(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11687,        421]
NotebookOptionsPosition[      8663,        317]
NotebookOutlinePosition[      9896,        353]
CellTagsIndexPosition[      9812,        348]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StartOfString" :> 
          Documentation`HelpLookup["paclet:ref/StartOfString"], "EndOfLine" :> 
          Documentation`HelpLookup["paclet:ref/EndOfLine"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StartOfString\"\>", 
       2->"\<\"EndOfLine\"\>", 
       3->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EndOfString", "ObjectName",
 CellID->5512],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["EndOfString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EndOfString"]], "InlineFormula"],
     " \[LineSeparator]represents the end of a string for purposes of \
matching in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17539]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->420808730],

Cell["Test whether a string ends with a \"t\":", "ExampleText",
 CellID->645002437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<abaababbat\>\"", ",", 
   RowBox[{"___", "~~", "\"\<t\>\"", "~~", "EndOfString"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1024638879],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1694693914]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31147],

Cell["Replace the last letter in a string:", "ExampleText",
 CellID->227790604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<ababbabbaaaCb\>\"", ",", " ", 
   RowBox[{
    RowBox[{"LetterCharacter", " ", "~~", "EndOfString"}], " ", "\[Rule]", 
    " ", "\"\<t\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1954063942],

Cell[BoxData["\<\"ababbabbaaaCt\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->450876812]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->241],

Cell["Remove the trailing spaces:", "ExampleText",
 CellID->1235924502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringReplace", "[", 
   RowBox[{"\"\<  Have a nice day.  \>\"", ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Whitespace", " ", "~~", " ", "EndOfString"}], ")"}], " ", 
     "\[Rule]", "  ", "\"\<\>\""}]}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1721271330],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<  Have a nice day.\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->1164893889]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12826],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StartOfString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StartOfString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndOfLine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EndOfLine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32506]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22069],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->12794038],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->407314018]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EndOfString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 20.8237434}", "context" -> "System`", 
    "keywords" -> {"\\0"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EndOfString represents the end of a string for purposes of matching in \
StringExpression.", "synonyms" -> {"end of string"}, "title" -> "EndOfString",
     "type" -> "Symbol", "uri" -> "ref/EndOfString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3472, 107, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9677, 341}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2149, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2772, 80, 48, 1, 70, "ObjectName",
 CellID->5512],
Cell[2823, 83, 612, 19, 70, "Usage",
 CellID->17539]
}, Open  ]],
Cell[CellGroupData[{
Cell[3472, 107, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3849, 121, 148, 5, 70, "ExampleSection",
 CellID->420808730],
Cell[4000, 128, 83, 1, 70, "ExampleText",
 CellID->645002437],
Cell[CellGroupData[{
Cell[4108, 133, 207, 6, 28, "Input",
 CellID->1024638879],
Cell[4318, 141, 162, 5, 36, "Output",
 CellID->1694693914]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4529, 152, 216, 7, 70, "ExampleSection",
 CellID->31147],
Cell[4748, 161, 79, 1, 70, "ExampleText",
 CellID->227790604],
Cell[CellGroupData[{
Cell[4852, 166, 266, 7, 70, "Input",
 CellID->1954063942],
Cell[5121, 175, 178, 5, 36, "Output",
 CellID->450876812]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[5348, 186, 221, 7, 70, "ExampleSection",
 CellID->241],
Cell[5572, 195, 71, 1, 70, "ExampleText",
 CellID->1235924502],
Cell[CellGroupData[{
Cell[5668, 200, 330, 9, 70, "Input",
 CellID->1721271330],
Cell[6001, 211, 316, 11, 50, "Output",
 CellID->1164893889]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6378, 229, 311, 9, 70, "SeeAlsoSection",
 CellID->12826],
Cell[6692, 240, 724, 26, 70, "SeeAlso",
 CellID->32506]
}, Open  ]],
Cell[CellGroupData[{
Cell[7453, 271, 314, 9, 70, "TutorialsSection",
 CellID->22069],
Cell[7770, 282, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[7912, 287, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[8127, 296, 318, 9, 70, "MoreAboutSection",
 CellID->12794038],
Cell[8448, 307, 141, 3, 70, "MoreAbout",
 CellID->407314018]
}, Open  ]],
Cell[8604, 313, 29, 0, 70, "History"],
Cell[8636, 315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

