(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    182132,       3743]
NotebookOptionsPosition[    174620,       3483]
NotebookOutlinePosition[    175982,       3522]
CellTagsIndexPosition[    175895,       3517]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives and Options" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsDirectivesAndOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graphics Directives and Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Prolog" :> Documentation`HelpLookup["paclet:ref/Prolog"], 
          "AxesStyle" :> Documentation`HelpLookup["paclet:ref/AxesStyle"], 
          "PlotStyle" :> Documentation`HelpLookup["paclet:ref/PlotStyle"], 
          "DisplayFunction" :> 
          Documentation`HelpLookup["paclet:ref/DisplayFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Prolog\"\>", 2->"\<\"AxesStyle\"\>",
        3->"\<\"PlotStyle\"\>", 
       4->"\<\"DisplayFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsOptionsAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Annotation & Appearance\"\>", 
       2->"\<\"Graphics Options & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Epilog", "ObjectName",
 CellID->5164],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Epilog",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions which gives a list \
of graphics primitives to be rendered after the main part of the graphics is \
rendered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In three\[Hyphen]dimensional graphics, two\[Hyphen]dimensional graphics \
primitives can be specified by the ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " option. The graphics primitives are rendered in a 0,1 coordinate system. "
}], "Notes",
 CellID->32495]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->367545923],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->56825010],

Cell["Draw the sample points on top of the plot:", "ExampleText",
 CellID->77499382],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"RandomReal", "[", "i", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225818802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"Point", "[", "data", "]"}]}], "}"}]}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45175040],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->689083117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7488895],

Cell["Place text at the right bottom corner of the 3D graphic:", "ExampleText",
 CellID->278338907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalPlot3D", "[", 
  RowBox[{"\[Phi]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"3", "Pi"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{"Framed", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Spiral\>\"", ",", "20"}], "]"}], ",", 
        RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Bottom"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Right", ",", "Bottom"}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185372961],

Cell[GraphicsData["CompressedBitmap", "\<\
eJysvAdYHEe6782RvXntzemcTWf33L3n3nMayTnb67D2OgzKyUqW1CAQEggJ
JIGEQCByzjnnDEPOOcchDgPDDDnnNMz0/7m3q2ZwGGOv9/suDzRd3dXVVb96
6623qt5qwUVzQ/3rF82NLl/843s3L94wNLp864/vmt7kLz32Lzo6Onn8n/jX
Ovz5/+HP6F8eAB0dS/74CtCvPnuZv/EvNHSX3H1MX1+fv0IuvMAf/uXTuxb8
XXrzMZrIHjFu8Tf28TEep+moo5Abz38h1g1NOt/+2lgmmrS+pxXrCf7wOB/8
H1+IbaxJ8wdasZ/kD/v44F++ENtIk/aT3yi2gSbtH3+j2Kwm7Z9pxX6MHj4L
kzI8rkmBnujs/jyuKaH6EfUPifUtPkgSoCefxv58Wp/l4qImz7/YIxePaZLe
p/lPwvs04cc/d333nfs09x/7XJ7Icff+Z2+9oCn7r/d4q3Zqe71NO95e1z97
21lNGf/1H5H+f/rWjzVl/N0/eOs/Irv7/9taZHW+8s2nNG/+g9abv6tVp1/1
pu9pxfti6sc1NP9dK/Vva6Tx8X+Q+jejd1RThv/QesuuzH9L83/f51LZpfj4
F1vKN3rfIU2p/vIV7eDx3eajvr5ne9Qu2Rfvkpx963Ncvvh+PU15/9fXtIjP
X//Tnql8qCnFf31FKrvv/o89n35fkwfdPZh/vm3v/fS7mncf0Hp6Vxvt0yrB
DzWp/Exz/4upvaPJyzNaqf1G89TP98zDm5o8PPe1PcYbmrRf/NpYr2rSevlr
Y72sSeu1r431giatNz7rRfmO8TnNs+/v9qagPzpPaoX/SGM/rUnjQ627P9IK
01avc0CTtp7W3R9rhX9PYzOatA99o9j/pUn7qNbdn2iFqebT+U9N2se/Uey/
aNI+pXX3p1rh39LYf9ak/bHW3Z9phf+Nxv53TdrnvlHs32vSvqB19+daYdqr
0PyQtC//g9i/obF/o0lb/xvF/pUmbUOtu7/QCtPeVOfTnlyTvJFWrF9qhX+1
51Mf7oY/z+QfpvLzzz1FDEAi2URp/m6v2NqpqZ9+/NN38reJTlFrUudj3eZv
FZ17MWiP1H69FxeamkZrfeHum7tpfjvYYt7l4pjVwV7Dd4XHXvjnUv48G+03
vP7pGzKCEe2q8rm9and52uxk67m3C/bt8Zbf7CUFX3rLY1qxXtl9y3cLU5AT
i4QAhLjA7e72PcMJfb0+Pd22/+/velwrFtGU1Pb4QXEOclORGo0IP/g4wsES
Ny+vnP9ogr938OV0nT3e+K9a4Z/t+cZvacV6brd0TzY3oLaSDCMKhchORXwk
gn3g6Qj7+7hxTcVfP6rXrfd0zR5v1pbZn+755m9rxaI9zk/4+13taGtGYz2q
q1BaTHKQnoKYCAT5wsMVD21hcoNcPPrhhN7LPXuV/Ju9/ztasQ7slvwn3V3o
bENrM+rrUFmJkhLkCskbo6MQGAQPLzywJ8Ez+qqjJzYO/m1srzz8VitMta7O
z7Ty8D2tWNQC+Bl/X9yPvh6IOtHehuYm1NaiogJFxRDmIiWNvDwoHB5+5MT0
LnfxuurkJ4qDB9eoxa/9Zu2c/XjPnHxfK9Z/7dL45dAg+Nz09qCrE21taGpC
TS3KylFYhJxcpGYiJonkwzOQHM2sOYPb3FmjnWOnN/jgnOkN/qhdH98sRz/Q
ikUttB/z90dHMDIEPlsDX5Gt7DykZiE2BaGx6jJ857YjZ/yAu3hLeeryFh+e
Ys3F52/o/IDce+w2w2osRfJybQ6/1wr/aM+8/lArFulNabv9iVwKqQQSMQb6
0NutndmCYprZbMTRSvWNhFMAaC3qfM/AmjtrsqPOmYBhTzDsOYZlGfYqn9/v
U93sxbDeDMsfPRiWPKMt0X/QCj/5ad5JbG1rh1r8v+RvzI5jahTjMpIjkvcB
9PeiRyvvFSTvWflI4fOeTmL6x8A9DHb+auKP8Tk+pgZLRwU/uMuw1gxry7D2
DOvIsM4M68awngzrw7D+DBvIR/02fS7809rQ1kzaNfFZaT5fE9ql+hM5/Iq/
Pz+Jmd2CyYdJjjUFE6GzA22tmoKVViK/BNkFSKVNPjIZQXFQ14C6JD/TZ9jr
DHuT5pMvkh0tjyutBHVhghg2hGH5gkQxbCzDxjNsIsMm8fH3pfCHx1IZNkVd
SM1Y72vr7Ik9S6lte1JLleiNpSksTGB2DFNyjEshH4J0kGR/oBe9InR1oL0V
zc2oq0dFFYrKICxCeh7fC9A6OrkrYkYMa8qw5gxrRTPqwLAutLJ0vkN71wRa
HL4Q6QybybA5DPtYLi+Befz/Pfr9P2qFf7hnifa0eEmJVqaxTAs1N4ZpOSak
GB3CiBhD/aRcfSKIaKFaeG3dgKoalFSQCqRJ63xHj2GPMOxphr1Ay2XMsGa7
pfhOMMOG7dZRgi6brMum6rI636Vtr/QAW6rLljHklw+X6LKF9ITYVn/aszw/
1SqPtt38b5pWp/OD9RmsTmF5EovjmBvFjAyTUowNQSbGcD/EPZr2/60OWqiG
BiKV5ZWaq4+rS8Qrg48ZltbaLx/QNuVM8+dLm1Iow0YybAwverpsIl+y/Wza
fjZjP5u9n809wOYfYIv44h1gK55iqw6w1QfU6Xyrdj9b/TRbtZ9VTy/SGnh8
dw6Olkcz/vuyXUPqaXsOm7NYn6aFm8DSOOZ3Czc+BLkY0n4M9qBfhJ4OUnN8
99rYoCkV0RaH1QqD1tsfeAE0YdhbDGvJsHz5HtEG5kWLGLRbbXG0XamlMIth
hQxbwLDFDKm48v1sJV+yp9jap9n6Z9jG59gm/vd5tvl5tuUFzTse4y/xxah/
mqV52B0ZaFtgP9izdrUpULv6p/x95TwUc9iawcY01iaxwoMYw7wcsyOYGsa4
BKNijPRD0oMBCqKr7TN9eZBWrZrIv5//XEO0oA3RdlfR8Bz8KApexURT/ZLM
sGm0KapruOAptuhptvQZtuJZtup5tvYFtv5FtvEltvlltvUVtu1Vtv01tuM1
/k2dr/MC3/WGRuPyxWl/lW17ma1/llz5hYaIdq/yzYj8clfef6Kcg2IWW9PY
mKJIxgmSBYpkehgTFImsH0M9EIvQS2VDZ59ArUt0nuDF/BOGvfRFFDZUJFyo
zuVFnm/JOk+S2D+qf41tep1tfYNtf5PtfIsVvc12v832vMP2/o3t43/fJeXi
T/hs9r6jIf1YyyusuhhUB5EiaNsAe5dYexT4810Z4BbAzZNi7Mxgexqbk1if
wOoYlkexKMOcFNNDmBzE2ABkfRjuwaBIoxn0aK3yDeEkbd682rrIsIa7uthy
V3M9GU3jJVPJz9Zlc/eTGi9+li17nq18ka1+ma17lW18jW1+gyV96r6BD1id
J8QfsoMfsZKPyJNDAkJAwl/5kBV/QK60vcE2vUrF4IcaBk98Iwbao9GffpGB
ag6qWUJCMYUtHsM41sawIseSDPNSzAxhahDjA5D3Qdqjtpe+y1f8UaoJeAyn
aN1fobqA3v03taLzJLWuH8TohzEGUYxBPHOFv5e+3zDrgFHuU0YFzxgVP2dU
9oJR5UtG1a8Y1r1m2PjXK81vXWl7x6DjXQPR3w16PjDo+9BgQGAwqKevsU5G
jrCyoxoFz5/wwZHDrPQQOyggF1v+ylJL/bM1hn/ERXuc/eMvcuEoF9UMlNOE
ztYENng0oxTNCBaGMSvBlBjj/ZD3qrl8m1cOvHio6ZyhDYJe/9NdxsCaMbBj
rjgxV9yZK96MYQBjGMIYRTLGccy1JOY6HynrgGnu06YFz5kWv2Ba9rJp5asm
1a9fr/3rtYa3jJveMW5992r73692fWDU85FRn56R+LCh5Ijh8DFD6fErshMG
8pP6oyfV7yLlGT/Njp/iW84Yf3hcfpwdOsx+Zq2RCNpzOmo+pEVp5hqxq22/
ZMuRXoRbxKeIOB7RNFRT2JkklDbHsC7HqgzLUiwOY06CaTEm+iHQ6EyiM3Qe
06OdI9Uh5PC/jBj9G8yV24zhfcboIWPkyFx1ZYy9mOv+jEkIYxrBmMUyNxN1
b6XuN+djC5+1yH/Bovjl22Wv3a58w6LmTYv6d8yb3jVv/bt5+we3Oj+6KdIz
6z10o/+IqfiYydDx69KT12SnjUc/vjp2xmj8rOHEuSuT5w2mLuhrLAX1LMH0
eXaK/z3Hjp9hh4+zkqMadUOKr91+1LSe0JKmfVphbXrUAiGDGXyRHjcDjgJU
TkAxvmtXrMmwwhMcwvwgZgZ27QoBhabuh+mV/6aaV/8KY3CdMTRnjKwYYxvG
5BFj6sKYeTI3/RjzYMYigrkTo3s34YBlytNWGc9a8Y/lv3Sv6NV7ZW/cr3zr
fs079+rfvdf0/r3WD63a9ay6Dln2HLHsO3ZXfOKO5OTt4dMWI2fM5Wdvjp03
m7hwY/ITk6mL16YvGc1cNpxlr8yzBnwB983rq3Pz7TmWnbnETn3Cjpxih06w
e8iQmh3pvzXrFGqzFrs/JJnfaT3z/d12yZPDAvAlcqpJqCawM4btUWzSEdHK
MJaGsDCIXZmjbeOnx6m+/oQxMGCu8MDMmOt3mBvWzE17xsKJue3O3PVhLAOZ
e6H770U+dT/uGeuk5x6kvWBDrc1fNAts2w7adB62ER190HvceuCU9eDH94fP
3h85f09+wXLs4t2Jy3em2NvT+uazBjfnrtyYNzRZMDJeMjLiC7J01UBn39JV
vh9fvqppinMG7AzLTl5khz8mV7Tn0j4nY1/ioz3G+i5VXiTWgoYP9uKjGody
FNtybI5gXaqZOVwUa8ZNAo1EPXGIaq9TjP4F5oo+Y2TEmJgwN80Zcyvmti1j
6cjcc2WsvXQfqHu57wpfc+T/lbztVP6uU/Xfneo+dGoUODUfcvwe7QPHWJtJ
gwfTV6xnje7PXbWaN767eO320nXzZZObKyamfAnWTK+umV5ZM9Xft2bKd5yr
poTFvBE7Z8jOGLAj5ygsbTZUHighzarNF9qdtvTQGayfa+jMa+hglw43BW6X
jmqMAFLIsDWCjWGsDWGFDsv27bL5vh5pefqnGIOzzNWLjKk+c8uYuW3G3L3D
3LNmrGkv9evAZxzCnnWMet4p/kWX5JdcM15xy3ndLf9Nd/5e2XselR941Ao8
Gg55NB9xbzvm3nnCXXTarfeM28A518ELLsMXnUcuO8n1ncYMHOlI+4fLN+6v
mFmt3by7fus2X6YN8xub5tc3za9uml/ZNNffNGfXb6nz9vicMTtrxMo+Ici0
e7bPiH15zvSzsLZcfdY6P4eN13MzvDIj6CbB7XJTjUIlx84ItqXYHMK6ZJcb
nQRRq61DzJVjjPEpxvQcc+sSc9uQuWvC3FP3jw66Dm66Tl4HXPyfcg15xi3i
OffYFzwTX/JKfdUr6w3v3Ld9Ct/15eNVfORbredbf9i36Zhv6wnfjlM+ojM+
Ped8+i94D17yHma9Rgy8Rg09x43cJ43dpq+7zpq4zN9wXrzptHzLYcXcnr7r
x5t37/FF3LK8vW15a9vyhsLyusLyqsLSYPuu/uYddsOCSuB1dtaYHdUn59ra
X83yhxrpe0zzX3v8TNl+m7LjyJGy48ntwzShR6WO+xw6lQzKESiGCT01MfWc
GG2Z+pSeyTHm5mnm9nnGUj02evEO43Bf18lO18VJ181D18P3gGfgU95hz/hE
Pe8b95Jf0qt+aX/1z347IO+9wKIPyPx91aGg2qPBjceDW04Ft38c1Hk2sPt8
YN/FgIHL/hJ9/+ErfjIjvzFj34nrPtOm3rNmXvM3PRfNPZZvu6/ccV2767xu
6bhh9Wjrnr2m4+QNRmtLxYPbOw9uKR/cUD64tmNtqLinv23FblkScAs32Nnr
7Ig+uzfBn2hJHyX4g09jqXUd5pWYU2GWMpwBgbcPU6QzpcLHE+R28alGoJRC
MYQtCdQC9xidDhIwxhSfxXHGkjLVvcLYXWccbzEulrpuNroej3S9XHV9vHT9
/A/4Bz8TEP58YMxLQQmvBae8GZL5Tqjw72EFH4aV6IXzT1Yfi6g/GdH0cUTr
2YiO8+Gii+G9l8L62VCxQciQYbD0apD8WtC4SeDkjYCZmwHzFv6Ld/yW7/qu
Wvms3fPauO+xae229cB128Z5x9ZRzZDm54c7dneVdhac/U3OzlT58Krigf62
Nbt9n928R0oxc2N3nPePGVKvg+9qFqmI1G1jdgezSsxwmObU4xeeHCbIL4E3
Bm4XnkoK5TB2JPicncaLnoC5LmBuqiXu6fOMPcs4XWVcTXXdLXQ9rXS9bXV9
HXX93XQDfQ6EBD4TGvpCWNQr4XGvRyS9FZH+t8js96PyPoouOhhTdiSGf772
VGzDmdiW87Htn8R2XYrp0Y/pvxI9aBQ9ZBw1cj1SbhoxZhYxeSt82iJs7nbo
wt2QJavg1ftB6w8CN2z8t2z9th/6KOy8duw9VI/c1Pw4x0ec40O1buac7sLJ
Ao43VA7GOw/1Fbbstg27aU3gTd1gvxm/P33aamc3MLuFGQVmdjCt4mWO45v0
JBVDYqNhjOfMix4nA0fRqYahHILi0/6CsLsiYEwEjLnadvvlEcb+FON4nnHR
Z9yv6nre0PW20PW7pxtgpxvsvD/U46lwv2cjg16MCn81OuaNmIS3Y1Pejcv8
IF4oSCg4lFByNLH8RCKdAfq3boPEPqNEsXGC5HqC1DRBfjN+3Dx+8nbc9J2Y
OcvohXtRS9aRKw8i1mzDN+zCNu1Dth4FbTsEKhz9lU6+KmdvNTi4usDVEW72
cLPV2JZwvQ0XM875utLhyj6FHV+CTZvdWV7teQM1vR9r0fvzpz3tzDpmNjG9
jWkFppSYUmFShQkO4xTgKCAncseT4yg51RCVOw25nwkYQwFjSsgRRWjLH48y
LqcZ908YL31dH2NdPzPdwLu6ITa64Y8ORLo+E+X1fIz/i3Ehr8ZrZtwbPklr
vpTWrp/WZZhG7ZDfzVsnLNrEL9vGrdnFbjyK2XKI3naK3HYO33YJVbiGKN2C
VO4BGjCenvB0g5czvBzhZQ8v8np43IHHLbibqFyMdhxYxSN24yH79VwIU8rj
h5THKqbXML2BqS1MbWNyh/JQYVyFMQ6j6pb5K1Ae3DC4ISgl2Bn81DQz+hwP
Oz3GiT85znid0fW5qOtvqBtkohtqoRtxb3/Uw6dj1LPEv4p6OzXu3bSkD9LS
BOlZhzJyj2UWncwsO5NVdT6bv914ObvVILvDKFtknN17PavfNHPQLGP4VsaI
Rfro3fQJq7Tp+2mzD1LVaf1m2yVe4Rq34x6z4xG14xmh9ApTeYdqcPn6wdcb
fh7wc4OfM/wd4PeQlNj7NrxvwcuU87iqdGYVTuyaHSWmPfLcW5KoHvs1CU8v
YmoZU6uYXMfkBia2MKHA+A7GlRhTYVQFOQcZhxEiWGpyKgmUn5HjJclEvVIj
YOz1GOdDjAcfOMkEnGOCWSbUmIkw041Wa7d/d3oh2f3lFJ/X0oL+mhH+Tmb0
e1nxH2Ql62VnHM7JOS7MP5VbfCa3/Hxe9UXiEdp0Ja/tal7ntbxu07w+szzx
rdwhi1zpHaHcMmfsXvakdda0Tebcw4wF+4xlh/Q1p/QNl7Rtt1T1TMYTKp9Y
lW+0yi9SQzEwGIEBZOk0yAtBHghyRZAjAu3ULfPb8L0FX1PO66rSTV/hwu4h
d9/7aop/JOHJBUwuYWIZE6sYX8P4Bsa2MKbAmBKjSshVkKkwooKUwzAFKYFq
EEox1NYHj5DivC9gHqkRHmKIOXaKCb3ARFB2/3nn2cT7zyc/fCnV6eV0z1ey
/N7IDn5HGPGeMObD3AS9vNTD+ZnHC4SnCgvPFpVeKKq4VFSjX8w/1ny1uP16
cdeN4p6bxf3mRYN3ioYtC2X3CsesCyZtCqYf5s/a5y045C45CVddctbdsjc9
shSemTveGUqfNKVvqso/eZ+6GQbFaUiGhCM0BKFBCPNHmC/CvBDmhlAnhNoj
2JqgCLjF+ZuqfK4qPfU3ndk9JHJvltQ6oWPQiRlMzGFiAeNLGF/G2CpG1zC6
AfkW5ArIdyBTYkQJqRLDKgypIOEe08gfqzZFPgV5kPE4yPgdYYLV8sdc2Z9w
7ekks2eT7zyf9uCFjEcvZru+IvR6I9f/7fyQ9woiPiyM1StKPFKcdrwk61RJ
7tnSwgulpZfKKvXLag3L+edbTMrbb5SLbpX3WpQP3C2TWJVJ75fKH5SOPyyd
si+ZcSiedypedClacS1ccy/Y8Mzb8s7d8REq/XKU/lnKwExVULoqOI0LSVFL
3U8JkYhoREQiMgyRIYgKRJQfIr0Q6Y4IZ0Q8QtgDwiPoJhdoovK7qvT65jTp
+tkTtDOdxPg0xmcxPoexBYwtYXQZ8lXI1iDbgGwLIwq+t5Xu6PwIwzsYUkKi
xKAKYg4DHGWpT4/31K2bJ6rH+B9mQtRlePoMk3DxQNKVp1KuP51u/kym1bM5
ts/nOryc7/p6gffbRQHvFYd+WBqpVxZ3pDzpeHnaqYqsMxW5FyoLL1WV6ldV
GVbXXSOOE61mNR3m1d23q/ssq8X3qiTWVVKbSvnDynH7iimH8hmn8nnXsiX3
0lXP0nWvkk2f4m2/ImVAgTIwXxWUqwoRqkKzVWFZXEQGF5n+OavvScREIzYC
sWGIDUasP2K8EO2OaGdEOyDShrAJvckFm6j8DUl87ZWqr+aqSX1sEmPTGJ3F
6DzkC5AvQbaMkVVI1yDdgHQLw9sYUkCi2IfBHZ23MKBEvwp93O4UkyXf0wgY
Zz3GU8AE6DFh/MVjTNwpJpE/ubw/3ehAlulTObefybv3fIHty4WOrxe7vVXi
/W5Z4AcVYXqVUUeq4o5XJ5+qTj9bk32hNu9SbZF+XZlRffW1+nrTBj6FNvOG
zjv13Zb1/ffrBx/UD9nWjdjVyh/VjDtWTzlXz7hWzbtXLnlWrnpXbPhWbPmX
KwLLVMGlqpBiVWiRKrxAFZGniszlonO4mGxNw49PQXySWtMjMQqJ4UgIJl4/
cV6Ic0OcM+IeIcZGs5qgCiEzrgtO7DfkSkfGv6W2ixyjxJUE8knIpyGfhWwe
sgWMLEG6jOFVDK9haANDm5BsY3AbYgUGFOjfQZ8SvapduDY8WQHjJWACaX5e
OsbEHmeSTjFpfIDdn3P1QN6Npwosniu691Kx7WulDm+Wuf2twvv9qkC9mrDD
tdHH6+JP1aecbci40JBzqTHfoKnYqKniWnO1aXP9zRYC905Ll1Vzz/3mfpvm
wYfNw/ZNMsemMafGCZeGabf6WY+6Ba/aZZ/aVb+ajYDqraCqnZAqLqySCy/n
Isu4qBIuuoiLKeTi8rn4PA3cxAwkpSE5GSmJaoJPICUCKSFIDkCiFxLckOCM
hEeIe4CYu/xtVYjRigft77X9GNV8f7QXX4ZiHYZsBDIZZJSybAoj0xiZxcg8
pAsYXsLQMiSrkKxhcB2DmxBvYWAb/dvoU6B3Bz1KytdKwDgKqOTqkKWaqKNM
7FEm+TiT/jGTTREXXD1QdOPZEosXS61eK7d9s9Lxb9Xu79f6CuqDDjdQ9wqd
P837NC/5Na0ENK4HNW6GNChC65XhdVxkLRdVzcVUcbEVXFwZl1DKJZKODMn5
pIwpOcTVJi0daalIT0J6PLmVHon0UKQFIsULyW5IdkaiPeKtEXuHi6S2yT/B
iI5NRiQYGcaIFFIZpKOa9i6dwfAshucxtADJEgaXMbgK8RoG1jGwif4t9G2j
R4FuhXq9j7erBYybgPHXIWPjqMNM3CEm5QiTeZLJOcPkk2o/UHL12bIbL1bc
frXq/l9r7N6pV9suvww/1RZzpj3hQnvKpY5M/U6hYWeBcVeJSVeFWVeNuYj0
Q1aidmuRyFbUaycacBBJnLqkLl1yt85xz84p745Z3w5qVf5MEdGkimrkYhq4
2HouvpZLqOGSqrnkSi6FdGZIKyZA0vORIURmNrIykZWGrGRkJagl8DvICkNm
INK8keqGVCck2yHxvqZ9TzizGmraPhh7s/0dOfxPEpb2QyrGsATDwxiWYkiG
oVEMjZNbQ9OQzEIyj8EFiJcwsIyBFfSvoW+d693kera47m1OtL3bHTkIGB/+
/CATeZCJFzCpB5nMY4zwFJN/liECo/90pfHz1TdfqdWspTt/2OJxsM33aHvQ
yY7wM10x50UJl0Qp+t0Zht05xj0FJj0lZr0VFr01d/sI4Qf9HbZ9Ivu+Xoe+
AadeiUuv1L1H7tkz7t095Sua9RctBHYtB3ethnVuhHdsRbar3/FbLqGJS2zk
kuu5lDourZZLrybFyqwgdLKKiDtNTh6EQgizIEyHMBk58RDGkjjCMOQEItMb
GW5Id0LqQyRZEgXqw34z2aV8v08h9hKfkCExhiSQDEMixaAMg3IMjmvGQOJZ
DMxhYAH9i+hbRt8KelfRs851b3CiTa5za1d/etCTSAGBm6LHZB5hhCeY/I+Z
4jO65WpJ/R9332y2/lur3fttToIO98Odvse7gk53h5/vibnYm8j2pRr2Zxr3
C00GCswGSszFFXfFtfcGCVzbwQ77QZHDYJ+zWOwqHnIfkHoOyL37x337pvx7
ZwJ750N6lsJ6ViO6N6JE2zGinbguLqETiRrKv+HSG7mMBi6rnhQ3p5qgEZYh
twR5RcjLR34u8rORn478ZOTFI4/MiyAvDMJA5HgjyxWZjkglhpUi0uAbagbq
S/hnEpZ0QdKNwV4M9mNQjEEJBochlmJAhgE5BsYwMEmi9c+ibw598+hdRM8S
upchWkXXGte5znVsUK6P6DFMwMTxdAVM5mFGeJzJP8GUnNCtUJfzf197pdns
r6133mm///eOhx91Oh0SuR/r8T3dF3SuP/yTgRhWnHhlMPXqYKaJRGg2VGg+
VHpnuNJquNZ6mDC2l3Y4DIuch/tch8Uew0NeQyM+Q6N+komAwakg8WyIeCFs
YCmifzWqbyOmdzuuV5nYwyV1I0WE1E6kdyCjTe3lhdw6Aie/CgUVKCxFYTGK
ClCUi6JsFGWgMAUF8SigiAtCkReAXC/k8Ijtdfayqb771XSJ4wLEHRB3QdwN
cS9xthSLMSDBwDD6peiXoU+O3jH0Tqj1K3pm0T0P0QJEi+haQucKOla5tjUB
c0fAuFO6UQImScBkHGSER5j8w0yJWnftP/NM/SfPN/Fnxq+3m73Vcfu9rvsf
dtsd7HU+1u9xasD37GDQBUn45aGYK8MJV6Wp16WZN0aEt0YK78hKrWSV1rJa
WzkB7CDvcJaLXOV9HjKxl2zIVzbiPzIaODIZLJ0Jk85FDC9GDS3HSNZiBzfj
B7cTxcrkAS61H+m9yOhBZjeyu5DTiVyNTNOxQFEtiqtRXImScpSWoLQQpXko
zUFpBkpSUBSH4mgCqSgEBf7I94TQSa2L54O+ShfvzZv6of6EimkL+tvQ34H+
LvR3EzfA/n70i9EvQd8QeqXolaFHju4xdE+ge0rN7xS65tA5j44FtC+hbRmt
KwLGmgIPpcoiTcAI9ZgCAVPKXzxyoPbkMw1nn2++9FIbH7z2psjs3Z47H/RZ
HxywPzrofFLicWbI9/xw0CVpuMFIjJEs4Zo85cZo5q1R4e3RAsuxkvtjFTbj
NXakf2hxHu9wHRd5jPd5jYt9x4b8x0YCR0dDRifCRmci5PNRssUY2UrcyHqC
dDNpWJEypEyTcBmDXKYYWf3I6UNuL/K6USCiENtR3KqeY0dpHcpqUF6F8nKU
l6C8EBV5qMhBRSbKU1Aaj1LKvTgYRb7IJ6KFDKu1KANt3fE1tMmaPvqa0NeC
3lb0tqO3i7jB9vaitx+9YvRK0DOEbim6RyCSQzSGrnF0TaJzWs38bbTNoXUB
LYtoXuKtr13xThYwWYJd1If21x5/uuHj55rPvdB24eUuIuDv9Jn9feCOYND6
sMTu+LDTaan7uRGfi7IgdjTccCzm2niC6XjKzYkMi4mcu5MF9yZLbKYq7KZq
HKYJbbfpDo9pkddUn++U2H9qKHByJHhiNGxiImJ8Omp8LmZsMW5sJXF0PUm+
mSJTpI2oMqRc1jCXPcQJB5ErRv4ACvtR1EtKXiJCaQcBVd6io2m9lbWoqkJV
OSqLUVWIqjxU5aAqE5UpqIhHOSVeGogiMp3KZVvvZenuzZv6+xMDEz116GlA
TxN6WtDdiu52dHeiW4TuXnT3o1uM7kGIhtAlRdcIOuXoHEXHODom0T6FtmmN
DdQ8j6YFHfqzK9y5mvG7QLf26FMNp55tPvlc+6kXRedfI2U1fk9840PJ7YPD
945KbU/KHM/I3S6Mel8aC7wyEWY8FW0yRQblOv8tDpwdCpkZCZuWh0+PR01N
xUzOxU0uJkysJE+sp45vpo8pMkdV2aNcjozLHeHypFzBEFcoQbGYFKysH+W9
qOhGZSehUdWK6mZyvaYOtdWoKUdNMWoKUJOL2hzUZKA6GVXxqIyiTP0IUKHt
durNvXk+uYf8qufXIaqDqAGiJoia0dWKrnbiC90lQlcPuvrQNYDOQXRK0DGM
jhG0y9A2irYxtI6jZRLNU2iaflxjGfNaOVPAFFKmNYf3Nxx5uvnIMx2Hn+s+
9XLv+TcG2L9J+Fs39EYsDsusjsttT4+pvaKfiDefS74zn2E1n2O9kG+7UGK/
WOG4WOOyyN9r9lps91kU+S/2Bi6oY/9yLnFmIXl6OWVqLX1qM3NSkT2pEk6o
csdU+aNcoZwrGuFKpFzpEClqhRiV/ajqQ3UP4VHbgbo21LXQcv8I9dWoL0dd
MeoKUJ+L+mzUpaM2CTVxqI6gUL25PPudTDIw+5IH795UP9sL3FmOzkq1RP0F
XQ3obEJnMzpb0dGGjg50dKGjGx19aB9AuxhtErQNoVWKVhla5GgeRdMYGsfR
MIn6KdRN79psqbwOpudVAt0GwYEWwVMdgme6j7zYd+q1gfNvSdj3pPxd00Oj
aovK8eKMGzvrbTgXYDwfaroQdWsx7vZisuVS+v2lbJvlfLvlYoeVcueVarcV
Qtpnpc1vpStwpTd4eSBsWRKxPBK1NBq7NBG/OJ24qLYM/7yVM6sQzqjyplUF
k6rCCVXxOFcyypXJuQoZKXTVEKoHUTOA2j5Cql6Ehk40tqOxBY2NJEJTNRrL
0VCMxnw05qIhCw2pqE9ELTU1KvxUhU4q4f2v503KRjn/jjzTXor2cnRUooMa
5R316GhEezNxmm5rQ1sHWrvQ2o22XrT2o1WMlkG0DKF5GE0jaJShQY76UdSN
oXYcNZMUbYzO7rx3uYCpFTDNgv3tgqdEh57tO/HSwNnXJZ+8I1X37n80PzFl
eWbG5sLso8vzrgYLXlcX/a8vhZgtR1qsxN5dSbq3mvZgNevhWu6jtSKntTLX
9SqPdf6xJr/1toD1ruD1ntC1gYg1SdSaNGZ1NH51InFlOnllLm15MWNpJWtx
PWdRbUOoima5kmmudIorn+Qqx7kqOsCvGUHtMOokaBATSE29aOpGcyea29DS
gpZGjZ5rKUdzEZrz0SxEUyYaU9AQrxnrcWUeqjybr2b9HY2G+NZeMv4XEm4t
Qlsp2srRVok2ir+tHm2NZG9RK58HPicdNEsiNPeiuQ9NA2gSo5HP8xDq+cyP
oE6GWjlqRkELJWCi6bGEyDfTIGDaBPtFgqd6jz4/cPoVibotfUI3hV0/PnPz
9Ozdc/PWFxfs2UVnwyWPa8u+pqtBt9Yi7qzHWK0nWm+k2m5k2m/mOm4WumyV
um9VeZMhUFPAVmvQVmfoVk/4Zn/U5mDMxnDchjxhfTx5fSp1bS59bTFrdSVn
ZS13eTN/SVG4tFO0oBkDVs5w1aQdom6ciEyDDI1SNA0Rai0DaO0jUtbaidY2
sr2Lh9BeR4GUE0qt+WjNQUs6mpLIxdoQVPkqC+321tTU7+az/Yo6X/bUob5h
xLkKzXloLqA1XIKWMrRUoqWacvo3XgTIVojmFjS1oYlvgnxDFKGxB419aOhH
vRh1g6iVoHYINVJUj6BKhkq52gChxzJehxPh1+0U7O899MyAWmr+68g7Y6fe
nzgvmNI/MsOHzc4s3D6/eO/S0kODFUejVbfraz5m64EWm2F3t6LvbyXYbKfY
bWc6KITOigI3RannTqUP2fPTGLTTGqLoDFd0Ryr6orfFcdvDCVuypK2xlM2p
9I3ZzI2F7PXl3PW1/LXNwlVF8cpOybKybElVschVzmtGi2iYQuMEUZPNcrSM
EIi8EuVVaXsf0aztHVTR8hqXV720JjrK0FGE9jy0ZaE1lVypJ3OzqlLnL41n
vvPP1MPvSbgxh6izxgI0FqKR125laKpAUxWaaqnWa0RjE1GCDW1oaCc6kdeM
9d2o6+UVJWr6USMmerNKgsphVEhRPoIymYAJp8SfETD1At02ga5IsH+AD+u9
MqL35uiRdydOfTB1/uAse2yeqPyzyxafrFixa7aG6w7XNtxubHrf2g64sx1q
pYiy3ol/qEx+pMxwUua4qgo8VCXeKl7T8k81BKtawlQdESpRtLIvVilO2BlO
2pGlKMbSFJMZ2zPZW/PCreW8zbWCzc3ije2SdUXZ2k7FirJqWVW9xNUuqmvi
12ieJpYAbw+0jRKGHVJiLXSKqfHQTXblEKOimdoYFEdXKboK0SmkKiQJDWQx
j6tw+/9VC9Q/tD4L9Tlo4PuVfNQXor4Y9aWki6+vQkONWn5/jPom1DejrhV1
7cQgqO1CjYi3D1DVSwyFygFiNJQPokyC0mGUSGkZnxcwTQLdDoEu2ZApeEGq
95pc762JY+9NffzRzCeH5y+dWOKvm5xfu3Vp3dJg0+bq1iMThYuZwstix/+u
MuS+MtJGFWunSnLg0py5bDcuz5Mr9uHK/clCTH0omsPRHgVRLHrjOXESN5Si
kqWpxjKUk9nKGeHOfJ5iqUCxWrS9UbK9Vba1XbGhqFrfqVlT1q6q6pepeC3w
5qzGluNt3I4JwrBLBpEUIgkxiHv6yAa37g5iLhO7uR49ZH0G3SUQ5dNONBXN
MagP1vny2P6b1gL1NaSj/dpU1PJ2VBbqclCXi7p81Baitgi1JagtI5tueWO2
tpbm933UNKOmBdVtqO5AVScqu1AhQnkPMYTL+lDajxIxigdRJEHhkIDJ4TsG
UgO6ZBQkeGZI8JJc8Mb44XemTr4/c1pv/szRpQsnVwzOkl7WjN26Y7htfU1h
Z7rjdGvH47bS10oVZK0Kt+WiH3EJTlyKK5fpwQm9uUI/MiLhH6kLQ1Mk2mLQ
GYeeRAwkQ5KGkQyMZWFSyM3kqeYLVEtFytWSnY2yna0KhaJqe6dmS1m3qarf
4BrJS9HCD5sX0b6Ajjm1vP2CkOweRQ8/4paS8WCfGH196OtGXwd6W+jgkaqn
3jL0FFHDMR3tiWggfgLzWbe+NDr6qvrQ9kmkrYL6tlYnoToV1emoyURNDhk+
1OShugDVRaguQVUZqivIXuTqGlTXaSzjymZUtqKiDeUdKOtEaRcZ6pV0o7gX
RX1k/FfADwQHaTehsXF/JNAVC56VCl4e1Xtz8tC7M0c+nD96aOnE8dVzp9cv
n9skKkpfYWG0Y3VdaXNDSTOm85eOBHQnoT8Fg+mQZkKeg4lcTOdjrgiLJdxq
GbdeodqsUipqdnbqFMqGbVXjNtUZG2hbQ/sKOpbQtQDRPLpnCaDeSfSOok+G
/mEy1TFAd6UOiDDQgYEWDDRioFbjF9CTD1EmOpLQEon6gKlMs70p71pAj2v+
U8uHrmVXJqAyCZWpqEono9uqbFQJyWC3sgCVRWTsW1GKCn4QXIXKGlTUoqJ+
n7rXKmtBaStK2lDSgeJOFHWhUISCbuT3Iq8Puf2UaYWAaSUn+yWC52SCV8cF
b03rvTd/8KOlQ4dXT5xYP/Px5sXz22ofkx/bWXBOdzmP+5yvDYLtEeGIWBck
uiPNC1m+ZOauOISIRzVf0Bg0x0G9FjGcDZkQ4/mYLsRcMRZLsVKB9Spus5rb
rlXt1CtVjUqueYdaMFvo2EDnGrpWyIRnzyJ653fXYn+CgVEMjEA8jMFBDA7Q
GdQuDLZjsBmDDRBTo7CvAN3Z6EpBWzQaA79Cw2jvCqD65BckXBaNsliUx6M8
iUzcVKSTGZyKbFQIyYROeQGZ2SkvRlkp2XJcVomyapTVktmf0gZ1D/VzFLai
sA0F7cjvRF4XckUQdiOnF9l9dJalScD0UsUuF7w2IXh7VvD+op7eyuGjaydP
bqjrTZ8l62OmxipzU5XVTc7mNvfIknO1hrctAh8RN4koV8R7IMUbmX5kRrqQ
Qq+MQl0smuJJL9eZgp50DGSqm63OX2ZLsVCO5UqsVXMbtdxWPbfTyKmaqZ9X
mxIdCnRuQbSJ7nX0rJIJ/f5Fgkw8i0FqhZKp/xFI6E7xIbq/bKgTQ20YaoKE
KpSBYvTkQJSGjjg0h+h8eZ7lq7lr+pLSaJTEoiQOJYkoTUZpGsoyUZaNMiHK
clGaT6cyi8kHBErKyMbUkioU15DpzqI6FDagYHcMkteK3DYI25HTgexOZImQ
2a1ZixLoUvAvjgpenxK8Myf4YEnv4Kr63h/OnN2+8IniMiV/7RpndoO7c4u7
fwd2VnB+AI+H8HNAsDMi3BDriSQfpPkjO4hgL45ARTQZxTckoCUZHakQZaAv
C4NCSPMgL8REsWYH7Z9Xa7n1Om6zgVM0ccoWCr9DhU4lRAp0b6N3E30bZKlq
YJlwG5wnC1lDlP+wnCxzSYfIqpe0D1IRpB0YJqvIkKilPhfd6ehM4FrCdP4p
+jr/SsJF5CkUR6MohswRFyWgKAnFqSjOQEkWSnJQnIviPBQXoLgIRSVkt3NR
OQorUVCF/Brk1yKvDrkNEDbSkj6OrDZktiOjA+mdakteoNsteIosKgj+OiP4
24LgQ2JMHD62cfzU5ulz2+cuKi7qK1kjYiea3ODMzWF1Bzb34PAAbnbwcUCg
C8LcEe2FeF+kBCAzmKAvikRZDKrjyZi+iW/waejKRG82BnIxlA9ZEcZLMV2O
+Sos1Wj25vz7VhOnoOi5Dg6dHEQcupVkTbpvGwNbEG9gcJVwG1okq7TSWYxM
ETQjcrKSK5NANgBZL0a6MNJGK6YWEroQ2psJUaKqJfSb0//Vp/Z8fgAKglFA
66AwCgUxKIilSyKJKEhBYRoKM1GYjUIhCnNRkI+CQvLBgPxS5Jchrxy5lRBW
QViNnFpk1yGrHpmNyGyi81eMgOkUHBALXqIj3vfIJJfg8MbB41tHTm+fOKf4
+NLOeQPlpauE+zUzmFngzl1Y34edDZztyAdK/FwQ7I4Ib8T6ITkQGVTTFEaj
NJb0SrVJaExFKy94WegRYiAPkkKMFGOsDFMVmKvGYi1W6rHeqGkBv+c6OY4Q
59DLEUeWgR3ieiHZgmSd4BpehnSROBHIZiCn3OVy4mswOojRfsi7yRVZM6R1
GKog5/3Z6E7eaQ3dw5L89lczp3slcv2QG4C8YOSFqiXjX5EXg7xYstqXm4C8
ZOSlIj8D+VnIy0GeEHl5yC1AbhGExRCWIqcM2eXIqkBmFTKrkVGD9Dqk1SO1
ASlNSG6mevcjfjAreGlU8CYZvAoEq4IjG4ITikMf7xy7oDx1WXX2CnfBmMii
oRlMLGB+F5b3YWMDBzvi9evtggB3hHoTf674QKSGEvT50SiOQ0UCapLRkIYW
3q7gGeSiPx+SIoyUYqwck1WYrcFCHZYbsNaMzVbyoLKTHLkejiPkOQyoiIOW
REm8i4a3CLeRFciWiBPS6BxGpzFG1yDHZRgfxpgYY3QOXt6KkXpIq6jKF6I3
VdEaqu1L9jXkyWYkZHsjxxc5ARAGQRiK3HA1/99DGAthHHISkJMEYQpd3M6E
MBs5OeTjKDn5ZOk7qwhZxcgsQUYZ0suRVoHUSqRWI6UGyXVIqkci8Vvi4ptU
cc3KGDqf8KJMvQdPcHBNcHRTcFIhOMMdvsAdu8ydvMJ9bIwLJoSMkQVM78Li
Pu7Z4KEdnBzh4QJfdwR5I8IfccFIDiPRhNEojENpIqpSUJ+O5iy0891eHvoK
MVgMaRlGKzBZjZlazNdjqRGrLdhoo7t2u6DshkbSBjgMcpCoiKecVIkRBaEn
W4N8BaNLxMGOeNpNYYJMPpGvNExIaF10Y6wdsgaMVGO4FIN5qt7UhRrPf4I/
cbNGhjsyqbmWRbuw7BDkhCMnUl0L/xPZcchKQFYi8eLITkNWBrKykJWNTCEy
c5GRj/QCpBchrRipJUgpRXIZkiqQWInEaiTUIJ4MulUx9croBmVUw05ko+DZ
Aap65sjx2Kbg1I7grErwCXeI5Y4acieNccZEPZTT+VVWNPLiUJyIihQyqGvK
QpsQXfnoLYS4BMPlkFdhogbTdZhrwGIzVqhkb3ViWwRFD3b6oNzdg/lr4tMp
VREXT9kOYTO6ibE1jC1jfBET85icweQUpujk5tQwxdyD8U6MNkFWw9cjqbGe
ZJ0ve0qq6f5wr55Ul4TTXJHG28OeSPdBhh8yApEZgswwZEYgk66dZMYhIx4Z
ichIQkYqMtKRkYn0LKTlIE2I1Fyk5CO5AMmFSCpGYgkSShFfhrhyxFYiljQ8
VVSNMrJ2J6JWEVa3HUr8FwTvTgkEZFJAcEohOKsUXODU/stnzAgfg7u4dg83
bWBpBxsHOLjAzR0+3gjyQ3gQYkM1Xyz5Ez9mq89CixCd+fzgEAOlvJKFrArj
tZhqwGwTFluwQmV5qwvb3djphbIfKjE4CXHopr2kirjVjioxRplPbBBP5sll
TC1iag7T05ie0Pj+TQ1isg8TXRhvgbwWI6QP3eomXov/DHHqtZ/siBQXpLgh
xYP4bqX6Ii0AaUHEmys9HOmR9I3PIy0eaQlIS0JqClLTkJqOlEwkZyEpG0lC
JOYiIR8JBYgvRFwRYosRU4roMkSRjKkiKpXhVTuh1YqQ6q2gmo3AGsHfRgWC
WcGxVQL9LPVmu4yDV3DkKo5fx0n6Ta0Lt6FviWvWuGmLu49g6wQnN/LBKz9f
hAQiiqrz1GjS3vKTUJKq3pv+h3Z++FKM/jJIKkg7H63DZANmmrFAya91YbMb
il7s9BNZVw0S8sShfoTyH1URd/txJYE3uYWpDUyvYnoJMwuYmcWMZu39e5iW
YKoPkyJMtGKsHrJK/uq6KP6b06fa5EcknPCQ+MklOiLJGUmuSHJHIrWPk6m9
kBKClDDqhBilfvcLSElAciKSk7mkFC4xjUtM5xIyuPgsLj6bixNysblcTB5i
ChBdiKgiRBInLC68VBVapgwpVwSXbwdWbAVUbvhVrvlWCT6UCY4tCD4mcyGC
i5yA5QT6nJ4hDhnjiAmOUeE/fxf692D8ALfsYOWIhy5w9oCXDwICEEZtyMQo
pMdBmIjCVJRnoCabTK2qrZW/iCsxXAN5HcYbMd2C+XZaBSJs9kDR90X+UrrH
SE5rYZzDhIoQnFZgepPsspldwewS5uYwR635WTk5TvdjqhuTbRhvwChp2Ktd
sdo7Br6GPvW9iHuAOFvE2yPegfp28uNCdzI0jPdCgi8SA5AYhMRQJIYhMQKJ
Ubuz2QmJXHwyF5fCxaZyMWlcTAYXnclFZXNROVykkIvIQ3g+wgoI+pAiZXDx
TlCJIqBk279007ds3ads1at82ZO0C8GZJXWt/pawN+AEV6B3FXrXcNCUgDh1
G+ctYWCN67aweIT7zrB3h6sXfPwQRIdOcZFIiUUmb22loDgdldlkBq+lEB0l
6ClX95X/wXd3482Yopp+sQur3djoxXY/2fagknwBPdnnNU4rYIojBGd2MLuN
uQ3MrWF+GfNkAR7zk5gfJSczA5juxlQ7JhpVciL/Sx3RX01/n45mfzPdNxVt
hWhrxNgi1g6xDohzQpwLYvmRoQdivRDrgzhqscUHIz4UceHgyxkXjbhYdQvg
YhK56CQuKpmLTOEi0riIdC48kwvL4sKyuVAhQnKJxgnMVwYU7PgXbPsVbvkW
bXgXr3kWr3iULLmVLLqWzjuXUo2zJrhMHRmvcAJD6BlDzwQHqdSfvoNP7sHQ
BjfscMcRD1zh4Al3X/gGkLvRvCjEEH2Yk4yCNJRmoVqIhgK0FUNUjv4qSGo1
LeAPs51YEGGlB+t92Boge51UQ2QfHdkTpiY+Rjd40o9KEHCzSswpML+FhXUs
kIVeLMxhYQoLtKedFWOmB9Md3GTTjqxcZ69vIH21xGv2kERaIfI+omwQbYfo
R4hxpM74rtQr3xPR3oj2RUwAYoIQE4KYMPCljY5CdDSiYmmZfsGFJ3FhyVxo
CheSygWnc8EZXFAmF0g8jlX+wh0/ocInd9s7b9Mrf90jf829YMW1cMmlcMGp
aM6xaOZRsWa+QGBIXfCuKHmhF1D0fPDwTZzaRW/Ko3eCjTucvMmtwBBEhCM2
GslxpOfPTUNxJiqFxBugpRhd5eirwmAdpI0YbdHYML/n0S/3Yq0fW2Ky845s
wRuhwv457mSP8gz5zCjmOSwosbCNxQ0srhF2i/NYnCafxlqg6+WzvZjp5NFv
j5SS9LX3Wn7rq3XNb4gqCCUb2xBmifD7iHiAiIeIfIRIR0Q6I9IVkW6I9CD7
TiJ8EOmPyEBEBiMyFBFhiIhAeCTCoxEWg7A49YzUz7nAZC4glfNP4/wz+LDS
J3PHO2vbK3vLM2fDXbjuJlx1yV12zl10zJt3yJu1z5+2K5i0LRh/UDBqXUi6
fZ1n7jrjoQdB6xOEkFBSyYlxxJ1bmIaiTJQLUVuA5mJ0lKOnCuI6DDeSyBPt
mOkiJ8t9WBvA5iDZi6yS7o2Vm4XGvWtRhUUFlsiiLpaWsTSPJZ7sBBYp2bk+
jpBt3JSWkKxp76T+GrIkzAWZccG3du3WECuEWiPMFuH2CHdAuBPCXRDuhnAP
uk3Km+6X4nuvINKBhYYiNIzspgqORHAUgmK4wFguII4LiKey/jvOJ4XA9UpT
eKZvu2dsumWuu2auOWetOGUtOWTP22fP2uVM2+ZMPsgZtxaO3hPKLHOld3OH
bucNWpBNBYJLOwJ9Mjdw8BqOmuGEBS5YEdlW1+FP/IMRHoH4WKQmIicNBZlk
sq6mAE3FxEtCVIX+OkJa1oLxdkyLML/7PbbfbkrIJnqlWot8iTk3TwV6kSrz
ZSU9bmB5BcsLWJ7BEo+d9qDz/Wrs69Kir6Su/TUFqsWJwcv5m3ABN7jAmwjU
7P39DYLuIfgBQh4i5BFCHBHijBBXhLgjxBMh3gjx4UL8uOAALigQQcHgW3RA
KALC4R8B/yj4RXO+MZxPHOcdr/JKUBP63ZZryoZz6rpT2qpj+vKj9AW79Dnb
jBmbjCnrjIl7GaOWmbK7mdLbWUPmWYO3sgbMsvtMiRoSnF4QnCea/aARjpni
lAU+scJVW5g7EiKO3hqKDC/yyQnITEF+JkqFZJWloRit5eiqQh8lP9JCRoxT
XZjrxVI/VumGy20plDJKfVybOrdAwS8By3R2ckWBlU2srGJlEcuz5Dt7S3Is
kuGSaqZDNdmwOlzw1fK+J3kyA8D5XON8TTi/G5z/Tfjdgp+FjsaLIOA+AmwQ
aEemuQMdEeiMQFcEuiPQkwv05gJ8VP6+Kn9/lV+AyjdI5Rus8glVeYepvCNU
XpEqzyiVR7TSg7j27LjGK1zit5wT1D5cv5l7kDpjnTp1L23CMm30TprsdrrU
PH3oZrr4Rnq/SUbv9Yxu44wuI6KGBCeI4jyoj6PG3Klb3KV7MHlImD10h5sv
AoJ35Tc9mUxPFOegMh/1JcTvpbOaxBtsgrQVox3EtuaZLw5gRUI+UkIy9amk
fxE4L+aE3DI0O3ZWFVjdxOoaVpewMouVSfKtsyXCXDndxjNfHsr/J5mTUT/n
acR5GXPe1zkfU/iYwecWfCzgc1vTm8H3Afwews+eTHP7OZFpPz83zs+d8/Xk
fL1UPj5Kb1+ll5/Sy1/pGaj0CFJ6hCjdQ5Vu4Uq3iB1XsqSucI7edozZdIjd
eBS3Zh+/Yhe/bJuwaJM4b51ItxDqPNmun9Z6mWydEpzcPHhRdeyK6vRNjrUi
bO45w9EL3oEIDSf77Wie/rMgC2V5ZCm3uZzE6akHoduG0U5MdmO2DwuU7roU
W/RjQiq1OE9TtHMatLwsazT4KpXotR2sbWJtDWtLWJ0j31dc4ekS9z3FdKti
vHZ2IFv7qyyfkf30a1tk/V/lZsC5G3IeVznPa5ynCbxuwOsmvMzhdRted9Vc
/ze8beD9EN728HaAtxPn7cJ5uXJe7ipPD5Wnl9LDe8fdR+Hmq3D1V7gGKFyC
FM7BCucQhROZCt52iNh8FLlhF7n2MGrVNnrZJmbROmbhfuycVeyMZdzUnfiJ
2/Fj5gnyWwkjZonDpokSk0TxtaS+q0k9hkldBkkdbBLVQT8UHN04eHbn+BXV
xzcJplu2sHGBKz8ECkEU32fGIyNFTfwv1UXEX07NWtz8GeuZPsyLsTyEtRFs
yqEYo1OJ01SMPwcaK1SSV4E1DmtUba9vYZ2yXpvjPsd6e6plVU5mcL+a9Zek
mAiRyplVuehzrlc4NyPOzZhzvw4PU3iY0W3/FnC/A3dLNfn/hoctPOzg8Yjz
cODcnTh3Z5Wbq8rNTeXqoXTx3HH2Ujh7bzv5bjv6bTv4bzsEbj8i317ZsgvZ
eBi6bhu2+iB8xTpi6X7EglXknGXkzJ2o6dvRk+bR47diRs1iZDdipSaxQ9di
B43j+o3ieq/EdevHdV6Oa78Y13IhrulcfMOZ+NrT8ervhhw8pzxuSDpRY0vc
sYOdKzz9EBKG+Dik8Wokg6yt0Jh/bquGqB4DzRhuh7yLzEjxY8Q5MflG1uoI
NkahmIByisKn2uNT7Dpq43sNWOewTslv8OTXsb7Mrc+rVic58jU8Mom4Odk0
zxsp2t9q+hru7xPd5cAq1b+O+ionQ875Kud6Da4mcL0B15twNSdfpXC9C1fi
Uw63B3C15VztOBd7zsVB5eyocnZWObmonNyUju47Dh6KR17b9t5bdj5bdr5b
D8nWtg2bwPUHQavWwSv3g5etQhYtQ+fvhM7eDps2D5u8FT5uFj5qGi4ziZBe
ixi6GjloFDlwJbJPP6qHjeq6FNXxSXTb+ejms9GNH0fXn4quORFNVMxrxDVV
cI6sKV++CdN7sLKHkzv8+YFBFFKTKHahZpTzp8+gizDeg6l+zA6Sz+KtyAj0
7QnyaUGOfnuRfJyK9I70fI2K+zqFvqHEBl3A3ljnNpZVa7M7KxOqZZka+sp4
vc6Xv4/1NcxJePshSz/vsWPP6nxf+chA6WCocryqcrrOOZlyTmac0y3OyYJz
vsM5W9JS/BfnZMs5PlQ52KscHqkeOaoeOSntXZT2rjt27oqHHtu2nls2XpsP
iCv8+n3f1Xt+K1b+y5YBi3cC528HzpoHTt8KmjQLGjcNGr0eLLsWLL0aPGQY
MnglZEA/tO9yaM+lUNEnYZ3nw9rPhbecCW86Hd5wMrz2eHj10fCKw+SjO4JX
pZpe/IIJrt2BpS0c+U7ED1HhSI0n5iF/r7IQ9WVoqyLnhHgHRrsx0Uc+Pjgn
waKUEF8fI5+33JkmqoVgWdT0uU9SxUKRbwAbKoJ88/9Wdh1wUV3pfnYGzSab
ze7b8vbll+x7W95udt8Lg73GXmMEe+96BobemxRhhYhRElFJzMummGqMGjVi
ARRBig0UpIP0MjMM0++9Uzi/3zvfuffCcIFs4u8yzm1nzvc/3/fd75T7/e1g
C4zVZTU4LBq7qdNpbHH1NwyunnBD22NstMFNMsmIPYC4FKSwpyLZ845UlSPV
13nQ35kW6EoLdqWFutLCXWmRrrRoV1qsKy3elcbnxNrgSE1xpP7DkXLQnpJu
P/Cm/UAGl3yYTXqLSTxiS4C33yzxb5vi3jHGHuuPydJHHddFHteEn+gJO9kV
crIj+GRbYHaLf3azX3ajb3Y9erdm77tPdr9bueu9RzveK9/23oOtp+5tPlW6
8VTx+lNF694vWH3qps+p3JWnvJUwy+G9CjrYAZE4LhmnH4IEHx++DwMq5OD1
i/A+RCnBuhBXlcARwPoJ7q7Fmgbc1wypMc3t2NaFuR7s5EMRPtw2YR5notcA
HoMx48KME7MAtYuxOKz9nKWXNbXbDc2cnufF+uFY82uBbYmISURsEpLJuWQk
+4U9GdmTVWRzHPBzpPg7UwOdqcHO1FBnargzNdKZGu1MjXWkxDlS9tsPJPCR
9Tw28R9MQhqTkM7sP2SLz7DGHQZDizlijD7aH5Wpj8zUhb+tDXunN+Sd7uBj
nYHH2gOyWtXHn/odb1Idb9h3vG7PiZrdJ57sPFG5/WTFtpMPt5y8v+nk3Q3Z
Jeuy76zJLlyVfcs7O++Nk9dfP5mzFDyUz+KeNVshJI+Jw+lp+Fgm/iddxXXx
K5icJVFgWT4uL4RXRerpUFUHwboOaxohN6uxDVK1Mt2QwNZJn5cUNcgHTUBi
KM6sC7POAQqyw2bmrH2suYcxtnHkcSmXjcz6zyP8nAThF8UI2xQLb3Vb45Ft
P6SnYhMB6USk4BJVshfsSX72ZH9HcpAjOcSRHOZIjnAkR9qTormkGC4xjk2I
ZxL22/Yn2OKTqIbPtsT+wxKTZo5OJzuGyEP9ERn68MO6sLe0IUd6g490Bx7t
DDjaoc5s88tsUb3djN5u3PtO/Z53ancdq95xrGr7scdbj5VvPvZgY9a99Vml
a7OKV2cV+WQVrMzKX5GVu/zYtSXHriwCn+Qzs2nNasOePbB4Ky0FZx0FFM98
jC99Ca8I3r6Cy/JwRRGuLsMND2H6nZztqcfaJqxvgQDZ0oWZHsxpMFUwQJau
RiPO2UY3lmwwKjjAOpwstKPdZmKtOpu5y2pstfbD6jIp1wOPMax0Axw8sNu7
ANCtMEQJaZesccgWhzwgm9qv2HgVx2/71faEAHtCkD0hhNsfyu0PZ+Mj2Pgo
Ji6aiYu1xcZZY+It0fvNUYnmKD4j4Z/6ww7qQ9N0IenaoDd7Aw91BxzqUmd0
+GW0qQ63oLee7n2rac+Rhl1H6nYerdl+9MnWo5Wbj1Zsyny4IfP+usyyNZkl
qzKLvDNvv5F56/XMvGWZ15cczVl49PJ8+hLj5KpVy3p2bTZEBPDvlf/yo2x8
9iMY9b7hju1d3FiOWytxRw3AqGuGFMumTkg0TREd5zLgASP4B/qgg/xaDOR4
I9hyAy4OZh0cLIyQsDajzaK1mDothhZjX+2Y2I4X++JY/CcTrwVI9OGoPxwZ
wpHgNWIQEwubTE4+FGysSvZvbKwvG6fm4gLY2CA2NpiJCWViwmzREbboSGtU
tCUqxhwZa4qIM4bvN4YlGEIT+0OT+IyYL3eo0tr2pbXsTW/end646836HW/W
bnuzeuuhqs2HHm88VLEh4+G6jPtrDt9dfbjU5/CdlYcLVxwuWH44f+nhG4sP
X11w+Mq8jEtzMrw9s70n3/Ge27JjjTbCl1+99fzHJ/A3H8Eaghvn8O3vcFku
riiElZdNFbitCpLsirYP6824Puzox04jdpnwAPW6AAcgigc47OIGnJzDznJ8
H8Zm67dYNCZTh4n2B0fk0PyXqILeaoNRXwjSky0U9Yfy2I6zRiJrFLIJm4og
HKUif76y3zJRalukvy0y0BoRZI0IsYSHWsLDzWER5rAoU2i0MSTGEBzbHxyv
D4LQT+ufqFEn9foldfsmd6kOdOxLoZNEsvFFy9MLlqXfXJKetyj9+oL0nLnp
vB5CcoMpV71n1+xZBcs9MmLs7x6EMOrCRzjnS5x3Dhe6Adj8iOohv8rOosGM
DnN67DBipwm7LHiAGDtD4eOxs2MHN2BnHRzLsoyN3Gi16s3mHqOR5mL40diB
Rvb4I00A0gUieV8QkuuDBM20hCFLOGwyhTVcJbeG+8r+bAnzNYeSTW0K8TeF
BBqDg4zBIYagUENQeH9ghD4gqs8/WqeOIbdrfON6VPHdKL5r3/6OvQltuxNb
dyU+3ZHUtD2pYWtS3ebkmo3JTzYkV647ULHmwMNVB+77HLi7MqV0RUrx8pSi
Zan8GMcLF2enXJiZ4q3M9J56ft3scnIoCRmPRlreT2W/ygIpcr/Gt7+FYX6q
ey8RG++mw0HgyjqxqQdbtJjRY86AHSbsNGOXFQ9QxwnPfQ47CZx2bOcGONbO
EDwZWLBjtvYZzbBOpK378Yi8pDyi4mpW6Qrul0RMu31Rrx/SqJFC549k4/r8
UZ+YfNcUTGzdHIwU5mCV7H9NwSpTkMoYqDIEqPoDfPv91Xp/f706sE8d1OcX
ovML1fqGa1QR0Ez7orr3RnfuienYFdO2M7Z1R9zTbXFNW+MbNsfXb9pfu2F/
9fqEqrUJj1cnlPskPvBOvPdGYtnriSXLk+4sTSpcnHRrYVL+/KQbc5OuvZZ0
ZXbSpVmJ385IPDc9ke8tjA9d1Xhwry4rwvTxQfY8pQ2i3tGjsgDXleLmhxDT
8mO52hasp31lUy+26jDTjzkjdpixw4KdNuxisIuiy0PL2THLuRjObmMZCwPD
ULzRd2hqpTwmQ8h+X57Yl0SL79iLuvahboR6VUjri+RaP4K1H88vAomOFYYA
ZPAnG7H7frVK9qreT9Xnq9KpVFrkp0VqzT5/zb7A3r1BPXsgw1jXrrDOneHt
O8Lbtke0bIt8uiWqaXNUw8boug3RtetiqtfGVK2Jfbwq9pFPXPnKuPsr4u8u
jy9dGn9ncXzhwviC+fH5c+Nz58Rfnx2fMzP+8vT4b6fFnZ8ad3ZKLCl53eSv
1MvyE9dXH1VpqJaCJd7PwZX5uLYI1poKK7V6GrDmKda1wdQG2TdrsbUPMwbM
mbDdgh1W7LBhB4udHB1346G1Y4ZzWTm7hWXMFF2tsYsHeNScsIPZ1cXMsS+L
sVXrTtS2E3XsRl17UM8+1IuIjmoQUmjJFw8dQnpfQXvl5BvNuU0Oyv6m3Ye0
e5Fmj6p3t6pnt6p7l1/3TnXXTn9on+1B7duCW7cGt2wJad4U2rQxrGFDWN26
8Jq14dWrI6pWRTz2jqx4I/Lhisj7yyGDeumSqOJFUYULogrmRd+cE507O/r6
zOir06O/mxp9cUrUhclR30yMOjMhkpS8d84nVDfHf5FgunyEzXuPKzoN7rXy
Gr/a4OWuKtxbB+QBulZQVUM3NtMQytaPWRPmzJizYs6GOQbbWWL8dPjYQbpd
2GbHVs5l4ewmFiI2jUnTom2u66oivzY6ns8KOFK/C2+TNW1FT7ehlm2odTtq
34E6d0FCcnnvHqKPmj2Qn5xsMjnBTPaqbp+Y4ZI0GzlHtt2ol2zknl2oeyfq
Ivdvh5zwHVuhRdu2+LVsUj/d6N+8IaBxfWDD2sC6NUE1q4KeeAdVrgx+tCK4
fHnwg2Uh95aElC0KKVkYemd+aOG80II5YTdnh+XNCrs+I+zqtLArU8IvTQr/
dmLYOa+wr5WhPI7pC/JPbKg4Hdh6McWUm2ktfJ/l30pqvINhluMx7q2BsQMS
9OvbAU1i+BbajWWMmDVjxoIZK2ZtmGWIsYNSQrTkwFY7ttix2e6ipY1r0bXV
dNXwlgw/K7X/IURHZtQm+40bUTPwCjwFXoGWLahtK+rYDhjJCVTynp1IQYCT
9+5ENO78Qzc5tw22TnLdFtS+GbVtArxbNqDm9aqmdb6Na/3qV6vrVqlrvIHX
oHKF/6Pl/uXL/B8sCbi7KKB0QUDx/ICiuQG3Xwu8NSswf2Zg7vTA61MDr04J
ujIp6PKEIGrJ4z9XQlK9jNdOZ6/+7rN9pZeimqisv6g8h+uv0VmiUpgl0jyB
Aa++Jgg9jZ0CflY9hZDEnXICn+wXNhu2MTDCZeNAEck5q4MHEL7rGdDIp32d
1d31MtlIVihpLDo2mjyLRuN61LQB2AaaN6KnG1HrJtS+hSgakhO85AQ2mUc3
gW8rbJ1bkKJjM4/ri60bUOt61EIpCprWoMbVqGEVqvdR1Xqrqt8A4ozK5b6P
lvmWL/F7sBg4Ncrm+5XMU9+Zoy6crS6Yqb45Q503TX1jiv/VSf78E2bceWXA
WWXAV0r/z5X+nyrV/LqtX5Vl6h99wNR8ZW+67GrJg4HGrvt0tq0W6xuho2/s
gFkE4iUtemwzUCgtWE5AlD1jZWCI1sKCBhIMwZk6RG4DHcP1WMFTPuluogck
uEn7pKPjOJgPq3qVYMSNa4G3Qd5EgPFoXoeImrVthE3evgnJO8hf+0YSB7ST
w+sFAFvWgjav5bmVflnvjWpXopoVqPp1VLUcPV6KHi1B5YvQg4Xo3nx0d56q
dI6q+DVV0SzV7RmqW9N8qf796bKX+qJSfV6p/kapPqP0+0Lp96nS92OlLynx
os+n+Xuu34m4/+BgY9VJXeNnTOsFe8dVR3cBjKT2VeC+GqyvhwFBQxvQMZk0
2NyHrQZsoyOvBMhBGOUW4iOfgykchxBb6e0DGsbRZYXVAlW9MFss5Wr8ETiC
Yj1egareQNXeNPaUN6xGcqJZMkXTakQQAm1TAPvKC61rBeYVnnyleTVqWoUa
fVCjNxCxNKxE9ZS+pnYForwJ4+7NBZqb0tmoeBYqmol4jXvlxmR0baIqZ4Lq
stL3otL3gtL3G6Xv10rfL5Wqz5SqTzzRhzRVXtGmD++pv30cX1h/pLr1w96u
b5ieK5w236EvcRkoCZGxARtId5LXxR6YebH0Y6sJ2yzUenn4OGzmqA1T+xmv
4wZ6GFeHlW02wtrGsvban0qQko47jY4c9Z6gOuVLUcVSVLkcVa8Q+YrqeTS8
yT7BRtFMdFTR7IOa6CaTNxGUgeZHwZP71L1OjtUu57PlVy9FT5agysXo8SKg
Ryqfjx7OQ/fnAvePXIgJ6Xtnv3vid7op/mrHW3c1HzTqzmj7rrD9+XZjsdNS
PmCtpivKWrC5DZuolYJu6bGFImOjnUELRYaPPZ81OLCeapaGG+hiXG1WrskI
axDvdjaNYFuUcnp8DzoQ19xbABb0cBGYEjGoqmUit1fdCpC9/g0iO4FB3kDA
U8CB12Ejpwkez9cuA0Ko6iXADwXxxUL0eAF6NB9VzEMP56IHc9C9OYja4V8L
ZqKbM1DudHR9Gro6FV2Zii5PQRcnowuT0LmJ6OwEYFj7UglEXKcp89oHPCUV
6SfEfqI7lNOffc/0eaP5ktZ6k2VK7Fy5k3viYuthbo/pgPFMKwm1iafrg0kn
qwVbbfw7aM8Z7bCAg4Cns0O+cAi7GFeL1dFgsj7R90kZmqRj9cNjGJqxF2ZV
Sykx1P356AFpfSLtQtAHohVCRmACCQEGtqUCPHKgynqegPRkEd0WoipyzwJU
OR9EfDQX2MQevgbMYtT+/r1kBrozAxVORwXT0M2pKG8qUFNdm4xyJqHvJqJL
E9CFCeicF5DtnaEMbp8Nhy3bE8GCNdkLZtrR4DHoswsYdNN4ro1xNVud9Sam
Ug9mJuV8lCJB+XP43AHSHMYAdOEMVDwT3IictLhs3P050PhEBYguEI2gt8iJ
yDKPqgWC3I/nIcqdNu4RJVIjWznPnkX1ZVbZNFQyFRVPRUVT0O0p6NZkdHMS
ypuEbkxE1yj/3nde6JISSOvOeaKzlL7tC4rDJ8NxOE6ViMk6zZ2+4bxwH163
LunDFRx+4sANTtwCz02XBjt02K6HbhpEa1ZsscECCCNFj4dOS6HrseNODrfT
441WZ63J/piudpPmtpDOb46O3p9ED1UwBRVOQ8XTUSnxwPK7s5Bs/L1Z6P5s
UAieZ44gBTDLKwhGHuWzgWHuwUz0YAavL3PAT05FpVOBdq54EiqaBMR9BRPQ
zQkozwvlKtF1JTD7XaEUfxcpzd05yvv3FYXtUwrbh8Nh46kC8Qcf4m9y4EXS
klb8yAC5PJsckJOazkc69dhhwHbSZSARrg2m2I0MNrC4n6oYUbdeilkXxayV
wlZvdVab7A90RhrESHCSrm4YHbc/i3aYNxHlTwL1uEOEn4ZKp6Oy6ejudILh
vRlEswhCD2dSnChUQ6Pvc8umoLLJqHQySFg8Ed2ZgIq8UKEXKlCiW5SwMtcT
XfcUILtEuRHPU37AQch4i/t4NNSO8sCdOQ1MwzdL8cNWXG/GLRwkRu91YR04
LScdELBbRdQIZCys4aMuHpLQE8g6OIDsKR3bqrO4Kk2Ooh79aByB/xqx/xY8
mOzZXKIRE8GWCilqxMBKqOIQ9SGaRz7GlVFOR/4fAYmPNmcTiMDMvYDcElBS
Cijd8ARazxxP9B0F6oKbPX5JeRU/FU3yn5RUUwLUYR6rnC9wcQGuqMQNnZCs
mwivceA+CMMGzNhpwXYbZmiwYKK61ceBPULES1Fq4yBjchMDb/GRgw/77bkd
2hHISNc9jo0UXedxmVoM+XLDC92goBUQVZuMCiejoslCnDTuDt2BbRIQf8oU
xOxkitsTxH4rHaP7jbvlfTs2QB9Qztv3KP/tIEB8jn9IF9muxUQ1dA7c78Qm
0CGXDdsZERcOcBl8xnXZcTuHW1jcyOA6G35Cw63SPpgAGeHZpRo1Oi5/Efd5
slr6ldqS4hZFpgCkpx9k/ybdZPL8CUie78VTLvK6cp2qCw8IXVQtG5dO+X/h
l0q+xuW3BD4OTEIekwtbqbEwmGMh2DZRM9FxAAT/FAMpOcg0XGPFVRZcQSPz
2xqYjRiVu31UOeEXXxHlI+0CYsnFt88VpL7XlCgXxMgjDfsKsSCiD9e9YLvm
BefIVTlUou/cWnksfzFoBu+6NXQmpXLO8EQEjFRK1wqqX52DW0nXmASINh6V
Xw9QF8pyEBoSN6tjcS8LSPBGAA8l+i5xpRkSF9yjfb7cbugWj+j9Sj3v2NbA
9+M/o1KcoXJdomLSGnlcpejw2/irBIu/5ijRFSVAQU5fEtHg/cIgIKP6BR6Q
LDdAiHc4RGlKUynzNc+k7KrLgwlWk9FlZV0M52T5t55+puWAf6KDPmeeUpxq
CRI0hcNdAy4WZl+lYyrSd3bHjnPgInFUWzb+Y9qeX1CBzlMR6fOZCDyeSCz7
27e0rudFsc+OUIVB4Xmbz6aEtFmi2b9FJedN44AnSqTUpTzLuqvpDjb2umxW
B+tw2CF+sTnAWojxk+cGuC4pu7JUxp9QGZ+RyChyFdOeAnQO/49W7yOe3JnW
nwgiP89LKlPwUp0V6LhlXrztfEmv/Xz4A9K9iXnvf2y4zh+k1LxE7RM8URxl
ag3nTaCvboAxOTmGc4CgREqtXdD3Ft7jM7iad/pmfNeIi/T4Jl2ww/vxH43B
S0I7ixngZOPed2O4/hIIq4CEXHFmiGEdPv76GT3v3qofDLfxY8NV2l1kvm1j
KVVzmCcKokWzNoOVtZo48NjEpfOhQDMryFtp5bVwXKkR3+7DNzT4ctcArYhE
SmlcOrrU/yFILfJTy8Yfo5XIpjLw4nsQ4Tw+Bdl5KeljiYZw3p6+PBQa1sF7
ZFLPBlrPxxZM2uUedcpF/ThPi6/04HPtUNW/S2omzT47ek1/I+jo4Br6DD7c
4j31SbG+smeJutHqnRKN66SbfWWKJpZB6aDT3KxsP22JKMpNH0obQ02eByJv
/fP1vHulYhF1KzHgIrp85movvtiFv3gKkr0qkUTasxqSTMxyDCdfFrFXHKQa
csRdqhM8W7WcfIw7LkiWRZXqbVGvBqU5KD5BBqWJptKEUQrgQEoC7UvJb2WQ
BSac/5WfVZghrVCZERcb8G1iRZR8+VI3Pts+8FEj1S0viRzSvvPoLfZzocX+
KMrnkUgrmE6rDBcqSFsojghSvUUtJMPN+6VQ18/7hRjRNfBNEyC2zj7K8kzl
8fX2jPDxFFaWP0skydfhG1p8lU5vnOvEn7cMnKql8kyS1P/5HyTPc0J7QbzA
+8FkWs2D0D7kg0Z8/5VK631guH0PalUwrbofrfpeys+8gxISUwECvD39fTzD
NntCQtArvUK1yeenT/HJalrzaZKa/uwH1fwZoeaeQs3l8DhVxFNg44SvdMW2
x05am82DLH28J/y8VRjaPEFHr2Qzf1AtxuOh/I6gBxPdrqI/BjUhmCiIcsqe
D6VKGkT1lIcIUYh2eaLtIp83XceheK9OqA1t6Tmj1OUnZBfqMLwecgGFqZI7
YKQH4lH5oQrq+RdJzj83donk6AzJ1fAMBSxXjHJ8eCnSVpKWtEey/9MRJYgR
rPTOvZL9Z0bc6b6ODJCUYrJPsj9+RAni6vgff6f4duUUyZVIsj9uVNwVspEZ
QydK7lRJ9j1GlCQdE3WfSQc8JkhK8P2eEmXChNOQTkrn6cXYUVqqn2RfMaxU
aR3HS/Y9JXerJfvyYaWJTx2RS1z6rPKnkA/uY34ecnRNla7z/B9JWQFU6MH9
wTqI+ip9L04aEYx1v/hOqPT6QLf9oVq/iN37d0NXB8HxwTKHMirzZ/8iuTp4
GIpiVmspp7h0BnyP5Ly7RlAnRv74En8vOSON4KUlwS8PMnTTyF0+xl0Qn/K8
FH+QlCFdt7NLKJM+1/mRXbca/V5y9VahbBpX018ebXXVOslvwh10HEaIz4fO
SHvra4Xa0ONDow/CWekcx8pRkP3PQWShZvTpJxs5+rFYUrJC+N1fCdfzaAyu
BBOuGtlDlI42zZFKLuD1ouT4c2OUL845/KtyRU34/Q8sV/TY0lGfOUL9/vgD
y5Far3Q8YZrkPNwsjkKOhenP8VBM7F6W1xht9DfJcVqnwRb/pdv/7qVNECT1
xG5+SPDKQ2VJo/a/D6+tUIN59N6JWIzdeTngUxoN/V24g8YVssnuvz1iTnhs
jwEl/Fq4l8avwvNT0l7fU6KoL78bgT59ftInufiEkJYDqL00xn3Thfukc7W/
HUUP/muMMmbgIVuVjlDC5X8e475Zo6Im7YEN9w6vjFHWbOy+bnF43CX1ZK8O
awm4XyEber5J1588I0ihGrXdnhleH3KbNBpRCL4T/l8zahniL7vH13D6Zcl1
PqPe/axQ9u+w27NlxF2ThN+Q2uTQWfejIkJ8fUWtf1Vy1Wp6dq9wlt+7MuJT
9pP/B/0ZcIo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219458235]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9534],

Cell[TextData[{
 "The ordinary coordinate system is used for ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " in 2D graphics:"
}], "ExampleText",
 CellID->156588669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"Disk", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "10"}], "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Disk", "[", 
       RowBox[{"p", ",", "2"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", 
         RowBox[{"-", "5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423060883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}, 10]},
    Axes->True,
    Epilog->DiskBox[{-5, -5}, 2]], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}, 10]},
    Axes->True,
    Epilog->DiskBox[{0, 0}, 2]], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}, 10]},
    Axes->True,
    Epilog->DiskBox[{5, 5}, 2]]}], "}"}]], "Output",
 ImageSize->{341, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->115430854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34043803],

Cell[TextData[{
 "Scaled 0,1 coordinate system is used for ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " in 3D graphics:"
}], "ExampleText",
 CellID->152766262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Disk", "[", 
       RowBox[{"p", ",", ".1"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{".2", ",", ".2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".8", ",", ".8"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->419412716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[SphereBox[{0, 0, 0}, 10],
    Epilog->DiskBox[{0.2, 0.2}, 0.1],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}, 10],
    Epilog->DiskBox[{0.5, 0.5}, 0.1],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}, 10],
    Epilog->DiskBox[{0.8, 0.8}, 0.1],
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->643072952]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14354],

Cell["\<\
Display the sample points as well as lines joining them, on top of the \
interpolated plot:\
\>", "ExampleText",
 CellID->380212625],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"RandomReal", "[", "i", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->536496199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"Line", "[", "data", "]"}], ",", 
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", "data", "]"}]}], "}"}]}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8033490],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1lXk4FPr3x4exDDOY3c4sWiVbbgp9jixFLsrSlYRbhOwqRFlLqUhCSZJC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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Epilog->{
    RGBColor[0, 1, 0], 
    LineBox[{{1, 0.5802448262767801}, {2, 1.1628372487260465`}, {
      3, 1.9337620713761405`}, {4, 1.3909131944392827`}, {
      5, 2.7754403460562194`}, {6, 5.591858829709469}, {
      7, 1.3884463773322155`}, {8, 4.142131445924553}, {
      9, 5.6425198147772315`}, {10, 0.35999252736216736`}}], 
    PointSize[Medium], 
    RGBColor[1, 0, 0], 
    PointBox[{{1, 0.5802448262767801}, {2, 1.1628372487260465`}, {
      3, 1.9337620713761405`}, {4, 1.3909131944392827`}, {
      5, 2.7754403460562194`}, {6, 5.591858829709469}, {
      7, 1.3884463773322155`}, {8, 4.142131445924553}, {
      9, 5.6425198147772315`}, {10, 0.35999252736216736`}}]},
  PlotRange->{{0., 10.}, {0., 5.6425198147772315`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->656397258]
}, Open  ]],

Cell["\<\
The same result, using a duplicated dataset with linear interpolation, and \
the meshes:\
\>", "ExampleText",
 CellID->130537527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data", ",", "data"}], "}"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Green"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->860374518],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->12053271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49622628],

Cell["Draw large points where the line and the curve intersect:", \
"ExampleText",
 CellID->554820405],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"27", " ", "x"}], "+", "130"}], ",", 
     RowBox[{
      RowBox[{"-", "12"}], "-", 
      RowBox[{"58", " ", "x"}], "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "3"]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40859443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"#", ",", 
            RowBox[{"f", "/.", 
             RowBox[{"x", "\[Rule]", "#"}]}]}], "}"}], "]"}], "&"}], ")"}], "/@",
        
       RowBox[{"(", 
        RowBox[{"x", "/.", 
         RowBox[{"NSolve", "[", 
          RowBox[{
           RowBox[{"f", "\[Equal]", "g"}], ",", "x"}], "]"}]}], ")"}]}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282092742],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->296257299]
}, Open  ]],

Cell[TextData[{
 "Alternatively, use ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " to find the intersections:"
}], "ExampleText",
 CellID->691888280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"f", "-", "g"}], ")"}], "/.", 
       RowBox[{"x", "\[Rule]", "#"}]}], "&"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", "0", "}"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Large", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->99010487],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWnuMVcUZP7v3nnv3dZdlcReW1yKsUh6C2Nb6wig+tiCwYkuJD6DLikJa
XxT/EI3RkGhMMDQ2JhIMJGptfPyxjQ3VZJsQNzWSGAhEUiMmdk0NNpGYQGyy
qcnt7/u+mTNzvjP37HaXjS5z5sz8vud8jzm7rn/3ju0P9e/eOdA/r3dX/6M7
dg78bt7tj+zCVKEuiqIR/P/CjAjjKkb8/0i1in930e8CPfNP9Nuc2Qae/fLD
U58cep+GD+asOn/23Jsb99Ze1cizb937/Hcj/6bhAzVX1YNaHgYAAFMbo4ln
wQxYouF2wsSih7y3x175y4k3huzbWhhfHz/z3sMv117VzLOv9z39/bnzNLw/
Z9XwvndOD/59rFWOYnhVi6I4kLPKUcxb5SgOpPRUUVrcFsSoKG3mrXJ2C69q
5dnBHb//5tN/0rA/Z9Wpt49+9NIgDdfjVxGL6g33BfNvKWc3lAfBfhj9b9RH
z7GsSn4zlt2rn3kYxJ7Cs0d2H/jq43/QsNdwVqSHols9Ofwvho4PPfMaDe/M
QamFSo8+GnQAZxq98J8JoWV5bOPZo8/96bMjx2i4ln6VfNknowFBdx67Ttk8
3/ZTq2mP3pKzCu4Mpw6tupQ9Bi6KJThh4AROHRUPrHwsig+v3oPnD/YcQgQD
l9FKD9H5nEacQ78a8R6nFXtfveVxnAFQxyNAcGrEgxpgJTxLNAYZEIMj4PE6
ptLOqJiBg9Bws9HFbLYAluEVTA2WMQYbfBJKwMR6UMUrCITHnzGaxPTR0R/O
nfuehmWl+c1KhhmsFWzHwQQUAAEbdbDnQzJIA+Hx7mqHXhwZ+W5D3+uP7z7y
t6EvBP/dbfu+/fxfNLxP4XdafMgOJJx9oEZdjINZPMMKMMpPGJ+jd3zs46+e
fWYIJA4f+uTs2fOiRS9yaBrCLd4DCmQAy5YpwgJiEGjtKsbnyBlDNUDetPFN
EUF8OO7furUuogyMn97e3ugeRWUaY0KToCJiXGo9DrqFa0Yr3PksJjL0rX+Q
wlRUAKZB2qSQp1ptw9KAAts9vAJqAf9QbHSl54/gvqmpQpBFxq2vr6+BK6cO
3giOyaoLrT8DFaEuWu75H1BEdEa9WyG1Wg4RJOGI0PCiqolC8BiEjGiZhzV3
7lyDVeBfhULJaHqT8W2J5uAJnBEnSy2aBKDoCg9teHi4rq4uQSvt378/Ue6L
+4bhjL9U3DZb7wIaVIoBS+pFtyWMzxaNT5482dPT09bW1nXJ9Cfu/o1EsBK0
/OfB05vvfWvnjsG/HvkMB2qDoiKVBqwDbRLP7GFeFlnMNDqtZHB+8vyYaZ7+
9JvnnzsqAmAs2czDbrSWAzbFkR9bFLgHvMJg09kreBlUdrmcztG0dOHCKCSB
GBAGAzxON/uuUlTLVm9QGqwMcgvMyime55CndyvKBS861MqXCUdeRGWOY5gQ
eoA2oJMzn38rMcnbtTyIIqeb/PpH6n3FswxR6Q7yRS5VR//KlIjAP4lEubJI
5EMkQOBJ/KEER4G7DGx7N9E2cZNUEzlSsWdQzW5svih0BgvwNLgxDeeOQ6qx
LVK2ujQVXiVjEfLPaWPwLrIh9iIaUE2yWL0X/3F17ZyLwrvkOpCE0hINGQv4
/k7z9cbfE9vSaYKfg2fmlubb7byJuheTS+AhSVZttM9ouEXt4lxSTp7xI6eP
/H2JWttubQgK5O+zx8F3uZquvIS+i5DtNXTZZNYzf64+FPHw+wrzXjwG5obR
aTizmq34Ip7140FHUDfX86zQgvzQAkXSW3kvAiJSMg0XMOKsavpUdqblQNL/
4xsnENyvsTqCA8ANQPw2pUUfD/RwPsizuXKJUZUceOUYOEQaQjKKfmo9RwCj
n/Ozq0XnMxbbxatjGDtGXkR2TBgTzRZAC6JRNFqtvNLHcnllTpAvzspFkYny
RhSt4X1IUUhUNOQahmPPGeMftobUHhx4NjVfeYz1/L7R92XNZzgqjYGY6Trg
upCKrDRZvAm9d6chcaL4/8Tx8qiuPL0IMlu95+ib8SP2X6oGcKjJM3VntkI9
S6XiTk5XkLduHrpIzpWq87sn93xAdZ6skgiLUxBpPayx7433dnvYsB/OGs1y
vRoPf/ilFHugQN3ALLsK54Oioe4Z77C+4OfJaB7PIlEgXdCQawbqBKAt1wlI
5eHOi7YXd8Vet8OnTs6Q18Fx9nNdjOH7kqo5eaaG0lZeqzj0sV38WRrkWzoD
GM74P9/GAXq94pc9RyKIR2lZkN8WayMYG15h7rkcv+sUimAvUP6xPMhvo7Uh
+MXCTPbTfM/ysMERXlCFxPVrg+IbcwMDA+gYuJ8prFp5E1ZTT18J0nD8C40e
6wGwEmmSK+9iwv8NN2yRbu7Wm1cZHM271PLutoJzXHSZoiYZo1JpNTWndEqu
lwujutwhqJdX5dZV0NI9HN8CmN3adn3q/Ama9IeuBpCuY2Znl89jMY7LSeel
ce9UXHIMMfW564y4my2KZ+3f9hRsxfyW0dlJs+K3XXxOSK4Nlmdz7+VjSzSg
E8v+1ignWFww6e/Qlh48eNBEy6QDMzWGjiJCzUVDjgymJhdq1Ldyn0p53ngk
+xh1XKpq0rFX0N3Nu6AvthLCRwidn4vSx8gtBp/zstRH8EYxAu+NIumCXTU8
neeXWExz0hZa3QNQglyH5TlRPMDw+ItqNVUpCB7Xd7AbYxpp5tuViFEU7Wda
DZPVEg3fpc405xuJPVQnysWHxDuSGVTxH1TEcYUq4WwxmjkVgindCUQDMbwz
nRIwoRxMgVGeSVUkuuZcp7xNkBPPBT0JKywr3QoJNnQ/z/gr+1mggr5DeRbr
X2IZ8Qg9yEmRWhi0cBrhAJgHuNG18yT220zFvFr5l9DgO7ZYLApTgT7loSnC
J98n4uwfXr0Hv6G8HkWpISPPO2+fQmDs5XWuDuc8F/F9YRkWhaBgAqrBAAIk
WbUBI5gdbgjh5EoUgkLcyxXdZivhH176yFWMUq27LC9Ur7VahGwwCJDLdL9b
xAA+C98EUd2bcteYqZ5WKfsL/tbq+L5Z8M1bphq/mVe53Mh1XfRrXhtN8kvG
tKAUN9qTAAU4ivx9ZlLfNTqC8q1UJ5x7yNQ3o/FKRo8zghJdp078xGn4zzPT
8pgqhXtErzttT3zgYnwZkY5NV118brwoPjXxkfF8L+lmTF1t8bn3Irlg6i/H
84P8yB2h+27ZFtzbE6R7pfL38N6Fabrmzl8yq/tu4faS3IstvdQ9/lLF65Qg
vaVBORcpXsN7lwXlXKh4De9dkaGLmGbqQsdza3AvV2IloesXR5IN3I1veDf7
VOrOmShLR+RiQ3gvn4FStizjDOpVuZXg7uszlEnXsxXXbi/Z9kaPInScUOxS
/IYp3pSh6G6UHbctwb2rPMr+DW6H4je8mzNSjZtT5xvhvZxDU7lVZJa+DtkR
KYiGzcHdayzllH3lztVV8+G9a9P2TWSW/sN9sw7v7gvKLF9GwDLcmuKm20v2
vSstaxLapR92dURTkCJXuZnMI3HQZYXwXv4+lskoHJfjLffcl/r61xBE4O9i
JZ/6ieNf7927V3/hi4O75bsl6D/y8HulUnMUq55PdqnsXM2P+PJNOt35lUM4
E8hQgq2/5pVKZfNtWfjdWpWayJDVabFmfhd09XWv8KuNj4kjeegZnsfIviFZ
GMd862ttqXS2TqNeUHYhQvi7kmw7UVry9y/wfxxcGjZcFFSpcdz5CFp5DG8h
DLovCHu3UHCxqhxcJX+T5GJSKWeVq2PcKuJL/kbKfR3Iw3BdTHiVYLnYHj57
ssrl97xV7pYmb5WLb+FV25W9ijVXkUUcBulH/j7O5brae+2Xgdqr8v5OMDwb
1f0PjcpPzQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->532431299]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70914348],

Cell["Watermark on top of the graphics:", "ExampleText",
 CellID->195430328],

Cell[BoxData[
 RowBox[{
  RowBox[{"watermark", "=", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Watermark\>\"", ",", "36", ",", "Bold", ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
     RowBox[{"Opacity", "[", ".3", "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->158871457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalPlot3D", "[", 
  RowBox[{"\[Phi]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"3", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", " ", "50"}], "]"}], ",", " ", "Yellow"}], 
     "]"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Inset", "[", 
     RowBox[{
     "watermark", ",", "Automatic", ",", "Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->116234979],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->328300996]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28776],

Cell[TextData[{
 "Objects in ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " are not part of the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " computation:"
}], "ExampleText",
 CellID->142687151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Circle", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74032185],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Epilog->CircleBox[{0, 1}],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->609576558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->306804208],

Cell["In 2D, the axes are drawn above the graphics:", "ExampleText",
 CellID->515293168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121984385],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Axes->True]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->515772189]
}, Open  ]],

Cell[TextData[{
 "Objects in ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " are drawn on top of any graphics, including the axes:"
}], "ExampleText",
 CellID->103317383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", ".4"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22529850],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Axes->True,
  Epilog->{
    RGBColor[0, 0, 1], 
    DiskBox[{0, 0}, 0.4]}]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->70496659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12326705],

Cell[TextData[{
 "In plot functions, ",
 Cell[BoxData[
  ButtonBox["PlotRangeClipping",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangeClipping"]], "InlineFormula"],
 " clips the graphics including ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 ", by default:"
}], "ExampleText",
 CellID->93553677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Circle", "[", "]"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->824277437],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126700331]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["PlotRangeClipping",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangeClipping"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the graphic can be drawn outside of plot range:"
}], "ExampleText",
 CellID->690947861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Circle", "[", "]"}]}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375730143],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48260946]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4046],

Cell[TextData[{
 "Image mask generated by ",
 Cell[BoxData[
  RowBox[{" ", "RegionPlot"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->531737635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{".45", "^", "10"}], "<", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", ".5"}], ")"}], "^", "10"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", ".5"}], ")"}], "^", "10"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97329683],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329799669]
}, Open  ]],

Cell["\<\
Apply the mask on top of 3D graphics, like a \"picture frame\":\
\>", "ExampleText",
 CellID->362541416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"First", "[", "g", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7219561],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16060113]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6702],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prolog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prolog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DisplayFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DisplayFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6963]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27467],

Cell[TextData[ButtonBox["Graphics Directives and Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsDirectivesAndOptions"]], "Tutorials",
 CellID->6522]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Epilog",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Epilog"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->12823294],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->80797294],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->291053445]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Epilog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 28.6364434}", "context" -> "System`", 
    "keywords" -> {
     "epilog", "graphics layer", "top layer", "layered graphics", 
      "post-rendering"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Epilog is an option for graphics functions which gives a list of \
graphics primitives to be rendered after the main part of the graphics is \
rendered. ", "synonyms" -> {}, "title" -> "Epilog", "type" -> "Symbol", "uri" -> 
    "ref/Epilog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4416, 136, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->367545923]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 175752, 3510}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2320, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2943, 82, 43, 1, 70, "ObjectName",
 CellID->5164],
Cell[2989, 85, 524, 15, 70, "Usage",
 CellID->4588]
}, Open  ]],
Cell[CellGroupData[{
Cell[3550, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4028, 122, 351, 9, 70, "Notes",
 CellID->32495]
}, Closed]],
Cell[CellGroupData[{
Cell[4416, 136, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->367545923],
Cell[CellGroupData[{
Cell[4801, 150, 147, 5, 70, "ExampleSection",
 CellID->56825010],
Cell[4951, 157, 84, 1, 70, "ExampleText",
 CellID->77499382],
Cell[5038, 160, 320, 11, 70, "Input",
 CellID->225818802],
Cell[CellGroupData[{
Cell[5383, 175, 360, 10, 28, "Input",
 CellID->45175040],
Cell[5746, 187, 3307, 58, 134, "Output",
 Evaluatable->False,
 CellID->689083117]
}, Open  ]],
Cell[9068, 248, 123, 3, 70, "ExampleDelimiter",
 CellID->7488895],
Cell[9194, 253, 99, 1, 70, "ExampleText",
 CellID->278338907],
Cell[CellGroupData[{
Cell[9318, 258, 746, 21, 65, "Input",
 CellID->185372961],
Cell[10067, 281, 33470, 553, 237, "Output",
 Evaluatable->False,
 CellID->219458235]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43586, 840, 215, 7, 70, "ExampleSection",
 CellID->9534],
Cell[43804, 849, 237, 8, 70, "ExampleText",
 CellID->156588669],
Cell[CellGroupData[{
Cell[44066, 861, 849, 28, 70, "Input",
 CellID->423060883],
Cell[44918, 891, 602, 20, 122, "Output",
 CellID->115430854]
}, Open  ]],
Cell[45535, 914, 124, 3, 70, "ExampleDelimiter",
 CellID->34043803],
Cell[45662, 919, 235, 8, 70, "ExampleText",
 CellID->152766262],
Cell[CellGroupData[{
Cell[45922, 931, 710, 24, 70, "Input",
 CellID->419412716],
Cell[46635, 957, 37958, 632, 131, "Output",
 CellID->643072952]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84642, 1595, 223, 7, 70, "ExampleSection",
 CellID->14354],
Cell[84868, 1604, 142, 4, 70, "ExampleText",
 CellID->380212625],
Cell[85013, 1610, 320, 11, 70, "Input",
 CellID->536496199],
Cell[CellGroupData[{
Cell[85358, 1625, 433, 11, 70, "Input",
 CellID->8033490],
Cell[85794, 1638, 6117, 112, 170, "Output",
 CellID->656397258]
}, Open  ]],
Cell[91926, 1753, 139, 4, 70, "ExampleText",
 CellID->130537527],
Cell[CellGroupData[{
Cell[92090, 1761, 603, 18, 70, "Input",
 CellID->860374518],
Cell[92696, 1781, 6831, 116, 70, "Output",
 Evaluatable->False,
 CellID->12053271]
}, Open  ]],
Cell[99542, 1900, 124, 3, 70, "ExampleDelimiter",
 CellID->49622628],
Cell[99669, 1905, 102, 2, 70, "ExampleText",
 CellID->554820405],
Cell[99774, 1909, 416, 15, 70, "Input",
 CellID->40859443],
Cell[CellGroupData[{
Cell[100215, 1928, 832, 28, 70, "Input",
 CellID->282092742],
Cell[101050, 1958, 4197, 73, 70, "Output",
 Evaluatable->False,
 CellID->296257299]
}, Open  ]],
Cell[105262, 2034, 238, 8, 70, "ExampleText",
 CellID->691888280],
Cell[CellGroupData[{
Cell[105525, 2046, 654, 21, 70, "Input",
 CellID->99010487],
Cell[106182, 2069, 4181, 73, 70, "Output",
 Evaluatable->False,
 CellID->532431299]
}, Open  ]],
Cell[110378, 2145, 124, 3, 70, "ExampleDelimiter",
 CellID->70914348],
Cell[110505, 2150, 76, 1, 70, "ExampleText",
 CellID->195430328],
Cell[110584, 2153, 321, 8, 70, "Input",
 CellID->158871457],
Cell[CellGroupData[{
Cell[110930, 2165, 784, 22, 70, "Input",
 CellID->116234979],
Cell[111717, 2189, 30318, 501, 70, "Output",
 Evaluatable->False,
 CellID->328300996]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[142084, 2696, 233, 7, 70, "ExampleSection",
 CellID->28776],
Cell[142320, 2705, 349, 13, 70, "ExampleText",
 CellID->142687151],
Cell[CellGroupData[{
Cell[142694, 2722, 377, 12, 70, "Input",
 CellID->74032185],
Cell[143074, 2736, 311, 10, 162, "Output",
 CellID->609576558]
}, Open  ]],
Cell[143400, 2749, 125, 3, 70, "ExampleDelimiter",
 CellID->306804208],
Cell[143528, 2754, 88, 1, 70, "ExampleText",
 CellID->515293168],
Cell[CellGroupData[{
Cell[143641, 2759, 244, 8, 70, "Input",
 CellID->121984385],
Cell[143888, 2769, 281, 9, 167, "Output",
 CellID->515772189]
}, Open  ]],
Cell[144184, 2781, 243, 8, 70, "ExampleText",
 CellID->103317383],
Cell[CellGroupData[{
Cell[144452, 2793, 468, 16, 70, "Input",
 CellID->22529850],
Cell[144923, 2811, 343, 12, 167, "Output",
 CellID->70496659]
}, Open  ]],
Cell[145281, 2826, 124, 3, 70, "ExampleDelimiter",
 CellID->12326705],
Cell[145408, 2831, 381, 13, 70, "ExampleText",
 CellID->93553677],
Cell[CellGroupData[{
Cell[145814, 2848, 367, 11, 70, "Input",
 CellID->824277437],
Cell[146184, 2861, 2782, 50, 70, "Output",
 Evaluatable->False,
 CellID->126700331]
}, Open  ]],
Cell[148981, 2914, 382, 13, 70, "ExampleText",
 CellID->690947861],
Cell[CellGroupData[{
Cell[149388, 2931, 427, 12, 70, "Input",
 CellID->375730143],
Cell[149818, 2945, 3025, 54, 70, "Output",
 Evaluatable->False,
 CellID->48260946]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[152892, 3005, 223, 7, 70, "ExampleSection",
 CellID->4046],
Cell[153118, 3014, 153, 6, 70, "ExampleText",
 CellID->531737635],
Cell[CellGroupData[{
Cell[153296, 3024, 614, 20, 70, "Input",
 CellID->97329683],
Cell[153913, 3046, 5276, 91, 70, "Output",
 Evaluatable->False,
 CellID->329799669]
}, Open  ]],
Cell[159204, 3140, 114, 3, 70, "ExampleText",
 CellID->362541416],
Cell[CellGroupData[{
Cell[159343, 3147, 332, 9, 70, "Input",
 CellID->7219561],
Cell[159678, 3158, 11619, 195, 70, "Output",
 Evaluatable->False,
 CellID->16060113]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[171358, 3360, 310, 9, 70, "SeeAlsoSection",
 CellID->6702],
Cell[171671, 3371, 954, 35, 70, "SeeAlso",
 CellID->6963]
}, Open  ]],
Cell[CellGroupData[{
Cell[172662, 3411, 314, 9, 70, "TutorialsSection",
 CellID->27467],
Cell[172979, 3422, 169, 3, 70, "Tutorials",
 CellID->6522]
}, Open  ]],
Cell[CellGroupData[{
Cell[173185, 3430, 305, 8, 70, "RelatedLinksSection"],
Cell[173493, 3440, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173887, 3457, 318, 9, 70, "MoreAboutSection",
 CellID->12823294],
Cell[174208, 3468, 174, 3, 70, "MoreAbout",
 CellID->80797294],
Cell[174385, 3473, 163, 3, 70, "MoreAbout",
 CellID->291053445]
}, Open  ]],
Cell[174563, 3479, 27, 0, 70, "History"],
Cell[174593, 3481, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

