(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     70832,       2829]
NotebookOptionsPosition[     54756,       2258]
NotebookOutlinePosition[     56185,       2298]
CellTagsIndexPosition[     56099,       2293]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/Equations"], 
          "Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Equations\"\>", 
       2->"\<\"Relational and Logical Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SameQ" :> Documentation`HelpLookup["paclet:ref/SameQ"], 
          "Unequal" :> Documentation`HelpLookup["paclet:ref/Unequal"], 
          "KroneckerDelta" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerDelta"], 
          "PossibleZeroQ" :> 
          Documentation`HelpLookup["paclet:ref/PossibleZeroQ"], "Order" :> 
          Documentation`HelpLookup["paclet:ref/Order"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SameQ\"\>", 2->"\<\"Unequal\"\>", 
       3->"\<\"KroneckerDelta\"\>", 4->"\<\"PossibleZeroQ\"\>", 
       5->"\<\"Order\"\>", 6->"\<\"Element\"\>", 7->"\<\"Reduce\"\>", 
       8->"\<\"Simplify\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Inequalities\"\>", 
       2->"\<\"Logic & Boolean Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Equal ",
 StyleBox["(==)", "OperatorCharacter"]
}], "ObjectName",
 CellID->21244],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "==", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " are identical. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " is used to represent a symbolic equation, to be manipulated using \
functions like ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28666],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " are identical expressions. "
}], "Notes",
 CellID->12070],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " are determined to be unequal by comparisons between numbers or other raw \
data, such as strings. "
}], "Notes",
 CellID->10201],

Cell["\<\
Approximate numbers are considered equal if they differ in at most their last \
eight binary digits (roughly their last two decimal digits). \
\>", "Notes",
 CellID->14149],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"2", "==", "2."}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2023],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["1", "TR"]], "==", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["2", "TR"]], "==", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["3", "TR"]]}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if all the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are equal. "
}], "Notes",
 CellID->5893],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11659],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " internally uses numerical approximations to establish inequality. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2439],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["lhs", "TI"], Cell[BoxData[
     ButtonBox["\\[Equal]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Equal"]], "InlineCharacterName"]}], 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "\[Equal]", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5467],

Cell[TextData[{
 "It can also be input as ",
 Cell[BoxData[
  ButtonBox["\\[LongEqual]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/LongEqual"]], "InlineCharacterName"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "\[LongEqual]", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22324],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " is output as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "\[LongEqual]", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21405]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->902679283],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->30249331],

Cell["Test equality:", "ExampleText",
 CellID->29826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "+", "2"}], "==", "4"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16790],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242357018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11734],

Cell["Represent an equation:", "ExampleText",
 CellID->4897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "==", 
  RowBox[{"1", "+", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22716],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "\[Equal]", 
  RowBox[{"1", "+", "x"}]}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180251061]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27427],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{247, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53334505]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->268522144],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Numeric Equalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->255979190],

Cell["Test equality of numbers:", "ExampleText",
 CellID->234143528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "/", "2"}], "\[Equal]", 
  RowBox[{"5", "/", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241292235],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65905722]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->911958469],

Cell["\<\
Approximate numbers that differ in at most their last eight binary digits are \
considered equal:\
\>", "ExampleText",
 CellID->580861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "\[Equal]", 
  RowBox[{"1.", "+", 
   RowBox[{
    RowBox[{"2", "^", "7"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37738947],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->572201796]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "\[Equal]", 
  RowBox[{"1.", "+", 
   RowBox[{
    RowBox[{"2", "^", "8"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525645198],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->182206885]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->367030270],

Cell["\<\
Compare an exact numeric expression and an approximate number:\
\>", "ExampleText",
 CellID->427000590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "\[Equal]", "Pi"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315310371],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12607112]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "\[Equal]", 
  RowBox[{"Pi", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"2", "^", "8"}], " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "20"}]}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331846797],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64522989]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113001372],

Cell["\<\
Compare two exact numeric expressions; a numeric test may suffice to disprove \
equality:\
\>", "ExampleText",
 CellID->128181167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pi", "^", "E"}], "\[Equal]", 
  RowBox[{"E", "^", "Pi"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398884990],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64139294]
}, Open  ]],

Cell["Proving equality requires symbolic methods:", "ExampleText",
 CellID->207797078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[Equal]", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"5", "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142094998],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177454420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93442946],

Cell[TextData[{
 "Symbolic methods used by ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " are insufficient to prove this equality:"
}], "ExampleText",
 CellID->135341977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[Equal]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "4"}], "-", 
      RowBox[{"10", 
       RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180221533],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "\[Equal]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]], "Output",
 ImageSize->{241, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177753248]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " to decide whether two algebraic numbers are equal:"
}], "ExampleText",
 CellID->299920545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195979928],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->502873373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64927627],

Cell[TextData[{
 "Numeric methods used by ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " do not use sufficient precision to disprove this equality:"
}], "ExampleText",
 CellID->192423184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "4"}], "-", 
       RowBox[{"10", 
        RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], "+", 
   
   RowBox[{"10", "^", 
    RowBox[{"-", "100"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1546846],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "\[Equal]", 
  RowBox[{
   RowBox[{
   "1", "/", 
    "1000000000000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000"}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}]], "Output",
 ImageSize->{557, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579873774]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " proves that the two algebraic numbers are not equal:"
}], "ExampleText",
 CellID->384720156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->476886642],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->632604902]
}, Open  ]],

Cell[TextData[{
 "Increasing ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " may also allow to disprove equality:"
}], "ExampleText",
 CellID->321641904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "4"}], "-", 
         RowBox[{"10", 
          RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], 
     "+", 
     RowBox[{"10", "^", 
      RowBox[{"-", "100"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1018235179],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->99933487]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Equalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->60168754],

Cell["A symbolic identity:", "ExampleText",
 CellID->152622296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[Equal]", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148403671],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->610785588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->262730086],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " does not automatically prove this identity:"
}], "ExampleText",
 CellID->178777735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "\[Equal]", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"2", "x"}], "+", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150821115],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"], "\[Equal]", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305800981]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " to prove it:"
}], "ExampleText",
 CellID->21217920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->128820129],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122849325]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355116091],

Cell["A symbolic equation:", "ExampleText",
 CellID->26754974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "\[Equal]", "b"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486416913],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "\[Equal]", "b"}]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217001568]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to solve the equation:"
}], "ExampleText",
 CellID->58238363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145270882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    FractionBox["b", "a"]}], "}"}], "}"}]], "Output",
 ImageSize->{67, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->294112374]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives all solutions, including the ones that require nongeneric values of \
parameters:"
}], "ExampleText",
 CellID->220870228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->159052583],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     FractionBox["b", "a"]}]}], ")"}]}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22531375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->386542873],

Cell["Compare more than two expressions:", "ExampleText",
 CellID->220377043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3", "\[Equal]", "3.", "\[Equal]", "3.000000"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213227638],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52092953]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y", "+", "z"}], "\[Equal]", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "-", 
   RowBox[{"y", "^", "2"}], "-", 
   RowBox[{"z", "^", "2"}]}], "\[Equal]", 
  RowBox[{"x", " ", "y", " ", "z"}], "\[Equal]", "3"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->534296793],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y", "+", "z"}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["x", "2"], "-", 
   SuperscriptBox["y", "2"], "-", 
   SuperscriptBox["z", "2"]}], "\[Equal]", 
  RowBox[{"x", " ", "y", " ", "z"}], "\[Equal]", "3"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39653857]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20775686],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "1"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SqrtBox["2"]}]}], ")"}]}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SqrtBox["2"]}]}], ")"}]}]}]}], ")"}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"2", "-", "y"}]}]}]], "Output",
 ImageSize->{392, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->202658885]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17154861],

Cell["Compare lists:", "ExampleText",
 CellID->503856903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->632197901],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150660288]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "==", 
  RowBox[{"{", 
   RowBox[{"d", ",", "e"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3372],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261496834]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217094515],

Cell["Compare strings:", "ExampleText",
 CellID->51853218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<abc\>\"", "==", "\"\<ABC\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27021],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5668292]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->961961752],

Cell[TextData[{
 "The negation of two-argument ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14000026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "\[Equal]", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785552779],

Cell[BoxData[
 RowBox[{"x", "\[NotEqual]", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->571659529]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348942315],

Cell[TextData[{
 "The negation of three-argument ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " does not simplify automatically:"
}], "ExampleText",
 CellID->179461278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "\[Equal]", "y", "\[Equal]", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->900203775],

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"x", "\[Equal]", "y", "\[Equal]", "z"}]}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->711654905]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to express it in terms of two-argument ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103307650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->602057068],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[NotEqual]", "x"}], "||", 
  RowBox[{"z", "\[NotEqual]", "x"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144681753]
}, Open  ]],

Cell[TextData[{
 "The negation of three argument ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " is not equivalent to three-argument ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22272967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"x", "\[NotEqual]", "y", "\[NotEqual]", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41719149],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[NotEqual]", "x"}], "&&", 
  RowBox[{"z", "\[NotEqual]", "x"}], "&&", 
  RowBox[{"z", "\[NotEqual]", "y"}]}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->239257555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240481313],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " tests mathematical equality of objects represented by expressions:"
}], "ExampleText",
 CellID->168215740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Equal]", "x"}], ",", 
   RowBox[{"x", "\[Equal]", "y"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "\[Equal]", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}], ",", 
   RowBox[{"Pi", "\[Equal]", 
    RowBox[{"N", "[", "Pi", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284729538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"x", "\[Equal]", "y"}], ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146531912]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " tests syntactic equality of expressions:"
}], "ExampleText",
 CellID->29005565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "===", "x"}], ",", 
   RowBox[{"x", "===", "y"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "===", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}], ",", 
   RowBox[{"Pi", "===", 
    RowBox[{"N", "[", "Pi", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->328203001],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "False", ",", "False"}], "}"}]], "Output",\

 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->362271678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228365763],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " cannot decide whether two numeric expressions are equal it returns \
unchanged:"
}], "ExampleText",
 CellID->294478095],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}], "/", "2"}]}], 
  ";"}], "\n", 
 RowBox[{"a", "\[Equal]", "b"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->174240470],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], "]"}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}]}]], "Output",
 ImageSize->{219, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1048805164]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses exact symbolic transformations to prove the equality:"
}], "ExampleText",
 CellID->631563206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"a", "\[Equal]", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106030961],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->184134442]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PossibleZeroQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PossibleZeroQ"]], "InlineFormula"],
 " uses numeric and symbolic heuristics to decide whether an expression is \
zero:"
}], "ExampleText",
 CellID->157871522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PossibleZeroQ", "[", 
  RowBox[{"a", "-", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13995468],

Cell[BoxData[
 RowBox[{
  RowBox[{"PossibleZeroQ", "::", "\<\"ztest\"\>"}], ":", 
  " ", "\<\"Unable to decide whether numeric quantities \
\\!\\({\\(\\(Log[\\(\\(\\@2 + \\@3\\)\\)]\\)\\) - \\(\\(1\\/2\\\\ \
\\(\\(Log[\\(\\(5 + \\(\\(2\\\\ \\@6\\)\\)\\)\\)]\\)\\)\\)\\)}\\) are equal \
to zero. Assuming they are.\"\>"}]], "Message", "MSG",
 CellID->94297036],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11688149]
}, Open  ]],

Cell[TextData[{
 "Numeric methods used by ",
 Cell[BoxData[
  ButtonBox["PossibleZeroQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PossibleZeroQ"]], "InlineFormula"],
 " may incorrectly decide that a number is zero:"
}], "ExampleText",
 CellID->361325790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PossibleZeroQ", "[", 
  RowBox[{"a", "-", "b", "+", 
   RowBox[{"10", "^", 
    RowBox[{"-", "100"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->70253842],

Cell[BoxData[
 RowBox[{
  RowBox[{"PossibleZeroQ", "::", "\<\"ztest\"\>"}], ":", 
  " ", "\<\"Unable to decide whether numeric quantities \
\\!\\({1\\/\\(10000000000000000000000 \\(\\(\[LeftSkeleton] 54 \
\[RightSkeleton]\\)\\) 000000000000000000000000\\) + \\(\\(Log[\\(\\(\\@2 + \
\\@3\\)\\)]\\)\\) - \\(\\(1\\/2\\\\ \\(\\(Log[\\(\\(5 + \\(\\(2\\\\ \
\\@6\\)\\)\\)\\)]\\)\\)\\)\\)}\\) are equal to zero. Assuming they \
are.\"\>"}]], "Message", "MSG",
 CellID->48677231],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->144619735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396887002],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to solve equations for generic values of parameters:"
}], "ExampleText",
 CellID->78940378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61149386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "b"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
      RowBox[{"2", " ", "a"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{309, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->738858228]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives all solutions, including those with nongeneric parameter values:"
}], "ExampleText",
 CellID->114534204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107957091],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "-", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}], "||", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "+", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]}], 
        RowBox[{"2", " ", "a"}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["c", "b"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"c", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"a", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{369, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->174541389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206622677],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve equations over specified domains:"
}], "ExampleText",
 CellID->107059385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "5"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->821314495],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SqrtBox["5"]}], "\[LessEqual]", "x", "\[LessEqual]", 
   SqrtBox["5"]}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"5", "-", 
        SuperscriptBox["x", "2"]}]]}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     SqrtBox[
      RowBox[{"5", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{306, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->580445202]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "5"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23944515],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "2"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "2"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}]}]], "Output",
 ImageSize->{509, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->199634286]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->274639256],

Cell["\<\
Equality for machine precision approximate numbers can be subtle: \
\>", "ExampleText",
 CellID->61699174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], "\[Equal]", "0.00001"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107589248],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22773094]
}, Open  ]],

Cell["The extra digits disrupt equality:", "ExampleText",
 CellID->454896623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385657575],

Cell["0.000010000000000065512", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->73319984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101622290],

Cell["\<\
Arbitrary precision approximate numbers do not have this problem:\
\>", "ExampleText",
 CellID->29032653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006`16", "-", "2.00005`16"}], "\[Equal]", 
  "0.00001`16"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108479341],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137600071]
}, Open  ]],

Cell[TextData[{
 "Thanks to automatic precision tracking ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " knows to look only at the first ten digits:"
}], "ExampleText",
 CellID->446345418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"2.00006`16", "-", "2.00005`16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501825511],

Cell[BoxData["10.397928065738002`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->372663843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24137272],

Cell["\<\
In this case, the equality test for machine numbers succeeds:\
\>", "ExampleText",
 CellID->693243942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], "\[Equal]", "0.1"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544352754],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39457688]
}, Open  ]],

Cell[TextData[{
 "The extra digits in this case are ignored by ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->153335021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->551042265],

Cell["0.10000000000000009", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->15410061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->296966913],

Cell["Equality may not be transitive for approximate numbers:", "ExampleText",
 CellID->12858],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.", "-", "1.*^-14"}], ",", "1.", ",", 
     RowBox[{"1.", "+", "1.*^-14"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "==", "y"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2780],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->479886419]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "==", "z"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5488],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->224348058]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "==", "z"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18731],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->585119810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54135621],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " is not treated as the Boolean equivalence operator:"
}], "ExampleText",
 CellID->695040232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"p", "||", "q"}], ")"}], "\[Equal]", 
   RowBox[{"(", 
    RowBox[{"q", "||", "p"}], ")"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50196019],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"p", "||", "q"}], ")"}], "\[Equal]", 
  RowBox[{"(", 
   RowBox[{"q", "||", "p"}], ")"}]}]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86772781]
}, Open  ]],

Cell["Define a Boolean equivalence operator:", "ExampleText",
 CellID->272642713],

Cell[BoxData[
 RowBox[{
  RowBox[{"eq", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Implies", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "&&", 
   RowBox[{"Implies", "[", 
    RowBox[{"b", ",", "a"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->218057704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eq", "[", 
   RowBox[{
    RowBox[{"p", "||", "q"}], ",", 
    RowBox[{"q", "||", "p"}]}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->121961107],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->51448965]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25486],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SameQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SameQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unequal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unequal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PossibleZeroQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PossibleZeroQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Order",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Order"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9121]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->693],

Cell[TextData[ButtonBox["Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Equations"]], "Tutorials",
 CellID->2534],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->29329]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->214041317],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->145835098],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->192590109]
}, Open  ]],

Cell["New in 1  |  Last modified in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Equal (==) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 30.4958660}", "context" -> "System`", 
    "keywords" -> {
     "biconditional", "Boolean tests", "delta function", "equal", 
      "equality testing", "equations", "equivalence", "identical expressions",
       "Kronecker delta", "mathematical equivalence", "same expressions", 
      "testing equality"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "lhs == rhs returns True if lhs and rhs are identical. ", 
    "synonyms" -> {"=="}, "title" -> "Equal", "type" -> "Symbol", "uri" -> 
    "ref/Equal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9463, 344, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->902679283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55956, 2286}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2737, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3360, 88, 99, 4, 70, "ObjectName",
 CellID->21244],
Cell[3462, 94, 691, 24, 70, "Usage",
 CellID->31619]
}, Open  ]],
Cell[CellGroupData[{
Cell[4190, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4668, 140, 358, 13, 70, "Notes",
 CellID->28666],
Cell[5029, 155, 444, 18, 70, "Notes",
 CellID->12070],
Cell[5476, 175, 517, 19, 70, "Notes",
 CellID->10201],
Cell[5996, 196, 182, 4, 70, "Notes",
 CellID->14149],
Cell[6181, 202, 235, 10, 70, "Notes",
 CellID->2023],
Cell[6419, 214, 567, 24, 70, "Notes",
 CellID->5893],
Cell[6989, 240, 337, 14, 70, "Notes",
 CellID->11659],
Cell[7329, 256, 477, 14, 70, "Notes",
 CellID->2439],
Cell[7809, 272, 827, 32, 70, "Notes",
 CellID->5467],
Cell[8639, 306, 345, 13, 70, "Notes",
 CellID->22324],
Cell[8987, 321, 439, 18, 70, "Notes",
 CellID->21405]
}, Closed]],
Cell[CellGroupData[{
Cell[9463, 344, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->902679283],
Cell[CellGroupData[{
Cell[9848, 358, 147, 5, 70, "ExampleSection",
 CellID->30249331],
Cell[9998, 365, 53, 1, 70, "ExampleText",
 CellID->29826],
Cell[CellGroupData[{
Cell[10076, 370, 112, 4, 28, "Input",
 CellID->16790],
Cell[10191, 376, 161, 5, 36, "Output",
 CellID->242357018]
}, Open  ]],
Cell[10367, 384, 121, 3, 70, "ExampleDelimiter",
 CellID->11734],
Cell[10491, 389, 60, 1, 70, "ExampleText",
 CellID->4897],
Cell[CellGroupData[{
Cell[10576, 394, 135, 5, 70, "Input",
 CellID->22716],
Cell[10714, 401, 234, 8, 36, "Output",
 CellID->180251061]
}, Open  ]],
Cell[CellGroupData[{
Cell[10985, 414, 120, 4, 70, "Input",
 CellID->27427],
Cell[11108, 420, 561, 21, 51, "Output",
 CellID->53334505]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11718, 447, 221, 7, 70, "ExampleSection",
 CellID->268522144],
Cell[CellGroupData[{
Cell[11964, 458, 239, 7, 70, "ExampleSubsection",
 CellID->255979190],
Cell[12206, 467, 68, 1, 70, "ExampleText",
 CellID->234143528],
Cell[CellGroupData[{
Cell[12299, 472, 145, 5, 70, "Input",
 CellID->241292235],
Cell[12447, 479, 161, 5, 36, "Output",
 CellID->65905722]
}, Open  ]],
Cell[12623, 487, 125, 3, 70, "ExampleDelimiter",
 CellID->911958469],
Cell[12751, 492, 145, 4, 70, "ExampleText",
 CellID->580861],
Cell[CellGroupData[{
Cell[12921, 500, 220, 8, 70, "Input",
 CellID->37738947],
Cell[13144, 510, 161, 5, 36, "Output",
 CellID->572201796]
}, Open  ]],
Cell[CellGroupData[{
Cell[13342, 520, 221, 8, 70, "Input",
 CellID->525645198],
Cell[13566, 530, 162, 5, 36, "Output",
 CellID->182206885]
}, Open  ]],
Cell[13743, 538, 125, 3, 70, "ExampleDelimiter",
 CellID->367030270],
Cell[13871, 543, 113, 3, 70, "ExampleText",
 CellID->427000590],
Cell[CellGroupData[{
Cell[14009, 550, 154, 5, 70, "Input",
 CellID->315310371],
Cell[14166, 557, 160, 5, 36, "Output",
 CellID->12607112]
}, Open  ]],
Cell[CellGroupData[{
Cell[14363, 567, 326, 12, 70, "Input",
 CellID->331846797],
Cell[14692, 581, 161, 5, 36, "Output",
 CellID->64522989]
}, Open  ]],
Cell[14868, 589, 125, 3, 70, "ExampleDelimiter",
 CellID->113001372],
Cell[14996, 594, 140, 4, 70, "ExampleText",
 CellID->128181167],
Cell[CellGroupData[{
Cell[15161, 602, 147, 5, 70, "Input",
 CellID->398884990],
Cell[15311, 609, 161, 5, 36, "Output",
 CellID->64139294]
}, Open  ]],
Cell[15487, 617, 86, 1, 70, "ExampleText",
 CellID->207797078],
Cell[CellGroupData[{
Cell[15598, 622, 295, 10, 70, "Input",
 CellID->142094998],
Cell[15896, 634, 161, 5, 36, "Output",
 CellID->177454420]
}, Open  ]],
Cell[16072, 642, 124, 3, 70, "ExampleDelimiter",
 CellID->93442946],
Cell[16199, 647, 242, 8, 70, "ExampleText",
 CellID->135341977],
Cell[CellGroupData[{
Cell[16466, 659, 379, 14, 70, "Input",
 CellID->180221533],
Cell[16848, 675, 435, 16, 41, "Output",
 CellID->177753248]
}, Open  ]],
Cell[17298, 694, 241, 8, 70, "ExampleText",
 CellID->299920545],
Cell[CellGroupData[{
Cell[17564, 706, 106, 3, 70, "Input",
 CellID->195979928],
Cell[17673, 711, 161, 5, 36, "Output",
 CellID->502873373]
}, Open  ]],
Cell[17849, 719, 124, 3, 70, "ExampleDelimiter",
 CellID->64927627],
Cell[17976, 724, 259, 8, 70, "ExampleText",
 CellID->192423184],
Cell[CellGroupData[{
Cell[18260, 736, 454, 17, 70, "Input",
 CellID->1546846],
Cell[18717, 755, 600, 21, 75, "Output",
 CellID->579873774]
}, Open  ]],
Cell[19332, 779, 234, 7, 70, "ExampleText",
 CellID->384720156],
Cell[CellGroupData[{
Cell[19591, 790, 106, 3, 70, "Input",
 CellID->476886642],
Cell[19700, 795, 162, 5, 36, "Output",
 CellID->632604902]
}, Open  ]],
Cell[19877, 803, 250, 8, 70, "ExampleText",
 CellID->321641904],
Cell[CellGroupData[{
Cell[20152, 815, 609, 21, 70, "Input",
 CellID->1018235179],
Cell[20764, 838, 161, 5, 36, "Output",
 CellID->99933487]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20974, 849, 239, 7, 70, "ExampleSubsection",
 CellID->60168754],
Cell[21216, 858, 63, 1, 70, "ExampleText",
 CellID->152622296],
Cell[CellGroupData[{
Cell[21304, 863, 99, 3, 70, "Input",
 CellID->148403671],
Cell[21406, 868, 161, 5, 36, "Output",
 CellID->610785588]
}, Open  ]],
Cell[21582, 876, 125, 3, 70, "ExampleDelimiter",
 CellID->262730086],
Cell[21710, 881, 215, 7, 70, "ExampleText",
 CellID->178777735],
Cell[CellGroupData[{
Cell[21950, 892, 247, 9, 70, "Input",
 CellID->150821115],
Cell[22200, 903, 343, 12, 36, "Output",
 CellID->305800981]
}, Open  ]],
Cell[22558, 918, 194, 8, 70, "ExampleText",
 CellID->21217920],
Cell[CellGroupData[{
Cell[22777, 930, 102, 3, 70, "Input",
 CellID->128820129],
Cell[22882, 935, 161, 5, 36, "Output",
 CellID->122849325]
}, Open  ]],
Cell[23058, 943, 125, 3, 70, "ExampleDelimiter",
 CellID->355116091],
Cell[23186, 948, 62, 1, 70, "ExampleText",
 CellID->26754974],
Cell[CellGroupData[{
Cell[23273, 953, 122, 4, 70, "Input",
 CellID->486416913],
Cell[23398, 959, 210, 7, 36, "Output",
 CellID->217001568]
}, Open  ]],
Cell[23623, 969, 202, 8, 70, "ExampleText",
 CellID->58238363],
Cell[CellGroupData[{
Cell[23850, 981, 124, 4, 70, "Input",
 CellID->145270882],
Cell[23977, 987, 256, 9, 51, "Output",
 CellID->294112374]
}, Open  ]],
Cell[24248, 999, 261, 8, 70, "ExampleText",
 CellID->220870228],
Cell[CellGroupData[{
Cell[24534, 1011, 126, 4, 70, "Input",
 CellID->159052583],
Cell[24663, 1017, 432, 15, 51, "Output",
 CellID->22531375]
}, Open  ]],
Cell[25110, 1035, 125, 3, 70, "ExampleDelimiter",
 CellID->386542873],
Cell[25238, 1040, 77, 1, 70, "ExampleText",
 CellID->220377043],
Cell[CellGroupData[{
Cell[25340, 1045, 124, 3, 70, "Input",
 CellID->213227638],
Cell[25467, 1050, 160, 5, 36, "Output",
 CellID->52092953]
}, Open  ]],
Cell[CellGroupData[{
Cell[25664, 1060, 304, 9, 70, "Input",
 CellID->534296793],
Cell[25971, 1071, 395, 12, 36, "Output",
 CellID->39653857]
}, Open  ]],
Cell[CellGroupData[{
Cell[26403, 1088, 183, 6, 70, "Input",
 CellID->20775686],
Cell[26589, 1096, 741, 25, 51, "Output",
 CellID->202658885]
}, Open  ]],
Cell[27345, 1124, 124, 3, 70, "ExampleDelimiter",
 CellID->17154861],
Cell[27472, 1129, 57, 1, 70, "ExampleText",
 CellID->503856903],
Cell[CellGroupData[{
Cell[27554, 1134, 193, 7, 70, "Input",
 CellID->632197901],
Cell[27750, 1143, 161, 5, 36, "Output",
 CellID->150660288]
}, Open  ]],
Cell[CellGroupData[{
Cell[27948, 1153, 192, 7, 70, "Input",
 CellID->3372],
Cell[28143, 1162, 162, 5, 36, "Output",
 CellID->261496834]
}, Open  ]],
Cell[28320, 1170, 125, 3, 70, "ExampleDelimiter",
 CellID->217094515],
Cell[28448, 1175, 58, 1, 70, "ExampleText",
 CellID->51853218],
Cell[CellGroupData[{
Cell[28531, 1180, 109, 3, 70, "Input",
 CellID->27021],
Cell[28643, 1185, 160, 5, 36, "Output",
 CellID->5668292]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28864, 1197, 237, 7, 70, "ExampleSection",
 CellID->961961752],
Cell[29104, 1206, 331, 13, 70, "ExampleText",
 CellID->14000026],
Cell[CellGroupData[{
Cell[29460, 1223, 129, 4, 70, "Input",
 CellID->785552779],
Cell[29592, 1229, 190, 6, 36, "Output",
 CellID->571659529]
}, Open  ]],
Cell[29797, 1238, 125, 3, 70, "ExampleDelimiter",
 CellID->348942315],
Cell[29925, 1243, 240, 8, 70, "ExampleText",
 CellID->179461278],
Cell[CellGroupData[{
Cell[30190, 1255, 146, 4, 70, "Input",
 CellID->900203775],
Cell[30339, 1261, 222, 7, 36, "Output",
 CellID->711654905]
}, Open  ]],
Cell[30576, 1271, 359, 13, 70, "ExampleText",
 CellID->103307650],
Cell[CellGroupData[{
Cell[30960, 1288, 109, 3, 70, "Input",
 CellID->602057068],
Cell[31072, 1293, 247, 8, 36, "Output",
 CellID->144681753]
}, Open  ]],
Cell[31334, 1304, 366, 13, 70, "ExampleText",
 CellID->22272967],
Cell[CellGroupData[{
Cell[31725, 1321, 161, 4, 70, "Input",
 CellID->41719149],
Cell[31889, 1327, 292, 9, 36, "Output",
 CellID->239257555]
}, Open  ]],
Cell[32196, 1339, 125, 3, 70, "ExampleDelimiter",
 CellID->240481313],
Cell[32324, 1344, 238, 7, 70, "ExampleText",
 CellID->168215740],
Cell[CellGroupData[{
Cell[32587, 1355, 501, 16, 70, "Input",
 CellID->284729538],
Cell[33091, 1373, 267, 9, 36, "Output",
 CellID->146531912]
}, Open  ]],
Cell[33373, 1385, 211, 7, 70, "ExampleText",
 CellID->29005565],
Cell[CellGroupData[{
Cell[33609, 1396, 481, 16, 70, "Input",
 CellID->328203001],
Cell[34093, 1414, 241, 8, 36, "Output",
 CellID->362271678]
}, Open  ]],
Cell[34349, 1425, 125, 3, 70, "ExampleDelimiter",
 CellID->228365763],
Cell[34477, 1430, 261, 9, 70, "ExampleText",
 CellID->294478095],
Cell[CellGroupData[{
Cell[34763, 1443, 470, 17, 70, "Input",
 CellID->174240470],
Cell[35236, 1462, 414, 16, 51, "Output",
 CellID->1048805164]
}, Open  ]],
Cell[35665, 1481, 244, 7, 70, "ExampleText",
 CellID->631563206],
Cell[CellGroupData[{
Cell[35934, 1492, 138, 4, 70, "Input",
 CellID->106030961],
Cell[36075, 1498, 161, 5, 36, "Output",
 CellID->184134442]
}, Open  ]],
Cell[36251, 1506, 267, 8, 70, "ExampleText",
 CellID->157871522],
Cell[CellGroupData[{
Cell[36543, 1518, 131, 4, 70, "Input",
 CellID->13995468],
Cell[36677, 1524, 359, 7, 70, "Message",
 CellID->94297036],
Cell[37039, 1533, 160, 5, 36, "Output",
 CellID->11688149]
}, Open  ]],
Cell[37214, 1541, 262, 8, 70, "ExampleText",
 CellID->361325790],
Cell[CellGroupData[{
Cell[37501, 1553, 188, 6, 70, "Input",
 CellID->70253842],
Cell[37692, 1561, 472, 9, 70, "Message",
 CellID->48677231],
Cell[38167, 1572, 161, 5, 36, "Output",
 CellID->144619735]
}, Open  ]],
Cell[38343, 1580, 125, 3, 70, "ExampleDelimiter",
 CellID->396887002],
Cell[38471, 1585, 232, 8, 70, "ExampleText",
 CellID->78940378],
Cell[CellGroupData[{
Cell[38728, 1597, 271, 10, 70, "Input",
 CellID->61149386],
Cell[39002, 1609, 750, 27, 62, "Output",
 CellID->738858228]
}, Open  ]],
Cell[39767, 1639, 244, 7, 70, "ExampleText",
 CellID->114534204],
Cell[CellGroupData[{
Cell[40036, 1650, 273, 10, 70, "Input",
 CellID->107957091],
Cell[40312, 1662, 1223, 41, 100, "Output",
 CellID->174541389]
}, Open  ]],
Cell[41550, 1706, 125, 3, 70, "ExampleDelimiter",
 CellID->206622677],
Cell[41678, 1711, 225, 8, 70, "ExampleText",
 CellID->107059385],
Cell[CellGroupData[{
Cell[41928, 1723, 296, 10, 70, "Input",
 CellID->821314495],
Cell[42227, 1735, 561, 21, 52, "Output",
 CellID->580445202]
}, Open  ]],
Cell[CellGroupData[{
Cell[42825, 1761, 298, 10, 70, "Input",
 CellID->23944515],
Cell[43126, 1773, 1312, 46, 54, "Output",
 CellID->199634286]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44487, 1825, 230, 7, 70, "ExampleSection",
 CellID->274639256],
Cell[44720, 1834, 116, 3, 70, "ExampleText",
 CellID->61699174],
Cell[CellGroupData[{
Cell[44861, 1841, 140, 4, 70, "Input",
 CellID->107589248],
Cell[45004, 1847, 161, 5, 36, "Output",
 CellID->22773094]
}, Open  ]],
Cell[45180, 1855, 77, 1, 70, "ExampleText",
 CellID->454896623],
Cell[CellGroupData[{
Cell[45282, 1860, 136, 4, 70, "Input",
 CellID->385657575],
Cell[45421, 1866, 182, 5, 50, "Output",
 CellID->73319984]
}, Open  ]],
Cell[45618, 1874, 125, 3, 70, "ExampleDelimiter",
 CellID->101622290],
Cell[45746, 1879, 115, 3, 70, "ExampleText",
 CellID->29032653],
Cell[CellGroupData[{
Cell[45886, 1886, 152, 5, 70, "Input",
 CellID->108479341],
Cell[46041, 1893, 161, 5, 36, "Output",
 CellID->137600071]
}, Open  ]],
Cell[46217, 1901, 259, 8, 70, "ExampleText",
 CellID->446345418],
Cell[CellGroupData[{
Cell[46501, 1913, 146, 4, 70, "Input",
 CellID->501825511],
Cell[46650, 1919, 176, 5, 36, "Output",
 CellID->372663843]
}, Open  ]],
Cell[46841, 1927, 124, 3, 70, "ExampleDelimiter",
 CellID->24137272],
Cell[46968, 1932, 112, 3, 70, "ExampleText",
 CellID->693243942],
Cell[CellGroupData[{
Cell[47105, 1939, 128, 4, 70, "Input",
 CellID->544352754],
Cell[47236, 1945, 160, 5, 36, "Output",
 CellID->39457688]
}, Open  ]],
Cell[47411, 1953, 222, 8, 70, "ExampleText",
 CellID->153335021],
Cell[CellGroupData[{
Cell[47658, 1965, 128, 4, 70, "Input",
 CellID->551042265],
Cell[47789, 1971, 178, 5, 50, "Output",
 CellID->15410061]
}, Open  ]],
Cell[47982, 1979, 125, 3, 70, "ExampleDelimiter",
 CellID->296966913],
Cell[48110, 1984, 94, 1, 70, "ExampleText",
 CellID->12858],
Cell[48207, 1987, 291, 10, 70, "Input",
 CellID->19437],
Cell[CellGroupData[{
Cell[48523, 2001, 88, 3, 70, "Input",
 CellID->2780],
Cell[48614, 2006, 161, 5, 36, "Output",
 CellID->479886419]
}, Open  ]],
Cell[CellGroupData[{
Cell[48812, 2016, 88, 3, 70, "Input",
 CellID->5488],
Cell[48903, 2021, 161, 5, 36, "Output",
 CellID->224348058]
}, Open  ]],
Cell[CellGroupData[{
Cell[49101, 2031, 89, 3, 70, "Input",
 CellID->18731],
Cell[49193, 2036, 162, 5, 36, "Output",
 CellID->585119810]
}, Open  ]],
Cell[49370, 2044, 124, 3, 70, "ExampleDelimiter",
 CellID->54135621],
Cell[49497, 2049, 223, 7, 70, "ExampleText",
 CellID->695040232],
Cell[CellGroupData[{
Cell[49745, 2060, 233, 8, 70, "Input",
 CellID->50196019],
Cell[49981, 2070, 283, 10, 36, "Output",
 CellID->86772781]
}, Open  ]],
Cell[50279, 2083, 81, 1, 70, "ExampleText",
 CellID->272642713],
Cell[50363, 2086, 292, 10, 70, "Input",
 CellID->218057704],
Cell[CellGroupData[{
Cell[50680, 2100, 209, 7, 70, "Input",
 CellID->121961107],
Cell[50892, 2109, 160, 5, 36, "Output",
 CellID->51448965]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51113, 2121, 311, 9, 70, "SeeAlsoSection",
 CellID->25486],
Cell[51427, 2132, 1922, 71, 70, "SeeAlso",
 CellID->9121]
}, Open  ]],
Cell[CellGroupData[{
Cell[53386, 2208, 312, 9, 70, "TutorialsSection",
 CellID->693],
Cell[53701, 2219, 128, 3, 70, "Tutorials",
 CellID->2534],
Cell[53832, 2224, 172, 3, 70, "Tutorials",
 CellID->29329]
}, Open  ]],
Cell[CellGroupData[{
Cell[54041, 2232, 319, 9, 70, "MoreAboutSection",
 CellID->214041317],
Cell[54363, 2243, 136, 3, 70, "MoreAbout",
 CellID->145835098],
Cell[54502, 2248, 157, 3, 70, "MoreAbout",
 CellID->192590109]
}, Open  ]],
Cell[54674, 2254, 52, 0, 70, "History"],
Cell[54729, 2256, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

