(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47851,       1568]
NotebookOptionsPosition[     40644,       1319]
NotebookOutlinePosition[     41935,       1356]
CellTagsIndexPosition[     41849,       1351]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BernoulliB" :> 
          Documentation`HelpLookup["paclet:ref/BernoulliB"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"BernoulliB\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/RecurrenceAndSumFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Recurrence and Sum Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EulerE", "ObjectName",
 CellID->2628],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EulerE",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EulerE"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Euler number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["E", "n"], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EulerE",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EulerE"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Euler polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["E", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4601]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The Euler polynomials satisfy the generating function relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", 
     RowBox[{
      SuperscriptBox["e", 
       RowBox[{"x", "t"}]], "/", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["e", "t"], "+", "1"}], ")"}]}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{
       SubscriptBox["E", "n"], "(", "x", ")"}], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["t", "n"], "/", 
        RowBox[{"n", "!"}]}], ")"}]}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29569],

Cell[TextData[{
 "The Euler numbers are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["E", "n"], "=", 
    RowBox[{
     SuperscriptBox["2", "n"], 
     RowBox[{
      SubscriptBox["E", "n"], "(", 
      FractionBox["1", "2"], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18529],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerE"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->584372998],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->42010865],

Cell[TextData[{
 "First ten ",
 Cell[BoxData[
  ButtonBox["EulerE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerE"]], "InlineFormula"],
 " numbers:"
}], "ExampleText",
 CellID->76111887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerE", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "5", ",", "0", ",", 
   RowBox[{"-", "61"}], ",", "0", ",", "1385", ",", "0", ",", 
   RowBox[{"-", "50521"}]}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13624052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->660433419],

Cell["Euler polynomials:", "ExampleText",
 CellID->83671587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"EulerE", "[", 
     RowBox[{"n", ",", "z"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501507449],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", "z"}], ",", 
   RowBox[{
    RowBox[{"-", "z"}], "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{
    FractionBox["1", "4"], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["z", "2"]}], "2"], "+", 
    SuperscriptBox["z", "3"]}], ",", 
   RowBox[{"z", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "2"]}], "2"], "-", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "4"]}], "2"], "+", 
    SuperscriptBox["z", "5"]}]}], "}"}]], "Output",
 ImageSize->{425, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132308054]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "myRawData",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27528],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerE"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerE", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "5", ",", 
   RowBox[{"-", "61"}]}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41821683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78130],

Cell["Plot Euler polynomials:", "ExampleText",
 CellID->204550622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"EulerE", "[", 
       RowBox[{"k", ",", " ", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->661580562],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmn9wFdUVx9e371d+4w9U/FF1bK0/arXW1k6nqJVWylCLjkVRdCrYOtFW
rJo6LY6Kv1A0IAJKImkQEwKJUZ8GUsGIIZQQSkxshihCphA0DTJQBjAMwcy8
fu49u/t29+0jgVb7TzMvO/vj3nPP+Z7vOefeu3vNpKLC39w9qejO2yedOfq+
Sb8vvPP2+8+8+p77uGUeYxhGN/+PnWxwnuRM/5+UTCYNU53pP2OdOhiD3O1p
+4SfYepD3+4+q9Vqp1WIRkZk8fUlicIldVNq+VWMW2CYpSNnhzg3wmuKV7VX
bqD7rs07V6ZkR+nVt3tfR01j1fjHV0wt397yUVhJU+NkdSY61pespXvt5MUI
ShRWN0z7S2v5OvVweUpGlqM1f1ubOuqLShHWXtmAYCOuW+zY2NvV8DFdESaS
mues5k7//oNGItB+Ux0i+3p3ry9ZVjHu4cbpS3Zs3GbkqLsxpHXUtKHLwjHz
EYWO3DFe82AR0/031a9PFM6unVzMyUD/F0au3R8s6El/pGyq7wRRo1r3j1n9
ZXy3ZQrgqE9LbV1k1+ZP0Q8t1xS/uqf7MyNPj4JtWNg4fSWOwGxGUdZWaUla
TjglJ11y2HedrUfq33+gM7G2euJTYNzV0GYUaB/iD4bBmBVT6xhyoH+gQoSa
ltr8CT/kOmWPGiVsP3CNpi2IQIaGaa9gFz7AEzJaZGtTF6BhFGMq3BdlsMht
gY2duhQpcAOGOKSzLAEhcMIz1RNfgX1clmeQHrH85MftOEtHLwtlzD3d/yIM
0Jzjvt69RtkRyj7By0mwUZwU2YCOwlXjy/GBio+XPGyKDeJdzf4IHoWteBcf
42mRHAZvCUFcW+Lh+CmWVZ/BO4kRmGjpQ5jjJfRBK3QzXgiMslM16kQG8UGU
MLoESr5l6V6QQgbRprg7N1DG13RbkJAYaJ6TUFzJt7zcR6AjgdBXEp4PlHCm
zW1JQ3hOMSLfunuQviJB2fGcB4Gv2zwVb9Nf4Zbn7Yn2qufMwLG/YfsUvVN5
RksIO9qDfHFg72+68HNcx2Wu3R8f4DkI8Uxg//O9HrTyh/TGg/gdOkFb6bdn
d3fP9jZ+Rr46mANf9FtyxunnG3dsbuvp5GeE1cHc3/+5m28OahfaeEsuqZvy
gsoluTbbiD3MRnnh/769vYy2/R8thtm6ttyIrEhMraueIr+y2aOMcGnxSMOs
Lp8ot4x8dTB5wn31KKQOkYVzxzi9kGCElKxw5wcJsQhTvqdH697zKbo3bf2b
ESpvrTGn1D1qmOMq7hhZegM/I6QOZmHiQe6rR2H9nA4eOz053JWBzIBMd5HG
oqdtiyfT6ToTXvNSXeUNpcueLGlZVRJCb22JWbVgPOf1rxVZeGzd0iQ2iBlW
VPYf3O/cpYXYG13zTrEDHMIARctVz0wQpq3qrFmdg/cwLNG5EhymrngWS0eV
TcT+idX3cs4dQUh7enffHsueYYfJaW4s/Dh8J+nJylZ9CUku+WwzJqBkw7Jp
yrkahyhny6seePOh+RUT5rXXvYvu39UyHcvF5iyQoqlYywkQcBtj4ZVxsuqR
17tvZ8v2doyZ1jBbzByzcBInxWsWcBMuYGP/wCHjtOTQqtpgtfQSjS/RhBar
ap6pfPrWBY+NRcGahbdBTbTr+qhB6a8Fhwm/+qIEP05+qHuKhXCXplgHIXAn
pjW/N0cILbkrh3is3/TenOaXxajxVb8tqp+ORQ1day2Lzs7gLX+9UCabduTm
gxwarm8qEVwJPbRAF5zU/eEGpzhB6iwteXvLNpIQ0yTS4OVaM3iKmh2tNUJI
ESK2cx/7BORsolEsIOSgHsfpjS/WdCwX9c87Au3d1+eqQ5boIBBWzB8HitCr
fX2lwk/mVTCQ3JSqh1puGCOYvZGVMWuUupOLJ4WftUt/9/i8n9/30vhbX550
ddktNy6+S9TFERdl0DV82EhxojGr7/PdYA5cta9MFm8Li7lvVSp/FhdtSaPC
Horpldp7xCqUBtPJtQ/AcyhRsrZ82bqKVe/OSiwuRDZ4CAzf9mSzaDJ4VqKr
ZxyfiX44EjSBEioSuMOTVoWSXO9U+KjNDLI9cAKq5nYc7aAnkUeaIe+SZsBv
866tun0cn2GzwzxBAU11HXPqi54RxFXF0H/EvagjOiuwZb7jnzN45t3QVSqn
EnF6Mj2jq1N1T9fqONlSUBW9ySRkTugbD+ipc5Oe/oI2rCcOoNAIK8ZCAWOY
jn3uJyP0yEQjtiFGFUPDQBiwB2Rc3ToqsxwuybDMUh0GklzUOk2txvpOHQJL
4+L1gUNkzpL1VcIl8RZW5wRLyHHfIWRIWNCFyIM3XKrqdWJQ7HokhQKx0P3i
O/65MUBmOqb+jKxrplqLMpVjQaBg1FO5kMUXw2Qaa7U9eagxHAMI4CDASL4c
K9vfgMjWrPrw/bXVMbdnOXKuatbxR4mQ7hcFksa3pxOhxLrwLn10f/7UzClw
t/BMVm2GMeFlus7iCS4NCSWtZxQCEe4UJyKH+OHy+EA8QzbrlA04FxfjaOIf
G4YdASZKzrEuLEgPgLtpYz2pNDY0LLLcLTi6J+A6XvVoYVanpBBZOJwYiIep
pwtkCiJHSMI505Hg1t47ekUexXggEMZDfUI/7yj5kReECWk9ewi6ZMgY2aoO
6T+pSRqqAQABFsAZntZLeE91hwhcQgqoQV5Vc5URQ9BDbCBKoDaF0uFH9lFi
IhiTVeAbMeNgkp/01kS7Pmi2ZHPiVDvmENwjIogLooMYOcFqa8SodcxuKBUy
3ZTUqflzmk/+sV5f88NAzIz62gXXiZirNzQh8kklsP0nSZ0zN25zrz1IdJRk
CrPeyVA5jLzFxIuixmSG2kylM66wJUI5kQgupNphnijTWTAKXAzneAOtx6j7
qbk+o2955+9GiEmKe29R15AoGVOKKj/qDDOpq3VvfCJ5jCPnMgdKs1zWD8wE
mADQFi+q2qhXq1E8Qw3ES399rn7pTYs21Xfq7BLDPqzEViymrFleGWvbgqGY
i9HMkbAlJzVuXMYFWB7RgHkUUyJQuV7QkvnZLx5ZOqE0UbgESgjbYYEkAFgA
F2AEd4zrtOYMwGTHkWVkpUZTcxRs5xktVF2YoLknqaj6ltllo2a9/mDl0vY6
8Z3E0QQXHiphNFUeOHBAZnS6PmzwckhVxN6d+0qWrh93V8X0ksaNW3b4K6d/
NujPl4NdH2l/3X6Yc01iwFkSQk725OknG7YtubFs0diZb92tNhf8Wv+nWhxV
/2znWil+aKB+9abChxMTi6o5sXNHwI620yzR0Lm/r19mt/71gV8XK7dIWQEe
K271syjz7SU3lS+7t9wJ+pxBZOqVb6S7Z0/xn9c4VEibVUVSFqTtpEvf8fdU
ceTc0DlARbc7u8BQ2WGXfNnwyPLW8hWyG6DmqtdoSQ3NXR48cp1RndVJlPs8
pQ0twQ+w9UotNdcgsCWb6IwVJ/hJel0NH8v8z9nKG61HdEJg2twGZXdBoJ2y
ZuQ56KQwGpm0coqT6VM01fu5WbJLR/LjxL0PqGrnKNviohn1YFf5ZvvuPX1S
DTLUKiz3EeaypCePo0Eqj8tshmTPchZWJO2pjLNSMy5PQ6Dlg+2iefAMIo0l
emcnRqDiXWeiJ+ALl9WKmtUWDt+1eadkbGdlZu2H/UDbhht9UJzo8f0wu5WD
QE19B60u0Bo4XCMiiAvLB3oHxJqpyQ6FaODeiVLcu1Tf3bxtl9hm4TAiEIfj
bBzmVDRL26YNW2Wn11PzHRIaeifDxANSemVmE3HIaL1F0OvxKAZhFsZN/lOt
ePjUQC2G29yZOmsFWuA/FXeyNpbVqrPKdgih93fC+3r3QsfG6SthpGjifueg
9sbP98rGTkd2mh4n2VrjMrQWr0AoqZnpK0hZN8tensQlUxKJ64jU7BQisv+O
J+DamF8vtJA+y8MKeccg3oA4EAPUUGeYCwnZYXIv0zTjws6SBmZGXUiggbX4
OUNLh+fCC8gJ+fCJ7KwFrf7V1M80jLQ16OleSVOeqBNJuubHfbs2stKGOpe7
+Ns8ZzUKSwZ0liTOy8cRGXA4R+uUvvLx7x/49dX7PtG2D3sEe5gg+ur4iTOH
B0jUJN7d+zh6zml21LRZfg1+g3mCrWt5baubM+dl0NVff/37NNobWZXvNBc+
XXXVbaWj73l+5EP3Fy59At6BqsoDuh6p3TLxN4CKZv63FAW21aAomqEiin4r
g2b+mYBCx7RWDEaB7LEDFBHobHESlsTAWy3vi6MYgthVmXSs7WsUlOjU3Eh7
e2DNY/v6CVBCAudAJgBUMXrREeiZFsU58mqkvLUGfd075eBIVlOZTMuJMRLR
DsUkKNFDVWrBWGJa9vxEf/dKQGUX05aBzmjukXFJBv3T14J+vua7EHdebBDv
zosNeavBTUyx9scL0pDEJhyuvDHazhCUDQza2tSl5y5xWPLG/aVP3TzzwYde
/eXdi3EffoQw3/dkBHvF5kSZ580ZGqAHP/2OxYjKiwl+wI2mHEPqzVNE3lCQ
QC199T5WDO3QEU1H/aqMhIQnlL4/TVq5fcXUuroptXZGyyYFkDTRkXqCgX94
8q3iP1bMv/ZRSXCXeXJpRL/vwvlu7cLyPoEf4OpskkUNJilDW5QYeXMpTkQh
7qjZy1WqRW5P2ydkLGEx2pGKSCNgReYjk+B4Sq3pzWTO3vGljk5u/+qMnQXQ
DIXVCCJ4kMUlNxV3fqRbIJhEhb0P31k168rnH5v48sz5jdxR0SFfOfhnH5cE
jqel5ZCUQI8xhKiSuDEcg6xRL9a8QzrXuAIzBRTg5hxLue+8U7DeFefaucfz
NuziQD1+rPUAWZFP9RBVcD4nIIFy3DdCPNeVMQ+tOBe1pTlIoRHwi/KgoRgT
sxkub6EJXHnT4HyXYVXhCz0c+ZnofmiAMXA5YyDRCCE5xBhGmLE4l4FMnhom
rWjLjwTDwRTN1KOQOuRig/TAKkRIPhPPCsw4ocDO31DKrSv6eWYuFwRieK2+
RoylR1jr5Yxr5KiDKUM6eoUdvQF0hB1dzvjyHYQzY7G+DTg3cPwZSZlbWL2t
bybsryC8a4JzAiU8a0uQLyZgk/reId8VQe63L2d7PDbLQqqPTEZfjup7pILA
WDjLk8WCv1Lyv8F6zmLzQbSS73ZIPpZ8P8fPyJDfB6vwc7Q0YCerUB45UQgW
ePnaWv624utpGcawv0byV455FhK98jEVCKf0Rx5SU/w65TCy/e+/1eWL2kNg
g89RnUJCCgB+N3uczzrE6xnmaqEA5Eu1dFbTRDCak/nlM7DgN4bDj1C6/n4p
SuETXFjFyid1eZZNB3zv/I7zcGewt7T6y6sYXkSofGvHogRw1JdTeV5uWvp7
dx/1N2gxVlOSvfihJrIUt3Ns7nm+ZgveQ1ysDnFGBTr58AwnIQqHQYlsL8Os
jJgTKEl/4ZeNN5Ak00zfV43Ii9qs8nzjlRUo73V18HzbKCLLRs3jXG2nhrht
xOXDS34bylbV3Dp78fUzmue+ba8UHLz0F5UmeNNQrUF1X1M+wFSvBvV3nOYb
d1RVXjf//UVrjGigTkP6mjTtrhq/xcOOoDetfv6tO1ysHXYu+FX1VB0P1yPo
i6BM7f3tgjVzR1coo/5ezP/bPvw/J1Ies3UcjAlfrm4ZVx1foRe/DFZk+l4i
2L4s3930t4DB6H25/VSDxitGlhomqzjrSfh/ou/QWNKddjSO+TebtXIg\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->416515131]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5265058],

Cell["Simple exact values are generated automatically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"EulerE", "[", 
   RowBox[{"n", ",", 
    FractionBox["1", "2"]}], "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{"-", "n"}]], " ", 
  RowBox[{"EulerE", "[", "n", "]"}]}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191370209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->238069966],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->270110659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EulerE", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388322017],

Cell[BoxData[
 FormBox[
  SubscriptBox[
   TagBox["E",
    EulerE], "n"], TraditionalForm]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->14428502]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EulerE", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->196941614],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    TagBox["E",
     EulerE], "n"], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{30, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->15065784]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12586],

Cell["Implement the Boole summation formula:", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"BooleSummation", "[", 
   RowBox[{"f_", ",", 
    RowBox[{"{", 
     RowBox[{"k_", ",", "0", ",", "n_"}], "}"}], ",", "m_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"j", "=", "0"}], 
     RowBox[{"m", "-", "1"}]], 
    RowBox[{
     FractionBox[
      RowBox[{"EulerE", "[", 
       RowBox[{"j", ",", "0"}], "]"}], 
      RowBox[{"j", "!"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"{", 
             RowBox[{"k", ",", "j"}], "}"}]], "f"}], "/.", 
          "\[InvisibleSpace]", 
          RowBox[{"k", "\[Rule]", 
           RowBox[{"n", "+", "1"}]}]}], ")"}]}], "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[PartialD]", 
           RowBox[{"{", 
            RowBox[{"k", ",", "j"}], "}"}]], "f"}], "/.", "\[InvisibleSpace]",
          
         RowBox[{"k", "\[Rule]", "0"}]}], ")"}]}], ")"}]}]}]}]}]], "Input",
 GeneratedCell->False,
 CellLabel->"In[1]:="],

Cell[TextData[{
 "First a sequence of approximations to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "n"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "k"], 
     SuperscriptBox["k", "3"]}]}], TraditionalForm]],
  GeneratedCell->False],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BooleSummation", "[", 
     RowBox[{
      RowBox[{"k", "^", "3"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"k", ",", " ", "0", ",", " ", "n"}], "}"}], ",", " ", "m"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "5"}], "}"}]}], "]"}], "//", "FullSimplify"}]], "Input",\

 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0tPFEEQHnZ2kV1kkYUoPlnkioo3EyHxBBcfF/Fx3BADCzEaxJO/RYmJ
ikcT74KJ/iH03k6/YPabGqp7dxyG1U2Ynuru6np0dXV31XCvtbX27Hlrq73S
ai5ttl6utVdeNRdfbEZV4UAQDPwIgmB+MojeRfSm/uTvZ/SnX/XbcPQMo8Y9
U/5StTX5rFgcoeqC4BtZu58DxpeoLEXlHZLnr7I2PMAJFo4Yfxj6zgO8DHAZ
4IbTqAsAP2RGHfSQoMZI8JihNeY0KkrwiBm1QkpgZ4rTOsdzI2WcbLg8D7WT
AI8yMMc9wr70zmQiJVJBeAzgEYCfMlRDodcoJx3SqQP8xFObtHSl6CGNHFfW
KYBrph+OejqlH+LL8SVYMaUeyP7QXodMr5DsPeQp+bkUmSkeXWTGGa8WUGZ6
tjl/ihLg7HKzjzCOp1ZcwqfStThWFeCQxMJelJ7k6uM0w9kGpxm0EZzt4mkG
vaHaewzW7u6uscOyfEg4BYvSN7U27Brk8FHWNLxKvN5Rj7UYzqBdcN56G+1R
Q5ZztDBXDaGlWbw0OvlrCCW7LfrNN/ngctq6wrSfJM+UpV5o/1REKyqb1Sz3
mRK04/1B8Vc+hLV2KEykdBLs5ng00d1ZCG8PvVoG3k6sHvT2rH/xk2lg/Cv2
QT35zruvXNw85yVXd7OItybkPgS4JGgb42YbtSq1JsE4fesRSwG/i3OzmJVc
yAeOk7Vc9Czi3ddyOwH1VVNPjtrhK6j7qsQcN/zj/DVMu7pVJ/Yi9I3NzPnF
+5zFzIZft/jNTVaLNxz0cNRsY/8kRdTD9R4p0pLbcyz6nDmh9yjkAuWedtL6
GEMFTzgoqxsVWkK0Fy6SeC0GSypNgDk9o+VzEcfZHunRkV+U+g3AaD1Tnv3R
69JU9wDujMJzvfcz7zVs6H835W9VKztgVuPwza6QdaH9z44p3x20Ji1zA6jv
APz2gJt47ZrQd8kPptQU7AkB53mVpPyRrN1WJe6E6NPUiB0+6FOihh4JvcRq
DA6MzuIwPQp9h253NZaNLG4Y7X02Jd0b1yxGlNHaLwCMM4n7CRePv8jQmxVJ
6Y6TXkhqcZyhilxdAtieTFAaLt5/maGDu0k5ZzplUlsNgG2s3DWKhauXjo4j
VdyBzxLtLtmMNC7KTly45glsZM5tVOS5n2VTp4LE2QBXIPolzra4yAjtoRHL
rmPMLvnGDThu6GhZnlG9tBzKvyu5CWOYQj71ucU9C5AWpfe13fj64vmf6JJL
3yyNX+6h14wGnhkHnajU/+uiw3sX1c/OeOq3GF6mOyp49upnWbXNcefFv2Fz
VFwU4TyszoUP37mgvhNxoZOH5RVJ3nysb0Qk8x64f2RtaXUHmpyW0fOXHMbM
2oKOSw7aMnAkvGG65l9wf0Y8vM3ZrwWbjKTd5n8QD8/09r6NsWuUX0UJEj4f
52eqL6RQWGx0bUi45oKqnTWCvl2h5WDG0DP3lKDHZVZRV1Y++80xamm64Pwp
20vM4myCG4x33WJ7vGZ7LJK0pUTS+K4KnS+ag/a6aZ8x7Zilusu001TRruLf
4AdGf/H2ZWh/wLQvOVHF/yfAKCV+y32fadeypmUV2gBj5mJbYeMOVTwsm+lZ
F53x//eqVXbU2Z1g4A93tVdd\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{452, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->535904634]
}, Open  ]],

Cell["The sequence converges to the exact answer:", "ExampleText",
 CellID->862042073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"n", "\[Rule]", "10"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11101836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1331", "2"], ",", 
   FractionBox["2299", "4"], ",", 
   FractionBox["2299", "4"], ",", "575", ",", "575"}], "}"}]], "Output",
 ImageSize->{202, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->77648673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Plot roots of Euler polynomials in the complex plane:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"n", "/", "30"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "#", "]"}], ",", 
           RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
       RowBox[{"(", 
        RowBox[{"z", "/.", 
         RowBox[{"NSolve", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"EulerE", "[", 
             RowBox[{"n", ",", "z"}], "]"}], "==", "0"}], ",", "z"}], "]"}]}],
         ")"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "30"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{168, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->420619250]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29608],

Cell["Find Euler numbers from their generating function:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Sech", "[", "z", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "n"}], "}"}]}], "]"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "5", ",", "0", ",", 
   RowBox[{"-", "61"}], ",", "0", ",", "1385", ",", "0", ",", 
   RowBox[{"-", "50521"}]}], "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->589581006]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerE", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "5", ",", "0", ",", 
   RowBox[{"-", "61"}], ",", "0", ",", "1385", ",", "0", ",", 
   RowBox[{"-", "50521"}]}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356328352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->474321756],

Cell["Find Euler polynomials from their generating function:", "ExampleText",
 CellID->654745298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"x", " ", "t"}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Exp", "[", "t", "]"}], "+", "1"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", "t"}], "]"}], 
   
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{"n", "!"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "//", 
  "Expand"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", "x"}], ",", 
   RowBox[{
    RowBox[{"-", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    FractionBox["1", "4"], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"]}], "2"], "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"x", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["x", "2"]}], "2"], "-", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["x", "4"]}], "2"], "+", 
    SuperscriptBox["x", "5"]}]}], "}"}]], "Output",
 ImageSize->{425, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80213639]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerE", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", " ", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", "x"}], ",", 
   RowBox[{
    RowBox[{"-", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    FractionBox["1", "4"], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"]}], "2"], "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"x", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["x", "2"]}], "2"], "-", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["x", "4"]}], "2"], "+", 
    SuperscriptBox["x", "5"]}]}], "}"}]], "Output",
 ImageSize->{425, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134459498]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15967],

Cell[TextData[{
 "Algorithmically produced results are often expressed using ",
 Cell[BoxData[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"]], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["EulerE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerE"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"n", "+", "2"}]], " ", 
     RowBox[{"n", "!"}]}], " "}], 
   SuperscriptBox["\[Pi]", 
    RowBox[{"n", "+", "1"}]]], 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "0"}], "\[Infinity]"], 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "k"}], "+", "1"}], ")"}], 
      RowBox[{"n", "+", "1"}]]], 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"k", " ", "\[Pi]"}], "-", 
      FractionBox[
       RowBox[{"n", " ", "\[Pi]"}], "2"]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{"-", "n"}]], " ", 
  SuperscriptBox["\[Pi]", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "n"}]], " ", 
  RowBox[{"Cos", "[", 
   FractionBox[
    RowBox[{"n", " ", "\[Pi]"}], "2"], "]"}], " ", 
  RowBox[{"n", "!"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Zeta", "[", 
     RowBox[{
      RowBox[{"1", "+", "n"}], ",", 
      FractionBox["1", "4"]}], "]"}], "-", 
    RowBox[{"Zeta", "[", 
     RowBox[{
      RowBox[{"1", "+", "n"}], ",", 
      FractionBox["3", "4"]}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{343, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204709]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->248889086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "5", ",", "0", ",", 
   RowBox[{"-", "61"}], ",", "0", ",", "1385", ",", "0", ",", 
   RowBox[{"-", "50521"}]}], "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->394777628]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerE", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->165987003],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "5", ",", "0", ",", 
   RowBox[{"-", "61"}], ",", "0", ",", "1385", ",", "0", ",", 
   RowBox[{"-", "50521"}]}], "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4862657]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30219],

Cell["Umbral calculus with Euler numbers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"e", "-", "I"}], ")"}], "^", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "-", 
  RowBox[{"10", " ", "\[ImaginaryI]", " ", "e"}], "+", 
  RowBox[{"45", " ", 
   SuperscriptBox["e", "2"]}], "+", 
  RowBox[{"120", " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["e", "3"]}], "-", 
  RowBox[{"210", " ", 
   SuperscriptBox["e", "4"]}], "-", 
  RowBox[{"252", " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["e", "5"]}], "+", 
  RowBox[{"210", " ", 
   SuperscriptBox["e", "6"]}], "+", 
  RowBox[{"120", " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["e", "7"]}], "-", 
  RowBox[{"45", " ", 
   SuperscriptBox["e", "8"]}], "-", 
  RowBox[{"10", " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["e", "9"]}], "+", 
  SuperscriptBox["e", "10"]}]], "Output",
 ImageSize->{513, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89969362]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"e", "^", "k_."}], ":>", 
   RowBox[{"Abs", "[", 
    RowBox[{"EulerE", "[", "k", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->410769411]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31568],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["BernoulliB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliB"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->24307]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17188],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->31015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->27886],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/EulerNumber.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/EulerE/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->481893410],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->429431907],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->182246682]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EulerE - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 44.1837164}", "context" -> "System`", 
    "keywords" -> {
     "Euler numbers", "Euler polynomials", "secant numbers", "zig numbers"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EulerE[n] gives the Euler number E_n. EulerE[n, x] gives the Euler \
polynomial E_n (x). ", "synonyms" -> {"Euler E"}, "title" -> "EulerE", "type" -> 
    "Symbol", "uri" -> "ref/EulerE"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5567, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->584372998]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 41706, 1344}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1931, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2554, 77, 43, 1, 70, "ObjectName",
 CellID->2628],
Cell[2600, 80, 1056, 36, 70, "Usage",
 CellID->4601]
}, Open  ]],
Cell[CellGroupData[{
Cell[3693, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4171, 138, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4294, 144, 706, 25, 70, "Notes",
 CellID->29569],
Cell[5003, 171, 327, 13, 70, "Notes",
 CellID->18529],
Cell[5333, 186, 197, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5567, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->584372998],
Cell[CellGroupData[{
Cell[5952, 212, 147, 5, 70, "ExampleSection",
 CellID->42010865],
Cell[6102, 219, 196, 8, 70, "ExampleText",
 CellID->76111887],
Cell[CellGroupData[{
Cell[6323, 231, 198, 6, 28, "Input"],
Cell[6524, 239, 358, 10, 36, "Output",
 CellID->13624052]
}, Open  ]],
Cell[6897, 252, 125, 3, 70, "ExampleDelimiter",
 CellID->660433419],
Cell[7025, 257, 60, 1, 70, "ExampleText",
 CellID->83671587],
Cell[CellGroupData[{
Cell[7110, 262, 265, 9, 70, "Input",
 CellID->501507449],
Cell[7378, 273, 922, 33, 54, "Output",
 CellID->132308054]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8349, 312, 220, 7, 70, "ExampleSection",
 CellID->27528],
Cell[8572, 321, 186, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[8783, 331, 139, 4, 70, "Input"],
Cell[8925, 337, 251, 9, 36, "Output",
 CellID->41821683]
}, Open  ]],
Cell[9191, 349, 121, 3, 70, "ExampleDelimiter",
 CellID->78130],
Cell[9315, 354, 66, 1, 70, "ExampleText",
 CellID->204550622],
Cell[CellGroupData[{
Cell[9406, 359, 413, 13, 70, "Input",
 CellID->661580562],
Cell[9822, 374, 6003, 102, 70, "Output",
 Evaluatable->False,
 CellID->416515131]
}, Open  ]],
Cell[15840, 479, 123, 3, 70, "ExampleDelimiter",
 CellID->5265058],
Cell[15966, 484, 71, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16062, 488, 147, 5, 70, "Input"],
Cell[16212, 495, 256, 9, 36, "Output",
 CellID->191370209]
}, Open  ]],
Cell[16483, 507, 125, 3, 70, "ExampleDelimiter",
 CellID->238069966],
Cell[16611, 512, 203, 7, 70, "ExampleText",
 CellID->270110659],
Cell[CellGroupData[{
Cell[16839, 523, 140, 4, 70, "Input",
 CellID->388322017],
Cell[16982, 529, 248, 9, 50, "Output",
 CellID->14428502]
}, Open  ]],
Cell[CellGroupData[{
Cell[17267, 543, 164, 5, 70, "Input",
 CellID->196941614],
Cell[17434, 550, 279, 10, 50, "Output",
 CellID->15065784]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17762, 566, 223, 7, 70, "ExampleSection",
 CellID->12586],
Cell[17988, 575, 61, 0, 70, "ExampleText"],
Cell[18052, 577, 1245, 41, 70, "Input"],
Cell[19300, 620, 365, 14, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19690, 638, 390, 13, 70, "Input"],
Cell[20083, 653, 1883, 35, 70, "Output",
 Evaluatable->False,
 CellID->535904634]
}, Open  ]],
Cell[21981, 691, 86, 1, 70, "ExampleText",
 CellID->862042073],
Cell[CellGroupData[{
Cell[22092, 696, 122, 4, 70, "Input",
 CellID->11101836],
Cell[22217, 702, 312, 10, 51, "Output",
 CellID->77648673]
}, Open  ]],
Cell[22544, 715, 105, 2, 70, "ExampleDelimiter"],
Cell[22652, 719, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[22753, 723, 780, 25, 70, "Input"],
Cell[23536, 750, 4808, 83, 70, "Output",
 Evaluatable->False,
 CellID->420619250]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28393, 839, 233, 7, 70, "ExampleSection",
 CellID->29608],
Cell[28629, 848, 73, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[28727, 852, 395, 13, 70, "Input"],
Cell[29125, 867, 349, 10, 36, "Output",
 CellID->589581006]
}, Open  ]],
Cell[CellGroupData[{
Cell[29511, 882, 198, 6, 70, "Input"],
Cell[29712, 890, 359, 10, 36, "Output",
 CellID->356328352]
}, Open  ]],
Cell[30086, 903, 125, 3, 70, "ExampleDelimiter",
 CellID->474321756],
Cell[30214, 908, 97, 1, 70, "ExampleText",
 CellID->654745298],
Cell[CellGroupData[{
Cell[30336, 913, 656, 23, 70, "Input"],
Cell[30995, 938, 921, 33, 54, "Output",
 CellID->80213639]
}, Open  ]],
Cell[CellGroupData[{
Cell[31953, 976, 227, 7, 70, "Input"],
Cell[32183, 985, 922, 33, 54, "Output",
 CellID->134459498]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33154, 1024, 226, 7, 70, "ExampleSection",
 CellID->15967],
Cell[33383, 1033, 346, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[33754, 1049, 679, 25, 70, "Input"],
Cell[34436, 1076, 691, 25, 51, "Output",
 CellID->204709]
}, Open  ]],
Cell[CellGroupData[{
Cell[35164, 1106, 215, 8, 70, "Input",
 CellID->248889086],
Cell[35382, 1116, 349, 10, 36, "Output",
 CellID->394777628]
}, Open  ]],
Cell[CellGroupData[{
Cell[35768, 1131, 208, 7, 70, "Input",
 CellID->165987003],
Cell[35979, 1140, 347, 10, 36, "Output",
 CellID->4862657]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36375, 1156, 224, 7, 70, "ExampleSection",
 CellID->30219],
Cell[36602, 1165, 58, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[36685, 1169, 155, 5, 70, "Input"],
Cell[36843, 1176, 844, 25, 36, "Output",
 CellID->89969362]
}, Open  ]],
Cell[CellGroupData[{
Cell[37724, 1206, 189, 6, 70, "Input"],
Cell[37916, 1214, 158, 5, 36, "Output",
 CellID->410769411]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38135, 1226, 311, 9, 70, "SeeAlsoSection",
 CellID->31568],
Cell[38449, 1237, 200, 6, 70, "SeeAlso",
 CellID->24307]
}, Open  ]],
Cell[CellGroupData[{
Cell[38686, 1248, 314, 9, 70, "TutorialsSection",
 CellID->17188],
Cell[39003, 1259, 156, 3, 70, "Tutorials",
 CellID->31015]
}, Open  ]],
Cell[CellGroupData[{
Cell[39196, 1267, 321, 9, 70, "RelatedLinksSection",
 CellID->27886],
Cell[39520, 1278, 182, 4, 70, "RelatedLinks"],
Cell[39705, 1284, 195, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39937, 1293, 319, 9, 70, "MoreAboutSection",
 CellID->481893410],
Cell[40259, 1304, 145, 3, 70, "MoreAbout",
 CellID->429431907],
Cell[40407, 1309, 165, 3, 70, "MoreAbout",
 CellID->182246682]
}, Open  ]],
Cell[40587, 1315, 27, 0, 70, "History"],
Cell[40617, 1317, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

