(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65929,       2255]
NotebookOptionsPosition[     55916,       1918]
NotebookOutlinePosition[     57160,       1954]
CellTagsIndexPosition[     57074,       1949]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], "Divisors" :> 
          Documentation`HelpLookup["paclet:ref/Divisors"], "MoebiusMu" :> 
          Documentation`HelpLookup["paclet:ref/MoebiusMu"], 
          "MultiplicativeOrder" :> 
          Documentation`HelpLookup["paclet:ref/MultiplicativeOrder"], 
          "CarmichaelLambda" :> 
          Documentation`HelpLookup["paclet:ref/CarmichaelLambda"], "PowerMod" :> 
          Documentation`HelpLookup["paclet:ref/PowerMod"], "CoprimeQ" :> 
          Documentation`HelpLookup["paclet:ref/CoprimeQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FactorInteger\"\>", 
       2->"\<\"Divisors\"\>", 3->"\<\"MoebiusMu\"\>", 
       4->"\<\"MultiplicativeOrder\"\>", 5->"\<\"CarmichaelLambda\"\>", 
       6->"\<\"PowerMod\"\>", 7->"\<\"CoprimeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 
       4->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EulerPhi", "ObjectName",
 CellID->31288],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EulerPhi",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EulerPhi"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Euler totient function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Phi]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3578]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 " gives the number of positive integers less than or equal to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " which are relatively prime to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15893],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63725357],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->36560402],

Cell["Table of values:", "ExampleText",
 CellID->647618687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerPhi", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", 
   ",", "4", ",", "6", ",", "4", ",", "10", ",", "4", ",", "12", ",", "6", 
   ",", "8", ",", "8", ",", "16", ",", "6", ",", "18", ",", "8"}], 
  "}"}]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192184037]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"EulerPhi", "[", "k", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdkssuQ2EUhU+MDA0MDAwQERER9zv9VauUVm+KqTD2CvvRziN5BMRakv01
Odn51u6+/8tvn6OPmaqq3n++X/v3+2pkW5XMsyXrc+B56AvwL0Jfwv9X4F+F
fw36Ovwb0DeRbwt1t8E70HcRvwd9H/EHqH+Ifo+gHyP+BHlPke8M9c/hv4B+
ifwN6EVW84bZ9a/gN7vvZq4fTejXud8wO76F/C3obeRvQ7/J/YbZ+Tuy2nd0
oN+ivtn575Df7D11c73oQr+X9fxmz/eAeHNTtiere0YPeh/996E/yureYXb+
QZ6nmLWHMGv+egB9iHiz7hBmzVcPoY+yv4yyHmb1W5u9v3H2F7PmD7Prj6FP
0L9Zdwqz6tUT6E/o3+w9mfWearPvPM35yzTrYXb/Zu/hWVb7LmbPb9Z7r82O
f5H1/C9ZD7P7N/t9vf73/w39+322
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 100.}, {0., 96.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25506573]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Evaluate for large arguments:", "ExampleText",
 CellID->17688403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerPhi", "[", 
  RowBox[{"50", "!"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6204260],

Cell[BoxData[\
"4218559200885839042679312107816703841788854953574400000000000000"], "Output",\

 ImageSize->{497, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180594331]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186261814],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerPhi", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69235120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93038927],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->324446478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EulerPhi", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32217127],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox["\[Phi]",
    EulerPhi], "(", "n", ")"}], TraditionalForm]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->132732241]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 " works for negative integers:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerPhi", "[", 
    RowBox[{"-", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "4", 
   ",", "6", ",", "4", ",", "10", ",", "4"}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421446196]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["A surprising result for powers of 10:", "ExampleText",
 CellID->273340789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerPhi", "[", 
    RowBox[{"10", "^", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288081322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "40", ",", "400", ",", "4000", ",", "40000", ",", 
   "400000", ",", "4000000", ",", "40000000", ",", "400000000", ",", 
   "4000000000"}], "}"}]], "Output",
 ImageSize->{546, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->481725493]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69258062],

Cell[TextData[{
 "Number of order-",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " Farey fractions with denominator ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Range", "[", "n", "]"}], "/", "n"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Denominator", "[", "#", "]"}], "\[Equal]", "n"}], "&"}]}], 
     "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "4", 
   ",", "6", ",", "4", ",", "10", ",", "4", ",", "12", ",", "6", ",", "8"}], 
  "}"}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231904158]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerPhi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "4", 
   ",", "6", ",", "4", ",", "10", ",", "4", ",", "12", ",", "6", ",", "8"}], 
  "}"}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->338714147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot the cumulative sum of ",
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Accumulate", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"EulerPhi", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->801767716],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 6.}, {5., 10.}, {6., 12.}, {
     7., 18.}, {8., 22.}, {9., 28.}, {10., 32.}, {11., 42.}, {12., 46.}, {13.,
      58.}, {14., 64.}, {15., 72.}, {16., 80.}, {17., 96.}, {18., 102.}, {19.,
      120.}, {20., 128.}, {21., 140.}, {22., 150.}, {23., 172.}, {24., 
     180.}, {25., 200.}, {26., 212.}, {27., 230.}, {28., 242.}, {29., 270.}, {
     30., 278.}, {31., 308.}, {32., 324.}, {33., 344.}, {34., 360.}, {35., 
     384.}, {36., 396.}, {37., 432.}, {38., 450.}, {39., 474.}, {40., 490.}, {
     41., 530.}, {42., 542.}, {43., 584.}, {44., 604.}, {45., 628.}, {46., 
     650.}, {47., 696.}, {48., 712.}, {49., 754.}, {50., 774.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->{{0., 50.}, {0., 774.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563099224]
}, Open  ]],

Cell["Compare with an asymptotic approximation:", "ExampleText",
 CellID->330465585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "/", 
       RowBox[{"Pi", "^", "2"}]}], " ", 
      RowBox[{"n", "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "50"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107531520],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40734459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "The probability that two randomly chosen positive integers less than ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " are relatively prime:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["x", "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"k", "=", "1"}], 
          FormBox[
           RowBox[{"\[LeftFloor]", "x", "\[RightFloor]"}],
           TraditionalForm]], 
         RowBox[{"EulerPhi", "[", "k", "]"}]}]}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1006455569],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{5.703096181348614, 0.6748472402588901}, {6., 
     0.6388888888888888}, {6.476921291854753, 0.6748472402588901}}], 
    LineBox[{{7.929917703369329, 0.6748472402588901}, {8., 0.671875}, {
     8.416434959515843, 0.6748472402588901}}], 
    LineBox[{{9.084980740309799, 0.6748472402588901}, {10., 0.63}, {
     10.801553334021522`, 0.6748472402588901}}], 
    LineBox[{{11.2055915895102, 0.6748472402588901}, {12., 
     0.6319444444444444}, {12.884066417392336`, 0.6748472402588901}}], 
    LineBox[CompressedData["
1:eJw90g9Qk3Ucx/EJZKcScbWpnbOOCLSOAJezUTI+TnADdRv78+zh9NTjwkuG
clhcsB26/Md5imdFhST9E4GujtDu1Gjqyn/ZTgO9IJrgdELigUA2L0HPFPbZ
7+655773/r1+t2fPE5dfbCqIkEgk4qPr8X1VZdr8GvEVKBqE9Lya3gzJ+EpC
SqO/V+q+EZqTMemqu7ZM4JyK8Zs/EJrnwdf/35MzEukVKLVvEuujuf81bM66
nbo1hX0+1o4vdiViq4JfHVJzXoAr4uSDv5zm+a8jv/es7MBJdhXk50rk50bY
05C3Q9VxZj37G2j5rifh6cmc38RqjXPKYALnhdjgO7Led4Q+HZ3adzfqtrCr
4f7p8WLPQOo04cFOBzsmnl8Vml2AO3/l0X9T2BdhjfR8heLvkHctQotU+c+8
KewavBxpONpXya5B201fU1wS+2JkH5ruf2mAfTEih/W+cs6STEibtdcc1eyZ
cAk6a9tc+iz097gUJQfZsxD8s/+LAgX7Ekx7dkirv8O+BA0fHiuK+oPna3Gl
1mN6Iuy1GBic9X15Ir0OaXsCqj2n2HVon16Y7pGxZ0NdLjYpL7BnY11OUsxw
O8/PwcpdUUrZ1+w52HB3OHpL2C9Fx0W7bOw4+1IU5Rcc3hb+3pZh6ir9z95v
2Jdh16vPt2ta2JejcnZjpGU3+3Js3p96YHaQXY9bG8e2Rn/Mrkdg4TtVqlF2
A6o/EpwlHewGJPlaU+ReduPE+28OzTDi3nuZnxgvcr8RhSeE32PeD80eI+L0
d7sieuhzUVeskd1spc+FU923YMxDn4uHAevxs2Gfi7KGS7s/66I34VbH/Rbd
PnoTBs11CXG36U2QxbYW+NvoTch84bmaiJP0ZkSUxn9+70t6M/4a2v7MrDP0
Zqy5M/rAu43ejKu/ZjzVfZneAt01h7S5kd6Cevn19Jgf6C2P9p+Pz6qlt6BV
PbdiZi+9FeviV4xp6+mtuD8U6PTy97msKDdc2jfC8z1WaA1iRSL/b4mAuj57
cGAvvQDTW/6RqE56AZodv8WYP6UXUCzRtM85Rm+DoUpemhx+fhuivdXB1Q30
NhzuntOk/IDeBtuPo2lR39KLE9+/k15EfVmypdBNL8Jhj0101tGLsHd77V37
6fMw9e0Xi8ocgYz/ATZms3I=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{194., Automatic},
  PlotRange->{{0., 100.}, {0.6087, 0.6748472402588901}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{198, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285410218]
}, Open  ]],

Cell["Compare with the asymptotic limit:", "ExampleText",
 CellID->521654294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"1", "/", 
   RowBox[{"Zeta", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->334334503],

Cell[BoxData["0.6079271018540267`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->364012006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Number of cyclic necklaces of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " that can be formed with ",
 Cell[BoxData[
  FormBox["b", TI]], "InlineFormula"],
 " types of beads:"
}], "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "[", 
   RowBox[{"n_", ",", "b_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"EulerPhi", "[", "#", "]"}], " ", 
       SuperscriptBox["b", 
        FractionBox["n", "#"]]}], "&"}], "[", 
     RowBox[{"Divisors", "[", "n", "]"}], "]"}], "]"}], "/", "n"}]}]], "Input",\

 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "[", 
  RowBox[{"6", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->440191385]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Power series of the generating function for ",
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"EulerPhi", "[", "#", "]"}], " ", 
       RowBox[{
        RowBox[{"x", "^", "#"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"x", "^", "#"}]}], ")"}]}]}], "&"}], "/@", 
     RowBox[{"Divisors", "[", "10", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWc1y2jAQFhhD0ppCk0CgncaQTpvMtM/RnvoQTCYzyaFNJ82l1z5I86iu
JUsgf15pJcAcygzYK+3Pp9Va3l2+rZ7ubr+vnu5vVouvj6ufd/c3vxZfHh7L
oaQjROevEGI5E+V9Ud6pr/w8l9/qdnP3p/x2S4aX+vqqNiMSI1soDpvOFOdA
y3X19TVwpeVPWpI9ho+bD9XTL38kmbaE64SYp/RQfCF4kkD89jpFbz0OUj1y
z47qMgRapTW1tYqmLZdce5oPLVfjOAWOXqBmlONtD4Du7nXtGBPdhp4UOKqo
OS42kSiV9gnUOB/Df0z4dxt7J5rGVQxgHvGFeR2lwnycaClcQ92zGCmIqO/g
c42Hyrs8vyueM2I8lC/Evn+HyOdux53iT84jwpe7npnxOs3boX8QvNw+NXX+
L2ciZj/vCD32/CyS/w2Bvk17c6DfBnkdc5u528eRmYrMRl8InZU2NMqMNF2r
Np+JGU02o2OvvMQgTY8IDGbeHmfQWHanW2lAbmpFGNf0zmR6ZUmQfdwDzPiN
n2wcku4ockwhsuiRlqZtz4GbQryWZvhkkA0lMQAr2tbY1uXgOY9ZjUPHLACr
jP1U6xp6bNq4zSlgajbqHWbTYfuzYOanIfK151sSqBWx5TvswSLC9+acufbI
fGbstePHGI8sGz6Wa7okR7noyxmc5x4cB/KiLy58HiL2XY03Tp335Oic0++L
OcfclYVL0vhsfwKafoZHejUmS10W9AkwcYznxebEsccvLL2JfmqNvLxOPfMY
27bcNbPLatWNyK1eL5J6jrqz8wnM3139ngz4cB7PZFe/B/lcfSi0ty2utvWE
9qFuleergLLS5Ua+HtqHQT82OTADCO3DoNxOiPayksNp3lf1VO22/Yz5OjNZ
Ue+0DAt/Z8bMu/oRWaS9bfm36wTVfYN1tat3glFpxrEWcfVOkM/lO7QTi6dt
+bheTuipw3c34s8bvrtB+SARVDcGre8D7yF07vk8Ee7/TbBDcQq0K883V8y2
8X3GycfaQ36yamI7KL/V+BnJa2p6k2vRvY2h5sI8G2OTrsYzx2ppbowOk32G
9ShcXY8fan5S0LUxhSwhzkNJ90Q9zxFiU0sPYRxrzpGDj7Jv1/K+vsCDun4E
DRgpuUZ+CeMXDOKcmOcqXxoRakbLpvowV+zh5EBPQJ5H9AEkph4Evhoc5RaM
3nhf4e4hIumLxEI8tWiqgroq6AqreipE5x+gBS1s\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{414, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367478447]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"GCD", "[", 
     RowBox[{"k", ",", "10"}], "]"}], " ", 
    RowBox[{"x", "^", "k"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  SuperscriptBox["x", "7"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  SuperscriptBox["x", "9"], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "10"]}], "+", 
  SuperscriptBox["x", "11"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "12"]}], "+", 
  SuperscriptBox["x", "13"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "16"]}], "+", 
  SuperscriptBox["x", "17"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "18"]}], "+", 
  SuperscriptBox["x", "19"], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "20"]}]}]], "Output",
 ImageSize->{367, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121520867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91152128],

Cell[TextData[{
 "Count the number of primes using ",
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->67843082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "2"}], 
       RowBox[{"Floor", "[", "x", "]"}]], 
      RowBox[{"Floor", "[", 
       FractionBox[
        RowBox[{"EulerPhi", "[", "k", "]"}], 
        RowBox[{"k", "-", "1"}]], "]"}]}], ",", 
     RowBox[{"PrimePi", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "Thick", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Dashed"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->702207463],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->646264725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59807796],

Cell["Model Fleck's totient function:", "ExampleText",
 CellID->28667740],

Cell[BoxData[
 RowBox[{
  RowBox[{"FleckPhi", "[", 
   RowBox[{"k_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Times", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "j"], 
         RowBox[{"Binomial", "[", 
          RowBox[{"k", ",", "j"}], "]"}], 
         RowBox[{"EulerPhi", "[", 
          SuperscriptBox["#1", 
           RowBox[{"#2", "-", "j"}]], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "0", ",", "#2"}], "}"}]}], "]"}], "&"}], "@@@", 
     RowBox[{"FactorInteger", "[", "n", "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192820593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FleckPhi", "[", 
    RowBox[{"0", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113948206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "4", 
   ",", "6", ",", "4", ",", "10", ",", "4"}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169962571]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", "0"}], TraditionalForm]], "InlineMath"],
 " reproduces the Euler totient function:"
}], "ExampleText",
 CellID->229821284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerPhi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->165627663],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "4", 
   ",", "6", ",", "4", ",", "10", ",", "4"}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23649405]
}, Open  ]],

Cell["Generalizations and closed forms:", "ExampleText",
 CellID->113823281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FleckPhi", "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "n"}], "]"}], "-", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17357304],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->125312566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FleckPhi", "[", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "n"}], "]"}], "-", 
    RowBox[{"DivisorSigma", "[", 
     RowBox[{"1", ",", "n"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->332480758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->757985893]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " with assumptions to simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"EulerPhi", "[", "n", "]"}], ">=", 
    RowBox[{"Sqrt", "[", "n", "]"}]}], ",", " ", 
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], " ", "&&", 
    RowBox[{"n", " ", ">", "6"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70020195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 " is a multiplicative function:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"EulerPhi", "[", "m", "]"}], 
     RowBox[{"EulerPhi", "[", "n", "]"}]}], "==", 
    RowBox[{
     RowBox[{"EulerPhi", "[", 
      RowBox[{"m", " ", "n"}], "]"}], 
     FractionBox[
      RowBox[{" ", 
       RowBox[{"EulerPhi", "[", 
        RowBox[{"GCD", "[", 
         RowBox[{"n", ",", "m"}], "]"}], "]"}]}], 
      RowBox[{"GCD", "[", 
       RowBox[{"n", ",", "m"}], "]"}]]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{349, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8669111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 " through prime factorization:"
}], "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"Times", " ", "@@", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       RowBox[{"First", "/@", 
        RowBox[{"FactorInteger", "[", "n", "]"}]}]]}], ")"}]}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"\[Phi]", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "4", 
   ",", "6", ",", "4", ",", "10", ",", "4"}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->255542372]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EulerPhi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "6", ",", "4", 
   ",", "6", ",", "4", ",", "10", ",", "4"}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->56533007]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Calculate a generating function of ",
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"n", "=", "1"}], "\[Infinity]"], 
  FractionBox[
   RowBox[{"EulerPhi", "[", "n", "]"}], 
   SuperscriptBox["n", "s"]]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"Zeta", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "s"}], "]"}], 
  RowBox[{"Zeta", "[", "s", "]"}]]], "Output",
 ImageSize->{85, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90132363]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22153],

Cell["Value at 0:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerPhi", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3337223]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Form an absolutely abnormal number as the limit of the following sequence:\
\>", "ExampleText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "[", "j_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"j", "==", "2"}], ",", "2", ",", 
    RowBox[{"j", "^", 
     RowBox[{"EulerPhi", "[", 
      RowBox[{"d", "[", 
       RowBox[{"j", "-", "1"}], "]"}], "]"}]}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "[", "k_", "]"}], ":=", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"1", "/", 
      RowBox[{"d", "[", "j", "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "2", ",", "k"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"\[Alpha]", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "3"], ",", 
   FractionBox["5", "16"], ",", 
   FractionBox["24414", "78125"]}], "}"}]], "Output",
 ImageSize->{152, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105673956]
}, Open  ]],

Cell["Digits of the sixth approximation in various bases:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BaseForm", "[", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "[", "6", "]"}], ",", " ", "50"}], "]"}], ",", 
      "b"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "2", ",", "24"}], "}"}]}], "]"}], " ", "//", " ", 
  "TableForm"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.\
010011111111111111110010100101000000011010110010101000011010100001011011110101\
000011110000101100110101101111100010011111101110010110111001001011001101110011\
01011111100\"\>", "2"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 2]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.\
022102210220212221212122200110010200201020220222102101111111202200100222111100\
102000121221210001010202200\"\>", "3"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 3]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.\
103333333302211000122302220122201123311003300230311233202133232112321023031303\
11332\"\>", "4"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 4]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.\
124012400000000000000000000000000000000000000000000000000000000000000000\"\>",
          "5"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 5]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.\
1512555435343240023554104123334025302351115125255054430055551531\"\>", "6"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 6]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.\
21212113462216565666136311603501034041516350565010624434105\"\>", "7"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 7]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.\
2377776245003262503241336503605465574237562671131563277\"\>", "8"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 8]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.\
2727267877786131206368283714446803284403605577011226\"\>", "9"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 9]& ]},
     {
      TagBox[
       InterpretationBox["\<\"0.\
31249920000000000000000000000000000000000000000000\"\>",
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 10]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.348a3343909667a4500333a15a785089a432393664974365\"\
\>", "11"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 11]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.38bbb97402137843b797a9b12b6506a312488076505963\"\>\
", "12"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 12]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.40a739c496032a339cb89b8c06172c7139072512b20c4\"\>\
", "13"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 13]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.4536d7d9523c157a7086a7431b6672d20ac80a42077c\"\>",
          "14"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 14]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.4a4a41300000000000000000000000000000000000\"\>", 
         "15"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 15]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.4ffff29406b2a1a85bd43c2cd6f89fb96e4b3735f\"\>", 
         "16"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 16]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.55554300c0348gd7df576b1105767e9255fbaf957\"\>", 
         "17"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 17]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.5b48g8e40a3gf860adgg81ehb0eb53c4c344ha51\"\>", 
         "18"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 18]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.5hf83i368ef6129b73b2bhdb1da83037376h1cb\"\>", 
         "19"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 19]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.64jjh8g0000000000000000000000000000000\"\>", 
         "20"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 20]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.6bh136440b0d45cf10kcbdj7efe0d2a5bk0kdg\"\>", 
         "21"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 21]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.6j5ahj6b6dgj3bg7jab7e2dedi1j53il02a89\"\>", "22"],
        
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 22]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.747420k7c17jg074911f4bjjha096bk24ibb2\"\>", "23"],
        
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 23]& ]},
     {
      TagBox[
       InterpretationBox[
        SubscriptBox["\<\"0.7bnnhf2jhn5b3h32i1en85c5h9e2gifj1dcc\"\>", "24"],
        0.3124992`50.,
        AutoDelete->True],
       BaseForm[#, 24]& ]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{1193, 349},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->579566693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Iterate the map ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Rule]", 
    RowBox[{"\[Phi]", "(", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", "b"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " and display result modulo ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "=", "1.535"}], ",", 
     RowBox[{"b", "=", 
      RowBox[{"-", "0.5"}]}], ",", 
     RowBox[{"m", "=", "3"}]}], "}"}], ",", 
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"FixedPointList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"EulerPhi", "[", 
          RowBox[{"Floor", "[", 
           RowBox[{
            RowBox[{"a", "#"}], "+", "b"}], "]"}], "]"}], "&"}], ",", 
        RowBox[{"Range", "[", "200", "]"}], ",", "120"}], "]"}], ",", "m"}], 
     "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnOtx20AMhJfbSVpKCW4gv9Nhyop5eNKCLTkzsS6ZxcgyH7gjFh8A/tO3
lx/fXwjg5+vfr9e/oxnzK//ZIdv12/t+xuPmTh2inWBcfqCdsILh7PEmrNvt
nqCDfrlCzr1YnsxN6J9JwzN1iMds4iEe5Sceu+gQj9nEQzzKTzx20SEes4mH
eJSfeOyiQzxmEw/xKD/x2EWHeMwmHuJRfuKxiw7xmE08xKP8xGMXHeIxm3iI
R/mJxy46xGM28RCP8hOPXXSIx2ziIR7lJx676BCP2cRDPMpPPHbRIR6ziYd4
lJ947KJDPGYTD/EoP/HYRYd4zCYe4lF+4rGLDvGYTTzEo/zEYxcd4jGbeIhH
+YnHLjrEYzbxEI/yE49ddIjHbJvzoHh8jY4HeUA8vkbHgzyePK8ihD/lUcf/
HA9eeMTmjIXP4YG7Oj7mkfrwHB7sTp/jgQuPxIBYzJuw/qKOy+VRx2UF786r
d/rjlst9HXxfB1tUnl8yF36GByv+3PfqAQsq2+ghHRx4vMmBxZsr2TdB6VhR
0aqG0beMonHd5NFn1Lpo2SeYmaGFZf2DKS0f8kCqulYPI95jPQrmgKposEWc
a5ixRrZNHomUwIIC39+86VxuC6sVX6tVZCI9ziNmS0RAeHyMxkRxLGXnTucv
F+PcEa7Wh9CZVTtB5oT5hHX5vA0id1xf8HHISUeVSqXYy8VjOtBeUMib54k/
CnD6phtYbbqWBi0fqbADRkDBwQSDUYpB9tyqlwmRo/loDKos2EJcNWLPQJbw
GTOWf+QtSZsi2wWWNUajWkEboSgmuPKg7FD92BQSkd71VMKzUTt3BFEwC75t
hHVy7syWi/bb1o4ZnhH6iPRS8Nh7n6Pe2NG4jsn2IVtpZXMha9uqavVKvuWj
OGIEmMyAsR4Z+Y8JEUGvUoEXgXswHoyjZzCqxe56ohl9G/6shRlnzSaQETrh
19x6WVnSGTMwOq+6ytMTxKKaIqDoBweZUyCVuTDvcwvLSsTBeUPEAM4tfGYY
stDiLODEcvasdlv9aGHYGKqx7sEkSZfnwCK06KIulZXjFfAVC1y+B5SvDNsa
tTTcs6bswKsd/8fnN3gBbUM=
   "], {{0, 0}, {200, 121}}, {0, 2}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->{324., Automatic}]], "Output",
 ImageSize->{328, 201},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->887603796]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5560],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MoebiusMu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MoebiusMu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultiplicativeOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiplicativeOrder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CarmichaelLambda",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CarmichaelLambda"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoprimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoprimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8727]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7488],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->29163]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->17169],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/TotientFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/NumberTheoryFunctions/EulerPhi/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
EulerPhi"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->179818760],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->270106346],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->210192880],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->347670291],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->863547094]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EulerPhi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 45.4337484}", "context" -> "System`", 
    "keywords" -> {"Euler phi", "Euler totient", "totient function"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EulerPhi[n] gives the Euler totient function \\[Phi](n). ", 
    "synonyms" -> {"euler phi"}, "title" -> "EulerPhi", "type" -> "Symbol", 
    "uri" -> "ref/EulerPhi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5525, 170, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->63725357]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56932, 1942}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2999, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3622, 94, 46, 1, 70, "ObjectName",
 CellID->31288],
Cell[3671, 97, 595, 19, 70, "Usage",
 CellID->3578]
}, Open  ]],
Cell[CellGroupData[{
Cell[4303, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4781, 138, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4916, 144, 364, 12, 70, "Notes",
 CellID->15893],
Cell[5283, 158, 205, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5525, 170, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63725357],
Cell[CellGroupData[{
Cell[5909, 184, 147, 5, 70, "ExampleSection",
 CellID->36560402],
Cell[6059, 191, 59, 1, 70, "ExampleText",
 CellID->647618687],
Cell[CellGroupData[{
Cell[6143, 196, 200, 6, 28, "Input"],
Cell[6346, 204, 412, 11, 36, "Output",
 CellID->192184037]
}, Open  ]],
Cell[6773, 218, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[6903, 224, 230, 7, 28, "Input"],
Cell[7136, 233, 951, 25, 166, "Output",
 CellID->25506573]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8136, 264, 200, 6, 70, "ExampleSection"],
Cell[8339, 272, 71, 1, 70, "ExampleText",
 CellID->17688403],
Cell[CellGroupData[{
Cell[8435, 277, 121, 4, 70, "Input",
 CellID->6204260],
Cell[8559, 283, 226, 7, 36, "Output",
 CellID->180594331]
}, Open  ]],
Cell[8800, 293, 125, 3, 70, "ExampleDelimiter",
 CellID->186261814],
Cell[8928, 298, 190, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[9143, 308, 141, 4, 70, "Input"],
Cell[9287, 314, 212, 7, 36, "Output",
 CellID->69235120]
}, Open  ]],
Cell[9514, 324, 124, 3, 70, "ExampleDelimiter",
 CellID->93038927],
Cell[9641, 329, 203, 7, 70, "ExampleText",
 CellID->324446478],
Cell[CellGroupData[{
Cell[9869, 340, 141, 4, 70, "Input",
 CellID->32217127],
Cell[10013, 346, 262, 9, 50, "Output",
 CellID->132732241]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10324, 361, 223, 6, 70, "ExampleSection"],
Cell[10550, 369, 186, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10761, 379, 210, 7, 70, "Input"],
Cell[10974, 388, 312, 9, 36, "Output",
 CellID->421446196]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11335, 403, 207, 6, 70, "ExampleSection"],
Cell[11545, 411, 80, 1, 70, "ExampleText",
 CellID->273340789],
Cell[CellGroupData[{
Cell[11650, 416, 246, 8, 70, "Input",
 CellID->288081322],
Cell[11899, 426, 350, 10, 36, "Output",
 CellID->481725493]
}, Open  ]],
Cell[12264, 439, 124, 3, 70, "ExampleDelimiter",
 CellID->69258062],
Cell[12391, 444, 227, 8, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12643, 456, 420, 14, 70, "Input"],
Cell[13066, 472, 346, 10, 36, "Output",
 CellID->231904158]
}, Open  ]],
Cell[CellGroupData[{
Cell[13449, 487, 190, 6, 70, "Input"],
Cell[13642, 495, 346, 10, 36, "Output",
 CellID->338714147]
}, Open  ]],
Cell[14003, 508, 105, 2, 70, "ExampleDelimiter"],
Cell[14111, 512, 190, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14326, 523, 291, 9, 70, "Input",
 CellID->801767716],
Cell[14620, 534, 1132, 25, 136, "Output",
 CellID->563099224]
}, Open  ]],
Cell[15767, 562, 84, 1, 70, "ExampleText",
 CellID->330465585],
Cell[CellGroupData[{
Cell[15876, 567, 405, 13, 70, "Input",
 CellID->107531520],
Cell[16284, 582, 2794, 50, 70, "Output",
 Evaluatable->False,
 CellID->40734459]
}, Open  ]],
Cell[19093, 635, 105, 2, 70, "ExampleDelimiter"],
Cell[19201, 639, 191, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19417, 648, 644, 21, 70, "Input",
 CellID->1006455569],
Cell[20064, 671, 2205, 46, 139, "Output",
 CellID->285410218]
}, Open  ]],
Cell[22284, 720, 77, 1, 70, "ExampleText",
 CellID->521654294],
Cell[CellGroupData[{
Cell[22386, 725, 152, 5, 70, "Input",
 CellID->334334503],
Cell[22541, 732, 176, 5, 36, "Output",
 CellID->364012006]
}, Open  ]],
Cell[22732, 740, 105, 2, 70, "ExampleDelimiter"],
Cell[22840, 744, 237, 8, 70, "ExampleText"],
Cell[23080, 754, 397, 14, 70, "Input"],
Cell[CellGroupData[{
Cell[23502, 772, 100, 3, 70, "Input"],
Cell[23605, 777, 159, 5, 36, "Output",
 CellID->440191385]
}, Open  ]],
Cell[23779, 785, 105, 2, 70, "ExampleDelimiter"],
Cell[23887, 789, 197, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24109, 800, 498, 16, 70, "Input"],
Cell[24610, 818, 1472, 28, 70, "Output",
 Evaluatable->False,
 CellID->367478447]
}, Open  ]],
Cell[CellGroupData[{
Cell[26119, 851, 270, 9, 70, "Input"],
Cell[26392, 862, 1118, 37, 54, "Output",
 CellID->121520867]
}, Open  ]],
Cell[27525, 902, 124, 3, 70, "ExampleDelimiter",
 CellID->91152128],
Cell[27652, 907, 215, 8, 70, "ExampleText",
 CellID->67843082],
Cell[CellGroupData[{
Cell[27892, 919, 723, 23, 70, "Input",
 CellID->702207463],
Cell[28618, 944, 2457, 44, 70, "Output",
 Evaluatable->False,
 CellID->646264725]
}, Open  ]],
Cell[31090, 991, 124, 3, 70, "ExampleDelimiter",
 CellID->59807796],
Cell[31217, 996, 73, 1, 70, "ExampleText",
 CellID->28667740],
Cell[31293, 999, 728, 23, 70, "Input",
 CellID->192820593],
Cell[CellGroupData[{
Cell[32046, 1026, 235, 8, 70, "Input",
 CellID->113948206],
Cell[32284, 1036, 312, 9, 36, "Output",
 CellID->169962571]
}, Open  ]],
Cell[32611, 1048, 185, 6, 70, "ExampleText",
 CellID->229821284],
Cell[CellGroupData[{
Cell[32821, 1058, 210, 7, 70, "Input",
 CellID->165627663],
Cell[33034, 1067, 311, 9, 36, "Output",
 CellID->23649405]
}, Open  ]],
Cell[33360, 1079, 76, 1, 70, "ExampleText",
 CellID->113823281],
Cell[CellGroupData[{
Cell[33461, 1084, 282, 10, 70, "Input",
 CellID->17357304],
Cell[33746, 1096, 311, 9, 36, "Output",
 CellID->125312566]
}, Open  ]],
Cell[CellGroupData[{
Cell[34094, 1110, 350, 12, 70, "Input",
 CellID->332480758],
Cell[34447, 1124, 311, 9, 36, "Output",
 CellID->757985893]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34807, 1139, 217, 6, 70, "ExampleSection"],
Cell[35027, 1147, 352, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[35404, 1163, 312, 9, 70, "Input"],
Cell[35719, 1174, 160, 5, 36, "Output",
 CellID->70020195]
}, Open  ]],
Cell[35894, 1182, 105, 2, 70, "ExampleDelimiter"],
Cell[36002, 1186, 187, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[36214, 1196, 632, 21, 70, "Input"],
Cell[36849, 1219, 549, 16, 54, "Output",
 CellID->8669111]
}, Open  ]],
Cell[37413, 1238, 105, 2, 70, "ExampleDelimiter"],
Cell[37521, 1242, 201, 7, 70, "ExampleText"],
Cell[37725, 1251, 324, 10, 70, "Input"],
Cell[CellGroupData[{
Cell[38074, 1265, 188, 6, 70, "Input"],
Cell[38265, 1273, 312, 9, 36, "Output",
 CellID->255542372]
}, Open  ]],
Cell[CellGroupData[{
Cell[38614, 1287, 190, 6, 70, "Input"],
Cell[38807, 1295, 311, 9, 36, "Output",
 CellID->56533007]
}, Open  ]],
Cell[39133, 1307, 105, 2, 70, "ExampleDelimiter"],
Cell[39241, 1311, 198, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[39464, 1322, 221, 7, 70, "Input"],
Cell[39688, 1331, 283, 10, 53, "Output",
 CellID->90132363]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40020, 1347, 226, 7, 70, "ExampleSection",
 CellID->22153],
Cell[40249, 1356, 34, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[40308, 1360, 84, 2, 70, "Input"],
Cell[40395, 1364, 156, 5, 36, "Output",
 CellID->3337223]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40600, 1375, 208, 6, 70, "ExampleSection"],
Cell[40811, 1383, 105, 2, 70, "ExampleText"],
Cell[40919, 1387, 588, 19, 70, "Input"],
Cell[CellGroupData[{
Cell[41532, 1410, 189, 6, 70, "Input"],
Cell[41724, 1418, 331, 11, 51, "Output",
 CellID->105673956]
}, Open  ]],
Cell[42070, 1432, 74, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[42169, 1436, 389, 13, 70, "Input"],
Cell[42561, 1451, 5894, 208, 384, "Output",
 CellID->579566693]
}, Open  ]],
Cell[48470, 1662, 105, 2, 70, "ExampleDelimiter"],
Cell[48578, 1666, 341, 13, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[48944, 1683, 660, 21, 70, "Input"],
Cell[49607, 1706, 1460, 30, 222, "Output",
 CellID->887603796]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51128, 1743, 310, 9, 70, "SeeAlsoSection",
 CellID->5560],
Cell[51441, 1754, 1725, 62, 70, "SeeAlso",
 CellID->8727]
}, Open  ]],
Cell[CellGroupData[{
Cell[53203, 1821, 313, 9, 70, "TutorialsSection",
 CellID->7488],
Cell[53519, 1832, 198, 4, 70, "Tutorials",
 CellID->29163]
}, Open  ]],
Cell[CellGroupData[{
Cell[53754, 1841, 321, 9, 70, "RelatedLinksSection",
 CellID->17169],
Cell[54078, 1852, 186, 4, 70, "RelatedLinks"],
Cell[54267, 1858, 202, 4, 70, "RelatedLinks"],
Cell[54472, 1864, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54895, 1882, 319, 9, 70, "MoreAboutSection",
 CellID->179818760],
Cell[55217, 1893, 164, 3, 70, "MoreAbout",
 CellID->270106346],
Cell[55384, 1898, 155, 3, 70, "MoreAbout",
 CellID->210192880],
Cell[55542, 1903, 162, 3, 70, "MoreAbout",
 CellID->347670291],
Cell[55707, 1908, 137, 3, 70, "MoreAbout",
 CellID->863547094]
}, Open  ]],
Cell[55859, 1914, 27, 0, 70, "History"],
Cell[55889, 1916, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

