(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19478,        574]
NotebookOptionsPosition[     15945,        457]
NotebookOutlinePosition[     17488,        502]
CellTagsIndexPosition[     17370,        496]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluator" :> Documentation`HelpLookup["paclet:ref/Evaluator"],
           "InitializationCell" :> 
          Documentation`HelpLookup["paclet:ref/InitializationCell"], 
          "CellEvaluationDuplicate" :> 
          Documentation`HelpLookup["paclet:ref/CellEvaluationDuplicate"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Evaluator\"\>", 
       2->"\<\"InitializationCell\"\>", 
       3->"\<\"CellEvaluationDuplicate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Options in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/EvaluationOptionsInNotebooks"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation Options in Notebooks\"\>", 
       2->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Evaluatable", "ObjectName",
 CellID->27303],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Evaluatable",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Evaluatable"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether a cell should be used as input to be evaluated \
by the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2386]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Evaluatable", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", typing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["Shift", "KeyEvent"], 
    StyleBox["+", "KeyEventDelimiter"], 
    DynamicBox[ToBoxes[
      If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
     ImageSizeCache->{36., {0., 8.}}]}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " in the front end when the cell is selected will cause the contents of the \
cell to be sent to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel for evaluation. "
}], "Notes",
 CellID->27484],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Evaluatable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluatable"]], "InlineFormula"],
 " is more often set for styles of cells than for individual cells. "
}], "Notes",
 CellID->25805]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37954367],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->187217049],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Evaluatable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluatable"]], "InlineFormula"],
 " settings to specify whether a cell can be evaluated:"
}], "ExampleText",
 CellID->298656146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<2+2\>\"", ",", "\"\<Text\>\"", ",", 
        RowBox[{"Evaluatable", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"ExpressionCell", "[", 
       RowBox[{
        RowBox[{"Defer", "[", 
         RowBox[{"3", "+", "3"}], "]"}], ",", "\"\<Input\>\"", ",", 
        RowBox[{"Evaluatable", "\[Rule]", "False"}]}], "]"}]}], "}"}], 
    "]"}]}], ";", 
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->796773116],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9PXFUex/Exm+wTNxsT/wLjX7FPd/ehPxL1kSYrdLe0asxG/wAfGGtd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   "], {{0, 0}, {458, 96}}, {0, 255}],
  ImageSize->{458 0.75, 96 0.75},
  PlotRange->{{0, 458}, {0, 96}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->610323947]
}, Open  ]],

Cell["The first cell can be evaluated, and the second cell cannot:", \
"ExampleText",
 CellID->17447074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluate", "[", "nb", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->792485650],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/Ht9Hkn/0L/lf54qmMnT2xnGnEqknYyjp0+yExm+iBTkzY2
nRoVxCAmFEg0JAaoRLEg8mNdFlyQH7Igu7aATlE0asSRAr09d8/u2XPvXZbL
ck93Yd+v+cQ533PPvZgnn9kshP3hwSM/O/j9UCj0jvgn+r1QyF5XVv6eEEKI
iayurRNCCAkwql0/v3CNEEJIIHG1a9FfQhNCyC5Izna1AADbUJl5r5V2BYAA
0a4AYALtCgAm0K4AYALtCgAm0K4AYALtCgAm0K4AYALtCgAm0K4AYALtCgAm
0K4AYALtCgAm0K4AYALtCgAm0K4AYALtCgAm0K4AULDfvdP+0z21Mvv2n9cv
0a4AEAhRsPpIuwJAIGhXADChDNs1lLHR1cJuBABdubWr6saNenLT1qVgAfhR
bu2qeEsy5OT/RgDwol29+4XdCAC6MmxX3ncF8H9Qhu0qFdyTFCyAPLL/Q8He
8mrXgr85xXe1APg3m1wqw9euBf8HPu8MAPBDVKt8BatvlkO7AoA5slq/e7FC
uwJAUFS1WmX8XS0ACJZerRbtCgABqakLH327Tf0GwqojLfpV2hUATKBdAcAE
2hUATKBdAcAE2hUATKBdAcAE2hUATKBdAcAE2hUATKBdAcAE2hUATKBdAcAE
2hUATKBdAcCEUm5X+Uu9/GwCQFFkP7JwT+2+/ef1SyXerlvaB4AiKvpvz1Y9
n3NHv+Q6s9G/AgCUguK2q7ckXV3qp1ELa1c+4BWAUbumXdUrXv9lS7UCMGfX
tKtPIY9C/+4AkE8pt6vrtWggr131OqVaAZhTau3q54D3u2Bb+qKqVGlXAOaU
4M8M5D+p1t5N/2Sv0q4AApf9kde9RW7XoqBdARg1m1wq+mvXYuFbWgAMEdUq
X8Hqm+XTrgBggqzW716s0K4AEBRVrVYJfFcLAHYHvVot2hUAAlJTFz76dpv6
OaiqIy36VdoVAEygXQHABNoVAEygXQHABNoVAEygXQHABNoVAEygXQHABNoV
AEygXQHABNoVAEygXQHABNoVAAqW/diXPbX79p/XLxW9XXN+TlZhH54FAEVU
ar+BcKMWpV0B7CzFalf5dXN+xmvOv1vOA/mFnLZ5DAC2ZMe165aotnTV5kYj
7QogKDu0XdX7xpu2bs7C9G7SqwCCtUPbdUt8dikFCyBARW9X1+tPn++7+n/t
KsnmDOXiPQYA21fcds2zn6d1C+CzRWlXAEEpwXbN+XYB7QpgZym1n3cNkF6V
edo1zzEAKNgubldLe6M1kGMA4N/ublcAKBbaFQBMoF0BICj678iqOtKiX6Jd
AcAE2hUATKBdAcAE2hUATKBdAcAE2hUATKBdAcAEvV1/89bxxOw/W9sjHxxv
JIQQss2s/mc1HJk6+tsTlW99KNpVZHo6SQghZJvR23U6Pm9Z6+vra4QQQraT
/66v6e16Z3JudXVt+eUrkZeppNfL4s8VNS4vpw+ITXVYrfW8ZGRkZCzRccud
dqbuwrnXf9S898dNe3/ijdgXV8UZeeOrVyvLyyuqXcdu33v2fHnp8bOlx09T
fz7LrJ+610/0A+q82nzuvMrIyMhYUmMhndb2+p61k6esTxqs+voc+aRBXBVn
5I2Pn9i3qHYdGZl98O/HcwuP5uYXf/Daa3rmFhbnFh6m1/P6+qGIduxRZvFQ
reWY3dfO5zycfXLqsLwqF+67nFcZGRkZfY12iS2mNuXOYmY/k/SlRfuuzBPu
Hq6wOi5bly5umI7L4oy8d/7+o/mFJdWuQ8Mzs/ceTN+dl/UlFjKZcSG7P5M9
k1nMpQ6nz8w4HjKnj66Hu66K0XnAvqofzn+VkZGRcdMxs1jIbs44R3s9p52x
nzBTWWG1tVpffJb+oSuxkFFjW6s4k7plYWZ24W7igWrXyGB8fPLe7fGEbDCx
GB1P6KNa5NpM5twfdT5k1Plw79VR51pe1Q/nv8rIyMjoc7ztXHuS1O8SC3e7
Ci3aOtOu8q6xicTEnX+pdhWLoVg8emtKNtjgcDwyFB8czo6ZxZS+Ti9uxQeH
prLjkLprKirOa6PrHQDvYbmOOE9G7C/quKqeLBaMjIyM/sfocFxkMPPnoL0f
t/dTjScPq05TT5ipPGC1XbIuNtlxaT5vNdVbX10Q7Toon3krHhudVe06EJ7s
D4/3hcdlg4lF38B4b3gsPQ449l2bvanNvgF1eCy7Hx7XR3Vj7waH0+uBMXWv
PLz9q4yMjIyyweSOWGd30vvpqE5TT5j+1Rt2rzZ8bDWctT7VPomgvto6d8r6
+CNRsNOH3sjcMhaJxq/fuC3btT882d0zIiI7quuGve6+EZOj2lfRD2d2Yq6F
a+zqGely3tJlPySW6+ExeVheVeNGV+Wj9C/nvZeRkZExNaZ3utL7jmjnHU+w
27XxnFV7wjpzwv3a9eSH1kd/ts7VinZVz+kPT/y9IyLbtW9g4krn4NVrUdlR
YiEjxyvXhq7aiV7tjIq1PXYOaYdTl+z9aOqkuiv36Dqsj+qB3quqe/Nf9fmF
GBkZy3O8kt3P0WnyqrfTpg8dsOpr1/56XHXqyl+y65d/et+qOT1z6EDq3uiV
zmhP7+jnF7vT7do/0d4RvvxNRBaUWMi4RlecV2+qUdu/6R21uEfXA31eTW06
vvqmX4iRkZFxs9xUf9rvu9acfv7+e7JOX/zxveepyPHbY8es06fEGXVv1/VY
XX17pl0nL7XebG2PmIjsvWBPBnsvIYTkSaKqwqquXnr33W+P/cEbsW/VVCcO
H5CHv26LdP5j5MTJi+l27bvT8kX/V1+GCSGEuBJ78+fW2RqrRqQ6R6qrrbN1
w7/+pTz8ZUv4m47YB8cbZbv29Iw3fNrV3HidEEKIK2fqLowc+kXyzYOzhyu8
SVZVxA5XiDPycNPfur++FKFdCSEk2NCuhBBiIrQrIYSYiKtde/vGGxu6Pmu+
TgghZDtpbupua8226/zCk0TyYSK5SAghZJu5f/+paldCCCHBRrTr/wCjD+vQ

   "], {{0, 0}, {458, 123}}, {0, 255}],
  ImageSize->{458 0.75, 123 0.75},
  PlotRange->{{0, 458}, {0, 123}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->133716613]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->253689205],

Cell["A cell that cannot be evaluated: ", "ExampleText",
 CellID->92950005],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"ExpressionCell", "[", 
   RowBox[{
    RowBox[{"Defer", "[", 
     RowBox[{"1", "+", "1"}], "]"}], ",", "\"\<Input\>\"", ",", 
    RowBox[{"Evaluatable", "\[Rule]", "False"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51989234],

Cell[BoxData[
 RowBox[{"1", "+", "1"}]], "Input",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"In[2]:=",
 CellID->115134538]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1732],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Evaluator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Evaluator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializationCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InitializationCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEvaluationDuplicate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEvaluationDuplicate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->478]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19642],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->16228]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->862322707],

Cell[TextData[ButtonBox["Evaluation Options in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationOptionsInNotebooks"]], "MoreAbout",
 CellID->85168206],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->150725051]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Evaluatable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 46.2306438}", "context" -> "System`", 
    "keywords" -> {"input cell"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Evaluatable is an option for Cell which specifies whether a cell should \
be used as input to be evaluated by the Mathematica kernel. ", 
    "synonyms" -> {}, "title" -> "Evaluatable", "type" -> "Symbol", "uri" -> 
    "ref/Evaluatable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5058, 164, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->37954367]},
 "Notebook Image"->{
  Cell[6527, 217, 2849, 49, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->610323947],
  Cell[9637, 280, 3284, 57, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->133716613]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17000, 482},
 {"Notebook Image", 17140, 486}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2176, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2799, 80, 49, 1, 70, "ObjectName",
 CellID->27303],
Cell[2851, 83, 697, 22, 70, "Usage",
 CellID->2386]
}, Open  ]],
Cell[CellGroupData[{
Cell[3585, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4063, 127, 716, 23, 70, "Notes",
 CellID->27484],
Cell[4782, 152, 239, 7, 70, "Notes",
 CellID->25805]
}, Closed]],
Cell[CellGroupData[{
Cell[5058, 164, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37954367],
Cell[CellGroupData[{
Cell[5442, 178, 148, 5, 70, "ExampleSection",
 CellID->187217049],
Cell[5593, 185, 245, 8, 70, "ExampleText",
 CellID->298656146],
Cell[CellGroupData[{
Cell[5863, 197, 661, 18, 70, "Input",
 CellID->796773116],
Cell[6527, 217, 2849, 49, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->610323947]
}, Open  ]],
Cell[9391, 269, 104, 2, 70, "ExampleText",
 CellID->17447074],
Cell[CellGroupData[{
Cell[9520, 275, 114, 3, 70, "Input",
 CellID->792485650],
Cell[9637, 280, 3284, 57, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->133716613]
}, Open  ]],
Cell[12936, 340, 125, 3, 70, "ExampleDelimiter",
 CellID->253689205],
Cell[13064, 345, 75, 1, 70, "ExampleText",
 CellID->92950005],
Cell[13142, 348, 296, 8, 70, "Input",
 CellID->51989234],
Cell[13441, 358, 161, 6, 70, "Input",
 Evaluatable->False,
 CellID->115134538]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13651, 370, 310, 9, 70, "SeeAlsoSection",
 CellID->1732],
Cell[13964, 381, 746, 26, 70, "SeeAlso",
 CellID->478]
}, Open  ]],
Cell[CellGroupData[{
Cell[14747, 412, 314, 9, 70, "TutorialsSection",
 CellID->19642],
Cell[15064, 423, 143, 3, 70, "Tutorials",
 CellID->16228]
}, Open  ]],
Cell[CellGroupData[{
Cell[15244, 431, 319, 9, 70, "MoreAboutSection",
 CellID->862322707],
Cell[15566, 442, 170, 3, 70, "MoreAbout",
 CellID->85168206],
Cell[15739, 447, 134, 3, 70, "MoreAbout",
 CellID->150725051]
}, Open  ]],
Cell[15888, 453, 27, 0, 70, "History"],
Cell[15918, 455, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

