(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14880,        514]
NotebookOptionsPosition[     11243,        394]
NotebookOutlinePosition[     12510,        430]
CellTagsIndexPosition[     12425,        425]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
           "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReturnPacket" :> 
          Documentation`HelpLookup["paclet:ref/ReturnPacket"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ReturnPacket\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink Expression Packet Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkExpressionPacketHandling"], 
          "MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], "MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup[
           "paclet:guide/ParallelAndGridComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MathLink Expression Packet Handling\"\>", 
       2->"\<\"MathLink Mathematica Functions\"\>", 
       3->"\<\"MathLink Packets\"\>", 
       4->"\<\"Parallel & Grid Computing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EvaluatePacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EvaluatePacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EvaluatePacket"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet requesting evaluation of ",
     StyleBox["expr", "TI"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["expr", "TI"],
 " is not evaluated by a complete pass through ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s main loop."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474513114],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->87325477],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->45169894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312144257],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "672", ",", "9"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45608859]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->202115744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2053461425],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108934649]
}, Open  ]],

Cell[TextData[{
 "Send an ",
 Cell[BoxData[
  ButtonBox["EvaluatePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFormula"],
 " packet with the expression ",
 Cell[BoxData[
  RowBox[{"10", "!"}]], "InlineFormula"],
 " without evaluating it:"
}], "ExampleText",
 CellID->316479038],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"EvaluatePacket", "[", 
     RowBox[{"10", "!"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1893681694],

Cell["Read the result:", "ExampleText",
 CellID->1400582518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1022125259],

Cell[BoxData[
 RowBox[{"ReturnPacket", "[", "3628800", "]"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->69885905]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1108681067],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["MathLink Expression Packet Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]], "MoreAbout",
 CellID->68257174],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->14918652],

Cell[TextData[ButtonBox["MathLink Packets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkPackets"]], "MoreAbout",
 CellID->146879740],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->140151453]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EvaluatePacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 46.8869106}", "context" -> "System`", 
    "keywords" -> {"evaluation packet", "input packet"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EvaluatePacket[expr] is a MathLink packet requesting evaluation of \
expr.", "synonyms" -> {"evaluate packet"}, "title" -> "EvaluatePacket", 
    "type" -> "Symbol", "uri" -> "ref/EvaluatePacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5084, 154, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->474513114]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12282, 418}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3057, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3680, 97, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3740, 100, 602, 20, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4379, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4857, 142, 190, 7, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[5084, 154, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474513114],
Cell[CellGroupData[{
Cell[5469, 168, 147, 5, 70, "ExampleSection",
 CellID->87325477],
Cell[5619, 175, 147, 6, 70, "ExampleText",
 CellID->45169894],
Cell[CellGroupData[{
Cell[5791, 185, 234, 7, 28, "Input",
 CellID->312144257],
Cell[6028, 194, 259, 8, 36, "Output",
 CellID->45608859]
}, Open  ]],
Cell[6302, 205, 65, 1, 70, "ExampleText",
 CellID->202115744],
Cell[CellGroupData[{
Cell[6392, 210, 108, 3, 28, "Input",
 CellID->2053461425],
Cell[6503, 215, 215, 6, 36, "Output",
 CellID->108934649]
}, Open  ]],
Cell[6733, 224, 315, 11, 70, "ExampleText",
 CellID->316479038],
Cell[7051, 237, 236, 7, 70, "Input",
 CellID->1893681694],
Cell[7290, 246, 60, 1, 70, "ExampleText",
 CellID->1400582518],
Cell[CellGroupData[{
Cell[7375, 251, 108, 3, 70, "Input",
 CellID->1022125259],
Cell[7486, 256, 202, 6, 36, "Output",
 CellID->69885905]
}, Open  ]],
Cell[7703, 265, 59, 1, 70, "ExampleText",
 CellID->1108681067],
Cell[7765, 268, 109, 3, 70, "Input",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7923, 277, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8242, 288, 208, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[8487, 299, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8808, 310, 371, 11, 70, "Tutorials",
 CellID->341631938],
Cell[9182, 323, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9516, 334, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9846, 345, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10209, 359, 299, 8, 70, "MoreAboutSection"],
Cell[10511, 369, 178, 3, 70, "MoreAbout",
 CellID->68257174],
Cell[10692, 374, 169, 3, 70, "MoreAbout",
 CellID->14918652],
Cell[10864, 379, 143, 3, 70, "MoreAbout",
 CellID->146879740],
Cell[11010, 384, 161, 3, 70, "MoreAbout",
 CellID->140151453]
}, Open  ]],
Cell[11186, 390, 27, 0, 70, "History"],
Cell[11216, 392, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

