(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20630,        600]
NotebookOptionsPosition[     16965,        481]
NotebookOutlinePosition[     18669,        529]
CellTagsIndexPosition[     18551,        523]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAsMathematicaExpressions"], 
          "Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Notebooks as Mathematica Expressions\"\>", 
       2->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InitializationCell" :> 
          Documentation`HelpLookup["paclet:ref/InitializationCell"], 
          "CellProlog" :> Documentation`HelpLookup["paclet:ref/CellProlog"], 
          "CellContext" :> Documentation`HelpLookup["paclet:ref/CellContext"],
           "CellEvaluationFunction" :> 
          Documentation`HelpLookup["paclet:ref/CellEvaluationFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"InitializationCell\"\>", 
       2->"\<\"CellProlog\"\>", 3->"\<\"CellContext\"\>", 
       4->"\<\"CellEvaluationFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Evaluation Options in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/EvaluationOptionsInNotebooks"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup["paclet:guide/ParallelAndGridComputing"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluation Control\"\>", 
       2->"\<\"Evaluation Options in Notebooks\"\>", 
       3->"\<\"Parallel & Grid Computing\"\>", 
       4->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Evaluator", "ObjectName",
 CellID->23245],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Evaluator",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Evaluator"]], "InlineFormula"],
     "\[LineSeparator]is an option for objects such as ",
     Cell[BoxData[
      ButtonBox["Button",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Button"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which gives the name of the kernel to use to evaluate their contents. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is typically ",
 Cell[BoxData[
  RowBox[{"Evaluator", "->", "\"\<Local\>\""}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10572],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Evaluator", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that no evaluation should be done."
}], "Notes",
 CellID->15882],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Evaluator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluator"]], "InlineFormula"],
 " is more often set at a global level or at the level of whole notebooks \
than at the level of individual cells or other objects. "
}], "Notes",
 CellID->31722]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->517201677],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->29006969],

Cell[TextData[{
 "Create input cells with different ",
 Cell[BoxData[
  ButtonBox["Evaluator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluator"]], "InlineFormula"],
 " settings:"
}], "ExampleText",
 CellID->41148611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ExpressionCell", "[", 
       RowBox[{
        RowBox[{"Defer", "[", 
         RowBox[{"2", "+", "2"}], "]"}], ",", "\"\<Input\>\"", ",", 
        RowBox[{"Evaluator", "\[Rule]", "None"}]}], "]"}], ",", 
      RowBox[{"ExpressionCell", "[", 
       RowBox[{
        RowBox[{"Defer", "[", 
         RowBox[{"2", "+", "2"}], "]"}], ",", "\"\<Input\>\"", ",", 
        RowBox[{"Evaluator", "\[Rule]", "\"\<Local\>\""}]}], "]"}]}], "}"}], 
    "]"}]}], ";", 
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33621652],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnG1vk1Uch2tMfKMxJn4C4qfwrfrSh0SMLzTRDWWAhhj9AL4wIuqUgMDG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   "], {{0, 0}, {458, 86}}, {0, 255}],
  ImageSize->{458 0.75, 86 0.75},
  PlotRange->{{0, 458}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->19034637]
}, Open  ]],

Cell[TextData[{
 "The first cell has no evaluator; the second cell uses the evaluator named \
",
 Cell[BoxData["\"\<Local\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18961866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluate", "[", "nb", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->964106627],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx3E6fd7Jv9B/pT+e6pjJE5OZRpyKpJ2MQ6YPnOlMH2Rq0sam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   "], {{0, 0}, {458, 113}}, {0, 255}],
  ImageSize->{458 0.75, 113 0.75},
  PlotRange->{{0, 458}, {0, 113}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->371474128]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27886],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializationCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InitializationCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellProlog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellProlog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellContext",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellContext"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEvaluationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEvaluationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8025]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25840],

Cell[TextData[{
 ButtonBox["Notebooks as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebooksAsMathematicaExpressions"]
}], "Tutorials",
 CellID->15645],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->18757]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->306419232],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->174659951],

Cell[TextData[ButtonBox["Evaluation Options in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationOptionsInNotebooks"]], "MoreAbout",
 CellID->512221935],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->535647487],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->267826554]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Evaluator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 59.6059862}", "context" -> "System`", 
    "keywords" -> {
     "evaluator", "cell evaluator", "notebook evaluator", "remote evaluator", 
      "local evaluator", "kernel evaluator", "frontend evaluator", 
      "multiple kernels"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Evaluator is an option for objects such as Button, Dynamic and Cell \
which gives the name of the kernel to use to evaluate their contents. ", 
    "synonyms" -> {}, "title" -> "Evaluator", "type" -> "Symbol", "uri" -> 
    "ref/Evaluator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5668, 176, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->517201677]},
 "Notebook Image"->{
  Cell[7182, 231, 2804, 49, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->19034637],
  Cell[10332, 298, 3279, 56, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->371474128]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18180, 509},
 {"Notebook Image", 18321, 513}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2814, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3437, 91, 47, 1, 70, "ObjectName",
 CellID->23245],
Cell[3487, 94, 915, 29, 70, "Usage",
 CellID->8201]
}, Open  ]],
Cell[CellGroupData[{
Cell[4439, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4917, 145, 170, 6, 70, "Notes",
 CellID->10572],
Cell[5090, 153, 239, 8, 70, "Notes",
 CellID->15882],
Cell[5332, 163, 299, 8, 70, "Notes",
 CellID->31722]
}, Closed]],
Cell[CellGroupData[{
Cell[5668, 176, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->517201677],
Cell[CellGroupData[{
Cell[6053, 190, 147, 5, 70, "ExampleSection",
 CellID->29006969],
Cell[6203, 197, 227, 8, 70, "ExampleText",
 CellID->41148611],
Cell[CellGroupData[{
Cell[6455, 209, 724, 20, 70, "Input",
 CellID->33621652],
Cell[7182, 231, 2804, 49, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->19034637]
}, Open  ]],
Cell[10001, 283, 189, 6, 70, "ExampleText",
 CellID->18961866],
Cell[CellGroupData[{
Cell[10215, 293, 114, 3, 70, "Input",
 CellID->964106627],
Cell[10332, 298, 3279, 56, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->371474128]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13672, 361, 311, 9, 70, "SeeAlsoSection",
 CellID->27886],
Cell[13986, 372, 998, 35, 70, "SeeAlso",
 CellID->8025]
}, Open  ]],
Cell[CellGroupData[{
Cell[15021, 412, 314, 9, 70, "TutorialsSection",
 CellID->25840],
Cell[15338, 423, 428, 12, 70, "Tutorials",
 CellID->15645],
Cell[15769, 437, 143, 3, 70, "Tutorials",
 CellID->18757]
}, Open  ]],
Cell[CellGroupData[{
Cell[15949, 445, 319, 9, 70, "MoreAboutSection",
 CellID->306419232],
Cell[16271, 456, 147, 3, 70, "MoreAbout",
 CellID->174659951],
Cell[16421, 461, 171, 3, 70, "MoreAbout",
 CellID->512221935],
Cell[16595, 466, 161, 3, 70, "MoreAbout",
 CellID->535647487],
Cell[16759, 471, 134, 3, 70, "MoreAbout",
 CellID->267826554]
}, Open  ]],
Cell[16908, 477, 27, 0, 70, "History"],
Cell[16938, 479, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

