(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23155,        827]
NotebookOptionsPosition[     17871,        646]
NotebookOutlinePosition[     19217,        684]
CellTagsIndexPosition[     19132,        679]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Setting Up Functions with Optional Arguments" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"Putting Constraints on Patterns\"\>", 
       3->"\<\"Setting Up Functions with Optional Arguments\"\>", 
       4->"\<\"String Patterns\"\>", 
       5->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PatternTest" :> 
          Documentation`HelpLookup["paclet:ref/PatternTest"], "Condition" :> 
          Documentation`HelpLookup["paclet:ref/Condition"], "DeleteCases" :> 
          Documentation`HelpLookup["paclet:ref/DeleteCases"], "Alternatives" :> 
          Documentation`HelpLookup["paclet:ref/Alternatives"], "Cases" :> 
          Documentation`HelpLookup["paclet:ref/Cases"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PatternTest\"\>", 2->"\<\"Condition\"\>", 
       3->"\<\"DeleteCases\"\>", 4->"\<\"Alternatives\"\>", 
       5->"\<\"Cases\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"],
           "Rules & Patterns" :> 
          Documentation`HelpLookup["paclet:guide/RulesAndPatterns"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Patterns\"\>", 
       2->"\<\"Rules & Patterns\"\>", 3->"\<\"String Manipulation\"\>", 
       4->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Except", "ObjectName",
 CellID->22023],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Except",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Except"], "[", 
       StyleBox["c", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a pattern object which represents any expression \
except one that matches ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Except",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Except"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents any expression that matches ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " but not ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->29300]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"], "[", 
   StyleBox["c", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", "_"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"], "[", 
   StyleBox["c", "TI"], "]"}]], "InlineFormula"],
 " represents the complement of the set of expressions that match ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17161],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Except",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Except"]], "InlineFormula"],
 " works in ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15798]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->451053802],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->1568091],

Cell["This gives all elements except 0:", "ExampleText",
 CellID->608208032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Except", "[", "0", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130234104],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614223898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52175313],

Cell["Delete all nonvowel characters from a string:", "ExampleText",
 CellID->244172038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<the cat in the hat\>\"", ",", 
   RowBox[{
    RowBox[{"Except", "[", 
     RowBox[{"Characters", "[", "\"\<aeiou\>\"", "]"}], "]"}], "\[Rule]", 
    "\"\<\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2105676896],

Cell[BoxData["\<\"eaiea\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62077013]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->172992361],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Except",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Except"]], "InlineFormula"],
 " works with patterns and string patterns:"
}], "ExampleText",
 CellID->904050847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "0", ",", "1", ",", "2", ",", "x", ",", "y"}],
     "}"}], ",", 
   RowBox[{"Except", "[", "_Integer", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->946433565],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "y"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56000029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<1a2b3c4\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Except", "[", "DigitCharacter", "]"}], ".."}], "\[Rule]", 
    "\"\<\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->935783004],

Cell[BoxData["\<\"1234\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172943062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124625295],

Cell["Constraints on patterns:", "ExampleText",
 CellID->1759220085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "0", ",", "1", ",", "2", ",", "x", ",", "y"}],
     "}"}], ",", 
   RowBox[{"Except", "[", 
    RowBox[{"0", ",", "_Integer"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1641861966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202194113]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<1a2b3c4\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Except", "[", 
      RowBox[{"\"\<a\>\"", ",", "LetterCharacter"}], "]"}], ".."}], 
    "\[Rule]", "\"\<\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->519811446],

Cell[BoxData["\<\"1a234\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->226472891]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->491788795],

Cell["Get all non-integers:", "ExampleText",
 CellID->674525350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "1", ",", " ", 
     RowBox[{"-", "5"}], ",", " ", "EulerGamma", ",", " ", "r", ",", " ", "I",
      ",", " ", "0", ",", " ", "Pi", ",", " ", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"Except", "[", "_Integer", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1545676562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"EulerGamma", ",", "r", ",", "\[ImaginaryI]", ",", "\[Pi]", ",", 
   FractionBox["1", "2"]}], "}"}]], "Output",
 ImageSize->{167, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297209032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195411744],

Cell["Find words containing nonword characters:", "ExampleText",
 CellID->94222495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<ain't\>\"", ",", "\"\<test\>\"", ",", " ", "\"\<A&M\>\"", ",", 
     "\"\<anybody\>\""}], "}"}], ",", " ", 
   RowBox[{"___", "~~", 
    RowBox[{"Except", "[", "WordCharacter", "]"}], "~~", "___"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155227723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275461848]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->344532492],

Cell["Strip off all tags \"<...>\" from an HTML document:", "ExampleText",
 CellID->775616074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", "\n", "  ", 
  RowBox[{
  "\"\<<title>The Title</title>\n<h1>The <a href='link'>head</a></h1>\n\
<p>Some text follows here...</p>\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<<\>\"", "~~", 
     RowBox[{
      RowBox[{"Except", "[", "\"\<>\>\"", "]"}], ".."}], "~~", "\"\<>\>\""}], 
    "\[Rule]", "\"\<\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1707486644],

Cell[BoxData["\<\"The Title\\nThe head\\nSome text follows here...\"\>"], \
"Output",
 ImageSize->{179, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140900712]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19071],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PatternTest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Condition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Condition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Alternatives",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Alternatives"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5730]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11748],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->29999],

Cell[TextData[ButtonBox["Setting Up Functions with Optional Arguments",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"]], "Tutorials",
 CellID->208660540],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->86397106],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->237062299],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "MoreAbout",
 CellID->651960399],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->109422934],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->15845955]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Except - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 37.9819686}", "context" -> "System`", 
    "keywords" -> {
     "avoiding matches", "complementary patterns", "excluded patterns"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Except[c] is a pattern object which represents any expression except one \
that matches c. Except[c, p] represents any expression that matches p but not \
c. ", "synonyms" -> {}, "title" -> "Except", "type" -> "Symbol", "uri" -> 
    "ref/Except"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6758, 211, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->451053802]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18989, 672}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3345, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3968, 100, 44, 1, 70, "ObjectName",
 CellID->22023],
Cell[4015, 103, 1098, 36, 70, "Usage",
 CellID->29300]
}, Open  ]],
Cell[CellGroupData[{
Cell[5150, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5628, 161, 430, 17, 70, "Notes",
 CellID->14517],
Cell[6061, 180, 342, 12, 70, "Notes",
 CellID->17161],
Cell[6406, 194, 315, 12, 70, "Notes",
 CellID->15798]
}, Closed]],
Cell[CellGroupData[{
Cell[6758, 211, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->451053802],
Cell[CellGroupData[{
Cell[7143, 225, 146, 5, 70, "ExampleSection",
 CellID->1568091],
Cell[7292, 232, 76, 1, 70, "ExampleText",
 CellID->608208032],
Cell[CellGroupData[{
Cell[7393, 237, 237, 7, 28, "Input",
 CellID->130234104],
Cell[7633, 246, 213, 7, 36, "Output",
 CellID->614223898]
}, Open  ]],
Cell[7861, 256, 124, 3, 70, "ExampleDelimiter",
 CellID->52175313],
Cell[7988, 261, 88, 1, 70, "ExampleText",
 CellID->244172038],
Cell[CellGroupData[{
Cell[8101, 266, 287, 8, 70, "Input",
 CellID->2105676896],
Cell[8391, 276, 169, 5, 36, "Output",
 CellID->62077013]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8609, 287, 220, 7, 70, "ExampleSection",
 CellID->172992361],
Cell[8832, 296, 214, 7, 70, "ExampleText",
 CellID->904050847],
Cell[CellGroupData[{
Cell[9071, 307, 269, 8, 70, "Input",
 CellID->946433565],
Cell[9343, 317, 222, 7, 36, "Output",
 CellID->56000029]
}, Open  ]],
Cell[CellGroupData[{
Cell[9602, 329, 258, 8, 70, "Input",
 CellID->935783004],
Cell[9863, 339, 169, 5, 36, "Output",
 CellID->172943062]
}, Open  ]],
Cell[10047, 347, 125, 3, 70, "ExampleDelimiter",
 CellID->124625295],
Cell[10175, 352, 68, 1, 70, "ExampleText",
 CellID->1759220085],
Cell[CellGroupData[{
Cell[10268, 357, 295, 9, 70, "Input",
 CellID->1641861966],
Cell[10566, 368, 203, 7, 36, "Output",
 CellID->202194113]
}, Open  ]],
Cell[CellGroupData[{
Cell[10806, 380, 294, 9, 70, "Input",
 CellID->519811446],
Cell[11103, 391, 170, 5, 36, "Output",
 CellID->226472891]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11322, 402, 227, 7, 70, "ExampleSection",
 CellID->491788795],
Cell[11552, 411, 64, 1, 70, "ExampleText",
 CellID->674525350],
Cell[CellGroupData[{
Cell[11641, 416, 388, 10, 70, "Input",
 CellID->1545676562],
Cell[12032, 428, 281, 8, 51, "Output",
 CellID->297209032]
}, Open  ]],
Cell[12328, 439, 125, 3, 70, "ExampleDelimiter",
 CellID->195411744],
Cell[12456, 444, 83, 1, 70, "ExampleText",
 CellID->94222495],
Cell[CellGroupData[{
Cell[12564, 449, 358, 11, 70, "Input",
 CellID->155227723],
Cell[12925, 462, 240, 8, 36, "Output",
 CellID->275461848]
}, Open  ]],
Cell[13180, 473, 125, 3, 70, "ExampleDelimiter",
 CellID->344532492],
Cell[13308, 478, 94, 1, 70, "ExampleText",
 CellID->775616074],
Cell[CellGroupData[{
Cell[13427, 483, 415, 11, 70, "Input",
 CellID->1707486644],
Cell[13845, 496, 216, 6, 71, "Output",
 CellID->140900712]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14122, 509, 311, 9, 70, "SeeAlsoSection",
 CellID->19071],
Cell[14436, 520, 1201, 44, 70, "SeeAlso",
 CellID->5730]
}, Open  ]],
Cell[CellGroupData[{
Cell[15674, 569, 314, 9, 70, "TutorialsSection",
 CellID->11748],
Cell[15991, 580, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[16172, 585, 170, 3, 70, "Tutorials",
 CellID->29999],
Cell[16345, 590, 201, 4, 70, "Tutorials",
 CellID->208660540],
Cell[16549, 596, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[16691, 601, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[16906, 610, 318, 9, 70, "MoreAboutSection",
 CellID->86397106],
Cell[17227, 621, 128, 3, 70, "MoreAbout",
 CellID->237062299],
Cell[17358, 626, 144, 3, 70, "MoreAbout",
 CellID->651960399],
Cell[17505, 631, 149, 3, 70, "MoreAbout",
 CellID->109422934],
Cell[17657, 636, 140, 3, 70, "MoreAbout",
 CellID->15845955]
}, Open  ]],
Cell[17812, 642, 29, 0, 70, "History"],
Cell[17844, 644, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

