(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14842,        545]
NotebookOptionsPosition[     11423,        434]
NotebookOutlinePosition[     12925,        474]
CellTagsIndexPosition[     12840,        469]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplification" :> 
          Documentation`HelpLookup["paclet:tutorial/Simplification"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Simplification\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TimeConstraint" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstraint"], 
          "ComplexityFunction" :> 
          Documentation`HelpLookup["paclet:ref/ComplexityFunction"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "TrigFactor" :> Documentation`HelpLookup["paclet:ref/TrigFactor"], 
          "TransformationFunctions" :> 
          Documentation`HelpLookup["paclet:ref/TransformationFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"TimeConstraint\"\>", 
       2->"\<\"ComplexityFunction\"\>", 3->"\<\"Simplify\"\>", 
       4->"\<\"TrigFactor\"\>", 
       5->"\<\"TransformationFunctions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExcludedForms", "ObjectName",
 CellID->2053],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ExcludedForms",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ExcludedForms"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["FullSimplify",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
     " which can be set to a list of patterns for expressions that should not \
be touched if they are encountered at intermediate steps in the operation of \
",
     Cell[BoxData[
      ButtonBox["FullSimplify",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->73]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["ExcludedForms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExcludedForms"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14153],

Cell[TextData[{
 "A setting such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"], "[", "_", "]"}]], "InlineFormula"],
 " will cause ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to treat gamma functions as elementary objects which should not be \
transformed. "
}], "Notes",
 CellID->5267]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->162462519],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->568515823],

Cell["This gives no simplification:", "ExampleText",
 CellID->419935635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124051613],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], "10"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{207, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277045434]
}, Open  ]],

Cell[TextData[{
 "Excluding transformations of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     StyleBox["x", "TI"], "-", "2"}], ")"}], "^", "10"}]], "InlineFormula"],
 " allows you to expand the remaining terms:"
}], "ExampleText",
 CellID->303413799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "^", "10"}]}], ",", 
   RowBox[{"ExcludedForms", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", "_Plus", ")"}], "^", "_"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202603875],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], "10"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "4"]}], ")"}]}]], "Output",
 ImageSize->{120, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->329556341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->637805310],

Cell[TextData[{
 "This gives a result in terms of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], "[", "x", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->146600868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], "+", 
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"3", "y"}]}], "]"}], "-", 
   RowBox[{"2", 
    RowBox[{"Im", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164581558],

Cell[BoxData[
 RowBox[{
  RowBox[{"Arg", "[", "x", "]"}], "-", 
  RowBox[{"3", " ", 
   RowBox[{"Im", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156308582]
}, Open  ]],

Cell[TextData[{
 "This specifies that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", "x", "]"}]], "InlineFormula"],
 " should not be transformed:"
}], "ExampleText",
 CellID->1505484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Im", "[", 
     RowBox[{
      RowBox[{"Log", "[", "x", "]"}], "+", 
      RowBox[{"2", " ", "x"}], "-", 
      RowBox[{"3", "y"}]}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"Im", "[", "x", "]"}]}]}], ",", 
   RowBox[{"ExcludedForms", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Log", "[", "_", "]"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->898901276],

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", "y"}], "+", 
   RowBox[{"Log", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->249191958]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23687],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstraint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstraint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexityFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexityFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationFunctions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->75665943]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4293],

Cell[TextData[ButtonBox["Simplification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Simplification"]], "Tutorials",
 CellID->20267]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExcludedForms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 38.2163496}", "context" -> "System`", 
    "keywords" -> {
     "atomic subexpressions", "subexpressions", "simplify exclusions", 
      "partial simplification", "constrained simplification"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ExcludedForms is an option for FullSimplify which can be set to a list \
of patterns for expressions that should not be touched if they are \
encountered at intermediate steps in the operation of FullSimplify. ", 
    "synonyms" -> {"excluded forms"}, "title" -> "ExcludedForms", "type" -> 
    "Symbol", "uri" -> "ref/ExcludedForms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4481, 149, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->162462519]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12697, 462}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1670, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2293, 66, 50, 1, 70, "ObjectName",
 CellID->2053],
Cell[2346, 69, 866, 25, 70, "Usage",
 CellID->73]
}, Open  ]],
Cell[CellGroupData[{
Cell[3249, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3727, 116, 273, 11, 70, "Notes",
 CellID->14153],
Cell[4003, 129, 441, 15, 70, "Notes",
 CellID->5267]
}, Closed]],
Cell[CellGroupData[{
Cell[4481, 149, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->162462519],
Cell[CellGroupData[{
Cell[4866, 163, 148, 5, 70, "ExampleSection",
 CellID->568515823],
Cell[5017, 170, 72, 1, 70, "ExampleText",
 CellID->419935635],
Cell[CellGroupData[{
Cell[5114, 175, 381, 14, 28, "Input",
 CellID->124051613],
Cell[5498, 191, 483, 18, 39, "Output",
 CellID->277045434]
}, Open  ]],
Cell[5996, 212, 267, 9, 70, "ExampleText",
 CellID->303413799],
Cell[CellGroupData[{
Cell[6288, 225, 539, 19, 28, "Input",
 CellID->202603875],
Cell[6830, 246, 369, 14, 39, "Output",
 CellID->329556341]
}, Open  ]],
Cell[7214, 263, 125, 3, 70, "ExampleDelimiter",
 CellID->637805310],
Cell[7342, 268, 236, 9, 70, "ExampleText",
 CellID->146600868],
Cell[CellGroupData[{
Cell[7603, 281, 326, 11, 70, "Input",
 CellID->164581558],
Cell[7932, 294, 264, 9, 36, "Output",
 CellID->156308582]
}, Open  ]],
Cell[8211, 306, 248, 9, 70, "ExampleText",
 CellID->1505484],
Cell[CellGroupData[{
Cell[8484, 319, 457, 15, 70, "Input",
 CellID->898901276],
Cell[8944, 336, 285, 10, 36, "Output",
 CellID->249191958]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9290, 353, 311, 9, 70, "SeeAlsoSection",
 CellID->23687],
Cell[9604, 364, 1255, 44, 70, "SeeAlso",
 CellID->75665943]
}, Open  ]],
Cell[CellGroupData[{
Cell[10896, 413, 313, 9, 70, "TutorialsSection",
 CellID->4293],
Cell[11212, 424, 139, 3, 70, "Tutorials",
 CellID->20267]
}, Open  ]],
Cell[11366, 430, 27, 0, 70, "History"],
Cell[11396, 432, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

