(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    109577,       2189]
NotebookOptionsPosition[    105142,       2049]
NotebookOutlinePosition[    106757,       2091]
CellTagsIndexPosition[    106670,       2086]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ClippingStyle" :> 
          Documentation`HelpLookup["paclet:ref/ClippingStyle"], 
          "BoundaryStyle" :> 
          Documentation`HelpLookup["paclet:ref/BoundaryStyle"], 
          "FillingStyle" :> 
          Documentation`HelpLookup["paclet:ref/FillingStyle"], "Exclusions" :> 
          Documentation`HelpLookup["paclet:ref/Exclusions"], "RegionFunction" :> 
          Documentation`HelpLookup["paclet:ref/RegionFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ClippingStyle\"\>", 
       2->"\<\"BoundaryStyle\"\>", 3->"\<\"FillingStyle\"\>", 
       4->"\<\"Exclusions\"\>", 
       5->"\<\"RegionFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ExclusionsStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ExclusionsStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ExclusionsStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option to plotting functions that specifies how \
to render subregions excluded according to ",
     Cell[BoxData[
      ButtonBox["Exclusions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Exclusions"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->198614931],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["s", "TI"], Cell[TextData[{
     "use style ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " for the interiors of excluded subregions "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["b", "TI"]]}], "}"}], Cell[TextData[{
     "use style ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["b", "TI"]]], "InlineFormula"],
     " for the boundaries of excluded subregions"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "leave excluded subregions blank", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "draw excluded subregions the same as outside ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->772960929],

Cell[TextData[{
 "The styles ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["b", "TI"]]], "InlineFormula"],
 " can use color, thickness, point size and other graphics directives. \
Composite directives can be given using ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9292039],

Cell[TextData[{
 "For single-parameter plotting functions such as ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"ExclusionsStyle", "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " specifies that style ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " should be used to render lines joining opposite sides of each excluded \
point. \n",
 Cell[BoxData[
  RowBox[{"ExclusionsStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["s", "TI"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["b", "TI"]]}], "}"}]}]], "InlineFormula"],
 " uses style ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["b", "TI"]]], "InlineFormula"],
 " for the endpoint of the curves on either side of an excluded point."
}], "Notes",
 CellID->543708848],

Cell[TextData[{
 "For two-parameter plotting functions such as ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"ExclusionsStyle", "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " uses style ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " to render the ruled surface that joins opposite sides of each excluded \
curve. ",
 Cell[BoxData[
  RowBox[{"ExclusionsStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["s", "TI"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["b", "TI"]]}], "}"}]}]], "InlineFormula"],
 " uses style ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["b", "TI"]]], "InlineFormula"],
 " for the boundary curves of the surfaces on either side of an excluded \
curve."
}], "Notes",
 CellID->242994306],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"ExclusionsStyle", "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " is taken to be equivalent to ",
 Cell[BoxData[
  RowBox[{"ExclusionsStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["s", "TI"], ",", 
     StyleBox["s", "TI"]}], "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->501323250]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38567674],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->6987590],

Cell["Use red to show excluded portions of the surface:", "ExampleText",
 CellID->2073258236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "5"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->968992524],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6605474]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->996943385],

Cell["Use transparency to show excluded portions of the surface:", \
"ExampleText",
 CellID->1708422121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.5", "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1594227257],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208113522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->184586232],

Cell["\<\
Use red around the edges of the excluded portions of the surface:\
\>", "ExampleText",
 CellID->809709553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "5"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181516230],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21829621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->610090757],

Cell["\<\
Use red lines to connect portions of the curve and blue points where there \
are jumps:\
\>", "ExampleText",
 CellID->564088130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279288267],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL9v00AUfvGlwmKIYEModo3KUFbEFAnVCCmIoeofwGQqIB1KUemKyi+p
sJeBhcwdoEMrdejAP4BgY0JiYkMgkFCXVNd3P5xcnu/soxGllFqJ7e/e+z6/
l7v3LvJ0ttS5NZ8tzc1mybXF7F5nbvZ+0l5YxCFWA4BN/D44A3jP8U5+NznH
q3mexDNDU4TXur4KfE5YxQ2XBzT1+JhkXSDWyMB4hoTYY4LHCQ6sqlWspo6Z
Ps2uZmMHCM1xsGTupxbxYuy5euD83UQMUB/gYi6RJUpJ6s+e+ZTYMXt5NIpl
zn9IPNd8Rruv3uEHYnFiN65/RL9Oh8Mz6SUyfYNONavSaVseBmY5TpPP3W7R
TjHVo/hkBX9UvcCapfy9+fIync2U4IlS9nNPa38F/Abnz1mPozmoaHQ564Ou
5GHfgFiZxRvYytVtXcsar3CN7zhVmO47wKLGN7Qwtgvxwt0NYI3GL8RhWMYu
xrDxeufSxZ1HD79D/OH9F2AvVr+m8Fb0Aj8VVWO8j2+PwFJu6hjzYtAZc3uJ
tXBlRI2D9zqO+qhFXbf0Dkc16H5jAIMzJfGgY9AO0uauOhRQsZOEWzrIiXpP
s2nVUjWlsrXFW63eUAdpnf3UnVn3VMm46pxtnaj5/4xmTXxL+sWwZz6/Nwuj
5Zy/ZT1csR7laFjl2vFZv2V7+XmnioCK3Tz1Ay1B0IN46vJLYGH4U+/lil21
0mUVpikX+3bcx2ofVwpVO/ITPtyDJrxyd7AsUdo98/l86rT6aRxWr38zt/8z
6v1VyP5Ytn8BjyWmfcN8VyJqSkDlqXZv0TMS2TNw89VKNc3UNEs1KoVBz6ju
MmvWbNflaPE9F9T2AA0BkVE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26213731]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1341650270],

Cell["Use black to indicate discontinuities in the density:", "ExampleText",
 CellID->537794390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2099126154],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430091825]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClippingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClippingStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoundaryStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BoundaryStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FillingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FillingStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exclusions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exclusions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->494196041],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->598340814]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExclusionsStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 41.7789408}", "context" -> "System`", 
    "keywords" -> {
     "singular points", "singular curves", "discontinuity points", 
      "discontinuity curves", "exclusion points", "exclusion curves", 
      "branch cuts", "branch cut points", "branch cut curves", "pole points", 
      "pole curves", "jump points", "jump curves", "styling of jumps", 
      "styling of asymptotes"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExclusionsStyle is an option to plotting functions that specifies how to \
render subregions excluded according to Exclusions. ", 
    "synonyms" -> {"exclusions style"}, "title" -> "ExclusionsStyle", "type" -> 
    "Symbol", "uri" -> "ref/ExclusionsStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9434, 301, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->38567674]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 106528, 2079}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1865, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2488, 70, 1580, 37, 70, "ObjectNameGrid"],
Cell[4071, 109, 651, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4759, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5237, 150, 73, 1, 70, "Notes",
 CellID->198614931],
Cell[5313, 153, 1318, 38, 70, "2ColumnTableMod",
 CellID->772960929],
Cell[6634, 193, 472, 17, 70, "Notes",
 CellID->9292039],
Cell[7109, 212, 894, 30, 70, "Notes",
 CellID->543708848],
Cell[8006, 244, 894, 31, 70, "Notes",
 CellID->242994306],
Cell[8903, 277, 494, 19, 70, "Notes",
 CellID->501323250]
}, Closed]],
Cell[CellGroupData[{
Cell[9434, 301, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38567674],
Cell[CellGroupData[{
Cell[9818, 315, 146, 5, 70, "ExampleSection",
 CellID->6987590],
Cell[9967, 322, 93, 1, 70, "ExampleText",
 CellID->2073258236],
Cell[CellGroupData[{
Cell[10085, 327, 572, 18, 47, "Input",
 CellID->968992524],
Cell[10660, 347, 22122, 367, 173, "Output",
 Evaluatable->False,
 CellID->6605474]
}, Open  ]],
Cell[32797, 717, 125, 3, 70, "ExampleDelimiter",
 CellID->996943385],
Cell[32925, 722, 104, 2, 70, "ExampleText",
 CellID->1708422121],
Cell[CellGroupData[{
Cell[33054, 728, 550, 17, 47, "Input",
 CellID->1594227257],
Cell[33607, 747, 17931, 298, 172, "Output",
 Evaluatable->False,
 CellID->208113522]
}, Open  ]],
Cell[51553, 1048, 125, 3, 70, "ExampleDelimiter",
 CellID->184586232],
Cell[51681, 1053, 116, 3, 70, "ExampleText",
 CellID->809709553],
Cell[CellGroupData[{
Cell[51822, 1060, 626, 20, 47, "Input",
 CellID->181516230],
Cell[52451, 1082, 20655, 343, 173, "Output",
 Evaluatable->False,
 CellID->21829621]
}, Open  ]],
Cell[73121, 1428, 125, 3, 70, "ExampleDelimiter",
 CellID->610090757],
Cell[73249, 1433, 138, 4, 70, "ExampleText",
 CellID->564088130],
Cell[CellGroupData[{
Cell[73412, 1441, 325, 10, 28, "Input",
 CellID->279288267],
Cell[73740, 1453, 1090, 22, 146, "Output",
 Evaluatable->False,
 CellID->26213731]
}, Open  ]],
Cell[74845, 1478, 126, 3, 70, "ExampleDelimiter",
 CellID->1341650270],
Cell[74974, 1483, 96, 1, 70, "ExampleText",
 CellID->537794390],
Cell[CellGroupData[{
Cell[75095, 1488, 534, 17, 28, "Input",
 CellID->2099126154],
Cell[75632, 1507, 27142, 449, 204, "Output",
 Evaluatable->False,
 CellID->430091825]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102835, 1963, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[103154, 1974, 1234, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[104425, 2023, 299, 8, 70, "MoreAboutSection"],
Cell[104727, 2033, 143, 3, 70, "MoreAbout",
 CellID->494196041],
Cell[104873, 2038, 197, 4, 70, "MoreAbout",
 CellID->598340814]
}, Open  ]],
Cell[105085, 2045, 27, 0, 70, "History"],
Cell[105115, 2047, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

