(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77650,       2914]
NotebookOptionsPosition[     64416,       2453]
NotebookOutlinePosition[     65975,       2494]
CellTagsIndexPosition[     65889,       2489]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quantifiers" :> 
          Documentation`HelpLookup["paclet:tutorial/Quantifiers"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Quantifiers\"\>", 
       2->"\<\"Complex Polynomial Systems\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ForAll" :> Documentation`HelpLookup["paclet:ref/ForAll"], 
          "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Resolve" :> 
          Documentation`HelpLookup["paclet:ref/Resolve"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "Eliminate" :> 
          Documentation`HelpLookup["paclet:ref/Eliminate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ForAll\"\>", 
       2->"\<\"FindInstance\"\>", 3->"\<\"Resolve\"\>", 4->"\<\"Reduce\"\>", 
       5->"\<\"Element\"\>", 6->"\<\"Eliminate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Logic & Boolean Algebra\"\>",
        2->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Exists ",
 StyleBox["(\[Exists])", "OperatorCharacter"]
}], "ObjectName",
 CellID->12424],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Exists",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Exists"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the statement that there exists a value of ",
     
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " for which ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Exists",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Exists"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["cond", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]states that there exists an ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " satisfying the condition ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     " for which ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Exists",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Exists"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]states that there exist values for all the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     " for which ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17643]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Exists]", "x"], 
    StyleBox["expr", "TI"]}], TraditionalForm]], "InlineMath"],
 ". The character ",
 Cell[BoxData[
  FormBox["\[Exists]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ex\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[BoxData["\\[Exists]"], "InlineCharacterName"],
 ". The variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is given as a subscript. "
}], "Notes",
 CellID->22958],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["cond", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Exists]", 
     RowBox[{"x", ",", 
      StyleBox["cond", "TI"]}]], 
    StyleBox["expr", "TI"]}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->7187],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is output as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Exists]", "x"], 
    StyleBox["expr", "TI"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->12167],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["cond", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is output as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Exists]", 
     RowBox[{"x", ",", 
      StyleBox["cond", "TI"]}]], 
    StyleBox["expr", "TI"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->3892],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exists"]], "InlineFormula"],
 " can be used in such functions as ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25660],

Cell[TextData[{
 "The condition ",
 Cell[BoxData[
  StyleBox["cond", "TI"]], "InlineFormula"],
 " is often used to specify the domain of a variable, as in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->613],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["cond", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{
     StyleBox["cond", "TI"], "&&", 
     StyleBox["expr", "TI"]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9176],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Exists]", 
     SubscriptBox["x", "1"]], 
    RowBox[{
     SubscriptBox["\[Exists]", 
      SubscriptBox["x", "2"]], "\[Ellipsis]"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->4267],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be localized, as in ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18401]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->773092766],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->319695193],

Cell[TextData[{
 "This states that there exists a positive solution to the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "\[LongEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->204316434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], " ", "&&", " ", 
    
    RowBox[{"x", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70687862],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", "x"], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"x", ">", "0"}]}], ")"}]}]], "Output",
 ImageSize->{178, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->240926751]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to get a condition on real parameters for which the statement is true:"
}], "ExampleText",
 CellID->9573649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"%", ",", " ", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->430461369],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{"b", " ", "c"}], "<", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", " ", "b"}], "<", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[LessEqual]", "0"}]}], ")"}], "||",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", " ", "c"}], "<", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[LessEqual]", "0"}]}], 
   ")"}]}]], "Output",
 ImageSize->{431, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->629151334]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives the condition in a solved form:"
}], "ExampleText",
 CellID->713782625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%%", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->337761020],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "<", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "\[LessEqual]", "0"}], "&&", 
        RowBox[{"c", ">", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", ">", "0"}], "&&", 
        RowBox[{"c", "\[GreaterEqual]", 
         FractionBox[
          SuperscriptBox["b", "2"], 
          RowBox[{"4", " ", "a"}]]}]}], ")"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "<", "0"}], "&&", 
        RowBox[{"c", ">", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "\[Equal]", "0"}], "&&", 
        RowBox[{"c", "\[Equal]", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", ">", "0"}], "&&", 
        RowBox[{"c", "<", "0"}]}], ")"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "<", "0"}], "&&", 
        RowBox[{"c", "\[LessEqual]", 
         FractionBox[
          SuperscriptBox["b", "2"], 
          RowBox[{"4", " ", "a"}]]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "\[GreaterEqual]", "0"}], "&&", 
        RowBox[{"c", "<", "0"}]}], ")"}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{421, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->211923453]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10986],

Cell[TextData[{
 "This states that there exists ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " for which the equation is true:"
}], "ExampleText",
 CellID->46228782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "x", "+", "1"}], "\[Equal]", "0"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331483428],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", "x"], 
  RowBox[{
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"]}], "\[Equal]", "0"}]}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14455788]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove that the statement is true:"
}], "ExampleText",
 CellID->337485886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65029305],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->328095969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122518545],

Cell[TextData[{
 "This states that there exists a real ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " for which the equation is true:"
}], "ExampleText",
 CellID->576543645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "x", "+", "1"}], "\[Equal]", "0"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157594200],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", 
   RowBox[{"x", ",", 
    RowBox[{"x", "\[Element]", "Reals"}]}]], 
  RowBox[{
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"]}], "\[Equal]", "0"}]}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5613543]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove that the statement is false:"
}], "ExampleText",
 CellID->36144885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158538849],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->338978357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35607302],

Cell[TextData[{
 "This states that there exists a pair ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
 " for which the inequality is true:"
}], "ExampleText",
 CellID->2016847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49125088],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]], 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "<", "0"}]}]], "Output",
 ImageSize->{99, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252318569]
}, Open  ]],

Cell[TextData[{
 "With domain not specified, ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " considers algebraic variables in inequalities to be real:"
}], "ExampleText",
 CellID->156930490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93535409],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->486880242]
}, Open  ]],

Cell[TextData[{
 "With domain ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 ", complex values that make the inequality ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " are allowed:"
}], "ExampleText",
 CellID->228888947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"%%", ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->152035922],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156955105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350705895],

Cell["This states that the negation of a tautology is satisfiable:", \
"ExampleText",
 CellID->803953843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "q"}], "}"}], ",", 
   RowBox[{"!", 
    RowBox[{"Implies", "[", 
     RowBox[{
      RowBox[{"p", "&&", 
       RowBox[{"Implies", "[", 
        RowBox[{"p", ",", "q"}], "]"}]}], ",", "q"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216912110],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", 
   RowBox[{"{", 
    RowBox[{"p", ",", "q"}], "}"}]], 
  RowBox[{"(", 
   RowBox[{"!", 
    RowBox[{"Implies", "[", 
     RowBox[{
      RowBox[{"p", "&&", 
       RowBox[{"Implies", "[", 
        RowBox[{"p", ",", "q"}], "]"}]}], ",", "q"}], "]"}]}], 
   ")"}]}]], "Output",
 ImageSize->{260, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[1]= ]",
 CellID->63509172]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to prove it ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->454281492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->319790039],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[2]= ]",
 CellID->511220122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->373276802],

Cell[TextData[{
 "If the expression does not explicitly contain the variable, ",
 Cell[BoxData[
  ButtonBox["Exists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exists"]], "InlineFormula"],
 " simplifies automatically:"
}], "ExampleText",
 CellID->217337348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{"x", ",", 
   RowBox[{"y", "\[Equal]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->761623207],

Cell[BoxData[
 RowBox[{"y", "\[Equal]", "0"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2156816]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"y", "\[Equal]", "z"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->124115997],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]], 
  RowBox[{"y", "\[Equal]", "z"}]}]], "Output",
 ImageSize->{71, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36544364]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556421747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->152306183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{"p", "[", "x", "]"}]}], "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->8899254],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[Exists]", "x"], 
   RowBox[{"p", "(", "x", ")"}]}], TraditionalForm]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"HoldForm[Out[1]//TraditionalForm= ]",
 CellID->186692835]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->903],

Cell["This states that a quadratic attains negative values:", "ExampleText",
 CellID->201343094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"b", " ", "x"}], "+", "c"}], "<", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3722289],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", "x"], 
  RowBox[{
   RowBox[{"c", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}]}], "<", "0"}]}]], "Output",
 ImageSize->{113, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3213650]
}, Open  ]],

Cell["This gives explicit conditions on real parameters:", "ExampleText",
 CellID->571354619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"%", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32866358],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "<", "0"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "<", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[NotEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", "c"}]}], "<", "0"}]}], 
   ")"}]}]], "Output",
 ImageSize->{435, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->758716497]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97572279],

Cell["Test whether one region is included in another:", "ExampleText",
 CellID->102801770],

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "x"}], ")"}], "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"2", " ", "x", " ", "y"}]}], "\[LessEqual]", "1"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "2"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->165438567],

Cell[TextData[{
 "This states that there are points satisfying ",
 Cell[BoxData["R1"], "InlineFormula"],
 " and not ",
 Cell[BoxData["R2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->54453802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "|", "y"}], ",", "Reals"}], "]"}], ",", 
   RowBox[{"R1", "&&", 
    RowBox[{"!", "R2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->356275993],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "|", "y"}], ")"}], "\[Element]", "Reals"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"2", " ", "x", " ", "y"}], "+", 
      SuperscriptBox["y", "2"]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ">", "2"}]}], ")"}]}]], "Output",
 ImageSize->{301, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138165353]
}, Open  ]],

Cell[TextData[{
 "The statement is false, hence the region defined by ",
 Cell[BoxData["R1"], "InlineFormula"],
 " is included in the region defined by ",
 Cell[BoxData["R2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->202488301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->52993724],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->88722386]
}, Open  ]],

Cell["Plot the relationship:", "ExampleText",
 CellID->241929558],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r1", ",", "r2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RegionPlot", "[", 
      RowBox[{"R1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "35"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Pink"}]}], "]"}], ",", 
     RowBox[{"RegionPlot", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->35717418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"r2", ",", "r1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->204010330],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->645693997]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215876008],

Cell["Test geometric conjectures:", "ExampleText",
 CellID->202110312],

Cell[BoxData[{
 RowBox[{
  RowBox[{"triangle", "=", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ">", "a"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"s", 
     RowBox[{"(", 
      RowBox[{"s", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "-", "b"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "-", "c"}], ")"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conjecture", "=", 
   RowBox[{
    RowBox[{"27", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}], "-", 
        RowBox[{"a", "^", "2"}]}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "+", 
        RowBox[{"c", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "+", 
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"c", "^", "2"}]}], ")"}], "^", "2"}]}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"4", "F"}], ")"}], "^", "6"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->186965933],

Cell["\<\
This states that there is a triangle for which the conjecture is not true:\
\>", "ExampleText",
 CellID->20584758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"a", "|", "b", "|", "c"}], ",", "Reals"}], "]"}], ",", 
   RowBox[{"triangle", " ", "&&", 
    RowBox[{"!", "conjecture"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->244596046],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "|", "b", "|", "c"}], ")"}], "\[Element]", "Reals"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ">", "a"}], "&&", 
    RowBox[{
     RowBox[{"27", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ">", 
     RowBox[{"512", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "b", "+", "c"}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "b"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "c"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ")"}], "3"]}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{502, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73194851]
}, Open  ]],

Cell["\<\
The statement is true, hence the conjecture is not true for arbitrary \
triangles:\
\>", "ExampleText",
 CellID->104592719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->282069049],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79933624]
}, Open  ]],

Cell["\<\
This states that there is an acute triangle for which the conjecture is not \
true:\
\>", "ExampleText",
 CellID->153691016],

Cell[BoxData[
 RowBox[{
  RowBox[{"acute", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], ">", 
     RowBox[{"c", "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], ">", 
     RowBox[{"b", "^", "2"}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", "2"}], "+", 
      RowBox[{"c", "^", "2"}]}], ">", 
     RowBox[{"a", "^", "2"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27660955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"a", "|", "b", "|", "c"}], ",", "Reals"}], "]"}], ",", 
   RowBox[{"triangle", " ", "&&", "acute", "&&", 
    RowBox[{"!", "conjecture"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->90216989],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "|", "b", "|", "c"}], ")"}], "\[Element]", "Reals"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ">", "a"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], ">", 
     SuperscriptBox["c", "2"]}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["c", "2"]}], ">", 
     SuperscriptBox["b", "2"]}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ">", 
     SuperscriptBox["a", "2"]}], "&&", 
    RowBox[{
     RowBox[{"27", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "+", 
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ">", 
     RowBox[{"512", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "b", "+", "c"}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "b"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "c"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ")"}], "3"]}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{553, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->95882385]
}, Open  ]],

Cell["\<\
The statement is false, hence the conjecture is true for all acute triangles:\
\
\>", "ExampleText",
 CellID->224820717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->430045710],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->400552996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->151317666],

Cell["Prove that a statement is a tautology:", "ExampleText",
 CellID->138659453],

Cell[BoxData[
 RowBox[{
  RowBox[{"statement", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "&&", 
          RowBox[{"!", 
           RowBox[{"(", 
            RowBox[{"b", "||", 
             RowBox[{"(", 
              RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}]}], ")"}], "||", "b", 
        "||", 
        RowBox[{"(", 
         RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"!", "a"}], "||", 
    RowBox[{"!", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "&&", 
         RowBox[{"!", 
          RowBox[{"(", 
           RowBox[{"b", "||", 
            RowBox[{"(", 
             RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}]}], ")"}], "||", "b", "||",
        
       RowBox[{"(", 
        RowBox[{"a", "&&", "c"}], ")"}]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3979005],

Cell[TextData[{
 "This proves that there are no values of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " for which the statement is not true:"
}], "ExampleText",
 CellID->112768003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"!", "statement"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->554407093],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47306787]
}, Open  ]],

Cell[TextData[{
 "This can be proven with ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " as well:"
}], "ExampleText",
 CellID->231647836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "statement", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->76307263],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->753134653]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22471],

Cell[TextData[{
 "Negation of ",
 Cell[BoxData[
  ButtonBox["Exists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exists"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["ForAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ForAll"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->375346019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{"x", "\[Equal]", "a"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306369163],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", "x"], 
  RowBox[{"x", "\[NotEqual]", "a"}]}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160024950]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}], ",", 
    RowBox[{"x", "\[Equal]", "a"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402630171],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{"x", ",", 
    RowBox[{"x", "\[Element]", "Reals"}]}]], 
  RowBox[{"x", "\[NotEqual]", "a"}]}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->586004797]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86081891],

Cell[TextData[{
 "Quantifiers can be eliminated using ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->125926680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"form", "=", 
  RowBox[{"Exists", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{"x", "\[NotEqual]", "y"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "x"}], "+", "c"}], "\[Equal]", "0"}], " ", "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "y"}], "+", "c"}], "\[Equal]", "0"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->645716618],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[NotEqual]", "y"}], "&&", 
    RowBox[{
     RowBox[{"c", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"c", "+", 
      RowBox[{"b", " ", "y"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["y", "2"]}]}], "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{313, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14146672]
}, Open  ]],

Cell["This eliminates the quantifier:", "ExampleText",
 CellID->499650896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"form", ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->457795290],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{313, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248625557]
}, Open  ]],

Cell["\<\
This eliminates the quantifier and solves the resulting equations and \
inequalities:\
\>", "ExampleText",
 CellID->269908548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"form", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->84668305],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "<", "0"}], "&&", 
    RowBox[{"c", ">", 
     FractionBox[
      SuperscriptBox["b", "2"], 
      RowBox[{"4", " ", "a"}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"c", "<", 
     FractionBox[
      SuperscriptBox["b", "2"], 
      RowBox[{"4", " ", "a"}]]}]}], ")"}]}]], "Output",
 ImageSize->{397, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->260834089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41635157],

Cell["This shows that a system of inequalities has solutions:", "ExampleText",
 CellID->305478949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ineqs", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "2"}], "&&", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"y", "-", "1"}], ")"}], "^", "2"}]}], "<", "2"}]}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->76550090],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "<", "2"}], "&&", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "y"}], ")"}], "2"]}], "<", "2"}]}]], "Output",\

 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76821845]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "ineqs"}], "]"}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47969652],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->595940655]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find an explicit solution instance:"
}], "ExampleText",
 CellID->214781451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{"ineqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->86296610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["3", "8"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{115, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->260968535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->560322904],

Cell[TextData[{
 "This states that there exists a complex ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " for which the equations are satisfied:"
}], "ExampleText",
 CellID->538056234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "==", 
     RowBox[{"z", "^", "3"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->426841678],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", "x"], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "\[Equal]", 
     SuperscriptBox["z", "3"]}]}], ")"}]}]], "Output",
 ImageSize->{187, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->683038199]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to find conditions on ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " for which the statement is true:"
}], "ExampleText",
 CellID->380117770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95877093],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["y", "2"]}], "+", 
      SuperscriptBox["y", "4"], "+", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", 
       SuperscriptBox["z", "2"]}], "+", 
      SuperscriptBox["z", "6"]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[NotEqual]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{316, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36974119]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem using ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->286318889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "==", 
     RowBox[{"z", "^", "3"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->946077505],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["y", "4"], "+", 
   RowBox[{
    SuperscriptBox["y", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["z", "2"]}], ")"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   SuperscriptBox["z", "6"]}]}]], "Output",
 ImageSize->{136, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->209575811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127718304],

Cell[TextData[{
 "This finds the projection of the complex algebraic set ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", " ", "y"}], "\[LongEqual]", "1"}], TraditionalForm]], 
  "InlineMath"],
 " along the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->456189702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[Equal]", "1"}]}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->651831720],

Cell[BoxData[
 RowBox[{"x", "\[NotEqual]", "0"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578519095]
}, Open  ]],

Cell[TextData[{
 "This finds the projection of the real unit disc along the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->152056624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "]"}], ",", "x", 
   ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->364490955],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "1"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->366970655]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31197],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eliminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eliminate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26656]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5535],

Cell[TextData[ButtonBox["Quantifiers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Quantifiers"]], "Tutorials",
 CellID->19704],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "Tutorials",
 CellID->212396704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->196508888],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->43792132],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->480027074]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exists (\[Exists]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 43.3102300}", "context" -> "System`", 
    "keywords" -> {
     "exist quantifier", "existence", "existential quantifier", 
      "first order logic", "satisfiability", "some"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Exists[x, expr] represents the statement that there exists a value of x \
for which expr is True. Exists[x, cond, expr] states that there exists an x \
satisfying the condition cond for which expr is True. Exists[{x_1, x_2, ...}, \
expr] states that there exist values for all the x_i for which expr is True. \
", "synonyms" -> {}, "title" -> "Exists", "type" -> "Symbol", "uri" -> 
    "ref/Exists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11656, 419, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->773092766]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 65745, 2482}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2524, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3147, 84, 107, 4, 70, "ObjectName",
 CellID->12424],
Cell[3257, 90, 2602, 86, 70, "Usage",
 CellID->17643]
}, Open  ]],
Cell[CellGroupData[{
Cell[5896, 181, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6374, 198, 830, 29, 70, "Notes",
 CellID->22958],
Cell[7207, 229, 512, 20, 70, "Notes",
 CellID->7187],
Cell[7722, 251, 565, 23, 70, "Notes",
 CellID->12167],
Cell[8290, 276, 508, 20, 70, "Notes",
 CellID->3892],
Cell[8801, 298, 580, 22, 70, "Notes",
 CellID->25660],
Cell[9384, 322, 384, 14, 70, "Notes",
 CellID->613],
Cell[9771, 338, 588, 23, 70, "Notes",
 CellID->9176],
Cell[10362, 363, 747, 29, 70, "Notes",
 CellID->4267],
Cell[11112, 394, 507, 20, 70, "Notes",
 CellID->18401]
}, Closed]],
Cell[CellGroupData[{
Cell[11656, 419, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->773092766],
Cell[CellGroupData[{
Cell[12041, 433, 148, 5, 70, "ExampleSection",
 CellID->319695193],
Cell[12192, 440, 348, 12, 70, "ExampleText",
 CellID->204316434],
Cell[CellGroupData[{
Cell[12565, 456, 339, 12, 28, "Input",
 CellID->70687862],
Cell[12907, 470, 430, 15, 39, "Output",
 CellID->240926751]
}, Open  ]],
Cell[13352, 488, 253, 8, 70, "ExampleText",
 CellID->9573649],
Cell[CellGroupData[{
Cell[13630, 500, 135, 4, 28, "Input",
 CellID->430461369],
Cell[13768, 506, 1133, 39, 56, "Output",
 CellID->629151334]
}, Open  ]],
Cell[14916, 548, 211, 7, 70, "ExampleText",
 CellID->713782625],
Cell[CellGroupData[{
Cell[15152, 559, 201, 7, 70, "Input",
 CellID->337761020],
Cell[15356, 568, 1630, 55, 105, "Output",
 CellID->211923453]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17035, 629, 216, 7, 70, "ExampleSection",
 CellID->10986],
Cell[17254, 638, 188, 6, 70, "ExampleText",
 CellID->46228782],
Cell[CellGroupData[{
Cell[17467, 648, 220, 8, 70, "Input",
 CellID->331483428],
Cell[17690, 658, 294, 10, 36, "Output",
 CellID->14455788]
}, Open  ]],
Cell[17999, 671, 221, 8, 70, "ExampleText",
 CellID->337485886],
Cell[CellGroupData[{
Cell[18245, 683, 102, 3, 70, "Input",
 CellID->65029305],
Cell[18350, 688, 161, 5, 36, "Output",
 CellID->328095969]
}, Open  ]],
Cell[18526, 696, 125, 3, 70, "ExampleDelimiter",
 CellID->122518545],
Cell[18654, 701, 196, 6, 70, "ExampleText",
 CellID->576543645],
Cell[CellGroupData[{
Cell[18875, 711, 294, 10, 70, "Input",
 CellID->157594200],
Cell[19172, 723, 356, 12, 36, "Output",
 CellID->5613543]
}, Open  ]],
Cell[19543, 738, 221, 8, 70, "ExampleText",
 CellID->36144885],
Cell[CellGroupData[{
Cell[19789, 750, 103, 3, 70, "Input",
 CellID->158538849],
Cell[19895, 755, 162, 5, 36, "Output",
 CellID->338978357]
}, Open  ]],
Cell[20072, 763, 124, 3, 70, "ExampleDelimiter",
 CellID->35607302],
Cell[20199, 768, 245, 8, 70, "ExampleText",
 CellID->2016847],
Cell[CellGroupData[{
Cell[20469, 780, 274, 10, 70, "Input",
 CellID->49125088],
Cell[20746, 792, 353, 13, 38, "Output",
 CellID->252318569]
}, Open  ]],
Cell[21114, 808, 265, 8, 70, "ExampleText",
 CellID->156930490],
Cell[CellGroupData[{
Cell[21404, 820, 102, 3, 70, "Input",
 CellID->93535409],
Cell[21509, 825, 162, 5, 36, "Output",
 CellID->486880242]
}, Open  ]],
Cell[21686, 833, 367, 13, 70, "ExampleText",
 CellID->228888947],
Cell[CellGroupData[{
Cell[22078, 850, 135, 4, 70, "Input",
 CellID->152035922],
Cell[22216, 856, 161, 5, 36, "Output",
 CellID->156955105]
}, Open  ]],
Cell[22392, 864, 125, 3, 70, "ExampleDelimiter",
 CellID->350705895],
Cell[22520, 869, 105, 2, 70, "ExampleText",
 CellID->803953843],
Cell[CellGroupData[{
Cell[22650, 875, 354, 13, 70, "Input",
 CellID->216912110],
Cell[23007, 890, 469, 17, 52, "Output",
 CellID->63509172]
}, Open  ]],
Cell[23491, 910, 316, 13, 70, "ExampleText",
 CellID->454281492],
Cell[CellGroupData[{
Cell[23832, 927, 103, 3, 70, "Input",
 CellID->319790039],
Cell[23938, 932, 173, 5, 50, "Output",
 CellID->511220122]
}, Open  ]],
Cell[24126, 940, 125, 3, 70, "ExampleDelimiter",
 CellID->373276802],
Cell[24254, 945, 264, 8, 70, "ExampleText",
 CellID->217337348],
Cell[CellGroupData[{
Cell[24543, 957, 156, 5, 70, "Input",
 CellID->761623207],
Cell[24702, 964, 185, 6, 36, "Output",
 CellID->2156816]
}, Open  ]],
Cell[CellGroupData[{
Cell[24924, 975, 215, 7, 70, "Input",
 CellID->124115997],
Cell[25142, 984, 283, 10, 38, "Output",
 CellID->36544364]
}, Open  ]],
Cell[25440, 997, 125, 3, 70, "ExampleDelimiter",
 CellID->556421747],
Cell[25568, 1002, 203, 7, 70, "ExampleText",
 CellID->152306183],
Cell[CellGroupData[{
Cell[25796, 1013, 194, 7, 70, "Input",
 CellID->8899254],
Cell[25993, 1022, 292, 9, 50, "Output",
 CellID->186692835]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26334, 1037, 221, 7, 70, "ExampleSection",
 CellID->903],
Cell[26558, 1046, 96, 1, 70, "ExampleText",
 CellID->201343094],
Cell[CellGroupData[{
Cell[26679, 1051, 261, 9, 70, "Input",
 CellID->3722289],
Cell[26943, 1062, 338, 12, 36, "Output",
 CellID->3213650]
}, Open  ]],
Cell[27296, 1077, 93, 1, 70, "ExampleText",
 CellID->571354619],
Cell[CellGroupData[{
Cell[27414, 1082, 129, 4, 70, "Input",
 CellID->32866358],
Cell[27546, 1088, 720, 26, 39, "Output",
 CellID->758716497]
}, Open  ]],
Cell[28281, 1117, 124, 3, 70, "ExampleDelimiter",
 CellID->97572279],
Cell[28408, 1122, 90, 1, 70, "ExampleText",
 CellID->102801770],
Cell[28501, 1125, 488, 18, 70, "Input",
 CellID->165438567],
Cell[28992, 1145, 200, 7, 70, "ExampleText",
 CellID->54453802],
Cell[CellGroupData[{
Cell[29217, 1156, 321, 11, 70, "Input",
 CellID->356275993],
Cell[29541, 1169, 720, 25, 39, "Output",
 CellID->138165353]
}, Open  ]],
Cell[30276, 1197, 237, 7, 70, "ExampleText",
 CellID->202488301],
Cell[CellGroupData[{
Cell[30538, 1208, 102, 3, 70, "Input",
 CellID->52993724],
Cell[30643, 1213, 161, 5, 36, "Output",
 CellID->88722386]
}, Open  ]],
Cell[30819, 1221, 65, 1, 70, "ExampleText",
 CellID->241929558],
Cell[30887, 1224, 845, 27, 70, "Input",
 CellID->35717418],
Cell[CellGroupData[{
Cell[31757, 1255, 149, 5, 70, "Input",
 CellID->204010330],
Cell[31909, 1262, 4641, 80, 70, "Output",
 Evaluatable->False,
 CellID->645693997]
}, Open  ]],
Cell[36565, 1345, 125, 3, 70, "ExampleDelimiter",
 CellID->215876008],
Cell[36693, 1350, 70, 1, 70, "ExampleText",
 CellID->202110312],
Cell[36766, 1353, 1577, 55, 70, "Input",
 CellID->186965933],
Cell[38346, 1410, 124, 3, 70, "ExampleText",
 CellID->20584758],
Cell[CellGroupData[{
Cell[38495, 1417, 360, 11, 70, "Input",
 CellID->244596046],
Cell[38858, 1430, 2267, 74, 101, "Output",
 CellID->73194851]
}, Open  ]],
Cell[41140, 1507, 133, 4, 70, "ExampleText",
 CellID->104592719],
Cell[CellGroupData[{
Cell[41298, 1515, 103, 3, 70, "Input",
 CellID->282069049],
Cell[41404, 1520, 160, 5, 36, "Output",
 CellID->79933624]
}, Open  ]],
Cell[41579, 1528, 134, 4, 70, "ExampleText",
 CellID->153691016],
Cell[41716, 1534, 542, 20, 70, "Input",
 CellID->27660955],
Cell[CellGroupData[{
Cell[42283, 1558, 374, 11, 70, "Input",
 CellID->90216989],
Cell[42660, 1571, 2702, 89, 101, "Output",
 CellID->95882385]
}, Open  ]],
Cell[45377, 1663, 130, 4, 70, "ExampleText",
 CellID->224820717],
Cell[CellGroupData[{
Cell[45532, 1671, 103, 3, 70, "Input",
 CellID->430045710],
Cell[45638, 1676, 162, 5, 36, "Output",
 CellID->400552996]
}, Open  ]],
Cell[45815, 1684, 125, 3, 70, "ExampleDelimiter",
 CellID->151317666],
Cell[45943, 1689, 81, 1, 70, "ExampleText",
 CellID->138659453],
Cell[46027, 1692, 948, 33, 70, "Input",
 CellID->3979005],
Cell[46978, 1727, 266, 9, 70, "ExampleText",
 CellID->112768003],
Cell[CellGroupData[{
Cell[47269, 1740, 249, 8, 70, "Input",
 CellID->554407093],
Cell[47521, 1750, 161, 5, 36, "Output",
 CellID->47306787]
}, Open  ]],
Cell[47697, 1758, 225, 8, 70, "ExampleText",
 CellID->231647836],
Cell[CellGroupData[{
Cell[47947, 1770, 116, 3, 70, "Input",
 CellID->76307263],
Cell[48066, 1775, 161, 5, 36, "Output",
 CellID->753134653]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48276, 1786, 233, 7, 70, "ExampleSection",
 CellID->22471],
Cell[48512, 1795, 318, 13, 70, "ExampleText",
 CellID->375346019],
Cell[CellGroupData[{
Cell[48855, 1812, 176, 6, 70, "Input",
 CellID->306369163],
Cell[49034, 1820, 238, 8, 36, "Output",
 CellID->160024950]
}, Open  ]],
Cell[CellGroupData[{
Cell[49309, 1833, 252, 8, 70, "Input",
 CellID->402630171],
Cell[49564, 1843, 300, 10, 36, "Output",
 CellID->586004797]
}, Open  ]],
Cell[49879, 1856, 124, 3, 70, "ExampleDelimiter",
 CellID->86081891],
Cell[50006, 1861, 341, 13, 70, "ExampleText",
 CellID->125926680],
Cell[CellGroupData[{
Cell[50372, 1878, 595, 20, 70, "Input",
 CellID->645716618],
Cell[50970, 1900, 650, 22, 39, "Output",
 CellID->14146672]
}, Open  ]],
Cell[51635, 1925, 74, 1, 70, "ExampleText",
 CellID->499650896],
Cell[CellGroupData[{
Cell[51734, 1930, 133, 4, 70, "Input",
 CellID->457795290],
Cell[51870, 1936, 559, 19, 39, "Output",
 CellID->248625557]
}, Open  ]],
Cell[52444, 1958, 136, 4, 70, "ExampleText",
 CellID->269908548],
Cell[CellGroupData[{
Cell[52605, 1966, 202, 7, 70, "Input",
 CellID->84668305],
Cell[52810, 1975, 702, 25, 55, "Output",
 CellID->260834089]
}, Open  ]],
Cell[53527, 2003, 124, 3, 70, "ExampleDelimiter",
 CellID->41635157],
Cell[53654, 2008, 98, 1, 70, "ExampleText",
 CellID->305478949],
Cell[CellGroupData[{
Cell[53777, 2013, 433, 17, 70, "Input",
 CellID->76550090],
Cell[54213, 2032, 533, 21, 36, "Output",
 CellID->76821845]
}, Open  ]],
Cell[CellGroupData[{
Cell[54783, 2058, 248, 9, 70, "Input",
 CellID->47969652],
Cell[55034, 2069, 161, 5, 36, "Output",
 CellID->595940655]
}, Open  ]],
Cell[55210, 2077, 233, 8, 70, "ExampleText",
 CellID->214781451],
Cell[CellGroupData[{
Cell[55468, 2089, 197, 6, 70, "Input",
 CellID->86296610],
Cell[55668, 2097, 336, 12, 51, "Output",
 CellID->260968535]
}, Open  ]],
Cell[56019, 2112, 125, 3, 70, "ExampleDelimiter",
 CellID->560322904],
Cell[56147, 2117, 206, 6, 70, "ExampleText",
 CellID->538056234],
Cell[CellGroupData[{
Cell[56378, 2127, 377, 13, 70, "Input",
 CellID->426841678],
Cell[56758, 2142, 491, 17, 39, "Output",
 CellID->683038199]
}, Open  ]],
Cell[57264, 2162, 383, 14, 70, "ExampleText",
 CellID->380117770],
Cell[CellGroupData[{
Cell[57672, 2180, 102, 3, 70, "Input",
 CellID->95877093],
Cell[57777, 2185, 646, 22, 39, "Output",
 CellID->36974119]
}, Open  ]],
Cell[58438, 2210, 220, 8, 70, "ExampleText",
 CellID->286318889],
Cell[CellGroupData[{
Cell[58683, 2222, 380, 13, 70, "Input",
 CellID->946077505],
Cell[59066, 2237, 430, 16, 39, "Output",
 CellID->209575811]
}, Open  ]],
Cell[59511, 2256, 125, 3, 70, "ExampleDelimiter",
 CellID->127718304],
Cell[59639, 2261, 331, 12, 70, "ExampleText",
 CellID->456189702],
Cell[CellGroupData[{
Cell[59995, 2277, 247, 9, 70, "Input",
 CellID->651831720],
Cell[60245, 2288, 190, 6, 36, "Output",
 CellID->578519095]
}, Open  ]],
Cell[60450, 2297, 191, 6, 70, "ExampleText",
 CellID->152056624],
Cell[CellGroupData[{
Cell[60666, 2307, 322, 11, 70, "Input",
 CellID->364490955],
Cell[60991, 2320, 230, 7, 36, "Output",
 CellID->366970655]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61282, 2334, 311, 9, 70, "SeeAlsoSection",
 CellID->31197],
Cell[61596, 2345, 1429, 53, 70, "SeeAlso",
 CellID->26656]
}, Open  ]],
Cell[CellGroupData[{
Cell[63062, 2403, 313, 9, 70, "TutorialsSection",
 CellID->5535],
Cell[63378, 2414, 133, 3, 70, "Tutorials",
 CellID->19704],
Cell[63514, 2419, 165, 3, 70, "Tutorials",
 CellID->212396704]
}, Open  ]],
Cell[CellGroupData[{
Cell[63716, 2427, 319, 9, 70, "MoreAboutSection",
 CellID->196508888],
Cell[64038, 2438, 156, 3, 70, "MoreAbout",
 CellID->43792132],
Cell[64197, 2443, 147, 3, 70, "MoreAbout",
 CellID->480027074]
}, Open  ]],
Cell[64359, 2449, 27, 0, 70, "History"],
Cell[64389, 2451, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

