(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    374856,       8972]
NotebookOptionsPosition[    350763,       8178]
NotebookOutlinePosition[    352279,       8220]
CellTagsIndexPosition[    352141,       8214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Power" :> Documentation`HelpLookup["paclet:ref/Power"], "E" :> 
          Documentation`HelpLookup["paclet:ref/E"], "ExpToTrig" :> 
          Documentation`HelpLookup["paclet:ref/ExpToTrig"], "ProductLog" :> 
          Documentation`HelpLookup["paclet:ref/ProductLog"], "Log" :> 
          Documentation`HelpLookup["paclet:ref/Log"], "LogPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogPlot"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Power\"\>", 2->"\<\"E\"\>", 
       3->"\<\"ExpToTrig\"\>", 4->"\<\"ProductLog\"\>", 5->"\<\"Log\"\>", 
       6->"\<\"LogPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Functions for Separable Coordinate Systems\"\>", 
       3->"\<\"Functions Used in Statistics\"\>", 
       4->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Exp", "ObjectName",
 CellID->14405],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Exp",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Exp"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the exponential function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23813]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["E",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/E"], "^", 
   StyleBox["z", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6155]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31402303],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->375870707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "3.4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14566],

Cell[BoxData["29.96410004739701`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324439361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"I", " ", 
   RowBox[{"Pi", "/", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25748],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "5"]]], "Output",
 ImageSize->{28, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329662751]
}, Open  ]],

Cell["Evaluate numerically to any precision:", "ExampleText",
 CellID->24423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "30"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7272],

Cell[BoxData[
 RowBox[{"0.809016994374947424102293417182819058860154802037`30.\
05847264241799", "+", 
  RowBox[{
  "0.587785252292473129168705954639072768597652145666`29.919733683127024", 
   " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{476, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->211507156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31632],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->15221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13099],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], ",", 
   SuperscriptBox["\[ExponentialE]", "y"], ",", 
   SuperscriptBox["\[ExponentialE]", "z"]}], "}"}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248494668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmF9olWUcxx/3nnO2Y8655tyx1jbNZuoszWltZoqaSyqii+giItYItosy
bN3UTd3URXVTIAWRF/2B/lwYgSEYREIoREIkRAVhEHaRBEkXg+D0+f2e93n2
vs/7nHPmTEh23vP8+f6+v//P8x7vn5ydfuLJydmZqcmhicOTT0/PTD0zdODQ
YZaSJcaYI3weqxnGdUb6OVKv8519tvNM2GqTmQzq+s+0MexjIN9JZs8Ils/2
Jnu1JpyKNx3Bjq6W5ufG9BZW2gOZrS0Rq1pqabNfSWp8an/SUm4FX7Jgynbu
N66ilf+vmC3GGgmWxHe04c7qq6w9K7OtJaK2QGvaU+sr6bfrG7ceelUL9vsC
eVuOS+VZfuP1r19+6cv33zt79tvf5ub+MbsCrol5bPXChb8+P/7DW2+eOfTU
Z3fve/vRRz588YWTH3/03bnvfzdjKfc9iu9S/Pnzf35x8mc0zEwfA//s7PGj
73yT6hmN6ulROfbPnP4VrNUz9fgncMB08eLfZktUTiPZ8dOPf2ANNj34wLsY
99qrpxC6dGluJCoj0XmFxdK8hxlMKZabcL9q5+glgJh578GjrHx67JxYGjIs
iPEK8P8135XqL0fjqv1fJSmkhgSRKeJG9KiVuj3hhgKJgWA+rLj18qwQecqR
XPNHjVCIg/VsHW5UFNzUBUWINnRSgf0Bp62IzYomd2SQ0gMNJyrC/rLoLQ4N
Nz5gAW7QIuEJZ9HbnCXY+/BDH0BPKxGGnpy9OzRwGEhPop6n9FZ3lPEOZaRX
IMI39GM2jMuj6J3KjH4CgH6emGqW5bRr75ehgAjM88+dwJJCBi3fHi2BU1/9
gid4TzbDM9Pi9ionQaQt4SRW8BdOQovdr1jsIuxgOQAEmxRsbHT3mwoiXtCW
00H9uitWq9XsSYuAFzbN5YondGKl3f0+sUDZklux/hLDA5cjWbErxIvYkgOS
tf9y5Dv8Sl3PMDJJyqHb6yOdvTXcHVpymafiKGYKUGvB3BdotTi2aQu840Tf
HcVVFEcfcT/wx2CXx4m+quIRRx/lY+6MsiiqRB7sdYM741HcNTqnqwiYpGws
iurUOftQ0TPm9pxFXRkOnLNdW+Docv4TJOvXaBTXnfGPqNqTwuvqcX6RGlyD
bqvPTtgHrv7C7lqpc2JHhv0dWqiSSjAPO6zXeY2dci7cuigWezriD7ZI7G5Z
MItM7RsTASUacjaMRKVLmYrNrttznBiTVTn9NjWUbja/TudUhW05e8f4bnHv
XM6G/oy/HKtmQ7QGbtA5hzIpluH6KGrA5RHv5R1qOIoadF6iUWJ0U66e1rgs
pjFYF+VY43yEg1YyN0ZRa3UOS4pam9O0LuM51W05CxwehU+CGoqi1IcEn1PU
YBQ1HKAGcvbcHOxqzPU0KTW4T8L6CRn6feazHehP9VTKFCpoQ8BzfbQO46e2
ADZmIitx14o0u0MPWtqxKeBZvUiekUwdSE3VfGQb3HcNmTYHTH0+wrGbSE+g
xN5cUumrolVhUVQ8KOma3ijK/q6ga8iJDFfmaue2etp5aX/2RDksCghAGV4b
Ren5nnAjkHoZdjdB4VV6A3Xn7Nnu4sQZJJ6viHJYFGcUnsuwK4raEfi2PKdJ
3zITXjB4O5Fhp89t2DWNbh+9O6XasVU86fQ5zUqG/08Q9qO1A3niIR4vq8d6
ptXtMxZkWd8GChUfeuBun/Egv0uj0u59NWQZd3GwryepdLFLQrmwR3a6SBBP
qeeqj2fs/rFx5icCvyVk2BGtAYsCAlCG7U1QRB/N0p1xlM3JfL9VcvW0x1Vb
qqkc5ZhosmqW/AsLNks3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226311816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16598],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   FractionBox[
    SuperscriptBox["x", "6"], "720"], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "40320"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "+", 
   FractionBox[
    SuperscriptBox["x", "10"], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120], 
    Rational[1, 720], 
    Rational[1, 5040], 
    Rational[1, 40320], 
    Rational[1, 362880], 
    Rational[1, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{476, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134906161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Exponential functions can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ee\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " ",
 StyleBox["x", "InlineCode"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "x"]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "x"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81970333]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6794],

Cell["Simple exact values are generated automatically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"I", " ", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24643910]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{
   RowBox[{"9", "/", "2"}], " ", "I", " ", "Pi"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->220802815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"16", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["4.\
9530324243951148036542863564239642564130311235566496478715819011161`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9796386]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "1.60000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["4.95303242439511480365428635642396425681`22.8262822072387"], \
"Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->197125206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Millions of digits can be computed in seconds:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"1", "/", "2"}], "]"}], ",", 
     RowBox[{"10", "^", "6"}]}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.7930000000000008`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->379984617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Expand assuming real variables:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"Cos", "[", "y", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132707245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Products are automatically combined:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", "x", "]"}], 
  RowBox[{"Exp", "[", "y", "]"}], 
  RowBox[{"Exp", "[", 
   RowBox[{"1", "/", "z"}], "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"x", "+", "y", "+", 
   FractionBox["1", "z"]}]]], "Output",
 ImageSize->{40, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401511283]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2730],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["1", "\[ExponentialE]"], ",", 
    SuperscriptBox["\[ExponentialE]", "2"]}], "}"}], "]"}]], "Output",
 ImageSize->{123, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549740667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->493461737]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"-", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->509657788]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \
\\!\\(\[ExponentialE]\\^ComplexInfinity\\) encountered. \\!\\(\\*ButtonBox[\\\
\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->449248763],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->257861765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "9"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 0, 
    Rational[-2, 9]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{116, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80860543]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " threads element-wise over matrices:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "u"},
      {"v", 
       RowBox[{"I", " ", "Pi"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.28], {
          Offset[0.7]}, 
         Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[ExponentialE]", ",", 
     SuperscriptBox["\[ExponentialE]", "u"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "v"], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->335646624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " threads element-wise over sparse arrays: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     RowBox[{"I", " ", "Pi"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "2"}], "}"}], "\[Rule]", "u"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50341915]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"Exp", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[ExponentialE]", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     SuperscriptBox["\[ExponentialE]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox["\[ExponentialE]", "u"], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{300, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->761299942]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12715],

Cell["Exponential decay:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"n", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{"-", "\[Lambda]"}], " ", 
       RowBox[{"n", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"n", "[", "0", "]"}], "==", "n0"}]}], "}"}], ",", 
   RowBox[{"n", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"n", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "t"}], " ", "\[Lambda]"}]], " ", "n0"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{118, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83136346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215257255],

Cell["Damped harmonic oscillator:", "ExampleText",
 CellID->724227718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
        RowBox[{"3", 
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}]}], "+", 
        RowBox[{
         RowBox[{"5", "/", "4"}], 
         RowBox[{"x", "[", "t", "]"}]}]}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "==", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", 
    RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}], " ", "//", 
  "ExpandAll"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48530058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "4"]}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", "t"}], "/", "2"}]]}], "+", 
     FractionBox[
      RowBox[{"5", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "t"}], "/", "2"}]]}], "4"]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{187, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374117249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->264473815],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151996628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Normal distribution:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117584581],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]"}]]], "Output",
 ImageSize->{55, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->686026979]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Mu]", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Sigma]", "\[Rule]", "1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->567827342]
}, Open  ]],

Cell["Calculate moments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Mu]", "\[Element]", "Reals"}], "\[And]", 
    RowBox[{"\[Sigma]", ">", "0"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "k"], 
        RowBox[{
         RowBox[{"PDF", "[", 
          RowBox[{"NormalDistribution", "[", 
           RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}], "[", "x", 
         "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "4"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "\[Mu]", ",", 
   RowBox[{
    SuperscriptBox["\[Mu]", "2"], "+", 
    SuperscriptBox["\[Sigma]", "2"]}], ",", 
   RowBox[{
    SuperscriptBox["\[Mu]", "3"], "+", 
    RowBox[{"3", " ", "\[Mu]", " ", 
     SuperscriptBox["\[Sigma]", "2"]}]}], ",", 
   RowBox[{
    SuperscriptBox["\[Mu]", "4"], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["\[Mu]", "2"], " ", 
     SuperscriptBox["\[Sigma]", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["\[Sigma]", "4"]}]}]}], "}"}]], "Output",
 ImageSize->{271, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->135624816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Define the CDF of the Gumbel distribution through nested exponential \
functions:\
\>", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GumbelG", "[", 
   RowBox[{"x_", ",", " ", 
    RowBox[{"{", 
     RowBox[{"a_", ",", " ", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Exp", "[", 
   RowBox[{"-", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"x", "-", "b"}], ")"}]}], "/", "a"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"GumbelG", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "2"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWGuIVVUU3s65jzSz0qzpNY5Z2WTO6NhbJilRMzOzMiuzunO15k45Y+No
pViORYHWn/qTIPojDXr8MBIjMIiESIiESIgKwiDsRxIk/RgIdt9a+7z2mnWO
c29Ew51z9j77W99ee61vP85ZWhnsWbuuMlirVloXDVTW99SqG1oX9g/gUTDG
GHMQ/0PNBmWLEv8ftBb3kdcKrgEAs8N7E+5NuDdz6xq60mPLf6aDLoWk7vBp
xOT/xa479LqzDnz66exR2lXDfmaF98CLVjquHcJ+e85TSpcxBdFWFvUi+3jy
5J/HvvkVP7KgW+GTQ9/v3fM1fhsHDzUtX/YO23x04PipU3+Zs87AKdv/Lf6/
tuesmGl0LWF8nx3+6bVXP8eYMfSjX/1SEuhOUZ8j6hcx23SOK8xBUu3+EAWZ
CZelNsb9+MPvwA1tO3z69LDUiMPN4GTBtdWr3kOC+Jkxr/D9OuaA5/19H3/w
/rfx83ZmeuvNLx2ZedlXC5KraMhlPf00VLBrGIqfk0JZqm+8fgTCMNsSi1Ls
/fDw3xgYHH4paS3HrfiD17WeA9CfedH3I52b4Ph3v2FsIDNbVRTPGHiXtJJ3
rO0AhmHAtqi2Li/wAGlC+DNQjgvxR5KouJlRU2wyYyM0hyXuPWFwOoI5SKj4
AmNbUhF2xkXBpfMgblAC+ZvFI3WrrwTIHPJHxeczeORsiVansVxB0CBeKj5X
h/3I2QkSUOXxFHIjRUXnEfSOSUDFTV6OSqn7SCtoa+WKd2l126TmfxzXsSpi
aaDixhhFnONFLAZVjrPFSHXUeKGTDTko+AuvaV7oqHOsmxdJK3k7QYx4QLWd
IPTxrIo6V4x8fQ7qyBc/b9n8aTbqPK67VZeK/TmoJIo66nyuozt0SsW+HFQS
xT5PMazUYnq1Mop+JlpfdetsY/NxovAli4fsCor6J3EdTsAVKj6TY59eX8gv
qk4SqsiyL1p9Hl0g9PJ0nfaThZJ6vVzIVURGz1knCutV832hUEUtRlEfvHOn
lFVTORzKbXpU7MlBJdnUUc0iZ0/loMACv06c+CMDdbGIwJMq6hLrz7G1OShE
Anszea+jLrW+8tfkoBJd6ajLuJ7sr1UvMy3C626V43KuYyfHzkhe6yjiojWx
29OX3JU0hbaIPFRszgzL3ammcB2nGsSXik/UxUS+TWWGXW8f3b/vGBUfb9iX
VjGqPKZAicpUMZbHMuxlv7J+hRjRai8/ZZs+00kreI/eodfQSuacz/YBRocx
kjIeVVFXcj3Z41epqKusv4Y8koPC+Qw90ulWR11t/Xn2sIqaLvx6KEZRRPgN
IrUerVQ5ronihOMwcpWBahNeP6iirrXWOzGvUFEzIl2EJ/cHPK9ncmuyWt2v
cswUI79PRbUL1HJPOaOZ2R2C4V7b6GyaFTFhsaJRL2uYib8eBFjwED+K8j0Z
TOn9lO5zoriH71VLG/bAMblZQx8F7m6Y6fpIV+Eb6hIvQ1kn8xu5jv3FvRib
xWr2b+K6ezMmZd8Zo4jzFvbNvWVibUFKFqost3IdS497WTcLVNRcZkNEkF0I
F7TzVVwX46Bu7HnYauD87SruNroU4RRAMdTM80bAlkU8dxiEg7LapfLdEWER
ZGChZorIXBXLIyxCqYgMQofVg/q+WcUuoksJ48Yys2TxXgwddoDfoKLvYjRG
j/6BBj9chyOdKpr1WUYzQIA6evhPq3m7Fwme12PRLagRBmRqXtcuKAp5RfoJ
36b2wOvTOCgY6YWUYju4hz5BhqZpsSLJUH6D0dTJK3oZpu5TGZwGJYgXzN9t
mlCkM4YpwDH3ZQ1J5hNauN8mPMEZZw+fDmjtDr/RMXMJI0Ev+KFD1y196jAF
RMN9qsGPv+UF7kDNwWvQg95Ip84DF0oTUA/UZ+BCip8p0CVAEjE3OHJ19EiA
rdFYo8g36PH2UdrtiPOeXol28tOR37XNmH8A7Jz+uA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274955535]
}, Open  ]],

Cell["Plot the PDF:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"GumbelG", "[", 
       RowBox[{"x", ",", " ", 
        RowBox[{"{", 
         RowBox[{"2", ",", " ", "2"}], "}"}]}], "]"}], ",", "x"}], "]"}], 
    "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "4"}], ",", " ", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->199354362]
}, Open  ]],

Cell["Calculate the first moment symbolically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"GumbelG", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData["EulerGamma"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->904963879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Solution of a boundary\[Hyphen]layer problem using ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[Epsilon]", " ", 
         RowBox[{
          RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Epsilon]"}], ")"}], 
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
        RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"1", "+", 
        FractionBox["1", "\[Epsilon]"]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "x"}]], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox["x", "\[Epsilon]"]}]]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "\[ExponentialE]"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox["1", "\[Epsilon]"]]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{174, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18171085]
}, Open  ]],

Cell["Plot various solutions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "/.", "%"}], "/.", 
       RowBox[{"\[Epsilon]", "->", 
        RowBox[{"10", "^", "k"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", 
        RowBox[{"4", "/", "15"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195739959]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Multivariate Gaussian integrals:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Lambda]", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "\[Element]", "Reals"}]}], ",", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[Lambda]"}], 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["x", "1"], "-", "a"}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["x", "2"], "-", 
              SubscriptBox["x", "1"]}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "-", 
              SubscriptBox["x", "3"]}], ")"}], "2"]}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", 
        SubscriptBox["x", "1"]}], 
       RowBox[{"\[DifferentialD]", 
        SubscriptBox["x", "2"]}], 
       RowBox[{"\[DifferentialD]", 
        SubscriptBox["x", "3"]}]}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", 
   RowBox[{"3", "/", "2"}]], 
  SuperscriptBox["\[Lambda]", 
   RowBox[{"3", "/", "2"}]]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70185268]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{" ", 
      RowBox[{"\[ImaginaryI]", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["x", "1", "2"], "+", 
         SubsuperscriptBox["x", "2", "2"]}], ")"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     SubscriptBox["x", "1"]}], 
    RowBox[{"\[DifferentialD]", 
     SubscriptBox["x", "2"]}]}]}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(\[ExponentialE]\\^\\(\[ImaginaryI]\\\\ \
\\(\\((Integrate`$$a$16075\\^2 + x\\_2\\%2)\\)\\)\\)\\) does not converge on \
\\!\\({\\(\\(-\[Infinity]\\)\\), \[Infinity]}\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->9554308],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        SubsuperscriptBox["x", "1", "2"], "+", 
        SubsuperscriptBox["x", "2", "2"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     SubscriptBox["x", "1"]}], 
    RowBox[{"\[DifferentialD]", 
     SubscriptBox["x", "2"]}]}]}]}]], "Output",
 ImageSize->{142, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->534443607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Calculate the dispersion relation for the telegrapher's equation using a \
plane wave ansatz:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", 
      RowBox[{"x", ",", "x"}]], 
     RowBox[{"V", "[", 
      RowBox[{"x", ",", "t"}], "]"}]}], "-", 
    RowBox[{"L", " ", "C", " ", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       RowBox[{"t", ",", "t"}]], 
      RowBox[{"V", "[", 
       RowBox[{"x", ",", "t"}], "]"}]}]}], "-", 
    RowBox[{"R", " ", "C", " ", 
     RowBox[{
      SubscriptBox["\[PartialD]", "t"], 
      RowBox[{"V", "[", 
       RowBox[{"x", ",", "t"}], "]"}]}]}]}], "==", "0"}], "/.", 
  RowBox[{"V", "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "t"}], "}"}], ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"k", " ", "x"}], " ", "-", " ", 
         RowBox[{"\[Omega]", " ", "t"}]}], ")"}]}]]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFV9FOwjAULevGMIKKAUGIhncegYgmvuqTn6DJQkjgwWiQ/6/tdgfdWdcN
mJNka2/Xe+7pubfdeAu2q+VnsF0vgtHrJvherRc/o5evjRziNcZqj4yxdp/J
vpC98FK/J3lFXew15N2T06aydWTL3HCYfk1l8BhFME/efGmqVg3XyXtCNof5
TozK96g+zKkD1pRaz+A70OMkkNTTuWrdPTJjLYiFHvVwUbvnNOrCrIfsWYlo
DkRzRVq9/GjpVeRHapAuyez5xnhO1Gqq6p7RfQ6cmpQTo36Qy5RyCeZe7loc
Lf827GN0urEogmtT3RnpegE4h+rAqa7dQgoY6yYHfWbyKblmcNWIeAb2vYn3
4fvTsvJDGeTvwLB7Yj6O0sWCj3xsVayyqiQ+B5+RJUboLa+OiHYe8vELYrpG
XrgaVAffMUWj2bJgimNT7VJEewFOEJF+A6XPGJ9mceKN1WKylTkw8mn+IRNu
jHhbOQ+0WxSrY8nQlWktGdmOTw6HvN1dGWokIw9v50GjiMsJB6vrGuw6xcET
rSqe8Vtz+M88uDC/MbtC/3Irkk2uscJvRr2Ss7ngyTKuJOqkkihdsAeFdY33
atbu9agCzKdFGRqXy6CI3uVGNGt/KbSTIoXRBh8/xUHfMcpjfCLe7ET/HvAZ
hm0/peYdIOHOn+R6POfO6IFtrvYl2B9gv4deqhv992W1X4DhfXI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{313, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194609696]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Omega]", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "C", " ", "R"}], "-", 
       SqrtBox[
        RowBox[{
         RowBox[{"4", " ", "C", " ", 
          SuperscriptBox["k", "2"], " ", "L"}], "-", 
         RowBox[{
          SuperscriptBox["C", "2"], " ", 
          SuperscriptBox["R", "2"]}]}]]}], 
      RowBox[{"2", " ", "C", " ", "L"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "C", " ", "R"}], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"4", " ", "C", " ", 
          SuperscriptBox["k", "2"], " ", "L"}], "-", 
         RowBox[{
          SuperscriptBox["C", "2"], " ", 
          SuperscriptBox["R", "2"]}]}]]}], 
      RowBox[{"2", " ", "C", " ", "L"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{413, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74669534]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Define a Fermi\[Dash]Dirac, a Bose\[Dash]Einstein, and a \
Maxwell\[Dash]Boltzmann distribution function:\
\>", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"fd", "[", 
   RowBox[{"\[ScriptCapitalE]_", ",", "\[Mu]_", ",", "kBT_"}], "]"}], ":=", 
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      RowBox[{"\[ScriptCapitalE]", "-", "\[Mu]"}], "kBT"]], "+", 
    "1"}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->494728085],

Cell[BoxData[
 RowBox[{
  RowBox[{"be", "[", 
   RowBox[{"\[ScriptCapitalE]_", ",", "\[Mu]_", ",", "kBT_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"UnitStep", "[", 
    RowBox[{"\[ScriptCapitalE]", "-", "\[Mu]"}], "]"}], 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{"\[ScriptCapitalE]", "-", "\[Mu]"}], "kBT"]], "-", 
     "1"}]]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->228617299],

Cell[BoxData[
 RowBox[{
  RowBox[{"mb", "[", 
   RowBox[{"\[ScriptCapitalE]_", ",", "\[Mu]_", ",", "kBT_"}], "]"}], ":=", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ScriptCapitalE]", "-", "\[Mu]"}], "kBT"]}]]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->162929880],

Cell["Plot the distributions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"fd", "[", 
      RowBox[{"\[ScriptCapitalE]", ",", "1", ",", 
       RowBox[{"1", "/", "10"}]}], "]"}], ",", 
     RowBox[{"be", "[", 
      RowBox[{"\[ScriptCapitalE]", ",", "1", ",", 
       RowBox[{"1", "/", "10"}]}], "]"}], ",", 
     RowBox[{"mb", "[", 
      RowBox[{"\[ScriptCapitalE]", ",", "1", ",", 
       RowBox[{"1", "/", "10"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptCapitalE]", ",", "0", ",", "3"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->109902042]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Solve the Schr\[ODoubleDot]dinger equation for the exponential Liouville \
potential:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"\[Psi]", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Exp", "[", "x", "]"}], 
      RowBox[{"\[Psi]", "[", "x", "]"}]}]}], "==", 
    RowBox[{"\[CurlyEpsilon]", " ", 
     RowBox[{"\[Psi]", "[", "x", "]"}]}]}], ",", 
   RowBox[{"\[Psi]", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SqrtBox["\[CurlyEpsilon]"]}]], " ", 
      RowBox[{"BesselI", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
         SqrtBox["\[CurlyEpsilon]"]}], ",", 
        RowBox[{"2", " ", 
         SqrtBox[
          SuperscriptBox["\[ExponentialE]", "x"]]}]}], "]"}], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SqrtBox["\[CurlyEpsilon]"]}]}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["\[CurlyEpsilon]"]}]], " ", 
      RowBox[{"BesselI", "[", 
       RowBox[{
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SqrtBox["\[CurlyEpsilon]"]}], ",", 
        RowBox[{"2", " ", 
         SqrtBox[
          SuperscriptBox["\[ExponentialE]", "x"]]}]}], "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SqrtBox["\[CurlyEpsilon]"]}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375626879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Transmission and reflection coefficient of the Schr\[ODoubleDot]dinger \
equation for a step potential :\
\>", "ExampleText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Psi]L", "[", 
   RowBox[{"\[ScriptCapitalE]_", ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", 
     SqrtBox["\[ScriptCapitalE]"], "x"}], "]"}], "+", 
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "[", "\[ScriptCapitalE]", "]"}], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], 
      SqrtBox["\[ScriptCapitalE]"], "x"}], 
     "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]R", "[", 
   RowBox[{"\[ScriptCapitalE]_", ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"\[ScriptCapitalT]", "[", "\[ScriptCapitalE]", "]"}], 
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", 
     SqrtBox[
      RowBox[{"\[ScriptCapitalE]", "-", 
       SubscriptBox["\[ScriptCapitalV]", "0"]}]], "x"}], "]"}]}]}]}], "Input",\

 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Psi]L", "[", 
       RowBox[{"\[ScriptCapitalE]", ",", "0"}], "]"}], "==", 
      RowBox[{"\[Psi]R", "[", 
       RowBox[{"\[ScriptCapitalE]", ",", "0"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[Psi]L", "[", 
          RowBox[{"\[ScriptCapitalE]", ",", "x"}], "]"}], ",", "x"}], "]"}], "==",
        
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[Psi]R", "[", 
          RowBox[{"\[ScriptCapitalE]", ",", "x"}], "]"}], ",", "x"}], "]"}]}],
       "/.", 
      RowBox[{"x", "\[Rule]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[ScriptCapitalR]", "[", "\[ScriptCapitalE]", "]"}], ",", 
     RowBox[{"\[ScriptCapitalT]", "[", "\[ScriptCapitalE]", "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"\[ScriptCapitalR]", "[", "\[ScriptCapitalE]", "]"}], "\[Rule]", 
     
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        SqrtBox["\[ScriptCapitalE]"]}], 
       RowBox[{
        SqrtBox["\[ScriptCapitalE]"], "+", 
        SqrtBox[
         RowBox[{"\[ScriptCapitalE]", "-", 
          SubscriptBox["\[ScriptCapitalV]", "0"]}]]}]]}]}], ",", 
    RowBox[{
     RowBox[{"\[ScriptCapitalT]", "[", "\[ScriptCapitalE]", "]"}], "\[Rule]", 
     
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox["\[ScriptCapitalE]"]}], 
      RowBox[{
       SqrtBox["\[ScriptCapitalE]"], "+", 
       SqrtBox[
        RowBox[{"\[ScriptCapitalE]", "-", 
         SubscriptBox["\[ScriptCapitalV]", "0"]}]]}]]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{343, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->342345334]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Propagator for the free\[Hyphen]particle Schr\[ODoubleDot]dinger equation:\
\>", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalG]", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{
   SqrtBox[
    FractionBox["m", 
     RowBox[{"2", " ", "\[Pi]", " ", "t", " ", "I", " ", "\[HBar]"}]]], 
   RowBox[{"Exp", "[", 
    FractionBox[
     RowBox[{"I", " ", "m", " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"2", " ", "t", " ", "\[HBar]"}]], "]"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell["Calculate spreading of a Gaussian wave packet:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[ScriptCapitalG]", "[", 
      RowBox[{
       RowBox[{"x", "-", "y"}], ",", "t"}], "]"}], 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       SuperscriptBox["y", "2"]}], "]"}], 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "k", " ", "y"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"m", ">", "0"}], "&&", 
      RowBox[{"\[HBar]", ">", "0"}], "&&", 
      RowBox[{"t", ">", "0"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "m", " ", "x"}], "-", 
     RowBox[{"2", " ", "m", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["k", "2"], " ", "t", " ", "\[HBar]"}]}], 
    RowBox[{
     RowBox[{"2", " ", "m"}], "+", 
     RowBox[{"4", " ", "\[ImaginaryI]", " ", "t", " ", "\[HBar]"}]}]]], " ", 
  SqrtBox[
   FractionBox["m", 
    RowBox[{"m", "+", 
     RowBox[{
     "2", " ", "\[ImaginaryI]", " ", "t", " ", "\[HBar]"}]}]]]}]], "Output",
 ImageSize->{204, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32011187]
}, Open  ]],

Cell["Visualize the spreading:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"\[Psi]", "[", 
        RowBox[{"x", ",", "t"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[HBar]", "\[Rule]", "1"}], ",", 
         RowBox[{"m", "\[Rule]", "1"}], ",", 
         RowBox[{"k", "\[Rule]", "1"}]}], "}"}]}], "]"}], "^", "2"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0fXVcVcv3NiComNjd3X1t17G7u+Neu7u7W1HsxBYVREQJ3YCAINLdBw6d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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHlwleUVxr97b+6S3GstsliSIIkbFGQRW3WKgNswaA1bLSpr6F8dSqBQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWmIl1UUxq//5V3+72shaalj5tjiX6d9UYtsrLAwKG2aUjPaPoUfxqKp
rKykXIJCsKCQvihFxkAjoo6jNaQ5Y0HaOFOzaFlpkRWtOFNBiP2enj4cOM89
yz333nOeW/vg0oamQghhBVJCmvIQNiYh3MDi1+UQpqLXpiH8BP4DXAc+D/wz
eBj8WCWEHch9BP8Jnob9ZnKcQB8SzkLYE4fQib0LmYatgs944g9g34P9evKt
j0JYCO4HDyDN6G+OCKGK7xxifgP/jixEH8laF3pCzG3E3sn+ObkvKYawE/tR
5A1s54BfwfYqErNfP/l25faRbSk+17HXh9hPYRsgR44tQ2LsrexxGvo/sW1b
wL3o3+K/CvwyeCL6ZupZTP5fkYvIt5Ka7iL+I3xasV2Q2tbL2n7yTQa/wN7P
I92qhRxfcvdrwB8QvzvzXSxAUuI78HkE217wD+it1HAL/u+wdgA8gfh3g3PO
IvYE9j727teboLdjvx99M/E92HuRudSzkTMPYpsNHsS+D/tu/Lci3xf8Bouo
tQ77Puwzqf9T9puSutbVSCP6HUgLudqQZ9CPU/Nf+DboPci/Dbmx7BqUezT4
k6L32Ak+G9xTdE+1g8eDu4vuuSFybWLPI+Bt4GexPYdcSq6T4CnY6nL30mvs
34RtFHI39zERn4+xbSBHPb7LI++1iz1+KXjPp1Lfme7qdvBYfKcTc4h8h5F2
bA+xViR2Png68TOQB4o+s876dOpYnbmK/6LcvameW4Hegc+Sgs/wOPiJ3LOh
NztFrobEvXkl9muJ38ra3yP8hkfBxzLPjnI0YhuO3ZtZyXe7Hbm35DvWLM1L
PQuaqWFyrwEvAJ8surcHkXWRe/wb9Gbstxb/nxlyTUL6iu7JwxX3iHrjSfaY
X/EMqPcTcE/sNel6k6HYNao21aS7HEcNX5R9p5eBzwT3oX+GXK3+Tcw1R5D3
wZOQbs76MPVcyNk7yZcW3INj0ZuxV7GtDeaCNnzmlc0JLeCbcnOFfGrwP5fz
rYzcUyHxjGo2lyCzc3OOuOY4MSXsy1P37qPYp2bmOHGbOKyt4pnSLInzxHXi
RHGhOE9cJc4UV4qzzk/NAZp99dwA9pfAZ0R+A3HHQdZejMwh1dQzptnSWotm
EfxW5JlvRF9GzMjIPTmu4jvRXfxI/OjUHCFuUM/PRF+Pf03kN9jLecaknoXF
Zd9tV8V3oTtei++M3L1/VuRZ3R47t2ZWb1Obm4v0RrOEE3OJ/oyaxG+qt/yq
bK4/VHHviPPHJO4Bvf3nZd/F5bl13UkTeELmWdAMbGHv+txvI87SXYyi/qsK
vpMrctesWtVTOus1uffWmTszn1lnvUf/WW7OEFfsB69O/eZ6a83IqtQzo1kR
h+tvSVL/Ffpj1EvicHG3eupt/XWJuenikv+SyezXUfKfsg7/g7Ft4gz16o7M
XKKe1ey9l7vXNYOnp/4DxP3LWNtA7NzUXAf87y+o5q5df0J95j9Kf5M4XNzX
lfms4sDazBwu7lZNr+vvzJ1bd/gd/scq5m79af8Cw44Vig==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.37880700813144963`, 0.2058763020177998, 0.6494393919360045], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnm0VXUVx8+9775z77nnOKCigDggKIpaGdXTTMHU1MwJREQhVyUoCqg4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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwl2MUx9/7u7/f712pjFtapFtpuWW9lLUyGSJbiyUjhlFadC1F9q6k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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.46419801626290247`, 0.3543482040356052, 0.7694667838720136], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmMV9UVxx/zW9/vvQGkRZR9EdAuUMAFDLGlaFU0xFaiphq1yDgstiqL
Fg1W3FidGWpNEFkSdUgQAWsFCrjbZnBQq1VQ0TQgWB0kbdVEaxTs9+P3kPSP
+7vnnd+555577lnvgMnX/+I3dUmS9NJPQXPfcpL01hih7++kSdKWJ8mt+t5b
TJJTNbpovCDcixo3CT9HY5bGqaL/s3BbNa7T9y1lrxsr/PSKv4G3F7xuj+DF
gq/QeLNTkgwWzXzx/lrwP6tJskp8LhJdSTI8IXin6P+k+cEsSUaWkmS8vufq
/2sS8waeJPjmWpLcrjWbxOfx3OtZOzPkvET4zcJv0Zih72Xaa4rg4aLZr/33
iPcK0VxZMHyy8N3Lhvn/gOb3NS7TXvsDbhR8juj2CZ4ieKrm72vNlcL9WrzH
5l53ur77CX+paC4oeP/2OusO+UZp7iF5Ts0twxtl45F5oOb+ZfPYG2vOE592
0fbQGQ/o+wmt/W3uvRcJN1fwIdG8J53dJrhRNB9oTNCYJfwSzUs1+oj/Qc07
C9bnDOnwOo33hBsguftrbBJcV2e5j4j+JPF8UTRTpZO+gvtr7BD8gO5xucZU
jTP0PaVg/jdo7Rcanya+v24F38urWvdKZp19qXl5zTKN1vdArT9b9IOKhi8W
PE74a7T2eMErK74D9L9S5ztX6/8hus80RksHGDa2iM2hZ/Q3oOy7Wy1dTc/9
Pbni/8DPEL8hghsEbxDNHNGslfw3ap6Z+7+npdvx+u828e2MrnKvvVvzPbn3
3qz/tmnPkzSaRT9U9FcLd6PmZ2u2c+yiX9W2MVf/zRXtU8LP1v+zaj5375L9
gHP9ULR/SH1+7IizY0t98ReNNZ3Mp5fO86ngQ6JpEdyheYloewteXPKdDan4
Pi+vGJ4k+uaK6a9NjD+5Yr+EjhmZV1VMB80K8TkqfruFf0DwkZLPAL+hwXNr
3PMQjdd13pGp7eBvmnfnvsc9mjdkvts5+m7S2psSy81e4I5ozuvNE1vJ9d2o
ebpGZ8GzE9sd9kecYS147nFq2CS+WS8eWb3Pxv9dguZL6Xti7vM0S5dVfQ+r
s644/5GIUSdHnELHvUPP+P7y2Bf98h/3mFUsJ3FgdNHfwMgNTIzKC46F+Nd2
7TtPMlwreJLGYdHdlTjGHAw77y+aWbm/35HO1un7EfG5U/Ciqu3tPMGLBQ8W
vFC0CzTGYC8F6x5fRKcdJevtwjrzQOdrte5lrT9XuK90R3fre6PW/atguyNm
8N9DnSzPmRXbGbaHr+zN7C8by56R/2v0nPvuiLPENvwam+4qukF19tnvlh1v
4TGk6vUnaR6vtR9L1ls0X6z/OkR7qGTcnXGOQwEzd4TeDgceeIHu856aY9Jq
nesS8TpF+Cck27jcOugIGYgbxPvuIQ93sq3qe0FO8OQC8mSfyDtXlfwNvEK0
jbn/W6g9P6n5/kek9gHuYGj4Hfb1MPaicaLWjhVNWWOXaHYUHIOJ80N07sEa
zxYdm/OIz9zV4xXfyX2CmzUGogP9f77k2CkdNojfeQFzhnfFt6HO34vEr2cn
+wh5gfiP/RJHsOFRmX0VP/28aD/Hx2vi3y31eclJDSEnOeRA8DlR/x9X79xy
g859vcZg6eQK4X9cNf8Vqc/P2X8p+BTxPZP4XnL8PFc0H0mGJ1Pvuz385Vb8
kRiZ+zzo4vSQYY3wqzUmFJ3zmNs6OU92q1m+mwV/oH2HdfK5D4bMz4rfNxXn
3PaC8yW5skHrtkmOHkXnin6Riw9WzAs+yzXvEd1xWtdbcKHe64kXdxRtb32Q
QfgPhX9LtEWNLaIfqH13C35N+GcEP5e7XsHPsE188w79/1nmOmyC4Cq+Sn4R
3FJzHO4pXIPWzhNND+GerISPFG3X1AOLoo7j3ifWWRbOSP6eH3KSb+dF/n1c
fLamtgnu+bXQM/sfzS0DMZ6cTpy/UDJekNlHtlQsBzIQaybGXqyZU/Q9oi/W
Dk4cY7oWbW/EyeMCf23YGPmOXD676Jj8lPZpylynnFBwPMV3usYZ4QP+5bAZ
1rUH/HDme+VOkWV2yEN+fi5y9AziquAx+Gnq++auTxPurYp1WExda6KD4SX7
OnG+JXOsQZ+p/u+qe38Uuy45Fu+oc320JGqwE1LXc9gn+8EHPLmFHEP+6hJ1
OPviJzdETUU+gZ6cwvrxYc/4+Miw/3+XveewyDvohfO2VuyH+OCOyA/QzKeW
rnn9fs37apH7StYZ9J9o3dHwl7cr1guy/UC2cZ/+mxw+9FLBfrZLOmnPfB5q
+VVRz7drXVvNPk/9PqLqs0yJ3IOO/lsz38lxnyfEXT8s3K7cseeFzPUTtRN+
jHzIdrtovsmtux+VnAfQbaNom1LX+0tD7+DXi75zvfPw1SXHd3TaHjEIvdG3
IAt6IO4ui9hL3qX+IxcjH7omv+PrpfB37HpL+MtKrXukYjvHF4k7+Ag1Y0vq
uvHnorm36pxQFo8/5q6tyJHISI5rqzMOntz1sfiH37eF72/U2k011y2c+5nM
Z+fe94c97QmZOSN5kP/J2Uup3TL3bMiyNrM8H4vfz6qOK3+tuPdgr+8J//fc
fKlXyFHUDAXhd9Wso/mp10A/KnIesYWcdlbuNfRBu6JGaq263qXe+E/N/R52
Qn3TFmddVrOsyEm9Sp/QFDXIkahL26ImZd+Z4jcoczzhnrlveg164KsCnlc2
HhugRvgs4ulpueMdsW5G1KNToo+gtuS7X+a6n3gCj18Fz53Cv5T5e3zsRT6l
j5wRfI7XWbprvFxwb/R61XZK3dSz5NrpgHALxOdEYmDJM3mzZ3xDQ91A70Yt
i4+RX7FP4tHxQT/k/+r9zeI5STwPFR33P4+8j21j48S0V6XjV1L38djMgOgT
14nHB7n7RnTAWaixu4Xdo3fs/emw+cPapyV3j7I7c01GztuOfWXmfYfmuzLL
+mHNdQmxfTH1oGTtQx8gWbKa+2N6ujEV5+mWqFHpWdZEX9QQ+Yg+gVoYXEfg
qdmz6C+6iN/6iu+LXoyaldg3Wntt1N4/LTnX7I18w3/QoHP6FHhwRs4N/G3N
X/F/5IiuNcdE4iE1AvpFt8QV4iyx5VhM4b66S091VecQ+iX2Jzb+Trhx4vNO
0fH6JyXHfHLaO5Erz5DMj2X+jzw7LtbSxw/NXIuyZ++I79wldzgqaqh1kUc+
zFyTYQ9NWntR1bHwK3JmzTXi+pJtC7u6TLiPatbP55nXQM990y+VBLeIx7s1
9wfUqtSvx3IXMznlaa2dFn0ZvRfriWPvi/7B3Pth++tj31nxfsJbCb0pclEj
NYt2WtVrn0/9PkKc7Jr67YNakveSHVXj387ca9EjnZ07NxBzL8399kHd1Cd8
jX2JOytiryPid7Tm77Oqrn2pe5G/V/TjyDcqaireotDFsT6Js1KDbdA5Pta4
m16D3JT5Puint0VPjX+NDHujfuMNhRh2c9kwfOpF26q1Y0qOY9SF9DjUnmnq
2g4d0wOz90LND2W250OClwjuG2ftG7Gle8RD+HzbmwX8Bb1q6nizOrN/4pvn
C56gsS9kHBNyYv/7wgeoM3bEe+Abon0zcy1Mj3VV0E/OnUvII9Sqw0NXI0qu
w/CvMTW/KxEz/yL6PLU+qDWQb1vUbNQE5H166N9n9rUL4t0I35ku+vurvifq
rOFBj772xt1N5X2y6jdU8vf06K9f4p0jdQ55VGNd2fXwoKptC7vibrlj6nxy
91kV52RoqZlnR4w6M95eOuKthLx/U9gH3wOr1he6Whf7sR56vuHzHG8GqXM9
76bknknBA35z4k2Vd1v+b423JvalfyM/nRM1HX0Tdd3hsE/OMq3itWMjbnCe
YSFPR/Tp99MzVV3fcVZo8DVy0OWRh8jZjXG+tSEH8Zt5bbyj8s6wKd4aWuJt
ijjeJd53uAN6lErqmvGYruHJuo3hUysyinTbDmddGXqmh+uVuoadFu9L9MrU
kvRj1JPUJ29GjcL8RrzZzgyYOEouej94P6+1tdRv53y3xlmISRujNpsQ9f6s
OOOGkHOh5DxYdW7fEPLfFW+hq0Lmpqh50B199mMRc7Cd1siDzUHfFG9al0dd
RNzAt8h3M0N2bJ4eG1unB2sNO1wTd40+6DXQ6+GQE7uZFnjOMjXe36glh0Vs
a479sbeH4v2pMd670Ne377HS1Zqq37/J5eDRWf94twVHnf5YxGTuZ1rYHjUT
9fTE0P/k4IlNoFfk6Rz2gl9Qs9ybOedxTvp77oU3jJ6pbX168Od89HPkHvIO
PX3f1Pv9D8rOH0E=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwj3UUxt/7u7/fve8mYsi+XWtNilRXGRMpoUxiUNOUZIuKSEWjIrsK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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5495890243943553, 0.5028201060534107, 0.8894941758080227], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQl1UZx9/fvr/Le8MxaEqaaSoNDQp22aAUpOkykiIkBKtQU0yriQ2m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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVlUQhu/Xe9ve5atgQQV/uCESEiMUaRCicQXZVaAGMJGkSJAgoGwV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         "],
         VertexColors->None], 
        PolygonBox[{{2483, 2397, 2396, 2110, 887}, {2397, 2486, 888, 2111, 
         2396}},
         VertexColors->None]}]}, 
     {RGBColor[0.6161393172190018, 0.6116266275152266, 0.9106914408331429], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMVWcVhvecfThnX85YCyTqD0Ow1TTQFlAosVXxB6VNgFGHcRhKUGYA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtln1olmUUxu/3Y+69n+ctcAnVHyGLCsHmR84FltkfOcKvbJi6xNE2oymZ
ilmooRC0xAphpv5hpluQUyMMy1DLCkpnI/pSU3OaZCv8wFpRbK2P38X1/nHg
XM917nPOfd/nnPupbFpS91Q2hLABySNHCyE8kYbwN2DSkBCugduLIczLhfA2
hg0xhKl8Wwe+FxkDXg5+E/1P+K1JCHv5djYTQi0+vgDfyPpDZSEsATfCTcG+
FfuJyBb4zcgZ7DeAL8NXgy+jt+IvBR8CN7K2Bh+7ye3L8hCqwPeB+9E/hO/A
fkbGXAQfyNkmj/1A4ny2g6fgbz7xX4UfiexDr4TfQ6zHkBOsv035wI3F/jf4
DvKfw1nUI53obyFN6AeVH/x5fG7Cfj0xelg7mW8vsnYNsoP421Pnpj3sYe1Q
+FV5+2jEvpP1y1g/jG9nwdXwa0vrPwAfLO2/CalLnbNy/QX8DNxhcB/67Xnn
+it47hDn3AO+B/9b0DcjFYpf9F0OEHN30XvSXhrhy1g7Ap/n4T7lWz3x3ufb
gqzPdCzcWvytUnzwMvgT8G1Zn9nT4OVIDbUUy5zbyei7VY7PEWs2fDP2VcRr
htuT+i4H+DYcvo81+9A/QzrhdiGVeefwH/atujP0+fi8gv5y6rPRHf4L/0o0
txdZDH8rOZ/KuUaeBI/Cvgv7duUP9xF3fndwjC7wMeQ63S1yEu4S/rZhu5Ec
z6B/jywCv8OdXkD/IfruZ+RsuyJa15qf0XtLvOrtH/RB5EDGd/4s+cxjz915
x1Quo+D/yDqnjfAzdcbgMcgc9NVFn91V1jwEbiuY60ceTFyzqtVB/BfhL2K/
A3wz9qPBRxLvTWdQxHYl8a5mnOM3cF8jn+jsWd8PN1CqT+U8F/uy1OernpoQ
XWOqrSvBtTY5cW2p5lTrLYljq+Y72d9MbE7hvxb7FvSFSMh5z+qdl8CP5txD
k9DvR45kXVNNxG5E7kD/C/49uP3Rs0j5aa87iTEieM/qnaX4PJB3D2VZex5+
G/rr6qnoGlTtKcYNrB9W9NmpBu/CfmzqvR3DfoXOOrWuO9Psy0bXqmbgOM3L
1LNK9XGYWEvJYXjeOf2YumfVq89jsxr733VmrK3Q/aN/jAxFX8T6b9GPR3PC
09DHJO69KuQW/M2NjqU9dqNPKPgsNKNfi+4J9YJqdid6R7lnje70K/As7L/L
eAY3429B6rNVj6+Eq0k9i5WTer+l9D6Ibyh4pqq2NQMfJrce/D+AHrG5Ezwy
ce6qqccLnvHyp5rTLO4AL855JnezNpd6Vut9mJ665lXr6gH53lX0rFKMz8FH
o98T1UA7+rloX/Ipvb3c+elbNb7Gp36LtOdz5a4J1YLuQG9TQ6me5FO+ldPE
Er6p6DvSfvSmvQGuTVzLmrnHweOje/ES9vvx9wj+X8h65s0GB+UAdxofU1nb
XbBtNu+z7ks9a3RGC9WvBZ/1YN69My2xrXpIs00zTbNMM64e/XR0vurPJfDv
FvxWqAbHgfuie1tvbAb/mxLnop5QL9Ylvjv1pP4FugqOrTvXbL1Q7rddM+Cc
3orEb1UbPrZG94DqUTN6ffSbqrdUPV0Bl4l+W/RPsQ79+oLX6ox+wldvyZ96
/Br6xdS90gueE/2Pon8TnaHeqtHR/x56s1Sba6Jtle8K9Vvqt0hvlN7W6dG9
ozf2fw/fOTw=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6789214669822864, 0.7125000728658433, 0.9121226804760817], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1V31o1lUUvu/e+76/z4libv3RzIEZOLOowNSywo9lEaVhZYW6qTUz2pYu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmto1mUYxp9373/7n96FMYo+FCks+2BaVGC6jnjoQwS58JRCO2islLap
RWJno0KlqBm1tDIsd1CnhFEfYkF08NBpWa3alhikVB5irmhF0e/yeuG94b7+
9+G5n+e57+t5JzW11t9bEUJ4FomQ/5IQvshCaANMrQzhQBrCbORm9KeKIazA
XlUKoRscVYVwWeYY+f6EfRjf9ch89A6kOQ/hY+zH0cfJ2QRuQNax6F/gFfgO
Yi8RPxefudjmIH2FEG7C3kn+PfiswTYHfCf4CP41+NeAH0Kfif8H5KtBRrF3
4t+C//OR11qWe22tGVF7JXIB+q+ssQbbKqQDnJGzDf0bcsboVcjb4DvIeS7x
t4J/Ue2Zcz0N/jZxjHyTStvuAv9dXu8K7C9Sz4MV3tOV4DP4dESu8U/wOPUM
cpb7sDfhuwB7Nfbrsb9FrvXgQwXfgfQnkNVFfysRf4yYLeDbkAfQT8acf2Tc
Al6I/zngWUWfTWPus9f62vv9SF7pMzhFvm3UM45tF/hLYj8v90M70outB5nI
2g3UvBv9JeLb8W0GD4NnsEZWdI4N6BuRj/A/H3kN+8nEudUjP4BPY9+ufiF+
iNr7wY+C6yLv5RryD0TeUw+1rE29N+GoOoTzkNbYPXKC3P34LMN2MXtagG8g
fmvk838c++bMvTUceW//Jq5de9yKf4r/G+iX4l9LfROw7yfXJ8hi9L3lfnwO
KeHbQo7N+HYRM4a+ARko+I4rqO0gMUfBo6wxH32M+F5in9H+0Rch09WvyHH0
W5DfCr7TE7HvVPu9nXyH0adknjXFb0E/GrtW1dQO7qGm66j1jwrf/VRi4sg9
sBa8FPtY5DvT7M3OfRaaQfVigW+NBffkfbl7XL2tHlmSew9aWzn6NO/g3UX3
5CvgodR7GSHHYvxT1ozRT+O/UrOQeP+a9wtL7jH11vvkrwZPAg9i26v10F9n
f/zOzqBiv069vnLorhUjX935OLaZiWtRTQnrLwW/GflOdbeqUbUJb8rMaeKy
a8EFzQbSWekeeUQY++RKc86PFHKG+B5y1xZ8V0vK/KA7exjfBupZWTTH7ETf
VfKsqEd24NuV+S7lf5YbwFMic0QXuCEzt6l1WzV7yERwI/bvyTVU8qxoxq7C
djXyqriZfHWs/13q3tRMiMsHkFWR+1u9OJKam9WTh9RviblEZ6be3Zh59tTD
l7DW5JJ7fxa4m/N4F//fI/dYH7Y9Jd+dOLiRfAdTvxXKKd9FxJyKHHMDttW5
uXYCPvXo+xLvTXdexH5japsepFni78RnNQSOxceJ708zszw3p4rLxLl3g/cn
Pku9OZm4rTzPilEt7yTuRdU0Azw999shjlGvvJz5rVHPqBeOxL5r9cQ89tqc
+O0QJ7Rjr83MbXoz+vHdgUwr+s4W4PtCmW/EQZejfxr77VB94nrtWXsV51eT
rys2l3RHnt1pqWdZM6zc8pFNa1yE3sYa/5TPQ9w5HLuXxaEHEnOQuEczPcJ6
x5AnI3PyV+ijqXtHPSIu/jB2LnHyusQzq1lVz9fl5mBx7+HIXHZP2a55/Dnz
G6y3V2ssTxwjX/XoPGz1md8ivSHvoW/KzdXaQ8L5tibutR6+fRb7zHRWmhH9
94hLtuk/SC+xO3O/leIYvdWPJe4VzeTC1G+AuF89sS31m6u3VjP6P6unLcQ=

         "],
         VertexColors->None], 
        PolygonBox[{{2400, 2504, 903, 2506, 2399}, {2179, 2474, 2473, 2554, 
         941}, {2520, 2400, 2399, 2521, 913}, {2474, 2654, 1043, 2656, 2473}},
         
         VertexColors->None]}]}, 
     {RGBColor[0.741703616745571, 0.8133735182164598, 0.9135539201190205], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV2tolmUYfre933teGqRl2mFl6cQTQdssIyi3CSq2aVBrU0mdkjH716Jm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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1oV2UYxp//f+fsf855jinkVjk1MisTSwnKl4o+qCUUWMsI8pWcCwpm
31IoyxL6UH2pFTrUWZpJpmvDD9ILSPWhhYEOoXSzQimU3ow5NTej3+W1Dzc8
93Pdb8997vs6Nz29trmtGkJYjyTIhDKElcg19SEc46IzD2EV+lj02ZUQerMQ
7ipCOFsXwgYcL9ZCmI9+CT1HkjEhdOHTj+0IPnfiOwPZjH4kDeHBGEI79pPw
PUn89Zw3czcDbBr6bvQWcnRxbka2oh9DT8AfQp9KrFuRXvR3iHma8xD+i9C3
ku8Vzr9g34A+HumllvHU1EadU6hvO/Z/gj+ObTMyF/trwZeDHyH+cfC5+LSD
vY3UwL8BO0NvPgDfD7YxOvZk3lDDN0emYvMe+Bli/wfeCb6n6rfPQo6m7kE9
2FOZY72PvMn7BvC9EewCMgnbLqRFvcNnC3gH8lPFPV1E/gPEeBjsdt7zBLZ3
lO5tis908IXIzWDnyP8o2GLh+G7H5l5yN1Lv8+T8jLsn0X/Ibav4GbEjsjtx
zlnggfw9xGtFloIti/5WP4LfB96N/z1gn6P/Q9y13F3WW6knI3et9Nt0N4Lv
aWymcU5Tf7vj6E0Vf8MN+KbYf5h65hLOdciu1He3lM6h2JoB9fpK9NvU8xXg
TciXqWd4ZukZ1WzqG6zBthWZTv2fqqdgb/C+eYm/wT7esgn97sQ1reS8ovC3
7qj628tGmGagh/P9md++DbxbvSo8uw9wtyP3Dml3DoL/iv+40f5twv85sGdz
97IdvJN6X0MfCZ7RFmKtRqaAreENf1DvR6Px51T8bWZmxvSNToFvK7wr6rGw
hdG7dtUGrBG9e3S/tMuVzLVpp6/ucs2zq50eoJ7fwT+ueieGwC8WnvU+4rdF
z5BmRzt6lNp/w/8R8LfqvHvf5p417eBk4s3Dpw/8UOrYO7hbUu8cj3Eel3m3
A3eN+v7orfLHZxm5lxd+izjkVbAF0b2Trt2/RL5P6swB68BeiMb2cneW82Hq
GA6egX+xP1w49m3iJ3xPleYS7dhw6Z3ULvZzdx7/Bbm55F3uBjifzM2F+mYv
g/+ceVa+qHp2V2d+i2a4JzqGfDVjJ8D7S3ONOGZs9IxoNgbRB8GGo3flO2wm
lq5JtRwi/jpqX0X8vYln6gawy8gJ8L+1c9Ex5CsO2Il9e/RbVeN8zhvxn1g1
58pX/wBxv2J8T69eLLz76tlfmTlU3Klv1op+HTF6sD+g/Jyvj65ddw2c9+C/
JPHM7cP3SubaxfniooYx/leIk/aXnhHNhjjwdWwrhXdLO5Bhew67g4k5V2/v
yz1r6kET+Z7J/HblLNCXou9MzGkvcZ4dzfWawfPEHizMBeKAC5wXZ55tcZpm
eSj37GimdxXuoXqnGVNscbq4XDlUmzhZXKwa9W+ZE72r+sd8Rayvc3O3OFpc
NSG6d+KsLegdpblFHPM/XyIAZQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.800219421052631, 0.8595327368421051, 0.8971914210526318], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVmtolmUYfr/vPX3vYWprzRMIHghTa9FmVNvc0dpC1IL0h2lHDGKbFnxL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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUlslVUYhs+dev//PxeBiiC6IpowyRAXRqVFuaBSQ1pkgQsEIxhICLRq
gmIVI2BiXGhYUCpQIyROYYjW6gZRE4m6AZUhEdSAFrQOpQ6kBZHB5817F1/y
jed855z3/c64pW0LWvMhhHakiHxZDuH6GEIPxoxCCG9kIZxPQ7g1F8J8fD3E
7sO+vxRCE/I4+k9JCDtZpIn8G4m/Q00/+R+S38d6veR0EmvG/hH7TuJ/Yc/B
Xos+gppd6Geo2YO9C1mI/SAyhH6Amj5668BezlqN+M5RPwvpRv+T+Fv0soh4
G/EmfFeIzUVup7d+fK+jP4a8SSyH9KA/QP4f1M7CHiz4DJPIbcGuI3YzvgWV
EEZHr52rQ8c+SPxjcvex56PoW6gZQ3+jydlC7n/sOYnYRGQ38UPYl4s+0zri
g+RP46wjiX/H/gexX6qdZxF6PTl7a/ffS7yBNf7WefDNJn4W+xX0cfjeJXcm
vntYaw7yCHuN0hsR62OPKrmN+J7EHkJO038vMgG9k/zG1Guo9lXON5/YZexT
1F7F9z21z0b3Opv4TNb7gprteb/Br8SHqPmmzjVbKz6TzjIPX5vuA9lOfRX7
WvQdrPFLzmdciz3Eeh2sN4yci9grsKsF1whrB5CNBWNubmoMCnvzkI+wT1bc
u94gGRZCitxED1X2eJvcW8j5h/UbyD9Fbje+Q8S2UfM8+raKe9WZVnKes+R3
sd85cgKxq9F3KQwvJ34D9ihyB3LutaXiu1LPg5ytJTFWNyMd5C7LjI0Jem9i
T+O7Bn1Eydy6ULtPcexf4pujuSaMCUtPpOaWMCUudGOvKZgTlxJjTlibjBzF
XoWdQy8grejH8G1irU3UbKTX9chq7Ns481jiY6LPIs7fRa93Z+aO+hlgv72Z
uXMH9jRqpyNf6/5zxmI/8nLRmPyN3r5ivytF32GZtzif+S70JkvYqx17DfsP
4rsummPilmbGyOgZJOzvIT482iddM0JcFkcUF6dnZD6zzqqZ0ow+kBl/euPx
mWeOZs3JgrG3M/MsEgaF7R+oqS8Z4y8mfjO9lWaEuL2Y/Pqi8aW7PUJOvuQ7
FnbX1fghDC8ltjj6bFupvxTNAWG/q+S3P0HO8JIx0JqaY+KWOPsc8eOJ11JP
4v7psms1AzSrfsfekffMWkn+/tRvoxnTRfy1zLNCby5uXij7rcTRKcTOpO7t
Z+Re9A+iuaSZ8H7qGanZqJnxmWZL6lkoDor7n9f+A2FWvWyoGEvq6SFqn4rm
su5Ms3Qi+cWiZ6r0b1NjUT71Ukg8S9XTEtZ6GNlfMsfGVvwn6C+QT1irpuau
MDeV+JSKuS5MHiZ2JPVfohmrv2RF4r9I8/c9eruI/UneM1N6ZzR35JtMbTM1
paJnxqeJMSTsiDPt0TNHWNAb6q/Rm6t3/TkNiWeuZq04qtl+ouxZqxmvt30m
mvt649XRM0qzSZjS3i8knu3qQVzaXfsPxan/ASZSBa8=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8566020526315786, 0.878334842105263, 0.871932052631579], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlktoXXUQxk9ucu89L1JQl4XgJiIWaTQGUdumFYQ+rOBK0Ap2YUS0QRGj
TbVE00V9RKyYRCklceNCfO2KCjG1TVVSF8aFj9qqbfNQE25Fpag0fr98U7o4
nLnzn5n/zDffzLlX7+y9e1clSZJjepr1bK0lyVkJb0i5piVJuvX7SFOSbC5l
kybJU9LfmyXJ73oOS3+PbJ6RfUPyBr1L2bfKZlq2Q6X9v5X8bJEkf+j8CZ2N
6n1O9jfobLyaJA9Jt5QnyXbZvaJ4/YV9sL+i8H3c9YLivajnNvktyv526VfL
pk/+h/Ssls2CngnJPXoPVxxjLfp6kmwrbfdms2M8KblN+juqjkNtsxFvr2x/
LJzjfslHU9vfJ3lH6TrX6/73ZbNKPiN6/yObZcndum9Itu16/6T41+SWyWWk
4nzOSB4N+aJizVTs9yr3pj5rSH+Tni7pT0q3p7D/p1EbvvuU+7XC7C/17lfd
tTG3/Q+y35XZ/jvJTxf2eavq+g9Kflu6RwvffTBwmZfvCdm/ozgDFd/fWXP+
X0v/SOHa4AbnLU3Old6T11U6f0B277WYQ3CpQ/o74zfyXZLHqpb/1PnJyGeH
fHemzoEegiV9pG7qoZZJvV8rjd+y9EnpWPCI2oizRbptspuW73bVcZ1waJO+
Vz5bas5jssn9/lshZmvuOfwBS/oMnnD0QuA8rjhjuevAry98OT8THCP3zbnz
Pxtcp8bB1Hm0RU2roq5TqfsNfnBkIjXOn8H90v7E680cE359UDjGonQP6/cY
PVP+czVz+HX5DZeuE1z3NXu+KtI1lcaJp6Nm/SfEKS7PMG/mHQzAgnvP6/wb
cetA1TbgyDyyA25OLcNdeAIm3Et8erFO+T8ouy+bzM3f6ubnv/IbLtxn4lZq
jt0ReZPbc6U5jT1zti4zdp9Ld7409nCuNeYdH+rlrn699za7j8fkN5X57Kje
pxVrUPL+qnkMh4m7Jzg8EPwGh0XZbkzNF/g0GPHBpz/if6yYuwv7d8v2o8xn
7JaVvsj+Z+kfy7yfukIPH+DUlYV5xfwRdz5mhP6fC0zGg9v0h/zIjRnDDhtm
eCh2SF+86cUmdnVubnAnd8N39uBU5Daj3G7N7c988xt5QBg/X3oHXAzftvDD
HzzY5Rciz+O12KXMe+o5xKarxT7TgTMY9wQOxCWfE5zHrvtQOZwuHWtU75HS
3yXOF6Ku3cr3/sIc7Za8IfcuGQzu0CP8yYn7kekHua1gXzcmYAyGzCl7gT4c
Dpv52uV6jwdWjcijM3LpiXxeVo7X5/5+vFSaB3DggOSZuvcjeYABuZ0qzRs4
w27+PvV+3lqao9QB7o24azS4zp7ZJNtGYQ60xi5b+d5J91/qmZqNnsGDpcI8
XuFwYE3uv+ieubprvyX3t6o9vkfL8U2ai/5Q++OZ53Yi9t9sxL+0F47EDkDX
Hnc1oqfM3/rcM7gcuV3ayeAO5u/qfKnu/xTgeCju4T8B2IEbe/GLuvvWGb0A
f/bBjZm5uCbzt438v1K+C5lnhh3TG3sOvCajd8zHYswI3z18sKfnU8Ef+jQc
PRgJvq+N/zytof8fqGlWeQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtIVHEUxv/3jnfmztxbQbUMok0QSVCRROWjB0E+CmrTIoNaRAQ6FRGh
mfSYhT0MrJwpIlSoXVG7iEC0ggrdZJtCR8o0p2h64KJFYL/Dtzhwzv3O6/+d
c+6Kw9m9rb5zrh6pQBpj55pC50Y85+4BFCPnOvm2LuncUexXYNewZxLOncGe
TTk3nXbuDvZA4NzKDD7YOexx5Ca+BaSB+Nv4Z8GOI3ctlhrV6EXws/guQk5g
n0QGwUvgregtyDR6nm/fqTeH/yj5qvhWm1FNqzWHPKbfmrRyzSPD9PsCOUXs
F+wOfEew64iv5MGbsTdZDnJ141ODXo289fSGr9Trx27Cdy3fxrAPUD8mvhZ8
DVgpJa6Mk26wbeQf9lRjMhKHxt0l8Eawhli6cfyG2Cn6LSTUoxeLU+OyH5m0
fODLwHcG8n0N/tdXzBJyL0aeeurxEPkH6GkP+iPkF9hvpCdQT8fQR/E5T3wH
8Tl8n0TKXWULsIDewJfbfOh/K/quWLMe8jS7uoy4thk6sM9pcdNHjpf4X+Vb
O/hp8NVgATnnk8o5Ad4Ti7sC9va0alote+Og9Qa+IamZ2G5dxt6S1I49w96B
T2dCNfaB3edbFt3H5wH6Q/rbb28nvoQ9i1R4erPpP5C+hL79I1c+0q7Yzm0M
lcNijdOP2O3gf8B7wfOxdsp2yXa6Gfsn+EJfO7E7FKfG5XXkBngx1FuniJnB
tw18FVguEDeV1BvzxZHt+tJIs7Od7411Q3Y79eDrwYdC5bId+BZpp22XuwLd
xqdQt2M3Yr2VI83OenyfEmfGle3EFfSuWLMyjtvw/RDqrXaTxu2tWLWN4yPY
5YzeZjdyEexCrFu0mU0Q78faXftn2C7OR9oN28mD6M2Rbt84aEF/F+r2jIMy
/T1PazdthufAx0Pdvs3gPy68qw0=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9129846842105261, 0.897136947368421, 0.8466726842105263], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNU7tOW1EQ3OvoYhsfHhKpkIjED6SxaIwSKcaAEaSBlhTkA4IELYa0eZhg
3j/AT9BENhcpSHShhRQWUqDgIaUwj4IZdlAoVnfPnD27M3PO7f84O/kpZWYz
iBeI8WA2kTG7i80uc2YfsP6BvN5mliB6IrNVYMeoGcH6Iud1rNlXzT/0uQZ2
hagBH0qbFRFl7KV4FngF+Bjyd+jTQt7A3p7OLmBdQJ7HrN607xGfS3neFfkc
zpsHdoP6z/h2Rz5rDHhn5DMWEU3zM9QQ1JPn6+q1oBrOZB7Un3VPfCrPagbF
7Y3yn8i3oWU9+OxhRAnRAfwE+taAj2L9MvJa9l+O3TPWVLG/j7q30lOWz0vA
T3KuYQXRBz4oe/SA3Mi/Gvss6uBczqFP5LIpPiPixFl1NMhnveYMPV63mw2I
V0H+UCs1U2MD9VvBeX3HN8m4bvIjJ/IpqT978r5fpX2Pd14T972M92KfEr67
4JBEru+PNB4Cr7T7XSbiRM+o8TZ2nuzJO+6Uj+RBDtQ5pDfGevrRlFfP77lL
56ah5Xda/sd+H8zvNItni2i8HPx9/UJtM+vvYQPYTtY5UB/3+famgB+J23uc
ncD6PnYNIfrvFX0iD/rUJ68S3T31/AUWBfefb6Il7XX5/vR+qsLp2XnOfSP3
e+H8nxqad5r1vnlxLornrfo0xa0qH1ryhH3oaVE86cGB/gt6XhbvL+D7Lfj/
QIy15Eqf6AtnfQ3OgxxYV9C/Qw/oRbc8qcnPB9Cajk4=
         "],
         VertexColors->None], 
        PolygonBox[{{2244, 3209, 1595, 1597}, {2003, 3218, 1606, 269}, {2500, 
         3147, 1531, 227}, {3148, 2025, 309, 1532}, {2245, 3145, 1528, 
         1598}, {3211, 3210, 307, 1595}, {3314, 2243, 627, 1733}, {3222, 3221,
          270, 1609}, {2269, 3217, 1605, 1606}, {2113, 3053, 1422, 1528}, {
         3073, 3074, 1405, 307}, {2124, 3146, 1530, 1531}, {3037, 3199, 1406, 
         1405}, {3219, 2241, 626, 1607}, {3313, 1992, 244, 1731}, {3165, 3164,
          269, 1423}, {1993, 3314, 1733, 244}, {3214, 2252, 640, 1529}, {3056,
          2114, 1529, 1425}, {3146, 2125, 1532, 1530}, {2490, 2112, 447, 
         452}, {2004, 3057, 1425, 270}, {3217, 2270, 1607, 1605}, {2606, 3213,
          1598, 309}, {2112, 3212, 1597, 447}, {2355, 3313, 1731, 626}, {3223,
          3224, 1609, 627}, {3039, 2500, 227, 1406}, {3053, 3054, 1423, 
         1422}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2116, 2490, 2112, 3212, 2244, 3209, 3211, 3210, 2533, 2024, 
         3073, 3074, 3037, 3199, 3038, 3039, 2500, 3147, 2124, 3146, 2125, 
         3148, 2025, 2606, 3213, 2245, 3145, 2113, 3053, 3054, 3055, 3165, 
         3164, 2003, 3218, 2269, 3217, 2270, 3219, 2241, 2355, 3313, 1992, 
         2531, 1993, 3314, 2243, 2242, 3223, 3224, 3220, 3222, 3221, 2469, 
         3155, 2004, 3057, 3056, 2114, 3214, 2252, 2685, 3050}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2154, 2541, 2536, 2537, 2254, 2731, 2253, 2922, 2492, 2030, 
         2733, 2470, 2104, 2540, 2395, 2834, 2835, 2720, 2721, 2023, 2530, 
         3072, 3071, 2722, 2145, 2836, 2413, 2414, 2267, 2940, 2268, 2942, 
         2264, 2939, 2266, 2937, 2265, 2938, 2491, 3294, 2365, 2991, 2366, 
         2992, 2298, 2967, 2300, 2966, 2299, 2418, 2417, 2273, 3316, 2027, 
         2625, 2026, 3202, 3203, 3201, 2239, 2599, 2016, 2618, 2619, 2259, 
         2924, 2258, 2925, 2983, 2348, 3333, 2347, 2638, 2180, 3328, 2371, 
         2797, 2796, 2370, 3295, 2993, 2693, 2126, 2798, 2406, 2621, 2622, 
         2502, 2501, 2598, 2623, 2624, 2416, 2415, 2633, 2146, 2909, 2910, 
         2682, 3046}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2031, 2737, 2738, 2838, 3154, 2837, 2728, 2843, 2151, 2730, 
         2732, 3097, 3322, 3098, 3167, 3166, 3099, 2842, 2150, 2839, 2841, 
         2840, 1991, 2833, 2831, 3045, 2832, 2680, 2144, 2514, 2513, 2022, 
         2549, 2941, 2550, 2936, 2935, 2652, 2653, 2454, 2660, 2659, 2965, 
         2183, 2561, 2725, 2482, 2109, 2626, 2108, 2481, 1987, 2806, 2127, 
         2805, 2807, 3335, 3337, 3336, 2032, 3157, 3117, 3118, 3116, 3120, 
         3119, 2039, 2627, 2040, 3318, 2280, 3070, 3069, 3152, 3151, 2407, 
         3066, 3315, 3067, 2927, 3068, 2019, 2620, 2018, 2717, 2716, 2260, 
         2926, 2135, 2519, 2345, 2639, 2346, 2373, 2498, 2499, 2375, 2995, 
         2376, 2996, 2374, 3298, 3299, 3061, 2009, 2508, 2010, 3225, 3226, 
         2944, 2272, 2552, 2551, 2724, 2723, 2964, 2297, 2764, 3094, 2051, 
         2532, 2605}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2296, 2943, 2271, 2655, 2654, 2474, 2179, 2478, 2945, 2477, 
         2692, 2691, 2994, 3060, 2372, 2505, 3348, 2504, 2400, 2520, 2107, 
         3350, 3349, 3332, 2479, 2713, 2714, 2140, 2824, 2827, 2826, 2139, 
         2822, 2138, 2823, 1988, 2543, 3290, 3291, 3289, 2361, 3292, 2283, 
         3232, 2286, 3230, 2285, 3231, 2435, 2524, 2525, 2250, 3330, 2249, 
         2610, 2049, 3321, 2294, 2464, 2463, 3168, 2174, 3077, 3076, 3075, 
         2147, 3153, 2064, 3108, 3110, 3109, 2033, 2159, 3080, 3079, 3078, 
         2155, 2700, 2012, 2494, 2011, 2699, 2698, 2804, 2803, 2098, 2917, 
         2918, 2683, 3049, 1996, 2607, 1997, 2684, 2455, 2096, 2560, 2095, 
         2885, 2886, 2708, 2178, 2884, 2263, 2411, 2410, 2548, 2133, 2907, 
         2908, 2681, 2968, 3245, 2301, 2766, 2768, 3100, 3323, 3101, 3247, 
         3246, 3102, 2874, 2173, 2871, 2873, 3347, 2872, 2029, 2424, 2028, 
         2727, 2726, 2148, 2883, 2177, 2650, 2997}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1954, 2471, 2656, 2473, 2554, 2553, 2106, 2507, 2123, 2398, 
         2122, 2401, 2506, 2399, 2521, 2137, 2480, 2715, 2017, 2445, 2558, 
         2460, 2825, 2461, 2523, 2522, 2392, 2845, 2160, 2746, 2748, 2956, 
         2284, 2750, 3085, 2593, 2227, 2898, 2228, 2671, 2672, 1982, 1958, 
         2829, 1959, 3300, 2828, 2664, 2065, 3243, 3244, 3240, 3242, 3241, 
         2013, 2641, 2642, 2409, 2408, 2647, 2349, 2350, 1983, 2673, 2985, 
         2984, 2232, 2904, 2231, 2905, 2569, 1999, 2986, 2987, 2403, 2402, 
         2646, 2307, 2368, 2367, 2931, 2932, 2930, 2934, 2933, 2262, 2928, 
         2261, 2929, 2596, 2005, 2442, 2443, 2117, 2781, 2790, 2789, 2802, 
         2457, 2913, 2914, 2912, 2916, 2915, 2246, 2921, 2248, 2919, 2247, 
         2391, 2390, 2816, 2134, 2709, 2817, 3064, 2015, 2818, 2014, 2547, 
         2171, 2412, 2172, 2516, 2515, 2603, 2604, 2302, 2767, 2769, 2770, 
         2546, 2611, 2612, 2539, 2149, 2875, 2729, 2425, 2060, 2534, 2535, 
         2379, 2651, 1953, 2526, 2465}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2103, 2466, 2141, 2378, 2142, 2527, 2059, 2528, 2529, 2422, 
         2421, 2538, 2006, 3058, 2870, 2169, 2794, 2170, 2496, 2495, 3096, 
         3095, 2765, 2869, 2868, 2131, 2643, 2132, 2512, 2710, 2711, 2517, 
         2518, 2238, 2678, 3043, 3044, 2799, 1986, 2430, 2920, 2431, 2609, 
         2608, 2380, 2381, 2100, 2780, 2783, 2782, 2063, 2595, 2062, 2440, 
         2255, 2901, 2230, 2902, 3196, 3195, 2903, 2893, 3171, 2896, 2195, 
         2894, 2194, 2895, 2356, 3283, 2357, 3284, 2251, 2635, 2636, 2384, 
         1960, 2637, 1964, 2630, 3235, 2288, 3234, 2289, 2632, 2631, 3092, 
         3091, 3236, 2290, 3103, 2054, 3325, 2306, 2163, 2352, 3334, 2351, 
         2600, 2053, 3324, 2305, 2066, 3233, 2287, 3088, 3089, 3090, 2628, 
         2629, 2363, 3293, 2362, 2544, 1990, 2865, 2866, 2864, 2165, 3163, 
         2167, 3162, 2166, 2761, 2760, 2758, 2863, 2862, 2156, 2594, 2157, 
         2542, 2749, 2041, 2562, 2975, 2976, 2747, 2315, 2977, 2099, 2459, 
         2658, 2386, 2182, 2559, 2068, 2821, 2136, 2810, 2820, 2819, 1995, 
         2503, 1994, 2483, 2397, 2486, 2485, 2105, 2556, 2557, 2472, 2657}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2181, 2555, 2475, 3051, 2476, 2111, 2396, 2110, 2484, 3048, 
         3047, 3149, 2129, 3150, 2809, 2814, 2813, 2067, 2509, 2510, 2385, 
         1980, 1955, 2458, 1957, 3001, 2661, 2979, 2978, 2184, 2955, 2282, 
         2950, 2281, 2954, 2034, 2419, 2295, 2759, 2762, 2763, 2563, 3170, 
         2186, 2888, 2890, 2889, 2101, 2784, 2785, 3339, 3341, 3340, 2045, 
         3087, 2044, 3338, 2855, 2755, 2852, 2851, 2162, 2881, 2175, 2771, 
         2772, 2311, 3326, 2056, 2634, 2310, 2364, 3320, 2046, 2545, 2047, 
         3263, 3264, 3262, 2314, 3265, 2198, 2571, 2318, 2974, 2313, 2773, 
         3106, 3107, 2597, 2233, 3197, 2234, 1965, 3303, 2205, 2078, 2213, 
         2212, 3186, 3185, 3023, 2077, 3183, 3184, 3018, 3019, 2576, 2204, 
         3271, 2323, 3270, 2322, 2570, 3175, 2202, 3174, 2203, 3176, 2196, 
         2981, 2317, 2980, 2316, 3268, 2567, 2568, 2191, 2665, 3005, 3006, 
         2446, 2663, 2662, 2900, 2229, 2899, 3194, 3193, 2441, 1989, 2433, 
         2434, 2565, 2564, 2775, 2774, 2456, 2097, 2432, 2679, 2800, 2801, 
         2696, 2697, 2923, 2257, 2712, 3065, 2617, 2256, 2990, 2360, 2989, 
         3286, 3285, 2511, 2867, 2791, 2792, 2648, 2118, 2795, 2121, 2793, 
         2120, 2405, 2404, 2830, 2143, 2718, 2719, 2021, 2423, 2020, 2467, 
         2468, 2240, 2601, 2394}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1998, 3052, 3216, 3215, 2153, 2734, 2735, 2736, 2487, 2911, 
         2811, 2812, 2703, 2704, 2705, 2444, 3063, 3062, 2702, 2128, 2808, 
         2092, 2451, 2277, 2953, 2278, 3229, 3228, 2887, 3169, 2952, 2276, 
         2949, 2275, 2951, 3082, 3081, 3344, 2274, 3227, 2946, 2948, 2947, 
         2185, 2962, 2963, 2959, 2961, 2960, 2462, 3158, 3159, 2846, 2848, 
         2847, 2161, 2751, 2752, 2753, 2854, 2853, 2042, 3253, 3254, 3252, 
         3256, 3255, 2188, 3266, 3267, 3002, 3003, 3004, 2958, 1961, 3301, 
         2957, 2666, 2197, 2897, 2189, 2982, 2320, 2667, 2668, 2572, 2200, 
         3179, 2207, 3177, 2206, 3178, 2574, 3180, 3181, 3132, 2079, 3131, 
         2080, 3187, 2214, 3020, 1968, 3134, 2082, 3027, 3028, 3029, 1970, 
         3137, 2083, 3032, 3033, 2217, 3329, 2216, 2447, 2087, 2448, 1975, 
         3307, 2221, 3189, 3034, 2086, 3140, 2219, 3342, 2220, 2085, 3138, 
         2084, 3139, 1974, 2583, 1972, 3305, 2335, 2582, 2581, 2333, 3346, 
         2334, 2215, 2332, 3331, 2331, 2579, 2329, 3345, 2330, 2211, 3275, 
         2328, 3274, 2327, 2578, 2210, 3273, 2326, 3015, 3016, 3017, 2575, 
         1963, 3010, 2676, 2675, 2674, 2074, 3173, 2193, 3172, 2192, 2779, 
         2071, 3124, 3125, 2892, 2891, 2906, 3205, 3206, 3204, 3208, 3207, 
         2055, 2566, 3249, 2308, 3248, 2309, 3250, 3251, 2971, 2973, 2972, 
         1956, 1981, 3022, 3021, 2226, 3192, 2225, 2970, 2304, 2969, 2303, 
         2695, 2694, 2453, 2094, 2616, 2093, 2452, 2649, 2882, 2176, 3327, 
         2690, 3059, 2008, 2613, 2007, 2689, 2688, 2359, 2988, 2119, 2497, 
         3036, 3198, 2235, 3343, 3035, 3093, 2050, 2602, 3282, 2353, 3281, 
         2354, 2489, 2488, 2493, 2115}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1952, 2377, 2358, 2686, 2687, 2001, 2640, 2002, 2787, 2788, 
         2786, 2102, 2388, 2387, 2614, 2615, 2450, 2449, 2000, 3238, 2291, 
         3237, 2292, 3239, 2236, 3200, 2237, 3040, 3041, 3042, 2858, 1985, 
         3312, 2857, 2677, 2743, 2742, 2038, 2744, 2745, 2740, 2741, 2036, 
         2644, 2037, 3084, 3083, 3288, 3287, 2187, 3122, 2069, 3121, 2070, 
         3123, 2190, 3127, 2072, 3126, 2073, 3128, 2201, 3130, 2075, 3129, 
         2076, 3182, 2209, 3014, 1967, 3133, 2081, 3024, 3025, 3026, 1969, 
         3135, 3136, 3030, 3031, 1984, 1971, 2580, 1973, 3306, 2336, 2585, 
         2584, 3188, 2218, 3142, 2088, 3141, 2089, 2337, 3308, 1976, 2586, 
         2587, 2339, 3276, 2338, 3277, 2588, 3190, 3191, 3144, 2090, 3143, 
         2091, 2340, 3309, 1977, 2589, 1978, 3310, 2341, 2222, 2342, 3311, 
         1979, 2590, 2223, 3280, 2344, 3278, 2343, 3279, 2591, 2592, 2224}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2168, 3156, 2152, 3000, 2999, 2998, 2061, 3160, 3161, 2856, 
         2164, 2707, 2706, 2701, 2130, 2815, 2389, 2844, 2158, 2739, 2876, 
         3317, 2035, 2877, 2426, 2427, 2279, 2429, 2428, 2052, 2438, 2439, 
         2293, 2437, 2436, 2861, 2048, 2757, 2756, 2860, 2859, 2393, 2849, 
         2850, 2754, 2878, 3319, 2043, 3086, 2879, 2880, 2776, 2778, 2777, 
         2058, 3114, 3115, 3111, 3113, 3112, 3261, 2057, 3105, 3104, 3260, 
         3259, 2420, 3296, 3297, 3257, 3258, 2312, 2645, 2382, 2383, 2369, 
         3009, 3008, 3007, 2319, 3269, 2199, 2321, 3302, 1962, 2573, 1966, 
         3304, 2324, 2208, 3272, 2325, 3011, 3012, 3013, 2577, 2670, 2669}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 190},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21182081]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Calculate the moments of the ",
 ButtonBox["binomial distribution",
  BaseStyle->"Hyperlink",
  ButtonData->"http://mathworld.wolfram.com/BinomialDistribution.html"],
 " from the exponential generating function:"
}], "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"egf", "[", 
    RowBox[{"n_", ",", "p_"}], "]"}], "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"p", " ", 
      RowBox[{"Exp", "[", "t", "]"}]}], "+", 
     RowBox[{"(", 
      RowBox[{"1", "-", "p"}], ")"}]}], ")"}], "^", "n"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", "k", "]"}], "[", 
      RowBox[{"egf", "[", 
       RowBox[{"n", ",", " ", "p"}], "]"}], "]"}], "[", "0", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "4"}], "}"}]}], "]"}], "//", 
  "Factor"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"n", " ", "p"}], ",", 
   RowBox[{"n", " ", "p", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "p", "+", 
      RowBox[{"n", " ", "p"}]}], ")"}]}], ",", 
   RowBox[{"n", " ", "p", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"3", " ", "p"}], "+", 
      RowBox[{"3", " ", "n", " ", "p"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["p", "2"]}], "-", 
      RowBox[{"3", " ", "n", " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["n", "2"], " ", 
       SuperscriptBox["p", "2"]}]}], ")"}]}], ",", 
   RowBox[{"n", " ", "p", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"7", " ", "p"}], "+", 
      RowBox[{"7", " ", "n", " ", "p"}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["p", "2"]}], "-", 
      RowBox[{"18", " ", "n", " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["n", "2"], " ", 
       SuperscriptBox["p", "2"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["p", "3"]}], "+", 
      RowBox[{"11", " ", "n", " ", 
       SuperscriptBox["p", "3"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["n", "2"], " ", 
       SuperscriptBox["p", "3"]}], "+", 
      RowBox[{
       SuperscriptBox["n", "3"], " ", 
       SuperscriptBox["p", "3"]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{452, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2120156]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13283],

Cell[TextData[{
 "Convert from ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"Pi", "/", "5"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22262],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"-", "1"}], ")"}], 
  RowBox[{"1", "/", "5"}]]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531687224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1661],

Cell["\<\
Convert from exponential to trigonometric and hyperbolic functions:\
\>", "ExampleText",
 CellID->18617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{"Exp", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12631],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cosh", "[", "x", "]"}], "+", 
  RowBox[{"Sinh", "[", "x", "]"}]}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142146018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31554],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->444582935]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"Pi", "/", "5"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29594],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], "+", 
  FractionBox[
   SqrtBox["5"], "4"], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   SqrtBox[
    RowBox[{
     FractionBox["5", "8"], "-", 
     FractionBox[
      SqrtBox["5"], "8"]}]]}]}]], "Output",
 ImageSize->{150, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->567651405]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Convert trigonometric and hyperbolic functions into exponentials:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], ",", " ", 
    RowBox[{"Cosh", "[", "z", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}], ",", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "z"}]], "2"], "+", 
    FractionBox[
     SuperscriptBox["\[ExponentialE]", "z"], "2"]}]}], "}"}]], "Output",
 ImageSize->{187, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430468283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Calculate special values as radicals:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"I", " ", 
   RowBox[{"Pi", "/", "32"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "32"]]], "Output",
 ImageSize->{28, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283052073]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"ExpToTrig", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox[
        RowBox[{"2", "+", 
         SqrtBox["2"]}]]}]]}]]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox[
        RowBox[{"2", "+", 
         SqrtBox["2"]}]]}]]}]]}]}]], "Output",
 ImageSize->{337, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->568618298]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Extract numerators and denominators:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"x", "-", 
      RowBox[{"1", "/", "y"}]}]]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], ",", "1", ",", 
   SuperscriptBox["\[ExponentialE]", "x"]}], "}"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201254415]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"x", "-", 
      RowBox[{"1", "/", "y"}]}]]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SuperscriptBox["\[ExponentialE]", "x"], ",", 
   SuperscriptBox["\[ExponentialE]", 
    FractionBox["1", "y"]]}], "}"}]], "Output",
 ImageSize->{76, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->450438695]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37865419],

Cell["\<\
Reciprocals of the exponential function evaluate to exponential functions:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Exp", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "x"}]]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30164]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " arises from the power function in a limit:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["x", "n"]}], ")"}], "n"], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "x"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54888053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Compose with inverse functions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Log", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"Exp", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"Log", "[", 
    SuperscriptBox["\[ExponentialE]", "z"], "]"}]}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614865]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " disregards multivaluedness of ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2044861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40827606]
}, Open  ]],

Cell[TextData[{
 "Obtain a form correct for all complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 "\[Hyphen]values:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"%%", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"z", "+", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox[
        RowBox[{"Im", "[", "z", "]"}], 
        RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{200, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->161107376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Compose with inverse trigonometric and hyperbolic functions:", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", 
       RowBox[{"ArcSin", "[", "x", "]"}]}], "]"}], ",", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", 
       RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}]}], "}"}], "//", 
   "TrigToExp"}], "//", "Together"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "x"}], "+", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], ",", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], 
     RowBox[{"-", 
      FractionBox["\[ImaginaryI]", "2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     FractionBox["\[ImaginaryI]", "2"]]}]}], "}"}]], "Output",
 ImageSize->{218, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360178880]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32439],

Cell[TextData[{
 "Solve transcendental equations involving ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->13082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], "+", "x"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28562],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    RowBox[{"ProductLog", "[", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], ",", "1"}], "]"}]}]}]}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34978936]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], "+", "x"}], "==", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31592],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "0.5671432904097811`"}]}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->292745695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], "-", "x"}], "==", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"2", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16222],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"0.3181315052047642`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.3372357014306895`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17763615]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Reduce an exponential equation:  ", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}], "==", "1"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
      RowBox[{"\[Beta]", "\[Equal]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{481, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194924184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integrals:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["z", "\[Alpha]"], 
   RowBox[{"Exp", "[", 
    SuperscriptBox["z", "\[Beta]"], "]"}], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["z", 
     RowBox[{"1", "+", "\[Alpha]"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox["z", "\[Beta]"]}], ")"}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "\[Alpha]"}], "\[Beta]"]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "\[Alpha]"}], "\[Beta]"], ",", 
      RowBox[{"-", 
       SuperscriptBox["z", "\[Beta]"]}]}], "]"}]}], "\[Beta]"]}]], "Output",
 ImageSize->{202, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199875941]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   FractionBox[
    SuperscriptBox["t", "k"], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "t"], "+", "1"}]], 
   RowBox[{"\[DifferentialD]", "t"}]}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "k", "]"}], ">", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"-", "k"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["2", "k"]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "k"}], "]"}], " ", 
    RowBox[{"Zeta", "[", 
     RowBox[{"1", "+", "k"}], "]"}]}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox[
      SuperscriptBox["t", "k"], 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", "t"]}]], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "k", "]"}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{369, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76985525]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], " ", 
      SuperscriptBox["t", "2"]}], "-", 
     FractionBox["b", 
      SuperscriptBox["t", "2"]]}]], 
   RowBox[{"\[DifferentialD]", "t"}]}]}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", "a", "]"}], ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"Re", "[", "b", "]"}], ">", "0"}]}], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SqrtBox["a"], " ", 
       SqrtBox["b"]}]], " ", 
     SqrtBox["\[Pi]"]}], 
    RowBox[{"2", " ", 
     SqrtBox["a"]}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          SuperscriptBox["t", "4"]}]}], 
        SuperscriptBox["t", "2"]]}]], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "a", "]"}], "\[LessEqual]", "0"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Re", "[", "a", "]"}], ">", "0"}], "&&", 
         RowBox[{
          RowBox[{"Re", "[", "b", "]"}], "\[LessEqual]", "0"}]}], ")"}]}]}]}],
     "]"}]}], "]"}]], "Output",
 ImageSize->{533, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->119324505]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", 
   RowBox[{"2", " ", "\[Pi]"}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "t"}]]], 
   RowBox[{"\[DifferentialD]", "t"}]}]}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->785908045]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integral transforms:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["s", "2"], "4"]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{35, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466065679]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"Abs", "[", "t", "]"}]}], "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "\[Pi]"]], 
  RowBox[{"1", "+", 
   SuperscriptBox["s", "2"]}]]], "Output",
 ImageSize->{41, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->753204041]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "\[Mu]"}], "  ", 
     RowBox[{
      RowBox[{"Abs", "[", "k", "]"}], "^", "3"}], "  ", "t"}], "]"}], ",", 
   "k", ",", "x", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Mu]", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"18", " ", 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], " ", "t", " ", "\[Mu]"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", "\[Pi]", " ", 
     SqrtBox["x"], " ", 
     SqrtBox[
      FractionBox["t", "\[Mu]"]], " ", "\[Mu]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        RowBox[{"BesselI", "[", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "3"]}], ",", 
          RowBox[{"-", 
           FractionBox[
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], 
              RowBox[{"1", "/", "4"}]], " ", 
             SuperscriptBox["x", 
              RowBox[{"3", "/", "2"}]]}], 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", 
             SqrtBox[
              RowBox[{"t", " ", "\[Mu]"}]]}]]}]}], "]"}]}], "+", 
       RowBox[{"BesselI", "[", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "3"]}], ",", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"3", "/", "4"}]], " ", 
           SuperscriptBox["x", 
            RowBox[{"3", "/", "2"}]]}], 
          RowBox[{"3", " ", 
           SqrtBox["3"], " ", 
           SqrtBox[
            RowBox[{"t", " ", "\[Mu]"}]]}]]}], "]"}], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"BesselI", "[", 
         RowBox[{
          FractionBox["1", "3"], ",", 
          RowBox[{"-", 
           FractionBox[
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], 
              RowBox[{"1", "/", "4"}]], " ", 
             SuperscriptBox["x", 
              RowBox[{"3", "/", "2"}]]}], 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", 
             SqrtBox[
              RowBox[{"t", " ", "\[Mu]"}]]}]]}]}], "]"}]}], "+", 
       RowBox[{"BesselI", "[", 
        RowBox[{
         FractionBox["1", "3"], ",", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"3", "/", "4"}]], " ", 
           SuperscriptBox["x", 
            RowBox[{"3", "/", "2"}]]}], 
          RowBox[{"3", " ", 
           SqrtBox["3"], " ", 
           SqrtBox[
            RowBox[{"t", " ", "\[Mu]"}]]}]]}], "]"}]}], ")"}]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["4", "3"], ",", 
         FractionBox["5", "3"]}], "}"}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["x", "3"]}], 
         RowBox[{"27", " ", "t", " ", "\[Mu]"}]]}]}], "]"}]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["4", "3"], ",", 
         FractionBox["5", "3"]}], "}"}], ",", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["x", "3"]}], 
        RowBox[{"27", " ", "t", " ", "\[Mu]"}]]}], "]"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{567, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->106440334]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Sums:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "\[Infinity]"], 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"k", " ", "z"}]], "k"]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "-", 
    SuperscriptBox["\[ExponentialE]", "z"]}], "]"}]}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11582592]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "\[Infinity]"], 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"k", "-", "1"}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"k", " ", "w"}]]}], 
   SuperscriptBox["k", "2"]]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"PolyLog", "[", 
   RowBox[{"2", ",", 
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", "w"]}]}], "]"}]}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134466457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The coefficients of the series of nested exponential functions are multiples \
of Bell numbers:  \
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"Exp", "[", "t", "]"}], "-", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", 
   FractionBox["5", "6"], ",", 
   FractionBox["5", "8"], ",", 
   FractionBox["13", "30"], ",", 
   FractionBox["203", "720"], ",", 
   FractionBox["877", "5040"], ",", 
   FractionBox["23", "224"], ",", 
   FractionBox["1007", "17280"], ",", 
   FractionBox["4639", "145152"], ",", 
   FractionBox["22619", "1330560"], ",", 
   FractionBox["4213597", "479001600"]}], "}"}]], "Output",
 ImageSize->{515, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263143]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BellB", "[", "n", "]"}], "/", 
    RowBox[{"n", "!"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "0", ",", " ", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", 
   FractionBox["5", "6"], ",", 
   FractionBox["5", "8"], ",", 
   FractionBox["13", "30"], ",", 
   FractionBox["203", "720"], ",", 
   FractionBox["877", "5040"], ",", 
   FractionBox["23", "224"], ",", 
   FractionBox["1007", "17280"], ",", 
   FractionBox["4639", "145152"], ",", 
   FractionBox["22619", "1330560"], ",", 
   FractionBox["4213597", "479001600"]}], "}"}]], "Output",
 ImageSize->{515, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->58925932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263729340],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->501651567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Exp", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->601177333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "Protected", ",", 
   "ReadProtected"}], "}"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->554906785]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"2", "+", "GoldenRatio"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10111011],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->495652176]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4226],

Cell["Exponentials can be very large:", "ExampleText",
 CellID->7848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"10", "^", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20634],

Cell[BoxData["3.033215396802087545087`9.954589770191005*^434294"], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253459268]
}, Open  ]],

Cell["\<\
And can become too large for computer representation of a number:\
\>", "ExampleText",
 CellID->5789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7978],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->911593782],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->242201728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Literal matchings may fail because exponential functions evaluate to powers \
with base ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"x", "+", "y"}], "]"}], ",", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"_", "+", "_"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145213622]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", "x", "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"E", ",", "x"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->259861522]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " to avoid evaluation:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   RowBox[{"Exp", "[", "x", "]"}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Hold", "[", 
    RowBox[{"Exp", "[", "x", "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->356861718]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"Unevaluated", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"x", "+", "y"}], "]"}], "]"}], ",", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"_", "+", "_"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->153271421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Logarithms in exponents are not always automatically resolved:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "Pi"}], " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "]"}], ",", 
   RowBox[{"Exp", "[", 
    RowBox[{"1", "-", 
     RowBox[{"Pi", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"-", "\[Pi]"}]], ",", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"1", "-", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]}]]}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43999422]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " to remove logarithms in exponents:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"-", "\[Pi]"}]], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"-", "\[Pi]"}]], " ", "\[ExponentialE]"}]}], "}"}]], "Output",
 ImageSize->{77, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->658726643]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"20", "+", 
   RowBox[{
    RowBox[{"10.", "^", "30"}], " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"3.1742808686906654`*^8", "-", 
  RowBox[{"3.669123553434312`*^8", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266717639]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"20", "+", 
     RowBox[{
      RowBox[{"10", "^", "30"}], " ", "I"}]}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "4.8319115254839963599775926150047535496`20.148744333321698*^8"}], "-",
   
  RowBox[{
  "4.372158432592736407552353738113888229`19.105321250728544*^7", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{384, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136429588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "No power series exists at infinity, where ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " has an essential singularity:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "x"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193699780]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " is applied element\[Hyphen]wise to matrices; ",
 Cell[BoxData[
  ButtonBox["MatrixExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixExp"]], "InlineFormula"],
 " finds matrix exponentials:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "\[ExponentialE]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ExponentialE]", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143361530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixExp", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], 
      RowBox[{"2", " ", "\[ExponentialE]"}]], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], 
      RowBox[{"2", " ", "\[ExponentialE]"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], 
      RowBox[{"2", " ", "\[ExponentialE]"}]], ",", 
     FractionBox[
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], 
      RowBox[{"2", " ", "\[ExponentialE]"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{240, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222162311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"exp", " ", "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"exp", " ", "x"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->543240912]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"exp", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "x"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->316625050]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31987],

Cell["Find correction terms to a classic limit:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["z", "n"]}], ")"}], "n"], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "z"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "z"], " ", 
     SuperscriptBox["z", "2"]}], 
    RowBox[{"2", " ", "n"}]], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox["\[ExponentialE]", "z"], " ", 
    SuperscriptBox["z", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"8", "+", 
      RowBox[{"3", " ", "z"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "n"], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "n"], "]"}], "3"],
    SeriesData[$CellContext`n, 
     DirectedInfinity[1], {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`n, 
   DirectedInfinity[1], {
   E^$CellContext`z, Rational[-1, 2] E^$CellContext`z $CellContext`z^2, 
    Rational[1, 24] E^$CellContext`z $CellContext`z^3 (8 + 3 $CellContext`z)},
    0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{261, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->693799787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Closed-form expression for the partial sum of the power series of ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ":  "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "k"}], "/", 
    RowBox[{"k", "!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "z"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"1", "+", "n"}], ",", "z"}], "]"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"2", "+", "n"}], "]"}]]], "Output",
 ImageSize->{162, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->695838866]
}, Open  ]],

Cell[TextData[{
 "Leading correction for the difference to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " for large ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "z", "]"}], "-", "%"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "\[Infinity]", ",", "2"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "n"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "n"], ")"}], 
    RowBox[{
     FractionBox["3", "2"], "+", "n"}]], " ", 
   SuperscriptBox["z", 
    RowBox[{"1", "+", "n"}]]}], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{92, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102264530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Nested exponential functions over the complex plane:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"Nest", "[", 
     RowBox[{"Exp", ",", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", " ", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->843031481]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Fractal from iterating ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ":  "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Length", " ", "@", 
    RowBox[{"FixedPointList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"TrueQ", "[", 
          RowBox[{
           RowBox[{"Abs", "[", "#", "]"}], ">", 
           RowBox[{"10.", "^", "5"}]}], "]"}], ",", "Indeterminate", ",", 
         RowBox[{"Exp", "[", 
          RowBox[{"#", "/", 
           RowBox[{"(", 
            RowBox[{"x", "+", 
             RowBox[{"I", " ", "y"}]}], ")"}]}], "]"}]}], "]"}], "&"}], ",", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", "10"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61688343]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The almost nowhere differentiable Riemann\[Dash]Weierstrass function:  \
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "#", "]"}], ",", 
       RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "@", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "1"}], "200"], 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["j", "3"], " ", "\[CurlyPhi]"}]], 
      SuperscriptBox["j", "2"]]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280301123]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6616],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/E"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpToTrig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpToTrig"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProductLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProductLog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3534]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20483],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->24243],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->6286]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->23592],

Cell[TextData[{
 ButtonBox["Demonstrations with Exp",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Exp"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ExponentialFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Exp/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Exp"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->547202679],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->121304795],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->25191509],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->452345001],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->374149471]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 51.5291904}", "context" -> "System`", 
    "keywords" -> {
     "alog", "antilg", "antilog", "antilogarithm", "exponential", "ldexp", 
      "exponenta"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Exp[z] is the exponential function. ", "synonyms" -> {}, 
    "title" -> "Exp", "type" -> "Symbol", "uri" -> "ref/Exp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5802, 187, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->31402303]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[215089, 5607, 391, 12, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"],
  Cell[217351, 5695, 139, 3, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 351768, 8202},
 {"XRef-2005-4-26-23-37-1.8558342", 351924, 8206}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2976, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3599, 92, 41, 1, 70, "ObjectName",
 CellID->14405],
Cell[3643, 95, 461, 15, 70, "Usage",
 CellID->23813]
}, Open  ]],
Cell[CellGroupData[{
Cell[4141, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4619, 132, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4742, 138, 233, 8, 70, "Notes",
 CellID->9487],
Cell[4978, 148, 208, 7, 70, "Notes",
 CellID->31226],
Cell[5189, 157, 191, 7, 70, "Notes",
 CellID->28162],
Cell[5383, 166, 382, 16, 70, "Notes",
 CellID->6155]
}, Closed]],
Cell[CellGroupData[{
Cell[5802, 187, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->31402303],
Cell[CellGroupData[{
Cell[6186, 201, 148, 5, 70, "ExampleSection",
 CellID->375870707],
Cell[CellGroupData[{
Cell[6359, 210, 97, 3, 28, "Input",
 CellID->14566],
Cell[6459, 215, 175, 5, 36, "Output",
 CellID->324439361]
}, Open  ]],
Cell[6649, 223, 121, 3, 70, "ExampleDelimiter",
 CellID->17137],
Cell[CellGroupData[{
Cell[6795, 230, 143, 5, 28, "Input",
 CellID->25748],
Cell[6941, 237, 256, 8, 44, "Output",
 CellID->329662751]
}, Open  ]],
Cell[7212, 248, 77, 1, 70, "ExampleText",
 CellID->24423],
Cell[CellGroupData[{
Cell[7314, 253, 116, 4, 70, "Input",
 CellID->7272],
Cell[7433, 259, 360, 10, 36, "Output",
 CellID->211507156]
}, Open  ]],
Cell[7808, 272, 121, 3, 70, "ExampleDelimiter",
 CellID->31632],
Cell[7932, 277, 196, 7, 70, "ExampleText",
 CellID->15221],
Cell[CellGroupData[{
Cell[8153, 288, 152, 5, 70, "Input",
 CellID->13099],
Cell[8308, 295, 330, 10, 36, "Output",
 CellID->248494668]
}, Open  ]],
Cell[8653, 308, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[8783, 314, 214, 7, 28, "Input"],
Cell[9000, 323, 2062, 38, 116, "Output",
 Evaluatable->False,
 CellID->226311816]
}, Open  ]],
Cell[11077, 364, 121, 3, 70, "ExampleDelimiter",
 CellID->19703],
Cell[CellGroupData[{
Cell[11223, 371, 212, 7, 70, "Input",
 CellID->16598],
Cell[11438, 380, 1192, 41, 54, "Output",
 CellID->134906161]
}, Open  ]],
Cell[12645, 424, 105, 2, 70, "ExampleDelimiter"],
Cell[12753, 428, 337, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13115, 444, 87, 2, 70, "Input"],
Cell[13205, 448, 194, 6, 36, "Output",
 CellID->81970333]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13448, 460, 215, 7, 70, "ExampleSection",
 CellID->6794],
Cell[13666, 469, 71, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13762, 473, 103, 3, 70, "Input"],
Cell[13868, 478, 174, 6, 36, "Output",
 CellID->24643910]
}, Open  ]],
Cell[CellGroupData[{
Cell[14079, 489, 137, 4, 70, "Input"],
Cell[14219, 495, 170, 5, 36, "Output",
 CellID->220802815]
}, Open  ]],
Cell[14404, 503, 105, 2, 70, "ExampleDelimiter"],
Cell[14512, 507, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14587, 511, 159, 5, 70, "Input"],
Cell[14749, 518, 233, 7, 36, "Output",
 CellID->9796386]
}, Open  ]],
Cell[14997, 528, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15115, 534, 103, 2, 70, "Input"],
Cell[15221, 538, 217, 6, 36, "Output",
 CellID->197125206]
}, Open  ]],
Cell[15453, 547, 105, 2, 70, "ExampleDelimiter"],
Cell[15561, 551, 69, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15655, 555, 241, 8, 70, "Input"],
Cell[15899, 565, 224, 7, 36, "Output",
 CellID->379984617]
}, Open  ]],
Cell[16138, 575, 105, 2, 70, "ExampleDelimiter"],
Cell[16246, 579, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16325, 583, 168, 5, 70, "Input"],
Cell[16496, 590, 389, 12, 36, "Output",
 CellID->132707245]
}, Open  ]],
Cell[16900, 605, 105, 2, 70, "ExampleDelimiter"],
Cell[17008, 609, 59, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17092, 613, 186, 6, 70, "Input"],
Cell[17281, 621, 250, 8, 43, "Output",
 CellID->401511283]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17580, 635, 238, 7, 70, "ExampleSection",
 CellID->2730],
Cell[17821, 644, 192, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18038, 654, 184, 6, 70, "Input"],
Cell[18225, 662, 317, 10, 51, "Output",
 CellID->549740667]
}, Open  ]],
Cell[18557, 675, 105, 2, 70, "ExampleDelimiter"],
Cell[18665, 679, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18754, 683, 86, 2, 70, "Input"],
Cell[18843, 687, 168, 5, 36, "Output",
 CellID->493461737]
}, Open  ]],
Cell[CellGroupData[{
Cell[19048, 697, 104, 3, 70, "Input"],
Cell[19155, 702, 158, 5, 36, "Output",
 CellID->509657788]
}, Open  ]],
Cell[CellGroupData[{
Cell[19350, 712, 93, 2, 70, "Input"],
Cell[19446, 716, 414, 8, 70, "Message",
 CellID->449248763],
Cell[19863, 726, 170, 5, 36, "Output",
 CellID->257861765]
}, Open  ]],
Cell[20048, 734, 105, 2, 70, "ExampleDelimiter"],
Cell[20156, 738, 179, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20360, 748, 273, 9, 70, "Input"],
Cell[20636, 759, 539, 18, 54, "Output",
 CellID->80860543]
}, Open  ]],
Cell[21190, 780, 105, 2, 70, "ExampleDelimiter"],
Cell[21298, 784, 183, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21506, 794, 648, 20, 70, "Input"],
Cell[22157, 816, 419, 14, 36, "Output",
 CellID->335646624]
}, Open  ]],
Cell[22591, 833, 105, 2, 70, "ExampleDelimiter"],
Cell[22699, 837, 189, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[22913, 847, 530, 18, 70, "Input"],
Cell[23446, 867, 478, 17, 36, "Output",
 CellID->50341915]
}, Open  ]],
Cell[CellGroupData[{
Cell[23961, 889, 112, 3, 70, "Input"],
Cell[24076, 894, 580, 19, 39, "Output",
 CellID->761299942]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24705, 919, 223, 7, 70, "ExampleSection",
 CellID->12715],
Cell[24931, 928, 41, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24997, 932, 426, 14, 70, "Input"],
Cell[25426, 948, 391, 14, 39, "Output",
 CellID->83136346]
}, Open  ]],
Cell[25832, 965, 125, 3, 70, "ExampleDelimiter",
 CellID->215257255],
Cell[25960, 970, 70, 1, 70, "ExampleText",
 CellID->724227718],
Cell[CellGroupData[{
Cell[26055, 975, 712, 24, 70, "Input",
 CellID->48530058],
Cell[26770, 1001, 637, 23, 54, "Output",
 CellID->374117249]
}, Open  ]],
Cell[CellGroupData[{
Cell[27444, 1029, 276, 9, 70, "Input",
 CellID->264473815],
Cell[27723, 1040, 2535, 46, 70, "Output",
 Evaluatable->False,
 CellID->151996628]
}, Open  ]],
Cell[30273, 1089, 105, 2, 70, "ExampleDelimiter"],
Cell[30381, 1093, 43, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30449, 1097, 212, 7, 70, "Input",
 CellID->117584581],
Cell[30664, 1106, 477, 17, 73, "Output",
 CellID->686026979]
}, Open  ]],
Cell[CellGroupData[{
Cell[31178, 1128, 336, 11, 70, "Input"],
Cell[31517, 1141, 2795, 50, 70, "Output",
 Evaluatable->False,
 CellID->567827342]
}, Open  ]],
Cell[34327, 1194, 41, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[34393, 1198, 768, 23, 70, "Input"],
Cell[35164, 1223, 675, 21, 39, "Output",
 CellID->135624816]
}, Open  ]],
Cell[35854, 1247, 105, 2, 70, "ExampleDelimiter"],
Cell[35962, 1251, 112, 3, 70, "ExampleText"],
Cell[36077, 1256, 385, 14, 70, "Input"],
Cell[CellGroupData[{
Cell[36487, 1274, 322, 10, 70, "Input"],
Cell[36812, 1286, 2209, 40, 70, "Output",
 Evaluatable->False,
 CellID->274955535]
}, Open  ]],
Cell[39036, 1329, 36, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[39097, 1333, 431, 14, 70, "Input"],
Cell[39531, 1349, 2677, 48, 70, "Output",
 Evaluatable->False,
 CellID->199354362]
}, Open  ]],
Cell[42223, 1400, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[42311, 1404, 416, 14, 70, "Input"],
Cell[42730, 1420, 167, 5, 36, "Output",
 CellID->904963879]
}, Open  ]],
Cell[42912, 1428, 105, 2, 70, "ExampleDelimiter"],
Cell[43020, 1432, 204, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[43249, 1443, 718, 23, 70, "Input"],
Cell[43970, 1468, 788, 25, 75, "Output",
 CellID->18171085]
}, Open  ]],
Cell[44773, 1496, 46, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[44844, 1500, 546, 17, 70, "Input"],
Cell[45393, 1519, 13807, 230, 70, "Output",
 Evaluatable->False,
 CellID->195739959]
}, Open  ]],
Cell[59215, 1752, 105, 2, 70, "ExampleDelimiter"],
Cell[59323, 1756, 55, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[59403, 1760, 1414, 42, 70, "Input"],
Cell[60820, 1804, 285, 10, 55, "Output",
 CellID->70185268]
}, Open  ]],
Cell[CellGroupData[{
Cell[61142, 1819, 623, 19, 70, "Input"],
Cell[61768, 1840, 515, 9, 70, "Message",
 CellID->9554308],
Cell[62286, 1851, 711, 22, 51, "Output",
 CellID->534443607]
}, Open  ]],
Cell[63012, 1876, 105, 2, 70, "ExampleDelimiter"],
Cell[63120, 1880, 124, 3, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[63269, 1887, 960, 31, 70, "Input"],
Cell[64232, 1920, 935, 19, 70, "Output",
 Evaluatable->False,
 CellID->194609696]
}, Open  ]],
Cell[CellGroupData[{
Cell[65204, 1944, 111, 3, 70, "Input"],
Cell[65318, 1949, 1095, 35, 62, "Output",
 CellID->74669534]
}, Open  ]],
Cell[66428, 1987, 105, 2, 70, "ExampleDelimiter"],
Cell[66536, 1991, 136, 3, 70, "ExampleText"],
Cell[66675, 1996, 344, 11, 70, "Input",
 CellID->494728085],
Cell[67022, 2009, 449, 14, 70, "Input",
 CellID->228617299],
Cell[67474, 2025, 309, 9, 70, "Input",
 CellID->162929880],
Cell[67786, 2036, 46, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[67857, 2040, 582, 17, 70, "Input"],
Cell[68442, 2059, 2766, 49, 70, "Output",
 Evaluatable->False,
 CellID->109902042]
}, Open  ]],
Cell[71223, 2111, 105, 2, 70, "ExampleDelimiter"],
Cell[71331, 2115, 116, 3, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[71472, 2122, 448, 14, 70, "Input"],
Cell[71923, 2138, 1589, 49, 75, "Output",
 CellID->375626879]
}, Open  ]],
Cell[73527, 2190, 105, 2, 70, "ExampleDelimiter"],
Cell[73635, 2194, 135, 3, 70, "ExampleText"],
Cell[73773, 2199, 835, 26, 70, "Input"],
Cell[CellGroupData[{
Cell[74633, 2229, 925, 28, 70, "Input"],
Cell[75561, 2259, 989, 33, 61, "Output",
 CellID->342345334]
}, Open  ]],
Cell[76565, 2295, 105, 2, 70, "ExampleDelimiter"],
Cell[76673, 2299, 105, 2, 70, "ExampleText"],
Cell[76781, 2303, 423, 13, 70, "Input"],
Cell[77207, 2318, 69, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[77301, 2322, 751, 23, 70, "Input"],
Cell[78055, 2347, 743, 22, 61, "Output",
 CellID->32011187]
}, Open  ]],
Cell[78813, 2372, 47, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[78885, 2376, 683, 21, 70, "Input"],
Cell[79571, 2399, 95193, 1594, 70, "Output",
 CellID->21182081]
}, Open  ]],
Cell[174779, 3996, 105, 2, 70, "ExampleDelimiter"],
Cell[174887, 4000, 249, 6, 70, "ExampleText"],
Cell[175139, 4008, 345, 12, 70, "Input"],
Cell[CellGroupData[{
Cell[175509, 4024, 367, 12, 70, "Input"],
Cell[175879, 4038, 1525, 46, 58, "Output",
 CellID->2120156]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[177453, 4090, 233, 7, 70, "ExampleSection",
 CellID->13283],
Cell[177689, 4099, 304, 13, 70, "ExampleText",
 CellID->17106],
Cell[CellGroupData[{
Cell[178018, 4116, 180, 6, 70, "Input",
 CellID->22262],
Cell[178201, 4124, 246, 9, 36, "Output",
 CellID->531687224]
}, Open  ]],
Cell[178462, 4136, 120, 3, 70, "ExampleDelimiter",
 CellID->1661],
Cell[178585, 4141, 114, 3, 70, "ExampleText",
 CellID->18617],
Cell[CellGroupData[{
Cell[178724, 4148, 131, 4, 70, "Input",
 CellID->12631],
Cell[178858, 4154, 243, 8, 36, "Output",
 CellID->142146018]
}, Open  ]],
Cell[CellGroupData[{
Cell[179138, 4167, 155, 5, 70, "Input",
 CellID->31554],
Cell[179296, 4174, 277, 9, 36, "Output",
 CellID->444582935]
}, Open  ]],
Cell[CellGroupData[{
Cell[179610, 4188, 181, 6, 70, "Input",
 CellID->29594],
Cell[179794, 4196, 383, 15, 72, "Output",
 CellID->567651405]
}, Open  ]],
Cell[180192, 4214, 105, 2, 70, "ExampleDelimiter"],
Cell[180300, 4218, 96, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[180421, 4224, 202, 6, 70, "Input"],
Cell[180626, 4232, 727, 23, 52, "Output",
 CellID->430468283]
}, Open  ]],
Cell[181368, 4258, 105, 2, 70, "ExampleDelimiter"],
Cell[181476, 4262, 60, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[181561, 4266, 128, 4, 70, "Input"],
Cell[181692, 4272, 257, 8, 44, "Output",
 CellID->283052073]
}, Open  ]],
Cell[CellGroupData[{
Cell[181986, 4285, 126, 3, 70, "Input"],
Cell[182115, 4290, 583, 24, 72, "Output",
 CellID->568618298]
}, Open  ]],
Cell[182713, 4317, 105, 2, 70, "ExampleDelimiter"],
Cell[182821, 4321, 59, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[182905, 4325, 336, 10, 70, "Input"],
Cell[183244, 4337, 291, 9, 36, "Output",
 CellID->201254415]
}, Open  ]],
Cell[CellGroupData[{
Cell[183572, 4351, 338, 10, 70, "Input"],
Cell[183913, 4363, 314, 10, 50, "Output",
 CellID->450438695]
}, Open  ]],
Cell[184242, 4376, 124, 3, 70, "ExampleDelimiter",
 CellID->37865419],
Cell[184369, 4381, 105, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[184499, 4387, 102, 3, 70, "Input"],
Cell[184604, 4392, 209, 7, 36, "Output",
 CellID->30164]
}, Open  ]],
Cell[184828, 4402, 105, 2, 70, "ExampleDelimiter"],
Cell[184936, 4406, 190, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[185151, 4416, 242, 8, 70, "Input"],
Cell[185396, 4426, 194, 6, 36, "Output",
 CellID->54888053]
}, Open  ]],
Cell[185605, 4435, 105, 2, 70, "ExampleDelimiter"],
Cell[185713, 4439, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[185792, 4443, 221, 7, 70, "Input"],
Cell[186016, 4452, 271, 9, 36, "Output",
 CellID->614865]
}, Open  ]],
Cell[186302, 4464, 327, 12, 70, "ExampleText",
 CellID->2044861],
Cell[CellGroupData[{
Cell[186654, 4480, 87, 2, 70, "Input"],
Cell[186744, 4484, 202, 7, 36, "Output",
 CellID->40827606]
}, Open  ]],
Cell[186961, 4494, 161, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[187147, 4503, 171, 5, 70, "Input"],
Cell[187321, 4510, 471, 15, 52, "Output",
 CellID->161107376]
}, Open  ]],
Cell[187807, 4528, 105, 2, 70, "ExampleDelimiter"],
Cell[187915, 4532, 85, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[188025, 4537, 362, 12, 70, "Input"],
Cell[188390, 4551, 609, 22, 49, "Output",
 CellID->360178880]
}, Open  ]],
Cell[189014, 4576, 121, 3, 70, "ExampleDelimiter",
 CellID->32439],
Cell[189138, 4581, 210, 8, 70, "ExampleText",
 CellID->13082],
Cell[CellGroupData[{
Cell[189373, 4593, 207, 8, 70, "Input",
 CellID->28562],
Cell[189583, 4603, 395, 13, 36, "Output",
 CellID->34978936]
}, Open  ]],
Cell[CellGroupData[{
Cell[190015, 4621, 255, 9, 70, "Input",
 CellID->31592],
Cell[190273, 4632, 247, 8, 36, "Output",
 CellID->292745695]
}, Open  ]],
Cell[CellGroupData[{
Cell[190557, 4645, 276, 10, 70, "Input",
 CellID->16222],
Cell[190836, 4657, 330, 10, 36, "Output",
 CellID->17763615]
}, Open  ]],
Cell[191181, 4670, 105, 2, 70, "ExampleDelimiter"],
Cell[191289, 4674, 56, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[191370, 4678, 232, 8, 70, "Input"],
Cell[191605, 4688, 858, 26, 51, "Output",
 CellID->194924184]
}, Open  ]],
Cell[192478, 4717, 105, 2, 70, "ExampleDelimiter"],
Cell[192586, 4721, 33, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[192644, 4725, 229, 7, 70, "Input"],
Cell[192876, 4734, 675, 23, 69, "Output",
 CellID->199875941]
}, Open  ]],
Cell[CellGroupData[{
Cell[193588, 4762, 285, 9, 70, "Input"],
Cell[193876, 4773, 1009, 33, 76, "Output",
 CellID->76985525]
}, Open  ]],
Cell[CellGroupData[{
Cell[194922, 4811, 363, 12, 70, "Input"],
Cell[195288, 4825, 1307, 44, 98, "Output",
 CellID->119324505]
}, Open  ]],
Cell[CellGroupData[{
Cell[196632, 4874, 306, 9, 70, "Input"],
Cell[196941, 4885, 184, 6, 36, "Output",
 CellID->785908045]
}, Open  ]],
Cell[197140, 4894, 105, 2, 70, "ExampleDelimiter"],
Cell[197248, 4898, 43, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[197316, 4902, 202, 6, 70, "Input"],
Cell[197521, 4910, 297, 11, 68, "Output",
 CellID->466065679]
}, Open  ]],
Cell[CellGroupData[{
Cell[197855, 4926, 212, 7, 70, "Input"],
Cell[198070, 4935, 264, 10, 77, "Output",
 CellID->753204041]
}, Open  ]],
Cell[CellGroupData[{
Cell[198371, 4950, 371, 11, 70, "Input"],
Cell[198745, 4963, 3735, 117, 210, "Output",
 CellID->106440334]
}, Open  ]],
Cell[202495, 5083, 105, 2, 70, "ExampleDelimiter"],
Cell[202603, 5087, 28, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[202656, 5091, 224, 7, 70, "Input"],
Cell[202883, 5100, 268, 9, 36, "Output",
 CellID->11582592]
}, Open  ]],
Cell[CellGroupData[{
Cell[203188, 5114, 375, 13, 70, "Input"],
Cell[203566, 5129, 295, 10, 36, "Output",
 CellID->134466457]
}, Open  ]],
Cell[203876, 5142, 105, 2, 70, "ExampleDelimiter"],
Cell[203984, 5146, 128, 3, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[204137, 5153, 335, 11, 70, "Input"],
Cell[204475, 5166, 584, 17, 51, "Output",
 CellID->263143]
}, Open  ]],
Cell[CellGroupData[{
Cell[205096, 5188, 257, 8, 70, "Input"],
Cell[205356, 5198, 586, 17, 51, "Output",
 CellID->58925932]
}, Open  ]],
Cell[205957, 5218, 125, 3, 70, "ExampleDelimiter",
 CellID->263729340],
Cell[206085, 5223, 190, 7, 70, "ExampleText",
 CellID->501651567],
Cell[CellGroupData[{
Cell[206300, 5234, 108, 3, 70, "Input",
 CellID->601177333],
Cell[206411, 5239, 272, 9, 36, "Output",
 CellID->554906785]
}, Open  ]],
Cell[CellGroupData[{
Cell[206720, 5253, 167, 5, 70, "Input",
 CellID->10111011],
Cell[206890, 5260, 161, 5, 36, "Output",
 CellID->495652176]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[207100, 5271, 225, 7, 70, "ExampleSection",
 CellID->4226],
Cell[207328, 5280, 69, 1, 70, "ExampleText",
 CellID->7848],
Cell[CellGroupData[{
Cell[207422, 5285, 148, 5, 70, "Input",
 CellID->20634],
Cell[207573, 5292, 207, 5, 36, "Output",
 CellID->253459268]
}, Open  ]],
Cell[207795, 5300, 111, 3, 70, "ExampleText",
 CellID->5789],
Cell[CellGroupData[{
Cell[207931, 5307, 94, 3, 70, "Input",
 CellID->7978],
Cell[208028, 5312, 357, 7, 70, "Message",
 CellID->911593782],
Cell[208388, 5321, 187, 6, 36, "Output",
 CellID->242201728]
}, Open  ]],
Cell[208590, 5330, 105, 2, 70, "ExampleDelimiter"],
Cell[208698, 5334, 237, 8, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[208960, 5346, 258, 8, 70, "Input"],
Cell[209221, 5356, 162, 5, 36, "Output",
 CellID->145213622]
}, Open  ]],
Cell[CellGroupData[{
Cell[209420, 5366, 110, 3, 70, "Input"],
Cell[209533, 5371, 347, 13, 50, "Output",
 CellID->259861522]
}, Open  ]],
Cell[209895, 5387, 313, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[210233, 5403, 142, 4, 70, "Input"],
Cell[210378, 5409, 353, 13, 50, "Output",
 CellID->356861718]
}, Open  ]],
Cell[CellGroupData[{
Cell[210768, 5427, 299, 9, 70, "Input"],
Cell[211070, 5438, 161, 5, 36, "Output",
 CellID->153271421]
}, Open  ]],
Cell[211246, 5446, 105, 2, 70, "ExampleDelimiter"],
Cell[211354, 5450, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[211472, 5456, 323, 11, 70, "Input"],
Cell[211798, 5469, 380, 13, 39, "Output",
 CellID->43999422]
}, Open  ]],
Cell[212193, 5485, 201, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[212419, 5496, 84, 2, 70, "Input"],
Cell[212506, 5500, 341, 12, 39, "Output",
 CellID->658726643]
}, Open  ]],
Cell[212862, 5515, 105, 2, 70, "ExampleDelimiter"],
Cell[212970, 5519, 96, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[213091, 5525, 155, 5, 70, "Input"],
Cell[213249, 5532, 257, 7, 36, "Output",
 CellID->266717639]
}, Open  ]],
Cell[213521, 5542, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[213609, 5546, 216, 8, 70, "Input"],
Cell[213828, 5556, 366, 12, 36, "Output",
 CellID->136429588]
}, Open  ]],
Cell[214209, 5571, 105, 2, 70, "ExampleDelimiter"],
Cell[214317, 5575, 224, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[214566, 5586, 202, 6, 70, "Input"],
Cell[214771, 5594, 195, 6, 36, "Output",
 CellID->193699780]
}, Open  ]],
Cell[214981, 5603, 105, 2, 70, "ExampleDelimiter"],
Cell[215089, 5607, 391, 12, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[215505, 5623, 228, 8, 70, "Input"],
Cell[215736, 5633, 330, 11, 36, "Output",
 CellID->143361530]
}, Open  ]],
Cell[CellGroupData[{
Cell[216103, 5649, 234, 8, 70, "Input"],
Cell[216340, 5659, 888, 29, 55, "Output",
 CellID->222162311]
}, Open  ]],
Cell[217243, 5691, 105, 2, 70, "ExampleDelimiter"],
Cell[217351, 5695, 139, 3, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[217515, 5702, 103, 3, 70, "Input"],
Cell[217621, 5707, 182, 6, 36, "Output",
 CellID->543240912]
}, Open  ]],
Cell[CellGroupData[{
Cell[217840, 5718, 108, 3, 70, "Input"],
Cell[217951, 5723, 195, 6, 36, "Output",
 CellID->316625050]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[218195, 5735, 224, 7, 70, "ExampleSection",
 CellID->31987],
Cell[218422, 5744, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[218511, 5748, 275, 9, 70, "Input"],
Cell[218789, 5759, 1140, 36, 55, "Output",
 CellID->693799787]
}, Open  ]],
Cell[219944, 5798, 105, 2, 70, "ExampleDelimiter"],
Cell[220052, 5802, 221, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[220298, 5813, 230, 8, 70, "Input"],
Cell[220531, 5823, 440, 15, 54, "Output",
 CellID->695838866]
}, Open  ]],
Cell[220986, 5841, 326, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[221337, 5857, 312, 10, 70, "Input"],
Cell[221652, 5869, 463, 17, 69, "Output",
 CellID->102264530]
}, Open  ]],
Cell[222130, 5889, 105, 2, 70, "ExampleDelimiter"],
Cell[222238, 5893, 75, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[222338, 5897, 421, 13, 70, "Input"],
Cell[222762, 5912, 93103, 1530, 70, "Output",
 Evaluatable->False,
 CellID->843031481]
}, Open  ]],
Cell[315880, 7445, 105, 2, 70, "ExampleDelimiter"],
Cell[315988, 7449, 178, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[316191, 7460, 917, 27, 70, "Input"],
Cell[317111, 7489, 11749, 197, 70, "Output",
 Evaluatable->False,
 CellID->61688343]
}, Open  ]],
Cell[328875, 7689, 105, 2, 70, "ExampleDelimiter"],
Cell[328983, 7693, 102, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[329110, 7699, 646, 20, 70, "Input"],
Cell[329759, 7721, 15938, 265, 70, "Output",
 Evaluatable->False,
 CellID->280301123]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[345758, 7993, 310, 9, 70, "SeeAlsoSection",
 CellID->6616],
Cell[346071, 8004, 1404, 53, 70, "SeeAlso",
 CellID->3534]
}, Open  ]],
Cell[CellGroupData[{
Cell[347512, 8062, 314, 9, 70, "TutorialsSection",
 CellID->20483],
Cell[347829, 8073, 163, 3, 70, "Tutorials",
 CellID->24243],
Cell[347995, 8078, 181, 4, 70, "Tutorials",
 CellID->6286]
}, Open  ]],
Cell[CellGroupData[{
Cell[348213, 8087, 321, 9, 70, "RelatedLinksSection",
 CellID->23592],
Cell[348537, 8098, 346, 11, 70, "RelatedLinks"],
Cell[348886, 8111, 190, 4, 70, "RelatedLinks"],
Cell[349079, 8117, 195, 4, 70, "RelatedLinks"],
Cell[349277, 8123, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[349695, 8141, 319, 9, 70, "MoreAboutSection",
 CellID->547202679],
Cell[350017, 8152, 151, 3, 70, "MoreAbout",
 CellID->121304795],
Cell[350171, 8157, 194, 4, 70, "MoreAbout",
 CellID->25191509],
Cell[350368, 8163, 165, 3, 70, "MoreAbout",
 CellID->452345001],
Cell[350536, 8168, 155, 3, 70, "MoreAbout",
 CellID->374149471]
}, Open  ]],
Cell[350706, 8174, 27, 0, 70, "History"],
Cell[350736, 8176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

