(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28221,        987]
NotebookOptionsPosition[     21489,        749]
NotebookOutlinePosition[     23904,        825]
CellTagsIndexPosition[     23792,        819]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Trigonometric Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TrigonometricExpressions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Trigonometric Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TrigToExp" :> Documentation`HelpLookup["paclet:ref/TrigToExp"],
           "TrigReduce" :> Documentation`HelpLookup["paclet:ref/TrigReduce"], 
          "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TrigToExp\"\>", 
       2->"\<\"TrigReduce\"\>", 
       3->"\<\"ComplexExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"], 
          "Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 2->"\<\"Complex Numbers\"\>", 
       3->"\<\"Functions of Complex Variables\"\>", 
       4->"\<\"Hyperbolic Functions\"\>", 
       5->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ExpToTrig", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExpToTrig",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExpToTrig"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts exponentials in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to trigonometric functions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14720]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " generates both circular and hyperbolic functions. "
}], "Notes",
 CellID->9522],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " tries when possible to give results that do not involve explicit complex \
numbers. "
}], "Notes",
 CellID->27260],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363767848],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->376204432],

Cell["Convert from exponentials to trigonometric functions:", "ExampleText",
 CellID->2452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", "x"}], "]"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[1]:=",
 CellID->28321],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[1]=",
 CellID->364776581]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25140],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " works with hyperbolic functions:"
}], "ExampleText",
 CellID->3211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], "-", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", "x"}], "]"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[1]:=",
 CellID->9918],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Sinh", "[", "x", "]"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[1]=",
 CellID->219214037]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", "3"}], ")"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[1]:=",
 CellID->28539],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["3"]}], "2"]}]], "Output",
 ImageSize->{67, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[1]=",
 CellID->165219954]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{"Sqrt", "[", "I", "]"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->10297],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "\[ImaginaryI]"}], 
  SqrtBox["2"]]], "Output",
 ImageSize->{36, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->66663982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->529379085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], "-", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8603814],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"ArcTanh", "[", "x", "]"}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127021473]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3203],

Cell["\<\
Show that the unit circle maps to an interval in the Joukowski map:\
\>", "ExampleText",
 CellID->402214677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"z", "+", 
    RowBox[{"1", "/", "z"}]}], "/.", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", "\[Theta]"}], "]"}]}]}], "//", "ExpToTrig"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->688894187],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cos", "[", "\[Theta]", "]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->734627390]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", "16"}], ")"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[1]:=",
 CellID->1585],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   FractionBox["\[Pi]", "16"], "]"}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "16"], "]"}]}]}]], "Output",
 ImageSize->{134, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[1]=",
 CellID->906135875]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->229],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]]}]]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]]}]]}]}]], "Output",
 ImageSize->{260, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->127658486]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37244664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->234365058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Sin", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14396485],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "x"}]]}]}]], "Output",
 ImageSize->{111, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72802014]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106293428],

Cell[BoxData[
 RowBox[{"Sin", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->230973612]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->598237314],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists, equations, inequalities and logic \
functions:"
}], "ExampleText",
 CellID->639922602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"I", "*", "x"}], "]"}], "\[Equal]", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355278567],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}], "\[Equal]", 
  RowBox[{"-", "1"}]}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16304958]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20617],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17114]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11056],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->31305],

Cell[TextData[ButtonBox["Trigonometric Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TrigonometricExpressions"]], "Tutorials",
 CellID->20626]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->121047274],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->171023163],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->82467850],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->525953944],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->405584238],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->195395665]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpToTrig - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 3.9045072}", "context" -> "System`", 
    "keywords" -> {
     "complex exponentials", "complex powers", "expansion", "exponentials", 
      "polar angles", "powers", "reduction"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExpToTrig[expr] converts exponentials in expr to trigonometric \
functions. ", "synonyms" -> {"exp to trig"}, "title" -> "ExpToTrig", "type" -> 
    "Symbol", "uri" -> "ref/ExpToTrig"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9680, 252, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->363767848]},
 "CellTags"->{
  Cell[10332, 278, 178, 6, 28, "Input",
   CellTags->"CellTags",
   CellID->28321],
  Cell[10513, 286, 300, 10, 36, "Output",
   CellTags->"CellTags",
   CellID->364776581],
  Cell[11313, 322, 228, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->9918],
  Cell[11544, 332, 234, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->219214037],
  Cell[11938, 350, 240, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->28539],
  Cell[12181, 361, 295, 11, 56, "Output",
   CellTags->"CellTags",
   CellID->165219954],
  Cell[12513, 377, 155, 5, 70, "Input",
   CellTags->"CellTags",
   CellID->10297],
  Cell[12671, 384, 247, 9, 55, "Output",
   CellTags->"CellTags",
   CellID->66663982],
  Cell[14753, 478, 240, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->1585],
  Cell[14996, 489, 355, 12, 49, "Output",
   CellTags->"CellTags",
   CellID->906135875],
  Cell[15388, 506, 127, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->229],
  Cell[15518, 512, 510, 21, 63, "Output",
   CellTags->"CellTags",
   CellID->127658486]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22596, 775},
 {"CellTags", 22731, 779}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2858, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3481, 92, 4193, 83, 70, "ObjectNameGrid"],
Cell[7677, 177, 578, 18, 70, "Usage",
 CellID->14720]
}, Open  ]],
Cell[CellGroupData[{
Cell[8292, 200, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8770, 217, 219, 7, 70, "Notes",
 CellID->9522],
Cell[8992, 226, 254, 8, 70, "Notes",
 CellID->27260],
Cell[9249, 236, 394, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[9680, 252, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363767848],
Cell[CellGroupData[{
Cell[10065, 266, 148, 5, 70, "ExampleSection",
 CellID->376204432],
Cell[10216, 273, 91, 1, 70, "ExampleText",
 CellID->2452],
Cell[CellGroupData[{
Cell[10332, 278, 178, 6, 28, "Input",
 CellTags->"CellTags",
 CellID->28321],
Cell[10513, 286, 300, 10, 36, "Output",
 CellTags->"CellTags",
 CellID->364776581]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10862, 302, 216, 7, 70, "ExampleSection",
 CellID->25140],
Cell[11081, 311, 207, 7, 70, "ExampleText",
 CellID->3211],
Cell[CellGroupData[{
Cell[11313, 322, 228, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->9918],
Cell[11544, 332, 234, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->219214037]
}, Open  ]],
Cell[11793, 343, 120, 3, 70, "ExampleDelimiter",
 CellID->1707],
Cell[CellGroupData[{
Cell[11938, 350, 240, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->28539],
Cell[12181, 361, 295, 11, 56, "Output",
 CellTags->"CellTags",
 CellID->165219954]
}, Open  ]],
Cell[CellGroupData[{
Cell[12513, 377, 155, 5, 70, "Input",
 CellTags->"CellTags",
 CellID->10297],
Cell[12671, 384, 247, 9, 55, "Output",
 CellTags->"CellTags",
 CellID->66663982]
}, Open  ]],
Cell[12933, 396, 125, 3, 70, "ExampleDelimiter",
 CellID->529379085],
Cell[CellGroupData[{
Cell[13083, 403, 238, 8, 70, "Input",
 CellID->8603814],
Cell[13324, 413, 214, 7, 36, "Output",
 CellID->127021473]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13587, 426, 222, 7, 70, "ExampleSection",
 CellID->3203],
Cell[13812, 435, 118, 3, 70, "ExampleText",
 CellID->402214677],
Cell[CellGroupData[{
Cell[13955, 442, 271, 10, 70, "Input",
 CellID->688894187],
Cell[14229, 454, 217, 7, 36, "Output",
 CellID->734627390]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14495, 467, 233, 7, 70, "ExampleSection",
 CellID->17527],
Cell[CellGroupData[{
Cell[14753, 478, 240, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->1585],
Cell[14996, 489, 355, 12, 49, "Output",
 CellTags->"CellTags",
 CellID->906135875]
}, Open  ]],
Cell[CellGroupData[{
Cell[15388, 506, 127, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->229],
Cell[15518, 512, 510, 21, 63, "Output",
 CellTags->"CellTags",
 CellID->127658486]
}, Open  ]],
Cell[16043, 536, 124, 3, 70, "ExampleDelimiter",
 CellID->37244664],
Cell[16170, 541, 325, 12, 70, "ExampleText",
 CellID->234365058],
Cell[CellGroupData[{
Cell[16520, 557, 134, 4, 70, "Input",
 CellID->14396485],
Cell[16657, 563, 487, 15, 51, "Output",
 CellID->72802014]
}, Open  ]],
Cell[CellGroupData[{
Cell[17181, 583, 105, 3, 70, "Input",
 CellID->106293428],
Cell[17289, 588, 187, 6, 36, "Output",
 CellID->230973612]
}, Open  ]],
Cell[17491, 597, 125, 3, 70, "ExampleDelimiter",
 CellID->598237314],
Cell[17619, 602, 267, 8, 70, "ExampleText",
 CellID->639922602],
Cell[CellGroupData[{
Cell[17911, 614, 210, 7, 70, "Input",
 CellID->355278567],
Cell[18124, 623, 327, 11, 36, "Output",
 CellID->16304958]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18512, 641, 311, 9, 70, "SeeAlsoSection",
 CellID->20617],
Cell[18826, 652, 712, 26, 70, "SeeAlso",
 CellID->17114]
}, Open  ]],
Cell[CellGroupData[{
Cell[19575, 683, 314, 9, 70, "TutorialsSection",
 CellID->11056],
Cell[19892, 694, 190, 4, 70, "Tutorials",
 CellID->31305],
Cell[20085, 700, 160, 3, 70, "Tutorials",
 CellID->20626]
}, Open  ]],
Cell[CellGroupData[{
Cell[20282, 708, 319, 9, 70, "MoreAboutSection",
 CellID->121047274],
Cell[20604, 719, 161, 3, 70, "MoreAbout",
 CellID->171023163],
Cell[20768, 724, 140, 3, 70, "MoreAbout",
 CellID->82467850],
Cell[20911, 729, 169, 3, 70, "MoreAbout",
 CellID->525953944],
Cell[21083, 734, 151, 3, 70, "MoreAbout",
 CellID->405584238],
Cell[21237, 739, 157, 3, 70, "MoreAbout",
 CellID->195395665]
}, Open  ]],
Cell[21409, 745, 50, 0, 70, "History"],
Cell[21462, 747, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

