(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65952,       2191]
NotebookOptionsPosition[     56677,       1859]
NotebookOutlinePosition[     57972,       1896]
CellTagsIndexPosition[     57886,       1891]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transforming Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformingAlgebraicExpressions"], 
          "Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Structural Operations on Rational Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnRationalExpressions"], 
          "Structural Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnPolynomials"], 
          "Polynomials Modulo Primes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PolynomialsModuloPrimes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Transforming Algebraic Expressions\"\>", 
       2->"\<\"Putting Expressions into Different Forms\"\>", 
       3->"\<\"Structural Operations on Rational Expressions\"\>", 
       4->"\<\"Structural Operations on Polynomials\"\>", 
       5->"\<\"Polynomials Modulo Primes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distribute" :> 
          Documentation`HelpLookup["paclet:ref/Distribute"], "Apart" :> 
          Documentation`HelpLookup["paclet:ref/Apart"], "Series" :> 
          Documentation`HelpLookup["paclet:ref/Series"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"], "PowerExpand" :> 
          Documentation`HelpLookup["paclet:ref/PowerExpand"], "ExpandAll" :> 
          Documentation`HelpLookup["paclet:ref/ExpandAll"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], 
          "ExpandNumerator" :> 
          Documentation`HelpLookup["paclet:ref/ExpandNumerator"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Distribute\"\>", 2->"\<\"Apart\"\>",
        3->"\<\"Series\"\>", 4->"\<\"Factor\"\>", 5->"\<\"LogicalExpand\"\>", 
       6->"\<\"TrigExpand\"\>", 7->"\<\"PowerExpand\"\>", 
       8->"\<\"ExpandAll\"\>", 9->"\<\"ComplexExpand\"\>", 
       10->"\<\"ExpandNumerator\"\>", 11->"\<\"Simplify\"\>", 
       12->"\<\"FullSimplify\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60AlgebraicComputing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Formula Manipulation\"\>", 3->"\<\"Polynomial Algebra\"\>", 
       4->"\<\"Polynomial Factoring & Decomposition\"\>", 
       5->"\<\"Rational Functions\"\>", 
       6->"\<\"New in 6.0: Symbolic Computation\"\>", 
       7->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Expand", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Expand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Expand"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands out products and positive integer powers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Expand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Expand"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]leaves unexpanded any parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that are free of the pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". ",
     ButtonBox[" \[RightGuillemet]",
      BaseStyle->"ExampleLink",
      ButtonData->10496,
      ButtonNote->"10496"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " works only on positive integer powers. "
}], "Notes",
 CellID->17188],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " applies only to the top level in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25345],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
 " expands ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " reducing the result modulo ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19620,
  ButtonNote->"19620"]
}], "Notes",
 CellID->23666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " automatically threads over lists in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", as well as equations, inequalities and logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15633186],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->405634184],

Cell["Expand polynomial expressions:", "ExampleText",
 CellID->333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10371],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"10", " ", "x"}], "+", 
  RowBox[{"45", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"210", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"252", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"210", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"120", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"45", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38112066]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x", "+", "y"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "-", "x"}], ")"}], "^", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5670],

Cell[BoxData[
 RowBox[{"8", "-", 
  RowBox[{"4", " ", "x"}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  SuperscriptBox["x", "4"], "+", 
  RowBox[{"8", " ", "y"}], "-", 
  RowBox[{"12", " ", "x", " ", "y"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "-", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", "y"}]}]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->799683870]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25818],

Cell["Variables need not be symbols:", "ExampleText",
 CellID->7709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", "[", 
      SubscriptBox["x", "1"], "]"}], "+", 
     RowBox[{"f", "[", 
      SubscriptBox["x", "2"], "]"}]}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15009],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"f", "[", 
    SubscriptBox["x", "1"], "]"}], "3"], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"f", "[", 
     SubscriptBox["x", "1"], "]"}], "2"], " ", 
   RowBox[{"f", "[", 
    SubscriptBox["x", "2"], "]"}]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"f", "[", 
    SubscriptBox["x", "1"], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"f", "[", 
     SubscriptBox["x", "2"], "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"f", "[", 
    SubscriptBox["x", "2"], "]"}], "3"]}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->833361748]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "/", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89],

Cell[BoxData[
 RowBox[{
  FractionBox["x", "z"], "+", 
  FractionBox["y", "z"]}]], "Output",
 ImageSize->{39, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108389301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3090],

Cell["Some powers can be symbolic:", "ExampleText",
 CellID->25149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "s"}], "+", 
     RowBox[{"y", "^", "s"}]}], ")"}], "^", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24122],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   RowBox[{"4", " ", "s"}]], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", 
    RowBox[{"3", " ", "s"}]], " ", 
   SuperscriptBox["y", "s"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", 
    RowBox[{"2", " ", "s"}]], " ", 
   SuperscriptBox["y", 
    RowBox[{"2", " ", "s"}]]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "s"], " ", 
   SuperscriptBox["y", 
    RowBox[{"3", " ", "s"}]]}], "+", 
  SuperscriptBox["y", 
   RowBox[{"4", " ", "s"}]]}]], "Output",
 ImageSize->{236, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76159212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17951],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " does not go into subexpressions; ",
 Cell[BoxData[
  ButtonBox["ExpandAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandAll"]], "InlineFormula"],
 " does:"
}], "ExampleText",
 CellID->17470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8188],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"]]], "Output",
 ImageSize->{69, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->470606139]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandAll", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28805],

Cell[BoxData[
 SqrtBox[
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{85, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9884502]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32219],

Cell[TextData[{
 "Leave parts free of ",
 Cell[BoxData["x"], "InlineFormula"],
 " unexpanded:"
}], "ExampleText",
 CellID->32113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], "^", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "^", "2"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22794],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"], " ", "x"}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"], " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{204, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251230556]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9339],

Cell[TextData[{
 "Leave parts free of ",
 Cell[BoxData[
  RowBox[{"1", "+", "x"}]], "InlineFormula"],
 " unexpanded:"
}], "ExampleText",
 CellID->4492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", "x"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"1", "+", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1798],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}], "2"]}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124663732]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30856],

Cell[TextData[{
 "Leave anything not matching ",
 Cell[BoxData[
  RowBox[{"x", "[", "_", "]"}]], "InlineFormula"],
 " unexpanded:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->10496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "+", 
      RowBox[{"a", "[", "2", "]"}]}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "+", 
       RowBox[{"x", "[", "2", "]"}]}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"x", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15395],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "+", 
     RowBox[{"a", "[", "2", "]"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"x", "[", "1", "]"}], "2"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "+", 
     RowBox[{"a", "[", "2", "]"}]}], ")"}], " ", 
   RowBox[{"x", "[", "1", "]"}], " ", 
   RowBox[{"x", "[", "2", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "+", 
     RowBox[{"a", "[", "2", "]"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"x", "[", "2", "]"}], "2"]}]}]], "Output",
 ImageSize->{423, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56123495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->255106291],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10768],

Cell["Work in the field GF(2):", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->19620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "10"}], ",", 
   RowBox[{"Modulus", "->", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1003],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "8"], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23198799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9426],

Cell["The modulus does not have to be a prime:", "ExampleText",
 CellID->17027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "10"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15826],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  SuperscriptBox["x", "8"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264276067]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->104057225],

Cell["Expand a trigonometric expression:", "ExampleText",
 CellID->47505639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", "y"}], "]"}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51431388],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130915842]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12633],

Cell["Many functions give results in unexpanded form:", "ExampleText",
 CellID->13033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"x", "+", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23692],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"6", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->484382801]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"x", "+", "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "6"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24516],

Cell[BoxData[
 RowBox[{"720", "+", 
  RowBox[{"1764", " ", "x"}], "+", 
  RowBox[{"1624", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"735", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"175", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  SuperscriptBox["x", "6"]}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->678624683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5385],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " is essentially the inverse of ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x", "+", "y"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "-", "x"}], ")"}], "^", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10657],

Cell[BoxData[
 RowBox[{"8", "-", 
  RowBox[{"4", " ", "x"}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  SuperscriptBox["x", "4"], "+", 
  RowBox[{"8", " ", "y"}], "-", 
  RowBox[{"12", " ", "x", " ", "y"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "-", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", "y"}]}]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476672063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28726],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "x"}], ")"}], "3"]}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", "y"}], ")"}]}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218636074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1269],

Cell[TextData[{
 "When no powers are involved, ",
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 " gives the same results as ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23527],

Cell[BoxData[
 RowBox[{"6", "+", 
  RowBox[{"11", " ", "x"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->439238788]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21204],

Cell[BoxData[
 RowBox[{"6", "+", 
  RowBox[{"11", " ", "x"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49537266]
}, Open  ]],

Cell["\<\
Direct application of the distributive law often generates far more terms \
than are needed:\
\>", "ExampleText",
 CellID->27496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"x", "^", "6"}], "-", "1"}], "]"}], ",", "Plus", ",", "Times", 
   ",", "List", ",", "Times"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5872],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWVlvE0EMnmSzBUrvJNuQsxKUUHgBRAM/gOMB8SOiCql9QKDSHw480Mdh
j5lm+40dz+yuSqV019fYHs84tvNleXX+9dvy6uJsefTpcvnj/OLs59HH75cp
Kmop1fqrlDoeqPRdp2/5J/u7Tj/F66/0007R8Q3mT/YWWU6t2gJlAthdgPsA
9wBG+bEA43rS+hI/wpJ+tFfSl7C7lu37nnkm5tk3z6l5TuCZMPyITxj5KSN3
SFq5Y6ht89wErhjoHYEuyT8A+rYgj3RJHukbAr2u/U2vj/Sthvfnrv0rTlme
MTorrFIPDf89hxKzFF5m01B4PS6Fl7GU+yylim3NrGYpO4142rzVbuyzFeIU
Genb+QjzYs/wdfQqf5VhpEv5EfF9sMN3fVxvG7xs5V6iNwhjdsZs7+uFtA7K
bZExcU9Cz8G4J8zlGTmYsQePu07Xg6eaVFMW+minzz9+wx4AjBke6Y8AHgp0
lN8X6KH8de2R9NHfIFi9PE3/RaVzPjFw+X5EJm72Xlh+rO3KfIcGHhl4ZmCq
RqXW6xq5DdKLcqWY/ldz4EIvhwDPAJYqZ6xcu6BfqmSlyhkr5SGsj/6g/h7A
MblrAyL2dazMYtthYtdRytkF3EUK7hBnZGzwqJ/Tc+C1GzbDnwixGwE8DYwV
WmNvGvJRu1iWQ70joI/16oZS+uxTvlHZ65xYBbWV4QkBtwm5PoFH76kTbaOF
eqcE3kaR0oNnzlYx8c0uZMRnQmykmxHa+XaNXunGVDmbEZM/ylk//67Iidfw
Zqu4DPM7x0SwVhXKPsBoH+7vXuB+SvFBuqQ/NJ6h9jxhdynb+4G+XaNavG9N
i/LcZINb55i0LutgbZ2/rlOW6FKnLE1KQjvtup1+qHyo//970lDXvsfkacGa
3uYVt4OKWQrfS/OzDrn/rtLnh8jI/tzFPKGqBUVmakP0suhyd7/c++9qehbg
O7PwnTGgHpTnunpp3dfa5yzbVQd6vZfchJnL05zVKOdnZd+JceJgmppeVJsW
uPY0NVHw0f7Kaxdtf2uzH8J1pxKhUwHUX3dqIOl76bVLC13Ul3NNTxdsrzIz
8CngE5BLgG6nEs9Ja2xWewf40CkBVtNYtb0R+Lt6vb7Q3/dOSG8/CF6G/mpn
u+2FwCfVvLY756YGdOwkb6QOiNJW7hffCvxSx4Xd/AzoOA14kT/t98l7oIZ2
2Vz3uxD4qC6c6sq5Lr7w4rMQm9CThvflVOCv+/s0xrq4T6r1Dwh6bL4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{502, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22657674]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13190],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "6"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->101611677]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[HappySmiley]", "+", "\[SadSmiley]"}], ")"}], "^", "5"}], 
    "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31301],

Cell[BoxData[
 StyleBox[
  RowBox[{
   SuperscriptBox["\[HappySmiley]", "5"], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["\[HappySmiley]", "4"], " ", "\[SadSmiley]"}], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox["\[HappySmiley]", "3"], " ", 
    SuperscriptBox["\[SadSmiley]", "2"]}], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox["\[HappySmiley]", "2"], " ", 
    SuperscriptBox["\[SadSmiley]", "3"]}], "+", 
   RowBox[{"5", " ", "\[HappySmiley]", " ", 
    SuperscriptBox["\[SadSmiley]", "4"]}], "+", 
   SuperscriptBox["\[SadSmiley]", "5"]}],
  StripOnInput->False,
  FontSize->20]], "Output",
 ImageSize->{413, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->447467960]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16137],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"100", " ", "x"}], "+", 
  RowBox[{"4950", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"161700", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"3921225", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"75287520", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"1192052400", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"16007560800", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"186087894300", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"1902231808400", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"17310309456440", " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"141629804643600", " ", 
   SuperscriptBox["x", "11"]}], "+", 
  RowBox[{"1050421051106700", " ", 
   SuperscriptBox["x", "12"]}], "+", 
  RowBox[{"7110542499799200", " ", 
   SuperscriptBox["x", "13"]}], "+", 
  RowBox[{"44186942677323600", " ", 
   SuperscriptBox["x", "14"]}], "+", 
  RowBox[{"253338471349988640", " ", 
   SuperscriptBox["x", "15"]}], "+", 
  RowBox[{"1345860629046814650", " ", 
   SuperscriptBox["x", "16"]}], "+", 
  RowBox[{"6650134872937201800", " ", 
   SuperscriptBox["x", "17"]}], "+", 
  RowBox[{"30664510802988208300", " ", 
   SuperscriptBox["x", "18"]}], "+", 
  RowBox[{"132341572939212267400", " ", 
   SuperscriptBox["x", "19"]}], "+", 
  RowBox[{"535983370403809682970", " ", 
   SuperscriptBox["x", "20"]}], "+", 
  RowBox[{"2041841411062132125600", " ", 
   SuperscriptBox["x", "21"]}], "+", 
  RowBox[{"7332066885177656269200", " ", 
   SuperscriptBox["x", "22"]}], "+", 
  RowBox[{"24865270306254660391200", " ", 
   SuperscriptBox["x", "23"]}], "+", 
  RowBox[{"79776075565900368755100", " ", 
   SuperscriptBox["x", "24"]}], "+", 
  RowBox[{"242519269720337121015504", " ", 
   SuperscriptBox["x", "25"]}], "+", 
  RowBox[{"699574816500972464467800", " ", 
   SuperscriptBox["x", "26"]}], "+", 
  RowBox[{"1917353200780443050763600", " ", 
   SuperscriptBox["x", "27"]}], "+", 
  RowBox[{"4998813702034726525205100", " ", 
   SuperscriptBox["x", "28"]}], "+", 
  RowBox[{"12410847811948286545336800", " ", 
   SuperscriptBox["x", "29"]}], "+", 
  RowBox[{"29372339821610944823963760", " ", 
   SuperscriptBox["x", "30"]}], "+", 
  RowBox[{"66324638306863423796047200", " ", 
   SuperscriptBox["x", "31"]}], "+", 
  RowBox[{"143012501349174257560226775", " ", 
   SuperscriptBox["x", "32"]}], "+", 
  RowBox[{"294692427022540894366527900", " ", 
   SuperscriptBox["x", "33"]}], "+", 
  RowBox[{"580717429720889409486981450", " ", 
   SuperscriptBox["x", "34"]}], "+", 
  RowBox[{"1095067153187962886461165020", " ", 
   SuperscriptBox["x", "35"]}], "+", 
  RowBox[{"1977204582144932989443770175", " ", 
   SuperscriptBox["x", "36"]}], "+", 
  RowBox[{"3420029547493938143902737600", " ", 
   SuperscriptBox["x", "37"]}], "+", 
  RowBox[{"5670048986634686922786117600", " ", 
   SuperscriptBox["x", "38"]}], "+", 
  RowBox[{"9013924030034630492634340800", " ", 
   SuperscriptBox["x", "39"]}], "+", 
  RowBox[{"13746234145802811501267369720", " ", 
   SuperscriptBox["x", "40"]}], "+", 
  RowBox[{"20116440213369968050635175200", " ", 
   SuperscriptBox["x", "41"]}], "+", 
  RowBox[{"28258808871162574166368460400", " ", 
   SuperscriptBox["x", "42"]}], "+", 
  RowBox[{"38116532895986727945334202400", " ", 
   SuperscriptBox["x", "43"]}], "+", 
  RowBox[{"49378235797073715747364762200", " ", 
   SuperscriptBox["x", "44"]}], "+", 
  RowBox[{"61448471214136179596720592960", " ", 
   SuperscriptBox["x", "45"]}], "+", 
  RowBox[{"73470998190814997343905056800", " ", 
   SuperscriptBox["x", "46"]}], "+", 
  RowBox[{"84413487283064039501507937600", " ", 
   SuperscriptBox["x", "47"]}], "+", 
  RowBox[{"93206558875049876949581681100", " ", 
   SuperscriptBox["x", "48"]}], "+", 
  RowBox[{"98913082887808032681188722800", " ", 
   SuperscriptBox["x", "49"]}], "+", 
  RowBox[{"100891344545564193334812497256", " ", 
   SuperscriptBox["x", "50"]}], "+", 
  RowBox[{"98913082887808032681188722800", " ", 
   SuperscriptBox["x", "51"]}], "+", 
  RowBox[{"93206558875049876949581681100", " ", 
   SuperscriptBox["x", "52"]}], "+", 
  RowBox[{"84413487283064039501507937600", " ", 
   SuperscriptBox["x", "53"]}], "+", 
  RowBox[{"73470998190814997343905056800", " ", 
   SuperscriptBox["x", "54"]}], "+", 
  RowBox[{"61448471214136179596720592960", " ", 
   SuperscriptBox["x", "55"]}], "+", 
  RowBox[{"49378235797073715747364762200", " ", 
   SuperscriptBox["x", "56"]}], "+", 
  RowBox[{"38116532895986727945334202400", " ", 
   SuperscriptBox["x", "57"]}], "+", 
  RowBox[{"28258808871162574166368460400", " ", 
   SuperscriptBox["x", "58"]}], "+", 
  RowBox[{"20116440213369968050635175200", " ", 
   SuperscriptBox["x", "59"]}], "+", 
  RowBox[{"13746234145802811501267369720", " ", 
   SuperscriptBox["x", "60"]}], "+", 
  RowBox[{"9013924030034630492634340800", " ", 
   SuperscriptBox["x", "61"]}], "+", 
  RowBox[{"5670048986634686922786117600", " ", 
   SuperscriptBox["x", "62"]}], "+", 
  RowBox[{"3420029547493938143902737600", " ", 
   SuperscriptBox["x", "63"]}], "+", 
  RowBox[{"1977204582144932989443770175", " ", 
   SuperscriptBox["x", "64"]}], "+", 
  RowBox[{"1095067153187962886461165020", " ", 
   SuperscriptBox["x", "65"]}], "+", 
  RowBox[{"580717429720889409486981450", " ", 
   SuperscriptBox["x", "66"]}], "+", 
  RowBox[{"294692427022540894366527900", " ", 
   SuperscriptBox["x", "67"]}], "+", 
  RowBox[{"143012501349174257560226775", " ", 
   SuperscriptBox["x", "68"]}], "+", 
  RowBox[{"66324638306863423796047200", " ", 
   SuperscriptBox["x", "69"]}], "+", 
  RowBox[{"29372339821610944823963760", " ", 
   SuperscriptBox["x", "70"]}], "+", 
  RowBox[{"12410847811948286545336800", " ", 
   SuperscriptBox["x", "71"]}], "+", 
  RowBox[{"4998813702034726525205100", " ", 
   SuperscriptBox["x", "72"]}], "+", 
  RowBox[{"1917353200780443050763600", " ", 
   SuperscriptBox["x", "73"]}], "+", 
  RowBox[{"699574816500972464467800", " ", 
   SuperscriptBox["x", "74"]}], "+", 
  RowBox[{"242519269720337121015504", " ", 
   SuperscriptBox["x", "75"]}], "+", 
  RowBox[{"79776075565900368755100", " ", 
   SuperscriptBox["x", "76"]}], "+", 
  RowBox[{"24865270306254660391200", " ", 
   SuperscriptBox["x", "77"]}], "+", 
  RowBox[{"7332066885177656269200", " ", 
   SuperscriptBox["x", "78"]}], "+", 
  RowBox[{"2041841411062132125600", " ", 
   SuperscriptBox["x", "79"]}], "+", 
  RowBox[{"535983370403809682970", " ", 
   SuperscriptBox["x", "80"]}], "+", 
  RowBox[{"132341572939212267400", " ", 
   SuperscriptBox["x", "81"]}], "+", 
  RowBox[{"30664510802988208300", " ", 
   SuperscriptBox["x", "82"]}], "+", 
  RowBox[{"6650134872937201800", " ", 
   SuperscriptBox["x", "83"]}], "+", 
  RowBox[{"1345860629046814650", " ", 
   SuperscriptBox["x", "84"]}], "+", 
  RowBox[{"253338471349988640", " ", 
   SuperscriptBox["x", "85"]}], "+", 
  RowBox[{"44186942677323600", " ", 
   SuperscriptBox["x", "86"]}], "+", 
  RowBox[{"7110542499799200", " ", 
   SuperscriptBox["x", "87"]}], "+", 
  RowBox[{"1050421051106700", " ", 
   SuperscriptBox["x", "88"]}], "+", 
  RowBox[{"141629804643600", " ", 
   SuperscriptBox["x", "89"]}], "+", 
  RowBox[{"17310309456440", " ", 
   SuperscriptBox["x", "90"]}], "+", 
  RowBox[{"1902231808400", " ", 
   SuperscriptBox["x", "91"]}], "+", 
  RowBox[{"186087894300", " ", 
   SuperscriptBox["x", "92"]}], "+", 
  RowBox[{"16007560800", " ", 
   SuperscriptBox["x", "93"]}], "+", 
  RowBox[{"1192052400", " ", 
   SuperscriptBox["x", "94"]}], "+", 
  RowBox[{"75287520", " ", 
   SuperscriptBox["x", "95"]}], "+", 
  RowBox[{"3921225", " ", 
   SuperscriptBox["x", "96"]}], "+", 
  RowBox[{"161700", " ", 
   SuperscriptBox["x", "97"]}], "+", 
  RowBox[{"4950", " ", 
   SuperscriptBox["x", "98"]}], "+", 
  RowBox[{"100", " ", 
   SuperscriptBox["x", "99"]}], "+", 
  SuperscriptBox["x", "100"]}]], "Output",
 ImageSize->{580, 679},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236100095]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7906],

Cell["\<\
Create a nested pattern corresponding to an additive cellular automaton (rule \
60):\
\>", "ExampleText",
 CellID->29169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"CoefficientList", "[", 
     RowBox[{
      RowBox[{"Expand", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "x"}], ")"}], "^", "t"}], ",", 
        RowBox[{"Modulus", "->", "2"}]}], "]"}], ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "31"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10901],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{585, 477},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433275198]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6603],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Distribute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Distribute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpandAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandNumerator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpandNumerator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30638]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24694],

Cell[TextData[ButtonBox["Transforming Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TransformingAlgebraicExpressions"]], "Tutorials",\

 CellID->20753],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->24630],

Cell[TextData[ButtonBox["Structural Operations on Rational Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnRationalExpressions"]], "Tutorials",
 CellID->77317866],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "Tutorials",
 CellID->19225],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "Tutorials",
 CellID->180770870]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->171666692],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->901053914],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->243952800],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->66091],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->622077602],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->284205624],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->133495030],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->9664701]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Expand",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Expand"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Expand"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Expand - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 45.0133986}", "context" -> "System`", 
    "keywords" -> {"expansion"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Expand[expr] expands out products and positive integer powers in expr. \
Expand[expr, patt] leaves unexpanded any parts of expr that are free of the \
pattern patt. >", "synonyms" -> {}, "title" -> "Expand", "type" -> "Symbol", 
    "uri" -> "ref/Expand"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13017, 335, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15633186]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 57743, 1884}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4844, 96, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5467, 123, 4190, 83, 70, "ObjectNameGrid"],
Cell[9660, 208, 1224, 39, 70, "Usage",
 CellID->4798]
}, Open  ]],
Cell[CellGroupData[{
Cell[10921, 252, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11399, 269, 203, 7, 70, "Notes",
 CellID->17188],
Cell[11605, 278, 264, 10, 70, "Notes",
 CellID->25345],
Cell[11872, 290, 650, 25, 70, "Notes",
 CellID->23666],
Cell[12525, 317, 455, 13, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[13017, 335, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15633186],
Cell[CellGroupData[{
Cell[13401, 349, 148, 5, 70, "ExampleSection",
 CellID->405634184],
Cell[13552, 356, 67, 1, 70, "ExampleText",
 CellID->333],
Cell[CellGroupData[{
Cell[13644, 361, 171, 6, 28, "Input",
 CellID->10371],
Cell[13818, 369, 716, 24, 36, "Output",
 CellID->38112066]
}, Open  ]],
Cell[CellGroupData[{
Cell[14571, 398, 249, 9, 28, "Input",
 CellID->5670],
Cell[14823, 409, 557, 18, 36, "Output",
 CellID->799683870]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15429, 433, 216, 7, 70, "ExampleSection",
 CellID->25818],
Cell[15648, 442, 68, 1, 70, "ExampleText",
 CellID->7709],
Cell[CellGroupData[{
Cell[15741, 447, 284, 10, 70, "Input",
 CellID->15009],
Cell[16028, 459, 687, 24, 36, "Output",
 CellID->833361748]
}, Open  ]],
Cell[16730, 486, 120, 3, 70, "ExampleDelimiter",
 CellID->3756],
Cell[CellGroupData[{
Cell[16875, 493, 167, 6, 70, "Input",
 CellID->89],
Cell[17045, 501, 222, 8, 49, "Output",
 CellID->108389301]
}, Open  ]],
Cell[17282, 512, 120, 3, 70, "ExampleDelimiter",
 CellID->3090],
Cell[17405, 517, 67, 1, 70, "ExampleText",
 CellID->25149],
Cell[CellGroupData[{
Cell[17497, 522, 222, 8, 70, "Input",
 CellID->24122],
Cell[17722, 532, 655, 23, 36, "Output",
 CellID->76159212]
}, Open  ]],
Cell[18392, 558, 121, 3, 70, "ExampleDelimiter",
 CellID->17951],
Cell[18516, 563, 335, 12, 70, "ExampleText",
 CellID->17470],
Cell[CellGroupData[{
Cell[18876, 579, 203, 7, 70, "Input",
 CellID->8188],
Cell[19082, 588, 242, 9, 45, "Output",
 CellID->470606139]
}, Open  ]],
Cell[CellGroupData[{
Cell[19361, 602, 207, 7, 70, "Input",
 CellID->28805],
Cell[19571, 611, 249, 9, 45, "Output",
 CellID->9884502]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19869, 626, 239, 7, 70, "ExampleSection",
 CellID->32219],
Cell[20111, 635, 129, 5, 70, "ExampleText",
 CellID->32113],
Cell[CellGroupData[{
Cell[20265, 644, 299, 12, 70, "Input",
 CellID->22794],
Cell[20567, 658, 497, 18, 36, "Output",
 CellID->251230556]
}, Open  ]],
Cell[21079, 679, 120, 3, 70, "ExampleDelimiter",
 CellID->9339],
Cell[21202, 684, 151, 6, 70, "ExampleText",
 CellID->4492],
Cell[CellGroupData[{
Cell[21378, 694, 324, 12, 70, "Input",
 CellID->1798],
Cell[21705, 708, 321, 11, 36, "Output",
 CellID->124663732]
}, Open  ]],
Cell[22041, 722, 121, 3, 70, "ExampleDelimiter",
 CellID->30856],
Cell[22165, 727, 213, 7, 70, "ExampleText",
 CellID->10496],
Cell[CellGroupData[{
Cell[22403, 738, 428, 15, 70, "Input",
 CellID->15395],
Cell[22834, 755, 780, 27, 36, "Output",
 CellID->56123495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23663, 788, 222, 7, 70, "ExampleSection",
 CellID->255106291],
Cell[CellGroupData[{
Cell[23910, 799, 224, 7, 70, "ExampleSubsection",
 CellID->10768],
Cell[24137, 808, 111, 2, 70, "ExampleText",
 CellID->19620],
Cell[CellGroupData[{
Cell[24273, 814, 227, 8, 70, "Input",
 CellID->1003],
Cell[24503, 824, 272, 9, 36, "Output",
 CellID->23198799]
}, Open  ]],
Cell[24790, 836, 120, 3, 70, "ExampleDelimiter",
 CellID->9426],
Cell[24913, 841, 79, 1, 70, "ExampleText",
 CellID->17027],
Cell[CellGroupData[{
Cell[25017, 846, 233, 8, 70, "Input",
 CellID->15826],
Cell[25253, 856, 481, 16, 36, "Output",
 CellID->264276067]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25783, 878, 225, 7, 70, "ExampleSubsection",
 CellID->104057225],
Cell[26011, 887, 76, 1, 70, "ExampleText",
 CellID->47505639],
Cell[CellGroupData[{
Cell[26112, 892, 216, 7, 70, "Input",
 CellID->51431388],
Cell[26331, 901, 351, 12, 36, "Output",
 CellID->130915842]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26743, 920, 233, 7, 70, "ExampleSection",
 CellID->12633],
Cell[26979, 929, 86, 1, 70, "ExampleText",
 CellID->13033],
Cell[CellGroupData[{
Cell[27090, 934, 195, 7, 70, "Input",
 CellID->23692],
Cell[27288, 943, 503, 18, 36, "Output",
 CellID->484382801]
}, Open  ]],
Cell[CellGroupData[{
Cell[27828, 966, 232, 8, 70, "Input",
 CellID->24516],
Cell[28063, 976, 483, 16, 36, "Output",
 CellID->678624683]
}, Open  ]],
Cell[28561, 995, 120, 3, 70, "ExampleDelimiter",
 CellID->5385],
Cell[28684, 1000, 321, 12, 70, "ExampleText",
 CellID->30383],
Cell[CellGroupData[{
Cell[29030, 1016, 250, 9, 70, "Input",
 CellID->10657],
Cell[29283, 1027, 557, 18, 36, "Output",
 CellID->476672063]
}, Open  ]],
Cell[CellGroupData[{
Cell[29877, 1050, 98, 3, 70, "Input",
 CellID->28726],
Cell[29978, 1055, 354, 13, 36, "Output",
 CellID->218636074]
}, Open  ]],
Cell[30347, 1071, 120, 3, 70, "ExampleDelimiter",
 CellID->1269],
Cell[30470, 1076, 359, 13, 70, "ExampleText",
 CellID->15377],
Cell[CellGroupData[{
Cell[30854, 1093, 272, 10, 70, "Input",
 CellID->23527],
Cell[31129, 1105, 297, 10, 36, "Output",
 CellID->439238788]
}, Open  ]],
Cell[CellGroupData[{
Cell[31463, 1120, 268, 10, 70, "Input",
 CellID->21204],
Cell[31734, 1132, 296, 10, 36, "Output",
 CellID->49537266]
}, Open  ]],
Cell[32045, 1145, 139, 4, 70, "ExampleText",
 CellID->27496],
Cell[CellGroupData[{
Cell[32209, 1153, 257, 8, 70, "Input",
 CellID->5872],
Cell[32469, 1163, 1487, 28, 70, "Output",
 Evaluatable->False,
 CellID->22657674]
}, Open  ]],
Cell[CellGroupData[{
Cell[33993, 1196, 97, 3, 70, "Input",
 CellID->13190],
Cell[34093, 1201, 222, 8, 36, "Output",
 CellID->101611677]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34364, 1215, 224, 7, 70, "ExampleSection",
 CellID->31538],
Cell[CellGroupData[{
Cell[34613, 1226, 262, 9, 70, "Input",
 CellID->31301],
Cell[34878, 1237, 737, 21, 45, "Output",
 CellID->447467960]
}, Open  ]],
Cell[35630, 1261, 121, 3, 70, "ExampleDelimiter",
 CellID->27041],
Cell[CellGroupData[{
Cell[35776, 1268, 172, 6, 70, "Input",
 CellID->16137],
Cell[35951, 1276, 8040, 204, 700, "Output",
 CellID->236100095]
}, Open  ]],
Cell[44006, 1483, 120, 3, 70, "ExampleDelimiter",
 CellID->7906],
Cell[44129, 1488, 131, 4, 70, "ExampleText",
 CellID->29169],
Cell[CellGroupData[{
Cell[44285, 1496, 477, 15, 70, "Input",
 CellID->10901],
Cell[44765, 1513, 4633, 80, 70, "Output",
 Evaluatable->False,
 CellID->433275198]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49459, 1600, 310, 9, 70, "SeeAlsoSection",
 CellID->6603],
Cell[49772, 1611, 2945, 107, 70, "SeeAlso",
 CellID->30638]
}, Open  ]],
Cell[CellGroupData[{
Cell[52754, 1723, 314, 9, 70, "TutorialsSection",
 CellID->24694],
Cell[53071, 1734, 179, 4, 70, "Tutorials",
 CellID->20753],
Cell[53253, 1740, 190, 4, 70, "Tutorials",
 CellID->24630],
Cell[53446, 1746, 203, 4, 70, "Tutorials",
 CellID->77317866],
Cell[53652, 1752, 183, 4, 70, "Tutorials",
 CellID->19225],
Cell[53838, 1758, 163, 3, 70, "Tutorials",
 CellID->180770870]
}, Open  ]],
Cell[CellGroupData[{
Cell[54038, 1766, 319, 9, 70, "MoreAboutSection",
 CellID->171666692],
Cell[54360, 1777, 161, 3, 70, "MoreAbout",
 CellID->901053914],
Cell[54524, 1782, 151, 3, 70, "MoreAbout",
 CellID->243952800],
Cell[54678, 1787, 143, 3, 70, "MoreAbout",
 CellID->66091],
Cell[54824, 1792, 167, 3, 70, "MoreAbout",
 CellID->622077602],
Cell[54994, 1797, 147, 3, 70, "MoreAbout",
 CellID->284205624],
Cell[55144, 1802, 169, 3, 70, "MoreAbout",
 CellID->133495030],
Cell[55316, 1807, 177, 3, 70, "MoreAbout",
 CellID->9664701]
}, Open  ]],
Cell[CellGroupData[{
Cell[55530, 1815, 305, 8, 70, "RelatedLinksSection"],
Cell[55838, 1825, 357, 12, 70, "RelatedLinks"],
Cell[56198, 1839, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[56597, 1855, 50, 0, 70, "History"],
Cell[56650, 1857, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

