(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31693,       1137]
NotebookOptionsPosition[     25841,        935]
NotebookOutlinePosition[     27129,        971]
CellTagsIndexPosition[     27044,        966]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations on Rational Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnRationalExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Operations on Rational Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerator" :> Documentation`HelpLookup["paclet:ref/Numerator"],
           "Expand" :> Documentation`HelpLookup["paclet:ref/Expand"], 
          "ExpandDenominator" :> 
          Documentation`HelpLookup["paclet:ref/ExpandDenominator"], 
          "ExpandAll" :> Documentation`HelpLookup["paclet:ref/ExpandAll"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Numerator\"\>", 
       2->"\<\"Expand\"\>", 3->"\<\"ExpandDenominator\"\>", 
       4->"\<\"ExpandAll\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Rational Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ExpandNumerator", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExpandNumerator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExpandNumerator"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands out products and powers that appear in the \
numerator of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21671]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandNumerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandNumerator"]], "InlineFormula"],
 " works on terms that have positive integer exponents. "
}], "Notes",
 CellID->1169],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandNumerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandNumerator"]], "InlineFormula"],
 " applies only to the top level in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23938],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandNumerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandNumerator"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->147882192],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->859621281],

Cell["Expand the numerator of a fraction:", "ExampleText",
 CellID->663264673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "3"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", "4"}], ")"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1169725],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "-", 
   RowBox[{"3", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "4"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{108, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239201381]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25426],

Cell["Expand the numerator of a rational function:", "ExampleText",
 CellID->130616091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "y"}], ")"}], "^", "2"}], "/", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"u", "-", "v"}], ")"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18739944],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", "2"], "-", 
   RowBox[{"2", " ", "x", " ", "y"}], "+", 
   SuperscriptBox["y", "2"]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"u", "-", "v"}], ")"}], "2"]]], "Output",
 ImageSize->{86, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138612971]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->597265136],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandNumerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandNumerator"]], "InlineFormula"],
 " threads over sums:"
}], "ExampleText",
 CellID->404569172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], "^", "2"}], "/", "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c", "+", "d"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "-", "d"}], ")"}], "/", "y"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4305372],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    RowBox[{"2", " ", "a", " ", "b"}], "+", 
    SuperscriptBox["b", "2"]}], "x"], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["c", "2"], "-", 
    SuperscriptBox["d", "2"]}], "y"]}]], "Output",
 ImageSize->{140, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260387549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143266365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandNumerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandNumerator"]], "InlineFormula"],
 " threads over Boolean combinations of equations and inequalities:"
}], "ExampleText",
 CellID->203258716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", 
  RowBox[{
   RowBox[{"x", "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], "^", "2"}], "/", "c"}]}], "&&", 
   RowBox[{"y", "\[GreaterEqual]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "/", "c"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417822826],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     RowBox[{"2", " ", "a", " ", "b"}], "+", 
     SuperscriptBox["b", "2"]}], "c"]}], "&&", 
  RowBox[{"y", "\[GreaterEqual]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     RowBox[{"2", " ", "a", " ", "b"}], "+", 
     SuperscriptBox["b", "2"]}], "c"]}]}]], "Output",
 ImageSize->{232, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116180510]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28522],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29454],

Cell["Expand the numerator over the integers modulo 3:", "ExampleText",
 CellID->237596275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "^", "3"}], "/", "z"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175648844],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", "3"], "+", 
   SuperscriptBox["y", "3"]}], "z"]], "Output",
 ImageSize->{46, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3333602]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19398],

Cell["\<\
Expand the numerator using expansion formulas for trigonometric functions:\
\>", "ExampleText",
 CellID->533987315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", "y"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31257848],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "y", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}]}], 
  RowBox[{"a", "-", "b"}]]], "Output",
 ImageSize->{195, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->412611278]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->982],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandNumerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandNumerator"]], "InlineFormula"],
 " leaves the denominator unexpanded:"
}], "ExampleText",
 CellID->297563176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", "d"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"c", "-", "d"}], ")"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333947376],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["a", "2"], "-", 
   SuperscriptBox["b", "2"]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"c", "-", "d"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"c", "+", "d"}], ")"}]}]]], "Output",
 ImageSize->{93, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24518535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->433206182],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandDenominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandDenominator"]], "InlineFormula"],
 " expands the denominator, leaving the numerator unexpanded:"
}], "ExampleText",
 CellID->169943182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandDenominator", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", "d"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"c", "-", "d"}], ")"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41151221],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}]}], 
  RowBox[{
   SuperscriptBox["c", "2"], "-", 
   SuperscriptBox["d", "2"]}]]], "Output",
 ImageSize->{93, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27451928]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11946482],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " expands the numerator and expands the fraction into a sum of fractions:"
}], "ExampleText",
 CellID->551034589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", "d"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"c", "-", "d"}], ")"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->537275298],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["a", "2"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c", "-", "d"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", "d"}], ")"}]}]], "-", 
  FractionBox[
   SuperscriptBox["b", "2"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c", "-", "d"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", "d"}], ")"}]}]]}]], "Output",
 ImageSize->{194, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108388901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197505926],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandAll"]], "InlineFormula"],
 " expands the numerator, the denominator, and the fraction:"
}], "ExampleText",
 CellID->135469102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandAll", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", "d"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"c", "-", "d"}], ")"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33089202],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["a", "2"], 
   RowBox[{
    SuperscriptBox["c", "2"], "-", 
    SuperscriptBox["d", "2"]}]], "-", 
  FractionBox[
   SuperscriptBox["b", "2"], 
   RowBox[{
    SuperscriptBox["c", "2"], "-", 
    SuperscriptBox["d", "2"]}]]}]], "Output",
 ImageSize->{101, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260051079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43279959],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " to factor the numerator back:"
}], "ExampleText",
 CellID->892226516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Factor", "[", 
     RowBox[{"Numerator", "[", "#", "]"}], "]"}], "/", 
    RowBox[{"Denominator", "[", "#", "]"}]}], "&"}], "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "-", 
     RowBox[{"b", "^", "2"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"c", "^", "2"}], "-", 
     RowBox[{"d", "^", "2"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35060007],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}]}], 
  RowBox[{
   SuperscriptBox["c", "2"], "-", 
   SuperscriptBox["d", "2"]}]]], "Output",
 ImageSize->{93, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23086515]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30992],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Numerator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Numerator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandDenominator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpandDenominator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpandAll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2694]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13271],

Cell[TextData[ButtonBox["Structural Operations on Rational Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnRationalExpressions"]], "Tutorials",
 CellID->31692]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->367922893],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->482703460],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->21388001]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpandNumerator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 45.7321670}", "context" -> "System`", 
    "keywords" -> {"numerator", "rational function"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExpandNumerator[expr] expands out products and powers that appear in the \
numerator of expr. ", "synonyms" -> {"expand numerator"}, "title" -> 
    "ExpandNumerator", "type" -> "Symbol", "uri" -> "ref/ExpandNumerator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9220, 245, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->147882192]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26901, 959}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2311, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2934, 82, 4199, 83, 70, "ObjectNameGrid"],
Cell[7136, 167, 604, 19, 70, "Usage",
 CellID->21671]
}, Open  ]],
Cell[CellGroupData[{
Cell[7777, 191, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8255, 208, 234, 7, 70, "Notes",
 CellID->1169],
Cell[8492, 217, 282, 10, 70, "Notes",
 CellID->23938],
Cell[8777, 229, 406, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[9220, 245, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->147882192],
Cell[CellGroupData[{
Cell[9605, 259, 148, 5, 70, "ExampleSection",
 CellID->859621281],
Cell[9756, 266, 78, 1, 70, "ExampleText",
 CellID->663264673],
Cell[CellGroupData[{
Cell[9859, 271, 407, 15, 28, "Input",
 CellID->1169725],
Cell[10269, 288, 424, 16, 56, "Output",
 CellID->239201381]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10742, 310, 216, 7, 70, "ExampleSection",
 CellID->25426],
Cell[10961, 319, 87, 1, 70, "ExampleText",
 CellID->130616091],
Cell[CellGroupData[{
Cell[11073, 324, 283, 10, 70, "Input",
 CellID->18739944],
Cell[11359, 336, 368, 13, 57, "Output",
 CellID->138612971]
}, Open  ]],
Cell[11742, 352, 125, 3, 70, "ExampleDelimiter",
 CellID->597265136],
Cell[11870, 357, 210, 7, 70, "ExampleText",
 CellID->404569172],
Cell[CellGroupData[{
Cell[12105, 368, 382, 14, 70, "Input",
 CellID->4305372],
Cell[12490, 384, 420, 15, 56, "Output",
 CellID->260387549]
}, Open  ]],
Cell[12925, 402, 125, 3, 70, "ExampleDelimiter",
 CellID->143266365],
Cell[13053, 407, 256, 7, 70, "ExampleText",
 CellID->203258716],
Cell[CellGroupData[{
Cell[13334, 418, 419, 15, 70, "Input",
 CellID->417822826],
Cell[13756, 435, 543, 18, 54, "Output",
 CellID->116180510]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14348, 459, 218, 7, 70, "ExampleSection",
 CellID->28522],
Cell[CellGroupData[{
Cell[14591, 470, 224, 7, 70, "ExampleSubsection",
 CellID->29454],
Cell[14818, 479, 91, 1, 70, "ExampleText",
 CellID->237596275],
Cell[CellGroupData[{
Cell[14934, 484, 272, 9, 70, "Input",
 CellID->175648844],
Cell[15209, 495, 249, 9, 54, "Output",
 CellID->3333602]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15507, 510, 221, 7, 70, "ExampleSubsection",
 CellID->19398],
Cell[15731, 519, 125, 3, 70, "ExampleText",
 CellID->533987315],
Cell[CellGroupData[{
Cell[15881, 526, 302, 10, 70, "Input",
 CellID->31257848],
Cell[16186, 538, 401, 14, 51, "Output",
 CellID->412611278]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[16648, 559, 231, 7, 70, "ExampleSection",
 CellID->982],
Cell[16882, 568, 226, 7, 70, "ExampleText",
 CellID->297563176],
Cell[CellGroupData[{
Cell[17133, 579, 409, 15, 70, "Input",
 CellID->333947376],
Cell[17545, 596, 371, 14, 56, "Output",
 CellID->24518535]
}, Open  ]],
Cell[17931, 613, 125, 3, 70, "ExampleDelimiter",
 CellID->433206182],
Cell[18059, 618, 254, 7, 70, "ExampleText",
 CellID->169943182],
Cell[CellGroupData[{
Cell[18338, 629, 410, 15, 70, "Input",
 CellID->41151221],
Cell[18751, 646, 371, 14, 52, "Output",
 CellID->27451928]
}, Open  ]],
Cell[19137, 663, 124, 3, 70, "ExampleDelimiter",
 CellID->11946482],
Cell[19264, 668, 245, 7, 70, "ExampleText",
 CellID->551034589],
Cell[CellGroupData[{
Cell[19534, 679, 400, 15, 70, "Input",
 CellID->537275298],
Cell[19937, 696, 525, 20, 56, "Output",
 CellID->108388901]
}, Open  ]],
Cell[20477, 719, 125, 3, 70, "ExampleDelimiter",
 CellID->197505926],
Cell[20605, 724, 237, 7, 70, "ExampleText",
 CellID->135469102],
Cell[CellGroupData[{
Cell[20867, 735, 402, 15, 70, "Input",
 CellID->33089202],
Cell[21272, 752, 425, 16, 55, "Output",
 CellID->260051079]
}, Open  ]],
Cell[21712, 771, 124, 3, 70, "ExampleDelimiter",
 CellID->43279959],
Cell[21839, 776, 475, 18, 70, "ExampleText",
 CellID->892226516],
Cell[CellGroupData[{
Cell[22339, 798, 477, 17, 70, "Input",
 CellID->35060007],
Cell[22819, 817, 371, 14, 52, "Output",
 CellID->23086515]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23251, 838, 311, 9, 70, "SeeAlsoSection",
 CellID->30992],
Cell[23565, 849, 958, 35, 70, "SeeAlso",
 CellID->2694]
}, Open  ]],
Cell[CellGroupData[{
Cell[24560, 889, 314, 9, 70, "TutorialsSection",
 CellID->13271],
Cell[24877, 900, 200, 4, 70, "Tutorials",
 CellID->31692]
}, Open  ]],
Cell[CellGroupData[{
Cell[25114, 909, 319, 9, 70, "MoreAboutSection",
 CellID->367922893],
Cell[25436, 920, 161, 3, 70, "MoreAbout",
 CellID->482703460],
Cell[25600, 925, 146, 3, 70, "MoreAbout",
 CellID->21388001]
}, Open  ]],
Cell[25761, 931, 50, 0, 70, "History"],
Cell[25814, 933, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

