(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44499,       1461]
NotebookOptionsPosition[     36641,       1190]
NotebookOutlinePosition[     38163,       1231]
CellTagsIndexPosition[     38077,       1226]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MovingAverage" :> 
          Documentation`HelpLookup["paclet:ref/MovingAverage"], 
          "MovingMedian" :> 
          Documentation`HelpLookup["paclet:ref/MovingMedian"], "FoldList" :> 
          Documentation`HelpLookup["paclet:ref/FoldList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MovingAverage\"\>", 
       2->"\<\"MovingMedian\"\>", 3->"\<\"FoldList\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Data Transforms and Smoothing\"\>", 
       2->"\<\"Signal Processing\"\>", 
       3->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       4->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ExponentialMovingAverage", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExponentialMovingAverage",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExponentialMovingAverage"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["\[Alpha]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the exponential moving average of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with smoothing constant ",
     Cell[BoxData[
      FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The smoothing constant ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " is typically a number between 0 and 1, but can be any expression."
}], "Notes",
 CellID->386153655],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExponentialMovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExponentialMovingAverage"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["\[Alpha]", "TR"]}], "]"}]], "InlineFormula"],
 " generates a list of results ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " in which ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", 
     RowBox[{"i", "+", "1"}]], "=", 
    RowBox[{
     SubscriptBox["y", "i"], "+", 
     RowBox[{"\[Alpha]", "(", 
      RowBox[{
       SubscriptBox["x", 
        RowBox[{"i", "+", "1"}]], "-", 
       SubscriptBox["y", "i"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->135253867,
  ButtonNote->"135253867"]
}], "Notes",
 CellID->491992065],

Cell[TextData[{
 "The output from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExponentialMovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExponentialMovingAverage"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["\[Alpha]", "TR"]}], "]"}]], "InlineFormula"],
 " has the same length as ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->841443470],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExponentialMovingAverage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialMovingAverage"]], "InlineFormula"],
 " handles both numerical and symbolic data."
}], "Notes",
 CellID->61915619],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExponentialMovingAverage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialMovingAverage"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->625271644,
  ButtonNote->"625271644"]
}], "Notes",
 CellID->115997578]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->152420209],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->229349431],

Cell["Exponential moving average in symbolic form:", "ExampleText",
 CellID->640262487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExponentialMovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183199635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", "x"}]}], ",", 
   RowBox[{"a", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", "x"}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "c", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", "x"}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 ImageSize->{346, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219662809]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121430491],

Cell["Exponential moving average for numeric values:", "ExampleText",
 CellID->248727338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExponentialMovingAverage", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->475800516],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["4", "3"], ",", 
   FractionBox["17", "9"], ",", 
   FractionBox["70", "27"], ",", 
   FractionBox["275", "81"], ",", 
   FractionBox["1036", "243"], ",", 
   FractionBox["3773", "729"], ",", 
   FractionBox["13378", "2187"], ",", 
   FractionBox["46439", "6561"], ",", 
   FractionBox["158488", "19683"]}], "}"}]], "Output",
 ImageSize->{394, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49991870]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2700],

Cell["Compute exponential moving averages at machine precision: ", \
"ExampleText",
 CellID->454759592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExponentialMovingAverage", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5", ",", "7", ",", "3", ",", "6", ",", "2"}], "}"}], 
    "]"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379808465],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "3.`", ",", "5.`", ",", "4.`", ",", "5.`", ",", "3.5`"}], 
  "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134942100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->722951932],

Cell["Exponential moving averages of matrices are matrices: ", "ExampleText",
 CellID->14559980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"5", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357143563],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.492297945492119`", ",", "0.07364147913502594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.353582433056513`", ",", "2.251941529780581`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8702474692141904`", ",", "0.7150792909379833`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.151151004539931`", ",", "3.4300107496517676`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.23604657241854565`", ",", "1.473873087681341`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.300058720005596`", ",", "4.701268327337667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5559015764813724`", ",", "1.7546757630761622`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.483680008239363`", ",", "1.1642837435409825`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.163187151737038`", ",", "1.4579238366103309`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.361577560782636`", ",", "3.649441496475009`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{552, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44816192]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExponentialMovingAverage", "[", 
  RowBox[{"data", ",", 
   RowBox[{"1", "/", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452249129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.492297945492119`", ",", "0.07364147913502594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9576190673832174`", ",", "0.6182164917964148`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.4357761678409604`", ",", "0.642432191581807`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.114619877015703`", ",", "1.3393268310992972`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6449765508664136`", ",", "1.3729633952448081`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.3087470931512093`", ",", "2.2050396282680227`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8705357139837502`", ",", "2.0924486619700575`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.523821787547653`", ",", "1.8604074323627888`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.9336631285949992`", ",", "1.7597865334246743`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.7906417366419083`", ",", "2.232200274187258`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{538, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116110442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11857],

Cell["Obtain results for lists of any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExponentialMovingAverage", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "7", ",", "3", ",", "6", ",", "2"}], "}"}], 
     ",", "25"}], "]"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`24.69897000433602", ",", "3.`24.73675856522542", ",", 
   "5.`24.628932137728263", ",", "4.`24.320458547502305", ",", 
   "5.`24.198082027658604", ",", "3.5`23.85804656694162"}], "}"}]], "Output",
 ImageSize->{580, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58543464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->307792789],

Cell["Obtain results for smoothing coefficients of any precision: ", \
"ExampleText",
 CellID->459280447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExponentialMovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "3", ",", "6", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", "30"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296292495],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3.`30.17609125905568", ",", "5.`30.", ",", 
   "4.`29.672641065613668", ",", "5.`29.560667306169737", ",", 
   "3.5`29.19918476498041"}], "}"}]], "Output",
 ImageSize->{464, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1689553]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18849],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322070633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExponentialMovingAverage", "[", 
  RowBox[{"sp", ",", 
   RowBox[{"1", "/", "10"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "963", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 963, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45183953]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2702],

Cell["Smooth noisy data:", "ExampleText",
 CellID->7299883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], "+", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "20"}], "]"}]}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->595911816],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.4987340697213245`"}], ",", "2.5853215621588594`", ",", 
   "4.98027675566899`", ",", "4.525457378731094`", ",", "3.170242056527087`", 
   ",", "7.49631916401058`", ",", "8.39458239393068`", ",", 
   "7.488766962285533`", ",", "9.980208638572151`", ",", "8.38922166626414`", 
   ",", "11.982139845684502`", ",", "12.262003626996833`", ",", 
   "11.855318954007977`", ",", "15.513223954791266`", ",", 
   "15.435090400503256`", ",", "15.68137209403088`", ",", 
   "15.731704056014726`", ",", "17.44823420920948`", ",", 
   "17.896043073506206`", ",", "20.780554837059757`"}], "}"}]], "Output",
 ImageSize->{422, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->747021311]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"smoothed", "=", 
  RowBox[{"ExponentialMovingAverage", "[", 
   RowBox[{"data", ",", 
    RowBox[{"1", "/", "4"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74563834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.4987340697213245`"}], ",", "0.2722798382487215`", ",", 
   "1.4492790676037888`", ",", "2.218323645385615`", ",", 
   "2.456303248170983`", ",", "3.716307227130882`", ",", "4.885876018830832`",
    ",", "5.5365987546945075`", ",", "6.647501225663918`", ",", 
   "7.082931335813973`", ",", "8.307733463281606`", ",", "9.296301004210413`",
    ",", "9.936055491659804`", ",", "11.33034760744267`", ",", 
   "12.356533305707817`", ",", "13.187743002788583`", ",", 
   "13.823733266095118`", ",", "14.729858501873709`", ",", 
   "15.521404644781834`", ",", "16.836192192851314`"}], "}"}]], "Output",
 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->290300470]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{"data", ",", "smoothed"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37373693],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WEFPE0EUXmi3GtNyqsRDQdDiqV4Ub200oWhi9CZ6qklDmsABUCiJFzho
MB5oiDElIQGNsRATTgaCBz3JBU4c5cwfWWd2przZb98OWwlNutu3+73vvffN
m9nZPq3WJ2pT1frkeHXg0Wz11cTk+NzAw5lZcSnR5TjOrvjWrznityd++d9d
zxPn8PGOOCYEIK/P3eLcLc6D2naSPkx/5NWkgUr4N+/JowR7/se5IQ9JshXe
RFwHO8Hdd5V9evRZZHld8nxBkQdYhouOOmjYfKV3teJD8WIRQvvlY0UwefLx
IrlmJMnsq5Ey/aJ0HNa53fSom9q9161bz7QTntl1GcimxV712zfxpf5trfS6
WfnkbFhQHx+8EajV0qwV9evrn5XHb7c//IhAqTyuiOP3tmYhjMsyb429E5fW
R+adFNxH/yGwb52Bx3hn2bzCad8+Ofi7M9083jt0VmJ50bjIsdtkMVnfPmr9
FvrvL287DQtKqCRQUiUbirLkUcGs+iD+EuuTg/gueC1YVNtsHd0vrTWW9/V9
ys8FVhvLi7EtwTI6su5cBRab1+HBycz0zs+9Y+1FuZDX6dpixOA588DJowqg
zbwFRbXPB/K5DTXyHGokpYryInZyDipWI3sZULiy5Vi1qZqpWCxZiO2yo0HV
R7NKMws59YE6yjultUMdshB7CCqqnXqH1yWyi5Cx8rrk0XodRlOGNcv42dcH
fm0vQw0VC4pyrgTijUKOKeB8xnIWYWR7IAbvVQCvDIxoD+RiYyGvDIwsr3IB
UMGZ9hyqfsJyDEP+vWx/kwo2Fsq/F2wXVLCxUD29YPPaBXvtJVRdZn0qUJVC
BffF7f0wzroK1KJ8/XXCurNCuwxK90PmxQ54pVkGzfuhxk74wnnSKPRD/f/L
2zqXn96Y+J/2HhJHKtgZ06DvMNsZU6CaDUUa8KgxGOEM2EWLF64FZJMXzXIa
HRdi4PMpAyoU2BwqEBOfajYvfBaSSrxXcJQWIb8867MA+dhQFJ9HLUHEnAVF
EXOBrN9DJJ5Dd65Lnaveo7g9TgOy8p/1obmA75x4vwFZn4eFqovPIk12nnv8
jFXzCruXbNzTp4k79M6K+x7Fjc8ktKNjZ0BLFdtch9rvtrhnUpFxjqIdnRm+
XaQDvbd4BrutF+Nd3QDVkxYU6ZMMZPkZauA5GqB51oIifWyo6JUxzXo1gTuo
9Spw8hydaBt/p2z+R8c/6VTLt/+bUceLfQqbc96J8KI1IA6aq8rMq5Ps4uwR
NqArbL1NXcH1NnUFz6Fz6voHrSd08A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->34023655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102711289],

Cell["\<\
Compute an exponential moving average using an initial starting value:\
\>", "ExampleText",
 CellID->4637764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], "+", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "20"}], "]"}]}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->555542417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.720528689649454`", ",", "0.7923066913023469`", ",", "1.069181875082804`",
    ",", "2.04562069882655`", ",", "6.593250659298255`", ",", 
   "7.228155245111116`", ",", "5.850086882967622`", ",", "8.964771683522578`",
    ",", "8.145566508446219`", ",", "10.503261693865804`", ",", 
   "11.759272566044986`", ",", "13.102921335232235`", ",", 
   "13.835935911256408`", ",", "13.52529782636006`", ",", 
   "15.933124570074895`", ",", "17.375612737522207`", ",", 
   "17.985056687248104`", ",", "17.509083314993696`", ",", 
   "18.49479452246898`", ",", "20.0648184614301`"}], "}"}]], "Output",
 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26037729]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"start", "=", "4.5"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->268890722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"smoothed", "=", 
  RowBox[{"Rest", "[", 
   RowBox[{"ExponentialMovingAverage", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", "start", "}"}], ",", "data"}], "]"}], ",", 
     RowBox[{"1", "/", "5"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->408920757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.144105737929891`", ",", "3.4737459286043824`", ",", 
   "2.9928331179000667`", ",", "2.803390634085363`", ",", 
   "3.5613626391279416`", ",", "4.294721160324577`", ",", 
   "4.605794304853186`", ",", "5.477589780587064`", ",", "6.011185126158895`",
    ",", "6.909600439700277`", ",", "7.879534864969219`", ",", 
   "8.924212159021822`", ",", "9.906556909468739`", ",", 
   "10.630305092847003`", ",", "11.690868988292582`", ",", 
   "12.827817738138506`", ",", "13.859265527960426`", ",", 
   "14.58922908536708`", ",", "15.37034217278746`", ",", 
   "16.30923743051599`"}], "}"}]], "Output",
 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156046431]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{"data", ",", "smoothed"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->491541473],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWL9v2lAQNhhoVUEmInWAlLSmE11auoE6hLRL6RTaiUoookqGkDYNlTow
VXQKI0OksJGoUrslSpduWZIpYzPnH3H9/Gzu+fPx+FFFChI2Z9939929O/t4
1cbuRnOrsbu53si92ml83Nhc/5x7ub3jXDIjhmGcON+v9w3nt+38cr8ntu2c
1eNT52g6tyzvHHXOUee87MlGzFXzPuJqTNEy3ZvPxVEo2+7HeCgOMZKlvqrx
AGSTux+X8ujoWhGBRcT5hjznWAs37XVZkflIn3kZz0/nizQ8nDWVB9WONZ2n
uOpJWHazkVBx4/JY9Lg9sqma/NqLeqWnyqatVl24llPAb6i5es85/vBjCunE
b7mcuGV8UDbZrOZBfjPhPm8l6cqHw8sX5f3e3pnR12i9qx05WqsrBx5DQvVG
KFFREn1xfr3dOv59euVpE7rH+kgDitfSVSFezQDLboBlFlh1NTaIFa8VA08D
jRZ5XHTly+Gf/fKns72fWtvEIAUomd2j2jdHPlhpQ5SLcFdqX5//PW71r04v
xvhMsj4IhRw6GivkG7noUORrEWQeFQNGtAIiC5ijPGi3NTbJcx6sSJSwbY58
ELoA6Dj43HLRdwGFb4Ui+JwFRb7Ho4QouycRyBVplYB3c6QdzhWiiLdE3bHp
XRTmS/2D9dZk10eiqJ+wKuuBGpBzBvYRMayzPixglgVmOhQx42vWAkaPgf8a
i6oCb9ISUT4BvkvAl7dZAL58PxSAL69Vgyhes1oV4LkAURFKRLUK/BYgKp0P
4suvFf/uKLF5pKgqAX5l4LcE0VQ0PogfrhWPknyD/yT8fxDYu1LXfTpoZ0+U
mxBtaQY7QmxC/LPgwzwoI/PaqcJqrv2XHVrnLOSpKM2YtDb+lI0rU4W1z0LG
ioH6akEe6O68s1ENMoKRFDQojJ9YFwKs37IxUhS8j1mi6ABrS6NFLK0Ay/ds
Joglb7MOmeB7tQ4ZSIEvfh2boIXzsw6FMzr5xmkzE8jChwn1mGF9diFXvFYP
PKdle8SpS+S/Wm6K6gEPicW+xB0AvN8DntNbofloVp99iDpJVkL7CRh1H6JW
sKEdApzE+hCrxKrPJH8nAKewNtRdsJu/QH3x3duGOsJJO8aiBhCvTosi47WG
AdaHrE4HItU9N3C+JFRag8KeJys8qgu2sXsJJaL6DjZ13Uk2eK0+eE5qtMij
Tos8JgOs+bWQ66Xug/JTjCx0f/9LHie9r+edfwaQE1lpascbY6wIcQC5mh4d
5kC59Aa+MXuBk7PATSW/3EvhvT8j8g8X9xzx\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->84675554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259738187],

Cell["\<\
Compute the exponential moving average of a financial time series:\
\>", "ExampleText",
 CellID->100557842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"ExponentialMovingAverage", "[", 
   RowBox[{
    RowBox[{"FinancialData", "[", 
     RowBox[{
     "\"\<GE\>\"", ",", "\"\<Jan. 1, 2000\>\"", ",", "\"\<Value\>\""}], "]"}],
     ",", "0.1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149127020],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->351322964]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1268],

Cell["\<\
Terms of an exponential moving average satisfy a recurrence relation:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->135253867],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", "100"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->790508555],

Cell[BoxData[
 RowBox[{
  RowBox[{"alpha", "=", 
   RowBox[{"3", "/", "4"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->140916294],

Cell[BoxData[
 RowBox[{
  RowBox[{"ema", "=", 
   RowBox[{"ExponentialMovingAverage", "[", 
    RowBox[{"data", ",", "alpha"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->96543928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Rest", "[", "ema", "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"Most", "[", "ema", "]"}], "+", 
   RowBox[{"alpha", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Rest", "[", "data", "]"}], "-", 
      RowBox[{"Most", "[", "ema", "]"}]}], ")"}]}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->160965965],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->682516109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448774422],

Cell["\<\
Exponential moving average with a smoothing coefficient of 0 is a constant:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->218682833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExponentialMovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->463120729],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->841112592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->377088038],

Cell["\<\
Exponential moving average with a smoothing coefficient of 1 is the original \
list:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->200894543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExponentialMovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222783109],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16415268]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31593],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingAverage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MovingMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingMedian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FoldList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FoldList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->215545899]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->48126672],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->102911737],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->332656448],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->241234314]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExponentialMovingAverage - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 41, 55.6074198}", "context" -> "System`", 
    "keywords" -> {
     "data filter", "data filtering", "data smoother", "data smoothing", 
      "EMA", "EWMA", "exponential smoother", "exponential smoothing", 
      "exponential weighted moving average"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExponentialMovingAverage[list, \\[Alpha]] gives the exponential moving \
average of list with smoothing constant \\[Alpha].", 
    "synonyms" -> {"exponential moving average"}, "title" -> 
    "ExponentialMovingAverage", "type" -> "Symbol", "uri" -> 
    "ref/ExponentialMovingAverage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7698, 244, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->152420209]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37934, 1219}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1928, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2551, 72, 1589, 37, 70, "ObjectNameGrid"],
Cell[4143, 111, 768, 23, 70, "Usage",
 CellID->2815]
}, Open  ]],
Cell[CellGroupData[{
Cell[4948, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5426, 156, 217, 6, 70, "Notes",
 CellID->386153655],
Cell[5646, 164, 871, 31, 70, "Notes",
 CellID->491992065],
Cell[6520, 197, 422, 15, 70, "Notes",
 CellID->841443470],
Cell[6945, 214, 244, 7, 70, "Notes",
 CellID->61915619],
Cell[7192, 223, 469, 16, 70, "Notes",
 CellID->115997578]
}, Closed]],
Cell[CellGroupData[{
Cell[7698, 244, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->152420209],
Cell[CellGroupData[{
Cell[8083, 258, 148, 5, 70, "ExampleSection",
 CellID->229349431],
Cell[8234, 265, 87, 1, 70, "ExampleText",
 CellID->640262487],
Cell[CellGroupData[{
Cell[8346, 270, 202, 6, 28, "Input",
 CellID->183199635],
Cell[8551, 278, 701, 26, 36, "Output",
 CellID->219662809]
}, Open  ]],
Cell[9267, 307, 125, 3, 70, "ExampleDelimiter",
 CellID->121430491],
Cell[9395, 312, 89, 1, 70, "ExampleText",
 CellID->248727338],
Cell[CellGroupData[{
Cell[9509, 317, 201, 6, 70, "Input",
 CellID->475800516],
Cell[9713, 325, 520, 16, 51, "Output",
 CellID->49991870]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10282, 347, 215, 7, 70, "ExampleSection",
 CellID->2700],
Cell[10500, 356, 103, 2, 70, "ExampleText",
 CellID->454759592],
Cell[CellGroupData[{
Cell[10628, 362, 292, 9, 70, "Input",
 CellID->379808465],
Cell[10923, 373, 263, 9, 36, "Output",
 CellID->134942100]
}, Open  ]],
Cell[11201, 385, 125, 3, 70, "ExampleDelimiter",
 CellID->722951932],
Cell[11329, 390, 96, 1, 70, "ExampleText",
 CellID->14559980],
Cell[CellGroupData[{
Cell[11450, 395, 208, 7, 70, "Input",
 CellID->357143563],
Cell[11661, 404, 1127, 28, 71, "Output",
 CellID->44816192]
}, Open  ]],
Cell[CellGroupData[{
Cell[12825, 437, 170, 5, 70, "Input",
 CellID->452249129],
Cell[12998, 444, 1133, 28, 71, "Output",
 CellID->116110442]
}, Open  ]],
Cell[14146, 475, 121, 3, 70, "ExampleDelimiter",
 CellID->11857],
Cell[14270, 480, 86, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[14381, 485, 321, 10, 70, "Input",
 CellID->190699768],
Cell[14705, 497, 372, 10, 54, "Output",
 CellID->58543464]
}, Open  ]],
Cell[15092, 510, 125, 3, 70, "ExampleDelimiter",
 CellID->307792789],
Cell[15220, 515, 105, 2, 70, "ExampleText",
 CellID->459280447],
Cell[CellGroupData[{
Cell[15350, 521, 317, 10, 70, "Input",
 CellID->296292495],
Cell[15670, 533, 337, 10, 71, "Output",
 CellID->1689553]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16056, 549, 239, 7, 70, "ExampleSection",
 CellID->18849],
Cell[16298, 558, 259, 9, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[16582, 571, 570, 19, 70, "Input",
 CellID->19878761],
Cell[17155, 592, 484, 17, 36, "Output",
 CellID->322070633]
}, Open  ]],
Cell[CellGroupData[{
Cell[17676, 614, 169, 5, 70, "Input",
 CellID->235263230],
Cell[17848, 621, 485, 17, 36, "Output",
 CellID->45183953]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18382, 644, 222, 7, 70, "ExampleSection",
 CellID->2702],
Cell[18607, 653, 59, 1, 70, "ExampleText",
 CellID->7299883],
Cell[CellGroupData[{
Cell[18691, 658, 294, 11, 70, "Input",
 CellID->595911816],
Cell[18988, 671, 781, 16, 71, "Output",
 CellID->747021311]
}, Open  ]],
Cell[CellGroupData[{
Cell[19806, 692, 201, 6, 70, "Input",
 CellID->74563834],
Cell[20010, 700, 785, 16, 71, "Output",
 CellID->290300470]
}, Open  ]],
Cell[CellGroupData[{
Cell[20832, 721, 160, 5, 70, "Input",
 CellID->37373693],
Cell[20995, 728, 1525, 29, 70, "Output",
 Evaluatable->False,
 CellID->34023655]
}, Open  ]],
Cell[22535, 760, 125, 3, 70, "ExampleDelimiter",
 CellID->102711289],
Cell[22663, 765, 119, 3, 70, "ExampleText",
 CellID->4637764],
Cell[CellGroupData[{
Cell[22807, 772, 294, 11, 70, "Input",
 CellID->555542417],
Cell[23104, 785, 765, 16, 71, "Output",
 CellID->26037729]
}, Open  ]],
Cell[23884, 804, 116, 4, 70, "Input",
 CellID->268890722],
Cell[CellGroupData[{
Cell[24025, 812, 329, 10, 70, "Input",
 CellID->408920757],
Cell[24357, 824, 770, 17, 71, "Output",
 CellID->156046431]
}, Open  ]],
Cell[CellGroupData[{
Cell[25164, 846, 161, 5, 70, "Input",
 CellID->491541473],
Cell[25328, 853, 1529, 29, 70, "Output",
 Evaluatable->False,
 CellID->84675554]
}, Open  ]],
Cell[26872, 885, 125, 3, 70, "ExampleDelimiter",
 CellID->259738187],
Cell[27000, 890, 117, 3, 70, "ExampleText",
 CellID->100557842],
Cell[CellGroupData[{
Cell[27142, 897, 314, 9, 70, "Input",
 CellID->149127020],
Cell[27459, 908, 3958, 69, 70, "Output",
 Evaluatable->False,
 CellID->351322964]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31466, 983, 232, 7, 70, "ExampleSection",
 CellID->1268],
Cell[31701, 992, 168, 4, 70, "ExampleText",
 CellID->135253867],
Cell[31872, 998, 179, 6, 70, "Input",
 CellID->790508555],
Cell[32054, 1006, 138, 5, 70, "Input",
 CellID->140916294],
Cell[32195, 1013, 195, 6, 70, "Input",
 CellID->96543928],
Cell[CellGroupData[{
Cell[32415, 1023, 338, 11, 70, "Input",
 CellID->160965965],
Cell[32756, 1036, 161, 5, 36, "Output",
 CellID->682516109]
}, Open  ]],
Cell[32932, 1044, 125, 3, 70, "ExampleDelimiter",
 CellID->448774422],
Cell[33060, 1049, 174, 4, 70, "ExampleText",
 CellID->218682833],
Cell[CellGroupData[{
Cell[33259, 1057, 215, 7, 70, "Input",
 CellID->463120729],
Cell[33477, 1066, 223, 7, 36, "Output",
 CellID->841112592]
}, Open  ]],
Cell[33715, 1076, 125, 3, 70, "ExampleDelimiter",
 CellID->377088038],
Cell[33843, 1081, 183, 5, 70, "ExampleText",
 CellID->200894543],
Cell[CellGroupData[{
Cell[34051, 1090, 215, 7, 70, "Input",
 CellID->222783109],
Cell[34269, 1099, 222, 7, 36, "Output",
 CellID->16415268]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34552, 1113, 311, 9, 70, "SeeAlsoSection",
 CellID->31593],
Cell[34866, 1124, 718, 26, 70, "SeeAlso",
 CellID->215545899]
}, Open  ]],
Cell[CellGroupData[{
Cell[35621, 1155, 299, 8, 70, "MoreAboutSection"],
Cell[35923, 1165, 166, 3, 70, "MoreAbout",
 CellID->48126672],
Cell[36092, 1170, 145, 3, 70, "MoreAbout",
 CellID->102911737],
Cell[36240, 1175, 175, 3, 70, "MoreAbout",
 CellID->332656448],
Cell[36418, 1180, 151, 3, 70, "MoreAbout",
 CellID->241234314]
}, Open  ]],
Cell[36584, 1186, 27, 0, 70, "History"],
Cell[36614, 1188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

