(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9097,        335]
NotebookOptionsPosition[      6266,        242]
NotebookOutlinePosition[      7666,        281]
CellTagsIndexPosition[      7582,        276]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"], 
          "Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>", 
       2->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ToExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Expression", "ObjectName",
 CellID->22716],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Expression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Expression"]], "InlineFormula"],
     "\[LineSeparator]is a symbol that represents an ordinary ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression in ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     " and related functions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->695557348],

Cell[TextData[{
 "A file containing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " inputs:"
}], "ExampleText",
 CellID->329268897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/exprs\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2104477207],

Cell["\<\
x + y +
z
2^8\
\>", "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->265493009]
}, Open  ]],

Cell[TextData[{
 "Read the text as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions:"
}], "ExampleText",
 CellID->1654137481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/exprs\>\"", ",", "Expression"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13933324],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", "y", "+", "z"}], ",", "256"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1004608164]
}, Open  ]],

Cell["Read the text without evaluating it:", "ExampleText",
 CellID->613934765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/exprs\>\"", ",", 
   RowBox[{"Hold", "[", "Expression", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1912832752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"x", "+", "y", "+", "z"}], "]"}], ",", 
   RowBox[{"Hold", "[", 
    SuperscriptBox["2", "8"], "]"}]}], "}"}]], "Output",
 ImageSize->{172, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->239137760]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29772],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->7793]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1199],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->22878],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->31883]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Expression - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 3.6701262}", "context" -> "System`", 
    "keywords" -> {
     "read Mathematica formulas", "read Mathematica programs", 
      "parsing Mathematica expressions", "parsing Mathematica formulas", 
      "parsing Mathematica programs"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Expression is a symbol that represents an ordinary Mathematica \
expression in Read and related functions. ", "synonyms" -> {}, "title" -> 
    "Expression", "type" -> "Symbol", "uri" -> "ref/Expression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2770, 91, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7448, 269}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1391, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2014, 62, 48, 1, 70, "ObjectName",
 CellID->22716],
Cell[2065, 65, 668, 21, 70, "Usage",
 CellID->23125]
}, Open  ]],
Cell[CellGroupData[{
Cell[2770, 91, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3147, 105, 148, 5, 70, "ExampleSection",
 CellID->695557348],
Cell[3298, 112, 138, 6, 70, "ExampleText",
 CellID->329268897],
Cell[CellGroupData[{
Cell[3461, 122, 130, 3, 70, "Input",
 CellID->2104477207],
Cell[3594, 127, 102, 6, 70, "Print",
 CellID->265493009]
}, Open  ]],
Cell[3711, 136, 143, 6, 70, "ExampleText",
 CellID->1654137481],
Cell[CellGroupData[{
Cell[3879, 146, 159, 4, 28, "Input",
 CellID->13933324],
Cell[4041, 152, 240, 8, 36, "Output",
 CellID->1004608164]
}, Open  ]],
Cell[4296, 163, 79, 1, 70, "ExampleText",
 CellID->613934765],
Cell[CellGroupData[{
Cell[4400, 168, 193, 5, 70, "Input",
 CellID->1912832752],
Cell[4596, 175, 329, 11, 39, "Output",
 CellID->239137760]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4986, 193, 311, 9, 70, "SeeAlsoSection",
 CellID->29772],
Cell[5300, 204, 203, 6, 70, "SeeAlso",
 CellID->7793]
}, Open  ]],
Cell[CellGroupData[{
Cell[5540, 215, 313, 9, 70, "TutorialsSection",
 CellID->1199],
Cell[5856, 226, 186, 4, 70, "Tutorials",
 CellID->22878],
Cell[6045, 232, 149, 3, 70, "Tutorials",
 CellID->31883]
}, Open  ]],
Cell[6209, 238, 27, 0, 70, "History"],
Cell[6239, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

