(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38965,       1402]
NotebookOptionsPosition[     32095,       1165]
NotebookOutlinePosition[     33391,       1202]
CellTagsIndexPosition[     33305,       1197]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup["paclet:tutorial/AlgebraicNumberFields"], 
          "Polynomials over Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Number Fields\"\>", 
       2->"\<\"Polynomials over Algebraic Number Fields\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modulus" :> Documentation`HelpLookup["paclet:ref/Modulus"], 
          "Factor" :> Documentation`HelpLookup["paclet:ref/Factor"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
          "Algebraics" :> Documentation`HelpLookup["paclet:ref/Algebraics"], 
          "GaussianIntegers" :> 
          Documentation`HelpLookup["paclet:ref/GaussianIntegers"], "Root" :> 
          Documentation`HelpLookup["paclet:ref/Root"], "AlgebraicNumber" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumber"], 
          "ToNumberField" :> 
          Documentation`HelpLookup["paclet:ref/ToNumberField"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Modulus\"\>", 2->"\<\"Factor\"\>", 
       3->"\<\"MinimalPolynomial\"\>", 4->"\<\"Algebraics\"\>", 
       5->"\<\"GaussianIntegers\"\>", 6->"\<\"Root\"\>", 
       7->"\<\"AlgebraicNumber\"\>", 
       8->"\<\"ToNumberField\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Algebraic Number Theory\"\>",
        2->"\<\"Polynomial Algebra\"\>", 
       3->"\<\"Polynomial Factoring & Decomposition\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Extension", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Extension",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Extension"]], "InlineFormula"],
     "\[LineSeparator]is an option for various polynomial and algebraic \
functions that specifies generators for the algebraic number field to be \
used.  "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5423]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For polynomial functions, ",
 Cell[BoxData[
  ButtonBox["Extension",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extension"]], "InlineFormula"],
 " determines the algebraic number field in which the coefficients are \
assumed to lie."
}], "Notes",
 CellID->221703778],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"Extension", "->", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 " specifies the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
  "InlineMath"],
 " consisting of the rationals extended by the algebraic number ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->285895976],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Extension", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SubscriptBox["a", "1"], ",", 
     SubscriptBox["a", "2"], ",", "\[Ellipsis]"}], "]"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->17956],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must be exact numbers, and can involve radicals as well as ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->16828],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Extension", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies that any algebraic numbers that appear in the input should be \
included in the extension field. "
}], "Notes",
 CellID->527527216],

Cell[TextData[{
 "For polynomial functions, the default setting ",
 Cell[BoxData[
  RowBox[{"Extension", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that all coefficients are required to be rational. Any algebraic \
numbers appearing in input are treated like independent variables. "
}], "Notes",
 CellID->13488],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Extension", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " includes both the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and any algebraic numbers in the input. "
}], "Notes",
 CellID->18915],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"Extension", "->", 
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6906]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41716124],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->162268203],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " a polynomial over ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    SqrtBox["2"], "]"}], TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->204090805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"Extension", "\[Rule]", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->809819770],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "-", "x"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "x"}], ")"}]}]], "Output",
 ImageSize->{130, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70409889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279304595],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " over the field generated by the algebraic numbers present in the \
coefficients:"
}], "ExampleText",
 CellID->206126633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "3", "]"}], "x"}], "+", "3"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "3"}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->801520920],

Cell[BoxData[
 RowBox[{
  SqrtBox["3"], "-", "x"}]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39887593]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3958],

Cell["By default, factorization is performed over the rationals:", \
"ExampleText",
 CellID->439546450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], "-", "9"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75223602],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{107, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->666430750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35600916],

Cell[TextData[{
 "This specifies the factorization should be done over the rationals extended \
by ",
 Cell[BoxData[
  SqrtBox["3"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->45042205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "9"}], ",", 
   RowBox[{"Extension", "\[Rule]", 
    RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55574864],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox["3"], "-", "x"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["3"], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{179, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65959234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->408038384],

Cell[TextData[{
 "Here the factorization is done over the rationals extended by ",
 Cell[BoxData[
  SqrtBox["3"]], "InlineFormula"],
 "and ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139601321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "9"}], ",", 
   RowBox[{"Extension", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sqrt", "[", "3", "]"}], ",", "I"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->16050516],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox["3"], "-", "x"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["3"], "-", 
    RowBox[{"\[ImaginaryI]", " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["3"], "+", 
    RowBox[{"\[ImaginaryI]", " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["3"], "+", "x"}], ")"}]}]], "Output",
 ImageSize->{273, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148612551]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139713603],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " treats algebraic numbers as independent variables:"
}], "ExampleText",
 CellID->415960529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "3"}], "-", "#", "+", "1"}], "&"}], ",", "1"}], 
      "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102725075],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148669150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->149558139],

Cell["\<\
This computes the GCD over the algebraic number field generated by the \
coefficients:\
\>", "ExampleText",
 CellID->501747575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", "x", "+", "1"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "3"}], "-", "#", "+", "1"}], "&"}], ",", "1"}], 
      "]"}], "^", "2"}]}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->956388995],

Cell[BoxData[
 RowBox[{"x", "-", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", "#1", "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]], "Output",
 ImageSize->{161, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254397290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228985923],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " treats algebraic numbers as independent variables:"
}], "ExampleText",
 CellID->13897979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "+", "x"}], ")"}]}], "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "2"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75076854],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   SqrtBox["2"], "+", "x", "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}]}]]], "Output",
 ImageSize->{123, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->673150104]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124465123],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Extension", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " recognizes algebraically dependent coefficients:"
}], "ExampleText",
 CellID->453137934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", "2", "]"}], "+", "x"}], ")"}]}], "+", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "2"}], ")"}]}]}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259952941],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SqrtBox["2"], "-", "x"}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "-", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{127, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374855145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160057576],

Cell[TextData[{
 "By default, the norm is computed in the field generated by the ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->410185397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"ToNumberField", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->440076793],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox["9", "2"]}], ",", "0", ",", 
     FractionBox["1", "2"]}], "}"}]}], "]"}]], "Output",
 ImageSize->{385, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37604587]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberNorm", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->411015962],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17346237]
}, Open  ]],

Cell[TextData[{
 "This computes the norm in the field in which the ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object is represented:"
}], "ExampleText",
 CellID->18420336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberNorm", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1002070978],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->182819338]
}, Open  ]],

Cell[TextData[{
 "This computes the norm in the field generated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"], "+", 
    SqrtBox["5"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->96056936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberNorm", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Extension", "\[Rule]", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}], "+", 
     RowBox[{"Sqrt", "[", "5", "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->267678258],

Cell[BoxData["16"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->210795932]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16536],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"Extension", "->", 
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->168181280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", "1"}], ",", 
   RowBox[{"Extension", "\[Rule]", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92016508],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{109, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57489925]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", "1"}], ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->92661089],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{109, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398396299]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8231],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Modulus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Modulus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Algebraics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Algebraics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14255]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17599],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938],

Cell[TextData[ButtonBox["Polynomials over Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]], "Tutorials",
 CellID->6213]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->218931148],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->2639087],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->797116281],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->8381312]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Extension - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 4.5607740}", "context" -> "System`", 
    "keywords" -> {"domain of coefficients"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Extension is an option for various polynomial and algebraic functions \
that specifies generators for the algebraic number field to be used. ", 
    "synonyms" -> {}, "title" -> "Extension", "type" -> "Symbol", "uri" -> 
    "ref/Extension"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12600, 358, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->41716124]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33162, 1190}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3093, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3716, 95, 4193, 83, 70, "ObjectNameGrid"],
Cell[7912, 180, 518, 15, 70, "Usage",
 CellID->5423]
}, Open  ]],
Cell[CellGroupData[{
Cell[8467, 200, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8945, 217, 290, 9, 70, "Notes",
 CellID->221703778],
Cell[9238, 228, 428, 15, 70, "Notes",
 CellID->285895976],
Cell[9669, 245, 591, 22, 70, "Notes",
 CellID->17956],
Cell[10263, 269, 616, 21, 70, "Notes",
 CellID->16828],
Cell[10882, 292, 316, 9, 70, "Notes",
 CellID->527527216],
Cell[11201, 303, 390, 10, 70, "Notes",
 CellID->13488],
Cell[11594, 315, 516, 19, 70, "Notes",
 CellID->18915],
Cell[12113, 336, 450, 17, 70, "Notes",
 CellID->6906]
}, Closed]],
Cell[CellGroupData[{
Cell[12600, 358, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41716124],
Cell[CellGroupData[{
Cell[12984, 372, 148, 5, 70, "ExampleSection",
 CellID->162268203],
Cell[13135, 379, 328, 12, 70, "ExampleText",
 CellID->204090805],
Cell[CellGroupData[{
Cell[13488, 395, 245, 8, 28, "Input",
 CellID->809819770],
Cell[13736, 405, 323, 13, 43, "Output",
 CellID->70409889]
}, Open  ]],
Cell[14074, 421, 125, 3, 70, "ExampleDelimiter",
 CellID->279304595],
Cell[14202, 426, 268, 8, 70, "ExampleText",
 CellID->206126633],
Cell[CellGroupData[{
Cell[14495, 438, 355, 11, 70, "Input",
 CellID->801520920],
Cell[14853, 451, 191, 7, 38, "Output",
 CellID->39887593]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15093, 464, 215, 7, 70, "ExampleSection",
 CellID->3958],
Cell[15311, 473, 103, 2, 70, "ExampleText",
 CellID->439546450],
Cell[CellGroupData[{
Cell[15439, 479, 148, 5, 70, "Input",
 CellID->75223602],
Cell[15590, 486, 347, 13, 39, "Output",
 CellID->666430750]
}, Open  ]],
Cell[15952, 502, 124, 3, 70, "ExampleDelimiter",
 CellID->35600916],
Cell[16079, 507, 194, 7, 70, "ExampleText",
 CellID->45042205],
Cell[CellGroupData[{
Cell[16298, 518, 244, 8, 70, "Input",
 CellID->55574864],
Cell[16545, 528, 406, 16, 43, "Output",
 CellID->65959234]
}, Open  ]],
Cell[16966, 547, 125, 3, 70, "ExampleDelimiter",
 CellID->408038384],
Cell[17094, 552, 290, 11, 70, "ExampleText",
 CellID->139601321],
Cell[CellGroupData[{
Cell[17409, 567, 299, 11, 70, "Input",
 CellID->16050516],
Cell[17711, 580, 540, 21, 43, "Output",
 CellID->148612551]
}, Open  ]],
Cell[18266, 604, 125, 3, 70, "ExampleDelimiter",
 CellID->139713603],
Cell[18394, 609, 255, 8, 70, "ExampleText",
 CellID->415960529],
Cell[CellGroupData[{
Cell[18674, 621, 425, 15, 70, "Input",
 CellID->102725075],
Cell[19102, 638, 158, 5, 36, "Output",
 CellID->148669150]
}, Open  ]],
Cell[19275, 646, 125, 3, 70, "ExampleDelimiter",
 CellID->149558139],
Cell[19403, 651, 137, 4, 70, "ExampleText",
 CellID->501747575],
Cell[CellGroupData[{
Cell[19565, 659, 481, 16, 70, "Input",
 CellID->956388995],
Cell[20049, 677, 322, 11, 39, "Output",
 CellID->254397290]
}, Open  ]],
Cell[20386, 691, 125, 3, 70, "ExampleDelimiter",
 CellID->228985923],
Cell[20514, 696, 244, 8, 70, "ExampleText",
 CellID->13897979],
Cell[CellGroupData[{
Cell[20783, 708, 338, 12, 70, "Input",
 CellID->75076854],
Cell[21124, 722, 463, 18, 66, "Output",
 CellID->673150104]
}, Open  ]],
Cell[21602, 743, 125, 3, 70, "ExampleDelimiter",
 CellID->124465123],
Cell[21730, 748, 399, 14, 70, "ExampleText",
 CellID->453137934],
Cell[CellGroupData[{
Cell[22154, 766, 417, 14, 70, "Input",
 CellID->259952941],
Cell[22574, 782, 395, 16, 66, "Output",
 CellID->374855145]
}, Open  ]],
Cell[22984, 801, 125, 3, 70, "ExampleDelimiter",
 CellID->160057576],
Cell[23112, 806, 267, 8, 70, "ExampleText",
 CellID->410185397],
Cell[CellGroupData[{
Cell[23404, 818, 282, 9, 70, "Input",
 CellID->440076793],
Cell[23689, 829, 566, 19, 51, "Output",
 CellID->37604587]
}, Open  ]],
Cell[CellGroupData[{
Cell[24292, 853, 115, 3, 70, "Input",
 CellID->411015962],
Cell[24410, 858, 174, 6, 36, "Output",
 CellID->17346237]
}, Open  ]],
Cell[24599, 867, 267, 8, 70, "ExampleText",
 CellID->18420336],
Cell[CellGroupData[{
Cell[24891, 879, 185, 5, 70, "Input",
 CellID->1002070978],
Cell[25079, 886, 158, 5, 36, "Output",
 CellID->182819338]
}, Open  ]],
Cell[25252, 894, 252, 10, 70, "ExampleText",
 CellID->96056936],
Cell[CellGroupData[{
Cell[25529, 908, 313, 9, 70, "Input",
 CellID->267678258],
Cell[25845, 919, 159, 5, 36, "Output",
 CellID->210795932]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26053, 930, 233, 7, 70, "ExampleSection",
 CellID->16536],
Cell[26289, 939, 591, 23, 70, "ExampleText",
 CellID->168181280],
Cell[CellGroupData[{
Cell[26905, 966, 211, 7, 70, "Input",
 CellID->92016508],
Cell[27119, 975, 370, 13, 39, "Output",
 CellID->57489925]
}, Open  ]],
Cell[CellGroupData[{
Cell[27526, 993, 221, 7, 70, "Input",
 CellID->92661089],
Cell[27750, 1002, 371, 13, 39, "Output",
 CellID->398396299]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28182, 1022, 310, 9, 70, "SeeAlsoSection",
 CellID->8231],
Cell[28495, 1033, 1969, 71, 70, "SeeAlso",
 CellID->14255]
}, Open  ]],
Cell[CellGroupData[{
Cell[30501, 1109, 314, 9, 70, "TutorialsSection",
 CellID->17599],
Cell[30818, 1120, 159, 3, 70, "Tutorials",
 CellID->341631938],
Cell[30980, 1125, 189, 4, 70, "Tutorials",
 CellID->6213]
}, Open  ]],
Cell[CellGroupData[{
Cell[31206, 1134, 319, 9, 70, "MoreAboutSection",
 CellID->218931148],
Cell[31528, 1145, 154, 3, 70, "MoreAbout",
 CellID->2639087],
Cell[31685, 1150, 147, 3, 70, "MoreAbout",
 CellID->797116281],
Cell[31835, 1155, 165, 3, 70, "MoreAbout",
 CellID->8381312]
}, Open  ]],
Cell[32015, 1161, 50, 0, 70, "History"],
Cell[32068, 1163, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

