(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    135966,       3119]
NotebookOptionsPosition[    127615,       2826]
NotebookOutlinePosition[    129083,       2866]
CellTagsIndexPosition[    128996,       2861]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GumbelDistribution" :> 
          Documentation`HelpLookup["paclet:ref/GumbelDistribution"], 
          "WeibullDistribution" :> 
          Documentation`HelpLookup["paclet:ref/WeibullDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GumbelDistribution\"\>", 
       2->"\<\"WeibullDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Statistical Distributions\"\>", 
       4->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ExtremeValueDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ExtremeValueDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ExtremeValueDistribution"], "[", 
       RowBox[{
        StyleBox["\[Alpha]", "TR"], ",", 
        StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an extreme value distribution with location \
parameter ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26068]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The extreme value distribution gives the asymptotic distribution of the \
maximum value in a sample from a distribution such as the normal \
distribution.\
\>", "Notes",
 CellID->53261241],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in an extreme value distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "-", "x"}], ")"}], "/", "\[Beta]"}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", "x"}], ")"}], "/", "\[Beta]"}]}]], 
   TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16321,
  ButtonNote->"16321"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExtremeValueDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " to be any real number and ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " to be any positive real number."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->12600],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExtremeValueDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2554,
  ButtonNote->"2554"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->183695755],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->112836020],

Cell["The mean and variance of an extreme value distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->2554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ExtremeValueDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1988],

Cell[BoxData[
 RowBox[{"\[Alpha]", "+", 
  RowBox[{"EulerGamma", " ", "\[Beta]"}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299887955]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"ExtremeValueDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16798],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Pi]", "2"], " ", 
   SuperscriptBox["\[Beta]", "2"]}], "6"]], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146289393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19002],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30104],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "x"}], "+", "\[Alpha]"}], "\[Beta]"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "x"}], "+", "\[Alpha]"}], "\[Beta]"]}]], 
  "\[Beta]"]], "Output",
 ImageSize->{78, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188442532]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExtremeValueDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7056],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWktsVGUUvvTOTFsLUqBALSCUR3kqPgBRQVQe5d0WgYI8pJRKq/II4kY3
utGNbnQDiZEFauJjgTHBmGBiJDGSGEmMJMZHTE0MLiQmEhckJtfvnP//55x7
5s60g13YtDP3/+d8533Of+6dbuk52d93pOfkQG/PjPYTPcf7B3qfnbHu2Als
xaOiKBrE36nmCNcJrvhvMEnwXvo6lV5jouCfqA0vOSw7/Pt88/ltmai5ao3X
qNOss7lM9DKi2JPhpwZ/M/1+bFCdSbauLQxvMTIXDoGeY+in8Du91gwD3ebp
0qh5tMoJlfNjemdeCpnlSfq0y78vyPScjuBxQ3G0wq729M/4G8XLfKC9/M1v
+I1q6UWt66pcMz5fXOP3k/PfRzVn3vo6yj938nzvwQ+7Os6+8vLnpMUtRs9a
s66rcv1/wzuHj62Sy3izLtBL/tq1v8mRUfTaqxevX78xJKpaKSNNz1rHV777
HRlA+uYSW6d0WayZj85dQWoMDv45N4uiwppzKA85n134CUn20osXwCeqWbXy
dBQP9J87dvTjH3/4w0tvZ+zVq3/hA9oNdbyH9htu3PgHuoIH0rR7x7vgADLw
ww54E309c1nPXGATPobCqV5ClzvppR7xAgrBgjprV78JPcDn0le/QrrLiGgD
48ABFJAdzTZ8HuOUuvjFL2Cyb897KBsoAz+RJk3MYSMjsAUKupxlOHD/qQVv
aALspg1nXnj+U5CT1s3MYRMjYAgcSJczvUe2cgixiUp1gsECJk9RKOgBzQNK
y2W9CiCHLGgO9khdLG9n9GamhiYwjS5bDXp9yPc3Xv8SsmEb6duqsCK51evb
HjBO3w/e/5Y8yv6Ithh5M4y8NZyDoEeAEHeo2qZwCBnyIQu3mnHwC0CAggHn
rvNdDAWhJl1ON7hHGAebXHpB6fkKB9Vhd8CRbUwfv/P2ZbBERNzp5KnhVJhL
tjZ4antu0l4NLmgrbz57iDWBAsjO06cugc0i5t1hPMZ5nzrHctk7Wq5Zrwze
RELQEXGnkuTS879IouUK3ocdiBd1nMVKAkxD9pOfRsKWBwJPuAhxie5mWKfx
Wt0wJNX4qNnI3B+iixwBu+geJQEJiiyvRoLmbG1bnvie6DvlvUoS5MNrIS6k
Z8G/59Q7MbvPcFnCXLp4F1sIOF3aeWeZQlFfXFpE0bwwzVAvNdTLlAzpCFbG
EoNiTaNtvAvjYCJdhhluSbDb27FcUcPpcH2g1jLYZzHSDuld9KlHSbQsimMa
o9hR8sWYexQ0RVfRmjlq6fWcg+6MiEEKAF3a8/UuXsP9UI6y/0GFEnssanHQ
AT6lSlqhUGKPRXFFU1X403WlQkkmtXh7Fvsocw+Kths78kl2N4sr1MwdvEaH
hHy61JzF1tIKKZTs2Jqx60XBUjeyRKuUJOnfNyuJlk4CQo2A06WWILk+ErYs
DBmCjKfLhxm2I0nXRzwCkhaETMAJgDPHnWtekvSIkZMklSWSKONCboVeFieS
T3LXJV5+VOmJXowGT5fNRuZ8Y4dGSfZblJtm5fzjmcJNkKoaJhuUm5GRfyAh
T65RKDl/JifqvpTORRxVdKmpJVutDJ6B1HS6VqEkW7JRooNGgQsGYa1Zm/H0
Oqbu5l2ZnyYZGXOMDI2SirGo2UbzdoWSrpqNEl00SvSe5O2ZbXJkvaKWCST0
r6ze5m9U/I/tcLOMNo7/LnrNye7QZ37JjGjWM40dG5Qc8fBIyRHNtRyJyc3J
oWWrsWOj4i/RK8NfOk6Sfd60Gu01d4l2Ge55zT0KXU5RubsNOc34nivabWSW
m8lqitZLnWgOch42GbnTk3Rub1Yo6RbZKOm4GiU2WBTfD8boYOhj5KstCiXd
osnb42RIH3PUjxuPTDAypgVuvlduVSh3W1seJTmoUeKFCV6z240Omlo6jpUx
1XinQ6HkxMhGSVQdip9gxDhY0bDp0j6tmWI83alQ4oXx3h6SQSdll6KC1b4r
6WrjdYWZrMV4X3Gk+vJ31h6XL/L0nIc65x13qW/D3XvwZiYIx1meixjO7mjG
hX7iV05jWvKTW1VV29L8XDiHya/kibCqO8MXMaQHr/5YKWgPDM8PzSF+XR1n
6U6Ap/lob1J5gnJayVQjKM5B8KLLcZmy5C7KofbxLiAA0mWjQU02XLcrlFRJ
NgqNBO3EoqTDNHp7nGYyj2lqyT4rw80SUv87FEru77JR0p8daj/vyjw+1ms2
KcTHnzY7FbV40j6BnshruZPTKLE+GyU1oVHiBYtyPR9tCc2JLrsVSrxAKAI1
GR26U/nGCeZSwWdwbsiZqcnkj+PIFZKqB5crtrcN9STIdWd5RrhLuKf7Dcqw
2unI8ZburHinNHfSrd3lOpE7GeS54e4yXN0JVMI1w8OOo5yVimO96ThSQqH3
lN7plXCWjNudygaHL/onyZ6Cxpv84/M1OsC7cpKPMZJdb5I81Cip6GyU5JpG
yYluUY0mh9hzUQ/vykwx2tszzmSFppauMdrIGGuivlehpA9koySyGiW1GzRr
NNFy1Ad5VwLfYGTcauKzT6Gkf2ejJD4aJVHNRkl8NErOZkIRaIyJy/5U9tlO
Yc9BLXeMiZnjVNol3CktfXu4p/RoE90nKvDnb2Jz1XMXr1bizvOs78Sl9R2e
FjuOktvlOLqpEGWjN4fUt8HE80BF7sXRqyruchd8IJUVeW+hnYgcSuYorqHo
kNG03shy349LfTpUX5LOYvvNq0NJHWqU6G1R9UaXgwolHa/O2+NkSL/R1GJl
9nfEchfSy6gnk3R1ZH8LL7OaRsmMWes1qws6+DuOQ4pa5iQrw60lxx3qsNHM
nk8FI6tPoWQiykaJ5holvMJs7TSTWulL5VtWFyr3bV/e6MU+yagLluhnAZmr
S2ehnNH48DD44adYcNn8JAbl+KW/G3AZG2a1uLiP4wYnCsW6vwwfc1fouXK9
eRpb+46z9OdynNniWr0jOZ899YnVA6n4hn4Sppko51qB6Ovw8g3PU4x/hgNe
rPaQHUyLtoBqpvp8mvePECewjQrunha6otIcCfNx/z9UgF9gAwiQEahGCDvC
nx73mhwrrrR9Ff8jadS/lvjdog==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->720254086]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17708],

Cell["\<\
Generate a set of pseudorandom numbers that have the extreme value \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.39135269446937765`", ",", "1.0882207152349337`", ",", 
   RowBox[{"-", "0.3791277644882793`"}], ",", "0.873317408731736`", ",", 
   RowBox[{"-", "0.5884052037416044`"}]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435684073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14804],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"ExtremeValueDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26385],

Cell[BoxData[
 FractionBox[
  RowBox[{"12", " ", 
   SqrtBox["6"], " ", 
   RowBox[{"Zeta", "[", "3", "]"}]}], 
  SuperscriptBox["\[Pi]", "3"]]], "Output",
 ImageSize->{101, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216330]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"ExtremeValueDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17260],

Cell[BoxData[
 FractionBox["27", "5"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->407283160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31620],

Cell["Third moment of an extreme value distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->4343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", 
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9578],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", 
       RowBox[{"EulerGamma", " ", "\[Beta]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["\[Alpha]", "2"]}], "+", 
       RowBox[{"4", " ", "EulerGamma", " ", "\[Alpha]", " ", "\[Beta]"}], "+",
        
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["EulerGamma", "2"]}], "+", 
          SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
        SuperscriptBox["\[Beta]", "2"]}]}], ")"}]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[Beta]", "3"], " ", 
     RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{539, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47738070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of an extreme value distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4591],

Cell[BoxData[
 RowBox[{"\[Alpha]", "-", 
  RowBox[{"\[Beta]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"Log", "[", 
     FractionBox["1", "q"], "]"}], "]"}]}]}]], "Output",
 ImageSize->{115, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1110938]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29761],

Cell["\<\
Plot the cumulative distribution function of an extreme value distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"ExtremeValueDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26124],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116753588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8007],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->17584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"ExtremeValueDistribution", "[", 
      RowBox[{"0", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Beta]", ",", 
     RowBox[{"1", "/", "10"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10951],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsnQk4VP/3+Gfs2bJVSvu+p0XadK4WpX0h2rVq30uLEvXRSkW0lzYtSlJJ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   "], {{{}, 
     {RGBColor[0.33397672886243995`, 0.1279285534584573, 0.5864250111696041], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl+9r1lUYxr/Psz3f55f74dQMeqEzA6mcEUSzuQmzyIZb5huDJsUgrOnU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllMtLVWEUxT9v995z7nfo9oAe0EijSa9BEGShQUVQlN2cFFEUQhiaj3FZ
VjMjMGjQpMIGmdQgxUjJRgUZWH9ASBRBiaWDHkaSQb/VGmzYaz/Xt/c+p7qp
o7E9F0LYi+SRShbCYeR8IYTmqhCKSQjj4EIxhHP4x8EdaQhPSTqAfxu+EfAv
8HFydqBfwbZ5UQht2CrEXy2FMAQeRq6VbJP+GJlE7yRnjNiT1LsPfkt+Pf1m
6PcIvAU8hf8e/hKxZ8F99CqD14A3RXhQq5KzL2K7W3CMep/B35M3h2Xg5UgL
sVvJb0fvRO7guwl+T/4CPXeh7y/67eIobppBmVpLkNXU247tN/555ZDfC75F
79vIIHoN/GuI7ab+bvodIedF5hlqdnPw68V/PXoW6jlJbG3mWapGH/gU8Y3o
E0gd+iX8w/hvkLMT/IaYXN5vuIBvH7ZX9BskZh36X3iP5r2z/tQcxU0zrce/
gf5N+J+DX4PfUWNP0T0/UnsM2wlqrSKmAX2K+BI45t3rGPhi3j3FRTVV6z+n
6DeIuzj8STxjzbYO22f8n6J3m1JzIPUNaPfTOd/CQOLd6CYWip6hZtdAzAS+
H+SvBLcGc5dNut5wGdyd+RY1sxT9CXymmVUtfB6S+wCZrfINPkv8Zr1VO9bb
v+IvFzyDo+Av4MUF2zSLg4m5ayaz4JloboppxvcdvKJgjnPoP6O/Jdl6Sr5J
3eIgnOZT37huWzetb0s71671jZ3WrDPvVjc8RG5X4m9Vb2jTt5H4FvUNtBLf
En2r+ga0q+roW9TOXpa8U+1SN/wBPRc9my7yD2W2Sdc/YZT4EaQ/eIZL4bc2
ele68W+pd6zd6h+wEd/66G9TN/YPwLGU/Q==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4150981865873199, 0.26897686037537194`, 0.7004510335088123], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl39sn1UVxt/v9/32+/5K3GYikCwhApFExqSAJJbN0QUJkrnJNuOGStj8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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlm9oV2UUx+/vz/3d+7sX2hT6A4alo6htpmlB2yKVEoXaKo0sStL+6XRz
FtWbps6s0Kk5GxVK1lZW4ipNJFvOrTcWhfUmTa0GlSxoGpWVuTWjz5fvXhw4
5/me8zznnud7znMnPNg0d3k2CIJNSB6pKwZBLbI6FwQtyNdREAxjXwu4LESP
g+AxpJegKvCHkyAogpdlguA5fJ7FHg9+F3gn9qVgF2Lfgu98ZDN4A/Z+8HfA
54DPRp4Ga0ZqOG8B9ib0f8jne/xvZm0c+3ewVgVWjTyOXsvaPWCn8NmPPgf5
Gb2WtavRI/KtQB+DhJz3Lef1oJ8k/vqsY46nQXCEmJfQqwpBMBV9WuKztrE2
Hf8V+G/HLmIfQz8+aiun1/A9T9wCcj2Ucy3WIF0516QXvA8p5bynsK9gvya+
/4uMYzagb0T6sGdgf0bsEDn1s+dPSAexryOHM/7mBvRGZC96O2tD+LxMTC/2
Hr6vmr3GYtdhP489yHn3sd+M0Dn8QmwEPgs8Za0eewkyk70awBfj/yf2UdUW
uRXf25Bv0OchBfA2zjiG72nsvGoPPqi747z16OuQ+qxzqODscqQV3/PYlegN
Rde6lvO/Q9/HnqXEliCvFH3Hult900ZxQT5Z57gKfTLnN+O7C/xLYs+yZ3vB
OW4BexEZQm8NzK2Fke9GHDtLvvXYX6FfwvmTUuekXOqQEfAuYk7kzPnDkTkq
bqomH6F/iJSH/uZP0QeIX1ow5y5DbyNmJvh0ZC3676ytBG8C/5v9zySu7cXg
9xM/lnzvzZvz8s2Cn8s45irxL3at1wf+1rfAr8z7m5cT/yY+mbw5mYB3g6/A
v4L9f0UfTNwbJdi78R1I3Bt3h+7FEdamZN2TG4rmiLghjpVF5pi41Q2eYhdT
7z3MnjuKnhGaDarpMPoz4PuwJ+P/Pvt3Yw9iD5B/E/578ElH8x1h7xfwOZp1
TyxLzElxsRWfy4n9Df/20DX9Ub2N9GR9x7eD36n6hq7ZFPQ3IvfGXNYOYvci
p0LPJHHxmtR3LU42ik+pfTUDJqIfZO0Mud3E+Y8k7in1kuZbJ3tPTV27Lfh/
gO8ufA6BnSTmBrCq1Fwe5nv78K9OXTv1+Fp8F8eejR3IHalnrmatvmFzZA6J
O+pZ3e1O5NWM73gnsTsizyat7Y5dY9VWM7kfvR05gT4+516dJX6G7tm3Y3+D
cv8ha1/1sHpXMTXYq/HfG/oO1XttiWe1enBr5DdAs78fuwB+IPbs0oyPU3Ne
XFeP6G5rWHsg9B3r7sQhcUd3KK5+nHg2i7PK9a/EvaGcW4ruefW6Zuo58A7i
/815Rl4U+43R26KZNoQd60z2vhHpStxD6h3d0R+xOSpuivPT0D8n/j9iP8Ge
j/+TseurGXMB9tLEXJyNTESfkHi2K6clkWeKZol6spH8kthnK8c+zWbkSGBO
rQFvSc0N1VizQzNfs14zRHdbpvmQdw7K7brIs1M5qne2xq69emgM8esivy16
41Tr04l7XTV/j/h3i56FmmlJ0W+2uLwQ/5X4r0pt65s6wRdFnvV6c0rFh9H6
K6cefA+kfpvVU4/G5rS4rB7XLHsidi0103QXk8AfyvtOxmGXYy/Ke60SvSLx
26o1vc0liWutN1pvw/bYXNUboVkQJe5NzYR56JWxv0Vvjv5dmiP3ov5h/gcd
giiv
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480204], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l3uMF1cVx2d/O7+Z38wAhkqJNMvD0mBptzwWamMJtMZA20hsWhSthVKw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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlXto12UUxr/7XfzepiXpyHBztZDKy3TOosIphaYlSS6qlQlz3tKpbdOi
yLIUrKYzza2tsnJpJF3pQl7aZgS1gkVR0Cq7EkhhYRcTWrU+D8/+OHDO+5z3
vO97znPOe+6SdQvXZoIgaEFyyPAoCP5DyrNBMBPgaBgE27A/RS/GoTsJgi7k
W/TvkHlxENTi8x7+G5Ef0Hfh34//pnwQFKRB8Bo+P4Jdgv8q8NPsHwN2Afbn
YDH2LPRC5EPsTnyqwQfZM4j9IvIl+sXgP4O9in8f+sN57/2V8y7KOsYx8CDx
WU3gCfpp1iZm7FOEb0g8PXo+8gn3qwQ/zrbSYUEwDX09PrMzXuvDnoXPUmL1
EDMLdiYx56LvYe0j8N9iv2UZ9vHYOVOuxiL7sG/DrikgN8jtxCqMnNsF4Kux
RxLvINhTygn+FyI3Z31nnf0c+NGc73A+di/2ZvznYH9G7AH8K8DrsZuw/wUf
l/faCLDhyFb8v8o4V1cqR3nnIyFejHSw9EXOtVkN/nHWNYrYewT8BPpVrH0D
fpIYxcQrYK0U/SbWNrJ3LvjV+Nexv3eID4ORY2hvFbIktI+w95HH0NuQBZzf
gN0TOofK3WLij2J/HfZusEWszcBey3nb0N8E/52atUV+m3K2MzJnxBVxcDn6
KdYGiN+WNXcf5IypeXO4GXwNa805c2IK+lj8q9HfRdrBb8X/Wt77DrIwNcfF
7fuQl8BfQEry5ugw9NGRuTWAlONbgpShn+CMlPiD2BUZ95hqO58992ZdY9Vu
PfixrGv4BtjryOOBe6gV7E/u8BDvfoD7nJd6Tfps/H/C/js219bjcxi7G/kF
bB9n9sbmvLi+lXin0PcmrsUjw8ztXGQuiuPjiX1Z7Nos5g7NYEciv00zoQes
K/bZf+BTDDY1MbeUw+XYh8Qf9GeRycQ7R4LehTSCN0Tm554C12pV6t5SzaqJ
dSlrW7jLXepv7IbYscXhBH0S+N1D/KsBn47UZszJJvCvE3O1E3wSsScj87Gf
yJpLVezfnjOn9sfuKfWSekC99kHi2qnnisB6Es++t7jCBOzDiXvneexK9k+P
zZV5yFmcNQqpIN4B8JX47088SzQT1uHbH3v2HcAuxHc4MjHvmr8SOUfKjXK4
Rvdj/1/4P8n9ylSf1L2iHno59gzU7BOHOmPPKM0m9eQM7Cqkr8Cc3ov+NPEO
5TzD1dubU/eWenxCas6IK8qZuBfif3bGHIzQu2PXfiYx1ml+EOOGjHO6AfsK
7EfRdyF12NclrqVqen3iGaLaqYb12EuJ15p1T46LXEPVbiV2Y2iOi9u13G8H
WE3oXGuG7sa/FRnD+QcDnz0+8ezQHbagr4jMxTnEfCYxx8Vt5aACe0Pk3l+B
fSN2eWQ+aa2Is0enjq2a3gF+Z+K3qaevif0nar6ppy8PPQM1+1qQM9g7IjUX
VON+9PrYXFRN307ds+pVzdwu9JLId1UPT1ZuE99Fd9pB/FtS/4X38P6R+k9C
c1EzrpHYlYlzJw6dDN2D6j3lSH+pOC0u609Vb5al/lvUo5q9y2LPTs1g9d60
xLlRD7bj3z7ET/VwB3ZHZC7LXqT5Gfvt+lNVW/3x+ttV4ymcVZ6ay/rzN4Hd
H5sPet92zmpJ/FeKU72hZ5ZmlTj8T2JOiAuawaXCQudCHP0+9MzWrNYf9z8F
dyFK
         "],
         VertexColors->None], 
        PolygonBox[{{2638, 2645, 1146, 2093, 2637}, {2642, 2638, 2637, 2092, 
         1145}},
         VertexColors->None]}]}, 
     {RGBColor[0.5737613661287864, 0.5435370519035629, 0.9097253540741592], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1mMVUUQhs/cM+fee84FlIg+EBEIIG4MIiCoDEYUI+IuyGKIsgzqIIMK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlslVUUhc/tf2/v/c9l1DqGioRSoWIRaAXFYoojoImCIqgEKW3V1gLS
AQ1Ro1QRqQNasJpogihvYByjokF9EdQHY6ImRnghahRtaRODxvFbrPuwk73O
ns6w9zqTmtYtWVsWQuhDssiBYggfIa8AKsAZ9PvzIbRlQqjKhVCXhjAL6UhC
WIvsQ+/C3oR9COlE/4WY7nKvPQAuA08hdi45z4ohPInsQd9H4c2FEHqRi9Bn
US9Bb8N/NrnnsNZN/L/4n0v8bGJuRL8JuRf9Zuxt2H/Efx31bqHeJ+jbS/sb
IaYF3Iz0YhsAD+O/gxrfEbsTPB3fGuQO/O9EnsO2Nfr8t+IziG0IPB7fQ4nv
YpB895X7TgawD2B/Hf8D2J8CjwcvBL8Lvhv/P8BnE1/DWj/2Z5Hrg/e4Hfsk
8i3A3oD9CL6HdUZqT8f+G74nsH9IvVXEnIH+ODFD2OqJqWa/V+O/gdgu5Bz0
yui71Jkm6u6i9ZnkHCF2TdF3cTD4LVfkvVftZxDfZvBnic/8M3qOtUvJvQVc
JHY0cgH6PRm/7YP4/JT4jUfY5zRytibuH71dD/Yjid9QZ30GPJz4zC9jn68e
Au+nxvPoLyCdie/oKuxXIuez92bsEzlvHXhX4juqAFeDO9EXI3PR5+i+2dtd
+H9MvS34NJLrOPW+pPZI6rdoBR9X7+KzA/1TfNrRswX3nt7wa+x/p+69DnyW
YR+D1KI/ilShTy469hg+Tfjvov776lX28I/6l3wNpfu/ArwJ/73ETsA+A3wo
OvYbchwFJ+BLwA+rJ3T30XfZQo7V6LdH975moBH/ZeBNWZ95GrUWgbuzrrFB
/cna92W+s1r0+ui7UcwC9Muj71bxA+QbTcyixDH9+N/GfrflPDPXRJ9Be+/M
elZ2Frw/zUxP9ExplvrB64ueec36bnIsRv+T+FpwD/bRxFbivzzxHZ2O/ynI
RvLX4V+Jvba0v1ZkLL45ZDL1rsV/bNE9qV7Um8h3AjEtWcck+Jalvvu9yAep
Z0C9rx5UrQrxTc41f8c2M7qWeu4guAH76pzfdAm2GxDgyfsXF4Ro7hMnVFF7
YfQsij/ETcPU/DZjjhI3/gU+mjFHijvqU3OpOOTC6DfVW+gMDeTbXDQXrCdf
A77zSvOhmXkL/Y3U3PwDeAXxy0v9oTc+teieVa/qjDH6jDpbY9bcMaXgtxSH
XAyeV+oP5ehD3xZ9Fr2vZkUcKu7UzOyn9jFwX86ctDVvjhI3iTN6wePAM3Lu
ab31qIJ7QW8ubuzA56vEHPlYwTOrWdWfcBhbJvrv6GKtG31jdG9p5qfifyY5
lxJ/HfIqenvef4HuWNwpDhd3i0P3pJ5pzbJqjknN+Tqfev4l8IupuVZ3rN4/
rehe1AwsRX8z9V0/JP5CX5P3rOuNV7K3VaX/ST2iXh+Xem/qee31vIJ7V3t+
LfUZdTZxpN52Zd5/ieoHcCZ176rnPyf3F0hVmf+0deLPgnvjHWRU0XvU3sTR
76XmcHH3r+R7OvUfqb9RnNgKbknNnfpznyBfe8G59EfvTs2Z4kr9CcVoTjvJ
ZVlzTU3BsyzOmYp/dWqu0h8g/UTevaY1/bX/5R2rP2k+8ZdF29ST6qXy6L9Q
PaXeeSTvvauH3k7NkeJG/TmaTf0h+js0o/8DA9kF9A==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV1lsVlUQvv//3+3cGyPBRBBiocqq0RjDUhUtq21BwqIQtqIU1MRCiyhd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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtol3UYx3//w/Ye/heFN5qSc7WcNqIgW1bm1sw8rEhLzVkbtdmN7mBF
U2c1TZtzFTUTwcwlRLogSgOhqdAW2YUFEYnozWYYFESzJhmFsz7fvrt44Hne
73N6n9OvtLHtsdZsCKEbykMVcQgPpyFsRPikKIR5SQjvQoO5EB7NhPAT/E50
vsdoKjrb0H0VOgDfB34cvCsK4QX4cSiHvA79OuyroWGwJYUQ2vH9JvFmwpdD
i5FPI/+J/hXoB3TbkHvx3QBtw38/9AW6ffj7kfij2CxDd3niWM1QLbq3gjeA
34aPrcjjyKVgfdjfiW4vNAC2lG8n4XeTUyf8NGxmorsEm1rwp5AHwF8Dfx48
Qp5P/AN8+xK8kfil6D+tGuD7Y+SH4G+H1qD7HN/OYjuO/hz4VvAO7O8FXz+h
H8CKoAX4q4JOwPdgs4l4k/DxT3EI+/k2BPYZNo/Dr4DirGtcDl+FvxawOr7V
4n9pwbVQja9h/xY5ngU7ic5idG+J/W+noHtS/4NyUU71yJeLXWvVfD7yFfKp
yDlGNfL+yPVvRf4XeRPyBfBSfDyIfHPs//8KqkS+b+J/VyO3k+8DqW2Vbw18
TWTdtrxrtyA1Lx97wdbyP/vwvQg6A/+MepbzjN5ErEJie/mfhXx94t7Xawaw
nwztgb+I/nR8V4DXIK9E7kbemdpWOVaBVUPtE/O+Gb4j8f8rn2/QPQ2NonsJ
GoQfSu17M/qt5NcGPYI8A7mBfI4gD5P7BaiEXL5NbXuO9s8GmwWdD96BSmLN
hTZMzOds7LcU3CvN9G+JZ1CzV4aPLPgO6DuwOdhsSbzD2t1+5LLIM6TZkU/t
YibxrGknv0Y+FXvXzmW8Ky+Df5TzzhxJvLPaVfX4WWI3Fbwr6kkL+q3QcXQX
QiX82zX070B3FTGvw748di80428nviG6HdrB9xLXXLXWjA+gewz7oxn3aDfY
msi1UIzDmt/EuQ7lPduZyLxm/DDY3+icyfmGTIGfnPo2qSdHyf1i7FszQv73
p94hzWJz3r2qj42pZz3ggwXfmkPodCI3xb4lunnahanYr8p5JzZG3gntgnZe
t2peat/CDyK/H3s25K8LfkXk2umftyN/Dv2VdU9HUu+M8svi843UOcn2Q80g
uosiY5rRual3TvO8Lu/ZH0anJOcd0K7dnRrTzijWjal3QTEbifUEtCzvHRvV
rKaetZXktw/sF2h63m/CXfgbi93vXdAf1CqH/lV0tzJ3Y8hFqW/nduQdkXWE
6aZegs+A/w7fUezZySZ+K+RzWuKa6X9VY8WqRKdnAu+OvQOafb1JjalvrO6Z
bnIzuj8jb8D3k8QYib2T/+8iNn2J3zjNn276MfhObNZn/A/add0g3R7t/J7E
b4jm8UTOtVqd+N9Vs1+JdVUzrvtLzLrEM61ZVs4fIK+NXMvzGd/WhanfCvXv
xcg+ZNsE3p/4DdHboZlW7d9JHFs9uIxuceq3ogubXZFrrlrrDSmP/Abo9uum
HcK2JXItlOOnunWRY6kHk+CnYF9Z5DdGtRtLnKtqWMa/vJ569vRG3lDwDdTt
k01v5JyUi97UVyL3WL1VTXV7Z6S+DarJS4lvlm6Vbs5/qGEZEw==
         "],
         VertexColors->None], 
        PolygonBox[{{2640, 2103, 1154, 2657, 2639}, {2101, 2640, 2639, 2655, 
         1153}},
         VertexColors->None]}]}, 
     {RGBColor[0.6930474506790265, 0.7351965980697338, 0.912444709395743], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV3tol1UYPtv3+33fd75fFGRecpvh1KbpFkZe0XIShpdiK0Etm7oJg0Cn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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtsVVUQhXfvubfncWtMRBApiVJErFoTjKXYoFI0KogKSCIqFCzGJia0
aNSW+mrRVtQG4ysaa6y0KKJgfItYfiDVaPwhD5WoiSS1JZhAjA8Q337L1R+T
7Nlrzew5s2dmn0kNzQubciGEtUge6chC2BSHcJjNXjbmpyFcjXREIaxBmsB+
h1NeCGFJSQjFJIS/kM/gX4hMKIbQDed88BrkK7Ax6I+BjcO+H/1c9AOcNcze
SvQB+WC9FYmw7wBfie+fkfc4ayuyL++9V4hlH3izfONvF/peJAZfD96Jr6Ol
8NB36cPw1wZ/CG4FNi2sD7HXAucm+PvxfRl7p7DeAKcT/VL0ftZ9+OjC36n4
XxbZ3xjw9Yn5V4BfA7YQuR/8AeRJ8Ar090scw0bWR5Fz8s7ZePBxyAX4uoq9
h/H1EDI72GYL2ILUuf5E9uglxLMcfEXkXC2KHYtyNhvuxcg9rOdjfy3fthiZ
wVlbsHkK+6bEuX0Vf2diW4Z055zTKXCnInPgd2J/Hb6mgx/E9hicFmxbkRdZ
NyJVYDvwOYTtB3CqwerRm0fxX7H/lL1VYGfDaQdbgf482Ezi38tZN8KpJP9n
IGvBazP774f/L3s74Rfgbkf/Av5M1VywTUNqH//bwqks+hsU+1y+4TfwY8iX
kWMYYX0AGYic40s4607898Bfhf9vWH+dOFeq0Yn4OsR5A8E1rLvtUj9EvuPj
4U7ExzTWdfCrwRanjkU5a0efq/rC9mDkWv0HvDrvmtW3DIM3lvqbasCWsLcd
bjOymfU08B34foEYj5S6pnXfqsHVsWtatSyfJ6AvSl17m4HuI7Y1mXtXOd8D
1gtnJOceeTx1TagWtmFTjj4B6easoZxjmwe+LOcYdfddmXtBd6TabYbTV3AN
78b2tdi9p5jVK8eph/KO93S4NyPPFlxjJ4KN1X1HvgP1Ul/ib1VP/ci6DR8v
RaM9ptpEfipxTuX7ndi1qTN64dbHrv1B5IbYOVUudedl6h98npfznT0H1oMs
IFd3oO8H+y5xLT8NZxb8usyzQDn5Be7u2LV8FnIEvU73V3BPnwY2Y/Q8+Xyd
dWvs2aKYl8I9jP4o/HXI56ynpO7lSuwnxb5j5eoW5OXUM1azdQTZEzsGnV2F
/Kleij07a+FvQL8cfWPkO1Zva+Zq1qrHT+b88UXXhnpW3N7Edy2bBr61JnHv
6n7fhvsW8q34xLsc7M2i18NIq2Zt4tmnO7xIvY6Pdejvgk8Hvz52bSknqj3F
XDsa30hin/I1mb1G9XLRvduDNBX9TeKqxvT2qKfUS3qD3gBfmviuKtCrNFtT
5053XKbaiV1bc9i7W7Mx9exRTa9m3ZI6dtXY7awfzDx7NPOFTU48G8TRrCim
9iWf5cp94tifwd9t2N6aeRYoB1cq15nfrtaC3555Ra/1Bql2PsK+NHINbUs9
8zXrNWPawO5K/JbqjdwE/kfmt04z7Qf0D2PXumbGI7HfXL21mvn1rJ9gr73E
Nfdx4ppTrenMexPfme5Kb/ZUsFmpe0FvzE7OGsz8bfKhWagaVu1qJg4mrknV
oma0/hVOyvyW6Z9Bb+vfqWtXb6zepv7Ms1xvlGbB94nvTjNhrN6b0frTG/If
3y0f4g==
         "],
         VertexColors->None], 
        PolygonBox[{{2221, 2316, 841, 2082, 2220}, {2421, 2221, 2220, 2420, 
         931}},
         VertexColors->None]}]}, 
     {RGBColor[0.7526904929541466, 0.8310263711528191, 0.9138043870565348], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl2mIllUUx5933uV5nvcVAhdaZsqs0IpKTbKoIGiyL9kyWhSYe5FClEbh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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhvedeva51+gDRdSisdhQNSpWHBLkRbC8CFEKjRqgUBIjJkao
QxgMRQiDE+JAHygEEgpCsZooqBi0JBRBtDI5IYaggRZkMEEJEDHq9+fvw0r2
2mvY66zhX6dy6vS6Z7IhhBYoDx0ohvBlGsIwLv/kYmAphNeTEOZkQijn7nAM
4XEo5VyRC6ED2T70c+jWF0Lown4H1APfK3vkvehXobsCm0Pw7fj8Cd0T+GzH
9hI0RLrcJcg7sN8Nv0wxobuAu1uQVUOV6H4G3x/5FHxeRrcJ/hDn65FPgJ9Y
dDxL8T+Xt6+BJsN/zfu/iEe/hfNAbG7lvBX9H5Gv5r163lvC3fPYLsLfb+j/
CnUG2/xXFkIb+rOwbeRua+KYFEs5Ptqw34h8Ibr7Cs7lqsSxKKeDOF/ERwe6
T2PThu/V3L2BfDvyXMk50LcPLlh3KTrfZ23zPrK18Mfg8/D78f8Bd2WcC9Dt
8BnktZyfwv/dnDdD59Cfx911xHYl/DjOddB7nMug+9A9jc6C6G/St+zNutbf
ElO/Mte8H/ZJ9Lcohmr4AfAN6E9SA2G7Gz7BXyf8Kb2P/TG+ZTB3Fch3Ft0b
3aiPIN4HoJk55/Q15BXoF7PuuauiY1as46Eh6Nakzt2ojHNzmdg2552js9j+
i7wX2SzuO5EP524K79fx3kFk36XOlXJeQFZWcm+9GZybJt5blneO1hPPpb78
nMJ/O+eaxLMhvgLdl7gbmnWMy+Ev8O7Q0NcTRfuQ7mjklZzvSF0b6bQir4Kf
Cr8F+XTkfxc9C5OIbxvnz6EjeffkMOQ1Jc/aOezH8PZc5K3IV0GtyNdz18t7
R6HbVEvo7ax9SPZcdK9JZwPnuxLzJ7OeFdVUtdTMzIv+Rn1bFe/9TqwT0X+I
WG7kblPqmBWrcv4q+l/AX4vsIP4alXtoPrK3iHkRvhZDu5DdkHFu303ce8qx
eqEBvivnnjiBfCp0smAMuQLb0Jdv9fhOzl3Rs3gYfxt5a0PJtfwBm6vxdy/y
R7AdC9XCj4KasR+bMVa9w3sjC8asQvRMKJ570B+JrwehO5E14bOB89nEWCgb
1f68cphzTP3xPRy+Luc3P0H/DPwRbE+g36LehCrwt433S8hehPZge3+ub9YS
Y5FmTrUTZgmrVMPZiXtcvf2Eehxf/YvuLc2kcjOw6FlRPN3In4SWZwzw+vZ1
Rc+mcjAGX6NL9iXMTTgf5401wZj7KPzP0Vj/MvwI+D3wEX4a/M34yqfuDWHA
TvU6fGXeM7cmdY+rt1XT09GYICyoVk3Q/yf620cSw/7oHaHdIAz9kPPK6F4W
him28cSwsOAYm6N9yLYJ+Tj1U8m11455QfVO3GuqaQ/y49HYszLr3bG2ZKzW
DtEs7kjc25rJi6m/Wd+qHdXMt3RH98JK+AHIy1PXWjWvxbYf/MM5v/kxto3R
te8tePa+SV0LzdwW5B+VHIswUrtUGC9s1w57lvdmFP1twqRd2o1F71LNlLB7
UzS+aH7OY38g8SyoRkvgF0PTso7xKOf6xNipHTohcU+qFzXTn+J7fuLdo514
Btnp1LOimv6BbHLJs6ydWMPbF6JnRd/8VTQmCYu0A3qwfSUaC9TzK/B/E3dd
GWO2sGt0dC6FYcL+x0ruNe0AYcmgvv0qTJkm7Ey9y9XT6oWexLtaPTEzeuY1
68IYYYdqoNwLQ/am3onz+vJ7IDWmCku1Q2ck/qfQv4Rmfnv0DtHuUMxzojFT
WKmZnR1dc9VaOf5LuzXx7hQm/A8ubzBX
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.80726725, 0.8618830000000001, 0.894034], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH+M13Udxz/fn59f5RacIas0bLODtZJF1NTWxo+LldbmJQ4VFaxL1kaY
zXWmKdjUfhxbhsKdZ0plKYRYyEFJSYBek+O4q4ndcd2hq8RyFTtInSN7Pni+
GH+893593+/X+/1+/Xy+Xp/vjOVfvXxlNUmSOypJUtO8Pk2SK/IkuVu/ZzeT
5GaNcdGvZUnSVyZJq5hmVj23an63xvtFn635iHheyvx7ls69qfmExpWNJPm+
fjd0T5f4pmlto96ao/sOayzR/p56kkxof7XWe2rmv7zquSvoUfgL0w9ozBDf
NM3HU8uNzC2aP6SxVfd06NyXNF7R3YOJ54Oa1+jMO2p+71WtHY19+KGfSaxz
KZ6xiuVDBvT4rO5+WTJcULFub2i8LP4B6f2twmd6xfNs7r0DWh/M/N4WyT8m
+pfif0H0i6XtdKv2OjWWI5vOXSieGyTjYcnS0rQuG+rmaRc9Xftf19nHJE93
zfMi8T+rdx/Rer9kG9PaqEZF621aW6Rxk34PNb2ODC16a5rGh8W/SWeni35Y
9DmiD2d+96KG7fGkxgGd3aGxX2vj+r1Q9ETMbUF/OuihxIM9bI4c3IHfx+rW
jft3SP6ndd8t2q+I3tuwjrw1IPqGxPrwJvb5rvT4XukzD8rebZKzU2c7qo43
/PId0VOJPdGrxLdOd/0gsf32hQ2R4ULtPSL6HmK+9G/Wr21aPnQnftD/JvG8
pfeu1Z0/Lv0bmnjpiBgjVvbr/q9hB/F8UzwdWmvXPCk5F4jerLmh8Ymqz3D/
bvF/Tmv7Sscmby9t2lZztfYxjasky7y69UTHxcQJMV/zXcQLcUh+jEaOHCkc
T+xtEd9cjS9WbQdsij15B32xA7IPhPxziNvc741r3qG3poa8HWGTkYZt9GTE
ycUN63KOzt6ucZnOTtF992qe1Hv3N+0LfIJMx+qW+aDkHCr8+896Z0hnz4pz
zGDC8Yrv4p4rxDMhmbbXfB/3Ymfi+/64nxhYF+v4aEHE8Vdqjrn5op/QvLXm
+H8d7Cpso02im+Gju/XOPbn51geWgWN31X2efCGnftO0PbDv3PAJtroobHJJ
2Ie8Iz/IE/CKtU8Gz6De350bV5AT/eZE7oyEncmTZSH/eXXTu5BB+zubtk+f
ZD+S++yh0ph1QeQCPGu0/iOtP585v8gt8pr4JecORI73az9JHSeT+ELvbRHP
r7Q2kpseFt9g0++/S/vbKo5zMLIjcBIdsQ+68/5gyADm7607jzg7pW6ZRwOn
0Jl8PV/rz4nnf1XrjL5TGo5VYnZf3EOcMO8JeiTexQfEMfmzSWf/Kdlfy30v
eL26at3hHQo5uRebYB/mA0GDw9115w9Yxe/2wJYNsd4ZWMb6ItnwtsJnyNVB
zbOq9vO+8HWf7PmX3Pq3BPbg619rfUZum/ZXHXPE2+905zOZ7UGskUvE2wcL
5x5595To7YXjn/xeGvfu1Z2/zyxfr+SfX7ddbhfvZZltcVbYFBsOVO1nfPpb
7T8kvpPVM/7AF8i4M7WcYOSqwMZtmXEE23dpfr3puP2UYu/fue25smJsBn/A
F+KAt5BpfvirLt5W3Tuv5jhkpt6hF3jNWfqR3qp7EmoO9Ym6Q/9CH4M8xAU0
+NbaMKbwPr0Ldsfmb8cad/4DH6XWlVxBbmSmHwAHNldc1//UcC/xc2qyxqGG
8+O8yBH0Pj+17tu1vzyzrD8T3Z4Z58A2zkFz33DcSa7sjPz6vHgf1Zk/ht+u
rtk+8LJGTk0EFuA7zg7H+onQCVuvkSz10nq2BQ5Rux+TjX9SOofAUfCU+Hkz
+jlymX6M/gwMZO4OGnt2hk2Jv+7wETi6ObAUe4Gh91YsJ/7AF9j+7Ohz+gL7
wIENgbncD37f13C/CZ6f7unurFu+jqgxYBw6Ui+XhI/uk14fLU3Tx7FOfdwW
uMNb6LoqbPVfyTs7M5Zfr3PLSr9Nr0lMgdX0cUtKY8Wo/Pzx0vh4ndZf1eiJ
3AAL2sP+S0/XWXjlg7Xa2yj6odK4+3jp+kf+NUU3Stt1Zu1M3w0eEo/c+WW9
O5DbRutK53Yl9ncFzwe03124TjBuCbnA2JHoD5GDmX4D+5IP1MoFYW9o+m30
R/cVeuvG0viB3075T3t/1ftp6Ryil3o7Ym5Y9hhJbdsrM+vPm0Ol7YWtDoqe
nvod+qBq6l7oKtHnlq6f12n+V2qZqI34D9+BPWsy//5CaTl4+06tvacwhhHj
4C5xDg5ujJ72LtnnM6n7o0tKYyu4Rv0bix6JbwFoYhU/naqN+t1buAfFx8/r
7OLM3ze3le5pjgXejMfZFQ3XG36DDauzMzV0KPIdnSeCH9nvyCw/30xrw0fE
IDg3GLVpf3yn0L9vTl0jwJhXAmdma+3xzL1Wm3gW5v7m6Nf9zxX+BnqraYwG
o7bSb2b+hgAfFkY/jxyTUQ/2646bM+cy86NBL9RbnZnrVWvkC1j8t9S+wS8r
dPbG3Pm9VvPi1Hl/TeY4IAZ6RP9Qso1XjXHM3M87Palp8pN30PeF3N8w0MRL
V+qYeZDvrdR3YOPJ+MbsFM83wAStHdU7387dz5HD6Ah2gWfg8ilM0z1/iPq4
XvxvgFfxPUleYJ+j2p9MTVMjOyPXOD8ZdW5l/IbepXueLlzD6A1mRZwiy6GQ
B8wAO/A7Pe2JONunc1nqNerAaTv9tLCPb41eFWwA92aGP/DFO1PHK7EKHpwM
OcGhhwOL+H4dLvwNC9bujrhboP35pWP5Gu1fXRiDifM90cthU2oDGDstc19C
TXgpt7/x9S90xxOlcWg8agM+PSbe/xTu75C3N+J8WebayW++TVviG5/e+YHA
pZ3R+2PrqbljsT9s1hW5Q11CFmrKvKDx9Uy9eX1umlzCz+T+pZl7I37zPfdU
9FTgHfgBNtI3XhzfQn8X/3tTy0xc9ERsvC813vH7XL1zvGm/8R9GT2Ar/Sz5
T+7PFs9HctdC4uxk+Irv2q7TOjVdj/Hz8cx4NxB1kD6CON8RmE9e8z1EvBA/
1J8XM2PK/wEETYM8
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtln1olmUUxp/33fvued73KaEtMyFLDUIjypGZkP2jy40ojckmOkmnpS7B
iiJarQ8XTSuUMPFjzezDarrmWLGNsIjhcoHzZctSWmttQjnLPmSrlOjjd3H5
xwXn3Oc657nvc59z7mfa6ofLNiaDIHgVpMDdYRD8FQXBnLwgaAGpOAjywYx0
EGxMBMGqTBAMgAmQS3Fsg/8R/LXIB7GPIFeCiehT8T+aDYLPwSj8s2AKsbbh
cyfx7gC9xDoGtuC7C/5euI2gBv9/wFrkdWA+vjfAmYXvVJBDr4c/iG8HegH6
FaAP7nFwmrOcR5+OrQjOBrgLWPsVfTjy3q4ifj/cotD8C6zlsN0HTrC3y9Br
kOeCF4jVA38E/jBYk3SOHsR3EfY69F703/nWeewF+B9Dvwn7J+iD+LfyjWLs
K1nrVmzQhd4Y+tt/gPH8IGgg3hDxKhUv628otmKehP812EcuDrFWAfdH7JOQ
t+IzC7029tm1x4XoO9ATec7pLfiWw2/Pc04OE38z+qy093hXxnvU3p4Cr+C7
E84T+B6GU4W+MnbutqMXEb8w49w8AJYS6+XY3E7812Nbl/Hd7gbnkH8CR9n/
dL43BHccn3r0Es6+AdtDYA/cBlCGbQi9EG5xwrW0g7XitGuqQnu/dL8defad
zJ6a0o4xSvyLrA3h+xjxx7CNg96k4+kufs54L7qTvaHvRHdxEaTh/hn5bHPB
AeSDkWXVzG8Z37nueg36AfbXBI4oXsp7U046L+W7C/l61qqQr8OeQ14B//mU
e+h79I/VUwnfkXK/C7SmfAedoWteta6cPI2tlP3sQd4NPov8DcX+F/43yAvJ
waPko479PRI6J8rF/XyjW/WEfmO+z6zcrop9t8rxaeJNYa2BWNOwn1G9gRyx
Gllr5/sd4CX1KvG2hu5x9fa8tHt9BfydSff8gHobezNyGWu3I38IpyXhmRIg
78+69laj3oZ9NlgGfznoi5xj5XYCnCT845F7VT34FfLloXuhkLVu5Hmxc6Ga
q8O+JPTdK8dPxq451Zr21IW9BBxJu2fexP4W6EXvgX8K2xn8E8TbBq5B7sl6
tikn32kewZkdeCbVav6F9tUdncD2PvFOEq+A+F+g90Q+66akZ1cu67tQfb0L
tz/y3X2JTztyim/Mxz4G/wKxr814VixIeRYsjbw3zYRy/H9g7b+Ee/wstlHQ
F/hO18eOId9G7L9gOwdm4DtT9Y99EahJ+w1YoFxgj7FVp52LVtYG086JuDqj
ziafUvSS2LWhGtzD2f7O9yxWD7zI3utBa57n2bdwB2LXhu58cugaVO2phl7D
fztoTnhG3gp3Tuza0NoyybFrr41vtGl2Z/yWqYefxfeeyLnWGZpDc2TTTK3M
egao99WTmh3Fsc+qGTID+yT49yZ9B7XI1RnPtjT2C5zt08hvl3p2LPSM02xT
zsvhVmT8dmnmLVE9x67lLfg8jjwz67dVM2yx+jXr3Nyc8FuknEnXm9SA/fXI
b6/e0E2RZ6bqWz2lWtaM0GxQTe8j/huxZ5Vq+h3kt2PPAs2sHPLVod+qiey5
Cf292HtTze5HXhy5FvtBFLrn1GuaAXo7xZFNb+gwex3JeDarJzqwVUWeHaqx
5yLXtGpZM/mZyDlVLpXjEH5d6H8P1fAh9JbYdzuQ9r+G9qy96p/jlHor9r+C
Ztpy7B/E5qpG9S9RHbvW9U+xmb1dmXFuVYP/A+ZcQRs=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8608307500000001, 0.879745, 0.8700376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMVdUVxs99nDnn3sOAtUUZEhqMDklTmthasdo/CikVSxMHCAwyUGpa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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlltsVVUQhnfP2Yezz95WQK2BJqBE+2CMCREReYJGuVgMt7QFW4NEwcCL
JhSVW2KUS4UKLVSpcrFoYowFwVRoiVHDrQ8taYtAS1tQC/pQXixGEH1Bvz8/
D5PMrH9m1l6z1vyzJ7zyxsLXU0EQ1CMhcj4Kglw2CLaxODodBNOxq+IgqANs
zQTB6VwQVCA1eUHwN/ho8EnIcvyLsYfBpiVB8Cq+RcSMxW4i3x/gpeAD6Avx
r8Yehd2DPpK1WuwC7P3s9QNrz/EtrYoH6ybfmBFBcJK1brCQtS345+Nfiv0r
9gNpf/ND7NeP5BO7hLUFkffUXoopxH6TfHXY87D7sAvAl2EXIkfZfz32I3z/
BXI04LsbKWPvNtZWoK9E3gd7IuW9mvGvzHjPk+Q7jd1GfdaBT0Qvx2czuQfJ
sZb83+EzGX03/uPJVYFsVTz+j4IfBS8CrwBvRv8mcv1uIAezrqlqOZxybXuw
c6F9viDXPPw3o4/EZzH6kGLSrvFFfJ/B/hw9Cp17Cvatu/Ep9DPkuMP3VPEN
l9B7kNvEP84dDBLfQswtfB8MXfsy7JqU7+Bn4aw159mnhthtyCzsw6HfTiXy
QdpvaCaxezlzC9gp9uzA/hT/TvQcPltVa6QF3+Os7UPfi7Rjt2PvQN+OzOBb
v8dehV6FVJKvlvjV5P6W7zmM/07WDoC1YafAuvAvQd+Ycy2L8HmZ/c/hU8hZ
H2atHn0X8iPYCfwnoz+NLEZvJEcZsQ3kuJn2HZcT3wF+D/EB8a2Je0S9cZ2Y
ZegrkS/ByliLs+4BvX3VMJN1D6r31CPKlc/arsA5L4Hdq/vDHoPPYfBDSD2+
l8lfDraDbzqW55pH2C3U4GLoHOfRjyf+lsaUzzou697SmVeQ/wXs4Yy/8ULs
GPnqjWwi9xB2LJz8a9CfjfyWP0Kuka9EfEC++eRrJdcvxHSm/CbOoJ9A5mf8
pp7E9z5ylITmkPfABrHT4IfA50TOqVy683TWHKDe34j/i2BXsMel3UPXiJ2D
TzX5Quxz2N3IVPUPa6vxH4v/XOylofc+lTOX6Rs2YM+O3Lt6I6rl1Zzfumpa
BH5/5N7UG9PbWsdaQ+g3Ju6YxR6rMuaQG2B/xubCcvCbnGN8ztxRQI0a8d2P
vJPym+/Hty82Ny1AXot9Jp1FnPMP8Q2xe0kcqd5uIr4v4x5v1nuPXZtF6jn0
I8hZ/OtSrn1X7FroDqYT/xbxTej/KmfkO9Vd6kyX0QfAp7Hvf6Fr25uYC1Tj
q+C3I/eO7uwy2FOJe0Mx6u19sblcPf524jPqbNpzIPYeyn0HmZo1R4mbxBFL
0R+LfVc703d7DZmQcs+dJd+iyL02coS5c1PiWSUO3YJenZg7xLnitrmR70Ic
Nxt7pvohz3d2MHHNVCvVVG/r68S9pTem3tOe2ks9OIi+JGeu0UzRrCyOzDWa
mVPAB3L+ds2Iv4gfUr3SPoPu/rPEXKQ3cAW9I+u7K2aP5/Hdk5jrNIPejTzj
NNvUU3rbG8CPZPzGNStfwmd9nmfmsdgzTbNMHLAGfG3iWqsHJonfwL8KzWkT
I/egek85K7CPJOYacUwPvr2x30op+KisZ6hmp96YZr84XNytf4B6fPdEfuva
4/fYORSbQa5H5lxxrWrSnnUNdHZxSK1mdWJu1wwQN/0WO1YctT3rGarZqTPP
UO0Tc7VmQj/4T5Fnoe54eWQOFvdqBn6M7yeJZ7s4XrP7w8SzSDO8N2fOE9dp
xnYR2xl5NmrG/g+xmEAq
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.91439425, 0.8976069999999999, 0.8460412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl0tsVVUUhnd77z339B4EKwEFhQRQiwVCQokFbBCj8tZEQKmaODDKY6IJ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         "],
         VertexColors->None], 
        PolygonBox[{{2117, 2240, 767, 632}, {2676, 2113, 626, 756}, {3020, 
         1807, 149, 1553}, {2152, 3043, 1621, 295}, {2121, 2242, 771, 636}, {
         3016, 1801, 133, 1543}, {2958, 2956, 631, 1469}, {2681, 2115, 628, 
         761}, {3013, 1796, 117, 1536}, {3041, 2099, 580, 1614}, {2737, 1894, 
         1299, 1232}, {2738, 2737, 1232, 1233}, {1849, 2395, 907, 240}, {2242,
          2966, 1478, 771}, {2136, 3020, 1553, 514}, {1982, 2962, 1473, 
         768}, {1978, 2952, 1466, 762}, {2240, 2957, 1469, 767}, {2399, 2933, 
         1449, 583}, {2597, 2931, 1447, 582}, {2499, 2498, 267, 907}, {2251, 
         2122, 640, 778}, {2775, 2776, 1276, 1275}, {1990, 2971, 1482, 772}, {
         2116, 2682, 756, 628}, {2123, 1990, 772, 640}, {2929, 2398, 1611, 
         1446}, {1808, 2735, 1226, 165}, {2074, 2775, 1275, 1449}, {2935, 
         2934, 266, 1276}, {2959, 1978, 762, 1470}, {2987, 2986, 514, 1226}, {
         2930, 2929, 1446, 1447}, {2968, 1982, 768, 1479}, {2950, 2234, 761, 
         1465}, {2967, 2965, 635, 1478}, {2098, 3041, 1614, 267}, {3026, 1848,
          240, 1571}, {1856, 2774, 1272, 266}, {2788, 2787, 295, 1272}, {2999,
          3000, 1268, 580}, {3014, 2130, 490, 1539}, {2953, 2949, 629, 
         1466}, {1894, 1994, 468, 1299}, {2963, 2961, 632, 1473}, {2972, 2970,
          636, 1482}, {1993, 2251, 778, 468}, {3017, 2133, 502, 1546}, {3043, 
         2153, 673, 1621}, {2771, 1847, 239, 1268}, {2956, 2960, 1470, 631}, {
         1802, 3017, 1546, 149}, {2596, 2067, 582, 754}, {2149, 3026, 1571, 
         673}, {2965, 2969, 1479, 635}, {2112, 2948, 754, 626}, {3040, 2399, 
         583, 1611}, {2949, 2951, 1465, 629}, {2132, 3016, 1543, 502}, {2129, 
         3013, 1536, 490}, {1797, 3014, 1539, 133}, {1795, 2739, 1233, 117}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1813, 2264, 1808, 2735, 2734, 2987, 2986, 2024, 2136, 3020, 
         1807, 2261, 1802, 3017, 2133, 2015, 2132, 3016, 1801, 2258, 1797, 
         3014, 2130, 2010, 2129, 3013, 1796, 2255, 1795, 2739, 2738, 2737, 
         1894, 1994, 3036, 1993, 2251, 2122, 3042, 2123, 1990, 2971, 2972, 
         2970, 2121, 2242, 2966, 2967, 2965, 2969, 2968, 1982, 2962, 2963, 
         2961, 2117, 2240, 2957, 2958, 2956, 2960, 2959, 1978, 2952, 2953, 
         2949, 2951, 2950, 2234, 2681, 2115, 2680, 2116, 2682, 1971, 2676, 
         2113, 2675, 2112, 2948, 2228, 2596, 2067, 2597, 2931, 2930, 2929, 
         2398, 3040, 2399, 2933, 2074, 2775, 2776, 2777, 2935, 2934, 1856, 
         2774, 2773, 2788, 2787, 1868, 2152, 3043, 2153, 2148, 2149, 3026, 
         1848, 2516, 1849, 2395, 2394, 2499, 2498, 2578, 2098, 3041, 2099, 
         2065, 2999, 3000, 2770, 2771, 1847, 2224, 2226}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1824, 1840, 2390, 2389, 1943, 2036, 3038, 2035, 2280, 2281, 
         2143, 3024, 1821, 2274, 1817, 3023, 2140, 1934, 2845, 1933, 2846, 
         2906, 2905, 2268, 2989, 2990, 2988, 2138, 2991, 2023, 2263, 1806, 
         3019, 2135, 2022, 2134, 3018, 1805, 2260, 1800, 2742, 2741, 2740, 
         1915, 2887, 2888, 2886, 2009, 2257, 2981, 2127, 2980, 2128, 2254, 
         2253, 1794, 3012, 2126, 1893, 2800, 2801, 2544, 2543, 2879, 2250, 
         2974, 2975, 2973, 2977, 2976, 1989, 2684, 2120, 2683, 2119, 2241, 
         1987, 2964, 2118, 2715, 2716, 2717, 2237, 1784, 2711, 2710, 2955, 
         2954, 1879, 2352, 1878, 2446, 2529, 2528, 2230, 2525, 1974, 2524, 
         1975, 2526, 1874, 2177, 2335, 2521, 1970, 2871, 2522, 2400, 2601, 
         2932, 2073, 2410, 2411, 2936, 2937, 2778, 2779, 3034, 3035, 2868, 
         2869, 2870, 2867, 2706, 2707, 2202, 1780, 2334, 2040, 2920, 2921, 
         2663, 2662, 2786, 1867, 3030, 3031, 3029, 2500, 2496, 2766, 2765, 
         2768, 2767, 2940, 2096, 2434, 2784, 2785, 2295, 1866, 2435, 2225, 
         1963, 2329, 1962, 2517, 2518, 2436, 2792, 1871}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2285, 2284, 2998, 2145, 2997, 2146, 2279, 2278, 1820, 2759, 
         2758, 2757, 1940, 2912, 2913, 2911, 2030, 2272, 2273, 2139, 3022, 
         1816, 2267, 1812, 1836, 2748, 2747, 1927, 2901, 2021, 2900, 2020, 
         2823, 1922, 2820, 2822, 2821, 2894, 2259, 2983, 2984, 2982, 2131, 
         2985, 2008, 2256, 2729, 2728, 2979, 2978, 1905, 2811, 1904, 3048, 
         2553, 2884, 2883, 2252, 2686, 2124, 2685, 2125, 2248, 2247, 1792, 
         2724, 2374, 2373, 2372, 1887, 2539, 2540, 2538, 1988, 2876, 2238, 
         2239, 1985, 2339, 2713, 1787, 2189, 1783, 1826, 2353, 2351, 1877, 
         2527, 1977, 2337, 1976, 2178, 1875, 2291, 2292, 2176, 2587, 2175, 
         2229, 2308, 2600, 2071, 2599, 2072, 2173, 2172, 2409, 2408, 2407, 
         2508, 2507, 2163, 2213, 1946, 2203, 1969, 2227, 2100, 2510, 2652, 
         2651, 1949, 2497, 1948, 2501, 2769, 1841, 2217, 2218, 2054, 2219, 
         2053, 2294, 2097, 2323, 1861, 2169, 2104, 2437, 2438, 2439, 2324, 
         2327}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2108, 2325, 2102, 2326, 2167, 2168, 2694, 2693, 1862, 2421, 
         2221, 2316, 1958, 2296, 1957, 2580, 2581, 2424, 2055, 2579, 2209, 
         2210, 1965, 2511, 1964, 2865, 1850, 2513, 1966, 2512, 2515, 2514, 
         1951, 2299, 1950, 2211, 1842, 2215, 2170, 2171, 2059, 2300, 1873, 
         2174, 2111, 2672, 2674, 2673, 2062, 2586, 2063, 2588, 2048, 2572, 
         2049, 2349, 2350, 1825, 1781, 2181, 1782, 2708, 2338, 1981, 2186, 
         2185, 2533, 2534, 2453, 1883, 2359, 1884, 2537, 1986, 2340, 2714, 
         2463, 1886, 2369, 2370, 2371, 2723, 1791, 2243, 2244, 2002, 2547, 
         2001, 2548, 2249, 2882, 2551, 2552, 2473, 2810, 1903, 2474, 2007, 
         2558, 3053, 1913, 2816, 1914, 2892, 2893, 2732, 1799, 2819, 1921, 
         2743, 2744, 1834, 1804, 2262, 1811, 3021, 2137, 2266, 2265, 2903, 
         2904, 2843, 1931, 2842, 1932, 2844, 2028, 2909, 2029, 2910, 1939, 
         2754, 2755, 2756, 1819, 2276, 2277, 2144, 2994, 2996, 2995, 2282, 
         2283}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2705, 2654, 2101, 2640, 2103, 2658, 2938, 2618, 2696, 2695, 
         2420, 2220, 2082, 2315, 2166, 2628, 2083, 2423, 2425, 2426, 2287, 
         1863, 2783, 2422, 2625, 2624, 1947, 2330, 2331, 2208, 2207, 1864, 
         2212, 2926, 2927, 2582, 2584, 2583, 1961, 2689, 2690, 2687, 2147, 
         2688, 2301, 2429, 2428, 2427, 2091, 2636, 3044, 1852, 3028, 2401, 
         3027, 2402, 2391, 2392, 1845, 2290, 1846, 2393, 2233, 1973, 2573, 
         2336, 2182, 1876, 2236, 2157, 2158, 2709, 2450, 1882, 2358, 2360, 
         1828, 1786, 2459, 2460, 2367, 2368, 1831, 1790, 2191, 1793, 2727, 
         2341, 1999, 2246, 2245, 2881, 2549, 2550, 2471, 2809, 1902, 2472, 
         2006, 2557, 3052, 1911, 2815, 1912, 2480, 2014, 2889, 2891, 2890, 
         1920, 2383, 2384, 2385, 2733, 2490, 1926, 2386, 2387, 2388, 1810, 
         2840, 2841, 2752, 2753, 1837, 1815, 2270, 2271, 2142, 2992, 2141, 
         2993, 2275, 2918, 2854, 2855, 2853, 2857, 2856, 2919}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1779, 2653, 2655, 2639, 2657, 2656, 2081, 2617, 2619, 2614, 
         2616, 2615, 1858, 2626, 2627, 2607, 2630, 2629, 2038, 2622, 2623, 
         2343, 2621, 2620, 2206, 3007, 3008, 2698, 2700, 2699, 2084, 2633, 
         2086, 2631, 2085, 2632, 1860, 2939, 2089, 2634, 2090, 2635, 2041, 
         2320, 2088, 2328, 2087, 2319, 2309, 2304, 2305, 2154, 2307, 2306, 
         2046, 2591, 2592, 2347, 2590, 2589, 2232, 2179, 2180, 2050, 2184, 
         3009, 2183, 2532, 2448, 3010, 2449, 2355, 2452, 2451, 2536, 2457, 
         2458, 2364, 2462, 2461, 2878, 2541, 3063, 2542, 2799, 2798, 1892, 
         2467, 2000, 2546, 3047, 1900, 2808, 1901, 2470, 2005, 2556, 3051, 
         1909, 2814, 1910, 2479, 2013, 2561, 3055, 1918, 2818, 1919, 2485, 
         2019, 2563, 3057, 1924, 2832, 1925, 2489, 2025, 2565, 3058, 1929, 
         2839, 1930, 2491, 2027, 2566, 3059, 1937, 2849, 1938, 2492, 2034, 
         2915, 2917, 2916, 1942, 2762, 2763, 2764, 1823}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1822, 1839, 2761, 2760, 2852, 2851, 1818, 1838, 2032, 2914, 
         2033, 2197, 2196, 2908, 2837, 2838, 2834, 2836, 2835, 2902, 2830, 
         2831, 2827, 2829, 2828, 2899, 2483, 2484, 2482, 2817, 1917, 3054, 
         2560, 2012, 2478, 1908, 2813, 1907, 3050, 2555, 2004, 2469, 1899, 
         2807, 1898, 3046, 2545, 1998, 2466, 1891, 2378, 1890, 2721, 3061, 
         1992, 2877, 2722, 2366, 2365, 2363, 1885, 2456, 2712, 2357, 2356, 
         2354, 1881, 2447, 2577, 2923, 2052, 2576, 2051, 2922, 2293, 2406, 
         2405, 2403, 2068, 2598, 2114, 2677, 2679, 2678, 2348, 2346, 2047, 
         2571, 2045, 2302, 2061, 2333, 2060, 2928, 2585, 2702, 2701, 2155, 
         2671, 2110, 2670, 2109, 2947, 2288, 2782, 2781, 2419, 2079, 2612, 
         2418, 2200, 1944, 2317, 2318, 2199, 2697, 2198, 1778, 2345, 2344, 
         2342, 2039, 2570, 2037, 2609, 2077, 2606, 2076, 2608, 1857, 2646, 
         2094, 2613, 2649, 2648, 2080, 2644, 2645, 2638, 2642, 2641, 2659}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2105, 2643, 2092, 2637, 2093, 2314, 2660, 2313, 2433, 2432, 
         2430, 2095, 2647, 2165, 2610, 2611, 2417, 2780, 1859, 2286, 2569, 
         2519, 2520, 2415, 1968, 2201, 1945, 2298, 2161, 2162, 2223, 2222, 
         3001, 2150, 2691, 2151, 2692, 2078, 3005, 3006, 3002, 3004, 3003, 
         2312, 2303, 1851, 2397, 2396, 2066, 2164, 1843, 2505, 1844, 3025, 
         2504, 2859, 2858, 2862, 2861, 2860, 2412, 3032, 2772, 2413, 2863, 
         2864, 1954, 2506, 2404, 2668, 2669, 2443, 2793, 2311, 2070, 2332, 
         2069, 2310, 2235, 2187, 2188, 1984, 2535, 1983, 2874, 1827, 1785, 
         2454, 2455, 2361, 2362, 1830, 2720, 2719, 2465, 1889, 2377, 2379, 
         2380, 2726, 2880, 1997, 3062, 2725, 1896, 2806, 1897, 2468, 2003, 
         2554, 3049, 1906, 2812, 2475, 2477, 2476, 2559, 2193, 2194, 2018, 
         2898, 2017, 1833, 1803, 2825, 2826, 2745, 2746, 1835, 1809, 2833, 
         1928, 2749, 2750, 2751, 1814, 2736, 2026, 2907, 1935, 2847, 1936, 
         2848, 2031, 2567, 3060, 1941, 2850, 2493, 2495, 2494, 2568}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2269, 2195, 2564, 2487, 2488, 2486, 2824, 1923, 3056, 2562, 
         2016, 2895, 2897, 2896, 2382, 2381, 1916, 2481, 2730, 2731, 1832, 
         2160, 2011, 3015, 1798, 2192, 2885, 2804, 2805, 2802, 1895, 2803, 
         1995, 3037, 1996, 2376, 2375, 1888, 2464, 2718, 1789, 1829, 2159, 
         1991, 3011, 1788, 2190, 2875, 2796, 2797, 2794, 1880, 2795, 1979, 
         2530, 1980, 2531, 2575, 2574, 2666, 2667, 2665, 2664, 2442, 1872, 
         2444, 2445, 2704, 2703, 2156, 2044, 3039, 2043, 2289, 2042, 2946, 
         2107, 2943, 2945, 2944, 1853, 2231, 2872, 2873, 2523, 1972, 2205, 
         2204, 2214, 1953, 2866, 1967, 2789, 2790, 1869, 2791, 1870, 2502, 
         3045, 2503, 3065, 3064, 1952, 2925, 2058, 2924, 2057, 2297, 2056, 
         2605, 2075, 2602, 2604, 2603, 1854, 2509, 1855, 2416, 2414, 1955, 
         1960, 3033, 1959, 2216, 1956, 2595, 2064, 2431, 2594, 2593, 2650, 
         1865, 2941, 2942, 2661, 2106, 2322, 2321, 2441, 2440}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{-2, 5}, {
      Rational[1, 10], 3}}, {{-2, 5}, {0.1, 3}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->416079507]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14489],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->30412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"ExtremeValueDistribution", "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", 
     RowBox[{"\[Beta]", ">", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14855],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149973785]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7093],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev", "=", 
  RowBox[{"ExpectedValue", "[", 
   RowBox[{
    RowBox[{"x", "^", "4"}], ",", 
    RowBox[{"ExtremeValueDistribution", "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25402],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Alpha]", "4"], "+", 
  RowBox[{"4", " ", "EulerGamma", " ", 
   SuperscriptBox["\[Alpha]", "3"], " ", "\[Beta]"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"6", " ", 
      SuperscriptBox["EulerGamma", "2"]}], "+", 
     SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
   SuperscriptBox["\[Alpha]", "2"], " ", 
   SuperscriptBox["\[Beta]", "2"]}], "+", 
  RowBox[{"2", " ", "\[Alpha]", " ", 
   SuperscriptBox["\[Beta]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["EulerGamma", "3"]}], "+", 
     RowBox[{"EulerGamma", " ", 
      SuperscriptBox["\[Pi]", "2"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "20"], " ", 
   SuperscriptBox["\[Beta]", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"20", " ", 
      SuperscriptBox["EulerGamma", "4"]}], "+", 
     RowBox[{"20", " ", 
      SuperscriptBox["EulerGamma", "2"], " ", 
      SuperscriptBox["\[Pi]", "2"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["\[Pi]", "4"]}], "+", 
     RowBox[{"160", " ", "EulerGamma", " ", 
      RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{471, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195984336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"CharacteristicFunction", "[", 
     RowBox[{
      RowBox[{"ExtremeValueDistribution", "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "t"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "4"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"t", "->", "0"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13543],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Alpha]", "4"], "+", 
  RowBox[{"4", " ", "EulerGamma", " ", 
   SuperscriptBox["\[Alpha]", "3"], " ", "\[Beta]"}], "+", 
  RowBox[{
   SuperscriptBox["EulerGamma", "4"], " ", 
   SuperscriptBox["\[Beta]", "4"]}], "+", 
  RowBox[{
   SuperscriptBox["EulerGamma", "2"], " ", 
   SuperscriptBox["\[Pi]", "2"], " ", 
   SuperscriptBox["\[Beta]", "4"]}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["\[Pi]", "4"], " ", 
    SuperscriptBox["\[Beta]", "4"]}], "20"], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["\[Alpha]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["EulerGamma", "2"]}], " ", 
      SuperscriptBox["\[Beta]", "2"]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}], "6"]}], ")"}]}], "-", 
  RowBox[{"4", " ", "EulerGamma", " ", 
   SuperscriptBox["\[Beta]", "4"], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"2", ",", "1"}], "]"}]}], "+", 
  RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Alpha]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SuperscriptBox["EulerGamma", "3"], " ", 
      SuperscriptBox["\[Beta]", "3"]}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "EulerGamma", " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["\[Beta]", "3"]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Beta]", "3"], " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"2", ",", "1"}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{474, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484058548]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ev", "==", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6266],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->197517827]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63845401],

Cell[TextData[{
 "The negative of an extreme value random variable follows a ",
 Cell[BoxData[
  ButtonBox["GumbelDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GumbelDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->77807631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"-", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6920919],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{"a", "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{"a", "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{68, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259237143]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->465489791],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{"a", "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{"a", "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{68, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->114635764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202447451],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExtremeValueDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFormula"],
 " is exponentially related to ",
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 " :"
}], "ExampleText",
 CellID->28196863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}], ",", 
   RowBox[{"-", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90830430],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85082193]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"WeibullDistribution", "[", 
     RowBox[{"1", ",", "1"}], "]"}], ",", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "/", "b"}], "]"}]}], "]"}], 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "/", "b"}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->219525460],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->769816911]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19472],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExtremeValueDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " is not a real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->23407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ExtremeValueDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "I"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22494],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtremeValueDistribution", "::", "\<\"realparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
real.\"\>"}]], "Message", "MSG",
 CellID->45068132],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ExtremeValueDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "\[ImaginaryI]"}], ",", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{274, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->792737362]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExtremeValueDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFormula"],
 " is not defined when \[Beta] is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->20383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ExtremeValueDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14262],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtremeValueDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-1\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->206535427],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ExtremeValueDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Output",
 ImageSize->{261, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256285475]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Rule]", "I"}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", "3"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", "+", 
  RowBox[{"3", " ", "EulerGamma"}]}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84768749]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16339],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GumbelDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GumbelDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeibullDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeibullDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29427]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10819],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->22837431],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->108692505],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->112805847],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->42831500]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExtremeValueDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 5.6545520}", "context" -> "System`", 
    "keywords" -> {
     "extreme-value distribution", "Fisher-Tippett distribution", 
      "log\\[Hyphen]Weibull distribution"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ExtremeValueDistribution[\\[Alpha], \\[Beta]] represents an extreme \
value distribution with location parameter \\[Alpha] and scale parameter \
\\[Beta].", "synonyms" -> {"extreme value distribution"}, "title" -> 
    "ExtremeValueDistribution", "type" -> "Symbol", "uri" -> 
    "ref/ExtremeValueDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8206, 254, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->183695755]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 128853, 2854}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2488, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3111, 86, 1589, 37, 70, "ObjectNameGrid"],
Cell[4703, 125, 792, 24, 70, "Usage",
 CellID->26068]
}, Open  ]],
Cell[CellGroupData[{
Cell[5532, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6010, 171, 198, 5, 70, "Notes",
 CellID->53261241],
Cell[6211, 178, 702, 24, 70, "Notes",
 CellID->429991538],
Cell[6916, 204, 542, 17, 70, "Notes",
 CellID->12600],
Cell[7461, 223, 708, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[8206, 254, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->183695755],
Cell[CellGroupData[{
Cell[8591, 268, 148, 5, 70, "ExampleSection",
 CellID->112836020],
Cell[8742, 275, 278, 6, 70, "ExampleText",
 CellID->2554],
Cell[CellGroupData[{
Cell[9045, 285, 183, 5, 28, "Input",
 CellID->1988],
Cell[9231, 292, 226, 7, 36, "Output",
 CellID->299887955]
}, Open  ]],
Cell[CellGroupData[{
Cell[9494, 304, 188, 5, 28, "Input",
 CellID->16798],
Cell[9685, 311, 261, 9, 54, "Output",
 CellID->146289393]
}, Open  ]],
Cell[9961, 323, 121, 3, 70, "ExampleDelimiter",
 CellID->19002],
Cell[10085, 328, 253, 6, 70, "ExampleText",
 CellID->16321],
Cell[CellGroupData[{
Cell[10363, 338, 208, 6, 70, "Input",
 CellID->30104],
Cell[10574, 346, 484, 17, 70, "Output",
 CellID->188442532]
}, Open  ]],
Cell[CellGroupData[{
Cell[11095, 368, 335, 11, 28, "Input",
 CellID->7056],
Cell[11433, 381, 3352, 59, 173, "Output",
 Evaluatable->False,
 CellID->720254086]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14834, 446, 216, 7, 70, "ExampleSection",
 CellID->17708],
Cell[15053, 455, 266, 8, 70, "ExampleText",
 CellID->19761],
Cell[CellGroupData[{
Cell[15344, 467, 201, 6, 70, "Input",
 CellID->6533],
Cell[15548, 475, 362, 9, 36, "Output",
 CellID->435684073]
}, Open  ]],
Cell[15925, 487, 121, 3, 70, "ExampleDelimiter",
 CellID->14804],
Cell[16049, 492, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[16173, 499, 188, 5, 70, "Input",
 CellID->26385],
Cell[16364, 506, 283, 10, 57, "Output",
 CellID->216330]
}, Open  ]],
Cell[CellGroupData[{
Cell[16684, 521, 188, 5, 70, "Input",
 CellID->17260],
Cell[16875, 528, 179, 6, 51, "Output",
 CellID->407283160]
}, Open  ]],
Cell[17069, 537, 121, 3, 70, "ExampleDelimiter",
 CellID->31620],
Cell[17193, 542, 221, 5, 70, "ExampleText",
 CellID->4343],
Cell[CellGroupData[{
Cell[17439, 551, 251, 7, 70, "Input",
 CellID->9578],
Cell[17693, 560, 916, 29, 51, "Output",
 CellID->47738070]
}, Open  ]],
Cell[18624, 592, 119, 3, 70, "ExampleDelimiter",
 CellID->113],
Cell[18746, 597, 382, 13, 70, "ExampleText",
 CellID->13063],
Cell[CellGroupData[{
Cell[19153, 614, 212, 6, 70, "Input",
 CellID->4591],
Cell[19368, 622, 302, 10, 53, "Output",
 CellID->1110938]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19719, 638, 223, 7, 70, "ExampleSection",
 CellID->29761],
Cell[19945, 647, 259, 7, 70, "ExampleText",
 CellID->13370],
Cell[CellGroupData[{
Cell[20229, 658, 336, 11, 70, "Input",
 CellID->26124],
Cell[20568, 671, 2795, 50, 70, "Output",
 Evaluatable->False,
 CellID->116753588]
}, Open  ]],
Cell[23378, 724, 120, 3, 70, "ExampleDelimiter",
 CellID->8007],
Cell[23501, 729, 361, 13, 70, "ExampleText",
 CellID->17584],
Cell[CellGroupData[{
Cell[23887, 746, 451, 14, 70, "Input",
 CellID->10951],
Cell[24341, 762, 87390, 1465, 70, "Output",
 CellID->416079507]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[111780, 2233, 233, 7, 70, "ExampleSection",
 CellID->14489],
Cell[112016, 2242, 229, 5, 70, "ExampleText",
 CellID->30412],
Cell[CellGroupData[{
Cell[112270, 2251, 476, 14, 70, "Input",
 CellID->14855],
Cell[112749, 2267, 158, 5, 36, "Output",
 CellID->149973785]
}, Open  ]],
Cell[112922, 2275, 120, 3, 70, "ExampleDelimiter",
 CellID->7093],
Cell[113045, 2280, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[113304, 2290, 284, 9, 70, "Input",
 CellID->25402],
Cell[113591, 2301, 1368, 41, 88, "Output",
 CellID->195984336]
}, Open  ]],
Cell[CellGroupData[{
Cell[114996, 2347, 413, 13, 70, "Input",
 CellID->13543],
Cell[115412, 2362, 1773, 51, 99, "Output",
 CellID->484058548]
}, Open  ]],
Cell[CellGroupData[{
Cell[117222, 2418, 128, 4, 70, "Input",
 CellID->6266],
Cell[117353, 2424, 161, 5, 36, "Output",
 CellID->197517827]
}, Open  ]],
Cell[117529, 2432, 124, 3, 70, "ExampleDelimiter",
 CellID->63845401],
Cell[117656, 2437, 261, 8, 70, "ExampleText",
 CellID->77807631],
Cell[CellGroupData[{
Cell[117942, 2449, 216, 7, 70, "Input",
 CellID->6920919],
Cell[118161, 2458, 403, 14, 65, "Output",
 CellID->259237143]
}, Open  ]],
Cell[CellGroupData[{
Cell[118601, 2477, 214, 7, 70, "Input",
 CellID->465489791],
Cell[118818, 2486, 403, 14, 65, "Output",
 CellID->114635764]
}, Open  ]],
Cell[119236, 2503, 125, 3, 70, "ExampleDelimiter",
 CellID->202447451],
Cell[119364, 2508, 385, 12, 70, "ExampleText",
 CellID->28196863],
Cell[CellGroupData[{
Cell[119774, 2524, 238, 8, 70, "Input",
 CellID->90830430],
Cell[120015, 2534, 448, 16, 65, "Output",
 CellID->85082193]
}, Open  ]],
Cell[CellGroupData[{
Cell[120500, 2555, 497, 18, 70, "Input",
 CellID->219525460],
Cell[121000, 2575, 449, 16, 65, "Output",
 CellID->769816911]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[121498, 2597, 327, 9, 70, "ExampleSection",
 CellID->19472],
Cell[121828, 2608, 454, 14, 70, "ExampleText",
 CellID->23407],
Cell[CellGroupData[{
Cell[122307, 2626, 196, 6, 70, "Input",
 CellID->22494],
Cell[122506, 2634, 216, 5, 70, "Message",
 CellID->45068132],
Cell[122725, 2641, 301, 9, 36, "Output",
 CellID->792737362]
}, Open  ]],
Cell[123041, 2653, 401, 11, 70, "ExampleText",
 CellID->20383],
Cell[CellGroupData[{
Cell[123467, 2668, 191, 6, 70, "Input",
 CellID->14262],
Cell[123661, 2676, 205, 5, 70, "Message",
 CellID->206535427],
Cell[123869, 2683, 284, 9, 36, "Output",
 CellID->256285475]
}, Open  ]],
Cell[124168, 2695, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[124292, 2700, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[124598, 2712, 332, 10, 70, "Input",
 CellID->25838],
Cell[124933, 2724, 224, 7, 36, "Output",
 CellID->84768749]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[125218, 2738, 311, 9, 70, "SeeAlsoSection",
 CellID->16339],
Cell[125532, 2749, 493, 17, 70, "SeeAlso",
 CellID->29427]
}, Open  ]],
Cell[CellGroupData[{
Cell[126062, 2771, 314, 9, 70, "TutorialsSection",
 CellID->10819],
Cell[126379, 2782, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[126573, 2790, 299, 8, 70, "MoreAboutSection"],
Cell[126875, 2800, 183, 4, 70, "MoreAbout",
 CellID->22837431],
Cell[127061, 2806, 165, 3, 70, "MoreAbout",
 CellID->108692505],
Cell[127229, 2811, 161, 3, 70, "MoreAbout",
 CellID->112805847],
Cell[127393, 2816, 150, 3, 70, "MoreAbout",
 CellID->42831500]
}, Open  ]],
Cell[127558, 2822, 27, 0, 70, "History"],
Cell[127588, 2824, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

