(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    134372,       2907]
NotebookOptionsPosition[    127831,       2689]
NotebookOutlinePosition[    129178,       2727]
CellTagsIndexPosition[    129091,       2722]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ticks" :> Documentation`HelpLookup["paclet:ref/Ticks"], 
          "GridLines" :> Documentation`HelpLookup["paclet:ref/GridLines"], 
          "Mesh" :> Documentation`HelpLookup["paclet:ref/Mesh"], 
          "FaceGridsStyle" :> 
          Documentation`HelpLookup["paclet:ref/FaceGridsStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Ticks\"\>", 2->"\<\"GridLines\"\>", 
       3->"\<\"Mesh\"\>", 4->"\<\"FaceGridsStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsOptionsAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Options & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FaceGrids", "ObjectName",
 CellID->22039],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FaceGrids",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FaceGrids"]], "InlineFormula"],
     "\[LineSeparator]is an option for three\[Hyphen]dimensional graphics \
functions that specifies grid lines to draw on the faces of the bounding box. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6771]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData[
  ButtonBox["FaceGrids",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGrids"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->1402],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no grid lines drawn ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "grid lines drawn on all faces ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["face", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["face", "TI"], "2"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "grid lines drawn on the specified faces ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["face", "TI"], "1"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["xgrid", "TI"], "1"], ",", 
          SubscriptBox[
           StyleBox["ygrid", "TI"], "1"]}], "}"}]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "details of grid lines specified ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->5761],

Cell[TextData[{
 "Faces are specified as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["dir", "TI"], 
     StyleBox["x", "TI"]], ",", 
    SubscriptBox[
     StyleBox["dir", "TI"], 
     StyleBox["y", "TI"]], ",", 
    SubscriptBox[
     StyleBox["dir", "TI"], 
     StyleBox["z", "TI"]]}], "}"}]], "InlineFormula"],
 ", where two of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must be ",
 Cell[BoxData["0"], "InlineFormula"],
 ", and the third one must be ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15815],

Cell[TextData[{
 "For example, the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "\[Hyphen]",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " face with smallest ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " value is specified as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", 
    RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1749],

Cell[TextData[{
 "For each face, specifications ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["xgrid", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["ygrid", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 " can be given to determine the arrangement of grid lines. These \
specifications have the form described in the notes for ",
 Cell[BoxData[
  ButtonBox["GridLines",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLines"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17722],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceGridsStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGridsStyle"]], "InlineFormula"],
 " gives default styles to use for face grids."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->643683418]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->86564627],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->15819400],

Cell["Put grids on every face of a 3D graphic:", "ExampleText",
 CellID->490860158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87871385],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->All]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->822713056,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314815608],

Cell[TextData[{
 "Put grids on both ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " faces:"
}], "ExampleText",
 CellID->6729609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195558251],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->{{0, 0, 1}, {0, 0, -1}}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->660234297,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49944586],

Cell[TextData[{
 "Specify overall style of face grids, using ",
 Cell[BoxData[
  ButtonBox["FaceGridsStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGridsStyle"]], "InlineFormula"],
 ": ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->643683418]
}], "ExampleText",
 CellID->438049882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", "All"}], ",", 
   RowBox[{"FaceGridsStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369339684],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  FaceGrids->All,
  FaceGridsStyle->Directive[
    RGBColor[1, 0.5, 0], 
    Dashing[{Small, Small}]]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->100130603,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18781],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FaceGrids Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->80772045],

Cell[TextData[{
 "Put face grids on the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    SubscriptBox["x", 
     StyleBox["max", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane:"
}], "ExampleText",
 CellID->18848067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355539880],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->{{1, 0, 0}}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->491205982,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Put face grids on the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    SubscriptBox["x", 
     StyleBox["min", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane:"
}], "ExampleText",
 CellID->977353446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->170662451],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->{{-1, 0, 0}}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->110929184,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9238429],

Cell[TextData[{
 "On the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["y", 
     StyleBox["min", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane, put grid lines on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", 
     FractionBox["1", "3"]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    FractionBox["1", "3"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->185725235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "0", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "3"}], ",", 
           RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18972493],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->NCache[{{{0, -1, 0}, {{0}, {
        Rational[-1, 3], 
        Rational[1, 3]}}}}, {{{0, -1, 
      0}, {{0}, {-0.3333333333333333, 0.3333333333333333}}}}]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->248971400,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Put face grids at the specific positions, on both ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["y", 
     StyleBox["min", "TI"]]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SubscriptBox["z", 
     StyleBox["max", "TI"]]}], TraditionalForm]], "InlineMath"],
 " planes: "
}], "ExampleText",
 CellID->491690116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "/", "2"}], ",", "0", ",", 
            RowBox[{"1", "/", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "/", "3"}], ",", 
            RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "/", "2"}], ",", "0", ",", 
            RowBox[{"1", "/", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "/", "3"}], ",", 
            RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13796340],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->NCache[{{{0, -1, 0}, {{
        Rational[-1, 2], 0, 
        Rational[1, 2]}, {
        Rational[-1, 3], 
        Rational[1, 3]}}}, {{0, 0, 1}, {{
        Rational[-1, 2], 0, 
        Rational[1, 2]}, {
        Rational[-1, 3], 
        Rational[1, 3]}}}}, {{{0, -1, 
      0}, {{-0.5, 0, 0.5}, {-0.3333333333333333, 0.3333333333333333}}}, {{0, 
      0, 1}, {{-0.5, 0, 0.5}, {-0.3333333333333333, 
       0.3333333333333333}}}}]]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->61220124,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FaceGrids Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->323941756],

Cell["Specify the style of each face grid:", "ExampleText",
 CellID->207632568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", "Red"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "Green"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", "Blue"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "3"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "3"}], ",", 
             RowBox[{"Directive", "[", 
              RowBox[{"Thick", ",", "Dashed"}], "]"}]}], "}"}]}], "}"}]}], 
        "}"}]}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522670623],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  FaceGrids->NCache[{{{0, -1, 0}, {{{
         Rational[-1, 2], 
         RGBColor[1, 0, 0]}, {0, 
         RGBColor[0, 1, 0]}, {
         Rational[1, 2], 
         RGBColor[0, 0, 1]}}, {
        Rational[-1, 3], {
         Rational[1, 3], 
         Directive[
          Thickness[Large], 
          Dashing[{Small, Small}]]}}}}}, {{{0, -1, 0}, {{{-0.5, 
         RGBColor[1, 0, 0]}, {0, 
         RGBColor[0, 1, 0]}, {0.5, 
         RGBColor[0, 0, 1]}}, {-0.3333333333333333, {0.3333333333333333, 
         Directive[
          Thickness[Large], 
          Dashing[{Small, Small}]]}}}}}]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->164737533,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVnQt0Fsd1x9d6IyEJsGywsQ0mwYDNIgEBjB8lTmI71BHEPIyfgBAyRi8E
SDyEHt/3keA4dhIcGxw7jt9S0rRp07Rpz+lJT096+m5Tp27SNK7TNE2TJm2a
Gts8bNjTztyZ3Z25c2d295OET3Rsoe/b3btzf9+dnbn/O/ttc0vvA21dLb07
W1tm37qnpeeBna17Z9+yaw97q/QCz/OOs/9fnOGxv/+P/QX/Hw+CwPO2sd+l
bW1ti+HVVva7hL0q4a/42wH8eI2wdbPcWib/bYJ375EWKpRj2G95zF1y30nk
1k1yaw1/VRadj/2xCLZvkLZr+avyaLu04cM+66SNKY591ko705Bf2M+rYe9m
afGiVHvfBu96XiA2eBejvUrR6wVw1Idli+BIuQUfWYZez4cjb5GtKw3Pm+no
D8mjyxOOLkev58HRN8lWV6KjpyecWxy9Sp67OuFofO6r4Ogb5LknJxxdgV7P
haOvk+euh+axo73wB3tOH39tEMdxFT+M2/jGBw7/yc2H//TWwzXsjRp0XCV6
/V6wsyx8l7WA/+ZnK+f2pj/TVHhhcWF0ceE33lf4reWF31lZ+Nr1ha/fWFDP
82erD//lRwp/s6bwrY8WXl5feGVj4bubCt+7u/DqvYXXNhd+2FLgzTLOTLdk
qfRIBGjgBTJWS3lrZn9qUf7oovzjjfknGvOfbyo8SzXuD7I07l9bCj9qLfy4
Lf/THfmfted5O3HPqEKv3wPtXBxo8S4ayn5K+K95eT/3cT/3kJ+PGvw5R4N/
LUuDt2oN/q/O/C+687/syb2+N+cBI6Wlk1DL50AbF8mIhXheLEKu1x8+4OcG
/Zyj4S+OY8N3Kg3fk3ujL/fW/typg8P8c2c/1WS7F0ri0BOW8v0Cr9Mf7vGH
+/zhg0brH3W2/vecrf929tafhNafGRqCCMDkrwQPFgTxmARxsmybPyS82J3k
xdNj8eKuwvd1L37i9mJw6O3c0NmC8AXH/2zwZZ78NCpDX667yx/c7A+2gkdd
ukcFP3fEz30y9OgY8miJ9OirSR697PToP5lHHQkenfvYYHBkkLgaCa/mSq/A
5/ex3W73Bzb4AzbXhs6jaz9XXevNlY6OjnoVZwaH3x4eeif0K/jEAP8s8Fgx
C3ybI6OvKvzElnzUP8T82+gP3O0PbvEHtyv+7fOH+2P/8sy/T+v+Paf495UV
af37jtO//wb/SrhnNW/tiz467GLwyYHgU4cgNvGILjydHb0L47HojUvY7mv9
fvBZuD2I3N7jdPvJiXEbPscp4jPFPuexz8FnDgWP9hN+XwF+X6GOndJ3iOQm
dsga/2Dk/jp/4A7d/W7d/cPp3b8hu/vbCuB1A//Iu/L/E4b0m8z9A3b3H5Hu
B48dJAhcDh7PlDEuRuUgnI6JHtHIDmv2D5og7vEHt/qDbQaIYQDxYAjisxJE
QQXx5WJBeBDnM7T4Bxj/uyd3goJx9rAO49MSRnDsADFrETwuUcdMhQeM/T7w
OABI+kMkAwqSIYTkkILkYR3JF8aAxINomMki49+2FX683cXjVD9HEvP4OOMx
GPM4KngcDJ444BFMLgMmFyvXQZUJRNRCYLKfxLLJH7xXx7LXH95vwXJcx/LF
LFggMmbxSLlHdhkAU/jJ/QqYXS4w5xiYB3Uwn5Vggif3wzyVZNMQKJmvwgZI
Xg1s9rnxtPhD9wOeXeONB6JkTtyLFDb/noHNEMWmP2ITfH4fQWcm0Jkm6dQi
OrD3fKDTVxygnALoMxkBAZe5MnjWFVRA/4IAPZAF0EM6oMdjQMEX+oy+dSkQ
qpd9q54idJWb0Hp/4E5/8D6K0AAQ+phB6KmQ0EuC0DJMCHrSAtzD0kPanTux
V4c0ZEB6eECDdFyBRESS4FQrIwmUn/kRJ9jGGPWmwcRyhx0hJsjfYkyfYJgW
cUyPOTFB5Cz8xgfxVejvnIz+g2TUxxjlBKMzaRh9TjIKnu0lKF0SUVLfBS1t
nkFrjwXYIQFsgwGsRwLLEcAaaWBitG6Mu54T2j+lhsbz3ghalKFE0PiUT4f2
lIQWPL/H6IMzgMhk5V0+GZwawBRYodbs72729wI1jswrYdC8S9YY2KK0x4Ht
EQqbGNGX8Ci7rkAw+3WN2T9scDJrL4IZTI1iZvuDpwWzvUSsKdQ0rReirTa+
hvFQ07iFocank14Jo+ZdaKaLQqGI9BWT2xOMW5OMr2VaBx0bup8a6FSZRUN3
xED3mI7uGY7u3Is9RsRNj9kZGjeMAbMofn0mPyUtI/Cp0kiE7+iivIiza1nQ
PY8ublnZ3Vf4gc7uZ5JdnrF73WCnigl8Ro7YHdPZPcfY7SYiT6Hn0PNh+2UR
x2Z/V0qOIr9rtUtMQO/6KAYRxt9eUfhdCuOfuzFuwRi5yrQr/8siMR4AjPsk
xhd2n3tplxGFF5Mc8V41Yvj1vDAYd8HQYXLsV9NDUyZQOUKvXRXF4/lHeVJB
aWokGkoxe0MoiSzpIpImzrerRQBnpCkyS0RT9OKbItnzEUXkZyyfiVguzcjy
Do3lD1sMlt0Uy0GKpZZvKzPhVCxxDQbrc5PErsCy2e9q9nvskxozS5csxQjy
IaFckEq+ifM37TiJi6WJs9XASSivoZZjyhdHDZxsasNx7hE4ccw1kDSxkgt5
/bTiaEIk3oK0wLGSXJ2OZBtFspcgGQofA44cFiaJe889z0meGulIRxIr/RCn
U5SRJxVMYLjaVI8iYdUN80tjhvkjB0xDYaVVJCPfZbNHDvPFnjMjnUYl+EKS
Jq4BwVF1yhWzG8ZxK03ozx9RdYNEoI8qtdFMQP/aAPrPJtAdFqCGTEkrLEbe
FwDQd0a68PVwGskTVwXLxKCOee5FPMXosiZKnhNpHnn3aFKir12OwQkhn6Gf
G+lORxO/Lg20LFGnKbJEzvF2lFyrog2SRfup+pgGdHFhJA3Q2yTQv7cDJerh
afQtOsOOs0UB1BhhppJEyXl8hTlvh3hcr07aSZqmSDihNF81aYYFYqcGT9E0
c+8wCeI08SgDebbRu+tgQFJzynBEf4CRhFi8g8yAkIAhdB9SkkY1vmi1QNEw
/5HBvNMOEwqcNMwoG8cwLdl4OOdMx1KsLopZeuKaOMkyY4/1jDXvJsa7MUax
aMFRF0rQg+wZ5YnRnZhkPUmS8wV2kyEUO8P5EA0RMdysa7aoOmJj+ILB8Pdt
DJsphvcWXtMZamWS3RpD5lmyMGRJJd8cbU/HkPds6L9bAhCKsszUNYUI6bmo
1HT+YTKf1GqBgJksccS5ZJz8nBztMOaPdSTNGhmRMH7fxHYQm7Lg5AJHJLh1
xHolUbmLVoCkxPnNRJybMU6vHOriqKCAMTpS8jjz6Tk90ol51ZIUJ8mYhLnT
B0REsq0pKa4zKCqqL6/KOCg+iyheW1RQUqtpoI9dSqrmVppkRh6mPm+PdNE0
caRWypiE68H1xpwymWa0OMXU0Iuj+YdZaIrRcTZ9tYxYOoQ3V04us56zI13k
/JHMGvknCXtfZ5mfJwgbDpY5aj3H2Fl+F1iWOTlqWvDgEL3ix5U9yul5Oo4l
MiZrRYBSHHkdbJ+32K0QIe2SqCPqIJ8eD5Ai95oj1k6RPA0REy0asmfjRv6I
85gagydvDG8RzDarqMoEzxlLeNK4wLYSwkTZZynJWlEuT0Ap+vF8FeSryho0
gyMpBusykSsPx4kOrl5XRxw5uwuDON9u9tvNqo6oys5bY4G31VKRIOE9mRGe
V2YnJ9doafXsBHI4q3GQg6mknZyha/ghwQ57BQILFmgdV5dRGlMrtOqiv2gB
Nga4SvbQpsSeTGOEWiNd2SGFIGumrc3I3xht5+TKwvVcRuYNMXiNMf+mkxkH
QaGhoeKiSvC4k6CItuLZWatiLnb6BNxg99ZoB8xiorWkSNc1WEI0LqS08mSc
d1okyUScz0V3BCg4IRKXpBlZvoeZyvVPzupYaqYyQ4yTmlOjUIfAd+UlMK1L
V3+I8u2L1SU/kY6myrxqcewRZZlUxBQIrhQL97VOPi5Me0Kmodh7OhVTa4YT
QsPXx5RMHXPyiGlDItMhk2mjZAr53LUxyhstKNckoCSKt3oVwrVCz4UyTm/a
wvv4UlHcmjWzsalpZDknWlEQrQRlHLX7fyYMJy1NWiUMW4ZjzIAcLC/PmNnQ
QpBQ1VSWYmxZhdannX+MWFZLnShyxXwiOa6zc1RrOGIu/f6jxlI/9SYnhvJr
KVB+e6JR0rkNn5PXIWbA0KjvwLyoMpwX7VTzGpEj1tlyRFUGEihhLLlVF8vj
8rdcMGSH+fUsML+fAqZLMk+EqU/TvQw0q6hMJ8oSa5KVC+jHH9YFc4Njk4Xj
9eeDo0tUc6Y7J0Z34h7uIBnljJ1mxiNyxmo3SrE+o5eqPownzI3vDsw3R9uN
6yVNE66X5OoWWwrJeQK9tap60Ukp5irPx1Pz/GM3z02peCp1MZvi61CD1EQo
rERk4Fmfhech0avXqnIGqfWOM831RdHU9XOp+ZorXeKU/IBJk03Xs9Dc5s59
GDw1n2QvSYXIJvmiZQQ00pUpkN6ehFRZmhEXbikZXZPZVJUDlcqiDAgWZNFE
cY6pjuqBPmcXcbgpjdZhyr4kzGjJ0Jhgwr2i2rp+ZWVGvJgA1SRCLZ1Q3si6
owLznZEuY1SvzEwTrpFlRha5jlQ7TPHXrN+iNVhfTA90rQT6Cgm0VQHa4QBq
lzKTsiBizungKfNy6NcJs/c0RFVF2FYRnziiZLkni4o0RqL8Cgraw+aU+eQG
Yy2bjeTDTpJfTkOyufC3Jkm4iecHW5UVwfbC2dhIWvIhe2xCHrMVZUNZtQ4k
FJs8j9l4rhgDT/fyl0w89fuoZUokeMLsMx1PrjHxa2SZcg0NKxhannl3VrT7
9CpGGrRfmTC0LukYLS5KkW2+MdqOx3lBF6/G5nTLwhUx1foMCidMkC/d6ZaW
bAIyWe4dT77G6re0fItKnN4a7UjHV8xUGWD5ugS9LiO44zyA4q7pJ78q3E8d
ChfDZkhYtZTg1GgHvmpUkNzL5VWjZpz47qDk57yl9o75LpsovnHJyS1Cp+bL
Uq4i+G5PWXVy6CykJB0V89Lw/WoWvt/JxNesmRTBNyybOPiWRStG2M80TNZV
e1KL9urqm1aLSG2WSc8vWSiWZhWrVbHASMbO2siWyZkt8GxOX8sbT56LM/P8
VhaevzB4evDNVhe5tEGrVKDUUuxEed+H++JWp6uhYKKbFKJCdTFv3iiCKGvL
H910eHyI9uSgQ3rTWXCeHoCerypZkS7oUgpSsTTuNawjqyn2ivNyXXzBShZi
+pCb6dJkpn9x2+G0TMOVT9xFbyZSr1WqlJjloBreH1MM1fbErAyoLi2Oarg8
YgKpgmveLFtRgGFlHZ/tkl2FiYssBtlykqxarwpwoaUX8rJyBFfcLdOkqjFb
/SFbeQDTlSV+bYle0XTVe2GB6RxtnZQdLpvDst1TwTVyszdH2zOwnWSZu/Jy
oAf1wDIjchdG+kwi2yPE8onxYQvXzrk8ZpWFPT+3l1442FCMZYe6wFqSXpaU
ZYlaG9m+iGxjJuVLyNzpyX4pI1nR6xdEdyC+tgW+kNmybCqiK5TZ04eGVUmB
o3jQLSnglPfUSGcWumlyrmscWg0peduWBahLJjPBFUwXqheEGG5inasvBdx0
edcZM+8SbPF6ygbMttvMt4DtfJtOY2M7YFkqkJUtEG2MovZlE629hGhWFBBa
dlXgLB7KkHJRVRoH25rEDIFfGw567yXXBaWAqy0dSAkXmC4xLwkYrrM+y+Eq
9+ScNOFCksB5JMCNsy5CFXew9bNks5oOY5PGi0Mrev1yln6ZV4S/GhvbN0i2
SgLGkRBs09VuHGyvVu/4duQMpAZjaoii7JCeLRBdqWa2adE6l7XxKqNReTgV
oTVyWw5FRevIx+oRxTI723npMgdCNXCzRfVwxFZE6Y3mBUGF+00HXOM+AAyX
KuswuHyJNaXESLgu4QDSspe6XyfyB5ovzBXmKteFjvOAGBowk38F1VxMxa5c
i4k/qU9xd9zJaliUsVDB32IHUXelLavKRAUJ14gKKBz8SRgzX3glqOBEZtH+
R4mP6T/MIHnbyawyYX7u8L/KlvlAVtmAskqbuGT6Lx/7MZ95DE9tuZS7eMDi
op6C8BY6c7uTZn3C4WFyBmLmdlWRKoFcLJF+NTG/4Nkm0yN3tOVXekbFW3TM
Ouc/Tcz5x9mfStMf/v1s3PTy0JMGtz7EW0E4wO/4IPT2lO3vTtn+0qj90Jdu
CNs8laqG9+tN1eapZ9k8FY9Jpfa2VrvnUpADlKMcAIx8kLUQnmhRb6Yn/ByW
aZ6lbfCPeFN8s2SadpWKdvHhTTyBgdlhrWL/eTeHratFUyR+jqfSjOOWdtUk
aqpghJ/7trANNfEE7QloQDFnvwhfy7RJBKgknId8ktXa8NzV0UDC7WjD664T
poJkOW85GkPEnKJcc5v9rOfoq/lDgswz2jQryxlLo++DEJ9tORq24Dq1MfSy
kiHlRyeMEua5eB8AX6qMqw0oY553F/epkvv0dB8/SNUx8KdWYtjnd2vzzwau
FhXoBGzXe7h1PmCypnO1KszibZbjd2oD5YkK5eqFhgO5j9vlwxJrL7cr8tdk
q9XSqngKX2SV7bSFW+SP6hLmzo50J1sL7+YUn4PoyLx1LdxWqbRFRL9pqVRy
nCItseykm1tqVSzxTfgTJyyxPxukFd6FNCusMTwYaCv8jenyyA5xqfG2h0ey
SRk/Eq/mMM8fWujEFljAUue+QIspvoewEF/r2kILsr/gNggLZEaCrZR5YT9v
M+/KE3bCJz6Sx5dHx8u24O+JEDbw2qwpyNYO0hb+HhRhqzJQnvlYpA18F2ct
Zas0smWMpHgdubCKzzU5wSr+hLjVC9hLbk1YrJG+Ykv3I0t4lUWFYYm8298S
U6EFrCDoFusC/YmONkuYVZlhaQpJN7a4HVnE9+SZFqcmWGxFFnE8lBoWw6eS
YEvbkCUc/yWGpQaCrGqxBVmkvvEwtOjB2Bk/eyi2sgVZgatMeWQlEL1D2KCf
4Bnbug/ZqnfYmhHEz4lVbdyLbMAnpD0JQBx/KeFtSThuKsdfqOwXn30m8Tmq
rdiErIT0xNGXWdq+ER01XfsErrC0eL2cq1yinWOW5RxriZZBjg1HXWk5R7M8
B6dRHkaneJIjosD3Wi33nipti+/weU8QPxWWbw1n0vWBMgKLJ6GiGOHNXSXz
lsmyBeI7j68K4t7Ct66Ue9VIm+LJI/ORzXDvpXLvSdLm5bD3giC+3vBh6xq2
F/+3StoUz6+8BtnkZ+TTrdkyaw/3Fs+VXYj2Rs+nCMTzXuvYsdXyWN4e8exf
P1CvzbEN3uo6T1wfuSnxtONGYi/19ZVy76Wwd1NgPjmZ/3mZbMEK2GsJ2oqv
2TOkzRtg7/CZr9S6c27z/bDXMrQVj1FhVNwMey9HW/E4GX7eq2HvFQH9hOkK
2YJm2GulspX37DJpYx1s5c/yrWCv7oBX3gX/D7zxhmY=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11240670],

Cell[TextData[{
 "Specify overall style of face grids, using ",
 Cell[BoxData[
  ButtonBox["FaceGridsStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGridsStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->73376459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", "All"}], ",", 
   RowBox[{"FaceGridsStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107248101],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  FaceGrids->All,
  FaceGridsStyle->RGBColor[1, 0.5, 0]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->79363383,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->426631554],

Cell[TextData[{
 "Individually styled face grids can be used with ",
 Cell[BoxData[
  ButtonBox["FaceGridsStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGridsStyle"]], "InlineFormula"],
 ", and have higher priority:"
}], "ExampleText",
 CellID->88564141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", "Red"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "Green"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", "Blue"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "3"}], ",", "Thin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "3"}], ",", "Dashed"}], "}"}]}], "}"}]}], 
        "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"FaceGridsStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Orange"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298470340],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  FaceGrids->NCache[{{{0, -1, 0}, {{{
         Rational[-1, 2], 
         RGBColor[1, 0, 0]}, {0, 
         RGBColor[0, 1, 0]}, {
         Rational[1, 2], 
         RGBColor[0, 0, 1]}}, {{
         Rational[-1, 3], 
         Thickness[Tiny]}, {
         Rational[1, 3], 
         Dashing[{Small, Small}]}}}}}, {{{0, -1, 0}, {{{-0.5, 
         RGBColor[1, 0, 0]}, {0, 
         RGBColor[0, 1, 0]}, {0.5, 
         RGBColor[0, 0, 1]}}, {{-0.3333333333333333, 
         Thickness[Tiny]}, {0.3333333333333333, 
         Dashing[{Small, Small}]}}}}}],
  FaceGridsStyle->Directive[
    Thickness[Large], 
    RGBColor[1, 0.5, 0]]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->227447547,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->966],

Cell["Face grids are placed on the major ticks by default:", "ExampleText",
 CellID->213162192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"FaceGrids", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], "}"}]}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243727893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVnQuUHkWVxzvzzOT9lgQicYMs6HZmIKIbBUE5EBFmQhjC5AUkwECSyWQm
k0kmyTy/LxiRhyhiDKC8E1/Lqrvurh49x3P2rEd3dV+uoqKrLj4RdQVMQgh9
dqtuVXXfunWrv/q++eZ4zIGZ79F9q+6vq6vv/d/qntbN/Vs6uzf3b71585KV
fZt7t2y9edeSy3v6xEe1k6IoOiT+f+q0SLz+P/EK/j+UJIn4Av3cKH7Wiq9q
5Dv5IoF/UY142QJbXE++qZU/6rL3UdT8J7Gd9FR61aB/tzgsVupvapHFSLIR
/18Gry93bDeS1ueR928M3G+Obhsa7+zsLGffWXhf3e0aYcO3f73efpY+9vC+
xPa4vel6/8nwueqs+Bm9waLYqH9P1a00sVuv199Og1bVt2qDc+H75cwxSfT4
PJ3xG+zUp3Z0W+fABuc7ntU5n7xG92f2OO3M132bh7yGfpP3rw+2OFf3bH7V
LJrjT8/9ucRiLXl/VnALM5gjdBqxVkfeL03wcTdn6zTd18VBe5sxSD07nWxd
T97/Gey9JPHPA6frfryO7NlA3sP30ZkOEXruztf25FkyTfyeHmR3kfgpzSoH
kHnH/lzmCEhmjfKzaZ97a/HzFxW/cHHxS+888JXLDvzjygNfffeBr19V/Maq
4r9dU/zPa4vf7ig2pFazXtD3SwK9na17U2/6v/BQc+HBluLDLcXHzysePb/4
qTcVn3pLMaRb311XfGZj8Yc3FH+8ufjszcWf3VqIzFyWx8/XUzMnzk7cc8Ic
+2jJwbhwV1y4d1nhQ82FjzQXHmopPtJSfEL1/IIyev59u+e/3FJ4rqvwfHeh
jlwBJpPen5nTe8yZO+9qzGfn7o3HhuOxYjwW4s7fgTtfrsid3/WO/b5v7MXd
Y38YGBMNyxl0CvHotdYZR68Z5qhEb+yJR/vj0X2m5+/19Pzj0PO/rmrPj+8f
lT2nV7ys9zOYMZPoa9QZiT2PRc2d8UhXPNJr/Bkpy59LQv35H9uf3zr+nBwd
eaUwEhnq2KvF4NVM4o0bVy2kR2n5hnh4Uzxyq/RwVHi4m3i4rPoe/oL1cB94
OCI9PHVgODk4HNVE7tyg/GzUc1FdSX8XaH+B1wrxYnU8dF08LJzebDu9H5w+
UNLpvxyH09t4p19GTid3DCV3DUWM52cEHuF5SRbpwRFesToevAa83mi83h6P
7nS8vntZ4QPLCvc3Fw43Fz7aUny0XK+vy/W6Z+x/hdf9nNfvAa/vHEruGYRj
TuOD0wM9n6OPNZzxF4sXbfH+q+NB5X6Hcf822/1RcP+Oarj/NHG/U7r/K8f9
Y5b7I9j95N7B5L796UWgAgYzNQMaewPTdwCTfascLDchLHsMlttzsXwasPxN
IJYNpbDsQVjGJJZXHSzJ/fs4MovS+RzP2eY95BaXihet8V7k+pBy/XpwfUs8
0m1cHxyn66286z/yuP6Cz/X3DkvX7wbXPyhdTw7t5bxfCN4v1fMheHsZeDvQ
Gu8jDq8Fh282DvcFOPwkdvht5Ti8STr8U87hl4IdTh4YiNJrNPX5dfoIwzmx
EnzeIw4ycbsd3L7BdnsA3B4bv9ur/W7fJt3+9XZwe6ft9vDISeF2kXP7Q+D2
4YHkoT2c55CHQSxptIDoXeD5bjjgyvn9rPNbPc7fs6zwwWWFDzcXHsDOL58A
5/dyzr8PnH8/dT752G7e9zP0/Cbn+uiK1rgfjjrv+zrw/RbwfYfxfcj4/j7L
9+LHyvf9v0r4XnB8H9W+3875/mHw/UHpO3fsX5OYLFL6D/n+lXDsvQiuBQQ3
IgS7EIL3lELwmWoh2BWA4AMYwYBAkDzSz1FYkFKo05lfdBVQ2JUPYr0DYi+A
KOSC+ETFIG6yQPyGBSGieQXiIIC4awiB2Jcc3itBfFSCePWxPp6Dybm4LAbn
lzIXgjOmtTXemc9qDbDaFA+LnGdbPNKjWY0FsXpzeax+AKx+Aqx+7mGVZT4s
KxEWCFYfyVglj/Vx4wYUOHV9zI2fiB4mDMAs2wZjTKHb7aAbNOiGAd1Iiq4f
0A370T0Wgu4qje4/ctBtBXQ7Cr9T6Hbb6Ao2untsdA8IdHuShwW6Xa8+0cuT
M+oPjStdgrUJVuIyO6CSrQrkuCGX451x4f3LCvctKxyaSI6/1xzHGI532Bzv
Zzhyo3Be4ChkKSM7YGFVa7yDZYnjezvXHcGSTDVZrgWW1xuWtzAsXSEDZ7wQ
5dssHwKWjwqWO189ssNhMLdCljS7BHXrahiXPa1xH8HZ5uDcaEsHGOfBicJZ
FDh/meLsDcQ5yON8XOKsFk2qUkDFaDWi2Z9Ds8OhuRvphYTmgzbNvypF818F
zfbx0SQpKEpLVIia0uQyM7jewhUa56VUsaJa9+SMX6/Nj2Y2OHln1buDcYHl
d8Th98VS/L4H/P4b+D2b8usy/IhK6VM2Un6HbX5P9vj5LSS82KrG6tZ4u81r
wMfrelvsSCWwCeF1o+F1q+T1nMuLkTy8+SDExIJXn+ZF5zGIhXWlLuPVRLZq
0Ly6ES8+EEwFgxxeSv+ugNe/VItXmj+TFPJBxUuGzoLXi0e3OTPVrJSXqV44
VUbFqUTA3M5x2oM44TqB4vRwtTll1Q+iMLo6A003BzCnPxztyuGExxXlVVcO
r3W2IoN5HXB5QanxsfPCeLWF8votx4vRZazc1EozRIx3/Mh2ZwafaY0rWhuu
1Zz4yM3N3m9wBLsQTp8sl9N6zUlW1W6BKhTi5Eq0JXJ4Kx2TsfDLghOduWew
44ryqqkGr1GnsFMWr6/ZvL4DvJ4hvNKalqvrDju83PTVzh1OHekeJ6+eklkW
FkVcQdgthKUl/wnihfRRRyPK4ZXmB7TOO53lBRTX4DVCbNjvZKRUQEqF1FFU
PhsvqzUBrFxJ0ZVG3LzUDv49rJoS/xoaOb/XGs35WrVna7yVjfJVCkpkEVeG
HLSLbzy8N5UPb6OB51YgA+H5ElEZq+6gERXkTIqou46mPv1Es4Q8q13s3Rp3
OSE+TZHSWvUmD7zbQ+CtmEh4riKSpp1uoiQCV7qWBOIImLXqjF4SQBF0lHY7
ik0R7nNz9g2OosmWgNKKP4vw798uEB4IR5hWwH+FEboaMEaYkyuZ2P+Fo1ud
qH5qWWOQo7eHy5kwvRFCb6gUvaPVo+eWEnjdg6VnZwIviUyAjsEpHnpmjQzN
2edk/NhYl2ocLr+9HL/70XoTL79LS/P7IcfPq6oTpcPNPC1+vcdEhlAOP1fF
dDnuKJkzOFpRJgrjel5Jjn8bxvG7IRyxxO4qHmymhTKHEyIipjlUk3UVNuvq
2JW+7SERMauwYWppSSItf1dG7VsstU5EzSpMUJ3In5/SPOKkiItBURO7q1G3
IEFrtoOotPupkEINofLExFBRZYZUPXvZRyUtDKbZVZYtqIhODiW8ErUpJcSN
n5yo16ts9Drlg7SklS6fIKQ+G0iqw5DC64RuK0UK60A0D/XkCfWaFNXPJrO0
YI5a0xpvqRjY7kBg508IsDzhDANjEytIFmBaF3vTfHSydf7N1Zy2hXBKU3Ui
LeJCCq6VMpzeUjmnnxJOvR5OeI0KTkD5vKBHnnx0Rs8ZU9c6mrU3TceyBmGV
lkkIq0cRq6cUqwsnihWTrOMElEsDprGc5nMz1RpPlF+CU7dH3p9YTlxRiRHN
2EQdczKxvtStKavGlFV63fMyaqOZuCVjdDtSdVoCIUvCqsXo55UxuhcxyvKh
fsVIatZ+Rp7xtDM/73FVCyK/cqyKmNWnqs6qz2Y1bLPC6bcv+5F6dbmsfLG5
leO4Cg+RqnFpDS8bGierHyFWtCCJhX0sKLqscKaDInSpWZdmFaFrXxArrEZg
VlhK9LH6eDCrf3dZbbJYPUdYYfEVa2Ikq85YWXH5KyIu51mZLIa7F7SOzGFB
GQ3RI1gp9i5nEUbl/Mya/tL8WE3R5YezQRPBy7iU5wfVpRJ3bFK2Zjzm1ACs
DJHw3FUWzwvyeH7d5vltwvMmi+fzhicrM1oqz902T50R2XF+5TzZjPs6pHaX
kXQTwXHUrtzhyjlF+tZKkP6EIDX1Oy9SXrDgM4HqE+0aJ1ElY+QQfTKc6NV+
orfkEeWkNE/a7uQM7J3DwUTTubOjVC7B5KepjEbkyKyq7Cf5ucpJ0hq8nyQn
gOAsVZLMMgqpitPxWR5NZ3x2lMo8fFRHjThpibxW7bmqVOnKhp4AqiT3xzmt
ztOMWs5TNdd1s66NvQaVJDjI6iauUPlHILhzfARFBgf1hmNMdqII0qeOALEG
EwVlxGoEr2hVmyfbzSdGKoPp+kl8A29eICSIXZNLjFSmSXlhxCFGdBQr59U5
ygkm7lbE5hJiQHBKftxdI3hFVxJ9wBUzyyL2+XBiGwKIIUmcV57cDNhkdSpT
OclE3xNFDKt0bvGvKsR+gIgxqx9YEdjVn2gebOUrp5j4MIdYhz+WJpqB1ldY
rU7pv3nE1J1npYh9M4SYXXJ+0UfsYCgxGVHTaKU+JZZGImtzlXKvwOKDRWp6
eslWVWGhJQ6yspcnb7qwSDqM0g8/K2fOvzRMNc/EA7xma+KYZQ8ysBd/22sa
rDIDPMEqmkuhuXpLVtuzltbkjDCH2iUo5g2UDBjZk634EWqfMDeEhlN7OqV2
I6WmasiCGlTr5h/bN3piEC6WY6VUAzcle7LHQ2wON4tdGBjPssSwoDfhxDZn
xGTlKVqIhWKB6+XhEfExxcVmsHa+xenpGTE5i4G2tyKclMpMlXziSp9Fp+SX
rpCpCqkfby6CK9FitkRjaMl8X2zF0HKzUxT9c8p6zvh6s62sTxS1I+OgBqyW
PEuWdDj6OobGiCRuIooC/uNHuspgttyOxYI0ECx82gUJD7PzSjP7J4eZGldL
s2Xh7toFWzxOoYmYX/ru6iBMlqRjfqm105mszk+tnkSwkciRBqJzfIklwaak
I4ztzmBs/0CwXSGxwRx1tnoSwvfQqcks97CRHUfIxDiTvruCh1P2UkH/K0e6
eWJGVfet4k1nuQY3D4Bc86w2T3bOKposxMPBEGGUvcE6WX0cb2M46nTT4iiT
JwnFTdBp8qQDW56je+9jo/MJPJPhXJQdMPkUztkDOGZFRczxcQ9HdZbG6VD8
54pAvoBAnrBBigEpwbi16qAMIZwkrJGYmquxS5gRZKeL0uzU1TJTnT2cJjBs
+eI76HnNwnwGwXRXRxDh7cSQH6ZI6d10KyeDKJ9ljrqesVzAsRx1axY5LGH+
W56d2wTklQ7ItR6QUMJ9fgejC0uQzuolycaXt+bFyD6SZr2veYIBzJJLcvMM
mv6zotwAV91NMcLoqydndzRdTtlnP23fDoJJ+RR0QYrVRKT7JfIvKaLT2CWP
lVXP5a7Ti8PiaK0GeARNphIJHZws7657/FuJ/B29Nkf9pkRQGi/9zM2vXjq6
jSdirqS+Vbrg/6JA/9MlFK48mfovxyWs7xQvhNfiv2ix+AFPH11E1GrlMc3B
TUYpXaEpUhb0Hzvaxd6zqO4vph4ucPXqHO3C9VDGJKKhPzeeLMjrPVzNmd5n
0bcUj/nem+dtw9w4N6zXQ2mvlaQX6WPQLHpbCws/fJ0UV0rZAdpJHe1Kvdbf
S/qk4WhWeI6g8nZp9gLTx1lMyncf9M7umooqT7lRZU7P6nDPamQg3sj2DMy9
TfQInkc5w41wZWtWhOuJzPi+wEhsMMpjFohBVlCrugOnjvhxieEyFUczsoVs
9Y8vmrFHEhBoZLU72AmeQG98bkqvT9KcfaEPHAvzNPHtaXtqPlD+yUaukJNC
k9zDbUldCWeQlmDWcp4qaTzr7jT/Ms+kN1carxrFJUQaIwoLe0+q04rM7CBy
aCCXV7HJKumJfNy1mI6lHWNdKhJ+6+nz8cWXtXpMWPOv+H61tCwfjy3mPCmJ
wJx33J3z+D5P09ahVlCPZxGJo13ahrutHtklbfN5LW+5SVtuss4r+SirNdKq
nByVyZPuGcpbbNAW1fVLWZS97JD2apW9U8zoU9b0ZU7/454vJgmbe/bkcZyp
2+lRF6hoLWpHfkXbmQQNUMtupEGf6i1NzNFtbdVtrTNtidNJDqlxtyWNmHNc
tNOl21lv2knUM9VobBDajhVhoit6av+Fo9vGY99aWYfsbyD9p+vVQ+2bqv8c
zr719DR6r9ikDIAeW8aWeV7xbM6mdQ+j7Dm9A1LZNauiZxAbG5HfSeL+/QX6
DAdlLe/petiD6WW2JmPGSeKtbEW1VPq5S2a9z9QSbdGn6DQ4bZX3JDe8xZSc
0QQ7k7brK/DT3GfeVKIt+pSSugraclcGNZRolY6T2gpabUzQE8lRW+tIW/Qe
/RqnLfpsqSmk7fpxt7AEtYAtdRBL9CzHlrIn9dL+XEes8H8HRtlYmpB7cbWN
NcQGnIvW36RR+5/l2b+d7D8TeZK1bv5qDaep4pmgllhfTazPYq0vYscIbaeG
2G7TURg87z31U74r5076Gj0aW0lP51tHML+H5ohbPSa9fZfurbRbl2PXaDB4
XZn8vZL0b7a2U59jx31umN0/afdS3S953OtN/JUeb5Pdm2uTua5erPearnuh
ns3SgraSTa3QucZUvZV6otl5SfYXGOTv5XqrJt0D9WTXs5kRlyRZ5OVEeuJt
rC1N1u2pZ8a/3mGTv4I8MhbE77OExXrNQVo8M9iiIYX/mon0UIbepwmr5i/U
SI+XBls1o4LGLfJonqYZyn6eE2zRzMY0njhTW/qLYEvpFcsacZnFRdrbFuv4
2h5lR4BeaRbo/lwA31+Y4Hk528rkVCtgq7cneM7Ltpque3IRbHV+4p/bahMc
AWUWDOd3JmZEB8wOdantTnU3qbRweaAFMw9Y8YV4+e7A/c1dv6s825t5Z33O
99jeOoudmSfUpxcl/rhxVXpk8qOEtj+J7S5K7FGsvHP/YmE06f8BdT7X8g==
\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    FaceGrids->{{0, -1, 0}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{330, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->63313023]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24044],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ticks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ticks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridLines",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridLines"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FaceGridsStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceGridsStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7249]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31434],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingThreeDimensionalGraphics"]], "Tutorials",\

 CellID->242403382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FaceGrids",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FaceGrids"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->44547717],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->113637100],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->360402381]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FaceGrids - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 11.7172072}", "context" -> "System`", 
    "keywords" -> {
     "bounding box grid lines", "cages in 3D graphics", "grid lines"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FaceGrids is an option for three-dimensional graphics functions that \
specifies grid lines to draw on the faces of the bounding box. ", 
    "synonyms" -> {"face grids"}, "title" -> "FaceGrids", "type" -> "Symbol", 
    "uri" -> "ref/FaceGrids"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7895, 264, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->86564627]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 128949, 2715}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2269, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2892, 81, 47, 1, 70, "ObjectName",
 CellID->22039],
Cell[2942, 84, 518, 15, 70, "Usage",
 CellID->6771]
}, Open  ]],
Cell[CellGroupData[{
Cell[3497, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3975, 121, 215, 8, 70, "Notes",
 CellID->1402],
Cell[4193, 131, 1547, 44, 70, "2ColumnTableMod",
 CellID->5761],
Cell[5743, 177, 715, 29, 70, "Notes",
 CellID->15815],
Cell[6461, 208, 424, 17, 70, "Notes",
 CellID->1749],
Cell[6888, 227, 562, 19, 70, "Notes",
 CellID->17722],
Cell[7453, 248, 405, 11, 70, "Notes",
 CellID->643683418]
}, Closed]],
Cell[CellGroupData[{
Cell[7895, 264, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->86564627],
Cell[CellGroupData[{
Cell[8279, 278, 147, 5, 70, "ExampleSection",
 CellID->15819400],
Cell[8429, 285, 83, 1, 70, "ExampleText",
 CellID->490860158],
Cell[CellGroupData[{
Cell[8537, 290, 245, 7, 28, "Input",
 CellID->87871385],
Cell[8785, 299, 9895, 168, 194, 110, 3, "CachedBoxData", "BoxData", "Output",
 CellID->822713056]
}, Open  ]],
Cell[18695, 470, 125, 3, 70, "ExampleDelimiter",
 CellID->314815608],
Cell[18823, 475, 228, 9, 70, "ExampleText",
 CellID->6729609],
Cell[CellGroupData[{
Cell[19076, 488, 449, 14, 70, "Input",
 CellID->195558251],
Cell[19528, 504, 8471, 144, 194, 130, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->660234297]
}, Open  ]],
Cell[28014, 651, 124, 3, 70, "ExampleDelimiter",
 CellID->49944586],
Cell[28141, 656, 326, 11, 70, "ExampleText",
 CellID->438049882],
Cell[CellGroupData[{
Cell[28492, 671, 327, 9, 70, "Input",
 CellID->369339684],
Cell[28822, 682, 10173, 173, 184, 181, 5, "CachedBoxData", "BoxData", \
"Output",
 CellID->100130603]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39044, 861, 216, 7, 70, "ExampleSection",
 CellID->18781],
Cell[CellGroupData[{
Cell[39285, 872, 239, 7, 70, "ExampleSubsection",
 CellID->80772045],
Cell[39527, 881, 227, 9, 70, "ExampleText",
 CellID->18848067],
Cell[CellGroupData[{
Cell[39779, 894, 332, 10, 70, "Input",
 CellID->355539880],
Cell[40114, 906, 7939, 136, 194, 118, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->491205982]
}, Open  ]],
Cell[48068, 1045, 228, 9, 70, "ExampleText",
 CellID->977353446],
Cell[CellGroupData[{
Cell[48321, 1058, 358, 12, 70, "Input",
 CellID->170662451],
Cell[48682, 1072, 7871, 135, 194, 119, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->110929184]
}, Open  ]],
Cell[56568, 1210, 123, 3, 70, "ExampleDelimiter",
 CellID->9238429],
Cell[56694, 1215, 586, 24, 70, "ExampleText",
 CellID->185725235],
Cell[CellGroupData[{
Cell[57305, 1243, 656, 22, 70, "Input",
 CellID->18972493],
Cell[57964, 1267, 7977, 137, 194, 262, 6, "CachedBoxData", "BoxData", \
"Output",
 CellID->248971400]
}, Open  ]],
Cell[65956, 1407, 404, 15, 70, "ExampleText",
 CellID->491690116],
Cell[CellGroupData[{
Cell[66385, 1426, 1341, 43, 70, "Input",
 CellID->13796340],
Cell[67729, 1471, 8853, 155, 194, 537, 14, "CachedBoxData", "BoxData", \
"Output",
 CellID->61220124]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76631, 1632, 238, 7, 70, "ExampleSubsection",
 CellID->323941756],
Cell[76872, 1641, 79, 1, 70, "ExampleText",
 CellID->207632568],
Cell[CellGroupData[{
Cell[76976, 1646, 1118, 35, 70, "Input",
 CellID->522670623],
Cell[78097, 1683, 8521, 151, 184, 668, 18, "CachedBoxData", "BoxData", \
"Output",
 CellID->164737533]
}, Open  ]],
Cell[86633, 1837, 124, 3, 70, "ExampleDelimiter",
 CellID->11240670],
Cell[86760, 1842, 237, 8, 70, "ExampleText",
 CellID->73376459],
Cell[CellGroupData[{
Cell[87022, 1854, 258, 7, 70, "Input",
 CellID->107248101],
Cell[87283, 1863, 10305, 174, 184, 135, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->79363383]
}, Open  ]],
Cell[97603, 2040, 125, 3, 70, "ExampleDelimiter",
 CellID->426631554],
Cell[97731, 2045, 268, 8, 70, "ExampleText",
 CellID->88564141],
Cell[CellGroupData[{
Cell[98024, 2057, 1230, 38, 70, "Input",
 CellID->298470340],
Cell[99257, 2097, 8772, 156, 184, 703, 19, "CachedBoxData", "BoxData", \
"Output",
 CellID->227447547]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[108090, 2260, 231, 7, 70, "ExampleSection",
 CellID->966],
Cell[108324, 2269, 95, 1, 70, "ExampleText",
 CellID->213162192],
Cell[CellGroupData[{
Cell[108444, 2274, 555, 18, 70, "Input",
 CellID->243727893],
Cell[109002, 2294, 15516, 264, 196, "Output",
 CellID->63313023]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124579, 2565, 311, 9, 70, "SeeAlsoSection",
 CellID->24044],
Cell[124893, 2576, 940, 35, 70, "SeeAlso",
 CellID->7249]
}, Open  ]],
Cell[CellGroupData[{
Cell[125870, 2616, 314, 9, 70, "TutorialsSection",
 CellID->31434],
Cell[126187, 2627, 192, 4, 70, "Tutorials",
 CellID->242403382]
}, Open  ]],
Cell[CellGroupData[{
Cell[126416, 2636, 305, 8, 70, "RelatedLinksSection"],
Cell[126724, 2646, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127124, 2663, 318, 9, 70, "MoreAboutSection",
 CellID->44547717],
Cell[127445, 2674, 148, 3, 70, "MoreAbout",
 CellID->113637100],
Cell[127596, 2679, 163, 3, 70, "MoreAbout",
 CellID->360402381]
}, Open  ]],
Cell[127774, 2685, 27, 0, 70, "History"],
Cell[127804, 2687, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

