(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    106321,       2118]
NotebookOptionsPosition[    102399,       1991]
NotebookOutlinePosition[    103714,       2027]
CellTagsIndexPosition[    103627,       2022]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FaceGrids" :> Documentation`HelpLookup["paclet:ref/FaceGrids"],
           "GridLinesStyle" :> 
          Documentation`HelpLookup["paclet:ref/GridLinesStyle"], "MeshStyle" :> 
          Documentation`HelpLookup["paclet:ref/MeshStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FaceGrids\"\>", 
       2->"\<\"GridLinesStyle\"\>", 
       3->"\<\"MeshStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FaceGridsStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FaceGridsStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FaceGridsStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option for 3D graphics functions that specifies \
how face grids should be rendered."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FaceGridsStyle", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies that all face grid lines should be rendered by default with the \
specified style."
}], "Notes",
 CellID->6849],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FaceGridsStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["xgrid", "TI"], ",", 
     StyleBox["ygrid", "TI"], ",", 
     StyleBox["zgrid", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies that different grid directions should use different styles."
}], "Notes",
 CellID->50466042],

Cell[TextData[{
 "Styles can be specified using graphics directives such as ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 " as well as ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " and combinations given by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15125],

Cell["\<\
Style specifications can refer to styles using style names from current \
stylesheets.\
\>", "Notes",
 CellID->797803519],

Cell[TextData[{
 "Any outside styles not explicitly overridden by settings in ",
 Cell[BoxData[
  ButtonBox["FaceGridsStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGridsStyle"]], "InlineFormula"],
 " will still be used."
}], "Notes",
 CellID->3528],

Cell[TextData[{
 "Explicit styles specified in the setting for ",
 Cell[BoxData[
  ButtonBox["FaceGrids",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGrids"]], "InlineFormula"],
 " can override styles specified in ",
 Cell[BoxData[
  ButtonBox["FaceGridsStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGridsStyle"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->39190952]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21285268],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->74995916],

Cell["Specify overall style of face grids:", "ExampleText",
 CellID->117945834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", "All"}], ",", 
   RowBox[{"FaceGridsStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14902408],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  FaceGrids->All,
  FaceGridsStyle->Directive[
    RGBColor[1, 0.5, 0], 
    Dashing[{Small, Small}]]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->618920835,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v", " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"v", " ", 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"v", "^", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], "}"}]}], ",", 
   RowBox[{"FaceGridsStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dotted"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108231186],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJztW2l4ldW15ipIEKeCUtGiGJDSK9iCAxBCXhIFAlJAZFQGZZDLJYwSEAVB
sQIyJBAIpExhCmIRAhVEiGeHGRkCYUwgyBAFwigGKwrUnnP2u9d31rkPN/fX
/VV+lMf3Waxv7Xevvdbab/d5osfAtr3vKFWq1Cn//9zp/zs1/89///XXK+Zq
zZ6vt3psnm9iWlHlwH8fOPVQ+ayDF03DoeVGb9xyzDh83pynaqUXF5q7J3Vd
vLl0keBvLtv3lynv7jbr4p7Pn133iuBn+g+qM+3d3eiYPmtRKD7gu0nn/H4w
pFa1+0L9PHo2/S3/d5E27vhuE/LdJ44H48Q372+PqJGxIMvhv6P9DGsPhw+k
/0HWv+D/ZDwdbDyCxzD+9TZ+wVO43op2vYLvIj9dLD+COz7jiiu94eczxuFd
B2emre1/wTRK+NPwQ/vSfI2qmws5Nb41CW+PKddp7Tlz/kdftfp7jhiH/1jc
/D9+qnzKZH/31Qu7B38n+LY1fU+e7bvDbO763e8//eq84Pc/lFPmQt8dGDTh
+5+XheBRRRsX+v1gX8rPm3aF+Ml55nc9/d/FstZpK58P+e6bQ4NxolPLc1t7
x87Lcvhe2i+x9nB4Q/rPsf4Fr8Z4Btp4BF/E+LfY+AW/yPXusOsVvDf5uesf
QX4Ed3x2G7czwGeMwyPLVRzT/9gZM37lrcldxs7wXe3r+/pI2yOmzP0Xyl6b
+a2ZNXzojhWHDhiHz0rdt3z2mAKTiMcKD35zSvDqm+5oGNtpi9nz9vRh6+LP
CF4v66mjL3TagvFD4tuE4uWPXvpyzpgC1L6xd3ion/fHzGzr/y6++G37aZ+F
fPfT8sE4cW167Dujn0/LcvgHtP/c2sPh99J/Letf8HjGM87GI3gE48+x8Qs+
gesdadcr+K/3WX5WWn4Ed3yOePS9KX4+Yxx+Lj3xzerNT5sDP+xcXPjcVN/V
/0xfUv30djN3Sfu7kkecNJN+eOVoi6y9xuFNm9zbsfmew6Zd3VulN8wsEHxs
zuwZf22abQ6nvLB124FTgnfvOWHFnKbZmP9aekYovvBUx6db7DmMB7e27Lw+
xM8zeyrE+b+Lj80T5+NDvnt5YTBOJB3/69NpT03PcviztP/I2sPhi+i/gvUv
eIKOx8MZf56NX/Aorre7Xa/gs8jPasuP4I7PlJV1lvj5jHF4l2CeHzPRwbox
wRcdzPPPTb/gucgzRcG6sd043NaNXGOC5+iQ4FuD526d2RQ8d0cFvy94Ttfx
nHq4rRu52Bs8156fPcE6kIdPgnXA+27vYN04ho7BujEly+E5tF9s7RHu39aN
Q4JHMp4BNh7BFzJ+W/c8/ALXu92uV/De5KdMsG5433V8dg3WjQkxDrf872c+
v898nsl83sd8NsbhNp+3MZ93C27zOZP5nCu4zedM5o+H23zexnz2/Nh83sd8
9r5r83k/8/nDLIc/S3ubzwYOX0T/Np93C56g4/Fwxm/z2cOjuF6bz56fWeTH
5rP3Xcenzef3YzS+iTwPJs99yHM2eV5pHG55XkueswS3PKeT542CW57TuS4P
tzyvJc+eH8tzNnn2vmt53kSeh2Y5/FnaW55XwuGL6N/ynCV4go7Hwxm/5dnD
o7hey7PnZxb5sTx733V8Wp4Hxzi81L///L/8If9gPjv+wXzGJL1fYD6jnd5f
MJ9xWOcDmM8mLH/AfDYP6nwD89l8rPMTzGfDfI52OPPZfKTzH8xnU0GfFyTo
eDyc8efp8wjmM7rr8wvmM1br8w7HJ/PZp/H95FnqCXneR56l/pDnbeRZ6hV5
ziTPUt/Ic6YJq4fkeRt59vywPpNn77usz+T5w2iHsz6TZ6nn5HkbeZb6T54l
Hg9n/Hm6v5DnbeTZ88P6TJ697zo+WZ9dvwP7IzhvuP4IzhvgvOH6KThvwOj+
C84b2KT7NThvmIG6v4PzgNmr5wFw3jCf6PkBnDcM541oh3PeMIv1fCL+c/Q8
A84bZoCef8B5A5v1vATOG9iu5ytw3gDnDcEdn5w33PxG/k8zn2XeYz6fZD7L
fMh8Psx8lnmS+ZzNfJb5k/mcbcLmVebzYeaz54fzM/PZ+y7nZ+bz9GiHc35m
Psu8zXw+zHyW+Zz5LPF4OOPP0/M/8/kw89nzw/mZ+ex91/HJ+dndR8D7C3gf
dPcX8D6IWfq+A94HkajvR+B9EHv0fQq8D5rx+v4F3gdNbX1fA++D5gt9vwPv
g4b3wWiH8z5oPtf3R/A+aGrp+yZ4HzTj9P0UvA8iR99nwfsgRur7L3gfxEp9
XxY+eR9092vwPg7qG+4+DuoboL7h7u+sG6eQre/7oL7Bcyf6AKhvmEFaT+C5
PmX2af2BdeCcWab1ClDfMNQ3oh1OfcMs0XoIqG+wboh+AuobrGOit4D6BrZo
fQbUN7BD6zmsG+dAfUNwxyf1DacXgfoSqNc5fQnU69BQ61GgXoe7tX4F6nVY
p/UuUK8zHbU+Bup1ZojW00C9zqRp/Q3U6wz1umiHU68zM7S+B+p1ZpDWA0G9
znTQ+iGo12G91htBvQ4VtT4J6nXoovVM4ZN6ndM/Uc7Xaua2A6tMYq1SG+Y2
TWadqWcqThp65/qZy83F2rfSWuzJELz3oogfmmXNN+ndr3ZPHpEpeGbEcn99
fzkmIVhHVwt+JT/qdPOs+Tje4NnqofYjb1Zf6fePytNXb2oe4r/B9atr/PGg
R1qFhbND4nF4V4vD4aPpp5L1I3gxv1tgvyv4zup5S0LiFLwl17XYrkvwCPLw
i+VB8LLkLdnyJjj5RKLGQT5xUfsB+US6/i7Ipy8sTpBPc1yvC+TTVNY8gLyZ
Hpo3wbtqnkE+TSW9LyCfpkDvI8inL2zfQT6xWOcJyCd+0XkF8olknYfYe+3E
msjrF03j+JOts4fsNA/+UCv5+rwik7sqJ7JZw7OmzZoqc3d/dFrwd54cXePY
2ktm5s6vL0z9abbP4VN/KbN5k/+cPD3+q6YL/OfP6dWbSy8d+suOfPNmw3Oz
P956Xvz8PGV7sc9/fjr3ObM0cI6d/eNTZvr9Toy5+nv7HWf/3P21/XVqSkxM
ga0Hzr5i7t6yN3fkI+Kbg1Gh/le9V7wk219HXuj9GkL917i31Qr/utD+4TqX
d4Ws61KXxp0D9Sg1tsvH6SHxd39m2Vk/P2jcoNvZrBB+eg/p4wvUtYRJ6a8l
++tKuH19a49w+57WXnT+moznFRuP2F9hPNNtPGL/W663rF2v2K/heuPsesX+
64ajL4XwKfY9Gkf1COFT7Fdyv/rZ/RL7Qu5Xd7tfYr+dedLF5onYj2M+NLT5
IPa7mW8JNt/EfvLur8cH6u+tPzcuOz2EH5dvL3816KI/32Kc/Z+b3PNAnbHn
TGSjqqcefmObOXilWWSd8idMq6qvn279SaF58vGslKavnhC8w/e9hw3OPWRG
FV4YW2PpGcGLJybcUfnTcTEdzKl7plUvEvxQ4vhdQ3IPIXnv9jqh9qn9+3Zq
80khFk1c069JiP82a2pF+ePB2Wn5/3woJB6Hn7Q4HD6LftKtH8Hz+N0k+13B
U+uWKx0Sp+BNuK4P7LoEb0oeGlgeBG9B3ppZ3gTfOaP+f+O+b03puq8PGdx6
k0lpWpTqK5Vrdk25uqDTQyfNsgPRl4oz8gUvOlb97XP5uWbGxCv9No0/Lfi2
CbGV07uMjVnf4cXi+GnfCp76SGxSUX4uKm9cXzPU/q6cD+/o/NBJzDkTceOH
EP+x9TIn+eNB0sV2lQaGxOPwCRaHw8vST5r1I3gav/uw/a7gPf+Q8khInIIf
47rS7LoE30oe1lseBN9B3qpZ3gRPCubzCbMnmM9ZZnwwnw3rZD7r5AHBJ/aP
bLQu/rBJqZf9hyadPuecvNTMCM4VJ8z3wTltis/ZXw+ex12mU/A8FoifSUdq
xh38Jtf0GTGy8dwxu8XPs8H6+V5MowLrz9lXfbPJT8sPbTYTvrg0/NrMg2Kf
Gawnu1hPPP/H7z7iv/8kxkQE7xmHxf5isF7lY0awXnnren5Hr9orDm1Gu/jY
2qH+ewXr4Qn0C9ZDj5+cKsM/88ePxxt0f2ZOSPzOvoe1h7OPHzagp583bMDM
j+NCeLvMeFJsPP/Dfo21h7P/nOuNtesV+32Mp4qNR+zfCNZP4VPs6+v1iv1p
7lc3u19if6t2q6QQPsV+HPPE1k8v/ge4X5Ptfon9JObbTZtvYv8X5sM7Nh8Q
nlexwXl1Soyzn8A8XGPzUOytnpBJXX2+zI230zOtzpBBvX15ifZWf0imDr+q
RHurSyRTDy/Z3uoVGdTtS47H6hiZ1PNLXu9lzpFW3+iVVZL9s/RvdY/5KMl+
EeO3esjyEu0TND8l25N/q5+UbB/F/bW6SsnxzGL+WL2l5PXe7g/zkLqW+KGu
lUFdS+KhrpVMXUvWRV0r2YTxQ10rg7qW54f5QF3L+y73nbpWr2iHc3+pa0n+
UNfKoK4leUhdS+LxcMafp88Fda0M6lqeH/JMXcv7LvsLUvS5BvsU9ui6AfYR
9NF1A+xfeFrXJbCPYIKuS2CfQidd98A+4gure2Cf8oXVVbCPmLC6CvYpE6fr
NthHzOO6boN9yszQfQHsC2aD7gtg3zH9dN8R+zW674h9D93XwD5iqui+BvYp
k6L7Jurr9Yo9+5SJ1X0Z7CO+sL4M9ilfWN8H+wgm674P9il003MF2Efwjp4r
wD6FhnqeAfsI1uh5BuxTuKnnIuwP6ioFiArqKruEZ/YpcP5xfQpzg/rMAZQL
6jP5Yt87qOdk4YugnuPlz3dB/SeL+o+HWz3qAPUoz88jQX2pgHqUF0/V45bH
40E9amq0wx+lvdWjdsm6BtK/1aPyvf1iPO1tPII3Yvxf2vgFn8b1VrDrFXwn
eXvN8mbCeWN/94m9nVdRWs+r4JyPZXq+Bed8zNDzMDjn+8LmZ3DON5X1vA3O
+WaOns/Bed4k6Xle8Al6/gfnfJOm7wvgnG8e1vcLcM73hd1HwDkfafr+As75
WK/vO+Ccj2r6fgTeQxGp71PgPRRP6vsXeA/FKH1fA++hvrD7HXgPNcn6Pgje
Q80ifX8E75vmrL5vCn5S30/Be6hJ1/dZ8B5qkvT9F7yH+sLuy+A9FB/o+zV4
D0UDfR8H76Fopu/vTo9CY60PgHoU2midAclWN0CO1g1A3QDUqZxuAOpReFPr
G+xrRexroleAepQvTD8B9St01noIqEeZCK3PgPqVL0xvAfUo017rP6B+ZV7Q
eg6oL5nGWl8C9SuTqvUisa+v9StQjzIJWo8C9SjzitbHxL6n1rtAPcqU1fob
qF+Z6VpPA/UoX5i+B+pX7OOi14F6FPpp/RDUr3xheiCoR6GL1i1B/Qrdtd4I
6lFI0Pon+1oR+5oXv8sr6lFO/wT1K1C/Envmp8nRuKla+6W7A+up+Fyv3AB/
TtdqsWN9aoD3M+vuvRbYB4en/rHKMxv88cXsm1yqmn8/Hf5u7PzZPn8efDt9
S05kCN6uz9ImgXMS+fqU/wr1kzi5W79AXi7o1zDmRsh3t9S06ypz8HhiQs/0
LIcPo/08ay96XXv6r2r9Cz6V8RTaeAQfzPgb2/gFb8z1XrbrFbwy+alj+RF8
3eY1EYH6snFt5WFv+euT069isfrIi/76MrvCgJRAPXP4jw3XTn7QX1/iL0S3
DtQ/hy86d3Pgb/318eao3z0Zijc+vO7XQD0dvb1XlVA/vz+a/2qg/mY+81PV
ISHfjci29Trj+wfTf9gwO8vhNWn/mbUXnS2W/kdZ/4KvZTw3bDyCH2b8zW38
gv+J611o1yv4avJzzPIj+MuvVi0b6HMD6+995Ly/Tzqd6sqly+8H+mibhJy6
gb7q8Hbxrc/19/e5tnddnBvow6IHJr364iB/n67YZ+i7ofiR45FDA3NDwdMN
93cK8XO0RvsWgTnAd2P1nUUh323Z0c4NcQ0GtLtnVWqW6G+032DtRU/Lo/+j
1r/gR3U8gkcx/lds/IKf4nrb2/UK3pL8fGj5EZxzqYnS85W5t8o/TgfeeWTG
jZl1se86eb/KudSU03Oaub/vzA8C70UGnx5VHHg/Iu9L7bxnvtDznpn0zkc/
Prdnuxl8//mkwDsUZ885lr878Owj7r1j+KF9I2IWvsV3vrTnfMvfR3jxvFVt
ed96e7ZjV4dWz4f659zL30146+361Wt3Bt7lVLhSpm1o/JyHwXk4y9l3uHb+
gcB7nYpnHn2rKIQfzsn8nYXM1WJf3trLO1vOz/z9hcznpjvj+Y2NR+w5V6O9
nvPNMK53p12v2HPeNl/q+4L5Y70tb4fwKfacw00Ffe8wI7hfw+x+iT3nc/Oa
vteYu5gPI20+iP3dzKs8m1eCM9+QqXEwrzBY+wHzB4N1PGCe+MLWBeaD2aX5
AffdVNA8g/tlKur9Ery83ndwv8xvdP6A+2J26jwE+feF5TPIM4bpcwHyiZH6
fIF8Ik+fU7AeYqA+72A9RBtdH8B6iLa6noD10ITVH7AemgJdr8B6aHy6voH1
0LAeRss9hfYbdP0E66E5qustjup4BGc9xCu6noP1EO11/QfrIT7U/QLsv9io
+wvYfzFb9yOw/yJe9y+w/5qbut+B/deM1v0R7L8mU/dTsP8a9t9oh7P/ms90
vwb7rxml+zvYf80NPQ+A/RfN9fwA9l8s1PMG2H9xTM8n4LyHinqeAec9nNHz
DzjvIUbPS+C8Z77V8xU475lIPY+B855ZoOc3cN4znPeiHc55z8zT8yE475mq
ep4E5z1TqOdPcN5DYz2vgvMeLuv5Fpz3UEfPw6g0de+0t+IWmN6j8u/vWHM8
9cyyZm+TFy8/UZBmsKpDhWr+vx1+ZOwjpdv57bCkzJHAv3P4079+VenG64Pw
90aV4tY8tVDw6ycK+5RLTEGzjLaLmvw0T/BTMSkX/f+N5BatiyMSUwQfOXRX
c/+/R+I9bxdff32Q4PuvxWf7v4d2eaUj2tccD4dPaHAjM7IgDT2z57cO/O3w
mU9dKd/Bb9f/hUnLAv/O4SserrvvH36/L3465uXAdxx+x+fr3wvEkXvowHNN
/XE5/Hz5Cq8G4u429O2CwDocfo14K4tLnA/Qz9fWj+AF+ruCT2GcA2ycgo/n
unrZdQmeSx46Wx4EH0Xe+lneJM5C8jzF8iz4z9yXpnZfBG+h91Hwjdz3OLvv
gm9mnrS0eSL4g8yrUTavBGe+obfGQT7RSvMM5iGg/YM842u9X2B+AjpOkH+E
7TuYtyZsveC+mAE6f8B8Ns00b+B+mV46D8E8N8maf3AfTWedz2D+m0S9j+D+
mn76XIDnwrTT+QDuu5mizxd4XkxPnVdgPpim+pyC58j01/mJFpo3wVdongVn
/iBO1w3w3CFXnxcwr9BS1x/wPKKbPndgvmGUrmO43f/PZd+zzeH7wFQ5R8T5
zi0VJfmx79+S+J4wXfwQ57u49BL92PdysXzX59UH4nyftrBEP/Z9XRLfK3rx
EOe7u5Ljse/x5vB9o8cPcb7TK5kf+05vAd9DjhE/xPmub8z/2U9XbS9+umr/
t/UzmuuqpOPnO8w5fDeYWqKfYvJcoPnku80kvjNML9GPfX8o+y5+iPvC8uG2
floyDxfrfOO70CS+Yyw5ngiei190/vMd6Ry+eyyZn1++HLt/47LL5m8ZZ17+
26IN5uGly+bFrrporhO/b2kQh8Nv5+fff/73P+QZ5NnxCfIM8uz45+8vVvN3
iG/EuHcC58q8ERWo1/Wu3hl1K2R+cPb29y9v+Jx9Ee1vfR+0N2H2/L2M+Hff
5e8+xA/4XfC7klfjRp9J6H/sstkyolKN7++e63N50nHnH2qM2n3FPHHmoyc3
LMuSd4yMB4xH6ol9z7yA78O9+kOc75y9+lOW9ska53vpBXzf69WZzjYebPhO
xePiR/O8zaHxO3tDe9Gr3XppH1PSuXD+yY+zB/kB+RGd/HZ+rO6xk7rHJ9QZ
PiRvG8mPqyd9sKBzvS6fFX6Jex4rfCn2sYW0b0edZCt1ko3ix/4ebQd/j/aF
4F0Sxw5/IGUrTMHeAwl1V/A9wHC+M89i/10r3x3R7KVOE1/djB5TU19p2Xad
2P8LkBwztQ==
   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNm2fcF8XVhnc31kSNFRQbKC32CigWQAVUQCEWYnwNGoOIIFhArAFEUFQk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        "]]]}, {}, {}, {}}, {}},
   VertexNormals->CompressedData["
1:eJztW3d8VdXSjVTpkPAgCBZ6SQSCoCCXjDQhCFKkShFQEAkkoYbQEpDeQemQ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    "]],
  Axes->True,
  FaceGrids->{{0, -1, 0}},
  FaceGridsStyle->Directive[
    GrayLevel[0.5], 
    Dashing[{0, Small}]],
  PlotRange->{{-0.9999998571428571, 0.9999998571428571}, {-0.9999998571428319,
    0.9999998571428319}, {-0.9999995714286326, 0.9999995714286326}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->311479516,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Specify the styles for grid lines of each direction:", "ExampleText",
 CellID->149808734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", "All"}], ",", 
   RowBox[{"FaceGridsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251390686],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  FaceGrids->All,
  FaceGridsStyle->{
    RGBColor[1, 0, 0], 
    RGBColor[0, 1, 0], 
    RGBColor[0, 0, 1]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->453309525,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Individually styled face grids can be used with ",
 Cell[BoxData[
  ButtonBox["FaceGridsStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGridsStyle"]], "InlineFormula"],
 ", and have higher priority:"
}], "ExampleText",
 CellID->88564141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", "Red"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "Green"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", "Blue"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "3"}], ",", "Thin"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "3"}], ",", "Dashed"}], "}"}]}], "}"}]}], 
        "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"FaceGridsStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Orange"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298470340],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  FaceGrids->NCache[{{{0, -1, 0}, {{{
         Rational[-1, 2], 
         RGBColor[1, 0, 0]}, {0, 
         RGBColor[0, 1, 0]}, {
         Rational[1, 2], 
         RGBColor[0, 0, 1]}}, {{
         Rational[-1, 3], 
         Thickness[Tiny]}, {
         Rational[1, 3], 
         Dashing[{Small, Small}]}}}}}, {{{0, -1, 0}, {{{-0.5, 
         RGBColor[1, 0, 0]}, {0, 
         RGBColor[0, 1, 0]}, {0.5, 
         RGBColor[0, 0, 1]}}, {{-0.3333333333333333, 
         Thickness[Tiny]}, {0.3333333333333333, 
         Dashing[{Small, Small}]}}}}}],
  FaceGridsStyle->Directive[
    Thickness[Large], 
    RGBColor[1, 0.5, 0]]]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->93020362,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVnQuQHEd5x8e3u3cn3Uune8mWbckmAit49MQWsk0ZQgxxnJNAD8tv6SQL
WzpJp/fz9m5vBTLGxpaxJWNj/L6DkJAQklSqUqRSpPJOCMSBEBwTQggEEkIs
W5JlW1NJ99c9Pd1ff93Te3fClSs9bnZnvunvt909/f2/b3Z6+3bfvXFr3+5N
G/pmf3Bn3/a7N23YNfsDAzvZS4Xzoig6zv4+NyNiv/8v+w3+Hk+SJIrWs38L
GzduXAhb69i/dWyrjm/xlxP4iebDu3fId4vy/wXw6q3SQr12DPtXHnOz3HcK
+e4a+W4T3yqq87Ff5sH7q6TtFr5VUu9LGzHss0LamObZZ7m0Mx35hf38Rdi7
V1rsCtr7Br53FCU96N0C2p4Le/+KbAl1RBFtXwZHfEC2puA4D33UL8ujSo6j
Smj7HXDU+2TrGuRRM3LOJY66Vp5rquMofK63w1HXyHM1O46qR9tz4Kir5Lna
5FHsb9QddOS7k6wnNrKj+NFR4Y+vO/wnHzzMNqOp7G8TOrIBbf8CWLoCzs1+
QWRK3EzDkwuqzy6sji2s/vq7qr95ZfW3l1a/fHVVnK31K790WJzwT68//Be/
Vv3rZdWvfaj69ZXVF1ZXv7Wm+u1bqi/eVn3pjur3+qpFbiqoNYulX7xFvBUF
3ormT84bOTpv5JH5I4/OH/nMgupTVKOgTdMD2/QvfdXvb6j+YOPIj+4a+fHm
Ed4+3MMb0fbboH0Lk2xOAWod8LL8GYkrH4sr98YjqsGfdjdYUOwObfE6o8X/
uWXkp9tGfra98vKuCjDSWjoFtfxSaOI82UOLquXsqN3x8P64Uo4rnpY/52j5
zPG0fJPW8p2VV/ZUTu6rnD4wzCc33mvJll8umcNI6Ob7JfzP9nh4Tzx8wGr+
Q97m/67sKXTrv1F7609B688MDXEqFvtLwIO5SXZV4XtF3evjIeHFjjwvnvB5
cVGOFzdXv2N68UO/F+Wh1ytDb1aFL3gEzAZf3iE/jYbUl8LNcfmOuLwh5kfx
fqW7VI0rR+LKJ1KXjiGXFkmXvgQuiX41O6dfUT79B/OpP8ensx8tJ0fKxEwk
/Joj/QKv69luH44HV8WDyjnk29C4fOsZn28/0X3bXWFz1VAU1Z8pD78+PPRG
6lny8UH+eeDrxSzwjvfDOvZ/6iF8cvUfig8xL1fHg7fE5bVx+U7Ny73x8MHM
yxHm5QOml09rXn5xieFll8fLb3q9/C/wkq1NmH9NJ/eqjxA7mnxiMPnkIeil
+Cou/J2tXoXZQozLKeyX5fFB8Fo4XlaOy7670+v5Y3me+64/Hs/h85wmPlzs
9Qj2OnnwUPLQQcLzi8Hzi2U/hgua9B76NF8SLIsPKAAr4sEbNQC2/4fD/b9G
+t9Wg//rq6Ifd/LPfevIf6e9+1UGYL8bwP0SQPLwAYLBReDzTDnfFmSvhxHf
xHbvjQ/YCG6Ny+vi8ka7DwwDg3tSBp+SDKo6gy9YDFoCGYhePsPo/oDhf3ZW
TlAY3jxsYnhAYkiO7SfWL4LE+dq1k5Ooz0jsBxgHUxiDGgxJonNbPCxgHNJg
3GfC+KwDBrCY6mcBn/9M1hn+dX31B3f6OJw+yFFkHD7GOJQzDkcFhwPJo/sj
gsWFwKI70eKBlEUzsNhH4lgTl28DHIrGrnh4n4PGcZPG5wgajS4a0BNm8Z5x
qxwdAKT6w49oQAZ8QM4yIPeYQD4lgSSP7eNMcLwnmHQmWrTDtiG6aQEme/1Y
+lQvGZgolxLiIuaFS7PxolH5txqoDFFUDioqyWf2ElxmApfpkkuz5ALzTCtw
2ROCxiZT0cg8GEqmIMhwHNBH5sgus6Kqw/lnBOfuWuDca8J5JIOTfHaPNZIu
ADptciS11kBnZTx4U1y+naIzCHQ+atF5PKXzvKBzhUkHiMzFoykczY7KiV0m
miELzX2DBprjGhqi7wg6LbLvtEs6wLAN6OwOAbReXYkYIYjQMkIfZ4TmcUIP
ewmJEXT5V96P55u/9RL6d5LQHkaoIgidCSH0aUkoeWo3weh8xUh/dVq6PoUN
YLXTgeuQwLVKwwW02rdLWhWC1nyalhhV8/m1G8IxP7B/DAbGo1oFTEUfChhf
xJnAHpfAkmd2WmMOtKSoWXuVL+/adWKl3nhHb7wLiHFcUR0DFk1ZZiFDsVor
yex+ihn0qALvXldla504A/arBrC/X+UFtnkcwGC1kwHblzwhgO2iRqLGzFBi
034mxDHezQxuaTfjS8SojlGLSiS3ZsWtTHF7lHFbIK7q9cbIvErN7OMh9yOL
nC6gGOSOWOQeNsk9ycmdfW671dt6MnKW/tyW0ptu0ttj09OCLBRDT0HCjWJ3
dN6ImLcaWY97Bs1pGbl5QeRur37XJPdjSW6EkXvZIqdLBHyFjcgdM8k9zcjt
IHqdxs6jtDfpI7e9Nx4IxChCNdUH623pCOg1qQ6IMP7WkurvaGM34/hnfo5r
MUcuHw2M/GycHPcDx72S47M7zj4/gPtgN8kR75WuWVMNFkjupEge1CM+O+ov
6iRh1LaqHpkLE1jOn0SWpzSWtuZhsBQrNZMlFf90kTxx7DxlfDxF0Kjz7GQ8
GUXxR4ma92siPuP5pOK5uEaeNxo8v9dn8dxG8SxTPI0oWlv5BvHE+RWsvDWm
PHmQ1Rtv7Y23u1c1dhAOPBOxQukQggQp1Ns4f8Ma6/N9c6bNc4PFk5BVU3HG
ViWOWjzZ2obz3Cl54p7XSfKkMkbAs30cPMWVpYux0CWuCdO8PozmRormboJm
qm0MeoJWWCnuOvsMp3l6tD+QJlbzU0Uoag2nCQxnrIuHNqbpC6SX+mF+3oQ5
Dpbf97C0dFNaJ7JiXLaI5Cyf235mdIuV3e0gWeIsTyllKdSkbXBBd7KEEV20
1IIupbbZOB/Ssp8unHTf/CuL5z/ZPO9y8LT0R1pQscK+BHi+MbrVmhOnkzxx
3q+Y8pyi8dyFeMosiAqec2keeQtpUmquW4HBMSFfqJ8d3RZIE2+nKjhMoCZN
EStyjlNQeK3LNZEiKvSag1T6yyC6sDoaRPQGSfTv3ESJlHeIpkVH2VnQKIni
a0w7SRTFkYm2fi+o9bvoj0366t1HU9cGzy3NF22aaQrYq7JTNO0QPA2HOE18
jYEqJmt0t6Jt6JsF6Jt3M5qiP7aS4RCSMjT1pwup0Ch5pyoCxs/zHxjPm9w8
IXlJ81SBOebpCMzV0jOMZ5veO0HHKsgRTS7eKW1DVx0nh+SCfJK3YJKiOMGT
/8kRh9wB5omxTZhlG8mSEwZ6zdAft6SrIhqjrRA5KR52U3zWovh7Toq9FMXb
qi+ZFI30yA6DYlKO8oUiR2j56tjmMIoiLzAkUm6iSyahi0xDM1KjW+htKMf0
FtBk+PSkgaCZL3pkgWUWCJ0a68fryFaSZpPsk+o63lEjTK536OplV6peEhk7
VeKRS7ND0PxqLs07ME22Xi6zOAIlFjBFT3ieBUDbXxvdgnm1kBSnyD6p4p4O
9l4gxRV+ioNeik8hiu82KHaG9kmqXKaOc7yAFNGdNMngPA2BXh/dStPEPbVB
9slGs0/mRD524YlNszIRmi2BNNlYYuRm07OlYukR4nyhuQx/3hzdSq4jHdHj
kNKFDZY46iH1DR/LClW3EcKy2c/yW8Cy6OVoiMPlIbqaxxdGymV6GMc62SfT
nD2sz4s6yDqGMWr2C0VaNVTXDjKjaHJ8YlI4wki+VJRFkTQtORMVBbmDciuM
xDpwk01T1hu0JWaOcUAPHXmOcV8W7+A6CKQJdwmNnczOOlleiVmWEEsxji/T
Sb6oFZhZJElh2JSLfAE5DnhwFnuqIsnpTU/HcyOM5812pgeytFOXOfCtM3ui
ylCQ9B4LoFfU6RXd5GQ1lpHbziGHQxsPOVhKusnhaFxT0PvdGQmsXajSrY2S
YPcOR9bxQbOwT9VaY4K83oQRW5A7lGmMkH2kMz2kIuSMuI0V+Stjmzk5HvyJ
UYzX56oPojUjHc+QBCNdT0MJRx3hcS/CqDgxes48mY+euQK36J0c64d1jKwU
tRTeSaR5k1kzl6mTuTSfVsX/Ok3oi4twxQrF9NuYqayD8ubKgpnKGDGLak6P
9RcT+x66AKbNeVENjriRotamK756pux+rWBKMRUES6JEH82TiyYB6vYUair8
vhYE1RnkSKZ4hgxi6lmV5zBtQSo6ZjpfMhURXTFD+Z4qTXJZDkkilWsmJHyV
ej6SWYAjqzprHu1BsQ2pqHUPODI7qsRAlYIyjMatPgbNhZNIkxYonRKGK8TZ
ZlXy0SyNarXpYcENqQTVC11NZwlXlmZUrvbzp4hlteBA8ey5pbjCTVHP5cBK
uuWoVfen38rEQH4ZQEZ+kt841yTp4AZyEDi7AAytPI8a2/UwtjfpsY0/StSF
oDqoz2DcOk21PEuCy/IhN8zfz+uVOsvvBLD0Sea5LFH+oUaWIr+4uYY40dAu
iibJwyTJBQ6SVyuSzmvOxEn6RDVvuHNibBMe4TksRcy4xY54RMzoRwljuWs3
lX4Ih+lYC+k0V781NF8d21wjTVTj4oofOU1gV0DqRbetmOs4Hwnum3/kp7km
iKaWGHMJvh45SI+CZB6iRpotYTQPiRFdyKrZTJaZ0jvJLFeOi6UpnkvB1653
yeLx/TZLtlCvkaWzNpCh0yNJtunQhrpJtRdVEtA8lwbw/HAeT604I0vaUgK6
IbDp+gbKkanAB0qyaJ44tuxIeZbQWl30wSa/xKHu/ezeEcBSVQ1NiCXcBmoU
+GulGVkpAUpGpCI6IbmR+UaN5RujW/H1vIFkmfZNUz/nMGFuLFqxYz3SOJDm
ZtN8wFGD9blwmsslzRdImhs0mv0emm4BMy/0YUvN2mjCrAmDOmfVHoUw1ZVg
Vyb83DEl0zy1aEeTwBQUh/bAMNJQNgpujvd5OX4hhGNv9W9sjnArz3fXaeXA
7nTZxDjKMCicY9TNqzPKEXTNTebaPVTmgJ7ZgxRiG+oxF9QlGdSoZqr+0pea
qJp3TcuASFCFhWcYVa4u8ZlS1WuIGLM/LMb0sd1rJjBC2H7RYrt4stj6VGNU
WRQQbL4yttlSQQRfXJPN+RZ1vo3pGiokViJVpR5bOyaTvZPK1yp+C+U7rqDp
5Fh/IF+xVuVTgtiuQ9tFizuOA1wxqtJO/t9wP30orYitIVg1QoLTjDueN+pJ
7iU5bzRNIt8BS78nE++Y7xXnjG+WbfIL0MF8Wcg1Xr6592X5NBbFd5eVHwnk
+6Wa+H6zJr52umQcfNOMiY9vWncMCwhDn+7wJ570hL1efKOqmHqQRm3nSH/O
bCFTWqtYrcsFVkj2ppNtUa5wayG6fJKJLvQRvZAk+rVaiP7UIgrfW9Xlkwad
goGWS3ET5aO/gyRKrncx0TUeooe0zN74iM6YHKLbK3xIRj2sd742CINfF7OU
MOgTDIJYkuqLUAb9UcQBHOOmMoxStHr0am+UL3VSXUxT7dKp/vkNh0OppsVP
4GY0EwnYOllK1vKQdeWpgshuzo3PJkQ2rZEIIjt9fGSB5yxXZoCBZcOf7VK7
KpOlWiy2JT9bEZ/puRYRn5XylZl18RBiu1/LBFK1EkaZnottWy5b/cZY0Ucv
NWql3HDZYpbtHgTXCtJeHdtcI9sGaw2b5QSLOlzFdlUY2yNEBUUQ26ZctrCo
iebwLqvV9vzEnYHhYFNllh3qA+uIfk8SUULNZPcoss25KliqJ/YoxTuc7Ocd
ZBtdZKF/zlV3I760Fr6A2VE3pdgKnfa1Q8O6ssBB3ONXFnDke5qIEHLY+iOv
Jo9i06dlE3qU/u2qDdBrJv1sS4itGPOX6/NBBjc33bUnAG5Y+HVmdAvNFldU
dsD6S7HdZkddLrar/WwHHdUC4WwLgi0HCivQ+arjft3G684m2jkGhJfNC5zH
vTVEX28QEYKbr1rXNroiBcb4AP9eMKI8SK/7m7E1HqYAGxUEIYDhe/o400X2
rIDhelO1HK52b84pGy4EC5xHDtws/CJ08gC2IXGtIcng+2uVTj4+ttAw6Lfv
QnPCX06M7CskWS0M40AIsmGZHD9Z+Eodcf+3J3Ig5Rj9rtvpeg4inC3MpUtV
p/2Da6t/+L7DQXC99W0872hlIU4ruFaMy7HocD1xWRviWAyh648eCP0A0W1D
dFGCHNEVV6j32HOCjverHrzW/QAYL5XkYXh5pTUlyki8PgkBgrPnt71MxBBB
hPsnSLg5hDA//Uz+NUpzMBO3iC2W/qRQxZ3xB6wqP0Mzwd9v12kyMeKqcTBp
HNByXzoTvkrnz76Y+ewLCf/C/mgW7b0KfGzvYQ3JW05GlTnr8xzv6601pIgq
W1BU6VeYSrr36YM+LmMew/NZLuAu7ne4aIYgvIXe2O7UWH+NHvoiEDq2W2m6
CPWz0qcFzCd4kkmPcsWowTKjKd6aY84VP5UToH1Rq9LJ8YUZvjL1o9OvDfE2
EM3nt3u8blfquFuv1iX12qJaNt/R+oJqvVxLJNHVaavbqZz4QbOxxgqVa9j4
alTIb20DuYoS31tbQjEAGHk/ayE8taLNDk74ORwLPEfb4D/xIkxTQe0qiHap
OIEDY61if6Lr0ta1oOURP8fjIVdwd7vg5kiPqirXg9ENaRuassXZo9CACZ29
3l47gD7CaUTiZ3l65qnqAsKtGBfVgRO2duQ5a0FdO8Q6omR89Rf7Wcmx82da
EOdzaVXu86XnMC5TMDetTn1rYBj5UTlXBfsc8H18TXyD+CaUVBBjPzdzjxq4
R0/s4Xvr+gX+vOqss/BvruGfi4j/yPOwA27l5+AXS+YGV6rSGN5lP3uFC9B8
E+ovS/pcw9t+O7fLL0ms1dyuiFzzrU6VVsUz85RVttNabpE/mEuYe3N0W761
9G5O8ZmIkcxb18dtFaQtovfblgqS5jRpiQUm27ilDZol/pb9XVaWJfZrp7TC
B5FhhTWGdzzaCn+hRx7ZL6aa6M70SLYc40fiig77/KmFLdgC67zUuc8zehbf
Q1jI5rqNqQWxi9UGYQGvlDspK0VhRRjCd+UJO+nzGcnjS+p42Rb8TRHCBq7Q
moZs3UXawt+EImw1JNoTGsdpA9/F2ULZKihb1pUUV5MLq/hczTlW8SfErZ7H
Nrk1YbEpyZ6CoVv6CLKEKy3qLUvk/f6OPpVawOqBabE1yZ5c4rOEWRUtS9NI
upnFO5FFfFeebbE9x+IGZBH3h4JlMX0eCba0HlnC/b/OstRJkNUt9iGL1LeZ
pxZFiKeezadZWYuswCxTUlYSMTqEDfoZoJmt25GtNo+tGUn2VFfdxm3IBnxC
xpMBxPEXEN7WpddN7fgObb/s7DOJz1FvxRpkJaUnjr7Q0fbV6Kge4xO42NHi
lXLdcr5xjlmOcywnWgbxNRx1ieMcvfIcnEYp7Z3iqY2IAt/rerl3u7QtvsXn
bYnxbFe1km5LtCuweOop6iO8udfKuKVZtkB89/Hbk2y08HeXyr2apE3xDJLL
kM1078Vy7ynS5kWw99wkm2/4ZeudbC/+f6O0KZ5V+U5kk5+RL7dmy4g93Vs8
NfZytLf9PaP82a6t7Nip8ljeHvGk3jjR5+bMBm81fxRPqzyTeDbxfGIvffsS
ufdi2HtBkj1dVt/rQtmCJbDXIvQunrNnSJvXwN7pk12pO3e4zffCXlcQfUff
TnvFdbD3lehd6kkLfO/rYe8lSfbsVtxu3oJe2Gup9i4f2UVpYwW8y5/YW8+2
boSt6Lz/A8DNt9E=\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FaceGrids",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceGrids"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridLinesStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridLinesStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FaceGridsStyle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FaceGridsStyle"]\
, None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->25198205],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->46661728]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FaceGridsStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 12.3422232}", "context" -> "System`", 
    "keywords" -> {"styling of face grids", "boxed  grid", "box grid"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FaceGridsStyle is an option for 3D graphics functions that specifies how \
face grids should be rendered.", "synonyms" -> {"face grids style"}, "title" -> 
    "FaceGridsStyle", "type" -> "Symbol", "uri" -> "ref/FaceGridsStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7232, 235, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->21285268]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 103485, 2015}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1607, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2230, 65, 1579, 37, 70, "ObjectNameGrid"],
Cell[3812, 104, 490, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4339, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4817, 140, 239, 7, 70, "Notes",
 CellID->6849],
Cell[5059, 149, 333, 10, 70, "Notes",
 CellID->50466042],
Cell[5395, 161, 1004, 38, 70, "Notes",
 CellID->15125],
Cell[6402, 201, 131, 4, 70, "Notes",
 CellID->797803519],
Cell[6536, 207, 263, 8, 70, "Notes",
 CellID->3528],
Cell[6802, 217, 393, 13, 70, "Notes",
 CellID->39190952]
}, Closed]],
Cell[CellGroupData[{
Cell[7232, 235, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21285268],
Cell[CellGroupData[{
Cell[7616, 249, 147, 5, 70, "ExampleSection",
 CellID->74995916],
Cell[7766, 256, 79, 1, 70, "ExampleText",
 CellID->117945834],
Cell[CellGroupData[{
Cell[7870, 261, 326, 9, 28, "Input",
 CellID->14902408],
Cell[8199, 272, 10173, 173, 184, 181, 5, "CachedBoxData", "BoxData", "Output",
 
 CellID->618920835]
}, Open  ]],
Cell[CellGroupData[{
Cell[18409, 450, 841, 26, 70, "Input",
 CellID->108231186],
Cell[19253, 478, 58514, 973, 194, 27452, 459, "CachedBoxData", "BoxData", \
"Output",
 CellID->311479516]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77816, 1457, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[78040, 1466, 95, 1, 70, "ExampleText",
 CellID->149808734],
Cell[CellGroupData[{
Cell[78160, 1471, 323, 9, 70, "Input",
 CellID->251390686],
Cell[78486, 1482, 10758, 184, 184, 188, 6, "CachedBoxData", "BoxData", \
"Output",
 CellID->453309525]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89293, 1672, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[89534, 1681, 268, 8, 70, "ExampleText",
 CellID->88564141],
Cell[CellGroupData[{
Cell[89827, 1693, 1230, 38, 70, "Input",
 CellID->298470340],
Cell[91060, 1733, 8771, 156, 184, 703, 19, "CachedBoxData", "BoxData", \
"Output",
 CellID->93020362]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99892, 1896, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[100211, 1907, 716, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[100964, 1938, 305, 8, 70, "RelatedLinksSection"],
Cell[101272, 1948, 370, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101679, 1965, 299, 8, 70, "MoreAboutSection"],
Cell[101981, 1975, 147, 3, 70, "MoreAbout",
 CellID->25198205],
Cell[102131, 1980, 196, 4, 70, "MoreAbout",
 CellID->46661728]
}, Open  ]],
Cell[102342, 1987, 27, 0, 70, "History"],
Cell[102372, 1989, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

