(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41410,       1623]
NotebookOptionsPosition[     33231,       1332]
NotebookOutlinePosition[     34601,       1370]
CellTagsIndexPosition[     34515,       1365]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorTermsList" :> 
          Documentation`HelpLookup["paclet:ref/FactorTermsList"], 
          "TrigFactorList" :> 
          Documentation`HelpLookup["paclet:ref/TrigFactorList"], 
          "CoefficientList" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientList"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "Decompose" :> 
          Documentation`HelpLookup["paclet:ref/Decompose"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FactorTermsList\"\>", 
       2->"\<\"TrigFactorList\"\>", 3->"\<\"CoefficientList\"\>", 
       4->"\<\"Factor\"\>", 5->"\<\"Decompose\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Polynomial Algebra\"\>", 
       2->"\<\"Polynomial Factoring & Decomposition\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FactorList", "ObjectName",
 CellID->727],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FactorList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FactorList"], "[", 
       StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the factors of a polynomial, together \
with their exponents. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5680]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first element of the list is always the overall numerical factor. It is \
",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}]], "InlineFormula"],
 " if there is no overall numerical factor. "
}], "Notes",
 CellID->19831],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorList"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
 " factors modulo a prime ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2397],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorList"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    RowBox[{
     ButtonBox["GaussianIntegers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GaussianIntegers"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " allows Gaussian integer coefficients. "
}], "Notes",
 CellID->20329],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorList"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " allows coefficients that are arbitrary rational combinations of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29497]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->227313469],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->97706867],

Cell["List factors of polynomials:", "ExampleText",
 CellID->28478175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341858652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"x", "^", "3"}]}], "+", 
   RowBox[{"2", 
    RowBox[{"x", "^", "2"}]}], "-", 
   RowBox[{"2", "x"}], "-", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->513832183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->961876033]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11535],

Cell["A univariate polynomial:", "ExampleText",
 CellID->242436578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"6", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"11", "x"}], "-", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6972226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509956456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606606440],

Cell["A multivariate polynomial:", "ExampleText",
 CellID->242121446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"x", "^", "3"}], " ", "y"}], "-", 
   RowBox[{"2", 
    RowBox[{"a", "^", "2"}], "x", " ", "y"}], "-", 
   RowBox[{"3", 
    RowBox[{"a", "^", "2"}], 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"3", 
    RowBox[{"a", "^", "4"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->685335161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "-", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"2", " ", "x", " ", "y"}]}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{303, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193073195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450536112],

Cell["A polynomial with multiple factors:", "ExampleText",
 CellID->95832622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"x", "^", "8"}], "+", 
   RowBox[{"11", 
    RowBox[{"x", "^", "7"}]}], "+", 
   RowBox[{"43", 
    RowBox[{"x", "^", "6"}]}], "+", 
   RowBox[{"59", 
    RowBox[{"x", "^", "5"}]}], "-", 
   RowBox[{"35", 
    RowBox[{"x", "^", "4"}]}], "-", 
   RowBox[{"151", 
    RowBox[{"x", "^", "3"}]}], "-", 
   RowBox[{"63", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"81", "x"}], "+", "54"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205321610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520322520]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137525866],

Cell["A rational function:", "ExampleText",
 CellID->250609994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"2", 
       RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}]}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"4", 
       RowBox[{"y", "^", "2"}]}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->582901814],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"2", " ", "y"}]}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", " ", "y"}]}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{451, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472503243]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28543],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Extension",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26223],

Cell["Factor over algebraic number fields:", "ExampleText",
 CellID->8503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", " ", 
   RowBox[{"Extension", " ", "->", " ", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7976],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       SqrtBox["2"], " ", "x"}], "-", 
      SuperscriptBox["x", "2"]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{
       SqrtBox["2"], " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{317, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178745558]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], ",", "I"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->19102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox["2"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox["2"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox["2"], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox["2"], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ",", "1"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{402, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221397743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1472],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " automatically extends to a field that covers the coefficients:"
}], "ExampleText",
 CellID->92225876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{"2", "+", 
   RowBox[{"2", 
    RowBox[{"Sqrt", "[", "2", "]"}], "x"}], "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{190, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192105939]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "2", "]"}], "x"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"Extension", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6669],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox["2"], "+", "x"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{145, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39226582]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GaussianIntegers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->160439818],

Cell["Factor over Gaussian integers:", "ExampleText",
 CellID->520967426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"1", " ", "+", " ", 
    RowBox[{"x", "^", "2"}]}], ",", " ", 
   RowBox[{"GaussianIntegers", " ", "->", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32901353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", "+", "x"}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80284557]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"1", " ", "+", " ", 
    RowBox[{"x", "^", "2"}]}], ",", " ", 
   RowBox[{"Extension", " ", "->", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->544366111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", "+", "x"}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161962323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->435291713],

Cell["Factor over finite fields:", "ExampleText",
 CellID->225502292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{"5", "+", 
   RowBox[{"x", "^", "12"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151353667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "+", 
      SuperscriptBox["x", "12"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{138, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10446444]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"5", "+", 
    RowBox[{"x", "^", "12"}]}], ",", 
   RowBox[{"Modulus", "->", "7"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49860741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", 
      SuperscriptBox["x", "3"]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "+", 
      SuperscriptBox["x", "3"]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "+", 
      SuperscriptBox["x", "6"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{284, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->432337607]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18082488],

Cell["Factor a trigonometric expression:", "ExampleText",
 CellID->47505639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51431388],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["x", "2"], "-", 
       FractionBox["y", "2"]}], "]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["x", "2"], "+", 
       FractionBox["y", "2"]}], "]"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{284, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116838186]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26938],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorList"]], "InlineFormula"],
 " gives a list of irreducible factors:"
}], "ExampleText",
 CellID->289317600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"x", "^", "8"}], "+", 
   RowBox[{"11", 
    RowBox[{"x", "^", "7"}]}], "+", 
   RowBox[{"43", 
    RowBox[{"x", "^", "6"}]}], "+", 
   RowBox[{"59", 
    RowBox[{"x", "^", "5"}]}], "-", 
   RowBox[{"35", 
    RowBox[{"x", "^", "4"}]}], "-", 
   RowBox[{"151", 
    RowBox[{"x", "^", "3"}]}], "-", 
   RowBox[{"63", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"81", "x"}], "+", "54"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271634407],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7878625]
}, Open  ]],

Cell["This multiplies the factors together:", "ExampleText",
 CellID->156932469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "@@", 
  RowBox[{"Power", "@@@", "%"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->199469494],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}], "3"]}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245575619]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " gives a product of factors:"
}], "ExampleText",
 CellID->18880447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "8"}], "+", 
   RowBox[{"11", 
    RowBox[{"x", "^", "7"}]}], "+", 
   RowBox[{"43", 
    RowBox[{"x", "^", "6"}]}], "+", 
   RowBox[{"59", 
    RowBox[{"x", "^", "5"}]}], "-", 
   RowBox[{"35", 
    RowBox[{"x", "^", "4"}]}], "-", 
   RowBox[{"151", 
    RowBox[{"x", "^", "3"}]}], "-", 
   RowBox[{"63", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"81", "x"}], "+", "54"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->333991352],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}], "3"]}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->280004706]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " combines all the factors back together:"
}], "ExampleText",
 CellID->38308230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4415914],

Cell[BoxData[
 RowBox[{"54", "+", 
  RowBox[{"81", " ", "x"}], "-", 
  RowBox[{"63", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"151", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"35", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"59", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"43", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"11", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  SuperscriptBox["x", "8"]}]], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->9315703]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450976876],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorSquareFreeList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFreeList"]], "InlineFormula"],
 " gives a list of square-free factors:"
}], "ExampleText",
 CellID->377259608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFreeList", "[", 
  RowBox[{
   RowBox[{"x", "^", "8"}], "+", 
   RowBox[{"11", 
    RowBox[{"x", "^", "7"}]}], "+", 
   RowBox[{"43", 
    RowBox[{"x", "^", "6"}]}], "+", 
   RowBox[{"59", 
    RowBox[{"x", "^", "5"}]}], "-", 
   RowBox[{"35", 
    RowBox[{"x", "^", "4"}]}], "-", 
   RowBox[{"151", 
    RowBox[{"x", "^", "3"}]}], "-", 
   RowBox[{"63", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"81", "x"}], "+", "54"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->424255709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{281, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62326940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->676304820],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " gives a list of prime factors of an integer:"
}], "ExampleText",
 CellID->107302986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "1234567", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6910716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"127", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9721", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109626757]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "@@", 
  RowBox[{"Power", "@@@", "%"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45160120],

Cell[BoxData["1234567"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219454463]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2191],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorTermsList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorTermsList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactorList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decompose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Decompose"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15457],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->16337]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->514138361],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->454370699],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->657602115]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FactorList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 17.1704718}", "context" -> "System`", 
    "keywords" -> {
     "factors list", "irreducible factors", "list of factors in polynomials", 
      "prime factors", "unique factorization domain"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FactorList[poly] gives a list of the factors of a polynomial, together \
with their exponents. ", "synonyms" -> {"factor list"}, "title" -> 
    "FactorList", "type" -> "Symbol", "uri" -> "ref/FactorList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6234, 208, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->227313469]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34372, 1358}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2446, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3069, 85, 46, 1, 70, "ObjectName",
 CellID->727],
Cell[3118, 88, 526, 16, 70, "Usage",
 CellID->5680]
}, Open  ]],
Cell[CellGroupData[{
Cell[3681, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4159, 126, 258, 8, 70, "Notes",
 CellID->19831],
Cell[4420, 136, 473, 18, 70, "Notes",
 CellID->2397],
Cell[4896, 156, 503, 17, 70, "Notes",
 CellID->20329],
Cell[5402, 175, 795, 28, 70, "Notes",
 CellID->29497]
}, Closed]],
Cell[CellGroupData[{
Cell[6234, 208, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->227313469],
Cell[CellGroupData[{
Cell[6619, 222, 147, 5, 70, "ExampleSection",
 CellID->97706867],
Cell[6769, 229, 70, 1, 70, "ExampleText",
 CellID->28478175],
Cell[CellGroupData[{
Cell[6864, 234, 149, 5, 28, "Input",
 CellID->24660],
Cell[7016, 241, 435, 16, 36, "Output",
 CellID->341858652]
}, Open  ]],
Cell[CellGroupData[{
Cell[7488, 262, 256, 9, 28, "Input",
 CellID->513832183],
Cell[7747, 273, 435, 16, 36, "Output",
 CellID->961876033]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8231, 295, 216, 7, 70, "ExampleSection",
 CellID->11535],
Cell[8450, 304, 67, 1, 70, "ExampleText",
 CellID->242436578],
Cell[CellGroupData[{
Cell[8542, 309, 235, 8, 70, "Input",
 CellID->6972226],
Cell[8780, 319, 564, 21, 36, "Output",
 CellID->509956456]
}, Open  ]],
Cell[9359, 343, 125, 3, 70, "ExampleDelimiter",
 CellID->606606440],
Cell[9487, 348, 69, 1, 70, "ExampleText",
 CellID->242121446],
Cell[CellGroupData[{
Cell[9581, 353, 380, 13, 70, "Input",
 CellID->685335161],
Cell[9964, 368, 594, 22, 39, "Output",
 CellID->193073195]
}, Open  ]],
Cell[10573, 393, 125, 3, 70, "ExampleDelimiter",
 CellID->450536112],
Cell[10701, 398, 77, 1, 70, "ExampleText",
 CellID->95832622],
Cell[CellGroupData[{
Cell[10803, 403, 515, 18, 70, "Input",
 CellID->205321610],
Cell[11321, 423, 605, 22, 36, "Output",
 CellID->520322520]
}, Open  ]],
Cell[11941, 448, 125, 3, 70, "ExampleDelimiter",
 CellID->137525866],
Cell[12069, 453, 63, 1, 70, "ExampleText",
 CellID->250609994],
Cell[CellGroupData[{
Cell[12157, 458, 612, 23, 70, "Input",
 CellID->582901814],
Cell[12772, 483, 786, 29, 36, "Output",
 CellID->472503243]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13607, 518, 218, 7, 70, "ExampleSection",
 CellID->28543],
Cell[CellGroupData[{
Cell[13850, 529, 226, 7, 70, "ExampleSubsection",
 CellID->26223],
Cell[14079, 538, 74, 1, 70, "ExampleText",
 CellID->8503],
Cell[CellGroupData[{
Cell[14178, 543, 254, 8, 70, "Input",
 CellID->7976],
Cell[14435, 553, 620, 23, 43, "Output",
 CellID->178745558]
}, Open  ]],
Cell[CellGroupData[{
Cell[15092, 581, 295, 11, 70, "Input",
 CellID->19102],
Cell[15390, 594, 1131, 44, 65, "Output",
 CellID->221397743]
}, Open  ]],
Cell[16536, 641, 120, 3, 70, "ExampleDelimiter",
 CellID->1472],
Cell[16659, 646, 354, 11, 70, "ExampleText",
 CellID->92225876],
Cell[CellGroupData[{
Cell[17038, 661, 216, 7, 70, "Input",
 CellID->20089],
Cell[17257, 670, 420, 15, 43, "Output",
 CellID->192105939]
}, Open  ]],
Cell[CellGroupData[{
Cell[17714, 690, 283, 9, 70, "Input",
 CellID->6669],
Cell[18000, 701, 343, 13, 43, "Output",
 CellID->39226582]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18392, 720, 237, 7, 70, "ExampleSubsection",
 CellID->160439818],
Cell[18632, 729, 73, 1, 70, "ExampleText",
 CellID->520967426],
Cell[CellGroupData[{
Cell[18730, 734, 245, 7, 70, "Input",
 CellID->32901353],
Cell[18978, 743, 461, 17, 36, "Output",
 CellID->80284557]
}, Open  ]],
Cell[CellGroupData[{
Cell[19476, 765, 231, 7, 70, "Input",
 CellID->544366111],
Cell[19710, 774, 462, 17, 36, "Output",
 CellID->161962323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20221, 797, 228, 7, 70, "ExampleSubsection",
 CellID->435291713],
Cell[20452, 806, 69, 1, 70, "ExampleText",
 CellID->225502292],
Cell[CellGroupData[{
Cell[20546, 811, 154, 5, 70, "Input",
 CellID->151353667],
Cell[20703, 818, 356, 13, 39, "Output",
 CellID->10446444]
}, Open  ]],
Cell[CellGroupData[{
Cell[21096, 836, 209, 7, 70, "Input",
 CellID->49860741],
Cell[21308, 845, 582, 21, 39, "Output",
 CellID->432337607]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21939, 872, 224, 7, 70, "ExampleSubsection",
 CellID->18082488],
Cell[22166, 881, 76, 1, 70, "ExampleText",
 CellID->47505639],
Cell[CellGroupData[{
Cell[22267, 886, 252, 8, 70, "Input",
 CellID->51431388],
Cell[22522, 896, 585, 21, 49, "Output",
 CellID->116838186]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[23168, 924, 233, 7, 70, "ExampleSection",
 CellID->26938],
Cell[23404, 933, 218, 7, 70, "ExampleText",
 CellID->289317600],
Cell[CellGroupData[{
Cell[23647, 944, 515, 18, 70, "Input",
 CellID->271634407],
Cell[24165, 964, 603, 22, 36, "Output",
 CellID->7878625]
}, Open  ]],
Cell[24783, 989, 80, 1, 70, "ExampleText",
 CellID->156932469],
Cell[CellGroupData[{
Cell[24888, 994, 126, 4, 70, "Input",
 CellID->199469494],
Cell[25017, 1000, 488, 18, 36, "Output",
 CellID->245575619]
}, Open  ]],
Cell[25520, 1021, 200, 7, 70, "ExampleText",
 CellID->18880447],
Cell[CellGroupData[{
Cell[25745, 1032, 511, 18, 70, "Input",
 CellID->333991352],
Cell[26259, 1052, 488, 18, 36, "Output",
 CellID->280004706]
}, Open  ]],
Cell[26762, 1073, 212, 7, 70, "ExampleText",
 CellID->38308230],
Cell[CellGroupData[{
Cell[26999, 1084, 100, 3, 70, "Input",
 CellID->4415914],
Cell[27102, 1089, 593, 20, 36, "Output",
 CellID->9315703]
}, Open  ]],
Cell[27710, 1112, 125, 3, 70, "ExampleDelimiter",
 CellID->450976876],
Cell[27838, 1117, 238, 7, 70, "ExampleText",
 CellID->377259608],
Cell[CellGroupData[{
Cell[28101, 1128, 525, 18, 70, "Input",
 CellID->424255709],
Cell[28629, 1148, 547, 20, 39, "Output",
 CellID->62326940]
}, Open  ]],
Cell[29191, 1171, 125, 3, 70, "ExampleDelimiter",
 CellID->676304820],
Cell[29319, 1176, 232, 7, 70, "ExampleText",
 CellID->107302986],
Cell[CellGroupData[{
Cell[29576, 1187, 113, 3, 70, "Input",
 CellID->6910716],
Cell[29692, 1192, 307, 11, 36, "Output",
 CellID->109626757]
}, Open  ]],
Cell[CellGroupData[{
Cell[30036, 1208, 125, 4, 70, "Input",
 CellID->45160120],
Cell[30164, 1214, 164, 5, 36, "Output",
 CellID->219454463]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30389, 1226, 310, 9, 70, "SeeAlsoSection",
 CellID->2191],
Cell[30702, 1237, 1224, 44, 70, "SeeAlso",
 CellID->17265]
}, Open  ]],
Cell[CellGroupData[{
Cell[31963, 1286, 314, 9, 70, "TutorialsSection",
 CellID->15457],
Cell[32280, 1297, 180, 4, 70, "Tutorials",
 CellID->16337]
}, Open  ]],
Cell[CellGroupData[{
Cell[32497, 1306, 319, 9, 70, "MoreAboutSection",
 CellID->514138361],
Cell[32819, 1317, 147, 3, 70, "MoreAbout",
 CellID->454370699],
Cell[32969, 1322, 167, 3, 70, "MoreAbout",
 CellID->657602115]
}, Open  ]],
Cell[33151, 1328, 50, 0, 70, "History"],
Cell[33204, 1330, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

