(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24009,        905]
NotebookOptionsPosition[     18259,        712]
NotebookOutlinePosition[     19935,        753]
CellTagsIndexPosition[     19850,        748]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorTerms" :> 
          Documentation`HelpLookup["paclet:ref/FactorTerms"], "FactorList" :> 
          Documentation`HelpLookup["paclet:ref/FactorList"], 
          "FactorSquareFreeList" :> 
          Documentation`HelpLookup["paclet:ref/FactorSquareFreeList"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FactorTerms\"\>", 
       2->"\<\"FactorList\"\>", 
       3->"\<\"FactorSquareFreeList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Factoring & Decomposition\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FactorTermsList", "ObjectName",
 CellID->2390],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FactorTermsList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FactorTermsList"], "[", 
       StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list in which the first element is the overall \
numerical factor in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     ", and the second element is the polynomial with the overall factor \
removed."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FactorTermsList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FactorTermsList"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of factors of ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     ". The first element in the list is the overall numerical factor. The \
second element is a factor that does not depend on any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". Subsequent elements are factors which depend on progressively more of \
the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25367]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->3072441],

Cell["\<\
Pull out an overall numerical factor, but do no further factoring:\
\>", "ExampleText",
 CellID->12716641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTermsList", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"x", "^", "2"}]}], "-", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231315819],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}]}], "}"}]], "Output",
 ImageSize->{76, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132027767]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1632],

Cell["Define a larger polynomial:", "ExampleText",
 CellID->48597772],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"2", "a", " ", 
     RowBox[{"x", "^", "2"}], "y"}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}], "y"}], "+", 
    RowBox[{"4", "a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"a", "^", "2"}], 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"4", "a", " ", 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"a", "^", "2"}], "y"}], "+", 
    RowBox[{"2", "a", " ", "y"}], "-", 
    RowBox[{"6", "y"}], "-", 
    RowBox[{"12", "a"}], "-", "12"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342528313],

Cell["Pull out an overall numerical factor:", "ExampleText",
 CellID->490293787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTermsList", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->797617060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{
    RowBox[{"-", "6"}], "-", 
    RowBox[{"6", " ", "a"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"a", " ", "y"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "y"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["y", "2"]}]}]}], "}"}]], "Output",
 ImageSize->{442, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->298563036]
}, Open  ]],

Cell[TextData[{
 "Pull out factors that do not depend on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->472727191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTermsList", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->199710368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"2", "+", 
    RowBox[{"2", " ", "a"}], "+", "y", "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"2", " ", "a", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{213, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->512237051]
}, Open  ]],

Cell[TextData[{
 "Pull out factors that do not depend on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and then factors that do not depend on ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->219394186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTermsList", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->68862429],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"1", "+", "a"}], ",", 
   RowBox[{"2", "+", "y"}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"2", " ", "a", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{192, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->58546122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398562133],

Cell["Here the terms have no common factors:", "ExampleText",
 CellID->158184934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTermsList", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"x", "^", "2"}]}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->612660736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]}]}], "}"}]], "Output",
 ImageSize->{86, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->585801542]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->254154752],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25084],

Cell["Pull out overall numerical factor over integers modulo 7:", \
"ExampleText",
 CellID->291345657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTermsList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "x"}], "+", "10"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289837268],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"1", "+", "x"}]}], "}"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111177613]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32488],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorTermsList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTermsList"]], "InlineFormula"],
 " gives a list of factors:"
}], "ExampleText",
 CellID->289317600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTermsList", "[", 
  RowBox[{
   RowBox[{"14", "x"}], "+", 
   RowBox[{"21", "y"}], "+", 
   RowBox[{"35", "x", " ", "y"}], "+", "63"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271634407],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"9", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"5", " ", "x", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353819963]
}, Open  ]],

Cell["This multiplies the factors together:", "ExampleText",
 CellID->156932469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "@@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->199469494],

Cell[BoxData[
 RowBox[{"7", " ", 
  RowBox[{"(", 
   RowBox[{"9", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"5", " ", "x", " ", "y"}]}], ")"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->695106076]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTerms"]], "InlineFormula"],
 " gives a product of factors:"
}], "ExampleText",
 CellID->18880447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{
   RowBox[{"14", "x"}], "+", 
   RowBox[{"21", "y"}], "+", 
   RowBox[{"35", "x", " ", "y"}], "+", "63"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->333991352],

Cell[BoxData[
 RowBox[{"7", " ", 
  RowBox[{"(", 
   RowBox[{"9", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"5", " ", "x", " ", "y"}]}], ")"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->973391]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " combines the factors back together:"
}], "ExampleText",
 CellID->38308230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4415914],

Cell[BoxData[
 RowBox[{"63", "+", 
  RowBox[{"14", " ", "x"}], "+", 
  RowBox[{"21", " ", "y"}], "+", 
  RowBox[{"35", " ", "x", " ", "y"}]}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->81795358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->618912857],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorList"]], "InlineFormula"],
 " gives a list of all irreducible factors:"
}], "ExampleText",
 CellID->326884617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTermsList", "[", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{"x", "^", "3"}]}], "-", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159360220],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "3"]}]}], "}"}]], "Output",
 ImageSize->{76, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563771905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{"x", "^", "3"}]}], "-", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6341319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{230, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->495252580]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11008],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorTerms",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorTerms"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorSquareFreeList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorSquareFreeList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12551],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->32146]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->240265274],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->38234213]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FactorTermsList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 20.3268026}", "context" -> "System`", 
    "keywords" -> {"content of a polynomial", "polynomial factors"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FactorTermsList[poly] gives a list in which the first element is the \
overall numerical factor in poly, and the second element is the polynomial \
with the overall factor removed. FactorTermsList[poly, {x_1, x_2, ...}] gives \
a list of factors of poly. The first element in the list is the overall \
numerical factor. The second element is a factor that does not depend on any \
of the x_i. Subsequent elements are factors which depend on progressively \
more of the x_i. ", "synonyms" -> {"factor terms list"}, "title" -> 
    "FactorTermsList", "type" -> "Symbol", "uri" -> "ref/FactorTermsList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4651, 142, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19715, 741}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2097, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2720, 80, 52, 1, 70, "ObjectName",
 CellID->2390],
Cell[2775, 83, 1839, 54, 70, "Usage",
 CellID->25367]
}, Open  ]],
Cell[CellGroupData[{
Cell[4651, 142, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5028, 156, 146, 5, 70, "ExampleSection",
 CellID->3072441],
Cell[5177, 163, 116, 3, 70, "ExampleText",
 CellID->12716641],
Cell[CellGroupData[{
Cell[5318, 170, 178, 6, 28, "Input",
 CellID->231315819],
Cell[5499, 178, 273, 10, 39, "Output",
 CellID->132027767]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5821, 194, 215, 7, 70, "ExampleSection",
 CellID->1632],
Cell[6039, 203, 69, 1, 70, "ExampleText",
 CellID->48597772],
Cell[6111, 206, 694, 23, 70, "Input",
 CellID->342528313],
Cell[6808, 231, 80, 1, 70, "ExampleText",
 CellID->490293787],
Cell[CellGroupData[{
Cell[6913, 236, 111, 3, 70, "Input",
 CellID->797617060],
Cell[7027, 241, 854, 27, 39, "Output",
 CellID->298563036]
}, Open  ]],
Cell[7896, 271, 160, 6, 70, "ExampleText",
 CellID->472727191],
Cell[CellGroupData[{
Cell[8081, 281, 134, 4, 70, "Input",
 CellID->199710368],
Cell[8218, 287, 423, 14, 39, "Output",
 CellID->512237051]
}, Open  ]],
Cell[8656, 304, 329, 12, 70, "ExampleText",
 CellID->219394186],
Cell[CellGroupData[{
Cell[9010, 320, 182, 6, 70, "Input",
 CellID->68862429],
Cell[9195, 328, 386, 13, 39, "Output",
 CellID->58546122]
}, Open  ]],
Cell[9596, 344, 125, 3, 70, "ExampleDelimiter",
 CellID->398562133],
Cell[9724, 349, 81, 1, 70, "ExampleText",
 CellID->158184934],
Cell[CellGroupData[{
Cell[9830, 354, 178, 6, 70, "Input",
 CellID->612660736],
Cell[10011, 362, 299, 11, 39, "Output",
 CellID->585801542]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10359, 379, 222, 7, 70, "ExampleSection",
 CellID->254154752],
Cell[CellGroupData[{
Cell[10606, 390, 224, 7, 70, "ExampleSubsection",
 CellID->25084],
Cell[10833, 399, 102, 2, 70, "ExampleText",
 CellID->291345657],
Cell[CellGroupData[{
Cell[10960, 405, 215, 7, 70, "Input",
 CellID->289837268],
Cell[11178, 414, 227, 8, 36, "Output",
 CellID->111177613]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11466, 429, 233, 7, 70, "ExampleSection",
 CellID->32488],
Cell[11702, 438, 216, 7, 70, "ExampleText",
 CellID->289317600],
Cell[CellGroupData[{
Cell[11943, 449, 225, 7, 70, "Input",
 CellID->271634407],
Cell[12171, 458, 333, 11, 36, "Output",
 CellID->353819963]
}, Open  ]],
Cell[12519, 472, 80, 1, 70, "ExampleText",
 CellID->156932469],
Cell[CellGroupData[{
Cell[12624, 477, 97, 3, 70, "Input",
 CellID->199469494],
Cell[12724, 482, 333, 11, 36, "Output",
 CellID->695106076]
}, Open  ]],
Cell[13072, 496, 210, 7, 70, "ExampleText",
 CellID->18880447],
Cell[CellGroupData[{
Cell[13307, 507, 221, 7, 70, "Input",
 CellID->333991352],
Cell[13531, 516, 330, 11, 36, "Output",
 CellID->973391]
}, Open  ]],
Cell[13876, 530, 208, 7, 70, "ExampleText",
 CellID->38308230],
Cell[CellGroupData[{
Cell[14109, 541, 100, 3, 70, "Input",
 CellID->4415914],
Cell[14212, 546, 283, 9, 36, "Output",
 CellID->81795358]
}, Open  ]],
Cell[14510, 558, 125, 3, 70, "ExampleDelimiter",
 CellID->618912857],
Cell[14638, 563, 222, 7, 70, "ExampleText",
 CellID->326884617],
Cell[CellGroupData[{
Cell[14885, 574, 178, 6, 70, "Input",
 CellID->159360220],
Cell[15066, 582, 273, 10, 39, "Output",
 CellID->563771905]
}, Open  ]],
Cell[CellGroupData[{
Cell[15376, 597, 171, 6, 70, "Input",
 CellID->6341319],
Cell[15550, 605, 473, 17, 39, "Output",
 CellID->495252580]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16084, 629, 311, 9, 70, "SeeAlsoSection",
 CellID->11008],
Cell[16398, 640, 730, 26, 70, "SeeAlso",
 CellID->22648]
}, Open  ]],
Cell[CellGroupData[{
Cell[17165, 671, 314, 9, 70, "TutorialsSection",
 CellID->12551],
Cell[17482, 682, 180, 4, 70, "Tutorials",
 CellID->32146]
}, Open  ]],
Cell[CellGroupData[{
Cell[17699, 691, 319, 9, 70, "MoreAboutSection",
 CellID->240265274],
Cell[18021, 702, 166, 3, 70, "MoreAbout",
 CellID->38234213]
}, Open  ]],
Cell[18202, 708, 27, 0, 70, "History"],
Cell[18232, 710, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

