(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21331,        823]
NotebookOptionsPosition[     15717,        629]
NotebookOutlinePosition[     16987,        666]
CellTagsIndexPosition[     16902,        661]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/Equations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Equations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TrueQ" :> Documentation`HelpLookup["paclet:ref/TrueQ"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "Boole" :> 
          Documentation`HelpLookup["paclet:ref/Boole"], "Booleans" :> 
          Documentation`HelpLookup["paclet:ref/Booleans"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TrueQ\"\>", 2->"\<\"True\"\>", 
       3->"\<\"Boole\"\>", 4->"\<\"Booleans\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Logic & Boolean Algebra\"\>",
        2->"\<\"Numerical Functions\"\>", 
       3->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["False", "ObjectName",
 CellID->27062],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     "\[LineSeparator]is the symbol for the Boolean value false. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15211]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->37343979],

Cell["Evaluate a Boolean expression:", "ExampleText",
 CellID->164430630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Implies", "[", 
  RowBox[{
   RowBox[{"Not", "[", "False", "]"}], ",", 
   RowBox[{"False", "&&", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21340764],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74450902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176130008],

Cell["Use a conditional:", "ExampleText",
 CellID->156302607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"False", ",", "a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49745004],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170480496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6704375],

Cell["Test a structural property:", "ExampleText",
 CellID->939752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65950149],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4442475]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91028403],

Cell["Test a mathematical property:", "ExampleText",
 CellID->186793146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "E", "]"}], "<", 
  RowBox[{"Cos", "[", "E", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->774552658],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29602392]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6808967],

Cell["The symbol for the Boolean value true:", "ExampleText",
 CellID->412067263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", "False", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42815367],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2716638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11623837],

Cell["Truth table for a Boolean function:", "ExampleText",
 CellID->69679226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Xor", ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95768180],

Cell[BoxData[
 TagBox[GridBox[{
    {"False", "True"},
    {"True", "False"}
   }],
  "Grid"]], "Output",
 ImageSize->{82, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->990251222]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132771426],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->58299015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Boole", "/@", 
  RowBox[{"{", 
   RowBox[{"True", ",", "False"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153856634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->701580537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->346612108],

Cell["This statement is not resolved automatically:", "ExampleText",
 CellID->176636187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "+", 
    RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}], "\[NotEqual]", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", 
      RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}], "/", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238517545],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], "]"}], "\[NotEqual]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}]}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->447469917]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to find its truth value:"
}], "ExampleText",
 CellID->144318281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->334328105],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42736061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35400950],

Cell["A fully quantified expression:", "ExampleText",
 CellID->622689182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"x", "<", "y"}], ",", 
   RowBox[{"Exists", "[", 
    RowBox[{"z", ",", 
     RowBox[{"x", "<", 
      RowBox[{"z", "^", "2"}], "<", "y"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521857631],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"x", "<", "y"}]}]], 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[Exists]", "z"], 
    RowBox[{"x", "<", 
     SuperscriptBox["z", "2"], "<", "y"}]}], ")"}]}]], "Output",
 ImageSize->{145, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127617849]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to find its truth value:"
}], "ExampleText",
 CellID->853938565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216212838],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4994184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330449434],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to find truth values of expressions under specified assumptions:"
}], "ExampleText",
 CellID->739978796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"x", "|", "y"}], ",", "Reals"}], "]"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "\[NotEqual]", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50825397],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364643813]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13793],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrueQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Booleans",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Booleans"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21557]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23013],

Cell[TextData[ButtonBox["Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Equations"]], "Tutorials",
 CellID->21207]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
False"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->29043378],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->104589047],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->255791834]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"False - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 21.2487012}", "context" -> "System`", 
    "keywords" -> {
     "Boolean", "Boolean algebra", "false", "no", "propositional logic", 
      "switching algebra", "truth value"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "False is the symbol for the Boolean value false. ", "synonyms" -> {}, 
    "title" -> "False", "type" -> "Symbol", "uri" -> "ref/False"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3380, 101, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16767, 654}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2254, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2877, 80, 43, 1, 70, "ObjectName",
 CellID->27062],
Cell[2923, 83, 420, 13, 70, "Usage",
 CellID->15211]
}, Open  ]],
Cell[CellGroupData[{
Cell[3380, 101, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3757, 115, 147, 5, 70, "ExampleSection",
 CellID->37343979],
Cell[3907, 122, 73, 1, 70, "ExampleText",
 CellID->164430630],
Cell[CellGroupData[{
Cell[4005, 127, 193, 6, 28, "Input",
 CellID->21340764],
Cell[4201, 135, 161, 5, 36, "Output",
 CellID->74450902]
}, Open  ]],
Cell[4377, 143, 125, 3, 70, "ExampleDelimiter",
 CellID->176130008],
Cell[4505, 148, 61, 1, 70, "ExampleText",
 CellID->156302607],
Cell[CellGroupData[{
Cell[4591, 153, 134, 4, 28, "Input",
 CellID->49745004],
Cell[4728, 159, 158, 5, 36, "Output",
 CellID->170480496]
}, Open  ]],
Cell[4901, 167, 123, 3, 70, "ExampleDelimiter",
 CellID->6704375],
Cell[5027, 172, 67, 1, 70, "ExampleText",
 CellID->939752],
Cell[CellGroupData[{
Cell[5119, 177, 284, 10, 70, "Input",
 CellID->65950149],
Cell[5406, 189, 160, 5, 36, "Output",
 CellID->4442475]
}, Open  ]],
Cell[5581, 197, 124, 3, 70, "ExampleDelimiter",
 CellID->91028403],
Cell[5708, 202, 72, 1, 70, "ExampleText",
 CellID->186793146],
Cell[CellGroupData[{
Cell[5805, 207, 152, 5, 70, "Input",
 CellID->774552658],
Cell[5960, 214, 161, 5, 36, "Output",
 CellID->29602392]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6170, 225, 235, 7, 70, "ExampleSection",
 CellID->6808967],
Cell[6408, 234, 81, 1, 70, "ExampleText",
 CellID->412067263],
Cell[CellGroupData[{
Cell[6514, 239, 102, 3, 70, "Input",
 CellID->42815367],
Cell[6619, 244, 159, 5, 36, "Output",
 CellID->2716638]
}, Open  ]],
Cell[6793, 252, 124, 3, 70, "ExampleDelimiter",
 CellID->11623837],
Cell[6920, 257, 77, 1, 70, "ExampleText",
 CellID->69679226],
Cell[CellGroupData[{
Cell[7022, 262, 281, 10, 70, "Input",
 CellID->95768180],
Cell[7306, 274, 235, 10, 48, "Output",
 CellID->990251222]
}, Open  ]],
Cell[7556, 287, 125, 3, 70, "ExampleDelimiter",
 CellID->132771426],
Cell[7684, 292, 189, 8, 70, "ExampleText",
 CellID->58299015],
Cell[CellGroupData[{
Cell[7898, 304, 151, 5, 70, "Input",
 CellID->153856634],
Cell[8052, 311, 203, 7, 36, "Output",
 CellID->701580537]
}, Open  ]],
Cell[8270, 321, 125, 3, 70, "ExampleDelimiter",
 CellID->346612108],
Cell[8398, 326, 88, 1, 70, "ExampleText",
 CellID->176636187],
Cell[CellGroupData[{
Cell[8511, 331, 357, 12, 70, "Input",
 CellID->238517545],
Cell[8871, 345, 416, 16, 51, "Output",
 CellID->447469917]
}, Open  ]],
Cell[9302, 364, 219, 8, 70, "ExampleText",
 CellID->144318281],
Cell[CellGroupData[{
Cell[9546, 376, 108, 3, 70, "Input",
 CellID->334328105],
Cell[9657, 381, 161, 5, 36, "Output",
 CellID->42736061]
}, Open  ]],
Cell[9833, 389, 124, 3, 70, "ExampleDelimiter",
 CellID->35400950],
Cell[9960, 394, 73, 1, 70, "ExampleText",
 CellID->622689182],
Cell[CellGroupData[{
Cell[10058, 399, 330, 11, 70, "Input",
 CellID->521857631],
Cell[10391, 412, 442, 16, 39, "Output",
 CellID->127617849]
}, Open  ]],
Cell[10848, 431, 209, 8, 70, "ExampleText",
 CellID->853938565],
Cell[CellGroupData[{
Cell[11082, 443, 103, 3, 70, "Input",
 CellID->216212838],
Cell[11188, 448, 160, 5, 36, "Output",
 CellID->4994184]
}, Open  ]],
Cell[11363, 456, 125, 3, 70, "ExampleDelimiter",
 CellID->330449434],
Cell[11491, 461, 247, 8, 70, "ExampleText",
 CellID->739978796],
Cell[CellGroupData[{
Cell[11763, 473, 411, 14, 70, "Input",
 CellID->50825397],
Cell[12177, 489, 162, 5, 36, "Output",
 CellID->364643813]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12400, 501, 311, 9, 70, "SeeAlsoSection",
 CellID->13793],
Cell[12714, 512, 921, 35, 70, "SeeAlso",
 CellID->21557]
}, Open  ]],
Cell[CellGroupData[{
Cell[13672, 552, 314, 9, 70, "TutorialsSection",
 CellID->23013],
Cell[13989, 563, 129, 3, 70, "Tutorials",
 CellID->21207]
}, Open  ]],
Cell[CellGroupData[{
Cell[14155, 571, 305, 8, 70, "RelatedLinksSection"],
Cell[14463, 581, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14883, 599, 299, 8, 70, "MoreAboutSection"],
Cell[15185, 609, 156, 3, 70, "MoreAbout",
 CellID->29043378],
Cell[15344, 614, 149, 3, 70, "MoreAbout",
 CellID->104589047],
Cell[15496, 619, 149, 3, 70, "MoreAbout",
 CellID->255791834]
}, Open  ]],
Cell[15660, 625, 27, 0, 70, "History"],
Cell[15690, 627, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

