(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    340270,       7816]
NotebookOptionsPosition[    321685,       7147]
NotebookOutlinePosition[    323333,       7196]
CellTagsIndexPosition[    323216,       7190]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GoldenRatio" :> 
          Documentation`HelpLookup["paclet:ref/GoldenRatio"], "LucasL" :> 
          Documentation`HelpLookup["paclet:ref/LucasL"], "RSolve" :> 
          Documentation`HelpLookup["paclet:ref/RSolve"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GoldenRatio\"\>", 2->"\<\"LucasL\"\>", 
       3->"\<\"RSolve\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/RecurrenceAndSumFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Discrete Mathematics\"\>", 
       2->"\<\"Integer Functions\"\>", 3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Recurrence and Sum Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fibonacci", "ObjectName",
 CellID->13925],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Fibonacci",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Fibonacci"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Fibonacci number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["F", "n"], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Fibonacci",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Fibonacci"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Fibonacci polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["F", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->13231]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["F", "n"], TraditionalForm]], "InlineMath"],
 " satisfy the recurrence relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "n"], "=", 
    RowBox[{
     SubscriptBox["F", 
      RowBox[{"n", "-", "1"}]], "+", 
     SubscriptBox["F", 
      RowBox[{"n", "-", "2"}]]}]}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "1"], "=", 
    RowBox[{
     SubscriptBox["F", "2"], "=", "1"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->475],

Cell[TextData[{
 "For any complex value of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["F", "n"], TraditionalForm]], "InlineMath"],
 " are given by the general formula ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "n"], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[Phi]", "n"], "-", 
       RowBox[{
        RowBox[{"cos", "(", 
         RowBox[{"\[Pi]", " ", "n"}], ")"}], 
        SuperscriptBox["\[Phi]", 
         RowBox[{"-", "n"}]]}]}], ")"}], "/", 
     SqrtBox["5"]}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineMath"],
 " is the Golden Ratio. "
}], "Notes",
 CellID->252537814],

Cell[TextData[{
 "The Fibonacci polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is the coefficient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["t", "n"], TraditionalForm]], "InlineMath"],
 " in the expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x", "t", "-", 
      SuperscriptBox["t", "2"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->27332],

Cell[TextData[{
 "The Fibonacci polynomials satisfy the recurrence relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["F", "n"], "(", "x", ")"}], "=", 
    RowBox[{
     RowBox[{"x", 
      RowBox[{
       SubscriptBox["F", 
        RowBox[{"n", "-", "1"}]], "(", "x", ")"}]}], "+", 
     RowBox[{
      SubscriptBox["F", 
       RowBox[{"n", "-", "2"}]], "(", "x", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->28379],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " include transformation rules for combinations of Fibonacci numbers with \
symbolic arguments when the arguments are specified to be integers using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "\[Element]", 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31102],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fibonacci",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fibonacci"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fibonacci",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fibonacci"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->603053716],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->430586704],

Cell["Compute Fibonacci numbers:", "ExampleText",
 CellID->30826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89", ",", "144", ",", "233", ",", "377", ",", 
   "610", ",", "987", ",", "1597", ",", "2584", ",", "4181", ",", "6765"}], 
  "}"}]], "Output",
 ImageSize->{560, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36326222]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11615],

Cell["Evaluate large Fibonacci numbers:", "ExampleText",
 CellID->21966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fibonacci", "[", "1000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30804],

Cell[BoxData[\
"43466557686937456435688527675040625802564660517371780402481729089536555417949\
051890403879840079255169295922593080322634775209689623239873322471161642996440\
906533187938298969649928516003704476137795166849228875"], "Output",
 ImageSize->{583, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->761944955]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fibonacci", "[", 
  RowBox[{"10.", "^", "9"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31576],

Cell[BoxData["7.952317915785354`7.272253472527282*^208987639"], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146436011]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5025],

Cell["Fibonacci numbers of negative argument:", "ExampleText",
 CellID->423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", 
    RowBox[{"-", "n"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15809],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}], ",", "2", ",", 
   RowBox[{"-", "3"}], ",", "5", ",", 
   RowBox[{"-", "8"}], ",", "13", ",", 
   RowBox[{"-", "21"}], ",", "34", ",", 
   RowBox[{"-", "55"}]}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86737978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7030],

Cell["Non\[Hyphen]integer arguments:", "ExampleText",
 CellID->23375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fibonacci", "[", "1.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31384],

Cell[BoxData["0.9204420652599261`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233478316]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", 
    RowBox[{"3", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1326],

Cell[BoxData["0.\
9204420652599260357653651942110866809339892366716024676679078669686`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->775823439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11923],

Cell["Complex arguments:", "ExampleText",
 CellID->21468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fibonacci", "[", 
  RowBox[{"1.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26278],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.3455686076541254`"}], "-", 
  RowBox[{"1.798380045093884`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19019466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2398],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fibonacci",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fibonacci"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->22387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fibonacci", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293609092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11161],

Cell["Series expansion at generic point:", "ExampleText",
 CellID->7541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Fibonacci", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5", ",", "2"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5915],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "+", 
   FractionBox[
    RowBox[{"11", " ", 
     RowBox[{"ArcCsch", "[", "2", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "5"}], ")"}]}], 
    SqrtBox["5"]], "+", 
   RowBox[{
    FractionBox["1", "20"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "25"}], "+", 
         RowBox[{"11", " ", 
          SqrtBox["5"]}]}], ")"}], " ", 
       SuperscriptBox["\[Pi]", "2"]}], "+", 
      RowBox[{"50", " ", 
       SuperscriptBox[
        RowBox[{"ArcCsch", "[", "2", "]"}], "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"n", "-", "5"}], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"n", "-", "5"}], "]"}], "3"],
    SeriesData[$CellContext`n, 5, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`n, 5, {
   5, (11 5^Rational[-1, 2]) ArcCsch[2], 
    Rational[1, 20] ((-25 + 11 5^Rational[1, 2]) Pi^2 + 50 ArcCsch[2]^2)}, 0, 
   3, 1],
  Editable->False]], "Output",
 ImageSize->{532, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27696907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->804171535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->126097607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fibonacci", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->619062489],

Cell[BoxData[
 FormBox[
  SubscriptBox[
   TagBox["F",
    Fibonacci], "n"], TraditionalForm]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->330963962]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10739],

Cell["Fibonacci polynomials:", "ExampleText",
 CellID->28992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "5"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    SuperscriptBox["x", "6"]}], ",", 
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    SuperscriptBox["x", "7"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["x", "6"]}], "+", 
    SuperscriptBox["x", "8"]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "7"]}], "+", 
    SuperscriptBox["x", "9"]}]}], "}"}]], "Output",
 ImageSize->{473, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105272195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4614],

Cell["General series expansion at infinity:", "ExampleText",
 CellID->31630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11932],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   RowBox[{"-", "n"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     SuperscriptBox[
      RowBox[{"O", "[", 
       FractionBox["1", "x"], "]"}], "1"],
     SeriesData[$CellContext`x, 
      DirectedInfinity[1], {}, 1, 1, 1],
     Editable->False], "+", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"2", " ", "n"}]], " ", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], "1"],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 1, 1, 1],
      Editable->False]}], "+", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"2", " ", "n"}]], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"1", "-", "n"}]], " ", 
          SqrtBox["\[Pi]"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "n"}], ")"}]}], "+", 
            FractionBox[
             RowBox[{"1", "+", "n"}], "2"]}], "]"}], " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            FractionBox[
             RowBox[{"n", " ", "\[Pi]"}], "2"], "]"}], "2"]}], 
         RowBox[{
          RowBox[{"Gamma", "[", 
           RowBox[{
            FractionBox["1", "2"], "+", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "n"}], ")"}]}]}], "]"}], " ", 
          RowBox[{"Gamma", "[", 
           FractionBox[
            RowBox[{"1", "+", "n"}], "2"], "]"}], " ", "x"}]], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "2"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[1], {}, 1, 2, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[
        1], {((((2^(1 - $CellContext`n) Pi^Rational[1, 2])/Gamma[
            Rational[1, 2] + Rational[1, 2] (-1 + $CellContext`n)])/Gamma[
           Rational[1, 2] (1 + $CellContext`n)]) 
          Gamma[Rational[1, 2] (-1 + $CellContext`n) + 
            Rational[1, 2] (1 + $CellContext`n)]) 
         Sin[(Rational[1, 2] $CellContext`n) Pi]^2}, 1, 2, 1],
       Editable->False], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{509, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64021074]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27356],

Cell["Solve the Fibonacci recurrence equation:", "ExampleText",
 CellID->850127328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], "==", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"n", "-", "1"}], "]"}], "+", 
       RowBox[{"f", "[", 
        RowBox[{"n", "-", "2"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "2", "]"}], "==", 
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"f", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557011535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"Fibonacci", "[", "n", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270890014]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], "/.", "%"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63116039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55"}], "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82907250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->294953161],

Cell["Find ratios of successive Fibonacci numbers:", "ExampleText",
 CellID->29408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Fibonacci", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "/", 
    RowBox[{"Fibonacci", "[", "n", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1563],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["5", "3"], ",", 
   FractionBox["8", "5"], ",", 
   FractionBox["13", "8"], ",", 
   FractionBox["21", "13"], ",", 
   FractionBox["34", "21"], ",", 
   FractionBox["55", "34"], ",", 
   FractionBox["89", "55"], ",", 
   FractionBox["144", "89"], ",", 
   FractionBox["233", "144"], ",", 
   FractionBox["377", "233"], ",", 
   FractionBox["610", "377"], ",", 
   FractionBox["987", "610"]}], "}"}]], "Output",
 ImageSize->{439, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268835925]
}, Open  ]],

Cell["Compare with continued fractions:", "ExampleText",
 CellID->13103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FromContinuedFraction", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["5", "3"], ",", 
   FractionBox["8", "5"], ",", 
   FractionBox["13", "8"], ",", 
   FractionBox["21", "13"], ",", 
   FractionBox["34", "21"], ",", 
   FractionBox["55", "34"], ",", 
   FractionBox["89", "55"], ",", 
   FractionBox["144", "89"], ",", 
   FractionBox["233", "144"], ",", 
   FractionBox["377", "233"], ",", 
   FractionBox["610", "377"], ",", 
   FractionBox["987", "610"]}], "}"}]], "Output",
 ImageSize->{439, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->559823555]
}, Open  ]],

Cell["Convergence to the Golden Ratio:", "ExampleText",
 CellID->31752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "2.`", ",", "1.5`", ",", "1.6666666666666667`", ",", "1.6`", 
   ",", "1.625`", ",", "1.6153846153846154`", ",", "1.619047619047619`", ",", 
   "1.6176470588235294`", ",", "1.6181818181818182`", ",", 
   "1.6179775280898876`", ",", "1.6180555555555556`", ",", 
   "1.6180257510729614`", ",", "1.6180371352785146`", ",", 
   "1.618032786885246`"}], "}"}]], "Output",
 ImageSize->{429, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->780366291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24599],

Cell["Fibonacci substitution system:", "ExampleText",
 CellID->6623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"StringReplace", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<A\>\"", "->", "\"\<AB\>\""}], ",", 
        RowBox[{"\"\<B\>\"", "->", "\"\<A\>\""}]}], "}"}]}], "]"}], "&"}], 
   ",", "\"\<A\>\"", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->939],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"AB\"\>", ",", "\<\"ABA\"\>", 
   ",", "\<\"ABAAB\"\>", ",", "\<\"ABAABABA\"\>", 
   ",", "\<\"ABAABABAABAAB\"\>", ",", "\<\"ABAABABAABAABABAABABA\"\>"}], 
  "}"}]], "Output",
 ImageSize->{457, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157465203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"%", ",", "\"\<A\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24063],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->145873261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24261],

Cell["Fibonomial coefficients:", "ExampleText",
 CellID->20336],

Cell[BoxData[
 RowBox[{
  RowBox[{"Fibonomial", "[", 
   RowBox[{"n_", ",", "k_"}], "]"}], ":=", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Fibonacci", "[", 
      RowBox[{"n", "+", "j", "-", "k"}], "]"}], "/", 
     RowBox[{"Fibonacci", "[", "j", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "k"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Array", "[", 
   RowBox[{"Fibonomial", ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "7"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7646],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "0", "0", "0", "0", "0", "0"},
    {"1", "1", "0", "0", "0", "0", "0"},
    {"2", "2", "1", "0", "0", "0", "0"},
    {"3", "6", "3", "1", "0", "0", "0"},
    {"5", "15", "15", "5", "1", "0", "0"},
    {"8", "40", "60", "40", "8", "1", "0"},
    {"13", "104", "260", "260", "104", "13", "1"}
   }],
  "Grid"]], "Output",
 ImageSize->{171, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13805052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5556],

Cell[TextData[{
 "Calculate the number of ways to write an integer as a sum of Fibonacci \
numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "1"], ",", 
    SubscriptBox["F", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->11617],

Cell[BoxData[
 RowBox[{
  RowBox[{"fibonacciSumCount", "[", "n_", "]"}], ":=", 
  RowBox[{"SeriesCoefficient", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"z", "^", 
          RowBox[{"Fibonacci", "[", "k", "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{
           RowBox[{"Ceiling", "[", 
            RowBox[{"Log", "[", 
             RowBox[{"GoldenRatio", ",", "n"}], "]"}], "]"}], "+", "2"}]}], 
         "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "n"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29865],

Cell["Plot the counts for the first hundred integers:", "ExampleText",
 CellID->14612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"fibonacciSumCount", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->82911068],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxtlLlOA0EQREdEhAQEBARgIYQQQtw3eDhszI1tzhRBzC/0p+0n+RMAUQ+p
S1iyap+quqd3dmdn3z4HH2OllPfv/4/+/kZtXdT/ddx0wnjSeMpy0+bPmN+y
PnPmz5u/YP6i8ZLNsWz1K+avGq9Zft38DVtv0/JbUu572+p3pOzDruX3LL9v
+QPzD63+yPJty9ecD5j5jzMHTL8Tq4db0tPMAVN/JtVzDpj5OzkfnZwvXfO7
5p+bD9O/Z+v3cr5c2PzG5TL3C5j6Kyn7B7P/19Yfpv5Gqvc+YO7v1uphzsWd
+TDn6F6qc1Nh9gNWvwZWv9LP89Z+zgesfo35ZZC5DnI+zG9g9meY56nDnA+Y
9WG+Ew9S7UeF1S9g1je/POb+FeZ5wZq3gal/kup9qMYBMz9M/XOerxoHrHka
mO/ii80PUw/ru9mYX17//C8InXBW
     "]], {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 100.}, {2., 15.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->780196394]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6633],

Cell[TextData[{
 "Lam\[EAcute]'s theorem bounds the number of steps of the Euclidean \
algorithm for calculating ",
 Cell[BoxData[
  FormBox[
   RowBox[{"gcd", "(", 
    RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->19352],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptF]", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"NestWhile", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "+", "1"}], ")"}], "&"}], ",", "1", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Fibonacci", "[", "#", "]"}], "<", "n"}], "&"}]}], "]"}], "-", 
   "1"}]}]], "Input",
 CellTags->"Fibonacci",
 CellLabel->"In[1]:=",
 CellID->5624],

Cell[BoxData[
 RowBox[{
  RowBox[{"maxEuclideanAlgorithmSteps", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[ScriptF]", "[", 
      RowBox[{"Min", "[", 
       RowBox[{"a", ",", "b"}], "]"}], "]"}], "-", "1"}], ",", 
    RowBox[{
     RowBox[{"\[ScriptF]", "[", 
      RowBox[{"Max", "[", 
       RowBox[{"a", ",", "b"}], "]"}], "]"}], "-", "2"}]}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->11262],

Cell["Plot the maximal number of steps:", "ExampleText",
 CellID->4139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"maxEuclideanAlgorithmSteps", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "100"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8152],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->527197259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11112],

Cell[TextData[{
 "Find the first Fibonacci number above ",
 Cell[BoxData["1000000"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "+", "1"}], ")"}], "&"}], ",", "1", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Fibonacci", "[", "#", "]"}], "<=", 
     RowBox[{"10", "^", "6"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28156],

Cell[BoxData["31"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3710355]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fibonacci", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8348480],

Cell[BoxData["1346269"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48232973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->303676422],

Cell["Plot the discrete inverse of Fibonacci numbers: ", "ExampleText",
 CellID->40779680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NestWhile", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"#", "+", "1"}], ")"}], "&"}], ",", "1", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Fibonacci", "[", "#", "]"}], "<=", "n"}], "&"}]}], "]"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "200"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25219],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJx11kmKFFEQBuDAlUsXvXDhohQREZF2nu1nO8/azmM/W9th5RXiKHmUWHqM
PIJHUOksIT8woQi+9/NnkFRR5P6tHxvbuyLi55/P37lz/VrbmbvbdDDNPW1+
vsL5CnPvf+Y+vOD8AD6ID+HD+Aj3PYqP4VV8HJ/AJ/EpfJrnOIPP4nP4PL6A
L+JL+DK+gtdwmztxXJ3m9D0kjnVyHNfIcVwnx3GDHMdNchy3yHHcJsdxhxzH
XXIc98iXXv6O78+dOB6Q43hIjuMROY7HczecuHA8oY8TF44N+jhx4XhKHycu
HM/o48SF4zl9nLhwvKC/9PS/lrhwvJy74cSF4xV9nLhwvKaPExeON/Rx4sLx
lj5OXDje0ceJC8d7+jhx4fhAHycuHJv0ceLC0ede4IY7TjzgwiOOj+zHDXec
eMCFRxxb05zeGxa44Y4TD7jwiOMT+3HDHScecOERx2f244Y7TjzgwiOObfbj
hjtOPODCI44v7McNd5x4wIVHHF/ZjxvuOPGAC484vrEfN9xx4gEXHnF8/+ff
NhwFHQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{{0., 200.}, {3., 13.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25968157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26015],

Cell[TextData[{
 "Plot of the absolute value of ",
 Cell[BoxData[
  ButtonBox["Fibonacci",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fibonacci"]], "InlineFormula"],
 " over the complex plane:"
}], "ExampleText",
 CellID->14631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Fibonacci", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13673],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65349252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74],

Cell["Find the number of factors of Fibonacci polynomials:", "ExampleText",
 CellID->19243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"FactorList", "[", 
      RowBox[{"Fibonacci", "[", 
       RowBox[{"n", ",", "x"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->908],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 2.}, {3., 2.}, {4., 3.}, {5., 2.}, {6., 4.}, {7.,
      2.}, {8., 4.}, {9., 3.}, {10., 4.}, {11., 2.}, {12., 6.}, {13., 2.}, {
     14., 4.}, {15., 4.}, {16., 5.}, {17., 2.}, {18., 6.}, {19., 2.}, {20., 
     6.}, {21., 4.}, {22., 4.}, {23., 2.}, {24., 8.}, {25., 3.}, {26., 4.}, {
     27., 4.}, {28., 6.}, {29., 2.}, {30., 8.}, {31., 2.}, {32., 6.}, {33., 
     4.}, {34., 4.}, {35., 4.}, {36., 9.}, {37., 2.}, {38., 4.}, {39., 4.}, {
     40., 8.}, {41., 2.}, {42., 8.}, {43., 2.}, {44., 6.}, {45., 6.}, {46., 
     4.}, {47., 2.}, {48., 10.}, {49., 3.}, {50., 6.}}], {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{{0., 50.}, {1., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->57083811]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32664],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Fibonacci Numbers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32261],

Cell["Expand in terms of elementary functions:", "ExampleText",
 CellID->14367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Fibonacci", "[", "n", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5783],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}], ")"}], "n"], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}]], ")"}], "n"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"n", " ", "\[Pi]"}], "]"}]}]}], 
  SqrtBox["5"]]], "Output",
 ImageSize->{221, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86681925]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22744],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55"}], "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26646452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17010],

Cell["Limiting ratio:", "ExampleText",
 CellID->9330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Fibonacci", "[", "n", "]"}], "/", 
     RowBox[{"Fibonacci", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}], ",", 
    RowBox[{"n", "->", "Infinity"}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20284],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SqrtBox["5"]}], ")"}]}]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210760977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5521],

Cell["Explicit recursive definition:", "ExampleText",
 CellID->31328],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", "n", "]"}], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"f", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16041],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], "=", 
   RowBox[{
    RowBox[{"f", "[", "2", "]"}], "=", "1"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32629],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89", ",", "144", ",", "233", ",", "377", ",", 
   "610", ",", "987", ",", "1597", ",", "2584", ",", "4181", ",", "6765"}], 
  "}"}]], "Output",
 ImageSize->{560, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->107878423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73468172],

Cell["\<\
Explicit state\[Hyphen]space recursive definition:\
\>", "ExampleText",
 CellID->781117648],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "0", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16606483],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"n_Integer", "?", "Positive"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"g", "[", "n", "]"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ".", 
    RowBox[{"g", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108716658],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"Last", "[", 
   RowBox[{"g", "[", "n", "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->124286756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->627728566],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89"}], "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->129161294]
}, Open  ]],

Cell[TextData[{
 "Closed\[Hyphen]form solution using ",
 Cell[BoxData[
  ButtonBox["MatrixPower",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPower"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68110738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Last", "[", 
    RowBox[{
     RowBox[{"MatrixPower", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", "n"}], "]"}], ".", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->340256544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89"}], "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->4658403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12267],

Cell["Simplify expressions involving Fibonacci numbers:", "ExampleText",
 CellID->662780443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Fibonacci", "[", 
      RowBox[{"n", "+", "1"}], "]"}], 
     RowBox[{"Fibonacci", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Fibonacci", "[", "n", "]"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"n", ">", "0"}], "&&", 
    RowBox[{"n", "\[Element]", "Integers"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19977],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"-", "1"}], ")"}], "n"]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396757486]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->315],

Cell["Symbolic summation:", "ExampleText",
 CellID->599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "0"}], "n"], 
  RowBox[{
   RowBox[{"Fibonacci", "[", "k", "]"}], 
   RowBox[{"Fibonacci", "[", 
    RowBox[{"n", "-", "k"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20999],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"5", " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      SqrtBox["5"]}], ")"}]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}], ")"}], 
    RowBox[{"-", "n"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"2", " ", "n"}]]}], " ", 
      SuperscriptBox["2", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "n"}]}]]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["4", "n"]}], "+", 
     RowBox[{
      SuperscriptBox["4", "n"], " ", 
      SqrtBox["5"]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["5"]}], ")"}], 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "n"}]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"5", "+", 
        SqrtBox["5"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["4", "n"], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "n"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SqrtBox["5"]}], ")"}], 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], " ", "n"}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{560, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261774924]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32717],

Cell["Generating function:", "ExampleText",
 CellID->32653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "0"}], "\[Infinity]"], 
   RowBox[{
    RowBox[{"Fibonacci", "[", "k", "]"}], " ", 
    SuperscriptBox["x", "k"]}]}], "//", "FullSimplify"}]], "Input",
 CellTags->"Fibonacci",
 CellLabel->"In[1]:=",
 CellID->28134],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x", "+", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 ImageSize->{76, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Fibonacci",
 CellLabel->"Out[1]=",
 CellID->621743367]
}, Open  ]],

Cell["Fibonacci numbers as coefficients:", "ExampleText",
 CellID->10858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32494],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"13", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"21", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{"34", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{"55", " ", 
    SuperscriptBox["x", "10"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 2, 3, 5, 8, 13, 21, 34, 55}, 1, 11, 1],
  
  Editable->False]], "Output",
 ImageSize->{402, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12066279]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->725],

Cell["\<\
Express a fractional Fibonacci number as an algebraic number:\
\>", "ExampleText",
 CellID->5140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Fibonacci", "[", 
    RowBox[{"1", "/", "3"}], "]"}], "//", "FunctionExpand"}], " ", "//", " ", 
  "RootReduce"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20354],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"41", "-", 
     RowBox[{"420", " ", "#1"}], "+", 
     RowBox[{"720", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"1400", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     RowBox[{"4800", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     RowBox[{"8000", " ", 
      SuperscriptBox["#1", "6"]}]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{385, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452627840]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Fibonacci Polynomials",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29758],

Cell["Expand in terms of elementary functions:", "ExampleText",
 CellID->9978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Fibonacci", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2294],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}], "+", "x"}], 
            ")"}]}]], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "\[ImaginaryI]"}], "+", "x"}], ")"}]}]]}]}], 
       ")"}], "n"]}], "-", 
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}], "+", "x"}], 
            ")"}]}]], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "\[ImaginaryI]"}], "+", "x"}], ")"}]}]]}]}], 
       ")"}], 
      RowBox[{"-", "n"}]], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"n", " ", "\[Pi]"}], "]"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}], "+", "x"}], ")"}]}]], 
    " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[ImaginaryI]"}], "+", "x"}], ")"}]}]]}], 
   ")"}]}]], "Output",
 ImageSize->{573, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->592911049]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12373],

Cell["Explicitly construct Fibonacci polynomials:", "ExampleText",
 CellID->2625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"m", "=", "0"}], 
     RowBox[{"Floor", "[", 
      FractionBox[
       RowBox[{"n", "-", "1"}], "2"], "]"}]], 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{
       RowBox[{"n", "-", "m", "-", "1"}], ",", "m"}], "]"}], " ", 
     SuperscriptBox["x", 
      RowBox[{"n", "-", 
       RowBox[{"2", " ", "m"}], "-", "1"}]]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->376818],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "4"]}]}], "}"}]], "Output",
 ImageSize->{219, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172501618]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", 
    RowBox[{"n", ",", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "4"]}]}], "}"}]], "Output",
 ImageSize->{219, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275402863]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19283],

Cell["\<\
Large arguments can give results too large to be computed explicitly:\
\>", "ExampleText",
 CellID->10552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fibonacci", "[", 
  RowBox[{"10", "^", "12."}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28284],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->477632282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13255],

Cell["\<\
Results for integer arguments may not hold for non-integers: \
\>", "ExampleText",
 CellID->5540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Fibonacci", "[", 
     RowBox[{"2", "n"}], "]"}], "==", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Fibonacci", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "2"], "-", 
     SuperscriptBox[
      RowBox[{"Fibonacci", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "2"]}]}], ",", 
   RowBox[{"n", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5618],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->871777717]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Fibonacci", "[", 
    RowBox[{"2", "n"}], "]"}], "==", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Fibonacci", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "2"], "-", 
    SuperscriptBox[
     RowBox[{"Fibonacci", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "2"]}]}], "/.", 
  RowBox[{"n", "->", "2.5"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5826],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->533204985]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20509],

Cell["Matrix power representation is valid only for integers:", "ExampleText",
 CellID->3045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPower", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", "2.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2.4097486115256355`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.08299620924913746`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.4893065462657096`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.1342906875025028`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.4893065462657091`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.13429068750250278`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9204420652599263`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.21728689675164023`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{308, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167894786]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fibonacci", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "+", "1"}], ",", "n"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "}"}], "]"}], "/.", 
  RowBox[{"n", "->", "2.5"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.4097486115256355`", ",", "1.4893065462657091`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4893065462657091`", ",", "0.9204420652599261`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169221044]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21778],

Cell["Fibonacci numbers modulo 10:", "ExampleText",
 CellID->19233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"Fibonacci", ",", "100"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21293],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "3", ",", "1", 
   ",", "4", ",", "5", ",", "9", ",", "4", ",", "3", ",", "7", ",", "0", ",", 
   "7", ",", "7", ",", "4", ",", "1", ",", "5", ",", "6", ",", "1", ",", "7", 
   ",", "8", ",", "5", ",", "3", ",", "8", ",", "1", ",", "9", ",", "0", ",", 
   "9", ",", "9", ",", "8", ",", "7", ",", "5", ",", "2", ",", "7", ",", "9", 
   ",", "6", ",", "5", ",", "1", ",", "6", ",", "7", ",", "3", ",", "0", ",", 
   "3", ",", "3", ",", "6", ",", "9", ",", "5", ",", "4", ",", "9", ",", "3", 
   ",", "2", ",", "5", ",", "7", ",", "2", ",", "9", ",", "1", ",", "0", ",", 
   "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "3", ",", "1", 
   ",", "4", ",", "5", ",", "9", ",", "4", ",", "3", ",", "7", ",", "0", ",", 
   "7", ",", "7", ",", "4", ",", "1", ",", "5", ",", "6", ",", "1", ",", "7", 
   ",", "8", ",", "5", ",", "3", ",", "8", ",", "1", ",", "9", ",", "0", ",", 
   "9", ",", "9", ",", "8", ",", "7", ",", "5", ",", "2", ",", "7", ",", "9", 
   ",", "6", ",", "5"}], "}"}]], "Output",
 ImageSize->{480, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118212007]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{"Fibonacci", ",", "200"}], "]"}], ",", "10"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9076],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdlUtuFEEQREusWLJgwYJFMUIIIYTM/48Tmz/GgDFgA7YbYxtYcYU6Sh+l
lhyjj8ARAE28kTJSGqVeZ3RMVk52z5n9XxuHx0opv/99/ud5/FnOuUTm45Gv
n4h8/aTlU8pV+bTpuY7/zHzPmt+5yLrzpr9g/hftey/Rv2LJ6peNr5j/Vev3
mvV3XZlz3zD9TfO/pcwcbpvfHWXOc9f098z/vnim/ECZWLZ6ZG4w/g9zvw2m
vxX8VV/J+rJq/jDzeZT9Gsx5Hmd9g/F/oqz5NJh4anXj8sz8YfVbnlt/MPvw
IusbjP9L+lEdZn5rysx3LevLK/OHmc86+nm0dau/ztxg/N/kfgPmvLD2oZu+
vM3+AWs+DZZfh3WespH1AfN7wZpPh4l3uR7GDZZ/h5nPZu4vYPZhM+s7zP69
V9Z8AmZ+sM7TTV8+ZP+AZ7ofVnSrl4+ZA5Z/g5kfzP5t4a/7t7K+wfLvMM/v
dvYLmH3bzvoOM79PyuwfrGhW78blc/YPWP02mP2DeX6/ZH3A7B+s+XSY+e3k
88RO1jdY/h1m/3bR667dXG/GfaFX3sv9Bsz+wTy/pi9D9q8wzyMsvwHWeZrp
R5jfC9Z8Jpj4muvVOGD5DzDzgdXfCLNvpp/Mv+wraz4VZp9hnWcwfYPlP8Iz
fT+smKxevmWuMO8TWP0OML8vrH0YTd/Nf4J5fg+yX4V5Hx1k/QDzfoA1nxFW
dKtPxuUw+1dY/QbM/sH8v5h+hNk/WPOZzK8c5fPUo6wPWP4DzP4t9PMYrd6N
J/Mv33O/FWb/YO3DYPoGs38w/3fmN8E6T/mR9RXmfQKzf7CiWX007uY/wbz/
fi76+wtPzQsr
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 200.}, {0., 9.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->406856180]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2486],

Cell[TextData[{
 "Fibonacci modulo n ",
 ButtonBox["[more info]",
  BaseStyle->"NKSLink",
  ButtonData:>{
    URL["http://www.wolframscience.com/nksonline/page-890b-text", None]}],
 ":"
}], "ExampleText",
 CellID->18625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"Fibonacci", "[", "n", "]"}], ",", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "200"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2159],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdlktuFEEMhlusWLJgwYJFgxBCCCHC+x0TEgIBQgiT1yQhlUwPCSuu4KP0
UWrJMfoIHAFQ/q8lu6SR9f12uVzPnmsnvzbnF5qm+f3v99+etz+LTWwW9YsW
9UsW9cv41a6k+KsW9Tb1u57ibiT/zVTPrTTebYv6HYv63ZT3Xsq7kPT7Kf5B
Gv9hqu9R4scp/knSn6b6nyV+blF/YXHcl6n+V2m81yl+Mfkt1usw6/Um6i4e
8y7Fen0p6W/jeC4e45ZjXl9O9a2kOmDsO1mtj8PMdzXqvhr15n2qH6a+Dyk/
zDqtyWpffS3pH2V1zh3mfHyS1blxmHX4LMv6JW7WU/3ryf8l9ReP67hhIa+J
yeuw5lM3kv419jMx++Kw7l2FqW8z1m+wrMuiV/zswzdZvT8G671xWPVUmPEn
Yu2HwXp/fBLj6yTpW7K6xwYTtxX1ip97uK047Ydtx/Ec1vtTYd6FndjPxOP8
d6Je8XP+dolXr92oO8z+wZzTPens016qH1a9VTzq01iPibknPo16nUa92U/1
w4y/H/NV8Rh3IJ31O4i6w3ovKjr9D8W6LyYez8lhrKcSzzvwPdUvZj8dP/3H
eNkjWc4/rOaw7n0Vj3pRP93LtsQ4g7W/pcR6HNb3tief6q8l6gP5WNfjyO1x
1A2rfgU/48N6n3uY857iB5j1O4HPWwtzHsXoBb/qcTHvWo+f/YL1Xg3J38zE
ev9bWN87E7M/BT/fa5j1n0W94mf+sxjXdDFv28V5WRfrKF3UHda71nexvtpF
feii3sxl1Vox993EnI8iHu81ft23fp508uv7O8B8P37E+lvxeJ/FrF9J7LBa
n/xVzLwG/Ny/U81L69GKyWsw+y/m/5mfxn49fu4Z/fXeDPg5f2ex/haWNVn0
gs46E6/3pz+LeoX13RiIZ/yfyndkfwHbf0R7
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{{0., 200.}, {0., 196.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->98062694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28472],

Cell[TextData[{
 "Count the number of 1, 2, ..., 9, 0 digits in the 1,000,000",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " ",
 Cell[BoxData[
  ButtonBox["Fibonacci",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fibonacci"]], "InlineFormula"],
 " number:"
}], "ExampleText",
 CellID->9361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"Fibonacci", "[", 
   RowBox[{"10", "^", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120914192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "20843", ",", "20874", ",", "20894", ",", "20780", ",", "20889", ",", 
   "20858", ",", "21077", ",", "20976", ",", "20871", ",", "20926"}], 
  "}"}]], "Output",
 ImageSize->{490, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50752983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26924],

Cell[TextData[{
 "Contours of vanishing real and imaginary parts of ",
 Cell[BoxData[
  ButtonBox["Fibonacci",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fibonacci"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"Fibonacci", "[", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"Im", "[", 
       RowBox[{"Fibonacci", "[", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "\[Equal]", "0"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "8"}], ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469119703],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxcnAk0VV0bx++95muerlmaB1SSBg17KykRSaMmJUSDSINCRamIQqI0qaQ5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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl1FV0EAQYBeANNhiMHoyOAQMWbMDobjYYtWAbMRAFAREkVEIMulEwCFtS
aUxQUkIJFSUETDoslAbx2/Hhu//7Pef+Ef2HpwwLDAgI6Ctybi5yE0QwechL
CPnITygFKEghClOEohQjjOKUIJySlKI0ZShLOcpTgYpUIoLKVKEqkVSjOjWI
IpoYYqlJHPHUojZ1SKAu9ahPAxrSiMY0oSnNaE4LWtKK1rShLe1oTwcSSaIj
nUimM13oSje6k0IqaaTTgwwyyaInvehNH7JzuqcfD9CfB3mIAQzkYQYxmCE8
wlAeZRjDeYwRjGQUo3mcJ3iSMYxlHON5igk8zTM8y3NMZBKTmcJUpjGdGcxk
FrOZw1zm8TwvMJ8FvMhLvMwrLGQRi1nCq7zG67zBm7zF27zDUpaxnBWsZBXv
8h6rWcNa1rGeDWxkE+/zAR/yER/zCZvZwqd8xla2sZ0d7GQXn7ObPexlH1/w
Jfs5wEEO8RVf8w2H+ZbvOMJRjnGc7znBSU7xAz/yEz/zC79ymjOc5RznucBF
LnGZK/zG7/zBn/zFVf7mH65xnRvc5Ba3ucNd7vEv98kZfyC5yE0QweQhLyHk
Iz+hFKAghShMEYpSjDCKU4JwSlKK0pShLOUoTwUqUokIKlOFqkRSjerUIIpo
YoilJnHEU4va1CGButSjPg1oSCMa04SmNKM5LWhJK1rThra0oz0dSCSJjnQi
mc50oSvd6E4KqaSRTg8yyCSLnvSiN33IDvz/9/4HweKTxA==
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwVzGWADgYAgOGPiWmmY5qZms7pzs3ZMMw4nae7u+60w52uOzG1TQ6bbpu2
iU3bdLfHj+f9+WYJDgnqEiMQCNSV5rQgmJa0ojVtaEs72tOBjnSiMx8GIXSl
G93pQU960Zs+9KUf/RnAQAYxmCEMZRjDGcFIRjGaMYxlHOOZwERCCWMSk5nC
VKYxnRnMJJxZzGYOEUQyl3nMZwELWcRilrCUZSwnimhWsJJVrOZH1rCWdaxn
Az/xM7+wkU1sZgtb2cavbGcHO/mN39nFbvawl33s5wAHOcRhjnCUYxznD/7k
BCc5xWnOcJZznOcv/uYCF7nEZf7hX65wlWtc5wY3ucVt/uN/7nCXe9znAQ95
xGOe8JRnPOcFL3nFa97wlncEYgYCMYjJR8QiNnGIy8fEIz4JSEgiEpOEpCTj
E5KTgpSkIjVpSEs60pOBT8lIJjKThaxkIzs5yMln5OJzcpOHvOQjP19QgIIU
ojBFKEoxilOCkpSiNF9ShrKUozwVqEglKlOFqlSjOjWoSS1qU4e6fMXX1COI
+nzDtzSgIY34jsY0oSnf04wfaE4LgmlJK1rThra0oz0d6EgnOtOFELrSje70
oCe96E0f+tKP/gxgIIMYzBCGMozhjGAkoxjNGMYyjvFMYCKhhDGJyUxhKtOY
zgxmEs4sZjOHCCKZyzzms4CFLGIxS1jKMpYTRTQrWMkqVvMe9Imseg==
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN0+eDyAUAgOHfLeuEkJESGlZklVFGRBmVbIqTvbrToGWXmVLZCk0UDuc4
HM7e+3C2M88+e6/nw/P+B2/hdjGNokOCIIiS2NAgmMNc5hHHfOJZwEISWMRi
lpDIUpaxnCRWsJJVrGYNa1nHejawkU1sZgtb2cZ2drCTXSSzmz3sJYV97OcA
BznEYY5wlFSOcZwTnOQUp0njDGc5x3kucJFLpHOZK1zlGte5wU1ucZs73OUe
93nAQx4RhAVBCKGEEU4EGchIJjKThUiy8gTZyE4OniQnucjNU+QhL/nIz9MU
4BmepSDPUYjCFOF5XuBFXqIoxShOCUryMqUozSuUoSzlKE8FXuU1KlKJylTh
dd6gKtWoTg3epCa1eIva1OFt3qEu9ahPA97lPd6nIR/QiMY0oSnNaE4LWtKK
D/mI1rQhirZ8TDva04GOdKIzXehKN7rTg0+IJoaefMpnfM4X9KI3X/IVX/MN
39KHvvSjPwMYyCC+43sGM4ShDGM4I/iBkfzIT4ziZ37hV0YzhrGMYzwTmMgk
fuN3JjOFqfzBn/zF3/zDv0xjOjP4j/+ZySxmE8sc5jKPOOYTzwIWksAiFrOE
RJayjOUksYKVrGI1a1jLOtazgY1sYjNb2Mo2trODnewimd3sYS8p7GM/BzjI
IQ5zhKOkcozjnOAkpzhNGmc4yznOc4GLXCKdy1zhKte4zg1ucovb3OEu97jP
Ax7yiCDc/4QSRjgRZCAjmchMFiLJymN2/Mpv
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGeAiAUAANDv6i5Sx7l9544bbu/tVikVyuo0bHURRXftpampRdEwKqNC
NIyijBKRUWYZDRo0aZIG9X68l9rY3NAUEgRBicJDg6A1bYigLZFEEU0MscQR
TwKJtCOJZNrTgRRSSSOdjmSQSRbZ5JBLHvkUUEgRxZRQShnlVFBJFZ2opoZa
6qjnNE6nM2dwJl04i7M5h650ozvnch496EkvetOH82mgLxdwIRdxMf3ozwAG
MojBDGEol3ApjVzGMIZzOSMYyRVcyShGcxVNNHM113At13E9N3AjN3Ezt3Ar
Y7iN27mDO7mLuxnLPdzLfdzPAzzIOB7iYR7hUR5jPBN4nCeYyCSe5Cme5hkm
M4WpTONZnuN5pjODmcziBV7kJWYzh7m8zDzm8wqv8hqvs4CFLGIxb/AmS1jK
W7zNMpazgpW8w7us4j1Ws4b3Wcs6PmA9G9jIJj7kIzazha1sYzs7+JhP2Mku
drOHT/mMz/mCvezjS77ia75hPwf4lu/4nh/4kZ84yCF+5hd+5Td+5w8Oc4Q/
Ocpf/M0//MsxjvMfQVgQhHACJxJKGCfRgpacTCtO4VTCaU0bImhLJFFEE0Ms
ccSTQCLtSCKZ9nQghVTSSKcjGWSSRTY55JJHPgUUUkQxJZRSRjkVVFJFJ6qp
oZY66vkf0KuNfQ==
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGeADgQAANBPspJkpWVcKKLQkLK54+64w7lhH2evO3uPs+e5c9wZd0KU
nb0yy94VDUIRoqXQVHg/3gtKSIpKzBEIBOJVO1cgUIe61KM+DQgmhIY0IpQw
wmlMEyKIpCnNaE4ULYgmhljiaEkrWtOGtrSjPfF0oCMJdKIzXehKN7rTg570
ojd9SCSJvvSjPwMYyCAGM4ShDGM4IxjJKEYzhmTGMo7xTGAik5jMFKYyjenM
IIWZpJLGLNKZzRwyyGQu85jPArLIZiHvsojFLOE9lrKM9/mA5axgJatYzRrW
8iHrWM8GNrKJzWxhK9vYzg4+Yie72M0e9rKPj/mE/RzgIIc4zBGOcozjnOAk
pzjNp3zG55zhLF/wJV/xNec4zzdc4CKX+JbvuMwVvucq17jOD9zgJj/yEz/z
C79yi9/4ndvc4S5/8Cd/8Tf/8C/3+I//uc8DArkDgRw8Qk4eJRe5yUNe8vEY
+XmcAjxBQZ6kEIUpQlGK8RTFeZpneJbneJ4SlKQUpQniBcpQlnK8yEuUpwIv
U5FKvMKrVKYKVXmN13mDN6nGW1Tnbd6hBjWpRW3qUJd61KcBwYTQkEaEEkY4
jWlCBJE0pRnNiaIF0cQQSxwtaUVr2tCWdrQnng50JIFOdKYLXelGd3rQk170
pg+JJNGXfvRnAAMZxGCGMJRhDGcEIxnFaMaQzFjGMZ4JTGQSk5nCVKYxnRmk
MJNU0phFOrOZQwaZzGUe81lAFtk8BAnlsX8=
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGOAFgYAANCvVl1etr1WLdvLWl2rlrls27WFLdtduGy75ZZt2zbej/dS
NmoX3DZMIBBIqhkRAoGZzGI2c5hLCPOYzwIWEsoiFrOEpSxjOStYySpWs4a1
rGM9G9jIJjazha1sYzs72MkudvMfe9jLPvZzgIMc4jD/c4SjHOM4JzjJKU5z
hrOc4zwXuMglLnOFq1zjOje4yS1uc4e73OM+D3jIIx7zhKc84zkveMkrXvOG
t7zjPR/4yCc+84WvfCMQFAiEISw/EI7wRCCIiEQiMlGISjSi8yMxiEksYhOH
uMQjPglISCISk4SkJCM5KUhJKlKThrSkIz0Z+ImM/EwmMpOFX8hKNrKTg5zk
Ijd5yEs+8lOAghSiMEUoSjGK8yslKEkpSlOGspSjPBWoSCV+ozJVCKYqv1ON
6tTgD2pSi9rUoS71qE8DGtKIxjThT5rSjOa0oCWtaE0b2tKO9nSgI53oTBe6
0o3u9KAnvehNH/rSj/4MYCCDGMwQhvIXfzOM4YxgJP/wL6MYzRjGMo7xTGAi
k5jMFKYyjenMYCazmM0c5hLCPOazgIWEsojFLGEpy1jOClayitWsYS3rWM8G
NrKJ74GenBk=
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN01VjkAUAQNEPBmyju2swUkkRUEBQOpRGkW5EJQUpJZXuDoPuUOnuhhGj
u7u7PQ/n/oMb0bRdjbYxgiBoL2tCg2At61jPBjayic1sYSvb2M4OdrKL3exh
L/vYzwGiOMghDnOEaI5yjOOc4CSnOM0ZznKO81zgIpe4zBWuco3r3OAmt7jN
He5yj/s84CGPeMwTnvKM57zgJa94zRve8o73BGFBEIOYhBCL2MQhlDDCiUs8
4pOAhCQiMUlISjKSk4KUpCI1aUhLOtKTgYxkIjMRZCErkWQjOznISS5y8wEf
koe85CM/BSjIRxTiYwpThKJ8wqcUozgl+IySlOJzvqA0ZShLOcpTgYpUojJV
+JKvqEo1qlODmtSiNnX4mm+oy7fUoz4NaEgjGtOEpjSjOS1oSSta8x1t+J4f
+JG2tKM9HehIJ36iM134ma50ozs96Mkv/EovetOHvvSjP7/xOwMYyCAGM4Sh
DGM4IxjJKEYzhrGMYzwTmMgkJjOFqfzBn/zF30xjOjOYySxmM4e5zGM+C1jI
IhazhKX8w7/8xzKWs4KVrGI1a1jLOtazgY1sYjNb2Mo2trODnexiN3vYyz72
c4AoDnKIwxwhmqMc4zgnOMkpTnOGs5zjPBe4yCUuc4WrXOM6N7jJLW5zh7vc
4z4PeMgjHvOEpzzjOS94ySte84a3vOM9Qbj/iUkIsYhNHEIJI5y4xCM+CUhI
IhKThKQkIzkpSEkqUpOGtKQjPRnISCYyE0EWshJJNrKTg5zk4n/Qlcyx
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{2346, 2347, 2348, 2349, 2350, 2351, 2352, 2353, 2354, 2355, 
        2356, 2357, 2358, 2359, 2360, 2361, 2362, 2363, 2364, 2365, 2366, 
        2367, 2368, 2369, 2370, 2371, 2372, 2373, 2374, 2375, 2376, 2377, 
        2378, 2379, 2380, 2381, 2382, 2383, 2384, 2385, 2386, 2387, 2388, 
        2389, 2390, 2391, 2392, 2393, 2394, 2395, 2396, 2397, 2398, 2399, 
        2400, 2401, 2402, 2403, 2404, 2405, 2406, 2407, 2408, 2409, 2410, 
        2411, 2412, 2413, 2414, 2415, 2416, 2417, 2418, 2419, 2420, 2421, 
        2422, 2423, 2424, 2425, 2426, 2427, 2428, 2429, 2430, 2431, 2432, 
        2433, 2434, 2435, 2436, 2437, 2438, 2439, 2440, 2441, 2442, 2443, 
        2444, 2445, 2446, 2447, 2448, 2449, 2450, 2451, 2452, 2453, 2454, 
        2455, 2456, 2457, 2458, 2459, 2460, 2461, 2462, 2463, 2464, 2465, 
        2466, 2467, 2468, 2469, 2470, 2471, 2472, 2473, 2474, 2475, 2476, 
        2477, 2478, 2479, 2480, 2481, 2482, 2483, 2484, 2485, 2486, 2487, 
        2488, 2489, 2490, 2491, 2492, 2493, 2494, 2495}],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN0+eDyAUAgOGfddyddbaKEEmUnew0bGWWpHD2VkbKbEi7CGXLSqFCRRrW
ORx37py99zzcnTPuuOP58Lz/wVs2cmj7IdmCIOgsG0ODYBOb2UIUW4lmG9vZ
QQw72UUscewmngT2kMhe9rGfAxzkEIc5wlGOcZwTnOQUpznDWc5xngtc5BKX
uUISV7nGdZJJIZUbpHGTW9zmDulkcJd7ZJLFfYKwIMhGdnKQk1yEkJs8hBJG
OHnJR34KUJAIClGYIhSlGMUpQUke4mEeoRSleZQylKUcj1GeCjxORZ6gEk9S
mSo8xdNUpRrVqUFNalGbZ6jDs9SlHvVpQEMa0ZjnaMLzvMCLvERTmtGcFrSk
Fa1pw8u8Qlva0Z4OdKQTr/IanXmdLrxBV97kLbrRnR5E0pNe9KYPfelHfwYw
kEEMZghDGcbbvMNwRjCSUbzLaN7jfcYwlnGMZwIT+YAP+YiPmcQnTOZTPuNz
vuBLvuJrvuFbpjCV75jGdGbwPT8wk1nMZg5zmcd8FvAjC1nEYpawlJ9Yxs/8
wnJWsJJf+Y3fWcVq1vAHf/IXa1nH36znH/7lP/5nAxvZxGa2EMVWotnGdnYQ
w052EUscu4kngT0kspd97OcABznEYY5wlGMc5wQnOcVpznCWc5znAhe5xGWu
kMRVrnGdZFJI5QZp3OQWt7lDOhnc5R6ZZHGfINz/ZCcHOclFCLnJQyhhhJOX
fOSnAAWJoBCFKUJRilGcB0wUx8k=
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGWADgYAANCPmWa63bnC6XYn7jBtw3R3TDPNTFvoZszEdMdCd7fZtMnp
tolh3o/3Qlp1q9U1TiAQiFSGJIFARjKRmSxkJYhgshFCKGGEE0F2cpCTSHKR
mzzkJR/5KUBBClGYIhSlGMWJIpoSlKQUpYkhljKUpRwfU54KVKQSlalCVarx
CZ9SnRrU5DNqUZs61KUe9WlAQxrRmCY0pRnNaUFLWtGaNrSlHe35nA50pBOd
6UJXutGdHnxBT3rRmz70pR/9GcBAvmQQXzGYIQxlGMMZwUhG8TXf8C3fMZox
jGUc45nARCYxmSlMZRrTmcFMvmcWs/mBOfzIXOYxnwX8xEIWsZglLGUZy1nB
SlaxmjWsZR3r2cDP/MKv/MZGNrGZLWxlG9vZwU52sZs97GUf+znAQQ5xmCMc
5RjHOcFJTvE7p/mDPznDWc5xngtc5BKX+YsrXOUa17nBTf7mFre5w13ucZ8H
POQRj3nCU57xnH/4lxe85BWv+Y83vOUd/xNIGgjEIS4fEI8PiU8CEpKIxCQh
KclIzkekICWpSE0a0pKO9GQgI5nITBayEkQw2QghlDDCiSA7OchJJLnITR7y
ko/8FKAghShMEYpSjOJEEU0JSlKK0sQQSxneA2l8lW4=
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{3137, 3138, 3139, 3140, 3141, 3142, 3143, 3144, 3145, 3146, 
        3147, 3148, 3149, 3150, 3151, 3152, 3153, 3154, 3155, 3156, 3157, 
        3158, 3159, 3160, 3161, 3162, 3163, 3164, 3165, 3166, 3167, 3168, 
        3169, 3170, 3171, 3172, 3173, 3174, 3175, 3176, 3177, 3178, 3179, 
        3180, 3181, 3182, 3183, 3184, 3185, 3186, 3187, 3188, 3189, 3190, 
        3191, 3192, 3193, 3194, 3195, 3196, 3197, 3198, 3199, 3200, 3201, 
        3202, 3203, 3204, 3205, 3206, 3207, 3208, 3209, 3210, 3211, 3212, 
        3213, 3214, 3215, 3216, 3217, 3218, 3219, 3220, 3221, 3222, 3223, 
        3224, 3225, 3226, 3227, 3228, 3229, 3230, 3231, 3232}],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGeAiAUAANBPlJITWSmSlZGMolIqhYyUrUG2CNGSjJLRsKKMiso448zD
Gefsvc858w537s7Zbtln9X68V6pz3xZ9cgRB0FEz8gbBTEKZxWzmMJcw5jGf
BSxkEYsJZwlLWUYEy1nBSlYRyWqiWMNa1rGeDWxkE5vZwla2sZ0d7GQXu9nD
XvYRzX5iOEAsBznEYY5wlGPEEc9xTnCSBBI5RRLJpHCaVM5wlnOc5wIXucRl
0kgng0yyuMJVrnGdG9zkFtnc5g53ucd9gpAgyMED5CQXD/IQuXmYR8jDo+Ql
hHw8Rn4K8DgFKURhilCUJyjGkzxFcUrwNCV5hlKUpgxlKcezlKcCFanEc1Tm
eapQlWpU5wVepAY1eYmXeYVavMpr1OZ13uBN6vAWb1OXetTnHRrQkEY05l2a
8B7v05RmNKcFLWlFa9rwAR/yER/TlnZ8Qns60JFOdKYLXenGp3SnB5/Rk170
5nP60Jcv+JKv+Jpv6Me39Oc7BjCQQQzme35gCD8ylGEMZwQ/8TO/8CsjGcVo
xjCW3xjHeH7nDyYwkUlM5k/+4m+mMJV/+Jf/mMZ0ZjCTUGYxmznMJYx5zGcB
C1nEYsJZwlKWEcFyVrCSVUSymijWsJZ1rGcDG9nEZrawlW1sZwc72cVu9rCX
fUSznxgOEMtBDnGYIxzlGHHEc5wTnCSBRE6RRDIpnCaVM5zlHOe5wEUucZk0
0skgkyyucJVrXOcGN7lFNre5w13ucZ8gXxD8D0QX4Ec=
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN0+eDDwQAgOHfWXfGDe6sO8cNhzvO2XfOWbc540gqI0Up646Ikqx2tDOK
slsqbbPSRANlFGVTGRkRsvJ8eN7/4I0fXNq7JCgQCBRLUFggUIaylKM8FQgm
hIpUojJVCCWMcCKoSjUiiaI6NahJLWoTTQx1iKUu9YgjngQSqU8SDWhII5JJ
oTFNSKUpaTSjOS1oSSta04Z0MmhLJu3Ioj0d6EgnOpNNDrnkkU8BhXShK0V0
ozs96EkxvejNDfThRvpyEzdzC/3ozwAGciuDuI3bGcwQ7uBOhnIXdzOM4Yxg
JKMooZTRjOEexjKOexnPBO7jfibyAJN4kMlMYSrTmM5DPMwjPMpjPM4TPMkM
ZvIUT/MMz/Icz/MCLzKL2cxhLi/xMvOYzyu8ygIWsojFLGEpy3iN13mDN3mL
5bzNO7zLCt7jfT7gQz7iYz5hJatYzRrWso5P+YzPWc8XfMlXfM03fMsGNrKJ
7/ieH/iRzWxhKz/xM9vYzg528gu/sovd/Mbv7GEv+9jPAQ5yiMMc4Q/+5C+O
cozjnOBvTnKK05zhH85yjn85zwUu8h+XuMwVrnKN/wmE+58ylKUc5alAMCFU
pBKVqUIoYYQTQVWqEUkU1alBTWpRm2hiqEMsdalHHPEkkEh9kmhAQxqRTAqN
aUIqTUmjGc1pQUta0Zo2pJNBWzJpRxbt6UBHOtGZbHLIJY98CiikC10pohvd
6UFPirkOtpug3g==
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwVxGeADgQAANAPoUJIZhRF9gglEqESJdzZnHH2urPX2evOdufOusOdcfYe
Z509s8oqGkZRthYVyfPjvUKh4UFhaQKBwLMaZg0EggimEY1pQlOa0ZwWtKQV
IbSmDW1pRyjt6UBHOtGZLnSlG93pQU/CCKcXvelDX/rRnwEMZBCDGUIEQxnG
cEYwklGMZgxjGcd4IoliAhOZxGSmMJVpTCeaGGYQSxwzmcVs5jCXeBKYx3wW
kEgSC1nEYpaQzFKWsZwVrGQVq1nDWtaxng1sZBOb2UIKW9nGdnawk1R2sZs9
7GUf+znAQQ5xmCMc5UuOcZwTnOQUX/E1pznDWc5xnm/4lgtc5Du+5wd+5BKX
ucJVfuJnrnGdX/iVG9zkFre5w13ucZ/f+J0/+JO/eMBD/uYf/uURj/mPJ/xP
IFsgkIa0pOM50pOBjDzPC7xIJjKThZfISjay8zI5eIWc5CI3echLPl4lPwV4
jdcpSCHe4E0KU4S3KEoxilOCkpSiNGUoSznepjwVqMg7vEsl3qMyVXifqnxA
NarzITWoSS0+4mM+oTafUoe6fMbn1OML6tOAhgQRTCMa04SmNKM5LWhJK0Jo
TRva0o5Q2tOBjnSiM13oSje604OehBFOL3rTh770oz8DGMggBjOECIYyjOGM
YCSjGM0YxjKO8UQSxQQmMonJTGEq05hONDHMIJY4ZjKL2cxhLvEkMI/5LCCR
JBayiMUsIZmlLGM5K1jJKlazhrWsYz0b2MgmNrOFFLayje3sYCep7OIpOgTS
DQ==
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{4287, 4288, 4289, 4290, 4291, 4292, 4293, 4294, 4295, 4296, 
        4297, 4298, 4299, 4300, 4301, 4302, 4303, 4304, 4305, 4306, 4307, 
        4308, 4309, 4310, 4311, 4312, 4313, 4314, 4315, 4316, 4317, 4318, 
        4319, 4320, 4321, 4322, 4323, 4324, 4325, 4326, 4327, 4328, 4329, 
        4330, 4331, 4332, 4333, 4334, 4335, 4336, 4337, 4338, 4339, 4340, 
        4341, 4342, 4343, 4344, 4345, 4346, 4347, 4348, 4349, 4350, 4351, 
        4352, 4353, 4354, 4355, 4356, 4357, 4358, 4359, 4360, 4361, 4362, 
        4363, 4364, 4365, 4366, 4367, 4368, 4369, 4370, 4371, 4372, 4373, 
        4374, 4375, 4376, 4377, 4378, 4379, 4380, 4381, 4382, 4383}],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxFVgFQQAAMAHSHcKkqO7u7tzdG+jGSzo7u4GBQWTLgUUFCSlG6VUUunu
5j7ugsIigyNiBAKBcGVJHggEkZVsZCcHOclFbvKQl3zkpwAFKURhilCUYhSn
BCUpRWnKUJZylKcCFalEZapQlWpUpwY1qUVt6lCXetSnAQ1pRGOaEExTmtGc
FrSkFa1pQ1va0Z4OdCSEUMLoRGe60JVudKcHPQmnF72JIJIooulDX/rRnwEM
ZBCDGcJQhjGcEYxkFKMZw1jGMZ4JTGQSk5nCVKYxnRnMZBazmcNc5jGfBSxk
EZ/zBYtZwpd8xVKW8TXf8C3f8T0/sJwVrGQVq1nDWtaxng1s5Ed+YhOb2cLP
/MJWtvErv7GdHfzOTnaxmz3sZR9/sJ8DHOQQhznCUY5xnBOc5BSnOcOf/MVZ
znGeC1zkb/7hXy5xmStc5RrX+Y//ucFNbnGbO9zlHvd5wEMe8ZgnPOUZz3nB
S17xmje85R3v+UAgRSAQg5jE4hNiE4e4xCM+CUhIIhKThKQkIzkpSEkqUpOG
T0lLOj4jPRnISCYyk4UgspKN7OQgJ7nITR7yko/8FKAghShMEYpSjOKUoCSl
KE0ZylKO8lSgIpWoTBWqUo3q1KAmtahNHepSj/o0oCGNaEwTgmlKM5rTgpa0
ojVtaEs72tOBjoQQShid6EwXutKN7vSgJ+H0ojcRRBJFNH3oSz/6M4CBDGIw
QxjKMIYzgpGMYjRjGMs4xjOBiUxiMlP4COBavc0=
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGOAFgYAANAvu5atVcu27VpYdi172bZ1l+4ylrFle7ktm2vLNt+P91K3
6FKzc5hAIJBM4+MEAhOYyCQmM4WpTGM6MwgimJnMYjZzmEsIocxjPgtYyCIW
s4SlLGM5v7OClaxiNWtYyzrWs4GN/MGfbGIzW9jKNrazg53sYjd72Ms+9nOA
gxziMEf4i6Mc4zgnOMkpTnOGv/mHs5zjPBe4yCUuc4WrXOM6N7jJLW5zh7vc
41/u8x//84CHPOIxT3jKM57zgpe84jVveMs73vOBj3ziM1/4yjcCcQOBMIQl
HOGJQEQiEZkoRCUa0YlBTGLxA7GJQ1ziEZ8EJCQRiUlCUpKRnBSkJBWp+ZE0
pCUdP5GeDGQkE5nJQlaykZ0c5CQXuclDXvKRnwIUpBCFKUJRilGcEpSkFKUp
Q1nKUZ4KVKQSlalCVX6mGtWpQU1+oRa1qUNd6lGfBjSkEY1pQlOa0ZwW/EpL
WtGaNrSlHe3pQEc60ZkudOU3utGdHvSkF73pQ1/60Z8BDGQQgxnCUIYxnBGM
ZBSjGcNYxjGeCUxkEpOZwlSmMZ0ZBBHMTGYxmznMJYRQ5jGfBSxkEYtZwlKW
8R2hu6ae
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{5031, 5032, 5033, 5034, 5035, 5036, 5037, 5038, 5039, 5040, 
        5041, 5042, 5043, 5044, 5045, 5046, 5047, 5048, 5049, 5050, 5051, 
        5052, 5053, 5054, 5055, 5056, 5057, 5058, 5059, 5060, 5061, 5062, 
        5063, 5064, 5065, 5066, 5067, 5068, 5069, 5070, 5071, 5072, 5073, 
        5074, 5075, 5076, 5077, 5078, 5079, 5080, 5081, 5082, 5083, 5084, 
        5085, 5086, 5087, 5088, 5089, 5090, 5091, 5092, 5093, 5094, 5095, 
        5096, 5097, 5098, 5099, 5100, 5101, 5102, 5103, 5104, 5105, 5106, 
        5107, 5108, 5109, 5110, 5111, 5112, 5113, 5114, 5115, 5116, 5117, 
        5118, 5119, 5120, 5121, 5122, 5123, 5124, 5125, 5126, 5127, 5128, 
        5129, 5130, 5131, 5132, 5133, 5134, 5135, 5136, 5137, 5138, 5139, 
        5140, 5141, 5142, 5143, 5144, 5145, 5146, 5147, 5148, 5149, 5150, 
        5151, 5152, 5153, 5154, 5155, 5156, 5157, 5158, 5159, 5160, 5161, 
        5162, 5163, 5164, 5165, 5166, 5167}],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{5168, 5169, 5170, 5171, 5172, 5173, 5174, 5175, 5176, 5177, 
        5178, 5179, 5180, 5181, 5182, 5183, 5184, 5185, 5186, 5187, 5188, 
        5189, 5190, 5191, 5192, 5193, 5194, 5195, 5196, 5197, 5198, 5199, 
        5200, 5201, 5202, 5203, 5204, 5205, 5206, 5207, 5208, 5209, 5210, 
        5211, 5212, 5213, 5214, 5215, 5216, 5217, 5218, 5219, 5220, 5221, 
        5222, 5223, 5224, 5225, 5226, 5227, 5228, 5229, 5230, 5231, 5232, 
        5233, 5234, 5235, 5236, 5237, 5238, 5239, 5240, 5241, 5242, 5243, 
        5244, 5245, 5246, 5247, 5248, 5249, 5250, 5251, 5252, 5253, 5254, 
        5255, 5256, 5257, 5258, 5259, 5260, 5261, 5262, 5263, 5264, 5265, 
        5266, 5267, 5268, 5269, 5270, 5271, 5272, 5273, 5274, 5275, 5276, 
        5277, 5278, 5279, 5280, 5281, 5282, 5283, 5284, 5285, 5286, 5287, 
        5288, 5289, 5290, 5291, 5292, 5293, 5294, 5295, 5296, 5297, 5298, 
        5299, 5300, 5301, 5302, 5303, 5304, 5305, 5306, 5307, 5308, 5309, 
        5310, 5311, 5312, 5313, 5314, 5315, 5316, 5317}],
       RowBox[{
         RowBox[{"Re", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Re[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN01VjkAUAQNGP7t5GbMTo7m4pQWmVFkmlW0EJJaRLQhCly6JTEZDu7u7u
ZjDiPJz7D25kq671u8QIgqCHbA8Jgh3sZBe72cNe9rGfAxzkEIc5wlGOcZwT
nOQUpznDWc5xngtc5BKXucJVrnGdG9zkFre5w13ucZ8HPOQRj3nCU57xnBe8
JIpXvCaaN7zlHUFoEMQgJrGITRziEo/4JCAhiUhMEpKSjOSkICWpCCGUMFKT
hrSkI5wI0pOBjGQiksxkISvZyE4OcpKL3OQhL/nITwEKUojCFKEoxShOCUpS
itKUoSzlKE8FKvIBlahMFapSjQ+pTg0+4mNqUova1KEu9ajPJ3zKZzSgIY1o
TBOa0ozPac4XtKAlrWhNG9ryJV/RjvZ0oCOd6EwXutKN7vSgJ734mm/oTR++
5Tv60o/+DOB7fmAggxjMEH5kKMMYzghGMorRjGEs4xjPT0xgIpOYzM9MYSq/
MI1f+Y3pzGAms5jNHOYyj/ksYCG/8wd/8hd/s4jFLGEpy1jOClayitWsYS3/
8C/r+I/1bGAj/7OJzWxhK9vYzg52sovd7GEv+9jPAQ5yiMMc4SjHOM4JTnKK
05zhLOc4zwUuconLXOEq17jODW5yi9vc4S73uM8DHvKIxzzhKc94zgteEsUr
XhPNG97yjiDM/8QkFrGJQ1ziEZ8EJCQRiUlCUpKRnBSkJBUhhBJGatKQlnSE
E0F6MpCRTESSmSxkJRvZyUFOcpGbPOQlH/kpQEEKUZgiFKUYxSnBe0FI2VQ=

        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN02OjFgYAQOE321ruZmNr2TZutmurdm+2bdu2bdtaWw0ZW7bxfHjOPzhB
zUODQ8IEAoEwki9hIJCfAhSkEIUpQlGKUZwSlKQUpSlDWcpRngpUpBKVqUJV
qlGdYGpQk1rUpg51qUd9GtCQRjSmCU1pRnNa0JJWtKYNv/ArbWlHe34jhFA6
0JFOdKYLXelGd3rQk170pg996Ud/BjCQQQxmCEMZxnBGMJJRjGYMYxnHeCYw
kUlMZgpTmcZ0ZjCTWcxmDnOZx3wWsJBFLGYJS1nGclawklWsZg1rWcd6NrCR
TWxmC1vZxnZ2sJNd7GYPe9nHfg5wkEMc5ghHOcZxTnCSU5zmDGc5x3kucJFL
XOYKv3OVP/iTa1znL/7mH/7lBje5xW3ucJd73OcBD/mP/3nEY57wlGc85wUv
ecVr3vCWd7znAx/5xGe+8JVvBBL5hLCEIzwRiEgkIhOFqEQjOjGISSxiE4e4
xCM+CUhIIn4gMUlISjKSk4KUpCKI1KQhLelITwYykonMZCEr2chODnKSix/5
idz8TB7yko/vtAaXvQ==
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGWADgYAANDvNmaTh3GHMd1dc/oOp+t0jtN1J8eYmlzo7rbpjoWY7u5m
atNsw+T78V6G6NiomKBAIBCssJBAoDglKEkpSlOGsoQTQTnKU4FIKlKJylSh
KtWoTg1qUovaRFGHutSjPg1oSCMa04SmNKM5X9KClkTTita0oS3taE8HOtKJ
znQhhli60o3u9KAnvfiK3vTha/rSj2/ozwAGMojBfMsQhjKM4YxgJN/xPT/w
I6MYzRjGMo7xTGAik5jMFKYyjenMYCazmM0c5jKP+SxgIYtYzE/8zBKWsozl
rGAlq1jNGtayjvVsYCOb2Mwv/Mpv/M4WtrKN7fzBDnayi93sYS/72M8BDnKI
wxzhKMc4zglOcorTnOEs5zjPBS5yictc4SrXuM4N/uQmt7jNHe7yF39zj/s8
4CGPeMwTnvKMf/iX/3jOC17yP694zRve8o5AaCAQxAd8SBzi8hHx+JhPiE8C
EpKIxCQhmKQkIzmfkoKUhBBKKlKThs9ISzo+Jz0ZyEgmMpOFrGQjOznISS5y
k4e85CM/BShIIQpThKJ8QTHCKE4JSlKK0pShLOFEUI7yVCCSilTiPYhgngY=

        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGeADgQAANCPREkakhW6NBQqJVtG2fvszdmcO+PubG6ZZ9xxOOusO3s7
3J3ZNBq0UKFCA2WWTd6P94JCwoPDcgQCgSg1LBwINKIxTWhKM5rTgpYE04rW
tKEt7WhPBzrSic50oSvd6E4PQuhJL3rTh770oz8DGEgogwgjnMEMYSjDiCCS
KIYzgpGMYjRjGMs4xhNNDLHEEc8EJjKJyUxhKglMYzozmEkiScxiNsnMYS7z
SGE+C1jIIhaTyhKWsozlrCCNdFayitWsYS3rWM8GNrKJzWxhK9vIYDs72Ekm
WWSzi93sYS/72M9HfMwnfMpnfM4BDnKIw3zBl3zF1xzhKN/wLd/xPT9wjOOc
4Ed+4mdOcorT/MKv/MYZznKO3/mDP/mL81zgIn/zD5e4zBWuco3r/Mt/3OAm
t7jNHe5yj/s84H8CRQKBHOTkEXLxKLnJw2M8Tl6eIB9Pkp+neJpneJYCPEdB
nqcQhSlCUYrxAsUpQUleJIiXKMXLvMKrvEZpXucNylCWcrzJW7xNed7hXSrw
HhWpRGWqUJVqVKcG71OTWtSmDh/wIXWpR30a0JBGNKYJTWlGc1rQkmBa0Zo2
tKUd7elARzrRmS50pRvd6UEIPelFb/rQl370ZwADCWUQYYQzmCEMZRgRRBLF
cEYwklGMZgxjGcd4ookhljjimcBEJjGZKUwlgWlMZwYzSSSJWcwmmTnMZR4p
zGcBC1nEYlJZwlKWsZwVpJHOSlaxmjWsZR3r2cBGNrGZLWxlGxlsZwc7ySSL
bHaxmz3s5SG1I+IX
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxFVgFQQAAMAHEpKC9AillEZCQko6BJWUkJAOGS3d3Y1KKShdKi3dXWMb
bLDRzUZ33sdd1pZd6gTHCQQC5bQjQyCwk13sZg972cd+DnCQQxzmCEc5xnFO
cJJThHCaUMII5wxniSCSc5wnimgucJFLXOYKV7nGdW5wk1vc5g53iSGWe9zn
AQ95xGOe8JRnPOcFL3nFa97wlncEggKBOMTlA+IRnwQk5EMSkZgkJCUZyfmI
FKTkY1KRmjSkJR3pyUAQGclEZrLwCZ+SlWxkJwc5+YzPyUVu8pCXfOSnAAX5
gkIUpghF+ZJiFKcEJfmKUpSmDGUpx9eUpwIVqURlqlCValSnBt9Qk1p8y3d8
T23qUJd61KcBP9CQRjSmCT/SlGY0pwU/0ZJWtKYNbWlHezrQkU78TGeC6UJX
utGdHvSkF7/Qmz70pR/9GcBABjGYIQxlGMMZwUhGMZoxjGUc45nARCYxmSlM
ZRrTmcFMZvErv/E7s5nDXOYxnz/4kwUs5C/+ZhGLWcJSlrGcFaxkFatZwz/8
y3+sZR3r2cBGNrGZ/9nCVraxnR3sZBe72cNe9rGfAxzkEIc5wlGOcZwTnOQU
IZwmlDDCOcNZIojkHOeJIpoLXOQSl7nCVa5xnRvc5Ba3ucNdYojlHvd5wEMe
8ZgnPOUZz3nBS17xmje8B94D2Ds=
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN01VjkAUAQNGP7q6xjRjd3d2doxsGjC6REKVb6e40QGmUDoPu7g4BFRRU
wCDOw7n/4EZE9YvsGyMIgl7yNjQI3hGEBUEMYhKL2MQhLvGITwISkojEJCEp
yUhOClKSitSkIS3pCCE9oYQRTgYykonMRJCFrGQjOznISS5yk4e85CM/BShI
IQpThKIUozglKEkpSlOGspSjPBWoSCUqU4WqVKM6NahJLWpTh7rUoz4NaEgj
GhNJE5rSjOa0oCWtaE0b2tKO9nSgI52IojNd6Eo03ehOD3rSi970oS/96M8A
PmAgHzKIwQxhKB8xjI/5hOGMYCSjGM0YxjKO8UxgIpOYzKd8xhSmMo3pzGAm
s5jNHOYyj/ksYCGLWMwSlrKM5axgJatYzed8wZd8xRrW8jXfsI71bGAjm9jM
FrbyLd+xje3sYCe72M0e9rKP/XzPD/zITxzgIIc4zBGOcozjnOAkpzjNGc5y
jvNc4CKXuMwVrnKN69zgJre4zR3uco/7POAhP/OIxzzhF37lN57yjN/5g+e8
4E/+4m9e8orX/MO//Mf/vOEt7wjC/U9MYhGbOMQlHvFJQEISkZgkJCUZyUlB
SlKRmjSkJR0hpCeUMMLJQEYykZkIspCVbGQnBznJRW7ykJd85KcABSlEYYpQ
lGIUpwQlKUVpylCWcpSnAhWpRGWqUJVqVKcGNalFbepQl3rUpwENaURjImlC
U5rRnBa0pBWtaUNb2tGeDnSkE1F0pgtdiaYb3XkPJfy/oQ==
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxFVgFQQAAMAHEtIp0hKSSndZtHQqSHdudDcb3QNGbMCADUYKCirdonR3
dzcoCnofd9nbBNcPihMIBCqrc+ZAoAtd6UZ3ggimBz3pRW/60Jd+9GcAAxnE
YIYwlGEMZwQjGcVoQghlDGMZx3gmMJFJTGYKU5nGdGYQxkxmMZtw5jCXecwn
gkgWsJBFRLGYJSwlmhiWsZxYVrCSVaxmDWv5kXWs5yd+ZgMb+YVf+Y1NbGYL
W9nGdnawk13sZg972cfv7OcP/uQABznEYY5wlGMc5wQnOcVpznCWc5znAhe5
xGWucJVrXOcGN7nFbe5wl3vc5wEPecRjnvCUZzznBS95xWve8Bd/85Z/+Jd3
vOc/AlkCgTjE5QPiEZ8EJORDEpGYJCQlGclJQUpSkZo0pOUj0vEx6clARjKR
mSxk5ROykZ0c5ORTcpGbPOQlH/n5jM8pQEEKUZgiFKUYxSlBSUpRmjKUpRzl
qcAXfMlXfM03VKQSlalCVapRnW+pQU1qUZs61KUe9WlAQxrRmO/4niY05Qea
0ZwWtKQVrWlDW9rRng50pBOd6UJXutGdIILpQU960Zs+9KUf/RnAQAYxmCEM
ZRjDGcFIRjGaEEIZw1jGMZ4JTGQSk5nCVKYxnRmEMZNZzCacOcxlHvOJIJIF
LGQRUSxmCUuJJoZlLCeWFaxkFav5H17Oyys=
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN02OjkAcAQOE328a9t5u1VcuuLawWttrianHZthtyC8vY0lq2bdu2bT4f
nvMPTniDNlVaRwiCoIcsDAmCRSxmCUtZxnJWsJJVrGYNa1nHejawkU1sZgtb
2cZ2drCTXexmD3vZx34OcJBDHOYIRznGcU5wklOc5gxnOcd5LnCRS1zmCle5
xnVucJNb3OYOd7nHfR7wkEc85glPecZzXvCSV7zmDW95x3s+8JFPBKFBEIGI
RCIyUYhKNKITg5jEIjZxiEs84pOAhCQiMUlISjKSk4KUpCI1IYQSRhrCSUs6
0pOBjGQiM1nISjay8wVfkoOc5OIrcpOHvOQjPwUoSCEKU4SiFKM4JSjJ13xD
KUpThrJ8SznK8x0VqEglKvM9P1CFqvzIT1SjOjWoSS1q8zN1qMsv1KM+DWhI
IxrzK01oSjOa04KWtKI1bWhLO9rTgY50ojNd6Eo3utODnvSiN33oSz/6M4CB
DGIwv/E7f/AnQxjKMIYzgpGMYjR/MYaxjGM8fzOBiUxiMlOYyjSmM4OZ/MO/
zGI2c5jLPP5jPv+zgIUsYjFLWMoylrOClaxiNWtYyzrWs4GNbGIzW9jKNraz
g53sYjd72Ms+9nOAgxziMEc4yjGOc4KTnOI0ZzjLOc5zgYtc4jJXuMo1rnOD
m9ziNne4yz3u84CHPOIxT3jKM57zgpe84jVveMs73vOBj3wiCPM/EYlEZKIQ
lWhEJwYxiUVs4hCXeMQnAQlJRGKSkJRkJCcFKUlFakIIJYw0hJOWdKQnAxnJ
RGY+A+G79do=
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{7977, 7978, 7979, 7980, 7981, 7982, 7983, 7984, 7985, 7986, 
        7987, 7988, 7989, 7990, 7991, 7992, 7993, 7994, 7995, 7996, 7997, 
        7998, 7999, 8000, 8001, 8002, 8003, 8004, 8005, 8006, 8007, 8008, 
        8009, 8010, 8011, 8012, 8013}],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxFVgFQQAAMA3uruGdEin0ql0w+gVMGBKd0ujdHdJd3ejdCggKAgoHaKk
0pL3cZc1qktI56BAIBCsupkDgXrUpwEhNKQRjWlCU5rRnFDCCCeCSFrQklZE
0Zo2tCWar/iadrSnAx3pRGe60JVudKcHPelFb/rQl370ZwDfMJBBDGYIQxnG
cEbwLd8xklGMZgxjGcd4JjCRSUxmClOZxnRmMJNZzGYOc5nHfL5nAQtZxGKW
sJRlLGcFK1nFatawlnWsZwMb2cRmtrCVbWxnBzvZxW72sJd97OcHfuQABznE
YY5wlGMc5wQn+YmfOcVpzvALZznHr/zGeS7wOxe5xGX+4E+ucJVrXOcGN7nF
be5wl7+4x9/8w30e8JBHPOYJ//IfT3nGc17wkle85n/e8JZ3vOcDgSyBQBAx
iEksYhOHuMQjPglISCISk4SkJCM5KUhJKlKThrSkI5j0fEIGMpKJzGQhK9nI
Tg5y8im5yE0e8pKP/BSgIIUoTBGK8hmfU4zilKAkpShNGcpSjvJUoCJf8CWV
qEwVqlKN6tSgJrWoTR3qUo/6NCCEhjSiMU1oSjOaE0oY4UQQSQta0oooWtOG
tkTzEeSprIY=
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGOAFgYAANCvlrHstrpsc1vmFpZt47rLtm3btm3bdm15YbXlej/eC2oU
WikkTCAQCFbz5IFAC1rSitYE04YQQmlLO9rTgY50ojNd6Eo3utODnvSiN33o
Sz/6M4CBDGIwQxjKMIYzgpGMYjRjGMs4xjOBiUxiMlOYyjSmM4OZzGI2c5jL
POazgIUsYjFLWMoylrOClaxiNWtYyzrWs4GNbGIzW9jKNrazg53sYjd72Ms+
9nOAgxziMEc4yjGOc4KTnOI0ZzjLOc5zgYtc4jJXuMo1rnODm9ziNne4yz3u
84CH/MXfPOIxT3jKM57zgn94ySte84Z/ecs7/uN/3vOBj3ziM1/4yjcCQYFA
GMLyA+EITwQiEonIRCEq0YjOj8QgJrGITRziEo/4JCAhiUhMEpLyEz+TjOQE
kYKUpCI1aUhLOtKTgYxkIjNZyEo2spODnOQiN3nISz7y8wu/8hsFKEghClOE
ohSjOCUoSSlK8zt/UIaylKM8f1KBilSiMlWoSjWqU4Oa1KI2dahLPerTgIY0
ojFNaEozmtOClrSiNcG0IYRQ2tKO9nSgI53oTBe60o3u9KAnvehNH/rSj/4M
YCCDGMwQhjKM4YxgJKMYzRjGMo7xTGAik5jMFKYyjenMYCazmM0c5jKP+Sxg
IYtYzBKWsozlrGAlq1jNGtayjvVsYCOb2MwWtrKN7exgJ7vYzR72so/9HOAg
hzjMEY5yjOOc4CSnOM0ZznKO83wHB9vx+g==
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGOgFgYAAMAvc3F59Xp5S8u2rYVl27Zt27aXjdWWbds278ddcP02FVuH
CAQCQToTHAic5RznucBFLnGZK1zlGte5wU1ucZs73OUe93nAQx7xmCc85RnP
ecFLXvGaN7zlHe/5wEc+8ZkvfOUb3/lBIEkgEIKQhCI0YQhLOMITgYhEIjK/
EIWoRCM6MYjJr8QiNnGISzzik4DfSEgigkhMMElISjKSk4KUpOJ3/iA1aUhL
OtLzJxnISCYyk4WsZCM7OchJLnKTh7zkIz8FKEghClOEohSjOCUoSSlKU4ay
lKM8FahIJf6iMlWoSjX+pjo1qEktalOHutSjPg1oSCMa04SmNKM5LWhJK1rT
hra0oz0d6EgnOtOFrnSjOz3oSS9604e+9KM/AxjIIAYzhKEMYzgjGMkoRjOG
sYxjPBOYyCQmM4WpTGM6M5jJLGYzh7nMYz4LWMgiFrOEpSxjOStYySpWs4a1
rGM9G9jIP2xiM1vYyja2s4Od7GI3e9jLPvZzgIP8yyEO8x//c4SjHOM4JzjJ
KU5zhrOc4zwXuMglLnOFq1zjOje4yS1uc4e73OM+D3jIIx7zhKc84zkveMkr
fgKLJcKj
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{8946, 8947, 8948, 8949, 8950, 8951, 8952, 8953, 8954, 8955, 
        8956, 8957, 8958, 8959, 8960, 8961, 8962, 8963, 8964, 8965, 8966, 
        8967, 8968, 8969, 8970, 8971, 8972, 8973, 8974, 8975, 8976, 8977, 
        8978, 8979, 8980, 8981, 8982, 8983, 8984, 8985, 8986, 8987, 8988, 
        8989, 8990, 8991, 8992, 8993, 8994, 8995, 8996, 8997, 8998, 8999, 
        9000, 9001, 9002, 9003, 9004, 9005, 9006, 9007, 9008, 9009, 9010, 
        9011, 9012, 9013, 9014, 9015, 9016, 9017, 9018, 9019, 9020, 9021, 
        9022, 9023, 9024, 9025, 9026, 9027, 9028, 9029, 9030, 9031, 9032, 
        9033, 9034, 9035, 9036, 9037, 9038, 9039, 9040, 9041, 9042, 9043, 
        9044, 9045, 9046, 9047, 9048, 9049, 9050, 9051, 9052, 9053, 9054, 
        9055, 9056, 9057, 9058, 9059, 9060, 9061, 9062, 9063, 9064, 9065, 
        9066, 9067, 9068, 9069, 9070, 9071, 9072, 9073, 9074, 9075, 9076, 
        9077, 9078, 9079, 9080, 9081, 9082, 9083, 9084, 9085, 9086, 9087, 
        9088, 9089, 9090, 9091, 9092, 9093, 9094, 9095, 9096, 9097, 9098, 
        9099, 9100}],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGOAFgYAANAvLHstt1xb9lpYbstcWrbbqmXbti/btm3jLtdl2+/Heyka
tK3UJkwgEGivEakCgZGMYjRjGMs4xjOBiUxiMlOYyjSmM4OZzGI2QcxhLvOY
zwIWsojFLGEpy1jOClayitWsYS3rWM8GNrKJzWxhK9vYzg52sovd7GEv+9jP
AQ5yiMMc4SjHOM4JTnKK05zhLOc4zwUuconLXOEqwYRwjevc4Ca3uM0d7nKP
UO7zgIc84jFPeMoznvOCl7ziNW94yzve84GPfOIzX/jKNwKpA4EwhCUc4fmB
CEQkEpGJQlSiEZ0YxCQWsYnDj8TlJ+IRnwQkJBGJSUJSfiYZyUlBSlKRmjSk
JR2/8CvpyUBGMpGZLGQlG9nJQU5ykZvfyMPv5CUf+SnAHxSkEIUpQlGKUZwS
/MlflKQUpSlDWcpRngpUpBKVqcLfVKUa1alBTf6hFrWpQ13qUZ8GNKQRjWlC
U5rRnBa0pBWtaUNb/uU/2tGeDvxPRzrRmS50pRvd6UFPetGbPvSlH/0ZwEAG
MZghDGUYwxnBSEYxmjGMZRzjmcBEJjGZKUxlGtOZwUxmMZsg5jCXecxnAQtZ
xGKWsJRlLGcFK1nFatawlnWsZwMb2cRmtrCVbWxnBzvZxW72sJd97OcABznE
YY5wlGMc5wQnOcVpznCWc5znAhe5xGWucJVgQrjGdW5wk1vc5g53uUco93nA
Qx7xmCc85RnPecFLXvGaN7zlHe/5wEc+8ZkvfOUb3wFJjg5i
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwV0+eDDwQAgOHfOYdzzro77jjjcPvOTYc7e89zjtBQUbJPGaUpylY0KLPs
lVHaaZCikFE2LVJWQ4NS6enD8/4Hb9zAUcUlQYFAoOj/xAcCQZQimNKEUIay
lCOU8oRRgXAqUonKVKEqEUQSRTWqE00MNahJLLWoTR3qEkc96tOAeBJIJIlk
UkgljXQakkEmWWSTQy6NyKMxTWhKPgU0ozktaEkrWtOGtrSjPR3oSCc604Wu
dKM7hfSgiJ4U04ve3EAf+tKPG7mJm7mF/tzKbdzOAAZyB3cyiLsYzBCGMozh
jGAkJYzibu5hNGMYyzju5T7Gcz8P8CAP8TCPMIFHmcgkHuNxJjOFqUxjOjOY
ySye4ElmM4eneJpneJa5zOM5nmc+C1jIIhazhBd4kaUsYzkrWMkqVrOGtaxj
PS+xgY1sYjMv8wpbeJXXeJ03eJO3eJt32Mq7vMf7fMA2tvMhO/iIj9nJLj7h
U3azh718xj72c4CDfM4XHOIwRzjKMY5zgpOc4ku+4mu+4VtOc4bvOMv3/MA5
znOBi1ziR37iZ37hMr/yG7/zB1e4yp/8xTX+5h/+5TqBBP9TimBKE0IZylKO
UMoTRgXCqUglKlOFqkQQSRTVqE40MdSgJrHUojZ1qEsc9ahPA+JJIJEkkkkh
lTTSaUgGmWSRTQ65NCKPxjShKfkU0IzmtKAlrWhNG9rSjvZ0oCOd6EwXutKN
7hTSg/8A5Wu+vQ==
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwNxGeADgQAANDvKklJSkUUISsNI4WQvYU7+wbOOI4bnLuz9x539uacs+6M
c7aWkVGorIYV2mVWyCq9H+8Vj4wLjg0KBALRalU6EGhNMCG0oS3taE8HOtKJ
UMIIJ4LOdKErkXSjOz3oSRS96E00fehLDLHEEU8/+pPAABJJIpmBDGIwQxjK
MIYzgpGMYjRjGMs4xjOBiUxiMlOYyjRSSGU6M5jJLGYzh7nMYz4LWMgiFrOE
paSxjHSWk8EKVrKK1awhkyzWso71bCCbjeSwic1sYSvb2M4OdvIBH/IRH/MJ
u9jNHvbyKfvYzwEO8hmfc4jDHOELvuQrjnKM45zgJF/zDd/yHac4zRnOco7v
Oc8FLvIDP/ITP/MLv/Ibv/MHl7jMFa5yjev8yV/8zQ1ucot/uM0d7nKP+/zL
fzwgUCYQCOIhHuYRcvEouXmMPDzOE+TlSfLxFPl5mmcowLM8x/MUpBAvUJgi
vMhLFKUYL1OcEpTkFUpRmjKUpRyvUp7XeJ03eJMKVKQSlXmLKrzNO1SlGtV5
lxrUpBbvUZs61KUe9WlAQxrRmCY0pRnNacH7tKQVrQkmhDa0pR3t6UBHOhFK
GOFE0JkudCWSbnSnBz2Johe9iaYPfYkhljji6Ud/EhhAIkkkM5BBDGYIQxnG
cEYwklGMZgxjGcd4JjCRSUxmClOZRgqpTGcGM5nFbOYwl3nMZwELWcRilrCU
NJaRznIyWMFKVrGaNWSSxVrWsZ4NZLORHDaxmS1sZRvb2cFO/gccje7y
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN01VjkAUAQNEPRjejm8FgG62UKN0gUhIKghJKl4TS3Y2CCkiHhBIGSHc3
o7u7uzkP5/6DG9a0Q+32MYIg6CarIoJgNWtYyzrWs4GNbGIzW9jKNrazg53s
Yjd72Ms+9nOAgxziMNEc4SjHOM4JTnKK05zhLOc4zwUuconLXOEq17jODW5y
i9vc4S73uM8DHvKIxzzhKc94zgte8orXvOEt7wgigyAGMQkhFrGJQ1ziEZ8E
JCQRiUlCUpKRnFBSkJJUpCYNaUlHejKQkUxkJgtZCSMb2QknBzmJIJIocpGb
POQlH/kpwAd8SEEKUZgiFOUjivExn1CcEpSkFKUpQ1nKUZ4KVKQSlalCVT6l
Gp9RnRrUpBa1+Zw61KUe9fmCL2lAQ76iEY35mm9oQlOa0Zxv+Y4WtKQVrWlD
W9rRng50pBPf05kudKUbP/Aj3elBT3rRmz70pR/9GcBABjGYIQxlGMMZwUhG
MZoxjGUc45nAT/zMRCbxC7/yG5OZwlR+ZxrTmcFMZjGbOcxlHvP5gwUsZBGL
+ZO/WMJSlrGcv/mHf/mPFazkf1axmjWsZR3r2cBGNrGZLWxlG9vZwU52sZs9
7GUf+znAQQ5xmGiOcJRjHOcEJznFac5wlnOc5wIXucRlrnCVa1znBje5xW3u
cJd73OcBD3nEY57wlGc85wUvecVr3vCWdwRR/icmIcQiNnGISzzik4CEJCIx
SUhKMpITSgpSkorUpCEt6UhPBjKSicxkISthZCM74eQgJxFEEkUucpOHvOQj
P+8BBlr8uA==
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN04ObEAYAxuHLtrW6FnaXbWtLq8uuy7q8zC0by1hatm3btrXaMtf7Pc/7
/Qe/wNAOIWHhAsxlDwoIyEFOcpGbPOQlH/kpQEEKUZgiFKUYxSlBSUpRmjKU
pRw/8wvlqUBFKlGZX6lCVUKoRnVqUJNa1KYOdalHfRrQkEY0pgmhNKUZzWlB
S1rRmja0pR3tCaMDHelEZ7rQlW78Rnd60JNe9KYPfelHfwYwkEH8zh8MZghD
GcZwRjCSUYxmDGMZx3gmMJFJ/MlkpjCVaUxnBjOZxWzm8Bdzmcd8FrCQv1nE
YpawlGUsZwUrWcVq1rCWdaxnAxvZxGa2sJVtbGcHO9nFbvawl33s5wAHOcRh
jnCUYxznBCc5xWnOcJZznOcCF7nEZa5wlWtc5wY3ucVt7nCXe9znAQ95xGOe
8JRnPOcF//CSV/zLf7zmDW95x3s+8JFPfOYLX/nG/wQEy4jwRCAikYhMFKIS
jejEICaxiE0c4hKP+CQgIYlITBKSkozkpCAlqfiB1KQhkLT8SDrSk4GM/EQQ
wWQiM1nISja+A98jqmU=
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{10800, 10801, 10802, 10803, 10804, 10805, 10806, 10807, 10808,
         10809, 10810, 10811, 10812, 10813, 10814, 10815, 10816, 10817, 10818,
         10819, 10820, 10821, 10822, 10823, 10824, 10825, 10826, 10827, 10828,
         10829, 10830, 10831, 10832, 10833, 10834}],
       RowBox[{
         RowBox[{"Im", "[", 
           RowBox[{"Fibonacci", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], 
         "\[Equal]", "0"}]],
      Annotation[#, Im[
         Fibonacci[$CellContext`x + Complex[0, 1] $CellContext`y]] == 0, 
       "Tooltip"]& ]}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-8, 8}, {-8, 8}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194132102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20579],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 " of positive and negative Fibonacci numbers: "
}], "ExampleText",
 CellID->4724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Fibonacci", "[", "x", "]"}], "]"}], "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->495123516],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9W2uoplUVfue7nXPGS/eyCzWp42iaWXmrnBEzMxMzC7Eyg2mwZgo1bCwa
scsftdKChHIs9Ucqav0wEiMwiIRIEIVIiArCIOxHEiT9GAh2z9rP2mvtvd/L
ec/pnDmc+c67v3fvtZ619lrPXnu/71yye//eq6/ZvX/fnt3bLrx+9xf27tvz
xW3vv+56fDXd0jTNo/h34zENrgOu4r9HQ8Df/PMMfE5x63j8neDv9qwtfyf6
/TT2Pls+5esQf5pt8jHzdtPsqHoc2+ohEgXeFvkbvzoNn9JltinSNwfzmeqX
41p9t2eeHCNlWPP2qsfxI6SelWGbqH15e1rMaTsmjqp03tf57btj+9Ch/2qb
s/fCC//R9nJqv/jiIfw2l0cpW/H5oKJuy5yPaS+sjZ/rrv35M0//fTL6+xv2
P/aLx/7Y2b/z+588/Hvcqr5/9g//OHfnQRg1qfBFj85vufnXkCXZd+CXT/zm
r81iPVYexvbU52Ke2465bZZiB5hajK3b9La159aOkjXSpBfc6aOuuvIh+Mnb
997z1BWXPxAslnATbn7uuX8RxQJ4Lrv0x9T9q8f/8o2vP35CZUmdLZllxaxC
DAJzkVAwaB3Vn//0T2/v2/tIbptYgUkt2gDubZjws0ee9TaiAercKrgAVkEk
rVqCMMSJefzii+4Vv3+0BzmGPv/8vxdJE64LzQXSus0YH0RetOFgqBM0RH7H
9357wfk/gnEaFYxzuZxU7Y9sDHpMctGu0R+880lvw3FFG/epLqKfIPGjBUXc
OgZawKjaQAsKxB1tuMzbkF20cR+RA7JR/yMy77/vGQSLMgrCdM+nf2pxPvXo
ObzoiQ55CfGODlDgc3hU7zOVYYPeRx5wOvQ+HK/zfdnmoIfv+tFDGMQjZhQd
GogmDFFOx31yEzJAPEwpJHiX4vGzSTYU+QlZqo3auSyJDfH+DLSG+EG+3n7b
E7TCuAZxg+jRcR43xu4YJ+3DZAUguxUYjC74VStgFSkYvWgFZoWZzpDRcU/+
7m+Itwg1ttHAV3L54U2wAg4btAKq0UawqBX0PKOIVljs0Bwdh6nS1WNRRdRI
K4q1azUrMFatsEjII0hWYGQJvtJ13XIW5ktNF1lzzmAKsS7CVKks9+giycZX
iMmxlgyuZR2WKPvn+exRRORc92OPZaZ3SKUiLmAR7Iqzs2CaExfNWsHVBN4i
epFqe5Z1W4G+Ra3gK0CXFaI992tEumy8CftYXjFmaIdFmXVYiUPhBgiSHL80
2pPXqM167BqMK2ijaXqfeWBxNWPlwIng7MDhcDsumfi4YB9aZTxmZmyNco0Z
6JsZbqAroMAlF0bLljI7rV+vnSzU3C5ExaCdnC84X+8TfG0nP2knEynE0o/Z
S3vi3Rkyi5OJzyPlmyMwFkZiCFThAp3hCGDAJzRJTl4Q7Vyu7JRMnaZSXOui
bhvRHmGjrzK0kXYQNeeR0cbKhJmVcER2RBufHg+ga1ltj46KMYm4D+NwIYwx
TaMQFhKz7+u1cfxcrmYnpqKwkxPH7KOdqGVQ0WTra1aRxX361OK0OT8k1ih3
78N51o85zyt42uOtA3OWVzPiJy5i9hWGuyejkea9ITGDnBa0995rQcqocQZA
ZySTrBY5P+dI0R1/WTLGEwvMDvd7iAB0lLqYCIdXknUgy+oPcq7XplzxrBoE
FFnj6UmvOIgT2BENEq/nrQ+nrg3dODGHkO4rHCuHLOsWFo34Yawy+7gKyuUO
tXCd+Dp4wfGR0B0fWQ9D8BvxreQ7X/MwXdu8pfLouf0IYaYh1FnKEckEzvsQ
5tXNjNr4LRFavRNSmYYLdlCEYDb4WNh0ACH8Zgg7Ys8RlhU8Y495EG8HZ1dW
u0RpGYsfm3OtjU8Oyku6OuwaREkUrALlCGveibJkmc6qRHmGaJgdvleKUShr
G4zgandKkgtCEJQ7DeUknRVm8Zf77v9DyUzI6r4p88RQihRdqU5NM6R7p3NG
eHI1jJAL+nC+Zg5TQbRybrOv+06isuq0OT0o08Bzouc9G4AKdwABvx3VGSPO
+C+krWRIVB1Pn2PlhWGwBxfvWgcmzl6BqWAT5mpWE65QPSXbSRQppokIpnAt
hkl8nb1uRP381qp6VmxHGuI5MpmEU6yn56ydBNFZG4Oo4DPOTM647EHJ3NXY
BDJylCmk5jqzCxEPeUYi6uYv5iD9wZzzqp3RjR5wncTSzoRJeeEMwzRJmxRC
WBMiX/9yRBnvZ7twOxcEC8iZ7a4kFTMr+Xh6l5c6MUl1m2OSA0nOE2MmryyZ
39mZR7YSsu3PWXYlhFrFvXM0on4eYv4QEU8rWOgEW5+JwnKfu46sdnxHRCHS
pu3a0SYpX/WKXIeKGg13hNVpXFF/OSsSDRpwm8wa0ayyX6hQdTAQQtIr1jYr
2lY1pAOSkA4Vmg+kWYMAqRbevjGIOhiIkdJGZMcc/LK5KPkeDYnk03oRcd+4
GkNj4kG1NZqcoXP2sUghETQfTBbp+cfbIpqevccqfsEVd2qKhHHM8x4iMcYJ
GTPr07qLQ8kApxqS3C+zQUSQwwOpQUQ5M9tpVMiYmd0UkUczES2pbyokTCZD
wmdovkbAVOjxc0mqyPew1V5H2BLmSNxfUsXwW0OLjTkVvdoZDb5CMWPz3ag/
SaR2IFPm/VDwtUDi9RTTnlk/rF9zllrzXSY9XleAbLNglEsicKY9eRwC4Jca
pI9ZeUofKmY1/uBz86nFB/cdq2stGJShTcuo1aolZdBJmlt9VnlFbHvNflK/
ViTQPM0VZLpWzmUfQ9oqrKfGH0tRjobUIwMakTWWV5A3pDGvwSy2dAf38TS/
0CgVz4ldGjHdQxo5kznn5ixndSjprvlECFb1yeWOLo0M2lwj4k2qoVyj86rU
NDyVMCajoc2VQXlZn7OdMEIbaAChNsSdOVPREn9+9Mkqarb3a4QY4wQ++FeN
zEgy9DT1KJ4z8xRWTlmvSjGDQkTeE6A+UmL6SW8wzbtQQHTNTNx3Wb2jsdLN
TkAJy+Uk6lOx7Sc+8fxPd7r5eV/9xshkTais7iEJtaqwmrGIylfV4zYEFVeI
DlRaWdQMdnU1i8euAQVrj5rHOQ/UQD6zNVNZtOazz1SRshYMWQ/JNSjPUeRc
nvOb+IfS/FT4s6mta9ibNwwFY4AZaitUSCWER8y+UHLCNirkizJNekBg+dKj
kytJxrNLOevZs5tGuOlzoeSENwXjhB7pxMwRJcNZDOnpFmX7GVwm26MXlIbu
Jp1R08WfVhXqjvjzoWTrN3ZJhyAMgkNy9sqq3mXDbAnCLcE1qrtPKkkxl5rV
i8v5G1Z8LwroYem1oeSpN3RJhzv47Ij5a09ntBZn/mazGJTroEW8TB3ILVgt
u/JOHYQA4EPMVe3Es10tdfjzk9eP0GEcUPCQnz/cENu+R32dy1yqZOrz7Sqr
mcjqD7Oo+VJQbtGnEgNytaKnXKtNdI9oJ44ab19OeuBnYYvXdsmlxFxuUYEY
C7PEb74SyhXhmChzVq+TtXwmfNM+FbdqWd+WORBKrn9NlM/tU3q4HPo5zvUS
uFYyZZ4al+iO7UDyP8CIF6hzJKu6RgaKyuTJkO0CQzo7Mo80N0ZpFnPNq6OS
aaaj6dEZ17QOpsif1TPyuX7dpNrHa0hWWRWTv8tUcAff9YGRAHJTFcev0rnL
fTjgSX131PNiktiqdaoOBoBW4divxrbXTa8Mg+uR2mW7l4Kx/PxnkixRrV+L
baaAXL4i1JlkWaf8ZBLov+bmUK5iL++XoOxTswQlYEZhqew22hJs3S5qGOeD
W2Lb33N6WUuC5XXBKJ7tt8a2n2281CVoptChnE9jZ42ebyafaA3VHs0ViqNt
/dC1+lspX/S86SWt0cwFjrZTCGWeb2sOtEexJ7Od6Gn8bVU0H90amb0jrm8x
0Le3p5lT3j2qNZIUwJF8cYPvlX+n8veRrZGMUXufQauw71bRdYSPkyzTPfr3
qwiqeunzlx9UUbLVesVTmqkVqCrPo2GllKc7nzuTH5Vdq16c8uZgFavxHDF2
KPJXvtDX4++KbT/XWAqj2U3aWqPdldDpqcEapei+9Yex7XX5YrQUaUaCyJ5i
zEPNYe21yP6vi465O7a9bpsVMgxztwzd/d2d4lZXJMpI63qxvmdW3JM8qG1/
Z1563x9b7f8j0v5stvwPpq5eZw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90139077]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24945],

Cell["\<\
While the Fibonacci numbers are nondecreasing for non-negative arguments, the \
Fibonacci function possesses a single local minimum:\
\>", "ExampleText",
 CellID->11737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"Prolog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"Fibonacci", "[", "k", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8372],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->655462058]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5333],

Cell["\<\
Since the generating function is rational these sums come out as rational \
numbers:\
\>", "ExampleText",
 CellID->5261719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "\[Infinity]"], 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"-", "k"}]], " ", 
   RowBox[{"Fibonacci", "[", "k", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->973853290],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314545327]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "\[Infinity]"], 
  RowBox[{
   SuperscriptBox["10", 
    RowBox[{"-", "k"}]], " ", 
   RowBox[{"Fibonacci", "[", "k", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24038],

Cell[BoxData[
 FractionBox["10", "89"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->342366950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"CoefficientList", "[", 
       RowBox[{
        RowBox[{"Fibonacci", "[", 
         RowBox[{"n", ",", " ", "x"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "60"}], "}"}]}], "]"}], ",", "2"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17250],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzlWEFuAyEMBDUf6T/6ij4hH+j/b2mkTbUyZccwNg4w0ija7BJ7MjHG+bz/
fN8/UkpfB2+/zCeIy+Fg46P1z/uvZ+TrKLDx0Xrxfrp6ZhTY+Gj9SWsC34c7
2Pho/VnrQfVnjYZRPZ+1Qn+9NbPxFfUqqf39u4GNf1Wvko37mznY+Ip6LfyV
a1FuXmDjK7QW/tZiePnMxm/wtVq/tZi1axZs/Aatxf6sjWWlmY3fojWD/svm
6o0OrbS/I874F/GbtGaj+g3S3KOV3p9Znx36q7p+jfpfNyz6K6LT+UYNh/7a
XL9G51c1LPsrovN8AuHQX9X1i3JphdF6S63QX2VO1fUB/ZWuXwSn+vfQCvdn
BKf93UVrFvU7+pxUue+pFZ6vEIzPZ65ac6V+W2F0/h6hFc5HCEbz1RCtWdTv
aARojfZ3qNYcW78RWqP25xCtB4vcevEO/RVxwvmV9nem+ZXlhPMr7a9WSyve
UKv3/xvh+v7hVPMrywnnV9pfmXsNM/RXxAnnV9rfmeZXlhPOr7S/vZhQK+tv
eP4dXKq/Ii7YX6G/UlsNC2htPV+F52vApfor4oL9Ffpbw4Jakb/h+Tlw6XqV
3KBeC3938PXFjXz983cjrWknrU8+AHVGL3Q=
   "], {{0, 0}, {60, 60}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->27407382]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7807],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GoldenRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GoldenRatio"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LucasL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LucasL"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RSolve"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26740]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11533],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->3948]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->19167],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#16020"], None}]], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/FibonacciNumber.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/Fibonacci/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Fibonacci"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->420736337],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->357329222],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->1240821],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->1500429],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->102297198]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fibonacci - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 21.8112156}", "context" -> "System`", 
    "keywords" -> {
     "fib", "Fibonacci numbers", "Fibonacci sequence", "phyllotaxis numbers", 
      "pineapple numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Fibonacci[n] gives the Fibonacci number F_n. Fibonacci[n, x] gives the \
Fibonacci polynomial F_n (x). ", "synonyms" -> {}, "title" -> "Fibonacci", 
    "type" -> "Symbol", "uri" -> "ref/Fibonacci"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8301, 292, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->603053716]},
 "Fibonacci"->{
  Cell[32245, 1205, 414, 15, 70, "Input",
   CellTags->"Fibonacci",
   CellID->5624],
  Cell[77075, 2342, 304, 10, 70, "Input",
   CellTags->"Fibonacci",
   CellID->28134],
  Cell[77382, 2354, 300, 11, 50, "Output",
   CellTags->"Fibonacci",
   CellID->621743367]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 322791, 7173},
 {"Fibonacci", 322927, 7177}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2420, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3043, 84, 47, 1, 70, "ObjectName",
 CellID->13925],
Cell[3093, 87, 1077, 36, 70, "Usage",
 CellID->13231]
}, Open  ]],
Cell[CellGroupData[{
Cell[4207, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4685, 145, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4808, 151, 596, 24, 70, "Notes",
 CellID->475],
Cell[5407, 177, 771, 28, 70, "Notes",
 CellID->252537814],
Cell[6181, 207, 525, 20, 70, "Notes",
 CellID->27332],
Cell[6709, 229, 478, 18, 70, "Notes",
 CellID->28379],
Cell[7190, 249, 645, 20, 70, "Notes",
 CellID->31102],
Cell[7838, 271, 220, 7, 70, "Notes",
 CellID->31226],
Cell[8061, 280, 203, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[8301, 292, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->603053716],
Cell[CellGroupData[{
Cell[8686, 306, 148, 5, 70, "ExampleSection",
 CellID->430586704],
Cell[8837, 313, 65, 1, 70, "ExampleText",
 CellID->30826],
Cell[CellGroupData[{
Cell[8927, 318, 207, 7, 28, "Input",
 CellID->18647],
Cell[9137, 327, 424, 11, 36, "Output",
 CellID->36326222]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9610, 344, 216, 7, 70, "ExampleSection",
 CellID->11615],
Cell[9829, 353, 72, 1, 70, "ExampleText",
 CellID->21966],
Cell[CellGroupData[{
Cell[9926, 358, 104, 3, 70, "Input",
 CellID->30804],
Cell[10033, 363, 373, 8, 71, "Output",
 CellID->761944955]
}, Open  ]],
Cell[CellGroupData[{
Cell[10443, 376, 126, 4, 70, "Input",
 CellID->31576],
Cell[10572, 382, 204, 5, 36, "Output",
 CellID->146436011]
}, Open  ]],
Cell[10791, 390, 120, 3, 70, "ExampleDelimiter",
 CellID->5025],
Cell[10914, 395, 76, 1, 70, "ExampleText",
 CellID->423],
Cell[CellGroupData[{
Cell[11015, 400, 232, 8, 70, "Input",
 CellID->15809],
Cell[11250, 410, 382, 12, 36, "Output",
 CellID->86737978]
}, Open  ]],
Cell[11647, 425, 120, 3, 70, "ExampleDelimiter",
 CellID->7030],
Cell[11770, 430, 69, 1, 70, "ExampleText",
 CellID->23375],
Cell[CellGroupData[{
Cell[11864, 435, 103, 3, 70, "Input",
 CellID->31384],
Cell[11970, 440, 176, 5, 36, "Output",
 CellID->233478316]
}, Open  ]],
Cell[CellGroupData[{
Cell[12183, 450, 178, 6, 70, "Input",
 CellID->1326],
Cell[12364, 458, 235, 7, 36, "Output",
 CellID->775823439]
}, Open  ]],
Cell[12614, 468, 121, 3, 70, "ExampleDelimiter",
 CellID->11923],
Cell[12738, 473, 57, 1, 70, "ExampleText",
 CellID->21468],
Cell[CellGroupData[{
Cell[12820, 478, 126, 4, 70, "Input",
 CellID->26278],
Cell[12949, 484, 268, 8, 36, "Output",
 CellID->19019466]
}, Open  ]],
Cell[13232, 495, 120, 3, 70, "ExampleDelimiter",
 CellID->2398],
Cell[13355, 500, 208, 7, 70, "ExampleText",
 CellID->22387],
Cell[CellGroupData[{
Cell[13588, 511, 181, 6, 70, "Input",
 CellID->24086],
Cell[13772, 519, 233, 7, 36, "Output",
 CellID->293609092]
}, Open  ]],
Cell[14020, 529, 121, 3, 70, "ExampleDelimiter",
 CellID->11161],
Cell[14144, 534, 72, 1, 70, "ExampleText",
 CellID->7541],
Cell[CellGroupData[{
Cell[14241, 539, 258, 9, 70, "Input",
 CellID->5915],
Cell[14502, 550, 1223, 41, 55, "Output",
 CellID->27696907]
}, Open  ]],
Cell[15740, 594, 125, 3, 70, "ExampleDelimiter",
 CellID->804171535],
Cell[15868, 599, 203, 7, 70, "ExampleText",
 CellID->126097607],
Cell[CellGroupData[{
Cell[16096, 610, 143, 4, 70, "Input",
 CellID->619062489],
Cell[16242, 616, 252, 9, 50, "Output",
 CellID->330963962]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16543, 631, 239, 7, 70, "ExampleSection",
 CellID->10739],
Cell[16785, 640, 61, 1, 70, "ExampleText",
 CellID->28992],
Cell[CellGroupData[{
Cell[16871, 645, 232, 8, 70, "Input",
 CellID->24419],
Cell[17106, 655, 1533, 51, 58, "Output",
 CellID->105272195]
}, Open  ]],
Cell[18654, 709, 120, 3, 70, "ExampleDelimiter",
 CellID->4614],
Cell[18777, 714, 76, 1, 70, "ExampleText",
 CellID->31630],
Cell[CellGroupData[{
Cell[18878, 719, 249, 8, 70, "Input",
 CellID->11932],
Cell[19130, 729, 2632, 79, 70, "Output",
 CellID->64021074]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21811, 814, 224, 7, 70, "ExampleSection",
 CellID->27356],
Cell[22038, 823, 83, 1, 70, "ExampleText",
 CellID->850127328],
Cell[CellGroupData[{
Cell[22146, 828, 525, 17, 70, "Input",
 CellID->557011535],
Cell[22674, 847, 302, 10, 36, "Output",
 CellID->270890014]
}, Open  ]],
Cell[CellGroupData[{
Cell[23013, 862, 308, 10, 70, "Input",
 CellID->63116039],
Cell[23324, 874, 294, 9, 36, "Output",
 CellID->82907250]
}, Open  ]],
Cell[23633, 886, 125, 3, 70, "ExampleDelimiter",
 CellID->294953161],
Cell[23761, 891, 83, 1, 70, "ExampleText",
 CellID->29408],
Cell[CellGroupData[{
Cell[23869, 896, 295, 10, 70, "Input",
 CellID->1563],
Cell[24167, 908, 648, 20, 51, "Output",
 CellID->268835925]
}, Open  ]],
Cell[24830, 931, 72, 1, 70, "ExampleText",
 CellID->13103],
Cell[CellGroupData[{
Cell[24927, 936, 306, 10, 70, "Input",
 CellID->25323],
Cell[25236, 948, 648, 20, 51, "Output",
 CellID->559823555]
}, Open  ]],
Cell[25899, 971, 71, 1, 70, "ExampleText",
 CellID->31752],
Cell[CellGroupData[{
Cell[25995, 976, 92, 3, 70, "Input",
 CellID->6867],
Cell[26090, 981, 550, 13, 54, "Output",
 CellID->780366291]
}, Open  ]],
Cell[26655, 997, 121, 3, 70, "ExampleDelimiter",
 CellID->24599],
Cell[26779, 1002, 68, 1, 70, "ExampleText",
 CellID->6623],
Cell[CellGroupData[{
Cell[26872, 1007, 378, 12, 70, "Input",
 CellID->939],
Cell[27253, 1021, 367, 10, 36, "Output",
 CellID->157465203]
}, Open  ]],
Cell[CellGroupData[{
Cell[27657, 1036, 134, 4, 70, "Input",
 CellID->24063],
Cell[27794, 1042, 258, 8, 36, "Output",
 CellID->145873261]
}, Open  ]],
Cell[28067, 1053, 121, 3, 70, "ExampleDelimiter",
 CellID->24261],
Cell[28191, 1058, 63, 1, 70, "ExampleText",
 CellID->20336],
Cell[28257, 1061, 400, 13, 70, "Input",
 CellID->1161],
Cell[CellGroupData[{
Cell[28682, 1078, 207, 7, 70, "Input",
 CellID->7646],
Cell[28892, 1087, 492, 15, 124, "Output",
 CellID->13805052]
}, Open  ]],
Cell[29399, 1105, 120, 3, 70, "ExampleDelimiter",
 CellID->5556],
Cell[29522, 1110, 300, 11, 70, "ExampleText",
 CellID->11617],
Cell[29825, 1123, 728, 23, 70, "Input",
 CellID->29865],
Cell[30556, 1148, 86, 1, 70, "ExampleText",
 CellID->14612],
Cell[CellGroupData[{
Cell[30667, 1153, 258, 8, 70, "Input",
 CellID->82911068],
Cell[30928, 1163, 901, 23, 137, "Output",
 CellID->780196394]
}, Open  ]],
Cell[31844, 1189, 120, 3, 70, "ExampleDelimiter",
 CellID->6633],
Cell[31967, 1194, 275, 9, 70, "ExampleText",
 CellID->19352],
Cell[32245, 1205, 414, 15, 70, "Input",
 CellTags->"Fibonacci",
 CellID->5624],
Cell[32662, 1222, 478, 16, 70, "Input",
 CellID->11262],
Cell[33143, 1240, 71, 1, 70, "ExampleText",
 CellID->4139],
Cell[CellGroupData[{
Cell[33239, 1245, 354, 11, 70, "Input",
 CellID->8152],
Cell[33596, 1258, 5536, 95, 70, "Output",
 Evaluatable->False,
 CellID->527197259]
}, Open  ]],
Cell[39147, 1356, 121, 3, 70, "ExampleDelimiter",
 CellID->11112],
Cell[39271, 1361, 142, 5, 70, "ExampleText",
 CellID->17425],
Cell[CellGroupData[{
Cell[39438, 1370, 315, 11, 70, "Input",
 CellID->28156],
Cell[39756, 1383, 157, 5, 36, "Output",
 CellID->3710355]
}, Open  ]],
Cell[CellGroupData[{
Cell[39950, 1393, 103, 3, 70, "Input",
 CellID->8348480],
Cell[40056, 1398, 163, 5, 36, "Output",
 CellID->48232973]
}, Open  ]],
Cell[40234, 1406, 125, 3, 70, "ExampleDelimiter",
 CellID->303676422],
Cell[40362, 1411, 90, 1, 70, "ExampleText",
 CellID->40779680],
Cell[CellGroupData[{
Cell[40477, 1416, 464, 16, 70, "Input",
 CellID->25219],
Cell[40944, 1434, 1073, 27, 153, "Output",
 CellID->25968157]
}, Open  ]],
Cell[42032, 1464, 121, 3, 70, "ExampleDelimiter",
 CellID->26015],
Cell[42156, 1469, 234, 8, 70, "ExampleText",
 CellID->14631],
Cell[CellGroupData[{
Cell[42415, 1481, 413, 14, 70, "Input",
 CellID->13673],
Cell[42831, 1497, 22416, 372, 70, "Output",
 Evaluatable->False,
 CellID->65349252]
}, Open  ]],
Cell[65262, 1872, 118, 3, 70, "ExampleDelimiter",
 CellID->74],
Cell[65383, 1877, 91, 1, 70, "ExampleText",
 CellID->19243],
Cell[CellGroupData[{
Cell[65499, 1882, 349, 11, 70, "Input",
 CellID->908],
Cell[65851, 1895, 1078, 24, 158, "Output",
 CellID->57083811]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66978, 1925, 233, 7, 70, "ExampleSection",
 CellID->32664],
Cell[CellGroupData[{
Cell[67236, 1936, 234, 7, 70, "ExampleSubsection",
 CellID->32261],
Cell[67473, 1945, 79, 1, 70, "ExampleText",
 CellID->14367],
Cell[CellGroupData[{
Cell[67577, 1950, 141, 4, 70, "Input",
 CellID->5783],
Cell[67721, 1956, 596, 23, 79, "Output",
 CellID->86681925]
}, Open  ]],
Cell[CellGroupData[{
Cell[68354, 1984, 212, 7, 70, "Input",
 CellID->22744],
Cell[68569, 1993, 294, 9, 36, "Output",
 CellID->26646452]
}, Open  ]],
Cell[68878, 2005, 121, 3, 70, "ExampleDelimiter",
 CellID->17010],
Cell[69002, 2010, 53, 1, 70, "ExampleText",
 CellID->9330],
Cell[CellGroupData[{
Cell[69080, 2015, 312, 10, 70, "Input",
 CellID->20284],
Cell[69395, 2027, 262, 10, 51, "Output",
 CellID->210760977]
}, Open  ]],
Cell[69672, 2040, 120, 3, 70, "ExampleDelimiter",
 CellID->5521],
Cell[69795, 2045, 69, 1, 70, "ExampleText",
 CellID->31328],
Cell[69867, 2048, 306, 11, 70, "Input",
 CellID->16041],
Cell[70176, 2061, 187, 7, 70, "Input",
 CellID->992],
Cell[CellGroupData[{
Cell[70388, 2072, 199, 7, 70, "Input",
 CellID->32629],
Cell[70590, 2081, 425, 11, 36, "Output",
 CellID->107878423]
}, Open  ]],
Cell[71030, 2095, 124, 3, 70, "ExampleDelimiter",
 CellID->73468172],
Cell[71157, 2100, 101, 3, 70, "ExampleText",
 CellID->781117648],
Cell[71261, 2105, 187, 7, 70, "Input",
 CellID->16606483],
Cell[71451, 2114, 453, 16, 70, "Input",
 CellID->108716658],
Cell[71907, 2132, 182, 6, 70, "Input",
 CellID->124286756],
Cell[CellGroupData[{
Cell[72114, 2142, 213, 7, 70, "Input",
 CellID->627728566],
Cell[72330, 2151, 306, 9, 36, "Output",
 CellID->129161294]
}, Open  ]],
Cell[72651, 2163, 223, 8, 70, "ExampleText",
 CellID->68110738],
Cell[CellGroupData[{
Cell[72899, 2175, 541, 18, 70, "Input",
 CellID->340256544],
Cell[73443, 2195, 304, 9, 36, "Output",
 CellID->4658403]
}, Open  ]],
Cell[73762, 2207, 121, 3, 70, "ExampleDelimiter",
 CellID->12267],
Cell[73886, 2212, 92, 1, 70, "ExampleText",
 CellID->662780443],
Cell[CellGroupData[{
Cell[74003, 2217, 459, 15, 70, "Input",
 CellID->19977],
Cell[74465, 2234, 223, 8, 36, "Output",
 CellID->396757486]
}, Open  ]],
Cell[74703, 2245, 119, 3, 70, "ExampleDelimiter",
 CellID->315],
Cell[74825, 2250, 56, 1, 70, "ExampleText",
 CellID->599],
Cell[CellGroupData[{
Cell[74906, 2255, 262, 9, 70, "Input",
 CellID->20999],
Cell[75171, 2266, 1681, 63, 85, "Output",
 CellID->261774924]
}, Open  ]],
Cell[76867, 2332, 121, 3, 70, "ExampleDelimiter",
 CellID->32717],
Cell[76991, 2337, 59, 1, 70, "ExampleText",
 CellID->32653],
Cell[CellGroupData[{
Cell[77075, 2342, 304, 10, 70, "Input",
 CellTags->"Fibonacci",
 CellID->28134],
Cell[77382, 2354, 300, 11, 50, "Output",
 CellTags->"Fibonacci",
 CellID->621743367]
}, Open  ]],
Cell[77697, 2368, 73, 1, 70, "ExampleText",
 CellID->10858],
Cell[CellGroupData[{
Cell[77795, 2373, 181, 6, 70, "Input",
 CellID->32494],
Cell[77979, 2381, 974, 32, 36, "Output",
 CellID->12066279]
}, Open  ]],
Cell[78968, 2416, 119, 3, 70, "ExampleDelimiter",
 CellID->725],
Cell[79090, 2421, 107, 3, 70, "ExampleText",
 CellID->5140],
Cell[CellGroupData[{
Cell[79222, 2428, 210, 7, 70, "Input",
 CellID->20354],
Cell[79435, 2437, 557, 18, 39, "Output",
 CellID->452627840]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80041, 2461, 238, 7, 70, "ExampleSubsection",
 CellID->29758],
Cell[80282, 2470, 78, 1, 70, "ExampleText",
 CellID->9978],
Cell[CellGroupData[{
Cell[80385, 2475, 165, 5, 70, "Input",
 CellID->2294],
Cell[80553, 2482, 1919, 68, 65, "Output",
 CellID->592911049]
}, Open  ]],
Cell[82487, 2553, 121, 3, 70, "ExampleDelimiter",
 CellID->12373],
Cell[82611, 2558, 81, 1, 70, "ExampleText",
 CellID->2625],
Cell[CellGroupData[{
Cell[82717, 2563, 563, 19, 70, "Input",
 CellID->376818],
Cell[83283, 2584, 471, 16, 39, "Output",
 CellID->172501618]
}, Open  ]],
Cell[CellGroupData[{
Cell[83791, 2605, 236, 8, 70, "Input",
 CellID->31206],
Cell[84030, 2615, 471, 16, 39, "Output",
 CellID->275402863]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[84562, 2638, 226, 7, 70, "ExampleSection",
 CellID->19283],
Cell[84791, 2647, 116, 3, 70, "ExampleText",
 CellID->10552],
Cell[CellGroupData[{
Cell[84932, 2654, 127, 4, 70, "Input",
 CellID->28284],
Cell[85062, 2660, 187, 6, 36, "Output",
 CellID->477632282]
}, Open  ]],
Cell[85264, 2669, 121, 3, 70, "ExampleDelimiter",
 CellID->13255],
Cell[85388, 2674, 107, 3, 70, "ExampleText",
 CellID->5540],
Cell[CellGroupData[{
Cell[85520, 2681, 465, 15, 70, "Input",
 CellID->5618],
Cell[85988, 2698, 161, 5, 36, "Output",
 CellID->871777717]
}, Open  ]],
Cell[CellGroupData[{
Cell[86186, 2708, 403, 14, 70, "Input",
 CellID->5826],
Cell[86592, 2724, 162, 5, 36, "Output",
 CellID->533204985]
}, Open  ]],
Cell[86769, 2732, 121, 3, 70, "ExampleDelimiter",
 CellID->20509],
Cell[86893, 2737, 93, 1, 70, "ExampleText",
 CellID->3045],
Cell[CellGroupData[{
Cell[87011, 2742, 282, 10, 70, "Input",
 CellID->9542],
Cell[87296, 2754, 796, 20, 54, "Output",
 CellID->167894786]
}, Open  ]],
Cell[CellGroupData[{
Cell[88129, 2779, 362, 13, 70, "Input",
 CellID->32473],
Cell[88494, 2794, 377, 12, 36, "Output",
 CellID->169221044]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[88920, 2812, 224, 7, 70, "ExampleSection",
 CellID->21778],
Cell[89147, 2821, 67, 1, 70, "ExampleText",
 CellID->19233],
Cell[CellGroupData[{
Cell[89239, 2826, 187, 6, 70, "Input",
 CellID->21293],
Cell[89429, 2834, 1239, 21, 88, "Output",
 CellID->118212007]
}, Open  ]],
Cell[CellGroupData[{
Cell[90705, 2860, 231, 8, 70, "Input",
 CellID->9076],
Cell[90939, 2870, 1310, 30, 140, "Output",
 CellID->406856180]
}, Open  ]],
Cell[92264, 2903, 120, 3, 70, "ExampleDelimiter",
 CellID->2486],
Cell[92387, 2908, 220, 8, 70, "ExampleText",
 CellID->18625],
Cell[CellGroupData[{
Cell[92632, 2920, 310, 10, 70, "Input",
 CellID->2159],
Cell[92945, 2932, 1468, 33, 168, "Output",
 CellID->98062694]
}, Open  ]],
Cell[94428, 2968, 121, 3, 70, "ExampleDelimiter",
 CellID->28472],
Cell[94552, 2973, 334, 12, 70, "ExampleText",
 CellID->9361],
Cell[CellGroupData[{
Cell[94911, 2989, 167, 5, 70, "Input",
 CellID->120914192],
Cell[95081, 2996, 333, 10, 36, "Output",
 CellID->50752983]
}, Open  ]],
Cell[95429, 3009, 121, 3, 70, "ExampleDelimiter",
 CellID->26924],
Cell[95553, 3014, 230, 8, 70, "ExampleText",
 CellID->7529],
Cell[CellGroupData[{
Cell[95808, 3026, 685, 23, 70, "Input",
 CellID->469119703],
Cell[96496, 3051, 209212, 3642, 70, "Output",
 CellID->194132102]
}, Open  ]],
Cell[305723, 6696, 121, 3, 70, "ExampleDelimiter",
 CellID->20579],
Cell[305847, 6701, 215, 7, 70, "ExampleText",
 CellID->4724],
Cell[CellGroupData[{
Cell[306087, 6712, 303, 10, 70, "Input",
 CellID->495123516],
Cell[306393, 6724, 4449, 77, 70, "Output",
 Evaluatable->False,
 CellID->90139077]
}, Open  ]],
Cell[310857, 6804, 121, 3, 70, "ExampleDelimiter",
 CellID->24945],
Cell[310981, 6809, 179, 4, 70, "ExampleText",
 CellID->11737],
Cell[CellGroupData[{
Cell[311185, 6817, 638, 20, 70, "Input",
 CellID->8372],
Cell[311826, 6839, 3046, 54, 70, "Output",
 Evaluatable->False,
 CellID->655462058]
}, Open  ]],
Cell[314887, 6896, 120, 3, 70, "ExampleDelimiter",
 CellID->5333],
Cell[315010, 6901, 133, 4, 70, "ExampleText",
 CellID->5261719],
Cell[CellGroupData[{
Cell[315168, 6909, 264, 9, 70, "Input",
 CellID->973853290],
Cell[315435, 6920, 158, 5, 36, "Output",
 CellID->314545327]
}, Open  ]],
Cell[CellGroupData[{
Cell[315630, 6930, 261, 9, 70, "Input",
 CellID->24038],
Cell[315894, 6941, 180, 6, 51, "Output",
 CellID->342366950]
}, Open  ]],
Cell[316089, 6950, 121, 3, 70, "ExampleDelimiter",
 CellID->22775],
Cell[CellGroupData[{
Cell[316235, 6957, 425, 14, 70, "Input",
 CellID->17250],
Cell[316663, 6973, 1001, 22, 246, "Output",
 CellID->27407382]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[317725, 7002, 310, 9, 70, "SeeAlsoSection",
 CellID->7807],
Cell[318038, 7013, 694, 26, 70, "SeeAlso",
 CellID->26740]
}, Open  ]],
Cell[CellGroupData[{
Cell[318769, 7044, 314, 9, 70, "TutorialsSection",
 CellID->11533],
Cell[319086, 7055, 155, 3, 70, "Tutorials",
 CellID->3948]
}, Open  ]],
Cell[CellGroupData[{
Cell[319278, 7063, 321, 9, 70, "RelatedLinksSection",
 CellID->19167],
Cell[319602, 7074, 251, 5, 70, "RelatedLinks"],
Cell[319856, 7081, 186, 4, 70, "RelatedLinks"],
Cell[320045, 7087, 198, 4, 70, "RelatedLinks"],
Cell[320246, 7093, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[320670, 7111, 319, 9, 70, "MoreAboutSection",
 CellID->420736337],
Cell[320992, 7122, 151, 3, 70, "MoreAbout",
 CellID->357329222],
Cell[321146, 7127, 143, 3, 70, "MoreAbout",
 CellID->1240821],
Cell[321292, 7132, 153, 3, 70, "MoreAbout",
 CellID->1500429],
Cell[321448, 7137, 165, 3, 70, "MoreAbout",
 CellID->102297198]
}, Open  ]],
Cell[321628, 7143, 27, 0, 70, "History"],
Cell[321658, 7145, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

