(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18162,        637]
NotebookOptionsPosition[     14649,        522]
NotebookOutlinePosition[     16034,        561]
CellTagsIndexPosition[     15949,        556]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"],
           "FrameMargins" :> 
          Documentation`HelpLookup["paclet:ref/FrameMargins"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ImageSize\"\>", 
       2->"\<\"FrameMargins\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FieldSize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FieldSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FieldSize"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["InputField",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["PopupMenu",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
     " and related functions, which specifies the size of the field allowed \
for input or contents. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["FieldSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FieldSize"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->9931],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Tiny",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Small",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Small"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Medium",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Large",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Large"]], "InlineFormula"],
     " "
    }], "TableText"], Cell["predefined sizes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["w", "TI"], Cell[TextData[{
     "fixed width ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " and at least one line high "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["w", "TI"], ",", 
      StyleBox["h", "TI"]}], "}"}], Cell[TextData[{
     "fixed width ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " and fixed height ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["max", "TI"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "width between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["h", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["h", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "}"}], Cell[TextData[{
     "height between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["h", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["h", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->8397],

Cell[TextData[{
 "The width for ",
 Cell[BoxData[
  ButtonBox["FieldSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FieldSize"]], "InlineFormula"],
 " is measured in ems; the height in line heights. "
}], "Notes",
 CellID->22197]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->675304936],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->415553428],

Cell[TextData[{
 "Use predefined sizes for ",
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->799097898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"InputField", "[", 
    RowBox[{"Null", ",", 
     RowBox[{"FieldSize", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141831463],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = Null}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      FieldSize->Tiny],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], FieldSize -> Tiny]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = Null}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      FieldSize->Small],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], FieldSize -> Small]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = Null}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      FieldSize->Medium],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], FieldSize -> Medium]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = Null}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      FieldSize->Large],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], FieldSize -> Large]& ]}], "}"}]], "Output",
 ImageSize->{522, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54550471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75643348],

Cell["Use a custom size:", "ExampleText",
 CellID->27430812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputField", "[", 
  RowBox[{"123", ",", "Number", ",", 
   RowBox[{"FieldSize", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2001732475],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`i$$ = 123}, 
   InputFieldBox[Dynamic[Typeset`i$$], Number,
    FieldSize->2],
   DynamicModuleValues:>{}],
  InputField[
   Setting[#], Number, FieldSize -> 2]& ]], "Output",
 ImageSize->{39, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1960087954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1468156826],

Cell[TextData[{
 "Use predefined sizes for ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->724670552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Range", "[", "5", "]"}], ",", 
     RowBox[{"FieldSize", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1158205327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[1, {1->"1", 2->"2", 3->"3", 4->"4", 5->"5"},
    FieldSize->Tiny], ",", 
   PopupMenuBox[1, {1->"1", 2->"2", 3->"3", 4->"4", 5->"5"},
    FieldSize->Small], ",", 
   PopupMenuBox[1, {1->"1", 2->"2", 3->"3", 4->"4", 5->"5"},
    FieldSize->Medium], ",", 
   PopupMenuBox[1, {1->"1", 2->"2", 3->"3", 4->"4", 5->"5"},
    FieldSize->Large]}], "}"}]], "Output",
 ImageSize->{490, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1995468821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->905911866],

Cell["Use a custom size:", "ExampleText",
 CellID->1674632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{"1", ",", 
   RowBox[{"Range", "[", "5", "]"}], ",", 
   RowBox[{"FieldSize", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228252613],

Cell[BoxData[
 PopupMenuBox[1, {1->"1", 2->"2", 3->"3", 4->"4", 5->"5"},
  FieldSize->2]], "Output",
 ImageSize->{50, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129104532]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1765],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameMargins"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7221]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19686],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FieldSize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 23.4362572}", "context" -> "System`", 
    "keywords" -> {
     "controls content area", "field area", "popupmenu field size", 
      "inputfield field size"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FieldSize is an option for InputField, PopupMenu and related functions, \
which specifies the size of the field allowed for input or contents. ", 
    "synonyms" -> {"field size"}, "title" -> "FieldSize", "type" -> "Symbol", 
    "uri" -> "ref/FieldSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8266, 269, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->675304936]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15806, 549}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1264, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1887, 59, 1574, 37, 70, "ObjectNameGrid"],
Cell[3464, 98, 793, 24, 70, "Usage",
 CellID->29288]
}, Open  ]],
Cell[CellGroupData[{
Cell[4294, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4772, 144, 201, 8, 70, "Notes",
 CellID->9931],
Cell[4976, 154, 3013, 100, 70, "2ColumnTableMod",
 CellID->8397],
Cell[7992, 256, 237, 8, 70, "Notes",
 CellID->22197]
}, Closed]],
Cell[CellGroupData[{
Cell[8266, 269, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->675304936],
Cell[CellGroupData[{
Cell[8651, 283, 148, 5, 70, "ExampleSection",
 CellID->415553428],
Cell[8802, 290, 212, 8, 70, "ExampleText",
 CellID->799097898],
Cell[CellGroupData[{
Cell[9039, 302, 373, 12, 28, "Input",
 CellID->141831463],
Cell[9415, 316, 1043, 35, 95, "Output",
 CellID->54550471]
}, Open  ]],
Cell[10473, 354, 124, 3, 70, "ExampleDelimiter",
 CellID->75643348],
Cell[10600, 359, 60, 1, 70, "ExampleText",
 CellID->27430812],
Cell[CellGroupData[{
Cell[10685, 364, 185, 5, 70, "Input",
 CellID->2001732475],
Cell[10873, 371, 357, 12, 70, "Output",
 CellID->1960087954]
}, Open  ]],
Cell[11245, 386, 126, 3, 70, "ExampleDelimiter",
 CellID->1468156826],
Cell[11374, 391, 210, 8, 70, "ExampleText",
 CellID->724670552],
Cell[CellGroupData[{
Cell[11609, 403, 415, 13, 70, "Input",
 CellID->1158205327],
Cell[12027, 418, 545, 15, 70, "Output",
 CellID->1995468821]
}, Open  ]],
Cell[12587, 436, 125, 3, 70, "ExampleDelimiter",
 CellID->905911866],
Cell[12715, 441, 59, 1, 70, "ExampleText",
 CellID->1674632],
Cell[CellGroupData[{
Cell[12799, 446, 209, 6, 70, "Input",
 CellID->228252613],
Cell[13011, 454, 230, 7, 70, "Output",
 CellID->129104532]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13302, 468, 310, 9, 70, "SeeAlsoSection",
 CellID->1765],
Cell[13615, 479, 460, 17, 70, "SeeAlso",
 CellID->7221]
}, Open  ]],
Cell[CellGroupData[{
Cell[14112, 501, 314, 9, 70, "TutorialsSection",
 CellID->19686],
Cell[14429, 512, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[14592, 518, 27, 0, 70, "History"],
Cell[14622, 520, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

