(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32364,       1062]
NotebookOptionsPosition[     26986,        895]
NotebookOutlinePosition[     28971,        942]
CellTagsIndexPosition[     28886,        937]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SystemDialogInput" :> 
          Documentation`HelpLookup["paclet:ref/SystemDialogInput"], 
          "FileNames" :> Documentation`HelpLookup["paclet:ref/FileNames"], 
          "Get" :> Documentation`HelpLookup["paclet:ref/Get"], "InputField" :> 
          Documentation`HelpLookup["paclet:ref/InputField"], "$HomeDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$HomeDirectory"], 
          "$UserDocumentsDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$UserDocumentsDirectory"], 
          "Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "ActionMenu" :> Documentation`HelpLookup["paclet:ref/ActionMenu"], 
          "Hyperlink" :> Documentation`HelpLookup["paclet:ref/Hyperlink"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"SystemDialogInput\"\>", 
       2->"\<\"FileNames\"\>", 3->"\<\"Get\"\>", 4->"\<\"InputField\"\>", 
       5->"\<\"$HomeDirectory\"\>", 6->"\<\"$UserDocumentsDirectory\"\>", 
       7->"\<\"Button\"\>", 8->"\<\"ActionMenu\"\>", 
       9->"\<\"Hyperlink\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedInput"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Creating Inspectors\"\>", 3->"\<\"Generalized Input\"\>", 
       4->"\<\"Palettes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FileNameSetter", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileNameSetter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileNameSetter"], "[", 
       StyleBox["name", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a file name setter which displays as a ",
     StyleBox["Browse", "MenuName"],
     " button and when clicked brings up a system file opening dialog, \
starting from the location corresponding to ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileNameSetter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileNameSetter"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["name", "TI"], "]"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses the dynamically updated current value of ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " being reset if a different file is chosen."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileNameSetter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileNameSetter"], "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", "\"\<Save\>\""}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]brings up a file saving dialog."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FileNameSetter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FileNameSetter"], "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"spec\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"type\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "->", 
           RowBox[{"{", 
            RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"patt\", \"TI\"], 
StyleBox[\"11\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"patt\", \"TI\"], 
StyleBox[\"12\", \"TR\"]]\)\>\"", ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
          RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"type\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", "->", 
           RowBox[{"{", 
            StyleBox["\[Ellipsis]", "TR"], "}"}]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]looks for files of types ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["type", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " with names matching the file patterns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["ij", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->5186]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"spec\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 "possible specifications of dialogs to use are:"
}], "Notes",
 CellID->28530],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Open\>\"", 
    RowBox[{Cell["file opening dialog (default)", "TableText"], " "}]},
   {Cell["      ", "TableRowIcon"], "\"\<OpenList\>\"", Cell[
    "multiple file opening dialog", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Save\>\"", Cell[
    "file saving dialog", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Directory\>\"", Cell[
    "directory picking dialog", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->15193],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"spec\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is normally a single complete file name string."
}], "Notes",
 CellID->11311],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<OpenList\>\""}], "]"}]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is always a list of file name strings."
}], "Notes",
 CellID->21817],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<Save\>\""}], "]"}]], "InlineFormula"],
 " generates a warning if the file picked already exists."
}], "Notes",
 CellID->15339],

Cell[TextData[{
 "If the file browser dialog is closed without choosing a file name, ",
 Cell[BoxData[
  ButtonBox["FileNameSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNameSetter"]], "InlineFormula"],
 " leaves ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " unchanged. "
}], "Notes",
 CellID->9492],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"], "[", 
   RowBox[{"\"\<\>\"", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " uses no initial file name."
}], "Notes",
 CellID->2512],

Cell[TextData[{
 "If no name is given that determines a valid directory, ",
 Cell[BoxData[
  ButtonBox["FileNameSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNameSetter"]], "InlineFormula"],
 " uses as a default ",
 Cell[BoxData[
  ButtonBox["$UserDocumentsDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserDocumentsDirectory"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21282],

Cell["\<\
If no file type specification is given, the file browser dialog will list \
files of all types.\
\>", "Notes",
 CellID->18441],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["type", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " give the names of filters to be listed in the file browser, and to be used \
for picking out files whose names match the file patterns specified."
}], "Notes",
 CellID->4212],

Cell["The following options can be given: ", "Notes",
 CellID->13506],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the setter", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the appearance of the file name setter", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the setter is enabled, or grayed out", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the displayed setter", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the displayed setter", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WindowTitle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WindowTitle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the title of the browser window ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->13911],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\""}]], "InlineFormula"],
 ", the string ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\""], "InlineFormula"],
 " will be used in place of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\(Browse\*
StyleBox[\"\[Ellipsis]\", \"TR\"]\)]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->28810],

Cell[TextData[{
 "Other expressions given as settings for ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " are used literally as the appearance of the unclicked ",
 Cell[BoxData[
  ButtonBox["FileNameSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNameSetter"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9678],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FileNameSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNameSetter"]], "InlineFormula"],
 " is intended primarily for use with local kernels. "
}], "Notes",
 CellID->14422],

Cell[TextData[{
 "Filenames in ",
 Cell[BoxData[
  ButtonBox["FileNameSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNameSetter"]], "InlineFormula"],
 " use the pathname separator appropriate for your computer system."
}], "Notes",
 CellID->4084],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"], "[", 
   RowBox[{"\"\<\>\"", ",", "\"\<Open\>\""}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10477],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Setting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setting"]], "InlineFormula"],
 " can be used to find the file name specified by ",
 Cell[BoxData[
  ButtonBox["FileNameSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNameSetter"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22074],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<FileNameSetter\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->298304544],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->35281542],

Cell["Assign the full path of a file to a variable:", "ExampleText",
 CellID->1477453614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FileNameSetter", "[", 
    RowBox[{"Dynamic", "[", "f", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "f", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366823782],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox["\<\"Browse\[Ellipsis]\"\>",
     Appearance->"DialogBox",
     ButtonData->"paclet:ref/Browse\[Ellipsis]",
     ButtonFrame->"DialogBox",
     ButtonFunction:>
      DynamicDump`fnsButtonFunction[$CellContext`f, "Open", Automatic, 
       Automatic],
     Enabled->Automatic,
     Evaluator->Automatic,
     ImageMargins->0,
     ImageSize->Automatic,
     Method->"Queued"],
    FileNameSetter[
     Dynamic[$CellContext`f], "Open", Automatic]], ",", 
   DynamicBox[ToBoxes[$CellContext`f, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{91, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->635220386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1008645826],

Cell["Assign the full path of multiple files to a variable:", "ExampleText",
 CellID->74488164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FileNameSetter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "f", "]"}], ",", "\"\<OpenList\>\""}], "]"}], 
   ",", 
   RowBox[{"Dynamic", "[", "f", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1981249082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox["\<\"Browse\[Ellipsis]\"\>",
     Appearance->"DialogBox",
     ButtonData->"paclet:ref/Browse\[Ellipsis]",
     ButtonFrame->"DialogBox",
     ButtonFunction:>
      DynamicDump`fnsButtonFunction[$CellContext`f, "OpenList", Automatic, 
       Automatic],
     Enabled->Automatic,
     Evaluator->Automatic,
     ImageMargins->0,
     ImageSize->Automatic,
     Method->"Queued"],
    FileNameSetter[
     Dynamic[$CellContext`f], "OpenList", Automatic]], ",", 
   DynamicBox[ToBoxes[$CellContext`f, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{91, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2119374439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2087089794],

Cell["\<\
Assign the full path of a new file without actually creating it:\
\>", "ExampleText",
 CellID->720277660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FileNameSetter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "f", "]"}], ",", "\"\<Save\>\""}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "f", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14943484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox["\<\"Browse\[Ellipsis]\"\>",
     Appearance->"DialogBox",
     ButtonData->"paclet:ref/Browse\[Ellipsis]",
     ButtonFrame->"DialogBox",
     ButtonFunction:>
      DynamicDump`fnsButtonFunction[$CellContext`f, "Save", Automatic, 
       Automatic],
     Enabled->Automatic,
     Evaluator->Automatic,
     ImageMargins->0,
     ImageSize->Automatic,
     Method->"Queued"],
    FileNameSetter[
     Dynamic[$CellContext`f], "Save", Automatic]], ",", 
   DynamicBox[ToBoxes[$CellContext`f, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{91, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1787807612]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->341313481],

Cell["Assign the full path of a directory to a variable:", "ExampleText",
 CellID->526854030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FileNameSetter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "f", "]"}], ",", "\"\<Directory\>\""}], "]"}], 
   ",", 
   RowBox[{"Dynamic", "[", "f", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2047032536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox["\<\"Browse\[Ellipsis]\"\>",
     Appearance->"DialogBox",
     ButtonData->"paclet:ref/Browse\[Ellipsis]",
     ButtonFrame->"DialogBox",
     ButtonFunction:>
      DynamicDump`fnsButtonFunction[$CellContext`f, "Directory", Automatic, 
       Automatic],
     Enabled->Automatic,
     Evaluator->Automatic,
     ImageMargins->0,
     ImageSize->Automatic,
     Method->"Queued"],
    FileNameSetter[
     Dynamic[$CellContext`f], "Directory", Automatic]], ",", 
   DynamicBox[ToBoxes[$CellContext`f, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{91, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1949906462]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11818],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$HomeDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$HomeDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserDocumentsDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$UserDocumentsDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ActionMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ActionMenu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hyperlink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hyperlink"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7500]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7830],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->323175321]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->807712551],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->755450381],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->270447190],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedInput"]], "MoreAbout",
 CellID->619376016],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->10720596]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FileNameSetter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 29.0145250}", "context" -> "System`", 
    "keywords" -> {
     "file browser", "file chooser", "file dialog", "file name input", 
      "file picker", "file-selection dialog", "file setter", "file selector"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FileNameSetter[name] represents a file name setter which displays as a \
Browse button and when clicked brings up a system file opening dialog, \
starting from the location corresponding to name. \
FileNameSetter[Dynamic[name]] uses the dynamically updated current value of \
name, with the value of name being reset if a different file is chosen. \
FileNameSetter[name, \"Save\"] brings up a file saving dialog. \
FileNameSetter[name, \" spec\", {\"SubscriptBox[ type, 1]\" -> \
{\"SubscriptBox[ patt, 11]\", \"SubscriptBox[ patt, 12]\", ...}, \
\"SubscriptBox[ type, 2]\" -> {...}, ...}] looks for files of types type_i \
with names matching the file patterns patt_ij. ", 
    "synonyms" -> {"file name setter"}, "title" -> "FileNameSetter", "type" -> 
    "Symbol", "uri" -> "ref/FileNameSetter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17277, 533, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->298304544]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28742, 930}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2996, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3619, 91, 1579, 37, 70, "ObjectNameGrid"],
Cell[5201, 130, 3125, 90, 70, "Usage",
 CellID->5186]
}, Open  ]],
Cell[CellGroupData[{
Cell[8363, 225, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8841, 242, 354, 12, 70, "Notes",
 CellID->28530],
Cell[9198, 256, 729, 15, 70, "2ColumnTableMod",
 CellID->15193],
Cell[9930, 273, 423, 15, 70, "Notes",
 CellID->11311],
Cell[10356, 290, 390, 15, 70, "Notes",
 CellID->21817],
Cell[10749, 307, 324, 10, 70, "Notes",
 CellID->15339],
Cell[11076, 319, 335, 11, 70, "Notes",
 CellID->9492],
Cell[11414, 332, 298, 10, 70, "Notes",
 CellID->2512],
Cell[11715, 344, 413, 13, 70, "Notes",
 CellID->21282],
Cell[12131, 359, 136, 4, 70, "Notes",
 CellID->18441],
Cell[12270, 365, 305, 9, 70, "Notes",
 CellID->4212],
Cell[12578, 376, 69, 1, 70, "Notes",
 CellID->13506],
Cell[12650, 379, 2034, 53, 70, "3ColumnTableMod",
 CellID->13911],
Cell[14687, 434, 502, 17, 70, "Notes",
 CellID->28810],
Cell[15192, 453, 408, 13, 70, "Notes",
 CellID->9678],
Cell[15603, 468, 230, 7, 70, "Notes",
 CellID->14422],
Cell[15836, 477, 261, 8, 70, "Notes",
 CellID->4084],
Cell[16100, 487, 433, 15, 70, "Notes",
 CellID->10477],
Cell[16536, 504, 350, 12, 70, "Notes",
 CellID->22074],
Cell[16889, 518, 351, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[17277, 533, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->298304544],
Cell[CellGroupData[{
Cell[17662, 547, 147, 5, 70, "ExampleSection",
 CellID->35281542],
Cell[17812, 554, 89, 1, 70, "ExampleText",
 CellID->1477453614],
Cell[CellGroupData[{
Cell[17926, 559, 228, 7, 28, "Input",
 CellID->366823782],
Cell[18157, 568, 769, 24, 46, "Output",
 CellID->635220386]
}, Open  ]],
Cell[18941, 595, 126, 3, 70, "ExampleDelimiter",
 CellID->1008645826],
Cell[19070, 600, 95, 1, 70, "ExampleText",
 CellID->74488164],
Cell[CellGroupData[{
Cell[19190, 605, 274, 9, 70, "Input",
 CellID->1981249082],
Cell[19467, 616, 778, 24, 70, "Output",
 CellID->2119374439]
}, Open  ]],
Cell[20260, 643, 126, 3, 70, "ExampleDelimiter",
 CellID->2087089794],
Cell[20389, 648, 115, 3, 70, "ExampleText",
 CellID->720277660],
Cell[CellGroupData[{
Cell[20529, 655, 264, 8, 70, "Input",
 CellID->14943484],
Cell[20796, 665, 770, 24, 70, "Output",
 CellID->1787807612]
}, Open  ]],
Cell[21581, 692, 125, 3, 70, "ExampleDelimiter",
 CellID->341313481],
Cell[21709, 697, 93, 1, 70, "ExampleText",
 CellID->526854030],
Cell[CellGroupData[{
Cell[21827, 702, 275, 9, 70, "Input",
 CellID->2047032536],
Cell[22105, 713, 780, 24, 70, "Output",
 CellID->1949906462]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22946, 744, 311, 9, 70, "SeeAlsoSection",
 CellID->11818],
Cell[23260, 755, 2223, 80, 70, "SeeAlso",
 CellID->7500]
}, Open  ]],
Cell[CellGroupData[{
Cell[25520, 840, 313, 9, 70, "TutorialsSection",
 CellID->7830],
Cell[25836, 851, 148, 3, 70, "Tutorials",
 CellID->323175321]
}, Open  ]],
Cell[CellGroupData[{
Cell[26021, 859, 319, 9, 70, "MoreAboutSection",
 CellID->807712551],
Cell[26343, 870, 141, 3, 70, "MoreAbout",
 CellID->755450381],
Cell[26487, 875, 149, 3, 70, "MoreAbout",
 CellID->270447190],
Cell[26639, 880, 145, 3, 70, "MoreAbout",
 CellID->619376016],
Cell[26787, 885, 127, 3, 70, "MoreAbout",
 CellID->10720596]
}, Open  ]],
Cell[26929, 891, 27, 0, 70, "History"],
Cell[26959, 893, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

