(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    198544,       4434]
NotebookOptionsPosition[    187429,       4056]
NotebookOutlinePosition[    189116,       4099]
CellTagsIndexPosition[    189029,       4094]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Joined" :> Documentation`HelpLookup["paclet:ref/Joined"], 
          "FillingStyle" :> 
          Documentation`HelpLookup["paclet:ref/FillingStyle"], 
          "ClippingStyle" :> 
          Documentation`HelpLookup["paclet:ref/ClippingStyle"], 
          "RegionFunction" :> 
          Documentation`HelpLookup["paclet:ref/RegionFunction"], 
          "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Joined\"\>", 
       2->"\<\"FillingStyle\"\>", 3->"\<\"ClippingStyle\"\>", 
       4->"\<\"RegionFunction\"\>", 
       5->"\<\"ColorFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"Function Visualization\"\>", 
       3->"\<\"Graphics Options & Styling\"\>", 4->"\<\"Plotting Options\"\>",
        5->"\<\"New in 6.0: Function Visualization\"\>", 
       6->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       7->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Filling", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Filling",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Filling"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ListPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Plot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Plot3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
     " and related functions which specifies what filling to add under \
points, curves and surfaces. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used: ", "Notes",
 CellID->8112],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no filling (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axis",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axis"], Cell["fill to the axis", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"], Cell[
    "fill to the bottom of the plot ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "fill to the top of the plot ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["v", "TI"], Cell[TextData[{
     "fill to value ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["m", "TI"], "}"}], Cell[TextData[{
     "fill to the ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " object "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["p", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["p", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "fill from object ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["i", "k"], TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["p", "k"], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "->", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["p", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["1", "TR"]]}], "}"}]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "use directive ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", "k"], TraditionalForm]], "InlineMath"],
     " for the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " filling "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], "->", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["p", "TI"], 
         StyleBox["1", "TR"]], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox[
            RowBox[{"1", "-"}], "TR"]], ",", 
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox[
            RowBox[{"1", "+"}], "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", 
        RowBox[{"1", "-"}]], TraditionalForm]], "InlineMath"],
     " below and ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", 
        RowBox[{"1", "+"}]], TraditionalForm]], "InlineMath"],
     " above "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->3485],

Cell[TextData[{
 "For 2D graphics, filling is done in the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " direction. "
}], "Notes",
 CellID->3817],

Cell[TextData[{
 "For 3D graphics, filling is done in the ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " direction, and on the bounding ",
 Cell[BoxData[
  StyleBox["xy", "TI"]], "InlineFormula"],
 " plane. "
}], "Notes",
 CellID->6398],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ", filling effectively draws a \[OpenCurlyDoubleQuote]stem",
 "\[CloseCurlyDoubleQuote]",
 " to every point. "
}], "Notes",
 CellID->17216],

Cell[TextData[{
 "For multiple curves, surfaces or lists of points, ",
 Cell[BoxData[
  RowBox[{"Filling", "->", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"Filling", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "->", 
      StyleBox["p", "TI"]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{
       StyleBox["p", "TI"], 
       StyleBox["\[Ellipsis]", "TR"]}]}]}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21411],

Cell[TextData[{
 "In filling between lists of points that do not line up, the",
 " \[OpenCurlyDoubleQuote]stems\[CloseCurlyDoubleQuote]",
 " start at points in the first list, and extend to positions that linearly \
interpolate between points in the second list. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->12070,
  ButtonNote->"12070"]
}], "Notes",
 CellID->31472],

Cell[TextData[{
 "By default, the style specified by the setting for ",
 Cell[BoxData[
  ButtonBox["FillingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FillingStyle"]], "InlineFormula"],
 " is used for all filling. "
}], "Notes",
 CellID->10713],

Cell[TextData[{
 "Settings of the form ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["i", "TI"], 
    StyleBox["k", "TI"]], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["k", "TI"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["k", "TI"]]}], "}"}]}]], "InlineFormula"],
 " can be used to override the default in particular cases. "
}], "Notes",
 CellID->25632],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["i", "TI"], 
    StyleBox["k", "TI"]], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["k", "TI"]], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["g", "TI"], 
        RowBox[{
         StyleBox["k", "TI"], "\[InvisibleSpace]", 
         StyleBox["-", "TR"]}]], ",", 
       SubscriptBox[
        StyleBox["g", "TI"], 
        RowBox[{
         StyleBox["k", "TI"], "\[InvisibleSpace]", 
         StyleBox["+", "TR"]}]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies that style ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   RowBox[{
    StyleBox["k", "TI"], "\[InvisibleSpace]", 
    StyleBox["-", "TR"]}]]], "InlineFormula"],
 " should be used when ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " lies below ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["p", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   RowBox[{
    StyleBox["k", "TI"], "\[InvisibleSpace]", 
    StyleBox["+", "TR"]}]]], "InlineFormula"],
 " when it lies above. "
}], "Notes",
 CellID->32751],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   RowBox[{
    StyleBox["k", "TI"], "\[InvisibleSpace]", 
    StyleBox["-", "TR"]}]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   RowBox[{
    StyleBox["k", "TI"], "\[InvisibleSpace]", 
    StyleBox["+", "TR"]}]]], "InlineFormula"],
 " can be composite directives specified with ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11657]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30889655],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->419312915],

Cell["Fill to different levels:", "ExampleText",
 CellID->511379531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Bottom", ",", "Axis", ",", "0.3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->526222223],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210274536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65844213],

Cell["Fill multiple curves:", "ExampleText",
 CellID->689609686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->476617387],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytW3lUVFeav6EW9sUkM52cnpnT//Xfc+aPmZ5uk5lMOiZRW2MHYwKKCiig
QQkoCrgQFBdQUEBZq6i9CoqiiqUKqAJKdkpWKRCVqGi7MNHjGe30GWdyDvPd
e9+rWzwezCRnOI9X79bjve/3fffb72XjroykxK93ZSTH7/rVum92HUxKjk//
1UcHvoGvJG8ghFrgN+kdBNeLcEV+f7G4uIgk+Ir8oEp8QvjbAPhyIx5Jnz//
YXzsERxw8anvvv9T5FtJb8+95CTrZ5s0KCAxwYIkcPVFtN5hn0Ufiz71Mf/2
Qxn2A6nN8IfSW7PfI+lA//zRzLbtMaY7t599JPrkOjKen38B9CxmLwrCz0mu
ue/CuNM1h34v+hR5lwReuivODDRQCHnKO7WQkd6KUQaT+3OuMddJtT46DwVU
rE1DkubUshFF24v5BfQPom8ltCRPnrwE2tc9D1E4eSswAK/Et2Tk9NR737y7
sDW9fFztmu+fRgHfzz5EshnbQE9BHdDqLax//eov6O+XSJ+++fXrH+HNro45
FMHjBWENDz1AUnL/Rp3bHHd+rmMUBeF3SoYrWkwxZx6N3aH8BD5buD3Sr2i3
ZjWbUu0NGXD96MEY+pUoLx+S8Zl8t1IxgolFEorjY48BAUgbBZD77nxDZ64W
EwshFB96blkSLs7ah5Ec3w+9d6fHpIgxKmJ6OgomrxtmJm3eUTNcWzQJmqub
pies6O9Eqf8bGcP8wXxgwmvwSQazGr/bDFIAsjARKILQbMushgF+gGCS/vDn
58AcsHj3tjvw+6ezSPrwnsfZlANAnj72BlJ9efGn8mF9kjUbSdZWbEWSaP2+
k65i+2w3ChPF8wEZg36CFoMM0FtEGldKB6/uLAUpoyiMRE5hwZ+CoK26JGA1
FNOXABBgeNZrp/MkA+pZ7QXR+v1FfTWYpmT2+++QrH9+RD3emNl2bpNmT92N
VhSyCpLcky6tehyDoEicRbbcjYVO8xhag5FIQSYDdSpzbdz8d/3hBMPCo6m2
xszhnnJu5hQjdQDAMNmMgjF1qefhRG7npRhT2u1n94KW6B6lCFqWkmz1UZQN
20b0sefdltGvonX3x+5RCUimrzmUJ6O9zg4YY8n3dRa12fNSm3MLeirCMR2J
++4giN063YECRfn7VzKGaQY1x4TexCf5lOe+LubskMUz2j5Vfr7zRGZrJLGa
ueFei3LvjQ6HOf7M/NR1FEl4vXN/ZJsqvsycgSIJzamFWznOC8Ax1UpCGXMm
8aON8Bh+ZQI8/8L7M7A0Ju/65JKuKw4AgwLwSbLjS32//QaGFIZPgXdHho0V
MTf7O+4M94zUWS1JBQsPpxGZCdnM3aGE+m8aRusarUc7ui6jKIIRBHR5oJYo
MEFDkEoZjqXIkAjS93kfATqKvQ9F6lZ0Nuy/QkCSU5NqKC7GgEGGkhlbmL5r
rNo+2Q1OGrAiSUdeZU+JDgOlugtokxsyHZM2FDB0qwtJTIaUHo8eQ6ayHXs0
zdGXUFzcB/4J8MH0Y4Ny5odbKspHfd2Nb3M7fRogAQ1QbT7psY0iGeHj6AGb
rqKPeZ5mbdqAvZywQE63+t3G2Ly5wT64z+nEDuOB5vEGJCF8DM50GFS7RuAS
8yFfQeaBAmyYOTx8T1TWjelVzos2DI9iBOv4fLP68dQ8Cqb+uF3ZokvH8GQE
47ilCfQWa0YQwfj4sTfVmq0b1iIZwdgzYdEpYr2PplDET8ToP35PVJ6D5mHj
zgsYZiDBmp9tLyvoIspLsM6Pj2uufHZrsAsFCvSC+FTJqY6Coq5SDFNOsLoG
akzaRKwS4atgla6q1fhyrahkwfh7VW6Gdrh1EiR7xzPHoTVX7x5xaTHQQMHs
ywnaOo8hrek4BhpE0DaY07r6qjHaMB9a3ivI/T6XI4NQDgGdybHf0GdKKMag
ggmyorz287kdxDkRZIP2SrshE4MKJsjAG8CcE+dIkE3M9W7TpfTddKJgXi81
VVsn7g/7IRP6yLUCH0mio+Tm1FOwEPCRKISXEbil6x3TQInE5kmvqnQjntFQ
gqTpm+IRow2DCOC1j7OQUIKkc0gFFoJlFLoECZYNRQB5IGR3TBadpa3W9BpM
PJQgUF2+dijVSogLbJQi8Lqc+i9yH383ySE45yoq6LyEiYcRBNRBYgQhK8ri
d2ScndVuMkyKySIcI5F/Fa0FQQAIOGb62+uq4iKIGbqLVc68KiDeN+OKNX6N
Ivg5ALsbm+tbhe5vF7mMYON6lZgEKF2fBOAANzveaYzEdKW6bbk3B67RMBAp
sJ/gFWm+AydsPH+DBzLf9yWXByAT4RAA58r1OdhPSgEBniuil1IqAaqNGAPx
zZJDx1NBXzGAKIFdSOGESZMLn0uXiOJ612+MBPjAkiH5xzmTUEIkHmF24BNf
IhREvgGZHUnTgbS8vXY6S3ALPjvdDXDRatSgNQRrv9cOlnIDMlgZAQw34RNf
IpLj4DLnDfy5RHN/KYJdSlizWaeP5zjFdEi6DCm19eMZKRZlHoZIcMopzp3a
VLhQbs4e9Loo0vZrZQ11B3ip/l+Q+iMUIsZaQGgt8oGVegKhfJejJvKVDLRc
qyj8Q1qKBkX59MDpNpuyLjQVV6I3CWK9evfAhJUE+P8HxO9ysicVV2yMUUzG
OGJKfNpqqtxv1xVt+6Oiy9JBZBsIt6JVextdWrjocNWDeHuvOzhNgDgJmjCD
XcjPQPvOspj0Sx9ealoML5OunMiSSZfEJVmv1a4q+bzX2lpZaD6YrEc+7Kca
80HGcAFn85lLltwSTtK2puPtzgsYa8DPwM5L9m/577moKZRuEOcLCEq5sSLJ
oSsBlHBQGYcRrwQWFl27h7N0DFei3JrT7Wz0+QepLzoBQPw+gtkv42P+Ad/9
zaJIFecXMaOIDDvrtfqr8QAFBeCThIqORQmwJ6WjAsOREkzWqxXGVOKzxKxL
3HP+ExkfyrBbzF6GhGUVFImm7CunSUFAkBOVDYvdpo7aRF0aBiEXSIciMWr3
9I3W81YjjuQfyfjJk5dbNmsYEo99QvdlvphMpAKZBBEkM0Pdm5Xx2BoCCZJW
g0odc5IhWWoRqyGB8r6woIchaUgt77zcIiYTmUAmNNO61FR0pP4EBhFEkGj3
nGo36hiSpfotQJJVve+4Jg0FnG7MQtJiV9GlrstwXOmtCsDFmmToAWQY03Cg
AHzCVTuH/dfkDaDsA/3zGHYUwT7ZP1e74ZiYFOUCKcppLtbXtkGxy9Fdh4IJ
drtZA1IEt81hZ7kYw/42nBWcbXKcBMGQyhAMrquiHWzOlqkcaZ0gtWEg+Nsu
s9FaewJEWVP8Mfyxq05DdT3YZNao6hRn9YU52rwY5b61FVu3KVIOa46Xm66g
AKNZTaQEn/hSJhhLxe4H+cZwpKTUnCvQUr9D9YQ6IHwpI2NHi4EGKiQlHMN9
+MSXpAIJ8o3hYHYGbyNKDheJKaaOEcg18AmPdxoyvTNPkIzMB4zhk1zyNZwm
+hT2R0LvSb1+fXVaq6YQC4YvG32awkWNANIVBDE7i2zwqoG6QVJpyYZa+1u1
F8D1asti2gxX6XzLQbQg1y01ieuqtu9XZ1aZKt4lMtOZ1J+sq2xuq0driBSo
Q2ZZkLpqKxSGfC6GJLE79BpbL2GRnBJM2cY+F4YSJogKawgfgKb28qZrFsty
PqjKIintprlngQlwQdQvS92WBtBX3dU4UJBAYnKOBjMox6fVcTHK/ef1hegX
BP+pfGVKihJDp/hrPjkMwRBDjxR4xBCCv6l7ZMcuPYYeQPBXdlsTTDkYQrhf
nABhojfJvNh1l8zVaSSJW4r+QmFvZcUwN7vTYw/BZ3VdcXB5BSg5TECj8hgK
Jo6rxlQZX5u2pTohX3/+rwju2O3V5VV6DDlK4MmFcscVB5IfyLCUKjsBMhzR
6q+dI+ORgghC8daWfPlNKmlXS5fEHySh5QlRGh5zfXKJu7KDyzVHHGM2VR7A
BolT1GCRe2szwApLTKVvEtQKtWr9J1VM2qqvjnfaG8SkHUb6eE7PxNZtGoBc
0FZ7xHaR86usY0R0RJKTfqW2LG4pZhL9IWH+ZJ3CO7Ug95Nyv76PyzlphgFm
gkIIXtDxL2qSDqizdObaKII384jiaJaaSZnFBqGUSUdOClK+pOzYUJt4/cZ3
FOtohxf0kvlRS81AYlzds4Xb/vrAZUy08grk/S9gxfZNsYJ0waQtiqMolPjf
U7qzoA7FhksokiD945ZKrcHEkOpSTrdpNGKSjaC9w4kb6zOPn2qp5roCrbkG
e54Bk4ok9GiNI9BbDiet24N4/gAnOGiuUm5WnzVVpmCIRKYSi1kPzjhdk4PC
Cc7yKtWWz6oZTuY1hRKlOD0PJ9aVJ5SU9nE4md+LEPQI5Mtw0swgWNC7ozjb
jVXgH3osNk6eJ3WnwS+o6mtQKMF5MK0mN0/DcNadKLIVlIvJk/TupDnOCzpP
C5ADbaNIIXo1HqjAxMI4j8T1dwGsXGBbcJGcZCWrJeTZpkxl+3kLQ0ujL0ML
/oCb/RCCdsP6SrOVzH4kQQtZfc3GozirF5WqrGOud7f5MFDVacfP5LvR24Qq
OAIwZ1/PQXowqcGq9tCK20+6rFqmCQ+HGTwfzAy2rlDehy3B3NxgilOm5unP
oiCC+WKxcscOBZOwpais/kjRihKWpzaf7LnnWSRlMHX9b/GWAh6XaWD1xe6s
9CasEQEr4Z6ffwFv4FaqWL4ojru7sWmf6vBRTS4KJLhZJhAlyFwjRTXYMNmc
1V6AAdDVAmH/m+kJ9f19tolo2o+TLMUv9+GHHyoByoEjv771hG4JBxD4MPgw
wsERzYlk1SGW57CYTTlo1ii1O79d2VdMLdyKM2fcfnaP6y+z3P8tgd7QjmLG
/sZ6xSDfq1qJg4ry4UtFfSG87hjjCnH0JrYicRiu1FelMg4K9Rd3Kw+CW4bC
AHNw5pxyzx4lmwOWKYvPQemg2n9FwK92fssve8A6JBd026TLrJXOIuvXhQj8
YBjvB8FZMw7KjGWg/ZgDmovGx1cXl+iZxYIfVKw/svIcgB+MMR58/sMLrpfK
qmnh2oSU75eDC8daJFs6B35VC+Vk43oVlLmMk/YCS3O22ue3JA2KQ82asz5O
5OB7KCcqnRqCucNlpnNgPFzYXFa98hzkdl6qu9FK1GCR9aVxBve2wOfR1ZXd
sUa3bYLv/lIOghZXXm0Srn1Q7miaxbhj+VkYH1ehhMd5bjifaQF3J/Kqv05V
Rfl86SeH+8fbV5gZ8KVJ1uzXP/4XQQdZhvcpaAaEAW5mmF8MEKwOyH18BfpF
LcqScIVKnDu2khgqWImg3HnsHshwusx6yh2OGx+d3l+h1HF2w7J1X7cWpg13
a+mKFJi99+ltTCpYUOES3uRgN6D1HtsopDUpCebHU/OBq/AkXAUQrq4E8HoB
Kom7nGGClSDKU3+TS1O6DVcERB+lzWrbhvhzibo0KD6pLUHo6xloYVw1O/Jb
7XlsxiqG9YW9VZhYKKFIQ6+PKynYsnrr6Z3bdDP9t4NW4Ue4WoTxS3zaydaV
Q/nMBSpq7CHCBRU1iTOy01nGsyfMFqeGsoLCBXm9b4aUVzbiTq3QL5DVdtxF
B8/mW+2Rgh5mxip0u4sWpu7/VF6WzxXrPwmrNcoTFI4NNYd82Z/88001vc2u
O8M9PrbCBHk/5aqp9VtH+1k2Q5lt5+yz3ZhkOO+vd8WZsU2RzqwMAiiE0QdD
N63Jlx6P0ZWrlThbvk4mtCUJr3e0WOAqOdbRorzRPipmK4jYUl2lNXabCjc/
AkgHhM1ciKBWoDz23mhSlX+G+0iUR9uMK7U5F5OO5G0Z2ML0SQcm0LfXBX4e
jd0xxpyZtXv8fAbvC/k1NuHqn1SghWGCbCec939gTU6TguPq6AHd1UIrW/tl
XAULIi3lymI55Lp21VcB4VwhWr//yct/R2t4jeG4CvfbZ4MzXTovL588tyYV
9xTUgX5KV4xUUoH2hQsiRjjfjQdvhz0D7VF1m1s2ra8ZcXVxa8SMF2Gnj/LS
7dHpFLFiWvgmP0OghdfcdzmLhisYY16o1o0o2lTrsztztXMdowHL8gaZqJYJ
6xm3pQFyN5x9ykT7bIwHueh8sL4pnQ+z15Fhz8ek3/azJLzGFcT7B8jC4neb
4Qbx8fLXr/6CNz/tLqxYm2ZJuOjON8hE50Qm0K9wQTYb4df/YN3XpF3quppW
1vPUttck69NZR1o4JyzaUn7GHntBv7C/+2sC4tWr15AKQcAALvBuLtIdk8Gc
fJvbCdUYJJkgcRRBsIIVgbr59GkFjpiWRQj8AOWoUZFlU51iPXaHrukPn9aw
znatvWK/MZMwI5ihcFEP7qtr6OoJ9uCAGmYESd5fW0GiU33dDfiW4l0BNdOr
CEHfIYK3c4g27cZKDjWNNhhwCFEuH2o46BxEito3y6R/I4qGxni21y1C0F0g
aORDrf3gdSAvASw0RpBVExlFAdpNhcbs0qDahT0nxQBGCZ4TZ1z/vMTCAnkr
5XKiCL7rw63ckM4GqKEdaKsv1+/ZqY3gZyy+JlW5/QSX4WlrvvLMtPu6UJL+
+ZEEyxHs034ryjOly/JoSrdXfa0+qYR1VCDeF+ZuV5U2IbJuLbl4OCe2JqV7
2sHpBYuBYYKq63erUKVVFCYYKeiNRfDVZMa+A23GE3T9TObRN1iSCugS/ZL9
CSZtIpNwsjVn6ME4JrAabVZFRQr2FRHaUtqbcVsLXOZT4UTLdNty5wb7vn86
OzHXCwBUg7XBgrzTx3t66ym8n+89Ufo002a7NiIFNRCJBzLfToU2U3ZPUzG3
BjZQY2xOv8z2atx/OJ5qzS7qKuX2s9TXpbqHVL7OKcYCJoqxvL9E22hGTBso
bN1E0EOBLKEPEmO+G+G/byOI310DQrk7NgRVDrcXKLkhE2uFTJC7hvL+D3QR
HAbdTbeCZNheCt9qDngDPDMUla+zw6FamL4LwIYc1RyqrkJF51klBkT3/LSM
N27R7C3vreR2fDl7K+oNKQwVSAe8MpQKdM/h0jqN9V1o+rUsU6GShLSg2TbD
MLPZDOYrWm4HmNQPM55XuWAHDNkBFnjn/sjRlrydprSG0TrmQUL4HZo5zgtQ
tkEgIXsyf0a1QlGzbs4aQU4SJOhPynjUoI1wcDmJOfGs1+HEgMneOmm3ty1G
mxxbHaMdNdPdpOB9oHQG8VqnOz5cASuOZ1KRzDZE4JmiBBUpxfjZhlqodNh+
tb6WMotyL97dRDPbnlJN27Fy3z7GwMnrhmZTat93A1ntBesUcWCpBT0VJKFF
cvV4Y777CjiuaP0+KPdfvf7z71fBLNyDiYcUs3AtFfJWfex5sQ4N2Q8on3Q3
6sq/AA2eamsz7jgNakDlufBoyu3Ib7dmvf7PV7SmAUiuuX6yKApRBElOuoq1
441Ydz9eAalsUTzDDuFtjbZ9l+1ik/l10n27K6V3R4at6v3KY1vHHBa6n3LW
azcqYsaHtSj6JyKg9SvLwSgCZ5HNlqlknRS65uDbUSuHDLVbWaIp39xqTh8f
UoOIyP452cN7Hhiaa+OsuqQXz+fR1iW2/L/tjQwVxAThugLtfuxLqG81jPj2
zAYNlloHLlvpK+ZuulwtJ6uKPtBXRgdYNAlIChhVZevhy6ePvdtE/R2tegUd
SRlYIe2I0i26lG8J5OeQzS7yOZMUeHz0YAyOl//xJGaJbw8X2DbpUEkd+fUg
V8pBKP9fAdwbE0XR0fewOEU7XeYTpgsfHrvrnuT2sj703GpNL+8trEd7V3mL
AI0MxDzimNRH58F04v99IP5FCtUwiJQUi8NJom+LEEiM6EyQyTCZndVO/wTS
f83mE/AOZ05tAJRmSAp1AFQ2MFE/PH+ZvMpbhXuSwCpgjP/HgVi7/NntP8HL
YR7ggGz8x9f/vW+J3KPIW1jPjvorcATgDvCtQ6K0af0MlQC3YyeSr87ofzig
w6JPUVrCmhIQJyZYpr1PUaboU7SqZfktraqh2IAcHd9a7SnAArUXrlJo/Qiv
gBfhW0eWSOEt8tdPnrzkqs1g/q/pDKGjojT8n8L/vSPn+QEaeI0ne4k1L+u9
iXgXUjFKQa70P4kgOtM9A+NjjwEMTCwkPzmLq3j3VbsupH4LpFoNhQ4cH35Q
Ba4Ma8uxn/3Wyp/0JH5wtSfwffUK94XSUi2RL78Dmn7bsuyM3vgfg7l7pw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95479897]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459938579],

Cell["Fill for a point oriented plot: ", "ExampleText",
 CellID->261341821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"50", ",", "p"}], "]"}], ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.5", ",", "0.8"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394843672],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24693415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->366658322],

Cell["Fill for a surface oriented plot: ", "ExampleText",
 CellID->623210129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "<", 
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], "<", "4"}], "&"}], ")"}]}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347376865],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4879654]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3472],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling Limits",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->423312395],

Cell["Fill to different levels:", "ExampleText",
 CellID->68209635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Bottom", ",", "Axis", ",", "0.3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374327792],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70147649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198392416],

Cell["Overlapping fills by default combine using opacity:", "ExampleText",
 CellID->410116164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601270849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24215983],

Cell[TextData[{
 "Fill between curve 1 and the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->200504289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26059],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->573800700]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28110335],

Cell["Fill between curves 1 and 2:", "ExampleText",
 CellID->396638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11560],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262004198]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling Style",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21778549],

Cell["Fill between curves 1 and 2 with a specific style:", "ExampleText",
 CellID->30883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", "Yellow"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15905],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15632206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->637116188],

Cell[TextData[{
 "Fill between curves 1 and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath"],
 " with yellow:"
}], "ExampleText",
 CellID->114357690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "Yellow"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11831765],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWn1oltcVf8z7kTcao1ajMVGTGHGztvbD2c62VldbP+hsF0amLHVrTAfJ
xuLQCJ0twzCIfyyuwzJIStExo9aPP16nxAkRXEIlgZKAGCpacJFJLBiEBGVh
wrvfOefe5z7Pfe+TmDRo8tz3uc/vnHvO75xzn3PfbTWNdb/6bU1jfW1N2eY9
Nb+rq6/dW7Zp9x58FJvmed4F/P9NkYfrDK74/4VMBn+Dv3PxO4ZbOTSiiwz/
eDm4PMYzUtadGP2Km7HnJawZn8nHMflDPzl6OCmcTTx+PPa/u323+ts7vZyv
jvzTi93o6MWYbpXSr9z+vrtnTl87euQr/Dve3o/h2Nhjb/kkdKcJb9IwAeyO
xrbPN+473/DX3tYLIjFxpfkkxvi088Df7/R87RXz3N6eO00HOt/a+Pnuhr2f
Hv6Zl3P0yDYv0dZaiTE+3dfYcbnzG2/ZFG34Bs/4prPvRNUfIR9ic1nq2Ogj
fAgl03V/uXf93958/nTg+r36uvS+xobLnWvGxhLkVc+L9/asbDrwwfaqE1Bk
6RT12MAzHg6PQCSWPzI0nM+fQDY0uHo4Dfc8xZ/A6p8evlpf9+HA9fJ8lj80
NBfyYYjh4YdlPtuIC8nA36C09TyGe09VHyRLz+bxtdNXzu5quX/zP2o8OPig
dtfZM6c30hjEwjoxhuOFEd4ChS5oA+kv4T3YzWM9Yw8Gv8UYMrwCHsOPUHpw
sIjuA214uAAePJce8Jb4aEEd1/EYxOhuOUOX83gMfFiIdGb7xLq7bsMdo6PT
vUJGPdRSDX7SrUVO1NdIZ4Au0Jy/tP8IoU3n8cWOG0Ajzy5gNFBNoZU40V7l
MWIGJKbLIgtVeABawD/0/EILtdiJ+gqPQT8QwZ8VQE1qe360v550LWFUxAbi
k24tDHlH0PAcngaG2IXsCF7BR15c+xreITsuZjSYAQL8NWXp+EMeg53wMaGy
D2OgLRhEHJA8Nzo6BsaAn3QfqNAWY8iKQH1Z6wYUYHnM5iQ4BCkyZXfD+f6+
5WWMBi4BjbLQgnHQYESYki7Lle+9GPIXEgg9U85I3V3Pf7T/Es2Z70R6icfI
WkgRdFnB4y9qP/l9zR7yQIXlgcKQB17S8YBVka0qdBzv2tF+cuf7D4dnVGjr
wAe3bt4PPB/U4geaB8Ahz3HOix9svnKxY+2dnrKOxspljHPr5mJkKbLLvHFw
QFkQ119NEtw/2Pw+rvDvSvPmGx1PL7PYOteJtlozAXwytkEqgm8Q48QEWtto
7qnqX2KpnqBy/rpHU59yor6o1wpUyki81hgKATIvA/AvWTVdVliMMKjkgdXK
88t05IDedD/BT8lqDcrx9i1trb00dY5Ttxd4DK2gm+9P4vrO6lO04iSjYK1n
d71HK7a9K6g6Rwfrta7hdr4WiZJOjY1RBpCcFZZHGXhVd8tGsw4UCPCApnI+
F9RQFcq15Nh7h+cz4UwkcrGG2l0fE0Aey8Ey798sNHKRg5HWaeosEWPtUKT4
BdRw6kHD5zQLUJ1RGxULsCgszci/d31hum6HkY8sxp54qORPft0iF1UXJdGs
248Qb4aTN+fSrx9q6aapBRFyExl3PV7lZBR4jE0FMSpfM+pEVe3jsbiKITgB
rqCpM8eRF5Rjj0UuCsPtrmsuXs1kOddOv3D18AazTuwDsNkwcjWT9V9byrM8
9rO4kjI0NLKzuomyZwGjYl3IECNDBWp1KG4o7jQ1349CQhedZaNi0JC+kcRp
3ix++nZXxaX977gyg0EL6vgMj+0Mb5g+h1HON1Td7VtkUE3Gn+FEXTkBfwUV
wYMQMqjwOPxOuo6HCmqCoEZXGAsmo/lzneyES+FYmjrdifo0j6EldA1xkCt2
EdWSEAf9rMYcfRhAJS+tdEYQjAWT0TzZrYFWIJcrgvKcOq6I0lHFyXytI5iE
ipMVJyknKtU1GnJ9g91OggaUleizeepenqW/ZADG8EwmMpGSUiJII855gT2G
W4t51pirRC5IDqr7AS2/s55NOPOFrR28Bt9RRbK15x150ow9T2xmNKU1FLo0
DGQP+912vlNLk13AGE5XMyzbTZ9QO6lsT2ZHeZfx7aj2u2Hv6+zF+5btVc2U
lYI2op98y4ZOLXODWuK3JDHBfkJNTWazNbXn2/bMV1yTrI3gRwrIqN2B8p+n
ehCyS0RkE0TyibTjWoq8eg0O970dqjY2Qsyy6Eylh+R7s2tIWpYstMair6kH
icgoJvQ5lhVjAfbG/NprrFZgSRM/m/qhracj2bae0Ybucj9knB1TqbV2yXt4
PcRLou/zrLVJ3bDriKl5pZbOdh0ZD9WuI0bXcqeupubFnKgVE+haPoGu46FG
61oxga7MVub037xQBlU7may+nGuc8MdC+KwIdT6V9MeiftRzU0OPkGZ2A4zj
KXSTnOTTrCib5NhkZdkaefrN7DviPvFYVj0t7FOVdcstJnJvTmUsBC9CeJ6F
LXtHsx9bZN2PZ0eoJAIlK3pP9j1GAuVBfLpcGkaKB8tFqTOCRGODZbQMY8lu
w+SnJRNotsLSrDysmeGNsupift7swWztVljaReIpywle9E5xJePhxRavt3RZ
FsZLBnmN1zO8pJVYGtq7xGcY0exkw4gmx5ucVDyBjs/yfLObLc3mSYi9Ji9J
x3BkaPhU9UGXrqssXSdCNjoLsv1uZ3R+juf3t6/pbX2NLpdEIktEt7VWHm/v
p1uyrzM7Kr/jo+o8p/nATmkiZPMOMd+ps6nVbNzATnFxlueko2PedWQXc6fn
647GNpeuL2pd1bvn4khd41pX1cURZPs9VLpxNHV1JlznFkUii87m/UD659Hv
otIAM7WuJBJZdlam1zbbmVlQAvFKb5CRx5HNnwTZZBlBNp1wO8u8nAlnmeIs
z6V4htkJFUyQZwQRJkjX7aDIKI7UNdeKDEHubjkzkP7SFRlrrWhe6COnMtE9
u4QlNWVFen5U1Kg+6SvCL79PaqTmBuqWCLT7VzlO2SauRLYcZbni6lUrroom
KVu9IXvUI1uLEKDP5UQleie8zmLxgqmtN2NkGR6ndFSrDCR9gN0Ne/v77tJU
OVsyHamSCLm6X2d3tEQen499TFkkZTFGdp+XO9c0HeAO+3qeL50FuiweR15Q
jr0D5H5QjM9gt5kotPtH3P9sIr9v4Pljo49QXSjei0Ms1v06txREClDo7CZp
eUqkSK2lqT+yPB0+f+IeYaDnHre4ZvcUN/J8OeSjS/dJkaCabCvVDxkc0WN1
p5rJEnzuHKiz46FyJ7/JnF3YXT/T336L5yONqDNK9zkU55uEbwFZuuJkf9/y
3Q3nacJma93ukyh+C6czn38cewMewVL99ydwkVa6hZ+At7FSOokzOOQNydOP
Rv/75017r3d9P6vXupXvm9rjPokSLbAf+lfbRQmBpVb0v20x3n0SJZbxmSPl
Qr0hmo7tj/kpeA3RSmfxbizxnemhS44wOW6Jjg0oPDQ04r2jGYH5FBvu0618
HUHqRDKmYwO1GpxVp6UwAHxLJ+M/yajMAkeSFuFzqHy9Etylk/GE5ps6GZf3
DVMDKy1+uc+jpmtUdT4s2RJrRMKj+C1mVHOO99OMnIa50fI0mmqE5mk05lcB
14YgWpVCm+1ES2n7QTdCk9yCKqBWLB1bVEmFtp3vA069rRSE7JfSPgMTaKUz
tW5AQySpzjd8DBphs+r9nO9j0w5+kTdmOnWUjhC2nOrbD7O0VxCZx9u3qC49
9xw/pDeg9zIq32E+8VFOFEg31V0L16qovE7f9oCNQQWYR/Z8ba29sDIkSQ8v
jpVAAaiBUvMLfubB4LfgK/ZZeEY67nkWdvZ3TZx9hDisCBtjcwW3cJTH2Stp
sA8KcDVPQD6iB8kQilEk1vA8bPHwGKwKHVKT0SGFCyxAvmYEFwoKHMPZuACk
h3yWVondsJyRgHLw7Ln063Dp21s/QTwjyX1A83MhHis4unU/uAUcwFIcxyeh
UYzflbEeda7K343Ig7FBHgQ4tFm/rq3y3T/BA4dausn3v6YZCXAFkrGCY+/+
gb9QMEVPfPadntN1XH/Lh4uvl/3dM2/a/wENuKpM\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->959501443]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->590217671],

Cell["\<\
Fill between curves 1 and 2; use yellow when 1 is below 2, and green when 1 \
is above 2:\
\>", "ExampleText",
 CellID->1241540290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Green"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1616539778],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->722774572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->426918260],

Cell[TextData[{
 "Use an overall ",
 Cell[BoxData[
  ButtonBox["FillingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FillingStyle"]], "InlineFormula"],
 " specification: "
}], "ExampleText",
 CellID->10234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Lighter", "[", "Purple", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312878712],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86628268]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->839],

Cell["Fill with opacity 0.5 orange:", "ExampleText",
 CellID->21157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Orange"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5668],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135860078]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1711066621],

Cell[TextData[{
 "Fill with red below the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis, and blue above:"
}], "ExampleText",
 CellID->943182170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Orange", ",", "Yellow"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1485932683],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246609317]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4485],

Cell[TextData[{
 "Use a variable filling style obtained from a ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "->", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31022],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260931739]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Plot Functions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->693532071],

Cell["Point oriented plot functions will fill using a stem: ", "ExampleText",
 CellID->679279617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"50", ",", "p"}], "]"}], ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.5", ",", "0.8"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234909199],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->697264172]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182344057],

Cell["Line oriented plot functions will fill using an area: ", "ExampleText",
 CellID->104330996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"50", ",", "p"}], "]"}], ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.5", ",", "0.8"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->428096184],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx91QtMW1UYB/DLY7NKDBWrY0md0DUwgSKP8i70A8p7wIAZJcpkONDABBXL
Ji5Q4jIMe0C2DJy8X2FsCkoZK4wxHmFqUGHykkyYwcFkGx1bhBEIXC+3Hyfc
m+hJ2ptfv97ec79z/r3WSRmxycYURZUzr43j5rB+cSzwfHScn0ELSumV9b6p
Py6gKZi0qXR6sjyEFsDUyZyybMs1tBD0DY9kp/dJlAaLYFEtyj77fADaEtai
j42dMElAi6HizG2Fe0Em2gouRlvOfpZ3Ai2BftbFaCmoe1cjpvpr0TaQWejp
XzXUhN4Dscr1mEn1FbQdfJ3/1ZHD0x1oBwjuc1hMzuxCO0LefHzHq7E30E5Q
G9XatfbOdbQz+K+oayX27WgXqFUZ1Wfd1KJdQVRS/ZPHqW/Qchigmy52LdWg
3WDglNfUec8StDsEByUJyhQFaA9QVVveqkn8HO0Jbs/evx2Xkor2gvwD2uWi
L99Ee8PgeHdoZHIg2ge6eysrHc7I0Ao4XPpcjHxQhPaFc/UNqWvmq7g+fuDo
tK4cUPyJVoIuZdY1cbEHDSD/RfzD0ZAagzUAWZ0ztmU78rDuD227xC1mkQlY
9weZ6b3fDyy5Yz0AaON6wViKEOsB0PzCmGZ3yIyvoR4ILSUjplaLOoM1gZDe
9vczsv0FWFfBtY7p6W3Db2FdBU/jmoVRvVKsB4Fc37v3pkavMNSDIFJnbG+i
1hpMBQO1dWh4pkJ4dZ6pUF6dZyqMZ4papjfGIF5/Qfkye3wN50uBYONdmokW
wCustWghPGXOviN+iBbBLGNXOyvspyVM03SudXQUWgxzNH1DPXQEbQWLNC02
p6rQEhBRmr2dl3rRUtDTg3K55C+0DfP9d+vmDhmRvGynxJdXA8UkL9spl8zR
BjnJiz43oTonIoLkxVxTIctNTCR5efj2zM6Tcx+TvDxmnUfyYqy0kKWmFZG8
mFbt/zSjoZTkZWXVdqUwvZ7kxeSDAXhS3kTyQr9RHvlA1krysj7u+OhxkY7k
xUgrkglrr5G80Antvwm7OkleuHUf3vkK3u/7Av3+1uv78ean5M0fuPfH5GWe
c//+3P4weTHj9C8A/tnaXyYv3P4HcteHyQt3/VTc9WXywl3/IFjbuj+YvHD3
D5sPDdlfTF64+y+Euz+ZvHD3byh3fzN54e7/MODmgz8WlLwPgEsBz0KeRTxb
8izm2YpnCc9Snm143sOzHYSG7KwTxG7+/zjAF99pC0fy59COMFQ1bkHX7MJ+
OMHog8ic3T370M7wK2sN2gWSne52pl1tQrvC6PjBteHJCbQcvEfsv79vZorr
4wZ9ZX7B0bUOaHeIVzVO03di0R5g5Otil7GShfaEluNHza9PbD7PvaB5ZV77
yXQH2hta2foE2ge2secvoRVwnP19C5KXScP1SV5s2PmpSF5odv7xJC+Z7P2l
k7zcNdw/yYvBRSQvP7L9qyB5Ocf2t5HkJc3Qf5KXxhKJzv+jDpKXyrCXukVB
3SQvP5eHDxfP9GBdBXX9B0fG1WgmL4OlDUXFenz+M3l5L9xNeii4DevBIHXS
tRfH4/OeycvVC7NnP/TdnF8I7GgYdv42Ap/vTF4uHzOeVd3b/H8MhUusY7Ae
CrdezyqITrLFehi46EbCs/Xzfpum/nf8d/1fwjxaQA==
   "], {{{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1, 157, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 
        33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 
        16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}},
        VertexColors->None]]}, {}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{52, 155, 156, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 
        92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 
        75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 
        58, 57, 56, 55, 54, 53}},
        VertexColors->None]]}, {}, 
     {Hue[0.14213595499957954`, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{115, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 
        144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 
        130, 129, 128, 127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 
        116}},
        VertexColors->
         None]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
        68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
       85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
       102}]}, 
     {Hue[0.14213595499957954`, 0.6, 0.6], 
      LineBox[{103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
       115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
       129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 
       143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 50.}, {0., 0.13981900517431567`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25639118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281227884],

Cell["\<\
Surface oriented plot functions will fill along the boundary: \
\>", "ExampleText",
 CellID->211234082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "<", 
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], "<", "4"}], "&"}], ")"}]}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336555871],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228462006]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31219],

Cell["\<\
Here styles indicate where the function differs from its step approximation:\
\>", "ExampleText",
 CellID->3575137],

Cell[BoxData[
 RowBox[{
  RowBox[{"fapprox0", " ", "=", " ", 
   RowBox[{"Interpolation", "[", " ", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k", "/", "5"}], ",", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "-", 
             RowBox[{"1", "/", "2"}]}], ")"}], "/", "5"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "0"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17322351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"fapprox0", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Orange"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->324570540],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->653195737]
}, Open  ]],

Cell["\<\
Difference between the function and its linear approximation: \
\>", "ExampleText",
 CellID->139608927],

Cell[BoxData[
 RowBox[{
  RowBox[{"fapprox1", " ", "=", " ", 
   RowBox[{"Interpolation", "[", " ", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k", "/", "5"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"5", 
           RowBox[{"k", "/", "5"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "10", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->549793565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"5", "x"}], "]"}], ",", 
     RowBox[{"fapprox1", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Orange"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->289808344],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->377486883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->340413895],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Factorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial"]], "InlineFormula"],
 " function compared to an asymptotic expansion:"
}], "ExampleText",
 CellID->7988894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "!"}], ",", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "Pi"}], "]"}], 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "x"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->993448970],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95436814]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12137],

Cell["Eigen functions in a potential well: ", "ExampleText",
 CellID->1530322957],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"n_", ",", "x_"}], "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", "Pi"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "4"}], ")"}]}], 
       RowBox[{"HermiteH", "[", 
        RowBox[{"n", ",", "x"}], "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "/", "2"}], ")"}]}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"2", "^", "n"}], " ", 
         RowBox[{"n", "!"}]}], "]"}]}], ")"}]}], "]"}], "^", "2"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->243810284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", "\n", "  ", 
    RowBox[{"Append", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "+", "n", "+", 
         RowBox[{"1", "/", "2"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "0", ",", "7"}], "}"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"Filling", "->", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"n", "->", 
       RowBox[{"n", "-", 
        RowBox[{"1", "/", "2"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "8"}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->320644712],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 199},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->164396698]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32664],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Joined",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Joined"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FillingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FillingStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClippingStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClippingStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16340]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16091],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Filling",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Filling"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2028890],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->88685212],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->64286516],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->901273334],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->164921586],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], "MoreAbout",
 CellID->187679739],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->297756443],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->35432629]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Filling - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 36.6397202}", "context" -> "System`", 
    "keywords" -> {
     "skirt", "fill area", "fill volume", "fill length", "filled plot", 
      "stem plot", "curve filling", "surface filling", "point filling", 
      "fill below curve", "fill above curve", "fill below surface", 
      "fill above surface", "fill between curves", "area between curves", 
      "area below curve", "area above curve", "volume below surface", 
      "volume above surface", "volume between surfaces"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Filling is an option for ListPlot, Plot, Plot3D and related functions \
which specifies what filling to add under points, curves and surfaces. ", 
    "synonyms" -> {}, "title" -> "Filling", "type" -> "Symbol", "uri" -> 
    "ref/Filling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15617, 508, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->30889655]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 188886, 4087}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3468, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4091, 105, 1572, 37, 70, "ObjectNameGrid"],
Cell[5666, 144, 918, 29, 70, "Usage",
 CellID->11580]
}, Open  ]],
Cell[CellGroupData[{
Cell[6621, 178, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7099, 195, 68, 1, 70, "Notes",
 CellID->8112],
Cell[7170, 198, 4257, 138, 70, "2ColumnTableMod",
 CellID->3485],
Cell[11430, 338, 161, 6, 70, "Notes",
 CellID->3817],
Cell[11594, 346, 252, 9, 70, "Notes",
 CellID->6398],
Cell[11849, 357, 283, 10, 70, "Notes",
 CellID->17216],
Cell[12135, 369, 490, 18, 70, "Notes",
 CellID->21411],
Cell[12628, 389, 399, 10, 70, "Notes",
 CellID->31472],
Cell[13030, 401, 257, 8, 70, "Notes",
 CellID->10713],
Cell[13290, 411, 450, 17, 70, "Notes",
 CellID->25632],
Cell[13743, 430, 1272, 49, 70, "Notes",
 CellID->32751],
Cell[15018, 481, 562, 22, 70, "Notes",
 CellID->11657]
}, Closed]],
Cell[CellGroupData[{
Cell[15617, 508, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30889655],
Cell[CellGroupData[{
Cell[16001, 522, 148, 5, 70, "ExampleSection",
 CellID->419312915],
Cell[16152, 529, 68, 1, 70, "ExampleText",
 CellID->511379531],
Cell[CellGroupData[{
Cell[16245, 534, 488, 16, 28, "Input",
 CellID->526222223],
Cell[16736, 552, 7134, 121, 246, "Output",
 Evaluatable->False,
 CellID->210274536]
}, Open  ]],
Cell[23885, 676, 124, 3, 70, "ExampleDelimiter",
 CellID->65844213],
Cell[24012, 681, 64, 1, 70, "ExampleText",
 CellID->689609686],
Cell[CellGroupData[{
Cell[24101, 686, 449, 14, 28, "Input",
 CellID->476617387],
Cell[24553, 702, 8508, 144, 125, "Output",
 Evaluatable->False,
 CellID->95479897]
}, Open  ]],
Cell[33076, 849, 125, 3, 70, "ExampleDelimiter",
 CellID->459938579],
Cell[33204, 854, 75, 1, 70, "ExampleText",
 CellID->261341821],
Cell[CellGroupData[{
Cell[33304, 859, 622, 19, 47, "Input",
 CellID->394843672],
Cell[33929, 880, 4095, 71, 138, "Output",
 Evaluatable->False,
 CellID->24693415]
}, Open  ]],
Cell[38039, 954, 125, 3, 70, "ExampleDelimiter",
 CellID->366658322],
Cell[38167, 959, 77, 1, 70, "ExampleText",
 CellID->623210129],
Cell[CellGroupData[{
Cell[38269, 964, 782, 24, 47, "Input",
 CellID->347376865],
Cell[39054, 990, 22740, 377, 165, "Output",
 Evaluatable->False,
 CellID->4879654]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61843, 1373, 216, 7, 70, "ExampleSection",
 CellID->3472],
Cell[CellGroupData[{
Cell[62084, 1384, 235, 7, 70, "ExampleSubsection",
 CellID->423312395],
Cell[62322, 1393, 67, 1, 70, "ExampleText",
 CellID->68209635],
Cell[CellGroupData[{
Cell[62414, 1398, 488, 16, 70, "Input",
 CellID->374327792],
Cell[62905, 1416, 7133, 121, 70, "Output",
 Evaluatable->False,
 CellID->70147649]
}, Open  ]],
Cell[70053, 1540, 125, 3, 70, "ExampleDelimiter",
 CellID->198392416],
Cell[70181, 1545, 94, 1, 70, "ExampleText",
 CellID->410116164],
Cell[CellGroupData[{
Cell[70300, 1550, 356, 12, 70, "Input",
 CellID->70],
Cell[70659, 1564, 4637, 80, 70, "Output",
 Evaluatable->False,
 CellID->601270849]
}, Open  ]],
Cell[75311, 1647, 124, 3, 70, "ExampleDelimiter",
 CellID->24215983],
Cell[75438, 1652, 162, 6, 70, "ExampleText",
 CellID->200504289],
Cell[CellGroupData[{
Cell[75625, 1662, 421, 14, 70, "Input",
 CellID->26059],
Cell[76049, 1678, 4308, 75, 70, "Output",
 Evaluatable->False,
 CellID->573800700]
}, Open  ]],
Cell[80372, 1756, 124, 3, 70, "ExampleDelimiter",
 CellID->28110335],
Cell[80499, 1761, 68, 1, 70, "ExampleText",
 CellID->396638],
Cell[CellGroupData[{
Cell[80592, 1766, 445, 15, 70, "Input",
 CellID->11560],
Cell[81040, 1783, 4157, 72, 70, "Output",
 Evaluatable->False,
 CellID->262004198]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[85246, 1861, 233, 7, 70, "ExampleSubsection",
 CellID->21778549],
Cell[85482, 1870, 89, 1, 70, "ExampleText",
 CellID->30883],
Cell[CellGroupData[{
Cell[85596, 1875, 510, 18, 70, "Input",
 CellID->15905],
Cell[86109, 1895, 4140, 72, 70, "Output",
 Evaluatable->False,
 CellID->15632206]
}, Open  ]],
Cell[90264, 1970, 125, 3, 70, "ExampleDelimiter",
 CellID->637116188],
Cell[90392, 1975, 213, 8, 70, "ExampleText",
 CellID->114357690],
Cell[CellGroupData[{
Cell[90630, 1987, 513, 18, 70, "Input",
 CellID->11831765],
Cell[91146, 2007, 4340, 75, 70, "Output",
 Evaluatable->False,
 CellID->959501443]
}, Open  ]],
Cell[95501, 2085, 125, 3, 70, "ExampleDelimiter",
 CellID->590217671],
Cell[95629, 2090, 141, 4, 70, "ExampleText",
 CellID->1241540290],
Cell[CellGroupData[{
Cell[95795, 2098, 578, 20, 70, "Input",
 CellID->1616539778],
Cell[96376, 2120, 4442, 77, 70, "Output",
 Evaluatable->False,
 CellID->722774572]
}, Open  ]],
Cell[100833, 2200, 125, 3, 70, "ExampleDelimiter",
 CellID->426918260],
Cell[100961, 2205, 217, 8, 70, "ExampleText",
 CellID->10234],
Cell[CellGroupData[{
Cell[101203, 2217, 376, 11, 70, "Input",
 CellID->312878712],
Cell[101582, 2230, 2802, 50, 70, "Output",
 Evaluatable->False,
 CellID->86628268]
}, Open  ]],
Cell[104399, 2283, 119, 3, 70, "ExampleDelimiter",
 CellID->839],
Cell[104521, 2288, 68, 1, 70, "ExampleText",
 CellID->21157],
Cell[CellGroupData[{
Cell[104614, 2293, 521, 17, 70, "Input",
 CellID->5668],
Cell[105138, 2312, 4495, 78, 70, "Output",
 Evaluatable->False,
 CellID->135860078]
}, Open  ]],
Cell[109648, 2393, 126, 3, 70, "ExampleDelimiter",
 CellID->1711066621],
Cell[109777, 2398, 173, 6, 70, "ExampleText",
 CellID->943182170],
Cell[CellGroupData[{
Cell[109975, 2408, 397, 12, 70, "Input",
 CellID->1485932683],
Cell[110375, 2422, 2933, 52, 70, "Output",
 Evaluatable->False,
 CellID->246609317]
}, Open  ]],
Cell[113323, 2477, 120, 3, 70, "ExampleDelimiter",
 CellID->4485],
Cell[113446, 2482, 234, 8, 70, "ExampleText",
 CellID->23592],
Cell[CellGroupData[{
Cell[113705, 2494, 528, 16, 70, "Input",
 CellID->31022],
Cell[114236, 2512, 3019, 54, 70, "Output",
 Evaluatable->False,
 CellID->260931739]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[117304, 2572, 235, 7, 70, "ExampleSubsection",
 CellID->693532071],
Cell[117542, 2581, 97, 1, 70, "ExampleText",
 CellID->679279617],
Cell[CellGroupData[{
Cell[117664, 2586, 622, 19, 70, "Input",
 CellID->234909199],
Cell[118289, 2607, 4096, 71, 70, "Output",
 Evaluatable->False,
 CellID->697264172]
}, Open  ]],
Cell[122400, 2681, 125, 3, 70, "ExampleDelimiter",
 CellID->182344057],
Cell[122528, 2686, 97, 1, 70, "ExampleText",
 CellID->104330996],
Cell[CellGroupData[{
Cell[122650, 2691, 626, 19, 70, "Input",
 CellID->428096184],
Cell[123279, 2712, 4224, 78, 138, "Output",
 CellID->25639118]
}, Open  ]],
Cell[127518, 2793, 125, 3, 70, "ExampleDelimiter",
 CellID->281227884],
Cell[127646, 2798, 113, 3, 70, "ExampleText",
 CellID->211234082],
Cell[CellGroupData[{
Cell[127784, 2805, 782, 24, 70, "Input",
 CellID->336555871],
Cell[128569, 2831, 22742, 377, 70, "Output",
 Evaluatable->False,
 CellID->228462006]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[151372, 3215, 223, 7, 70, "ExampleSection",
 CellID->31219],
Cell[151598, 3224, 125, 3, 70, "ExampleText",
 CellID->3575137],
Cell[151726, 3229, 640, 21, 70, "Input",
 CellID->17322351],
Cell[CellGroupData[{
Cell[152391, 3254, 571, 19, 70, "Input",
 CellID->324570540],
Cell[152965, 3275, 2978, 53, 70, "Output",
 Evaluatable->False,
 CellID->653195737]
}, Open  ]],
Cell[155958, 3331, 113, 3, 70, "ExampleText",
 CellID->139608927],
Cell[156074, 3336, 572, 18, 70, "Input",
 CellID->549793565],
Cell[CellGroupData[{
Cell[156671, 3358, 583, 20, 70, "Input",
 CellID->289808344],
Cell[157257, 3380, 5324, 91, 70, "Output",
 Evaluatable->False,
 CellID->377486883]
}, Open  ]],
Cell[162596, 3474, 125, 3, 70, "ExampleDelimiter",
 CellID->340413895],
Cell[162724, 3479, 232, 8, 70, "ExampleText",
 CellID->7988894],
Cell[CellGroupData[{
Cell[162981, 3491, 638, 22, 70, "Input",
 CellID->993448970],
Cell[163622, 3515, 3241, 57, 70, "Output",
 Evaluatable->False,
 CellID->95436814]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[166912, 3578, 224, 7, 70, "ExampleSection",
 CellID->12137],
Cell[167139, 3587, 81, 1, 70, "ExampleText",
 CellID->1530322957],
Cell[167223, 3590, 783, 28, 70, "Input",
 CellID->243810284],
Cell[CellGroupData[{
Cell[168031, 3622, 883, 29, 70, "Input",
 CellID->320644712],
Cell[168917, 3653, 13957, 233, 70, "Output",
 Evaluatable->False,
 CellID->164396698]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[182935, 3893, 311, 9, 70, "SeeAlsoSection",
 CellID->32664],
Cell[183249, 3904, 1222, 44, 70, "SeeAlso",
 CellID->16340]
}, Open  ]],
Cell[CellGroupData[{
Cell[184508, 3953, 314, 9, 70, "TutorialsSection",
 CellID->16091],
Cell[184825, 3964, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[184966, 3969, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[185160, 3977, 305, 8, 70, "RelatedLinksSection"],
Cell[185468, 3987, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[185864, 4004, 317, 9, 70, "MoreAboutSection",
 CellID->2028890],
Cell[186184, 4015, 146, 3, 70, "MoreAbout",
 CellID->88685212],
Cell[186333, 4020, 154, 3, 70, "MoreAbout",
 CellID->64286516],
Cell[186490, 4025, 163, 3, 70, "MoreAbout",
 CellID->901273334],
Cell[186656, 4030, 143, 3, 70, "MoreAbout",
 CellID->164921586],
Cell[186802, 4035, 174, 3, 70, "MoreAbout",
 CellID->187679739],
Cell[186979, 4040, 197, 4, 70, "MoreAbout",
 CellID->297756443],
Cell[187179, 4046, 178, 3, 70, "MoreAbout",
 CellID->35432629]
}, Open  ]],
Cell[187372, 4052, 27, 0, 70, "History"],
Cell[187402, 4054, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

