(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    165569,       3634]
NotebookOptionsPosition[    156200,       3316]
NotebookOutlinePosition[    157896,       3359]
CellTagsIndexPosition[    157809,       3354]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Filling" :> Documentation`HelpLookup["paclet:ref/Filling"], 
          "PlotStyle" :> Documentation`HelpLookup["paclet:ref/PlotStyle"], 
          "MeshStyle" :> Documentation`HelpLookup["paclet:ref/MeshStyle"], 
          "BoundaryStyle" :> 
          Documentation`HelpLookup["paclet:ref/BoundaryStyle"], 
          "ExclusionsStyle" :> 
          Documentation`HelpLookup["paclet:ref/ExclusionsStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Filling\"\>", 
       2->"\<\"PlotStyle\"\>", 3->"\<\"MeshStyle\"\>", 
       4->"\<\"BoundaryStyle\"\>", 
       5->"\<\"ExclusionsStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FillingStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FillingStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FillingStyle"]], "InlineFormula"],
     " ",
     "\[LineSeparator]",
     "is an option for ",
     Cell[BoxData[
      ButtonBox["ListPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Plot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Plot3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
     " and related functions that specifies the default style of filling to \
be used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FillingStyle", "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " specifies that all filling should be done by default with the specified \
graphics directive. "
}], "Notes",
 CellID->23086],

Cell[TextData[{
 "Possible directives include ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 ", and in the case of ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " also ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2448],

Cell[TextData[{
 "Directives can be combined using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Directive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directive"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9262],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FillingStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["-", "TR"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["+", "TR"]]}], "}"}]}]], "InlineFormula"],
 " specifies that the filling should be done with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["-", "TR"]]], "InlineFormula"],
 " when a point, curve or surface lies below the object being filled to, and \
with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["+", "TR"]]], "InlineFormula"],
 " when it lies above. "
}], "Notes",
 CellID->7094],

Cell[TextData[{
 "Settings of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "k"], "->", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["p", "k"], ",", 
        SubscriptBox["s", "k"]}], "}"}]}], ",", "\[Ellipsis]"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  ButtonBox["Filling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Filling"]], "InlineFormula"],
 " can be used to override the default style specified by ",
 Cell[BoxData[
  ButtonBox["FillingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FillingStyle"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23017]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6757518],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->635223901],

Cell[TextData[{
 "Set an explicit ",
 Cell[BoxData[
  ButtonBox["FillingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FillingStyle"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->13140642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Zeta", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "+", 
      RowBox[{"I", " ", "x"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45494168],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163138412]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "<", 
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], "<", "4"}], "&"}], ")"}]}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->347376865],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->119260023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256930987],

Cell["Use automatic filling styles: ", "ExampleText",
 CellID->689609686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->476617387],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405580061]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"50", ",", "p"}], "]"}], ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.5", ",", "0.8"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->394843672],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69358649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61320466],

Cell[TextData[{
 "Use automatic filling style together with a ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->135479556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Accumulate", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "250"}], "]"}], "]"}], 
   ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318380430],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->653483518]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3472],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling Limits",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->423312395],

Cell["Fill to different levels:", "ExampleText",
 CellID->68209635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Bottom", ",", "Axis", ",", "0.3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374327792],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31825652]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198392416],

Cell["Overlapping fills by default combine using opacity:", "ExampleText",
 CellID->410116164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43338737]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24215983],

Cell[TextData[{
 "Fill between curve 1 and the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->200504289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26059],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192649788]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28110335],

Cell["Fill between curves 1 and 2:", "ExampleText",
 CellID->396638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11560],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->684092873]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling Style",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21778549],

Cell["Fill between curves 1 and 2 with a specific style:", "ExampleText",
 CellID->30883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", "Yellow"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15905],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126171899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->637116188],

Cell[TextData[{
 "Fill between curves 1 and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath"],
 " with yellow:"
}], "ExampleText",
 CellID->114357690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "Yellow"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11831765],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414814179]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->590217671],

Cell["\<\
Fill between curves 1 and 2; use yellow when 1 is below 2, and green when 1 \
is above 2:\
\>", "ExampleText",
 CellID->1241540290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Green"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1616539778],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69494699]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->426918260],

Cell[TextData[{
 "Use an overall ",
 Cell[BoxData[
  ButtonBox["FillingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FillingStyle"]], "InlineFormula"],
 " specification: "
}], "ExampleText",
 CellID->10234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312878712],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69934861]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->839],

Cell["Fill with opacity 0.5 orange:", "ExampleText",
 CellID->21157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Green"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5668],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93533494]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->786928661],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["FillingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FillingStyle"]], "InlineFormula"],
 " is together with styles in ",
 Cell[BoxData[
  ButtonBox["Filling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Filling"]], "InlineFormula"],
 " that latter takes priority: "
}], "ExampleText",
 CellID->193365359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "Axis"}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Axis", ",", "Yellow"}], "}"}]}]}], "}"}]}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->432086383],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65181020]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1711066621],

Cell[TextData[{
 "Fill with red below the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis, and blue above:"
}], "ExampleText",
 CellID->943182170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Yellow"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1485932683],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->870807018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4485],

Cell[TextData[{
 "Use a variable filling style obtained from a ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "->", "Axis"}], ",", 
   RowBox[{"FillingStyle", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31022],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386627060]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Plot Functions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->693532071],

Cell["Point oriented plot functions will fill using a stem: ", "ExampleText",
 CellID->679279617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"50", ",", "p"}], "]"}], ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.5", ",", "0.8"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234909199],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44238068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182344057],

Cell["Line oriented plot functions will fill using an area: ", "ExampleText",
 CellID->104330996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"50", ",", "p"}], "]"}], ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.5", ",", "0.8"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->428096184],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx91QtMW1UYB/DLY7NKDBWrY0md0DUwgSKP8i70A8p7wIAZJcpkONDABBXL
Ji5Q4jIMe0C2DJy8X2FsCkoZK4wxHmFqUGHykkyYwcFkGx1bhBEIXC+3Hyfc
m+hJ2ptfv97ec79z/r3WSRmxycYURZUzr43j5rB+cSzwfHScn0ELSumV9b6p
Py6gKZi0qXR6sjyEFsDUyZyybMs1tBD0DY9kp/dJlAaLYFEtyj77fADaEtai
j42dMElAi6HizG2Fe0Em2gouRlvOfpZ3Ai2BftbFaCmoe1cjpvpr0TaQWejp
XzXUhN4Dscr1mEn1FbQdfJ3/1ZHD0x1oBwjuc1hMzuxCO0LefHzHq7E30E5Q
G9XatfbOdbQz+K+oayX27WgXqFUZ1Wfd1KJdQVRS/ZPHqW/Qchigmy52LdWg
3WDglNfUec8StDsEByUJyhQFaA9QVVveqkn8HO0Jbs/evx2Xkor2gvwD2uWi
L99Ee8PgeHdoZHIg2ge6eysrHc7I0Ao4XPpcjHxQhPaFc/UNqWvmq7g+fuDo
tK4cUPyJVoIuZdY1cbEHDSD/RfzD0ZAagzUAWZ0ztmU78rDuD227xC1mkQlY
9weZ6b3fDyy5Yz0AaON6wViKEOsB0PzCmGZ3yIyvoR4ILSUjplaLOoM1gZDe
9vczsv0FWFfBtY7p6W3Db2FdBU/jmoVRvVKsB4Fc37v3pkavMNSDIFJnbG+i
1hpMBQO1dWh4pkJ4dZ6pUF6dZyqMZ4papjfGIF5/Qfkye3wN50uBYONdmokW
wCustWghPGXOviN+iBbBLGNXOyvspyVM03SudXQUWgxzNH1DPXQEbQWLNC02
p6rQEhBRmr2dl3rRUtDTg3K55C+0DfP9d+vmDhmRvGynxJdXA8UkL9spl8zR
BjnJiz43oTonIoLkxVxTIctNTCR5efj2zM6Tcx+TvDxmnUfyYqy0kKWmFZG8
mFbt/zSjoZTkZWXVdqUwvZ7kxeSDAXhS3kTyQr9RHvlA1krysj7u+OhxkY7k
xUgrkglrr5G80Antvwm7OkleuHUf3vkK3u/7Av3+1uv78ean5M0fuPfH5GWe
c//+3P4weTHj9C8A/tnaXyYv3P4HcteHyQt3/VTc9WXywl3/IFjbuj+YvHD3
D5sPDdlfTF64+y+Euz+ZvHD3byh3fzN54e7/MODmgz8WlLwPgEsBz0KeRTxb
8izm2YpnCc9Snm143sOzHYSG7KwTxG7+/zjAF99pC0fy59COMFQ1bkHX7MJ+
OMHog8ic3T370M7wK2sN2gWSne52pl1tQrvC6PjBteHJCbQcvEfsv79vZorr
4wZ9ZX7B0bUOaHeIVzVO03di0R5g5Otil7GShfaEluNHza9PbD7PvaB5ZV77
yXQH2hta2foE2ge2secvoRVwnP19C5KXScP1SV5s2PmpSF5odv7xJC+Z7P2l
k7zcNdw/yYvBRSQvP7L9qyB5Ocf2t5HkJc3Qf5KXxhKJzv+jDpKXyrCXukVB
3SQvP5eHDxfP9GBdBXX9B0fG1WgmL4OlDUXFenz+M3l5L9xNeii4DevBIHXS
tRfH4/OeycvVC7NnP/TdnF8I7GgYdv42Ap/vTF4uHzOeVd3b/H8MhUusY7Ae
CrdezyqITrLFehi46EbCs/Xzfpum/nf8d/1fwjxaQA==
   "], {{{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1, 157, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 
        33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 
        16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}},
        VertexColors->None]]}, {}, 
     {Hue[0.9060679774997897, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{52, 155, 156, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 
        92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 
        75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 
        58, 57, 56, 55, 54, 53}},
        VertexColors->None]]}, {}, 
     {Hue[0.14213595499957954`, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{115, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 
        144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 
        130, 129, 128, 127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 
        116}},
        VertexColors->
         None]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
        68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
       85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
       102}]}, 
     {Hue[0.14213595499957954`, 0.6, 0.6], 
      LineBox[{103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
       115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
       129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 
       143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 50.}, {0., 0.13981900517431567`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25639118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281227884],

Cell["\<\
Surface oriented plot functions will fill along the boundary: \
\>", "ExampleText",
 CellID->211234082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "<", 
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], "<", "4"}], "&"}], ")"}]}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336555871],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178802559]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9982],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Filling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Filling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoundaryStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BoundaryStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExclusionsStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExclusionsStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7277]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->34],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FillingStyle",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FillingStyle"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->226258893],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->503857044],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->110366928]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FillingStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 40.6554480}", "context" -> "System`", 
    "keywords" -> {
     "fill area", "fill volume", "fill length", "filled plot", "stem plot", 
      "curve filling", "surface filling", "point filling", "fill below curve",
       "fill above curve", "fill below surface", "fill above surface", 
      "fill between curves", "area between curves", "area below curve", 
      "area above curve", "volume below surface", "volume above surface", 
      "volume between surfaces"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FillingStyle is an option for ListPlot, Plot, Plot3D and related \
functions that specifies the default style of filling to be used. ", 
    "synonyms" -> {"filling style"}, "title" -> "FillingStyle", "type" -> 
    "Symbol", "uri" -> "ref/FillingStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8998, 293, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6757518]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 157668, 3347}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2551, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3174, 87, 1577, 37, 70, "ObjectNameGrid"],
Cell[4754, 126, 932, 31, 70, "Usage",
 CellID->17382]
}, Open  ]],
Cell[CellGroupData[{
Cell[5723, 162, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6201, 179, 236, 7, 70, "Notes",
 CellID->23086],
Cell[6440, 188, 719, 28, 70, "Notes",
 CellID->2448],
Cell[7162, 218, 439, 17, 70, "Notes",
 CellID->9262],
Cell[7604, 237, 672, 24, 70, "Notes",
 CellID->7094],
Cell[8279, 263, 682, 25, 70, "Notes",
 CellID->23017]
}, Closed]],
Cell[CellGroupData[{
Cell[8998, 293, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6757518],
Cell[CellGroupData[{
Cell[9381, 307, 148, 5, 70, "ExampleSection",
 CellID->635223901],
Cell[9532, 314, 207, 8, 70, "ExampleText",
 CellID->13140642],
Cell[CellGroupData[{
Cell[9764, 326, 431, 13, 28, "Input",
 CellID->45494168],
Cell[10198, 341, 6166, 105, 137, "Output",
 Evaluatable->False,
 CellID->163138412]
}, Open  ]],
Cell[CellGroupData[{
Cell[16401, 451, 782, 24, 47, "Input",
 CellID->347376865],
Cell[17186, 477, 22742, 377, 165, "Output",
 Evaluatable->False,
 CellID->119260023]
}, Open  ]],
Cell[39943, 857, 125, 3, 70, "ExampleDelimiter",
 CellID->256930987],
Cell[40071, 862, 73, 1, 70, "ExampleText",
 CellID->689609686],
Cell[CellGroupData[{
Cell[40169, 867, 508, 15, 47, "Input",
 CellID->476617387],
Cell[40680, 884, 6768, 115, 125, "Output",
 Evaluatable->False,
 CellID->405580061]
}, Open  ]],
Cell[CellGroupData[{
Cell[47485, 1004, 681, 20, 47, "Input",
 CellID->394843672],
Cell[48169, 1026, 4095, 71, 138, "Output",
 Evaluatable->False,
 CellID->69358649]
}, Open  ]],
Cell[52279, 1100, 124, 3, 70, "ExampleDelimiter",
 CellID->61320466],
Cell[52406, 1105, 238, 8, 70, "ExampleText",
 CellID->135479556],
Cell[CellGroupData[{
Cell[52669, 1117, 424, 13, 47, "Input",
 CellID->318380430],
Cell[53096, 1132, 4267, 74, 124, "Output",
 Evaluatable->False,
 CellID->653483518]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57412, 1212, 216, 7, 70, "ExampleSection",
 CellID->3472],
Cell[CellGroupData[{
Cell[57653, 1223, 235, 7, 70, "ExampleSubsection",
 CellID->423312395],
Cell[57891, 1232, 67, 1, 70, "ExampleText",
 CellID->68209635],
Cell[CellGroupData[{
Cell[57983, 1237, 488, 16, 70, "Input",
 CellID->374327792],
Cell[58474, 1255, 7133, 121, 70, "Output",
 Evaluatable->False,
 CellID->31825652]
}, Open  ]],
Cell[65622, 1379, 125, 3, 70, "ExampleDelimiter",
 CellID->198392416],
Cell[65750, 1384, 94, 1, 70, "ExampleText",
 CellID->410116164],
Cell[CellGroupData[{
Cell[65869, 1389, 356, 12, 70, "Input",
 CellID->70],
Cell[66228, 1403, 4636, 80, 70, "Output",
 Evaluatable->False,
 CellID->43338737]
}, Open  ]],
Cell[70879, 1486, 124, 3, 70, "ExampleDelimiter",
 CellID->24215983],
Cell[71006, 1491, 162, 6, 70, "ExampleText",
 CellID->200504289],
Cell[CellGroupData[{
Cell[71193, 1501, 421, 14, 70, "Input",
 CellID->26059],
Cell[71617, 1517, 4308, 75, 70, "Output",
 Evaluatable->False,
 CellID->192649788]
}, Open  ]],
Cell[75940, 1595, 124, 3, 70, "ExampleDelimiter",
 CellID->28110335],
Cell[76067, 1600, 68, 1, 70, "ExampleText",
 CellID->396638],
Cell[CellGroupData[{
Cell[76160, 1605, 445, 15, 70, "Input",
 CellID->11560],
Cell[76608, 1622, 4157, 72, 70, "Output",
 Evaluatable->False,
 CellID->684092873]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80814, 1700, 233, 7, 70, "ExampleSubsection",
 CellID->21778549],
Cell[81050, 1709, 89, 1, 70, "ExampleText",
 CellID->30883],
Cell[CellGroupData[{
Cell[81164, 1714, 510, 18, 70, "Input",
 CellID->15905],
Cell[81677, 1734, 4141, 72, 70, "Output",
 Evaluatable->False,
 CellID->126171899]
}, Open  ]],
Cell[85833, 1809, 125, 3, 70, "ExampleDelimiter",
 CellID->637116188],
Cell[85961, 1814, 213, 8, 70, "ExampleText",
 CellID->114357690],
Cell[CellGroupData[{
Cell[86199, 1826, 513, 18, 70, "Input",
 CellID->11831765],
Cell[86715, 1846, 4340, 75, 70, "Output",
 Evaluatable->False,
 CellID->414814179]
}, Open  ]],
Cell[91070, 1924, 125, 3, 70, "ExampleDelimiter",
 CellID->590217671],
Cell[91198, 1929, 141, 4, 70, "ExampleText",
 CellID->1241540290],
Cell[CellGroupData[{
Cell[91364, 1937, 578, 20, 70, "Input",
 CellID->1616539778],
Cell[91945, 1959, 4441, 77, 70, "Output",
 Evaluatable->False,
 CellID->69494699]
}, Open  ]],
Cell[96401, 2039, 125, 3, 70, "ExampleDelimiter",
 CellID->426918260],
Cell[96529, 2044, 217, 8, 70, "ExampleText",
 CellID->10234],
Cell[CellGroupData[{
Cell[96771, 2056, 339, 10, 70, "Input",
 CellID->312878712],
Cell[97113, 2068, 2798, 50, 70, "Output",
 Evaluatable->False,
 CellID->69934861]
}, Open  ]],
Cell[99926, 2121, 119, 3, 70, "ExampleDelimiter",
 CellID->839],
Cell[100048, 2126, 68, 1, 70, "ExampleText",
 CellID->21157],
Cell[CellGroupData[{
Cell[100141, 2131, 520, 17, 70, "Input",
 CellID->5668],
Cell[100664, 2150, 4494, 78, 70, "Output",
 Evaluatable->False,
 CellID->93533494]
}, Open  ]],
Cell[105173, 2231, 125, 3, 70, "ExampleDelimiter",
 CellID->786928661],
Cell[105301, 2236, 374, 13, 70, "ExampleText",
 CellID->193365359],
Cell[CellGroupData[{
Cell[105700, 2253, 605, 19, 70, "Input",
 CellID->432086383],
Cell[106308, 2274, 4506, 78, 70, "Output",
 Evaluatable->False,
 CellID->65181020]
}, Open  ]],
Cell[110829, 2355, 126, 3, 70, "ExampleDelimiter",
 CellID->1711066621],
Cell[110958, 2360, 173, 6, 70, "ExampleText",
 CellID->943182170],
Cell[CellGroupData[{
Cell[111156, 2370, 396, 12, 70, "Input",
 CellID->1485932683],
Cell[111555, 2384, 2909, 52, 70, "Output",
 Evaluatable->False,
 CellID->870807018]
}, Open  ]],
Cell[114479, 2439, 120, 3, 70, "ExampleDelimiter",
 CellID->4485],
Cell[114602, 2444, 234, 8, 70, "ExampleText",
 CellID->23592],
Cell[CellGroupData[{
Cell[114861, 2456, 528, 16, 70, "Input",
 CellID->31022],
Cell[115392, 2474, 3019, 54, 70, "Output",
 Evaluatable->False,
 CellID->386627060]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[118460, 2534, 235, 7, 70, "ExampleSubsection",
 CellID->693532071],
Cell[118698, 2543, 97, 1, 70, "ExampleText",
 CellID->679279617],
Cell[CellGroupData[{
Cell[118820, 2548, 622, 19, 70, "Input",
 CellID->234909199],
Cell[119445, 2569, 4095, 71, 70, "Output",
 Evaluatable->False,
 CellID->44238068]
}, Open  ]],
Cell[123555, 2643, 125, 3, 70, "ExampleDelimiter",
 CellID->182344057],
Cell[123683, 2648, 97, 1, 70, "ExampleText",
 CellID->104330996],
Cell[CellGroupData[{
Cell[123805, 2653, 626, 19, 70, "Input",
 CellID->428096184],
Cell[124434, 2674, 4224, 78, 138, "Output",
 CellID->25639118]
}, Open  ]],
Cell[128673, 2755, 125, 3, 70, "ExampleDelimiter",
 CellID->281227884],
Cell[128801, 2760, 113, 3, 70, "ExampleText",
 CellID->211234082],
Cell[CellGroupData[{
Cell[128939, 2767, 782, 24, 70, "Input",
 CellID->336555871],
Cell[129724, 2793, 22742, 377, 70, "Output",
 Evaluatable->False,
 CellID->178802559]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[152539, 3178, 310, 9, 70, "SeeAlsoSection",
 CellID->9982],
Cell[152852, 3189, 1211, 44, 70, "SeeAlso",
 CellID->7277]
}, Open  ]],
Cell[CellGroupData[{
Cell[154100, 3238, 311, 9, 70, "TutorialsSection",
 CellID->34],
Cell[154414, 3249, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[154555, 3254, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[154749, 3262, 305, 8, 70, "RelatedLinksSection"],
Cell[155057, 3272, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155463, 3289, 319, 9, 70, "MoreAboutSection",
 CellID->226258893],
Cell[155785, 3300, 143, 3, 70, "MoreAbout",
 CellID->503857044],
Cell[155931, 3305, 197, 4, 70, "MoreAbout",
 CellID->110366928]
}, Open  ]],
Cell[156143, 3312, 27, 0, 70, "History"],
Cell[156173, 3314, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

