(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95156,       2926]
NotebookOptionsPosition[     82501,       2489]
NotebookOutlinePosition[     84174,       2532]
CellTagsIndexPosition[     84088,       2527]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partition" :> Documentation`HelpLookup["paclet:ref/Partition"],
           "Split" :> Documentation`HelpLookup["paclet:ref/Split"], "Nearest" :> 
          Documentation`HelpLookup["paclet:ref/Nearest"], "FindShortestTour" :> 
          Documentation`HelpLookup["paclet:ref/FindShortestTour"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Partition\"\>", 2->"\<\"Split\"\>", 
       3->"\<\"Nearest\"\>", 
       4->"\<\"FindShortestTour\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Exploratory Data Analysis\"\>", 
       2->"\<\"Handling Arrays of Data\"\>", 
       3->"\<\"Logic & Boolean Algebra\"\>", 4->"\<\"Numerical Data\"\>", 
       5->"\<\"Processing Textual Data\"\>", 6->"\<\"Statistics\"\>", 
       7->"\<\"String Manipulation\"\>", 
       8->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       9->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       10->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       11->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FindClusters", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindClusters",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindClusters"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]partitions the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
     " into clusters of similar elements. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindClusters",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindClusters"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["2", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["v", "i"], TraditionalForm]], "InlineMath"],
     " corresponding to the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
     " in each cluster. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindClusters",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindClusters"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the same result. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindClusters",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindClusters"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]partitions the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
     " into exactly ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " clusters. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindClusters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindClusters"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{
     ButtonBox["DistanceFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DistanceFunction"], "->", 
     StyleBox["f", "TI"]}]}], "]"}]], "InlineFormula"],
 " treats pairs of elements as being less similar when their distances ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "[", 
    RowBox[{
     SubscriptBox["e", "i"], ",", 
     SubscriptBox["e", "j"]}], "]"}], TraditionalForm]], "InlineMath"],
 " are larger. "
}], "Notes",
 CellID->27310],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " are vectors of numbers, ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " by default in effect uses the Euclidean distance function ",
 Cell[BoxData[
  ButtonBox["EuclideanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28327],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " are lists of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " by default uses a distance function based on the normalized fraction of \
elements that disagree. "
}], "Notes",
 CellID->11730],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " are strings, ",
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " by default uses a distance function based on the number of point changes \
needed to get from one string to another. "
}], "Notes",
 CellID->7677],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option can be used to specify different methods of clustering. Possible \
settings include: "
}], "Notes",
 CellID->288],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Agglomerate\>\"", Cell[
    "find clustering hierarchically", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Optimize\>\"", Cell[
    "find clustering by local optimization", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->30106]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->202508092],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->226033367],

Cell["Find clusters of nearby values:", "ExampleText",
 CellID->21889872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "10", ",", "12", ",", "3", ",", "1", ",", "13", ",", 
    "25"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->569529878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12", ",", "13", ",", "25"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172282501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256090717],

Cell["Find exactly 4 clusters:", "ExampleText",
 CellID->91155046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "10", ",", "12", ",", "3", ",", "1", ",", "13", ",", 
     "25"}], "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224096450],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", "10", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13", ",", "25"}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422447164]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->154946119],

Cell["\<\
Represent clustered elements with the right-hand sides of each rule:\
\>", "ExampleText",
 CellID->1439678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "a"}], ",", 
    RowBox[{"2", "\[Rule]", "b"}], ",", 
    RowBox[{"10", "\[Rule]", "c"}], ",", 
    RowBox[{"12", "\[Rule]", "d"}], ",", 
    RowBox[{"3", "\[Rule]", "e"}], ",", 
    RowBox[{"1", "\[Rule]", "f"}], ",", 
    RowBox[{"13", "\[Rule]", "g"}], ",", 
    RowBox[{"25", "\[Rule]", "h"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482481490],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "g", ",", "h"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174841753]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7765],

Cell["Cluster vectors of real values:", "ExampleText",
 CellID->233166546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2.5", ",", "3.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5.9", ",", "3.4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.2", ",", "1.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "7.5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488124990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.5`", ",", "3.1`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.9`", ",", "3.4`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.2`", ",", "1.5`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"100", ",", "7.5`"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->606519053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->954028739],

Cell["Cluster data of any precision:", "ExampleText",
 CellID->225237183],

Cell[BoxData[
 RowBox[{
  RowBox[{"data30", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"25", ",", "31"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"59", ",", "34"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"100", ",", "150"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"22", ",", "15"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1000", ",", "75"}], "}"}]}], "}"}], "/", "10"}], ",", 
     "30"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22000234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "data30", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->483855928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.5`30.", ",", "3.1`30."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.9`30.", ",", "3.4`30."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.2`30.", ",", "1.5`30."}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"10.`30.", ",", "15.`30."}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"100.`30.", ",", "7.5`30."}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{492, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->407486340]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21120065],

Cell[TextData[{
 "Cluster Boolean 0, 1 or ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " data:"
}], "ExampleText",
 CellID->429482735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57822912],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147901267]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->335113769],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1OwkAQXloR1KjgySO+jJ58iIaYwMFokJdRD+pz6LthtwXSfMx2Zna3
SOKS0O5sd2a++Wm7/e6L5ezhsVjOp8XkblE8z+bTl8nt06KcynvG9L6NMTfX
phyvylH1t7+f8l8P69GZPeabqytzBPIJyJeMjPqnke2hfGj4R3vOB2cP8Wjz
m9vDjhcKRVaKo/V5TFix82iH06PQ2HVc1WPhuYoUB6c3FsaPciaqjl3VL0Wc
H5QHK/Zh/tixHuUhESVlL9QPd09L43X5ix2vy97A08++4mnrkxA/fl1LyfYe
sWhMfztf2TLbq1xvuNZlrVbDfVIYfDNA+esudpc3CfoQVDH0pbh9q7jb1ZwV
fFack7nHtzSphW/pHSt+thHxhTIibgfjFwu3z+KsxkaJ17l9FpdllHtV3Non
hKziqIXX6eeBn22Uuf0xhy1OLNpdu9ardj2XJW2W47xxUzelbqLk1E00ttRN
kqylbpJhS90kyRrdTRw/ZFdt+Jp8nSUr4y4N+Zissb5ND/0hj9SGp3nW4Gny
SBI9X39NPy49rko1q2iHyEfrR6Hs0V8z2tirh8ZYo/xWZT1XanXFELsY4a4Y
YKqT7bp3r6xomVnXfAizF+KHYpL2EY+WaR4K/aD86lVVP+bSfZWyJWW7YvqU
Mn5dxhnC0w7Fnikk9XMvE6xuyjK+j57VclAhtpHl6xK3hq28EHnArH+sYty3
mpi1+94Q29wbOyZuzRcSXSsuy5+rVKtUq1SrVKv/XisfrgNZjJzw1vb136aH
3z4h/prrRw49lL+qrNihhAcwvV9GLT9+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{443, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33938093]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tfdata", "=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->391953649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"False", ",", "True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "True", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "True", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "False"}], "}"}]}], "}"}]], "Output",
 ImageSize->{562, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->400947356]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "tfdata", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2733212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True", ",", "True"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "True", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"False", ",", "False", ",", "False"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True", ",", "False"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{583, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->57258019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350061373],

Cell["Cluster string data:", "ExampleText",
 CellID->36822420],

Cell[BoxData[
 RowBox[{
  RowBox[{"sdata", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<GCTAT\>\"", ",", "\"\<TAGGA\>\"", ",", "\"\<GAATT\>\"", ",", 
     "\"\<CATCT\>\"", ",", "\"\<TCAGG\>\"", ",", "\"\<GGGGA\>\"", ",", 
     "\"\<TTACG\>\"", ",", "\"\<GTCAG\>\"", ",", "\"\<TGGAG\>\"", ",", 
     "\"\<GAAAA\>\"", ",", "\"\<ATAGG\>\"", ",", "\"\<TCCGA\>\"", ",", 
     "\"\<TAACT\>\"", ",", "\"\<GTGAT\>\"", ",", "\"\<AAGAA\>\"", ",", 
     "\"\<CCGTA\>\"", ",", "\"\<GCTAA\>\"", ",", "\"\<GCTGG\>\"", ",", 
     "\"\<GAGGG\>\"", ",", "\"\<CTCAT\>\""}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419536537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "sdata", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->539862822],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"GCTAT\"\>", ",", "\<\"GTCAG\"\>", ",", "\<\"GTGAT\"\>", 
     ",", "\<\"GCTAA\"\>", ",", "\<\"GCTGG\"\>", ",", "\<\"CTCAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"TAGGA\"\>", ",", "\<\"TCAGG\"\>", ",", "\<\"GGGGA\"\>", 
     ",", "\<\"TGGAG\"\>", ",", "\<\"GAAAA\"\>", ",", "\<\"ATAGG\"\>", 
     ",", "\<\"TCCGA\"\>", ",", "\<\"AAGAA\"\>", ",", "\<\"CCGTA\"\>", 
     ",", "\<\"GAGGG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"GAATT\"\>", ",", "\<\"CATCT\"\>", ",", "\<\"TTACG\"\>", 
     ",", "\<\"TAACT\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{483, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->657223694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70406879],

Cell[TextData[{
 "Find clusters in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "4"], TraditionalForm]], "InlineMath"],
 " 5\[Hyphen]dimensional vectors:"
}], "ExampleText",
 CellID->304980997],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"RandomReal", "[", "100", "]"}], "+", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", "100", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomSample", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"data", ",", "1"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->80246693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Length", ",", 
   RowBox[{"FindClusters", "[", "data", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7689210],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "900", ",", "2100", ",", "1200", ",", "700", ",", "1700", ",", "1500", ",", 
   "1300", ",", "600"}], "}"}]], "Output",
 ImageSize->{300, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->650254712]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->554518242],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DistanceFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->478502983],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ManhattanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFormula"],
 " as the measure of distance for continuous data:"
}], "ExampleText",
 CellID->291204248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "10", ",", "12", ",", "3", ",", "1", ",", "13", ",", 
     "25"}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "ManhattanDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166822192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12", ",", "13", ",", "25"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516309555]
}, Open  ]],

Cell[TextData[{
 "Clusters obtained with the default ",
 Cell[BoxData[
  ButtonBox["SquaredEuclideanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SquaredEuclideanDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22850172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "10", ",", "12", ",", "3", ",", "1", ",", "13", ",", 
    "25"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->771507975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12", ",", "13", ",", "25"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->451366966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->739228160],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DiceDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiceDissimilarity"]], "InlineFormula"],
 " as the measure of distance for Boolean data:"
}], "ExampleText",
 CellID->148336777],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395023205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "DiceDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34892062],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1OAjEQLqwoasDFk0e8GR9ETz4EISZwMBrk+cSD+lrrdmFh82XKzLRd
DLGbsMu0nW9+2+1OnybL2fPLZDmfTsaPi8nbbD59Hz+8LsqmrGNM984Yc3tj
yv9F+a/61dd9+duRa+rS3rPtKHMC9DnQV0oa8S6U+HnL+Jw8xOfkte0/jNex
xQfpzN5YL9r+bknm8BwRaLYd8ZB/FMhfP68F1lF4ofZhFhzKP1w0u6Jo2lG9
ksT2U0f7WXmzZE/Yjvz9QPl9hxzXeE5+psTbZ79EPqcPlbUaf4fGB9cYV3xc
eC6/xY6PNg5S+/1mEUXbOYverNutNqa3ba9kGEGvVIZGl/5eXXzRu2pU3i8x
oyDX1TdW+khK7ONlunzbTiT1EdP5hZ+bnF0443FXNCB1oVsRa6CUNSRRcRQn
JROh0BbgHpFbD1E2uWcUei/E00OJj1ifxPG0zLMyu7gc71R82pUvJMc5LK5f
luMcCr3q+OW41luy90N4jqMcTm+/HPfzdEiO+63jKcdTjqccTzm+G5VyPOW4
zvMpx1OOuzwbM8e5kxo7CmvA2cb+jJCKtV3kHzX4LY1fERR/c3wtP3fwc/pQ
9jXtwSeOx9p80z7UU2tf067cIZ+j1ycfxeaizubiUFq9ju1Eqe0Tv1B87YnY
yt7W2aHgOpYTMi0/tyrUeJ9eXtOeBMU+afA5CftL+Vq9DiVfaj/SH4VP1mhq
/m1Ux7XyXRXxQ8nX6HVI+RJcim9lifWuTMHN1elD68YcPvdeDcXn5MXG5/RH
/38VMeZ66Nte26/dDWn7tbuhUHztbui7SFFLUfPTKkUtRe2/RM2npkR9b2mq
IdT3oi8/4vjyS6tNP5XXis2lramYzi8YLbi3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{552, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->237060734]
}, Open  ]],

Cell[TextData[{
 "Clusters obtained with the default ",
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->486847666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->189917055],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtOAjEQLbuiqAHBJ58EE/VT9MmPIMQEHowG+V/5k3W7uF4OLdPTC/JQ
EpZOL3OmM2eX7szTdDV/fpmuFrPp5HE5fZsvZu+Th9dl3VV2lOp8KKVurlTd
rupW89Wfdf3dNDetc30t29FKHYF8CvIFKaM+lM8C8YckPuKx+0O81Ptj/Yvx
TB2/Ul/EXerxohaH8Dty0K7nsfpHFv02fTb7LhPZZ9t/qw+j6Os/lAunaOlZ
3VrE/mNL/0l90WLXsV+ysufgdQavF2gf2sPi2/xmsyvUP7HiZ5svPcNs/kmF
78dyk6zvKdxN26+tVN3v/gZDOYz6Ym7tyANbj/Yi2W2yM8Qum5/t9sbwZNyo
u6CZ/h92+y2dLfJdI2nBexTPC32jjeZe6bnXF8ZLAmsQYBfaweCif8x2hHrC
Lyo4C7UMnPYdB0tiZ6fRwz7TQ9jJ6nZ7ZoezU7KDwXVjZ6gn/KIiacU3MfO+
42ClOXFkdu7WldmZ2SljZXZmdmZ2ZnamZKeUJdezMD9XfqGXDn6W8ngF6JP0
oz5cf1H95A9j2Wfbv5bxtI951QLmS+slezdZad1cB7dYxsTOuLMVi0OriITq
P7SKx1hfNgwjVrEVAKlCkarCwa5PXcFo9U28vM5mwtl+lDEz75OJ/0981i5f
fDbj71uJ2Hf8Ub6ufFjL5qiZ/tjzbNXPfeIzdoXg+9UzfGsE+2SBad242V9B
rpYy0ZIs5d4l/dLpJ1S/hMfqd3trYTP1saOAUb5t7Ax9roWezNhx9mTMjrMn
Y0m/Hzekt+nYUUD5rsrcyNwwy5kbLvZmbmRuZG5sc4Plgikr+fsXTzmmrKkp
5+K7HvUw60v1NzvqmlVl9o/+u2+8rptrh5bqfAK/NjyG\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{479, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->242896979]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171113641],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["HammingDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HammingDistance"]], "InlineFormula"],
 " as the measure of distance for string data:"
}], "ExampleText",
 CellID->201999173],

Cell[BoxData[
 RowBox[{
  RowBox[{"sdata", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<GCTAT\>\"", ",", "\"\<TAGGA\>\"", ",", "\"\<GAATT\>\"", ",", 
     "\"\<CATCT\>\"", ",", "\"\<TCAGG\>\"", ",", "\"\<GGGGA\>\"", ",", 
     "\"\<TTACG\>\"", ",", "\"\<GTCAG\>\"", ",", "\"\<TGGAG\>\"", ",", 
     "\"\<GAAAA\>\"", ",", "\"\<ATAGG\>\"", ",", "\"\<TCCGA\>\"", ",", 
     "\"\<TAACT\>\"", ",", "\"\<GTGAT\>\"", ",", "\"\<AAGAA\>\"", ",", 
     "\"\<CCGTA\>\"", ",", "\"\<GCTAA\>\"", ",", "\"\<GCTGG\>\"", ",", 
     "\"\<GAGGG\>\"", ",", "\"\<CTCAT\>\""}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374390573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"sdata", ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "HammingDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331039916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"GCTAT\"\>", ",", "\<\"GAATT\"\>", ",", "\<\"CATCT\"\>", 
     ",", "\<\"GTCAG\"\>", ",", "\<\"GAAAA\"\>", ",", "\<\"GTGAT\"\>", 
     ",", "\<\"GCTAA\"\>", ",", "\<\"GCTGG\"\>", ",", "\<\"CTCAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"TAGGA\"\>", ",", "\<\"GGGGA\"\>", ",", "\<\"TCCGA\"\>", 
     ",", "\<\"AAGAA\"\>", ",", "\<\"CCGTA\"\>", ",", "\<\"GAGGG\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"TCAGG\"\>", ",", "\<\"TTACG\"\>", ",", "\<\"TGGAG\"\>", 
     ",", "\<\"ATAGG\"\>", ",", "\<\"TAACT\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{543, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85115265]
}, Open  ]],

Cell[TextData[{
 "Clusters obtained with the default ",
 Cell[BoxData[
  ButtonBox["EditDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EditDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->263107730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "sdata", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->274678518],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"GCTAT\"\>", ",", "\<\"GTCAG\"\>", ",", "\<\"GTGAT\"\>", 
     ",", "\<\"GCTAA\"\>", ",", "\<\"GCTGG\"\>", ",", "\<\"CTCAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"TAGGA\"\>", ",", "\<\"TCAGG\"\>", ",", "\<\"GGGGA\"\>", 
     ",", "\<\"TGGAG\"\>", ",", "\<\"GAAAA\"\>", ",", "\<\"ATAGG\"\>", 
     ",", "\<\"TCCGA\"\>", ",", "\<\"AAGAA\"\>", ",", "\<\"CCGTA\"\>", 
     ",", "\<\"GAGGG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"GAATT\"\>", ",", "\<\"CATCT\"\>", ",", "\<\"TTACG\"\>", 
     ",", "\<\"TAACT\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{483, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->50255087]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5405018],

Cell["Define a distance function as a pure function:", "ExampleText",
 CellID->152413854],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "10"}], ",", "10"}], "}"}], "]"}], ",", "1"}], "]"}],
        ",", "5"}], "]"}], ",", 
     RowBox[{"{", "100", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368987804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Length", ",", 
   RowBox[{"FindClusters", "[", 
    RowBox[{"data", ",", 
     RowBox[{"DistanceFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{
           RowBox[{"#1", "-", "#2"}], ",", "5"}], "]"}], "^", "5"}], "&"}], 
       ")"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->80558366],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25", ",", "15", ",", "13", ",", "10", ",", "18", ",", "19"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80160781]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->293299345],

Cell["Cluster the data hierarchically:", "ExampleText",
 CellID->308264702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "10", ",", "12", ",", "3", ",", "1", ",", "13", ",", 
     "25"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Agglomerate\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68860908],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", "25", "}"}]}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318995503]
}, Open  ]],

Cell["Clusters obtained with the default method:", "ExampleText",
 CellID->362886188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "10", ",", "12", ",", "3", ",", "1", ",", "13", ",", 
    "25"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137032996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12", ",", "13", ",", "25"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83612655]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RandomSeed",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17625882],

Cell["Start with a nondefault seed:", "ExampleText",
 CellID->171379349],

Cell[BoxData[
 RowBox[{
  RowBox[{"sdata", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<GCTAT\>\"", ",", "\"\<TAGGA\>\"", ",", "\"\<GAATT\>\"", ",", 
     "\"\<CATCT\>\"", ",", "\"\<TCAGG\>\"", ",", "\"\<GGGGA\>\"", ",", 
     "\"\<TTACG\>\"", ",", "\"\<GTCAG\>\"", ",", "\"\<TGGAG\>\"", ",", 
     "\"\<GAAAA\>\"", ",", "\"\<ATAGG\>\"", ",", "\"\<TCCGA\>\"", ",", 
     "\"\<TAACT\>\"", ",", "\"\<GTGAT\>\"", ",", "\"\<AAGAA\>\"", ",", 
     "\"\<CCGTA\>\"", ",", "\"\<GCTAA\>\"", ",", "\"\<GCTGG\>\"", ",", 
     "\"\<GAGGG\>\"", ",", "\"\<CTCAT\>\""}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156881691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"sdata", ",", 
   RowBox[{"RandomSeed", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->819176424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"GCTAT\"\>", ",", "\<\"GTCAG\"\>", ",", "\<\"GTGAT\"\>", 
     ",", "\<\"CCGTA\"\>", ",", "\<\"GCTAA\"\>", ",", "\<\"GCTGG\"\>", 
     ",", "\<\"CTCAT\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"TAGGA\"\>", ",", "\<\"TCAGG\"\>", ",", "\<\"GGGGA\"\>", 
     ",", "\<\"TGGAG\"\>", ",", "\<\"ATAGG\"\>", ",", "\<\"TCCGA\"\>", 
     ",", "\<\"AAGAA\"\>", ",", "\<\"GAGGG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"GAATT\"\>", ",", "\<\"CATCT\"\>", ",", "\<\"TTACG\"\>", 
     ",", "\<\"GAAAA\"\>", ",", "\<\"TAACT\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{391, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81501062]
}, Open  ]],

Cell[TextData[{
 "Clusters obtained with the default value of ",
 Cell[BoxData["RandomSeed"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->202550871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "sdata", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->324650839],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"GCTAT\"\>", ",", "\<\"GTCAG\"\>", ",", "\<\"GTGAT\"\>", 
     ",", "\<\"GCTAA\"\>", ",", "\<\"GCTGG\"\>", ",", "\<\"CTCAT\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"TAGGA\"\>", ",", "\<\"TCAGG\"\>", ",", "\<\"GGGGA\"\>", 
     ",", "\<\"TGGAG\"\>", ",", "\<\"GAAAA\"\>", ",", "\<\"ATAGG\"\>", 
     ",", "\<\"TCCGA\"\>", ",", "\<\"AAGAA\"\>", ",", "\<\"CCGTA\"\>", 
     ",", "\<\"GAGGG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"GAATT\"\>", ",", "\<\"CATCT\"\>", ",", "\<\"TTACG\"\>", 
     ",", "\<\"TAACT\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{483, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->47722]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16975],

Cell["Find and visualize clusters in bivariate data:", "ExampleText",
 CellID->173426724],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.1"}], ",", "2.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.9", ",", 
       RowBox[{"-", "0.8"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.2", ",", 
       RowBox[{"-", "3.7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", "3.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.9", ",", "5.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.1", ",", 
       RowBox[{"-", "4.8"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.8", ",", "3.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.6", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.1", ",", 
       RowBox[{"-", "5.2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9"}], ",", "2.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.9", ",", "4.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.3"}], ",", "3.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.5"}], ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.6", ",", 
       RowBox[{"-", "5.5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.2", ",", "1.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7"}], ",", "1.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9", ",", "2.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.5"}], ",", "3.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.8", ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.6", ",", 
       RowBox[{"-", "5.1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "3.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.7", ",", "0.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.9", ",", "3.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5", ",", "1.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.2", ",", "1.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.1"}], ",", "2.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.8", ",", "2.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", 
       RowBox[{"-", "3.5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", 
       RowBox[{"-", "4.6"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", 
       RowBox[{"-", "4.9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "3.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7", ",", "2.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", 
       RowBox[{"-", "4.3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2."}], ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2"}], ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.6"}], ",", "1.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3.5"}], ",", "3.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.8", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", "2.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.1"}], ",", "2.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3"}], ",", "2.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.4", ",", "3.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.5", ",", "0.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "2.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1."}], ",", "1.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.4"}], ",", "4.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", "2.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.6"}], ",", "2.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.6", ",", 
       RowBox[{"-", "5.1"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177473525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"FindClusters", "[", "data", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72316041],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{-1.1, 2.6}, {-0.9, 2.3}, {-2.3, 3.9}, {-2.5, 3.}, {-0.7, 
     1.3}, {0.9, 2.8}, {-1.5, 3.3}, {-0.8, 3.2}, {-1.1, 2.6}, {0.7, 
     2.1}, {-2., 0.5}, {-1.2, 2.}, {-1.6, 1.8}, {-3.5, 3.7}, {-0.1, 
     2.1}, {-1.3, 2.5}, {0.1, 2.9}, {-1., 1.6}, {-1.4, 4.5}, {-1.6, 2.4}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    PointBox[{{3.9, -0.8}, {5.6, 0.1}, {5.2, 1.9}, {3.8, 1.2}, {4.7, 0.7}, {
     4.5, 1.4}, {4.2, 1.3}, {4.8, 2.4}, {4.8, 0.2}, {3.5, 0.2}}]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], 
    PointBox[{{4.2, -3.7}, {4.1, -4.8}, {3.1, -5.2}, {2.6, -5.5}, {
     2.6, -5.1}, {3.3, -3.5}, {3.2, -4.6}, {3.3, -4.9}, {3.2, -4.3}, {
     2.6, -5.1}}]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], 
    PointBox[{{3.3, 3.5}, {3.9, 5.2}, {3.8, 3.7}, {2.9, 4.1}, {3., 3.}, {3.9, 
     3.6}, {3., 3.5}, {3.3, 2.4}, {4.4, 3.9}, {3.2, 2.5}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{-3.5, 5.6}, {-5.5, 5.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->670555867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146195537],

Cell["\<\
Cluster genomic sequences based on the number of element\[Hyphen]wise \
differences:\
\>", "ExampleText",
 CellID->441656661],

Cell[BoxData[
 RowBox[{
  RowBox[{"gdata", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<GTCTT\>\"", ",", "\"\<AAGCT\>\"", ",", "\"\<GGTAA\>\"", ",", 
     "\"\<AGGCT\>\"", ",", "\"\<GTCAT\>\"", ",", "\"\<CGGCC\>\"", ",", 
     "\"\<GGGAG\>\"", ",", "\"\<GTTAT\>\"", ",", "\"\<GTCAT\>\"", ",", 
     "\"\<AGGCT\>\"", ",", "\"\<GTCAG\>\"", ",", "\"\<AGGAT\>\""}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152564336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"gdata", ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "HammingDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172707271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"GTCTT\"\>", ",", "\<\"GTCAT\"\>", ",", "\<\"GTTAT\"\>", 
     ",", "\<\"GTCAT\"\>", ",", "\<\"GTCAG\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AAGCT\"\>", ",", "\<\"AGGCT\"\>", ",", "\<\"CGGCC\"\>", 
     ",", "\<\"AGGCT\"\>", ",", "\<\"AGGAT\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"GGTAA\"\>", ",", "\<\"GGGAG\"\>"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{359, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7454762]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindClusters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindClusters"]], "InlineFormula"],
 " groups data while ",
 Cell[BoxData[
  ButtonBox["Nearest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
 " gives the elements closest to a given value:"
}], "ExampleText",
 CellID->257695094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "10", ",", "12", ",", "3", ",", "1", ",", "13", ",", 
    "25"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177207225],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12", ",", "13", ",", "25"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147396759]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "10", ",", "12", ",", "3", ",", "1", ",", "13", ",", 
     "25"}], "}"}], ",", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19791519],

Cell[BoxData[
 RowBox[{"{", "10", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31771685]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "10", ",", "12", ",", "3", ",", "1", ",", "13", ",", 
     "25"}], "}"}], ",", "11"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->226612713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "12"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->426125619]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11214],

Cell["\<\
The order of elements can have an effect on the clusters found:\
\>", "ExampleText",
 CellID->215918777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5", ",", "3", ",", "10", ",", "100"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20119668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "100"}], "}"}]}], "}"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243108895]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "5", ",", "3", ",", "1", ",", "100"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137238055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "10", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "100", "}"}]}], "}"}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40687799]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14773],

Cell[TextData[{
 "Divide a square into ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " segments by clustering uniformly distributed random points:"
}], "ExampleText",
 CellID->27619387],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "4"}], ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->276728907],

Cell[BoxData[
 RowBox[{
  RowBox[{"plots", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"FindClusters", "[", 
        RowBox[{"data", ",", "n"}], "]"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "9"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38730789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsArray", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{"plots", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->192950076],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytfd2THLeRZ7mrqj9mhjOkJFuy72Uf9m0fN+J2X6q6Z4bUF2VrrQ+OSMqm
JUoWqSUpiSJH1EprUrIsaTUzJIdfU9WUL2w/7D3c00Y4NmJjIy4c4T/MByCB
RCKRqGrKp2gVu7p7CkAi8ctfJoDEj9+4cu7ti29cOX/2jb955vIb7587f/bD
v3n6vcvqo/x7WZb9Uf//VKbe/0W9M///8S9/Uf/CtVDX/6k+LNW//2D/1fe5
+dZcc3V79cp/Tqs2m+hLPqvn6t+N9YdZbu5vbG+1u5V6ZUN9yR/enNn70ty3
exX9vmiPftNWt81rf6D+UR9X+3CrXn/e/b8Z1MuUrErwJT999Lf2vjD39c6Z
qj2hXtkhfcnfvPeCLWkZinMlq9fv7z1Pn5tokX3unVP2uaV57uzha8H9C81L
tpyVqJw///euevwglB8UkK2Zpzc7NfyBEk0onwKERp6m3mcD9qsB/OrcW06K
WnJZJMnb8+qOIMk1Jrk1dRmyVuzZK/Sn1hnzH7SKPOuwuhxRfy/WMMfHRC2A
ds/VN+bR2fdCaQV9Pq0ac9+AthXvnr3Q7uinNHsVPLfZsTUG+S0F7YCf7vo3
5m8OtU9/iXJqgjf2qkUqSG9slQ/qpKulawVaUTUnrEyX9KWwBZurafGE9myD
NTNNsTJKy1qWRn39HJSpCh+wWkyMwrLmg4zGsVy8RDVs6B6Re6XkEmgHrjrw
YTawWu56ZQBds8f6IG+gh/asPpTNrqj3P74BnQIanrvuMff76nv40vVViTW1
choEcoPaDWy/mc+rr87iyFaXLRSgepMVWrv1G7l2Q9skFKLVycLLO9ahhARL
lKB66SJH0J+uRtnQ9W9DRhnR9rhLpdoMxF49bKTRYo/YUbIXPhihIfzE9p/9
1KI7dI3SNItIflxBd8m4VN38udXeZTOGaH8UtBQsuwx1BxqZevrdk/bpQybb
nJbWnFAPzmn/kgItZqNEUZdjLCuILjZcD8fkHiS+A4JsCEaOhN7dQzv6yscI
/0bWOaJ/hve2Vv31GdlK6fvq1utGTiAdfR1r+Yz0+9b2BtjaZhd7X7ZaIQpw
fOuXkKpWU395llUnG0faMRRrkQu16Ma3ob14hIdrgahG+53ZtJVGtD109FS3
DI6NcFygBWqgy+J+47UrsVKhLTh3zfXO1pjZggH2n/nIV2rPWoQInwcovo6a
CHLSdRmw0TVitTGjrWSSCTU+so6dtmkd+FXBNCgP7q2cbB9iy/Nmz2nHMnTk
O5ZZQUcUhCLsF84GJaSSSzXgUqoevMbxRzOGJdMPFGcRE3hpC7ZXjyhuRYxm
lC8cvOTHyY6TBEO1odUJ2XrQsWss2IrTTU3R9gIZj5CyBTiWo+ZBRerbZmyU
MBiQoGWDxnNbJGkCyuumL6s3SxbiiS037y3KK3wP0RytB7R71FCTbt6gTYla
vWwKrs99bHV7zHnEluMRFJ12PEYWWLru8UZgFYI/Uc2RSURoYJC8tKWgrpuy
Jg0bXaRDiAUyhiXiW+Fo0C9gYGnOGjGdpgQ7fHACTEnGkaKIWVi7lQ0cHfJ4
QWq9V5UR9gccoFNaZgyNkHfQjrM4xZQI6rzsuQKqNrPSpaBb3bansDo1cpYP
Nc3rgtdYUEzGf9CzVB1WUBszcOYFgMz0bl//ufqE/dioRpdof51YSqv8AX9G
GOD44m2O6y4+lgNZ6IFdb7/nbYdlAtgnw0hvCEePbPIAfZDQZxV6J2AoSxLe
jg92phRLUQGkNpt+KQm47TvPxvRFiQxZ9D+bbBXGD1rSUho/5H7gvXOnplFU
BjUqyRWXwnFcHWxxq+L1wVUtZ6V6vSW+uh0dWYhwQ1o2XFeI5Jvd2kaafBtK
+vRzb2UhHwZf0Xw2QvBCcyLJmXNR7X0/AbEfZzktojLGGSAA9w1SrdM25Ego
Qac/nc/nPSejCuckYLG0kSa2PoxNhFdnp2c32wD5hyA/6tiFuLMvWU2R5/MI
Sk4tODGkRr9HqEWBJQD+2ETtkPxBLhNdh2Wq0w1yZo/+xOdhfrWPaQSxvATa
W3uUR9ZxmVpuZFA8Shgg1ztvGZOs0b2w/aL7IO9E9kYoW+NsLo3qHL0+i7LH
H/yUyR141AAxTyg32WaD78Pq/kmUMrEnpOyRwxRt65CyO/m4svvta86iVUXE
CrYe/AT6vlhvX1H/qhHvInjjJlQ7NyT2Bby5rdiWQxkaaBQRh0tGXRvjYa24
CF/AJ5k7nEO4j2iqxxHg9yCjHc3EkatgHy4QfUxKbhkrkapctljtsuLSr89V
inh+3P70X38zUv8orP3XbzqRLUSSBnxScq9rCJELi9osdhR5Gxg7Gbi5CWZD
Ihn1xhuhX89Xv2mrD9Srbk6sRlxl1h7L8o22Gmy2Sg7qzaZ5/fJ+xcd+LvXT
WN3fqD5VT9+prqnioLBb1VVV4w+y0Z3qKpQNH8LPTNyfWuxf3cqNzKf/cgC9
kB1Sl+7xtIbczCgpmYUxLjThmOg1oHR1BMR7EinGY1l7fr760tR+W3fXB1lx
4bwPCZFYh9c3NXY3QIpKnHkoV/Wm0J8MvaTv8VgtiCtbVRfuowydF4mmwv7i
8y+J5NTPrjVwD2+Ssdcly3S1tg5ZWwzPKh4wyyuxGy5rOSKu5Jit6Iblm3e3
rA9W+PbYYnUthlpCOUoo4/dGVyXEsJJb0pJrqveNDubr91yLStZCXdYTRvOU
mOLRHo2vko2vQWhRassRSH9NDAdm/tB++Mm+taEhIkRYDaPMaEU2vL51nqGd
9lNNj43W29mGUTQtrcYqnZVZKMNcfd0r1xLlql5KqDAKlG/+vpW2kXIB96pe
tbUJ5bkvjrcXK3jdf0/z5otqJBz/aBc1c+JkD7eZQYHC36e0VphXsb6anz0d
MxsOPeMn2MBK0l4h/s/thiMIRwjbdi6LkbnXvUNn46bt8Q03+legHxon86JH
lwdc2urt2JWyfm9r58MNNaouVoeoLD9W9iiNoJYPxZ4+vK93zsAMyJJoWc9f
+BAEZCQ4DmHUE/Kc+f2S9A4ZEWLbVINm92lcJogfGy2fNsc3nW5rrS4BHpw0
7ZumKkG0KGVS9pz0lC/b6nYg7ZdPZstaZ/PG6PD6tXtGqhG6qmup/hmofwey
1Bez1Pa+Pvdx5EsH7Bjn5w6mgTbzORiPOc474tHjAvtCNTlnmsbvC3cPBjD0
k9oTSsmhUySkofemb8YbDcEn957ajXS/CHWD+/adTYAbNS4vVgPVbYXpv+vv
b1nruMr6rxtnjE80REwJbBSPdMT3+8d2aO+MWk7H/cxysHaC+K5krKyZAUP1
VY0VynVpF2SHjMxxOGSGhZTYBzAk5PFYYBnNu7MR0X/9dkDutSiXrd4P01aU
2C4z5oqr1WcwChRzC+fS0Mses7inerN1/Z2mRj/TOJ4oriLt+aMKjVNI/eze
ST/CNtp6g2qtkp29N7ayoBIcOC6Xe5wRLWhnPazmvnxSkHCjDaaxmtgD6pVb
ma91y7zxXCgr69ADgqg2wRMeywMNVzKnPiXzMZENFuK8iB25mq/o5mpbqz9A
ngA9vt5sbFiGp+VpFNVKXFvKgVHeLnmugvzenTn5KVENRa09c2XbosCalSAQ
DlF6hElm+YkbPxPnfvV1yTG83Af1BiTSin44MmVxjjXQSsatyP3QXNS9EuCN
a8eOOkNYMozNRb2k2ux/nwnWcdxhHdsLtZVrHuqmeqPxYpSwkaM0IxFQXZcH
FufZm27lBJ/LhVVGeH/j1c/djN2AxaX65M7tySEnZ9v+My+ohj1zUA3Bd2s8
CoCMBw5k9a16O+lhdbylenCUTGsn5l5xOau1A8IxBpY9J7hG0GtD6w0ZtKu9
X9JlwSj/OP/KjoHbcN1AoO2y59ftNai3S0ArLujmfvZxddRyh9EmkS/6MbEH
w/G3WdSDQYmU8IH9UvG9sYQcJUXfC5fPm57wXLvNJouxCtvyZSOJY/tuXSfn
ekOv1TySNao+2a5OtTeO3Q04hMj25BisrcNjoaVvz23AWH7/c6bTQ2rxNgx+
LAGXIH0kcQmLy+dnbWzXHENTI8wBB165bJf0paSyZTM2gTUAa6f0/JXPf+at
nTQzJaxu++cvlWzVS/1eXYZbLx18fuzOJ0/ffVDvH9S3D6zHo62dur363D3B
2j0OrT63YVtprHd5w+g2El2juUNgwS1HEsBoxO8kWz/EsLjoYGr+e48mI+Z7
d/iLFBPLjbt+HRYyCZyN1S+MRAxRovp1Wl2bHMRr3gufnGpTrDS2iW8foy1d
ojr0Gco7sI8BrnjMoBiSZMWm/AtYnvMtBtbmZbnCBYLTVIMHTNIFuc+SKAHx
U2aBA7toogx+hUfASvhsitd40PCRvuQgcn8v4iaA/RcOs3OLnUPaKwo5nTSo
3p392sbuygDRG8JHNkl0qtc/6ZJJ2TEeGmF8GLzL648PbK+UrNcSbEUYgz6a
yaUezFSfvZU9Lkm5IFJmkcEvVBkTaJchIEkcHVncDkFEKbzgeXeyad0i7vON
bM8aER67tg8CW+vFC27xc8KpgMEqyVy/dgx65sr1ZyphXcHP7ynObXQVESK3
CttYVDndIHSAxgydRP1KLozljR112QfxWh16+eSqs0ev3A7kOJSYdBhxamau
5EOm5K+pbypegYpqs53o1QmVufr3+vtb9cfNAODjI8+sPZZcbQBrjFdzIeET
Ui+CsE+437/koieGBRW/2db3ul8+2R5q+a54aRMAR2yHbwtJx3PsEbPMxK9C
ob4RrhC6UCu/S7Bm2tNQkAJS1xZSdwvMW7numm7svDjYPJhlxez6GxbbgmjA
bRIxYP5suGZpWRgF2aFfvb91/OpO9cseIRgG0YceE8GuHYax8Ms3bd1LfRn7
Mmgx1nbakYHaP4J2svnfUMJkVcqK07QRmk+woD+5q40oRepayTTL2Wgs3H3M
VG6TODHKej+QdYOjU9dDixu9oCtv6w5UGq25WCyBkrVdtqIcg4bwoUNTaxtW
bJk1aDeUWfgCTzUrPVqN+LLENJstJ5VYWu4iFt7PgEKz1c5SyYptGneYkG53
b954WT30xbvOzh47CPyrLJ6jhFH1dFsdXJxCZQaMMSwtoOHR3AXDHRtPwNgX
jXU15qWRaMI0bixJZUy0PkJ+N+/jd/JY0VyozKyU1n8c77Z9vr2gYhOp1AnV
c1ZwJpVsV9q9fvoolb+LfoGtOfPGNvVDWMu7bS6PLloJvyt5YQ2yIMaKJo1X
wpbhG8il5J8WlYBElD967OdzcO6e1aZJ+TAT6o2b/uqtXU76kvFKMbqZextF
EbQB3Lp91Fl+HnUbAcm69cJ3kFiHF0Ai8tX7MG8Frkib7MeSSXKNadJA0uYl
2l9MoV1MjVmR3FmPHIcs8kVXp5ogBpXDqXRfFNG6vnEbkagXd56nEaANMiPI
Zj5WhNYvEjnTkZpDBJPgBe01TzONmFBrYcoQOdAwxArdgtzNkzKpOptMexFL
wnY4ve7w2gLcoWv0svwoxtl5XM1YgwnGitGdQFacaPEiEs1bwScwcWbnzjcY
+WTjfmRZERtHQ1GzGRINY802Mp8Qax3oujHlEgMsD7Q+e/qXlYuUL/aJQRyy
MsnMAtJZdCXtCfM+8ihqRIXRJwsZYwqpT9y9w5KSoa5dzUFi//WAlc6ZImcQ
ovaOmc0IOKJDgYZ9e2Gap+s4Yp+eeXMb8bcgaNSIMRCOTHQn0H7MMDy/9Qa+
sdE8vuaD9WqH5PrtvjhPRJgVtw/yDJlDmmBU0XjRIlpd8rlswnvUB8ev+f4R
Z5c9/2sv1iWrx9jpUDyPQyy5sE/bez1ktv32UWcmRAy0PYbxKfQy1SuqGZfQ
Yv5Ibq15Hegtn4UYOhYcRE5FzrUUjx9KSovQuqorx1qYwetgLEnZ5608PvKg
zNsY3Y5WiITjI4gGrt94E3SyUwKyzHm0Q48V7t2X1g8zQ88+8PAi3pefE6PI
HehdY36WHm+Uv9WgUFF8tvwr64L25iiNBPr4a8CaiNfvuNtqGoHm8gyq1nQR
f6mNHxKbbsU+inpZ5Koj0U4IcRxsvfnUFe94K9RCvbl94Wlai9LSLRLYIW8C
3jrHiB6La1HuBTV4/9x55FF0hl5HxMtI5/18ptdJWTrdtgHWMDQYQR4y3eMx
icLa0to3+XTsiwbW/rS5b3o0FLmum53X93zWW/T57DxhKvblR4gNv0kxP8O2
B6wGMC6OPbArZsN5iSZhqYM5UajQItLpHj8DZMLCigvsu8NtGBeGjy1ehwEy
J5EQr6nNdhpqMyERzCaeF9eOkoxper3y9htZVz2E8TsPS0PuRGtCOVZxtKlx
Rk/PQuOqCzev6nqLMsxeuXT5K4G9viitB2guxmxK2+/DBMEFPyTwqqMYHvEM
7P3bPxY8e2evxbIidsajhXmIladuvDzeDOY2UNYsPqheq67E2esPe9gOWWXw
8knuU/GoW16ReLedbfAg1GcFjdUtqHRDvuPtQTfmDFmtCjDJNN6PI3uROuWM
lTJG9PSD2cDFXMOZUrsKLltW/IfqcCwaU4/++bgcnHBcJyvPinYwckAfreDW
EQ6NI6yciCUl2nBmHQbcgt523Ynj4cJUtlZjGjNuod9IucyziphtX+2MXg0p
0SBjt6Rs41jjdqswLkV8B8CtgcOvYvNgtpD8Er3771tfzKvLZm5emfr6g6a2
ayzb+rK+Hn+zPb8+v1jNL1WD9pLSpeZS3VyqWv2q4f38Ut3qq/0w078bqM+z
p+bvzb69vKm+P7g0O/PGR8Jkl7nWp9v1nz185s3fTl+fm2/nMJOibr+e/4la
47mTYN7UMBDmtffM/q5x9/pVO0f/+LX5u8doJd37mrZFV/Q99Xm98+5xrEF1
ao6zlrUhePXp+fFf/u7Zs/9LvTG1n8NXFz7/j4DX/eHFb+cY9Z2rukB1ar8K
aG4aMreau/ze+XfcxEqtmLPu6nmtbo/O7YcZ9vlTx+az577dVN8fbaeb+vt6
48Fs+sF2OLxVtebdcgXc7c6k+MfEVX/7j7bF/2D//ccYy194/nd6GfxTZkNc
kG9gr8p4FhXMPLAn7hjGXYTzvZp7kXbN/ZOmnPNvXvory0nuBoZEjtnjZsfF
zV8/a7OOyTmcOrMLLtA6eefN9/n+JZctrSOTlZD5iX+/19Fqstec5xbwO5Db
u19tkpxqrC7m02WWi85f++tgW28kX3x06Re42TzOofJd2969Z5Tt16OZ+MgO
v4GQJ2DgEhXhBl6xdlLONP1dE2a5cn8tRO47dwnxPcfh/vHgr4b7vznGthwn
ciGu8DrHCXoS9f1Oks2GesyFMjIaM4xl9+gy7e5/nkOF57CC+/v/to6ZCPdY
1j/MJpLKzjfyvyYplORcnlF2MF8Ts5u8eO3l61AT9/SCZocKMh+Go3TBWnB5
QIY3XequkOPg/48kElm8GsD9rz59UcAAn8dIzh+DCJT155P5AezpdvYl68Dd
FZ4/L9rFr25FtAtKNHg3jB/hx6MrZvSIrevIuRLnuSDaBvkWfY12g9QuQV6y
PSvzIM8w/V0aE7hOj6Zxvlazo3psrTCRKtGjoonKjHWzD58SMsHdr/6qNNDl
jZOEkz2KdPozgvCMeWEWDrP/sOjWGTFLwyjWUz+aFu+xQWBfUlhl2lHc+3oT
6xTXUsgntMMzwLmsNuZHAlr1ywv0HLXJZvqi+clgtPN8umWPzLr78SnoJeRC
e1F+L5qH0OsI5FDLnXQ4akVswLDGCKlWaBsxw1jMUdO9/gRF/RABA8Y9fMRW
sFVh69M5FIj5GqPsfJD7cwc6pCHqYyxx7APQsdik0D+R8yrafb2K90F6bCmR
qugFBPruW4Gmi3rBPbIwmk1GCzOkgV3cS/hHNmcQaYTN2fv8r2MfrzNL4SEn
LTqqclqXHXCfWHrEgdXFUY/+xZkaJ1MBh2K7GNZgKa4BBZiOrH+drQcMRjVo
rLfyCO23mQBtxmQ3Kx4xIagFyzfn7CbIX2h9khOls93xfHOHWHm0P+59PWvj
vNPpEgmeSiws2UbIrNLwEsL7RHZ9+HB9L5z724+1PNAmX7bEgict5RUsk2DZ
hDrW63VLGf0i3p3f+vUztseGidJLwPqIqy1espRFcqWrraZXIaNS3iXfmMtP
4hzUPqtfjPLEd6Fcinn/KZ6trf9jAaPTLxyNmR+HfpC6hnZEO0oK/wGCY1u1
9bToG2fk62mvlfj6no8zs1zDXXocc9oj6p8RHYu7qDO7vm6THp3JpzFPN7k/
SzzxoYYcpxxp5GyBvi59liBukSm3uPvl5taDn6hyX2heGkrtMyPyuS8QYHHW
RU8cLHCmRJShktueB//mzpUJ4o57GPeh3DHM8c19A4HZ8jpIeaawR2y+s8Jm
FnoV1Ynn0mRV2mN1X4AZJmUDR7jY/W4+Kyn3zgJEeectKYsEWf/qc9Ownjq6
8XDq+L+ccZrLrtTRL6Rje+jls9zWyCq91LxB6UaeTq1lUdUp5FQyuwGXfDZA
WhknslG7K8XopNIXlorOJ2T2+0/evP9CoBuoIefeMtNbZgWRkKR20DuKZE+x
CBA5/M7YvOUvP/0nD5vRGCJR3zB786QhA6qVMFqOpQosW6ydldqoCvJK2yOe
gvhbgPpDh0U0fXo02jtkNRZrU938uem/8ax5lUvIsMqcrO4mKyjIWubODEcC
0lBfu911p35Q4xVgyU7MCR8VW8TYA8nvGOzhx6z2eOqWRZzDPaXK6K5LOfA7
eIP8ilCuKkc3/h3I7hzuJOXXTp7Eoq/e/4v9Wu5femjaq+C0iCY5iyZFuguW
PWVcsfzcu/6si6j0YYCQohVbCnTHn/K1YsrdOW63xUZrdMO9mDQ7vNbf+nZH
1NjP1QRxIDmajvdOe0uO9GNqJZDds5MSXMsncVwBrz4j4RBPZ8BkVitOoyiD
oX2wSPxGlgKfGyIWgGd4Gtu8ReH6SAf84q45n5sS1Dqh10NbI3uuE7Ihf2Ia
8S8CvV+SJd2BGmDnqrsu6yPPHVhG4xl+0SJnXe1BDNeaIStpjNnvsHchDyeV
6ZjKNMKI4KyRtDyXI8slnvQSabPB7M7T1uBv4qzxaWkcYmM7Z5hC7v3ZCGva
XRCrgc58HNtaDMPr+6/J2VyCnLL6F4jbmPs3WMrj12kFa3hZr2hWAecpUlYR
ZVyOWAbjpyK+Rx7oWGI+nTNNol4gBlyDbKQsO62qkPIhqFfKPazkXHW/JFzZ
189FvcTxCO7DnRvizvEhGTV0L5fsPwjRXxNHX+Z+EobvUd6Giw8b0iWU+TB5
COXAHC/6zCDtYZyL3J4qQnJyb7avJOcuqJYguxRKt/lw8Wwg3/cEKX0O7rub
uwTzcUWWX70YeG0L+NU8xiXyu8A3YJo+YoAVWpEwhjLmDk3K0564Uv3hlS5r
juN+JItOV1Y0n+0bcvQHfRSCnbXoaUSb2L66FlmxRugrqWagQ5CvkeUFY2uJ
PbOyKy/Vv4mevFNdwZ0do6a6DOtID8z1XnXlRvWp3b90tfoMkqSbry9nyAKL
S3eerWya+Vehzj89+CfayiV7ni2L5oZRe5ER0DXG5YFbtK1el/QZLMGYcj2s
M1M9bhLzsLGurpeunLP77t68dIWOrRH0EzQQcpfqTOawMv9Wta3+fefcOXaq
I5S1Yu1OuCeO75QLM0SS3VkxI7BtftKUvXHfWd0fOkbJvQH7e8g0MntAmX98
TtgytsCk7VL3WhqbP7vLn2r1AnJEYnZGYEDgM0fPhszkBzUPLThldLtBAtSP
0VzM5Ed3Hen88stsbJjTBuRd0omV/nXjvBbPbIbBPWZQxZxxHRlCSGaGX205
a8BrCdn2Xc5gvzOAWET3WZQ7pSN21tKcg+HurHC3CeJZ1HdrEhp1tBS0zSSJ
3pIs/Si0POhjQ25D3OUZ5nwxuzX42IeSpg8CtsmZ4JC1R4Ek2wXKdvIyvhGc
mCX4oqhCTxAZS1x4VWQ8shxhMXeFGYrrNtG62DrhnkG+GxyzYPBZOWwB5pWf
HniciEsIc1Lmt57eofMXjClEe1soFkpeTytmYMXtmwPyObXgnNuKtttrnaBN
5myKEcEzkn1TPqdCidjpLK6JZ/kM1RuffSTKeOH3561gRmR2rgP3Y7h3VXKU
CO73BUuTljndRe5yN4f59jwqLIEKh3U0qDjpwQddSnCKQSX7klJrs0M8p6TL
/ubf07wQ3bWIc6DZnIptcFZIMmco3deDuz1dxhIyDhJseeFcSW0qS0NBxsGW
nIXeM/4jUr8MaR3gWtj+gRLPbJ+xEonOJCPjQ2N6R3bDrjaOqX6Z0k6QTPCM
UYlt1BZr+9l7rcnR6pL0yLuAF+mJJaYZRWgr4U02oralORHkA6c8ITdAmUZ5
zmAGZMypqyNtRspipMPV4ewtxKBlC//hDjEpK75p6zKU9s/kXCPOAca0JPJc
yJR2j1hSjH77LDdpD4OykQ5dj7K4SXKIIj6L2lqpBIdRA4cKz+2diljb2Vu4
H7upwp1u3up25EPsbbsaDREO+bbD8yErwtZLD77evHNnphMV58wCIBp1MsQh
0XKv+3BeU6iBA2f9RkxLAlbAfNNHkb3NLhvoHELO6w+G8W5MnumrO89Vb6sJ
8nmZhycD/8s29P0k3hKn+mJ/hrv/yVyc5NUFo/EHLTvxS5DmJOAx+trHI9ec
fIGSM43CDM7IZE63erc6z7on7nMNag/lvHrj9UhTGyMv3jemhCW4P//C/XvT
/W/W7zQ1iV+kJdVlLXWb5XMUpugBByeBhVzjBNCMbpmK5RdYPuZH9jrESxiA
iOQM2YTFi37lI8kirAnGuVCVP9nGzC42+4iU61FjjM6HfubF+0n+yLMPTkKp
rN/f4r5gZ4SN6ZDEnXk/mxoMHaeM4mVgI4NsETzjEmQAHRKJSOWKp8mMrc8b
Zu5XXZzIhMVshL+nnluarXPcLK3N4plYQB/MKXhJJtvhKVVwtlyf10/tFo+n
BJnf7OlRpbEk6XajXAJfaoAgL0e6OmWiNfG53ZNEI4TxN1qoDv1ZV/ioNJZ0
jeX3UFd3DoTEuhaKvESRrDUy6lpD6wpo68/vMc9plbatb59+ulW+LDXwBmCk
Irl6Gy3lolwkd+BEtNWAAL/Y/kUVnKaB1o0jCo9hiNYzmadZlwhj/ydfnQLw
tAjtPU+OLSIDXLB1oM/VwQkbk/W4ZMQZIUch1OW75GUEWw5hoCodCQo1Mziv
mmF2b4lipmZjtV4/QLbQkSOPY+ZipUIGf20vTDoNsHQdyDwA7unDkm0fSnNr
LCFU5Hkw6fIT7/n3YsRlxNqeKF/0P0nGKZ59n2O2mBf5UdsfRKI3XjuISuGo
LNWiG48NUgnxRF0+Pw3Ja7dsMSknl9iBibZ3nFPBZcq1TozULtAWbYM7NLiV
JMdzyEdafBl7KchDjKeiUJ3Ec2CkM0jEeZgEg0AM0tEhbkmi3H/6bUeu9A+6
WrC5dZ9mgSkqkgWOY8xar5bJ3IvZyxHOxFV21ZD3w4i8liNPr4+D5dFYcnwg
ODMjFCRo32K57hZspdb/kpbIGMCKyDsSkv12Ux8bnh1JjKm6oZJKr6lI2nrS
riPhuMIyljs04zTBJ+HJtPZBz2z9dE95meJzgxzZHVaco2zU87qfNPtd7rUp
W27uL4zuOl8RoxEpu1qEo6slEX4vT2zlOOp/OVObeL7Fwq3WjIqjRGBHTlv0
k8tFzs9Ocus92Y5bVC0bfrb6Y4SlYssSsfgo6p+YBYAX9Vx13Y8QxpjmRQuy
gpOM42Ipj7FSHiH7bScX2Ly7FXlB3Do/cnyxFU6wsp8fTlvH1t8vXlYXy9WP
OtJjrfPeke9ma/hpMrRk5R0RztIyDiOuB7Nev4+/PqIV4vMnHdYiZzIJT96w
DHNZSD1Gp/66s7gtIKn1rYOgj3mfMwa1EtQnPhSpz6rNgVflTXiimp9z4PLy
p6CaGaWJn3kiHILMlAUWkHGMut36+k8HIqIK8aNhiDGWM+fW6WpYf/DzeoLP
l8SeU9dTH/5vWhsrHV6bhpzdOQhrdf3Yp3rsDHT21xVeiqQ3OdRHmkGuT7c0
u1p3nrRUdrXunGyoB1ev/KdfAQgLajfWH2awP3pj9tCuEDQ5JvK93T9zjyBY
QQipzfwaaVyUlz1lpPj75z/hf99Z/uezXwV//+fd/5PJec3MH2Z/b9d4zhO1
/AGr1Y/MU4URG7S6ccbA1mKuLl35b8KVp+mcXkvRWu2hXfDvP6FruNP1HEdP
Cne++YfdrLaDtVgYwYoiP4Me2Szcymj04hnSjGvoEhfYK0vbGe0TjmXKd2wM
07+gWrNQLrSBsOYd9n++Vt0M+A239TwnPNrlhOYu2PIcVskmS4xQlJYpy/yH
PeuoXb+PplW45zRkzPbXemc+nzPhNWUsDCoYPQnG5rs4lqU5e43TI/FpqcwB
vJd5vkIppxS9f1waqZ0l8CfwfVT6foW17ZA0NvvbIeDBFPMp7VYfJTjj473j
UsyMlNgLpu+7pdpE2FL04F9um8hxcyrsSoGdv6IfE2Egn2XLezDxUeVQpmpC
kIFH/4t0b9g8MkusFL4X8zF2j7Xqsu39+79MhhivMfGaEkFufTW2f/+Y+DwR
uaJ9iTzTS2wro/1t0q5OAYHyaZzJyezWCxGnpatpYy8wPAMeka63HbAf0HMT
ztrp3HeLERG2TiD2lDtzEYnjNsr/2fGppHUB7qXHVpylictejgHJvbHco5GL
t78Qny9HQiWPvx9Z0bp2WA3OcibB3y2KWDGC6edwe801uVwAFTvbEDwn1GBn
wRNrJlEXOMbx3V9ihpNIR4fkVzHnaET2ItU6YnKL1TXxxDgqxXWJMRphNx5H
j1V2n8xLINqEmA2LGdMC+SqkyvT6sii+naX3EEqYx20y31kyYPLvyFFKnvyE
ON5TeXB460V+0snHdKYkF3fpW3ktY0nO+l+wTpHVHyRKlOZTpN/1c494/zHv
w8NTas9SqNEIT5J0dI3VcKkH1/vrp5+6atu/shA+59PQExNZoODV8x7iefAW
YiAs80Ts3UYjsVE+YuQtcQ+DRbeEsr9zy+9XH8qrIOTSRZbCUWoa47e+P5wY
v2uS7vV6/NyP0DjOLbrcsrRt7GsB2Ip71Yc9I3WtV1PX2JNHke5IaBfZTN6b
gmasCm3iqzCW2zDmbBqW8PR5zUFGB24/sInSSnMskQ3lMaekXoWZZNIa8CN3
3xW16ZAo5ZN63/L/6NGWReqlH/GjtA2MtLyvjkN2zy39eEriYDFaBVZQYqmx
v+x9Gs619L2bsYhs31/fMqG0aAXpI6MS5OL5W1GHe3AhGJ2aMXDuw5l40s/u
qJl+7uOspcNeOx9F+0TEjH1tEVMF2xhGk9Mt4jYT6oXY0Mqr5QsJDRyKyFbv
kdoNv2p6apF31MKxr8Tayc7SOa+QMp1p2X6fyz45bpPxninlv+H339etG7OI
Whsw/kduieStPhlKsWdsHoo0sjv+Gsem+jzqtakk/XSchu/2G/WMYbkF3P5R
+7pApKzhkQ1+Pkj6pBefaavL/+l7Pkd6/VaKmH2HUiiKtrIvRVnUItJanfL5
F87crEfZwd4bw5Ny9hTQeB+LfxL5UVe7pfqAHrNzRvL2wkutj9Ei85J9ZYt5
Y7Hvue1e5WjS0PGV1ue+8Ufl+kBxpNVFmF6HByi3ZsSkVTJpsZVkOFwTsamk
H95EkRcpcuIsn/530iM/0YsMotms7lh9yrsxotTp8/G2QFk3trfgFIAW8njb
TPc7FRbmVr64cTZZ0LK53HfUx+TRMzkWw+SbsnKLcEYfr7tL8hF1+HycR4q4
tVBb3XlQGy3Jb2xzgvt8aTZ/+PVjAaYtP5JdfJy1W45/i7INxpLkv/H5JogK
bFc3BH3kcQm6KwXVMuFxRliXzCAaZNAlo3xFLE2WWHSGHruXvOCueFdoLzTU
cWSjyNfQdW0J7xNG5+6N46gqBcso5+RgM/05DYr2znX4A4nWc0tM8/pKs1ld
M6VSj/PfS+XF98jI7Tr4GBMDuSa0TZ7BP9iZkSz0A5dGDpUuyKrKT3bcC+0z
r4VUK1kruRz6Ihj8+76syH3WPIqv+tyl8QyyRo4b1ScencZJdhavF0nXgcrg
zpfHgvNHEEVzdrJD4TP47VVjEVETVis6jYHLS5oxWJXkKMyAcPm7eT3TcfDx
zWpbziJwuJcvjyhC7CFCSCeP2eMnzTl8oyBDMcqRo+lSL2p0a5tsb7iNjHQr
YE/wyNRMnDQHzZ8v+6QfOeuV9OIZm2rjGRUJW3CWWykuyehY0PyE9FQ6iy2u
53y23SCZvT0zqKAaTflYhw8wjVn4VIisC3oZaX3/Op54jh/GyU2T5bCt4lVe
+j5nckXM6OUNEH2yoiYZVsXzhYTzQSdh37izXIY4BrBCiZmzQBu5J6Dtt75d
tkASMFg+QkQOwL20VGwIVytm1Cfw3DXNdeUsUayHR7SViDZC1mGXAZ6cOdii
TNnZfYq9OdCxdpef1hqd7pe3X81suxZb+8jxiUctHGdPrX091KPv3dZZOtUW
/4LawshirnZYSCV/fz6WldyY+BU+023BWQtmim7Y6XjiGZDEEuQLaL/M2Lys
w1VoOsTB/YpubtJ/mvEyRf82npl0HEAsQ4OIy5kdnBgqnMGDpySK5+EEGel5
T1k9/qYm46/bxqaYOLe1fTHeWBcjrievpF441sPrQHosgf5slroheTbCT7jF
NfkV3MnGgXfIT75Zo+jOUvby0/4cevGc6css7bzP+M1yq6sR00Trk5OzQq2z
DYloFrPWsp/eE4NvcM6RxxbdLMWRUOIZWc3Djlil5y+0Lr+5cHIVnrcnn/cc
nwkafIJ+VIzsUVufSuB2fOJB/wofvTbM8anHWpoJR2D51OJZCzfwLI2fxBKd
7YqnyRWoWcK5KXAysFezPfK7RaJvIiJEMSHOMEaR7JKjnqJEb+nSungeJ3az
HpTBJFcG8NLbyKI56e7wk3u97wgnJVrnCNk2y9yPkodzfuP4S3rE9zGE/nWM
yadEf1VKOt4RaZafUtjO4Gy1b2cqX/cuzoMtUdwOsNdGn+0hvA3hIcJp1Sx7
/7ANnSX3pHEATATJYhzqP6X5iKCvXfqNv+8cJXy2UUuf7y06Iml8YVHIqLd4
XvSEti+wWj7mzLg7jbS4e+yTlpwGK5xJ2LEOnWtygC6c3xxmcuzjJOIK6Eir
dSmPRdxCjMAWHt8t+1umvnrAIcRT5rx8g/Np9uCIYbCY4WFYaDFzbSV7170K
s3TiGby90e0erEis60iVw/1JLVe+MlCc3VuxEt+ThZsas96vFGIlEeeOODjy
GB7JLdJYYLX6yDTt0ctnT6dww9nBdE8c4SPGs7kDs6wwkWuBIXOg98ko1txL
JEdG4iXHT64Ozk/3LDiUrDBfwU8axa+C8dSNx47Xcq7M8YCzF3HfCmVF4r5H
V1o8+7xfXY3WgCTzD3MMA5W3Xmd4/q/V76X4ZJqWMEIR+ceNwyGG/HBqXUPK
EZiL1fF4B4AWzfencYRVnpFfbFeuvIuoB8fGuJ6Whczj2cYG9+YKI2xO41iS
B2NtXxAXGaDXQqO0HFMK+sxdqtXE6sbyX2wNZC9ffIrcozYLsxOyrcR1+q1f
wxKhxchqb6iXGednedTilp7v3hJPJzqxMETkSMv13z+8OUtz7765MP59GI+K
PZSFdrE+wtwcPr8h88PRLFBytozIirPdkFuXFF2QHfOzlsWzl5eFiAnr8Q5r
SdqdC35kd4SqmcrnUorzOZFXu9BuxA4rwetG9ybCcht5JVqcJS6Zh4HMNoce
TIP+6kCwwbnjidZ22DgCsRIm5hueaMajOGPer9SeJHrz1Na/68wcA4Clup3V
zczIZ31q5aWcmQash37VjRVf3a7Xzbp6X89nVWt/UJPZutH6bP705rfqe/Wo
qX2A7cMl2rOzWicXee6Z327MHs70h3OwRbPp/Juv/xREB/ExA1WRLF/XlVV/
P4ea/lB9sT7Fmra0pupH65Wrhqnyx9VnbXXZLgGtP/h28+q8/nBeX27qD+b6
tDIzWTt3mRt059f6p+oXvzv+ye9//Ol8qs3VXD9Cf/UfF+5QhvGHBy/Od+0Z
b0/Od+tGv1R31GaA16pr5qab5n7s1W4c1s1N+IH+8dyGOurMxZiy5fnN2bc3
N/X3N6dz1Igg4gm/260f3lz/7Z1nFKK2rkT95L3pn/7ra4+x3Vlp4iw22ff+
H3aHO1o=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->286778072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75847478],

Cell["Cluster words beginning with \"ax\" in the English dictionary:", \
"ExampleText",
 CellID->819283457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"Column", "[", "#", "]"}], "]"}], "&"}], "/@", 
  RowBox[{"FindClusters", "[", 
   RowBox[{
    RowBox[{"DictionaryLookup", "[", 
     RowBox[{"\"\<ax\>\"", "~~", "__"}], "]"}], ",", "20"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->248439858],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{458, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->800710920]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14377],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Split",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Split"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nearest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nearest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindShortestTour",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindShortestTour"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23753]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4745],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FindClusters",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FindClusters"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->709579398],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->393938368],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->45809221],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->236105421],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->280406104],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->209599964],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->413197435],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->194639290],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->23989129],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->216585683],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->238460552]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindClusters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 42, 50.8432088}", "context" -> "System`", 
    "keywords" -> {
     "agglomerate", "agglomeration", "cluster", "cluster analysis", 
      "clustering", "clustering of data", "grouping of data", "optimize", 
      "partitioning of data"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FindClusters[{e_1, e_2, ...}] partitions the e_i into clusters of \
similar elements. FindClusters[{e_1 -> v_1, e_2 -> v_2, ...}] returns the v_i \
corresponding to the e_i in each cluster. FindClusters[{e_1, e_2, ...} -> \
{v_1, v_2, ...}] gives the same result. FindClusters[{e_1, e_2, ...}, n] \
partitions the e_i into exactly n clusters. ", 
    "synonyms" -> {"find clusters"}, "title" -> "FindClusters", "type" -> 
    "Symbol", "uri" -> "ref/FindClusters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13228, 399, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->202508092]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 83944, 2520}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3744, 80, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4367, 107, 1577, 37, 70, "ObjectNameGrid"],
Cell[5947, 146, 3525, 113, 70, "Usage",
 CellID->26892]
}, Open  ]],
Cell[CellGroupData[{
Cell[9509, 264, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9987, 281, 881, 30, 70, "Notes",
 CellID->27310],
Cell[10871, 313, 506, 17, 70, "Notes",
 CellID->28327],
Cell[11380, 332, 633, 23, 70, "Notes",
 CellID->11730],
Cell[12016, 357, 410, 13, 70, "Notes",
 CellID->7677],
Cell[12429, 372, 261, 9, 70, "Notes",
 CellID->288],
Cell[12693, 383, 498, 11, 70, "2ColumnTableMod",
 CellID->30106]
}, Closed]],
Cell[CellGroupData[{
Cell[13228, 399, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->202508092],
Cell[CellGroupData[{
Cell[13613, 413, 148, 5, 70, "ExampleSection",
 CellID->226033367],
Cell[13764, 420, 73, 1, 70, "ExampleText",
 CellID->21889872],
Cell[CellGroupData[{
Cell[13862, 425, 228, 7, 28, "Input",
 CellID->569529878],
Cell[14093, 434, 348, 12, 36, "Output",
 CellID->172282501]
}, Open  ]],
Cell[14456, 449, 125, 3, 70, "ExampleDelimiter",
 CellID->256090717],
Cell[14584, 454, 66, 1, 70, "ExampleText",
 CellID->91155046],
Cell[CellGroupData[{
Cell[14675, 459, 255, 8, 70, "Input",
 CellID->224096450],
Cell[14933, 469, 409, 14, 36, "Output",
 CellID->422447164]
}, Open  ]],
Cell[15357, 486, 125, 3, 70, "ExampleDelimiter",
 CellID->154946119],
Cell[15485, 491, 117, 3, 70, "ExampleText",
 CellID->1439678],
Cell[CellGroupData[{
Cell[15627, 498, 467, 13, 70, "Input",
 CellID->482481490],
Cell[16097, 513, 342, 11, 36, "Output",
 CellID->174841753]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16488, 530, 215, 7, 70, "ExampleSection",
 CellID->7765],
Cell[16706, 539, 74, 1, 70, "ExampleText",
 CellID->233166546],
Cell[CellGroupData[{
Cell[16805, 544, 458, 15, 70, "Input",
 CellID->488124990],
Cell[17266, 561, 607, 21, 36, "Output",
 CellID->606519053]
}, Open  ]],
Cell[17888, 585, 125, 3, 70, "ExampleDelimiter",
 CellID->954028739],
Cell[18016, 590, 73, 1, 70, "ExampleText",
 CellID->225237183],
Cell[18092, 593, 596, 20, 70, "Input",
 CellID->22000234],
Cell[CellGroupData[{
Cell[18713, 617, 113, 3, 70, "Input",
 CellID->483855928],
Cell[18829, 622, 643, 21, 105, "Output",
 CellID->407486340]
}, Open  ]],
Cell[19487, 646, 124, 3, 70, "ExampleDelimiter",
 CellID->21120065],
Cell[19614, 651, 324, 13, 70, "ExampleText",
 CellID->429482735],
Cell[CellGroupData[{
Cell[19963, 668, 210, 7, 70, "Input",
 CellID->57822912],
Cell[20176, 677, 874, 27, 54, "Output",
 CellID->147901267]
}, Open  ]],
Cell[CellGroupData[{
Cell[21087, 709, 111, 3, 70, "Input",
 CellID->335113769],
Cell[21201, 714, 1036, 21, 70, "Output",
 Evaluatable->False,
 CellID->33938093]
}, Open  ]],
Cell[CellGroupData[{
Cell[22274, 740, 270, 9, 70, "Input",
 CellID->391953649],
Cell[22547, 751, 979, 27, 71, "Output",
 CellID->400947356]
}, Open  ]],
Cell[CellGroupData[{
Cell[23563, 783, 111, 3, 70, "Input",
 CellID->2733212],
Cell[23677, 788, 1182, 36, 88, "Output",
 CellID->57258019]
}, Open  ]],
Cell[24874, 827, 125, 3, 70, "ExampleDelimiter",
 CellID->350061373],
Cell[25002, 832, 62, 1, 70, "ExampleText",
 CellID->36822420],
Cell[25067, 835, 624, 13, 70, "Input",
 CellID->419536537],
Cell[CellGroupData[{
Cell[25716, 852, 112, 3, 70, "Input",
 CellID->539862822],
Cell[25831, 857, 776, 19, 71, "Output",
 CellID->657223694]
}, Open  ]],
Cell[26622, 879, 124, 3, 70, "ExampleDelimiter",
 CellID->70406879],
Cell[26749, 884, 201, 7, 70, "ExampleText",
 CellID->304980997],
Cell[26953, 893, 648, 21, 70, "Input",
 CellID->80246693],
Cell[CellGroupData[{
Cell[27626, 918, 168, 5, 70, "Input",
 CellID->7689210],
Cell[27797, 925, 292, 9, 36, "Output",
 CellID->650254712]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28138, 940, 222, 7, 70, "ExampleSection",
 CellID->554518242],
Cell[CellGroupData[{
Cell[28385, 951, 237, 7, 70, "ExampleSubsection",
 CellID->478502983],
Cell[28625, 960, 252, 8, 70, "ExampleText",
 CellID->291204248],
Cell[CellGroupData[{
Cell[28902, 972, 319, 10, 70, "Input",
 CellID->166822192],
Cell[29224, 984, 348, 12, 36, "Output",
 CellID->516309555]
}, Open  ]],
Cell[29587, 999, 249, 8, 70, "ExampleText",
 CellID->22850172],
Cell[CellGroupData[{
Cell[29861, 1011, 228, 7, 70, "Input",
 CellID->771507975],
Cell[30092, 1020, 348, 12, 36, "Output",
 CellID->451366966]
}, Open  ]],
Cell[30455, 1035, 125, 3, 70, "ExampleDelimiter",
 CellID->739228160],
Cell[30583, 1040, 249, 8, 70, "ExampleText",
 CellID->148336777],
Cell[30835, 1050, 975, 27, 70, "Input",
 CellID->395023205],
Cell[CellGroupData[{
Cell[31835, 1081, 197, 6, 70, "Input",
 CellID->34892062],
Cell[32035, 1089, 1102, 22, 70, "Output",
 Evaluatable->False,
 CellID->237060734]
}, Open  ]],
Cell[33152, 1114, 242, 8, 70, "ExampleText",
 CellID->486847666],
Cell[CellGroupData[{
Cell[33419, 1126, 111, 3, 70, "Input",
 CellID->189917055],
Cell[33533, 1131, 1110, 22, 70, "Output",
 Evaluatable->False,
 CellID->242896979]
}, Open  ]],
Cell[34658, 1156, 125, 3, 70, "ExampleDelimiter",
 CellID->171113641],
Cell[34786, 1161, 244, 8, 70, "ExampleText",
 CellID->201999173],
Cell[35033, 1171, 624, 13, 70, "Input",
 CellID->374390573],
Cell[CellGroupData[{
Cell[35682, 1188, 197, 6, 70, "Input",
 CellID->331039916],
Cell[35882, 1196, 774, 19, 54, "Output",
 CellID->85115265]
}, Open  ]],
Cell[36671, 1218, 226, 8, 70, "ExampleText",
 CellID->263107730],
Cell[CellGroupData[{
Cell[36922, 1230, 112, 3, 70, "Input",
 CellID->274678518],
Cell[37037, 1235, 775, 19, 71, "Output",
 CellID->50255087]
}, Open  ]],
Cell[37827, 1257, 123, 3, 70, "ExampleDelimiter",
 CellID->5405018],
Cell[37953, 1262, 89, 1, 70, "ExampleText",
 CellID->152413854],
Cell[38045, 1265, 490, 16, 70, "Input",
 CellID->368987804],
Cell[CellGroupData[{
Cell[38560, 1285, 431, 14, 70, "Input",
 CellID->80558366],
Cell[38994, 1301, 252, 8, 36, "Output",
 CellID->80160781]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39295, 1315, 227, 7, 70, "ExampleSubsection",
 CellID->293299345],
Cell[39525, 1324, 75, 1, 70, "ExampleText",
 CellID->308264702],
Cell[CellGroupData[{
Cell[39625, 1329, 307, 9, 70, "Input",
 CellID->68860908],
Cell[39935, 1340, 370, 12, 36, "Output",
 CellID->318995503]
}, Open  ]],
Cell[40320, 1355, 85, 1, 70, "ExampleText",
 CellID->362886188],
Cell[CellGroupData[{
Cell[40430, 1360, 228, 7, 70, "Input",
 CellID->137032996],
Cell[40661, 1369, 347, 12, 36, "Output",
 CellID->83612655]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41057, 1387, 230, 7, 70, "ExampleSubsection",
 CellID->17625882],
Cell[41290, 1396, 72, 1, 70, "ExampleText",
 CellID->171379349],
Cell[41365, 1399, 624, 13, 70, "Input",
 CellID->156881691],
Cell[CellGroupData[{
Cell[42014, 1416, 174, 5, 70, "Input",
 CellID->819176424],
Cell[42191, 1423, 770, 18, 71, "Output",
 CellID->81501062]
}, Open  ]],
Cell[42976, 1444, 155, 5, 70, "ExampleText",
 CellID->202550871],
Cell[CellGroupData[{
Cell[43156, 1453, 112, 3, 70, "Input",
 CellID->324650839],
Cell[43271, 1458, 772, 19, 71, "Output",
 CellID->47722]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[44104, 1484, 223, 7, 70, "ExampleSection",
 CellID->16975],
Cell[44330, 1493, 89, 1, 70, "ExampleText",
 CellID->173426724],
Cell[44422, 1496, 4129, 134, 70, "Input",
 CellID->177473525],
Cell[CellGroupData[{
Cell[48576, 1634, 145, 4, 70, "Input",
 CellID->72316041],
Cell[48724, 1640, 1268, 28, 133, "Output",
 CellID->670555867]
}, Open  ]],
Cell[50007, 1671, 125, 3, 70, "ExampleDelimiter",
 CellID->146195537],
Cell[50135, 1676, 135, 4, 70, "ExampleText",
 CellID->441656661],
Cell[50273, 1682, 433, 11, 70, "Input",
 CellID->152564336],
Cell[CellGroupData[{
Cell[50731, 1697, 197, 6, 70, "Input",
 CellID->172707271],
Cell[50931, 1705, 577, 16, 54, "Output",
 CellID->7454762]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51557, 1727, 232, 7, 70, "ExampleSection",
 CellID->8037],
Cell[51792, 1736, 371, 12, 70, "ExampleText",
 CellID->257695094],
Cell[CellGroupData[{
Cell[52188, 1752, 228, 7, 70, "Input",
 CellID->177207225],
Cell[52419, 1761, 348, 12, 36, "Output",
 CellID->147396759]
}, Open  ]],
Cell[CellGroupData[{
Cell[52804, 1778, 249, 8, 70, "Input",
 CellID->19791519],
Cell[53056, 1788, 180, 6, 36, "Output",
 CellID->31771685]
}, Open  ]],
Cell[CellGroupData[{
Cell[53273, 1799, 251, 8, 70, "Input",
 CellID->226612713],
Cell[53527, 1809, 205, 7, 36, "Output",
 CellID->426125619]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53781, 1822, 226, 7, 70, "ExampleSection",
 CellID->11214],
Cell[54010, 1831, 114, 3, 70, "ExampleText",
 CellID->215918777],
Cell[CellGroupData[{
Cell[54149, 1838, 190, 6, 70, "Input",
 CellID->20119668],
Cell[54342, 1846, 315, 11, 36, "Output",
 CellID->243108895]
}, Open  ]],
Cell[CellGroupData[{
Cell[54694, 1862, 191, 6, 70, "Input",
 CellID->137238055],
Cell[54888, 1870, 323, 11, 36, "Output",
 CellID->40687799]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55260, 1887, 224, 7, 70, "ExampleSection",
 CellID->14773],
Cell[55487, 1896, 200, 6, 70, "ExampleText",
 CellID->27619387],
Cell[55690, 1904, 336, 13, 70, "Input",
 CellID->276728907],
Cell[56029, 1919, 567, 16, 70, "Input",
 CellID->38730789],
Cell[CellGroupData[{
Cell[56621, 1939, 173, 5, 70, "Input",
 CellID->192950076],
Cell[56797, 1946, 16630, 277, 70, "Output",
 Evaluatable->False,
 CellID->286778072]
}, Open  ]],
Cell[73442, 2226, 124, 3, 70, "ExampleDelimiter",
 CellID->75847478],
Cell[73569, 2231, 107, 2, 70, "ExampleText",
 CellID->819283457],
Cell[CellGroupData[{
Cell[73701, 2237, 328, 11, 70, "Input",
 CellID->248439858],
Cell[74032, 2250, 3734, 65, 70, "Output",
 Evaluatable->False,
 CellID->800710920]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77827, 2322, 311, 9, 70, "SeeAlsoSection",
 CellID->14377],
Cell[78141, 2333, 951, 35, 70, "SeeAlso",
 CellID->23753]
}, Open  ]],
Cell[CellGroupData[{
Cell[79129, 2373, 313, 9, 70, "TutorialsSection",
 CellID->4745],
Cell[79445, 2384, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[79652, 2392, 305, 8, 70, "RelatedLinksSection"],
Cell[79960, 2402, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80366, 2419, 299, 8, 70, "MoreAboutSection"],
Cell[80668, 2429, 155, 3, 70, "MoreAbout",
 CellID->709579398],
Cell[80826, 2434, 155, 3, 70, "MoreAbout",
 CellID->393938368],
Cell[80984, 2439, 156, 3, 70, "MoreAbout",
 CellID->45809221],
Cell[81143, 2444, 139, 3, 70, "MoreAbout",
 CellID->236105421],
Cell[81285, 2449, 156, 3, 70, "MoreAbout",
 CellID->280406104],
Cell[81444, 2454, 132, 3, 70, "MoreAbout",
 CellID->209599964],
Cell[81579, 2459, 149, 3, 70, "MoreAbout",
 CellID->413197435],
Cell[81731, 2464, 185, 3, 70, "MoreAbout",
 CellID->194639290],
Cell[81919, 2469, 178, 3, 70, "MoreAbout",
 CellID->23989129],
Cell[82100, 2474, 175, 3, 70, "MoreAbout",
 CellID->216585683],
Cell[82278, 2479, 151, 3, 70, "MoreAbout",
 CellID->238460552]
}, Open  ]],
Cell[82444, 2485, 27, 0, 70, "History"],
Cell[82474, 2487, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

