(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    289350,       7141]
NotebookOptionsPosition[    270187,       6475]
NotebookOutlinePosition[    272107,       6522]
CellTagsIndexPosition[    272020,       6517]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematics-BasicOperations"], 
          "Solving Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingEquations"], 
          "Numerical Equation Solving" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalEquationSolving"], 
          "Numerical Root Finding" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalRootFinding"], 
          "Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Mathematics: Basic Operations\"\>", 
       2->"\<\"Solving Equations\"\>", 
       3->"\<\"Numerical Equation Solving\"\>", 
       4->"\<\"Numerical Root Finding\"\>", 
       5->"\<\"Unconstrained Optimization\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NSolve" :> Documentation`HelpLookup["paclet:ref/NSolve"], 
          "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "FindMinimum" :> Documentation`HelpLookup["paclet:ref/FindMinimum"],
           "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], 
          "RootIntervals" :> 
          Documentation`HelpLookup["paclet:ref/RootIntervals"], 
          "IsolatingInterval" :> 
          Documentation`HelpLookup["paclet:ref/IsolatingInterval"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NSolve\"\>", 2->"\<\"Solve\"\>", 
       3->"\<\"FindMinimum\"\>", 4->"\<\"FindInstance\"\>", 
       5->"\<\"RootIntervals\"\>", 
       6->"\<\"IsolatingInterval\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equation Solving" :> 
          Documentation`HelpLookup["paclet:guide/EquationSolving"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Equation Solving\"\>", 
       2->"\<\"Inverse Functions\"\>", 
       3->"\<\"Polynomial Equations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FindRoot", "ObjectName",
 CellID->5141],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindRoot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindRoot"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["0", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]searches for a numerical root of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", starting from the point ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "=", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["0", "TR"]]}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindRoot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindRoot"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["lhs", "TI"], "==", 
         StyleBox["rhs", "TI"]}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["0", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]searches for a numerical solution to the equation ",
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "==", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindRoot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindRoot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            StyleBox["x", "TI"], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["0", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            StyleBox["y", "TI"], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["0", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]searches for a simultaneous numerical root of all the \
",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FindRoot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FindRoot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["eqn", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["eqn", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            StyleBox["x", "TI"], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["0", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            StyleBox["y", "TI"], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["0", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]searches for a numerical solution to the simultaneous \
equations ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["eqn", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->587]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
If the starting point for a variable is given as a list, the values of the \
variable are taken to be lists with the same dimensions. \
\>", "Notes",
 CellID->29172],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " returns a list of replacements for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", \[Ellipsis]",
 " ",
 ", in the same form as obtained from ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18571],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " first localizes the values of all variables, then evaluates ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " with the variables being symbolic, and then repeatedly evaluates the \
result numerically."
}], "Notes",
 CellID->5826],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and effectively uses ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " to localize variables."
}], "Notes",
 CellID->11798],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["lhs", "TI"], "==", 
     StyleBox["rhs", "TI"]}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " searches for a solution using ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " as the first two values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", avoiding the use of derivatives. "
}], "Notes",
 CellID->14944],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["lhs", "TI"], "==", 
     StyleBox["rhs", "TI"]}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["start", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " searches for a solution, stopping the search if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ever gets outside the range ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22045],

Cell[TextData[{
 "If you specify only one starting value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " searches for a solution using Newton methods. If you specify two starting \
values, ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " uses a variant of the secant method. "
}], "Notes",
 CellID->23240],

Cell[TextData[{
 "If all equations and starting values are real, then ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " will search only for real roots. If any are complex, it will also search \
for complex roots. "
}], "Notes",
 CellID->14357],

Cell[TextData[{
 "You can always tell ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to search for complex roots by adding ",
 Cell[BoxData[
  RowBox[{"0.", 
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"]}]], "InlineFormula"],
 " to the starting value. "
}], "Notes",
 CellID->17774],

Cell["The following options can be given: ", "Notes",
 CellID->12477],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the accuracy sought ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate whenever equations are evaluated ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "Jacobian", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the Jacobian of the system ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], "100", Cell[
    "maximum number of iterations to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PrecisionGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrecisionGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the precision sought ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["StepMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StepMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate whenever a step is taken ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision to use in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->13018],

Cell[TextData[{
 "The default settings for ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "/", "2"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->3703],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " specifies the number of digits of accuracy to seek in both the value of \
the position of the root, and the value of the function at the root. "
}], "Notes",
 CellID->9011],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " specifies the number of digits of precision to seek in the value of the \
position of the root. "
}], "Notes",
 CellID->17911],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " continues until either of the goals specified by ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " is achieved. "
}], "Notes",
 CellID->29615],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " does not succeed in finding a solution to the accuracy you specify within \
",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 " steps, it returns the most recent approximation to a solution that it \
found. You can then apply ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " again, with this approximation as a starting point. "
}], "Notes",
 CellID->15787]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->16010467],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->821922204],

Cell[TextData[{
 "Find a root of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], "+", 
    RowBox[{"sin", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " near ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6133],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"-", "0.5885327439818611`"}]}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228127870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29108],

Cell[TextData[{
 "Find a solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cos", "(", "x", ")"}], "\[LongEqual]", "x"}], TraditionalForm]], 
  "InlineMath"],
 " near ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->24146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21927],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->952218672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->467321172],

Cell["Solve a nonlinear system of equations:", "ExampleText",
 CellID->611245419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"x", "-", "2"}], "]"}], "\[Equal]", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "\[Equal]", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10539561],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "0.019026016103714054`"}], ",", 
   RowBox[{"y", "\[Rule]", "0.13793482556524314`"}]}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520524528]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->624333486],

Cell["Find the solution of a system of two nonlinear equations:", \
"ExampleText",
 CellID->14495046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "\[Equal]", 
      RowBox[{"Exp", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "\[Equal]", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155930699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "0.4428544010023886`"}], ",", 
   RowBox[{"y", "\[Rule]", "1.5571455989976115`"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97721266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->578132984],

Cell["Find a root for a 3-component function of 3 variables:", "ExampleText",
 CellID->45814927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "y"}], "]"}], ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "-", "y"}], "]"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "-", "z"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85154930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "0.7853981633974483`"}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"-", "0.7853981633974483`"}]}], ",", 
   RowBox[{"z", "\[Rule]", "1.2337005501361697`"}]}], "}"}]], "Output",
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309936772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198919299],

Cell["\<\
You can cause the search to use complex values by giving a complex starting \
value:\
\>", "ExampleText",
 CellID->29620782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "+", 
      RowBox[{"14", " ", "I"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98169622],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{"0.5000000000000016`", "\[InvisibleSpace]", "+", 
    RowBox[{"14.134725141734695`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->746925268]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650788513],

Cell["\<\
When the function is complex for real input, a real starting value may give a \
complex result:\
\>", "ExampleText",
 CellID->408695815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"z", "+", "I"}], "]"}], "-", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"z", "+", "2"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16385612],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "5.9471781882505156`*^-24"}], "+", 
    RowBox[{"0.31695789692481674`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{219, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81672072]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"z", "+", "I"}], "]"}], "-", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"z", "+", "2"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3987502],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "1.9999999999999993`"}], "+", 
    RowBox[{"6.700856866951783`*^-16", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{177, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88393519]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->100522369],

Cell["\<\
A variable may be considered as vector-valued if specified in the starting \
value:\
\>", "ExampleText",
 CellID->194977374],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "7", ",", "8"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33603735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"A", ".", "x"}], "\[Equal]", 
      RowBox[{"\[Lambda]", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{"x", ".", "x"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", "3"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->327858092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.832050293744123`", ",", "1.2861385633584948`*^-9", ",", 
      RowBox[{"-", "0.5547001971158102`"}]}], "}"}]}], ",", 
   RowBox[{"\[Lambda]", "\[Rule]", 
    RowBox[{"-", "0.9999999983825539`"}]}]}], "}"}]], "Output",
 ImageSize->{317, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->650871715]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->254436480],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AccuracyGoal and PrecisionGoal",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->267835863],

Cell["Change tolerances for error estimates:", "ExampleText",
 CellID->31871615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"10", "-", "x"}], "/.", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "-", "10"}], "]"}], "-", "x", "+", "10"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576789740],

Cell[BoxData["1.9716335408759278`*^-7"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403026386]
}, Open  ]],

Cell["Relax error tolerances for stopping:", "ExampleText",
 CellID->38130835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"10", "-", "x"}], "/.", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "-", "10"}], "]"}], "-", "x", "+", "10"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}], ",", 
    RowBox[{"AccuracyGoal", "\[Rule]", "4"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "4"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106070136],

Cell[BoxData["0.0014761758665553515`"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->793203194]
}, Open  ]],

Cell["\<\
Make estimated relative distance to the root the main criterion for stopping:\
\
\>", "ExampleText",
 CellID->123543348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"10", "-", "x"}], "/.", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "-", "10"}], "]"}], "-", "x", "+", "10"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0"}], "}"}], ",", 
    RowBox[{"AccuracyGoal", "\[Rule]", "Infinity"}], ",", 
    RowBox[{"PrecisionGoal", "\[Rule]", "8"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->139482286],

Cell[BoxData["8.615632651753913`*^-9"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->223685836]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DampingFactor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->44487655],

Cell[TextData[{
 Cell[BoxData["DampingFactor"], "InlineFormula"],
 " can be used to help speed convergence to higher-order roots:"
}], "ExampleText",
 CellID->139953229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "-", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1.5"}], "}"}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"s", "++"}]}]}], "]"}], ",", "s"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->477043934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.5707963102749631`"}], "}"}], ",", "22"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366538122]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "-", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1.5"}], "}"}], ",", 
       RowBox[{"DampingFactor", "\[Rule]", "2"}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"s", "++"}]}]}], "]"}], ",", "s"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->337215297],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.5707963267931118`"}], "}"}], ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->621747601]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EvaluationMonitor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->518879127],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EvaluationMonitor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluationMonitor"]], "InlineFormula"],
 " can be used to keep track of function evaluations used:"
}], "ExampleText",
 CellID->554794537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"res", ",", 
    RowBox[{"{", "evx", "}"}]}], "}"}], "=", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "==", 
      RowBox[{"Exp", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0"}], "}"}], ",", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18443624],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.7034674224983924`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", 
      RowBox[{"-", "1.`"}], ",", 
      RowBox[{"-", "0.7330436052454454`"}], ",", 
      RowBox[{"-", "0.703807786324133`"}], ",", 
      RowBox[{"-", "0.7034674683317975`"}], ",", 
      RowBox[{"-", "0.7034674224983924`"}]}], "}"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{505, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218882433]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "^", "2"}], ",", 
       RowBox[{"Exp", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"evx", ",", 
         RowBox[{"evx", "^", "2"}]}], "}"}], "]"}], ",", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"evx", ",", 
         RowBox[{"Exp", "[", "evx", "]"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->676481546],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->501160615]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Jacobian",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->257849657],

Cell["Specify the Jacobian for a \"black-box\" function:", "ExampleText",
 CellID->58854240],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
        "1."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}], ",", "0."}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"blackbox", "[", 
    RowBox[{"x_", "?", "VectorQ"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "^", "2"}], " ", 
     RowBox[{"A", ".", "x"}]}], "+", "x", "-", 
    RowBox[{"x", "^", "3"}], "-", "1"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->102548334],

Cell[BoxData[
 RowBox[{
  RowBox[{"J", "[", 
   RowBox[{"x_", "?", "VectorQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d", "=", 
      RowBox[{"1", "-", 
       RowBox[{"3", " ", 
        RowBox[{"x", "^", "2"}]}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"n", "^", "2"}], " ", "A"}], "+", 
     RowBox[{"SparseArray", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
        RowBox[{"d", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68233642],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sc", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0.", ",", "n"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", "0"}], "}"}], ",", 
   RowBox[{"Timing", "[", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"blackbox", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "sc"}], "}"}], ",", 
       RowBox[{"Jacobian", "\[Rule]", 
        RowBox[{"J", "[", "x", "]"}]}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"e", "++"}]}]}], "]"}], ";", "e"}], "]"}]}], "]"}]}], "Input",\

 CellLabel->"In[3]:=",
 CellID->467135772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.03100000000000032`", ",", "4"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->478956284]
}, Open  ]],

Cell["\<\
Without a specified Jacobian, extra evaluations are used to compute finite \
differences:\
\>", "ExampleText",
 CellID->32268760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", "0"}], "}"}], ",", 
   RowBox[{"Timing", "[", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"blackbox", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "sc"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"e", "++"}]}]}], "]"}], ";", "e"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->193152442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.9690000000000005`", ",", "3007"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->19542221]
}, Open  ]],

Cell["\<\
If you just know the sparse form, specifying the sparse pattern template \
saves evaluations:\
\>", "ExampleText",
 CellID->295467606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"i", "-", "j"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
      "_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->154971934],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2998", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2998, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "1000"}], "}"}], ",", "Pattern"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->34857902]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", "0"}], "}"}], ",", 
   RowBox[{"Timing", "[", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"blackbox", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "sc"}], "}"}], ",", 
       RowBox[{"Jacobian", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<FiniteDifference\>\"", ",", 
          RowBox[{"Sparse", "\[Rule]", "sp"}]}], "}"}]}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"e", "++"}]}]}], "]"}], ";", "e"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5686649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01599999999999885`", ",", "16"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->774781769]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxIterations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6226037],

Cell["Limit or increase the number of steps taken:", "ExampleText",
 CellID->180797191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "]"}], "-", 
    RowBox[{"10", "^", 
     RowBox[{"-", "8"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", ".1"}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333203278],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
\\!\\(10\\) iterations. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/cvmit\\\", ButtonNote -> \
\\\"FindRoot::cvmit\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->28418542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.9665826038411666`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507275088]
}, Open  ]],

Cell["The default number of iterations is 100:", "ExampleText",
 CellID->150839805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", ".1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172725194],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
\\!\\(100\\) iterations. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/cvmit\\\", ButtonNote -> \
\\\"FindRoot::cvmit\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->408492983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.9953265163164798`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->545615544]
}, Open  ]],

Cell[TextData[{
 "Eventually the algorithm stalls out since this mollifier function has all \
derivatives 0 at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->263952119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", ".1"}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "1000"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->104049662],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.9993287975228579`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->546636815]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->193410444],

Cell[TextData[{
 "Find a root for",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], "=", 
     RowBox[{
      SuperscriptBox["tan", 
       RowBox[{"-", "1"}]], "(", 
      RowBox[{"1000", " ", 
       RowBox[{"cos", "(", "x", ")"}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " using different methods:"
}], "ExampleText",
 CellID->315800719],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"1000", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "12"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->123229637],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1LVFEUv/rGGTUrRS2XWmr9E+IiKiIiWkQLcTFJMbNIw2xTm9rUvjZZ
oYs+wGphKEagEAWhIAqRECWEgtgiEZIWQjCd+/XOnTP3zbxx3owfM+K89849
953f75x7zpn7ZuZcdCB25Vp0IN4TbT7dH70ei/fcaD7V1w9DThljbBxeV5sY
XCfgSrzGEwk4y+NhfnT4qPhjj8VoBI58sNzQMi7DKwzX/FwvdBsbm/NzK/DP
jvCDs7b2V1k6JvSbm/889HXCZiXBDxPZIbK4y3k38e3smeG+3jF2lB+cC+ef
DQ/NclW70E9NLp488TRJ//DBZ0SVZuVfuRazZgFWpTusVchACcLBL9uE3N01
srS0jnqUa337zsVaHUnwCa3HY6MLX3+hDEqYgmjgOETcGy2k1pGiSrTV1T+X
Lr5E62hNyp0dg2q+fzRTrggE9f69D5AKiBpRPulzhTrXWa3fHJiYmV5Ga7CY
sKSop9Zprdg5412tGfT5turt+c7hWPI8OKu2rs0vza4dTFRodYv+GEKZ+azv
bHEz9e1C8fDnP/bu3Rrv7cLV/TtMzsVX08XbzYrXc539Zneju+9goiL2fkn1
HCEe0Q6bnz4u24hBo0A8/PkfXB9PxdM7VH+78GDwst+HbzWDM+3DOTVaQxFi
sUbde0jfq/KmIYG7Ha6vJveFlZ7mmtgd2Ss34jJz05H5YLgvJcqNekT5Kdkm
z6G7NGpVyBFXn8QojQ9GdCkC58ApVBaOv7kLJXKZ64MtM2i91xsyj0CVPx+M
fGlMmZGtB5wT/0iFM0f26VaAetGgvLWxd3SOBxx3O2s35iFkm2rbi28NmRdY
vqTc4SPeIbNqOdumDEj71TyaIdpbJ+HdUUy94ysHSruf7KzyVRjy7HG0oujn
Sq7eowJ9359uvspSyZzmdSCIlWbfNyuUvl/n6o8rqzXwdX/Wfa82g1WxT6lw
M0G6Knu6MauayLJjpIsOxaV9jFpE74qz9kqelzzP/RMjr2fX/D1rpH+Gox26
kLhc3Gt+6qe5Qq0nxdHfXAWbsfpZlb4DFk/tFm/X2r2eLy2td3eN5Jb9juXp
zLu+5+dW+nrHto5YRaymfqdgr8DC4GK/3tt+bhcuZm6ueLpv66fy/GSrvYaD
sBpcJPLHcad5Pvho5sXz+WA5lg8PzdblYC25A6M1W2c1d8L+o5CsRwRacfQ7
BPt+kKJhTPOBNjW5ePfOpGmtzcoCKAARXFk/aNirIVwQNLT2+tUX9Xsv6dOn
jz9v33qPepxvR9OdivaUA0IJ+QP0wSCYaRcjM9PL8dgoDEIytBhzAASoyDk/
vv/uufwGBuHioCeqVe7sGIR/doAfHEhdiBwEix0X+rejCyBDCrIWqx5WAGSA
ZlVCD1fKvuPmKd3/8vOThK0m5O8DzV8QsrL/UD1mBA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210934010]
}, Open  ]],

Cell["The default (Newton's) method:", "ExampleText",
 CellID->114233266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", "0"}], ",", 
     RowBox[{"e", "=", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"1000", 
         RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"s", "++"}]}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"e", "++"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
     RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1023104],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "10.995574287564276`"}], "}"}], ",", 
   RowBox[{"\<\"Steps\"\>", "\[Rule]", "9"}], ",", 
   RowBox[{"\<\"Evaluations\"\>", "\[Rule]", "13"}]}], "}"}]], "Output",
 ImageSize->{292, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1610288]
}, Open  ]],

Cell["\<\
Brent's root-bracketing method requiring two initial conditions bracketing \
the root:\
\>", "ExampleText",
 CellID->509557818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", "0"}], ",", 
     RowBox[{"e", "=", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"1000", 
         RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"Method", "\[Rule]", "\"\<Brent\>\""}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"s", "++"}]}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"e", "++"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
     RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->607841865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.5707963267948966`"}], "}"}], ",", 
   RowBox[{"\<\"Steps\"\>", "\[Rule]", "14"}], ",", 
   RowBox[{"\<\"Evaluations\"\>", "\[Rule]", "16"}]}], "}"}]], "Output",
 ImageSize->{292, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->290993165]
}, Open  ]],

Cell["Secant method, starting with two initial conditions:", "ExampleText",
 CellID->504121406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", "0"}], ",", 
     RowBox[{"e", "=", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"1000", 
         RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"Method", "\[Rule]", "\"\<Secant\>\""}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"s", "++"}]}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"e", "++"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<Steps\>\"", "\[Rule]", "s"}], ",", 
     RowBox[{"\"\<Evaluations\>\"", "\[Rule]", "e"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28474875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.5707963267948966`"}], "}"}], ",", 
   RowBox[{"\<\"Steps\"\>", "\[Rule]", "12"}], ",", 
   RowBox[{"\<\"Evaluations\"\>", "\[Rule]", "27"}]}], "}"}]], "Output",
 ImageSize->{292, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->28153640]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "StepMonitor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->424537078],

Cell["Monitor when iterative steps have been taken:", "ExampleText",
 CellID->372984645],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "1"}], ",", 
     RowBox[{"10", 
      RowBox[{"(", 
       RowBox[{"y", "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", "x"}], "]"}], "+", "1"}], ")"}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245186511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"res", ",", 
    RowBox[{"{", "stxy", "}"}]}], "}"}], "=", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"StepMonitor", "\[RuleDelayed]", 
      RowBox[{"Sow", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->571050783],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1.4161468365471424`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.8`"}], ",", 
        RowBox[{"-", "0.6778957129244416`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.6200000000000001`"}], ",", 
        RowBox[{"-", "0.3531795967671845`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.4580000000000001`"}], ",", 
        RowBox[{"-", "0.07894799282493775`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.31220000000000003`"}], ",", "0.12113552694504906`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.18098000000000003`"}], ",", "0.24357858061998103`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.06288200000000004`"}], ",", "0.2963800521257964`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.04340619999999998`", ",", "0.29261629897930774`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.13906558000000002`", ",", "0.24639009924822125`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.22515902200000004`", ",", "0.17063263443660714`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.3499057621544118`", ",", "0.018518901242232877`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.5885565636880948`", ",", 
        RowBox[{"-", "0.3819790474514864`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", 
        RowBox[{"-", "1.376345614207783`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", 
        RowBox[{"-", "1.4161468365471424`"}]}], "}"}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{564, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321690609]
}, Open  ]],

Cell[TextData[{
 "Show the steps on a contour plot of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{
    "\[LeftDoubleBracketingBar]", "f", "\[RightDoubleBracketingBar]"}], "2"], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->172351922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ".", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Map", "[", 
       RowBox[{"Point", ",", "stxy"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->187720557],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlnXVA1UnXx7E71+6uNddY1xpr7da1WFvXWGvt7lpj7W7sxlVUDAZb10RB
BBHphnsBBemXh8tnfu8dnj8e9uuZOjNnTszM79yqY2cMmJDdxsbmcAEbm//9
tfzPLDP/w9nrxrRPN6aFK3zrf/BTkMK7anTfUaO7n8JfMsp/UnhPBv2dwgcy
8AOFLX/s74I3WugC/I+lvsLulvYV3mbpX+HrlvEp/NEyfoUz+dOxrPm/ZnYk
S/gFwy8YfsHwC4ZfMPyC4RcMv2D4BcMvGH7B8AuGX+v+zDqWPf4HayQofsHw
C4ZfMPyC4RcMv2D4BcMvGH7B8AuGXzD8guHXuj+zjuWM/1W78U3xC4ZfMPyC
4RcMv2D4BcMvGH7B8AuGXzD8guEXDL/W/Zl1nMlHjOIXDL9g+AXDLxh+wfAL
hl8w/ILhFwy/YPgFwy8Yfq37M+tY/pXBf6TiFwy/YPgFwy8YfsHwC4ZfMPyC
4RcMv2D4BcMvGH6t+zPrWN7O5At+wfB722qd/RSGXzD8guEXDL9g+AXDLxh+
wfALhl8w/Fr3Z9axzJHx10fxC4ZfMPyC4RcMv2D4BcMvGH7B8AuGXzD8guEX
DL/W/Zl1LPdljhN+wfALhl8w/ILhFwy/YPgFwy8YfsHwC4ZfMPyC4de6P7OO
5fkM/K/iFwy/YPgFwy8YfsHwC4ZfMPyC4RcMv2D4BcMvGH6t+zPrWK7L7Bd+
wfALhl8w/ILhFwy/YPgFwy8YfsHwC4ZfMPyC4de6P7OOpX1GvQ+KXzD8guEX
DL9g+AXDLxh+wfALhl8w/ILhFwy/YPi17s+sY7k1sx34BcMvGH7B8AuGXzD8
guEXDL9g+AXDLxh+wfALhl/r/sw6ll12/O8fQhW/YPgFwy8YfsHwC4ZfMPyC
4RcMv2D4BcMvGH7B8Gvdn1nHal9bx0dmYR0fmYV1fGQW1vGRWVjHR2ZhHR+Z
Fb9g6/jILKzjI7Owjo/MYpu2btbxkVlYx0fmLH+nWvwOkcF+91RtXRMldHC1
/xXbEZA5L/GaXMSr8uDpmX6NJfb8quqDqQ+mPtji54fKWhn1zDI57X//+yLA
tAemPTDtgWnPsi5hme0GKPyvlR4KU/2B6Q9sLddhqj+9fe+M+fCX7zP+vhBg
+gPTH5j+wPQHpj+wZd58ZN+Mch6Zft4HhekfTP9g+gfTP5j+9fYfZPx9Iv0t
7Stsl2kXwassWIAZD5jxgBkPmPHo/Y3NaNdO0B+Y/sD0B6Y/MP2B6U+vH5tR
7o2qD6Y+mPITM9bpsyoPZvzsP8avY8t+tXGGH+hg6PSn72cw+gCM/HB+wHjY
7/QPpj8w/YFpH0z/xOv0B0Y/6PpCj3ehMz4w4wMzPjDjA6MfwayvHn/r+k2P
x3V9Bx39gv5i/GDGD2b8YMYPZvxg5AuM/tfperyt6189/tb1sR6P6/oZOvwS
v6IP0LfwC4ZfMPyC4RfMftGxHm/r9kGPv3V7ocfjuv2ADr/6eYOu34ln4R86
/IPhHwz/YPjXsR5/6/ZKj8d1+6XH57o90+N13b5BZz7A2Bvd/hDvMh/QmQ8w
8wFmPnR7qcfjuv3U43Pdnurxum5f9fhdt7fQGb9u/4h34Qc6/OhYj791+6zH
47q91uNz3X7r8bpuz6Gznrp9x77iv4LxX3X7q8ffuv3X43HdH9Djc90/0ON1
3V/Q43fdf9Djed2f0Mev+xPYc8av+xfQGb/uL+jxt+5/6PG47o/o8b4+Hr1/
3f/Q42Hdf4HOfEBnffFXmA8w/IMZD5jxgOFH93+mZOBA1T6Y9sHwA2b8YNoH
409Uz+ArQsV3YPoH0z+Y/nU6dpHx6OWhMz7ojA/M/tMx9dlvGdsy3V9j/cHM
N5jy+F+UB1MeTHn8GcqDKQ8mHsYfoL61v2N/F0x9MPoEe0t9MPXB1AdTH/tE
fTD1wcTn6HPqg6kPpr5eHv1IeTDlwdgPXZ/q9oH9jLzo+5/9R3/sF/oDs5/B
lEf+KQ9mPsHsTzDt6ftHl0fr/WR/F0z7YNoH0762H4Ven/UD6/6Dfp6trw/6
03KOFZYpP3HS0n2UwtB7ZtSPVXTwn5nzYOnfpMqDu2aU8xV1MtoLUeXBlAd3
toxTzMwo56vqg6kP/p4pB3MysJuqD6Y+2CnTrhXMmFdn+SJjnHcEmPbAtKeX
P5LRzg1BeXC1zHXamcHXd3nTMl+Z+uZr5j14hMIpGfWDBZj6YOZbpzP/1P+c
UTBazScYOutBfejZMvgKkTkz/kZkxpWBkvXwsMiVgM78g2kfTPvgz5ly2Stj
vIGZ++6zANM+mPbAVTLacxX1Mv56qfo6Zn1pD7qFD1e5MIP+KpPPtwojDzqd
9Q63rLfCly3lBeXB0BkvdOQHDJ3yjB86/cVkrOMO+a9lnyoMHXmblbmPoSOf
YMYHRl7BjEcv3yZj3M8F8os+ABPPo/+QT/QV5a3PR414H4w9QJ6RHz3eRl7Z
D9bxeoSKt+mP9qzjGZOSL+yltf4za+eHJiXv6FtLu74S/YO8IH/obzDrq8cn
rDd09DX+D/VpH38cedXjC11e8dexp/r6Uh/7o8svdMrTHv4c5cG0j7xTn/ao
D/+6PsUeIZ/K/8+U/4xmaqRJ5F3HFrky3jPp9gx9DEZ+WX9dHsHQ9fMe6MgH
8om8gWlP18/oR8rr+hX9h/0C4//odF3fIT9g5Iv51fUT9ZFfMHQ9noaO/6fr
U11/sd5g5IH11+Nb2mO8enyrj5/+8LfA+D+6fkS/0Z8+XujIF5j2dP2YAbtH
KXkFI29g7r/QB5wPIl+zLPpAMr+cn3C+0iuzHutLf8g/+5/9wf4Hwz+Y8Vmf
90Yo/Q1mv1jfFxn+IfoY/Yr+xR7r/oeOdf2r+xf4I2D0Me3r/grnb8Tr0MHs
H/Qn80t93f/Ev7bmx1/pb8qDaQ99Dh3M+sKP7t9CZz/p8sD6s77sT+SV/cF6
6/4K9cHUZz8hn+hvyoMpjz7X/S/d/6Y9sO7vgBm/bh+wJ9DRB+gH6My/0jeZ
49P3t+4/6Vg/3+L8h/miPJjyzA907KMeL6A/4B/9QP9g+Adb329h1/BLYhV/
zD/t6fLCeGgPjD7DzqFP6Y9/t8b2d3V9w30Z7YMZj8VvTFLjBdMemPa4D6M9
MO1h32kPTHvW2KzK0z76jfbBtI+9p31rf5bzI+O+Cn1Oe0q/Z7aHP0B7YNrT
/QXuV2gfTPtg2kd/0j6Y9nV/Q38fiX7DHqGfwOg39jMY+UY/oL/Yr+gX3f7r
57fsD8a/OeOvp5JX9iP8Qqc+mPnivQ71wdS36GV/1R+Y9qyxWe1X2sdu0T6Y
9i1+XphqH0z7Oh05xT6Dibewl2Dki/s26NzHgYn3sb/cR6E/wawf9lE/72a9
0BfoH84/6Q/9hDyD6Z/xYh84jwQTb+n+LZj5Rv8wHj1+ZHzMI+Njfhkf/g0Y
/8zaXwlQ/ov1fZhJ+fP4G4yf/cH8sp/A8EO8Bx1/G0z7YMZDffYv64m/iH3F
f9DtL/aB+YRO/9DxX/T69Ic8Y3/x13X/H3vJeSTyRXtuGX/fK38b+4S/rttX
9IX1+xDDnrLu9G+R0xSlL8GMH0x5y75JVOXBlAdTHv+Y8mDKgzkP1PcPGDry
TPvQad9avu3v6v4A8kl5MOXBzB/2AHkA0x7yTXtg9jPyzvkf8sr+BkPX77up
T/9g+lf2KLN/MPwgr8iT7m+hv2jPso+DlbyAaQ9Mee6H0A/6/Q+Y9WO9reUv
XtXH30A/6v6Gvv7oL+Yb+8/5LfYd/aLf94CZf9aP9qFTn/VHnxE/UV7dN2Zi
7ivgXz9vBuNPKH81E+vnCex3MOtpff6YqOwh/iH2AH8POvyxXmDmn/mz1v/+
Cuvfm0Bn/pkf9C36Dqy/14eO/o/JwMZ5hr7f9Ps85B/51v1nMOvBfFBe94d1
uu7fgqGzntDByBfzSXkw5XU6/hZ0MHT8Jehg5Iv5ArMe2EPsERj7hX8BHcx6
IN+0h/9Kf+grMPxjn6kPZj319lhP2gOz39EHYPw/5E+PL5BXxqPrU7C1fTDk
Xdd37C/2C/KCvkA/gdFP6A/WG3+S+BB7DrZ+d27jjPzq3zMij7THfNAeGHnQ
36vp91X692Osj2UY5izvhbAn+EfEF5w/wAd02oGeQe6eqvwrMO2DKc96UF5/
fw5m/rE3yJeyR5ntQac9MPpK2Z/M8mDaw3/Af2Y/wTf6DToY+cX/ozyY8mD0
N/f58AumPpj6YPrDXhGPYt9pDzrtgWkP/C5TL2T8fw2Tqo/9oz4Y+4U+Tsro
90Lm/klS8wmd8yWwdfyHP2mW+n0z64e+pDz7FflnPyP/jA/9QX3Wl/FAZ//o
+hb7hD7SMfuL9dD9R11f69/z6foZecN+Yl/RB+hvzgexJ5zXYT+YH+QbfYU+
ZL0tf9LkAMt/CDDriTxAB9+x0BXGfoPR96w3/SEf1u+D47T3wXHae1GT9l7U
pPQ9/aHvwYzfso7xqn8wdIvcmBUdTPuMF0x9MOWRP/Qb669j9D/6TKfr+g6M
/qI88gNm/vX1pD/iTV3/Qic+1vU39gt9QHnid12/6/kV9PHr/GF/obPfiaeR
H+JnMPE47cGPnm9Aty/Q6V9/r0b/zJduT/R8Anp9MPXBjFe3N+gf+AOjH7HP
YOvzCbOio8/RL8gj5cHYK857dPuGvqE/yoOxX/Sv2z8d69+bQsdv0O0p5Rmv
bi/17zOhU163j7p91b//1O21/j2obr+hMx7sJ/aD/pAvfTz4U9Cpj7xSnvnS
x099xgOGf/09n/69I3TKY88ZH5j9SHkwdMajf2+p+xv695e6/6F/b6rH2xb9
EqXmFzrjp13mU+dHp4PZr5Rn/sHMv84v9eFX94+gW7Z7lLLH3CdwHgfW3yNy
fsB9Cf4B9xucHzA+5BM6543cZ1TNGJ+POu9mfOgfMPEFmPrMP/4I48d+Ym+4
/7XY3zTtvilR+S/oX9rD38NfA1Mf/Yu/gf1lvLSHP0d95hdMf8w3/hPxFv0R
79Ef9p355bwG+WR92W/MF/4rdDDywngoz/jBpzPXGX/G+n7ApN5n0j6Y+tbf
+0Yp/w1+rOMndQ+k/CnWg/rW79OjhPV79Cgl32DkGX63Z/67ZwYhUp2vIT/4
58jfEwv/WfxP/DFLOe5Dk5S/g3ywnrp/hv+CPrGMN1X5K2D0B/4M+gOMPqQ9
/AHd39H9Df29oZ4fRLfXuj3W80tgP6mv20PsFfzo9kvPX6DbLz3/gW4/rL/D
DsiSD0C3H9Dx12if+JV4Bn8JzH5DPhgv8oU+oH3kkf2BP2Z9X2lWGHnn380Z
9aXab7QHHf3H+qMvkEf2E/KO/dXP+/T9TPvoS+SF8REfWX9PEafo+vew1Ee/
UB6sf29LPE17xFvW30+YtPEY33Ow31hPa3mJVPwif/r8sp55M+0edOv3Xial
P9iPrIeln2QVn+nvH8DvLPois3yc0h9g6MwXdDD6CnsIZjyMn/Ggz8CMV38v
Qv+Ml/Wgf8s5QZTCrAfxv7r/z9xfYNYb+UM+1H19Znnkj/bQ56w39pL1Yj6s
v+c15JHzGNaP/sCsN/aO/cL8W/b5N80ex2n6PU7xr59P6fuH+aR96LTP/NI+
GHlmPqzPO6ME/g/6AH8BfY0/hbxAB9M+96+UB2NP8f/wD/H3oINpH/+P8pwP
Uh5MefihPNj6+6w47T1Tsiyf4eActKzX8zh5MKPdg8Ixox9DPi37N029rwPj
j7EfoIOpjz+HvKBv0J/ct7EeMZnrDB3/jfZ5X0N5MOXZP5RHfikP/pDx97Rl
H69IksUz2lllmb/nadp7L+P9CvxzXg/mfBH5gI58cZ6n05kv7h/BlEeeOG+k
P84ndbryxzPbY/9jHy1+QrQ6ryV+wV6zHpxHEs/AP+tDfeSb+vr7ZOSb+aE8
7UOnfdaT+QFTn/2B3qM+/bP+9M9+YT6pz/xQnvFQnvHo57PsL8YHnfFBZ31o
j/WhPOOhPPXh65PFTmTGBeFqv+vvoahvnV8kSsk38ox+xN+hvh6/6fEadK9M
u8V4LPouUtl39g/64w+LHCn7YP0+3JTp33mKaxnlA5S/Af+/ZmAXxb/Vfk0X
yPoZDT1S57sVLFiNHzr71zL+yMz4xSSKWuy35d8j0/d/hgCtsuwX2zilD8CM
H/2JPYdfa38uRWH8C/SRPn7as87fauSzZf7xh7X3pFKXf+QNjH+N/dDlXZdf
/T4beUL+oHOeAYbO+mGPoHP+Aub8Bn8W+4m9Iv7g/hT7redXJf6BX/Y348Of
ZXzMz7tMPab776xfP8vGydSf8Zr/GK/8Q+Stfabe08vjb1v7k2blz+P/UJ/9
wv5ifMTj7B/OC8D4r4zH2p81K3uP/GPvsf/4s8g7/Fv+PUWLPwys359D57yE
83HmF4z/wHqBiS85v4eOP8H6gfX4FDrtIb/W99tRyr9jP6GvOW+ifTDxO/qX
/aLvP+wV8m59Hhyh+KE95JP2GH9SRj/umeWDlPyyf9F36AvkjfW31lfmTH68
MueLeP19pl8Uqu0HG2fkBfuRlFH+gtov6GPkCX0IHfmCfsdSX9F9Mvq9ouh7
LO0pjD5WOFMfg/Fn4dfavzUrf4j1Q5+C0adg/Hkw66H7n6w3WM/PAZ311jHy
g37U/Vfd32G9obM/iMeRF/wd3f9BvvB/KQ/Wz/31eIP69G/9XsE4R0cfQce+
oN/gR78P0O1LdSs+wxRmvJS3zp8GDszcby5K3rAn6CPsB3TiceQRe459sT5/
4ruwULX/0NfEN8h3y4zxOCp5tdQLV/sNfc748QfQ5/gDYOwH7TfLIFxX+2Oo
pT+F2U/wg35CHuFP11/IJ+uHPLJeYPwD1hs6GPtBvIE/iD8HZn05n4Buff9j
xE+W+UhT579gzi8t85mq4h/13joTY6/Q99QH0x/6B/2HfQRbv6eyccae0B7+
DRh/hPNm5J14D6yfV+vjpTz8gtFvtI/+0+NDzrexl7SP/tPv68Hwp/8eAf4Q
86ven2dizmvgBww/xKfW5/HGfTz+E/KB/wDW/UPahx/as35/YOTL4/0h+o73
kewzzvehEx+D9Xzben6TmEy7CtbzbVOe/afH05xHMV7q0z/tow/Zn/Sn34/j
j1Cf8mDK07/uj0FHHqiPvIORZ/2+G4x+wV4xH2D8Iz0et75/Ds5sL0TdL2Cv
iM+pD9bzHVOe/aHH67p9ZPzML+Nl/bXvtYTOjx5fUQ59Z/3dkK8qD39g9gv6
k/2GPQHr8Y31d85vVXvMB5j1pjzrrcdvYOSH8p8sdlXZO+J5y3ti4/crsFfo
W8bL/KI/aRdMvIE+gB/mY17mPsU+E+/TH/4iuITFnip7zfkfGHuMvwkmfsB+
E/+B9fdR+Kdgxk957CVY5de06Iks5znob/wZ/XxCx+jzgxnlD1rkdEWSdr+S
rDDliQcob7Ve/+/8FMx4mT/GC06yjFfd54CxHx8s/ovU41Pmn/6hg6nPeBQ9
E0NHPizrZfgnYOSZ91rEk8gn96esL/sTzP5FPsD0z30KdDD18Sfhl/NbMP60
/t5JjyfQ95TX3w+zHtb9p6jxIF/0j3xYn+cb8oJ8sp60j/yBkVf9vSnyw/6D
X/Yv64l86fIGHf0NP9bvBVMU3aIvU1W8D936PWGKtL5fS1X+BBh/A/0Exj/E
P4Fu/V4nVckX/YGZf+v38SlKH0InPoJuHS8Z7z2Zb+QXfw77iL+IPIOh418i
z9S39rcS1fyBmT/aA+v+KHTGC514GzqY9lkP9g/zx34D4x9a56uPU/4o7z3h
R8+vjP/H/uJ+BPsPhq6/14yx0quR6r0I8Tr0TD2T5b4Ff5H9jH9I+2DWH38S
TH30m3U+9Ygs+eR0/xM640O/MD70D/zp52HEm5b1CBWVMvr5qOJhMP6Rfl4G
hq7rN/wz9hd0+NfPh8HQrfM5mpU/ir+D/kT+8BfBrAPyCx1/hvrW78mjRO+M
/3DR7ld8s5x/YH9YH+7vWB8w85k7o7xrpjz6CNeM8XwRYPwjCw5R3xPgT7Hf
wOxHxmtZ5+/KnoL3WOy3sr+cr4CJ32gfTPv4i7SHfQbTP/4k55v6+wPOP5g/
zvNYf7BlfYPEmIz2HitcJqPdlyoesj6/ilT+JfIOhs76Qsdfzvx3td5g2mc/
QcfeYj+5X9LfQ1Gf8xfGgz+pY8bHeT7yxfmWxV6ZFKY88kb/263+PVxhxoO+
gT4g0x/Afs/K1EOsF/Ei9o39jn1DH4Ct76tSpfX9aqoqj71AX+j2EGz9/VqK
Or/AflufXxjvB5Fn6+8Rje/tsQ/Eu2Do2AviY/Q/GHvB/Oj2BP0MHf3N/EBn
PsDQsQf0R7wPRn8xX+g3+Nfv21n/jGrp8SDygj+JPIKRr5EZFe5l7hvjPQvy
2CHj731FR98gT+wf6/MCkzq/Rb+Doev7iXgOTHzGfTL9gxkf+xV+OA+mvPX3
dgad+u8y1xV9yX7R/V/87w8W/tV9Nlj/3g+69fvnVCWPYNYbeUeeiIcoD0Z+
sT/IP/EJ/iQYfxJ/APuov3/CHuMvJGbU/6TsJ/KJvOFvII/U57wEzPkI/XGe
hDxQH3+C/a7fn1v/LlOYqo89Yz+AKY99ozzxiH4/yn2U9fcANs7YY9bH+n16
qjof4f0c+l3/nlLP5008ir5H/q3zPZu0eNCsxgu/+ONg3ntwn8n9pP5+FH0A
Zv9gH/T3ovCHfPP+D8x42U/QwdCZP/YLGPuDf2OZfuP9Fv4DGPlgvWgPe8z4
0Sf6/S3xifX9fZzC+ntW+IcOf2D4u2OZD+XfMZ/ggxn0g+r9G/qB70/BnJej
Xzkvxx9lP1p/n2LjjPwjr9bfH6RKzt/Qh7SHfPAeAvnA/wAjf9gn/EHeF1nn
009R88N6gllv2mO8xItg4leVTy6Tb/39o8qnkknX83Hr8weGP52OvYcORp+h
/xg/mPHr7yeRV+s8Af6qvn4erPt76C/Ldo/Kos/03x9Gn4HRP8Tb6D8w9bEH
yBP2APllvdEvlmK8z05W53/YP/QH+8X6/USiln8kUb3f4f0c+kDfz7q+BlOe
eAX9Cx0Mv9bviaKVf4q+AbNe6DP9PTb6k/Nb9hfjhV9rfydRnT/DL+er1Afj
r+zIwLMs56a2JmW/9fMq/f0r9ob7Iv38B0x7+Ku0p+ePxJ6D9fgffwNs/X4j
RJ0/oG/A7D/u+6ATX9Oe9e+zBqt4Ev3GfLG+YNYfTPvES+x3MP46+oZ4hvkC
s56UR37w59Dn+DPoG85r9PMb6/OTMHWeQH/Wv1MWpO7nsKfYI+vfmzLsL/qA
/YK/jb2gvPXvNZo0e5qg5JfzAmt5Nr5fZL9Z398Y9y/oI+w3+wHM/Fu/79Pf
i8Ypuq5vdH+F/Qtm/3L+zf5jf1v2U6LyZ1hvq/uQ4knK/qM/92SUO63sPftR
/74/M04S1uflUcI6n0GUJr/G/Rx4gGV8gvGC1Xgz9TPjRV71+J/9hf9PvAqG
Tjxgfd4TpuIH+CMeAaMP8PeRf9Zb9x/xj63XI95aX7Yw7v/Yn9b3g4nW93vp
/hDtWdbbwMznrEy+8Y+YT+QHzPqwfqwn9yvIN/LBfgOzH9nP2FeLnASq/W19
/hoirPeHsd/A1u9rozX7Y+SjZX6Yz4x+Tyaq8aBn0R98vwTGP0afsH7sR+aL
+2D9vtjipkQqf572ac8iNxGqPeab91nUfzem7uqCk43vWYmHd62emKv3xzS5
ufa48BUuXkreF597u2uj82OFmY8+QV7Ojt+M90V7W9quyZWYJrs6ucQe7+un
9rfKdxF93+Zx3mTZeneXdY/XvVP7G3k8sC9v8S+9klV8l2Ota+4aA5OVf9bB
/czkg1WTZc6l/314VNRPnc+2iWw8bpitl4pX0AflKs38VviHBHX/87HU4Vcx
1Y33QsunHZrT2/abLHrq8uzSc12E7h/2iqi+JmbZN3nBbmWe2rOM722R24eP
8r449a+ndHee2tjbNSjL758HiLgCw1dMVPcnoZ5PnR4ufC/63Pi4aWcuf7W/
d8T+euhBV5Oy/3GFS+x7tjk8y/e1fZYfN12+6CFi9/hVPdrBW9Hz32h0eNE+
4/e6OQ/Z1/vmuaB1fqJi8S9fn8003t+Pf2H3cLVP1t/fLnD3c6vInQHKvtp5
NvLd4m78bnSlagUc/C4Z41kfFOvSShjvNXyjXhzqcMr4XvaAjeeGWW7G+4wJ
pyfm+GWV8f1sj8Op+3e2Tvffg3PNPdk8SMhpMSWPFU6RLeIr/9DmRz/RZ87q
szatE+QCx2/vLh98Lyd7/T2lzLMYuePHiP6DvrqI2GxTz8dMipGjh03JGegc
Jnqu++t04tjbssy+F2UOuAcJr2phnxv+9EA8W1931rdjYWK5T+HFdee6imq/
lrGX+0yidNsaTy+echNLZu562sAcLisVLtJ41lpf0WF5S2+H60HC32nQq6JF
/ETdXQkLHmefKk/9/Z97kptJ5OxbKuHJzDey0AbHzds3pMhLe2/dbfpjiFhb
5cDiH3OmSffd82I85j+XRQpV6Pr2Rbz8/K1fjs59n4sC5WPHTX0fL4/1feAY
f+OGrBTpPTSltlm2Px1f//C2Z6Lj1G7f7pWPlrcLvm7Uv1mULPmDw9OFfSJF
g3ujy5nDX8jlfzY4dOR+hIofW3wfuHpeU+M85Pit1rW7tY6XYoHj/Ijbj9T9
I+X/SVvXtPImsyxUoNiUiueN31O7Hbbwc+u0+0q/5rh5rFT1Hp4qfsUeRDaN
nzI7LU3eOFO37579TvLWmOT5I32NfOzr6799s9ctSRauWyymaVM7cap1s1qu
Dkmy0fIRpwsVtJMX35wZnnrN+F61dMcB97eeN+KfQ/Z5fvNxMt5nPDsbv8H5
kUk0yrZ41qrqJ+SSoyU2rT0UJ229C41dvvO4nFXUze/lgTj5anawx4apx8X0
zy3+OnbIeJ/x6M8DXSrtiJNtul4b0rTgDHVe8dvS4rMrPhiu7lu/F2sXODnf
WVnhUjPbe/Em+TjWZo1v2gHpu+7rjZ0+JvlknPn2oPe3ZKuDD44N+mZ8r7R7
529bT5dKUf5FLsfG9T5WSZET78W0mbPHpN5r/NrP1N7zpneW7wn8jzhsqtDW
V8zLc6vXtyZuWb4fKN/jQoPXZUPExVJrY3Y19NbecX0RP92d2vqn1VEiZ/kJ
U+p/dRU7V38r/DktVX6Rw965tQgQ513XNstZJUkOLPcs4Fk9H1n5hHujY73j
5WnboutTOt4SV/MtXtPDO05uKOLc3d/VR6x+cG/AmELf5ZOirVpsaOYuP69q
U3SPd6x8sHzXzO2vXcWzP05NaNA6Vo4Y1vGv0LsRovSiPcfL3nwpS7nYHEn4
L0TcK+Jd6NzjnaJ404mXs98OkE73lh2uP/+tiD+fY836QxGizeeXa/OOfS5m
PXIac3JBpJy153X3FsleYuFvdcp2OB8ibGo++Bzc1UvcazHZ4+qOSGEb+cp+
ZI/PotzF03cS7CLExeuxHdov9BFXesU/TSoVKCsOPrrgjSlAOFeqVTPGLkC+
O7gr6uObQPG67IHIUxs+iuVej/c8/h4k9hQfF7L44i3x3nP51+/fk+QgUblD
5TkPRP3pw2sOPWCWl1p0DllV7bOYkTPs4L1t/mJrvvpnbHa9F3mcXg+9WSFM
XBBXve0Tr8iywbMcn2833mv99iD09RxHI/9YQ/cAse+e8X2rb4XC7czFjN8v
Htms4WKf0un+y7g2j+zyXZZN/Vq16pTLLHPlmPbPx1srZWTnR1EFPhr5yUp0
b7WzXIhJ/j1rbNPZ/ULkuLsH/FqHpEqHxFXxkV185OaQ02VifkiV7uXa7H0/
KEDOLurlszZfkpzlXv7PBgXcZGSy/eU28Ua+r+xdBlzt1CBVxpny9Wx4wcj/
FVt96ZMCnY4re42/VqG/eHj5e5qyn9P3H5+d0CpVOv/gf3/uIiMf2O2lqSmn
c33M8r7k9m9JD+L3G++ND59/ETnveoqUnVvPLDndeA/Sptza4vPmu8s8rxbv
CjuWqPyJEYv71So8OEHpt9TjZT957jHLw7m9U8psjZIPil7Z53HwgxyQsDKi
6K4IOfV2Gaf6F18pe9s697vJW3N6ydqFQ564tjJlyXc1/l7U/VEl38lC4YW2
h5wKkS6ep9pHnvzbyEcUGvvwX9sHcsif969FpBr5ro4Lr4r5FkfJPZ0DN94Y
rH7HU7rsnDvw67Ztslcb1wabyplUPKD473bz5s4SD0S59T8eHTDEpN47VBiz
tvqXdZFZ3jfMW3Vt33p3ZxFXe9iQJyVMyl94IrNNPLgtRHqN6/M0LvGTGm+J
14sbzx/sIg6uqHr910dGfqq2u3ZX3J4cKY+Z13z7s3KQKHYsNvTIUR+5+872
H2/t/iLcbbcFFBpjvE94m2g3Pe+GUNlswddTBXsFiX/P5v2xSr4w6TxlUnzF
0EhR8PW5p8UPB8ql25rvn18tStwMbtt/8OCPMuTGCt9874PElxlrBrXsHKL0
2ctWMuqPPcb3GRVX/56Y4mB8j/HmaPevHyZmzc800ubcn7tumcS67Wejaq31
kVOqb92YY3ik8PR6HRR6Nmt+plmOaXa5e0SJZRu653H/28i/NM/b9p8JH43v
Nzo6znCaXdXIt8S4RNGfR71MMImVJ2vXPtfLJAJl7y9d1oaL5TWXeZzp8Ua8
L3J67M2tKXJdv37Fyr93EUXcwrP5VkiVoza+6L1LRolFa4POTsz/QZb5KeVl
Aycf4fDXZdfx0V/Eq+WLOo856CM+5e1RwHZxpJjTPOfCP/9wkUE93tSp/DVF
/rH93pe/+7yR/ff/dmvKlO9Sigk381d5I47UCdpabfZ3ub73wFd1xp4Vv/+2
+FiedDm7YVs79vd/L4l/vPOsGJ7PLI8ffXnlkUegWPHjGbd8cc/FpNbLK+TL
FiHLeDid35LNyC80171r0TsiSpzo0KdHylXjPUBqA6dfWv9sklX+aZRUdUK4
uJ7j9z6792a9///zlq13fLEIUTW2fsWXJZ6IwzfOfD+TGilOjuo19vY4BxE6
Pi0kx58mkTLh3tGPT24KD/PrQTf6pc/jb/vs1peMEB4rAmb3rBIm3P5M7b7c
zcgvxP1jTul5Nl8vs5zpaD/sd5/H8muVYUVSwyKVv3M/dmch+6VR4mLN6CEu
Jx9mySdUy6HO/ZK7o8TjIb/2delnvA/oemx7s+C7We//N15PXvh+aIRoeDRb
8YBu6fWmZy8/OD3eanxnZq6iXaNE+KB/L7vNjBSlWruOG/vQQf4X7jCpxDCT
cDv1NqHwupvy5eZ/127rbPgrW+fWn3owyngvELYsR2v7e2nqvn/+kPVFbZel
yCpncnbIdiFY6d/1oz8UqREdmDU/0PLd/Qr8bdx/bI8757Fj4Ht13xk1NH7e
lPS4/euNUu9v3zDy/wz57Vl8mE1Ylvw/uQvWDXrWzUnFB0tO90s7se2tmNSj
/rIcO4z8Pysanrc74mnk/4Gf7q/ezpl410Od9177aWDNlSVcxOule952r+ab
Jf9PzfEtx8T7+oheY1yeLnT3yJLPZ/TzG/8t+WLcz62oX7haHb8AUWXfsPW+
27zU+f/C8iMGmd4Y+XuO/D60Q9nQt6Lhtc9n2m8MFxOXh++Y2dbIzzPpj5Z5
mp4z7vdPjWrW6a3JSbQe7/Tb39FRIu/dB1dOFLgvHm5qHdzMOUo0ffsoKWBl
1vv2H+KHzXL4J16dhx956PXo5D7j/j3Pyj4bTwYa+Wve58rbvekHk7ov8Pw7
24A7m4NE+KISFQc3i5StZhTM07KNka+mU7Xq7jNTwkWLDQFFs0+7L3/+8nrV
1YPGfihY7I88YdVNIvrcgfr7Rt/Jch9fqP2z7z/tMu7jV69e2av17jg5YVjp
HDOKO8uCsbfK5qmTLENmHyhxJlLK6aVbHO1RK1k+H5s8sJDTNdnx3Bfh4mHc
x38Y+/O+l85JMnrJ7auJ1Yx80228CsdXa+YjxqWlDM1fLVXeX5e/Yb1h7mLA
o7r5u15MlCfs1vf9/VCUeBAS6X0o6JoYsTnb2WWHQ8WWAdmT204NEp9rVMsb
WTxK7Hw+xO1b+yBRt36v0QPtA8WVinWXDU3XR6kTDo3+tiZQOLiaT6XsjBLl
zsWFH0r3u8b9+arMsNzG78vs2LB+0Nx3SbJ8N4fe64/ukIkucXP6pvPv+cuu
YuX+PSB2HO1f9JcAk8xbuVGrE90PiSPLer24G2iSp3IfGfiyl5+YOdimUceU
NFm4Y9/AgBxewnz9s0/8sGR5+Xn2X8v2eCdGfq20rkWNBHn8atzK7/NviPAc
5boENjBLr2zLIpxX3hSN3v5Yql4zs0y9uW9scmCEKJmQ4jqy4VMRliP2TJe3
fsKpgEf8+5kfxU7v1W6Ju8NFndFT/t641k8U7FsjV+cr6XH0gGlz798LFd7f
b1w7cCZY5Paf9shtcJh47rV/e/0ldvJVcVlo/vUk2bvVrSs5U4aL0HLtKvl+
S5O18r//b3yu7WJc64ErJ6f7Y+6OwX8suXBd3XdfmPzt3doxfrLRy2VFbkam
yTYrnM7GDA6SHZNqzzj1LVn2bLDPYeccP3Xe06larnufa3rJLysStrbqnSzf
BL1cOLWLnzzivNL2UK0E+bzWAVl3/Ds5v0mtoTPLJci+nofn7wn9JGu+rrFz
4oZvclKNK0ML/ZzuP9cdtfzSbrMcfbDh6WXHIqTHs9HzKxR8LYOOyoeNDoTJ
Fi1nXV7Y9K5MurJlWM1lEVIk5V1/58IzcTuwYbdiuSOkU9CC2b7TXoolp0zh
dktMsubI84sG93cTA04Gbfa9FiQrT92855PtfTH04qz5X9aGyZp9wjYGV3cV
VQ+JlVev+ckhrk6rS5T/KGLsZiV3PxQkJ369kDg9zNc4r4iT+8c2dxVzDgzf
XGl5uIxZeLF8+3F+4teEy+d7hntJ21K3Gwya6C92rBrzx6jdwfKfq9PeLmkd
JoI7DkkaftBPPpCOQf5HQ8XuIh1z9Y0LkMMGf28YP9kkanR8v7fkhPfyrzq9
Cq1PCBWRzxasG10sMEs+xXed/YquyfdCnde1PXS+uauXkW/sUq6k7nvS0u3R
k3ztHg60k5O+x2xdkWacp+bct6NAmIMRb7bcPGrMreR4ObHJqp+Syr7Oki9j
Ve3Cm5ccNvIptR4f/Kl9vnR/YlSjxw+PvVLvKWq1GtruaNdIUbpwzK2a6fas
00R54/HnlaJX0xtLQ9Pjjw8Dn9zpdHmVOLDML6mwRzreO/u8bZ2XYs3SZjFd
Pkao9xKhm158KFA83R4ebdvtR5vb6v5t+4Mvuct88RTNx/fqE9DTyN819+8Z
T74MN4nI3TmPmhyN32vcc6Fpd5u6D+WWe1XP3esULy9etR39Ns9D8Ueb/07G
dY+X3QrsbPto/AMZOG1Os/JbzLLblraVtvS+Ko9G7z321+skWWff0k5LJ16U
yfv33t72IElOPXO2/7bRyU4XXjvu/F/8v6n3YXGtQnI7x8lrEyr9v/cK7j5P
cy7OlSwDly/PPtpeZsmn0b3h0A0HPpvkjImj/qgUuylLfo2xjZ/4NT6bLN2n
D16/ZuBD2erF0VpDRidLp8c/Dz2cnC7f0YF1mhcKUe812/VZUuKIX4i4fa5G
rbulTCK7Z+Tpb0MDxOku3S+NyhEu3x2zHfUkJlw8EsU7nNkXJJuvCZhduWGE
aHndcbNbkVAZ+O+owAAfk2hZvvDVyReDxOTe3uUf9jTyjV70KV3yZHr9Mt2q
N+k00cgvNK1bXIUSz4z8owUfuo9fUDpczLS9Oiu8aITxvVh2m788p4QL32b7
9wy6YeTH+Hl+6IfQCj7qPKn/pBWzrxTxEUcmveocO8bIj/8i5LLXGOdY9b7A
02nr5IpfYuW3Rz/sK9TdyFefUCJ8W5fFEfLLotJdH8/wEWPGJrcf42rkm+81
5uWVPLcCxPm0Le0WmozvQ/bHHupS8K1JBC8tUyl2wWv1fuKfbmf3Nm7yTPpX
3jXhxaV4ObzivMrxf92Sm5Y3qeTvEScfHIodEDnsupzc2S7u08M4Wafc6raX
Tj4TTWtfejTroZGfYMWCAnN/6myW+W4tbXuh1E3Z/vnDQlXqGfkxZuffOrn5
50ixM9/niTlSnonyG0NmbF4SKbINnJ7neZPnotqo52MvzIoU4ZOTxkdGG/n4
uD/NdeXo36cOm0T51sNPhjyNFGWatRt/a6zxfvXEnR+HXF0dJRwGb6zXeZyR
T6PXqUEvd093lqnefUvdLREv13v5b3izXcrBJ+ptGpQ/Xg7rYLureJEHcuPl
b48mrDfLX1ODXGdH35NzwxpOM/1mlmF1Z//y096jct3GxIhWj0xi99jW7cZt
2yPLnzIXOffSJKZH99q9+M0O8W3UyYYz0v2HTfvzLQo9/FyeKux2WoQmy7pB
bU8PcX4qHeWcbM3vJcveHybm7LH4uWg3zn/zPVOyfFxj8k0728fq+w/ma9bM
bju22CdLe4cFf/uXeK3u28Nbz3n0/cJraRe+t8WCS0Y+jk7vBldbNTBaNrp0
tPLOoS/VfWeZIteHZO/3RQQ0Kjqo1mNf9R7EcXKj2lUr+Iul9cbOaDrOR90H
P2q+7+znEh/EwDqz2p3eGqLycxz3+/rUZX2oyN/jW9M7Hu7qXrz42vM5B+T9
It76L1/dtotJTHQ50tmxqo+KH5K6LHPvWdlXFPy8dmLZ3t/lvcUnEktscRX9
Knt/XFsrVppWFr0xZFeEGHTkTerI3T7ihc369e2eBIqIp12HhYf4i1Krt5zz
uBUoliTdH5aSPUCcONzbsWPLh+KvWR2Wzp5gvLcK63lmxsiIdP8tNtL+fmUn
9X3ff7tjvS788U483fepXbfHYWo/2K+eWzkhPk3a7PX/ZUobO/l720+dJqbb
j1yTRhVYsWWnnLao7qcJ343vn0bN/nDmtxMm4R38W5H9Q0/Ja6+6lNhywyTG
33FwaZz3rJzsXGrG4svG91ElL2d7n/Iu3f9sN6/6m6SjYsOVmK4xz0yiaBH/
s/vb7RFpz8yrlr01vp+6d7Pb5y0XTMIUFzYn5Ed7MWfIsttrDphE4RFOI6LW
XRGTZj57YZcu/4vqFHTqk+eUOHozsEB9J5Oo/6H2pq79z4qYWQu3/eZgEvtD
/Fd3C94sHUNbJ6e4mES9C3Pdctr9KZa8kd83fzAJF5tavz3oukX0n1fdvb2r
SeQKGf64cQ4jn82Xca229XJwlV02PLb5q7SRb2PciBD7XJNi1HnWti/T/22w
PEbOsNtaJn6tkV/F5ofVzrXyuYtc1cYc8oyKlQ8XTBm29XWg7OAX9WD4nmfi
0LpVScmOgbLn7rCDtj8/FyVv20bMcvMXG51/Lhx+0lVsmj2t9vfORj4Ovsco
/drv31pdjPwc1y9vWPq3yUWMyPu609n6Rr6ONfa7u4YdTtfHEfM7H0iPz3jv
MTpb0dGPrz8XU+8UKN30eKCM75u2dPUXf/GuzPNxTxzC1fky5Y/1HGS7bL+P
iv+nxW+/+vvZILFn7OOiJfsb+Tpa3Wzea3palGw/PY+PTYsAMfzKlzUlmhv5
OtT7/62Hi7otChCveg8vOM8uRGz78VvkxDEh6v3K+iOViq28ZHyf3KFHpRp7
/ggWFf/ufj+pipHPo5/L6BffRhj5PIjHi5TtYCefB4jO/3kNqVY8UmxaMOLs
kgYhip9dMxYk7ahv5Pdot2vhtcCvQWK+uXKuVguy5vtotWD1umNTI9V9sP3F
4vEFYyLFDb/FDi88s+b7GHCqUL86TY38hRfbfprW1D5S/JMrMeZhejwUUd95
WY8Uk7h/73TzX5KNfB859/m3GOIZII5FxLao9/Gt2g+f7tqOMZ+Pk7XGlVm5
7ZWLet/BffAv3RsPf/c+WkY7/jpn7smrolf7Qd5VS5pVfN8p6UhqbI1wsfTv
oW+ddxj5P0Z9uf7zvTwR0mQ/s/74r6GiU/f2fTtefCD7v6vp2Hd6lMrPkb9D
Yv/NvUyiYvL708lvrkn7A6kvPaeZxLFLC56XuXRK3LpS4dLjeJO0uX/kQ8rK
cPlHpZ3Rrm3eigHHbZpMcjDy4c30/zTBf2OorDEmW6ExhT+K0nb1mtlmM/Jv
OA6uvPfglhAZeatCuyodQ9R5weILjx9UKR8sGjS7UbtdkpGfo23uJmu7Pnkm
fz1/L+flYtHyeKeSgbn6/Cc7VG176fHP0XJEYJlmAXneiLpHy99q1zxC9CpZ
7tjf84z8HHx/4xV+zHnWmgixM8eAUYPS9wnvkRrPLbo8arCvrHj2WpVXqanS
51GrzSeXG/k61rl2thdjvOWchQs6ujQw8nG8CRr5qUh4siwyPcS0cI279Kl8
cMpB5zRZqFAX/xKtPip/9VylHBHu9Wzlh2V5TG/S47PGT3rN7By8TT4r2Uxe
T9fH4ZcrNfmpk694nVzH9kChNOnT51Xj+7ZGPg7boq3vHPg5UNy+tjO2Z6lk
6XOr+q2HV4x8G8jj+w6/O7Xcnyz7THIbVMDDQzbcNChfw9lJ8luh+8M6bvZU
7322fZyRYEp2la3C6s/M9jFBfU/aZMuENgk3E+SyYhv3+dzyEI4vzEXaLU+S
A8vvu3+7h6d6H8r3XQWdXLsE9/8uo0ctrda5trec5/7Up+okI39G+cJrr+Zq
Gyftyx8KfrffQzY9MH3x3Ctf5YWZdqWPF/RU+TKcm1ZoeGfKa1F72rMH1xyN
91LFQ3+7OT0kWi7J5xBy508PkaNDrvJOzl/l6ry7Hs+yN/JjXPEpu7pGup/S
3vxB1vjoIQ8OyJ2rjVOkKCCHv8ze9J2cneup/+RHxu9V/PDqxb4xj0NF2ScB
Fz2WnZIXt6X0yt/FyG/Bft4/f0pim0X/yhF/HcpTcnGkrHT2fINlfs6i5v7d
3Wv1NfJj46+POFB9d+sfnonlPoPXVztuEldGe6158GyH0m+2q6Y3ujjHU5zY
c/P3iY2MfBepDTt2b5LfyHdB/6faNzl0xNdN7LhjZ/91V5SoWvjocse5Hkr/
PR7S7P23qR/FJu98i0899RVD8iXUHvmTl7o/32hfv2fQMk/xYOSyonZDjPwW
E0s7VC28Okz+ElF1iPfgADFg384GJe2NfBbPXq/63a+Kka+C90vhNv/O//pH
enybO0+f7cf85dTLA9enOhr5KRIWbIptVTlEnCzbf2TbcDfZ/P3d3NNnhgi7
KQsSCn828lEgb6NP55r9fGCoWDxlwtaG+8OE96TzSYUXpPv1xfIPeOJu5KfY
PrbbtCHdTFnzUcjiOx5fDhcv8szueq5zsNJ3f95Lu+RqY/xeg3/4ldg1O3xl
mTkXbwxbES6GFFzkkjvGyE9Ry6n071MDvOX+18V+7f+jSYQWPNm1TaSRf2Lm
1XlrzI/fyiezmpXzmxEuXEJtfm7r66Lq74+9WNTllK+4klbbr2e6HX4U3Wpu
Sikjv0S1mSXdE96kxyG7Fy8cv9P4/eLpkec3P/xg5I9IrfBi8M10/yTPtsD3
67uHZHmPVrfk9Z+2T4iWYQMKHi3pYOSPWJr3i6uz48ss+f73lSp9PdklXBR1
GX7sSQ57+bXDyqCd/+8+smSFewe6LjWJpEW/tiqY77pY7nfi1pYFRv6If5Yl
Ly/7t0nMdV1daH2Dq+r7va6JSY/3jHkiVx/aW2frmnjZ+Ns2pxtdH6v3Y7wP
m7A3YOftkfEypMnbLufPPJYjx+96nvLCrOgdN+yY/MjBLMsPLZRYstFVsW9e
8oteLkZ+ffclXZ+fupQk31bv0PrZ7Z3irwL39za5bHxv/zFgyvmXF5NksYWr
rz/9slPOWRp6YGB6+SF7K1xb13S0TF1r/+z6+STZb/2zUclbtsl77uuXLEgv
37LbyefffxgtWhyrPPtlOn1ZuY+lSttvE02bv6vw6yXjfNNmXZ2eH8/EyepT
Eu8vfX9OOts/dFl9Kk6aN9f1jU/YLh1yOzauscvI3xAROfXWqh1xMk/O8iuH
vt0uQkYkRFTcbeRv2HzP+0PunXEqP8PihJx7V037IMN2Bso+fY3fmxsx7E4d
51p+0veXxIQn+ROkd+ecNwa29pWnRh5f8UNLI99CWOqnBbei42R87KWyn/Zd
F/vvdurw4Hmc3HDaP6DlRWfR5krY+R5V4mWlgu0OlBgqxeeGG4s5FYmXj0af
/zjCMyBLPsBDrmsvOfZ/rvyleLdcC/o89BJ58jp1GDni/+XbWTd5kP184/fh
liy97dzP3vh9OMbX4sWz3FH5kuUvx9NiV3RyFutWBMxr1SRZNnzd/mnKPSm+
Lpu37EG9ZLm1V/K+W6ZrotGZIX0WeifJ0Ea9Rv/geUXlX6i+sb1btQg7ZX/w
lzbNzbG528Mk2efDo382+9vLZfZB499ci5MDHX/dO2HLJdlx8ujfHl8wvjdb
f/Bkx5bXjfcjte9GyAUH4+T52Wnjs815J8OfdH5Y7JdUZQ97VcwefvRdqryd
rV8z15HvxPHt6xyydzDyLdxqezMmyjdV7v6n5o9uf7qLC03HN/N4niZneFyd
tmiCm9q/fbafv3x6lI+6v8Z+VqldeGX/2FS5KDanzZK23uLDtG0nW7VOkSV8
d3bb/4+X0L/nyD5ud/XsuVPU9xzZt51/Hx2XIqtly96j7TVvFS/fbePoNrJJ
sOj1vNqdK3lT1fvubk03Jl78ZORTWNRhfEiPJUlyQuXUn8u/MfIrrCz7z6Ip
ff1l7htnujmWMvIpeJ+M3V63boJ8/OT+2mrNjXwLowqvGO5axfg9MeyB38dz
u2o2S5Sffjp1KaWTn3q/9777gnylvd3V+1nuPwo4/tjyY48k6ZfWuewpH1ex
IKnNmsN+CbJR1zoP+vR8p97vMf9dw/dEv/zPyL8wfnqRox6rEuWlEN9KF1u5
qff31/9u/sb3J3/xuWq955XrJ8oeOUtu6hZm5F8g3qqft1GLjxMSpe2sCyvc
Yz+LTdvmHZ6yOE6eWdLoUnTyJ5V/gfVYYDfqxc1xcWo9/GJTUlr8lq7/Skzv
UK+Ot3ovlC3mZNisHe4qPwPvc1/23n+qy/qvclS5Y7OOtXQXev6G978ca5t6
5qvcG7m9TNQXI9/4utR6p0z3wsUl+WdymcRH0r+NY6UiVbPmb3C0c97rOdTI
m3RgQ99+zeoNlK+eeY2YPcnI5xC0q2Pk2mUm6TWxQscXezao+M23TlSFqWfP
ie+me1vD9wYpfyd63PgmLV2CRYGK2/IUPX9dZHerFfVxU4h6n4C8Be8Z2ORW
9FXlr2ya/nRNwAB74TB1SovuByNF683Lutw8cV/8uXWi07GpRr75MYPvdwhb
ECU3eif+dKCqh4pHW/Sq8GpCcS/huLfF740bGvkamu86lNYwyMhPnxTv3KbY
2VDx9oj99rAJH8XnXe4Pv/YLFc8qNK6W8tBDOPw4/c6OPcFyZMkZi3uEfFH+
xMJW8xcGzvIVr2b0js/eM1h9jzHjdcW7BWsb+Rrwh1Y9nDjbZ5C3GNpmzOrd
04PU+0r0ae51ef+qedNf5UPoWnTHgUdbvUVwm1L79lwJFitOXst7oayRz2FI
0/Uv+j3xFcMcCo7aNNfI97CuSKl3YwaEZMkHcct3d6GQbOp3UWWFzdOubf7d
T6xemVBhbEWT8ucmjBx9vpiDv6j3r0cx+TFYpM64PeVDLuO7KeR/5fVS659N
CFHnDVsTVp+/2DpI9Ht+6MB3k5Ev4nTr56uPJRm/76nygX640M6jQqDIVmRU
51X/Lz/Exq8jgr9V9dW+h/MVCbJmQZctEeKfUYMdw84bv0dVtK/TV8/4SLFm
+aja1Qu+l3/9kuu/2iJKTLz/YmhcRVc5O/WVg28xX+FTa1e2AZcjRD6x7W3u
Sunx9f1tE0onpcnFudYV8TodInwX2371XGV8X9olsczO/cu+y81eHZ5v+ddF
dnG/f69sxHc5tsmw2Tfzu8gnlf2XbnH+Lmvtrdl15ZATYt2Rgku/HYmTHlUX
H19z6Jyoerb78tJn42TpP0pXNDnbC5vYf2oXvhknJyxonnuy3yXR6vTOZfev
GPkhbgweHZ+2+bt8nVJlwOFO78SD1SW3L6+WILuWGFq+ecxbcWmj/0in599l
jWv97/Qs805WNgX6zbWNkf8UHFCv+81Pomfrqts6HzTyQfStGpIrRy6zHOP+
67iCX43fh+pg+vA60jlItCo/PnuNkAci7wzXhUlDg0STA4meASWfiPbhVf3K
XI+Uve6GOtv8GiWCR7zo1a6G8XsxDoUH9BvsECWPt3qUv9Yw9btOsmv5sNCy
tSNFzX3lp5ctaMqSz2H5rnWvVtoa+Rzypx4qOlNGio/Vevg1vv5cnjmWNubT
z5Ei+2rXFh7xz2TFq1vnRP9u5G/4EFtj3/kaUSJPT3uX+x4PRLb3RTaOWh6l
8jXMLbSq95/p6377eMXZA/+LEnX3fnM6vsD4fafPvmPuek2NFCV29y878icj
3/z75Msvtw4Klu0WhmXrGZUivZ78U2H1f1nzLex6P3vricOp8je3r6uOrvLJ
kn/h/ruJdczvU2XcwIpTGg4JlPmyTWl8ONXIt9CoUkqOsC5Jsn9qnWpP8xj5
GHjP0DqyQ7SLR4os2TjIZne8t+o/LSE81+R9bup84ejDfXE1Kn1U9hP7YHu1
+e+FmyWp+5KN0e0uFpmebp/arv3jywK3LPkaxLW2jQf+GC9Thx3+JXyDt3q/
GllzbcE2e8Ll8Pd9tvUJeSyz/XBn8kHPsCz5G6a1WL5l4uFXMqHT0TybjobK
b8eKdY/Pf059X+WUzS7W78UN9V5lQ+jYUnmrb5db25RqWbqukc/BL8/Mj0d/
Mn5fwfwyWXpcDJZueR1u2H37V+nbFdcO7tzR3FksKfvLyEOzglV5X+eEfZt7
G/kcWK++65pvyVPzojqva7J21eTLVd1EzR/zd8zuZvweIfRDt3N3e/I6QL0/
yfvzqn43owNFF9+Xtm3+M/IrXji0pFDFle4KN43J/nJgivH7fshD58R7gzb1
MfJBLO6ba+2hbuEq/0PLud3ndvONEge6r3hiN+uOeFCqWKHT1U0i5e2i4OuN
74uvP5WePOlOOj167s7Gtnbi7f2zn7Ony8ulaj0Llbhtkjervvxv0yz13l3m
c9t9uXdsqHgy7UC1sgmmLPkeJh4PrH/aJlxUK+B4ukDqU/W92dIwz02Nj0fK
5EI/BJ6cHCVOFo9qWGdOpCw7IX7KWucocbVj7Mr97Y18D+R/GDA/m2ehV1HC
r/DW4+Ypd8Srdz0qFUqnk9+hwF8TTse0N4lf3i2ftO3qeVk7e7nWl2SS7OtT
oMi0ySeV/H/IWMfTss7iToe9HZPkupFdYgr1DJXvT9fqUN0/Tdo8+/Vitm2R
0n/koQ9X772T81uP2FHzlr880bmNTY7eruLE4mF1ntQLFXY+wY2cbT1FUN93
bdwu+MoRIwZMi/T+JEK/j1oXXf6LbF252M2yR3zF/NINnJec95Re47p4zKgR
KHyf1Hee2/mdmFW7y/4w9zAVD0cNSp73eZ+R/9005uXdurFmOfjfgmNmtnki
UhausV23KV4Oef3X519O3BPRQWO8Oo8wy9VV//xv7g0P4fHkQuEuNYLU9/1X
/hu86PDLKPW9W/3whv1G2Bi/71u4fZnJZg+THLHxpnngrpey+ZcZExe2SJFB
yU9vJk7bKSJyV06qlpAmXWLS9ubYYZKfHGusXD/dU9mP8ucf9Tp0MkW6FGtb
6N9uxu/ZXcnztkZidi9x5G6++TEzAtR4HByK13Oplazil13lAspUKxQrC1wY
daXrdiMfN99z/pe73MDts02i9qGeHUY9eSF9yg/qVnpEtPw/8WsTWA==
   "], {{{}, 
     {RGBColor[
      0.36798948059047276`, 0.18706754305963919`, 0.6342340483482978], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXe8VcW1x/fZ5556UQiCJZoI2FuQorSooIBgFwTpTcRGExEQBAERVIwi
iCAiTcSCvRcSFcWYRCxoXtQkmmcUnoKCiILU9/ve9bsf/GPY686ZPXvNmjWr
zZqh/oBhnYamSZK0LyZJVs8rCklyuQp18/TPwEySXCb4VsGXCx4m+HLBdVT6
6+9Nel6hMkDwfXrON7wriXcv13OryqWGf9Dvt6hcpr97qnShncput7lCz2uE
yAiVQfr7KD03u/2Rgs8wvE3lEvdZNw24u+B+SeDZV8/1evZQuUjw1Xr3O7V7
T38/IvhhlR4q/RlzJt5blAY8XPCF+u3KTPz+s8pgwSP0vEBtMirT9ffPKkNU
Rqr+WLXfDn1UrtTv/fQcpPpMJt69RvABabS/VPB2laGuH54GTD9XCT4wjX56
qs/uxuM81R2jcrPgd/X8Hz3HmAbQFzp87zkaKvgRzeGVevZUmaI+tjEGlcmC
r9KzF/TRnH+nckqF+lb9B5kY/1OCe6l8KHhDJsY/wjhf4/la6rHsEHy/4MXG
+SE9r/b8pxUxX+8zzkzM8WjwEG5XqYwVXEvfma7n9SpPqO13maDZQarf4/rp
qp8GQ6q+rZ4f6Xmtyolq83c9R6scKHicx7hb8C0qU1X/tNqP1TPNxO9861b4
XfWHqFyv+okqOZWbVF8hvP4heLLKF+Uk+UzlL/kkOSuXJCs0njYqz+m9Cfq9
QmVNJuYHnnlI3+wEffX3liR4gLl+Qe1vEDwlie/wvVGCd6jtYpUp8JbaHKky
XnAH48Y7H6vcaNyOqNR6UMkJx5Uqr6s0F26r9fvFKheqzd1670L+TgK/iX4X
nCcZh30yAVPfuaT50xjXaVyNhcvuTIxtkvr+i55nMnd69zce82i12Vdlg959
jHnhG4L30J/K7YJP0u+j/NtzgtuwblTGqO4ElVtV/0AaPDRc8Ct6vuR6BM8t
es4QOF44ta2I8Y9U/aFp0OpqPQ/23J2rZwOvi9F6Hmv4MPczCboJh62ZkFcP
CF7qeeqcjXXeXfW9tA56qnRRmaN3L7I8+QZ5o9JZfx+utj/q2UllP9O5m9qc
nsbf/T0HzAXjfV3t91d9V/1dEv+8S3uvV/rvoecWtblPpYv+fk3PIYa36vkr
vztIz5ppfPcyy7qf9O6+xgsc+vq7yLFelq0DLQ+7WY5NLUQ98nCu+p+jsl59
9FbdD6rralnXy+9+q982pCFDf0KmWqbRto/b9DWvw2+10/gbmO/QzyVu39tr
YYvhrpYnfVy/j3Bpref5KvemoXugZ9NszC+8tVTlZf2+XOXfgpeprBA8Vm32
gy/1d6We56juFJXZeq+16r6hT+ZMZZbgs8RTdQTfJXi+aDJM5WO9t9CyF/3V
Xc+GKnMyIbf7WdZdL/gewbWRs3rvXmQtsl3v1/W6YH0wnvOS4H/GxNjONF+w
Hrpp3V5aEePJ6PmO+l0FnT3vXbym+3rtrDbvMJ+f6/kI6yaJ9Y9cHaOyWev4
e5WPVfeJykviuWbqu4X6q1Q5Xe+cqvK12nZQ+ZV4vWYx1vlkjaWl2p4iuElF
4NtIZaTwyaj8JxP82928hK7ebb1zkO0EZP4Y8LfsXo6OUBnFOjWPoe9/1u83
ZYO363qtsSY6W7fe5vU7Ts+yZQKyoaSyRO/djGxXaZQNGXQdckrPIyw/m2VD
DswSfK2eGzPBG11ZW9aF8Ca8Dn8ONnyN+XG7ddw4tW2uUjsbun6ofztaf/86
G3bIsjT0PnJsh8oIlZ1qsyANmQMvjTRtRnuNIDd+hNe9drqantAA+wfbZqDX
eHPNz3zz/D22u1jzfUxP1g5rs5/7WgQfq5yAXlW5KBs2zzA9h6r0UZtV5mt4
eLP63yaeOUNzfmcmZC3r4ny1Odwy9CXLcuh/vnjqVbXtoPK66l8znY8znWtm
wgbs6zGOFl+NUnlJcFN9a551MPPH2rktiflkfhjnhXr3KNtXf9TzD3rWULkj
E3qL9fum6t9Qma2/W3iO7hL8b43jYpV6+VjTrM+HTUPWKN9jLqHlfMsE5MAS
y6iB5s/7VHe3ymPoNb3bVjqye0Wse2TIYmSIvl/f+mgBfKzyuOoXIy9UnhT8
T9Hqn4LvV1mosr/KE0nYpT0tG7cK3zf0jRPVdr7wPlF19VX+V78/Cg2Ye+F8
WhK/9fY8M+/Xqr6gsha5p/fLKusEz01Dh6EvTktDT1yQCdvgPD2/07sT9d73
SdiBN4tO01Te0W83ZMNmRIY2Fj7nZIIm7+v3b82rRwg+XOUr1qbskZ+KIVPX
ayzfqnyYDx+iVlJlsiW/UZ91mCfWiXD8GnmncpT+/lK/H4+u0e+Nhd/x6APB
A1Uaqv5O1TVR3Trkhvq+rRh2QSPVrVVdS5UvmCuVP0E7Pb/gm8hq9XFoEng8
LbgeMk8lrz5yKs2E46HC9b+qO05lhnD7Ss8WKhfru6nK7ervReufG1hracgU
bMuz9e5bhZjrE8Qj7USLByuC51cVguee0nOB6v6md1rkw25DZo90G/iKPv4M
r2bCpqMN9mcb9XdGZdD7H/6N+mP1rd+LFstYs4V4MhfXC/9jVPbo7525wAV+
2FMIPO7T330Mgw/6f2khbIDlej5qn6Gx+j9F/T+m9r2L8XybtV6IdvgPjxim
Pc9HXA9MO3yKXm4HPz0AniqbmYdi/A28tiLgTm6z1PB44dBcpbbg/xZCT6Oj
l+WiH977LBO0g27QFPogY/sI1xlp8Az+BH4S/gt+AL4Fcv4k/f694JPQsYLL
KicLnpkGzwE/mA0/C/8CfwXfAh/iCtVfrtIsE74svgn67uY06lirzQTn0+D5
naLlDpXPhePB2fBfWBjLsuHn4LvstuxHj6OfsVs6Gm6TCX09S2M+2Tr6tEw8
qed5qmHaA8PDefVbVPkbelrfvxqez4f/9ZrnC71PX2cmsb5Pcz8D0/guODQX
vDkT9kN/wSXbEthXZ7hN0bYW65G+B5sHHknDR8NfOycffM66Wc8cqqzR77/T
3+01ry+r/QTV3aDyfkXgAn6MD/mE/YrtWlPts2r/gdrM17hOVfmn4MOK8TxF
Y57oflar/Rw956pcgG7Mx3ewbfh9gttgW/4rEzbVWNWNs856rxA4nOn29Mt3
Z+bCR8Kmw34CPj0JnTPSemeVYeQAz2td37IYMoL6MYWA+VZt5E9F8P8w8zz6
Et+M+g6ZaIMv8WVF2I/gig2Jjh3rfi5W/11t29HPcK+dk/33POvlMZY/N+Rj
XbGmPtFzjepn6TlC9R8K3jcJ+2C8fTFk/QTb0MjjoeX47Vu13aBSrAg5/J3g
epmYa+q/zMZv6z3vlK8Kob9qIqvcBr4Avqn6d8M817sNuu8r19M3314jnIfn
A+Y70A/Z0VHwp7mAoQNj+6AQug2bd5bXVF3kbD7+vkbPjwp7aQD8cjb04Afm
B55rDDP/75oH4LePVc5T+9mG7zIfwU9881vrVN4FD2B065t65+6KsBmYi/fc
Zlc27A30zlNpxIzwf39v276d9V6DTOi+2ZqTUjlogn47OhM6jvgFMowYyBfW
l8wvbdDH6OKH04gbED9A7xCzQK5eZ1k6KQlbtYdlFjIeWY886cj6to34pfH5
rZ53C5djK4OuGwvBG2/m41nfOH9pHIA3aLwTsmEPIM+P0fOEJOrGY9/DV3oO
UjlOcJM07IfjbFMc47EQ4wPnqwU/r98HpxHHQE42trxaa/rQfrplPHEnbIFG
v2jTyDT8yu8iYzdlwj5pJfgV7DHjsFrPR9PQHQRYf2s/iDgZPsK1ScTK8A2I
BbUWvI9ttnrYLSqbkohJIjuJu6IjiKPhc+0yPNrzNcL9PJNGzAs/qJ2euzLB
J1s8dvwU/DVidJdZzl9gmxD/AF8Tn/PubPgMm7GNsuHb8A7x4QMrwo7qq/m8
qRSxscfth03yunjf62t7NuJ3jB3bE75HvzyZRrwPH48YJ3QihtYkH3bn2ejN
TOjsyUnYq9im5ybBjyM99m+tW7DNflR/w9znu8Znoup/nUY/6P0BpjN66zr7
ScQg52XCH1qcBP1ZT2ebxtAamm/Mhp/fPhMxb+iBr/cqfaRRj15AJ7RJInZK
LBA7H7pSXxWjK4Rc2Ed0XJJGvJjYKfFU/Etse/xR/BFwbiUZW6sYOmBflY+y
EZe5PxsxWuKPP6i0Nc7QGFoThyGmS0y4n+A66mO/YuhRYsXE15lr5CFz1T4J
Px24q+USf2P/r9M8f63yeC5insSJ+yfBN+fZZuC75/vdLYbBoZvjYMSBT9Vz
SyZ47lLBNcx/P/jbXb3WmnrdLchG/Jq4dc6+AOv0PcGvqnyiv9/Ss0JlLr85
VlBL5SJsizTiCe/rmVX5VPCSTPhi2O1/Ut2JtvNnZMK/m6n6+YbxDWdmQtfh
e6L3kNH8/XtiEP7uokz4gPh389z/IvdzgPlqZzbkAD7jy2msGfzr3lpHGzQv
HXOhZ9GxU5Pwx/F5idMSQ8YHruFvHZgJf7NLGnFj/OR+adANWYSNxXefSsJ3
L3ot4E/yLr4SdDjIOP+tIuBXeVf91LPPs1ByO6fyPvFvry98c2yNUbY9ZhpP
4gYzjGNVnM3ykLgWMZNbbCdDm3mmSRPx1NJS+Bj4Jfgn+CnQ/h7PBf4v9lrr
JOxEYlrEqEbZZvnK/iByGfn8hudkYRKxjnmeiw/UvpbaFirCfkxzYWdis+Nb
Y7djy4Mneyj4EOgefARigWPxDZJYa6cIXp+E39DKMPXArEPiNOyTdbNsJ268
MYn1g72InUCc4wLTs7bHW0WTTKwB+Jx4GjiNF4zPMM24ES/E3zg1iZg8MPj/
uZofk7ALsA/OElxLc/iD6Pyyvn+baDy9EHIEXnjQvETMY4Fh6h8ynyA/bvV3
b0yD56tjHgvNPwe5PTCxGGIoj3muFxqfPWnEbOHBZf4u8M+qn5zGO/gHb9lH
mE+MSKUiG7Z9A/x2zdeBGkudcsRXVmTDH4PHvtHv7xUjjkEcf7XlbdX6M23x
eYljYmMTX11t2ciYGNvCZK9Nz7uTLTOgzYO5sFOxP/GtcirPqr6jnh2Mw440
2kLDVtmQS8Ta6hfDZsVenWiZM8frb4llUU3PF7oHHdXSegq7Bvvmd0nEvpBp
v8qEf9nE9gbrrKnhvOH/S8JXO9n82cnvsrcyIY29GGBiHfBiZSb48SjzOftQ
R0OXJPZZ2H9kfwdZQz3rvMqHBu8k7DFwxTbrnQYMzvAK9IVf2MM5yzKQ+EoX
y64jDYMDsgcZVPC6u8gynHhkZ8PEGsGHeCN0G2Q+xx5gjxCbgPcamlYTDTOu
rqY/8FzjxrwzH9SzFtljYa+FPaAquycNe2l8GrHlO5KIf6Jv0DXotFO93sum
OTEEYsDsD7GXwV42+6Ho3YsND/E6PcXzvp/lBu2ZO2L3+NrsTYDDTrdv7nr8
8uYee6XbM9c1zD/InI9MkwlJxJAZF7FlvgVuxGmJEbZJI7aM/jzB4zrP461p
mhPnvc/69zjXv2I6QJNxacwlPENMGtuGfRP2tYHZP4K3Wxs35GIbw+Bw2i9g
6IltUMP1wLTn3U7m82bmMXi2q+cU2bXIsghdjS+1JAkbk1gEdiY2JHur6Fbi
Rvg52JP4CsR88Bd6Z8OO/x/Ls8le232zMXZsj09dvyAJm2iN+4f/oPsww3wX
G7VPNt5DRt5oHKYan38YvpBYRSHid8g/Ynt/TUI/sP+ETiSORWyrKq6Vjblh
Xu5KgyfY88IPwvfCb2K9jvO8EFdHT880zh9YBrKe6Ic1jh2Bb9PKepB1Tjzt
jmzEZ1nj+ONf2Zfv6zbIAWyq672OmriftV53zBO21uX+7jDLIuQS8XxoMykN
+mDfsbcAbZNcxHn/ZHlOXB3bBhre6Xm8Jxt7Y69Y7yy2XH0gE/uF7BWiWz5z
PbIXGJtnF2srjXbsrX1umo83b4NHR+nPubLVVjtOBT7Ejog9E69Hl2EHYQ9h
/9yQhk5B/rFP8qnHwp4YvMF6XOmxoitbZsNGhQ63ZSP/o9q+h6/6J5FjQN2A
JOj0ift81Di8I3iA2vTLxp5dHeODbZaqLnH9/aYh62JbGriCH3Rb4rXDPgrx
8dXZ4J2jLauxzbBrF5vf+lkWDZBOHlyMeN7lKpepPI0cFc0GVUZsgO9jB4Bv
P+v25YJHZWP/lP3b/dRP7XLEbLCnkKdtPfePmc7MQ4dSzAV6+FGPnfgqtgp8
BZ73eozEJvH58SmwofBJsangFeYbO7au5Qa6m7+XmpceNcy+0RbsqHLsr8Iv
6HtsmUwueBQ7mjmF53jv1mzkGbznubjXvEGMlpgTMYTlxgf7bl42+Hh3GvR7
xHy4233CwydnQ3cyFxMcK4UuG9PYs+db+3hdMO/w73jLZ3If2H+6xPSZYXzY
j6Ke+Oqxbg/Pj7GcmZTs3Yej/QDLGfQOMRviR8Rttnrt324caE/OyZGWP+BM
7tUGy66ibSligOhE9mjxE1PvZTGn6OSJlu3YipMsb7ET0PfI1ZXZyBvjXfbJ
3/V6aes2Eyw35psfNuFn5GPPDdmDDMIWwu/eYPqc4HrWY0PjgI1wo9cLNgP7
VPWT8B9YPzdYR0zy+Bk7cTtsHuwZ5N/Fpg/73ux/Y2Ogd/EZsB/If6hjHU2u
C7E+csMucXtib8Q48MXYH78uDXiydS75CsQQeI/3if+stA/O/i8+KDEpaPKz
69kTxz7ExsK+Yq+b98mbwu9p6PofHevo4u+y547/gm9OzA0dwfNL6501+fDL
jk0iZvaV1yDxNnQC/tpvs8FL2LoHG2fGO8s6BTuqjdcvew3Ytuj+4yzDDvCc
Lrb8Qi5hj9fIhg3c2O+y1g6RzJhdihgreqmp8SBORg4WcTNynch5IkbHPvhh
pjO++uHmE+T3EK9Z/GRyVG63bIe2xLueMX2YF/JKsIGwf+h7sPvf4bjuH5Kw
/bFlWVPnpFEPz3T2vIDDg343m4nvDPE8Pmk8Wac3Gx98fvIIiPdhu27LRm4J
Mb0thnsnkXfEnJKvMtc4bDKfkHeFrU7OArkLxHM2uT37x9RjR2JD9nUbYHIC
GTP26n2GGfsQ8yc24WDTmXgs8gH6Y59g/+7ntQBtWeescfaYmK9vzD/IHHxk
9m0esKxmjMOzkVvCGiSGjW3QUHW/y8a8YHNhb2FrkW812HHOVd6LYU+E2MZy
64F25ACQJ5OGz7rMOoK91xmF2BvdnobtAB7gs9Tyn/y+aci4TPg+yCLmlPkl
Z454/kjjQ/y2WxpyB5lzq/kLv5vcCXIlyGFokg1dTH4geRjErNnTYZ/6Uc97
zSTi+8T24RnWFbFfYqGsbdb18dng9arYcRp8w7sd08gDpH9yYzKW1cRjx/nv
Z9NYM6wXfJ0qP5NxSzcuFK6T8xEPwBbHlkAuYgchG/F1iJXg7+zv2AV5U+z3
EUNkv6OB6ms61sraJ85IjBGfBn8AWUHe3I3Z4MPDsuGDwY/4E/gJyNT62eDn
dpa38HUP8/Ak93++vwtvEz8hXoEt0MByDL32pvMEDkmCBxgXdghjxI7ENnky
F/Yk+9FtZZ8cIzlzlPjjGduuj/NOOewbbBv6Z46w0V9Q3XPl0En9baNh06Dr
8D2wET/zt7BdK9R3+1LsAXaznfCXJOxW7ClsBuxB7IJqHdrVeucB8wMydqx5
An4gX4K4fj3zTk3jBq91ML+xTs+0nDzE9azZSuFeJvdD4yrqWShHvA1dQAwN
vcA8st/AXGLTXZKGXUccmPqOrseXwI9A9vc1X32eRj/oFOIKxBeONw7tLQ8P
Noy+I3+P2Au+Pz4+8KIk1uBIy0ziDdhRxBzQceSeYWNgD2OHo9/htUuNWzfX
4xfj1+Q8rgrnkpBjcoTpQ588jzR8oXUBMN/he+jTrcYBX+wnywT0yEB/F58X
3TjAPI/9cKH7wV/DP8cHP9Zwde4reqtaXwGjO+ibuAoyFR+cmAl+9B3i1S6l
yMtB9nTzGMHrYn8LOnc0D+y2jIDm2E4Xmc5HGLfp/i72BLoSPM81bnss+5CB
+A3kE5zu/tt57pr6N+Q8vwO3so5uZ34r+V3qGQv0QW+yX8t+IvvO2CzdjRs0
72w6oFfBYarx7+S5aGA8oX/WdJht3qEfbL/2XjuMHV/5WrdfYf6hf/bayAlE
v7NXu8vydonr0X3MF/nK2OTkq9MPOXDsYSFnJ3tt7qyWv5nYg0NHYAeSI4h9
ONAw+1Mj/K0brWfJWWQ/6Wq/iy4e6nrW/ijjwLywR8DfyH/qRhk3vouOYCzM
+SEeezvDN7pPZMg1/hb2Bntm2LyHeq6Ry8hndDo68FCvQdbibw0j25lL4j/E
fogB0b6N4Y1+t577nGDc0PENvbeCnmVvhZzRkuf9Aq9rfEn0DvGxQf4WPENs
qYb7R5chg2hDLK1k+BLXI5dYhzUsE9BllW7T3DB9jjEOVfxvWYGtQrwW25WY
VfVawkcgR4567FXs24LhFd5DIReOdYENhP0807jB/5zBIc6IjYcfcJ3X4BGG
4SXy2NGJ+BroQujAXuHpfheb7QLPEfIZP4K8Umy2vobZ02ttHFibyBLWM3PB
3jpjgTeI82HrsqcJDaBFdUxxjGlCDkyLYthZ6Eb8WHQVfij7k+w5sj+MXTsp
CbuDv1kL2JL3u//tXlfAi10Pn3/n9rxLnvDj5gdk4uOu57wD5yKmeK09bVqx
hp6yLMIHAk4tV8EHXLA3yKeEVryHPYROxJeZbfpwXoA8TGhOTtlMzxd+DX+v
sxyjHh2HnYL9jUxG981yG3TNnX6X5yy3Ry7e5W/hLxLbRSZg5/BdbJ057nOT
5262+RadwrvIXvZvGQv2z2Xup7NlwmOmG2N8xvQhN4ScA2QRcU1yvIh5Yk8+
7PVIzsBDbkMOA22Ig+6qiBhF5yTyk4E5X0Ds4jvXbzF9oS14AVflTGeCpt09
LmBoBf9yxgP+xx8inoLdzDw+67mb7nrsf/wObGLsYeQdNvPEJM4TAeNrXOex
U08fT7ufI0wH5przK8vcD3wIjGw/2P1n/a3nDdMe22uk5fNSw7y39BfvPuA+
8QugIbKU8xCMsb/X1xK3Zy0sNM8TFyK2iy1Bfif+CvtTyAT0E7qJeA9talg2
rrCsqJGLHOK/pmFnYW+x7/m07IKnSpFbCv2/MW+Qw3loMfI1P9fvn5Vif4w8
J+aRnNK6+rtOLuacOCXx3AXmsW+8LrBLiRcTKyZO9YplBbGn19yefH7exc7h
nGK+ImLO7Ouu8rvs+ZIHgK3H+y+ZbzmLBIwu4ywJPlLRv7/iemQUOqNaNrzs
d/GzXjCt4IsXzRvXG2dsac7Nwd/EGz8QDeYIv4W52DNg74A9B3T0PK9NcuPx
hwd5Tu91PTJ2vuvruL6/ZR3tB5jPOVfwo/tZ4PorzAMDvBYXeT3CL3yDdcH5
ROTjtdbpi9O95xTmu0/GuNo8j+/8nNcy65N8E2KD8Mnf0r37nuxDswe9wPvq
/Ma+ybvuB9+ONuyxEwuEnlO8vmhDfJG9FPaT4JENzvEjfw8bjLyNWuYFYGJs
+OPM/1rz1Hvmjd3WQ1Vn88wP2H7ss3F2lL02zpKyD8ceHHsQ5MGQAwNtN5mG
tKEevxsbeKvnGhsNGx17Dx5HZhFr5SwVf3M25lvXd7Yuxp6bnISe5N2p7p9z
sJf5+/wNPsTFiY+vMI9t9Vr+wW3Ah/gCsWBiHcSf2bdg7wA/kdgoviK+Nj4M
/stk17OOiEsTp6CPXYZ5F598h+Flholv8Nzp+oxj0uCWdf/MxTLjTf2jhvGL
iYXwLr9vN57UwQ/4/PAMti30QZ/eYpowxseQw9k4QzXKcTzaD3Yd56mwlTnz
xTkOcqw5X8CZL85AsB+Az4sfDUz+c85xZmD2QTKmM74yexB/9RhT+96JYdoU
vE/Bu5wJ4rvstSHzsfWR1eBYx/HGSu9lkKtGbIb8MmI3nIsCJrdwnnFYbh2x
xWuz+tvQ8lXHQIjL7Wt4g+nD3+R77O9vQR/iVZxvIe4EjrVNH/Lc+Db7HXuM
BzjUdD/0z3km1gg8SX/7+1vIAOwk1hQ5ieTGYTfyJLaCLVnf9dgYxKzYg0k8
J78xTfiN93vY9sBOwm7B5qUNc8jeaHPTFrsee6LCOhB7otqPAcauwJahH+xx
4rF8d5hp0Nx0IL+esTFu8joP9Ng/sOwe5rEf7Tbk9zVwXIj5RW5eaxuG9ldY
nhxlWsG3RxtGptIeW5TvHORv/dow8udI4wOMvVffdKvp70JzzqjxPucNmIsD
zEvIOnThLOtw9D37KcQ1T/D8NnB7+nnYNETek4f5O7ep5fbwJPYbdg96DXsH
Wxndhy+MvixaJ1J/nWUs/IAMJy6EjqzWj/Qz2jKeevwbfDJ8M+yuY40/snqR
8cFfe9Hfusl6nH1Q/G5y+R9zPn/W9cg05raF5xeZBkx8rIf0Qvdi5Nqkpg/y
k5geuXrYBvi12ATo/ZcMY+c2cpu61h3k7ixKwr4AnmM6NzTOxAjplzbopdes
p+iDevpB76EjyQtiP6Kj1yl3EbAniL7gLgLO2pMnyl4h5/UGJCFPOrj9WYZZ
R/iCZxmmbSe3533gS5I4/7O7Is47kHs+x/nn9HGW8UHvkhtNXPdx40M/T2bj
3As5uewzswfN/jM5nOzNsU/0RDbOrsCnT7gefubOBvbg2GOi7mLXbzNPw8+s
HerZp2PfqZv7fMBjx9YAB75LDsZtpg8weIDXcPffzf3wew+3QaZyZhW5yrjI
keWM9/4a/8/SDdtyYYtwfoc9O/bvgPGveV5hmNxn9hE2W9df7flibx29gi5A
J/TL7tUv1CO3ufcAOgyyTCNfBNsGvu1jXsXmoR5ZN9L9gPPr/i40ZN6YQ2wJ
5gccsDfI0x7hNn3dJ/1wdniIcX7Xdhh2KHhDg/5J2HfUT7Q+pT3yn3xv/ka3
7mOYesbAt7CRXsgGXWgz3HAfz/vQX7R53n9zrhl6Qm/GN8C0Yg+R2D1xe3JJ
yCmpZ55H31frz1Hmf3QUOY7oO9qOd3ue1xsmD4X8OmxC9DXwM7Y3eHeDdSL6
G/1AnJt3ORuILERHjrduHGOYPAFg9AJ7OJxZvc3v8W3OFpKXPMW8Ta4y+xHs
qSGvyVfnHCVnGzm3QM5MT9dzXoL9B/Laq9tOdD155pNcP9EwtKLvyW5zk7/b
23SYYHy4N+Am108xzPoqFuNd8Kzuq5ffvcO4NTd97jMdoAm6At5DNg2wzMFv
r7pXxfXv2YYiVwk7akpZ/av0yMfZXu7iwF7jyd/sdU41jH3CWmeds357Gf7Q
tvR09w//sE6wj3a5T/ohV2Ke1w7x2LH+Vsb12KzgNd/8wPnxaX6XHAHyQVkf
C11/m/lkrOlwr3EFT3xd2nfy2mHNbLasuNvrouBvQQ/2Yu4xbuAB/IrlCT4D
PjL9zTUO7CXeazyf5ZkN+cS5Es65IJf6ex39x2sa+XalZT+5HZckkcex1HPE
+n/QtKXuAddT9+QvaM6dL+iQhwxDf/Z4sUGRA8DsE7Pvj8x4zfXIAWRWV8tz
4D7mE74FXtSTf4Csxg5CdwzxmlriddXT+HR3AT9sCXgPOc5YkQPYvsinRw2f
Zt1Cn9hM5Niz55q3vsbOOMG8tsTzPs1t/uC1v9DzPs1w3vywyDC0uN/8f7/x
AUbGr/R4sd+gFXYjdsob9r/wfVbah0IuvmA+4TzZhz5fNsz1yExsGdpj2xAP
Ice0Ohbyum2MPsU4l9utGLbJKtsh7GWQHzzbdhQw/i9+8BuGuY/ieeNAPhL5
kUuS4C/47DjrF9pwZgX5vcK8h+0BjP1wqdb3oHKc1zkoF/kU9HVNpfouaf4L
IdufNQ8/YxhZ3SYJPFqbJs/5W0+7HW0aez8NOU0dcP1kb1/1jc8rxg0+e8jz
gm2AXVLNF0+Y35CRyGL2DbGRkbPIWM7lNsrFXTOcEWRvljODxDzIkb/Isnqj
53ex+WyK7dud5hNkErIJH589pl3mMfgQ+3uU393hetrscD9vimb7lOP8EP2w
J4QcG6e6sSrnCsfNnNspRE4NtLzUtBqnd69WaZgLGwYanWjdyrwi2we5fUPL
fvRvb8PoLXTDOp+1JL+dPdZvf/HuesPUrzefQE/O6aF3OgjHM1X2zcf9I3fm
4qwyMZPdpgnrBdvofftQwNgXHwn3D1UW50IWYRNjz52m/n6t+nw+ZA72DfJn
inEG/4fd/irbs/yNTUsO18Our5YX8Ntyw8gNnsuze+86WW66PWVe4l3o9KO/
S74MOCDzgbcaB+AtboO+JacKnYvcA+5qXyDjsyasKWDWEXFpeGO8+9nm9uSb
EK8gzkY8kbNinJdHDm8yH/KtrW6PHN5m3GgDzuh58N9iPOHhTa7nDD3n7Tk/
g75Cb6F3iCUSByNmiO1S6TXCHnfjYpzHZ61wBpjcwiaFqGe9MvfrfE6ZMzlr
fZaZvQxyiIknz/d5XPJVyME7hnMdSeBSz/HkL/NxzwjtOPPB2Q98QO7hov3b
+b3nvTkPgq2Hzwf+95bjTDi/t5YsOrwU54nIRbgjH+d/mpXjPBtncYjX1igH
jd/KxRM6c7aIc9GM4T79vqAcMU5i3Lfn4xwI/LpI5Xl991/q79+lOEfNGRvO
1HGeLnUbchkfysf7rC/ov8zfulvvzStGrixj7mD6cMZlf59zIc+5rWkOLxB7
590TfWaMXCZ0GHlCxJyGkItbjnc4k35SMWwZ6Mu72B6ct+JuCMbFnWI7C3H/
GefURzoPirwG7spA3gJXmAcaG0YuN7DPzdkWvn+S73nhrDlnzvk+ODEuzh3z
e1PjAy71PJYePuPDXOc89/RJ+5Pd51Ua05UqrSsc+3M/f6yIs830zzh2eCzE
fKjnrjn2G2m/3O+18L0wOzx2+mQe7inHXAyHlsWYR2QZMo0cQnIYuSuEnMa3
nUMKfXiSv4MsOdF/A7/D+dh8jGm35vqtcvzNfSDz8nGnx6p85BiRX8R3Zvhb
7+r5RD72PJ4TLs+W45255dDBTZyXxLvkKXHeGz6Dx8BloXEgl7u+++d8Le8x
rm7qo3s5fnuNeRB+L/o8aGO3WaX6FeU4Oz9M8EDBjXxnA0/O4/1Xdc+XYy1z
xpR32cN9kTsG1eezHtOLpttKPZ/LRU7UXO5cK8eZ338J/l/Bh1TEWmfN02dV
zn4ucvWfzgVMntWHPvNffecA9hQ5b5wzByYPpHYx7rp63O895X74/jPG4XnW
RCl+ow58ye0vFOJ7fAubjX65B4A962fcZp3PIiLz1vh+ANY/OXDU8/s56vvs
Utwdwb1c6HnsIPLXuROH+3AmloKOjJc7dNDz0Ip7BbhfgHdyln/wG/RBhvL3
HwX/qxy5+pyvX+WxE4PFryY2Tt1brl/HXRnl+BsZssP8X+G1M9W8Tf/wcU3f
KcGZuF6GuYOivmNuyF7WU0uvqT6uZy1zX0VPt+c+xf/4TkX8HWxY8ie5BwC8
wY2+L3b7Vb4vAP7ubpuXb9VyG/CqvkcA/udd8OviwnfJB+fejFY+Q82+KPoV
3drM9z1wJwN9tvJ3WQf9ysGvPd0n9dzHwL0MtO/qb0ATcOvh8d6i59fFmLub
9VxbjHXHWcMuxqeB20M/ck5bOheCc5mcz+QMI2OFRoyX8+KcG+dOCfJOZxbi
3p+5ju9Rf5dh4kXcwfBHy8NWGkvPyri/crZjgcj/j30OnXe52wTe5CwB/uld
7oecDOresfx+1X3u477o5w71P64Yd48ga1dY3oLjnc6PJW+RsxHkScLrwKxB
7GvGjI2N78t4Oe80zbSADtPV/+hi3J3CGXZ+O9v+8p1uT9tp7ofnzW7D+nrH
3/pzLv4GznjNsfaxs+CHtba72hlubxh+4f4fYijET+C7WuYH7GbqufuipuVM
tf1TyzDz2sJ6h7Ylt69l/qXNjaU4v8p4OXta03zFnUzcqcRdOtypU/Wuzy6w
NpEVT6ruk2LMI7kzyN8ulsPQCzp8aP8BmXKH+HpGOc7o8Dc+BXn4hxpGhrD2
kTXIYehJP1Ptf2x2m+aFuEsLuwB5v5+/xXt5v4vMhSaMiTt1ODdOzip1tT12
ziWvLIbdxDie8liqbMtC3DeBv9vH66v6Xirgv+v5j2LwI7kG+9pvO9R1VfyZ
Dz2K7cea6m2Zg05t7/nlPDl6DJnMuRz0PfqXu4L4DR0KL9CevWd8hiZuj9+E
PYitgm34js8Jb9C4XiiG/jhf6+/CyqBZd4+lm/UbtIZW53B/nd75lf4+R22b
CT6pEPvqtSy3uNsGfbfG+/AF129U25eKodMYV9E5EuCRM25VubkV8XstP3mX
+8Za2A5pKhwOKMf5sOpcdmIRxwif/qXQfeSJkAeA/OS8fg3njSBz2hZC7mDH
YsMjMzjLWGkbuB/9VEa7snNO6Ae5i4xmTfXR76eUoh8K94sgV8gnYV/j/GzE
xYGRUVcW4l4SoVB1H0mvyniHO9KOK4WcRB5dZXtwSCHWEnWsp6r7iJOgdRPz
G7HHXeal+7kj1zyDLgNP/Jof1f9P5HLnQ77+vhSyj72AssfF39zrwLewxU4t
BE8h/zgvhjzEP0jtRyCDuZsAmTtQfV7KOTfj1bQQtvcS8kxK0b6KxoWQy9Bj
j+nDuIqWFfhnTfwu/fIt5PkurxnGuM25OuebrnVze3+v63rmr+x30YnQAl3G
ODK2o5CpwIyP+GrJtPrC7WhzpnAfonGd63m70jRnHoZY1v2UD9sLu+vzcthG
yDruqvy+GD5PD9XdAD+p3ZGV4Rtgw3TS3/0KwZN9C/E7PuAFlWFfstb4va/b
TFHdrFLkz+PbrsuHf8vvfdwGnc88o/cz6ietjHanV4b/hr9wkZ6LSsGb8CJ3
IDLsPv4WOGwUjpvKcc8UcSZ8XdYKa4h2rGnuGCGm9qbX2gXGgeeFhmu5f+Jj
g6FnKe7+g/5fW68tLkZuN39zBxj+GDp0QznsRWT4x8XAG5zhIdYw+h0+Osbz
ju+FDzbU89TY3+2IzV6O+9jwF/kd2w97ivEhQ89T3yMqY06669mjMtbARR4L
Z5zPKgdPw898s1Ehvst9iseXos3l5hW+C3/u8tqnj06mCXxeFadwv9ALnoXf
s15fJ2OHV8Zagre3WWfw/NkwsbQRjqdxvgz/m7PGxKG2mSboQfQlevMk9Xdy
Oe70YC3vtKw7mDsMy9EvZzm5MxM+4awGZzY4W8QeSfd88F67Utw3it9dV++N
LMV38c2xy5HPtD3XOhRf5c/2ZZY5foEf3c190oZnN/f/gfrerj7fVrvDOD9S
GbgeUYpYCfw5thj2FnwCLaABNtqiYtgo2CfzymFDYD8gy/AD0YXEGlg/xCg4
yw7O+BHcJdnEd7wQZ+LMJ/ZV0XEn9gTxUSrtp6CLuM+RuxC58wqYs/nck7q9
HP7Kf22vHGL/nTq+Be8wT8wR8cjrKiMuhU6FT6vlKzD8gN8PfZEbd5VC/6H7
6Lue++9Wijs30SP7lmO+mWvsTuaUPS/8CO6Pg/f3qG1SDjvg1mK8Q3tiCTXL
4VOT57bGsSDuRUTeIetYqystJycWw7bGruZ+oCml0CXEXLC58AGxJ5pZthMj
pi94JlHb/SqjX+IVa8yr2GW8gwzEjsMuRA5wx0/e9/xwB8s5xgc74V3bFMSJ
+B2bA7uC8WFbpHovW452nMXk7hbOKLUsxf8xgDwnZrOxGHRuIbxaqhxUCPod
4XVxRiliDcQZmEP27FlvVxXDp8Kfoj1rCZo3r4zznOw9UHe5+Rzf/W375th0
L9nXxjdHjp+ZxPjONq2Y16PsR8wsxt15zA1xlw89dtbsZe4f2QzufPckff/T
YsjFozwW+vl/8Nv9Xg==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnnQjmUUxh+8y/Pcb4giqj+oJNpTPlQqJHz2aixT2SnZqSxZhs+Ekeyk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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5171408436172102, 0.4464014827999652, 0.8438843323716584], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmge0ldWxx8/lnvOdr2gsUcGrmJUnURAQpCgdpKg0QxHF3pBEUFFBEyXv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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHm4j2Uax1/O7/c77/u8KoNwoZpKZCudJNmO7VgySWRJtoSaOI61Bs3I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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6391610105789491, 0.6486160828903496, 0.9112162645339651], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXuUllUVxj9m5nu/9zKogIAGmAozTZaA1ZJaKSiYrmKYYQ0XW4pAoOIt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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmeMllUQhV/59nu/t1BElCYgCBJsiDUaEwVEiAobWJoRDLgQlhYQQUQT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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.748821774819224, 0.8248104175922695, 0.9137161921988732], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl9tvVUUUxvfhnH322dNgTEzElJZLQYsoVWMIQR8o4C36hEIM1UZFgdYH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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEdo1UEQxjfJ+7/3dkNUFCyxxMQeuyISPVoQPdkQxZioWJJDPEggdhN5
xoIFG3oVTUhDMXY0sSsKQTxYEOwRxIKoB0kU/X3M4YP5dsrOzs5M7op188rS
nXPLQQyMC85leefKIYMj57ohT+DsJ/IvcBXuwXfkPWAV8sBM5/7FncuDv046
14b9NOQcYuQjD8XmH/yLYiA/xOZVhnNF6HvAj+F/NoE/PAkfg08htmXwu8in
sH9Kko3csR/9Fvhc5IXYnMC3kLOe5H6FGJXwKrAK+Tk+t/G/A+qx741NLnIe
aMd3EfGHIw8D78mnmrNzxD5DvE3IHeh3o9sVLJclenOwGujtxcQsR+4nf/gk
8BbeTIwTyPWgDl1N0nLZg/0IeNxbLT6Dw+j2km+KfLPTnGtC3wheYF+NfS22
x8FqbNeDBdgWwC/FrMaq7U1wILIanyfee3gDchNoQC4Fw5ArwEH0G8BsYh+F
z+Su6eA+8bI4K8F2YrC//khNEvDLYBf8G9iKbluwWsinO7qP3u7KSbNe6QrP
SFjPVCatRqpNIfHbkT94+wvleAO5FeyP7A1T8d+Kz130nfAk702Al+TyFf8W
bNd668194CS2f9RTyDvQn4bXBqvdM2o4Ptib9JYf2GxEfotNjNwL4Gfhy8Dv
mP15Nnf1ARec9chI/EcF+yv1yAp8m9WDkfWccu/iLbbecAvbtqT1qnpOtVbP
qldV883oS4k/h/rc485Bmg/wCX0J/Bq218HkyGZQvX8afSpuM6Be6eVtttQz
yuWdt15TTu3YP8E+H3kQNo/Vm0mbLZ3dw/a+t79XTTvQxTOttjW8J4X9zmB/
tRafTmwXwLPhTSA302yk08w/UO8Eq7Vy1N9dxCcV2R9WoKvg7DzyLPTz4Svh
feMWMwc+INgsyuevtzt1l/70CPe9wX4p8et473Z4Mfo1CZtx7Q71oHpPO2Qs
sdLhK2O2o3TXBm9/rTv194qpWOoBzZZ6SL2jGZuCf39vvdcBWuCtwXLXznrk
bWY1q5rxLcH+VH+pnaRZK/K2OzRzyrXR2+wp58HYRt7+Wn+s3tMO0+5SDw4J
tlO1S9UT9fCGYLtDO6GKu6uD7arb1PQQtplgeWQ7s3+wHavdqp2kWowONruq
SQl3pXG2OLIelDwj2OzrTLNeEOztmvn/HSLSvg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.848712187621698, 0.8757037823573659, 0.8754667050856402], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VLtrk1EUvyb98uV+AXWtafI1KbVqvyRUJx/oqoNUVCKiCI1TbdO4lKQv
BwcFcRSqU9RBV6lFpIsKLoJxEPEBHSqIQ8B/wAf4+3F+HQ7n3HPP43ce95Ya
rbNzKedcB5QGlULnhkHPdjj30jsXgmYHnKsHIOjfwqYA3ZHIuVXqIS/nnOtD
HoP8BfQI8vPQ+ENQW3wLvqmsc2u468qG8gZyXQS/AHoA/Xpod9TXpWde3vE8
Bf4zMEwNyMeRv+QNexwaLuKnX10xP4CaoE+IU4XtSfhUcTcP3s6Z7Raw3WMs
4d0UZmIkbuKZyzjXw7kJfhpxrsN+Uuf34DPwSUKTFyAX0acY9CMwXU96xpmU
nKgf9B2CnA8NK/Nu928Due4gTgtyCnIN8qXA4jEW4/zCeSSwOOz9bGD+rL2v
+nlPrDPCQPkjaryPmE9Bd7EMj7N2pszZMw/7FquXU5rdumbMObA+6iuR4aNP
VzUQ/zR0E7gbhf4g+G6cO9DvBT8QmS3xbqr3a9oBypfBi6HVsIR+L+ZMdwM4
j8L3FvwORZZjVD3og64NWA7qOMeGsHKXvsN30dus2QP6sA/nEecP9O9wHoO8
L7JYhyN7D+xHF/yzN7w9zZoxvLc5cUYV6NJZm+2w9pI7yd2MtcMJYo5HNjfu
V1o79sZbX9iTDPj+yOb119tsOJdB9GAP6DfyfvOGiXhWctYj9od1/FMtZcQo
RfZuuOOsn7VfBT8HPZgrw/YE7srCXtEbpJxSLbXQ9Ny3U7CtedOxB4n2P1bN
3JUFbzkYn7qy9JxJW+9rl7ed6KhvieJ3EP+Mt7+B/8pX/S07wV9583/hbQ+4
AxPe/iDa8LyqXU30ftnP28hzE/KVjL0z2nCm3K8hvbsiYhxD7oLu85pdX3a0
eeLt79t+V7RhHOJ6LWx5xaRvU3n4jlhjVb3lO2lJT9uC7Ee0v9xJ/mF1va//
N5yrfw==
         "],
         VertexColors->None], 
        PolygonBox[{{2496, 2497, 1183, 1143}, {2602, 2310, 1131, 1183}, {2603,
          2406, 1315, 1517}, {2601, 2604, 1517, 1131}, {2593, 2302, 1366, 
         1510}, {2426, 2425, 8, 1057}, {2337, 2877, 1824, 1825}, {2406, 2599, 
         1514, 1315}, {2302, 2590, 1508, 1366}, {2600, 2487, 1130, 1514}, {
         2643, 2644, 1481, 8}, {2351, 2887, 1837, 1839}, {2201, 2878, 1825, 
         432}, {2183, 2707, 1646, 210}, {2335, 2875, 1820, 1822}, {2607, 2313,
          1135, 1371}, {2876, 2201, 432, 1821}, {2619, 2333, 1175, 1414}, {
         2384, 2933, 1879, 1881}, {2875, 2334, 1821, 1820}, {2928, 2321, 1145,
          1871}, {2938, 2335, 1822, 1884}, {2352, 2967, 1972, 442}, {2967, 
         2353, 1185, 1972}, {2336, 2936, 1881, 1177}, {2842, 2592, 1122, 
         1786}, {2887, 2350, 1838, 1837}, {2487, 2695, 1630, 1130}, {2518, 
         2517, 1244, 1388}, {2378, 2470, 1258, 1230}, {2609, 2318, 1143, 
         1317}, {2877, 2338, 1826, 1824}, {2311, 2605, 1371, 1132}, {2592, 
         2594, 1510, 1122}, {2707, 2381, 1871, 1646}, {2888, 2352, 442, 
         1838}, {2321, 2889, 1839, 1145}, {2557, 2556, 652, 1481}, {2320, 
         2611, 1317, 1144}, {2618, 2617, 1132, 1175}, {2879, 2336, 1177, 
         1826}, {2591, 2485, 1121, 1508}, {2935, 2934, 196, 1879}, {2520, 
         2521, 1388, 1185}, {2485, 2486, 1414, 1121}, {2940, 2941, 1884, 
         1258}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2936, 2336, 1387}, {1178, 644, 433}, {2878, 2201, 
         1241}, {2353, 2967, 1194}, {2517, 2518, 1442}, {1885, 1399, 1259}, {
         2381, 2707, 1235}, {1444, 1443, 443}, {1188, 1259, 484}, {723, 646, 
         490}, {1188, 721, 644}, {778, 1443, 646}, {2350, 2887, 1193}, {2334, 
         2875, 1176}, {1443, 1536, 646}, {771, 644, 211}, {2201, 2876, 
         1241}, {2338, 2877, 1178}, {1259, 1188, 1176}, {1387, 1178, 433}, {
         644, 771, 433}, {2889, 2321, 1378}, {1399, 1393, 484}, {1194, 1193, 
         646}, {2707, 2183, 1235}, {1241, 1176, 644}, {1178, 1241, 644}, {
         2934, 2935, 1880}, {1443, 778, 443}, {646, 1193, 490}, {2875, 2335, 
         1176}, {721, 1188, 484}, {2967, 2352, 1194}, {1176, 1188, 644}, {
         1378, 1235, 490}, {2336, 2879, 1387}, {2335, 2938, 1176}, {2933, 
         2384, 1242}, {2521, 2520, 1444}, {2941, 2940, 1885}, {2470, 2378, 
         1393}, {2352, 2888, 1194}, {646, 723, 225}, {1242, 1387, 433}, {778, 
         646, 225}, {644, 721, 211}, {1193, 1378, 490}, {2877, 2337, 1178}, {
         1536, 1194, 646}, {2887, 2351, 1193}, {1259, 1399, 484}, {2321, 2928,
          1378}},
         VertexColors->None], 
        PolygonBox[{{2888, 2350, 1193, 1194}, {2520, 2519, 1443, 1444}, {2938,
          2939, 1259, 1176}, {2337, 2878, 1241, 1178}, {2463, 2521, 1444, 
         443}, {2384, 2936, 1387, 1242}, {2519, 2343, 1536, 1443}, {2935, 
         2933, 1242, 1880}, {2879, 2338, 1178, 1387}, {2518, 2463, 443, 
         1442}, {2351, 2889, 1378, 1193}, {2940, 2390, 1399, 1885}, {2928, 
         2381, 1235, 1378}, {2939, 2941, 1885, 1259}, {2390, 2470, 1393, 
         1399}, {2876, 2334, 1176, 1241}, {2343, 2353, 1194, 1536}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2183, 2707, 2381, 2928, 2321, 2889, 2351, 2887, 2350, 2888, 
         2352, 2967, 2353, 2343, 2519, 2520, 2521, 2463, 2518, 2517}],
        "500"],
       Annotation[#, 500, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2378, 2470, 2390, 2940, 2941, 2939, 2938, 2335, 2875, 2334, 
         2876, 2201, 2878, 2337, 2877, 2338, 2879, 2336, 2936, 2384, 2933, 
         2935, 2934}],
        "500"],
       Annotation[#, 500, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2178, 2695, 2487, 2600, 2599, 2406, 2603, 2604, 2601, 2310, 
         2602, 2342, 2497, 2496, 2495, 2318, 2609, 2409, 2611, 2320, 2610, 
         2319}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2272, 2964, 2273, 2426, 2425, 2147, 2643, 2644, 2555, 2557, 
         2556, 2210, 2456, 2471}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2698, 2490, 2313, 2607, 2306, 2605, 2311, 2488, 2617, 2618, 
         2333, 2619, 2174, 2486, 2485, 2591, 2590, 2302, 2593, 2594, 2592, 
         2842, 2841}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2166, 2440, 2298, 2822, 2824, 2823, 2247, 2502, 2503, 2192, 
         2169, 2446, 2173, 2685, 2684, 2922, 2921, 2305, 2629, 2630, 2628, 
         2686, 2687, 2448, 2697, 2696, 2489, 2312, 2606, 2307, 2450, 2315}],
        "300"],
       Annotation[#, 300, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2276, 2769, 2277, 2770, 2236, 2768, 2275, 2767, 2274, 2323, 
         2966, 2322, 2534, 2228, 2531, 2533, 2532, 2551, 2153, 2755, 2756, 
         2754, 2254, 2757, 2212, 2725, 2760, 2759, 2932, 2457, 2213, 2727, 
         2726, 2733, 2732, 2215, 2730, 2731, 2728, 2729, 2214, 2763, 2424, 
         2945, 2946, 2944, 2400, 2476, 2475, 2410, 2399, 2226, 2479, 2480, 
         2398, 2969, 2397, 2152, 2484, 2146, 2483, 2530, 2529, 2227, 2963, 
         2507, 2195, 2955, 2327, 2270, 2765, 2271, 2766, 2269, 2900, 2361, 
         2641, 2642}],
        "300"],
       Annotation[#, 300, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2445, 2191, 2168, 2680, 2679, 2751, 2750, 2249, 2752, 2250, 
         2548, 2589, 2588, 2421, 2177, 2694, 2693, 2849, 2848, 2405, 2597, 
         2598, 2595, 2309, 2596, 2423, 2493, 2492, 2491, 2317, 2608, 2407, 
         2408, 2494}],
        "300"],
       Annotation[#, 300, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2149, 2414, 2148, 2646, 2645, 2772, 2771, 2402, 2776, 2777, 
         2773, 2775, 2774, 2415, 2154, 2655, 2654, 2789, 2788, 2403, 2793, 
         2794, 2790, 2792, 2791, 2416, 2158, 2867, 2868, 2866, 2329, 2462, 
         2461, 2198, 2511, 2386, 2957, 2205, 2473, 2204, 2746, 2747, 2744, 
         2239, 2745, 2260, 2864, 2865, 2613, 2863, 2862, 2460, 2220, 2528, 
         2396, 2738, 2739, 2223, 2478, 2221, 2477, 2222, 2737, 2736, 2395, 
         2411, 2219, 2764, 2218, 2735, 2734, 2762, 2761, 2259, 2510, 2509, 
         2552, 2553, 2523, 2522, 2203, 2472, 2722, 2721, 2720, 2385, 2508, 
         2197, 2458, 2459, 2328, 2859, 2861, 2860, 2157, 2433, 2151, 2653, 
         2652, 2904, 2903, 2280, 2901, 2902, 2650, 2651, 2150, 2431, 2145, 
         2640, 2639, 2899, 2898, 2267, 2893, 2894, 2637, 2638, 2144, 2428, 
         2430}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2165, 2674, 2295, 2819, 2404, 2821, 2297, 2820, 2296, 2419, 
         2246, 2586, 2301, 2585, 2300, 2825, 2190, 2678, 2677, 2826, 2827, 
         2676, 2950, 2675, 2248, 2839, 2840, 2836, 2838, 2837, 2193, 2172, 
         2549, 2550, 2504, 2505, 2846, 2847, 2843, 2845, 2844, 2422, 2182, 
         2706, 2705, 2852, 2851, 2856, 2326, 2545, 2235, 2544, 2234}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2292, 2813, 2293, 2814, 2291, 2914, 2366, 2671, 2672, 2673, 
         2438, 2439, 2368, 2624, 2367, 2625, 2442, 2920, 2369, 2626, 2370, 
         2627, 2299, 2831, 2832, 2828, 2830, 2829, 2444, 2833, 2834, 2587, 
         2971, 2251, 2753, 2252, 2923, 2924, 2688, 2689, 2175, 2449, 2179, 
         2700, 2699, 2927, 2926, 2314, 2850, 2316, 2701, 2702}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2143, 2947, 2357, 2266, 2892, 2359, 2890, 2358, 2891, 2429, 
         2360, 2895, 2897, 2896, 2268, 2785, 2786, 2782, 2784, 2783, 2432, 
         2787, 2742, 2743, 2741, 2238, 2905, 2906, 2657, 2658, 2156, 2434, 
         2159, 2660, 2659, 2804, 2803, 2241, 2500, 2573, 2970, 2186, 2574, 
         2869, 2614, 2615, 2535, 2537, 2973, 2536, 2632, 2631, 2937, 2387, 
         2723, 2724, 2207, 2474, 2206, 2524, 2525, 2512, 2513, 2199, 2572, 
         2261, 2263, 2961, 2224, 2265, 2225, 2962, 2264, 2388, 2464, 2465, 
         2482, 2481, 2412, 2413, 2356, 2623, 2330, 2871, 2331, 2616, 2262, 
         2427, 2417, 2418, 2344, 2958, 2208, 2435, 2282, 2255, 2956, 2200, 
         2711, 2712, 2661, 2662, 2160, 2187, 2575, 2576, 2547, 2242, 2501, 
         2577, 2805, 2806, 2663, 2664, 2161, 2870, 2799, 2800, 2798, 2802, 
         2801, 2499, 2498, 2240, 2546, 2656, 2155, 2185, 2281, 2795, 2797, 
         2796, 2237, 2780, 2781, 2647, 2648, 2649, 2184, 2278, 2778, 2279, 
         2779, 2196, 2710, 2858, 2857, 2401}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2163, 2665, 2229, 2740, 2324, 2853, 2855, 2854, 2667, 2666, 
         2287, 2807, 2243, 2810, 2290, 2808, 2289, 2809, 2188, 2670, 2669, 
         2668, 2812, 2811, 2244, 2817, 2818, 2816, 2294, 2189, 2164, 2873, 
         2874, 2872, 2332, 2453, 2452, 2612, 2583, 2584, 2580, 2582, 2581, 
         2420, 2683, 2682, 2681, 2304, 2835, 2325, 2540, 2231, 2538, 2230, 
         2539, 2256, 2377, 2968, 2376, 2469, 2209, 2959, 2389, 2253, 2543, 
         2233, 2541, 2232, 2542, 2257, 2554, 2181, 2954, 2380, 2379, 2636, 
         2391, 2633, 2635, 2634, 2466, 2455, 2516, 2515, 2514, 2339, 2886, 
         2349, 2885, 2348, 2931, 2383, 2929, 2382, 2930, 2393, 2942, 2394, 
         2943, 2341, 2880, 2340, 2972, 2717, 2718, 2719, 2565, 2566, 2564, 
         2568, 2567, 2217, 2562, 2563, 2561, 2571, 2570, 2708, 2194, 2709, 
         2569, 2506, 2527, 2526, 2216, 2559, 2560, 2558, 2758, 2258, 2715, 
         2716, 2622, 2354, 2621, 2355, 2468, 2467, 2211, 2960, 2392, 2346, 
         2620, 2347, 2884, 2345, 2881, 2883, 2882, 2454, 2202, 2713, 2714, 
         2703, 2704, 2180, 2451, 2692, 2691, 2690, 2375, 2925, 2308, 2374, 
         2953, 2176, 2447, 2171, 2952, 2373, 2303, 2372, 2951, 2170, 2443, 
         2167, 2949, 2371, 2245, 2748, 2749, 2579, 2578, 2815, 2441, 2916, 
         2917, 2915, 2919, 2918, 2288, 2912, 2913, 2910, 2365, 2911, 2437, 
         2908, 2363, 2907, 2364, 2909, 2284, 2436, 2162, 2948, 2362, 2283, 
         2286, 2965, 2285}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Epilog->{
    RGBColor[1, 0, 0], {
     PointBox[{-0.8, -0.6778957129244416}], 
     PointBox[{-0.6200000000000001, -0.3531795967671845}], 
     PointBox[{-0.4580000000000001, -0.07894799282493775}], 
     PointBox[{-0.31220000000000003`, 0.12113552694504906`}], 
     PointBox[{-0.18098000000000003`, 0.24357858061998103`}], 
     PointBox[{-0.06288200000000004, 0.2963800521257964}], 
     PointBox[{0.04340619999999998, 0.29261629897930774`}], 
     PointBox[{0.13906558000000002`, 0.24639009924822125`}], 
     PointBox[{0.22515902200000004`, 0.17063263443660714`}], 
     PointBox[{0.3499057621544118, 0.018518901242232877`}], 
     PointBox[{0.5885565636880948, -0.3819790474514864}], 
     PointBox[{1., -1.376345614207783}], 
     PointBox[{1., -1.4161468365471424`}]}},
  Frame->True,
  PlotRange->{{-1, 1}, {-2, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->84645867]
}, Open  ]],

Cell["\<\
Show steps (red) and evaluations (green). A step may require several \
evaluations:\
\>", "ExampleText",
 CellID->212720019],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"res", ",", 
     RowBox[{"{", "exy", "}"}]}], "}"}], "=", 
   RowBox[{"Reap", "[", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->176283711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ".", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.04", "]"}], ",", "Red", ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "stxy"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "exy"}], "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->366479200],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlnXVA1UnXx7E71+6uNddY1xpr7da1WFvXWGvt7lpj7W7sxlVUDAZb10RB
BBHphnsBBemXh8tnfu8dnj8e9uuZOjNnTszM79yqY2cMmJDdxsbmcAEbm//9
tfzPLDP/w9nrxrRPN6aFK3zrf/BTkMK7anTfUaO7n8JfMsp/UnhPBv2dwgcy
8AOFLX/s74I3WugC/I+lvsLulvYV3mbpX+HrlvEp/NEyfoUz+dOxrPm/ZnYk
S/gFwy8YfsHwC4ZfMPyC4RcMv2D4BcMvGH7B8AuGX+v+zDqWPf4HayQofsHw
C4ZfMPyC4RcMv2D4BcMvGH7B8AuGXzD8guHXuj+zjuWM/1W78U3xC4ZfMPyC
4RcMv2D4BcMvGH7B8AuGXzD8guEXDL/W/Zl1nMlHjOIXDL9g+AXDLxh+wfAL
hl8w/ILhFwy/YPgFwy8Yfq37M+tY/pXBf6TiFwy/YPgFwy8YfsHwC4ZfMPyC
4RcMv2D4BcMvGH6t+zPrWN7O5At+wfB722qd/RSGXzD8guEXDL9g+AXDLxh+
wfALhl8w/Fr3Z9axzJHx10fxC4ZfMPyC4RcMv2D4BcMvGH7B8AuGXzD8guEX
DL/W/Zl1LPdljhN+wfALhl8w/ILhFwy/YPgFwy8YfsHwC4ZfMPyC4de6P7OO
5fkM/K/iFwy/YPgFwy8YfsHwC4ZfMPyC4RcMv2D4BcMvGH6t+zPrWK7L7Bd+
wfALhl8w/ILhFwy/YPgFwy8YfsHwC4ZfMPyC4de6P7OOpX1GvQ+KXzD8guEX
DL9g+AXDLxh+wfALhl8w/ILhFwy/YPi17s+sY7k1sx34BcMvGH7B8AuGXzD8
guEXDL9g+AXDLxh+wfALhl/r/sw6ll12/O8fQhW/YPgFwy8YfsHwC4ZfMPyC
4RcMv2D4BcMvGH7B8Gvdn1nHal9bx0dmYR0fmYV1fGQW1vGRWVjHR2ZhHR+Z
Fb9g6/jILKzjI7Owjo/MYpu2btbxkVlYx0fmLH+nWvwOkcF+91RtXRMldHC1
/xXbEZA5L/GaXMSr8uDpmX6NJfb8quqDqQ+mPtji54fKWhn1zDI57X//+yLA
tAemPTDtgWnPsi5hme0GKPyvlR4KU/2B6Q9sLddhqj+9fe+M+fCX7zP+vhBg
+gPTH5j+wPQHpj+wZd58ZN+Mch6Zft4HhekfTP9g+gfTP5j+9fYfZPx9Iv0t
7Stsl2kXwassWIAZD5jxgBkPmPHo/Y3NaNdO0B+Y/sD0B6Y/MP2B6U+vH5tR
7o2qD6Y+mPITM9bpsyoPZvzsP8avY8t+tXGGH+hg6PSn72cw+gCM/HB+wHjY
7/QPpj8w/YFpH0z/xOv0B0Y/6PpCj3ehMz4w4wMzPjDjA6MfwayvHn/r+k2P
x3V9Bx39gv5i/GDGD2b8YMYPZvxg5AuM/tfperyt6189/tb1sR6P6/oZOvwS
v6IP0LfwC4ZfMPyC4RfMftGxHm/r9kGPv3V7ocfjuv2ADr/6eYOu34ln4R86
/IPhHwz/YPjXsR5/6/ZKj8d1+6XH57o90+N13b5BZz7A2Bvd/hDvMh/QmQ8w
8wFmPnR7qcfjuv3U43Pdnurxum5f9fhdt7fQGb9u/4h34Qc6/OhYj791+6zH
47q91uNz3X7r8bpuz6Gznrp9x77iv4LxX3X7q8ffuv3X43HdH9Djc90/0ON1
3V/Q43fdf9Djed2f0Mev+xPYc8av+xfQGb/uL+jxt+5/6PG47o/o8b4+Hr1/
3f/Q42Hdf4HOfEBnffFXmA8w/IMZD5jxgOFH93+mZOBA1T6Y9sHwA2b8YNoH
409Uz+ArQsV3YPoH0z+Y/nU6dpHx6OWhMz7ojA/M/tMx9dlvGdsy3V9j/cHM
N5jy+F+UB1MeTHn8GcqDKQ8mHsYfoL61v2N/F0x9MPoEe0t9MPXB1AdTH/tE
fTD1wcTn6HPqg6kPpr5eHv1IeTDlwdgPXZ/q9oH9jLzo+5/9R3/sF/oDs5/B
lEf+KQ9mPsHsTzDt6ftHl0fr/WR/F0z7YNoH0762H4Ven/UD6/6Dfp6trw/6
03KOFZYpP3HS0n2UwtB7ZtSPVXTwn5nzYOnfpMqDu2aU8xV1MtoLUeXBlAd3
toxTzMwo56vqg6kP/p4pB3MysJuqD6Y+2CnTrhXMmFdn+SJjnHcEmPbAtKeX
P5LRzg1BeXC1zHXamcHXd3nTMl+Z+uZr5j14hMIpGfWDBZj6YOZbpzP/1P+c
UTBazScYOutBfejZMvgKkTkz/kZkxpWBkvXwsMiVgM78g2kfTPvgz5ly2Stj
vIGZ++6zANM+mPbAVTLacxX1Mv56qfo6Zn1pD7qFD1e5MIP+KpPPtwojDzqd
9Q63rLfCly3lBeXB0BkvdOQHDJ3yjB86/cVkrOMO+a9lnyoMHXmblbmPoSOf
YMYHRl7BjEcv3yZj3M8F8os+ABPPo/+QT/QV5a3PR414H4w9QJ6RHz3eRl7Z
D9bxeoSKt+mP9qzjGZOSL+yltf4za+eHJiXv6FtLu74S/YO8IH/obzDrq8cn
rDd09DX+D/VpH38cedXjC11e8dexp/r6Uh/7o8svdMrTHv4c5cG0j7xTn/ao
D/+6PsUeIZ/K/8+U/4xmaqRJ5F3HFrky3jPp9gx9DEZ+WX9dHsHQ9fMe6MgH
8om8gWlP18/oR8rr+hX9h/0C4//odF3fIT9g5Iv51fUT9ZFfMHQ9noaO/6fr
U11/sd5g5IH11+Nb2mO8enyrj5/+8LfA+D+6fkS/0Z8+XujIF5j2dP2YAbtH
KXkFI29g7r/QB5wPIl+zLPpAMr+cn3C+0iuzHutLf8g/+5/9wf4Hwz+Y8Vmf
90Yo/Q1mv1jfFxn+IfoY/Yr+xR7r/oeOdf2r+xf4I2D0Me3r/grnb8Tr0MHs
H/Qn80t93f/Ev7bmx1/pb8qDaQ99Dh3M+sKP7t9CZz/p8sD6s77sT+SV/cF6
6/4K9cHUZz8hn+hvyoMpjz7X/S/d/6Y9sO7vgBm/bh+wJ9DRB+gH6My/0jeZ
49P3t+4/6Vg/3+L8h/miPJjyzA907KMeL6A/4B/9QP9g+Adb329h1/BLYhV/
zD/t6fLCeGgPjD7DzqFP6Y9/t8b2d3V9w30Z7YMZj8VvTFLjBdMemPa4D6M9
MO1h32kPTHvW2KzK0z76jfbBtI+9p31rf5bzI+O+Cn1Oe0q/Z7aHP0B7YNrT
/QXuV2gfTPtg2kd/0j6Y9nV/Q38fiX7DHqGfwOg39jMY+UY/oL/Yr+gX3f7r
57fsD8a/OeOvp5JX9iP8Qqc+mPnivQ71wdS36GV/1R+Y9qyxWe1X2sdu0T6Y
9i1+XphqH0z7Oh05xT6Dibewl2Dki/s26NzHgYn3sb/cR6E/wawf9lE/72a9
0BfoH84/6Q/9hDyD6Z/xYh84jwQTb+n+LZj5Rv8wHj1+ZHzMI+Njfhkf/g0Y
/8zaXwlQ/ov1fZhJ+fP4G4yf/cH8sp/A8EO8Bx1/G0z7YMZDffYv64m/iH3F
f9DtL/aB+YRO/9DxX/T69Ic8Y3/x13X/H3vJeSTyRXtuGX/fK38b+4S/rttX
9IX1+xDDnrLu9G+R0xSlL8GMH0x5y75JVOXBlAdTHv+Y8mDKgzkP1PcPGDry
TPvQad9avu3v6v4A8kl5MOXBzB/2AHkA0x7yTXtg9jPyzvkf8sr+BkPX77up
T/9g+lf2KLN/MPwgr8iT7m+hv2jPso+DlbyAaQ9Mee6H0A/6/Q+Y9WO9reUv
XtXH30A/6v6Gvv7oL+Yb+8/5LfYd/aLf94CZf9aP9qFTn/VHnxE/UV7dN2Zi
7ivgXz9vBuNPKH81E+vnCex3MOtpff6YqOwh/iH2AH8POvyxXmDmn/mz1v/+
Cuvfm0Bn/pkf9C36Dqy/14eO/o/JwMZ5hr7f9Ps85B/51v1nMOvBfFBe94d1
uu7fgqGzntDByBfzSXkw5XU6/hZ0MHT8Jehg5Iv5ArMe2EPsERj7hX8BHcx6
IN+0h/9Kf+grMPxjn6kPZj319lhP2gOz39EHYPw/5E+PL5BXxqPrU7C1fTDk
Xdd37C/2C/KCvkA/gdFP6A/WG3+S+BB7DrZ+d27jjPzq3zMij7THfNAeGHnQ
36vp91X692Osj2UY5izvhbAn+EfEF5w/wAd02oGeQe6eqvwrMO2DKc96UF5/
fw5m/rE3yJeyR5ntQac9MPpK2Z/M8mDaw3/Af2Y/wTf6DToY+cX/ozyY8mD0
N/f58AumPpj6YPrDXhGPYt9pDzrtgWkP/C5TL2T8fw2Tqo/9oz4Y+4U+Tsro
90Lm/klS8wmd8yWwdfyHP2mW+n0z64e+pDz7FflnPyP/jA/9QX3Wl/FAZ//o
+hb7hD7SMfuL9dD9R11f69/z6foZecN+Yl/RB+hvzgexJ5zXYT+YH+QbfYU+
ZL0tf9LkAMt/CDDriTxAB9+x0BXGfoPR96w3/SEf1u+D47T3wXHae1GT9l7U
pPQ9/aHvwYzfso7xqn8wdIvcmBUdTPuMF0x9MOWRP/Qb669j9D/6TKfr+g6M
/qI88gNm/vX1pD/iTV3/Qic+1vU39gt9QHnid12/6/kV9PHr/GF/obPfiaeR
H+JnMPE47cGPnm9Aty/Q6V9/r0b/zJduT/R8Anp9MPXBjFe3N+gf+AOjH7HP
YOvzCbOio8/RL8gj5cHYK857dPuGvqE/yoOxX/Sv2z8d69+bQsdv0O0p5Rmv
bi/17zOhU163j7p91b//1O21/j2obr+hMx7sJ/aD/pAvfTz4U9Cpj7xSnvnS
x099xgOGf/09n/69I3TKY88ZH5j9SHkwdMajf2+p+xv695e6/6F/b6rH2xb9
EqXmFzrjp13mU+dHp4PZr5Rn/sHMv84v9eFX94+gW7Z7lLLH3CdwHgfW3yNy
fsB9Cf4B9xucHzA+5BM6543cZ1TNGJ+POu9mfOgfMPEFmPrMP/4I48d+Ym+4
/7XY3zTtvilR+S/oX9rD38NfA1Mf/Yu/gf1lvLSHP0d95hdMf8w3/hPxFv0R
79Ef9p355bwG+WR92W/MF/4rdDDywngoz/jBpzPXGX/G+n7ApN5n0j6Y+tbf
+0Yp/w1+rOMndQ+k/CnWg/rW79OjhPV79Cgl32DkGX63Z/67ZwYhUp2vIT/4
58jfEwv/WfxP/DFLOe5Dk5S/g3ywnrp/hv+CPrGMN1X5K2D0B/4M+gOMPqQ9
/AHd39H9Df29oZ4fRLfXuj3W80tgP6mv20PsFfzo9kvPX6DbLz3/gW4/rL/D
DsiSD0C3H9Dx12if+JV4Bn8JzH5DPhgv8oU+oH3kkf2BP2Z9X2lWGHnn380Z
9aXab7QHHf3H+qMvkEf2E/KO/dXP+/T9TPvoS+SF8REfWX9PEafo+vew1Ee/
UB6sf29LPE17xFvW30+YtPEY33Ow31hPa3mJVPwif/r8sp55M+0edOv3Xial
P9iPrIeln2QVn+nvH8DvLPois3yc0h9g6MwXdDD6CnsIZjyMn/Ggz8CMV38v
Qv+Ml/Wgf8s5QZTCrAfxv7r/z9xfYNYb+UM+1H19Znnkj/bQ56w39pL1Yj6s
v+c15JHzGNaP/sCsN/aO/cL8W/b5N80ex2n6PU7xr59P6fuH+aR96LTP/NI+
GHlmPqzPO6ME/g/6AH8BfY0/hbxAB9M+96+UB2NP8f/wD/H3oINpH/+P8pwP
Uh5MefihPNj6+6w47T1Tsiyf4eActKzX8zh5MKPdg8Ixox9DPi37N029rwPj
j7EfoIOpjz+HvKBv0J/ct7EeMZnrDB3/jfZ5X0N5MOXZP5RHfikP/pDx97Rl
H69IksUz2lllmb/nadp7L+P9CvxzXg/mfBH5gI58cZ6n05kv7h/BlEeeOG+k
P84ndbryxzPbY/9jHy1+QrQ6ryV+wV6zHpxHEs/AP+tDfeSb+vr7ZOSb+aE8
7UOnfdaT+QFTn/2B3qM+/bP+9M9+YT6pz/xQnvFQnvHo57PsL8YHnfFBZ31o
j/WhPOOhPPXh65PFTmTGBeFqv+vvoahvnV8kSsk38ox+xN+hvh6/6fEadK9M
u8V4LPouUtl39g/64w+LHCn7YP0+3JTp33mKaxnlA5S/Af+/ZmAXxb/Vfk0X
yPoZDT1S57sVLFiNHzr71zL+yMz4xSSKWuy35d8j0/d/hgCtsuwX2zilD8CM
H/2JPYdfa38uRWH8C/SRPn7as87fauSzZf7xh7X3pFKXf+QNjH+N/dDlXZdf
/T4beUL+oHOeAYbO+mGPoHP+Aub8Bn8W+4m9Iv7g/hT7redXJf6BX/Y348Of
ZXzMz7tMPab776xfP8vGydSf8Zr/GK/8Q+Stfabe08vjb1v7k2blz+P/UJ/9
wv5ifMTj7B/OC8D4r4zH2p81K3uP/GPvsf/4s8g7/Fv+PUWLPwys359D57yE
83HmF4z/wHqBiS85v4eOP8H6gfX4FDrtIb/W99tRyr9jP6GvOW+ifTDxO/qX
/aLvP+wV8m59Hhyh+KE95JP2GH9SRj/umeWDlPyyf9F36AvkjfW31lfmTH68
MueLeP19pl8Uqu0HG2fkBfuRlFH+gtov6GPkCX0IHfmCfsdSX9F9Mvq9ouh7
LO0pjD5WOFMfg/Fn4dfavzUrf4j1Q5+C0adg/Hkw66H7n6w3WM/PAZ311jHy
g37U/Vfd32G9obM/iMeRF/wd3f9BvvB/KQ/Wz/31eIP69G/9XsE4R0cfQce+
oN/gR78P0O1LdSs+wxRmvJS3zp8GDszcby5K3rAn6CPsB3TiceQRe459sT5/
4ruwULX/0NfEN8h3y4zxOCp5tdQLV/sNfc748QfQ5/gDYOwH7TfLIFxX+2Oo
pT+F2U/wg35CHuFP11/IJ+uHPLJeYPwD1hs6GPtBvIE/iD8HZn05n4Buff9j
xE+W+UhT579gzi8t85mq4h/13joTY6/Q99QH0x/6B/2HfQRbv6eyccae0B7+
DRh/hPNm5J14D6yfV+vjpTz8gtFvtI/+0+NDzrexl7SP/tPv68Hwp/8eAf4Q
86ven2dizmvgBww/xKfW5/HGfTz+E/KB/wDW/UPahx/as35/YOTL4/0h+o73
kewzzvehEx+D9Xzben6TmEy7CtbzbVOe/afH05xHMV7q0z/tow/Zn/Sn34/j
j1Cf8mDK07/uj0FHHqiPvIORZ/2+G4x+wV4xH2D8Iz0et75/Ds5sL0TdL2Cv
iM+pD9bzHVOe/aHH67p9ZPzML+Nl/bXvtYTOjx5fUQ59Z/3dkK8qD39g9gv6
k/2GPQHr8Y31d85vVXvMB5j1pjzrrcdvYOSH8p8sdlXZO+J5y3ti4/crsFfo
W8bL/KI/aRdMvIE+gB/mY17mPsU+E+/TH/4iuITFnip7zfkfGHuMvwkmfsB+
E/+B9fdR+Kdgxk957CVY5de06Iks5znob/wZ/XxCx+jzgxnlD1rkdEWSdr+S
rDDliQcob7Ve/+/8FMx4mT/GC06yjFfd54CxHx8s/ovU41Pmn/6hg6nPeBQ9
E0NHPizrZfgnYOSZ91rEk8gn96esL/sTzP5FPsD0z30KdDD18Sfhl/NbMP60
/t5JjyfQ95TX3w+zHtb9p6jxIF/0j3xYn+cb8oJ8sp60j/yBkVf9vSnyw/6D
X/Yv64l86fIGHf0NP9bvBVMU3aIvU1W8D936PWGKtL5fS1X+BBh/A/0Exj/E
P4Fu/V4nVckX/YGZf+v38SlKH0InPoJuHS8Z7z2Zb+QXfw77iL+IPIOh418i
z9S39rcS1fyBmT/aA+v+KHTGC514GzqY9lkP9g/zx34D4x9a56uPU/4o7z3h
R8+vjP/H/uJ+BPsPhq6/14yx0quR6r0I8Tr0TD2T5b4Ff5H9jH9I+2DWH38S
TH30m3U+9Ygs+eR0/xM640O/MD70D/zp52HEm5b1CBWVMvr5qOJhMP6Rfl4G
hq7rN/wz9hd0+NfPh8HQrfM5mpU/ir+D/kT+8BfBrAPyCx1/hvrW78mjRO+M
/3DR7ld8s5x/YH9YH+7vWB8w85k7o7xrpjz6CNeM8XwRYPwjCw5R3xPgT7Hf
wOxHxmtZ5+/KnoL3WOy3sr+cr4CJ32gfTPv4i7SHfQbTP/4k55v6+wPOP5g/
zvNYf7BlfYPEmIz2HitcJqPdlyoesj6/ilT+JfIOhs76Qsdfzvx3td5g2mc/
QcfeYj+5X9LfQ1Gf8xfGgz+pY8bHeT7yxfmWxV6ZFKY88kb/263+PVxhxoO+
gT4g0x/Afs/K1EOsF/Ei9o39jn1DH4Ct76tSpfX9aqoqj71AX+j2EGz9/VqK
Or/AflufXxjvB5Fn6+8Rje/tsQ/Eu2Do2AviY/Q/GHvB/Oj2BP0MHf3N/EBn
PsDQsQf0R7wPRn8xX+g3+Nfv21n/jGrp8SDygj+JPIKRr5EZFe5l7hvjPQvy
2CHj731FR98gT+wf6/MCkzq/Rb+Doev7iXgOTHzGfTL9gxkf+xV+OA+mvPX3
dgad+u8y1xV9yX7R/V/87w8W/tV9Nlj/3g+69fvnVCWPYNYbeUeeiIcoD0Z+
sT/IP/EJ/iQYfxJ/APuov3/CHuMvJGbU/6TsJ/KJvOFvII/U57wEzPkI/XGe
hDxQH3+C/a7fn1v/LlOYqo89Yz+AKY99ozzxiH4/yn2U9fcANs7YY9bH+n16
qjof4f0c+l3/nlLP5008ir5H/q3zPZu0eNCsxgu/+ONg3ntwn8n9pP5+FH0A
Zv9gH/T3ovCHfPP+D8x42U/QwdCZP/YLGPuDf2OZfuP9Fv4DGPlgvWgPe8z4
0Sf6/S3xifX9fZzC+ntW+IcOf2D4u2OZD+XfMZ/ggxn0g+r9G/qB70/BnJej
Xzkvxx9lP1p/n2LjjPwjr9bfH6RKzt/Qh7SHfPAeAvnA/wAjf9gn/EHeF1nn
009R88N6gllv2mO8xItg4leVTy6Tb/39o8qnkknX83Hr8weGP52OvYcORp+h
/xg/mPHr7yeRV+s8Af6qvn4erPt76C/Ldo/Kos/03x9Gn4HRP8Tb6D8w9bEH
yBP2APllvdEvlmK8z05W53/YP/QH+8X6/USiln8kUb3f4f0c+kDfz7q+BlOe
eAX9Cx0Mv9bviaKVf4q+AbNe6DP9PTb6k/Nb9hfjhV9rfydRnT/DL+er1Afj
r+zIwLMs56a2JmW/9fMq/f0r9ob7Iv38B0x7+Ku0p+ePxJ6D9fgffwNs/X4j
RJ0/oG/A7D/u+6ATX9Oe9e+zBqt4Ev3GfLG+YNYfTPvES+x3MP46+oZ4hvkC
s56UR37w59Dn+DPoG85r9PMb6/OTMHWeQH/Wv1MWpO7nsKfYI+vfmzLsL/qA
/YK/jb2gvPXvNZo0e5qg5JfzAmt5Nr5fZL9Z398Y9y/oI+w3+wHM/Fu/79Pf
i8Ypuq5vdH+F/Qtm/3L+zf5jf1v2U6LyZ1hvq/uQ4knK/qM/92SUO63sPftR
/74/M04S1uflUcI6n0GUJr/G/Rx4gGV8gvGC1Xgz9TPjRV71+J/9hf9PvAqG
Tjxgfd4TpuIH+CMeAaMP8PeRf9Zb9x/xj63XI95aX7Yw7v/Yn9b3g4nW93vp
/hDtWdbbwMznrEy+8Y+YT+QHzPqwfqwn9yvIN/LBfgOzH9nP2FeLnASq/W19
/hoirPeHsd/A1u9rozX7Y+SjZX6Yz4x+Tyaq8aBn0R98vwTGP0afsH7sR+aL
+2D9vtjipkQqf572ac8iNxGqPeab91nUfzem7uqCk43vWYmHd62emKv3xzS5
ufa48BUuXkreF597u2uj82OFmY8+QV7Ojt+M90V7W9quyZWYJrs6ucQe7+un
9rfKdxF93+Zx3mTZeneXdY/XvVP7G3k8sC9v8S+9klV8l2Ota+4aA5OVf9bB
/czkg1WTZc6l/314VNRPnc+2iWw8bpitl4pX0AflKs38VviHBHX/87HU4Vcx
1Y33QsunHZrT2/abLHrq8uzSc12E7h/2iqi+JmbZN3nBbmWe2rOM722R24eP
8r449a+ndHee2tjbNSjL758HiLgCw1dMVPcnoZ5PnR4ufC/63Pi4aWcuf7W/
d8T+euhBV5Oy/3GFS+x7tjk8y/e1fZYfN12+6CFi9/hVPdrBW9Hz32h0eNE+
4/e6OQ/Z1/vmuaB1fqJi8S9fn8003t+Pf2H3cLVP1t/fLnD3c6vInQHKvtp5
NvLd4m78bnSlagUc/C4Z41kfFOvSShjvNXyjXhzqcMr4XvaAjeeGWW7G+4wJ
pyfm+GWV8f1sj8Op+3e2Tvffg3PNPdk8SMhpMSWPFU6RLeIr/9DmRz/RZ87q
szatE+QCx2/vLh98Lyd7/T2lzLMYuePHiP6DvrqI2GxTz8dMipGjh03JGegc
Jnqu++t04tjbssy+F2UOuAcJr2phnxv+9EA8W1931rdjYWK5T+HFdee6imq/
lrGX+0yidNsaTy+echNLZu562sAcLisVLtJ41lpf0WF5S2+H60HC32nQq6JF
/ETdXQkLHmefKk/9/Z97kptJ5OxbKuHJzDey0AbHzds3pMhLe2/dbfpjiFhb
5cDiH3OmSffd82I85j+XRQpV6Pr2Rbz8/K1fjs59n4sC5WPHTX0fL4/1feAY
f+OGrBTpPTSltlm2Px1f//C2Z6Lj1G7f7pWPlrcLvm7Uv1mULPmDw9OFfSJF
g3ujy5nDX8jlfzY4dOR+hIofW3wfuHpeU+M85Pit1rW7tY6XYoHj/Ijbj9T9
I+X/SVvXtPImsyxUoNiUiueN31O7Hbbwc+u0+0q/5rh5rFT1Hp4qfsUeRDaN
nzI7LU3eOFO37579TvLWmOT5I32NfOzr6799s9ctSRauWyymaVM7cap1s1qu
Dkmy0fIRpwsVtJMX35wZnnrN+F61dMcB97eeN+KfQ/Z5fvNxMt5nPDsbv8H5
kUk0yrZ41qrqJ+SSoyU2rT0UJ229C41dvvO4nFXUze/lgTj5anawx4apx8X0
zy3+OnbIeJ/x6M8DXSrtiJNtul4b0rTgDHVe8dvS4rMrPhiu7lu/F2sXODnf
WVnhUjPbe/Em+TjWZo1v2gHpu+7rjZ0+JvlknPn2oPe3ZKuDD44N+mZ8r7R7
529bT5dKUf5FLsfG9T5WSZET78W0mbPHpN5r/NrP1N7zpneW7wn8jzhsqtDW
V8zLc6vXtyZuWb4fKN/jQoPXZUPExVJrY3Y19NbecX0RP92d2vqn1VEiZ/kJ
U+p/dRU7V38r/DktVX6Rw965tQgQ513XNstZJUkOLPcs4Fk9H1n5hHujY73j
5WnboutTOt4SV/MtXtPDO05uKOLc3d/VR6x+cG/AmELf5ZOirVpsaOYuP69q
U3SPd6x8sHzXzO2vXcWzP05NaNA6Vo4Y1vGv0LsRovSiPcfL3nwpS7nYHEn4
L0TcK+Jd6NzjnaJ404mXs98OkE73lh2uP/+tiD+fY836QxGizeeXa/OOfS5m
PXIac3JBpJy153X3FsleYuFvdcp2OB8ibGo++Bzc1UvcazHZ4+qOSGEb+cp+
ZI/PotzF03cS7CLExeuxHdov9BFXesU/TSoVKCsOPrrgjSlAOFeqVTPGLkC+
O7gr6uObQPG67IHIUxs+iuVej/c8/h4k9hQfF7L44i3x3nP51+/fk+QgUblD
5TkPRP3pw2sOPWCWl1p0DllV7bOYkTPs4L1t/mJrvvpnbHa9F3mcXg+9WSFM
XBBXve0Tr8iywbMcn2833mv99iD09RxHI/9YQ/cAse+e8X2rb4XC7czFjN8v
Htms4WKf0un+y7g2j+zyXZZN/Vq16pTLLHPlmPbPx1srZWTnR1EFPhr5yUp0
b7WzXIhJ/j1rbNPZ/ULkuLsH/FqHpEqHxFXxkV185OaQ02VifkiV7uXa7H0/
KEDOLurlszZfkpzlXv7PBgXcZGSy/eU28Ua+r+xdBlzt1CBVxpny9Wx4wcj/
FVt96ZMCnY4re42/VqG/eHj5e5qyn9P3H5+d0CpVOv/gf3/uIiMf2O2lqSmn
c33M8r7k9m9JD+L3G++ND59/ETnveoqUnVvPLDndeA/Sptza4vPmu8s8rxbv
CjuWqPyJEYv71So8OEHpt9TjZT957jHLw7m9U8psjZIPil7Z53HwgxyQsDKi
6K4IOfV2Gaf6F18pe9s697vJW3N6ydqFQ564tjJlyXc1/l7U/VEl38lC4YW2
h5wKkS6ep9pHnvzbyEcUGvvwX9sHcsif969FpBr5ro4Lr4r5FkfJPZ0DN94Y
rH7HU7rsnDvw67Ztslcb1wabyplUPKD473bz5s4SD0S59T8eHTDEpN47VBiz
tvqXdZFZ3jfMW3Vt33p3ZxFXe9iQJyVMyl94IrNNPLgtRHqN6/M0LvGTGm+J
14sbzx/sIg6uqHr910dGfqq2u3ZX3J4cKY+Z13z7s3KQKHYsNvTIUR+5+872
H2/t/iLcbbcFFBpjvE94m2g3Pe+GUNlswddTBXsFiX/P5v2xSr4w6TxlUnzF
0EhR8PW5p8UPB8ql25rvn18tStwMbtt/8OCPMuTGCt9874PElxlrBrXsHKL0
2ctWMuqPPcb3GRVX/56Y4mB8j/HmaPevHyZmzc800ubcn7tumcS67Wejaq31
kVOqb92YY3ik8PR6HRR6Nmt+plmOaXa5e0SJZRu653H/28i/NM/b9p8JH43v
Nzo6znCaXdXIt8S4RNGfR71MMImVJ2vXPtfLJAJl7y9d1oaL5TWXeZzp8Ua8
L3J67M2tKXJdv37Fyr93EUXcwrP5VkiVoza+6L1LRolFa4POTsz/QZb5KeVl
Aycf4fDXZdfx0V/Eq+WLOo856CM+5e1RwHZxpJjTPOfCP/9wkUE93tSp/DVF
/rH93pe/+7yR/ff/dmvKlO9Sigk381d5I47UCdpabfZ3ub73wFd1xp4Vv/+2
+FiedDm7YVs79vd/L4l/vPOsGJ7PLI8ffXnlkUegWPHjGbd8cc/FpNbLK+TL
FiHLeDid35LNyC80171r0TsiSpzo0KdHylXjPUBqA6dfWv9sklX+aZRUdUK4
uJ7j9z6792a9///zlq13fLEIUTW2fsWXJZ6IwzfOfD+TGilOjuo19vY4BxE6
Pi0kx58mkTLh3tGPT24KD/PrQTf6pc/jb/vs1peMEB4rAmb3rBIm3P5M7b7c
zcgvxP1jTul5Nl8vs5zpaD/sd5/H8muVYUVSwyKVv3M/dmch+6VR4mLN6CEu
Jx9mySdUy6HO/ZK7o8TjIb/2delnvA/oemx7s+C7We//N15PXvh+aIRoeDRb
8YBu6fWmZy8/OD3eanxnZq6iXaNE+KB/L7vNjBSlWruOG/vQQf4X7jCpxDCT
cDv1NqHwupvy5eZ/127rbPgrW+fWn3owyngvELYsR2v7e2nqvn/+kPVFbZel
yCpncnbIdiFY6d/1oz8UqREdmDU/0PLd/Qr8bdx/bI8757Fj4Ht13xk1NH7e
lPS4/euNUu9v3zDy/wz57Vl8mE1Ylvw/uQvWDXrWzUnFB0tO90s7se2tmNSj
/rIcO4z8Pysanrc74mnk/4Gf7q/ezpl410Od9177aWDNlSVcxOule952r+ab
Jf9PzfEtx8T7+oheY1yeLnT3yJLPZ/TzG/8t+WLcz62oX7haHb8AUWXfsPW+
27zU+f/C8iMGmd4Y+XuO/D60Q9nQt6Lhtc9n2m8MFxOXh++Y2dbIzzPpj5Z5
mp4z7vdPjWrW6a3JSbQe7/Tb39FRIu/dB1dOFLgvHm5qHdzMOUo0ffsoKWBl
1vv2H+KHzXL4J16dhx956PXo5D7j/j3Pyj4bTwYa+Wve58rbvekHk7ov8Pw7
24A7m4NE+KISFQc3i5StZhTM07KNka+mU7Xq7jNTwkWLDQFFs0+7L3/+8nrV
1YPGfihY7I88YdVNIvrcgfr7Rt/Jch9fqP2z7z/tMu7jV69e2av17jg5YVjp
HDOKO8uCsbfK5qmTLENmHyhxJlLK6aVbHO1RK1k+H5s8sJDTNdnx3Bfh4mHc
x38Y+/O+l85JMnrJ7auJ1Yx80228CsdXa+YjxqWlDM1fLVXeX5e/Yb1h7mLA
o7r5u15MlCfs1vf9/VCUeBAS6X0o6JoYsTnb2WWHQ8WWAdmT204NEp9rVMsb
WTxK7Hw+xO1b+yBRt36v0QPtA8WVinWXDU3XR6kTDo3+tiZQOLiaT6XsjBLl
zsWFH0r3u8b9+arMsNzG78vs2LB+0Nx3SbJ8N4fe64/ukIkucXP6pvPv+cuu
YuX+PSB2HO1f9JcAk8xbuVGrE90PiSPLer24G2iSp3IfGfiyl5+YOdimUceU
NFm4Y9/AgBxewnz9s0/8sGR5+Xn2X8v2eCdGfq20rkWNBHn8atzK7/NviPAc
5boENjBLr2zLIpxX3hSN3v5Yql4zs0y9uW9scmCEKJmQ4jqy4VMRliP2TJe3
fsKpgEf8+5kfxU7v1W6Ju8NFndFT/t641k8U7FsjV+cr6XH0gGlz798LFd7f
b1w7cCZY5Paf9shtcJh47rV/e/0ldvJVcVlo/vUk2bvVrSs5U4aL0HLtKvl+
S5O18r//b3yu7WJc64ErJ6f7Y+6OwX8suXBd3XdfmPzt3doxfrLRy2VFbkam
yTYrnM7GDA6SHZNqzzj1LVn2bLDPYeccP3Xe06larnufa3rJLysStrbqnSzf
BL1cOLWLnzzivNL2UK0E+bzWAVl3/Ds5v0mtoTPLJci+nofn7wn9JGu+rrFz
4oZvclKNK0ML/ZzuP9cdtfzSbrMcfbDh6WXHIqTHs9HzKxR8LYOOyoeNDoTJ
Fi1nXV7Y9K5MurJlWM1lEVIk5V1/58IzcTuwYbdiuSOkU9CC2b7TXoolp0zh
dktMsubI84sG93cTA04Gbfa9FiQrT92855PtfTH04qz5X9aGyZp9wjYGV3cV
VQ+JlVev+ckhrk6rS5T/KGLsZiV3PxQkJ369kDg9zNc4r4iT+8c2dxVzDgzf
XGl5uIxZeLF8+3F+4teEy+d7hntJ21K3Gwya6C92rBrzx6jdwfKfq9PeLmkd
JoI7DkkaftBPPpCOQf5HQ8XuIh1z9Y0LkMMGf28YP9kkanR8v7fkhPfyrzq9
Cq1PCBWRzxasG10sMEs+xXed/YquyfdCnde1PXS+uauXkW/sUq6k7nvS0u3R
k3ztHg60k5O+x2xdkWacp+bct6NAmIMRb7bcPGrMreR4ObHJqp+Syr7Oki9j
Ve3Cm5ccNvIptR4f/Kl9vnR/YlSjxw+PvVLvKWq1GtruaNdIUbpwzK2a6fas
00R54/HnlaJX0xtLQ9Pjjw8Dn9zpdHmVOLDML6mwRzreO/u8bZ2XYs3SZjFd
Pkao9xKhm158KFA83R4ebdvtR5vb6v5t+4Mvuct88RTNx/fqE9DTyN819+8Z
T74MN4nI3TmPmhyN32vcc6Fpd5u6D+WWe1XP3esULy9etR39Ns9D8Ueb/07G
dY+X3QrsbPto/AMZOG1Os/JbzLLblraVtvS+Ko9G7z321+skWWff0k5LJ16U
yfv33t72IElOPXO2/7bRyU4XXjvu/F/8v6n3YXGtQnI7x8lrEyr9v/cK7j5P
cy7OlSwDly/PPtpeZsmn0b3h0A0HPpvkjImj/qgUuylLfo2xjZ/4NT6bLN2n
D16/ZuBD2erF0VpDRidLp8c/Dz2cnC7f0YF1mhcKUe812/VZUuKIX4i4fa5G
rbulTCK7Z+Tpb0MDxOku3S+NyhEu3x2zHfUkJlw8EsU7nNkXJJuvCZhduWGE
aHndcbNbkVAZ+O+owAAfk2hZvvDVyReDxOTe3uUf9jTyjV70KV3yZHr9Mt2q
N+k00cgvNK1bXIUSz4z8owUfuo9fUDpczLS9Oiu8aITxvVh2m788p4QL32b7
9wy6YeTH+Hl+6IfQCj7qPKn/pBWzrxTxEUcmveocO8bIj/8i5LLXGOdY9b7A
02nr5IpfYuW3Rz/sK9TdyFefUCJ8W5fFEfLLotJdH8/wEWPGJrcf42rkm+81
5uWVPLcCxPm0Le0WmozvQ/bHHupS8K1JBC8tUyl2wWv1fuKfbmf3Nm7yTPpX
3jXhxaV4ObzivMrxf92Sm5Y3qeTvEScfHIodEDnsupzc2S7u08M4Wafc6raX
Tj4TTWtfejTroZGfYMWCAnN/6myW+W4tbXuh1E3Z/vnDQlXqGfkxZuffOrn5
50ixM9/niTlSnonyG0NmbF4SKbINnJ7neZPnotqo52MvzIoU4ZOTxkdGG/n4
uD/NdeXo36cOm0T51sNPhjyNFGWatRt/a6zxfvXEnR+HXF0dJRwGb6zXeZyR
T6PXqUEvd093lqnefUvdLREv13v5b3izXcrBJ+ptGpQ/Xg7rYLureJEHcuPl
b48mrDfLX1ODXGdH35NzwxpOM/1mlmF1Z//y096jct3GxIhWj0xi99jW7cZt
2yPLnzIXOffSJKZH99q9+M0O8W3UyYYz0v2HTfvzLQo9/FyeKux2WoQmy7pB
bU8PcX4qHeWcbM3vJcveHybm7LH4uWg3zn/zPVOyfFxj8k0728fq+w/ma9bM
bju22CdLe4cFf/uXeK3u28Nbz3n0/cJraRe+t8WCS0Y+jk7vBldbNTBaNrp0
tPLOoS/VfWeZIteHZO/3RQQ0Kjqo1mNf9R7EcXKj2lUr+Iul9cbOaDrOR90H
P2q+7+znEh/EwDqz2p3eGqLycxz3+/rUZX2oyN/jW9M7Hu7qXrz42vM5B+T9
It76L1/dtotJTHQ50tmxqo+KH5K6LHPvWdlXFPy8dmLZ3t/lvcUnEktscRX9
Knt/XFsrVppWFr0xZFeEGHTkTerI3T7ihc369e2eBIqIp12HhYf4i1Krt5zz
uBUoliTdH5aSPUCcONzbsWPLh+KvWR2Wzp5gvLcK63lmxsiIdP8tNtL+fmUn
9X3ff7tjvS788U483fepXbfHYWo/2K+eWzkhPk3a7PX/ZUobO/l720+dJqbb
j1yTRhVYsWWnnLao7qcJ343vn0bN/nDmtxMm4R38W5H9Q0/Ja6+6lNhywyTG
33FwaZz3rJzsXGrG4svG91ElL2d7n/Iu3f9sN6/6m6SjYsOVmK4xz0yiaBH/
s/vb7RFpz8yrlr01vp+6d7Pb5y0XTMIUFzYn5Ed7MWfIsttrDphE4RFOI6LW
XRGTZj57YZcu/4vqFHTqk+eUOHozsEB9J5Oo/6H2pq79z4qYWQu3/eZgEvtD
/Fd3C94sHUNbJ6e4mES9C3Pdctr9KZa8kd83fzAJF5tavz3oukX0n1fdvb2r
SeQKGf64cQ4jn82Xca229XJwlV02PLb5q7SRb2PciBD7XJNi1HnWti/T/22w
PEbOsNtaJn6tkV/F5ofVzrXyuYtc1cYc8oyKlQ8XTBm29XWg7OAX9WD4nmfi
0LpVScmOgbLn7rCDtj8/FyVv20bMcvMXG51/Lhx+0lVsmj2t9vfORj4Ovsco
/drv31pdjPwc1y9vWPq3yUWMyPu609n6Rr6ONfa7u4YdTtfHEfM7H0iPz3jv
MTpb0dGPrz8XU+8UKN30eKCM75u2dPUXf/GuzPNxTxzC1fky5Y/1HGS7bL+P
iv+nxW+/+vvZILFn7OOiJfsb+Tpa3Wzea3palGw/PY+PTYsAMfzKlzUlmhv5
OtT7/62Hi7otChCveg8vOM8uRGz78VvkxDEh6v3K+iOViq28ZHyf3KFHpRp7
/ggWFf/ufj+pipHPo5/L6BffRhj5PIjHi5TtYCefB4jO/3kNqVY8UmxaMOLs
kgYhip9dMxYk7ahv5Pdot2vhtcCvQWK+uXKuVguy5vtotWD1umNTI9V9sP3F
4vEFYyLFDb/FDi88s+b7GHCqUL86TY38hRfbfprW1D5S/JMrMeZhejwUUd95
WY8Uk7h/73TzX5KNfB859/m3GOIZII5FxLao9/Gt2g+f7tqOMZ+Pk7XGlVm5
7ZWLet/BffAv3RsPf/c+WkY7/jpn7smrolf7Qd5VS5pVfN8p6UhqbI1wsfTv
oW+ddxj5P0Z9uf7zvTwR0mQ/s/74r6GiU/f2fTtefCD7v6vp2Hd6lMrPkb9D
Yv/NvUyiYvL708lvrkn7A6kvPaeZxLFLC56XuXRK3LpS4dLjeJO0uX/kQ8rK
cPlHpZ3Rrm3eigHHbZpMcjDy4c30/zTBf2OorDEmW6ExhT+K0nb1mtlmM/Jv
OA6uvPfglhAZeatCuyodQ9R5weILjx9UKR8sGjS7UbtdkpGfo23uJmu7Pnkm
fz1/L+flYtHyeKeSgbn6/Cc7VG176fHP0XJEYJlmAXneiLpHy99q1zxC9CpZ
7tjf84z8HHx/4xV+zHnWmgixM8eAUYPS9wnvkRrPLbo8arCvrHj2WpVXqanS
51GrzSeXG/k61rl2thdjvOWchQs6ujQw8nG8CRr5qUh4siwyPcS0cI279Kl8
cMpB5zRZqFAX/xKtPip/9VylHBHu9Wzlh2V5TG/S47PGT3rN7By8TT4r2Uxe
T9fH4ZcrNfmpk694nVzH9kChNOnT51Xj+7ZGPg7boq3vHPg5UNy+tjO2Z6lk
6XOr+q2HV4x8G8jj+w6/O7Xcnyz7THIbVMDDQzbcNChfw9lJ8luh+8M6bvZU
7322fZyRYEp2la3C6s/M9jFBfU/aZMuENgk3E+SyYhv3+dzyEI4vzEXaLU+S
A8vvu3+7h6d6H8r3XQWdXLsE9/8uo0ctrda5trec5/7Up+okI39G+cJrr+Zq
Gyftyx8KfrffQzY9MH3x3Ctf5YWZdqWPF/RU+TKcm1ZoeGfKa1F72rMH1xyN
91LFQ3+7OT0kWi7J5xBy508PkaNDrvJOzl/l6ry7Hs+yN/JjXPEpu7pGup/S
3vxB1vjoIQ8OyJ2rjVOkKCCHv8ze9J2cneup/+RHxu9V/PDqxb4xj0NF2ScB
Fz2WnZIXt6X0yt/FyG/Bft4/f0pim0X/yhF/HcpTcnGkrHT2fINlfs6i5v7d
3Wv1NfJj46+POFB9d+sfnonlPoPXVztuEldGe6158GyH0m+2q6Y3ujjHU5zY
c/P3iY2MfBepDTt2b5LfyHdB/6faNzl0xNdN7LhjZ/91V5SoWvjocse5Hkr/
PR7S7P23qR/FJu98i0899RVD8iXUHvmTl7o/32hfv2fQMk/xYOSyonZDjPwW
E0s7VC28Okz+ElF1iPfgADFg384GJe2NfBbPXq/63a+Kka+C90vhNv/O//pH
enybO0+f7cf85dTLA9enOhr5KRIWbIptVTlEnCzbf2TbcDfZ/P3d3NNnhgi7
KQsSCn828lEgb6NP55r9fGCoWDxlwtaG+8OE96TzSYUXpPv1xfIPeOJu5KfY
PrbbtCHdTFnzUcjiOx5fDhcv8szueq5zsNJ3f95Lu+RqY/xeg3/4ldg1O3xl
mTkXbwxbES6GFFzkkjvGyE9Ry6n071MDvOX+18V+7f+jSYQWPNm1TaSRf2Lm
1XlrzI/fyiezmpXzmxEuXEJtfm7r66Lq74+9WNTllK+4klbbr2e6HX4U3Wpu
Sikjv0S1mSXdE96kxyG7Fy8cv9P4/eLpkec3P/xg5I9IrfBi8M10/yTPtsD3
67uHZHmPVrfk9Z+2T4iWYQMKHi3pYOSPWJr3i6uz48ss+f73lSp9PdklXBR1
GX7sSQ57+bXDyqCd/+8+smSFewe6LjWJpEW/tiqY77pY7nfi1pYFRv6If5Yl
Ly/7t0nMdV1daH2Dq+r7va6JSY/3jHkiVx/aW2frmnjZ+Ns2pxtdH6v3Y7wP
m7A3YOftkfEypMnbLufPPJYjx+96nvLCrOgdN+yY/MjBLMsPLZRYstFVsW9e
8oteLkZ+ffclXZ+fupQk31bv0PrZ7Z3irwL39za5bHxv/zFgyvmXF5NksYWr
rz/9slPOWRp6YGB6+SF7K1xb13S0TF1r/+z6+STZb/2zUclbtsl77uuXLEgv
37LbyefffxgtWhyrPPtlOn1ZuY+lSttvE02bv6vw6yXjfNNmXZ2eH8/EyepT
Eu8vfX9OOts/dFl9Kk6aN9f1jU/YLh1yOzauscvI3xAROfXWqh1xMk/O8iuH
vt0uQkYkRFTcbeRv2HzP+0PunXEqP8PihJx7V037IMN2Bso+fY3fmxsx7E4d
51p+0veXxIQn+ROkd+ecNwa29pWnRh5f8UNLI99CWOqnBbei42R87KWyn/Zd
F/vvdurw4Hmc3HDaP6DlRWfR5krY+R5V4mWlgu0OlBgqxeeGG4s5FYmXj0af
/zjCMyBLPsBDrmsvOfZ/rvyleLdcC/o89BJ58jp1GDni/+XbWTd5kP184/fh
liy97dzP3vh9OMbX4sWz3FH5kuUvx9NiV3RyFutWBMxr1SRZNnzd/mnKPSm+
Lpu37EG9ZLm1V/K+W6ZrotGZIX0WeifJ0Ea9Rv/geUXlX6i+sb1btQg7ZX/w
lzbNzbG528Mk2efDo382+9vLZfZB499ci5MDHX/dO2HLJdlx8ujfHl8wvjdb
f/Bkx5bXjfcjte9GyAUH4+T52Wnjs815J8OfdH5Y7JdUZQ97VcwefvRdqryd
rV8z15HvxPHt6xyydzDyLdxqezMmyjdV7v6n5o9uf7qLC03HN/N4niZneFyd
tmiCm9q/fbafv3x6lI+6v8Z+VqldeGX/2FS5KDanzZK23uLDtG0nW7VOkSV8
d3bb/4+X0L/nyD5ud/XsuVPU9xzZt51/Hx2XIqtly96j7TVvFS/fbePoNrJJ
sOj1vNqdK3lT1fvubk03Jl78ZORTWNRhfEiPJUlyQuXUn8u/MfIrrCz7z6Ip
ff1l7htnujmWMvIpeJ+M3V63boJ8/OT+2mrNjXwLowqvGO5axfg9MeyB38dz
u2o2S5Sffjp1KaWTn3q/9777gnylvd3V+1nuPwo4/tjyY48k6ZfWuewpH1ex
IKnNmsN+CbJR1zoP+vR8p97vMf9dw/dEv/zPyL8wfnqRox6rEuWlEN9KF1u5
qff31/9u/sb3J3/xuWq955XrJ8oeOUtu6hZm5F8g3qqft1GLjxMSpe2sCyvc
Yz+LTdvmHZ6yOE6eWdLoUnTyJ5V/gfVYYDfqxc1xcWo9/GJTUlr8lq7/Skzv
UK+Ot3ovlC3mZNisHe4qPwPvc1/23n+qy/qvclS5Y7OOtXQXev6G978ca5t6
5qvcG7m9TNQXI9/4utR6p0z3wsUl+WdymcRH0r+NY6UiVbPmb3C0c97rOdTI
m3RgQ99+zeoNlK+eeY2YPcnI5xC0q2Pk2mUm6TWxQscXezao+M23TlSFqWfP
ie+me1vD9wYpfyd63PgmLV2CRYGK2/IUPX9dZHerFfVxU4h6n4C8Be8Z2ORW
9FXlr2ya/nRNwAB74TB1SovuByNF683Lutw8cV/8uXWi07GpRr75MYPvdwhb
ECU3eif+dKCqh4pHW/Sq8GpCcS/huLfF740bGvkamu86lNYwyMhPnxTv3KbY
2VDx9oj99rAJH8XnXe4Pv/YLFc8qNK6W8tBDOPw4/c6OPcFyZMkZi3uEfFH+
xMJW8xcGzvIVr2b0js/eM1h9jzHjdcW7BWsb+Rrwh1Y9nDjbZ5C3GNpmzOrd
04PU+0r0ae51ef+qedNf5UPoWnTHgUdbvUVwm1L79lwJFitOXst7oayRz2FI
0/Uv+j3xFcMcCo7aNNfI97CuSKl3YwaEZMkHcct3d6GQbOp3UWWFzdOubf7d
T6xemVBhbEWT8ucmjBx9vpiDv6j3r0cx+TFYpM64PeVDLuO7KeR/5fVS659N
CFHnDVsTVp+/2DpI9Ht+6MB3k5Ev4nTr56uPJRm/76nygX640M6jQqDIVmRU
51X/Lz/Exq8jgr9V9dW+h/MVCbJmQZctEeKfUYMdw84bv0dVtK/TV8/4SLFm
+aja1Qu+l3/9kuu/2iJKTLz/YmhcRVc5O/WVg28xX+FTa1e2AZcjRD6x7W3u
Sunx9f1tE0onpcnFudYV8TodInwX2371XGV8X9olsczO/cu+y81eHZ5v+ddF
dnG/f69sxHc5tsmw2Tfzu8gnlf2XbnH+Lmvtrdl15ZATYt2Rgku/HYmTHlUX
H19z6Jyoerb78tJn42TpP0pXNDnbC5vYf2oXvhknJyxonnuy3yXR6vTOZfev
GPkhbgweHZ+2+bt8nVJlwOFO78SD1SW3L6+WILuWGFq+ecxbcWmj/0in599l
jWv97/Qs805WNgX6zbWNkf8UHFCv+81Pomfrqts6HzTyQfStGpIrRy6zHOP+
67iCX43fh+pg+vA60jlItCo/PnuNkAci7wzXhUlDg0STA4meASWfiPbhVf3K
XI+Uve6GOtv8GiWCR7zo1a6G8XsxDoUH9BvsECWPt3qUv9Yw9btOsmv5sNCy
tSNFzX3lp5ctaMqSz2H5rnWvVtoa+Rzypx4qOlNGio/Vevg1vv5cnjmWNubT
z5Ei+2rXFh7xz2TFq1vnRP9u5G/4EFtj3/kaUSJPT3uX+x4PRLb3RTaOWh6l
8jXMLbSq95/p6377eMXZA/+LEnX3fnM6vsD4fafPvmPuek2NFCV29y878icj
3/z75Msvtw4Klu0WhmXrGZUivZ78U2H1f1nzLex6P3vricOp8je3r6uOrvLJ
kn/h/ruJdczvU2XcwIpTGg4JlPmyTWl8ONXIt9CoUkqOsC5Jsn9qnWpP8xj5
GHjP0DqyQ7SLR4os2TjIZne8t+o/LSE81+R9bup84ejDfXE1Kn1U9hP7YHu1
+e+FmyWp+5KN0e0uFpmebp/arv3jywK3LPkaxLW2jQf+GC9Thx3+JXyDt3q/
GllzbcE2e8Ll8Pd9tvUJeSyz/XBn8kHPsCz5G6a1WL5l4uFXMqHT0TybjobK
b8eKdY/Pf059X+WUzS7W78UN9V5lQ+jYUnmrb5db25RqWbqukc/BL8/Mj0d/
Mn5fwfwyWXpcDJZueR1u2H37V+nbFdcO7tzR3FksKfvLyEOzglV5X+eEfZt7
G/kcWK++65pvyVPzojqva7J21eTLVd1EzR/zd8zuZvweIfRDt3N3e/I6QL0/
yfvzqn43owNFF9+Xtm3+M/IrXji0pFDFle4KN43J/nJgivH7fshD58R7gzb1
MfJBLO6ba+2hbuEq/0PLud3ndvONEge6r3hiN+uOeFCqWKHT1U0i5e2i4OuN
74uvP5WePOlOOj167s7Gtnbi7f2zn7Ony8ulaj0Llbhtkjervvxv0yz13l3m
c9t9uXdsqHgy7UC1sgmmLPkeJh4PrH/aJlxUK+B4ukDqU/W92dIwz02Nj0fK
5EI/BJ6cHCVOFo9qWGdOpCw7IX7KWucocbVj7Mr97Y18D+R/GDA/m2ehV1HC
r/DW4+Ypd8Srdz0qFUqnk9+hwF8TTse0N4lf3i2ftO3qeVk7e7nWl2SS7OtT
oMi0ySeV/H/IWMfTss7iToe9HZPkupFdYgr1DJXvT9fqUN0/Tdo8+/Vitm2R
0n/koQ9X772T81uP2FHzlr880bmNTY7eruLE4mF1ntQLFXY+wY2cbT1FUN93
bdwu+MoRIwZMi/T+JEK/j1oXXf6LbF252M2yR3zF/NINnJec95Re47p4zKgR
KHyf1Hee2/mdmFW7y/4w9zAVD0cNSp73eZ+R/9005uXdurFmOfjfgmNmtnki
UhausV23KV4Oef3X519O3BPRQWO8Oo8wy9VV//xv7g0P4fHkQuEuNYLU9/1X
/hu86PDLKPW9W/3whv1G2Bi/71u4fZnJZg+THLHxpnngrpey+ZcZExe2SJFB
yU9vJk7bKSJyV06qlpAmXWLS9ubYYZKfHGusXD/dU9mP8ucf9Tp0MkW6FGtb
6N9uxu/ZXcnztkZidi9x5G6++TEzAtR4HByK13Oplazil13lAspUKxQrC1wY
daXrdiMfN99z/pe73MDts02i9qGeHUY9eSF9yg/qVnpEtPw/8WsTWA==
   "], {{{}, 
     {RGBColor[
      0.36798948059047276`, 0.18706754305963919`, 0.6342340483482978], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXe8VcW1x/fZ5556UQiCJZoI2FuQorSooIBgFwTpTcRGExEQBAERVIwi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnnQjmUUxh+8y/Pcb4giqj+oJNpTPlQqJHz2aixT2SnZqSxZhs+Ekeyk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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5171408436172102, 0.4464014827999652, 0.8438843323716584], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmge0ldWxx8/lnvOdr2gsUcGrmJUnURAQpCgdpKg0QxHF3pBEUFFBEyXv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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHm4j2Uax1/O7/c77/u8KoNwoZpKZCudJNmO7VgySWRJtoSaOI61Bs3I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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6391610105789491, 0.6486160828903496, 0.9112162645339651], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXuUllUVxj9m5nu/9zKogIAGmAozTZaA1ZJaKSiYrmKYYQ0XW4pAoOIt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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmeMllUQhV/59nu/t1BElCYgCBJsiDUaEwVEiAobWJoRDLgQlhYQQUQT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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.748821774819224, 0.8248104175922695, 0.9137161921988732], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl9tvVUUUxvfhnH322dNgTEzElJZLQYsoVWMIQR8o4C36hEIM1UZFgdYH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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEdo1UEQxjfJ+7/3dkNUFCyxxMQeuyISPVoQPdkQxZioWJJDPEggdhN5
xoIFG3oVTUhDMXY0sSsKQTxYEOwRxIKoB0kU/X3M4YP5dsrOzs5M7op188rS
nXPLQQyMC85leefKIYMj57ohT+DsJ/IvcBXuwXfkPWAV8sBM5/7FncuDv046
14b9NOQcYuQjD8XmH/yLYiA/xOZVhnNF6HvAj+F/NoE/PAkfg08htmXwu8in
sH9Kko3csR/9Fvhc5IXYnMC3kLOe5H6FGJXwKrAK+Tk+t/G/A+qx741NLnIe
aMd3EfGHIw8D78mnmrNzxD5DvE3IHeh3o9sVLJclenOwGujtxcQsR+4nf/gk
8BbeTIwTyPWgDl1N0nLZg/0IeNxbLT6Dw+j2km+KfLPTnGtC3wheYF+NfS22
x8FqbNeDBdgWwC/FrMaq7U1wILIanyfee3gDchNoQC4Fw5ArwEH0G8BsYh+F
z+Su6eA+8bI4K8F2YrC//khNEvDLYBf8G9iKbluwWsinO7qP3u7KSbNe6QrP
SFjPVCatRqpNIfHbkT94+wvleAO5FeyP7A1T8d+Kz130nfAk702Al+TyFf8W
bNd668194CS2f9RTyDvQn4bXBqvdM2o4Ptib9JYf2GxEfotNjNwL4Gfhy8Dv
mP15Nnf1ARec9chI/EcF+yv1yAp8m9WDkfWccu/iLbbecAvbtqT1qnpOtVbP
qldV883oS4k/h/rc485Bmg/wCX0J/Bq218HkyGZQvX8afSpuM6Be6eVtttQz
yuWdt15TTu3YP8E+H3kQNo/Vm0mbLZ3dw/a+t79XTTvQxTOttjW8J4X9zmB/
tRafTmwXwLPhTSA302yk08w/UO8Eq7Vy1N9dxCcV2R9WoKvg7DzyLPTz4Svh
feMWMwc+INgsyuevtzt1l/70CPe9wX4p8et473Z4Mfo1CZtx7Q71oHpPO2Qs
sdLhK2O2o3TXBm9/rTv194qpWOoBzZZ6SL2jGZuCf39vvdcBWuCtwXLXznrk
bWY1q5rxLcH+VH+pnaRZK/K2OzRzyrXR2+wp58HYRt7+Wn+s3tMO0+5SDw4J
tlO1S9UT9fCGYLtDO6GKu6uD7arb1PQQtplgeWQ7s3+wHavdqp2kWowONruq
SQl3pXG2OLIelDwj2OzrTLNeEOztmvn/HSLSvg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.848712187621698, 0.8757037823573659, 0.8754667050856402], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VLtrk1EUvyb98uV+AXWtafI1KbVqvyRUJx/oqoNUVCKiCI1TbdO4lKQv
BwcFcRSqU9RBV6lFpIsKLoJxEPEBHSqIQ8B/wAf4+3F+HQ7n3HPP43ce95Ya
rbNzKedcB5QGlULnhkHPdjj30jsXgmYHnKsHIOjfwqYA3ZHIuVXqIS/nnOtD
HoP8BfQI8vPQ+ENQW3wLvqmsc2u468qG8gZyXQS/AHoA/Xpod9TXpWde3vE8
Bf4zMEwNyMeRv+QNexwaLuKnX10xP4CaoE+IU4XtSfhUcTcP3s6Z7Raw3WMs
4d0UZmIkbuKZyzjXw7kJfhpxrsN+Uuf34DPwSUKTFyAX0acY9CMwXU96xpmU
nKgf9B2CnA8NK/Nu928Due4gTgtyCnIN8qXA4jEW4/zCeSSwOOz9bGD+rL2v
+nlPrDPCQPkjaryPmE9Bd7EMj7N2pszZMw/7FquXU5rdumbMObA+6iuR4aNP
VzUQ/zR0E7gbhf4g+G6cO9DvBT8QmS3xbqr3a9oBypfBi6HVsIR+L+ZMdwM4
j8L3FvwORZZjVD3og64NWA7qOMeGsHKXvsN30dus2QP6sA/nEecP9O9wHoO8
L7JYhyN7D+xHF/yzN7w9zZoxvLc5cUYV6NJZm+2w9pI7yd2MtcMJYo5HNjfu
V1o79sZbX9iTDPj+yOb119tsOJdB9GAP6DfyfvOGiXhWctYj9od1/FMtZcQo
RfZuuOOsn7VfBT8HPZgrw/YE7srCXtEbpJxSLbXQ9Ny3U7CtedOxB4n2P1bN
3JUFbzkYn7qy9JxJW+9rl7ed6KhvieJ3EP+Mt7+B/8pX/S07wV9583/hbQ+4
AxPe/iDa8LyqXU30ftnP28hzE/KVjL0z2nCm3K8hvbsiYhxD7oLu85pdX3a0
eeLt79t+V7RhHOJ6LWx5xaRvU3n4jlhjVb3lO2lJT9uC7Ee0v9xJ/mF1va//
N5yrfw==
         "],
         VertexColors->None], 
        PolygonBox[{{2496, 2497, 1183, 1143}, {2602, 2310, 1131, 1183}, {2603,
          2406, 1315, 1517}, {2601, 2604, 1517, 1131}, {2593, 2302, 1366, 
         1510}, {2426, 2425, 8, 1057}, {2337, 2877, 1824, 1825}, {2406, 2599, 
         1514, 1315}, {2302, 2590, 1508, 1366}, {2600, 2487, 1130, 1514}, {
         2643, 2644, 1481, 8}, {2351, 2887, 1837, 1839}, {2201, 2878, 1825, 
         432}, {2183, 2707, 1646, 210}, {2335, 2875, 1820, 1822}, {2607, 2313,
          1135, 1371}, {2876, 2201, 432, 1821}, {2619, 2333, 1175, 1414}, {
         2384, 2933, 1879, 1881}, {2875, 2334, 1821, 1820}, {2928, 2321, 1145,
          1871}, {2938, 2335, 1822, 1884}, {2352, 2967, 1972, 442}, {2967, 
         2353, 1185, 1972}, {2336, 2936, 1881, 1177}, {2842, 2592, 1122, 
         1786}, {2887, 2350, 1838, 1837}, {2487, 2695, 1630, 1130}, {2518, 
         2517, 1244, 1388}, {2378, 2470, 1258, 1230}, {2609, 2318, 1143, 
         1317}, {2877, 2338, 1826, 1824}, {2311, 2605, 1371, 1132}, {2592, 
         2594, 1510, 1122}, {2707, 2381, 1871, 1646}, {2888, 2352, 442, 
         1838}, {2321, 2889, 1839, 1145}, {2557, 2556, 652, 1481}, {2320, 
         2611, 1317, 1144}, {2618, 2617, 1132, 1175}, {2879, 2336, 1177, 
         1826}, {2591, 2485, 1121, 1508}, {2935, 2934, 196, 1879}, {2520, 
         2521, 1388, 1185}, {2485, 2486, 1414, 1121}, {2940, 2941, 1884, 
         1258}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2936, 2336, 1387}, {1178, 644, 433}, {2878, 2201, 
         1241}, {2353, 2967, 1194}, {2517, 2518, 1442}, {1885, 1399, 1259}, {
         2381, 2707, 1235}, {1444, 1443, 443}, {1188, 1259, 484}, {723, 646, 
         490}, {1188, 721, 644}, {778, 1443, 646}, {2350, 2887, 1193}, {2334, 
         2875, 1176}, {1443, 1536, 646}, {771, 644, 211}, {2201, 2876, 
         1241}, {2338, 2877, 1178}, {1259, 1188, 1176}, {1387, 1178, 433}, {
         644, 771, 433}, {2889, 2321, 1378}, {1399, 1393, 484}, {1194, 1193, 
         646}, {2707, 2183, 1235}, {1241, 1176, 644}, {1178, 1241, 644}, {
         2934, 2935, 1880}, {1443, 778, 443}, {646, 1193, 490}, {2875, 2335, 
         1176}, {721, 1188, 484}, {2967, 2352, 1194}, {1176, 1188, 644}, {
         1378, 1235, 490}, {2336, 2879, 1387}, {2335, 2938, 1176}, {2933, 
         2384, 1242}, {2521, 2520, 1444}, {2941, 2940, 1885}, {2470, 2378, 
         1393}, {2352, 2888, 1194}, {646, 723, 225}, {1242, 1387, 433}, {778, 
         646, 225}, {644, 721, 211}, {1193, 1378, 490}, {2877, 2337, 1178}, {
         1536, 1194, 646}, {2887, 2351, 1193}, {1259, 1399, 484}, {2321, 2928,
          1378}},
         VertexColors->None], 
        PolygonBox[{{2888, 2350, 1193, 1194}, {2520, 2519, 1443, 1444}, {2938,
          2939, 1259, 1176}, {2337, 2878, 1241, 1178}, {2463, 2521, 1444, 
         443}, {2384, 2936, 1387, 1242}, {2519, 2343, 1536, 1443}, {2935, 
         2933, 1242, 1880}, {2879, 2338, 1178, 1387}, {2518, 2463, 443, 
         1442}, {2351, 2889, 1378, 1193}, {2940, 2390, 1399, 1885}, {2928, 
         2381, 1235, 1378}, {2939, 2941, 1885, 1259}, {2390, 2470, 1393, 
         1399}, {2876, 2334, 1176, 1241}, {2343, 2353, 1194, 1536}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2183, 2707, 2381, 2928, 2321, 2889, 2351, 2887, 2350, 2888, 
         2352, 2967, 2353, 2343, 2519, 2520, 2521, 2463, 2518, 2517}],
        "500"],
       Annotation[#, 500, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2378, 2470, 2390, 2940, 2941, 2939, 2938, 2335, 2875, 2334, 
         2876, 2201, 2878, 2337, 2877, 2338, 2879, 2336, 2936, 2384, 2933, 
         2935, 2934}],
        "500"],
       Annotation[#, 500, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2178, 2695, 2487, 2600, 2599, 2406, 2603, 2604, 2601, 2310, 
         2602, 2342, 2497, 2496, 2495, 2318, 2609, 2409, 2611, 2320, 2610, 
         2319}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2272, 2964, 2273, 2426, 2425, 2147, 2643, 2644, 2555, 2557, 
         2556, 2210, 2456, 2471}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2698, 2490, 2313, 2607, 2306, 2605, 2311, 2488, 2617, 2618, 
         2333, 2619, 2174, 2486, 2485, 2591, 2590, 2302, 2593, 2594, 2592, 
         2842, 2841}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2166, 2440, 2298, 2822, 2824, 2823, 2247, 2502, 2503, 2192, 
         2169, 2446, 2173, 2685, 2684, 2922, 2921, 2305, 2629, 2630, 2628, 
         2686, 2687, 2448, 2697, 2696, 2489, 2312, 2606, 2307, 2450, 2315}],
        "300"],
       Annotation[#, 300, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2276, 2769, 2277, 2770, 2236, 2768, 2275, 2767, 2274, 2323, 
         2966, 2322, 2534, 2228, 2531, 2533, 2532, 2551, 2153, 2755, 2756, 
         2754, 2254, 2757, 2212, 2725, 2760, 2759, 2932, 2457, 2213, 2727, 
         2726, 2733, 2732, 2215, 2730, 2731, 2728, 2729, 2214, 2763, 2424, 
         2945, 2946, 2944, 2400, 2476, 2475, 2410, 2399, 2226, 2479, 2480, 
         2398, 2969, 2397, 2152, 2484, 2146, 2483, 2530, 2529, 2227, 2963, 
         2507, 2195, 2955, 2327, 2270, 2765, 2271, 2766, 2269, 2900, 2361, 
         2641, 2642}],
        "300"],
       Annotation[#, 300, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2445, 2191, 2168, 2680, 2679, 2751, 2750, 2249, 2752, 2250, 
         2548, 2589, 2588, 2421, 2177, 2694, 2693, 2849, 2848, 2405, 2597, 
         2598, 2595, 2309, 2596, 2423, 2493, 2492, 2491, 2317, 2608, 2407, 
         2408, 2494}],
        "300"],
       Annotation[#, 300, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2149, 2414, 2148, 2646, 2645, 2772, 2771, 2402, 2776, 2777, 
         2773, 2775, 2774, 2415, 2154, 2655, 2654, 2789, 2788, 2403, 2793, 
         2794, 2790, 2792, 2791, 2416, 2158, 2867, 2868, 2866, 2329, 2462, 
         2461, 2198, 2511, 2386, 2957, 2205, 2473, 2204, 2746, 2747, 2744, 
         2239, 2745, 2260, 2864, 2865, 2613, 2863, 2862, 2460, 2220, 2528, 
         2396, 2738, 2739, 2223, 2478, 2221, 2477, 2222, 2737, 2736, 2395, 
         2411, 2219, 2764, 2218, 2735, 2734, 2762, 2761, 2259, 2510, 2509, 
         2552, 2553, 2523, 2522, 2203, 2472, 2722, 2721, 2720, 2385, 2508, 
         2197, 2458, 2459, 2328, 2859, 2861, 2860, 2157, 2433, 2151, 2653, 
         2652, 2904, 2903, 2280, 2901, 2902, 2650, 2651, 2150, 2431, 2145, 
         2640, 2639, 2899, 2898, 2267, 2893, 2894, 2637, 2638, 2144, 2428, 
         2430}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2165, 2674, 2295, 2819, 2404, 2821, 2297, 2820, 2296, 2419, 
         2246, 2586, 2301, 2585, 2300, 2825, 2190, 2678, 2677, 2826, 2827, 
         2676, 2950, 2675, 2248, 2839, 2840, 2836, 2838, 2837, 2193, 2172, 
         2549, 2550, 2504, 2505, 2846, 2847, 2843, 2845, 2844, 2422, 2182, 
         2706, 2705, 2852, 2851, 2856, 2326, 2545, 2235, 2544, 2234}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2292, 2813, 2293, 2814, 2291, 2914, 2366, 2671, 2672, 2673, 
         2438, 2439, 2368, 2624, 2367, 2625, 2442, 2920, 2369, 2626, 2370, 
         2627, 2299, 2831, 2832, 2828, 2830, 2829, 2444, 2833, 2834, 2587, 
         2971, 2251, 2753, 2252, 2923, 2924, 2688, 2689, 2175, 2449, 2179, 
         2700, 2699, 2927, 2926, 2314, 2850, 2316, 2701, 2702}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2143, 2947, 2357, 2266, 2892, 2359, 2890, 2358, 2891, 2429, 
         2360, 2895, 2897, 2896, 2268, 2785, 2786, 2782, 2784, 2783, 2432, 
         2787, 2742, 2743, 2741, 2238, 2905, 2906, 2657, 2658, 2156, 2434, 
         2159, 2660, 2659, 2804, 2803, 2241, 2500, 2573, 2970, 2186, 2574, 
         2869, 2614, 2615, 2535, 2537, 2973, 2536, 2632, 2631, 2937, 2387, 
         2723, 2724, 2207, 2474, 2206, 2524, 2525, 2512, 2513, 2199, 2572, 
         2261, 2263, 2961, 2224, 2265, 2225, 2962, 2264, 2388, 2464, 2465, 
         2482, 2481, 2412, 2413, 2356, 2623, 2330, 2871, 2331, 2616, 2262, 
         2427, 2417, 2418, 2344, 2958, 2208, 2435, 2282, 2255, 2956, 2200, 
         2711, 2712, 2661, 2662, 2160, 2187, 2575, 2576, 2547, 2242, 2501, 
         2577, 2805, 2806, 2663, 2664, 2161, 2870, 2799, 2800, 2798, 2802, 
         2801, 2499, 2498, 2240, 2546, 2656, 2155, 2185, 2281, 2795, 2797, 
         2796, 2237, 2780, 2781, 2647, 2648, 2649, 2184, 2278, 2778, 2279, 
         2779, 2196, 2710, 2858, 2857, 2401}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2163, 2665, 2229, 2740, 2324, 2853, 2855, 2854, 2667, 2666, 
         2287, 2807, 2243, 2810, 2290, 2808, 2289, 2809, 2188, 2670, 2669, 
         2668, 2812, 2811, 2244, 2817, 2818, 2816, 2294, 2189, 2164, 2873, 
         2874, 2872, 2332, 2453, 2452, 2612, 2583, 2584, 2580, 2582, 2581, 
         2420, 2683, 2682, 2681, 2304, 2835, 2325, 2540, 2231, 2538, 2230, 
         2539, 2256, 2377, 2968, 2376, 2469, 2209, 2959, 2389, 2253, 2543, 
         2233, 2541, 2232, 2542, 2257, 2554, 2181, 2954, 2380, 2379, 2636, 
         2391, 2633, 2635, 2634, 2466, 2455, 2516, 2515, 2514, 2339, 2886, 
         2349, 2885, 2348, 2931, 2383, 2929, 2382, 2930, 2393, 2942, 2394, 
         2943, 2341, 2880, 2340, 2972, 2717, 2718, 2719, 2565, 2566, 2564, 
         2568, 2567, 2217, 2562, 2563, 2561, 2571, 2570, 2708, 2194, 2709, 
         2569, 2506, 2527, 2526, 2216, 2559, 2560, 2558, 2758, 2258, 2715, 
         2716, 2622, 2354, 2621, 2355, 2468, 2467, 2211, 2960, 2392, 2346, 
         2620, 2347, 2884, 2345, 2881, 2883, 2882, 2454, 2202, 2713, 2714, 
         2703, 2704, 2180, 2451, 2692, 2691, 2690, 2375, 2925, 2308, 2374, 
         2953, 2176, 2447, 2171, 2952, 2373, 2303, 2372, 2951, 2170, 2443, 
         2167, 2949, 2371, 2245, 2748, 2749, 2579, 2578, 2815, 2441, 2916, 
         2917, 2915, 2919, 2918, 2288, 2912, 2913, 2910, 2365, 2911, 2437, 
         2908, 2363, 2907, 2364, 2909, 2284, 2436, 2162, 2948, 2362, 2283, 
         2286, 2965, 2285}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Epilog->{{
     PointSize[0.04], 
     RGBColor[1, 0, 0], {
      PointBox[{-0.8, -0.6778957129244416}], 
      PointBox[{-0.6200000000000001, -0.3531795967671845}], 
      PointBox[{-0.4580000000000001, -0.07894799282493775}], 
      PointBox[{-0.31220000000000003`, 0.12113552694504906`}], 
      PointBox[{-0.18098000000000003`, 0.24357858061998103`}], 
      PointBox[{-0.06288200000000004, 0.2963800521257964}], 
      PointBox[{0.04340619999999998, 0.29261629897930774`}], 
      PointBox[{0.13906558000000002`, 0.24639009924822125`}], 
      PointBox[{0.22515902200000004`, 0.17063263443660714`}], 
      PointBox[{0.3499057621544118, 0.018518901242232877`}], 
      PointBox[{0.5885565636880948, -0.3819790474514864}], 
      PointBox[{1., -1.376345614207783}], 
      PointBox[{1., -1.4161468365471424`}]}}, {
     RGBColor[0, 1, 0], {
      PointBox[{-1., -1.}], 
      PointBox[{0.9999999999999996, 2.2210428707555843`}], 
      PointBox[{-0.8, -0.6778957129244416}], 
      PointBox[{0.9999999999999998, 2.569265448648129}], 
      PointBox[{-0.6200000000000001, -0.3531795967671845}], 
      PointBox[{1.0000000000000002`, 2.3891364426552832`}], 
      PointBox[{-0.4580000000000001, -0.07894799282493775}], 
      PointBox[{0.9999999999999999, 1.9218872048749303`}], 
      PointBox[{-0.31220000000000003`, 0.12113552694504906`}], 
      PointBox[{1., 1.3455660636943687`}], 
      PointBox[{-0.18098000000000003`, 0.24357858061998103`}], 
      PointBox[{0.9999999999999999, 0.7715932956781346}], 
      PointBox[{-0.06288200000000004, 0.2963800521257964}], 
      PointBox[{1., 0.2587425206609103}], 
      PointBox[{0.04340619999999998, 0.29261629897930774`}], 
      PointBox[{1.0000000000000004`, -0.16964569833155713`}], 
      PointBox[{0.13906558000000002`, 0.24639009924822125`}], 
      PointBox[{1., -0.5111845488679199}], 
      PointBox[{0.22515902200000004`, 0.17063263443660714`}], 
      PointBox[{1., -0.7741932876649869}], 
      PointBox[{0.3499057621544118, 0.018518901242232877`}], 
      PointBox[{0.9999999999999999, -1.072453377256558}], 
      PointBox[{0.5885565636880948, -0.3819790474514864}], 
      PointBox[{1., -1.376345614207783}], 
      PointBox[{1., -1.4161468365471424`}]}}},
  Frame->True,
  PlotRange->{{-1, 1}, {-2, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->244971889]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8701688],

Cell["Find a root using 100-digit precision arithmetic:", "ExampleText",
 CellID->154413102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"x", "^", "2"}], "]"}], "-", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395562938],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "0.801070765209218366216867854086565585542152944970973755111056684779040914\
5678013209735696971621054444230752988149312`100."}], "}"}]], "Output",
 ImageSize->{578, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387074459]
}, Open  ]],

Cell["\<\
Find the root starting with machine precision and adaptively working up to \
precision 100:\
\>", "ExampleText",
 CellID->377300582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"prec", "=", "MachinePrecision"}], "}"}], ",", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"x", "^", "2"}], "]"}], "-", "x"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1.0"}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "100"}], ",", 
     RowBox[{"StepMonitor", "\[RuleDelayed]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Precision", "[", "x", "]"}], "\[NotEqual]", "prec"}], ",", 
        RowBox[{
         RowBox[{"prec", "=", 
          RowBox[{"Precision", "[", "x", "]"}]}], ";", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<Increased precision to \>\"", ",", "prec", ",", 
           "\"\< at x = \>\"", ",", "x"}], "]"}], ";"}]}], "]"}]}]}], "]"}]}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1085713],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Increased precision to \"\>", "\[InvisibleSpace]", 
   "25.075257498915995`", "\[InvisibleSpace]", "\<\" at x = \"\>", 
   "\[InvisibleSpace]", 
   "0.80107076520930349497172655477694735993`25.075257498915995"}],
  SequenceForm[
  "Increased precision to ", 25.075257498915995`, " at x = ", 
   0.80107076520930349497172655`25.075257498915995],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->15406366],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Increased precision to \"\>", "\[InvisibleSpace]", 
   "50.15051499783199`", "\[InvisibleSpace]", "\<\" at x = \"\>", 
   "\[InvisibleSpace]", 
   "0.801070765209218366216867860104169246449814460829029839602555358317`50.\
15051499783199"}],
  SequenceForm[
  "Increased precision to ", 50.15051499783199, " at x = ", 
   0.80107076520921836621686786010416924644981446082903`50.15051499783199],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->247331292],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Increased precision to \"\>", "\[InvisibleSpace]", "100.`", 
   "\[InvisibleSpace]", "\<\" at x = \"\>", "\[InvisibleSpace]", 
   "0.801070765209218366216867854086565585542152944970973785180000840737687160\
7365151432799043919751751341927025380985114`100."}],
  SequenceForm[
  "Increased precision to ", 100., " at x = ", 
   0.8010707652092183662168678540865655855421529449709737851800008407376871607\
3651514327990439197517513419`100.],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->112739794]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "0.801070765209218366216867854086565585542152944970973755111056684779040914\
5678013209735696971621054444230752979310096`100."}], "}"}]], "Output",
 ImageSize->{578, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->508612562]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->212749006],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Computing Inverse Functions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25985482],

Cell[TextData[{
 "For an isomorphism ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", the inverse ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"f", " "}], 
      RowBox[{"-", "1"}]], 
     RowBox[{"(", "t", ")"}]}]}], TraditionalForm]], "InlineMath"],
 " is the root of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", " ", 
      RowBox[{"(", "s", ")"}]}], "-", "t"}], "\[Equal]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->125456646],

Cell[BoxData[
 RowBox[{
  RowBox[{"inv", "[", 
   RowBox[{"f_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "t", "}"}], ",", 
    RowBox[{"s", "/.", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"f", "-", "t"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "1"}], "}"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238310877],

Cell["An approximate inverse for the exponential function:", "ExampleText",
 CellID->20519307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"einv", "=", 
  RowBox[{"inv", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151731003],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "t$", "}"}], ",", 
   RowBox[{"x", "/.", "\[InvisibleSpace]", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "-", "t$"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1"}], "}"}]}], "]"}]}]}], "]"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->499146064]
}, Open  ]],

Cell[TextData[{
 "It is very close to the built-in ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->106398918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"einv", "[", "x", "]"}], "-", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32404523],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mE2IHUUQxyczb94mapIVMSaegiHxonhTicagoiIi4kEExcO6SHYPGo3r
RS8qohe96MWAmIMf4MchYogIEcSAGBADYkBUkAgSDwbB4GFBeP6qq2emp7vn
zce+9fHevOmeqv+/qru6qnvuXVhZeuzxhZXlxYWddx1aeHJpefHpnXcePERX
tiFJkmP8HtqecD/hzvyOTSb8h9fbuKYIZNLKRFJ6E3O7xX2W6zP9iMTWiKbc
pi3P5rmRrjTyzMgnt8p1VD1JktyzbnMgMfbQLgkkRkFPiBLKzHu4WSCRNtjc
zaJRRzvW19Y5T/PiOJszA1sG2SzzKPN8aUdLr/Pktg6wvOCMW5x19KXr2LZb
3GecQstyD3+WcRG1PTv93e+JfsbWqmJ1+2O/2ekvrE8dvXmvnZWsBWqSfXb8
xztuf+vMD38kT0VtUn8vXFh95OEPTn3z2+KjH6vE+fP/8M812d+sl7/x+tcf
ffg9t3qTXGvQvjjxCzjowqwjvrr6L27z/fmnP9VLLKIpdu2K4pvVPYc4SNoF
nqIm1xhMPHvwgffPnft7/77DRjrDiyNvf0tnkh584tMkQ3x56ejJr37V+diE
FapELwJccfqTo2fQs9mFx1hVzSm6IPIt7YbvhedPCKbRMLa8VERJ5QViJYrj
1chr+89NeyPt++97B7cgpgMsemiaWJ3jHhfK+RF3I3EcZRZdnMX35579nCuY
pW5Vj3jGoAT1JGqr395UtuEhnggKmTFNc+krL3+ZZIy5XQJG4yK4mAn1ELdh
ZxZ0GXEzjo7rNrmMdSTccUppGI2cGGSeuH3t1ZPiTbR65EQEUnyJVBkMMxKy
kjFaR+lyT2+uiBP8K3Gc53nU3ivMI9ysTapYq3g8wUjiNdlu2tgFvlikdrO8
aEjUXV/iyxo30rnOZAyXsLV6V5o2jVokwqhdDm5g99zZs39hgOLjOUqCuLFg
sIg7PAaND7SsBTdEGcSDFCEjDriEyO4oknrJyKwZqRwsB0lGc0cHBF0VUBJ5
cntjiy0sAJQlN8aRCE/GdjrSCKQ9UW3WiyaCLtrjUpsPmZeg2xv4H5fWwdjb
yKG+so7ee/e09O0OEPRZG4Im9DiC+toTIXcRZD3d1DDjjXqsw3vuPmL1bJq3
HzMHtbof7M8n1d5c+Lb1t1tDzfL7Odnfx48Di3yNy4o2C6mwIJFJJxB1ee2p
82ugNPD7WTXvzm/bmu/gJ75kfq6us5MVMWym3mdF3mxmZcAlY8VZTQgEp7d2
z8eWux5D/ghGLRuVlnFzc9SqcGfrS/i7y7Z67lpCeaxZQpjQpZbYbaf5uOfU
4n8UWRd9uCX6XW5dEMq9qwNusc6b8NiM1PGqUZxU++uu1tF7+M1TDloQKf48
lGikSB8NAlKvol1lrRnZf3/HV+KgKpWrCcfNfYW8pCBX/pmV42zeKvkmHl+P
Gs1w9tdjS8FGor+eZs0OftnKKStqXysLQ1Vpsflhx9pXi1GQI8hatXx/ZONc
SjNDzJOVHq2tHkUsq3HZ3ZByFRlMr+7q6FmDerGuY+3xeW3VUd5pZ7iBVQcK
wr3i0zNmA1/8beHM6w1myNkhblOdKXwHM7Na41tBLmXbWFixnpUGMnkPUDJr
yrTMveuMPVWVaJwkZUfhoHWvMj6WJlkXq3uN8bFIbSQ4i9WnwtRQNA1PyVs1
aXYOcopryY1sugstOc/eMl3ansZci+S2hcPXYjTqWjU/fGnmYQDHMC0S/QAt
YriHPzXprFhLs6knPhfp1eHytIZl2CgvR5carz33x3n9eF9DRbGzHOd185i7
UgdWE59L38g2VM3/6fTi22Rf6cXHPXznPrN6YtdNgx3rUUfsKnJ3aRXjkPNK
Dc2+nR5UR9qxutcRH8u+u+hZR6aiBPmqVbqdgzRk39t20zowRYp9iX1zdyCw
N6XALUV1X5zSm2z4DwILeiY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->55179085]
}, Open  ]],

Cell["A \"black-box\" function giving the period of an oscillation:", \
"ExampleText",
 CellID->409862437],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", "?", "NumberQ"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", "=", "0"}], "}"}], ",", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
            RowBox[{"x", "[", "t", "]"}], "+", 
            RowBox[{
             RowBox[{"x", "[", "t", "]"}], "^", "3"}]}], "\[Equal]", "0"}], 
          ",", 
          RowBox[{
           RowBox[{"x", "[", "0", "]"}], "\[Equal]", "a"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
        ",", "x", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "\[Infinity]"}], "}"}], ",", 
        RowBox[{"Method", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<EventLocator\>\"", ",", 
           RowBox[{"\"\<Event\>\"", "\[Rule]", 
            RowBox[{"x", "[", "t", "]"}]}], ",", 
           RowBox[{"\"\<EventAction\>\"", "\[RuleDelayed]", 
            RowBox[{"Throw", "[", 
             RowBox[{
              RowBox[{"p", "=", "t"}], ",", "\"\<StopIntegration\>\""}], 
             "]"}]}]}], "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"4", "p"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->171819644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->64565450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmH1oV2UUx6/7/TZd9EIWNipq5dy0F3qh9zCR4UpLzEpNhslci83S2dys
1GhaaS9KU5NmvoYlaP2xSIzAIBIiIRIiISoIg7A/kiDpj0Fw+5zzPM9+996d
7XcFZd49z+/5nnO+5/U+v81u6W5vW9bS3dHaUvtgV8uK9o7WlbVNnV18VBgT
RdFh/vfURKxjVvr/cBzzO/m8lWeBo3p+F/1v2U+WU1nE+i8qKPq2zKf1iT3P
aErmfFIuLQ2Zfdb2RM+taEpn0WKzwnuS5FaZS7p+BG1OelwOdFQs7YdHpG5U
fcHaZP+7YdRsZKX3yaPq7NnB49/+vnfPdz3dRx6eufeXn/8qoUXnbtlVnzr1
9+dHftq44atFzQdBgUUCOaR9nLPa++UxDnUfH/phzeovEEIUBahBWbUp867K
nPzxz48+POFkWpd8sm3rN8e+/g1DF5kyfSqDSmdnRuOujvaBHf3HncylKiMM
BySpw6QrM/uqMufnij/f+s63fc31WCJOxPh07pz9LkVnzvzr8noOXCrM/GS7
tdx+rD5I3ZdHf4ULNUA+qQcqKarJZXG9asAD/HBVtK73KGup1dohCantXg3R
6dP/UDudyz9z3lM4dabetQk0dblg3gFK88T3fzSY6JcUDYskGiduMNGrFD04
+B88aS6YOPTNJrpbw49pFyCetKLO5pJvXYEtjYpx3EM1Bm43NXaqRkKOcdDI
IBndaWKfUyzn1AxECa5Yv8fELg1MQaGXPEpl3Zdi2q4Y5zuRgik8oqmmvjbF
kknnFZ5LXUwzsa2B5+ZNx+CJhNiebmJbFMsUQSN6Px04CZ+o0cQulkcRuxQX
Mw3WTSl/ntJz7KILf6inh/S8EOZ4QlezYuHl7KJrlsNalZ7YLwxylImTeySX
3IIQazIBd2pT/Jytsv41EYW3n4jNVzvkAyOkm8DPUVBWb9buEyFGNC+ph+jc
XPweUznM4BexYzA9PmLsVGMBbs6RaF4qC4+qJjJKRTsG881squ9FFxEsUspP
mjiNbxFCgIgEAgtN3KygDxDOQ6DZxM3UPcfow3S0KMXenTpKYFxNDdPRFKqA
nnGcFpu4GbqnSIgUveiqfRiqMTCnFvkhCUtSnBoTjNEVPW1qmR6y4pm3mahp
wRZ5JjssnjFxD+jeeSg5bjdROisK5Ab/eEYdKd5Tg/fokHfA0lwVfL/uoUco
pEeezSV1r+7BMxuE7zKVGrqNJpA6LwvwgRUjIloeux5M30Ble7cimSeuIdys
HtatSd136Z7uQ0Lm+IqyEjrpCxS/j9Hzuby9I0QWb0WqKxV3d8oo9RFcaeZO
30cFhjNTWpbdJsrdw4EAlGWPidI3YAFzGJXlKhN1S0BBXJYvpFhnT180ddwU
8uyA0epRUO72IUsbdWPG4poUn+zpWlPHlFCtFJ0sXzZR+j2BCL5injb4096U
/fDpOlNmUsixz55DWdO6LtQKrshyvUNmUNmKm6h7+oMKk+WruaSuj301IyWV
99qIUrK9LvbTg9oX9OtxuW7RW6T0l++WDSkJeWYlro19D/NKkFvIxjj0V4Ux
G64JaPRL/76Ryog7dZNDbj9vmpm5OvYVCkqmxlsm6qqAIlJyi3t7FBR1zFiX
pY26Mk5X6qYUa3daqtDNpo4aX23vmKdX+NM+83SC7lGPEVn2pexPyNTfFlPH
5XE8NLNkudVEXab70szaZqLGe7bbUzzGhyj5SbbdlL0kkReZL++VrcmLQ1Vw
35H3Sb+Dpv66kK0z/UYtb3SqUu4FO3LIXBj7jnSXm+j9EWRE5ALZ+ruQe0Xs
jEeaD/oXgYK7X8l9aHfK49joKf2mKHdFsuDI7IlH66rKgHffHUjyvlRmFF9J
R6HPfQeS3v6glJ9qQISJH4qMDPKlArLoEdz+Eq4KHIRoPCrRfZk+kM4yTS3L
g2U+FVaH8kh6D8t9WtIXjfkfU6xdsw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->187581259]
}, Open  ]],

Cell["Plot its inverse:", "ExampleText",
 CellID->489526707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"finv", "=", 
  RowBox[{"inv", "[", 
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], ",", "a"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->851945494],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "t$", "}"}], ",", 
   RowBox[{"a", "/.", "\[InvisibleSpace]", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], "-", "t$"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "1"}], "}"}]}], "]"}]}]}], "]"}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->63398726]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"finv", "[", "s", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "3", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->63001270],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWGlsVUUUvn33tkWlLaikKBrABpWgEhU3CEoMFPcVQUWUUtRWbMHygFBR
q5JiWJTNBRcQt8TlB0aCMcHESGIkMZIYSYyaGEwM/pCYQPzRxOT6nXNm7rsz
c/panon40t53Z+abb75z5syZmXdzS7HtwY6WYntry5iZXS1L2tpbl45pXtyF
qrgqiqLd+F80MsJ7ijf+352m+M4/m/CM0RRTiV64NooK+B9O79VSJx9uwXfW
WuO1GrYGhZVeC/205Ucs9NOP66JzvZZqr1zvlblXUipH0TAPUeOVG/yxA4bh
A2ioC3okQQ2zBlpOG4B5KB6JyldvWmr/R9bY2RyiWJGf+WrVmjzCZziRVp3q
lRNj5TDzHVrTYFpqKkLGVkly5Mhfy4p79n35i6mhRV5F36pOP5b8NdUwKBXl
vB56zEf4XmeNQ7Lyp3t+mDf3/f1f/1ryd2iTzQuxiW7rF20OtFn3PZ7PMzVe
OYrX9H5x7FhfamKqlHf8Ebdy+eNdB8WA6GQVtZnF/fTjH+1tuzas3wfmU1Tc
Rsahecvmr1oXfHTw+9/rVNwLuVE//OA78XeA2sBsB779DVQYFWHDCI75t22k
B70KXrnuX7b/13g/RwyE98u1dg5QBfdimakIP7oDPzZ65Q6G9vX9jQmbc9d7
775zAO/RCLVvL2uQZYFQgJhGFbeacZCIGUbEHj589IwMRzH7rI0AxN3j3Z8h
AEepPD2MQ7gt7vwEf3g5W8U9mZo4BhkoQTxaxa1iHOQAB2kQOFbFdVscxMMn
wDU5+le67XDIOJVneYA7T8UVA9x4FdcV4CaouCUB7kIV1xngJjp2dgTtF6s8
jwS4S1VcW4C7TMU9FOCuUHELA9xVjv7WoH2KyjOfcUhEGW6qirvf4hD8gruG
cSZlmU+wku0ulqu7jx7VGRPWHq26aUzj9w/PiImHuFdlu/Y42AhwN7NgUe/Y
/o0kcGKZXqGm2Tk2aMKTcldzhWyzUidLGbbrKmS7kxHYp0AleewGAcalebR7
rz9zt6cmt6Gv7F43qbFyK+Ow9yLRIN0gCG9xYpNLlAOR2HBsQvK6TeW5MS3l
LEDR4Q4Vd70bmxA4S8XNZBw8mc3ybBXXnPORuHuOo3+G9QNIxA/3qDwchZSb
IR4mHDr051wVN83qBxlcBjvnqbirrX7sVBgaAh9QcbyCk8/3/gz9217ZD/3z
VRxnhASyoO/pnr0QsMCxczK3oztIMB50LVR5ruQyxgMI0iSHBajLmQ0bGbYp
Ge1hFTfJjgpvAEodVBzn2RiJCFbCFdEiR/sl1jZQyMnxUZVlovWp2IjROlXc
RVxGTBsbeZ8pk/24rKyhC6x1EIXYR3A/lmor2T/h++0Tcnrgg2jpoFmoON5G
HCYCKvBSrEjF+XYOoALzL7t+gLJ3AN8X/IsBrW9IkDla0W//cuVxVgUWD534
V6Z+RrO3E79nk/VDpqBbnf1zrLfNCKucWBvrzinonlBZRntz9pSK4nMeRSSy
mbD1qLizuIwIhya6cTyjovh0SfcSoICV82em/EyrHHGA5YZBV6ssI7kstyWa
514V1WjHAorGWqOiRlj7sjGfU3Gn5+yjMdc6yqUV9WasdSqH/CIAR2Is2jXX
qygpw9HgIk8+r6LkBo0EIddAufEFqHqrCzkVjHJ/DFB1OV100tjk2Ca/wqAe
mwbp2aJy8L02xuqBavrlYauKOik3c3hGLzIqGeRZTW5uYEdvsualNJ/1coWy
Zw65ncES2EPWvpxqq7z/0xmfR+CsbVwd/AI54PiJ589XK+SRHogjzC15/DUD
C/qUZSnYeZNrXfR66mcr5/xVm/XER3rRPL5Rmu3SL71oQHACtN2JJ55/9KMV
sKPUj1QiGUnDm270wFOE3unWwoX06tUau3Y6Y74l5lT9A2z+vuM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->469336812]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Solving Boundary Value Problems",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->132272328],

Cell[TextData[{
 "Solve a boundary value problem ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]\[Prime]",
      MultilineFunction->None], "+", 
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "+", 
     SuperscriptBox["x", "3"]}], "\[LongEqual]", 
    RowBox[{"sin", "(", "t", ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "(", "0", ")"}], "\[LongEqual]", 
    RowBox[{"x", "(", "1", ")"}], "\[LongEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " using a shooting method:"
}], "ExampleText",
 CellID->1271033],

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "[", 
   RowBox[{"s_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{"First", "[", 
   RowBox[{
    RowBox[{"x", "[", "1", "]"}], "/.", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
          RowBox[{
           RowBox[{"x", "'"}], "[", "t", "]"}], "+", 
          RowBox[{
           RowBox[{"x", "[", "t", "]"}], "^", "3"}]}], "\[Equal]", 
         RowBox[{"Sin", "[", 
          RowBox[{"4", " ", "t"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "s"}]}], "}"}], 
      ",", "x", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->496031650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x1", "[", "s", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109542164],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270737029]
}, Open  ]],

Cell["\<\
Use points on either side of the root to give bracketing starting values:\
\>", "ExampleText",
 CellID->5440138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"x1", "[", "s", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->76994692],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"s", "\[Rule]", 
   RowBox[{"-", "0.3443234211042515`"}]}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32786902]
}, Open  ]],

Cell["Plot the solution", "ExampleText",
 CellID->225317043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}], "+", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], "^", "3"}]}], "\[Equal]", 
        RowBox[{"Sin", "[", 
         RowBox[{"4", "t"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "s"}]}], "}"}], "/.",
      "%"}], ",", "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->226828258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->315753884]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "/.", "sol"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->17063451],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->236199083]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75606875],

Cell[TextData[{
 "Solve the boundary-value problem ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Epsilon]", " ", 
      RowBox[{"x", "''"}]}], " ", "+", " ", "x", " ", "+", " ", 
     SuperscriptBox["x", "3"]}], "\[LongEqual]", "1", " "}], 
   TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "(", "0", ")"}], "\[LongEqual]", 
    RowBox[{"x", "(", "1", ")"}], "\[LongEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " collocation points:"
}], "ExampleText",
 CellID->9884090],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "100"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->815199894],

Cell[TextData[{
 "Consider as a first order system ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], "'"}], " ", "=", " ", 
    RowBox[{"f", "(", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->419867967],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"u_", ",", "v_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "u", "-", 
        RowBox[{"u", "^", "3"}]}], ")"}], "/", "\[Epsilon]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->660598617],

Cell["Equations for collocation using the trapezoidal rule:", "ExampleText",
 CellID->137640289],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["u", "0"], "\[Equal]", "0"}], ",", 
        RowBox[{
         SubscriptBox["u", "n"], "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Thread", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["u", "i"], ",", 
            SubscriptBox["v", "i"]}], "}"}], "\[Equal]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox["u", 
              RowBox[{"i", "-", "1"}]], ",", 
             SubscriptBox["v", 
              RowBox[{"i", "-", "1"}]]}], "}"}], "+", 
           RowBox[{
            FractionBox["h", "2"], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["u", 
                  RowBox[{"i", "-", "1"}]], ",", 
                 SubscriptBox["v", 
                  RowBox[{"i", "-", "1"}]]}], "}"}], "]"}], "+", 
              RowBox[{"f", "[", 
               RowBox[{"{", 
                RowBox[{
                 SubscriptBox["u", "i"], ",", 
                 SubscriptBox["v", "i"]}], "}"}], "]"}]}], ")"}]}]}]}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->423352582],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " as a starting value:"
}], "ExampleText",
 CellID->375466357],

Cell[BoxData[
 RowBox[{
  RowBox[{"sv", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["u", "i"], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["v", "i"], ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->696006544],

Cell[TextData[{
 "Find a solution for a particular value of ",
 Cell[BoxData[
  StyleBox["\[Epsilon]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->120975745],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"froot", "=", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"eqns", "/.", 
      RowBox[{"\[Epsilon]", "\[Rule]", "0.01"}]}], ",", "sv"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["u", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "/.", "froot"}]}], 
  ";"}], "\n", 
 RowBox[{"ListLinePlot", "[", "sol", "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->75050124],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdlWlIFHEYxgczFDssK9QSNcsuTCyvvB/vW/dy1RDMVCjSREuKPsgURmj2
ITISMqwozc3Y6INhuDlkltihllem2eFarGGtR36wpMJ3YP7zh2H58cz+r/d5
n9l8sEiVb8FxXP6/5//v0vgZxrEDOHLZ/N7mYdsSWuPr1MJ12/oO4jVQc3a1
12JeE69HS99Jk0/DG2IHrHq8uHFe3U/shIH23LxR10FiV4zoci4arIaI3ZBT
2eN4aLnIW1Gj368yOorvb4NlvbbzeJw43w6ca1H8SLkirrcLM99sLYqcxf14
YMXQH81cqbhfT/hXnNIOX20m9sKCyfzx5q5sOvceeHB9Hlc3PyLeC0Nrofmt
1Qtib4wOB6+0X+wj9sFgiGGf3dgIsS+Cp+uelJR/JvbDlU2HDa26CWJ/vHTS
I6/LRLwPvjPWenPHFHEAGqs8Z7NDzMSBcM76/cbr0zRxELzrzq6+GzhLHIzV
LVH3Sv3niEPQe2na9KFT5FBwTdsrzEaRw9BcP1UyWCUykNv00MG9nebjAb+E
0KD56hnSw9GtyHFyX0fr8+GoXeCyLZWiTyJwTNhdU/H0O+kR4ExlORcefCM9
Eo2xWWs9q8ZJj0SxV8fODQUfSY/C/Vu97+K7h0iPgv+X8YICl17So1EYXtaq
fdZOejRKy/Pt1/GNpMegrGS20xUNS/XkY1ApVJu8dALVNxZG4+fTY2u7SI+F
m1/e8/JfPaTH4bZ3hSHAro/0OIzvtz0RpBogPR76yWc3LPTkPz4eEc1H67q3
iP5MkOkJMDL/T5TNnyhbP0m2vyScZ/afjDPM+ZJRzJw/BUeY+0mR3V+q7H5T
ZfevwB1pfaBg68cr2PoKCln9law/oGT9wytZfwlKmf9UrD+hYv3Lq1h/CyqZ
/9VwkfYH1NBJ+4dXw0/aX4Iar5j+06BG2p/QsP3La9j+FjSy/k9DmzQfkAZP
aX7waTg/KckXIQ2+TP5oYSPNJ2jZ/OK1bL4JWixj8i+dzUek44A0P/l0Nl+F
dPQz+ZvB5jMy2PzmM9h8FzIwweR/Jvt9QCY4Gn8BA737hQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 101.}, {-0.3771857315976811, 1.3686385495773266`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->277446975]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->437197510],

Cell[TextData[{
 "For a polynomial system of equations, ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " finds all solutions and ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " finds one:"
}], "ExampleText",
 CellID->379053703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"polysys", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"RandomInteger", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "9"}], ",", "9"}], "}"}], ",", "5"}], "]"}], 
       RowBox[{
        RowBox[{"RandomChoice", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "5"}], "]"}], "^", 
        RowBox[{"RandomInteger", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}], ",", "5"}], "]"}]}]}], "]"}], 
     "\[Equal]", "0"}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153894183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"5", " ", "x"}], "-", 
     RowBox[{"6", " ", "z"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "7"}], "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["y", "2"]}], "-", 
     RowBox[{"7", " ", 
      SuperscriptBox["z", "2"]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{"10", "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"9", " ", "z"}], "-", 
     RowBox[{"9", " ", 
      SuperscriptBox["z", "3"]}]}], "\[Equal]", "0"}]}], "}"}]], "Output",
 ImageSize->{393, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->477832524]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " will find a single solution using an iterative method:"
}], "ExampleText",
 CellID->431689540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"polysys", ",", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"RandomComplex", "[", 
       RowBox[{
        RowBox[{"1", "+", "I"}], ",", "3"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202213805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "0.4488388150294671`"}], "+", 
     RowBox[{"1.0301560673611714`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "0.8668817950625549`"}], "+", 
     RowBox[{"0.8385857527938984`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{"z", "\[Rule]", 
    RowBox[{
     RowBox[{"-", "0.37403234585788925`"}], "+", 
     RowBox[{"0.8584633894676427`", " ", "\[ImaginaryI]"}]}]}]}], 
  "}"}]], "Output",
 ImageSize->{533, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->523271533]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " will find all solutions using a direct method:"
}], "ExampleText",
 CellID->100625776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{"polysys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->651551109],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{543, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->359733379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44115266],

Cell[TextData[{
 "For equations involving parameters or exact solutions use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->660412948],

Cell[BoxData[
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"2", "x"}], "+", "a"}], "]"}]}], "+", "3"}], "\[Equal]", 
    "0"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99356243],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " will return some solutions:"
}], "ExampleText",
 CellID->472535283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eq", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->262203851],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->455094050],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->417430873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"ProductLog", "[", 
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "a"}]]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{189, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->964443295]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " will enumerate all solutions:"
}], "ExampleText",
 CellID->77310316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eq", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->384174785],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "a"], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], ",", 
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "a"}]]}]}], "]"}]}]}]}]], "Output",
 ImageSize->{372, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79270137]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " will find particular instances:"
}], "ExampleText",
 CellID->488158405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{"eq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->73903294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["92", "5"], "-", 
       FractionBox[
        RowBox[{"191", " ", "\[ImaginaryI]"}], "10"]}]}], ",", 
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       FractionBox["1", "5"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"191", "+", 
           RowBox[{"184", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
         RowBox[{"1780", " ", "\[Pi]"}], "-", 
         RowBox[{"5", " ", "\[ImaginaryI]", " ", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["5520", "70337"]}], "-", 
            FractionBox[
             RowBox[{"5730", " ", "\[ImaginaryI]"}], "70337"]}], "]"}]}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"43", "-", 
       FractionBox[
        RowBox[{"411", " ", "\[ImaginaryI]"}], "10"]}]}], ",", 
     RowBox[{"a", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "5"]}], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "411"}], "-", 
           RowBox[{"430", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
         RowBox[{"1200", " ", "\[Pi]"}], "+", 
         RowBox[{"5", " ", "\[ImaginaryI]", " ", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["12900", "353821"]}], "-", 
            FractionBox[
             RowBox[{"12330", " ", "\[ImaginaryI]"}], "353821"]}], "]"}]}]}], 
        ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{528, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->427338722]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4241],

Cell["\<\
If a function is complex, variables are allowed to have complex values: \
\>", "ExampleText",
 CellID->678329697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "+", 
     RowBox[{"I", " ", "t"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->430899202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", "\[Rule]", 
   RowBox[{"9.920598770752625`*^-17", "+", 
    RowBox[{"2.5`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{169, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->512336426]
}, Open  ]],

Cell["\<\
If the function is kept real, variables are also taken to be real:\
\>", "ExampleText",
 CellID->381422181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Zeta", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "+", 
      RowBox[{"I", " ", "t"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24119152],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", "\[Rule]", "14.134725141734691`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->437736259]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29933],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMinimum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMinimum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootIntervals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootIntervals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IsolatingInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IsolatingInterval"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4020]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26295],

Cell[TextData[ButtonBox["Numerical Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalMathematics-BasicOperations"]], "Tutorials",
 CellID->123709578],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "Tutorials",
 CellID->5444],

Cell[TextData[ButtonBox["Numerical Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalEquationSolving"]], "Tutorials",
 CellID->4221],

Cell[TextData[ButtonBox["Numerical Root Finding",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalRootFinding"]], "Tutorials",
 CellID->15972],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "Tutorials",
 CellID->123070281]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31082],

Cell[TextData[{
 ButtonBox["Demonstrations with FindRoot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FindRoot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#2118"], None}]], "RelatedLinks",
 CellID->20443],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FindRoot"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->632422093],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "MoreAbout",
 CellID->20530193],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->632602245],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->338525158]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindRoot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 7.1092502}", "context" -> "System`", 
    "keywords" -> {
     "Brent method", "common roots of equations", "iterative root finding", 
      "Newton's method", "Newton-Raphson method", "numerical root finding", 
      "secant method", "solve algebraic equations", 
      "solving systems of equations", 
      "transcendental equations numerical solving", 
      "transcendental roots numerical solving"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FindRoot[f, {x, x_0}] searches for a numerical root of f, starting from \
the point x = x_0. FindRoot[lhs == rhs, {x, x_0}] searches for a numerical \
solution to the equation lhs == rhs. FindRoot[{f_1, f_2, ...}, {{x, x_0}, {y, \
y_0}, ...}] searches for a simultaneous numerical root of all the f_i. \
FindRoot[{eqn_1, eqn_2, ...}, {{x, x_0}, {y, y_0}, ...}] searches for a \
numerical solution to the simultaneous equations eqn_i. ", 
    "synonyms" -> {"find root"}, "title" -> "FindRoot", "type" -> "Symbol", 
    "uri" -> "ref/FindRoot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18073, 597, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->16010467]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 271877, 6510}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3337, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3960, 102, 45, 1, 70, "ObjectName",
 CellID->5141],
Cell[4008, 105, 4069, 133, 70, "Usage",
 CellID->587]
}, Open  ]],
Cell[CellGroupData[{
Cell[8114, 243, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8592, 260, 175, 4, 70, "Notes",
 CellID->29172],
Cell[8770, 266, 509, 20, 70, "Notes",
 CellID->18571],
Cell[9282, 288, 380, 11, 70, "Notes",
 CellID->5826],
Cell[9665, 301, 468, 17, 70, "Notes",
 CellID->11798],
Cell[10136, 320, 899, 34, 70, "Notes",
 CellID->14944],
Cell[11038, 356, 980, 37, 70, "Notes",
 CellID->22045],
Cell[12021, 395, 525, 17, 70, "Notes",
 CellID->23240],
Cell[12549, 414, 319, 9, 70, "Notes",
 CellID->14357],
Cell[12871, 425, 387, 14, 70, "Notes",
 CellID->17774],
Cell[13261, 441, 69, 1, 70, "Notes",
 CellID->12477],
Cell[13333, 444, 2372, 63, 70, "3ColumnTableMod",
 CellID->13018],
Cell[15708, 509, 519, 20, 70, "Notes",
 CellID->3703],
Cell[16230, 531, 339, 9, 70, "Notes",
 CellID->9011],
Cell[16572, 542, 295, 9, 70, "Notes",
 CellID->17911],
Cell[16870, 553, 501, 17, 70, "Notes",
 CellID->29615],
Cell[17374, 572, 662, 20, 70, "Notes",
 CellID->15787]
}, Closed]],
Cell[CellGroupData[{
Cell[18073, 597, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->16010467],
Cell[CellGroupData[{
Cell[18457, 611, 148, 5, 70, "ExampleSection",
 CellID->821922204],
Cell[18608, 618, 332, 13, 70, "ExampleText",
 CellID->832],
Cell[CellGroupData[{
Cell[18965, 635, 259, 9, 28, "Input",
 CellID->6133],
Cell[19227, 646, 247, 8, 36, "Output",
 CellID->228127870]
}, Open  ]],
Cell[19489, 657, 121, 3, 70, "ExampleDelimiter",
 CellID->29108],
Cell[19613, 662, 312, 13, 70, "ExampleText",
 CellID->24146],
Cell[CellGroupData[{
Cell[19950, 679, 229, 8, 70, "Input",
 CellID->21927],
Cell[20182, 689, 227, 7, 36, "Output",
 CellID->952218672]
}, Open  ]],
Cell[20424, 699, 125, 3, 70, "ExampleDelimiter",
 CellID->467321172],
Cell[20552, 704, 81, 1, 70, "ExampleText",
 CellID->611245419],
Cell[CellGroupData[{
Cell[20658, 709, 485, 17, 70, "Input",
 CellID->10539561],
Cell[21146, 728, 303, 9, 36, "Output",
 CellID->520524528]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21498, 743, 220, 7, 70, "ExampleSection",
 CellID->624333486],
Cell[21721, 752, 101, 2, 70, "ExampleText",
 CellID->14495046],
Cell[CellGroupData[{
Cell[21847, 758, 458, 16, 70, "Input",
 CellID->155930699],
Cell[22308, 776, 299, 9, 36, "Output",
 CellID->97721266]
}, Open  ]],
Cell[22622, 788, 125, 3, 70, "ExampleDelimiter",
 CellID->578132984],
Cell[22750, 793, 96, 1, 70, "ExampleText",
 CellID->45814927],
Cell[CellGroupData[{
Cell[22871, 798, 613, 21, 70, "Input",
 CellID->85154930],
Cell[23487, 821, 378, 11, 36, "Output",
 CellID->309936772]
}, Open  ]],
Cell[23880, 835, 125, 3, 70, "ExampleDelimiter",
 CellID->198919299],
Cell[24008, 840, 134, 4, 70, "ExampleText",
 CellID->29620782],
Cell[CellGroupData[{
Cell[24167, 848, 288, 10, 70, "Input",
 CellID->98169622],
Cell[24458, 860, 331, 10, 36, "Output",
 CellID->746925268]
}, Open  ]],
Cell[24804, 873, 125, 3, 70, "ExampleDelimiter",
 CellID->650788513],
Cell[24932, 878, 146, 4, 70, "ExampleText",
 CellID->408695815],
Cell[CellGroupData[{
Cell[25103, 886, 358, 13, 70, "Input",
 CellID->16385612],
Cell[25464, 901, 335, 11, 39, "Output",
 CellID->81672072]
}, Open  ]],
Cell[CellGroupData[{
Cell[25836, 917, 378, 14, 70, "Input",
 CellID->3987502],
Cell[26217, 933, 333, 11, 39, "Output",
 CellID->88393519]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26599, 950, 243, 7, 70, "ExampleSection",
 CellID->100522369],
Cell[26845, 959, 134, 4, 70, "ExampleText",
 CellID->194977374],
Cell[26982, 965, 357, 12, 70, "Input",
 CellID->33603735],
Cell[CellGroupData[{
Cell[27364, 981, 565, 19, 70, "Input",
 CellID->327858092],
Cell[27932, 1002, 450, 13, 39, "Output",
 CellID->650871715]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28431, 1021, 222, 7, 70, "ExampleSection",
 CellID->254436480],
Cell[CellGroupData[{
Cell[28678, 1032, 251, 7, 70, "ExampleSubsection",
 CellID->267835863],
Cell[28932, 1041, 80, 1, 70, "ExampleText",
 CellID->31871615],
Cell[CellGroupData[{
Cell[29037, 1046, 324, 11, 70, "Input",
 CellID->576789740],
Cell[29364, 1059, 180, 5, 36, "Output",
 CellID->403026386]
}, Open  ]],
Cell[29559, 1067, 78, 1, 70, "ExampleText",
 CellID->38130835],
Cell[CellGroupData[{
Cell[29662, 1072, 429, 13, 70, "Input",
 CellID->106070136],
Cell[30094, 1087, 179, 5, 36, "Output",
 CellID->793203194]
}, Open  ]],
Cell[30288, 1095, 130, 4, 70, "ExampleText",
 CellID->123543348],
Cell[CellGroupData[{
Cell[30443, 1103, 436, 13, 70, "Input",
 CellID->139482286],
Cell[30882, 1118, 179, 5, 36, "Output",
 CellID->223685836]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31110, 1129, 233, 7, 70, "ExampleSubsection",
 CellID->44487655],
Cell[31346, 1138, 169, 4, 70, "ExampleText",
 CellID->139953229],
Cell[CellGroupData[{
Cell[31540, 1146, 496, 16, 70, "Input",
 CellID->477043934],
Cell[32039, 1164, 281, 10, 36, "Output",
 CellID->366538122]
}, Open  ]],
Cell[CellGroupData[{
Cell[32357, 1179, 552, 17, 70, "Input",
 CellID->337215297],
Cell[32912, 1198, 280, 10, 36, "Output",
 CellID->621747601]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33241, 1214, 238, 7, 70, "ExampleSubsection",
 CellID->518879127],
Cell[33482, 1223, 251, 7, 70, "ExampleText",
 CellID->554794537],
Cell[CellGroupData[{
Cell[33758, 1234, 499, 16, 70, "Input",
 CellID->18443624],
Cell[34260, 1252, 600, 19, 36, "Output",
 CellID->218882433]
}, Open  ]],
Cell[CellGroupData[{
Cell[34897, 1276, 741, 25, 70, "Input",
 CellID->676481546],
Cell[35641, 1303, 3348, 59, 70, "Output",
 Evaluatable->False,
 CellID->501160615]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39038, 1368, 229, 7, 70, "ExampleSubsection",
 CellID->257849657],
Cell[39270, 1377, 92, 1, 70, "ExampleText",
 CellID->58854240],
Cell[39365, 1380, 977, 33, 70, "Input",
 CellID->102548334],
Cell[40345, 1415, 712, 24, 70, "Input",
 CellID->68233642],
Cell[CellGroupData[{
Cell[41082, 1443, 695, 22, 70, "Input",
 CellID->467135772],
Cell[41780, 1467, 222, 7, 36, "Output",
 CellID->478956284]
}, Open  ]],
Cell[42017, 1477, 139, 4, 70, "ExampleText",
 CellID->32268760],
Cell[CellGroupData[{
Cell[42181, 1485, 487, 15, 70, "Input",
 CellID->193152442],
Cell[42671, 1502, 223, 7, 36, "Output",
 CellID->19542221]
}, Open  ]],
Cell[42909, 1512, 144, 4, 70, "ExampleText",
 CellID->295467606],
Cell[CellGroupData[{
Cell[43078, 1520, 462, 16, 70, "Input",
 CellID->154971934],
Cell[43543, 1538, 506, 17, 36, "Output",
 CellID->34857902]
}, Open  ]],
Cell[CellGroupData[{
Cell[44086, 1560, 661, 19, 70, "Input",
 CellID->5686649],
Cell[44750, 1581, 223, 7, 36, "Output",
 CellID->774781769]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45022, 1594, 232, 7, 70, "ExampleSubsection",
 CellID->6226037],
Cell[45257, 1603, 87, 1, 70, "ExampleText",
 CellID->180797191],
Cell[CellGroupData[{
Cell[45369, 1608, 443, 15, 70, "Input",
 CellID->333203278],
Cell[45815, 1625, 419, 8, 70, "Message",
 CellID->28418542],
Cell[46237, 1635, 227, 7, 36, "Output",
 CellID->507275088]
}, Open  ]],
Cell[46479, 1645, 83, 1, 70, "ExampleText",
 CellID->150839805],
Cell[CellGroupData[{
Cell[46587, 1650, 314, 11, 70, "Input",
 CellID->172725194],
Cell[46904, 1663, 421, 8, 70, "Message",
 CellID->408492983],
Cell[47328, 1673, 227, 7, 36, "Output",
 CellID->545615544]
}, Open  ]],
Cell[47570, 1683, 245, 8, 70, "ExampleText",
 CellID->263952119],
Cell[CellGroupData[{
Cell[47840, 1695, 369, 12, 70, "Input",
 CellID->104049662],
Cell[48212, 1709, 227, 7, 36, "Output",
 CellID->546636815]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48488, 1722, 227, 7, 70, "ExampleSubsection",
 CellID->193410444],
Cell[48718, 1731, 394, 15, 70, "ExampleText",
 CellID->315800719],
Cell[CellGroupData[{
Cell[49137, 1750, 442, 14, 70, "Input",
 CellID->123229637],
Cell[49582, 1766, 1660, 31, 70, "Output",
 Evaluatable->False,
 CellID->210934010]
}, Open  ]],
Cell[51257, 1800, 73, 1, 70, "ExampleText",
 CellID->114233266],
Cell[CellGroupData[{
Cell[51355, 1805, 805, 24, 70, "Input",
 CellID->1023104],
Cell[52163, 1831, 376, 11, 36, "Output",
 CellID->1610288]
}, Open  ]],
Cell[52554, 1845, 137, 4, 70, "ExampleText",
 CellID->509557818],
Cell[CellGroupData[{
Cell[52716, 1853, 878, 25, 70, "Input",
 CellID->607841865],
Cell[53597, 1880, 379, 11, 36, "Output",
 CellID->290993165]
}, Open  ]],
Cell[53991, 1894, 95, 1, 70, "ExampleText",
 CellID->504121406],
Cell[CellGroupData[{
Cell[54111, 1899, 878, 25, 70, "Input",
 CellID->28474875],
Cell[54992, 1926, 378, 11, 36, "Output",
 CellID->28153640]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55419, 1943, 232, 7, 70, "ExampleSubsection",
 CellID->424537078],
Cell[55654, 1952, 88, 1, 70, "ExampleText",
 CellID->372984645],
Cell[55745, 1955, 392, 15, 70, "Input",
 CellID->245186511],
Cell[CellGroupData[{
Cell[56162, 1974, 686, 23, 70, "Input",
 CellID->571050783],
Cell[56851, 1999, 2036, 61, 105, "Output",
 CellID->321690609]
}, Open  ]],
Cell[58902, 2063, 274, 10, 70, "ExampleText",
 CellID->172351922],
Cell[CellGroupData[{
Cell[59201, 2077, 603, 20, 70, "Input",
 CellID->187720557],
Cell[59807, 2099, 77555, 1309, 70, "Output",
 CellID->84645867]
}, Open  ]],
Cell[137377, 3411, 134, 4, 70, "ExampleText",
 CellID->212720019],
Cell[137514, 3417, 732, 25, 70, "Input",
 CellID->176283711],
Cell[CellGroupData[{
Cell[138271, 3446, 851, 28, 70, "Input",
 CellID->366479200],
Cell[139125, 3476, 79004, 1336, 70, "Output",
 CellID->244971889]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[218178, 4818, 235, 7, 70, "ExampleSubsection",
 CellID->8701688],
Cell[218416, 4827, 92, 1, 70, "ExampleText",
 CellID->154413102],
Cell[CellGroupData[{
Cell[218533, 4832, 315, 10, 70, "Input",
 CellID->395562938],
Cell[218851, 4844, 340, 10, 71, "Output",
 CellID->387074459]
}, Open  ]],
Cell[219206, 4857, 142, 4, 70, "ExampleText",
 CellID->377300582],
Cell[CellGroupData[{
Cell[219373, 4865, 932, 27, 70, "Input",
 CellID->1085713],
Cell[CellGroupData[{
Cell[220330, 4896, 486, 11, 70, "Print",
 CellID->15406366],
Cell[220819, 4909, 536, 12, 70, "Print",
 CellID->247331292],
Cell[221358, 4923, 582, 12, 70, "Print",
 CellID->112739794]
}, Open  ]],
Cell[221955, 4938, 340, 10, 71, "Output",
 CellID->508612562]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[222356, 4955, 227, 7, 70, "ExampleSection",
 CellID->212749006],
Cell[CellGroupData[{
Cell[222608, 4966, 247, 7, 70, "ExampleSubsection",
 CellID->25985482],
Cell[222858, 4975, 569, 23, 70, "ExampleText",
 CellID->125456646],
Cell[223430, 5000, 409, 14, 70, "Input",
 CellID->238310877],
Cell[223842, 5016, 94, 1, 70, "ExampleText",
 CellID->20519307],
Cell[CellGroupData[{
Cell[223961, 5021, 181, 6, 70, "Input",
 CellID->151731003],
Cell[224145, 5029, 476, 15, 36, "Output",
 CellID->499146064]
}, Open  ]],
Cell[224636, 5047, 215, 8, 70, "ExampleText",
 CellID->106398918],
Cell[CellGroupData[{
Cell[224876, 5059, 320, 10, 70, "Input",
 CellID->32404523],
Cell[225199, 5071, 2187, 40, 70, "Output",
 Evaluatable->False,
 CellID->55179085]
}, Open  ]],
Cell[227401, 5114, 106, 2, 70, "ExampleText",
 CellID->409862437],
Cell[227510, 5118, 1463, 42, 70, "Input",
 CellID->171819644],
Cell[CellGroupData[{
Cell[228998, 5164, 210, 7, 70, "Input",
 CellID->64565450],
Cell[229211, 5173, 2197, 40, 70, "Output",
 Evaluatable->False,
 CellID->187581259]
}, Open  ]],
Cell[231423, 5216, 60, 1, 70, "ExampleText",
 CellID->489526707],
Cell[CellGroupData[{
Cell[231508, 5221, 179, 6, 70, "Input",
 CellID->851945494],
Cell[231690, 5229, 465, 15, 36, "Output",
 CellID->63398726]
}, Open  ]],
Cell[CellGroupData[{
Cell[232192, 5249, 213, 7, 70, "Input",
 CellID->63001270],
Cell[232408, 5258, 2156, 39, 70, "Output",
 Evaluatable->False,
 CellID->469336812]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[234613, 5303, 252, 7, 70, "ExampleSubsection",
 CellID->132272328],
Cell[234868, 5312, 638, 21, 70, "ExampleText",
 CellID->1271033],
Cell[235509, 5335, 958, 31, 70, "Input",
 CellID->496031650],
Cell[CellGroupData[{
Cell[236492, 5370, 235, 8, 70, "Input",
 CellID->109542164],
Cell[236730, 5380, 2559, 46, 70, "Output",
 Evaluatable->False,
 CellID->270737029]
}, Open  ]],
Cell[239304, 5429, 122, 3, 70, "ExampleText",
 CellID->5440138],
Cell[CellGroupData[{
Cell[239451, 5436, 236, 8, 70, "Input",
 CellID->76994692],
Cell[239690, 5446, 246, 8, 36, "Output",
 CellID->32786902]
}, Open  ]],
Cell[239951, 5457, 60, 1, 70, "ExampleText",
 CellID->225317043],
Cell[CellGroupData[{
Cell[240036, 5462, 805, 26, 70, "Input",
 CellID->226828258],
Cell[240844, 5490, 466, 17, 36, "Output",
 CellID->315753884]
}, Open  ]],
Cell[CellGroupData[{
Cell[241347, 5512, 238, 8, 70, "Input",
 CellID->17063451],
Cell[241588, 5522, 2543, 46, 70, "Output",
 Evaluatable->False,
 CellID->236199083]
}, Open  ]],
Cell[244146, 5571, 124, 3, 70, "ExampleDelimiter",
 CellID->75606875],
Cell[244273, 5576, 620, 22, 70, "ExampleText",
 CellID->9884090],
Cell[244896, 5600, 112, 4, 70, "Input",
 CellID->815199894],
Cell[245011, 5606, 354, 14, 70, "ExampleText",
 CellID->419867967],
Cell[245368, 5622, 374, 14, 70, "Input",
 CellID->660598617],
Cell[245745, 5638, 96, 1, 70, "ExampleText",
 CellID->137640289],
Cell[245844, 5641, 1549, 48, 70, "Input",
 CellID->423352582],
Cell[247396, 5691, 152, 6, 70, "ExampleText",
 CellID->375466357],
Cell[247551, 5699, 546, 19, 70, "Input",
 CellID->696006544],
Cell[248100, 5720, 172, 6, 70, "ExampleText",
 CellID->120975745],
Cell[CellGroupData[{
Cell[248297, 5730, 542, 19, 70, "Input",
 CellID->75050124],
Cell[248842, 5751, 1585, 34, 123, "Output",
 CellID->277446975]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[250488, 5792, 237, 7, 70, "ExampleSection",
 CellID->437197510],
Cell[250728, 5801, 376, 13, 70, "ExampleText",
 CellID->379053703],
Cell[CellGroupData[{
Cell[251129, 5818, 751, 24, 70, "Input",
 CellID->153894183],
Cell[251883, 5844, 792, 27, 39, "Output",
 CellID->477832524]
}, Open  ]],
Cell[252690, 5874, 232, 7, 70, "ExampleText",
 CellID->431689540],
Cell[CellGroupData[{
Cell[252947, 5885, 390, 13, 70, "Input",
 CellID->202213805],
Cell[253340, 5900, 668, 20, 36, "Output",
 CellID->523271533]
}, Open  ]],
Cell[254023, 5923, 220, 7, 70, "ExampleText",
 CellID->100625776],
Cell[CellGroupData[{
Cell[254268, 5934, 190, 6, 70, "Input",
 CellID->651551109],
Cell[254461, 5942, 2810, 50, 70, "Output",
 Evaluatable->False,
 CellID->359733379]
}, Open  ]],
Cell[257286, 5995, 124, 3, 70, "ExampleDelimiter",
 CellID->44115266],
Cell[257413, 6000, 493, 18, 70, "ExampleText",
 CellID->660412948],
Cell[257909, 6020, 283, 11, 70, "Input",
 CellID->99356243],
Cell[258195, 6033, 199, 7, 70, "ExampleText",
 CellID->472535283],
Cell[CellGroupData[{
Cell[258419, 6044, 125, 4, 70, "Input",
 CellID->262203851],
Cell[258547, 6050, 428, 8, 70, "Message",
 CellID->455094050],
Cell[258978, 6060, 453, 8, 70, "Message",
 CellID->417430873],
Cell[259434, 6070, 440, 15, 51, "Output",
 CellID->964443295]
}, Open  ]],
Cell[259889, 6088, 202, 7, 70, "ExampleText",
 CellID->77310316],
Cell[CellGroupData[{
Cell[260116, 6099, 126, 4, 70, "Input",
 CellID->384174785],
Cell[260245, 6105, 623, 20, 51, "Output",
 CellID->79270137]
}, Open  ]],
Cell[260883, 6128, 217, 7, 70, "ExampleText",
 CellID->488158405],
Cell[CellGroupData[{
Cell[261125, 6139, 190, 6, 70, "Input",
 CellID->73903294],
Cell[261318, 6147, 1847, 56, 81, "Output",
 CellID->427338722]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[263214, 6209, 225, 7, 70, "ExampleSection",
 CellID->4241],
Cell[263442, 6218, 123, 3, 70, "ExampleText",
 CellID->678329697],
Cell[CellGroupData[{
Cell[263590, 6225, 285, 10, 70, "Input",
 CellID->430899202],
Cell[263878, 6237, 296, 9, 39, "Output",
 CellID->512336426]
}, Open  ]],
Cell[264189, 6249, 117, 3, 70, "ExampleText",
 CellID->381422181],
Cell[CellGroupData[{
Cell[264331, 6256, 319, 11, 70, "Input",
 CellID->24119152],
Cell[264653, 6269, 227, 7, 36, "Output",
 CellID->437736259]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[264941, 6283, 311, 9, 70, "SeeAlsoSection",
 CellID->29933],
Cell[265255, 6294, 1462, 53, 70, "SeeAlso",
 CellID->4020]
}, Open  ]],
Cell[CellGroupData[{
Cell[266754, 6352, 314, 9, 70, "TutorialsSection",
 CellID->26295],
Cell[267071, 6363, 193, 4, 70, "Tutorials",
 CellID->123709578],
Cell[267267, 6369, 143, 3, 70, "Tutorials",
 CellID->5444],
Cell[267413, 6374, 160, 3, 70, "Tutorials",
 CellID->4221],
Cell[267576, 6379, 153, 3, 70, "Tutorials",
 CellID->15972],
Cell[267732, 6384, 177, 4, 70, "Tutorials",
 CellID->123070281]
}, Open  ]],
Cell[CellGroupData[{
Cell[267946, 6393, 321, 9, 70, "RelatedLinksSection",
 CellID->31082],
Cell[268270, 6404, 361, 12, 70, "RelatedLinks"],
Cell[268634, 6418, 266, 6, 70, "RelatedLinks",
 CellID->20443],
Cell[268903, 6426, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[269326, 6444, 319, 9, 70, "MoreAboutSection",
 CellID->632422093],
Cell[269648, 6455, 142, 3, 70, "MoreAbout",
 CellID->20530193],
Cell[269793, 6460, 145, 3, 70, "MoreAbout",
 CellID->632602245],
Cell[269941, 6465, 151, 3, 70, "MoreAbout",
 CellID->338525158]
}, Open  ]],
Cell[270107, 6471, 50, 0, 70, "History"],
Cell[270160, 6473, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

