(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18709,        584]
NotebookOptionsPosition[     15417,        478]
NotebookOutlinePosition[     16862,        517]
CellTagsIndexPosition[     16777,        512]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Refresh" :> Documentation`HelpLookup["paclet:ref/Refresh"], 
          "Pause" :> Documentation`HelpLookup["paclet:ref/Pause"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Refresh\"\>", 
       2->"\<\"Pause\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Dynamic Interactivity Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FinishDynamic", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FinishDynamic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FinishDynamic"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]finishes updating and displaying all currently visible \
",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " objects. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26247]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FinishDynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FinishDynamic"], "[", "]"}]], "InlineFormula"],
 " does not return until all ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects are updated and displayed. "
}], "Notes",
 CellID->16161]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42245484],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->45032797],

Cell[TextData[{
 "Evaluations are not affected when updating ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->498989732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->831704377],

Cell[BoxData[
 DynamicBox[ToBoxes[$CellContext`x, StandardForm],
  ImageSizeCache->{7., {0., 6.}}]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147012115]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"x", "=", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->901082944],

Cell["\<\
Force each evaluation to wait for the dynamic display updates to finish: \
\>", "ExampleText",
 CellID->596784189],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FinishDynamic", "[", "]"}], ";", 
    RowBox[{"x", "=", "n"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->446361164]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26411],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DisplayAllSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayAllSteps"]], "InlineFormula"],
 " forces updates to finish in ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 " and related functions:"
}], "ExampleText",
 CellID->31522253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Animate", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Sin", "[", "x", "]"}], ",", 
           RowBox[{
            RowBox[{"Cos", "[", "x", "]"}], 
            RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], "]"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", " ", "Pi"}], ",", ".1"}], "}"}], ",", 
     RowBox[{"DisplayAllSteps", "\[Rule]", "t"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->472174277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`x$$ = 7.6000000000000005`, 
      Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
      Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ =
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`x$$], 0, 20 Pi, 0.1}}, Typeset`size$$ = {
      100., {48., 52.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`x$7131$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`x$$, $CellContext`x$7131$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Graphics[{
           Point[{
             Sin[$CellContext`x$$], Cos[$CellContext`x$$] 
             Sin[$CellContext`x$$]}]}, PlotRange -> 1, ImageSize -> Tiny], 
        "Specifications" :> {{$CellContext`x$$, 0, 20 Pi, 0.1, 
           DisplayAllSteps -> True, AnimationRunning -> False, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{328., {85., 90.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`x$$ = 32.4, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`x$$], 0, 20 Pi, 0.1}}, Typeset`size$$ = {
      100., {48., 52.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`x$7152$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`x$$, $CellContext`x$7152$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Graphics[{
           Point[{
             Sin[$CellContext`x$$], Cos[$CellContext`x$$] 
             Sin[$CellContext`x$$]}]}, PlotRange -> 1, ImageSize -> Tiny], 
        "Specifications" :> {{$CellContext`x$$, 0, 20 Pi, 0.1, 
           DisplayAllSteps -> False, AnimationRunning -> False, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{328., {85., 90.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{346, 366},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->880997874]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2544],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Refresh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refresh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pause",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pause"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30247]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28908],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->403535851]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FinishDynamic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 23.2190376}", "context" -> "System`", 
    "keywords" -> {
     "synchronizing dynamic updates", "finish dynamic updates", 
      "synchronize frontend and kernel", "sync", "display in synch", 
      "display all steps", "track all steps", "checkpoint updates"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FinishDynamic[] finishes updating and displaying all currently visible \
Dynamic objects. ", "synonyms" -> {"finish dynamic"}, "title" -> 
    "FinishDynamic", "type" -> "Symbol", "uri" -> "ref/FinishDynamic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5829, 177, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->42245484]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16635, 505}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2046, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2669, 77, 1578, 37, 70, "ObjectNameGrid"],
Cell[4250, 116, 639, 21, 70, "Usage",
 CellID->26247]
}, Open  ]],
Cell[CellGroupData[{
Cell[4926, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5404, 159, 388, 13, 70, "Notes",
 CellID->16161]
}, Closed]],
Cell[CellGroupData[{
Cell[5829, 177, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42245484],
Cell[CellGroupData[{
Cell[6213, 191, 147, 5, 70, "ExampleSection",
 CellID->45032797],
Cell[6363, 198, 232, 8, 70, "ExampleText",
 CellID->498989732],
Cell[CellGroupData[{
Cell[6620, 210, 103, 3, 28, "Input",
 CellID->831704377],
Cell[6726, 215, 240, 7, 36, "Output",
 CellID->147012115]
}, Open  ]],
Cell[6981, 225, 196, 7, 70, "Input",
 CellID->901082944],
Cell[7180, 234, 124, 3, 70, "ExampleText",
 CellID->596784189],
Cell[7307, 239, 258, 9, 70, "Input",
 CellID->446361164]
}, Open  ]],
Cell[CellGroupData[{
Cell[7602, 253, 233, 7, 70, "ExampleSection",
 CellID->26411],
Cell[7838, 262, 364, 12, 70, "ExampleText",
 CellID->31522253],
Cell[CellGroupData[{
Cell[8227, 278, 949, 27, 70, "Input",
 CellID->472174277],
Cell[9179, 307, 4151, 87, 70, "Output",
 CellID->880997874]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13391, 401, 310, 9, 70, "SeeAlsoSection",
 CellID->2544],
Cell[13704, 412, 443, 17, 70, "SeeAlso",
 CellID->30247]
}, Open  ]],
Cell[CellGroupData[{
Cell[14184, 434, 314, 9, 70, "TutorialsSection",
 CellID->28908],
Cell[14501, 445, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[14663, 450, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[14873, 458, 299, 8, 70, "MoreAboutSection"],
Cell[15175, 468, 170, 3, 70, "MoreAbout",
 CellID->403535851]
}, Open  ]],
Cell[15360, 474, 27, 0, 70, "History"],
Cell[15390, 476, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

