(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18917,        741]
NotebookOptionsPosition[     14228,        573]
NotebookOutlinePosition[     15512,        610]
CellTagsIndexPosition[     15427,        605]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Getting Pieces of Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GettingPiecesOfLists"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Getting Pieces of Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Part" :> Documentation`HelpLookup["paclet:ref/Part"], "Last" :> 
          Documentation`HelpLookup["paclet:ref/Last"], "Rest" :> 
          Documentation`HelpLookup["paclet:ref/Rest"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "Select" :> 
          Documentation`HelpLookup["paclet:ref/Select"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Part\"\>", 2->"\<\"Last\"\>", 3->"\<\"Rest\"\>", 
       4->"\<\"Take\"\>", 5->"\<\"Select\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"List Manipulation\"\>", 
       3->"\<\"Parts of Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["First", "ObjectName",
 CellID->19],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["First",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/First"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the first element in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14996]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", "1", "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5572]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67069002],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->699391764],

Cell["Extract the first element of a list:", "ExampleText",
 CellID->17122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6114],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8438],

Cell["Extract the first row of a matrix:", "ExampleText",
 CellID->24795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114844383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31986],

Cell[TextData[{
 "The head need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{
   RowBox[{"a", "^", "2"}], "+", 
   RowBox[{"b", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11288],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24298]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->275],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["First",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/First"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->30673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"Range", "[", "100", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12160],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15018]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27386],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", "1", "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6236],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22339]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6088],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2683]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20941],

Cell[TextData[{
 "The expression is evaluated before ",
 Cell[BoxData[
  ButtonBox["First",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/First"]], "InlineFormula"],
 " is applied:"
}], "ExampleText",
 CellID->10499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{
   RowBox[{"b", "^", "2"}], "+", 
   RowBox[{"a", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14736],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29185],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["First",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/First"]], "InlineFormula"],
 " always operates on the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of expressions: "
}], "ExampleText",
 CellID->25988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"1", "/", 
   RowBox[{"a", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8693],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14752]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"1", "/", 
   RowBox[{"a", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5593],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "2"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->14577]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32601],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Last",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Last"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Select",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Select"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->548]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29385],

Cell[TextData[ButtonBox["Getting Pieces of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GettingPiecesOfLists"]], "Tutorials",
 CellID->9197]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->111773761],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->314456775],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->251178463],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->232683836]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"First - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 23.6877996}", "context" -> "System`", 
    "keywords" -> {
     "beginning of list", "first part", "first element of list", 
      "first part of expression", "first part of tree"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "First[expr] gives the first element in expr. ", "synonyms" -> {"car"}, 
    "title" -> "First", "type" -> "Symbol", "uri" -> "ref/First"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4470, 144, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->67069002]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15285, 598}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2355, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2978, 82, 40, 1, 70, "ObjectName",
 CellID->19],
Cell[3021, 85, 545, 18, 70, "Usage",
 CellID->14996]
}, Open  ]],
Cell[CellGroupData[{
Cell[3603, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4081, 125, 352, 14, 70, "Notes",
 CellID->5572]
}, Closed]],
Cell[CellGroupData[{
Cell[4470, 144, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67069002],
Cell[CellGroupData[{
Cell[4854, 158, 148, 5, 70, "ExampleSection",
 CellID->699391764],
Cell[5005, 165, 75, 1, 70, "ExampleText",
 CellID->17122],
Cell[CellGroupData[{
Cell[5105, 170, 153, 5, 28, "Input",
 CellID->6114],
Cell[5261, 177, 154, 5, 36, "Output",
 CellID->30568]
}, Open  ]],
Cell[5430, 185, 120, 3, 70, "ExampleDelimiter",
 CellID->8438],
Cell[5553, 190, 73, 1, 70, "ExampleText",
 CellID->24795],
Cell[CellGroupData[{
Cell[5651, 195, 246, 9, 70, "Input",
 CellID->27824],
Cell[5900, 206, 203, 7, 36, "Output",
 CellID->114844383]
}, Open  ]],
Cell[6118, 216, 121, 3, 70, "ExampleDelimiter",
 CellID->31986],
Cell[6242, 221, 191, 8, 70, "ExampleText",
 CellID->6191],
Cell[CellGroupData[{
Cell[6458, 233, 168, 6, 70, "Input",
 CellID->11288],
Cell[6629, 241, 177, 6, 36, "Output",
 CellID->24298]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6855, 253, 237, 7, 70, "ExampleSection",
 CellID->275],
Cell[7095, 262, 316, 12, 70, "ExampleText",
 CellID->30673],
Cell[CellGroupData[{
Cell[7436, 278, 170, 5, 70, "Input",
 CellID->12160],
Cell[7609, 285, 154, 5, 36, "Output",
 CellID->15018]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7812, 296, 233, 7, 70, "ExampleSection",
 CellID->27386],
Cell[8048, 305, 358, 14, 70, "ExampleText",
 CellID->18616],
Cell[CellGroupData[{
Cell[8431, 323, 153, 5, 70, "Input",
 CellID->6236],
Cell[8587, 330, 154, 5, 36, "Output",
 CellID->22339]
}, Open  ]],
Cell[CellGroupData[{
Cell[8778, 340, 172, 6, 70, "Input",
 CellID->6088],
Cell[8953, 348, 153, 5, 36, "Output",
 CellID->2683]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9155, 359, 226, 7, 70, "ExampleSection",
 CellID->20941],
Cell[9384, 368, 219, 8, 70, "ExampleText",
 CellID->10499],
Cell[CellGroupData[{
Cell[9628, 380, 168, 6, 70, "Input",
 CellID->14736],
Cell[9799, 388, 177, 6, 36, "Output",
 CellID->11346]
}, Open  ]],
Cell[9991, 397, 121, 3, 70, "ExampleDelimiter",
 CellID->29185],
Cell[10115, 402, 332, 12, 70, "ExampleText",
 CellID->25988],
Cell[CellGroupData[{
Cell[10472, 418, 143, 5, 70, "Input",
 CellID->8693],
Cell[10618, 425, 154, 5, 36, "Output",
 CellID->14752]
}, Open  ]],
Cell[CellGroupData[{
Cell[10809, 435, 146, 5, 70, "Input",
 CellID->5593],
Cell[10958, 442, 364, 14, 50, "Output",
 CellID->14577]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11383, 463, 311, 9, 70, "SeeAlsoSection",
 CellID->32601],
Cell[11697, 474, 1148, 44, 70, "SeeAlso",
 CellID->548]
}, Open  ]],
Cell[CellGroupData[{
Cell[12882, 523, 314, 9, 70, "TutorialsSection",
 CellID->29385],
Cell[13199, 534, 153, 3, 70, "Tutorials",
 CellID->9197]
}, Open  ]],
Cell[CellGroupData[{
Cell[13389, 542, 319, 9, 70, "MoreAboutSection",
 CellID->111773761],
Cell[13711, 553, 144, 3, 70, "MoreAbout",
 CellID->314456775],
Cell[13858, 558, 145, 3, 70, "MoreAbout",
 CellID->251178463],
Cell[14006, 563, 150, 3, 70, "MoreAbout",
 CellID->232683836]
}, Open  ]],
Cell[14171, 569, 27, 0, 70, "History"],
Cell[14201, 571, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

