(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    111119,       3075]
NotebookOptionsPosition[    100141,       2688]
NotebookOutlinePosition[    101567,       2728]
CellTagsIndexPosition[    101480,       2723]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Numerical Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNumericalData"], "Curve Fitting" :> 
          Documentation`HelpLookup["paclet:tutorial/CurveFitting"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Manipulating Numerical Data\"\>", 
       2->"\<\"Curve Fitting\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindFit" :> Documentation`HelpLookup["paclet:ref/FindFit"], 
          "LeastSquares" :> 
          Documentation`HelpLookup["paclet:ref/LeastSquares"], 
          "PseudoInverse" :> 
          Documentation`HelpLookup["paclet:ref/PseudoInverse"], 
          "Interpolation" :> 
          Documentation`HelpLookup["paclet:ref/Interpolation"], 
          "InterpolatingPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingPolynomial"], 
          "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], "ListPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FindFit\"\>", 
       2->"\<\"LeastSquares\"\>", 3->"\<\"PseudoInverse\"\>", 
       4->"\<\"Interpolation\"\>", 5->"\<\"InterpolatingPolynomial\"\>", 
       6->"\<\"Solve\"\>", 7->"\<\"ListPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"], 
          "Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Curve Fitting & Approximate Functions\"\>", 
       2->"\<\"Data Transforms and Smoothing\"\>", 
       3->"\<\"Matrix-Based Minimization\"\>", 
       4->"\<\"Numerical Data\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fit", "ObjectName",
 CellID->23747],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Fit",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Fit"], "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        StyleBox["funs", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a least\[Hyphen]squares fit to a list of data as \
a linear combination of the functions ",
     Cell[BoxData[
      StyleBox["funs", "TI"]], "InlineFormula"],
     " of variables ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The data can have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "1"], ",", 
       SubscriptBox["y", "1"], ",", "\[Ellipsis]", " ", ",", 
       SubscriptBox["f", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "2"], ",", 
       SubscriptBox["y", "2"], ",", "\[Ellipsis]", " ", ",", 
       SubscriptBox["f", "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ", where the number of coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y", ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " is equal to the number of variables in the list ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18767],

Cell[TextData[{
 "The data can also be of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "1"], ",", 
     SubscriptBox["f", "2"], ",", "\[Ellipsis]"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ", with a single coordinate assumed to take values ",
 Cell[BoxData["1"], "InlineFormula"],
 ", ",
 Cell[BoxData["2"], "InlineFormula"],
 ", \[Ellipsis]. "
}], "Notes",
 CellID->22534],

Cell[TextData[{
 "The argument ",
 Cell[BoxData[
  StyleBox["funs", "TI"]], "InlineFormula"],
 " can be any list of functions that depend only on the objects ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8399],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", 
      RowBox[{"x", "^", "2"}]}], "}"}], ",", "x"}], "]"}]], "InlineFormula"],
 " gives a quadratic fit to a sequence of values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". The result is of the form ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["0", "TR"]], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]], 
    StyleBox["x", "TR"]}], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["2", "TR"]], 
    RowBox[{
     StyleBox["x", "TR"], "^", 
     StyleBox["2", "TR"]}]}]}]], "InlineFormula"],
 ", where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are real numbers. The successive values of ",
 Cell[BoxData["x"], "InlineFormula"],
 " needed to obtain the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are assumed to be 1, 2, \[Ellipsis] . ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->729431391,
  ButtonNote->"729431391"]
}], "Notes",
 CellID->31512],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", 
      RowBox[{"x", "^", "2"}]}], "}"}], ",", "x"}], "]"}]], "InlineFormula"],
 " does a quadratic fit, assuming a sequence of ",
 Cell[BoxData["x"], "InlineFormula"],
 " values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->10655736,
  ButtonNote->"10655736"]
}], "Notes",
 CellID->21501],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", "y"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "InlineFormula"],
 " finds a fit of the form ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["0", "TR"]], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]], 
    StyleBox["x", "TR"]}], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["2", "TR"]], 
    StyleBox["y", "TR"]}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->66083099,
  ButtonNote->"66083099"]
}], "Notes",
 CellID->16640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " always finds the linear combination of the functions in the list ",
 Cell[BoxData[
  StyleBox["funs", "TI"]], "InlineFormula"],
 " that minimizes the sum of the squares of deviations from the values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->153685526,
  ButtonNote->"153685526"]
}], "Notes",
 CellID->17934],

Cell[TextData[{
 "Exact numbers given as input to ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " are converted to approximate numbers with machine precision. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->753871874,
  ButtonNote->"753871874"]
}], "Notes",
 CellID->30992]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1377790],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->414965136],

Cell["Here is some data:", "ExampleText",
 CellID->430527260],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25679113],

Cell["Find the line that best fits the data:", "ExampleText",
 CellID->96581851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"line", " ", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98035656],

Cell[BoxData[
 RowBox[{"0.18644067796610175`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.6949152542372883`", " ", "x"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133191716]
}, Open  ]],

Cell["Find the quadratic that best fits the data:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->10655736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parabola", " ", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", 
      RowBox[{"x", "^", "2"}]}], "}"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->301796045],

Cell[BoxData[
 RowBox[{"0.6783919597989946`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.26633165829145716`", " ", "x"}], "+", 
  RowBox[{"0.19095477386934664`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->529749515]
}, Open  ]],

Cell["Show the data with the two curves:", "ExampleText",
 CellID->276178247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"line", ",", " ", "parabola"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "5"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28450773],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->53030813]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14864],

Cell["Here is some data defined with exact values:", "ExampleText",
 CellID->18284782],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Pi"}], ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "Pi"}], "/", "2"}], ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], ",", " ", 
       RowBox[{"-", "1"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"Pi", ",", " ", 
       RowBox[{"-", "4"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310923059],

Cell["\<\
Fit the data to a linear combination of sine functions using machine \
arithmetic:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->753871874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "/", "2"}], "]"}], ",", " ", 
     RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "}"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->635366557],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "3.999999999999999`"}], " ", 
   RowBox[{"Sin", "[", 
    FractionBox["x", "2"], "]"}]}], "+", 
  RowBox[{"2.32842712474619`", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"0.`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}]}]], "Output",
 ImageSize->{264, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27823509]
}, Open  ]],

Cell["Fit the data using 24 digit precision arithmetic:", "ExampleText",
 CellID->149847150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"data", ",", "24"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "/", "2"}], "]"}], ",", " ", 
     RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "}"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->266507236],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
   "-", "3.99999999999999999999999999999282962068`22.311313750293873"}], " ", 
   
   RowBox[{"Sin", "[", 
    FractionBox["x", "2"], "]"}]}], "+", 
  RowBox[{
  "2.32842712474619009760337744863707742454`22.021698531402937", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{441, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->48006382]
}, Open  ]],

Cell["Show the data with the curve:", "ExampleText",
 CellID->122496759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", "data", "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{"%", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "Pi"}], ",", " ", "Pi"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->493468576],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->757222865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191497276],

Cell["Here is some data in 2 dimensions:", "ExampleText",
 CellID->550542185],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->43222121],

Cell["Find the plane that best fits the data:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->66083099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plane", " ", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", "x", ",", " ", "y"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->335676179],

Cell[BoxData[
 RowBox[{"0.7999999999999994`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.5`", " ", "x"}], "+", 
  RowBox[{"0.5000000000000007`", " ", "y"}]}]], "Output",
 ImageSize->{113, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->255100191]
}, Open  ]],

Cell["Show the plane with the data points:", "ExampleText",
 CellID->39616490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{"plane", ",", "  ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", ".5", "]"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}], ",", " ", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", " ", 
      RowBox[{"PointSize", "[", "0.05", "]"}], ",", " ", 
      RowBox[{"Map", "[", 
       RowBox[{"Point", ",", " ", "data"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->280137527],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNXOuyHUUVbuay97kEciAhOSbkJBxyQIGEgNwEURElRSEXQSwK1DLisZKy
LC3krz+t8h18CP/wJPspfAindHpdulevXj3Ts6NVnqpk7z3T070u3/rW6jWz
93t3vrp7+oc7X9374s6121/e+dPde1/8+drbf/xyPNQ+4Jz7evz3t0M3vv/3
+A7+fT0Mw3ii+v/Pxv/b8cLGf/JvBvhzzfj2QxjxuTrT+v+6+Nm5DyrHrccX
P29rrPW9yjlW2ZEuO/LG//Vcn5EVVvS6rr7y99Uj79LcjVoLrfw7+gRqnJ6e
+rfvwJnfqutQUZje3Ya3v6EzPZhhvFj48G0Y8WuplxyhbPgWjP4Vjd5VozVG
fgijfzEgWvfU6E6NfjOx9INqdK9G/wBGf0qjH+KzeEEy2psE5/65GI2W2vzz
X3TFjpofrf4zdYW/AKSiqXcSH31En87yXONouICv8q/BEnGt1+HqD8XV/mTv
R3d4FV6or3sNrntfXBdljKs3anX2nH/FlX9Cnw6U3J3/bxU+o7HkCiSHtt2r
MOuNIWcOXv8c6cgy78ByuBJ60WsfMRbnfgVmeXaweEqOY48dSF/TAmuam/0P
aiqd9HwvV657htZ7WNmyUV5pSYZwnOTwereG3i9Vrr8n1gcW0esYmGT5EvQI
O/jjpfV7Or8v1gX5aT6PoQYG+kALy5NkcqUVXfnixEoadVJTjfuOMfXxvb/g
kn5ECxSMsgAcEXsTaH4+QTPbg9n5EStmOhkzbIXE+qkUA0rRGDF+C1b/rlit
kTKTLddBB9RKWjwo6jimmhmNn4M1X1NragSFCB1fO0incj0UjFHVz6zI1rS4
4gjevxrieAjZTfOVxXyNkIJjAazfRgxwLM4hIc/cOvouw+GXSdZzjJmU3Rj7
GUpajhUhW6M8LXECyKqU6UUlk+ZDabc1cVCQMtCEFWcZk9G6wGB9+MweVdLp
qEZpXyApzysPl1iUtWHbtsGbVCpJvuG5DFzuZtbU8rYkGaLylpCzmVtD6tBL
3yfSkcDsZ41JmRcse+oa7AqMuynkbPXsCTJ7E5lAYKGEkBZm7mer4SzMkrj6
MwPVcuQJthZ7j5lEYnKl9ScJYUhSFfEs/NoV8MgcIxnkKXj7LbLKowptmedc
zuSNXk2xY5fKS5bLGcFEovh8ApI+RTpcUH6U8+GUFuqCnAn6vF8a5VELdf44
SnEipChmXoOzClpHuUdRNC5SrbhyO6OscwxyPUHyXFR+tHNyicc0CluxrqyY
tkIHyauz/OMg/9Re+4A8zjbf2USO1gzIEdAVmUbrwsfmcSlzoj+PlucqsDFe
5dVcJV4cYk3Bnu5UtLNcNfykq9mSLy1sa19cBY0gr66c4DSRD4zjrNmhhb3M
B1k9OCNvsh8Ml80jDktflqM1IudoK213hbYajdsyZifn6OJ+tYI3dEQXPHtl
K119VHYi8kpyV7PcBP8I/7rIOpl1BSv7j9vp5Y/7Slj6Ue4QrJyq66w538Me
JEP+FD51dO4rH16KuiqGtFgTeIh09K/MO8vyptZKZwXZYQnX5LMuzkBeCx2v
30j4Nt03kXu9lQesZv7XePWDGtGtkTsJxkiRDwoeBgYNu06pVSuOW0hdyqgm
Yr0Kp/yH57hCmpov0b6g2cWgGe/V2VdyXy93qlZWz/ZbBb9yd8tLLysgPDQ3
25T9uMd1GGJRx5+/kHen4K0hduKm5Na5n/NetadJ37TrldYFIZduWbtpr8Ku
oXDnhHk3HPS5JOzw8SBb834RXcINbLzENYnHu8DA4yi2DvPafDWobXF+yhad
tAWiYnwd190b0t3MtujXHTEYR+xU0IN97W2UVWn5daUakqu/9VC+M9dO2Sbr
k2CdHVES7lVtJCf3Ba1lzTiHKe7wIN3J3NaKqAqjrajJ5CrF+IPCTlnXIu+7
GMc583EfZpcwxExjcbqsYtK8rDsZ+uqWoqIuG7bheN5XZ3vWVa466+t6Z5m9
EiSqz3tsv8m4l1XbIm4aZ066iQXPNDRWz8F3Q7I5JP90mEixYaqrwJKlGC+8
5+Yda7D8X//+D/aflRVKlfAUf2XzeI2NSMlqil76ItB5NSbZr95a2PsO5rL7
h4a9+C4L951B/tFGtbWu3OmbOSbUXNPX651IQBofynptJdzV5HrPwgCvPliM
+LmfsJOsghhfWQYebSfxURMlOX/1Im6yrn0SvUVtU0t7vlNInq4AVmyhDi2E
dy6yvUnAT2B+JUtkEAo8l++zbF7i2aBKL+bxTsTlmj5bVWDC3QW8cVbVVYDX
eKWqu/3Ay6W6QHN7YKaNyChdtEqZhae4idm4lCOX5fG1lGCl9vg2Wmfi2Gse
n09BbtKV8n5g7mnG4tqAXy179EYMqrtyborL8rhBhXXvpjLvFzwY2ELU8K4u
1tk63ucco/Ts0MAVRm1dkVfulb71Bk45WtqjVVrV4NmsCHILGHew5D0jMwv5
A2Qd/WRTLfKyvvcm3ivQ0qIkqDPaiVUt7cc7Pk91A8dy4LKM+ex6f9zzBYNp
v+T31+bYxoiGUR0/UD/xtcSKumady/29WDd7zkFIzF4u9XQ0vvS9yTLCajoo
VixP5NhRH48Ma4egn9RbitBQvwQ/13SEZG3QcgQv3inoyIsdmdgPDhlE+y8+
jyDQC3nJYnOVne3MnFUr4irebyZymnFWQmhjdFamqrw5+5erIf2kX7K78q9U
r5fqGRtTfOdRV27yfo3NxA0jZKb6lp9dERvbWYsrZOY2QElFvtA7ga5oG71f
mEL/FOPofu394MRneyvj1u6D+GmNDSWntjRXwTrA/HiHyaV8DrhwOVPxvtLO
5wmKN8yhWBMHZphDUNr5GVzG0M7llYGNaqjHwwMt/PSElW/kvkM/f70XGCjn
KZfsEbhvpqXj53LwL6zPvYttWGXA9sAytORcIvsDyb5ji9hr6u2W5DqIzqqa
CFYdF4idm4gt5rltLDKQRXUtuMQacDgUiDHDxAiVd9+SHDXwnx97phptzPhW
7RN6VmWvUdVi5byONNgZXIIaq1bSWjEPpTYL/VY6WHq6QEojUDJeaNvFuqvl
3+rnuoPPkv5Var28up+LRm8rZqgKNnT2nksijWNwCYrbqrjL7sUP8UnTPPp0
9dspjoRzxF9LI0/2NX2fU3crVhwXYflQMi6o5uPeSFZAsAcrZkGurpK9IY3i
J3LtO1UTDElHMdwaQ9fY40rr6iU8PseE4FO+NOm9TllR391CS51VlvF3xXX9
KDFd4qilOW+Wib19jXl0fl9vuDJJ19LY3Vfa7wbt/VnolIo7WlNaSC+k97zT
2ui/kdHRSpHLrPuj9Tvj1oglrnRy2/C3ec4SInZEhpq8pyReOY+iZaTfZGay
rgwWZXy5WIlJHJrWTZ6fbx2jXGvYGcxg5Z8zhA5+aiDBnrt/jpNx0dse3wJD
ybN9ogPziGkLTCm8Xci/4cCMuk+2OOARVdrJu0WNYM5FTBl7vRvcU1bwSaXd
dLVr46Xyvp0YsabY4e/eTTGnjgDdpZTI4+gJ9ykcb0CWoqNsP51ZHzJtkj0B
WETOipBjPa2bRVO6+8vveRbwZmNF9mAk79xPVO2QNvdjFY0lP9/lIe1m5Pfq
InKYD8O9zS6eszKFRBT0OCujti62dBaxM25qhTLPwKlQ318VzLskr3I11rLQ
mIsyBoq6JTlkFmvc18c/tteB0lz35MkS9J0Yx7HhBG6Iq/nbFb3lkSTjgEQC
A1FuobeLtb+ZSyvqinOEU+1dqC7jd8Lp6ImK9bJ1LVx3HLt8Xuxyt+N61lzu
cS9ammSanRWeYc2qEGloGjnd8muJnSQT+FOXlJy6k4xyc2X7pPbEJq/HQj+t
j5Us9Qqq/GblFP/5iGSwJYTcOB68PuAz/3X1LMuvK+9pTMtc2wrpNyIPHSsp
dZ8Vpb5AOl03shmvrT2Z3VeaQGYjPksbnyhpdL8ApTsk6Z5gfg0lVi3f16Cw
lBu/Savbsl0SspW0nMAaBY/uYbDPLZlvgBWCHKf49Ktzj5Ekx0oSnitUV0HF
xlihVbLLutuPvyWs4Dkd1z4Say+xscS7P1WuCrX1vk1xhtnnGq3/uOIx61sn
9ZHPs7yUrHUs1prCfRLHVTHciLWwp3id1rrGyA/XldBcU/HJqPR29GCCjOCe
pPVkhRJRklbvNfH0whB3DDGSrirLacy1GzurP0+zXYDZnqbZjoSsooIR95zm
vc8z43djnhUzWx7WvRGJuOfIno/BTDdppisyG8zY7CbJAj7H74fTDHnvJnqE
179BVwNXBvtzHZ7W1PkuxM/wDGkAORbwyJV82s9qxXi/xtMw/hUaf4lXlLZy
6DU/GljMfUeMZq71a+NvVrw+yD1WZN4TmgN/5+MNGnVBjTqmUfh7L9+nUefV
qCNaEX8J500apbsKl2ku/JWetwbRNRCjDmkU/lbQjwd7T/UojfoRjLo9xG6M
HPUwyYW/v/TOEL/noHex/uO7MOrdIVYmvnt9hs6+D2ffG2JX0N8ZWNEKP4Wz
H9DYNT9rOL7/BM58RNf5b+D4o5/Go+NrD93KIdTIePZjWuNz49MndOUv4RP+
Hpl74D9uU8kV\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->258578052]
}, Open  ]],

Cell["Find the quadratic that best fits the data:", "ExampleText",
 CellID->40504194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"quad", " ", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", "x", ",", " ", "y", ",", " ", 
      RowBox[{"x", "^", "2"}], ",", " ", 
      RowBox[{"x", " ", "y"}], ",", " ", 
      RowBox[{"y", "^", "2"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->686435202],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4.344434768182728`*^-17"}], "+", 
  RowBox[{"1.760869565217391`", " ", "x"}], "-", 
  RowBox[{"0.7608695652173924`", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"2.23913043478261`", " ", "y"}], "-", 
  RowBox[{"3.000000000000002`", " ", "x", " ", "y"}], "-", 
  RowBox[{"0.2391304347826084`", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{446, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->321090908]
}, Open  ]],

Cell["The quadratic actually interpolates the data:", "ExampleText",
 CellID->218938156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{"quad", ",", "  ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", ".5", "]"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}], ",", " ", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", " ", 
      RowBox[{"PointSize", "[", "0.05", "]"}], ",", " ", 
      RowBox[{"Map", "[", 
       RowBox[{"Point", ",", " ", "data"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->266566092],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVnPmXZEd159MR8bJaFtrB2AZ78MbMMJsZMzOMkCwsQEYIMRaWxLTRitS2
ZJAQIJiDmfSMLSEWL2DsGWODQYz/gPzF51jdtW9dVV3Vta9Ze1Xvq7olfos+
M9/vvTdevszKghL4l+lz60bEq5fv3fuJGzfixcvqux999okDTz367JOPPfqW
3/z0o8888eRjn3nLHZ/8NA75nyiVSv+An+d+uoT6/0VNfv7hypUr+MWe9f+G
9vigY4uVK/Kv5FB9vZzx102/8VSh3i6Vbvr/4rwPQ9MrXzi/RM/xc7P9rmyl
en7Pjiu1Nd3rvj2e954W906U9+3xGrfvOCO0/kyLa2V2/1tRtpXsQPGE13it
ol1vh7o6+VYunql6R2TtcqfrfwCjd9rv2qx8K8rXobwGZXhN/ly3B4oPmkdX
N1ly9Y/p4V7u/WG7976ma765BZUUrfv2fPU7jFtzH75N2gcOHDCfbtzzFd9l
9oamK76zqX3Dnq/4q3ZFDQS153V7unqKoMTlrXal5k/f0fLT/8HO/smm3za3
33tFM6ZmlTSyWkXtm+yKzSP50Zb330mi9ZHM7tqqH5/+ka/sd+nHL/xYV9RP
lko6IkulF37kq7nC1aQtEXLzByt68R/zyjoD8or4OXR35eDdFTnpj6x3G/s6
xVdDn6crBL0CZSy6Q0djyR88Gm/+UAUiJ1daWnqjXVMMvJKglfn5jFc8Ginj
8eB4lFt8/krjiK1fpdSWXxv/cAb0Lbi3az8avdiDy/CS0BkUE9qzu19tR17T
s3AxSGg3c3AdFX9oIirFiciqk/bBiWj9xF99cte7uWIE4tpyeSppT8R2XgzK
Nd0lHJo0Oybjwcl48z0VQntyT175wln85zp40w65WbvYHXjH9kmzYjKyKnf0
h6aE5BTbU/RzKvnJ+z/edKfr85jcbR2SfpeP6w7pKrmag0mlcofcXuWWexj9
tCy0TxmPqUhDHJQ/NG3HpqNUD05LXz9o99Acv3O1JNkqK8ZQyWJervbMH1c7
JxQQT/IdictUpBG5Je3TsZ13hXK8fcgtgYRDM1Fm0oMzUQX1m++VXvtIS2p7
tTPPtTBS7Oy0yICdKmVhORVdh5mnxsJyUWIKNCSjlUJwNkJAdTb6g7N6DCWr
+1C9ixkkT3nFWNvF6lC0OhRj/pnnqmJwp1HtnIqdBEoVOiS6oDumzYvpmLWb
jWoyomEGsWo2tqvdGZXwn4sq4eCceTEXWf1JVN99ReeWvbDfbdbLo6RrMn7q
uWrJddGPLnWCn0PpOi0aUKp486cUbr230iEd0DEby7kXcxECz+YQ03PNnhya
tz6ajwdRzah4xsGFqMJZ7R2wq/wafGvOer4YWZ96vtrF7uiySEfZBZcclPjm
c9/g74z5OhM7RBw8a5O+Yw/ccn/FvAtUvn1eom9eq77g26EF9uOC9Zo4VgpU
/uAiP0PNqntpMcqK2P/n/Wlu5ErhF3YlkHJOWls3r2bT8VJZHTeRcZOxCF3S
ZdAQ8VgIzMZOxl6n9SL8pcv0e59kLesnlCqh3bxD2V709tBihKC9SJeTt5Ds
4JLxWIqsll+yNkpWHZR/qSY83Ds/WrlKuKBS4FLy/+mB1Gb01zPjDS04SLt7
Ks/JHv6L+yEHAPFd5nOXMnBQvtNGHEqpqpqPHdLlGNzs61s/kmxRRgsYBYvG
SShAwiHzEiWrGVXIKUCygzU7Uosq4SU7glIle2nZWC1HVsv/aG2UrDqo8I8r
dmwlShWqdQzdYGMkf2rpno6f/mK1FLptZHtgue2+CsGUczpzsYuR32VkuuZj
J0dwp0V9p7Z95wJGjcUCSlbZdh2LUdbA7cajXXmUD9WMTy2yGqR9aFniBrrt
oHmKktUg7Zfk9y/By7aXzGuUrJbz9mqElAKU5MmQryx+wIyetYylfWnuAh9F
1c0M0m1jByWr2u6eLa4pXE5L6bHtu+ZzglJVtcDPAV6p3Gn0OhdjJ/MEFOkp
0cXYwSii8rf+TgUlqz9LfwDNHTLvUbJaPrgi4xdr74dSrJab2jIyUiqtL79a
5JZWuVZpkd1VggqVnunYM0P5zAvVHmVTEjpZt8USym7S6LbskhNZiOSQdS3U
2xxQXTaqlAgkdFoUoWSVbddhkYSS1azY5hiB8u0WTSil2s5jZHbLgxWUrMrT
bHhXzgfj5BACyeMISlbL0ibltQjBmIaqr+N/RIbFo1eleS4H6XoYXT0SXdSB
ypMicHJcQrlu44iSVbY1i3ZJHqbOqHzXkrQ5/roSyVrsJLXOWlPbiIFeTrHD
ogwlq+XUNoLldvK55aEKSlazduNl7QDl2tfs2FpktSwqb1PW4y2PVPL9on8q
qgz33plImY3PfgmrHiH5G/dVUCpZW7WgVHE98zvYZt0Woyi7iRTqGgZOl/FD
yaqD8l3GECVxBmHauSIjnjms0/ih7CSvDuOFktWytG99qGJtD+U6jB9KVsuF
Ngkxil3HOs7biK333NKqMMtXVr4F2eJzDvdW5FpB0fVKNGa9zHEkpXNjucdI
9SzEHq57qIiHsBiBiksikDrrthmxW4iRl8TsbfnMf73kiJWYdRkXQBJOVP7X
H6pY26tai7/+sHxUVgzZrY/URzLr4hHIQG3EThGOcRa2W1gMtWYezWvokK/K
dpy1y/6KHtF9qtvvqwAiOeo+L1D2zpsIBJS+N0FMSEOPzQYoWc16EsGlqBK6
azlTldC9rHsTKFUkKLss8lBKFcqB8o3aAw8ncrLS7LQI61yPEMxT6w1tBxVI
UY4p1yy1uzYjRL30OWKhW1zN7pWms0jMd/v6ZmMfZxSq7LNfrvZJYuwTnDIp
CUXfK1FInVH5XolCwUfle2rSZt6j8j2yzqB2UMJQxvxKhCByiezdD1a6V2M3
45HK3/ZQBQQZqhqvXTIgqctdRhBlFwl2GUGUrDoo35WIbURWM2mD3W0fq5Dg
VZJjtpCPtmIjkxteA7viGfm+OWgRmxf12a9U+ywGUfo+y3YoWdU5UulBQ7Je
y3soe5njeowVSlaznhXLqitRJfTYaDZ65e5Cm7MqlcTwWlQJ3cYLpVShfPdO
Xrof3b0ZwUgwJVba7ia97eh+4/HKPw3BfMe6fy72Mwr7+bSUE4TOivwYfX02
gvuWYh8DD+paXpnofK/MDNQZle9dlSgkI6qgDZXQYzGFUqpQrsc4oWQ1I6zQ
vWEr03c/WrmO9wIgTxY9W5z/HquglCqU79m2Z/ze7dh7LKqv7jUy4gl1NvOR
WLyoz32lykNMbFCuP9FYFDoOyvUtNRBi2/dZjKFkNfRZjKFk1fWtxDdK39/e
kLngXT4HCOWejZj1bBqjzciqgwriPo/VSTiQ0DXDtuG7HWEja2ZwCX3HWo5C
f+UH7D2niOHnBuajihtghADG575aFbtRDYkLSlZDvzFB2c8c1V9r8F959En0
UGd9lt37VmMf81HfakM79DFgeiU/UTuorHddPUKpEnpthKFk1UH5XqOHktUA
5XqNHkpWg7QVGzWzcBt5iQXHYt9xnXCbR5O8dZInVR7kO0N9YvlvAmaAHKj8
gGQfanJxiQVKVtl2/cvqC0qV0G9EULIa+kmkT8ZXnRCwvOfhCuGQkOuz0YSS
1SDtPhlN1BmV79uUNnS5z9j0bUUI2sblPY9LEOoc2LcdyYDhk5j0H4v9rPYf
l71aeHg8DpygoHoijzOdOq/PKRXZXZPaiCYGlESV4JJ/79tf0adBUBuoUXCG
cRtYjgPM0wM2pgZW4gBhCbF+IURd7rcYQtnPLN1v+QdlP3NNv9FC2U86/RY9
oEQwrh9ZJye0KccCCKnHhqikmxahfxs91kjHQZGQRI6goa0n4iCqDkqvU19h
/BBOgwtxkE+cgzbSBpfiIAeZKlkNUN9AawbMc5RSVSWjhzpAuQHzHiWr0g4D
G0TRLxETUFwrmfW9j9FXaIiDp+rldmQ1SLtfEi91eYAUEA+89HFdR7XRZT94
Mu03yBrtMJph6GQcOlXI2XUGbMn48nfsr8BncVuVjCZqByWuB3VeJQxaXAyu
xEGOnEGbzwdXo4rG9fvyzHuNth9NbdnXe9/HKmHAen9gK0IQcTY+BrbjAJPt
gLGAzwO57+r4gOUM2P+7lUHt9TBoY+PwiUg5qc8P4Tef4J3f/0QFODx4hD1F
xrUpMx9ejCr+sGXdz/9pldXssI0YEBEoqiTrUrPqBy1WFA1sTO21OMhYofKD
6/KZda36wQ0juhFVwqCRQsmqg/KDtpZBqRIGt+3IdlTJBplW7jhQQakifVMe
PB6V2aCQIiQUjBkdNRo3DB1H5e98sjiL+pHTe8pB16Y28TE7C7/DMpY+/2dV
qbrDlplRqvjDlplRspodtpUOSpVw2DINysMcW1Bu0MYbSuLLBjcaiGU5QUGF
tsWagkKb7AZlnCkprq/94eO0WAhRZ1QemIZO5nvJiZaE2jDKUKdlrPyR08Wx
uTP26u+yd+5EhsLYDXI7i7o/+LMqq2HIxiPxcSgKv8OSp6mFX6LFPJ3TWxd6
nvQOGy2UrLLtD28a982oEg4bM5SsZoe3ZYWdCSUePx6HAKg8ZNl4SEHpOB0+
GUFHAEG5DzxZEY8LfI6c0Y+5UVSysTOxGGLF9z6FGCvvWG/emI4MLUXwGarZ
eH9//r6AuwFhaBW5wJ4rUKr4IYsilKxmQ8ZlaDMOMYCGLIre/zG5GPcjsqFj
0Q0ZAZRShfKkwABBqTJsLBwqniD425FT0cQGFWE4omgbPZOiplRCHUDGzuo5
6Y3lD+FS3J0opXyPynAtDnPGh/LDFj0ov/DnVfSNjb6hlQhEGP+r0Q2vxp+j
3UOWcVCqhCHL0ChZJQuQPlBBSQ7lYeMyDO+ZnKH02xJ3PlEfI+SBgSJDCiBK
ZSjd+bnr93kWo8MdkTgRIuQicwhwKI2jZ+P4OYqNr/q+zXV7jBr5poi/86MV
YxNyLivxC19DrhIuwzKqqDMqPyxzPjWrbtiiByWrbPthiyCUw8xDwxZBw1tx
mGNo2MbU8HYcJkwoN0yKdx6ooGSVbU+StBilClnKJ+/8vUrKFe4DwBpAEiU0
JBOghHgqUmSgAaty0uYoIw9QJfokxMAz7x0PrDqPTpzj0WLGb7UH1uopJ99/
HVmOIwRLVR6RmRJglTGI+hHLVagTMCMPXbEWRwT0CBnj6T9xHtmII5wqc8ab
wtiNMHOxoYyZhRGrIxarKFnNRmw1MXI8QtA+bm9IcngalP7ISaLjrzKWhWyu
2ep09KOWusZkmGoUhrs/UQHNMWHpgFTOZpCG//JUIfonz1u0X0n7srtEbfOz
dtozyzOe0oWEEVuToQTS//71ak4WJathxGaBkfU4wqUplR+RlSm1gwojFqso
RxirI1sNBOtEj0WBCaXj8QO/2/jUfZeE6BGuzKGyIyf1cwY2UGWjp+ox98Hf
191ZspUzNf2VwphGaWY0SwE4J5I4o1kKU+ftWtNgy4BtXpXs2G9sfvbMv210
ZCUeIcyc6OoOohqentF5xJ6ZlSrEH7HYRHmEYUnlj0hUUgcqfyRtKdiK4q4D
xbWyP2JZFOzIMKiSfEmEmE1GT0ZHgMLqVBw9lWZdABwTEXYlf/fHK8UYLX/o
E7yTjndm0bPR2Xi/Dtzy1YpZo3F53W6s7nqwUvAhf2+mOzF3PZba+nygPh9B
3GRU4iSMp6tQftTW8ihVwqhFDUr6p/5+MF9r8VfZmE2i6iPEHz0j3lzLKAiT
5wt5jUESPvxJ+/zMBY2fWS3lRWhhb7p5dXbF3oj4nIgvjkSNmiOYO0fxc2RV
53qUo2uUP/yLKuy3ETi6Hkc5W0D5UYsWlKyGURuBo1txlNFC5Ue34wcfr4xu
a9WPWh5DSXph1KIFJSFmoydybmNECMUeCGM2tlAeRVUJjaeZFONJ3/BMnI+T
SWTWnbqgmcyIla6avVinOv8MedbZNeewXfZQd8TUTakNfqPMV6M22hSg0fvD
b1RH13VvGmXI6W1GAadKxpqC24p+1HIWyjHG3pjRGzsexwgOyo1Z7KFUccZM
GDGkxnVpJnsTQFbyE2ctCemOIAONv7SAc8atFKYv1FmRYCnMJHr3PSOzspu/
mOaDH4li/ncQBXoShaP2XlUJQsbW4//4RtWN2Ww6thHHmPmh3Jit/VGqhDHL
/WPgxtw/ZhzBjwgdlB873sBSOLJ9QP6VroHyR22EHpWoGz8dA1hKxsgAckIE
DWouOIQwKLopnSUFYPbb+ai9GBl9wiubSyRBcP7ltBZc/FQxQ8jXmXNq2WuJ
RuGxGlXCmI1e0CNApQicY7q57lGGMRu9YCf4VEneE3yqjsWjx2Li446eND4n
o4o7yjw3fipe0W8X0wE/bmN3XEOR3ZoBmWMAtk2eq8fYPU9V7nm6wjAkQTkR
pc6PmvscifJaMxfyWC15BUu2EpNAK8czck3/Fl+2p5FwJfXxlV3ek7ZgfG3T
eW9IbZAVuKrW492PVBJhxmbJ/8+/5P7vUVaPbubZXZ6Vj2LmOGpRN34ijgNm
Nm7zBhCOc96AaruSvv0ycSbFnKPyk2fjPZ+oTEpVM2BZ5onpwsxBYhy7vKgn
ouxL/6ea//Yrf19VZl9Fxf9Xib79n6oY1z/9e56pFPDDEbFHXqG0+wzEQ+S3
r5RyFAFtxaMMMFHj23H8mEYmyjB+vM6IyW48MTspzBwUQ06OTZyKE+Q2gXWu
2UFsACRJkKwyqqBxh4j78FOSyWSG9Rpx5OemdQbxL3yvWmp7ITFTeNBfRkVm
FgSZEFx42Z4WF1PU1S7Fpm/bG8W0nmt4z5JeI5cKjR/4/o7jXudBDbBxETfO
cfxHf0UzWQ3jWzhme20EK0KuyvB4JF5lPC57RxPEC+UnLBZRkqmHKpfS3zBM
fpyxQu2o9oEvuKoo6CnIOduje/671edfpJTCF1+synfMyNUjMG1K0VkEATon
Im0PtpoHFy/F/Z/mDZeMqQfcj8oRpQgO1+Vr5T1EaMMRUsy/Mz2+HlX8uM3Q
BCskLUOCKARxhxl63GaWie04we1LKj8hq0NqB+UnLF5REmmA0iePe+o7lZM2
06Ck4MmBVCUeP1GBlMLz36nKp8pg+UXIixQd6cFiVcb5rM7IkgXnLCa9ZkJq
+d1iikzgbIjVfQ0sd/y9UUuWPOGn0pmKDqwSu01h5yY2ke85o/zx/2JksppN
JHbHhJ2DEnRe4RGbg5LvgoVJeeKCfu5b1ey5b+vge/7vqpCSo8qmPl4xVgLN
VvbTMs6pScnNnDfP7y2upWdtVpktzNCBgZiw+URxQURzWaJYLlJclrp+O0H/
LuZKenOzB56+6XP5PDOxESeIFIos9dhmZDVMbNVjcJvMtiNZItEdK8yteMqV
b5Q897dVuSdKoIT4578Fms9/m/0yxakayk/ZthVKjOPpszKOM2L0MxJz1KzK
XxbwOYTgynOF1bXy88X8uHBJSZaBLoeGSsqUfvly+vzrWhLcy9+u7caPV309
z3num1X/3N9oBE2diFNMc6okxqhZ9VO2bkE5TRzTuvZz05xwgWJGly4OZVYg
IRbNpURmkXMxjT+X57QFCS4gSXHklQrBCLHa5R1Urm1NpfDUm+aUctOZr7fj
YZLRMynPGdQOKkzatwUQMCpTHI9TNhZRshqmThgoHDJmTmBNCzfqbPq0vrUJ
MzINQEMykgr3PlUBpVkR4ciomUPGSus1f788j0mWgpKMBjzMVpK1CGbf0uV6
hNWk/sBnKstK6vqWdG5sQUJz7WZUERzi6XacYlKiClMyeqYERpazQLwwL0G5
aZsfUdL3MC0s8v023TmYORMVgiKRteu5OMvdXyg3e96+5wgYc0kkquZI56Ku
QRgzaX3hNWIWGSU5mcsWUyCSB4tbuRyL2eZ6y+26p3RTE5X8GXZqM04RhypZ
/1M7KE8k4fm/ruZB4ab5Y/MbSlaDcJnOd8gs3xbeM7mZ04gJ24UElVmuaKE8
sUgeVkI6S86dj/c/XSGWjMrGUn7lTB+gLDGXNNOkWa7ksWxYvFR/VigDVU3k
o5+paAi5ZaPnV15JV76pgdXrm1jle0hgREwOykngTAsv6jBNVl/8JlkBEiRM
21zmZ05FEJhhelEla9NZAoEiCaWgZHIq9z+V750TihMkHDAXosnFxGzhYgIS
jIbMVmn11JZTyIeQXNnGkQMIlm9ooPCG3ShMb0X12FaZ8FxFZ+B7f6/hmdbf
+0Rl5mSc4Upoxlbts6fjLEFAuVmLC5T0PgiCuXyP35v3Upk/HyEIgQuWLS7G
PK+K+25R8wgXOnL3fej2Js/h9PIrNrYefLYC31df0Qz8xh/qv+7B35vvgLoZ
5okXvlmdOWFzw4kYZixPzJ6Ks3QYys2erntu/Y4Vh8QBfIXISnsOM4s4WOzl
BZti2Mmh4J8czGdVT/+y5eQk/aRX8E57YTWP9Z9p8PKnmry8IWXLme2oEmaO
6Rc64avJifjC31RnxWXqMIuZYfZUg9f02M2Z13CUvro5203xcHReBPMjo31e
1hjUrDq4nKX+9YsX4/5nKvI8v6ixTe9d7VJDDlTxNqwlqle1fFODv29s5a/k
pWORjjoqDydnj2uPonR00n8puSz+Qp2KcyJMSvCUPejnGb0feapS8M6JWwvi
IXXyLoNjjFe5+9LLec7y7FMeq8lCyUaR9ix1cdRKT+Vd683jNzd4/NNNHl+f
enj2WFTxszbbwT+6KP5mX/7b6tzJOCfzP3WAq/JXhvM2YuEr3XVQ2osLskCi
zhbsCWURs9qipSmUkCWskeht+J209wV/M+vNbPlyw8iki6kfxb3VV+Paqzpa
f77By59p8jLfJVMXtR/n+Np3TjoRmnIywk3dJ7q/OGPNW+TCV3FXlWSlBfoM
FRYsT8NX6Ve5yv6neZVFmdST927pYt7LS2lfik+02slaDctpKJcsM3M+D/U5
Chevk3iVRxOJX2jyXdbSpZ/djcicRrbOTfMn47xO3Q5lEL/nJS9RuwU8mS7Y
/AR/6bJbsKf88uL5CA9VlsTjjJ6GpcI+nKshY6UwXi7MzAEuroiU6jMQ+1rO
tJiW8QA3Wf5SSy/f1HT0Wlv3Isccj9rJ8Mz2zOnsyfgV9Pi8ZSv4S5fdArLV
gsU1SnFZ1OLZuKjrfsnBizYTLanHniosyQplSWJbY6kmBKDhOTtWYrvQnw89
W7H+LPmHPluxvkye/kpLT9/carUrPhyPdNBDuXmbe+gmH/MWuFBdkDUqNCSI
l4vSw/DNdhrhIjxbonOqpDepnbp5MdZEdD6GY2755Txml+Ux2NZU0p/UjF/2
p7ehW2rTqH34s5W1FL7rFsH/fE8e57uy8HRe+hXzzoLtScPTr36rCi3uSr45
E1V0ztGeZGe6pXPmKHzkyIUSP0NN/IauWU967Uk6S4/FYVrwoO5FBVlzr4rP
KXTF18y6VP5J365r3/7Llp7+3G59u3Ai0kEvXi7IQFVH3eJpzbD7P65bH3Tv
bFzShVMGD92SxWrtfKRfvmarpmVk4GWbd1DSJbdyyfyFQ6siGIvaf/lcusYf
9SKYN/+qpTc/3+oobYQXKosn098SwQ3tJPYFF0XwQPuHB85FVgM8KJvlavXF
mHrErdCTlTx36jMC2qu5I2K/9NMrxbOSPzKuzZ9/09Kff9biqM5uzCKLMrr+
5NtVxBH6ZMl2UpakMyC+dq7eD4y2mu1J+QdkT2qZy/rkGbxRh+yZZhVzI2yX
Nd+azffrKa5odSlsvFrPtv/O5kR9En5Lk91Xp36A3SpLdGDJ5jpYTuMdlYfh
NY0lhzLU7Hs2/oGnKzCbNrvlC3lvrNB8KPaGvGNctXFSiCVpP/ysjhv64tdf
ieaL9hoaG7l8XzPD2xs8ap7p8r8KWlJfwpKN/dqZqOJrNnvV6lkcqykZ+9Se
XoSVC3Rh5aLOReqH5Gz4kduOcu2y7QXmfQEXxIuiB6iZB/zYrzV48ItNHuR/
GwbLabyrYSaqnWnwQnfj3PI55B8b0zSYfQBF7pLhwurLEfauylhg5OCImKyi
/bemBnNdtd4cTwwlnvUfGyxunnfzv0+FpSb2lq9UXj4bYaWKAg4riPaVC3Wr
+dZuVffJaLBECq1Yu9Rg57oM3HULE0k4eZR72Ok2vy/M39lg6y+3sFVzHon+
+Xf4dE4bkWNgoVuxTQfYqEJL3eoFi2HLkSjXaOSa5kgH04SdVwM3rOrY8zxh
89UI48y+d7WK2JZ26lg6E2mq2gsz1eQVjMAV2nveVvznI4xc1XzuQdPBRrdm
9pIkc/pa2vV/RB73YbZZ7jZ0VqbFfjNZ/X0DfGtLi5vXJPuaLPYrHGdf+051
xXZJWXoYvCqiu/MZrb5oIgfE5rWm7A171VgNAsTlK5oBxdbcUPy7raWtb93N
VthIMx1V+Np3zdZVfZfKfle6gpYxumZZGVbSUBIOFpx+w7LChkaAZIXNQgS8
Grc0Am5vaWPziid/HwXbVkU0Bs9jhNjogTViEFTdEsuzsIYGOajUu6TltnRE
v7elDf+i6Wj5SvqfD4Hk69+tQq/ad0RQhrULOmmrHZB1WRs9Yu+PxZa2jUtR
bdmQvmPllfQMuynzr0Ayu+5oaVfzGkn2tq/SnlL5+otVWLQmxlGLbQSzXn+7
6Gie35DYonZQ0mths7CnTKNIST6CcstWpHe2tOxtTUezlAth09o5GvQXL2Id
QJOyNVlLQq9fELOC2eQ2kPU2LOuhhDWbl+25AcZsJfHG6K6WljSvvHJL1s6b
GTTCrVtMP/LJyiPPUBxN8RvSc9S0hmTcpq0AyzAmt4FMEp/tPAN/aO8WSY48
H9dTBgi4/UYSMcMbBfbQZnqKoA0iiBQLn+36SuG3Wt7/Xzcd5bshffv0je9V
wWFDRed4FOL5plmwWX8y9XJb9VzFbb/S4P9vt7x/89oxf1v1l9+r6r39huUT
lLwx767rka1LyV+5O1HhniqPP6vji/8vLGc6XZP+26a75e8a9W7q4abdb7Ow
u7RlkbeVELvty+IhT9zfdFVZnciqsnjUFe4lt9i0d9Bb8IfXF/svRxPrwAda
XvtXd7v2x56pf3N8y3oJJS/vqPz2JbuBuEM6V+d03i4BmF9VjvE6eKqTa21J
d2/zWlBCAO334byb8CHZIyz9+6Zr4PYwyW0h3bXhItuQSxS90LZNB++wa7xt
5zVK6X+tdNu4Br+uYheg/b9sn7tVTvy1nIp+iCfz6m+ws36rcJZ+v0m/Maav
BnnGY3LGOwpn8KsjbVCfy3/D/3fpD6TF/6eUX5SS/5mz4f9yLv3E/wPaRlYi
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->11665159]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1696],

Cell["Here is a list of values:", "ExampleText",
 CellID->251101490],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", " ", "4", ",", " ", "3", ",", " ", "2", ",", " ", "1", ",", " ",
      "0", ",", " ", "1", ",", " ", "2", ",", " ", "3", ",", " ", "4", ",", 
     " ", "5"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->839043382],

Cell["\<\
Fit to a quadratic. When coordinates are not given, the values are assumed to \
be paired up with 1, 2, \[Ellipsis]:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->729431391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"quad", " ", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"v", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", "x", ",", " ", 
      RowBox[{"x", "^", "2"}]}], "}"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204450147],

Cell[BoxData[
 RowBox[{"7.272727272727274`", "\[InvisibleSpace]", "-", 
  RowBox[{"2.0979020979020992`", " ", "x"}], "+", 
  RowBox[{"0.17482517482517493`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3607914]
}, Open  ]],

Cell["Fit to a quartic:", "ExampleText",
 CellID->66078004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"quart", " ", "=", " ", 
  RowBox[{"Fit", "[", 
   RowBox[{"v", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", "x", ",", " ", 
      RowBox[{"x", "^", "2"}], ",", 
      RowBox[{"x", "^", "3"}], ",", " ", 
      RowBox[{"x", "^", "4"}]}], "}"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5245654],

Cell[BoxData[
 RowBox[{"4.545454545454524`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.1888111888111885`", " ", "x"}], "-", 
  RowBox[{"0.9382284382284347`", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"0.13986013986013923`", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"0.005827505827505799`", " ", 
   SuperscriptBox["x", "4"]}]}]], "Output",
 ImageSize->{384, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->98221838]
}, Open  ]],

Cell["Show the data with the curve:", "ExampleText",
 CellID->382894155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"v", ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"quad", ",", " ", "quart"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", " ", 
       RowBox[{"Length", "[", "v", "]"}]}], "}"}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->153480539],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->306179748]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23850],

Cell["Here is some data:", "ExampleText",
 CellID->20344755],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165185234],

Cell[TextData[{
 "This is the sum of squares error for a line",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    StyleBox["a", "TI"], " ", "+", " ", 
    RowBox[{
     StyleBox["b", "TI"], " ", 
     StyleBox["x", "TI"]}]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->91398702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ss", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], "=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "=", 
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ",", 
      RowBox[{"y", "=", 
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ",", "res"}], "}"}], ",", 
    
    RowBox[{
     RowBox[{"res", "=", 
      RowBox[{"y", "-", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}]}], ";", 
     RowBox[{"res", ".", "res"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->858530513],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "a"}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"4", "-", "a", "-", 
     RowBox[{"5", " ", "b"}]}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "-", "a", "-", 
     RowBox[{"3", " ", "b"}]}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "a"}], "-", "b"}], ")"}], "2"]}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92102714]
}, Open  ]],

Cell["Find the minimum symbolically:", "ExampleText",
 CellID->354736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"ss", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->763678291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["96", "59"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      FractionBox["11", "59"]}], ",", 
     RowBox[{"b", "\[Rule]", 
      FractionBox["41", "59"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{155, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->863130470]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}]}], "/.", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->235091458],

Cell[BoxData[
 RowBox[{"0.1864406779661017`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.6949152542372882`", " ", "x"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->51145423]
}, Open  ]],

Cell[TextData[{
 "These are the coefficients given by ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->153685526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->210850061],

Cell[BoxData[
 RowBox[{"0.18644067796610175`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.6949152542372883`", " ", "x"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->388745514]
}, Open  ]],

Cell[TextData[{
 "This is the sum of squares error for a quadratic ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], " ", "+", " ", 
   RowBox[{
    StyleBox["b", "TI"], " ", 
    StyleBox["x", "TI"]}], " ", "+", " ", 
   RowBox[{
    StyleBox["c", "TI"], " ", 
    SuperscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["2", "TR"]]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->38465746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ss", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], "=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "=", 
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ",", 
      RowBox[{"y", "=", 
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ",", "res"}], "}"}], ",", 
    
    RowBox[{
     RowBox[{"res", "=", 
      RowBox[{"y", "-", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ";", 
     RowBox[{"res", ".", "res"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->69843954],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "a"}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"4", "-", "a", "-", 
     RowBox[{"5", " ", "b"}], "-", 
     RowBox[{"25", " ", "c"}]}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "-", "a", "-", 
     RowBox[{"3", " ", "b"}], "-", 
     RowBox[{"9", " ", "c"}]}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}], "2"]}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->391122698]
}, Open  ]],

Cell["Find the minimum symbolically:", "ExampleText",
 CellID->579390564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"ss", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->781445857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["128", "199"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      FractionBox["135", "199"]}], ",", 
     RowBox[{"b", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["53", "199"]}]}], ",", 
     RowBox[{"c", "\[Rule]", 
      FractionBox["38", "199"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{243, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->132645014]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}]}], "/.", 
   RowBox[{"%", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->50189283],

Cell[BoxData[
 RowBox[{"0.678391959798995`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.2663316582914573`", " ", "x"}], "+", 
  RowBox[{"0.19095477386934673`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->6673334]
}, Open  ]],

Cell[TextData[{
 "These are the coefficients given by ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27323165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->903491024],

Cell[BoxData[
 RowBox[{"0.6783919597989946`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.26633165829145716`", " ", "x"}], "+", 
  RowBox[{"0.19095477386934664`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->557419698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110206816],

Cell[TextData[{
 "When a polynomial fit is done degree high enough, ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " returns the interpolating polynomial:"
}], "ExampleText",
 CellID->39371633],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "2"}], ",", " ", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", "x"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->128690991],

Cell[BoxData[
 RowBox[{"0.9999999999999998`", "\[InvisibleSpace]", "-", 
  RowBox[{"2.06666666666667`", " ", "x"}], "+", 
  RowBox[{"1.2000000000000024`", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"0.13333333333333364`", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393131062]
}, Open  ]],

Cell[TextData[{
 "The result is consistent with that given by ",
 Cell[BoxData[
  ButtonBox["InterpolatingPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingPolynomial"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->509071374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterpolatingPolynomial", "[", 
  RowBox[{"data", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75800833],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["2", "3"], "-", 
        RowBox[{
         FractionBox["2", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", "x"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}]}], ")"}], " ", 
   "x"}]}]], "Output",
 ImageSize->{234, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69993669]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Expand", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->302291909],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "-", 
  RowBox[{"2.066666666666667`", " ", "x"}], "+", 
  RowBox[{"1.2`", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"0.13333333333333333`", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->779571662]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30888],

Cell["Here is some data from a random perturbation of a Gaussian:", \
"ExampleText",
 CellID->196081406],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"100", ",", "100"}], "]"}]}], "}"}], ",", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"r", ",", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"r", "-", "50"}], ")"}], "^", "2"}]}], "/", "10"}], 
          "]"}], "+", 
         RowBox[{"RandomReal", "[", 
          RowBox[{".1", ",", "100"}], "]"}]}]}], "}"}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"lp", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{"data", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->200469894],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWc1vFVUUH97MdNpXXiHWb0ptgjFukI3RxIItFKggKiVpniYUfRBjWQgE
S1wY41IXfmw0ESoKBjUGExcQSFyRmBBcGLeu+UfGc++5c++Z39y5ffOwGJt0
Zu655/v8zrkz7Su9leW33+2tnDzRm5o/2zuzfPLEe1P7T58lUrwhiqLr9PvB
oxE95/Skf6/nOd3ldZ+6Jmqv+GnRYqu5x+Y+Cespnyw9tNQtdpTH1GVIcvj5
Hu+Tb6smz9FVmY1Sy8sP0ZZ1s1dQo4KrFHe/dreY/FU1PKFve2v3lWTs3Zlo
FEu9Ba0nlUiIPFqaZc6PrgJNrTyELonSbaD98wB1RFN/uPLXzK7zn336e/Rw
sSZGtX4A9rfDug3rTbBOYT0Ga7Q/xHGoZEbDRT7+uHP39KlrN2/8nShK1l38
kYj75r6hFT2TJD3rfOj4SpZJlEgkytpE/NpSW2qX6rhO1gNLT31acJ3JGlr1
laprXQntv979idOdAUdScKgAdciWYnSatk5cHiKW2izDYo2Wx6abs8PPPB5i
X32HpS72d2bX17StI2qz3rnZVZaxwmz4EZ0Wq8HuZpXqPq0pzCCz7bzR3g1L
A9IbrEVcIMDkarTsiXU7plsUc9GtHF9NXtlcR1E2Sv/4+f1zN0njq4cuM5FE
Wlqj8pg7vgNxtGCtKxYfOniJ1rtnVqOnypkglhHhzezMBXKfc4P4d+sWrCeE
ziMLV8hd9pK1WbSZuBlzLKoxMG69lU7IfrGJ1bIXqSYMR9Pz9Z7F5Wjndq9i
fiYFB3sQFxku9aGrNa4RCy1YTxSThX2ijd5bvywd/dnq4uxkshMAl8bf5Xd+
jXRmR0nPJx/fosczp67J/CAOhJfF2JMQt8+MEquSpdtVtbJAmGudySGIU2Uc
8qm7Nj63coPoby5drcxxnPsx8GO+NT/P001sfc/sBRui8fjF8/paApbpDbfW
nozKCSvnz0vz34XkNsrIybWPPvxNjhJ2dtKHlUSiWr+pJXu0RVGbFCIzZw4g
PbVyJS7IJfs/DrNOzhlL+erL23I6G68TbxTOiun0TGolIJSkHdZSn7ZMtr/T
/CTwal2dKqSpU6og52x0vr/8JwEBjqtqDkzusM9J+uWDlw7svxghrr1Tkz3E
c4ytvaFOF7Ucq5w98sxNA9MBe7Bd8FrdsIeTryPzLHsF34FGihOOz8QD89/y
hn/6OSv6LB6FPNv5j+cUZJupKVYGo+b8eQ+MqHgPxTMCz27oXtpog9w4RDZc
9K6dkRoR2fHeVU/PtEUX77W9gF2c+XzF94ri3KycRBjZmKdb1DmQAX0zrDuw
HgevdMbc+wuRUEMb1mgRe57jwe+IWV+lEnmA7vTKhb5K6qmKGOJ5MHdfR/Ir
NC7eiysSOm+lb7sUZFFuJ2DstRo9/vdR1OMqVqcHvwoUghTDNGS+iXw/eUj8
lNqcD5k7fiP56zUNWTxcqvE05OZwQIfLgJ/rBbC0EOByFkNczuJCyevBMC2p
+H19LMDlfD1W8mI7+OjX0XcXVf7K4a9vc/yHcJeYu8tqDT5Fn/brV5qHcNqU
v8gVdpk/2m2G+4sGNXkGMLEU4HKYCHE5bCwN7NVg1MGs+Ka6emxSxbWn2Q7I
89FGmpSiHVCDZhqqvrg6hTTFDbFc+QtTENOt2rl//1DzX9pey8r9wea/Lymn
2ppTdl19G+z94bm83K2LpYo9n5c7cTGgw3WZn+v/jk77n5C+0PkQUOM+q7i+
cg6hze08m5eR0r0nPQ5TXZvhEHpZymGsu0ZFXaT835xowz9TxOcu\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389918615]
}, Open  ]],

Cell["\<\
This is a function that gives the standard basis for polynomials:\
\>", "ExampleText",
 CellID->296749167],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nbasis", "[", "n_Integer", "]"}], "[", "x_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"x", "^", "k"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40337129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nbasis", "[", "10", "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->723530217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", 
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["x", "3"], ",", 
   SuperscriptBox["x", "4"], ",", 
   SuperscriptBox["x", "5"], ",", 
   SuperscriptBox["x", "6"], ",", 
   SuperscriptBox["x", "7"], ",", 
   SuperscriptBox["x", "8"], ",", 
   SuperscriptBox["x", "9"], ",", 
   SuperscriptBox["x", "10"]}], "}"}]], "Output",
 ImageSize->{262, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1922713]
}, Open  ]],

Cell["\<\
Show the fits computed for successively higher-degree polynomials:\
\>", "ExampleText",
 CellID->515287132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fit", "=", 
     RowBox[{"Fit", "[", 
      RowBox[{"data", ",", 
       RowBox[{
        RowBox[{"nbasis", "[", "n", "]"}], "[", "x", "]"}], ",", "x"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{"fit", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "100"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", "lp", ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".25"}], ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"\"\<n = \>\"", "<>", 
        RowBox[{"ToString", "[", "n", "]"}]}]}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10", ",", "40", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22502136],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 248},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->594219890]
}, Open  ]],

Cell["\<\
The problem is that the coefficients get very small for higher powers:\
\>", "ExampleText",
 CellID->45477658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{
    RowBox[{"nbasis", "[", "10", "]"}], "[", "x", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->492886621],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.52678967952173`"}], "+", 
  RowBox[{"0.37873927250325296`", " ", "x"}], "-", 
  RowBox[{"0.0866647585972506`", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"0.009583018437347745`", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"0.0005888299700251398`", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"0.00002161518279690078`", " ", 
   SuperscriptBox["x", "5"]}], "-", 
  RowBox[{"4.912505886609058`*^-7", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"6.959288130289361`*^-9", " ", 
   SuperscriptBox["x", "7"]}], "-", 
  RowBox[{"5.97603509239826`*^-11", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"2.845270289025644`*^-13", " ", 
   SuperscriptBox["x", "9"]}], "-", 
  RowBox[{"5.762532411451332`*^-16", " ", 
   SuperscriptBox["x", "10"]}]}]], "Output",
 ImageSize->{583, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->17924533]
}, Open  ]],

Cell["\<\
Giving the basis in terms of scaled and shifted values helps with this \
problem:\
\>", "ExampleText",
 CellID->279734829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fit", "=", 
     RowBox[{"Fit", "[", 
      RowBox[{"data", ",", 
       RowBox[{
        RowBox[{"nbasis", "[", "n", "]"}], "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "50"}], ")"}], "/", "50"}], "]"}], ",", "x"}], 
      "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{"fit", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "100"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", "lp", ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".25"}], ",", "1"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"\"\<n = \>\"", "<>", 
        RowBox[{"ToString", "[", "n", "]"}]}]}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10", ",", "40", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->890800062],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 248},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->321858534]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11668],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindFit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeastSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeastSquares"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PseudoInverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PseudoInverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3944]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26168],

Cell[TextData[ButtonBox["Manipulating Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingNumericalData"]], "Tutorials",
 CellID->26150],

Cell[TextData[ButtonBox["Curve Fitting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CurveFitting"]], "Tutorials",
 CellID->16983]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->17218],

Cell[TextData[{
 ButtonBox["Demonstrations with Fit",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Fit"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#20880"], None}]], "RelatedLinks",
 CellID->17340],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Fit"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->683027344],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CurveFittingAndApproximateFunctions"]], "MoreAbout",\

 CellID->109306605],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->137084454],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "MoreAbout",
 CellID->85324052],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->188572973]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 24.0940600}", "context" -> "System`", 
    "keywords" -> {
     "approximate formulas", "approximation of functions", "chi squared", 
      "curves", "data", "fits", "fitting of data", "least-squares fits", 
      "linear fits", "models"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Fit[data, funs, vars] finds a least-squares fit to a list of data as a \
linear combination of the functions funs of variables vars. ", 
    "synonyms" -> {}, "title" -> "Fit", "type" -> "Symbol", "uri" -> 
    "ref/Fit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11603, 396, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1377790]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 101338, 2716}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3130, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3753, 96, 41, 1, 70, "ObjectName",
 CellID->23747],
Cell[3797, 99, 795, 25, 70, "Usage",
 CellID->20499]
}, Open  ]],
Cell[CellGroupData[{
Cell[4629, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5107, 146, 821, 27, 70, "Notes",
 CellID->18767],
Cell[5931, 175, 425, 15, 70, "Notes",
 CellID->22534],
Cell[6359, 192, 254, 9, 70, "Notes",
 CellID->8399],
Cell[6616, 203, 1621, 60, 70, "Notes",
 CellID->31512],
Cell[8240, 265, 1150, 42, 70, "Notes",
 CellID->21501],
Cell[9393, 309, 1219, 47, 70, "Notes",
 CellID->16640],
Cell[10615, 358, 578, 19, 70, "Notes",
 CellID->17934],
Cell[11196, 379, 370, 12, 70, "Notes",
 CellID->30992]
}, Closed]],
Cell[CellGroupData[{
Cell[11603, 396, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1377790],
Cell[CellGroupData[{
Cell[11986, 410, 148, 5, 70, "ExampleSection",
 CellID->414965136],
Cell[12137, 417, 61, 1, 70, "ExampleText",
 CellID->430527260],
Cell[12201, 420, 393, 14, 70, "Input",
 CellID->25679113],
Cell[12597, 436, 80, 1, 70, "ExampleText",
 CellID->96581851],
Cell[CellGroupData[{
Cell[12702, 441, 227, 7, 28, "Input",
 CellID->98035656],
Cell[12932, 450, 262, 7, 36, "Output",
 CellID->133191716]
}, Open  ]],
Cell[13209, 460, 133, 2, 70, "ExampleText",
 CellID->10655736],
Cell[CellGroupData[{
Cell[13367, 466, 274, 8, 70, "Input",
 CellID->301796045],
Cell[13644, 476, 339, 9, 36, "Output",
 CellID->529749515]
}, Open  ]],
Cell[13998, 488, 77, 1, 70, "ExampleText",
 CellID->276178247],
Cell[CellGroupData[{
Cell[14100, 493, 444, 14, 28, "Input",
 CellID->28450773],
Cell[14547, 509, 3140, 56, 146, "Output",
 Evaluatable->False,
 CellID->53030813]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17736, 571, 216, 7, 70, "ExampleSection",
 CellID->14864],
Cell[17955, 580, 86, 1, 70, "ExampleText",
 CellID->18284782],
Cell[18044, 583, 665, 22, 70, "Input",
 CellID->310923059],
Cell[18712, 607, 181, 5, 70, "ExampleText",
 CellID->753871874],
Cell[CellGroupData[{
Cell[18918, 616, 370, 12, 70, "Input",
 CellID->635366557],
Cell[19291, 630, 454, 15, 49, "Output",
 CellID->27823509]
}, Open  ]],
Cell[19760, 648, 92, 1, 70, "ExampleText",
 CellID->149847150],
Cell[CellGroupData[{
Cell[19877, 653, 425, 14, 70, "Input",
 CellID->266507236],
Cell[20305, 669, 457, 15, 49, "Output",
 CellID->48006382]
}, Open  ]],
Cell[20777, 687, 72, 1, 70, "ExampleText",
 CellID->122496759],
Cell[CellGroupData[{
Cell[20874, 692, 325, 11, 70, "Input",
 CellID->493468576],
Cell[21202, 705, 2404, 43, 70, "Output",
 Evaluatable->False,
 CellID->757222865]
}, Open  ]],
Cell[23621, 751, 125, 3, 70, "ExampleDelimiter",
 CellID->191497276],
Cell[23749, 756, 77, 1, 70, "ExampleText",
 CellID->550542185],
Cell[23829, 759, 594, 19, 70, "Input",
 CellID->43222121],
Cell[24426, 780, 129, 2, 70, "ExampleText",
 CellID->66083099],
Cell[CellGroupData[{
Cell[24580, 786, 305, 9, 70, "Input",
 CellID->335676179],
Cell[24888, 797, 297, 8, 36, "Output",
 CellID->255100191]
}, Open  ]],
Cell[25200, 808, 78, 1, 70, "ExampleText",
 CellID->39616490],
Cell[CellGroupData[{
Cell[25303, 813, 768, 22, 70, "Input",
 CellID->280137527],
Cell[26074, 837, 4861, 84, 70, "Output",
 Evaluatable->False,
 CellID->258578052]
}, Open  ]],
Cell[30950, 924, 85, 1, 70, "ExampleText",
 CellID->40504194],
Cell[CellGroupData[{
Cell[31060, 929, 430, 12, 70, "Input",
 CellID->686435202],
Cell[31493, 943, 522, 14, 36, "Output",
 CellID->321090908]
}, Open  ]],
Cell[32030, 960, 88, 1, 70, "ExampleText",
 CellID->218938156],
Cell[CellGroupData[{
Cell[32143, 965, 767, 22, 70, "Input",
 CellID->266566092],
Cell[32913, 989, 11619, 195, 70, "Output",
 Evaluatable->False,
 CellID->11665159]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44581, 1190, 238, 7, 70, "ExampleSection",
 CellID->1696],
Cell[44822, 1199, 68, 1, 70, "ExampleText",
 CellID->251101490],
Cell[44893, 1202, 326, 9, 70, "Input",
 CellID->839043382],
Cell[45222, 1213, 215, 5, 70, "ExampleText",
 CellID->729431391],
Cell[CellGroupData[{
Cell[45462, 1222, 277, 8, 70, "Input",
 CellID->204450147],
Cell[45742, 1232, 335, 9, 36, "Output",
 CellID->3607914]
}, Open  ]],
Cell[46092, 1244, 59, 1, 70, "ExampleText",
 CellID->66078004],
Cell[CellGroupData[{
Cell[46176, 1249, 355, 10, 70, "Input",
 CellID->5245654],
Cell[46534, 1261, 490, 13, 36, "Output",
 CellID->98221838]
}, Open  ]],
Cell[47039, 1277, 72, 1, 70, "ExampleText",
 CellID->382894155],
Cell[CellGroupData[{
Cell[47136, 1282, 471, 15, 70, "Input",
 CellID->153480539],
Cell[47610, 1299, 4003, 70, 70, "Output",
 Evaluatable->False,
 CellID->306179748]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51662, 1375, 233, 7, 70, "ExampleSection",
 CellID->23850],
Cell[51898, 1384, 60, 1, 70, "ExampleText",
 CellID->20344755],
Cell[51961, 1387, 394, 14, 70, "Input",
 CellID->165185234],
Cell[52358, 1403, 286, 11, 70, "ExampleText",
 CellID->91398702],
Cell[CellGroupData[{
Cell[52669, 1418, 716, 25, 70, "Input",
 CellID->858530513],
Cell[53388, 1445, 585, 21, 36, "Output",
 CellID->92102714]
}, Open  ]],
Cell[53988, 1469, 70, 1, 70, "ExampleText",
 CellID->354736],
Cell[CellGroupData[{
Cell[54083, 1474, 231, 8, 70, "Input",
 CellID->763678291],
Cell[54317, 1484, 395, 14, 51, "Output",
 CellID->863130470]
}, Open  ]],
Cell[CellGroupData[{
Cell[54749, 1503, 224, 8, 70, "Input",
 CellID->235091458],
Cell[54976, 1513, 260, 7, 36, "Output",
 CellID->51145423]
}, Open  ]],
Cell[55251, 1523, 257, 9, 70, "ExampleText",
 CellID->153685526],
Cell[CellGroupData[{
Cell[55533, 1536, 184, 6, 70, "Input",
 CellID->210850061],
Cell[55720, 1544, 262, 7, 36, "Output",
 CellID->388745514]
}, Open  ]],
Cell[55997, 1554, 404, 15, 70, "ExampleText",
 CellID->38465746],
Cell[CellGroupData[{
Cell[56426, 1573, 797, 27, 70, "Input",
 CellID->69843954],
Cell[57226, 1602, 669, 23, 36, "Output",
 CellID->391122698]
}, Open  ]],
Cell[57910, 1628, 73, 1, 70, "ExampleText",
 CellID->579390564],
Cell[CellGroupData[{
Cell[58008, 1633, 251, 8, 70, "Input",
 CellID->781445857],
Cell[58262, 1643, 493, 17, 51, "Output",
 CellID->132645014]
}, Open  ]],
Cell[CellGroupData[{
Cell[58792, 1665, 284, 10, 70, "Input",
 CellID->50189283],
Cell[59079, 1677, 335, 9, 36, "Output",
 CellID->6673334]
}, Open  ]],
Cell[59429, 1689, 208, 8, 70, "ExampleText",
 CellID->27323165],
Cell[CellGroupData[{
Cell[59662, 1701, 220, 7, 70, "Input",
 CellID->903491024],
Cell[59885, 1710, 339, 9, 36, "Output",
 CellID->557419698]
}, Open  ]],
Cell[60239, 1722, 125, 3, 70, "ExampleDelimiter",
 CellID->110206816],
Cell[60367, 1727, 259, 8, 70, "ExampleText",
 CellID->39371633],
Cell[CellGroupData[{
Cell[60651, 1739, 603, 20, 70, "Input",
 CellID->128690991],
Cell[61257, 1761, 412, 11, 36, "Output",
 CellID->393131062]
}, Open  ]],
Cell[61684, 1775, 257, 8, 70, "ExampleText",
 CellID->509071374],
Cell[CellGroupData[{
Cell[61966, 1787, 144, 4, 70, "Input",
 CellID->75800833],
Cell[62113, 1793, 610, 23, 51, "Output",
 CellID->69993669]
}, Open  ]],
Cell[CellGroupData[{
Cell[62760, 1821, 130, 4, 70, "Input",
 CellID->302291909],
Cell[62893, 1827, 382, 11, 36, "Output",
 CellID->779571662]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63324, 1844, 226, 7, 70, "ExampleSection",
 CellID->30888],
Cell[63553, 1853, 104, 2, 70, "ExampleText",
 CellID->196081406],
Cell[CellGroupData[{
Cell[63682, 1859, 852, 28, 70, "Input",
 CellID->200469894],
Cell[64537, 1889, 2034, 37, 70, "Output",
 Evaluatable->False,
 CellID->389918615]
}, Open  ]],
Cell[66586, 1929, 116, 3, 70, "ExampleText",
 CellID->296749167],
Cell[66705, 1934, 305, 10, 70, "Input",
 CellID->40337129],
Cell[CellGroupData[{
Cell[67035, 1948, 131, 4, 70, "Input",
 CellID->723530217],
Cell[67169, 1954, 518, 16, 39, "Output",
 CellID->1922713]
}, Open  ]],
Cell[67702, 1973, 117, 3, 70, "ExampleText",
 CellID->515287132],
Cell[CellGroupData[{
Cell[67844, 1980, 989, 28, 70, "Input",
 CellID->22502136],
Cell[68836, 2010, 11595, 194, 70, "Output",
 Evaluatable->False,
 CellID->594219890]
}, Open  ]],
Cell[80446, 2207, 120, 3, 70, "ExampleText",
 CellID->45477658],
Cell[CellGroupData[{
Cell[80591, 2214, 203, 7, 70, "Input",
 CellID->492886621],
Cell[80797, 2223, 967, 26, 54, "Output",
 CellID->17924533]
}, Open  ]],
Cell[81779, 2252, 132, 4, 70, "ExampleText",
 CellID->279734829],
Cell[CellGroupData[{
Cell[81936, 2260, 1082, 31, 70, "Input",
 CellID->890800062],
Cell[83021, 2293, 11912, 199, 70, "Output",
 Evaluatable->False,
 CellID->321858534]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94994, 2499, 311, 9, 70, "SeeAlsoSection",
 CellID->11668],
Cell[95308, 2510, 1725, 62, 70, "SeeAlso",
 CellID->3944]
}, Open  ]],
Cell[CellGroupData[{
Cell[97070, 2577, 314, 9, 70, "TutorialsSection",
 CellID->26168],
Cell[97387, 2588, 163, 3, 70, "Tutorials",
 CellID->26150],
Cell[97553, 2593, 136, 3, 70, "Tutorials",
 CellID->16983]
}, Open  ]],
Cell[CellGroupData[{
Cell[97726, 2601, 321, 9, 70, "RelatedLinksSection",
 CellID->17218],
Cell[98050, 2612, 346, 11, 70, "RelatedLinks"],
Cell[98399, 2625, 267, 6, 70, "RelatedLinks",
 CellID->17340],
Cell[98669, 2633, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99087, 2651, 319, 9, 70, "MoreAboutSection",
 CellID->683027344],
Cell[99409, 2662, 186, 4, 70, "MoreAbout",
 CellID->109306605],
Cell[99598, 2668, 167, 3, 70, "MoreAbout",
 CellID->137084454],
Cell[99768, 2673, 159, 3, 70, "MoreAbout",
 CellID->85324052],
Cell[99930, 2678, 139, 3, 70, "MoreAbout",
 CellID->188572973]
}, Open  ]],
Cell[100084, 2684, 27, 0, 70, "History"],
Cell[100114, 2686, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

