(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46059,       1661]
NotebookOptionsPosition[     37232,       1349]
NotebookOutlinePosition[     38670,       1388]
CellTagsIndexPosition[     38584,       1383]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FixedPoint" :> 
          Documentation`HelpLookup["paclet:ref/FixedPoint"], "NestWhileList" :> 
          Documentation`HelpLookup["paclet:ref/NestWhileList"], "NestList" :> 
          Documentation`HelpLookup["paclet:ref/NestList"], "ComposeList" :> 
          Documentation`HelpLookup["paclet:ref/ComposeList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FixedPoint\"\>", 
       2->"\<\"NestWhileList\"\>", 3->"\<\"NestList\"\>", 
       4->"\<\"ComposeList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Functional Iteration\"\>", 3->"\<\"Functional Programming\"\>"}
       , "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FixedPointList", "ObjectName",
 CellID->3684],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FixedPointList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FixedPointList"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list giving the results of applying ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " repeatedly, starting with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", until the results no longer change. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FixedPointList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPointList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as the first element of the list it produces. "
}], "Notes",
 CellID->2110],

Cell[TextData[{
 "The last two elements in the list produced by ",
 Cell[BoxData[
  ButtonBox["FixedPointList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPointList"]], "InlineFormula"],
 " are always the same. "
}], "Notes",
 CellID->3192],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FixedPointList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPointList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " stops after at most ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " steps. "
}], "Notes",
 CellID->19577]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->450418892],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->811014791],

Cell["Find the sequence of values leading to a fixed point:", "ExampleText",
 CellID->303654515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Floor", "[", 
      RowBox[{"#", "/", "2"}], "]"}]}], "&"}], ",", "1000"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->17596],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1000", ",", "501", ",", "251", ",", "126", ",", "64", ",", "33", ",", "17",
    ",", "9", ",", "5", ",", "3", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->829026708]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"Floor", "[", 
   RowBox[{
    RowBox[{"Last", "[", "%", "]"}], "/", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->474768918],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->755135630]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343115287],

Cell["\<\
Repeated application of a rule until the result no longer changes:\
\>", "ExampleText",
 CellID->261159432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/.", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a_", ",", "b_"}], "}"}], "/;", 
       RowBox[{"b", "\[NotEqual]", "0"}]}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"b", ",", 
        RowBox[{"Mod", "[", 
         RowBox[{"a", ",", "b"}], "]"}]}], "}"}]}]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "21"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1230143031],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"28", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316068185]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"28", ",", "21"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->659869695],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54928154]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30939],

Cell["Stop after at most 5 steps:", "ExampleText",
 CellID->30746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Floor", "[", 
      RowBox[{"#", "/", "2"}], "]"}]}], "&"}], ",", "1000", ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27976],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1000", ",", "501", ",", "251", ",", "126", ",", "64", ",", "33"}], 
  "}"}]], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227369490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"Floor", "[", 
      RowBox[{"#", "/", "2"}], "]"}]}], "&"}], ",", "1000"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->10408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1000", ",", "501", ",", "251", ",", "126", ",", "64", ",", "33", ",", "17",
    ",", "9", ",", "5", ",", "3", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->302144495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->569024916],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SameTest",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->203272597],

Cell[TextData[{
 "Stop as soon as successive iterations differ by less than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "10"}]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->77384070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1`20", 
   ",", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"#1", "-", "#2"}], "]"}], "<", "1*^-10"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1016195388],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`20.", ",", "1.5`20.", ",", 
   "1.41666666666666666666666666666666666667`20.", ",", 
   "1.41421568627450980392156862745098039216`19.999999999999996", ",", 
   "1.41421356237468991062629557889013491012`19.999999999999996", ",", 
   "1.41421356237309504880168962350253024361`19.999999999999996"}], 
  "}"}]], "Output",
 ImageSize->{482, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35040107]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FixedPointList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", " ", "+", " ", 
        RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1", 
    ",", 
    RowBox[{"SameTest", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"#1", "-", "#2"}], "]"}], "<", "1*^-10"}], "&"}], ")"}]}]}], 
   "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1468269344],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"1"},
     {
      FractionBox["3", "2"]},
     {
      FractionBox["17", "12"]},
     {
      FractionBox["577", "408"]},
     {
      FractionBox["665857", "470832"]},
     {
      FractionBox["886731088897", "627013566048"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{73, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->317290099]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25020],

Cell[TextData[{
 "Show convergence to ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " in Newton\[CloseCurlyQuote]s method:"
}], "ExampleText",
 CellID->16711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1.0"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13340],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", "1.4142156862745097`", 
   ",", "1.4142135623746899`", ",", "1.414213562373095`", ",", 
   "1.414213562373095`"}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->633663606],

Cell[TextData[{
 "Number of steps needed to converge to a fixed point of ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->574574828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"FixedPointList", "[", 
    RowBox[{"Cos", ",", "1.0"}], "]"}], "]"}], "-", "1"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->683235496],

Cell[BoxData["92"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270083604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25994],

Cell["Matrix convergence:", "ExampleText",
 CellID->14271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"FixedPointList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.51", ",", "0.49"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.49", ",", "0.51"}], "}"}]}], "}"}], ".", "#"}], "&"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23895],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXUtv00AQduIkLWkjngckDvRfUFROgIpaxI8IFag9IFDpmQN/3PgRU/fL
rHdmX97EG6l19jmPndm15/O0X9Z3199+rO9urtYnn27Xv65vrn6fnP+8Lavy
SZZN32ZZdvoyK78X5bf6p/2clT/3xaZ0XP3O//fK3kD5OZRPPbcj/ReW/B3V
Uh5B7az8VRWr67S8zjflY0X9AYx/CuV5mq93vgWMfxb5eixJq8nrqbseVX6v
a6ebObdblwZjUFsoHT0q8TEWPuZAF71p7Hba9q71xPTiFfQ6ZPWaGWkg0RqK
Vg5lnufELxfSwh1iWo9beuQAKT6m2hOtaGihxTyh2ndQLqSFcko8oepVdTrq
bT00ki7NbTo33qvzLHd4vnFuW8vcesrV9jKXLtEagpa5pcctV3yegPeFjwJK
n2j7p42ehLTHYms8T2ujYhWN2ebaLVPanBLUFyOdRxWPwEjEUHrmWcGZZhTa
1rvI+uv4R79zLS9fq9WaIjfU7CH6qfhzJQc+n01YWsK7EZzVdTvSxzsvKX+V
h07KYiXtOCQe5zqb7QFJ6v2VWopE6p7DFmk+EZKLqxzbetg8+7pH0lB7vChA
4mMsfOCTDS8itb/6MHuy2hdsJdGS00q42z5Km2glT/DhCfGhlmnufUegee/L
ucFheO9EJVpD0dK9t70vtmHyxujuSZloJQ9Q0aIzHtq8DC7SqcrD2Nfxujfx
Q+uvWcVx5HQVmw+V1fawhPp4paF3rmn/qmn/I9TH50Lne3OBrbQR54NNudk2
2s8KerWjcqdUWt510fAZXP1wgVcpV3hddOaRcCnNkrushen20p88aOt2OTqs
d5eEMVN86vDLoXp0txf9ZN8vx9S6NoDkunKkmuHpyyzDxn8+XuO3qMmQ/lv5
5YLgjBfBmnrloe49uy9zbW5Fj9uuITlxzL+u7FM+Tk139QgZQubY0d7A243Q
G8xwP/UpNVN6vM4nfHDSXundr4dPoUWElCWIbNY+MiTucVEM7R/LLf1IVqmN
LqMO/fJC1+YFJw5OnxL0jCgVnoUhpJLWzpxqQKr/h3KaW4F+HXHu4T2p+wyv
1pLaj/r2JJ8cSWp53EssDH3KbDd2L2lPbYebY+f6kNR2rTuz8retCJs4huzT
/8yypkL6o08Oh/VPujZW+XtOJrGFD+W1MeVGfig4Xt2NbVJ5QLrctdWmPS8e
xkhbpCN3NC/Gcik6VD8q2mZDF2PRiOzoxi2K+8i3hC9pzuJH1uq/1rSj9i6F
/b8L+/8V9tfl/r2vtYAnP54IlBYom6Wkp/pRUlP9KGkluX2NhzeL3GxJaFUo
Gd5VoETYjpJgO0qgy925MFqPOLiW+lLiOnG9XZ539nDTHKUc5ulHU3E34VJR
Ybw8qnhOmsrKxXSXIq5Up7nvrDaenZBvh2jv413k0iAn/aiaDsk0i7n5xijt
ZOKhr2aRkDjQ2X7kOAx67UN/LvLmhvdfHb5F01Jhohb4iRGiuxJxp0dkPfNv
gNjS6Jo/TDp+BCxOb1AjoBacWOK5Jtz247OeZbH2GNruXCLUbuxqV/1DhfH2
xJoZaKcdLzYoLm0ZbrBnuwyucMis3dq5Q6pDZuo1nqR6o5Zn3WZvw+nQJJoW
Dx1xw5ENYkvva+6xnfCS2qA6NmvqHqdGPwuZNdW8A0j9/cPkb+YrHMq+YpF3
F7wO79KGzFWkva49/dpMIO7/UkIkth2PSKfJfHmmRmZ1SKoreoisHjHpY+zX
dU5hs4q7kcNWbD5N3l02+QfPqc0u\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{569, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281225109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10416],

Cell["Evaluate combinators:", "ExampleText",
 CellID->21256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"s", "[", "x_", "]"}], "[", "y_", "]"}], "[", "z_", "]"}], 
        "\[Rule]", 
        RowBox[{
         RowBox[{"x", "[", "z", "]"}], "[", 
         RowBox[{"y", "[", "z", "]"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"k", "[", "x_", "]"}], "[", "y_", "]"}], "\[Rule]", "x"}]}], 
      "}"}]}], "&"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"s", "[", 
       RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", "k", "]"}], 
    "[", "k", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9093],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1O4zAQdpO0wJZUcEE9lpfZPe1DVAgJDggEnGAvq33wbJKmbRg8eMYz
dpyWSE1qZ36+z078k5nf69e724f16/3NevXref10d3/zsvr5+FxX5RNjsswY
c7009f+q/tf+tkdR//bFTemyPjcq8+46Q8rn4Lq9P0X0pr2ryXcozIXQHobH
BxcFH8WeTd/3fr7rlX7tHJQL4X1XGepz/eUdOxeP0Dik7RAaj287cXFQ/VDl
oL+sOZnT+lxsn+miP/I0NjdK28PKIIJOJsWogfmL8hS3cghMKTYOgadfDyfM
aqaIR9PWfuQx074lrE17/szn2TeGRhYIq46FpgdOaBxGzNKDy4GwZfZxMpx2
mJUQadv7PCad22qRcuN3RrGqKA/LUnxSvKVDfmx8uPpj5+fqv6Hxwz0N179U
H44ak1burD7nljEl6+opb7lELhf698VTInKp4aTqpY4ba+9Y+BZMP1z5730B
a5xkWShp2EfK7rj3A8S+TYJLqYREy459zGlm9AKz11sfZBaZWDq5IkYNG3Dt
aNMZIy8fG4fAk9KfQ3NYCPxLdO2jhmt3wdnta8jDiA/XvhRf6ZBPHT9Xf2x8
XP0TG+9VYHn8rW3e8azaf1HsZwm46k+rj9kGUB5mHWD3F8Cetn0Mt7YfjI+v
3SWz3p6NUXVHEawEn64fgLcrC8VVdmWhuLJ+fLNgXPqu7B2qv/e2FXNQGzu7
g3vfN9tCmu3D5RkrS0Vqj8rjT2V7WpqxYBeVFtRTZjJUL1bWDJjp2PwUovbJ
ZjckhFPdv3K7vVXYm0T8vqIkRVo9sq2E+i7MjD3Hwp3EN74Q7RPtm3AEJP4t
ulkjwX3Oic3eF/sg7n3KyMvR50aJpVHd0PhSj4oPjS+0fy6ev209nPGwKCq3
3oWOqseJktrksOirtv+ho8+x/Gv7ofq1P63f6zNcgxEbPKp1mWa7HPd6DJ9B
bBElbj1lBqHohYo8Y5GzkLhSjTQOjSukfx+b9jcj9ldc7UgqjDRp+x860hbb
v7Y/rv/NUwq1fCM21MjhkqkvjZhx9amROpf/f23rVt1RMEtm8h/drll2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{514, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->942199545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14793],

Cell["\<\
Go up a directory tree to its root (the result will depend on computer \
system):\
\>", "ExampleText",
 CellID->23654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{"ParentDirectory", ",", "$UserBaseDirectory"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"/crypt/maeder/.Mathematica\"\>", ",", "\<\"/crypt/maeder\"\>", 
   ",", "\<\"/crypt\"\>", ",", "\<\"/\"\>", ",", "\<\"/\"\>"}], 
  "}"}]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1467000338]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[2]:=",
 CellID->21713],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->490554414],

Cell["Repeated differentiation:", "ExampleText",
 CellID->1962092327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"x", "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24347],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "10"], ",", 
   RowBox[{"10", " ", 
    SuperscriptBox["x", "9"]}], ",", 
   RowBox[{"90", " ", 
    SuperscriptBox["x", "8"]}], ",", 
   RowBox[{"720", " ", 
    SuperscriptBox["x", "7"]}], ",", 
   RowBox[{"5040", " ", 
    SuperscriptBox["x", "6"]}], ",", 
   RowBox[{"30240", " ", 
    SuperscriptBox["x", "5"]}], ",", 
   RowBox[{"151200", " ", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{"604800", " ", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"1814400", " ", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"3628800", " ", "x"}], ",", "3628800", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{404, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->862459208]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10741],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " gives the last element of ",
 Cell[BoxData[
  ButtonBox["FixedPointList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPointList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1578207386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", "/", "x"}]}], ")"}], "/", "2"}]}], "]"}], ",", "1.0"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->896449159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", "1.4142156862745097`", 
   ",", "1.4142135623746899`", ",", "1.414213562373095`", ",", 
   "1.414213562373095`"}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1280192909]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", "/", "x"}]}], ")"}], "/", "2"}]}], "]"}], ",", "1.0"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->464958028],

Cell[BoxData["1.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1397143087]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->919070827],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 " goes for a fixed number of steps:"
}], "ExampleText",
 CellID->1175498421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1.0", 
   ",", "8"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->530990209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", "1.4142156862745097`", 
   ",", "1.4142135623746899`", ",", "1.414213562373095`", ",", 
   "1.414213562373095`", ",", "1.414213562373095`", ",", 
   "1.414213562373095`"}], "}"}]], "Output",
 ImageSize->{486, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1180905893]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1.0"}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1020220570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", "1.4142156862745097`", 
   ",", "1.4142135623746899`", ",", "1.414213562373095`", ",", 
   "1.414213562373095`"}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1487696621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2002140272],

Cell["Apply rules repeatedly until the result no longer changes:", \
"ExampleText",
 CellID->1130546592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "->", "b"}], ",", 
       RowBox[{"b", "->", "c"}], ",", 
       RowBox[{"c", "->", "d"}]}], "}"}]}], "&"}], ",", 
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{"c", "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55058346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["c", "3"]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["d", "3"]}], ",", 
   RowBox[{
    SuperscriptBox["c", "2"], "+", 
    SuperscriptBox["d", "3"]}], ",", 
   RowBox[{
    SuperscriptBox["d", "2"], "+", 
    SuperscriptBox["d", "3"]}], ",", 
   RowBox[{
    SuperscriptBox["d", "2"], "+", 
    SuperscriptBox["d", "3"]}]}], "}"}]], "Output",
 ImageSize->{251, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228320662]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "^", "2"}], "+", 
   RowBox[{"c", "^", "3"}]}], "//.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "->", "b"}], ",", 
    RowBox[{"b", "->", "c"}], ",", 
    RowBox[{"c", "->", "d"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2122339331],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["d", "2"], "+", 
  SuperscriptBox["d", "3"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->869426863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49488151],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPointList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPointList"]], "InlineFormula"],
 " is equivalent to a particular choice of arguments of ",
 Cell[BoxData[
  ButtonBox["NestWhileList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhileList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->506529632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", "/", "x"}]}], ")"}], "/", "2"}]}], "]"}], ",", "1.0", 
   ",", "UnsameQ", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1365408793],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", "1.4142156862745097`", 
   ",", "1.4142135623746899`", ",", "1.414213562373095`", ",", 
   "1.414213562373095`"}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->610452199]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13648],

Cell["\<\
When finding a fixed point, numerical precision may increase:\
\>", "ExampleText",
 CellID->132059442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FixedPointList", "[", 
   RowBox[{"InverseErf", ",", "0.5`10", ",", "10"}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1339911032],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"0.5`10."},
     {"0.47693627620446982229296395417`11.213126265505911"},
     {"0.45157953466301736789034748654`12.441703835425427"},
     {"0.42435507490617879744476681481`13.690467665700549"},
     {"0.39580825259249846626019575524`14.964638340906031"},
     {"0.3665514512748453412882554403`16.27048056253154"},
     {"0.33720411442247995966740046111`17.6147810905242"},
     {"0.30833836339920378451393598550158606424`19.00467472380283"},
     {"0.28043933170777735913479005515529876291`20.447296261286237"},
     {"0.2538838699797014057784924452393391162`21.94960648240735"},
     {"0.22893626453536171643139709476802197867`23.518392147113364"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{186, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->713722286]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22797],

Cell[TextData[{
 "The depth of intermediate expressions in a combinator evaluation [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-1122a-text "], None}],
 "]:"
}], "ExampleText",
 CellID->21507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "/@", 
  RowBox[{"FixedPointList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"s", "[", "x_", "]"}], "[", "y_", "]"}], "[", "z_", "]"}], 
         "\[Rule]", 
         RowBox[{
          RowBox[{"x", "[", "z", "]"}], "[", 
          RowBox[{"y", "[", "z", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"k", "[", "x_", "]"}], "[", "y_", "]"}], "\[Rule]", "x"}]}],
        "}"}]}], "&"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"s", "[", 
        RowBox[{"s", "[", 
         RowBox[{
          RowBox[{"s", "[", "s", "]"}], "[", "s", "]"}], "]"}], "]"}], "[", 
       "s", "]"}], "[", "s", "]"}], "[", "k", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29219],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "4", 
   ",", "5", ",", "6", ",", "3", ",", "3", ",", "4", ",", "4", ",", "5", ",", 
   "3", ",", "4", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", 
   ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", 
   "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", 
   ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", 
   "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", 
   ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", 
   "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", 
   ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", 
   "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5", 
   ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "7", ",", 
   "8", ",", "8", ",", "9", ",", "9", ",", "5", ",", "6", ",", "7", ",", "4", 
   ",", "4"}], "}"}]], "Output",
 ImageSize->{462, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11034]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14519],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FixedPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComposeList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComposeList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18140],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->15225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->3749886],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->813501777],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->479058194],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->189152942]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FixedPointList"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FixedPointList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 25.5628476}", "context" -> "System`", 
    "keywords" -> {
     "fixed point", "fixed point iteration", "function iteration", 
      "least fixed point", "Newton's approximation", "until"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FixedPointList[f, expr] generates a list giving the results of applying \
f repeatedly, starting with expr, until the results no longer change. ", 
    "synonyms" -> {"fixed point list"}, "title" -> "FixedPointList", "type" -> 
    "Symbol", "uri" -> "ref/FixedPointList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5459, 177, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->450418892]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38441, 1376}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2400, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3023, 83, 51, 1, 70, "ObjectName",
 CellID->3684],
Cell[3077, 86, 775, 23, 70, "Usage",
 CellID->24984]
}, Open  ]],
Cell[CellGroupData[{
Cell[3889, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4367, 131, 397, 14, 70, "Notes",
 CellID->2110],
Cell[4767, 147, 251, 8, 70, "Notes",
 CellID->3192],
Cell[5021, 157, 401, 15, 70, "Notes",
 CellID->19577]
}, Closed]],
Cell[CellGroupData[{
Cell[5459, 177, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->450418892],
Cell[CellGroupData[{
Cell[5844, 191, 148, 5, 70, "ExampleSection",
 CellID->811014791],
Cell[5995, 198, 96, 1, 70, "ExampleText",
 CellID->303654515],
Cell[CellGroupData[{
Cell[6116, 203, 240, 9, 28, "Input",
 CellID->17596],
Cell[6359, 214, 323, 9, 36, "Output",
 CellID->829026708]
}, Open  ]],
Cell[CellGroupData[{
Cell[6719, 228, 181, 6, 28, "Input",
 CellID->474768918],
Cell[6903, 236, 158, 5, 36, "Output",
 CellID->755135630]
}, Open  ]],
Cell[7076, 244, 125, 3, 70, "ExampleDelimiter",
 CellID->343115287],
Cell[7204, 249, 117, 3, 70, "ExampleText",
 CellID->261159432],
Cell[CellGroupData[{
Cell[7346, 256, 508, 17, 70, "Input",
 CellID->1230143031],
Cell[7857, 275, 423, 15, 36, "Output",
 CellID->316068185]
}, Open  ]],
Cell[CellGroupData[{
Cell[8317, 295, 124, 4, 70, "Input",
 CellID->659869695],
Cell[8444, 301, 157, 5, 36, "Output",
 CellID->54928154]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8650, 312, 239, 7, 70, "ExampleSection",
 CellID->30939],
Cell[8892, 321, 66, 1, 70, "ExampleText",
 CellID->30746],
Cell[CellGroupData[{
Cell[8983, 326, 251, 9, 70, "Input",
 CellID->27976],
Cell[9237, 337, 258, 8, 36, "Output",
 CellID->227369490]
}, Open  ]],
Cell[CellGroupData[{
Cell[9532, 350, 240, 9, 70, "Input",
 CellID->10408],
Cell[9775, 361, 323, 9, 36, "Output",
 CellID->302144495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10147, 376, 222, 7, 70, "ExampleSection",
 CellID->569024916],
Cell[CellGroupData[{
Cell[10394, 387, 229, 7, 70, "ExampleSubsection",
 CellID->203272597],
Cell[10626, 396, 232, 8, 70, "ExampleText",
 CellID->77384070],
Cell[CellGroupData[{
Cell[10883, 408, 475, 17, 70, "Input",
 CellID->1016195388],
Cell[11361, 427, 493, 13, 54, "Output",
 CellID->35040107]
}, Open  ]],
Cell[CellGroupData[{
Cell[11891, 445, 518, 18, 70, "Input",
 CellID->1468269344],
Cell[12412, 465, 912, 32, 168, "Output",
 CellID->317290099]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[13385, 504, 223, 7, 70, "ExampleSection",
 CellID->25020],
Cell[13611, 513, 193, 7, 70, "ExampleText",
 CellID->16711],
Cell[CellGroupData[{
Cell[13829, 524, 274, 10, 70, "Input",
 CellID->13340],
Cell[14106, 536, 354, 10, 36, "Output",
 CellID->24555]
}, Open  ]],
Cell[14475, 549, 125, 3, 70, "ExampleDelimiter",
 CellID->633663606],
Cell[14603, 554, 228, 8, 70, "ExampleText",
 CellID->574574828],
Cell[CellGroupData[{
Cell[14856, 566, 196, 6, 70, "Input",
 CellID->683235496],
Cell[15055, 574, 159, 5, 36, "Output",
 CellID->270083604]
}, Open  ]],
Cell[15229, 582, 121, 3, 70, "ExampleDelimiter",
 CellID->25994],
Cell[15353, 587, 58, 1, 70, "ExampleText",
 CellID->14271],
Cell[CellGroupData[{
Cell[15436, 592, 560, 20, 70, "Input",
 CellID->23895],
Cell[15999, 614, 2009, 37, 70, "Output",
 Evaluatable->False,
 CellID->281225109]
}, Open  ]],
Cell[18023, 654, 121, 3, 70, "ExampleDelimiter",
 CellID->10416],
Cell[18147, 659, 60, 1, 70, "ExampleText",
 CellID->21256],
Cell[CellGroupData[{
Cell[18232, 664, 753, 26, 70, "Input",
 CellID->9093],
Cell[18988, 692, 1305, 25, 70, "Output",
 Evaluatable->False,
 CellID->942199545]
}, Open  ]],
Cell[20308, 720, 121, 3, 70, "ExampleDelimiter",
 CellID->14793],
Cell[20432, 725, 128, 4, 70, "ExampleText",
 CellID->23654],
Cell[CellGroupData[{
Cell[20585, 733, 159, 4, 70, "Input",
 CellID->2993],
Cell[20747, 739, 324, 9, 36, "Output",
 CellID->1467000338]
}, Open  ]],
Cell[21086, 751, 65, 2, 70, "Input",
 CellID->21713],
Cell[21154, 755, 125, 3, 70, "ExampleDelimiter",
 CellID->490554414],
Cell[21282, 760, 69, 1, 70, "ExampleText",
 CellID->1962092327],
Cell[CellGroupData[{
Cell[21376, 765, 229, 8, 70, "Input",
 CellID->24347],
Cell[21608, 775, 806, 26, 58, "Output",
 CellID->862459208]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22463, 807, 233, 7, 70, "ExampleSection",
 CellID->10741],
Cell[22699, 816, 346, 12, 70, "ExampleText",
 CellID->1578207386],
Cell[CellGroupData[{
Cell[23070, 832, 309, 11, 70, "Input",
 CellID->896449159],
Cell[23382, 845, 359, 10, 36, "Output",
 CellID->1280192909]
}, Open  ]],
Cell[CellGroupData[{
Cell[23778, 860, 305, 11, 70, "Input",
 CellID->464958028],
Cell[24086, 873, 176, 5, 36, "Output",
 CellID->1397143087]
}, Open  ]],
Cell[24277, 881, 125, 3, 70, "ExampleDelimiter",
 CellID->919070827],
Cell[24405, 886, 212, 7, 70, "ExampleText",
 CellID->1175498421],
Cell[CellGroupData[{
Cell[24642, 897, 283, 10, 70, "Input",
 CellID->530990209],
Cell[24928, 909, 417, 11, 36, "Output",
 CellID->1180905893]
}, Open  ]],
Cell[CellGroupData[{
Cell[25382, 925, 279, 10, 70, "Input",
 CellID->1020220570],
Cell[25664, 937, 359, 10, 36, "Output",
 CellID->1487696621]
}, Open  ]],
Cell[26038, 950, 126, 3, 70, "ExampleDelimiter",
 CellID->2002140272],
Cell[26167, 955, 104, 2, 70, "ExampleText",
 CellID->1130546592],
Cell[CellGroupData[{
Cell[26296, 961, 401, 14, 70, "Input",
 CellID->55058346],
Cell[26700, 977, 614, 22, 39, "Output",
 CellID->228320662]
}, Open  ]],
Cell[CellGroupData[{
Cell[27351, 1004, 301, 11, 70, "Input",
 CellID->2122339331],
Cell[27655, 1017, 228, 8, 36, "Output",
 CellID->869426863]
}, Open  ]],
Cell[27898, 1028, 124, 3, 70, "ExampleDelimiter",
 CellID->49488151],
Cell[28025, 1033, 378, 12, 70, "ExampleText",
 CellID->506529632],
Cell[CellGroupData[{
Cell[28428, 1049, 336, 11, 70, "Input",
 CellID->1365408793],
Cell[28767, 1062, 358, 10, 36, "Output",
 CellID->610452199]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29174, 1078, 226, 7, 70, "ExampleSection",
 CellID->13648],
Cell[29403, 1087, 112, 3, 70, "ExampleText",
 CellID->132059442],
Cell[CellGroupData[{
Cell[29540, 1094, 195, 6, 70, "Input",
 CellID->1339911032],
Cell[29738, 1102, 1335, 32, 198, "Output",
 CellID->713722286]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31122, 1140, 224, 7, 70, "ExampleSection",
 CellID->22797],
Cell[31349, 1149, 270, 8, 70, "ExampleText",
 CellID->21507],
Cell[CellGroupData[{
Cell[31644, 1161, 878, 29, 70, "Input",
 CellID->29219],
Cell[32525, 1192, 1225, 21, 88, "Output",
 CellID->11034]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33811, 1220, 311, 9, 70, "SeeAlsoSection",
 CellID->14519],
Cell[34125, 1231, 961, 35, 70, "SeeAlso",
 CellID->16168]
}, Open  ]],
Cell[CellGroupData[{
Cell[35123, 1271, 314, 9, 70, "TutorialsSection",
 CellID->18140],
Cell[35440, 1282, 167, 3, 70, "Tutorials",
 CellID->15225]
}, Open  ]],
Cell[CellGroupData[{
Cell[35644, 1290, 317, 9, 70, "MoreAboutSection",
 CellID->3749886],
Cell[35964, 1301, 147, 3, 70, "MoreAbout",
 CellID->813501777],
Cell[36114, 1306, 151, 3, 70, "MoreAbout",
 CellID->479058194],
Cell[36268, 1311, 155, 3, 70, "MoreAbout",
 CellID->189152942]
}, Open  ]],
Cell[CellGroupData[{
Cell[36460, 1319, 305, 8, 70, "RelatedLinksSection"],
Cell[36768, 1329, 392, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[37175, 1345, 27, 0, 70, "History"],
Cell[37205, 1347, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

