(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33460,       1258]
NotebookOptionsPosition[     26022,        994]
NotebookOutlinePosition[     27406,       1032]
CellTagsIndexPosition[     27320,       1027]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flat and Orderless Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FlatAndOrderlessFunctions"], "Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Flat and Orderless Functions\"\>", 
       2->"\<\"Attributes\"\>", 
       3->"\<\"Patterns and Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orderless" :> Documentation`HelpLookup["paclet:ref/Orderless"],
           "OneIdentity" :> 
          Documentation`HelpLookup["paclet:ref/OneIdentity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Orderless\"\>", 
       2->"\<\"OneIdentity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], "Patterns" :> 
          Documentation`HelpLookup["paclet:guide/Patterns"], 
          "Defining Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Patterns\"\>", 
       3->"\<\"Defining Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Flat", "ObjectName",
 CellID->7340],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Flat",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
     "\[LineSeparator]is an attribute that can be assigned to a symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to indicate that all expressions involving nested functions ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " should be flattened out. This property is accounted for in pattern \
matching. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32117]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " corresponds to the mathematical property of associativity. "
}], "Notes",
 CellID->15114],

Cell[TextData[{
 "For a symbol ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " with attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], ",", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["c", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " is automatically reduced to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20847],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5125],

Cell[TextData[{
 "For a ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", the variables ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " in the pattern ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{"x_", ",", "y_"}], "]"}]], "InlineFormula"],
 " can correspond to any sequence of arguments. "
}], "Notes",
 CellID->8543],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " attribute must be assigned before defining any values for a ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " function. "
}], "Notes",
 CellID->1711],

Cell[TextData[{
 "When functions that are ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " are used in pattern matching, they often also require the attribute ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18582]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->241631267],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->91673295],

Cell["Nested expressions with flat functions are flattened out:", \
"ExampleText",
 CellID->637102752],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "Flat"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"f", "[", 
      RowBox[{"d", ",", "e"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12992],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27680230],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " implements the notion of associativity:"
}], "ExampleText",
 CellID->16365858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plus", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145086886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
   "Orderless", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407973854]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"(", 
   RowBox[{"b", "+", "c"}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101872230],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->718584292]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18283],

Cell["\<\
Nested expressions with associative functions are flattened out:\
\>", "ExampleText",
 CellID->526842666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "NonCommutativeMultiply", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222914585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Flat", ",", "OneIdentity", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366776425]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "**", 
    RowBox[{"(", 
     RowBox[{"b", "**", "c"}], ")"}]}], ")"}], "**", 
  RowBox[{"(", "d", ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->449146996],

Cell[BoxData[
 RowBox[{"a", "**", "b", "**", "c", "**", "d"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19635689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95892404],

Cell[TextData[{
 "In pattern matching, ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " allows sequences of elements to be replaced:"
}], "ExampleText",
 CellID->5158],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "Flat"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c", ",", "d"}], "]"}], "->", "x"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->264],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "x", ",", "e"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17982]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c", ",", "d"}], "]"}], "->", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7049],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "x", ",", "y", ",", "e"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "b", "]"}], "->", "x"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7090],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "x", ",", "c", ",", "d", ",", "e"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->21969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17095],

Cell["\<\
For flat and orderless functions, any subset of the arguments may match:\
\>", "ExampleText",
 CellID->86712818],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "Orderless", ",", "OneIdentity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "d"}], "]"}], "->", "x"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7259],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "c", ",", "e", ",", "x"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81655854]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14259],

Cell["\<\
Nested expressions with flat functions are automatically flattened:\
\>", "ExampleText",
 CellID->114300041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"f", "[", 
      RowBox[{"d", ",", "e"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176161476],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"f", "[", 
      RowBox[{"d", ",", "e"}], "]"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5236491]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->628847329],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->769324844]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"g", ",", "Flat"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->259016081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"c", ",", 
     RowBox[{"g", "[", 
      RowBox[{"d", ",", "e"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->127915518],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->24352061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524805642],

Cell["\<\
For flat functions, a definition for the two-argument case is normally \
sufficient:\
\>", "ExampleText",
 CellID->659924797],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "OneIdentity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31051139],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"x", "+", "y"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->799952925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->414044942],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c", "+", "d"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1036112058]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6365],

Cell[TextData[{
 "Pattern matching for flat functions requires the ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 " attribute as well:"
}], "ExampleText",
 CellID->15688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "[", "f", "]"}], "=", 
  RowBox[{"{", "Flat", "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16256],

Cell[BoxData[
 RowBox[{"{", "Flat", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43559398]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatchQ", "[", 
    RowBox[{
     RowBox[{"f", "[", "1", "]"}], ",", 
     RowBox[{"f", "[", "_Integer", "]"}]}], "]"}], ",", 
   RowBox[{"MatchQ", "[", 
    RowBox[{
     RowBox[{"f", "[", "1", "]"}], ",", 
     RowBox[{"f", "[", "__Integer", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1958362206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "[", "g", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"Flat", ",", "OneIdentity"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->270077799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Flat", ",", "OneIdentity"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->418870304]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatchQ", "[", 
    RowBox[{
     RowBox[{"g", "[", "1", "]"}], ",", 
     RowBox[{"g", "[", "_Integer", "]"}]}], "]"}], ",", 
   RowBox[{"MatchQ", "[", 
    RowBox[{
     RowBox[{"g", "[", "1", "]"}], ",", 
     RowBox[{"g", "[", "__Integer", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->40086246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->471358796]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->599442373],

Cell["\<\
For flat and orderless functions, pattern matching may have to try a large \
number of cases:\
\>", "ExampleText",
 CellID->913971896],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Flat", ",", "OneIdentity", ",", "Orderless"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7380087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->279433030],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW9tuEzEQ3WaTpkDvF2iRKvUFHtoHbgL+AJ74iKhCah8QqPT/l2yym25P
xp6Lx9sbkZLGjj1nxjNje33qH5Pri5+/JteX55OT71eTPxeX539Pvv2+mlaV
K0Ux+FQUxcfDYvq9mn6bvdvX5+n7pjgvvag/y0Wr4vn0Y1As12819SOo31a2
HxJ4UnwKF+VjOy+8mP194nH2afzpgVfWH0tWhrTYIXpT9aH2FHrdTorfRs2u
UA+r/JCcEK6X/FA9yvOSj/4YVFQ01LWjaZHyXknE3LhpXzJoqxG5VP9RU8/N
SVheU9ijwV0L2I9ypeORS08NvsSeVD3HARypntI4eBbTc7ioj4xaipbSdnTO
Ub5d6jXq2lA0ltV5Pg7+iprUrdGfubAobPRRLrsXdopHRTeGfdph8O4jsEPX
uq98ymnH8iyB3qFmxqVeuBtksTdNY7Uhko2yNiwWCbHRjlUKe6lXnxrKxgzt
GOfTUB0rsjFEC+6fhthrZdbONIu451uNOhRHC5bxCZCzIY5my6m8OtmyCDVP
0skpKrEVnk7YVjGbhpuNfbKVyWe9RU0HhmwJS66lYYZiOTVSdejrIk9IRiWv
nnjeEPSLe+arV1NGS2kcWDIvOHJmTa37RM0JTp3jm432zXFgQVm8EZFRNjLa
p+pi9uLWWIwF7pxpGWG7oucoiT3p6FtCFEpDLXorR+qpuCcwukPoA9JmqR6b
lew8ybaCHFJSFOvEPpRxP5A6c6H8IyjjWSy5d0zA22Pkv0rEO2Xk4xyH42va
23TKb5jfX0KZjjpc2dp8a5/WD5u/3RP07u/71c1TPcW/UCfxVP/X1Q3D0OJZ
5OxXt/XFLOHknEL/Ns/xmZNiQrpy2vXwLcjDqKP5qKp5UYynT+kh8aahuLpL
/JD9IV63L3yp/e/rjwfDe0r5yL7xQ/ajXn3jS+3/UFFR4MVnRflOEf8k4Y9y
sHMafiuNTUuyxg1Vy0Sv5fCNW0RorbH65l1FZc9/5jK/3Yj9VOxO87ecCX1c
dqf5e75TMjGP7LkXPhM+FuaROzvwGa2MFrn7SHY6fJc+Sog9hY/mT5/aNTPE
NfWZP3k5vH4yJiMbkeCV7il8fj/kzBFpnKLcL5UlK3Jnu5UJ6yfKJCxgGkuV
wy47esK604O/kljTnmZsOsukzBPFT8o5I44r8uDHJHyUjuXSRoqeR5OOamtn
e+6ZYyxtnuM0lo6lbQ04JnzM5lOnzLFkqXMDx1KK9jkReS5rTUQ+N57Iamb5
fxqFvzh9MV7oKORYweOKZgPblQBZOC0riKzjbgDnyCgf+6MdR1Wa/qFxQJzj
gPyvMy9UzSsfC8jNSXjqEWOdsGxhwaR4yJ3nxpPe3syFJ7Xvrlnd+TLJrcch
loq7xSdl0Tj5O5nlh25pesuX6i+9PZmLZZzVs1ERYmf0rGEZqDczViyqhT9z
15JYj1L1jN389NKT9XmCnlZmL3pzMkEfDVPpGR/z//XiegnYI26nauBg/Bm5
nHaEObSHZYfXTdH7bUeaP54qsz/fxXFPsiWJ4cMiyW7ocGyZp4bYy1FD2H8b
Ry8T4+ju5WQG0fEupc+Ze3JUzHJdtD8epo29WlPJSao+OkKWOOqkyKk4L+vD
SaaNky1vUCftfQMdX50nU8h9uXEfm8R4mthISVRQiOuSsRRGqpeenmuAxGaz
niDDV0sbT+x3i5nSScsA2Nl1WzZ27w/quEHJHTtRTNySHtKjyzB6oXfn0Bgm
fbPTAx1lrKs1kfKX0juVYSRqLxqSYPWQLGYPoJx6F897z3KWiMfZh3cpsazF
w70Jt8IhHsf6amdY7u4rN4dyrDYddVwG1V4pC/4OIcdG1m32QNaZUgbq0jKZ
B0o5bf+tgLwQg8vdr8R7p8isIoOM8mdnO4slUMubFiv/ADyGGZ0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{563, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72965049]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12156],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Orderless",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Orderless"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OneIdentity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OneIdentity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13197]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8077],

Cell[TextData[ButtonBox["Flat and Orderless Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FlatAndOrderlessFunctions"]], "Tutorials",
 CellID->11795],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->19434],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->8502839],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->189746312],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->78672548],

Cell[TextData[ButtonBox["Defining Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->96753135]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Flat"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Flat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 26.3284922}", "context" -> "System`", 
    "keywords" -> {
     "associative", "attribute", "grouping arguments", "auto flattening"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Flat is an attribute that can be assigned to a symbol f to indicate that \
all expressions involving nested functions f should be flattened out. This \
property is accounted for in pattern matching. ", "synonyms" -> {}, "title" -> 
    "Flat", "type" -> "Symbol", "uri" -> "ref/Flat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7206, 252, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->241631267]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27177, 1020}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2440, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3063, 84, 41, 1, 70, "ObjectName",
 CellID->7340],
Cell[3107, 87, 713, 20, 70, "Usage",
 CellID->32117]
}, Open  ]],
Cell[CellGroupData[{
Cell[3857, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4335, 129, 219, 7, 70, "Notes",
 CellID->15114],
Cell[4557, 138, 789, 32, 70, "Notes",
 CellID->20847],
Cell[5349, 172, 540, 23, 70, "Notes",
 CellID->5125],
Cell[5892, 197, 527, 20, 70, "Notes",
 CellID->8543],
Cell[6422, 219, 355, 13, 70, "Notes",
 CellID->1711],
Cell[6780, 234, 389, 13, 70, "Notes",
 CellID->18582]
}, Closed]],
Cell[CellGroupData[{
Cell[7206, 252, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->241631267],
Cell[CellGroupData[{
Cell[7591, 266, 147, 5, 70, "ExampleSection",
 CellID->91673295],
Cell[7741, 273, 102, 2, 70, "ExampleText",
 CellID->637102752],
Cell[7846, 277, 130, 4, 70, "Input",
 CellID->3685],
Cell[CellGroupData[{
Cell[8001, 285, 282, 10, 28, "Input",
 CellID->12992],
Cell[8286, 297, 235, 7, 36, "Output",
 CellID->29424]
}, Open  ]],
Cell[8536, 307, 124, 3, 70, "ExampleDelimiter",
 CellID->27680230],
Cell[8663, 312, 208, 7, 70, "ExampleText",
 CellID->16365858],
Cell[CellGroupData[{
Cell[8896, 323, 109, 3, 70, "Input",
 CellID->145086886],
Cell[9008, 328, 301, 9, 36, "Output",
 CellID->407973854]
}, Open  ]],
Cell[CellGroupData[{
Cell[9346, 342, 139, 5, 70, "Input",
 CellID->101872230],
Cell[9488, 349, 190, 6, 36, "Output",
 CellID->718584292]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9727, 361, 216, 7, 70, "ExampleSection",
 CellID->18283],
Cell[9946, 370, 115, 3, 70, "ExampleText",
 CellID->526842666],
Cell[CellGroupData[{
Cell[10086, 377, 127, 3, 70, "Input",
 CellID->222914585],
Cell[10216, 382, 235, 7, 36, "Output",
 CellID->366776425]
}, Open  ]],
Cell[CellGroupData[{
Cell[10488, 394, 216, 8, 70, "Input",
 CellID->449146996],
Cell[10707, 404, 202, 6, 36, "Output",
 CellID->19635689]
}, Open  ]],
Cell[10924, 413, 124, 3, 70, "ExampleDelimiter",
 CellID->95892404],
Cell[11051, 418, 235, 8, 70, "ExampleText",
 CellID->5158],
Cell[11289, 428, 131, 4, 70, "Input",
 CellID->14476],
Cell[CellGroupData[{
Cell[11445, 436, 257, 8, 70, "Input",
 CellID->264],
Cell[11705, 446, 214, 7, 36, "Output",
 CellID->17982]
}, Open  ]],
Cell[CellGroupData[{
Cell[11956, 458, 312, 10, 70, "Input",
 CellID->7049],
Cell[12271, 470, 224, 7, 36, "Output",
 CellID->27153]
}, Open  ]],
Cell[CellGroupData[{
Cell[12532, 482, 223, 7, 70, "Input",
 CellID->7090],
Cell[12758, 491, 235, 7, 36, "Output",
 CellID->21969]
}, Open  ]],
Cell[13008, 501, 121, 3, 70, "ExampleDelimiter",
 CellID->17095],
Cell[13132, 506, 122, 3, 70, "ExampleText",
 CellID->86712818],
Cell[13257, 511, 211, 7, 70, "Input",
 CellID->31444],
Cell[CellGroupData[{
Cell[13493, 522, 248, 8, 70, "Input",
 CellID->7259],
Cell[13744, 532, 227, 7, 36, "Output",
 CellID->81655854]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14020, 545, 233, 7, 70, "ExampleSection",
 CellID->14259],
Cell[14256, 554, 118, 3, 70, "ExampleText",
 CellID->114300041],
Cell[CellGroupData[{
Cell[14399, 561, 286, 10, 70, "Input",
 CellID->176161476],
Cell[14688, 573, 373, 13, 36, "Output",
 CellID->5236491]
}, Open  ]],
Cell[CellGroupData[{
Cell[15098, 591, 103, 3, 70, "Input",
 CellID->628847329],
Cell[15204, 596, 239, 7, 36, "Output",
 CellID->769324844]
}, Open  ]],
Cell[15458, 606, 135, 4, 70, "Input",
 CellID->259016081],
Cell[CellGroupData[{
Cell[15618, 614, 286, 10, 70, "Input",
 CellID->127915518],
Cell[15907, 626, 238, 7, 36, "Output",
 CellID->24352061]
}, Open  ]],
Cell[16160, 636, 125, 3, 70, "ExampleDelimiter",
 CellID->524805642],
Cell[16288, 641, 135, 4, 70, "ExampleText",
 CellID->659924797],
Cell[16426, 647, 193, 6, 70, "Input",
 CellID->31051139],
Cell[16622, 655, 170, 6, 70, "Input",
 CellID->799952925],
Cell[CellGroupData[{
Cell[16817, 665, 140, 4, 70, "Input",
 CellID->414044942],
Cell[16960, 671, 201, 6, 36, "Output",
 CellID->1036112058]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17210, 683, 225, 7, 70, "ExampleSection",
 CellID->6365],
Cell[17438, 692, 252, 8, 70, "ExampleText",
 CellID->15688],
Cell[CellGroupData[{
Cell[17715, 704, 151, 5, 70, "Input",
 CellID->16256],
Cell[17869, 711, 182, 6, 36, "Output",
 CellID->43559398]
}, Open  ]],
Cell[CellGroupData[{
Cell[18088, 722, 368, 12, 70, "Input",
 CellID->16730],
Cell[18459, 736, 211, 7, 36, "Output",
 CellID->1958362206]
}, Open  ]],
Cell[CellGroupData[{
Cell[18707, 748, 189, 6, 70, "Input",
 CellID->270077799],
Cell[18899, 756, 217, 7, 36, "Output",
 CellID->418870304]
}, Open  ]],
Cell[CellGroupData[{
Cell[19153, 768, 371, 12, 70, "Input",
 CellID->40086246],
Cell[19527, 782, 209, 7, 36, "Output",
 CellID->471358796]
}, Open  ]],
Cell[19751, 792, 125, 3, 70, "ExampleDelimiter",
 CellID->599442373],
Cell[19879, 797, 144, 4, 70, "ExampleText",
 CellID->913971896],
Cell[20026, 803, 213, 7, 70, "Input",
 CellID->7380087],
Cell[CellGroupData[{
Cell[20264, 814, 350, 11, 70, "Input",
 CellID->279433030],
Cell[20617, 827, 2154, 39, 70, "Output",
 Evaluatable->False,
 CellID->72965049]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22832, 873, 311, 9, 70, "SeeAlsoSection",
 CellID->12156],
Cell[23146, 884, 459, 17, 70, "SeeAlso",
 CellID->13197]
}, Open  ]],
Cell[CellGroupData[{
Cell[23642, 906, 313, 9, 70, "TutorialsSection",
 CellID->8077],
Cell[23958, 917, 164, 3, 70, "Tutorials",
 CellID->11795],
Cell[24125, 922, 131, 3, 70, "Tutorials",
 CellID->19434],
Cell[24259, 927, 178, 3, 70, "Tutorials",
 CellID->244552785]
}, Open  ]],
Cell[CellGroupData[{
Cell[24474, 935, 317, 9, 70, "MoreAboutSection",
 CellID->8502839],
Cell[24794, 946, 132, 3, 70, "MoreAbout",
 CellID->189746312],
Cell[24929, 951, 127, 3, 70, "MoreAbout",
 CellID->78672548],
Cell[25059, 956, 164, 3, 70, "MoreAbout",
 CellID->96753135]
}, Open  ]],
Cell[CellGroupData[{
Cell[25260, 964, 305, 8, 70, "RelatedLinksSection"],
Cell[25568, 974, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[25965, 990, 27, 0, 70, "History"],
Cell[25995, 992, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

