(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     67791,       2510]
NotebookOptionsPosition[     55981,       2091]
NotebookOutlinePosition[     57475,       2132]
CellTagsIndexPosition[     57389,       2127]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingNestedLists"], 
          "Structural Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/StructuralOperations"], 
          "Sequences" :> 
          Documentation`HelpLookup["paclet:tutorial/Sequences"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rearranging Nested Lists\"\>", 
       2->"\<\"Structural Operations\"\>", 
       3->"\<\"Sequences\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partition" :> Documentation`HelpLookup["paclet:ref/Partition"],
           "ArrayFlatten" :> 
          Documentation`HelpLookup["paclet:ref/ArrayFlatten"], "FlattenAt" :> 
          Documentation`HelpLookup["paclet:ref/FlattenAt"], "Transpose" :> 
          Documentation`HelpLookup["paclet:ref/Transpose"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Partition\"\>", 
       2->"\<\"ArrayFlatten\"\>", 3->"\<\"FlattenAt\"\>", 
       4->"\<\"Transpose\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ListManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Expressions\"\>", 
       2->"\<\"Handling Arrays of Data\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Rearranging & Restructuring Lists\"\>", 
       5->"\<\"Structural Operations on Expressions\"\>", 
       6->"\<\"New in 6.0: List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Flatten", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Flatten",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Flatten"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]flattens out nested lists. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Flatten",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Flatten"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]flattens to level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Flatten",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Flatten"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]flattens subexpressions with head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Flatten",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Flatten"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["s", "TI"], 
             StyleBox["11", "TR"]], ",", 
            SubscriptBox[
             StyleBox["s", "TI"], 
             StyleBox["12", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["s", "TI"], 
             StyleBox["21", "TR"]], ",", 
            SubscriptBox[
             StyleBox["s", "TI"], 
             StyleBox["22", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]flattens ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " by combining all levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["ij", "TI"]]], "InlineFormula"],
     " to make each level ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in the result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " \[OpenCurlyDoubleQuote]unravels\[CloseCurlyDoubleQuote] lists, effectively \
just deleting inner braces. "
}], "Notes",
 CellID->31634],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " effectively flattens the top level in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " ",
 StyleBox["n ", "TI"],
 "times. "
}], "Notes",
 CellID->262],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     StyleBox["e", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 " flattens out subexpressions with head ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20415],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Range",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Range"], "[", 
      RowBox[{
       StyleBox["n", "TI"], "+", "1"}], "]"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29827],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " are matrices, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["12", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["21", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["22", "TR"]]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 " effectively constructs a single matrix from the \
\[OpenCurlyDoubleQuote]blocks\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2267],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "}"}], ",", 
      RowBox[{"{", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " effectively transposes levels in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ", putting level ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " at level ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " in the result. Note that the function ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " in effect uses an inverse of this specification. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25495],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " flattens out levels in ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects just as in the corresponding ordinary arrays. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->24361,
  ButtonNote->"24361"]
}], "Notes",
 CellID->27912]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->494426351],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->218221588],

Cell["Flatten out lists at all levels:", "ExampleText",
 CellID->10676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"{", "d", "}"}], ",", "e"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "h"}], "}"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650],

Cell["Flatten only at level 1:", "ExampleText",
 CellID->19596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"{", "d", "}"}], ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"g", ",", "h"}], "}"}]}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2339],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", 
   RowBox[{"{", "d", "}"}], ",", "e", ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15546]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15118],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Level Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65258142],

Cell["No flattening:", "ExampleText",
 CellID->97876623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "2"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "3"}], "}"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"{", "4", "}"}], "}"}], "}"}], "}"}]}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785619432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "2"}]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"-", "3"}], "}"}]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "4", "}"}], "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106642297]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192367290],

Cell["Flatten to level 1:", "ExampleText",
 CellID->882113147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "2"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "3"}], "}"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"{", "4", "}"}], "}"}], "}"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136292252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"-", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "4", "}"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113342960]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50348319],

Cell["Flatten to level 2:", "ExampleText",
 CellID->169621002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "2"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "3"}], "}"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"{", "4", "}"}], "}"}], "}"}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312556913],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "4", "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96476900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->474647632],

Cell["Flatten to level 3:", "ExampleText",
 CellID->418391907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "2"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "3"}], "}"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"{", "4", "}"}], "}"}], "}"}], "}"}]}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110929369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", 
   RowBox[{"-", "2"}], ",", "3", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"{", "4", "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55527204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->507924021],

Cell["Flatten to level 4:", "ExampleText",
 CellID->750832852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "2"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "3"}], "}"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"{", "4", "}"}], "}"}], "}"}], "}"}]}], "}"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57218549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", 
   RowBox[{"-", "2"}], ",", "3", ",", 
   RowBox[{"-", "3"}], ",", "4"}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123624416]
}, Open  ]],

Cell["\<\
This is the same as using level \[Infinity]:\
\>", "ExampleText",
 CellID->19187418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "2"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "3"}], "}"}]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"{", "4", "}"}], "}"}], "}"}], "}"}]}], "}"}], ",", 
   "\[Infinity]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43151300],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", 
   RowBox[{"-", "2"}], ",", "3", ",", 
   RowBox[{"-", "3"}], ",", "4"}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->240257361]
}, Open  ]],

Cell["And the same as not specifying a level:", "ExampleText",
 CellID->196096835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", 
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "2"}]}], "}"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "3", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"-", "3"}], "}"}]}], "}"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "4", "}"}], "}"}], "}"}], "}"}]}], "}"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->3489744],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", 
   RowBox[{"-", "2"}], ",", "3", ",", 
   RowBox[{"-", "3"}], ",", "4"}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8748851]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17453],

Cell["Flatten a sparse array:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->24361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "->", "a"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "4"}], "}"}], "->", "b"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25245],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "24", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194450101]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23574],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "a", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "b"}], "}"}]], "Output",
 ImageSize->{444, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->214759294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2896],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " works with any head:"
}], "ExampleText",
 CellID->18490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26847],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1676213]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23066],

Cell[TextData[{
 "Flatten",
 " all levels with respect to ",
 Cell[BoxData["g"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"u", ",", "v"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", "Infinity", ",", "g"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30789],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"u", ",", "v", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "]"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474361487]
}, Open  ]],

Cell[TextData[{
 "Flatten",
 " all levels with respect to ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"u", ",", "v"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", "Infinity", ",", "f"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5005],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"u", ",", "v"}], "]"}], ",", "x", ",", "y"}], "]"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->468624984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15120],

Cell["Here is a matrix:", "ExampleText",
 CellID->31042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", " ", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38215570]
}, Open  ]],

Cell["\<\
Flatten an array of blocks with the shape of u into a single matrix.\
\>", "ExampleText",
 CellID->67830920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"0", " ", "u"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0", " ", "u"}], ",", "u"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26942],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b", "0", "0"},
     {"c", "d", "0", "0"},
     {"0", "0", "a", "b"},
     {"0", "0", "c", "d"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->6539288]
}, Open  ]],

Cell["\<\
Flatten into a single matrix effectively using the transpose of the blocks:\
\>", "ExampleText",
 CellID->727065314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"0", " ", "u"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0", " ", "u"}], ",", "u"}], "}"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32280],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "c", "0", "0"},
     {"b", "d", "0", "0"},
     {"0", "0", "a", "c"},
     {"0", "0", "b", "d"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->499446138]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28599],

Cell["Join lists and individual elements:", "ExampleText",
 CellID->20885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", "5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43521133]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"{", 
   RowBox[{"%", ",", "x", ",", "%", ",", "%", ",", "y"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1219],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "x", ",", "1", ",", "2", 
   ",", "3", ",", "4", ",", "5", ",", "1", ",", "2", ",", "3", ",", "4", ",", 
   "5", ",", "y"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97302122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2145],

Cell["Unravel a matrix:", "ExampleText",
 CellID->6571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "^", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23645],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "27", ",", "81"}], "}"}]}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42902337]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9564],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "4", ",", "8", ",", "16", 
   ",", "3", ",", "9", ",", "27", ",", "81"}], "}"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->522357094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28480],

Cell["Make a flattened list of rules:", "ExampleText",
 CellID->14560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "->", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5920],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{558, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170755569]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1539],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "1"}], ",", 
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"1", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "1"}], ",", 
   RowBox[{"2", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "1"}], ",", 
   RowBox[{"3", "\[Rule]", "2"}], ",", 
   RowBox[{"3", "\[Rule]", "3"}], ",", 
   RowBox[{"4", "\[Rule]", "1"}], ",", 
   RowBox[{"4", "\[Rule]", "2"}], ",", 
   RowBox[{"4", "\[Rule]", "3"}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->279678586]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4350419],

Cell["Do a \"transpose\" on a ragged array:", "ExampleText",
 CellID->614537583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "+", "j", "-", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "i"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312422236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25023670]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"list", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->328740875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", "7", "}"}]}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->273590526]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->801073205],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " acts as an inverse of ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", "20", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], "Output",\

 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216731470]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"%", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13340],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "11", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14", ",", "15", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "18", ",", "19", ",", "20"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{518, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->334466502]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14157],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], "Output",\

 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->102733808]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->673105231],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " effectively arranges elements in the lexicographic order of their \
indices:"
}], "ExampleText",
 CellID->8159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8576],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "3"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"1", ",", "4"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "3"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"2", ",", "4"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"3", ",", "1"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"3", ",", "2"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"3", ",", "3"}], "]"}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"3", ",", "4"}], "]"}]}], "}"}]], "Output",
 ImageSize->{409, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5324263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"100", "#1"}], "+", 
      RowBox[{"10", "#2"}], "+", "#3"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26841],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "111", ",", "112", ",", "113", ",", "121", ",", "122", ",", "123", ",", 
   "131", ",", "132", ",", "133", ",", "211", ",", "212", ",", "213", ",", 
   "221", ",", "222", ",", "223", ",", "231", ",", "232", ",", "233", ",", 
   "311", ",", "312", ",", "313", ",", "321", ",", "322", ",", "323", ",", 
   "331", ",", "332", ",", "333"}], "}"}]], "Output",
 ImageSize->{458, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->400612675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->333138007],

Cell[TextData[{
 "For a permutation ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " with inverse ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["p", 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     RowBox[{
      ButtonBox["List",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/List"], "/@", 
      SuperscriptBox[
       StyleBox["p",
        FontSlant->"Italic"], 
       RowBox[{"-", "1"}]]}]}], "]"}], "==", 
   RowBox[{
    ButtonBox["Transpose",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Transpose"], "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["p", "TI"]}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->86662226],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", " ", "=", " ", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434694602],

Cell["A random permutation:", "ExampleText",
 CellID->230434525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "=", " ", 
  RowBox[{"RandomSample", "[", 
   RowBox[{"Range", "[", "4", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6402946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->761928216]
}, Open  ]],

Cell["Get its inverse:", "ExampleText",
 CellID->30453679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"invp", "=", "p"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"invp", "[", 
    RowBox[{"[", "p", "]"}], "]"}], "=", 
   RowBox[{"Range", "[", "4", "]"}]}], ";"}], "\n", "invp"}], "Input",
 CellLabel->"In[3]:=",
 CellID->586197694],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->85257485]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", 
   RowBox[{"list", ",", 
    RowBox[{"List", " ", "/@", " ", "invp"}]}], "]"}], " ", "==", " ", 
  RowBox[{"Transpose", "[", 
   RowBox[{"list", ",", " ", "p"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->300717130],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->181469811]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15345],

Cell[TextData[{
 "Peel off successive layers of ",
 Cell[BoxData[
  ButtonBox["Framed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Framed"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"#", ",", "1"}], "]"}], "&"}], ",", 
   RowBox[{"Nest", "[", 
    RowBox[{"Framed", ",", "x", ",", "6"}], "]"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox[
       FrameBox[
        FrameBox["x",
         StripOnInput->False],
        StripOnInput->False],
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox[
       FrameBox["x",
        StripOnInput->False],
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox["x",
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox["x",
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox["x",
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox["x",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{467, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221215002]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3986],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlattenAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlattenAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30249]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8437],

Cell[TextData[ButtonBox["Rearranging Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingNestedLists"]], "Tutorials",
 CellID->31969],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->2230],

Cell[TextData[ButtonBox["Sequences",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Sequences"]], "Tutorials",
 CellID->326938533]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->287545104],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->707862099],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->922059094],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->119594198],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->311334588],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->433005658],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->134284537]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Flatten"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Flatten - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 26.8910066}", "context" -> "System`", 
    "keywords" -> {
     "lists", "ravel in APL", "squash", "subexpressions", "sublists", 
      "unravel"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Flatten[list] flattens out nested lists. Flatten[list, n] flattens to \
level n. Flatten[list, n, h] flattens subexpressions with head h. \
Flatten[list, {{s_11, s_12, ...}, {s_21, s_22, ...}, ...}] flattens list by \
combining all levels s_ij to make each level i in the result. ", 
    "synonyms" -> {}, "title" -> "Flatten", "type" -> "Symbol", "uri" -> 
    "ref/Flatten"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16252, 485, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->494426351]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 57245, 2120}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3204, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3827, 98, 4191, 83, 70, "ObjectNameGrid"],
Cell[8021, 183, 2673, 86, 70, "Usage",
 CellID->12790]
}, Open  ]],
Cell[CellGroupData[{
Cell[10731, 274, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11209, 291, 271, 8, 70, "Notes",
 CellID->31634],
Cell[11483, 301, 403, 16, 70, "Notes",
 CellID->262],
Cell[11889, 319, 428, 16, 70, "Notes",
 CellID->20415],
Cell[12320, 337, 813, 30, 70, "Notes",
 CellID->29827],
Cell[13136, 369, 1341, 48, 70, "Notes",
 CellID->2267],
Cell[14480, 419, 1252, 43, 70, "Notes",
 CellID->25495],
Cell[15735, 464, 480, 16, 70, "Notes",
 CellID->27912]
}, Closed]],
Cell[CellGroupData[{
Cell[16252, 485, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->494426351],
Cell[CellGroupData[{
Cell[16637, 499, 148, 5, 70, "ExampleSection",
 CellID->218221588],
Cell[16788, 506, 71, 1, 70, "ExampleText",
 CellID->10676],
Cell[CellGroupData[{
Cell[16884, 511, 401, 14, 28, "Input",
 CellID->11788],
Cell[17288, 527, 266, 9, 36, "Output",
 CellID->13726]
}, Open  ]],
Cell[17569, 539, 119, 3, 70, "ExampleDelimiter",
 CellID->650],
Cell[17691, 544, 63, 1, 70, "ExampleText",
 CellID->19596],
Cell[CellGroupData[{
Cell[17779, 549, 437, 16, 70, "Input",
 CellID->2339],
Cell[18219, 567, 323, 10, 36, "Output",
 CellID->15546]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18591, 583, 216, 7, 70, "ExampleSection",
 CellID->15118],
Cell[CellGroupData[{
Cell[18832, 594, 239, 7, 70, "ExampleSubsection",
 CellID->65258142],
Cell[19074, 603, 56, 1, 70, "ExampleText",
 CellID->97876623],
Cell[CellGroupData[{
Cell[19155, 608, 613, 22, 70, "Input",
 CellID->785619432],
Cell[19771, 632, 609, 22, 36, "Output",
 CellID->106642297]
}, Open  ]],
Cell[20395, 657, 125, 3, 70, "ExampleDelimiter",
 CellID->192367290],
Cell[20523, 662, 62, 1, 70, "ExampleText",
 CellID->882113147],
Cell[CellGroupData[{
Cell[20610, 667, 613, 22, 70, "Input",
 CellID->136292252],
Cell[21226, 691, 502, 18, 36, "Output",
 CellID->113342960]
}, Open  ]],
Cell[21743, 712, 124, 3, 70, "ExampleDelimiter",
 CellID->50348319],
Cell[21870, 717, 62, 1, 70, "ExampleText",
 CellID->169621002],
Cell[CellGroupData[{
Cell[21957, 722, 613, 22, 70, "Input",
 CellID->312556913],
Cell[22573, 746, 389, 13, 36, "Output",
 CellID->96476900]
}, Open  ]],
Cell[22977, 762, 125, 3, 70, "ExampleDelimiter",
 CellID->474647632],
Cell[23105, 767, 62, 1, 70, "ExampleText",
 CellID->418391907],
Cell[CellGroupData[{
Cell[23192, 772, 613, 22, 70, "Input",
 CellID->110929369],
Cell[23808, 796, 315, 10, 36, "Output",
 CellID->55527204]
}, Open  ]],
Cell[24138, 809, 125, 3, 70, "ExampleDelimiter",
 CellID->507924021],
Cell[24266, 814, 62, 1, 70, "ExampleText",
 CellID->750832852],
Cell[CellGroupData[{
Cell[24353, 819, 612, 22, 70, "Input",
 CellID->57218549],
Cell[24968, 843, 292, 9, 36, "Output",
 CellID->123624416]
}, Open  ]],
Cell[25275, 855, 94, 3, 70, "ExampleText",
 CellID->19187418],
Cell[CellGroupData[{
Cell[25394, 862, 623, 22, 70, "Input",
 CellID->43151300],
Cell[26020, 886, 292, 9, 36, "Output",
 CellID->240257361]
}, Open  ]],
Cell[26327, 898, 82, 1, 70, "ExampleText",
 CellID->196096835],
Cell[CellGroupData[{
Cell[26434, 903, 570, 21, 70, "Input",
 CellID->3489744],
Cell[27007, 926, 290, 9, 36, "Output",
 CellID->8748851]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27358, 942, 239, 7, 70, "ExampleSection",
 CellID->17453],
Cell[27600, 951, 110, 2, 70, "ExampleText",
 CellID->24361],
Cell[CellGroupData[{
Cell[27735, 957, 353, 13, 70, "Input",
 CellID->25245],
Cell[28091, 972, 454, 16, 36, "Output",
 CellID->194450101]
}, Open  ]],
Cell[CellGroupData[{
Cell[28582, 993, 98, 3, 70, "Input",
 CellID->23574],
Cell[28683, 998, 439, 11, 36, "Output",
 CellID->214759294]
}, Open  ]],
Cell[29137, 1012, 120, 3, 70, "ExampleDelimiter",
 CellID->2896],
Cell[29260, 1017, 192, 7, 70, "ExampleText",
 CellID->18490],
Cell[CellGroupData[{
Cell[29477, 1028, 207, 7, 70, "Input",
 CellID->26847],
Cell[29687, 1037, 216, 7, 36, "Output",
 CellID->1676213]
}, Open  ]],
Cell[29918, 1047, 121, 3, 70, "ExampleDelimiter",
 CellID->23066],
Cell[30042, 1052, 138, 6, 70, "ExampleText",
 CellID->20527],
Cell[CellGroupData[{
Cell[30205, 1062, 312, 11, 70, "Input",
 CellID->30789],
Cell[30520, 1075, 273, 9, 36, "Output",
 CellID->474361487]
}, Open  ]],
Cell[30808, 1087, 137, 6, 70, "ExampleText",
 CellID->6702],
Cell[CellGroupData[{
Cell[30970, 1097, 311, 11, 70, "Input",
 CellID->5005],
Cell[31284, 1110, 273, 9, 36, "Output",
 CellID->468624984]
}, Open  ]],
Cell[31572, 1122, 121, 3, 70, "ExampleDelimiter",
 CellID->15120],
Cell[31696, 1127, 56, 1, 70, "ExampleText",
 CellID->31042],
Cell[CellGroupData[{
Cell[31777, 1132, 242, 9, 70, "Input",
 CellID->24253],
Cell[32022, 1143, 301, 11, 36, "Output",
 CellID->38215570]
}, Open  ]],
Cell[32338, 1157, 118, 3, 70, "ExampleText",
 CellID->67830920],
Cell[CellGroupData[{
Cell[32481, 1164, 539, 20, 70, "Input",
 CellID->26942],
Cell[33023, 1186, 797, 24, 92, "Output",
 CellID->6539288]
}, Open  ]],
Cell[33835, 1213, 126, 3, 70, "ExampleText",
 CellID->727065314],
Cell[CellGroupData[{
Cell[33986, 1220, 549, 20, 70, "Input",
 CellID->32280],
Cell[34538, 1242, 799, 24, 92, "Output",
 CellID->499446138]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35386, 1272, 223, 7, 70, "ExampleSection",
 CellID->28599],
Cell[35612, 1281, 74, 1, 70, "ExampleText",
 CellID->20885],
Cell[CellGroupData[{
Cell[35711, 1286, 97, 3, 70, "Input",
 CellID->25593],
Cell[35811, 1291, 232, 7, 36, "Output",
 CellID->43521133]
}, Open  ]],
Cell[CellGroupData[{
Cell[36080, 1303, 178, 6, 70, "Input",
 CellID->1219],
Cell[36261, 1311, 364, 10, 36, "Output",
 CellID->97302122]
}, Open  ]],
Cell[36640, 1324, 120, 3, 70, "ExampleDelimiter",
 CellID->2145],
Cell[36763, 1329, 55, 1, 70, "ExampleText",
 CellID->6571],
Cell[CellGroupData[{
Cell[36843, 1334, 252, 9, 70, "Input",
 CellID->23645],
Cell[37098, 1345, 423, 13, 36, "Output",
 CellID->42902337]
}, Open  ]],
Cell[CellGroupData[{
Cell[37558, 1363, 98, 3, 70, "Input",
 CellID->9564],
Cell[37659, 1368, 314, 9, 36, "Output",
 CellID->522357094]
}, Open  ]],
Cell[37988, 1380, 121, 3, 70, "ExampleDelimiter",
 CellID->28480],
Cell[38112, 1385, 70, 1, 70, "ExampleText",
 CellID->14560],
Cell[CellGroupData[{
Cell[38207, 1390, 252, 9, 70, "Input",
 CellID->5920],
Cell[38462, 1401, 844, 27, 36, "Output",
 CellID->170755569]
}, Open  ]],
Cell[CellGroupData[{
Cell[39343, 1433, 98, 3, 70, "Input",
 CellID->1539],
Cell[39444, 1438, 664, 19, 36, "Output",
 CellID->279678586]
}, Open  ]],
Cell[40123, 1460, 123, 3, 70, "ExampleDelimiter",
 CellID->4350419],
Cell[40249, 1465, 80, 1, 70, "ExampleText",
 CellID->614537583],
Cell[CellGroupData[{
Cell[40354, 1470, 308, 10, 70, "Input",
 CellID->312422236],
Cell[40665, 1482, 424, 14, 36, "Output",
 CellID->25023670]
}, Open  ]],
Cell[CellGroupData[{
Cell[41126, 1501, 230, 8, 70, "Input",
 CellID->328740875],
Cell[41359, 1511, 425, 14, 36, "Output",
 CellID->273590526]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41833, 1531, 237, 7, 70, "ExampleSection",
 CellID->801073205],
Cell[42073, 1540, 321, 12, 70, "ExampleText",
 CellID->10867],
Cell[CellGroupData[{
Cell[42419, 1556, 98, 3, 70, "Input",
 CellID->20726],
Cell[42520, 1561, 408, 11, 36, "Output",
 CellID->216731470]
}, Open  ]],
Cell[CellGroupData[{
Cell[42965, 1577, 124, 4, 70, "Input",
 CellID->13340],
Cell[43092, 1583, 592, 18, 36, "Output",
 CellID->334466502]
}, Open  ]],
Cell[CellGroupData[{
Cell[43721, 1606, 99, 3, 70, "Input",
 CellID->14157],
Cell[43823, 1611, 408, 11, 36, "Output",
 CellID->102733808]
}, Open  ]],
Cell[44246, 1625, 125, 3, 70, "ExampleDelimiter",
 CellID->673105231],
Cell[44374, 1630, 247, 8, 70, "ExampleText",
 CellID->8159],
Cell[CellGroupData[{
Cell[44646, 1642, 205, 7, 70, "Input",
 CellID->8576],
Cell[44854, 1651, 950, 31, 54, "Output",
 CellID->5324263]
}, Open  ]],
Cell[CellGroupData[{
Cell[45841, 1687, 322, 11, 70, "Input",
 CellID->26841],
Cell[46166, 1700, 527, 12, 54, "Output",
 CellID->400612675]
}, Open  ]],
Cell[46708, 1715, 125, 3, 70, "ExampleDelimiter",
 CellID->333138007],
Cell[46836, 1720, 814, 32, 70, "ExampleText",
 CellID->86662226],
Cell[47653, 1754, 310, 11, 70, "Input",
 CellID->434694602],
Cell[47966, 1767, 64, 1, 70, "ExampleText",
 CellID->230434525],
Cell[CellGroupData[{
Cell[48055, 1772, 172, 5, 70, "Input",
 CellID->6402946],
Cell[48230, 1779, 223, 7, 36, "Output",
 CellID->761928216]
}, Open  ]],
Cell[48468, 1789, 58, 1, 70, "ExampleText",
 CellID->30453679],
Cell[CellGroupData[{
Cell[48551, 1794, 270, 9, 70, "Input",
 CellID->586197694],
Cell[48824, 1805, 222, 7, 36, "Output",
 CellID->85257485]
}, Open  ]],
Cell[CellGroupData[{
Cell[49083, 1817, 274, 8, 70, "Input",
 CellID->300717130],
Cell[49360, 1827, 161, 5, 36, "Output",
 CellID->181469811]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49570, 1838, 224, 7, 70, "ExampleSection",
 CellID->15345],
Cell[49797, 1847, 205, 8, 70, "ExampleText",
 CellID->20020],
Cell[CellGroupData[{
Cell[50027, 1859, 289, 10, 70, "Input",
 CellID->9936],
Cell[50319, 1871, 1378, 59, 89, "Output",
 CellID->221215002]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51758, 1937, 310, 9, 70, "SeeAlsoSection",
 CellID->3986],
Cell[52071, 1948, 955, 35, 70, "SeeAlso",
 CellID->30249]
}, Open  ]],
Cell[CellGroupData[{
Cell[53063, 1988, 313, 9, 70, "TutorialsSection",
 CellID->8437],
Cell[53379, 1999, 157, 3, 70, "Tutorials",
 CellID->31969],
Cell[53539, 2004, 151, 3, 70, "Tutorials",
 CellID->2230],
Cell[53693, 2009, 133, 3, 70, "Tutorials",
 CellID->326938533]
}, Open  ]],
Cell[CellGroupData[{
Cell[53863, 2017, 319, 9, 70, "MoreAboutSection",
 CellID->287545104],
Cell[54185, 2028, 134, 3, 70, "MoreAbout",
 CellID->707862099],
Cell[54322, 2033, 155, 3, 70, "MoreAbout",
 CellID->922059094],
Cell[54480, 2038, 145, 3, 70, "MoreAbout",
 CellID->119594198],
Cell[54628, 2043, 177, 3, 70, "MoreAbout",
 CellID->311334588],
Cell[54808, 2048, 181, 3, 70, "MoreAbout",
 CellID->433005658],
Cell[54992, 2053, 164, 3, 70, "MoreAbout",
 CellID->134284537]
}, Open  ]],
Cell[CellGroupData[{
Cell[55193, 2061, 305, 8, 70, "RelatedLinksSection"],
Cell[55501, 2071, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[55901, 2087, 50, 0, 70, "History"],
Cell[55954, 2089, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

