(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17668,        601]
NotebookOptionsPosition[     14394,        495]
NotebookOutlinePosition[     15890,        534]
CellTagsIndexPosition[     15805,        529]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/StructuralOperations"], 
          "Sequences" :> 
          Documentation`HelpLookup["paclet:tutorial/Sequences"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Structural Operations\"\>", 
       2->"\<\"Sequences\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeleteCases" :> 
          Documentation`HelpLookup["paclet:ref/DeleteCases"], "Flatten" :> 
          Documentation`HelpLookup["paclet:ref/Flatten"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"], "SlotSequence" :> 
          Documentation`HelpLookup["paclet:ref/SlotSequence"], "Delete" :> 
          Documentation`HelpLookup["paclet:ref/Delete"], "Insert" :> 
          Documentation`HelpLookup["paclet:ref/Insert"], "MapAt" :> 
          Documentation`HelpLookup["paclet:ref/MapAt"], "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"], "ArrayFlatten" :> 
          Documentation`HelpLookup["paclet:ref/ArrayFlatten"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DeleteCases\"\>", 
       2->"\<\"Flatten\"\>", 3->"\<\"Sequence\"\>", 4->"\<\"SlotSequence\"\>",
        5->"\<\"Delete\"\>", 6->"\<\"Insert\"\>", 7->"\<\"MapAt\"\>", 
       8->"\<\"ReplacePart\"\>", 
       9->"\<\"ArrayFlatten\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Expressions\"\>", 
       2->"\<\"Rearranging & Restructuring Lists\"\>", 
       3->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FlattenAt", "ObjectName",
 CellID->10643],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FlattenAt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FlattenAt"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]flattens out a sublist that appears as the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox[
        RowBox[{
         StyleBox["n", "TI"], "\[Null]"}]], "th"]], "InlineFormula"],
     " element of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". If ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is negative, the position is counted from the end. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FlattenAt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FlattenAt"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          StyleBox["j", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]flattens out the part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at position ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FlattenAt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FlattenAt"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["1", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]flattens out parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at several positions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->25735]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->31174253],

Cell["Flatten at position 2:", "ExampleText",
 CellID->21881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlattenAt", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23287],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", "f", "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3597]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3083],

Cell["Flatten at positions 2 and 4:", "ExampleText",
 CellID->26239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlattenAt", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", "f", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19273],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", "f"}], "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11304]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FlattenAt", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", "a", "}"}], ",", 
       RowBox[{"{", "b", "}"}], ",", 
       RowBox[{"{", "c", "}"}], ",", 
       RowBox[{"{", "d", "}"}]}], "]"}], ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "b", "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", "b", ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", "b", "}"}], ",", "c", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", "b", "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{550, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20478]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26853],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SlotSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlotSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Delete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Delete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Insert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Insert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6936]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23797],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->9470],

Cell[TextData[ButtonBox["Sequences",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Sequences"]], "Tutorials",
 CellID->326938533]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->710525354],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->302909687],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->189621]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FlattenAt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 26.5941240}", "context" -> "System`", 
    "keywords" -> {"splicing", "unpack"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FlattenAt[list, n] flattens out a sublist that appears as the n\\[Null] \
th element of list. If n is negative, the position is counted from the end. \
FlattenAt[expr, {i, j, ...}] flattens out the part of expr at position {i, j, \
...}. FlattenAt[expr, {{i_1, j_1, ...}, {i_2, j_2, ...}, ...}] flattens out \
parts of expr at several positions. ", "synonyms" -> {"flatten at"}, "title" -> 
    "FlattenAt", "type" -> "Symbol", "uri" -> "ref/FlattenAt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6564, 190, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15670, 522}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3054, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3677, 94, 47, 1, 70, "ObjectName",
 CellID->10643],
Cell[3727, 97, 2800, 88, 70, "Usage",
 CellID->25735]
}, Open  ]],
Cell[CellGroupData[{
Cell[6564, 190, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[6941, 204, 147, 5, 70, "ExampleSection",
 CellID->31174253],
Cell[7091, 211, 61, 1, 70, "ExampleText",
 CellID->21881],
Cell[CellGroupData[{
Cell[7177, 216, 325, 11, 28, "Input",
 CellID->23287],
Cell[7505, 229, 302, 10, 36, "Output",
 CellID->3597]
}, Open  ]],
Cell[7822, 242, 120, 3, 70, "ExampleDelimiter",
 CellID->3083],
Cell[7945, 247, 68, 1, 70, "ExampleText",
 CellID->26239],
Cell[CellGroupData[{
Cell[8038, 252, 426, 15, 28, "Input",
 CellID->19273],
Cell[8467, 269, 279, 9, 36, "Output",
 CellID->11304]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8795, 284, 223, 7, 70, "ExampleSection",
 CellID->25669],
Cell[CellGroupData[{
Cell[9043, 295, 421, 14, 70, "Input",
 CellID->15392],
Cell[9467, 311, 828, 27, 36, "Output",
 CellID->20478]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10356, 345, 311, 9, 70, "SeeAlsoSection",
 CellID->26853],
Cell[10670, 356, 2177, 80, 70, "SeeAlso",
 CellID->6936]
}, Open  ]],
Cell[CellGroupData[{
Cell[12884, 441, 314, 9, 70, "TutorialsSection",
 CellID->23797],
Cell[13201, 452, 151, 3, 70, "Tutorials",
 CellID->9470],
Cell[13355, 457, 133, 3, 70, "Tutorials",
 CellID->326938533]
}, Open  ]],
Cell[CellGroupData[{
Cell[13525, 465, 299, 8, 70, "MoreAboutSection"],
Cell[13827, 475, 134, 3, 70, "MoreAbout",
 CellID->710525354],
Cell[13964, 480, 177, 3, 70, "MoreAbout",
 CellID->302909687],
Cell[14144, 485, 178, 3, 70, "MoreAbout",
 CellID->189621]
}, Open  ]],
Cell[14337, 491, 27, 0, 70, "History"],
Cell[14367, 493, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

