(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19471,        709]
NotebookOptionsPosition[     15337,        573]
NotebookOutlinePosition[     16834,        613]
CellTagsIndexPosition[     16749,        608]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "String Representation of Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringRepresentationOfBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"String Representation of Boxes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TagBox" :> Documentation`HelpLookup["paclet:ref/TagBox"], 
          "InterpretationBox" :> 
          Documentation`HelpLookup["paclet:ref/InterpretationBox"], 
          "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], 
          "MakeExpression" :> 
          Documentation`HelpLookup["paclet:ref/MakeExpression"], 
          "Interpretation" :> 
          Documentation`HelpLookup["paclet:ref/Interpretation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TagBox\"\>", 
       2->"\<\"InterpretationBox\"\>", 3->"\<\"ToExpression\"\>", 
       4->"\<\"MakeExpression\"\>", 
       5->"\<\"Interpretation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FormBox", "ObjectName",
 CellID->5865],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FormBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FormBox"], "[", 
       RowBox[{
        StyleBox["boxes", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level box construct which displays as ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " but specifies that rules associated with ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " should be used to interpret ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " on input. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2210]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " \[Backslash]",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["form", "TI"]}]], "InlineFormula"],
 "\[Backslash]",
 Cell[BoxData[
  StyleBox[
   RowBox[{"`", 
    StyleBox["input", "TI"]}]]], "InlineFormula"],
 "\[Backslash]",
 Cell[BoxData[")"], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FormBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormBox"], "[", 
   RowBox[{
    StyleBox["input", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20624],

Cell[TextData[{
 "\[Backslash]",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"\[Backslash]", 
    StyleBox[
     RowBox[{"`", 
      StyleBox["input", "TI"]}]]}]}]], "InlineFormula"],
 "\[Backslash]",
 Cell[BoxData[")"], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FormBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormBox"], "[", 
   RowBox[{
    StyleBox["input", "TI"], ",", "RawForm"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15785]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->573637476],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->69735585],

Cell[TextData[{
 "Create a cell with ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " style settings applied:"
}], "ExampleText",
 CellID->504798212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"FormBox", "[", 
      RowBox[{
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{
         "\"\<sin\>\"", ",", "\"\<(\>\"", ",", "\"\<x\>\"", ",", 
          "\"\<)\>\""}], "}"}], "]"}], ",", "TraditionalForm"}], "]"}], "]"}],
     ",", "\"\<Output\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->658219872],

Cell[BoxData[
 FormBox[
  RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115834642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71589111],

Cell[TextData[{
 "Create a cell with ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " style settings applied:"
}], "ExampleText",
 CellID->115074377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"BoxData", "[", 
     RowBox[{"FormBox", "[", 
      RowBox[{
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{
         "\"\<sin\>\"", ",", "\"\<(\>\"", ",", "\"\<x\>\"", ",", 
          "\"\<)\>\""}], "}"}], "]"}], ",", "StandardForm"}], "]"}], "]"}], 
    ",", "\"\<Output\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124301210],

Cell[BoxData[
 RowBox[{"sin", "(", "x", ")"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1925016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->479609777],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FormBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FormBox"]], "InlineFormula"],
 " affects interpretation of its contents:"
}], "ExampleText",
 CellID->528705324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ToExpression", "[", 
    RowBox[{"FormBox", "[", 
     RowBox[{
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<f\>\"", ",", "\"\<(\>\"", ",", "\"\<x\>\"", ",", "\"\<)\>\""}], 
        "}"}], "]"}], ",", "fm"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"fm", ",", 
     RowBox[{"{", 
      RowBox[{"TraditionalForm", ",", "StandardForm"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457229843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", " ", "x"}]}], "}"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224794531]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->265225838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"f", "[", "x", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Times", "[", 
      RowBox[{"f", ",", "x"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333075915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->769973770],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting uses ",
 Cell[BoxData[
  ButtonBox["FormBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FormBox"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1035817502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "TraditionalForm"}], "]"}], "//",
   "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->531305627],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"FormBox", "[", 
    RowBox[{
     RowBox[{"FractionBox", "[", 
      RowBox[{"\"\<x\>\"", ",", 
       RowBox[{"SqrtBox", "[", 
        RowBox[{"RowBox", "[", 
         RowBox[{"List", "[", 
          RowBox[{"\"\<1\>\"", ",", "\"\<-\>\"", ",", 
           RowBox[{"SuperscriptBox", "[", 
            RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}]}], "]"}], "]"}], 
        "]"}]}], "]"}], ",", "TraditionalForm"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{581, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->309261446]
}, Open  ]],

Cell["The formatted result looks like this:", "ExampleText",
 CellID->252116026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "/", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", 
     RowBox[{"x", "^", "2"}]}], "]"}]}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23975829],

Cell[BoxData[
 FormBox[
  FractionBox["x", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]], TraditionalForm]], "Output",
 ImageSize->{56, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->198669103]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24195],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpretationBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpretationBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpretation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpretation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16132]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4897],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->14878],

Cell[TextData[ButtonBox["String Representation of Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringRepresentationOfBoxes"]], "Tutorials",
 CellID->187054374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->434988936]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FormBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 55.7667458}", "context" -> "System`", 
    "keywords" -> {
     "hidden box data", "magic cookies", "disambiguation", 
      "interpretation data", "interpretation hints", "parsing hints", 
      "parsing interpretation", "semantic hints", "semantic markup"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FormBox[boxes, form] is a low-level box construct which displays as \
boxes but specifies that rules associated with form should be used to \
interpret boxes on input. ", "synonyms" -> {"form box"}, "title" -> "FormBox",
     "type" -> "Symbol", "uri" -> "ref/FormBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5912, 199, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->573637476]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16606, 601}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2524, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3147, 88, 44, 1, 70, "ObjectName",
 CellID->5865],
Cell[3194, 91, 862, 26, 70, "Usage",
 CellID->2210]
}, Open  ]],
Cell[CellGroupData[{
Cell[4093, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4571, 139, 814, 33, 70, "Notes",
 CellID->20624],
Cell[5388, 174, 487, 20, 70, "Notes",
 CellID->15785]
}, Closed]],
Cell[CellGroupData[{
Cell[5912, 199, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->573637476],
Cell[CellGroupData[{
Cell[6297, 213, 147, 5, 70, "ExampleSection",
 CellID->69735585],
Cell[6447, 220, 239, 8, 70, "ExampleText",
 CellID->504798212],
Cell[CellGroupData[{
Cell[6711, 232, 464, 14, 47, "Input",
 CellID->658219872],
Cell[7178, 248, 216, 7, 36, "Output",
 CellID->115834642]
}, Open  ]],
Cell[7409, 258, 124, 3, 70, "ExampleDelimiter",
 CellID->71589111],
Cell[7536, 263, 233, 8, 70, "ExampleText",
 CellID->115074377],
Cell[CellGroupData[{
Cell[7794, 275, 461, 14, 70, "Input",
 CellID->124301210],
Cell[8258, 291, 185, 6, 36, "Output",
 CellID->1925016]
}, Open  ]],
Cell[8458, 300, 125, 3, 70, "ExampleDelimiter",
 CellID->479609777],
Cell[8586, 305, 215, 7, 70, "ExampleText",
 CellID->528705324],
Cell[CellGroupData[{
Cell[8826, 316, 522, 17, 70, "Input",
 CellID->457229843],
Cell[9351, 335, 256, 9, 36, "Output",
 CellID->224794531]
}, Open  ]],
Cell[CellGroupData[{
Cell[9644, 349, 100, 3, 70, "Input",
 CellID->265225838],
Cell[9747, 354, 563, 22, 36, "Output",
 CellID->333075915]
}, Open  ]],
Cell[10325, 379, 125, 3, 70, "ExampleDelimiter",
 CellID->769973770],
Cell[10453, 384, 332, 12, 70, "ExampleText",
 CellID->1035817502],
Cell[CellGroupData[{
Cell[10810, 400, 289, 10, 70, "Input",
 CellID->531305627],
Cell[11102, 412, 721, 22, 68, "Output",
 CellID->309261446]
}, Open  ]],
Cell[11838, 437, 80, 1, 70, "ExampleText",
 CellID->252116026],
Cell[CellGroupData[{
Cell[11943, 442, 212, 7, 70, "Input",
 CellID->23975829],
Cell[12158, 451, 289, 10, 75, "Output",
 CellID->198669103]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12508, 468, 311, 9, 70, "SeeAlsoSection",
 CellID->24195],
Cell[12822, 479, 1232, 44, 70, "SeeAlso",
 CellID->16132]
}, Open  ]],
Cell[CellGroupData[{
Cell[14091, 528, 313, 9, 70, "TutorialsSection",
 CellID->4897],
Cell[14407, 539, 179, 4, 70, "Tutorials",
 CellID->14878],
Cell[14589, 545, 172, 3, 70, "Tutorials",
 CellID->187054374]
}, Open  ]],
Cell[CellGroupData[{
Cell[14798, 553, 299, 8, 70, "MoreAboutSection"],
Cell[15100, 563, 165, 3, 70, "MoreAbout",
 CellID->434988936]
}, Open  ]],
Cell[15280, 569, 27, 0, 70, "History"],
Cell[15310, 571, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

