(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     79557,       1721]
NotebookOptionsPosition[     74951,       1566]
NotebookOutlinePosition[     76273,       1603]
CellTagsIndexPosition[     76187,       1598]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formats for Text in Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FormatsForTextInGraphics"], "Files and Streams" :> 
          Documentation`HelpLookup["paclet:tutorial/FilesAndStreams"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Formats for Text in Graphics\"\>", 
       2->"\<\"Files and Streams\"\>", 
       3->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>", 
       4->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BaseStyle" :> Documentation`HelpLookup["paclet:ref/BaseStyle"],
           "LanguageCategory" :> 
          Documentation`HelpLookup["paclet:ref/LanguageCategory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BaseStyle\"\>", 
       2->"\<\"LanguageCategory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graphics Annotation & Appearance\"\>", 
       2->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FormatType", "ObjectName",
 CellID->29904],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FormatType",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FormatType"]], "InlineFormula"],
     "\[LineSeparator]is an option for output streams, graphics and functions \
such as ",
     Cell[BoxData[
      ButtonBox["Text",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Text"]], "InlineFormula"],
     " which specifies the default format type to use when outputting \
expressions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData[
  ButtonBox["FormatType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FormatType"]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->27742400],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "inherit from surrounding constructs", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["InputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputForm"], Cell["\<\
one\[Hyphen]dimensional form suitable for direct keyboard input \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OutputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/OutputForm"], Cell["\<\
character\[Hyphen]based two\[Hyphen]dimensional form \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["StandardForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StandardForm"], Cell[
    "standard two\[Hyphen]dimensional form ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TraditionalForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraditionalForm"], Cell[
    "form approximating traditional mathematical notation ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->3928],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", 
    RowBox[{"FormatType", "->", 
     StyleBox["type", "TI"]}]}], "]"}]], "InlineFormula"],
 " resets the format type for an open stream. "
}], "Notes",
 CellID->28537],

Cell[TextData[{
 "For graphics functions box\[Hyphen]based format types such as ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " can be used only when a notebook front end is present. "
}], "Notes",
 CellID->23054]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52051347],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->545970245],

Cell[TextData[{
 "By default, expressions are displayed using ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " in graphics:"
}], "ExampleText",
 CellID->130415530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Circle", "[", "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", "20"}], "]"}], 
     "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35379963],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], InsetBox[
    StyleBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[LongEqual]", "1"}],
     StripOnInput->False,
     FontSize->20], {0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->43613938]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->289335594],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], Text3DBox[
    FormBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "\[LongEqual]", "1"}], TraditionalForm], {
    0, 0, 0}]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->960351550,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127269120],

Cell[TextData[{
 "Display expressions using ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->260195582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", "20"}], "]"}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22410898],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], InsetBox[
    StyleBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "1"}],
     StripOnInput->False,
     FontSize->20], {0, 0}]},
  FormatType->StandardForm]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->568760808]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "+", 
         RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141409998],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], Text3DBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "\[Equal]", "1"}], {0, 0, 0}]},
  FormatType->StandardForm]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1560922804,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297735380],

Cell[TextData[{
 "Labels are also affected by the ",
 Cell[BoxData[
  ButtonBox["FormatType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FormatType"]], "InlineFormula"],
 " setting:"
}], "ExampleText",
 CellID->153438732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60375871],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Cos", "[", "\[Theta]", "]"}], StandardForm], 
    FormBox[
     RowBox[{"Sin", "[", "\[Theta]", "]"}], StandardForm]},
  FormatType->StandardForm]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70881370]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21833],

Cell["\<\
When different format types are combined the result is likely unpredictable: \
\
\>", "ExampleText",
 CellID->226240286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"TraditionalForm", "@", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41856964],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531273653]
}, Open  ]],

Cell["This is equivalent to: ", "ExampleText",
 CellID->106728617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"TraditionalForm", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23353568],

Cell[BoxData[
 TagBox[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}],
   TraditionalForm],
  TraditionalForm,
  Editable->True]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//StandardForm=",
 CellID->166372388]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27556],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LanguageCategory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LanguageCategory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23602]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13270],

Cell[TextData[ButtonBox["Formats for Text in Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormatsForTextInGraphics"]], "Tutorials",
 CellID->3607],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreams"]], "Tutorials",
 CellID->478647659],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->398533142],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->184088418],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->60548289]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FormatType - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 52.0322752}", "context" -> "System`", 
    "keywords" -> {"options for output"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FormatType is an option for output streams, graphics and functions such \
as Text which specifies the default format type to use when outputting \
expressions. ", "synonyms" -> {"format type"}, "title" -> "FormatType", 
    "type" -> "Symbol", "uri" -> "ref/FormatType"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6978, 213, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->52051347]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 76045, 1591}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2584, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3207, 87, 48, 1, 70, "ObjectName",
 CellID->29904],
Cell[3258, 90, 667, 20, 70, "Usage",
 CellID->2555]
}, Open  ]],
Cell[CellGroupData[{
Cell[3962, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4440, 132, 209, 8, 70, "Notes",
 CellID->27742400],
Cell[4652, 142, 1486, 37, 70, "2ColumnTableMod",
 CellID->3928],
Cell[6141, 181, 356, 12, 70, "Notes",
 CellID->28537],
Cell[6500, 195, 441, 13, 70, "Notes",
 CellID->23054]
}, Closed]],
Cell[CellGroupData[{
Cell[6978, 213, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52051347],
Cell[CellGroupData[{
Cell[7362, 227, 148, 5, 70, "ExampleSection",
 CellID->545970245],
Cell[7513, 234, 253, 8, 70, "ExampleText",
 CellID->130415530],
Cell[CellGroupData[{
Cell[7791, 246, 406, 14, 28, "Input",
 CellID->35379963],
Cell[8200, 262, 447, 14, 171, "Output",
 CellID->43613938]
}, Open  ]],
Cell[CellGroupData[{
Cell[8684, 281, 469, 16, 70, "Input",
 CellID->289335594],
Cell[9156, 299, 27739, 463, 184, 288, 8, "CachedBoxData", "BoxData", "Output",
 
 CellID->960351550]
}, Open  ]],
Cell[36910, 765, 125, 3, 70, "ExampleDelimiter",
 CellID->127269120],
Cell[37038, 770, 217, 8, 70, "ExampleText",
 CellID->260195582],
Cell[CellGroupData[{
Cell[37280, 782, 490, 16, 70, "Input",
 CellID->22410898],
Cell[37773, 800, 472, 15, 171, "Output",
 CellID->568760808]
}, Open  ]],
Cell[CellGroupData[{
Cell[38282, 820, 551, 17, 70, "Input",
 CellID->141409998],
Cell[38836, 839, 27718, 461, 184, 271, 7, "CachedBoxData", "BoxData", \
"Output",
 CellID->1560922804]
}, Open  ]],
Cell[66569, 1303, 125, 3, 70, "ExampleDelimiter",
 CellID->297735380],
Cell[66697, 1308, 227, 8, 70, "ExampleText",
 CellID->153438732],
Cell[CellGroupData[{
Cell[66949, 1320, 432, 12, 70, "Input",
 CellID->60375871],
Cell[67384, 1334, 391, 13, 168, "Output",
 CellID->70881370]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67824, 1353, 226, 7, 70, "ExampleSection",
 CellID->21833],
Cell[68053, 1362, 130, 4, 70, "ExampleText",
 CellID->226240286],
Cell[CellGroupData[{
Cell[68208, 1370, 440, 12, 70, "Input",
 CellID->41856964],
Cell[68651, 1384, 3100, 55, 70, "Output",
 Evaluatable->False,
 CellID->531273653]
}, Open  ]],
Cell[71766, 1442, 66, 1, 70, "ExampleText",
 CellID->106728617],
Cell[CellGroupData[{
Cell[71857, 1447, 180, 5, 70, "Input",
 CellID->23353568],
Cell[72040, 1454, 282, 11, 50, "Output",
 CellID->166372388]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72383, 1472, 311, 9, 70, "SeeAlsoSection",
 CellID->27556],
Cell[72697, 1483, 469, 17, 70, "SeeAlso",
 CellID->23602]
}, Open  ]],
Cell[CellGroupData[{
Cell[73203, 1505, 314, 9, 70, "TutorialsSection",
 CellID->13270],
Cell[73520, 1516, 162, 3, 70, "Tutorials",
 CellID->3607],
Cell[73685, 1521, 147, 3, 70, "Tutorials",
 CellID->478647659],
Cell[73835, 1526, 191, 4, 70, "Tutorials",
 CellID->11451],
Cell[74029, 1532, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[74223, 1540, 319, 9, 70, "MoreAboutSection",
 CellID->398533142],
Cell[74545, 1551, 175, 3, 70, "MoreAbout",
 CellID->184088418],
Cell[74723, 1556, 133, 3, 70, "MoreAbout",
 CellID->60548289]
}, Open  ]],
Cell[74871, 1562, 50, 0, 70, "History"],
Cell[74924, 1564, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

