(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23807,        923]
NotebookOptionsPosition[     17736,        707]
NotebookOutlinePosition[     19048,        745]
CellTagsIndexPosition[     18963,        740]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generating C and Fortran Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GeneratingCAndFortranExpressions"], 
          "Forms of Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FormsOfInputAndOutput"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Generating C and Fortran Expressions\"\>", 
       2->"\<\"Forms of Input and Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CForm" :> Documentation`HelpLookup["paclet:ref/CForm"], 
          "Compile" :> Documentation`HelpLookup["paclet:ref/Compile"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"CForm\"\>", 
       2->"\<\"Compile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Display of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FortranForm", "ObjectName",
 CellID->15122],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FortranForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FortranForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as a Fortran language version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22511]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Standard arithmetic functions and certain control structures are translated. \
\
\>", "Notes",
 CellID->14329],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->11628],

Cell[TextData[{
 "The width of output lines must be set explicitly by giving the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PageWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageWidth"], "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " for the relevant output stream. "
}], "Notes",
 CellID->8207],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"], "[", 
   RowBox[{
    ButtonBox["$Output",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Output"], ",", 
    RowBox[{
     ButtonBox["PageWidth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PageWidth"], "->", "72"}]}], "]"}]], 
  "InlineFormula"],
 " uses a line width of 72 characters for standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. "
}], "Notes",
 CellID->21537],

Cell["No declarations are generated. ", "Notes",
 CellID->17707]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->75561539],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->461410452],

Cell["A Fortran language version of a polynomial:", "ExampleText",
 CellID->551017233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}], "+", 
   RowBox[{"3", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->608693877],

Cell["1 + 2*x + 3*x**2", "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FortranForm=",
 CellID->1266635]
}, Open  ]],

Cell["A mixed numeric and symbolic expression:", "ExampleText",
 CellID->120247557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{
   RowBox[{"1.2", " ", "x"}], "+", 
   RowBox[{"Exp", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194108971],

Cell["E**y + 1.2*x", "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FortranForm=",
 CellID->202752339]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->350058743],

Cell["Fortran formatting for an arbitrary function:", "ExampleText",
 CellID->458199205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{"f", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->751320023],

Cell["f(x)", "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FortranForm=",
 CellID->220700577]
}, Open  ]],

Cell["A composite power:", "ExampleText",
 CellID->430667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{"f", "^", 
   RowBox[{"g", "[", 
    RowBox[{"h", "[", "x", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14082873],

Cell["f**g(h(x))", "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FortranForm=",
 CellID->37186117]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17458613],

Cell["\<\
Compute terms of the analytic Hessian for a multivariate function for use in \
Fortran code:\
\>", "ExampleText",
 CellID->3523600],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{
     RowBox[{"y", "^", "3"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159635990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "}"}]}], "]"}], "//", 
  "Flatten"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->621847130],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{
     SuperscriptBox["y", "3"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"3", " ", 
    SuperscriptBox["y", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], ",", 
   RowBox[{"3", " ", 
    SuperscriptBox["y", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], ",", 
   RowBox[{"6", " ", "y", " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{326, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->342409661]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "/@", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->194585093],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWNtOwzAM9ZqWjcsugLgKpL1xeUF8AwKe+IgJIcEDAgG/Cb804i6G7tRt
0i1FVNpap3HOObGdtL2bfDw+PE8+nu4n49u3yevj0/37+OblzTaZDlHnk4iG
+2Svp/Yq//HxZX9EKf8baZvSof1LrXkN7V2wM7APFvRbFu+8oZ/JVRtoPQb7
CuxVsHnWEmseLegXC+/U44fqE1U9t2bW3IX2PfvH5iCnMGun/DDOYwYgh7iv
FPrPDuaeuDNmHNpdhzqC9l2HOXD3U3dmLgzWWwq1V4G641CHraBWae3/6YxX
ZwVlxTHJ5QiPWawzAgwSRiXvDHplBaYlbC8XrPVkfhYAT5T/sPey60bXWu6l
K4uttxdVr65k5R/pbRZfjflfZ2W5HhFNW7EYvLjmk8S6xk/bW3Dc5VUbZW75
ctODjjHyqcHxkYe69tXmLrKoU7MVWQ3i+vrHVdNvPJoW+XbzB7V0cn/cu3Ce
dqZaDWauxrGKhGWmRKzdahDUzMtXy3NuD8sQ5mMUdaF5Hs5Ti197PPUMlrkp
s5U77UY57HkLM3s7CFN7osQ9XEY3VN575BkRFatvDrW72LACWY+sTwdGxLdn
6iixduhRVG1435cv7WrjmkmDtWn13G5ehVWPtrIaKX6S4wB6rStYxq07iSxA
zrfZmx6u7GsL8ZHZTYsxCuaAq7bOYR96bUTl0Adb3t7nOSBmvDgs8657obai
IkbFLyf4NDFQRzqtHl99765DGKpeJ2qrziYIoWCPF5gH/XuUFiM2L91ZdhbJ
grw7+OAXFFzNRm6s88KYnER7Hj9ZR86mv19qmviNI3DXv2Hy5VfAFXW+AShI
W58=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79499212]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->390731684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 " formats expressions like Fortran code:"
}], "ExampleText",
 CellID->57980832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}], "+", 
   RowBox[{"3", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653451490],

Cell["1 + 2*x + 3*x**2", "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FortranForm=",
 CellID->232446367]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CForm"]], "InlineFormula"],
 " formats expressions like C code:"
}], "ExampleText",
 CellID->71117676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "x"}], "+", 
   RowBox[{"3", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->130576372],

Cell["1 + 2*x + 3*Power(x,2)", "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//CForm=",
 CellID->190547792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58411151],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " can be used to convert expressions in a file: "
}], "ExampleText",
 CellID->636006957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "5"}], ",", " ", "x"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329129734],

Cell["(-5*Cos(x))/8. + (5*Cos(3*x))/48. - Cos(5*x)/80.", "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FortranForm=",
 CellID->559636299]
}, Open  ]],

Cell["\<\
The following Fortran file contains the unevaluated integral:\
\>", "ExampleText",
 CellID->5218386],

Cell[BoxData[
 RowBox[{
  RowBox[{"ifile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"\"\<ExampleData\>\"", ",", "\"\<splicefile.mf\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202677003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "ifile", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->641697745],

Cell["\<\
program calculation

implicit none
real x,y

x=3.
y = <* Integrate[Sin[x]^5, x] *> 

print *,2.*y-1.

end program\
\>", "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->488729582]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " inserts the result of the integral:"
}], "ExampleText",
 CellID->35240128],

Cell[BoxData[
 RowBox[{
  RowBox[{"ofile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"$TemporaryPrefix", ",", "\"\<spliceoutput.f\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6722148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Splice", "[", 
  RowBox[{"ifile", ",", "ofile"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->499700900],

Cell[BoxData["\<\"ExampleData\\\\splicefile.mf\"\>"], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->334536159]
}, Open  ]],

Cell["The resulting output file:", "ExampleText",
 CellID->323774926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "ofile", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->738229338],

Cell["\<\
program calculation

implicit none
real x,y

x=3.
y = (-5*Cos(x))/8. + (5*Cos(3*x))/48. - Cos(5*x)/80. 

print *,2.*y-1.

end program\
\>", "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->98288771]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->495709264],

Cell["\<\
Additional Fortran function definitions may be needed to run the code:\
\>", "ExampleText",
 CellID->41702638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", 
  RowBox[{"BesselJ", "[", 
   RowBox[{"x", ",", "7"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114469161],

Cell["BesselJ(x,7)", "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FortranForm=",
 CellID->83650851]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29900],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2011]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30397],

Cell[TextData[ButtonBox["Generating C and Fortran Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneratingCAndFortranExpressions"]], "Tutorials",\

 CellID->3754],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "Tutorials",
 CellID->20712]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->644343800],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->10037227]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FortranForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 56.5948920}", "context" -> "System`", 
    "keywords" -> {
     "code generation", "Fortran", "Fortran form", "Fortran output", 
      "language conversion"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FortranForm[expr] prints as a Fortran language version of expr. ", 
    "synonyms" -> {"fortran form"}, "title" -> "FortranForm", "type" -> 
    "Symbol", "uri" -> "ref/FortranForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5178, 176, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->75561539]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18821, 733}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2031, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2654, 77, 49, 1, 70, "ObjectName",
 CellID->15122],
Cell[2706, 80, 570, 18, 70, "Usage",
 CellID->22511]
}, Open  ]],
Cell[CellGroupData[{
Cell[3313, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3791, 120, 120, 4, 70, "Notes",
 CellID->14329],
Cell[3914, 126, 286, 8, 70, "Notes",
 CellID->11628],
Cell[4203, 136, 323, 10, 70, "Notes",
 CellID->8207],
Cell[4529, 148, 545, 20, 70, "Notes",
 CellID->21537],
Cell[5077, 170, 64, 1, 70, "Notes",
 CellID->17707]
}, Closed]],
Cell[CellGroupData[{
Cell[5178, 176, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->75561539],
Cell[CellGroupData[{
Cell[5562, 190, 148, 5, 70, "ExampleSection",
 CellID->461410452],
Cell[5713, 197, 86, 1, 70, "ExampleText",
 CellID->551017233],
Cell[CellGroupData[{
Cell[5824, 202, 203, 7, 28, "Input",
 CellID->608693877],
Cell[6030, 211, 176, 5, 50, "Output",
 CellID->1266635]
}, Open  ]],
Cell[6221, 219, 83, 1, 70, "ExampleText",
 CellID->120247557],
Cell[CellGroupData[{
Cell[6329, 224, 187, 6, 28, "Input",
 CellID->194108971],
Cell[6519, 232, 173, 5, 50, "Output",
 CellID->202752339]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6741, 243, 220, 7, 70, "ExampleSection",
 CellID->350058743],
Cell[6964, 252, 88, 1, 70, "ExampleText",
 CellID->458199205],
Cell[CellGroupData[{
Cell[7077, 257, 135, 4, 70, "Input",
 CellID->751320023],
Cell[7215, 263, 165, 5, 50, "Output",
 CellID->220700577]
}, Open  ]],
Cell[7395, 271, 58, 1, 70, "ExampleText",
 CellID->430667],
Cell[CellGroupData[{
Cell[7478, 276, 188, 6, 70, "Input",
 CellID->14082873],
Cell[7669, 284, 170, 5, 50, "Output",
 CellID->37186117]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7888, 295, 226, 7, 70, "ExampleSection",
 CellID->17458613],
Cell[8117, 304, 141, 4, 70, "ExampleText",
 CellID->3523600],
Cell[8261, 310, 243, 9, 70, "Input",
 CellID->159635990],
Cell[CellGroupData[{
Cell[8529, 323, 260, 10, 70, "Input",
 CellID->621847130],
Cell[8792, 335, 583, 19, 39, "Output",
 CellID->342409661]
}, Open  ]],
Cell[CellGroupData[{
Cell[9412, 359, 103, 3, 70, "Input",
 CellID->194585093],
Cell[9518, 364, 1069, 22, 70, "Output",
 Evaluatable->False,
 CellID->79499212]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10636, 392, 237, 7, 70, "ExampleSection",
 CellID->390731684],
Cell[10876, 401, 221, 7, 70, "ExampleText",
 CellID->57980832],
Cell[CellGroupData[{
Cell[11122, 412, 203, 7, 70, "Input",
 CellID->653451490],
Cell[11328, 421, 178, 5, 50, "Output",
 CellID->232446367]
}, Open  ]],
Cell[11521, 429, 203, 7, 70, "ExampleText",
 CellID->71117676],
Cell[CellGroupData[{
Cell[11749, 440, 197, 7, 70, "Input",
 CellID->130576372],
Cell[11949, 449, 178, 5, 50, "Output",
 CellID->190547792]
}, Open  ]],
Cell[12142, 457, 124, 3, 70, "ExampleDelimiter",
 CellID->58411151],
Cell[12269, 462, 220, 7, 70, "ExampleText",
 CellID->636006957],
Cell[CellGroupData[{
Cell[12514, 473, 233, 8, 70, "Input",
 CellID->329129734],
Cell[12750, 483, 210, 5, 50, "Output",
 CellID->559636299]
}, Open  ]],
Cell[12975, 491, 110, 3, 70, "ExampleText",
 CellID->5218386],
Cell[13088, 496, 218, 7, 70, "Input",
 CellID->202677003],
Cell[CellGroupData[{
Cell[13331, 507, 109, 3, 70, "Input",
 CellID->641697745],
Cell[13443, 512, 202, 14, 70, "Print",
 CellID->488729582]
}, Open  ]],
Cell[13660, 529, 208, 7, 70, "ExampleText",
 CellID->35240128],
Cell[13871, 538, 214, 7, 70, "Input",
 CellID->6722148],
Cell[CellGroupData[{
Cell[14110, 549, 133, 4, 70, "Input",
 CellID->499700900],
Cell[14246, 555, 194, 5, 36, "Output",
 CellID->334536159]
}, Open  ]],
Cell[14455, 563, 69, 1, 70, "ExampleText",
 CellID->323774926],
Cell[CellGroupData[{
Cell[14549, 568, 109, 3, 70, "Input",
 CellID->738229338],
Cell[14661, 573, 221, 14, 70, "Print",
 CellID->98288771]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14931, 593, 230, 7, 70, "ExampleSection",
 CellID->495709264],
Cell[15164, 602, 120, 3, 70, "ExampleText",
 CellID->41702638],
Cell[CellGroupData[{
Cell[15309, 609, 165, 5, 70, "Input",
 CellID->114469161],
Cell[15477, 616, 172, 5, 50, "Output",
 CellID->83650851]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15710, 628, 311, 9, 70, "SeeAlsoSection",
 CellID->29900],
Cell[16024, 639, 442, 17, 70, "SeeAlso",
 CellID->2011]
}, Open  ]],
Cell[CellGroupData[{
Cell[16503, 661, 314, 9, 70, "TutorialsSection",
 CellID->30397],
Cell[16820, 672, 180, 4, 70, "Tutorials",
 CellID->3754],
Cell[17003, 678, 157, 3, 70, "Tutorials",
 CellID->20712]
}, Open  ]],
Cell[CellGroupData[{
Cell[17197, 686, 319, 9, 70, "MoreAboutSection",
 CellID->644343800],
Cell[17519, 697, 145, 3, 70, "MoreAbout",
 CellID->10037227]
}, Open  ]],
Cell[17679, 703, 27, 0, 70, "History"],
Cell[17709, 705, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

