(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16760,        520]
NotebookOptionsPosition[     14140,        435]
NotebookOutlinePosition[     15391,        471]
CellTagsIndexPosition[     15306,        466]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Backward" :> Documentation`HelpLookup["paclet:ref/Backward"], 
         "ForwardBackward" :> 
         Documentation`HelpLookup["paclet:ref/ForwardBackward"], "Right" :> 
         Documentation`HelpLookup["paclet:ref/Right"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Backward\"\>", 2->"\<\"ForwardBackward\"\>", 
      3->"\<\"Right\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Forward", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Forward",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Forward"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that represents the forward direction for \
purposes of motion and animation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2865]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->381117700],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AnimationDirection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AnimationDirection"], "->", "Forward"}]], 
  "InlineFormula"],
 " on ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->450390543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{"0", ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "Forward"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->959513660],

Cell[BoxData[
 AnimatorBox[0.435,
  AnimationDirection->Forward,
  PausedTime->2.175]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1797577472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2070225687],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1981484173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "Forward"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1137208652],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 7, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 10, 1}}, Typeset`size$$ = Automatic,
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$138938$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 10, 1},
                   AnimationDirection->Forward,
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->3.333333333333333]}
                },
                ColumnsEqual->False,
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                RowsEqual->False],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               
               PaneSelectorBox[{1->"1", 2->"2", 3->"3", 4->"4", 5->"5", 6->
                "6", 7->"7", 8->"8", 9->"9", 10->"10"}, 
                Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0,
               Background->GrayLevel[1]],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False,
             GraphicsBoxOptions->{PreserveImageOptions->True},
             Graphics3DBoxOptions->{PreserveImageOptions->True}],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         ColumnsEqual->False,
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}},
         RowsEqual->False],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$138938$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 10, 1}, 10, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {33.5, 38.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1084625908]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->766889962],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1775581582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", "t"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "20"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "Pi", ",", 
     RowBox[{"6", "Pi"}]}], "}"}], ",", 
   RowBox[{"AnimationDirection", "\[Rule]", "Forward"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1592040578],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 9.660397409788615, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], Pi, 6 Pi}}, Typeset`size$$ = {180., {87., 92.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$138963$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = Pi}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$138963$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      PolarPlot[$CellContext`\[Theta], {$CellContext`\[Theta], 
         0, $CellContext`t$$}, PlotRange -> 20], 
      "Specifications" :> {{$CellContext`t$$, Pi, 6 Pi, AnimationDirection -> 
         Forward, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {124., 129.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 255},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1466440020]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9601],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Backward",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Backward"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ForwardBackward",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForwardBackward"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Right",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Right"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28323]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Forward - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 43, 57.3136604}", "context" -> "System`", 
    "keywords" -> {"animation forward", "animation direction"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Forward is a symbol that represents the forward direction for purposes \
of motion and animation.", "synonyms" -> {}, "title" -> "Forward", "type" -> 
    "Symbol", "uri" -> "ref/Forward"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3474, 102, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15171, 459}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 769, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1392, 44, 1572, 37, 70, "ObjectNameGrid"],
Cell[2967, 83, 470, 14, 70, "Usage",
 CellID->2865]
}, Open  ]],
Cell[CellGroupData[{
Cell[3474, 102, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3851, 116, 148, 5, 70, "ExampleSection",
 CellID->381117700],
Cell[4002, 123, 371, 15, 70, "ExampleText",
 CellID->450390543],
Cell[CellGroupData[{
Cell[4398, 142, 239, 6, 28, "Input",
 CellID->959513660],
Cell[4640, 150, 229, 8, 46, "Output",
 CellID->1797577472]
}, Open  ]],
Cell[4884, 161, 126, 3, 70, "ExampleDelimiter",
 CellID->2070225687],
Cell[5013, 166, 185, 7, 70, "ExampleText",
 CellID->1981484173],
Cell[CellGroupData[{
Cell[5223, 177, 277, 7, 28, "Input",
 CellID->1137208652],
Cell[5503, 186, 4600, 119, 112, "Output",
 CellID->1084625908]
}, Open  ]],
Cell[10118, 308, 125, 3, 70, "ExampleDelimiter",
 CellID->766889962],
Cell[10246, 313, 177, 7, 70, "ExampleText",
 CellID->1775581582],
Cell[CellGroupData[{
Cell[10448, 324, 521, 14, 70, "Input",
 CellID->1592040578],
Cell[10972, 340, 2018, 44, 70, "Output",
 CellID->1466440020]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13051, 391, 310, 9, 70, "SeeAlsoSection",
 CellID->9601],
Cell[13364, 402, 704, 26, 70, "SeeAlso",
 CellID->28323]
}, Open  ]],
Cell[14083, 431, 27, 0, 70, "History"],
Cell[14113, 433, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

