(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57498,       2072]
NotebookOptionsPosition[     38067,       1470]
NotebookOutlinePosition[     47301,       1719]
CellTagsIndexPosition[     46097,       1690]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierCosTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierCosTransform"], 
          "FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"], 
          "FourierDST" :> Documentation`HelpLookup["paclet:ref/FourierDST"], 
          "InverseFourierSinTransform" :> 
          Documentation`HelpLookup[
           "paclet:ref/InverseFourierSinTransform"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FourierCosTransform\"\>", 
       2->"\<\"FourierTransform\"\>", 3->"\<\"FourierDST\"\>", 
       4->"\<\"InverseFourierSinTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FourierSinTransform", "ObjectName",
 CellID->11021],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FourierSinTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FourierSinTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["\[Omega]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the symbolic Fourier sine transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FourierSinTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FourierSinTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["\[Omega]", "TR"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multidimensional Fourier sine transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Fourier sine transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is by default defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"f", "(", "t", ")"}], " ", 
      RowBox[{"sin", "(", 
       RowBox[{"\[Omega]", "\[InvisibleSpace]", "t"}], ")"}], "d", 
      "\[InvisibleSpace]", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->11936],

Cell["\<\
Other definitions are used in some scientific and technical fields. \
\>", "Notes",
 CellID->21382],

Cell[TextData[{
 "Different choices of definitions can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26358],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    ButtonBox["FourierParameters",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FourierParameters"], "->", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}]}], TraditionalForm]], "InlineFormula"],
 " the Fourier sine transform computed by ",
 Cell[BoxData[
  ButtonBox["FourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierSinTransform"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    SqrtBox[
     FractionBox[
      RowBox[{"\[VerticalSeparator]", "b", "\[VerticalSeparator]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], 
       RowBox[{"1", "-", "a"}]]]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{"f", "(", "t", ")"}], " ", 
      RowBox[{"sin", "(", 
       RowBox[{
       "b", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]", "t"}], 
       ")"}], "d", "\[InvisibleSpace]", "t"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->19886],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " and other options to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can also be given in ",
 Cell[BoxData[
  ButtonBox["FourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierSinTransform"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->339369344],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->192252494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "1"}], ")"}]}], ",", "t", ",", " ", 
   "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,5",
 CellLabel->"In[1]:=",
 CellID->409380582],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "\[Omega]"}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{57, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,5",
 CellLabel->"Out[1]=",
 CellID->25855844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59341575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,1",
 CellLabel->"In[1]:=",
 CellID->510216563],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "\[Omega]"}], 
  RowBox[{"1", "+", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 ImageSize->{49, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,1",
 CellLabel->"Out[1]=",
 CellID->183992458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->535862854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "t", "]"}], "/", "t"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,7",
 CellLabel->"In[1]:=",
 CellID->71906731],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", "-", 
   RowBox[{"\[Pi]", " ", 
    RowBox[{"Sign", "[", 
     RowBox[{"1", "-", "\[Omega]"}], "]"}]}]}], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]]}]]], "Output",
 ImageSize->{109, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,7",
 CellLabel->"Out[1]=",
 CellID->439197431]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6054],

Cell["Elementary functions:", "ExampleText",
 CellID->1337587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", "t"}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,12",
 CellLabel->"In[1]:=",
 CellID->559634976],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sign", "[", "\[Omega]", "]"}]}]], "Output",
 ImageSize->{88, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,12",
 CellLabel->"Out[1]=",
 CellID->755985808]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,13",
 CellLabel->"In[2]:=",
 CellID->86052490],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["\[Omega]", "2"], "4"]}]], " ", 
   RowBox[{"Erfi", "[", 
    FractionBox["\[Omega]", "2"], "]"}]}], 
  SqrtBox["2"]]], "Output",
 ImageSize->{90, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,13",
 CellLabel->"Out[2]=",
 CellID->49505900]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "t", "]"}], "/", 
    RowBox[{"t", "^", "2"}]}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,14",
 CellLabel->"In[3]:=",
 CellID->93576955],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "\[Omega]", "-", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Omega]"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{176, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,14",
 CellLabel->"Out[3]=",
 CellID->195641295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", "t", "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,15",
 CellLabel->"In[4]:=",
 CellID->295748689],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "\[Omega]"}]], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]]}], "\[Omega]"]], "Output",
 ImageSize->{58, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,15",
 CellLabel->"Out[4]=",
 CellID->162802637]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Csch", "[", "t", "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,16",
 CellLabel->"In[5]:=",
 CellID->39179587],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Tanh", "[", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "\[Omega]"}], "2"], "]"}]}]], "Output",
 ImageSize->{104, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,16",
 CellLabel->"Out[5]=",
 CellID->316301981]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sinc", "[", "t", "]"}], "^", "2"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,17",
 CellLabel->"In[6]:=",
 CellID->419408488],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "\[Omega]"}], ")"}], " ", 
    RowBox[{"Log", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Omega]"}], ")"}], "2"], "]"}]}], "-", 
   RowBox[{"4", " ", "\[Omega]", " ", 
    RowBox[{"Log", "[", "\[Omega]", "]"}]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "\[Omega]"}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "+", "\[Omega]"}], "]"}]}]}], 
  RowBox[{"4", " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]]}]]], "Output",
 ImageSize->{351, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,17",
 CellLabel->"Out[6]=",
 CellID->47520428]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->229510772],

Cell["Special functions:", "ExampleText",
 CellID->374012082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", "t"}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"In[1]:=",
 CellID->100635333],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"ArcSinh", "[", "\[Omega]", "]"}]}], 
  SqrtBox[
   RowBox[{"1", "+", 
    SuperscriptBox["\[Omega]", "2"]}]]]], "Output",
 ImageSize->{112, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"Out[1]=",
 CellID->672322796]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"In[2]:=",
 CellID->71189633],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]", "2"]}], "]"}], 
   RowBox[{
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Omega]"}]]}]], "Output",
 ImageSize->{83, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,18",
 CellLabel->"Out[2]=",
 CellID->114618455]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362298078],

Cell["Generalized functions:", "ExampleText",
 CellID->609824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"t", "-", "1"}], "]"}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034599492440594602,3",
 CellLabel->"In[1]:=",
 CellID->489072697],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"Cos", "[", "\[Omega]", "]"}]}], "\[Omega]"]], "Output",
 ImageSize->{84, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034599492440594602,3",
 CellLabel->"Out[1]=",
 CellID->34912151]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], 
    RowBox[{"HeavisideTheta", "[", "t", "]"}], 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"1", "-", "t"}], "]"}]}], ",", "t", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,25",
 CellLabel->"In[2]:=",
 CellID->731592460],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "4"}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SuperscriptBox["\[Omega]", "2"]}], ")"}], " ", 
    RowBox[{"Cos", "[", "\[Omega]", "]"}]}], "+", 
   RowBox[{"4", " ", "\[Omega]", " ", 
    RowBox[{"Sin", "[", "\[Omega]", "]"}]}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", 
   SuperscriptBox["\[Omega]", "3"]}]]], "Output",
 ImageSize->{219, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,25",
 CellLabel->"Out[2]=",
 CellID->36597285]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->261975949],

Cell["Multivariate transforms:", "ExampleText",
 CellID->56580579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "t1"}], "-", "t2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->350817845],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Omega]1", " ", "\[Omega]2"}], 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]1", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]2", "2"]}], ")"}]}]]], "Output",
 ImageSize->{129, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2939408]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"t1", "^", "2"}]}], "-", 
     RowBox[{"t2", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->316948596],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["\[Omega]1", "2"], "4"]}], "-", 
    FractionBox[
     SuperscriptBox["\[Omega]2", "2"], "4"]}]], " ", 
  RowBox[{"Erfi", "[", 
   FractionBox["\[Omega]1", "2"], "]"}], " ", 
  RowBox[{"Erfi", "[", 
   FractionBox["\[Omega]2", "2"], "]"}]}]], "Output",
 ImageSize->{199, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136693334]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4467],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9383],

Cell[TextData[{
 "Fourier sine transform of ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " is a piecewise function:"
}], "ExampleText",
 CellID->129286313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"1", ",", "t"}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"Assumptions", "\[Rule]", " ", 
    RowBox[{"\[Omega]", "<", "1"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,22",
 CellLabel->"In[1]:=",
 CellID->786369123],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "\[Omega]"}], 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["\[Omega]", "2"]}]]]], "Output",
 ImageSize->{60, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,22",
 CellLabel->"Out[1]=",
 CellID->8462544]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"1", ",", "t"}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Omega]", ">", "1"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,23",
 CellLabel->"In[2]:=",
 CellID->320784725],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,23",
 CellLabel->"Out[2]=",
 CellID->47116349]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FourierParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24370],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->327143797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034599492440594602,9",
 CellLabel->"In[1]:=",
 CellID->379941444],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "\[Omega]"}], 
  RowBox[{"1", "+", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 ImageSize->{49, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034599492440594602,9",
 CellLabel->"Out[1]=",
 CellID->161203352]
}, Open  ]],

Cell["\<\
Use a non-default setting for a different definition of the transform:\
\>", "ExampleText",
 CellID->21669668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "t"}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"FourierParameters", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,28",
 CellLabel->"In[2]:=",
 CellID->257823649],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Omega]"}], 
  RowBox[{"1", "+", 
   SuperscriptBox["\[Omega]", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,28",
 CellLabel->"Out[2]=",
 CellID->174461266]
}, Open  ]],

Cell[TextData[{
 "To get the inverse, use the same ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 " setting:"
}], "ExampleText",
 CellID->440478316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t", ",", 
   RowBox[{"FourierParameters", " ", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->596811075],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "t"}]]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->41593490]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GenerateConditions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22736],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to get the parameter conditions necessary for the result to be valid:"
}], "ExampleText",
 CellID->327317843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"a", " ", "t"}], "]"}], ",", "t", ",", "\[Omega]", ",", 
   RowBox[{"GenerateConditions", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,19",
 CellLabel->"In[1]:=",
 CellID->205781283],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], "<", "0"}], ",", 
   FractionBox[
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", "\[Omega]"}], 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["\[Omega]", "2"]}]], ",", 
   RowBox[{"FourierSinTransform", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", " ", "t"}]], ",", "t", ",", "\[Omega]", ",", 
     RowBox[{"GenerateConditions", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{539, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,19",
 CellLabel->"Out[1]=",
 CellID->520243414]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26038],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierSinTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseFourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourierSinTransform"]], "InlineFormula"],
 " are mutual inverses:"
}], "ExampleText",
 CellID->899866971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{"FourierSinTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "\[Omega]"}], "]"}], ",", 
   "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"In[1]:=",
 CellID->87244332],

Cell[BoxData[
 RowBox[{"f", "[", "t", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"Out[1]=",
 CellID->111051783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"InverseFourierSinTransform", "[", 
    RowBox[{
     RowBox[{"g", "[", "\[Omega]", "]"}], ",", "\[Omega]", ",", "t"}], "]"}], 
   ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22035133735460154583,1",
 CellLabel->"In[2]:=",
 CellID->72689112],

Cell[BoxData[
 RowBox[{"g", "[", "\[Omega]", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22035133735460154583,1",
 CellLabel->"Out[2]=",
 CellID->240395945]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "1"}], ")"}]}], ",", "t", ",", 
   "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[3]:=",
 CellID->517183249],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "\[Omega]"}]], " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{57, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[3]=",
 CellID->18044080]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[4]:=",
 CellID->100959012],

Cell[BoxData[
 FractionBox["t", 
  RowBox[{"1", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{41, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[4]=",
 CellID->732816232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4553799],

Cell[TextData[{
 "Results from ",
 Cell[BoxData[
  ButtonBox["FourierSinTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierSinTransform"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 " differ by ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " for odd functions:"
}], "ExampleText",
 CellID->211365622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", "t"}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"In[1]:=",
 CellID->145126959],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sign", "[", "\[Omega]", "]"}]}]], "Output",
 ImageSize->{88, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,4",
 CellLabel->"Out[1]=",
 CellID->248655905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", "t"}], ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"In[2]:=",
 CellID->204658303],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sign", "[", "\[Omega]", "]"}]}]], "Output",
 ImageSize->{99, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034558506017011754,5",
 CellLabel->"Out[2]=",
 CellID->274940532]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27576],

Cell[TextData[{
 "The Fourier sine transform may be given in terms of generalized functions \
such as ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->238568336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{"t", ",", "t", ",", "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22034523510008951413,31",
 CellLabel->"In[1]:=",
 CellID->741524577],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]]}], " ", 
  RowBox[{
   SuperscriptBox["DiracDelta", "\[Prime]",
    MultilineFunction->None], "[", "\[Omega]", "]"}]}]], "Output",
 ImageSize->{145, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034523510008951413,31",
 CellLabel->"Out[1]=",
 CellID->274463699]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{"%", ",", "\[Omega]", ",", "t"}], "]"}]], "Input",
 CellTags->"Ex--22034545667636924857,7",
 CellLabel->"In[2]:=",
 CellID->602915504],

Cell[BoxData["t"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034545667636924857,7",
 CellLabel->"Out[2]=",
 CellID->423311936]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11089],

Cell[TextData[{
 "The Fourier sine transform represented in terms of ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->46193661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "3"}], "+", "1"}], ")"}]}], ",", " ", "t", ",", 
   "\[Omega]"}], "]"}]], "Input",
 CellTags->"Ex--22035147681198963238,1",
 CellLabel->"In[1]:=",
 CellID->49310671],

Cell[BoxData[
 FractionBox[
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       FractionBox["1", "6"], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", "6"], ",", 
        FractionBox["1", "6"], ",", 
        FractionBox["1", "2"], ",", 
        FractionBox["2", "3"], ",", 
        FractionBox["5", "6"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        FractionBox["1", "3"]}], "}"}]}], "}"}], ",", 
    FractionBox[
     SuperscriptBox["\[Omega]", "6"], "46656"]}], "]"}], 
  RowBox[{
   SqrtBox["6"], " ", "\[Pi]"}]]], "Output",
 ImageSize->{365, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22035147681198963238,1",
 CellLabel->"Out[1]=",
 CellID->108892779]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6783],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierDST",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierDST"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->142]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6118],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->23153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->40312389],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->140025776]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FourierSinTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 7.3607926}", "context" -> "System`", 
    "keywords" -> {
     "Fourier sin transform", "Fourier transforms", "sine transform"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FourierSinTransform[expr, t, \\[Omega]] gives the symbolic Fourier sine \
transform of expr. FourierSinTransform[expr, {t_1, t_2, ...}, {\\[Omega]_1, \
\\[Omega]_2, ...}] gives the multidimensional Fourier sine transform of expr. \
", "synonyms" -> {"fourier sin transform"}, "title" -> "FourierSinTransform", 
    "type" -> "Symbol", "uri" -> "ref/FourierSinTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7836, 259, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->339369344]},
 "Ex--22034523510008951413,5"->{
  Cell[8394, 282, 307, 10, 28, "Input",
   CellTags->"Ex--22034523510008951413,5",
   CellID->409380582],
  Cell[8704, 294, 322, 11, 60, "Output",
   CellTags->"Ex--22034523510008951413,5",
   CellID->25855844]},
 "Ex--22034523510008951413,1"->{
  Cell[9190, 315, 247, 7, 28, "Input",
   CellTags->"Ex--22034523510008951413,1",
   CellID->510216563],
  Cell[9440, 324, 344, 12, 77, "Output",
   CellTags->"Ex--22034523510008951413,1",
   CellID->183992458]},
 "Ex--22034523510008951413,7"->{
  Cell[9949, 346, 254, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,7",
   CellID->71906731],
  Cell[10206, 356, 406, 14, 55, "Output",
   CellTags->"Ex--22034523510008951413,7",
   CellID->439197431]},
 "Ex--22034523510008951413,12"->{
  Cell[10966, 390, 221, 6, 70, "Input",
   CellTags->"Ex--22034523510008951413,12",
   CellID->559634976],
  Cell[11190, 398, 298, 10, 60, "Output",
   CellTags->"Ex--22034523510008951413,12",
   CellID->755985808]},
 "Ex--22034523510008951413,13"->{
  Cell[11525, 413, 276, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,13",
   CellID->86052490],
  Cell[11804, 424, 434, 15, 73, "Output",
   CellTags->"Ex--22034523510008951413,13",
   CellID->49505900]},
 "Ex--22034523510008951413,14"->{
  Cell[12275, 444, 277, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,14",
   CellID->93576955],
  Cell[12555, 454, 443, 15, 60, "Output",
   CellTags->"Ex--22034523510008951413,14",
   CellID->195641295]},
 "Ex--22034523510008951413,15"->{
  Cell[13035, 474, 234, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,15",
   CellID->295748689],
  Cell[13272, 483, 356, 12, 61, "Output",
   CellTags->"Ex--22034523510008951413,15",
   CellID->162802637]},
 "Ex--22034523510008951413,16"->{
  Cell[13665, 500, 231, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,16",
   CellID->39179587],
  Cell[13899, 509, 350, 12, 60, "Output",
   CellTags->"Ex--22034523510008951413,16",
   CellID->316301981]},
 "Ex--22034523510008951413,17"->{
  Cell[14286, 526, 257, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,17",
   CellID->419408488],
  Cell[14546, 536, 804, 27, 60, "Output",
   CellTags->"Ex--22034523510008951413,17",
   CellID->47520428]},
 "Ex--22034523510008951413,18"->{
  Cell[15579, 576, 260, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,18",
   CellID->100635333],
  Cell[15842, 586, 395, 14, 87, "Output",
   CellTags->"Ex--22034523510008951413,18",
   CellID->672322796],
  Cell[16274, 605, 257, 7, 70, "Input",
   CellTags->"Ex--22034523510008951413,18",
   CellID->71189633],
  Cell[16534, 614, 403, 14, 60, "Output",
   CellTags->"Ex--22034523510008951413,18",
   CellID->114618455]},
 "Ex--22034599492440594602,3"->{
  Cell[17167, 641, 266, 8, 70, "Input",
   CellTags->"Ex--22034599492440594602,3",
   CellID->489072697],
  Cell[17436, 651, 326, 11, 76, "Output",
   CellTags->"Ex--22034599492440594602,3",
   CellID->34912151]},
 "Ex--22034523510008951413,25"->{
  Cell[17799, 667, 361, 11, 70, "Input",
   CellTags->"Ex--22034523510008951413,25",
   CellID->731592460],
  Cell[18163, 680, 630, 21, 60, "Output",
   CellTags->"Ex--22034523510008951413,25",
   CellID->36597285]},
 "Ex--22034523510008951413,22"->{
  Cell[21561, 817, 344, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,22",
   CellID->786369123],
  Cell[21908, 828, 357, 13, 87, "Output",
   CellTags->"Ex--22034523510008951413,22",
   CellID->8462544]},
 "Ex--22034523510008951413,23"->{
  Cell[22302, 846, 339, 9, 70, "Input",
   CellTags->"Ex--22034523510008951413,23",
   CellID->320784725],
  Cell[22644, 857, 199, 6, 36, "Output",
   CellTags->"Ex--22034523510008951413,23",
   CellID->47116349]},
 "Ex--22034599492440594602,9"->{
  Cell[23501, 895, 247, 7, 70, "Input",
   CellTags->"Ex--22034599492440594602,9",
   CellID->379941444],
  Cell[23751, 904, 344, 12, 77, "Output",
   CellTags->"Ex--22034599492440594602,9",
   CellID->161203352]},
 "Ex--22034523510008951413,28"->{
  Cell[24255, 926, 360, 10, 70, "Input",
   CellTags->"Ex--22034523510008951413,28",
   CellID->257823649],
  Cell[24618, 938, 305, 10, 52, "Output",
   CellTags->"Ex--22034523510008951413,28",
   CellID->174461266]},
 "Ex--22034523510008951413,19"->{
  Cell[26385, 1010, 318, 8, 70, "Input",
   CellTags->"Ex--22034523510008951413,19",
   CellID->205781283],
  Cell[26706, 1020, 723, 23, 77, "Output",
   CellTags->"Ex--22034523510008951413,19",
   CellID->520243414]},
 "Ex--22034138112425334325,15"->{
  Cell[28136, 1075, 327, 9, 70, "Input",
   CellTags->"Ex--22034138112425334325,15",
   CellID->87244332],
  Cell[28466, 1086, 227, 7, 36, "Output",
   CellTags->"Ex--22034138112425334325,15",
   CellID->111051783]},
 "Ex--22035133735460154583,1"->{
  Cell[28730, 1098, 333, 9, 70, "Input",
   CellTags->"Ex--22035133735460154583,1",
   CellID->72689112],
  Cell[29066, 1109, 233, 7, 36, "Output",
   CellTags->"Ex--22035133735460154583,1",
   CellID->240395945]},
 "Ex--22034558506017011754,4"->{
  Cell[29336, 1121, 302, 10, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->517183249],
  Cell[29641, 1133, 322, 11, 60, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->18044080],
  Cell[31141, 1195, 220, 6, 70, "Input",
   CellTags->"Ex--22034558506017011754,4",
   CellID->145126959],
  Cell[31364, 1203, 297, 10, 60, "Output",
   CellTags->"Ex--22034558506017011754,4",
   CellID->248655905]},
 "Ex--22034558506017011754,5"->{
  Cell[30000, 1149, 203, 5, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->100959012],
  Cell[30206, 1156, 267, 9, 51, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->732816232],
  Cell[31698, 1218, 217, 6, 70, "Input",
   CellTags->"Ex--22034558506017011754,5",
   CellID->204658303],
  Cell[31918, 1226, 319, 10, 60, "Output",
   CellTags->"Ex--22034558506017011754,5",
   CellID->274940532]},
 "Ex--22034523510008951413,31"->{
  Cell[32811, 1264, 197, 5, 70, "Input",
   CellTags->"Ex--22034523510008951413,31",
   CellID->741524577],
  Cell[33011, 1271, 388, 13, 38, "Output",
   CellTags->"Ex--22034523510008951413,31",
   CellID->274463699]},
 "Ex--22034545667636924857,7"->{
  Cell[33436, 1289, 203, 5, 70, "Input",
   CellTags->"Ex--22034545667636924857,7",
   CellID->602915504],
  Cell[33642, 1296, 199, 6, 36, "Output",
   CellTags->"Ex--22034545667636924857,7",
   CellID->423311936]},
 "Ex--22035147681198963238,1"->{
  Cell[34373, 1329, 306, 10, 70, "Input",
   CellTags->"Ex--22035147681198963238,1",
   CellID->49310671],
  Cell[34682, 1341, 868, 30, 66, "Output",
   CellTags->"Ex--22035147681198963238,1",
   CellID->108892779]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39318, 1497},
 {"Ex--22034523510008951413,5", 39471, 1501},
 {"Ex--22034523510008951413,1", 39717, 1508},
 {"Ex--22034523510008951413,7", 39963, 1515},
 {"Ex--22034523510008951413,12", 40210, 1522},
 {"Ex--22034523510008951413,13", 40461, 1529},
 {"Ex--22034523510008951413,14", 40710, 1536},
 {"Ex--22034523510008951413,15", 40960, 1543},
 {"Ex--22034523510008951413,16", 41211, 1550},
 {"Ex--22034523510008951413,17", 41461, 1557},
 {"Ex--22034523510008951413,18", 41711, 1564},
 {"Ex--22034599492440594602,3", 42176, 1577},
 {"Ex--22034523510008951413,25", 42424, 1584},
 {"Ex--22034523510008951413,22", 42675, 1591},
 {"Ex--22034523510008951413,23", 42924, 1598},
 {"Ex--22034599492440594602,9", 43172, 1605},
 {"Ex--22034523510008951413,28", 43421, 1612},
 {"Ex--22034523510008951413,19", 43673, 1619},
 {"Ex--22034138112425334325,15", 43926, 1626},
 {"Ex--22035133735460154583,1", 44176, 1633},
 {"Ex--22034558506017011754,4", 44424, 1640},
 {"Ex--22034558506017011754,5", 44890, 1653},
 {"Ex--22034523510008951413,31", 45356, 1666},
 {"Ex--22034545667636924857,7", 45608, 1673},
 {"Ex--22035147681198963238,1", 45857, 1680}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2260, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2883, 82, 57, 1, 70, "ObjectName",
 CellID->11021],
Cell[2943, 85, 1711, 52, 70, "Usage",
 CellID->14912]
}, Open  ]],
Cell[CellGroupData[{
Cell[4691, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5169, 159, 604, 20, 70, "Notes",
 CellID->11936],
Cell[5776, 181, 109, 3, 70, "Notes",
 CellID->21382],
Cell[5888, 186, 259, 8, 70, "Notes",
 CellID->26358],
Cell[6150, 196, 1158, 39, 70, "Notes",
 CellID->19886],
Cell[7311, 237, 488, 17, 70, "Notes",
 CellID->32]
}, Closed]],
Cell[CellGroupData[{
Cell[7836, 259, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->339369344],
Cell[CellGroupData[{
Cell[8221, 273, 148, 5, 70, "ExampleSection",
 CellID->192252494],
Cell[CellGroupData[{
Cell[8394, 282, 307, 10, 28, "Input",
 CellTags->"Ex--22034523510008951413,5",
 CellID->409380582],
Cell[8704, 294, 322, 11, 60, "Output",
 CellTags->"Ex--22034523510008951413,5",
 CellID->25855844]
}, Open  ]],
Cell[9041, 308, 124, 3, 70, "ExampleDelimiter",
 CellID->59341575],
Cell[CellGroupData[{
Cell[9190, 315, 247, 7, 28, "Input",
 CellTags->"Ex--22034523510008951413,1",
 CellID->510216563],
Cell[9440, 324, 344, 12, 77, "Output",
 CellTags->"Ex--22034523510008951413,1",
 CellID->183992458]
}, Open  ]],
Cell[9799, 339, 125, 3, 70, "ExampleDelimiter",
 CellID->535862854],
Cell[CellGroupData[{
Cell[9949, 346, 254, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,7",
 CellID->71906731],
Cell[10206, 356, 406, 14, 55, "Output",
 CellTags->"Ex--22034523510008951413,7",
 CellID->439197431]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10661, 376, 215, 7, 70, "ExampleSection",
 CellID->6054],
Cell[10879, 385, 62, 1, 70, "ExampleText",
 CellID->1337587],
Cell[CellGroupData[{
Cell[10966, 390, 221, 6, 70, "Input",
 CellTags->"Ex--22034523510008951413,12",
 CellID->559634976],
Cell[11190, 398, 298, 10, 60, "Output",
 CellTags->"Ex--22034523510008951413,12",
 CellID->755985808]
}, Open  ]],
Cell[CellGroupData[{
Cell[11525, 413, 276, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,13",
 CellID->86052490],
Cell[11804, 424, 434, 15, 73, "Output",
 CellTags->"Ex--22034523510008951413,13",
 CellID->49505900]
}, Open  ]],
Cell[CellGroupData[{
Cell[12275, 444, 277, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,14",
 CellID->93576955],
Cell[12555, 454, 443, 15, 60, "Output",
 CellTags->"Ex--22034523510008951413,14",
 CellID->195641295]
}, Open  ]],
Cell[CellGroupData[{
Cell[13035, 474, 234, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,15",
 CellID->295748689],
Cell[13272, 483, 356, 12, 61, "Output",
 CellTags->"Ex--22034523510008951413,15",
 CellID->162802637]
}, Open  ]],
Cell[CellGroupData[{
Cell[13665, 500, 231, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,16",
 CellID->39179587],
Cell[13899, 509, 350, 12, 60, "Output",
 CellTags->"Ex--22034523510008951413,16",
 CellID->316301981]
}, Open  ]],
Cell[CellGroupData[{
Cell[14286, 526, 257, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,17",
 CellID->419408488],
Cell[14546, 536, 804, 27, 60, "Output",
 CellTags->"Ex--22034523510008951413,17",
 CellID->47520428]
}, Open  ]],
Cell[15365, 566, 125, 3, 70, "ExampleDelimiter",
 CellID->229510772],
Cell[15493, 571, 61, 1, 70, "ExampleText",
 CellID->374012082],
Cell[CellGroupData[{
Cell[15579, 576, 260, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellID->100635333],
Cell[15842, 586, 395, 14, 87, "Output",
 CellTags->"Ex--22034523510008951413,18",
 CellID->672322796]
}, Open  ]],
Cell[CellGroupData[{
Cell[16274, 605, 257, 7, 70, "Input",
 CellTags->"Ex--22034523510008951413,18",
 CellID->71189633],
Cell[16534, 614, 403, 14, 60, "Output",
 CellTags->"Ex--22034523510008951413,18",
 CellID->114618455]
}, Open  ]],
Cell[16952, 631, 125, 3, 70, "ExampleDelimiter",
 CellID->362298078],
Cell[17080, 636, 62, 1, 70, "ExampleText",
 CellID->609824],
Cell[CellGroupData[{
Cell[17167, 641, 266, 8, 70, "Input",
 CellTags->"Ex--22034599492440594602,3",
 CellID->489072697],
Cell[17436, 651, 326, 11, 76, "Output",
 CellTags->"Ex--22034599492440594602,3",
 CellID->34912151]
}, Open  ]],
Cell[CellGroupData[{
Cell[17799, 667, 361, 11, 70, "Input",
 CellTags->"Ex--22034523510008951413,25",
 CellID->731592460],
Cell[18163, 680, 630, 21, 60, "Output",
 CellTags->"Ex--22034523510008951413,25",
 CellID->36597285]
}, Open  ]],
Cell[18808, 704, 125, 3, 70, "ExampleDelimiter",
 CellID->261975949],
Cell[18936, 709, 66, 1, 70, "ExampleText",
 CellID->56580579],
Cell[CellGroupData[{
Cell[19027, 714, 343, 11, 70, "Input",
 CellID->350817845],
Cell[19373, 727, 431, 14, 57, "Output",
 CellID->2939408]
}, Open  ]],
Cell[CellGroupData[{
Cell[19841, 746, 396, 13, 70, "Input",
 CellID->316948596],
Cell[20240, 761, 544, 18, 55, "Output",
 CellID->136693334]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20833, 785, 217, 7, 70, "ExampleSection",
 CellID->4467],
Cell[CellGroupData[{
Cell[21075, 796, 227, 7, 70, "ExampleSubsection",
 CellID->9383],
Cell[21305, 805, 231, 8, 70, "ExampleText",
 CellID->129286313],
Cell[CellGroupData[{
Cell[21561, 817, 344, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,22",
 CellID->786369123],
Cell[21908, 828, 357, 13, 87, "Output",
 CellTags->"Ex--22034523510008951413,22",
 CellID->8462544]
}, Open  ]],
Cell[CellGroupData[{
Cell[22302, 846, 339, 9, 70, "Input",
 CellTags->"Ex--22034523510008951413,23",
 CellID->320784725],
Cell[22644, 857, 199, 6, 36, "Output",
 CellTags->"Ex--22034523510008951413,23",
 CellID->47116349]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22892, 869, 234, 7, 70, "ExampleSubsection",
 CellID->24370],
Cell[23129, 878, 347, 13, 70, "ExampleText",
 CellID->327143797],
Cell[CellGroupData[{
Cell[23501, 895, 247, 7, 70, "Input",
 CellTags->"Ex--22034599492440594602,9",
 CellID->379941444],
Cell[23751, 904, 344, 12, 77, "Output",
 CellTags->"Ex--22034599492440594602,9",
 CellID->161203352]
}, Open  ]],
Cell[24110, 919, 120, 3, 70, "ExampleText",
 CellID->21669668],
Cell[CellGroupData[{
Cell[24255, 926, 360, 10, 70, "Input",
 CellTags->"Ex--22034523510008951413,28",
 CellID->257823649],
Cell[24618, 938, 305, 10, 52, "Output",
 CellTags->"Ex--22034523510008951413,28",
 CellID->174461266]
}, Open  ]],
Cell[24938, 951, 242, 8, 70, "ExampleText",
 CellID->440478316],
Cell[CellGroupData[{
Cell[25205, 963, 274, 7, 70, "Input",
 CellID->596811075],
Cell[25482, 972, 212, 7, 36, "Output",
 CellID->41593490]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25743, 985, 235, 7, 70, "ExampleSubsection",
 CellID->22736],
Cell[25981, 994, 379, 12, 70, "ExampleText",
 CellID->327317843],
Cell[CellGroupData[{
Cell[26385, 1010, 318, 8, 70, "Input",
 CellTags->"Ex--22034523510008951413,19",
 CellID->205781283],
Cell[26706, 1020, 723, 23, 77, "Output",
 CellTags->"Ex--22034523510008951413,19",
 CellID->520243414]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27490, 1050, 233, 7, 70, "ExampleSection",
 CellID->26038],
Cell[27726, 1059, 385, 12, 70, "ExampleText",
 CellID->899866971],
Cell[CellGroupData[{
Cell[28136, 1075, 327, 9, 70, "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellID->87244332],
Cell[28466, 1086, 227, 7, 36, "Output",
 CellTags->"Ex--22034138112425334325,15",
 CellID->111051783]
}, Open  ]],
Cell[CellGroupData[{
Cell[28730, 1098, 333, 9, 70, "Input",
 CellTags->"Ex--22035133735460154583,1",
 CellID->72689112],
Cell[29066, 1109, 233, 7, 36, "Output",
 CellTags->"Ex--22035133735460154583,1",
 CellID->240395945]
}, Open  ]],
Cell[CellGroupData[{
Cell[29336, 1121, 302, 10, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->517183249],
Cell[29641, 1133, 322, 11, 60, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->18044080]
}, Open  ]],
Cell[CellGroupData[{
Cell[30000, 1149, 203, 5, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->100959012],
Cell[30206, 1156, 267, 9, 51, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->732816232]
}, Open  ]],
Cell[30488, 1168, 123, 3, 70, "ExampleDelimiter",
 CellID->4553799],
Cell[30614, 1173, 502, 18, 70, "ExampleText",
 CellID->211365622],
Cell[CellGroupData[{
Cell[31141, 1195, 220, 6, 70, "Input",
 CellTags->"Ex--22034558506017011754,4",
 CellID->145126959],
Cell[31364, 1203, 297, 10, 60, "Output",
 CellTags->"Ex--22034558506017011754,4",
 CellID->248655905]
}, Open  ]],
Cell[CellGroupData[{
Cell[31698, 1218, 217, 6, 70, "Input",
 CellTags->"Ex--22034558506017011754,5",
 CellID->204658303],
Cell[31918, 1226, 319, 10, 60, "Output",
 CellTags->"Ex--22034558506017011754,5",
 CellID->274940532]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32286, 1242, 226, 7, 70, "ExampleSection",
 CellID->27576],
Cell[32515, 1251, 271, 9, 70, "ExampleText",
 CellID->238568336],
Cell[CellGroupData[{
Cell[32811, 1264, 197, 5, 70, "Input",
 CellTags->"Ex--22034523510008951413,31",
 CellID->741524577],
Cell[33011, 1271, 388, 13, 38, "Output",
 CellTags->"Ex--22034523510008951413,31",
 CellID->274463699]
}, Open  ]],
Cell[CellGroupData[{
Cell[33436, 1289, 203, 5, 70, "Input",
 CellTags->"Ex--22034545667636924857,7",
 CellID->602915504],
Cell[33642, 1296, 199, 6, 36, "Output",
 CellTags->"Ex--22034545667636924857,7",
 CellID->423311936]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33890, 1308, 224, 7, 70, "ExampleSection",
 CellID->11089],
Cell[34117, 1317, 231, 8, 70, "ExampleText",
 CellID->46193661],
Cell[CellGroupData[{
Cell[34373, 1329, 306, 10, 70, "Input",
 CellTags->"Ex--22035147681198963238,1",
 CellID->49310671],
Cell[34682, 1341, 868, 30, 66, "Output",
 CellTags->"Ex--22035147681198963238,1",
 CellID->108892779]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35611, 1378, 310, 9, 70, "SeeAlsoSection",
 CellID->6783],
Cell[35924, 1389, 1017, 35, 70, "SeeAlso",
 CellID->142]
}, Open  ]],
Cell[CellGroupData[{
Cell[36978, 1429, 313, 9, 70, "TutorialsSection",
 CellID->6118],
Cell[37294, 1440, 194, 4, 70, "Tutorials",
 CellID->23153]
}, Open  ]],
Cell[CellGroupData[{
Cell[37525, 1449, 318, 9, 70, "MoreAboutSection",
 CellID->40312389],
Cell[37846, 1460, 149, 3, 70, "MoreAbout",
 CellID->140025776]
}, Open  ]],
Cell[38010, 1466, 27, 0, 70, "History"],
Cell[38040, 1468, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

