(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15868,        577]
NotebookOptionsPosition[     12423,        463]
NotebookOutlinePosition[     13773,        501]
CellTagsIndexPosition[     13688,        496]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "String Representation of Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringRepresentationOfBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"String Representation of Boxes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/OverscriptBox"], "GridBox" :> 
          Documentation`HelpLookup["paclet:ref/GridBox"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OverscriptBox\"\>", 
       2->"\<\"GridBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FractionBox", "ObjectName",
 CellID->26032],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FractionBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FractionBox"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level formatting construct that represents ",
     Cell[BoxData[
      FractionBox[
       StyleBox["x", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"],
     " in notebook expressions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31739]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Inside \[Backslash]",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}], 
   RowBox[{"FractionBox", "[", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "]"}]}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Backslash]", 
   RowBox[{"/", 
    StyleBox["y", "TI"]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6676],

Cell[TextData[{
 "In a notebook a ",
 Cell[BoxData[
  ButtonBox["FractionBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionBox"]], "InlineFormula"],
 " can be created using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 ". ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out of the fraction. "
}], "Notes",
 CellID->11920],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FractionBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FractionBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is interpreted on input as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "/", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12217],

Cell[TextData[{
 "The axis of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FractionBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FractionBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to go through the fraction line. The baseline lies below the axis \
by the distance between the axis and the bottom of characters such as ",
 Cell[BoxData["("], "InlineFormula"],
 " in the current font. "
}], "Notes",
 CellID->3986],

Cell[TextData[{
 "The width of the fraction line can be given in x\[Hyphen]heights as the \
setting for the ",
 Cell[BoxData[
  ButtonBox["SpanLineThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanLineThickness"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10359],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FractionBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FractionBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " does not fit on a single line, it is output as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "/", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19757],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", explicit ",
 Cell[BoxData[
  ButtonBox["FractionBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionBox"]], "InlineFormula"],
 " objects are output literally. You can use ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " to see the display form of such objects. "
}], "Notes",
 CellID->1739]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->95935715],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->101334472],

Cell["Display a typeset fraction:", "ExampleText",
 CellID->374528096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FractionBox", "[", 
   RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249491258],

Cell[BoxData[
 TagBox[
  FractionBox["x", "2"],
  DisplayForm]], "Output",
 ImageSize->{16, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->419719263]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->839047],

Cell["\<\
Display a fraction with typeset structures in numerator and denominator:\
\>", "ExampleText",
 CellID->43194949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FractionBox", "[", 
   RowBox[{
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\"\<x\>\"", ",", "\"\<3\>\""}], "]"}], ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<1\>\"", ",", "\"\<+\>\"", ",", "\"\<a\>\"", ",", "\"\< \>\"", ",", 
       "\"\<b\>\""}], "}"}], "]"}]}], "]"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380313827],

Cell[BoxData[
 TagBox[
  FractionBox[
   SuperscriptBox["x", "3"], 
   RowBox[{"1", "+", "a", " ", "b"}]],
  DisplayForm]], "Output",
 ImageSize->{45, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->309199539]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4890],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OverscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12492]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16604],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->859],

Cell[TextData[ButtonBox["String Representation of Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringRepresentationOfBoxes"]], "Tutorials",
 CellID->187054374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FractionBox",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FractionBox"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->216038804]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FractionBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 10.6421266}", "context" -> "System`", 
    "keywords" -> {
     "\\above (TeX)", "built-up fractions", "\\frac (TeX)", "\\over (TeX)", 
      "rational functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FractionBox[x, y] is a low-level formatting construct that represents \
x/y in notebook expressions. ", "synonyms" -> {"fraction box"}, "title" -> 
    "FractionBox", "type" -> "Symbol", "uri" -> "ref/FractionBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7573, 270, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->95935715]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13546, 489}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2127, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2750, 80, 49, 1, 70, "ObjectName",
 CellID->26032],
Cell[2802, 83, 704, 22, 70, "Usage",
 CellID->31739]
}, Open  ]],
Cell[CellGroupData[{
Cell[3543, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4021, 127, 478, 19, 70, "Notes",
 CellID->6676],
Cell[4502, 148, 452, 16, 70, "Notes",
 CellID->11920],
Cell[4957, 166, 679, 27, 70, "Notes",
 CellID->12217],
Cell[5639, 195, 499, 15, 70, "Notes",
 CellID->3986],
Cell[6141, 212, 417, 14, 70, "Notes",
 CellID->10359],
Cell[6561, 228, 434, 17, 70, "Notes",
 CellID->19757],
Cell[6998, 247, 538, 18, 70, "Notes",
 CellID->1739]
}, Closed]],
Cell[CellGroupData[{
Cell[7573, 270, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->95935715],
Cell[CellGroupData[{
Cell[7957, 284, 148, 5, 70, "ExampleSection",
 CellID->101334472],
Cell[8108, 291, 70, 1, 70, "ExampleText",
 CellID->374528096],
Cell[CellGroupData[{
Cell[8203, 296, 184, 6, 28, "Input",
 CellID->249491258],
Cell[8390, 304, 217, 8, 63, "Output",
 CellID->419719263]
}, Open  ]],
Cell[8622, 315, 122, 3, 70, "ExampleDelimiter",
 CellID->839047],
Cell[8747, 320, 122, 3, 70, "ExampleText",
 CellID->43194949],
Cell[CellGroupData[{
Cell[8894, 327, 423, 12, 70, "Input",
 CellID->380313827],
Cell[9320, 341, 276, 10, 69, "Output",
 CellID->309199539]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9657, 358, 310, 9, 70, "SeeAlsoSection",
 CellID->4890],
Cell[9970, 369, 459, 17, 70, "SeeAlso",
 CellID->12492]
}, Open  ]],
Cell[CellGroupData[{
Cell[10466, 391, 314, 9, 70, "TutorialsSection",
 CellID->16604],
Cell[10783, 402, 177, 4, 70, "Tutorials",
 CellID->859],
Cell[10963, 408, 172, 3, 70, "Tutorials",
 CellID->187054374]
}, Open  ]],
Cell[CellGroupData[{
Cell[11172, 416, 305, 8, 70, "RelatedLinksSection"],
Cell[11480, 426, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11884, 443, 299, 8, 70, "MoreAboutSection"],
Cell[12186, 453, 165, 3, 70, "MoreAbout",
 CellID->216038804]
}, Open  ]],
Cell[12366, 459, 27, 0, 70, "History"],
Cell[12396, 461, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

