(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    111827,       3424]
NotebookOptionsPosition[     97774,       2932]
NotebookOutlinePosition[     99062,       2969]
CellTagsIndexPosition[     98976,       2964]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/TheStructureOfGraphics"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Tables and Matrices\"\>", 
       3->"\<\"Grids, Rows, and Columns in Mathematica\"\>", 
       4->"\<\"Formatted Output\"\>", 5->"\<\"The Structure of Graphics\"\>", 
       6->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Framed" :> Documentation`HelpLookup["paclet:ref/Framed"], 
          "Dividers" :> Documentation`HelpLookup["paclet:ref/Dividers"], 
          "FrameLabel" :> Documentation`HelpLookup["paclet:ref/FrameLabel"], 
          "FrameTicks" :> Documentation`HelpLookup["paclet:ref/FrameTicks"], 
          "FrameStyle" :> Documentation`HelpLookup["paclet:ref/FrameStyle"], 
          "Boxed" :> Documentation`HelpLookup["paclet:ref/Boxed"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Framed\"\>", 2->"\<\"Dividers\"\>", 
       3->"\<\"FrameLabel\"\>", 4->"\<\"FrameTicks\"\>", 
       5->"\<\"FrameStyle\"\>", 6->"\<\"Boxed\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Data Visualization\"\>", 3->"\<\"Function Visualization\"\>", 
       4->"\<\"Graphics Annotation & Appearance\"\>", 
       5->"\<\"Graphics Options & Styling\"\>", 6->"\<\"Grids & Tables\"\>", 
       7->"\<\"Layout & Tables\"\>", 
       8->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Frame", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Frame",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " and other constructs that specifies whether to include a frame. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following basic settings can be given: ", "Notes",
 CellID->31854],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "draw a frame around the whole object ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], Cell[" or ", "TableText"], 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell["draw no frame ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[TextData[{
     "draw frames around each entry in ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     ", etc. "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, None, {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->19484],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and related functions, ",
 Cell[BoxData[
  RowBox[{"Frame", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["left", "TI"], ",", 
       StyleBox["right", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["bottom", "TI"], ",", 
       StyleBox["top", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies whether to draw a frame on each edge. With the default setting \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrameTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameTicks"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ticks are included whenever a frame is drawn."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1001088588],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and related constructs, lists of settings can be given. Common cases \
include:"
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24136695],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"], ",", 
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]}], "}"}], Cell[
    "put frames at all horizontal positions (column lines) ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"], ",", 
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]}], "}"}], Cell[
    "put frames at all vertical positions (row lines)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], "->", 
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]}], "}"}], Cell[
    "a frame around the last column  ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "->", 
       ButtonBox["True",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/True"]}]}], "}"}], Cell[
    "a frame around the last row", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->5388],

Cell[TextData[{
 "General settings for ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and related constructs can be given as:"
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->46514975],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox["spec", "TI"], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to all items "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["x", "TI"]], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " at successive horizontal positions"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " at successive horizontal and vertical positions"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    FormBox[
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["spec", "TI"], 
        StyleBox["x", "TI"]], ",", 
       SubscriptBox[
        StyleBox["spec", "TI"], 
        StyleBox["y", "TI"]], ",", 
       StyleBox["rules", "TI"]}], "}"}],
     TraditionalForm], Cell[TextData[{
     "also allow explicit rules for individual ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     " elements"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->11051],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " can have the following forms:"
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25391],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     "; then use defaults "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["c", "TI"], "}"}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " in all cases "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}], "}"}], "}"}], Cell[TextData[{
     "alternate between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[TextData[{
     "cycle through all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", then repeatedly use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", then repeatedly use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ", but use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning, then cyclically use the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", then use the last sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning and the last sequence at the end"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], "2"]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "specify what to use at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " to override specifications in ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->16534],

Cell[TextData[{
 "With settings of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{"{", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["m", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["n", "TI"]]}], "}"}]], "InlineFormula"],
 ", if there are more ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " specified than items across the grid, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " from the beginning are used for the first items, and ones from the end are \
used for the last items. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26373273],

Cell[TextData[{
 "Rules of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}], "->", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " can be used to specify frames for regions of a grid."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->227894726]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->420548067],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->11098265],

Cell["Draw a frame around a plot:", "ExampleText",
 CellID->133795784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9964907],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74363408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52719449],

Cell["Put a frame on the left and right edges:", "ExampleText",
 CellID->144333763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"True", ",", "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"False", ",", "False"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43807148],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->611276916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16644194],

Cell["Put a frame around a grid:", "ExampleText",
 CellID->280543320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30126082],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwZAOxvQQDkP0fyALj
7P///0MkgIAZJAIGDOlAgpEGokxAggnIhdGcNOazYnUFM4hgQfAZGLjpKMKG
1U0sUBfzkkiz08G0wRhegyMl0Sqf0Fd0cITlYExlo7mStPAaHClpMOSp0Vw5
misHS3gNjpQ0GPLUaK4czZWDJbwGR0qiZj6B9CMhfUoGRgB/riun\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{107, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125141248]
}, Open  ]],

Cell["Frame all elements in the grid:", "ExampleText",
 CellID->338538436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->630251220],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs0OgjAM7jYED+rZI+9ioicfYiEmcDAK8v7QDTRKOIqmP0vWbR3L1y3N
1+/A2bfl5erbqvD5qfH3sioe+fHWoMsZAKixH/aA8w5nsdddh+NoITYX/LHB
Lpi39fbL6w0ao6g/R7VoLC6fYxqcyWufxO5q9mbu8wxOssmLWMJfpLN3TsYX
WU/Ouz/7MwbRSswnvuwgieO5o6paUdQlUfmyoMSaRkt10IpWYj7xZQdJHM8d
VTWSoi6JypcFJdY0WqqDVrQS84kvO0jieO6oqpEUdUlUviwosabRUh20opWY
T3zZQRLHc0cdNNLwlxCYHnWbmC4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73005082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3532064],

Cell[TextData[{
 "Specify overall frame style, including frame ticks and frame tick labels, \
using ",
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->256827188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120129542],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->634884700]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24740],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frame Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->531461547],

Cell["Put a frame on the top and the bottom edges:", "ExampleText",
 CellID->810167149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"False", ",", "False"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "True"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36249098],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->184881615]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->423921085],

Cell["Put a frame on all the columns:", "ExampleText",
 CellID->108539650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317061368],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmr0OwiAQx49SWwd1duybuOnkQ5DGpB2Mtvb98ShqtOlEjOY+SKBwV/I7
yOUPA0c3NKezG9raVYfeXZu2vlX7S48mawCgw7rbAvY99sbaee+jA4sNlrHA
JjRv4/WXxytsjFJ/Ts2wyXD4/BbBmL/8JLyL2ZXZzznYKSc7khH+o5hdc/7Y
keVkvv2zvWQQrcR84qsOkjReqUpVagqVr/5JPM1o3TdoRSsxn/iqgySNV6pS
lZpC5at/Ek8zWvcNWtFKzCe+6iBJ45WqVKWmUPnqn8TTjNZ9g1a0EvOJrzpI
0nju1PgOKL4JAnMHpxiTaQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178803416]
}, Open  ]],

Cell["Put a frame on all the rows:", "ExampleText",
 CellID->94045870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "All"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->257420082],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwZAOxswQDkP0fyALj
7P//gTSUZAADZpA4GDCkAwlGGogyAQkmIBdGc9KYz4rVFcwgggXBZ2DgpqMI
G1Y3sUBdzEsizU4H0wZjeA2OlETNfEK/XDiaN0lLa6N5k7TwGhwpaTRvjubN
0bw5OFPSaN4czZujeXNwpiTq501IL5OBEQAXnTBU\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{107, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->506984504]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frame Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->55708741],

Cell["Specify the style of each frame edge:", "ExampleText",
 CellID->84494844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Thick", ",", "Dashed"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81179046],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameStyle->{{
     Thickness[Large], 
     Directive[
      Thickness[Large], 
      Dashing[{Small, Small}]]}, {
     RGBColor[0, 0, 1], 
     RGBColor[1, 0, 0]}}]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->538146350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11536810],

Cell["Specify the frame style of a grid:", "ExampleText",
 CellID->823414964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Dotted"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318063793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWFELgjAQvqk1iQp669H/EtRTP2JIoA9Smv9/3TYRFQksbedS2N19twnH
3e5z7irK5JaJMo1FdCnEI0njZ3S+F+jyGQDkOE5HQFuipUcuJWojAyV9NKR+
wFvwqJg1cm3kobNiNwWGpidDwZQPVmh5qL1KbybGax2LlgHU8QBsf+jhWvEq
ov1AHbbeDju59in4oTtjL9eq0jZ3GqU+o8RCLmCVWaY1pUqbCBZepc+Mgfzs
C8DrWlPIt01epdFntnnINdzHq/YrTYtXeV8e57xiZGb87nT9v7xKqc9s85Br
uM2rVCrdz6umA+t35zNL8t93nLsGd7iU8P4ZsLve9dNyizotbp5Ngb0AbgxM
Jg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65218126]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frame Lables and Ticks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->43483404],

Cell["Place labels on the bottom and left frame edges:", "ExampleText",
 CellID->513450776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130102686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->278520385]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78564993],

Cell["Specify labels for each edge:", "ExampleText",
 CellID->799486137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "\"\<plot\>\""}], "}"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->63028012],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->613391227]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->488864868],

Cell["Put a frame, but no ticks:", "ExampleText",
 CellID->439930527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "->", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24643],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyFmU1oXUUUx2/yXl6aj5ev5jVJkyZ5SZOm5jtNYr9jkqZpa1UExYV0EYOQ
LLRS40Y3utGNbiqIBbELP8CPRUVoESqIBbEgFsSCqCAVpC4sgsVFQIj/mblz
z8s/505DG2bunfM78z9z5sy9Nw8tra08/czS2uryUvfiuaXnVlaXn+8+fvYc
LmXKoih6C//PtEZob6Bl/5tL+MmYtv2J5syv7O3b/9z4/g/8u3t3/TSulG0Z
94D5lcG4F9YuP/H4h1H52Wc/jzIPnrz42qtfwSg6pVrNWKvr3/6+/NSn+B1l
bf/K5Z/Q/+Xnv6KTqtVRb/XSi18Yds77hk9jdUK1OmJH4f7qyqX19f+ibbZ/
586/6MM2WlStDttR8IIZmVHVtn/r1t/oG8rxgNUrL1/98uqvpllj+x+8f+PC
29dNc0G1OmRHXfv6N+gyzbztY3o3f/zTNI+pVgftKMwFYYeaqM7rxAzDVuUX
3/2uwY5+8/w3n3z8g2nOq6MP+FjBh1HdQP2QlbAbqT+nWu0ndhP1062Mnmby
MauOvp9i1uxX9cyTH93LCmDgTbNg+1gsLJnfA2lWLqHFCtmLnZJuNW1HYeGx
/KbZYvuYHibpd06alcyohWasW01RhFupH7ISdhvlvMtm7Jx4fBpBNDkCqgz2
cZLZpva4TFZnMUk27baPicMsycFssvMCDBQqFB7PMLnk/CfzU233+Ux69JH3
TC3qoExy2Sy7sTxAQeAQPtPctbF557scggQIuRdFVsBRPrt0843XrwkFE8XS
plMm/LphoFn9TsqGaYp4JkBBQBFW0+yizJyimIcocAR3QpE4TVL0sypl3CvA
KNPs9lY4noyiSaKGKJLvRYo2Rz9EkZUtku8JmluFShmzo5DiWBPT7CGrCaKG
KHIq9ZKCceqHKKKol3yP0dxyKmWUFO0mqzGihiiiqI8UjFI/RBFFfeR7hOZW
qVJGSFE/WY0QNUQRRXtIwTD1QxTZR3vI9xDNbZtKGaZ9NEBWQ0QNUaQq7bV9
HIY4Ek1zkBSVULIJBe6GSJPjSMW5j2ZXlXDip9yKhObCG1sIYZBmtpdmJsQS
liv9MUvq3SCxOXbVwsolLPy400ePtNRod1+eKUpo2VKaOdUGaJWGSaXLDanM
aTNzQgfUfJTVTbI+rtA1ak6U21HyJNCn7hXJvH7Sm041ivtJ8ShljvOGCWPa
YVrpSa7XFlHu7stpq1MzpLyXlI+RclcX5fStTaUa5btJ+Tgp7yXl6bTSZxr9
nJCTsZeU69QsKS+S8glS3kPK86lUo7yHlO8j5UVSnk4rVa6f+bLmRVKuUyvs
KDlfujY27+ZJUt5NyusCVDkpHFUqjnvikn3eRREIUeUU6yLKFHnp9KsY7/d6
lZqjCOwixdMUEUeV/R6iymroz79Sk919qXQhqsxFfzaXt/YOGt+gUispk9op
zvt9HOM31A7SEqJKnBxV3hsOUL+dtISoMped1D9Iu8Tdl0rZqFLd9xd5U2+j
OLr3R9mxbTQ+RBXfbZSvhyhfW0lLk0qtoji1UL4e9pS4djmqVJ8QVdbUUE3t
Okp52UIaQjTZec5KalHy/SuOzA5ate0qtZqiXqBVmqHIFGh8iCrvlAVa6xmK
XzNpa1apNRS37aR41vbl24C7L+dWiCoUZyVVZJYoTZRRBZVaS5RG8jKn5CV/
e0qjbt55pV7midJAXnao1DxR6snLMaI0kJcQVb6k1lMOLGxs3ql1PmeQrz6/
t1LrKP/ylK+LlK95Gh+iisJa6p+giLj78vWuVaU6xXKuc/6ar9+mHtR4b6Aj
XrambaW5qEttr6L4nfIUFBL4jPegeNOpSQaVvF/6OZtVO2377vu4+fbu6q88
hewMUGEPMOpffMZilRAvs7YP27778mf+LpDzqxRraVepdo9Ugop6iulhxmjj
GrhROTxZj/FY66EKvjAQUJdz6Lq/PWD+9pzf6sNWohyGozItzL8zc+SC2xeP
2euwBg8XcQ5gAALSqVLOJ1fjd9Gy/wFmpI3Y\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->211125151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384317580],

Cell["Place frame tick marks and labels automatically:", "ExampleText",
 CellID->25360382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12988],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->110585761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->610285637],

Cell["Place frame tick marks at the specific positions:", "ExampleText",
 CellID->28686972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", "None"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi", ",", 
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"3", "Pi"}]}], "}"}], ",", "None"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259399820],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->49788168]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4104],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Grid Frame Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->291717711],

Cell["\<\
No frame on the first column, frame on the second, then repeat the default:\
\>", "ExampleText",
 CellID->367583419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "True"}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5631025],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAOxvQQDkP0fyALj
5P//gTQPkBQEct3gPAZmkCwYMPCi8V0GSBUTUIAJyALRbCARFrgKqChxspwU
8hnBrmFghVBQJwIBO5qrmVBdQZQKbiqJMEFCDOpiDjR7mQmI8xKgmelg+pAI
30GVIgdrvh3aqgZXHA+JXPF/tNQZLXUGOt8ObVWDK46HRK74P1rqjJY6A51v
h7aqwRXHQyJX/B8tdUZLnYHOt6jjN5AxHQZGAIDn3w0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{99, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27052314]
}, Open  ]],

Cell["\<\
No frame on the first column, frame on the second, then repeat it:\
\>", "ExampleText",
 CellID->212071829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", "True", "}"}]}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31900168],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWsEOgjAM7ZiCB7175E+86cl/YCEmkGA0yP+PdhKIXF3iNl+Tsm4tezSw
l3fgaobmdjdDW5vy0ptn09av8vzoeUkrIurYT0fi2HLkvLOWxz1fKxKTiLRk
nNHB81z2V0D6GikT55mMuaQ2c9W0GnZ2O3fiwqVFtmLVdfa5U1QV+fLGps53
q3v0j9eLiJ7wb76VAE6on9OdIvcCCUjpI4XAI1AYUBhQGP4qoDDi4F4gASl9
pBB4BAoDCgMKw18FFEYc3AskIKWPFAKPQGFAYUBh+KuAwoiDe1NFqlz0/m+C
1AhABh+O\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{108, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->744421612]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111836538],

Cell["\<\
No frame on the first row, frame on the second, then repeat the default:\
\>", "ExampleText",
 CellID->161391847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "True"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85937981],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwZAOxtQQDkP0fyALj
7P//gTQyyQokmYBSTFCak8Z8NrCtYJIF5CIwADK46SjCDqbYoS7iJZHmoILu
weD/gYl5zBRIDDmaSkdT6aBIpQxgwIxwZzqQYKSbKMyV9AoNVqyuYB7QdMGG
1U0s/8lL6ex0MG0whtfgSEnUzCeQvDlaj4zWI4O5HmFgBABtNRb8\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{107, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180324967]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17006101],

Cell["Frame specific rows and columns:", "ExampleText",
 CellID->797409539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "\[Rule]", "True"}], ",", 
      RowBox[{"2", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1764164693],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{
    "ColumnsIndexed" -> {3 -> True}, "RowsIndexed" -> {2 -> True}}],
  "Grid"]], "Output",
 ImageSize->{113, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2014556348]
}, Open  ]],

Cell["Frame the last column and the last row:", "ExampleText",
 CellID->278608329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "\[Rule]", "True"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "\[Rule]", "True"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->89820352],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw5ACxowQDkP0fyALj
nP//gTSUZAADZpA4GDBEgggkPg+QYBwEqpiABBOQC6M5qcxnA1nCArcPTZYV
q5uYUfUAGdw0E2FHCyUmDBVsWN3IAvUBL5E0B5o9zFBx9gEwfSiE72BMl4Mp
D0NKmBic8vSSYR0k8YSmbtCkafb/1M7J1DdxsIbdYElbA5/LRnPz4EiRo7l5
NDcPHZnBEuKDNUWO5ubR3EyKjACYBenhMzACAAEoNsU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{108, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->773030373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384703251],

Cell["Frame a set of items:", "ExampleText",
 CellID->1356547037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "True"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "True"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1108049723],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{
    "Columns" -> {{None}}, "Rows" -> {{None}}, 
     "ItemsIndexed" -> {{1, 1} -> True, {3, 3} -> True}}],
  "Grid"]], "Output",
 ImageSize->{109, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1421362234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1031681727],

Cell["Frame a region of the grid:", "ExampleText",
 CellID->1799654307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "True"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1630253401],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{
    "Columns" -> {{None}}, "Rows" -> {{None}}, 
     "ItemsIndexed" -> {{{1, 3}, {1, 3}} -> True}}],
  "Grid"]], "Output",
 ImageSize->{107, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226977610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1781762087],

Cell["Put a frame around an individual element in the grid:", "ExampleText",
 CellID->1563422441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "b"}], "}"}], ",",
     
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1978544842],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["a",
      Frame->True,
      StripOnInput->False], "b"},
    {"c", "d"}
   }],
  "Grid"]], "Output",
 ImageSize->{32, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290143500]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Grid Frame Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->308441468],

Cell["Frame rows and columns with specific styles:", "ExampleText",
 CellID->109825147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "\[Rule]", "Red"}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thick"}], "]"}]}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->549877936],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM0KgzAMjv/K8LDbbupjDNlpsJ32EEUGehgO5/t3sTrBytAN0RQqtF+T
xjZtkzT0xur8/mB1kbH4WrFnXmSv+FJWyLIMACixnA+AbY4tUUrOEROs94in
ngILG1x8EEp0upGUi7WJSpsdBhLd9IPd//VTrzzWFO0JjURtQ68nwG7E8aS1
mH9IjEedw/EF+J3GYYe+NJs1wQ+/YLDC6CrsLz2rpOq/akvRO2cVvENHHx19
aPhv0mQ8DVdkPigl0anAeVK4Wh5NzHpsd0VxaXvizNe0L2egmcMpe6c70PXj
pUvHKW+DWVTad7rWG0nrVyEeLBlByd4Ss6To3boq5Co6F9S5IA3/Hb53tW9g
YLwBGpa1Cg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{111, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166298073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164204064],

Cell["Frame a region of the grid with specific style:", "ExampleText",
 CellID->6719319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "Thick"}], 
        ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2", ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "\[Rule]", "Red"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141173846],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMkKwjAQnTZ1X/HkQdSTeBERL94FPfkRRQRFRFH/P05jUjW1Gk3QKC2k
s2RmOk1eHrQz/7hcbPzjau63p3t/t1zND+3Jdo8u4gDAGse4DqhT1NhYU4qy
hvcBym5oAUGFsgt6kt35UlQa7y427XIZ2OCFUdJsTrILWtmy7bCOMqwGhH1y
z1XnbiSiEPGUjFSJelgWZHnHWakm4f4SlxXFOCHJB6r/wvrah0pbz28N2MaC
uJocFzqRwVtXpZkGvWDuvzM8qoMegVyiVeU+BgMtRU2cuwyv6xmpFneKr9fj
GUcJzkspxt9y2mef9Gt7YDei7WSBJCNhzIQxE8a0EdF2ssB7Ga1QF1/KgdXn
uSPjHnln82/u5bO8V/ioqIDNeOyrZKvwTZk+PvXyfDyf6FeybY2+jxoT+B/e
0c7/qsA5AcGF8K8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{107, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258047673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14849033],

Cell["Put a styled frame around an individual element:", "ExampleText",
 CellID->464891231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", 
        RowBox[{"FrameStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}], ",", "b"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->769908544],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1UsEKwjAMbZu2iqjs4EFQxvwZPfkRZQjbQRxz/1/TLiudKyI4C2nSl5ek
TXM1XXW7m64uTXFpTVPV5bM4P1qEgDPGcpTTnqFt0fKSW4s63pe4A7q2qBVz
a+FwZ9phOXSdRLnXPgKCz+eajZu+SZRBBL57i8TTBvWA8uA9jk6HiDPuyA5l
9WYJlMxF/AXR1HtFHqCzCAyV7IQmvvzQw9+jNXV1vmqC3sYndYDmL9SRfR4/
mFE/spgTzQJMGED11Nc/kvr/fjIYfwH05pb8\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{30, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158586980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256724259],

Cell[TextData[{
 "Individually styled frames can be used with ",
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 ", and have higher priority:"
}], "ExampleText",
 CellID->866284491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Red"}], ",", 
        RowBox[{"3", "\[Rule]", "Dashed"}]}], "}"}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Thin"}], "]"}]}]}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227151410],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEsOgjAQHSgfDSG4cOGSe8jORFceQSMxJrgwGvQ+Hs2j1Ck/MZbYyqeY
QFLedDqUYZjXTroOb9HhFN6O+9BfxeElOu6v/vIco4poABBjW8wAZYpS0mJK
EafYPJQIqgxEo4SBoIWObYISw21NDZtZByanaGUWhKcHcf1Ysm8VHplMYh9L
kwsFO/PJ4I+A3Ijzk8Yu/Mu/eJR5ZZb7UN13K3DUwcwyMXUFNHVjKJp1zpf+
71kmwxYvezrHTxZ2Y9EOs9uL8cBktUxWEVP1WVdvZ+SzEMgddj482Fbu4S2x
ZAgvDNJ9ntAiLl7FnHNErSHrTeOj3B2+gz9ocr2pyF3F+W5xfX1jdQOstxW+
5Z/i3q+MbY+ZIivEA/wd3L+vU0Nt0sf8HmqToTaRrU2aOFFIzyZAewJMMEIu
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{114, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187448159]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11200],

Cell["Frame diagonal elements:", "ExampleText",
 CellID->25419607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Range", "[", "100", "]"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k", ",", "k"}], "}"}], "\[Rule]", "True"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "10"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4524886],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"},
    {"11", "12", "13", "14", "15", "16", "17", "18", "19", "20"},
    {"21", "22", "23", "24", "25", "26", "27", "28", "29", "30"},
    {"31", "32", "33", "34", "35", "36", "37", "38", "39", "40"},
    {"41", "42", "43", "44", "45", "46", "47", "48", "49", "50"},
    {"51", "52", "53", "54", "55", "56", "57", "58", "59", "60"},
    {"61", "62", "63", "64", "65", "66", "67", "68", "69", "70"},
    {"71", "72", "73", "74", "75", "76", "77", "78", "79", "80"},
    {"81", "82", "83", "84", "85", "86", "87", "88", "89", "90"},
    {"91", "92", "93", "94", "95", "96", "97", "98", "99", "100"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{
    "Columns" -> None, "Rows" -> None, 
     "ItemsIndexed" -> {{1, 1} -> True, {2, 2} -> True, {3, 3} -> 
       True, {4, 4} -> True, {5, 5} -> True, {6, 6} -> True, {7, 7} -> 
       True, {8, 8} -> True, {9, 9} -> True, {10, 10} -> True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{242, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152828802]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25166],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " can be used to individually specify the dividers between rows and \
columns:"
}], "ExampleText",
 CellID->1753916702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1717471792],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpAGxrQQDkP0fyALj
tP//gTSEZGAGiYABQzIRIkxAggnIhdGcNOYzYriAGUSwIPgMDNx0FGHCcA8L
1KW8JNLMNDRpsIXRwKcaYtL2wIoMfBgNtlQzmrNGc9ZozhrNWaM5a7CKDHwY
DbZUM5qzhnvOAnWo4L0nRgDq/Rqo\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{102, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88867047]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1541807528],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {True}, "Rows" -> {True}}],
  "Grid"]], "Output",
 ImageSize->{112, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1184321592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88669207],

Cell["In 2D, frames are drawn above the graphics:", "ExampleText",
 CellID->824055203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206505545],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Frame->True,
  PlotRange->{{0, 1}, {0, 1}}]], "Output",
 ImageSize->{154, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->528311824]
}, Open  ]],

Cell[TextData[{
 "Objects in ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " are drawn on top of any graphics, including frames:"
}], "ExampleText",
 CellID->109784410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", ".5"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154466856],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Epilog->{
    RGBColor[0, 0, 1], 
    DiskBox[{0, 0}, 0.5]},
  Frame->True,
  PlotRange->{{0, 1}, {0, 1}}]], "Output",
 ImageSize->{154, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->492375608]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60624786],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GridLines",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLines"]], "InlineFormula"],
 " puts grids across the image:"
}], "ExampleText",
 CellID->50562259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16430822],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  GridLines->Automatic]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->211619932]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21084],

Cell["Frame the upper left sub grids: ", "ExampleText",
 CellID->578408418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Range", "[", "100", "]"}], ",", "10"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "k"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "k"}], "}"}]}], "}"}], "\[Rule]", "True"}], ",",
         
        RowBox[{"{", 
         RowBox[{"k", ",", "10"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31368993],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"},
    {"11", "12", "13", "14", "15", "16", "17", "18", "19", "20"},
    {"21", "22", "23", "24", "25", "26", "27", "28", "29", "30"},
    {"31", "32", "33", "34", "35", "36", "37", "38", "39", "40"},
    {"41", "42", "43", "44", "45", "46", "47", "48", "49", "50"},
    {"51", "52", "53", "54", "55", "56", "57", "58", "59", "60"},
    {"61", "62", "63", "64", "65", "66", "67", "68", "69", "70"},
    {"71", "72", "73", "74", "75", "76", "77", "78", "79", "80"},
    {"81", "82", "83", "84", "85", "86", "87", "88", "89", "90"},
    {"91", "92", "93", "94", "95", "96", "97", "98", "99", "100"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{
    "Columns" -> None, "Rows" -> None, 
     "ItemsIndexed" -> {{{1, 1}, {1, 1}} -> True, {{1, 2}, {1, 2}} -> 
       True, {{1, 3}, {1, 3}} -> True, {{1, 4}, {1, 4}} -> 
       True, {{1, 5}, {1, 5}} -> True, {{1, 6}, {1, 6}} -> 
       True, {{1, 7}, {1, 7}} -> True, {{1, 8}, {1, 8}} -> 
       True, {{1, 9}, {1, 9}} -> True, {{1, 10}, {1, 10}} -> True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{242, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151001625]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18304],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Framed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Framed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dividers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dividers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameTicks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boxed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boxed"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19501]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11685],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->280319219],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->144157870],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->30348036],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->485333491],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->33263000],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->405351285],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->55960078],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->484097736],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->219094291]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Frame - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 17.4391756}", "context" -> "System`", 
    "keywords" -> {
     "box", "framed", "graphics frame", "table frame", "grid frame"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Frame is an option for Graphics, Grid and other constructs that \
specifies whether to include a frame. ", "synonyms" -> {}, "title" -> "Frame",
     "type" -> "Symbol", "uri" -> "ref/Frame"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[29363, 860, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->420548067]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 98832, 2957}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4212, 88, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4835, 115, 4189, 83, 70, "ObjectNameGrid"],
Cell[9027, 200, 741, 23, 70, "Usage",
 CellID->13161]
}, Open  ]],
Cell[CellGroupData[{
Cell[9805, 228, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10283, 245, 76, 1, 70, "Notes",
 CellID->31854],
Cell[10362, 248, 1380, 37, 70, "2ColumnTableMod",
 CellID->19484],
Cell[11745, 287, 1153, 39, 70, "Notes",
 CellID->1001088588],
Cell[12901, 328, 381, 12, 70, "Notes",
 CellID->24136695],
Cell[13285, 342, 2380, 65, 70, "2ColumnTableMod",
 CellID->5388],
Cell[15668, 409, 480, 16, 70, "Notes",
 CellID->46514975],
Cell[16151, 427, 2653, 79, 70, "2ColumnTableMod",
 CellID->11051],
Cell[18807, 508, 320, 11, 70, "Notes",
 CellID->25391],
Cell[19130, 521, 8269, 265, 70, "2ColumnTableMod",
 CellID->16534],
Cell[27402, 788, 1110, 37, 70, "Notes",
 CellID->26373273],
Cell[28515, 827, 811, 28, 70, "Notes",
 CellID->227894726]
}, Closed]],
Cell[CellGroupData[{
Cell[29363, 860, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->420548067],
Cell[CellGroupData[{
Cell[29748, 874, 147, 5, 70, "ExampleSection",
 CellID->11098265],
Cell[29898, 881, 70, 1, 70, "ExampleText",
 CellID->133795784],
Cell[CellGroupData[{
Cell[29993, 886, 259, 8, 28, "Input",
 CellID->9964907],
Cell[30255, 896, 2989, 53, 136, "Output",
 Evaluatable->False,
 CellID->74363408]
}, Open  ]],
Cell[33259, 952, 124, 3, 70, "ExampleDelimiter",
 CellID->52719449],
Cell[33386, 957, 83, 1, 70, "ExampleText",
 CellID->144333763],
Cell[CellGroupData[{
Cell[33494, 962, 432, 14, 28, "Input",
 CellID->43807148],
Cell[33929, 978, 2734, 49, 127, "Output",
 Evaluatable->False,
 CellID->611276916]
}, Open  ]],
Cell[36678, 1030, 124, 3, 70, "ExampleDelimiter",
 CellID->16644194],
Cell[36805, 1035, 69, 1, 70, "ExampleText",
 CellID->280543320],
Cell[CellGroupData[{
Cell[36899, 1040, 279, 9, 28, "Input",
 CellID->30126082],
Cell[37181, 1051, 447, 11, 84, "Output",
 Evaluatable->False,
 CellID->125141248]
}, Open  ]],
Cell[37643, 1065, 74, 1, 70, "ExampleText",
 CellID->338538436],
Cell[CellGroupData[{
Cell[37742, 1070, 279, 9, 28, "Input",
 CellID->630251220],
Cell[38024, 1081, 544, 13, 88, "Output",
 Evaluatable->False,
 CellID->73005082]
}, Open  ]],
Cell[38583, 1097, 123, 3, 70, "ExampleDelimiter",
 CellID->3532064],
Cell[38709, 1102, 269, 9, 70, "ExampleText",
 CellID->256827188],
Cell[CellGroupData[{
Cell[39003, 1115, 380, 11, 28, "Input",
 CellID->120129542],
Cell[39386, 1128, 3092, 55, 138, "Output",
 Evaluatable->False,
 CellID->634884700]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42527, 1189, 216, 7, 70, "ExampleSection",
 CellID->24740],
Cell[CellGroupData[{
Cell[42768, 1200, 236, 7, 70, "ExampleSubsection",
 CellID->531461547],
Cell[43007, 1209, 87, 1, 70, "ExampleText",
 CellID->810167149],
Cell[CellGroupData[{
Cell[43119, 1214, 432, 14, 70, "Input",
 CellID->36249098],
Cell[43554, 1230, 2400, 44, 70, "Output",
 Evaluatable->False,
 CellID->184881615]
}, Open  ]],
Cell[45969, 1277, 125, 3, 70, "ExampleDelimiter",
 CellID->423921085],
Cell[46097, 1282, 74, 1, 70, "ExampleText",
 CellID->108539650],
Cell[CellGroupData[{
Cell[46196, 1287, 334, 11, 70, "Input",
 CellID->317061368],
Cell[46533, 1300, 541, 13, 70, "Output",
 Evaluatable->False,
 CellID->178803416]
}, Open  ]],
Cell[47089, 1316, 70, 1, 70, "ExampleText",
 CellID->94045870],
Cell[CellGroupData[{
Cell[47184, 1321, 334, 11, 70, "Input",
 CellID->257420082],
Cell[47521, 1334, 435, 11, 70, "Output",
 Evaluatable->False,
 CellID->506984504]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48005, 1351, 233, 7, 70, "ExampleSubsection",
 CellID->55708741],
Cell[48241, 1360, 79, 1, 70, "ExampleText",
 CellID->84494844],
Cell[CellGroupData[{
Cell[48345, 1365, 492, 15, 70, "Input",
 CellID->81179046],
Cell[48840, 1382, 424, 15, 162, "Output",
 CellID->538146350]
}, Open  ]],
Cell[49279, 1400, 124, 3, 70, "ExampleDelimiter",
 CellID->11536810],
Cell[49406, 1405, 77, 1, 70, "ExampleText",
 CellID->823414964],
Cell[CellGroupData[{
Cell[49508, 1410, 399, 12, 70, "Input",
 CellID->318063793],
Cell[49910, 1424, 581, 14, 70, "Output",
 Evaluatable->False,
 CellID->65218126]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50540, 1444, 242, 7, 70, "ExampleSubsection",
 CellID->43483404],
Cell[50785, 1453, 91, 1, 70, "ExampleText",
 CellID->513450776],
Cell[CellGroupData[{
Cell[50901, 1458, 361, 11, 70, "Input",
 CellID->130102686],
Cell[51265, 1471, 2542, 46, 70, "Output",
 Evaluatable->False,
 CellID->278520385]
}, Open  ]],
Cell[53822, 1520, 124, 3, 70, "ExampleDelimiter",
 CellID->78564993],
Cell[53949, 1525, 72, 1, 70, "ExampleText",
 CellID->799486137],
Cell[CellGroupData[{
Cell[54046, 1530, 519, 17, 70, "Input",
 CellID->63028012],
Cell[54568, 1549, 2827, 50, 70, "Output",
 Evaluatable->False,
 CellID->613391227]
}, Open  ]],
Cell[57410, 1602, 125, 3, 70, "ExampleDelimiter",
 CellID->488864868],
Cell[57538, 1607, 69, 1, 70, "ExampleText",
 CellID->439930527],
Cell[CellGroupData[{
Cell[57632, 1612, 304, 9, 70, "Input",
 CellID->24643],
Cell[57939, 1623, 2313, 42, 70, "Output",
 Evaluatable->False,
 CellID->211125151]
}, Open  ]],
Cell[60267, 1668, 125, 3, 70, "ExampleDelimiter",
 CellID->384317580],
Cell[60395, 1673, 90, 1, 70, "ExampleText",
 CellID->25360382],
Cell[CellGroupData[{
Cell[60510, 1678, 314, 9, 70, "Input",
 CellID->12988],
Cell[60827, 1689, 2667, 48, 70, "Output",
 Evaluatable->False,
 CellID->110585761]
}, Open  ]],
Cell[63509, 1740, 125, 3, 70, "ExampleDelimiter",
 CellID->610285637],
Cell[63637, 1745, 91, 1, 70, "ExampleText",
 CellID->28686972],
Cell[CellGroupData[{
Cell[63753, 1750, 717, 24, 70, "Input",
 CellID->259399820],
Cell[64473, 1776, 2451, 44, 70, "Output",
 Evaluatable->False,
 CellID->49788168]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[66985, 1827, 238, 7, 70, "ExampleSection",
 CellID->4104],
Cell[CellGroupData[{
Cell[67248, 1838, 241, 7, 70, "ExampleSubsection",
 CellID->291717711],
Cell[67492, 1847, 126, 3, 70, "ExampleText",
 CellID->367583419],
Cell[CellGroupData[{
Cell[67643, 1854, 393, 14, 70, "Input",
 CellID->5631025],
Cell[68039, 1870, 498, 12, 70, "Output",
 Evaluatable->False,
 CellID->27052314]
}, Open  ]],
Cell[68552, 1885, 117, 3, 70, "ExampleText",
 CellID->212071829],
Cell[CellGroupData[{
Cell[68694, 1892, 423, 15, 70, "Input",
 CellID->31900168],
Cell[69120, 1909, 525, 13, 70, "Output",
 Evaluatable->False,
 CellID->744421612]
}, Open  ]],
Cell[69660, 1925, 125, 3, 70, "ExampleDelimiter",
 CellID->111836538],
Cell[69788, 1930, 123, 3, 70, "ExampleText",
 CellID->161391847],
Cell[CellGroupData[{
Cell[69936, 1937, 391, 13, 70, "Input",
 CellID->85937981],
Cell[70330, 1952, 447, 11, 70, "Output",
 Evaluatable->False,
 CellID->180324967]
}, Open  ]],
Cell[70792, 1966, 124, 3, 70, "ExampleDelimiter",
 CellID->17006101],
Cell[70919, 1971, 75, 1, 70, "ExampleText",
 CellID->797409539],
Cell[CellGroupData[{
Cell[71019, 1976, 401, 13, 70, "Input",
 CellID->1764164693],
Cell[71423, 1991, 442, 14, 86, "Output",
 CellID->2014556348]
}, Open  ]],
Cell[71880, 2008, 82, 1, 70, "ExampleText",
 CellID->278608329],
Cell[CellGroupData[{
Cell[71987, 2013, 445, 15, 70, "Input",
 CellID->89820352],
Cell[72435, 2030, 500, 12, 70, "Output",
 Evaluatable->False,
 CellID->773030373]
}, Open  ]],
Cell[72950, 2045, 125, 3, 70, "ExampleDelimiter",
 CellID->384703251],
Cell[73078, 2050, 65, 1, 70, "ExampleText",
 CellID->1356547037],
Cell[CellGroupData[{
Cell[73168, 2055, 604, 20, 70, "Input",
 CellID->1108049723],
Cell[73775, 2077, 480, 15, 84, "Output",
 CellID->1421362234]
}, Open  ]],
Cell[74270, 2095, 126, 3, 70, "ExampleDelimiter",
 CellID->1031681727],
Cell[74399, 2100, 71, 1, 70, "ExampleText",
 CellID->1799654307],
Cell[CellGroupData[{
Cell[74495, 2105, 602, 20, 70, "Input",
 CellID->1630253401],
Cell[75100, 2127, 473, 15, 82, "Output",
 CellID->226977610]
}, Open  ]],
Cell[75588, 2145, 126, 3, 70, "ExampleDelimiter",
 CellID->1781762087],
Cell[75717, 2150, 97, 1, 70, "ExampleText",
 CellID->1563422441],
Cell[CellGroupData[{
Cell[75839, 2155, 360, 13, 70, "Input",
 CellID->1978544842],
Cell[76202, 2170, 282, 13, 52, "Output",
 CellID->290143500]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76533, 2189, 239, 7, 70, "ExampleSubsection",
 CellID->308441468],
Cell[76775, 2198, 87, 1, 70, "ExampleText",
 CellID->109825147],
Cell[CellGroupData[{
Cell[76887, 2203, 475, 16, 70, "Input",
 CellID->549877936],
Cell[77365, 2221, 590, 14, 70, "Output",
 Evaluatable->False,
 CellID->166298073]
}, Open  ]],
Cell[77970, 2238, 125, 3, 70, "ExampleDelimiter",
 CellID->164204064],
Cell[78098, 2243, 88, 1, 70, "ExampleText",
 CellID->6719319],
Cell[CellGroupData[{
Cell[78211, 2248, 874, 29, 70, "Input",
 CellID->141173846],
Cell[79088, 2279, 655, 15, 70, "Output",
 Evaluatable->False,
 CellID->258047673]
}, Open  ]],
Cell[79758, 2297, 124, 3, 70, "ExampleDelimiter",
 CellID->14849033],
Cell[79885, 2302, 91, 1, 70, "ExampleText",
 CellID->464891231],
Cell[CellGroupData[{
Cell[80001, 2307, 493, 16, 70, "Input",
 CellID->769908544],
Cell[80497, 2325, 491, 12, 70, "Output",
 Evaluatable->False,
 CellID->158586980]
}, Open  ]],
Cell[81003, 2340, 125, 3, 70, "ExampleDelimiter",
 CellID->256724259],
Cell[81131, 2345, 257, 8, 70, "ExampleText",
 CellID->866284491],
Cell[CellGroupData[{
Cell[81413, 2357, 690, 21, 70, "Input",
 CellID->227151410],
Cell[82106, 2380, 639, 15, 70, "Output",
 Evaluatable->False,
 CellID->187448159]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[82806, 2402, 223, 7, 70, "ExampleSection",
 CellID->11200],
Cell[83032, 2411, 66, 1, 70, "ExampleText",
 CellID->25419607],
Cell[CellGroupData[{
Cell[83123, 2416, 548, 18, 70, "Input",
 CellID->4524886],
Cell[83674, 2436, 1226, 26, 184, "Output",
 CellID->152828802]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84949, 2468, 233, 7, 70, "ExampleSection",
 CellID->25166],
Cell[85185, 2477, 255, 8, 70, "ExampleText",
 CellID->1753916702],
Cell[CellGroupData[{
Cell[85465, 2489, 392, 13, 70, "Input",
 CellID->1717471792],
Cell[85860, 2504, 422, 11, 70, "Output",
 Evaluatable->False,
 CellID->88867047]
}, Open  ]],
Cell[CellGroupData[{
Cell[86319, 2520, 389, 13, 70, "Input",
 CellID->1541807528],
Cell[86711, 2535, 413, 13, 86, "Output",
 CellID->1184321592]
}, Open  ]],
Cell[87139, 2551, 124, 3, 70, "ExampleDelimiter",
 CellID->88669207],
Cell[87266, 2556, 86, 1, 70, "ExampleText",
 CellID->824055203],
Cell[CellGroupData[{
Cell[87377, 2561, 454, 15, 70, "Input",
 CellID->206505545],
Cell[87834, 2578, 313, 10, 170, "Output",
 CellID->528311824]
}, Open  ]],
Cell[88162, 2591, 241, 8, 70, "ExampleText",
 CellID->109784410],
Cell[CellGroupData[{
Cell[88428, 2603, 676, 22, 70, "Input",
 CellID->154466856],
Cell[89107, 2627, 376, 13, 170, "Output",
 CellID->492375608]
}, Open  ]],
Cell[89498, 2643, 124, 3, 70, "ExampleDelimiter",
 CellID->60624786],
Cell[89625, 2648, 207, 7, 70, "ExampleText",
 CellID->50562259],
Cell[CellGroupData[{
Cell[89857, 2659, 248, 7, 70, "Input",
 CellID->16430822],
Cell[90108, 2668, 280, 9, 162, "Output",
 CellID->211619932]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[90437, 2683, 224, 7, 70, "ExampleSection",
 CellID->21084],
Cell[90664, 2692, 75, 1, 70, "ExampleText",
 CellID->578408418],
Cell[CellGroupData[{
Cell[90764, 2697, 688, 23, 70, "Input",
 CellID->31368993],
Cell[91455, 2722, 1342, 28, 184, "Output",
 CellID->151001625]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92858, 2757, 311, 9, 70, "SeeAlsoSection",
 CellID->18304],
Cell[93172, 2768, 1433, 53, 70, "SeeAlso",
 CellID->19501]
}, Open  ]],
Cell[CellGroupData[{
Cell[94642, 2826, 314, 9, 70, "TutorialsSection",
 CellID->11685],
Cell[94959, 2837, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[95100, 2842, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[95250, 2847, 303, 9, 70, "Tutorials",
 CellID->542584750],
Cell[95556, 2858, 146, 3, 70, "Tutorials",
 CellID->175077611],
Cell[95705, 2863, 162, 3, 70, "Tutorials",
 CellID->659944600],
Cell[95870, 2868, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[96064, 2876, 319, 9, 70, "MoreAboutSection",
 CellID->280319219],
Cell[96386, 2887, 173, 3, 70, "MoreAbout",
 CellID->144157870],
Cell[96562, 2892, 146, 3, 70, "MoreAbout",
 CellID->30348036],
Cell[96711, 2897, 155, 3, 70, "MoreAbout",
 CellID->485333491],
Cell[96869, 2902, 174, 3, 70, "MoreAbout",
 CellID->33263000],
Cell[97046, 2907, 163, 3, 70, "MoreAbout",
 CellID->405351285],
Cell[97212, 2912, 139, 3, 70, "MoreAbout",
 CellID->55960078],
Cell[97354, 2917, 142, 3, 70, "MoreAbout",
 CellID->484097736],
Cell[97499, 2922, 180, 3, 70, "MoreAbout",
 CellID->219094291]
}, Open  ]],
Cell[97694, 2928, 50, 0, 70, "History"],
Cell[97747, 2930, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

