(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    446699,       8246]
NotebookOptionsPosition[    437890,       7940]
NotebookOutlinePosition[    439296,       7979]
CellTagsIndexPosition[    439209,       7974]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Labeling Two\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingTwoDimensionalGraphics"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Labeling Two\[Hyphen]Dimensional Graphics\"\>", 
       3->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Frame" :> Documentation`HelpLookup["paclet:ref/Frame"], 
          "Labeled" :> Documentation`HelpLookup["paclet:ref/Labeled"], 
          "AxesLabel" :> Documentation`HelpLookup["paclet:ref/AxesLabel"], 
          "PlotLabel" :> Documentation`HelpLookup["paclet:ref/PlotLabel"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Frame\"\>", 
       2->"\<\"Labeled\"\>", 3->"\<\"AxesLabel\"\>", 
       4->"\<\"PlotLabel\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsOptionsAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>", 
       3->"\<\"Graphics Options & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FrameLabel", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FrameLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FrameLabel"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " and related functions that specifies labels to be placed on the edges \
of a frame. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28574]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FrameLabel", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that no labels should be given. "
}], "Notes",
 CellID->2235],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FrameLabel", "->", 
   StyleBox["label", "TI"]}]], "InlineFormula"],
 " specifies a label for the bottom edge of the frame. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->17255],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FrameLabel", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["bottom", "TI"], ",", 
     StyleBox["left", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies labels for the bottom and left\[Hyphen]hand edges of the frame. \
"
}], "Notes",
 CellID->5713],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FrameLabel", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["left", "TI"], ",", 
       StyleBox["right", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["bottom", "TI"], ",", 
       StyleBox["top", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies labels for each of the edges of the frame. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5621],

Cell[TextData[{
 "Any expression can be specified as a label. It will be given by default in \
",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". Arbitrary strings of text can be given as ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27212],

Cell[TextData[{
 "Labels for the vertical edges of the frame are by default written \
vertically. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RotateLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateLabel"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " specifies that they should be horizontal. "
}], "Notes",
 CellID->32304]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->90816981],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->42267439],

Cell["Place labels on the bottom edge of the frame:", "ExampleText",
 CellID->406721236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25225454],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->452382959]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355586309],

Cell["Place labels on the bottom and left frame edges:", "ExampleText",
 CellID->513450776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130102686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->206713533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78564993],

Cell["Specify labels for each edge:", "ExampleText",
 CellID->799486137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "\"\<plot\>\""}], "}"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->63028012],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413406351]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63018244],

Cell[TextData[{
 "Overall style of all the label-like elements can be specified by ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->194566514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Bold"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558268740],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120969143]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23213],

Cell[TextData[{
 "Labels use ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " by default: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->27212]
}], "ExampleText",
 CellID->175125548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194121374],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm]}]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->122984769]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141434770],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", instead:"
}], "ExampleText",
 CellID->82479360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"StandardForm", "[", "x", "]"}], ",", 
      RowBox[{"StandardForm", "[", "y", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2477946],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameLabel->{
    FormBox[
     TagBox[
      FormBox["x", StandardForm], StandardForm, Editable -> True], 
     TraditionalForm], 
    FormBox[
     TagBox[
      FormBox["y", StandardForm], StandardForm, Editable -> True], 
     TraditionalForm]}]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->331112918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183673086],

Cell[TextData[{
 "Individually styled labels can be used together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 ", and have higher priority:"
}], "ExampleText",
 CellID->636303218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"x", ",", "Bold", ",", "Red"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"y", ",", "Bold", ",", "Blue"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Medium"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86999437],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23434315]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16487],

Cell[TextData[{
 "Specify frame labels for ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->107384665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4100350],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$968$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$968$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, 
      "Options" :> {
       FrameLabel -> {{$CellContext`a, $CellContext`b}, {$CellContext`c, \
$CellContext`d}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{276., {60., 65.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{280, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94805580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224904698],

Cell[TextData[{
 "Use labels based on variables specified in ",
 Cell[BoxData[
  ButtonBox["CountourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountourPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9992112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187420325],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnQmYZVV1tmuuujXcqrq3ExRMNNqiMRrBoSNaWsc/KmklEXFMGidE40Ar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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHtsl2cVx5/S9teyTnr5FUpLf4WWdvTXkjh0SzTLCJcYs7ERrlVhQIIW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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVto1FcQxie7ZqNddTfrRm3Z3X92k9XdGCltLUUEsfogVRLxgoixCnlR
o0mKCm2pxTz0TmuxD15asFCtosWqEdz4IhJvtLEiXlo1BgwaL9XapqVSawr9
Dd/DwMy5zPlm5ps52eb2BW0hM1uPDENm15s1pc1awmat48ymYy/JYkfMFmI3
Yw8gD54168b+vGiWZ/+lsWb3xrCPXiiYvZAwe521ds6urjX7jvt/cX4Tvi+x
9i33/46Z/RGYvYc9bTzvxs3eQk+x9hqgqlhLB1pzvQmAU7GHIbOSZs9XmO3L
mHWAYU9EGPuxu7CHKs0OYGfQA2Qx2FaO5m30lTlwlJnNxMdF7HAg/VXkTN7s
bWLo4u528F3m7Yv1uuuYv55kdpL734QUc5yzf1aDD/3fEZzLKoeeu334eB//
B8DUx/u9SBm5KWWUq6dgbGV/Gjn5gvsl1s7z/jnkDHd38n4753ex30nsH5HT
59B/ymvv16jZQ/bHZ7Q3jvtLJmrN9VSlanWDOw0J1awerLvrzMpHme0frtyk
ke5y5ej7jGrmtVoPhrXstXj+0I+yPx3fLfjrCctnKWW2pqi9OP7C5OeVCfik
lp9VmZ0F6y18fgneHUgH+8tr4AbxJIm5El/vcH4Z5+8Qz0b0emRwuNY+xvch
7vfj/ybyCfndzVoZtTr0DDVB34VsjmhtMtjvgmkr9c0RQxfvlZAt+OuLi5tF
5MWEOHoV/Tcw/Ic+hNRhrwPf7LDOPC2Ks87VDfi/xv4s7Iqw7qyrFoedu/28
0ZxWDjz2GQnFPgTm/qhy8C6572JtI3gf4O9gRjF6bI75CGdHIXHOx6LiRmdW
unPEe6MC/j2KqkeO8f591s6Sz6Xwb0q1OOLcOAiebeS/if5byHutvB8htqns
bw+JA657j3tv+5rHfhT888cqB29w9zBrF+D/CmQe59trpZfwORpsq1Pi/hOk
ETs7Ubl2H1PI18sF5aKH873Ee5h4Y0n1rPfSqZywek89cey16p0FcHIz9nLu
fxUTZ7zWe5FQUjWvIt6ddcq913gN9ok6cek69gnO/s6bJyPi0AfYHxbViz4D
osQ2skZnvaY3wNKXE5ed47Xs5WvENe9Bz7VzzLnlOd9ErgarxeUxyDHe2lLU
7PEatxDL6UmahT4Du9l7nFEuvIZ7isqp59JjGiB/b5LPuczitgpxIZZVbp0T
P1LPH/LqTY8pVNBM8VniM28pvlI59bbP8I60OOzcXZVQby0K5Nt7zGfvYCAu
+gz23t2aF1e8h1eB5XRes/A4fGngrcaCuHbH/wT0RQX5foTdyNsNyDbwz4iI
O501uuscugKWSKC7vcRzGbscewD7Z+z75OuftGr/mLWHafWo96ZzxmdRW1Gz
0meS/wU+w312+58wh7NzC/ob3KfP0p68sPhMvZ3RTPJZ5Jz6hbsjA2H3HvVZ
7jX1WvpM97/g07T+Hv8T+jifDITNZ/r/sB4dSQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.3834351563046074, 0.213923401790075, 0.6559448140743914], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mUVdWVxm9Nz6LmqlcF1PBe1auBeq+qNB0VjSjIKBQKBQiKMokzCBJx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVx69mAULyAgmLaN7L9h55Lwm2U6FjFxFCQCOEJYsiECRhXwKM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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4736031941102623, 0.3707012683027887, 0.7826868991091485], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3eYVtW1xg8zw/TC9w0DDMN804dpsQAKChopAipW7HRslICxJ4hIEanG
jopoorG3WHNV9Ln2GjV2RQUFWxQ1RsUSxfv+5l083D/Oc/bZZ5+191579bVO
3dQTD5mdlSTJuV2TJFv388uTpLAqSar0UN6WJGldS7snybWFSTK1R5Jk5SXJ
3Lokeb49Sa7PTZIr1f5Q7TvU/imdJJM1BkD/zk+Sz/U8VsDPr06S59r9/eOt
SfKErlbBrEh7zGDNfbHeX6SrVWOu0X1nwR2o9jGa70G9rxHYWYL5Sk6SLNGV
3SdJztI6l6o9J+37ao2ZqYFPNCTJBfruzLTfHa/v7xLMUYK5l/ZxWCZJShuT
ZIP6b9H7W3V9Atx8P9O+I89rfEH7SuqT5Ht986Lam/X+i1jzJ3oeqTFv6r6l
SPDVPkX73blYOIx1D1J7gN5/oPZk4WWC3s/okiRd9Hx/zyQZo7kWah8LqvxM
+wHdd80yTmkz9rW+STJa6x+q9S/TGZUK1nEaM0h7vaYlSc4rSJIOndV12v+N
WsdcjZso/J2qcS/o/YstXjf43hzrT2u/bRpTqPZPWv84tWfqu746rweEr0MF
/1vNmxbMb7WWR9X3mK6jNe4Owbg9cJUqcd90fbtVuBoZeF6dZ3zOFZxP1L9O
cD4SPn7SfYHW+o3ak7T+T/Xuqmy/n9LmMSeof72e99Qah2ltGwXvDa3zR/Bf
mSQ/6L5WdPSZ1prRfp9JJcnLwtXQ0iS5R/3v6by6g4e054FmttR7bp77ax+X
tPjsi7TOpcJfgeA/qbXP1rVE8x2iNa1Uf5vOq1zreKfYOFuq6+di08vMtNfb
X/B31LqyhIsr831Ov6j/M/X/LW18gasNlW6P1px3aJ1vaZ3F3U3ru+h6WGs4
XfPO09g24W1A9N+l9hfxTJtxtDu6+Azb4xyvFcznBHNrub/bNcZfpb7LtOcp
OsczAv7KxHvgHL/rYt4GLjAnCZ+lel6r56v17emt/pb936vxLRrziOYYoevU
siTZpH3dl/Y30ztE4x0+j961gi0auirf7/mWdf497WfaS4Szm4SvG3U9qG/W
6uqu/v929TM88m2F2/QP7K0z65Ukb2s9ZTqfYrU1JGnjDNVer/auGpOv9mu5
7iuMNnsAX8ilqWn38x28PVNAytS/WPOco+t3ep7UpG909dMeawTzU/VP0thZ
QZMvqb2ywrIGOYO8oQ29/Sx8/69o6QrNt6zA30JjvJ8bYw7SvaSX9zFMOPyy
0PQzXngdp6s51/srif1eqHmn5viMhulcKlt9Zpv1Pi162xxyhr2MTravCdl4
t8YP1rmcLjgXC3YvjZuRtV2Gsp7losUV3f3uwN5+po28Qe6cqXn/2y1JntWZ
vVro98t0NQhOmWCX6npB+23o6f7VGj9O8x4jHH7d1Tw1WfMIVLJCvDtBPHha
2rIUOZqvd+9o3sGlHgef8b6f8LO7niuzvIbjBOBG4eJzwazS2F1y3e5Ranm7
Ue1XtY7riiznj9X464vc30/wd9ZVofUNEMzpafNvh3TCSq2zXjC68V48sFT0
fJbOd0bauuBwjTtC10uJn/kWPO8nuT261O+gKWjrtXg/I+Dvqj2s7m7d0iH8
DEdnaj1jdIZzhaOV5Z53U0/3r6l0OzfHNHluT+vcsRq/RONXaXx22mtiPQsL
3f5G+DlIYxZrzEUaM1g4P0z9e2dZf8JX8NSBwv1BLbFW8enIdsvB53Uuk9vN
ax2C095qfC/R3Nd1tzwv0fjL2ywL4Vd4E7h7auwfhMM5Gt9P7Wlqz1T7O9HF
IH1zd7nxMTNwskjvezRaP15QbvsDOvla92s11/Waa7Vw8l2F8cA8yALWz1qu
B58a06K5DoHO9N0a4SHJ8555f0OM4VyH6Gye7mKYV/Q2rJ0KrGOBObDUcBl/
Y8Bn323YLK2mo436Zr9S8zQ65NLQI7uXuA8eX1zhs941ZAt3eHJ5vXUe+g7Z
C12Dz5+Fm8nqHycY6wp8R/58qPYEtTfpvpfOZajw+Ia+mw6/5NueeD3ffUck
plf2w1421FiPokNH67tpdbYLnhOcIQ0+3xc19qgSy5R5WvNThf7+OO2nXv3t
arcWWEYiV4vT7lukee/M8Tv6t42jn3W9HmtbFetjbV8J3pcl1qeDJUPyhMOR
WkN/nX8/Xc2ltsu6hW1Wr/vHfczf63V1jfHYfdh/2Ejzo40M26o9/aorp9T2
VE4fv58nGntD7RO7eGxOfPtAmdfEej7UGjfqOln9v+1rWMDJ1hqydOWWWi6+
n295iO3KXtAjmzR2Y4NhNWYbzgrt93XhcoPaZ6q9Xu83NNgmfF9nNEq4Wqhv
r9VZHNnh5/G6X6YzelzfLW0WDek6rpvpd3GhafI+bO5C0/ZDouW1vcz3UyXb
phTZJrxNfPAf7eHEXMtLZDcy8xLR76hq73VWnukMGpun/qHVPjfmAB4y5OFe
nmORnlPZhj9X/X/QGv/WYT6bUG77DNvsJvV/1+7nBWpfLJg3a8w9Gru6zrSF
f3BJoX0E9rQo9rVJtLpQ44bme55U2LeMPU14HVXoM4AGZmkNhwveobrGqX++
8LpA10KNS2lPaV37Z9mG41lLS17Jdpv+sTq7PhrbrcDrw/7A9jhR6/1Trb/P
kd75k/ofK/T53F7rM7pcc67UXOfH96XwmmC+nO02dgj3smjvoW9b9e1N2tds
fXeirlP17exC34cXGg+sHVyUiFYLdG3QPn8nPMwM3II75kROvZvy3MwLLSwu
MT18LhyeIfjj4fdi+0DdoQHR7/t9rBuRN8gzZM6T4vfF+dYZ2DITisOeKbA/
AV/cK3l1luCu1rujBeeoRuu5bsyld1PUP7rQd2wnziNdYro/XWspafAzNFde
Yt5Ap3euI9923zg9P6S5SiVHS7jQD5pjrPoH59hm2anadsvXou0T6/3NmTqL
Ozvsmy4Ung4pNn3uJrgHqd2o8beJtm/WlSse+qO+Pa7e41hXaaytqcg+DDQH
D5SVWGZdjo/Qbtt6iu4T2q2H/qHz3EXtBdrDlXm+Y+fvpu8WRhvbf1G03wDP
8bxU9+WhIz7Qt88UWx68ojG3lPp7/NwTCqyr71f/e0V+Hqa9nqK5N+n99+Lv
rg32N+7RWkprPefDwlP/Bvsau2v8XdrzabmmF2ge2kRWI9uR1+iTGbXWH/BL
dfDQxDzrBvTCTqKdrA4/7y+dv0RzTxYNfi/8bxX8twT/I33/cb79X/yLj6L9
Vb7b+BrYi9iNyEPsDPRlQfie+J2MxX97Uv01+vYzndWN2ss7BabNu0sstwoq
bdsx7iG9f7jBcPHRB7VY30I7t5aYLu7U++O1h4f0fFauaRE5fzXfag9/LTGt
/KT+q7X2T/XNtUEXC4SbsyWHf4x33NHd74kPrm+wH31SrJ09Qt+bQv6/VOo5
53Y1jUAf0MNLkun3aX33i1ZXiY9OavYzfvxfwpfHdxsQ/uC92vNVen9Pnnnx
83rzI/Q4KWhyR63nN7oaNOf72tONNaYv9Dz2HLr+3JS/Qw/+RTCu0XWm8PCD
8Nknx/ooVzByGq2bRwv2q7U+p0vVvqHe/trWoGPODpqGtuGD/tWGC8wn6703
9tVT/RfX20fAfyQ2hN58qcI4ATfvab754e+MEL/u3epn7NuctGHOqrfdic05
QDDzhavctOVYdoy5RLJzlWh0D53RNbpfq6tK729tty+KH/pUhb9hPOMK07af
swMW8vD2LD/TP6rY8yzNtb2IjYV9Na/KMZoRut7XWooy9reIA/2aMv1jhx6U
a9v7PHRQ2rDpo00/PnqPCvvpzP9UyOX14rPpTfYThsQ6sa/K094TeKnUvL11
1an9rPa3o/b5TIXttLkV5vU1glWj5xO0nNq0x5YL3rfCzXdtHsecz8S8A3t6
PGP2rvA3wOihe09iSFpDj5TtRWzFvBz7bfiY7Ckde9xFdHV8mdf/55RlGXKM
vYALcEvso0fEo4gTbIlYAfbLN2HDvBV+IToCu6tHrAEYwAKHx4lmdxFNLFX7
SM27NWXfAZwVBd6Q77/PtV0xQvT2vMbUZzmuA01Cm6dJzh1f7dgBtgjzYzud
rv6Z1Y47YPv3K3YcYLO+X5eyLh6r9+06i/6ab7xo9ekax412U9+xejdK/f+q
sH7FD74723z3H8F/J2W9DhxoYWPK9ICcbgvberjgzKq2/XKI2vOqbacTmzu4
q/1j/EVsRvzHl7TmJZItV1V6je8EfM62Ns73n9m2XbBVlsZe8M2RDb9pN4+A
v+LAIfGFgbnGG/GQTMryADjYWO1dHHviG3gLPtgavPBnrfnqFsd+prXaJ8Qf
XCO+GSM6nCy4XbLt2+A7jBIeRuqao/W819f8AC1ts7eYC13FvNh4xD8Y/yc9
3CCYc1sN65XYJ2PQkW9WWG4NxVZt9zO6sSzsOewPcAU+SsscM0JeLRDMZU3e
/4Na9wO61qn9tNb+jK79K7x+YgrdNP5B/O9W65zrsnxH72BjoUvQI7NEI/2b
HStlbvbF/vYSnoa2OD6EzsNO55t14vHDtebNyLBc63bihYuKrOuwnfFTWAu+
ypNa10m1bveosg7ZjXiaYP9bV3W5fQT6iEuPEez9dW2qcLwKfxY6xxbGL8Ee
/lbn1qfWcgj7A9lAzOqzCq8L+sYvIRaCLMXfnx7xE+j/sxjTLPo9NOLM4Htd
4Bz7DX1MfKCS+FN37xMfmtgJfnTX7o6hlqv/mCL7P49qba063+dSjgchM/JC
bvSDL3U9l+tYGnglnkbM4/Va2yO9dFa76nz3Fk7+SHwsZb2G/4GNiw+yJmzq
x0VLXQUvp8U0Tpz/2ZRjT+x1QMTfUlrnlhzz5tw8xzaIuW0scGyeNvoVfIPr
ywXvshbHjInVV0QO5YZC7+W2LpYjxBfAxy8p21unhF7ICdmLnFvR1bJuWpF5
YP+wzzt90jzTKnzGOn8Om+9IfXd/uWURZwK95v0/2X5eyFt4+pfga3gYmY9O
6572OlgDfd2jjT1NLID5sGXwh6BF1g4c9sV5c+7wDr51Rch5bAPsAvy+z0V7
l2fMo/A6MuK0PNMUtAUtkUfBdkZHj44xyJAdq20TQ0tvS5as62u4B4oGDtL1
cYXlPWeFzM/oHE6ttV2LXfZ2rW2zD1KeCxmOHcR32PTEsz+pcAx8V40f2GKa
f1PfHdzud/glP+Vvtze32ZVHlDmHgd07Md++zlVawwyd3fQinwu2Ob4pMo84
YFPg6tHw/zlr1obuAA8/SLbMF//PIBYj2j4/Y1tlnNrjdf213PoHPfReYnok
LgxNHqVvd2g2btGV2O49sh0HRwcg/5GvN2YsY6+TzTlGOuO1Qsdcsc+nCeYB
vQ2TOHDPKssg+IHY5SXlnvMyYLSafgYLT7u32x+Ch/qHLGXspQHn4viW9rn6
9pBWv+PctkSMmNzXqoCPfYzdhg2Mz8DaiC9laZ6/1jp+/6rg3CI4eeSS1L61
1fYeMemictt163We31db1+IHX9pkXxi/fWHEMZA/yB50UC/tNS14hyf+BlnA
Gok/91C7X8hv5BsyHNmEr4Ad/rTWcGWrfXXivosjH4E9xbmhB4FBDBs8f6C1
bWzxWsE//cRU8T/uC7h3xlljb7Cu8lgbORlsH2x78q/QNDp9vtZwaKPXib5b
W246RKetzVif7ZPtXDG5KvJI+PT4nkNkg5xXbrr+s2iwZ63tGviNvAa8zJ08
B/GNQTqLge32CYh5jIv+5bqviLzDY4Lz+1rzNLmI5dGPnEZeowuGam2nZMwb
2O30I8ORhXwDj6yMb+lDHp8fNF9U5dw3z7SJR8ODxNAviLg0uZzx4aeQ30CO
4tcQryHOms5ybu2MwAk2woOBN2wFnpHD+Jep8DGxt8FTY5nzvfdHznda5F2g
Z+h6t6Btcm7k3tDL2F+PRA4O2oaukSH7iTb3J5eh/i3C2+pa5zEeEm4ubXV8
HRnOHTt5z0bnP4iRL9TYFfWWTZtDD2Efg4MLAyfIpAdiX8hidAb6At1M/olY
EHiaEOc4T/Mu0Hp2znVeFvqDJ8AV9I/vTBwEeYQsIt9IzhLba3Zvx+2RY/2E
m/66EsFvEi9+Jhn+fso2fP9YJ7prdoVjHj1Ch+JfEA8g9oOdREyHPCDw3+1t
uMAk/rJfnv30QT19NtjJ2My0OSPug+LM2nRv72lfHjjkrnYOG7wj8jj4QbQf
7OJ4H3MNK/TFWPQI+uSDkNubhfupbZ4X//jVCq/rXuHk763m++GltjngzSrx
fR9d9Wnr4h0qrHuhBfANPXTm9dPWZfAluob148eAP2zvfYTPmhaPI0f9fIVt
rKNKDRv5j221U5ll3MGl9g+x/z4kb99mvA8RH+/R7nXfFToJnwK99EH4Nc+J
xga0e45/SM/0a7cNTFxpUqwHe6q9zDYVshibrzxkMvIYm4Q+Ynvkr9dX+pn2
W1XOe2GrUC9A3QAxZ2oFaI/P8v2HaGNn9g46REYiK8lrzI8aE3KjjP8p4GzL
fyBLkcvki9HjI8MeQf6fE3Ib/YW8WRYy51bxwf0NbkP7lTEv/M16sMOxD86J
b4kHF0VMmDg1tiA8WyP+qGn0XI0hb7CjsOu/DtseHYTeRfd8Toy/xXsghzIi
/BJyJewTmwk5gnwh74+vTk6PfvK5jT0dW4Zmyc1CtxNFjy8jU3Id62kLXiio
sk5jTeiCQcFHwAAWunsvnflv2x0f7cwh97Q85Tzz4hz/o/V+0+K4IBd7Qs6R
9x6acXxsS7V1M/IEeh4RsnE/wd633fk65BprQ4Yge1Ihf4iTzetwrOw+2TAp
XemIu+dErgG6IMbHGS2VvFmma8o2Ok25FmJjpZ9pk/8tiLoCYvj4e/h6nGdj
+H7k9MjFkdfD1nsy/Lim8IE5d2BPCZjE44jfEbsjFopPCFx8gW05RuQ5sQ/s
6fs0/9972d7nzjNnt1TvlqQcJycui55iX/hV2Kr4Avg5IyNH82OR7RJsEvyn
kxv9jC2PLoJWOf+LW00DG6u8H/Zyp2h2fcb2CfEL+AW+qUxtj53PFv7nNNmv
Io44KmKJxA8KI4aAvYcdSd6N+4HRpvaANrRzmNbVvdpy8fE226/wIfyFjmE9
xNrJ4aBnJoouzqh2TnlVmfMo2EnUsk1qdVzv7KjFuiP2Oy17ez6NNjnNtoh3
w3fEXontQv8/9TY8ZBC26sVhi9L/Y6XtMWo9OAt8Z3jx0uBH+IDzghd4T10R
Y/C1aRMfK0dWiw4zGv8v6YvH6kyzyPmPI+aO7f99jWm+Xvcz612XRl1Dj6ht
IDfPM3pquGCPqDRM8pSMpe5ujM7nqQ6/Q/YcUWn5g05Dt2GLspdh8S05lfXd
7GdirzIG3Qft7VTpPWGXDIt9Ae/IgEnf8IDDXneK/ULTjAPPx4oOFzZ6fXeU
2Xenhot85KfdHHNFzy8LOgcGcwOHvqXRTw3j8Fb7UjcIl6/1EQ2mnIdek/Ka
kUXoFPQPe6G/ibi+xv/Yx3HNxVGXAc+OqXItyLa8LHdiIPgID0Xfm9J3A5vs
J6LnkBvI2+U607c6vIe2YtfZ4HdB39A9MvOkUtcXsl9qD7H30YfMC/yRWb4/
HG1iILxHV1KjhZzC3m/QGup1fas9jSmz7iUnSFyE+ipiI9SqoVOx64krUo+C
XUM8kTa884Jg/LHJdgKwqHvDfiKXRQ6SNvkTbErsSWJKxA3xLxbQr2tqN8fA
/hFxMGJVR3dzvOQp0fDoPn7mHFgPc10ieOdq/PHd7CMTu1iW5fcbYszBIt5d
mlxDit/NPPjc+OmbAg+/FDivxffsDXice0fYcLTZP3DRR+T08XHhTXIaR9fY
/v9G7d8120bChiWngm2AHN1caVmKbqeNzER2I8PRBXdHzQfPyAa+Rd6y74c6
vHfiOtkRS/lMfWdlrFfxm1dl7DsD+4uYixos9AR53aO0rvdqXHOB3ASv+DvU
tlwX9S3Im4bQ75w1dUjIB+gFXEGr5N537+YaDOpdqO3kvKgPxu9F3j6q83qi
zTEX5ApwkC3vav4jm/09OTLsFWJL2Jkbgsbgg40x1wyN37l5ew6bOzE36rbw
n7F78Y+fynj91EYSi6cujrqb1qiz+i7j2F9n3K/F8SP8FepTvypznQN88EZf
0++QsO04u04fPerEFoW+wi9AdpL3AD/Dw44nTkUdFXWH1H1dEXVcjHk54s/E
qy8qcg3f8iLb7zvHXpiDNj77/pJtxze6Bg4cUNPM/mdpL/s2Gh/Xiq6vabK9
Bu2Sp4X+mZO54U1iHlfEOR4iWde3xjUv+GjgBl2PHEU3IEvXCd7bTZap+JXw
KXYU+fWsmIP3o9o9hlgY8KgTwD/DT/uswPlKYnuHh01LGxsbvkD3QtvYj8R6
8QtWErMucpySMyT+Da7gT+gB+we7ABlcHrhdHXvcEPMx1/LQA+Ql8X9SEZMk
/rM6ar2Q3QeIBo/r6v2wL2ims3ayl+OES7THpbomam/rJFffrjJPUoc0MXwf
/IshEUvZM+P6ngfD/kSmr41axAnhvywWvHOb/ExcfI/If2HjDIl2j7DV2cuw
qD/eVntMfAY8/LOb7QzWD+9Sr4bcbm10foLcBHmnA9r83X2tjuNAY/i76ci9
4qfir+Lz4pefnbGvmGq0r04bX401cEZbJIvOa7Jtg//6bvi5/6O+wmrDQYcf
EfYnPhO2DHoHXY+eJ/9I/ID45lWhl3cMewC7cVOV+4mj4Otg6yJz3gs7HJ9i
Y/gV3TRncZPjLYfpfniTfcXTwwYFzn+Fh7V9XU/B+XGOnBcydl3V9r514Su+
FWdNO1/wqjOuO8NvwLfBjhoS4/ArPxfszX3t1+6g9UxptE+MncZ9TfhK4Bp6
x2bEjsRu3DtiNtAJMaeiWDP8vV/w+Jl9bENjP18QMSliU5w5Optz3xQ4KQj8
FQachfruUK2/uczxOd5jqzYIdkujY7gz9X5As2Fhq2KbYpeSFx1Q5hgvMnJQ
qeVkYZNr6TgXYh7gBb8KfPIteCM+QlyBmAP/A8wri1yEvluk+aYCr9p1Udty
ANzHR4wLHkBmTCKXrm8Gl7l2eHzG8bcDGi0fkY1DyszP8ML4RucR4T1ydAuD
F9aEPdcUNh02HDp9gWjjrA7LjhM0fnLG8LbVLKKjiaN0j3w2tP99H9P/VLWP
yhhH6Oc5zdbRrOmd4KnbkaNN3n9BtfmE/mMbHV9GlsHH7I/1808CdLok5GWP
kAP4zej5I+IcBsZZcF7UfIHzX7WuPRpd1wqdsQ5kK7bpCVFPBF2/FfQPDGLV
wBmrtRyotTUJ/kbh5JxW572RUcS2kVPEkFcFjRQGnUFPzRGz5Kypu4XP4XH6
mqKNLY9NzzviuMAmZvuE5myoto26v9YwEn4rcw6M/Dp6h9qifTuc/8c32pZH
3Uv9Z7Q6N4t9jb29bb20gYl9sU/EH7CHx1RtHzsmxhA7qc04foJ/zfzYNsT6
GmP9M+u8VsbfzT9ENeYJcojFUbf/VZFju8R1f6893Vvn5yMkGw7v6/g0diBx
UeiK/VDvjm3emU/pZX7k/kXoIO5fRnuy5l/b4WfoEziduUXB7ltnnXCU2kUd
1tvksKgJINdAroN6KWQIvkVHX/sX/NOzocXjyLWBS/QCsWRggP85kQMtD7yf
HPJ8KvWz7fbjeV8ZeVLoEd8L2Xio5hnb1zbgTbrf1m6/i/oj5DsyhPoZ4lDU
4nKfFzEpfO6zox89wjvmR4esCT3C2LOj/oZ63uyo9SV2viBiWVz0wVNnB3xg
YiveFbYH3y6I/gfi/ytgkOumBpH6Q+wK/C5si29EM39rcG1XtxbnwsujBp/a
GXjqlsiDIJ/Jl2Kzo9+pW6IfP4J4Lj4S/hHzL4w15Bc53oofgQ9NGz+aeFXP
yJ1BG9AKtIMM6heympguMTL4ERuFOC3/RPBdr5An+JPk8xjP/xM7xpjx2CZN
/uZo3cc1+R21+YdnbJe+zj934rvd8x2n4k6sinhar4gx8o9FW5n/s6gKHqQW
jnhnJuOYJ/ZQe4zBzmgOGYJuGBF7H4v+ajKs/epdQ4afhX+OL0eNwEdxJ0f4
juj5+r5+Rp+jk5CNxPWwOckpoNt+DN8KnIJrahF/zZhv4VlyqaUR26EGmHoH
2tyhCegB3w8fkPUMLg5/MHALTNZPTe6aqNPeE/rssI+HX8848I8vvDVqQfnu
1YBDPcNjMddp4u87OhyfeqLaNeKsA18B/4FzgZ+okcQWuknv03XO5x8ifBzU
xzb5zer7tt3+ID7i5viHDvrDT8feOFp47tfsZ/Jm2Nyd9nada7i3/RvAvfOf
xEL7w6yZmkf+VeCswe3r4SNTS0ttKfn/UzPOz0E7x2uuORnXaR5NnUyDcUm9
6vtRs7pIc35RY3uxMHQONIW8wt/CNqaOoipobGTUaJB7uiTa+MLYIdgg1H8R
byXuSiyOHNbK8DtmNdtGgQb5bnTA2Y+8dp2fv4w6eGJHj9S53p1ad2qpaqJG
bkXAxBcDv9gy2Db4R5wDOhqdNq3aeoAcGutAd6yMXD/f9hB+Hm11/BU7ZX6N
bRVie/xrSt0F/suFMZ55Lwq/8ssa4w68XRj9jAH2jGgvDz+0I3zSFdH/a61o
stZ+FblJ9kws7gDi9LWWhcdo3wdXOyaOjQVNQ897as3HtTg+dWTGtiZ6jbxx
OmoYakWTWfWusYUu4DH4a476GusdbyRGy747/4/o7hp9YoPU6VIrTK1tGfZU
xn4bMqYxaABeOb3O/DJZ94OqXWuP7GZd+GjldeYTeITrl4j/UOu9Kuq9qVWH
polVFBKD6WteRR7Dq9D4BRnXVaCzLmvzv5db459I/EBse/YJHsHhI4I9sc70
uIPaHe2uu+Q/quKoawXfnfXo2faLeJ4b/jW2Nj4I+57Y5L3Dc5uC704Ou4cY
KXFackXUPh0Rcdvbgl82Re3RYZp/bLtrZ5B5yD7y48ieR0PuUYPRJewN5P30
yE9QOwCNoFOQbb/UWr5trvF/CJ1xpALP18mbFV4v9gz1RDfE2mYJH1Oq/Q/E
cu2pLmN64v+SM+osQy/C3qh3/Id/lTr/Rc9xvIm4E/Yb/wHMqfO7U3Q/p9oy
AH+pKuqsuLMe2uDmpljDRRo7v87P+9ZbHiGL+A94drXr4m8OfEKHyE5kDbYc
dfHf1jqGCI1DT0dGPIc6DOwu6to2h70xPeQN/D6+2v9lIY8WRQ0bMh+ZTByV
WBO+0TdFliHY8vwLQE5uRfA6cRJyTLMiz4R8p03OHT7rErxGzhy/nXgV/2fz
PzwxsGNEe0c328fg/xt8AGx0bBneY89QOzYt5koJXrreMqin7qOrzZPIY2IW
bREf2Dly3MQhnoo62BfhxybjBZ4cHnGz1/v6/3b2vDxiQMxFXu6GqGPfHHYb
OPxB9LClzrh4ts1rYj3YxSNDbm8OGYd8K9b7knrjkXzRAZEzGlntfyrgc2oC
FgX+D27yWlkn/8F31ilmGQcrAg/U5n8R8UZqomfHXsjBcB7k+6YGzClxtscE
fP7ROazOPPKj9ndys2NS1LzwPbGOfSQ7Rzfa50PWljdY3sKbwIE/kYPke8j1
8O8+eXue4S9kAfxOjcn0wu3/b7FP5MmsWCd0MqzVth38PTbqI1jnfZE/RI8j
H2eEDE+HzwMNQzvEo6Ef4vbElokx/x/4YM2S
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl41eWxx38sCdlDcpKwmHOynJwkJ4ciOwgKskiigLK3krAEBJEtUgFb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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5637712319159172, 0.5274791348155025, 0.9094289841439055], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHd8VVW2xy+QEEICSUghCcnNTbspF0HHURCwjSNKsYyKYnlWHNuoIEUF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmA1+P2xz8t05hmmn2mkZnvNt/5fmfmm6Kump8iLu1JqLS4KkrRlcoS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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6300787435715952, 0.6340234069772063, 0.911009216819962], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHd8VVX29k8SQkIS4CYkIaTem4QbksCIvYxKkWYZdcY2ijOCIjpj7zo/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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmgmc1eMax/9TTbMvTTOFzsz8z5wz58ycUyT71kKlulzXlqUslxZEEhFK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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6963731155113378, 0.7405400160791759, 0.9125205243107319], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnQd4lUUWhm9CSUI6JOEmuUluSHKT3ARRLKu7ugqoqyj23ntX1F3X1bWh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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmndglcXSxt8gIQlJICIEkJPkDefkHHICUgQEBYUA9sJnAQt8AopduSDo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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7626637682075126, 0.8470089273240657, 0.9140163198723991], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnAd4lVW2hg8kIaSHNEhCcpKc5KQCImJ31BkdR7mOOqKIiugoVqwoRb0q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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmczvXax3+DMZjt1iyWZu7Z7m3mHjuhjedIm3qpk3LUk+pkKYQkS/Wq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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8222006136791876, 0.8668628788734427, 0.8873438664539983], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3ecVdW1xw8zMJ0ZmF6YO3Mvc5lyx/iMGgQjmEjEKAiCqNgDqGhEinSj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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl01NUVx38sCSFkIytLZpKZZDKTTJAiSkrYbIvosQIKImBVVi0gIsgW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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8817374591508628, 0.8867168304228198, 0.8606714130355977], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnl8lsW1xx8SCBBIQiABsrxv1tfkDVFBuSKVgHVfQQgoKCqLuyJ1Q1bZ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd01eUZx1/IYEgSkhuBkNxLcpNL7r1JK9D2KMiyFvUckY2ooECCAgqi
MioEQUMdZRawtTJEcCPraHFQlohliTiO4jgVFQeOFkGGiEA/33794zn3fX/v
s99nvbesZly/WxuGEC5oEEImv7NjIVybCmFN4xC6ZYcwLhFCLd/OZYWw7rwQ
hsZD6FTGWYsQejYLYQPn/wQyWEehH1UdQv+KELrnhvBqfgib0iHcVAr++SF0
Bf4A7hXwexN+TaD5L0QfJuFfEEJZYQhPVoXQEf5d4d8FOMv6DFCMLt8LwP8C
/lvhvw2obRNCH3TqCq/mzUPoy1kfoCtn3YAFyBqGPc9EQngWOIl+vfj2PvKL
i0O4A94jwb8G3IVNQxiC/NXos7hJCD+g71HOB1d5/Tb2D4fXDyUhPI+/VsKv
ZWUIuW1DuAjad5G/G3vvxN5+4PcBxiLvYmh+C/8vWvIdXVfCc1EO+qFzXXkI
U4Gf4X11Rgj54DcH1jcKIY3/dsJ/TLVp17Efi/+y2K/DN5fkhVCPrmvxyT4u
byEynkR+MfJbIzsBNIb3SPbdWecg8zZsvwwdLkR2P+ifwraD7JOZ9vnjnE9B
3z3YNgQbr0TWePh/im5T0OEOzlfA8xl49YZHD8UD/liXY55dsK0Iea2Q16Gp
bf0ROHCebR6LPTPBv59Y2SMe0A9k/1KO73Ah93kz+HdDu7zQsaaYUCwo5j7m
rj5Gn6PEy0vY2xL8gA9O4ZvrwG/NfjD78ZwPYX8p9K+g8xXQdmxq35xGh+P5
9tEH8i0+3YAvNhVxh+yPImMvvNew/xLaavj9Dn5R+PXj/C7xJBYfwB93oX8D
fF7H2U3oX4HvEkBdnmPsO/BLoR+L7KrW6MHZJHims81jLLJuBV7G/t/g46HY
dozzXZzdA80t8L8bna9H10Hw74V9i+D3HPpMQeZhbPke+AZ7vs637/VNa93B
ftbvVzoXtwHD4N8e+vvQ737kdUC/hnw7yF23w54R2NaPfU/OnkOHbaxz2zj3
tupO0H8X+s1kP50a8Tq2T0bmQGQNAA4g6xPgLWS9CdwB/iLwh4BfDP4Zzh7C
JhWdE5zfiLyBUcf+smzn+oaUfa2cv471nJhr0SlgD/KOo8/Ixs6xQei/HPrV
xO/SlvbVr7HvogL77D+s1xOv23Jck5Zx148Ct2P/bHS4EF4TwJkD/rhCx8bP
ldZNMVKD7DEJ59qlwI2sb+DbCe62Azm6C9qdwCfof6jAteywCmHENW0luJux
IQ7vMdmuNTVx545qzlLOHgF+ivgOfgX9IOivy3DM9cC+4fhknGoTMXwN9AvQ
YTS69ILfPnKjJuXaNqqFfX9rwrrqDlSburaxrqpRa8H9IGZfzwWnAN9MwWdX
46vz8VENuK3w8Tz0vYV6dgh9vlKNQZ8IMqLwX4/MPsi6En7dwV9V4drzKfw2
Q9sM/Rs1dM3/FlmbUq7tWa2wG9yp6NcX3CJ02At+CfidGjqG2iGrsNyx2bHA
ufsw9CcizuG2+GMz9eJifJXPfR/Dly0qXXuP4NMj8C+EpnnEOfwa6+eQ96c8
x/xofPlH7O2LrOno3wr9P4P/teg3GHiZ9Wcxx/694H/HeiPfSgt9hw3A38e+
Jf3h39mmVQ1S7RGPFeDfybcdyN8JTGR/ecq1UDl/Dl3PAj/mu2ZloX8m0DPb
Of8KvpiJ/XNy3FOLub8d4K8F9wA2T1AtBv/jZtZhK/6YgD+6EXIZ1KstrI9g
4w3U227gP4rsZSnXFsWYZH2ecm2UzI/w9/Yqx5ZidgPramQM5z4GtLCv1NPU
y+SzF7DnYMq+mpLt3qIer96uHrMFfWrR4TXYnea+j6B7/zLzUo3K5Dyb/SF0
X8u3Y+DOgd+Xil9yegbre1LOlf0R19b6lNeqsf3SrimqJXsL7cv10ilin87l
bHbKuolnnWItbVzFXJx1GXAb9WIJ32al3HPUa8TjPfD3Jzw7KIbvxl/T4/bl
InQ+wd2cBM5xP/uoATHkX1XmXJjEtxHlruGq3UPZT2d/fdSxdg/71cTnmgr3
PvXsVfj/2aR5d+Xb0+iTzX4G+meiUx7rt2NeNycfOnPeRT0k4pniK3i/C85I
+F+OPvncx2Lsy+Uu8tT/oQ1p94oazv+Fvq8Ba/IdU4uwrW/cs8hdwDrdRdS8
cgtdG1TjVdtVI1og68OYz0rQpwrcYdjTG10G4a8j7I+nXEt7wWMTvtwMfN/E
MbEZ2oc0Q6H/YuRXEG8JYCO8J3On86PuseqtuqM4uu5gP47Yruf+vkb+N0nX
ItV8zWIbKs1LM9m8Us8smlXUc1aVukeoN6hnbUw4RhWb6rnvJJxDyh31iHbo
1h4oyHeN342sPUnXds1AXaL2gWw/ib09ytxD1Tunon8ttCNS7n2amS8qc81S
rSrh/BJ83T1uX/0/R8HtnnJv1ky8NeaZQbOCYmAx+/Gcb4645nWKOiYUC0/B
4z7212i+YH8Z/ijHl3Hgzob2aZz4Kyv3WQfk7eGuJsO/CPvncydZ6FfL+cqm
zslp5EJp2rnxIDwWpSxTsk5GfBdXsU9l+E6O4/967LmZ2Bnd2LPh7ejcq5ln
xEbKd+Cx4Jl1f4lnJs1K3cAfznpfiWdN0dRwl22Rv6zQM3AbzkuBBU1d445y
9kPavUk9YwLyJgIDm3pm+RBZH1V7lluGzW3xTWXSuakeWsY6nnSv00y2C9zd
wLQi99z3WO+v9uzXG/reei9Ue/aQj1WbNRNpFlKN3o2+eyo9m9Vhz5v473p8
2p7zduxvZ11f7reFbNhKvLWBfgGxvBA4i+1/4duoPM/I+9Dt5YR782HkrU+4
Z6pXzuTbC+zPi3o9C9iS8EygWUA8dReqqaqlupOiuGmEqzfGiqRjQHe/ocC9
cXvMvU49Urm5JeZcU45qNpoIzC3wjBSL2gbpLp9P4uwFcmx7pnGWQ9uf+3lD
tQOcifCbkPKspRiuQfar4MzgbAA14xF4LU347aiZbGiFeYhWNaUjvtsRta6d
8XdnzRblfsuo5mkWXgw8X+CZeHLKOarc3BVxL34s5rV68gjWtyX8lg34bAm0
e9H/XKZ56K04P+a3nd6Megs9wf71iN9En8Wd08pl9eAboq7xqu16szwOvyeS
1nVhE/fS3LjX6qk/x10zVCtONfMsezzut4lm2mnQTk96lqmF5u+cPRz3WjOz
ansB+jY/3zW+M7xWVnnWUMwNgfaBqGNXb6BGZb/0pBzX4DrOTsctu5J97xL3
ZPVi5WhJW88cmjW+zfMsqDe23taaCTvhj6K2PlMPSrP+Pf5szT4DnEsT7pHq
jfqm2Hix1LmuGKlH/lTueHSu35x7VQ+g6Z/nnvpXculvlf5vIQZNEbaVAC9i
601N/LbXG1ZvV73x/4x+GaXuHacK3dsyS71WjzsN7s6UbX2H+24Nr62l5hXh
fAD0D1ZalmK2DtwLo659unPFxhulrm2KEb0tLkh6NtUb4y3156RzVTY9jS3D
K/121xtwjWbnpHu7/lPoCe9Wcddi1dCd+P5Ahd+yqkHtOa+tcG6ohn/F+ssK
1zL95zFftQGdzxb6DVBc5Rlcs7d89I8qzwDq/ZrRPwf/IDA4+I17ecL/gei/
j1bU13nsL65wLozM86yrmV2zumbeJWnXNNUyxdy8tN+AevtJB+XyTL79VOic
7qN5qMS+VQ+dxdmuStdG4eius4CPcn3n2ayPES/3ZvlbIu3/ePTfjnpAfZnf
OHrbqEe1Rl6jhP87Es0T4D+V9n8d+s9KvS3Vxrapx6m2nimxbaqxektsi7mX
6U3xPwHP1Mo=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtwVdUVxneSm5u0MJBXSUK4l9xI4N4YCNCh7URgxiKdQaEGZzrCtKED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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllUts1GUUxS+VTltaqYwjBdKZdtqZdgZKrS50QXEh4kpButAYbRMxPhMw
SKs2XRiViMb6YKWRAlUjSI0BE8CIUB/RCBprNNIqJr5qywZrqLQmFB+/k7O4
me/+7/3u49zz3clufKhjc0lEbELmI5PFiNvSEdckI7pSEY+2RCysiziHMbkk
Ync+YgDpTEQ8XB1xLbYZ7lRWRbSWRZzNRAyjf395xEf43FmIuAP5h3M3MS82
RMwhKeKtWhDRg+9WpAv7h9x5lfMnxNiG/jLyAvrzyJF5ERPYH8iSm/r6LiFX
ecR+6ruebyvRD1HfosaIBvIVydXGt7XkuhGpJdZq+hul9iruj1dG7KX+SXId
Jf5v6Mfw+ZdYl9JTosTfzuD7HfFmiPc3coz775BjEbW8xP0NuYgOZDzhHM8R
6zAxezmfLLNtLO9c8llG7N/x+aPSmOyl/nJyHuQ8RP0rydVScC2aQbLRPamX
Kfr9cnnEY/XufRrMe4n1Bvnuwf81ZAB9NzJHfc+i718BzsRfsxickOPUcnet
a9+BtNPfqYJ7m6XnEe4GNbYz+1XIU+hPIlvAf5SYBzmfzjjXLHfWUv+n5NiH
fl8NmIH1r8gE9bYy3xPYv0AeXxrx/sKIJcQeJ8YZYl1Qj+TvLnr2O9A/Rm/k
/mDCnPuLXOeRp4nXTn1T2I8Xza2bSvnF9gr6ee4XqOcn8P4551zXYT9Kv7vy
5uqLyFfg11tvLM9WmsuDyNZqc1pYdSL3LzBmu4hdkjZXhWkerO7KutdW8u0U
32vdqzj8I/Y/065NmEyTrzbtXH1XuNYEPiVJ1zyM/V7q+abcnFyH7x58LmJ7
l/uDRc9Us9S3/iYwWe5YTRVwB26UNXp2ivE69QwxjxsWmxP/NTPPgrEWJ9Po
N1P/6csifkA25ZxTubrA7CSzuhX97WrPTNwczpsr4qjehnaCdoHeiN7GZNpc
0Btpz5pz4ppqmAGbNvyLNX7DOs8SI0r9bQx7kW9La8wx2UbAY1uFfUaxbSf+
EPkPUE9Z1m9Gb0WcEFc+yHu24ox8J8CrM+U7Q+DxRNHc1U5Sb9px2m3qcQAs
k+TrL/fM38L2bca7RzNaT/xbkO285TcpaarFMxD2HcsiPsf/Av5XEa8t5dzP
pL3rVEM356/5tjrlN7GxzjF0VzG1SzbnjL12SmmDOS+ua0dot800+K1rx23B
vxnMr9TbQ+8j/gniX53yTh3AthNZX2YM12S9I7UbtVOF9S/U8Nl8Y97F/Qez
3lXaqbK9Bx63V9gn0+ycyiXONBX8BsR91bBOswTDdJVzniL+WItnNUJPj+Db
U/B/g2JmOdcX/Fa1o+cyxlDYqYc9ee8E7QK9ySPY+4ve/doZh+DW4RXmrmY2
r847S7tKGJ8Dy+mcc/fAn/8B/VoTrA==
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7226, 8773, 8774, 7792, 9296, 9297, 9298, 9687, 9686, 7436, 
         10942, 8294, 10941, 8295, 8968, 8967, 7484, 10453, 7655, 10452, 7654,
          10672, 7898, 10262, 7485, 10617, 7843, 10616, 7842, 11178, 8508, 
         11177, 8507, 8541, 8144, 10908, 8210, 10907, 8209, 11188, 11189, 
         10013, 8525, 10014, 9073, 10279, 10278, 10277, 8545, 11333, 11204, 
         10459, 7663, 10458, 7662, 10685, 7915, 10684, 7916, 10686, 7850, 
         10625, 10627, 10626, 10753, 8829, 7383, 11305, 8160, 8375, 8374, 
         10358, 10357, 10356, 7991, 10741, 7665}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7253, 8783, 8784, 8035, 10776, 8034, 11502, 9868, 10995, 
         10994, 7452, 10957, 8313, 10956, 8314, 8978, 8977, 10274, 10273, 
         10272, 11500, 7872, 10648, 10246, 10664, 7890, 10255, 7482, 10650, 
         7874, 10649, 7873, 8515, 11433, 8514, 8949, 8181, 10955, 8312, 10954,
          8311, 8553, 7517, 9087, 7518, 8554, 8083, 10635, 7861, 10238, 10239,
          10240, 7959, 10722, 7960, 10723, 7862, 10636, 10638, 10637, 7412, 
         8834, 7413, 11312, 8182, 8398, 8397, 10396, 10395, 10394, 8014, 
         10752, 7688}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7646, 9438, 9439, 11464, 11466, 11465, 7510, 10726, 7511, 
         10285, 10284, 7910, 10682, 8701, 8702, 7949, 11383, 7950, 7618, 9098,
          7617, 8739, 9659, 9658, 9629, 9630, 9628, 9632, 9631, 7478, 10612, 
         10613, 10611, 7835, 7358, 11302, 8504, 8930, 8929, 7540, 10703, 7937,
          10702, 7936}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7700, 9457, 9458, 11477, 11479, 11478, 7559, 10725, 7560, 
         10332, 10331, 7962, 10724, 8708, 8709, 7923, 7924, 7519, 9060, 8455, 
         11430, 8456, 9662, 9661, 7267, 11455, 9660, 9133, 9326, 9325, 7502, 
         10655, 10656, 10652, 10654, 10653, 7426, 11314, 8517, 8956, 8955, 
         7547, 10696, 7931, 10695, 7930}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{8690, 11099, 11100, 10413, 10414, 10415, 9019, 10412, 10411, 
         9420, 8416, 8832, 8831, 7359, 8689, 8641, 8769, 8768, 7466, 9765, 
         7467, 9312, 9311, 7841, 10835, 10836, 10132, 10133, 10134, 8798, 
         8799, 8506, 11174, 8505, 11175, 8931, 7554, 9340, 9339, 10448, 10449,
          10450, 10447, 9657, 10671, 7897, 10260, 10261, 8549, 7509, 9083, 
         9084, 8730, 8729, 9654, 7435, 11460, 9653, 9295, 9596, 9595, 10833, 
         10834, 10610, 7834, 10216, 10217, 8335, 11339, 7539, 8988, 7538, 
         10442, 10443, 10439, 10441, 10440}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8741, 9699, 9700, 9698, 9701, 11481, 11483, 11482, 7579, 
         10346, 9446, 9447, 9445, 7664, 10789, 10790, 10082, 11280, 11281, 
         10081, 9640, 11517, 9641, 10533, 10532, 7758, 11511, 9543, 10347, 
         10737, 7977, 11385, 9419, 10402, 7623, 9017, 10405, 10404, 10403, 
         8411, 8718, 7468, 11194, 8531, 10225, 10224, 10223, 8217, 8509, 
         11306, 7384, 10567, 7797, 10566, 7798, 10568, 11212, 8573, 11346, 
         7569, 9057, 11151, 10785, 10786, 10784, 8062, 8885, 7479, 10619, 
         7845, 10618, 7844, 7375, 8801, 7793, 9122, 7794, 8802, 9319, 8562, 
         11341, 7555, 9090, 8561, 8736, 8735, 9685, 9684, 7284, 11456, 9683, 
         9141, 10477, 10479, 10478, 9299, 11368, 10200, 10199, 10560, 10559, 
         9213, 9208, 7752, 9540, 7652, 9479, 7706, 9204, 9478, 9477, 9597, 
         7373, 9207, 9206, 9539, 9538, 9770}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8751, 7306, 10093, 9151, 9390, 9389, 7600, 8833, 7599, 10370,
          9388, 8000, 11035, 11036, 11033, 8384, 11034, 7245, 10064, 10065, 
         10545, 10544, 7774, 9573, 10364, 9741, 7998, 9742, 10007, 10006, 
         8948, 10367, 10366, 10365, 8381, 8857, 8856, 8855, 10237, 10236, 
         10235, 8219, 10918, 10919, 10917, 8243, 10585, 7820, 10584, 7821, 
         10586, 11209, 11342, 11343, 10327, 10328, 7558, 9091, 7557, 8993, 
         8994, 8638, 8728, 7500, 10019, 7501, 11463, 10018, 9649, 7871, 10647,
          7870, 10170, 7411, 10593, 7825, 10592, 7826, 10594, 11215, 8578, 
         11347, 7572, 9059, 8453, 8454, 11268, 7247, 9867, 7251, 11270, 11271,
          11269, 9581, 9580, 7778, 9582, 10208, 10207, 10596, 10595, 9270, 
         9268, 7779, 9583, 8664, 9584, 7780, 9275, 9615, 10177, 7421, 9616, 
         7422, 8696, 8618, 8786, 8785, 8858}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10184, 11372, 11373, 10555, 10556, 10557, 10554, 9753, 9754, 
         9756, 9755, 10183, 10182, 10181, 8196, 10889, 8195, 11044, 11045, 
         11041, 11043, 11042, 8860, 8792, 7473, 9315, 9314, 7875, 10890, 
         10891, 10185, 10186, 10187, 8810, 8811, 8320, 10286, 10287, 10288, 
         8980, 7520, 10289, 9651, 7877, 9650, 7876, 10681, 7906, 10275, 10276,
          8548, 7506, 9076, 9077, 8529, 11318, 7454, 9664, 7455, 11319, 9663, 
         9304, 9618, 9617, 10894, 10895, 10657, 7881, 10249, 10250, 8364, 
         11351, 7585, 8913, 10797, 10473, 10474, 10470, 10472, 10471}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7225, 10765, 10766, 10764, 10768, 10767, 7648, 10451, 7647, 
         11387, 9766, 10355, 10354, 7593, 11487, 11488, 11486, 9534, 9533, 
         9639, 11516, 9638, 10077, 11277, 11276, 10078, 8468, 11161, 8052, 
         8872, 10410, 10409, 8415, 11098, 9944, 9532, 7748, 10524, 7747, 
         11497, 9636, 7839, 9635, 7840, 9637, 10408, 7625, 9018, 7624, 10407, 
         10406, 8414, 11097, 7986, 9192, 9191, 9530, 9190, 9310, 9309, 7464, 
         8964, 7465, 10222, 10221, 8216, 10912, 8502, 11172, 8503, 11173, 
         7790, 9123, 7791, 8797, 9338, 7553, 10039, 8597, 10038, 8598, 10040, 
         8596, 8738, 8737, 9656, 9625, 9626, 9624, 7833, 9627, 7508, 11334, 
         7909, 8713, 8367, 7589, 8998, 7588, 8366, 8820, 8819}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7255, 8835, 8836, 8003, 9399, 9400, 9401, 8791, 7605, 11047, 
         11048, 11046, 11050, 11049, 8387, 11228, 11229, 11226, 8594, 11227, 
         7261, 11454, 9589, 11453, 9590, 9588, 7785, 9591, 9924, 11051, 8388, 
         10381, 10382, 10383, 9005, 7608, 10380, 10379, 11231, 11230, 10037, 
         10780, 8044, 11504, 10069, 7786, 9120, 8697, 8698, 8006, 10893, 8199,
          10892, 8198, 8957, 8197, 11235, 8595, 11232, 11234, 11233, 9006, 
         9080, 7474, 11324, 8535, 9082, 9081, 8200, 11397, 8619, 8201, 10896, 
         8202, 10897, 7828, 10598, 7829, 10599, 11216, 7573, 8579, 11441, 
         8580, 8457, 8458, 11272, 7263, 9666, 7268, 11273, 9665, 9134, 10475, 
         7701, 9342, 7561, 11344, 7963, 8725, 8392, 7610, 9007, 7609, 8391, 
         8822, 8821}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7674, 9702, 9703, 9353, 9704, 10345, 7578, 9705, 9706, 8585, 
         10031, 8584, 11223, 9034, 10428, 10427, 10426, 8423, 11123, 8022, 
         9707, 7976, 9356, 9708, 9709, 7978, 10738, 7979, 10739, 7637, 9038, 
         7636, 10430, 10429, 8607, 11239, 10041, 9711, 11519, 7980, 9710, 
         9713, 11484, 9712, 11485, 7581, 10762, 10763, 10461, 7666, 10460, 
         7667, 10791, 10792, 10085, 11282, 11283, 10083, 10084, 9642, 11374, 
         7731, 10504, 7732, 10694, 7929, 10693, 7928, 7981, 11349, 7582, 7851,
          11321, 7469, 7917, 7668, 11364, 7669, 7893, 10669, 7892, 8301, 7492,
          8296, 11327, 7486, 8969, 7487, 11328, 8297, 8714, 8715, 7951, 9443, 
         7656, 9442, 7657, 9444, 10020, 8550, 7513, 9085, 7512, 8731, 7911, 
         8814, 7437, 8703, 7938, 10311, 10312, 7542, 10748, 7541, 10309, 
         10310, 10705, 10704, 10308, 11005, 8350, 10335, 10336, 8995, 8348, 
         11004, 8349, 11001, 11003, 11002, 8800, 7374, 10148, 10147, 11506, 
         8145, 10846, 8146, 10026, 10027, 8559, 10025, 10024, 9977, 9814, 
         9815, 9210, 9211, 9212, 8876, 10146, 10145, 9209, 8143, 9813, 8648, 
         9812, 8141, 9203, 9205, 8874, 8054, 9811, 8140, 9809, 8139, 9810, 
         8142}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7687, 9498, 9499, 9383, 9497, 9496, 9744, 9745, 9387, 9386, 
         9380, 7999, 9743, 7686, 9495, 7718, 9377, 7717, 9494, 7996, 9739, 
         7997, 9740, 7995, 9738, 7994, 10742, 8750, 10092, 10091, 10490, 9150,
          9374, 9373, 7598, 9000, 10361, 10360, 10359, 8378, 11031, 11032, 
         11029, 8379, 11030, 7244, 10063, 10062, 11496, 7738, 10510, 7739, 
         10699, 7933, 10698, 7932, 8117, 11391, 8116, 10634, 7860, 10232, 
         10233, 10234, 7958, 8720, 8719, 9121, 7859, 8854, 8031, 9064, 8484, 
         8452, 8451, 8309, 11331, 7498, 8976, 7499, 11332, 8310, 8723, 8724, 
         7922, 9680, 9679, 10646, 7869, 11376, 9323, 9324, 8604, 7622, 9075, 
         8527, 8528, 7961, 8824, 7451, 8707, 7945, 11340, 7545, 7968, 7544, 
         10468, 10469, 10467, 7692, 11000, 8347, 10329, 10330, 8951, 8191, 
         11182, 8516, 10173, 10174, 7419, 8809, 7420, 10176, 10175, 11501, 
         7946, 10710, 7947, 11109, 11110, 11106, 11108, 11107, 7546, 11473, 
         9335, 11472, 9336, 9271, 9848, 9272, 9273, 8909, 10003, 8490, 9269, 
         8491, 10004, 7694, 9849, 8192, 9274, 9276, 8911, 8095, 8954, 8194, 
         9068, 8686, 8687, 8492}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7220, 9869, 9870, 9808, 9874, 9873, 8053, 9023, 9024, 8469, 
         8673, 7278, 11114, 9945, 9946, 9875, 9877, 9876, 8055, 9026, 9027, 
         8470, 8674, 7279, 9028, 8828, 11019, 11020, 9895, 8369, 8847, 8846, 
         7594, 11022, 11023, 11021, 8371, 11024, 8370, 11141, 8439, 11139, 
         8438, 11140, 7227, 11246, 8610, 11245, 8611, 9102, 9101, 8147, 8933, 
         8056, 8934, 8149, 9061, 8148, 11143, 11144, 11142, 8440, 9517, 7729, 
         9163, 9536, 11291, 7325, 9537, 7326, 7754, 10529, 7755, 7913, 11380, 
         7912, 7376, 11303, 7753, 7730, 8522, 11316, 7438, 8960, 8961, 8208, 
         10905, 8207, 10906, 7377, 8825, 8574, 11213, 8575, 11214, 8351, 
         11009, 8353, 11007, 8352, 11008, 8354, 10728, 7966, 10727, 10730, 
         10729, 7760, 10534, 7759, 10535, 7329, 10962, 10963, 10961, 10965, 
         10964, 8323, 11163, 11164, 11162, 8473, 7289, 8651, 8650, 9105, 8066,
          8849, 8848, 7525, 11337, 8324, 9859, 9169, 7734, 9521, 8023, 9520, 
         7733, 9167, 9168, 7331, 9682, 7330, 11292, 9681, 9166, 9519, 11512, 
         9518, 9773, 9967, 7638, 11492, 9966, 9430, 8425, 9040, 9039, 8891, 
         7580, 9360, 9359, 9429, 9428, 7635, 9962, 9963, 9960, 8424, 9961, 
         8889, 9358, 9357, 9883, 11017, 11016, 11014, 9427, 11015, 10030, 
         11222, 8583, 9955, 9956, 9957, 9035, 8422, 9031, 8887, 9355, 9354, 
         9352, 8361, 9879, 8652}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7260, 9012, 9013, 8493, 9015, 9014, 8096, 9937, 9938, 9934, 
         9936, 9935, 7259, 11056, 11057, 9927, 9931, 9930, 8094, 9008, 9009, 
         8614, 11250, 11251, 11247, 11249, 11248, 7258, 9976, 7252, 9132, 
         9131, 7693, 10760, 10761, 10759, 8015, 7602, 11490, 11491, 11489, 
         9579, 9578, 9866, 9865, 10993, 7310, 8685, 9067, 9066, 8343, 8991, 
         8093, 9847, 8190, 10884, 8189, 10882, 10883, 10888, 10887, 10180, 
         9504, 7719, 9501, 9503, 9502, 9585, 7334, 10548, 7781, 10547, 7782, 
         8342, 11422, 8341, 8038, 11388, 8039, 7741, 9775, 8033, 10775, 8032, 
         9844, 8188, 9843, 9846, 9845, 8180, 9116, 8179, 10879, 10878, 8636, 
         8693, 7410, 11134, 8432, 10169, 10168, 10543, 7773, 10416, 7628, 
         10751, 8013, 10749, 8012, 10750, 7449, 10719, 7957, 10718, 10721, 
         10720, 7819, 10582, 7818, 10583, 10972, 10971, 10967, 10968, 10966, 
         10970, 10969, 8030, 10773, 10774, 10060, 10061, 7243, 10977, 10978, 
         10974, 8327, 10973, 8328, 8984, 8983, 10301, 10300, 10299, 10976, 
         10975, 7715, 9492, 7716, 9493, 7408, 10167, 11495, 7737, 10509, 
         10107, 10108, 7332, 10697, 10486, 10487, 10485, 10489, 10488, 7684, 
         8999, 7685, 8749, 9370, 7596, 8894, 7597, 9372, 9371, 9897, 9896, 
         8659, 9898, 9899, 9375, 10362, 10363, 8896, 9379, 9378, 9376, 8380, 
         9900, 8660, 9901, 8382, 9381, 10368, 10369, 8898, 9385, 9384, 9382, 
         8383, 9902, 8661}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7651, 9974, 8429, 9436, 10438, 7643, 9053, 11224, 11225, 
         10034, 10036, 10035, 7990, 9735, 9734, 9368, 7989, 9733, 8019, 11129,
          11130, 10436, 10437, 7642, 9048, 10033, 9731, 9732, 9366, 10352, 
         9730, 7988, 9531, 7987, 11520, 9729, 10042, 11243, 11244, 10431, 
         10432, 7640, 9043, 10435, 10434, 10433, 8426, 11127, 9971, 9726, 
         7985, 9723, 9725, 9724, 7223, 10502, 10503, 9515, 9516, 11467, 11469,
          11468, 7537, 10022, 10023, 8734, 8733, 9119, 8368, 8589, 8588, 
         10701, 7277, 10700, 11367, 11366, 7705, 11494, 10141, 10142, 10140, 
         7749, 10528, 9189, 9528, 10523, 9529, 9194, 9193, 7363, 8932, 7364, 
         10139, 10138, 10840, 10839, 10103, 10102, 10501, 10500, 10769, 8840, 
         7357, 10131, 10130, 8137, 9188, 7356, 8928, 7355, 10129, 10128, 
         11171, 11170, 8646}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8666, 9752, 8002, 9392, 9397, 9398, 8004, 9505, 7720, 9395, 
         7721, 9506, 7695, 9757, 8005, 9402, 9406, 10376, 11354, 10377, 10746,
          10745, 10378, 8760, 7722, 9923, 9153, 9154, 8754, 10740, 7982, 9716,
          7983, 9717, 10384, 8761, 7723, 9109, 9110, 8688, 7311, 8839, 8762, 
         8763, 8615, 8765, 8764, 7548, 8859, 8040, 10778, 8041, 8390, 11427, 
         8389, 7262, 10551, 10552, 10550, 7783, 10553, 7453, 10209, 7827, 
         10597, 9281, 9280, 9587, 9586, 9979, 8861, 7427, 10189, 10188, 10899,
          10898, 10117, 10518, 10519, 10211, 10210, 7456, 8963, 7457, 10213, 
         10212, 8214, 9285, 7428, 8914, 8101, 10798, 10800, 10799, 8671}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7233, 11012, 11013, 9878, 9881, 9880, 8068, 9032, 9033, 8474,
          8678, 7292, 11122, 9958, 9959, 9882, 9885, 9884, 8069, 9036, 9037, 
         8475, 8679, 7293, 11124, 9964, 9965, 9886, 9888, 9887, 8070, 9041, 
         9042, 8476, 8680, 7294, 11125, 10807, 10808, 10806, 10810, 10809, 
         8071, 8941, 8942, 8632, 8681, 7295, 10865, 10812, 10813, 10811, 
         10815, 10814, 8072, 8943, 8944, 8633, 8682, 7296, 8165, 10866, 10867,
          10505, 10507, 10506, 7393, 8237, 8238, 8073, 8477, 11284, 7297, 
         8776, 8537, 11435, 8538, 8267, 8269, 11410, 8268, 7395, 7887, 7888, 
         7675, 9129, 9130, 7234, 10934, 10935, 10933, 10937, 10936, 8276, 
         8278, 11413, 8277, 7407, 8241, 11403, 8242, 8080, 8483, 7305, 7238, 
         10820, 10821, 10819, 10823, 10822, 8081, 8082, 7307, 7242, 8399, 
         11428, 8400, 8085, 10793, 10794, 10094, 10095, 7308, 7246, 10512, 
         10513, 10511, 10515, 10514, 7424, 8246, 11404, 8247, 8091, 8092, 
         7309, 7250, 7894, 11379, 7895, 7697, 9283, 9456, 9455, 10939, 8281, 
         10938, 8282, 10940, 8125, 8500, 11297, 7343, 8789, 7344, 11298, 8127,
          8126, 8284, 11415, 8283, 8756, 8285, 11416, 8286, 8128, 8501, 11299,
          7345, 8790, 7346, 11300, 8130, 8129, 8288, 11417, 8287, 10779, 
         10516, 10517, 10114, 10115, 7347, 10549, 7348, 9177, 9176, 9524, 
         9523, 9978, 9797, 9798, 9178, 10116, 7349, 8908, 7350, 9180, 9179, 
         9800, 9799, 8668, 9746, 9747, 9391, 9750, 11353, 7601, 9751, 10373, 
         10372, 10371, 8386, 11038, 8385, 11133, 8431, 11131, 8430, 11132, 
         9975, 9925, 11523, 9926, 9408, 10386, 7611, 8910, 7612, 9411, 9409, 
         9929, 9928, 8669, 9939, 9940, 9413, 10393, 7614, 8912, 7615, 9416, 
         9414, 9942, 9941, 8670}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7269, 7316, 8495, 8494, 10011, 10012, 10008, 10010, 10009, 
         7264, 7315, 10100, 10099, 10191, 10190, 7429, 8292, 8293, 8289, 8291,
          11418, 8290, 7257, 7312, 8098, 8097, 10924, 10925, 10921, 10923, 
         10922, 7425, 9284, 9282, 7784, 8124, 11296, 7342, 8788, 7341, 11295, 
         8499, 8123, 8280, 11414, 8279, 8755, 8331, 11421, 8332, 8121, 8122, 
         11294, 7340, 8818, 7339, 11293, 8498, 8120, 8330, 11420, 8329, 10979,
          10826, 10827, 10112, 10113, 7338, 8907, 7337, 10111, 10110, 10825, 
         10824, 11152, 9795, 9796, 9174, 9175, 7336, 8905, 7335, 10109, 9173, 
         9794, 11524, 9793, 9968, 11241, 8608, 11240, 8609, 11242, 8362, 
         11018, 8363, 10348, 10349, 10350, 9722, 7583, 11350, 9721, 9361, 
         9715, 9714, 8667, 9921, 9922, 9404, 9405, 7607, 8904, 7606, 10375, 
         9403, 9920, 9919, 8665, 9910, 9911, 9394, 9396, 7604, 8902, 7603, 
         10374, 9393, 9908, 9907, 7696}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8647, 9871, 9872, 9343, 9345, 10339, 7574, 8873, 9021, 9022, 
         8420, 9094, 8582, 10044, 8581, 10029, 7629, 11359, 9421, 11358, 9422,
          9347, 9349, 10342, 7576, 8875, 9948, 9949, 9947, 9951, 9950, 7631, 
         9423, 9424, 9350, 9351, 7577, 9736, 9463, 9464, 9462, 9466, 9465, 
         7634, 9425, 9426, 9157, 9158, 7317, 8877, 9804, 9805, 9803, 9807, 
         9806, 7365, 9195, 9196, 9159, 9160, 7318, 9535, 9468, 9469, 9467, 
         9471, 11458, 9470, 11459, 7366, 8249, 11405, 8250, 8104, 8105, 11287,
          7319, 8770, 8224, 11399, 8225, 8223, 8227, 11400, 8226, 7367, 8255, 
         11407, 8256, 8106, 8107, 11288, 7320, 8771, 7883, 11377, 7884, 7751, 
         9198, 9200, 7369, 8254, 10927, 10929, 10928, 8251, 8253, 11406, 8252,
          7219, 7276, 8051, 8050, 8222, 11398, 8221, 7362, 10804, 10805, 
         10801, 10803, 10802, 7218, 7275, 11447, 11446, 11515, 11514, 9139, 
         9461, 9460, 9769}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV00lQz3EYx/HvP2YwzHBhxi5SCcPJRfYsOdhN2qiMNhRGlIuxJLIVGZMs
mdFyqH/IhSxXshwcJG4NLhiTe/L6H97z+T/P83me7/P9/uYfX1C+rSwSQhhC
yuwQzk8LoTQphJ45IUyg43F1Zgj7EkMoxF4cSgmhHPP4a/hLeJ7xj6NjcYU/
n68Au1HGexDJ/Of4i3me8o+mo3CZP4cvF9k4wLsfifzV/JMWhFDEd3d+CHdw
ib9EvRSFKEYRjuMs/894++Cv/kFc5F+lthorcQwV+CF/hv9obI75UXTiu9y2
WSE0OHc73Yoc8zrE2TTdzNM8E8UzxLXmLOZZhG/ym+l1tS10E17a+RV68ALP
kTE3hF1o9w4ZM0L4gCN63tMBM9L11Ys30g2IOKdFHOhK9RPo8juKIB/BkLnD
+IczdlruLQfl4xaqY6l4GVKxQn8l8tx3DxK8wRyc1NeHU/o+0VSeCky110e6
zi7rsQZrUceXRpeoHUKVnnW8v93rD17LdZu7iudx7BvQJ7SDrxOT9TfypHnT
uWoXxIk0AcmoFSfRXp5q2iQ+R6N6uzBFfCt2tv4W+WZxK32AdtwXt9G3PPfc
sxmVqEKTXFRfln2ykYlc5OCd2qD9/+INenFb7iH/P+83jCFEzAkYmC7newa5
awm+P1rlxsQ88nGxGkZiBPrU+ng+owE30Cb3yPwdztqJn/auoVd942Wx/xVd
TPv58t2rX08e/UJvohGHk91bvducTL1Z+BV7V1qvv5HW0fP0K/9/s9uffw==

         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7645, 10831, 10832, 10122, 10123, 7352, 8867, 8868, 8869, 
         8136, 10126, 10127, 7354, 8927, 7353, 10124, 10125, 10499, 10498, 
         10101, 10837, 10838, 10136, 10137, 7361, 11176, 7360, 11258, 11259, 
         11257, 8635, 9112, 9111, 8138, 10048, 8643, 9781, 9782, 10049, 10050,
          10055, 10054, 8916, 8917, 8644, 10051, 10053, 10052, 8631, 10046, 
         8630, 11256, 8981, 10076, 10075, 9140, 11138, 11137, 8049, 10781, 
         8048, 10782, 8841, 7523, 9513, 9514, 9510, 9512, 11448, 9511, 11449, 
         7221, 11238, 8605, 11237, 8606, 9030, 9029, 10425, 10424, 10423, 
         8421, 11121, 9954, 9697, 7974, 9695, 7973, 11518, 9696, 9952, 11117, 
         11118, 10419, 10420, 7632, 8871, 7633, 10422, 10421, 11120, 11119, 
         9953, 10735, 10736, 10344, 11348, 10343, 9694, 9348, 7972, 9693, 
         8018, 11115, 11116, 10417, 10418, 7630, 9025, 11218, 11219, 11217, 
         11221, 11220, 7971, 9692, 9691, 9344, 7969, 9688, 7649}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7679, 9998, 8482, 9240, 8481, 9997, 8897, 9243, 9242, 9237, 
         8164, 9828, 7678, 9994, 8480, 9231, 8479, 9993, 8895, 9236, 9235, 
         9234, 9824, 9823, 7677, 9989, 9990, 9986, 9988, 9987, 8893, 7391, 
         9229, 8743, 7676, 8962, 8653, 9545, 9546, 9227, 9228, 7390, 9600, 
         7389, 11308, 9599, 9226, 7761, 9544, 8024, 9522, 7735, 9170, 9171, 
         10852, 10853, 10154, 10155, 10156, 8511, 10005, 8512, 11181, 8339, 
         10990, 8338, 11207, 8560, 10983, 10984, 10982, 10986, 10985, 8336, 
         10988, 10989, 10987, 8337, 7387, 10570, 7799, 10569, 7800, 10714, 
         10715, 10712, 7953, 10713, 7442, 11112, 8418, 11111, 8419, 11113, 
         8161, 8510, 11307, 7386, 9225, 7385, 9223, 9224, 9441, 9440, 9142, 
         9143, 9541, 7756, 11304, 7379, 8344, 11423, 8345, 8153, 10847, 8152, 
         10848, 7327, 8879, 7328, 9165, 9164, 8112, 9784, 8441, 11145, 11147, 
         11146, 8113, 9785, 8114, 9786, 8058, 8918, 8115, 9103, 9104, 8621, 
         11254, 8620, 11255, 7229, 11149, 8442, 11148, 8443, 11150, 8372, 
         11028, 8373, 11025, 11027, 11026, 7595, 8844, 8845, 8437, 9126, 
         10056, 7224, 7281, 11126, 9969, 9970, 9889, 9891, 9890, 8059, 9046, 
         9047, 8471, 8675, 7282, 11128, 9972, 9973, 9892, 9894, 9893, 8060, 
         9051, 9052, 8472, 8676, 7283, 9062}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7681, 9831, 8167, 9245, 10159, 10160, 8888, 9249, 9248, 9246,
          8168, 9832, 8656, 9833, 8170, 9252, 10161, 10162, 8890, 9255, 9254, 
         9253, 9835, 9834, 8658, 9838, 9839, 9258, 10163, 7401, 8892, 7402, 
         9259, 8748, 7683, 8850, 7682, 10541, 10542, 10164, 10165, 7404, 
         10574, 9489, 9490, 9488, 7714, 9491, 7405, 10166, 11371, 7736, 10508,
          10106, 8211, 11317, 7448, 8852, 8853, 8028, 10057, 10058, 10059, 
         10992, 10991, 7241, 8662, 8613, 8990, 8989, 8029, 10875, 10876, 
         10872, 10874, 10873, 7406, 10581, 7816, 10580, 7817, 10733, 10734, 
         10731, 7967, 10732, 8752, 11076, 8401, 11075, 8402, 11077, 8178, 
         8513, 11311, 7409, 9764, 9500, 9453, 11510, 9454, 9451, 7689, 9452, 
         7740, 9776, 8037, 10777, 8036, 11503, 9854, 8318, 9853, 8319, 10960, 
         8317, 10958, 8316, 10959, 8953, 8906, 7333, 9172, 9792, 9791, 8119, 
         11392, 9279, 10179, 10178, 10886, 10885, 8684, 9065, 8193, 8952, 
         8090, 8921, 8118, 9107, 9108, 8920, 8919, 8982, 10097, 10096, 9152, 
         8489, 10002, 8089, 11096, 8413, 11095, 8412, 7584, 10755, 10756, 
         10754, 10758, 10757, 7984, 9718, 9720, 9719, 8830, 7256, 9001, 9002, 
         8488, 9004, 9003, 8088, 9917, 9918, 9914, 9916, 9915, 7254, 11039, 
         11040, 9909, 9913, 9912, 8087, 9905, 9906, 9840, 9904, 9903, 8753}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7699, 9509, 7727, 9415, 7726, 9508, 8011, 9418, 9417, 9412, 
         8010, 9761, 7698, 9507, 7725, 9410, 7724, 9759, 11355, 9760, 9758, 
         10387, 8838, 8009, 9010, 8008, 8837, 8016, 9768, 9767, 10492, 10494, 
         10493, 10491, 9407, 10385, 9749, 8001, 9748, 10744, 10743, 8757, 
         7313, 10098, 9155, 9334, 11513, 9333, 7529, 8985, 9332, 9331, 9860, 
         8333, 8460, 11431, 8459, 7265, 8624, 11444, 8625, 9115, 9114, 8132, 
         8923, 8131, 8922, 10118, 9181, 9802, 9801, 9980, 8862, 7430, 10193, 
         10192, 10901, 10900, 7728, 10495, 10497, 10496, 11153, 8863, 7458, 
         11320, 8530, 9286, 7431, 9069, 7432, 10195, 10194, 11184, 11183, 
         7702}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7217, 8645, 8558, 7534, 8987, 7535, 8334, 8712, 7935, 7536, 
         8628, 10608, 10609, 8629, 8465, 8467, 11432, 8466, 7274, 7216, 11266,
          8436, 8435, 8571, 11440, 8570, 7567, 11210, 10522, 7746, 10521, 
         7745, 11169, 8497, 11168, 8496, 10911, 8215, 10219, 10220, 7463, 
         11193, 7462, 11092, 11093, 11091, 8410, 11094, 8408, 9016, 10401, 
         10400, 8409, 11090, 7975, 9187, 9186, 9185, 7744, 10615, 7838, 10614,
          7837, 11159, 11160, 11156, 11158, 11157, 8870, 10399, 10398, 10397, 
         8407, 11089, 9943, 9527, 7743, 10520, 9526, 9634, 9633, 10073, 11275,
          11274, 10074, 11155, 11154, 8047, 11087, 11088, 11086, 8406, 7575, 
         8766, 10341, 10340, 9346, 7970, 8827, 8826, 8740}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7248, 10066, 11507, 8183, 10880, 8184, 9841, 8086, 8901, 
         8486, 9262, 8487, 10001, 7690, 9842, 8185, 9264, 9266, 9267, 8903, 
         9862, 8340, 9861, 9864, 11470, 9863, 11471, 7543, 11102, 11103, 
         11101, 11105, 11104, 7627, 9020, 7626, 11357, 8417, 8694, 7416, 
         11037, 7417, 10172, 10171, 8187, 10881, 8186, 8950, 10338, 10337, 
         8355, 11010, 7691, 10464, 10466, 10465, 7527, 7943, 7528, 11338, 
         7934, 8695, 7418, 8815, 7921, 8576, 7570, 9093, 7571, 8577, 8084, 
         10645, 7868, 10243, 10244, 10245, 7944, 8722, 8721, 10953, 8308, 
         10270, 10271, 7497, 11203, 7496, 8727, 8637, 9118, 8315, 8979, 7505, 
         8547, 7903, 10679, 7904, 7857, 11322, 7471, 7920, 7472, 11323, 7858, 
         8173, 11395, 8174, 7812, 10575, 7813, 10576, 7772, 9571, 7771, 9572, 
         9850, 11452, 7240, 10950, 8305, 10949, 10952, 10951, 8027, 10772, 
         8026, 8851, 7447, 8779, 8780, 8612, 9106, 7770, 8778, 8747, 9149, 
         9148, 10043, 7713, 9610, 7810, 9609, 7809, 9257, 9256, 9251, 7768, 
         9566, 7680, 9487, 7712, 9247, 7711, 9486, 9608, 9607, 7398, 9250, 
         9244, 9563, 9562, 8657}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7271, 8672, 8103, 11390, 8102, 8915, 7586, 11352, 8365, 8726,
          10689, 7925, 10290, 10291, 9330, 7703, 9459, 9135, 9136, 7270, 9667,
          8565, 11438, 8566, 8564, 8568, 11439, 8567, 7562, 11480, 10028, 
         9619, 7831, 10601, 7830, 10600, 11509, 8248, 10926, 10257, 10256, 
         11508, 8220, 10913, 10914, 10247, 7475, 8864, 8865, 11053, 11054, 
         11052, 8393, 11055, 8203, 8958, 8518, 11185, 8519, 11186, 8007, 9289,
          9288, 9287, 7787, 9780, 8045, 9779, 9932, 11058, 11059, 10388, 
         10389, 7613, 9011, 10392, 10391, 10390, 8394, 11060, 9933, 9593, 
         7788, 10558, 9592, 10071, 10070, 7266, 11062, 8396, 11061, 11064, 
         11063, 8395, 11068, 11069, 11065, 11067, 11066, 7616, 8794, 9778, 
         8042, 9777, 8043, 9156, 7314, 8758}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8655, 9555, 9556, 9239, 9241, 7392, 9605, 9606, 9604, 9603, 
         9238, 7766, 9553, 8654, 9552, 7765, 9230, 9232, 9233, 7806, 9601, 
         7807, 9602, 7764, 9550, 7763, 9551, 7235, 10536, 7762, 9547, 9549, 
         11461, 9548, 11462, 7443, 10015, 10016, 8706, 8705, 9117, 8302, 
         11201, 11202, 11200, 8542, 9645, 9646, 9644, 9643, 9144, 7710, 10572,
          7804, 10571, 7803, 8163, 11394, 8162, 10628, 7852, 10226, 10227, 
         10228, 7954, 10463, 7670, 10462, 7671, 10675, 7901, 10674, 7900, 
         8447, 8446, 8065, 11389, 8064, 8886, 7480, 11325, 8233, 8716, 8717, 
         7914, 10683, 7658, 10454, 7659, 10455, 11208, 8563, 7556, 9072, 8523,
          8524, 7952, 8823, 7439, 8704, 7927, 10296, 10297, 7524, 11006, 
         10783, 10691, 10692, 10294, 10295, 10998, 8346, 10325, 10326, 8935, 
         8154, 10849, 8155, 10149, 10150, 7380, 8803, 9857, 9858, 9856, 8321, 
         9855, 8322, 8843, 8842, 9055, 8936, 8937, 8642, 10047, 9214, 9215, 
         8882, 9219, 9218, 9216, 8156, 9816, 8649, 9817, 8157, 9221, 10151, 
         8884, 8061, 8939, 8159, 9063, 8158, 8938, 9127}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7236, 10537, 10538, 9554, 9558, 9557, 7445, 8775, 7444, 9301,
          9300, 7808, 10677, 10678, 10676, 7902, 9648, 7291, 11457, 9647, 
         10481, 10480, 10484, 10483, 10482, 11370, 11369, 10203, 10573, 7805, 
         11498, 9818, 10851, 10850, 8940, 10266, 10265, 10264, 8303, 9313, 
         7470, 8965, 10231, 10230, 10229, 8218, 11179, 11180, 10152, 10153, 
         8805, 7801, 9124, 7802, 8806, 9341, 8599, 11356, 7620, 9099, 7619, 
         8298, 11329, 7488, 8970, 7489, 10622, 7847, 10620, 7846, 10621, 7381,
          10562, 7795, 10561, 7796, 10563, 11211, 8572, 11345, 7568, 9056, 
         8444, 8445, 11267, 7230, 7286, 8817, 11278, 11279, 11252, 8617, 
         11253, 8616, 8640, 10531, 10530, 8639, 11260, 10202, 10201, 10565, 
         10564, 7708, 9217, 7709, 9480, 7653, 9542, 7757, 9220, 9222, 7382, 
         9598, 9482, 9483, 9481, 9485, 9484, 7440}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7237, 10539, 10540, 9561, 9565, 9564, 7446, 8759, 10770, 
         10771, 9774, 8025, 10947, 10948, 10945, 8304, 10946, 7239, 11451, 
         9568, 11450, 9569, 9567, 7769, 9570, 10204, 9302, 7811, 9611, 9837, 
         9836, 8947, 10268, 10267, 9320, 8543, 8974, 8973, 9078, 8532, 8534, 
         11434, 8533, 9079, 8171, 8172, 11310, 7403, 10578, 7814, 10577, 7815,
          10579, 11206, 8552, 11336, 7516, 9058, 8450, 8307, 11330, 7494, 
         8975, 7495, 10644, 7867, 10642, 7866, 10643, 7889, 10590, 7823, 
         10589, 7824, 10591, 11236, 8603, 7621, 9100, 8600, 8602, 11443, 8601,
          10999, 7249, 10067, 10068, 9576, 10546, 7777, 9577, 10206, 10205, 
         10588, 10587, 9614, 9265, 7776, 9575, 8663, 9574, 7775, 9261, 9263, 
         7415, 9613, 7414, 11313, 9612, 9260, 9278, 9277, 7423}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7526, 11381, 10298, 10320, 10319, 7549, 8992, 7550, 10322, 
         10321, 10997, 10996, 10252, 10251, 7882, 10658, 10903, 10902, 9620, 
         9621, 9305, 9306, 7459, 9668, 8555, 11437, 8556, 9089, 9088, 7521, 
         8557, 8099, 10795, 8100, 10796, 7878, 10651, 7879, 9652, 10333, 7563,
          8959, 8204, 10904, 8205, 8813, 8812, 10666, 7891, 10665, 10668, 
         10667, 7880, 9316, 10248, 7476, 8793, 8866, 11071, 11072, 11070, 
         11074, 11073, 8206, 11187, 8520, 10196, 10197, 10198, 9762, 9763, 
         9292, 9291, 9290, 7789, 9594, 8046}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7531, 11382, 10303, 10305, 10304, 7532, 8986, 7533, 10307, 
         10306, 10981, 10980, 10215, 10607, 7832, 11499, 10253, 10254, 7477, 
         9317, 9318, 9293, 9294, 7434, 9655, 7433, 11315, 8521, 9071, 9070, 
         7504, 8544, 10259, 10258, 7896, 10670, 9125, 9437, 10446, 10445, 
         10444, 9329, 10283, 7507, 8926, 8134, 10830, 8135, 8796, 8795, 10121,
          10120, 10119, 10829, 10828, 7836, 9308, 10218, 7461, 8767, 7460, 
         11082, 11083, 11081, 11085, 11084, 8403, 11080, 8405, 11078, 8404, 
         11079, 9689, 9690, 9184, 9183, 9182, 7742, 9525, 8017}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{8691, 10708, 7941, 10313, 10314, 10315, 7992, 11386, 7993, 
         7940, 10706, 7939, 10707, 8807, 7388, 10630, 10631, 10629, 7853, 
         10717, 7956, 10716, 7955, 9449, 7672, 9448, 7673, 9450, 10021, 8551, 
         11335, 7515, 9086, 7514, 8732, 8235, 10915, 8236, 10916, 8234, 8966, 
         7481, 11326, 8536, 7848, 10623, 7849, 10624, 7490, 10263, 7899, 
         10673, 7660, 10456, 7661, 10457, 7491, 8971, 8972, 8300, 10943, 8299,
          10944, 7441, 9851, 9852, 9772, 8020, 9771, 8021, 8677, 7287, 8804}],
        
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8692, 10709, 7942, 10316, 10317, 10318, 8376, 11426, 8377, 
         8169, 11309, 7399, 8808, 7400, 7855, 10633, 7856, 10688, 7919, 10687,
          7918, 9674, 9673, 10632, 7854, 11375, 9321, 9322, 11205, 8546, 
         10280, 10281, 10282, 9074, 11190, 8526, 10017, 11192, 11191, 8212, 
         10909, 8213, 10910, 8175, 8306, 8176, 11396, 8177, 10877, 7864, 
         10640, 7865, 10641, 7493, 10269, 7905, 10680, 10242, 10241, 7863, 
         10639, 8485, 11167, 8899, 8900, 8245, 10920, 8244, 7450, 9677, 9678, 
         9676, 9675, 9303, 7822, 8782, 8781, 8787}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10072, 10476, 7704, 11365, 10351, 7587, 8996, 8997, 8587, 
         11442, 8586, 10660, 10661, 10659, 10663, 10662, 7503, 9327, 9328, 
         9137, 9138, 7272, 9669, 9670, 8569, 7564, 9092, 7565, 7965, 11384, 
         7964, 8711, 8710, 10690, 7926, 10292, 10293, 7522, 11011, 9783, 9622,
          9623, 9307, 10214}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10135, 10525, 10527, 10526, 9337, 11474, 11476, 11475, 7551, 
         10747, 7552, 10324, 10323, 7948, 10711, 8699, 8700, 7907, 9671, 7908,
          9672, 10334, 7566, 9054, 11136, 8433, 11135, 8434, 8464, 7273, 8462,
          8463, 8461, 8627, 11445, 8626, 7483, 10605, 10606, 10602, 10604, 
         10603, 7351, 11301, 8133, 8925, 8924, 7530, 10302, 11363, 7644, 
         11493, 11362}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameLabel->{
    FormBox["\[Rho]", TraditionalForm], 
    FormBox["\[Theta]", TraditionalForm]},
  PlotRange->{{-5, 5}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->438611511]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->208618586],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFnYebVNd5/0/unZldUC9Rs2zJji07thyXxCVW3BLLsboANdQsJFElEL3D
wi5sr+wuvQqEQBKIjuhLW/qyvddpOLH9J/j5/d5yzrnnlpkFx3ni5zLsIgzM
/cz3Leee836fGTV93OiJo6aPf2fUw/85ddTkcePfmfbwbz+YCr9k/50QYh/+
uE/A1/8PvqIf+/7yl78IMQZfbfj+L/Q/8RT96ljPrz6pfxV/0flOhJzfI8QT
zq+H9a/zfxK/o5/H+f4//Ovj4dXSf8K+v+nrv3jey73wgv+Ee+Tfeb/8/gHP
77s98P99n/E9vq+/972j+z2/I/jPfVT+rZb8+U75c8jzu+/2/fneP0+9nzvo
P//Q87c/6Pndd/n+vC95fsc9nj/hTvr5n+XduvE/7175/3T/Off7/n/+O3lf
4L11/qwgNvhf1d/4gPzZ+y+6Pe3nxXz9Krwug//j3+nvzD/nFs/39/8Pv78V
Xv4u5d9W6v+vZfq/PnNX4bP3FD93X+mwL5UP//KyFx6uevFry1/6xspXvrl6
5LfXvfbo+te/t/HNH3z4+3/ZMurHH7/9r9vfeezT0b/YMeZXn4/7j93jH9/7
3u/2v//kwYnPHPrguSOThx+b+sKJaS+fnDHy9MzXz85689ycty7MfefS/NFX
Foy7mjWhYdHEpsUftORMbVsyvSN3VlfenJ6C+X2FCweKFsdKcuKlS+NleYny
/ERFYWJZcbKyNFlVlqyuSC6vTK6sSq5anly9MrlmVXLtmuS6dcn1G5IbNiY3
fpjctCX54UfJzR8nt2xPfvRJcutnyY93Jrd9nty+O/nJ3uSn+5KfHUju+CL5
+aHkriPJ3ceSe04k99Yk951K7j+TPHA2efBc8osLyUMXk4cvJ4/UJY9eTR5r
SB5vTJ5oTta0JE+2Jk+1Jk+3Jc60Jc62xWvb4+faY+fbYxfaYxc7opc6opc7
Bq50DtR19l+Fq6u/vquvoauvsbu3qbu3ubu3paentaenrae7vae7o7ers7er
q7eru6+zp6+zt6+jrx+u9v7+9oGB9uhAW2ygLR5tTURbk9HWa7GWP8Ra/ivW
/N+x5j/Gm0jrKQk+dUe+hHh/2fAHK0Y8VPnCw9Uv/sOKl7+xauQ/rn31O+tf
++6G17+36c0fbn7rR1tH/XQbQHz33xDi2H/fNf43eyb8liA+dXDSs4cnDzs6
ZcSxqS+emP7KyZmvnZn1Ru3s35+f8/bFee9eXjC2buGE+qz3GxdPas6e0rpk
evvSmZ15s7vz5/UWLOgvWhQtBoJL4mW58UCCK6qSK5cnV/0VBPcjwZ1A8LAi
ePwGCCK+VsbnJtgRlQQ7HYISX1cf42vudvC19yJBwNfV1ykJIr6OYHxRF74/
BROcoAk+eVsuQry76Ll7S1iGIx6qAogvfR1kuAZkyBDfQBl+NOonH7/9023v
/OyT0T//bOyvWYZ7JvznPpDhJJDh8yjDKS8cRxm+ijKcTTKcBzIEguPrs95D
GWZPblkyDQnmzu7Km9sjCWbHSpbESk2CJYrgMkVwxV9DcEcagrWK4CVFsD55
vCF5ojFZ05w86SIYr20DfHEWoAX8xL2XlADrAgXYbQqw2xRgT19Hr8InLAAo
hgJC5peMtmgFMr8/x5sCCE5zCN6KBJ8mGT7/QNmwByuGf0XJ8JHVKEOIpUDw
+5t+/89bUIY/+fidn6EMx/xqJ8hw3G+Q4HtPHJj49BcfPMcyPD7tpRoVSGvn
vHUeA+kYI5BObsmZ1rZ0BgXSuRhIi7KIYE6MA2lFQWJZURDBG9fgZ5rgoeTn
R5K7/ATPS4JHriSP1iWPMcEmg2BbAMFUIRQEKCwAKB5wxdBeFUOlAjs4hroU
qAiyAv9gKDCYoBNFnzAIGtlQBtJXvrVGEuRAyjIkgqN/uQNliIFUElSBFAlO
f+UUB1IieHH+6MtAcKGZCg2ChVkDxYujmmC5JliarC53E1ydXLv2ryG4kwke
Te72ETx0IXmYCV4dlGDKJFjf1W+GUBBgOoBpQmjMG0L/HG8MiqIlRhTNe+rO
Aoiiz95b8vz9qMERoMGvVr+EGlw1Egh+Z93r/7Txje9/KDVIUfTdn3/GGlRR
1NHgVIiiL1Ex8xoVM6MuOBpUURQIsgbzMYqSBo1ixqVBg+BqD8FN10twR1qC
jgaR4DVMgk2DRNHrKGPSEOx0JNgfLEFFsFlYfxpEgZQCQX4Ib/iDywLrmDf8
dcwvXXXMRF3HDOc65pSuY+ZeZx2DWRDqGK5Ek4F1zF/Bj+uYlPz8dQwosPGa
5nfyxuqY/vR1TDDCoDrm2uB1zCRN0ImeWIZiIwH4sJdA7a1H7QE+LmJYe4CP
ixiOnthLHIAiZvLzGD0BH8tPlqFKfgvHS/lxAEX5URGTT72Ekl+CA2gFyK/Y
CKDQS1SrXoIJrr9ugvtSEzytCJ5XBFmEDdeON10L7iWMMMoQQYQWIBRD0pQy
wgKMIqNd1TJmNSosgChCjhKjrRZwFOFkdNBuYrRm+Ny9pc8/UM76w07w6ytd
wfMHH5L+PqICBoMn9hFUhVL62y+r0OeOsP6gCp2O8fPMbBU/541GCapmUEqQ
mkEtwYHibGglElKCBcmAEFqNhWhKhlsHY3jQxXBPTXLvyeS+08n9Z12B9LAT
SIHhNWSoAqmwgKLITNUTao71Xd6mgoMpc7xLN4UBKdEIqCzIa7IqbQaS6TtC
mfqM4kW38thDQPb78da3dfb7papAIYA+QY0gtRFTArp5LGEYoIyhDFB2Et35
cwEgVzFuEXrCqNFMrF51gwz3uBkeVgxPKIZmS+FqClmK1xwpGvkwIJ6m7+yv
M6Sm7g49BL1rc7SaN1t/r8sYWYg+ukEuyxBLFU0/k7UotIS/NVdmXOXojFfP
zIKu8Peox3nvynqGKtIgnPN9ODkreupST1il5gKJbiSim91EPyWiO9xE97uJ
mgs1HFxrVXAlYXKGvF6ohjSdPGlIk7qNW1ylDjWMgVw5zkaMpkOCvQ6i4/T3
KEqoah7FtMggZW+vVmdYl+NVZ+hZZZv6IrPk5MgLbSRNZElN/iQqT6dhg4EV
jgyvUKFyj5ESp2u9hgW6xt1sbEpu2kyJcmtyy7bkR9uTW02iu4joXkWU2n4Z
ao8pmfprHqd1vOaCCgG3BaFSvB3qKV49YrWAqsg013HMlTgLw+5triqW0PYE
xF1J1qNRXLHGRWVh/4UXuHEVHn6E3RkUihwnTaIyt7/zGIpTAwVxyk6DxIlL
NsOcWDvjtTMztT4pX8qFGypZoeYxq1ZV9nDWjELh6gq6pko11mp33AWsZujd
rEqgbRR6U5HVzaSSqyuP6hh83oHrCcPCgsJWZFJGTaiqyCltLSAs7jUBu4Xr
Dcge7ZoxWVigXmHrJTvSr5us99lM5C+8/i9mwRdqwc1p9ilfqhj71EFq+Y2U
yWF2pFx8m/0WraC+oyMtktTNI5Kc0emsACzsh3hbtHhALgJQCcRlrFyO88M0
oq6TR83Aa5a0bp7eosgvVhWBZWlkIHVlVuxUrpnNpgHVG4o11EsKqiDl3mpG
ZDPT+sFaQFZTBfUiNkvTVM96Iu6IS48tdkp2j++VC25c7jynlr41vlfPcNGD
+DhRjr6ywFhB5VzJzzI4XRpajEKILc6JkRzjphydMsivyJXuWKuzJ4nSWxL5
Oeo0qnsUWm7ddcwojxiloU5n3ZVqXZlSqe8kfd6sK16fRB2gtBKb6VWpyrAW
ABVh5inXE7qh/sVoHPEmWqDq0qWL5FRN0oOOA6jsGLHhOAUxdJZc+T6v2475
Y+qU/jA7BgOc10MVLMdTWkylZxqekKoZymqWyh+ZL0mLGqOW40ZTjoOSdIvS
G2dJl06opeJIdi0XDZ66RGrE1XRWp8qpidNwQa3UGrfOtsZFpLY1fq4tZmpU
UR3A5OorholqBnc1nghMvc111EI/1d9TSUPlKdCj0GnKj9ZtpPwQ4Ph6qFYp
GzJDKHJal86AhNiRO6sjbzatxHEkXdhXtKivOBuCabR0aawsN1aWFy/Pj1e4
42kVY1QkvYJcnbQApXjEBfNDgkm5Uspym48ntCyKpwyy+wOQoj7dEtVULdCo
GPLFeadGOqzTKIJNCut4Q9ICtiJU05Q4SdeppoR1ujkuhpxpiQNZR61tsfN4
RS+0RYV1sT0qbB2ChaWqp4gruVIYxto4oNu8X9ObaSrt7Ysotnd12aKWarhy
gZTHkoMWY0Z77kzA1Zk/t1tYBfN7xN8XLOgpXNirlAc16kDp0oGyvBggKy+I
VxTGK4riy4oTpv5kDCVqwgJu4pZVZl/pliEGVKVEYYEWxbccNVIl6wXo16SP
IadLxggMZRGkIy3nTSN1sj4tEKgFChXhY7zaTteJ+gTURQ0J62RjQmSeakaV
QtQ9A0IFmgS0tjVmAUusjyyl0oiOvTr8WqBUEQKaUnEudndpdpTRZMfAZYmM
jLo4gcg4i54SzsH4KCyIkOI2wIWksvqKF/cXZ/eXwJXTX7okSpESJVaeH6so
jC0rSgAvYVWWJMSQqtKEJ2ay0iBsCguIiQwpuFWu6CksACfCG1Qu5OUBYQE4
cf9mt/aws3TTcykwEKBiKCygKEJmeLWAoshgOXrirLCApLCRJeEUyFPchA0M
XonjVxPH6xOA80RDoobLIrzgXgBUC6gKG6G2oT6FBQWSsHWJJKj2tXWlREIN
UOCdmqIWFfd6UE1qYNz0ybJyUbRocdQCdYlwSQ4968WoiMiEBdDELSSzBGOr
RKUliFqiujxRXZFYDheBExbKzebiE9FZgA74rVKpz8fvNhc/lQcxdBLBzdsc
/QFEYQFD8VWgyOs+pgy9IINYOpnyuJJkjRFcuZolYQqKsSEZYynMWkBU3HKE
Uyj3pCreHueNBZxLiaqwIJtaUCFZuChoc5GErap1lphS9IVLWNjT+Bnepxnm
z+3Kn9ddML+7cGFPYRZEwb4i1BbmLgBVsiSqWcmOoCAJ5QjmMUploLGkiHBc
dGRWkbSAmMh0xKbKlFUrMb9ZgMwCZiLsIKPSk6hZAA2Ut8lJd1p5IY0OuFmg
PgvIiQytPomO6AkL4ImQxEeB1AJ+IsMkiCUrQRQWMBSZSNEHEijagBE0qbKk
GWGZZSazdGohVQ5ZkDktSJ3C5jUGuCB/NiZtzJ/hmkYiylkUdGqDTkXodHMi
KH7erKmV5HSXLukpXdpblttXltdfnj9QXsCRL24tK4qJ0LLiWGVJvJJUZAEY
YesIKIiN7clfNvKRqsKXsC5DOJ8JrEZCQEmE1xtJDSgJGziJkCYFF7HK4ApF
ywxj5Xb4c5CYrUOmsIGZiGxTgsPISZqzAZmwuYJBbBZgEyEH3MGkBfBExJUQ
CV0I2IkwR1QdVEUIo6otdXgG/jwAKGzuSBCgBRFWRPwULcAYAlkK++jl5NHL
iaNXQGUgTRHGYFvngAomVVncU1nSV1nSX1U6UF02UF0eW14RBwDLlyVCKypB
qyuqEiurE5yN4MXWIuHoFtEQdIwLYV0YktUFsYigYkKmYmygYCMFWytGWPBi
Sd3YSCGkKcBFHMJaPYyCNGQpGiEdBOEKEw9TRTbKKENGw8OqD6QaRSATC5BY
AMQCIhYg8RLJoNoTqIS/UIuuh+D1XCLoqcMQfYdXVvetWt6/avnAqhXR1Stj
q1fBTcXqec3qhLVmDUhq7ZrE2rUJvGk23DQb7pq1Hn9sSNpw3zDQwKdXh5rN
yQiGm5CTJ7Ymw3j7bPkx3gZfwh0MmZ9jyB22vIc23MIQhh9bfpThLtpwB0Nw
B/HjbMEdFCGZSOgKw4da2PpOihDcyxDeS1t/qqFKOJIMc6VAgYmvCMQnYTuf
cYs+6PBNUPRw7tj69f3rNwys3xDdsDG+YWMCb4AF1WkG3ISQfP9hePsYbOFd
KxWLEH5+Nm+jz1CYYu/2ZBjuAt4EG25BBO5ARN4BCz5FYd9d2JXEcJwJd8KC
O2HDnYigtO1P1a0glbvux0H8kNELR2q6wnB3Aj4TGfodbvl4YMu26JZt8S3b
EyIC/1YgxVn+ExWBOBzhlzfDC0pB4JtQlQC8hBVWSdiCl9soZG3dIUUjbof3
OwTerw3v15I/y/etZATBTd4H+b0FL9Y2vBe76Ocw/IyfEFtqLe07274rtn13
/JPdCRQk/W74f2XAz3R7t9ElMuBL/FvxL+W/bWcyA36+Cf6FIsRJkq+bUPUh
nTzhjd3E71CFBRHGlxDemU/lDVS86dMv72lEqUF+bwfd8xB8D7/OIsqg3wFf
sKwERSb/O3f25X9+KP754QTlaQv4Z8LnwOJPxgHM53zhx4ayBH+e4IOFUrPg
Z4s/aXuxkqN7p/SIn0a4fxmKhrxf+CkOwy3BTzWSxzcX5nfJ7wL++SFUAfy7
Mzk+bMWIwanvI4rAYVCTwC/gZ+r9QGEWyA3Vpr+GGGRj1ZPuve87lYA4KbAz
0BqH8pITnAVfUVzF+ArhwcY4EYaoi7H3KIYP6jPgvpFu1H2z9X0TFt41W981
4bpXe/Fe7aUMoD6l7k+z/OTDvcL62fvJQPKUcShwAmwZTWwOKeqewWXpOwb3
ikt2gXcImzCq5m0I2xC9qQiBF1ofgeiOaZGKSYz6WFlC3sQ0mvaOQmaH/E79
lIWNlQ0JByoArgSwNofKDoqDA1SxW5ieQpCm9qkrmIQtCVBPZ/ONx7JSfWZ9
915GPIs+o3u53uFqVWtbhPW93kaSFepOi4ipSv5U4l22zE/jVq6cbcpp/DHk
W2tR6Qa3dj1d3C+F9B2W99fC0i/MNxivVVgUCnWHoVpZjoU9VS9QRXJ/BmXl
crqo0rSg6rSg+KQqNFRVGpibjDU663g9/L7jV6n9ob7WgnaIqq8jdAmLqjLg
dgi5QYmARZviZmtuVOERORvJncKLM2SGyWwPJ9NjqhPX1CQzEQZonIl2SLVI
YiKso8knu7Fk5WoJ4wdiwuDBMZQxaSWIMEc9FIJDiNaFbE2IPvkiIvlsoIvY
WPjxtwENf/CFJT/1VLFD5Yj1o0ME60uo8xNwIQ1IhtBNQxFaVUZXaayyNAY9
XAx6uOIYNA3QPFQURisKouUFUejNo1ZZHvzIjYpQ6dJoEDknM51uip+CqzF+
shH6zpMNcaumPi4iNVfjJ+qwUOZy+VhdwjoGJXTkGJTScF1KHMEraTKNgCi5
CmdFAk/NMixVeAoLHuAoVOQTEWCogx7yM/QW0XqDTID1K8d9gYlTpk0lL0yI
pK6hWl2cs0xiilemqSgAtoFYSUpaP7ZUzkrZW4WkaqgvJs1kLK9MAB2QCrZp
5dC1Qe8WE0QmRFiAyUB5fh/wgB+5fVbp0j5hly7pK8npLc7uFlZRVpdVuLBL
hAsXdBXANR+v/LmdQbWzc0LpXEvMqm2JiaG1zbGzcDXhdaYxdrohdqo+drI+
DhgBp6YZRppXE3ABTUAJnZDUZ+RoHa4RQ8ML/RIGVxlXM3VcZZDYPBM+VCJ1
AsCPurXdxE5FTFTeTVp5kh2BY8UxOKqlxE2MjcXmR6YUJsKATNLaRJ0rrzQw
MQAGvFyKiqwmOTEqwAQhjXrnocsrkowKuuuqUlyvWlaMy1e4Vsy6EWEQTllu
PxLK7i1e3OMQiihCnfnz2vPntOXOarWWzmixlkxvEaEl01pyprVkT2nO/qAx
gJwZJy+1Dwj7YtvARbm2fqE1KjLPN0drm6JnG+lqIqbN8TPNcetMU9wChQqb
BJrAhV6rBl7sEw2JE3TsgVb1RehYPT2RI5TY+4q7OFWyJrUg959VKA0xAkoT
JK+pZABKBmlSpPpLhKX+Pncp7yadzrYogIBPl1EcHWVNEHHQKZGRxoZqjTE4
4AbIqsrxyUtlKa9b2UCtogh3S+M6ZELcVJYbhzBXkjNQkoPry7gYltVbuKCb
pZQ3p0NYubParKUz28QtS2e0LpnevGRaY86UhuwP6hdNvJr1Xl3WhLqFcI2v
WzDuyvwxl+eNvpRef/WdfbhiTs9AMq509F9uH7jUOnCxZeBC88B5uFqA6/nW
qHW+LSbsc22xWrhaIbriszP7TGscH5C24OpuSwJXBIVd04LLgyeakrTGJN47
1pA8Wn8NgHq0ieFVoTxw1lGln+MuEqRmuMNUopKh5ieT3ScOu80mOyNGrlfY
1q5xyMncRcxWELPlUmaErQRXHJcV0QJkIe5QKMvD3ZqlS+MlS+LF2bGixdGi
rIHChX0FC/ry5/Xkze3Om92VO6tz6Yz2JdPbcqa2Zk9pWfxB0+JJTYsmNSya
WL/o/bqs964sHH9pwdhL80dfnPvOhTmjzs956/zsN8/NeuPszNfOzHj1dBA/
Z3WnmZ5CNsJFT67qu/qudvbVtfdfaeu3Lrf2i9Cltn7QKV7ymYl9oSN6Qa63
n8P1dlyolevxuIA75XQbPiA91Yoby04qmiBPwAkwWZ0apqPLc7gUmYqkH6OW
IkZTxXBbIMPBAKahJxVXxug4QuIiMqMjbvisu3hxrGhRtHDhQMGC/vx5vXlz
e/Jmdy+dCdw6lkxrz5nalj0ZuDUvmtiU9X7jwgkNC8ZfnT/myvzRoK+L8969
MPedc3NG1c7+/dlZb5yZ+drp6a+cmvZSzdQXT0wZcXzy8GMfPH8kvQbxqTHt
Cmjp6Wnu7pFIO3sbOkCb7X0i82pH31V6BA0qvULPui53aJ4RzfMcXrjoTmvw
YYCpUCZOokZx2X7cCcKJLI0wmwqkDq2DUGQlpkAIOVDHT5n5fPxWK34QMU14
1eWm7hJadKUoukRJTrR48UBhVn/hwn5SXG/enJ7cWV1LZ3Qumd6eM60te0rr
4kmE7b2GhRPqAduCsXXzR1+Z9+6luW9fnP3W+Vlv1M56/ezM10/PfO3kjJE1
014+MfXF41NGHJv8/NFJzx6e+PQX7z958L0nDkz4z32D5MLO3i5xe0dvV3tv
N+CEC4C2AMuunqbOHmDZ2IUiZYXWd0mWtFs6onECTWZJz8Emn1O6PEtPVhBk
C4JETbbiKU/UJAnyGARYD0cOraYaWYpGiQMQdzBE1iHF0mCClAF17QIK5JbA
xIeFv5ntVNiEVCdjplRdXEbLnDhES2BXsKBXgpvdBZJbMr1D6k2DI7HNA7ER
tTmjLsz+PYKD8Dh95KlpL5+c+gIo7diU4UcnDzv8wXOHJz5zCKn9bv+E3+4d
95s9Y/9915hffT76lzv8O99Cag+j81y4t6+jh3a9dsFFe3M01NZuuHCrR4vW
aHevoP0gdyDSLpdCL7mRsjx1qD2DO+nxydlYjrNGkMXnM06ENWlyzZOGJumR
Qyqi3OVDycWMUqLZLnDlKWXIHD0lC2kQEh9ETx06IeVB6CzMGpD5bk43qa9D
Su+DFk0QdTfmytx3LhG+c4jv9bMzgCDHyhdOcKCc9OyhiU+B6A6898R+EN34
x/eMY3y/2PHuv336zs+2j/rptrd+vFX4d0uZuxjD7hw5QIfN+/pxr6vJF/fS
AV2RKfnSJh4TLu/1wZza1V/nYos7SeBlUgBZirqnOIG24LajE8248xOp1qtw
a8Ra7kgg0Mp0qatXE6k7xDJSaDM4uMr8yNJ081xj8qxSPF2iTKpUCNE0Xgz1
y6KoTIIylHY4cfT9xizIfeNIju9eRi1CBH3zHJIceXr6yyeB5JQXjk8eduyD
545MAhU+JWMnYxz7a1Thu//22Ts/++Rtwvj7f/nozR9ufuN7m1777obgHce2
J856Z31YuFn53uhAWxrGHXjhdjsZlc0kq4umrn7eizn0ii8aa8BAlyqk0bo8
IrpcGF1zgrAvAntyKAhWJlBf9oQiFtG6o64L7TpZr5rpEuIt69TLNRcnE5Rg
pCWRzu/LnwthtpvCbHuOW6FuqBBdESpGV65jnIR4AELr+Mf3jvuP3ZLoz02i
WzTRV7+zbuQ/rn35kdUetXpniyBj2nOcAV8k6bBIfKAVwDJWPnVwC6Dt8XFt
N7kSVD4/fasC28/K9YZkAyrVSmPOGDVvja6QSLIQiDmtOnr1R2EOwUHZNJAo
5FEOvukir65bqd8gnIlS2WaomDu3lzUKVSoF3GaqT+ulRjnaskAp1E59sQZZ
DjsqBfrkgQm/24csIU3+epcKsorlP2954wcfvv5PG5nlK99c/fI3Vr34Dyte
+Gq1JJaap3Em6w8xPL2VjLYQ1zbmGh0IkqvKtx29jlZbfFqt7/LWwRd9OjVq
X6eHkUivqkoplUh1/E3P00ymxNOJvIHyVGFXwlQxF2Eu5ATai9qc0amyJwbc
hePr54+tg+KHUydGW+gKKdqiMIfLUIvChFD7W1IlZsydo3+Bqhz1k491nH39
extf/c76kd8GVa4BVQLJEQ9VDf/ysmFfKhcBpwJcU4Qoo35V/8p/xZr/gFfL
NcZqkDUDMQjWXUl5orBMszoEYwCmmjgzFVeKv28HcKXge/iKV6ecV/fUqMgb
WCelgvqhgmrGXI9CS6VCjaqIFJpFWXRuL/eRUp6UQlGeTBRDrSSKhawug55z
4iwTdRVAP/lYps3vozZf/fa6V761BoT50tdXvvi15SO+UjnswYrn7y979t6S
NDvKHXX+Md7033Sw0iXTqAq/UqbE0yfTQWHW0abMAJauSkklUilQubzgFagO
uFQgcQqF9mVwkDp5rpcguVkZTJpAMV60CKTJtZCZMxXFcaxLnTAlRSqBjmqK
Rhm7czSkysd84fVREOVaCK8SoRLlc/eVPntP8dN3FQatHjyqCf4p3uSCGG2R
OdQLcTBFBhVFZsnLBZFPjaM8aqQFv6CsecaXMm+coE6WTnD1ZEpZ+CRIh3Gt
QyeyTm5ZNMkseWRHgjnyVVXvcC/CFSwUO6YIH/v07X/dPurHJMIfQEzdRPgw
O770DcT3wsNefE/dkR9E8BYvwbgjQw2RzuLhjJ57Oa6602Wnqz119y6BCIVc
ASQh0u5MrH7ePmOmSqlEKH2uHfGHVE+eVHXPdUH0VTwIsdqAWKohyjUeJ5jO
78ub6/QjiyfLupUX4jA3ciSlTsTQoKpyQIO/2cMQuVwdpcpVDKOqVkWIVN9A
GAWIzz9QDmH0mbuLnrqj4Mnb8tIy/HO8UQvRYNhiMrzVUWJQJWsypCrW9vQm
712hGvaiK5gabaen52zElkQvI/zfIOSuMlt2H05LObUNWw9eSx3HCC/iqs6b
tQ5CVahOfObQe1TbIEIKo9BDogi5toEw+n0UoW43uLBBhA8SwntKUIS35z9x
S26QDh8xGDYZDJtNHTrlzfUgDEqHem0ICJIKx6Yk2OoiyE3l/4oIV6cgWGxU
NLm8LpCC4MQm2W2MvqIXVKFzlIlwhJMIieA+tRwHBD99m2qZt35EBLlh/DYT
pCbj4erhX1a1jAqjT9waSLDMH0kD0qG/QE0TSFMUNCmajsEJ/m3D6PpBCZak
JkhhdAkT5DDKGhzNYTR1KfOEDKNI8Jc7nTD6o61v/pA0yGEUqtFHVukwqgg6
YfS6CN5gNROwyuOvZjoHqWaCesZrKdcA/NXM4aBqZkfKasYbRQOrmUKzmonJ
tTmnmmnPnoxdRapqZnrqagaXbqil4ECqOkQIpBtGqpbiRqqZzMCOAhIgTeLJ
NBd0DHydfJaZi1FQH0+HmRlcyrgX193Lc3FvS9Gi1uaarqXs+VVLgb0hIXS1
FHt8CLenbCnWBLYUJd6WooSfeSwcyFeRdIkRSbGccXSoKPIa3AsGRefZhqxJ
33nMaAy5JuUVG6bIUnyoctiXHCmmfaasu/ukr7untbiwxsfBk59+3exaRe8J
biaou39/0FUbvbTKpegxoxQFggfPu1bNne7+iLu796yXmwS3pFhR1d19RfqC
VD0oVn2hXK/hYDpW9YW8+Abp8JVTaiEV12swmPLSOGREbizUKqrT3VNr+Op3
1iPER1a/jL0FljUpuntPFB2kdAls5tOuuaVNf+nX3Hz6u5B2ze2Qe80tEOBW
9/KMJxUuD3jUYTy3SkgVZrnW3PQCqmuFRq+58ROOV4xw+qyx5qaqGtSi+9nG
69+D9l4XNqtfNNJi+jyYgl1w5ZlqYS1F7gvG5zxl1vh0+OQMqGoYjKC17kWZ
NKvgaQh6Vk39q+AeFbpWZ3jHRr8saWZ3BUDU0dTJifKBo1mackB10uIv5So4
1zZymYY46szI5U0QwTs0Qb3Q7VkR9euOs17YA4+fLM/Q9LyLaap44S0fLv21
+PRXH/Q8OfWzKc6CgzL0PnZcl3rxOwXGkpyY2gVA8VQ/m5qqFmpoCdxYMMUH
jrOCSarUqKtUXgV/7BNnxUYvm35nPff7QQzN54uY72yd73iiTtjTMPBMj0yK
mgF9A/XuN3ljp4nP2H011qlf1Np2ui0BBkLvw2NDhgEPjxXFzVt9q92eh8du
kF490qaO0lzeDBAtWjSAC6Zc3fB2jhl6OwcUOO7HGf5Hjc42gMP4UEM/Pzab
Dsb5E9Cmwvm9TYNRRHS2jpiCnvoPCX7KRFFTOE/+fZuueA1tih8gzyvg/VYS
obNvjh7+X3XvgAxE6BPiDnOjXCBF45lFgBwHBVmMh6lVpxEvxQ1xUZUg+/mZ
MW/s0CzlAipHWMI5T2/sUI2HswNumLOx4z3jGRWEWiRKHQikTKh8BqOI6IZ6
91gF7Niw69WjX143s6+42WVe6MDM58dHO3ImeHY+qm2PUoGHjTomHUFPOjzg
eo7oh+jZZ2yqMdUmOc8uK91uULEaL12Kcw6Knb2Nrh1yEqWuWtWuRh1oZ6ud
HfJxo9qmo9sQuU0HO5F90InwLisAel07HYe6NmG4n+2q3ci2Fp2wEN1sipoB
4GThojfduLo/uUMuYMuqe/NxSnzuTXJ6z/E2906cgHjq3o/j36kasNPR3Jij
kmQZ73RckpAVD7ceZoSdbmy3ooTpbNJRJayHprOrQ0VbpyUZdKcjrUzjdkZi
JiygJjKdBc4OuFhtA5fa9Y5jiU3gBBdxU21rDCf0tMbP4KVCZgvOCcFJTbh3
HDeQP6qLl8Hx6Y2qxsa4dDuO02x23OaqbvCUpMj07lhdI/VIO/1/kAolLqSa
0ZX3reKOHNy3WrSonwqfvoL5Pflyp3gH7hSf1pYztSV7cjNqc1LTovcbsibU
0xY62nGMmyAv4B5xj0I55L5wHBQKBVFQLHXOHl5tw8RG0ZE68rBTmrRHL9JZ
Dni59Xxr9FxrjMZjyRrzbAue5TjTFJdnreTYCJ6ZNhQHhDTgOB/ck3rVu72Y
JsdkmPv+9UYaPhWX6T/AwQGUTlA96Od3Axv/N3s3PHLbTzNAMs3Aau5gxVOD
4lu+vf9Q8sTLcqOlSwdKlwyUwJUzULwYz2oULuwpmN+dP68rb05H7qz23Jmt
S/Hivf94pmbxB02LJjZkvV+PZzTGXVqAV938sR6h0pbkV2vSzhy42Nh/sYUe
BbVDI4e9HE/PCSGt1hgorLYlZp1tjlnAS4R46NmpZpqSdbIhLjJr6uM1PKin
PkHjXa4do+2JeJbKwkOOYT51I3mdl6cb70klOX2KMfjEhnFog87d3OrEUBPf
pwHpkM65ZWzaHLB5nGaCiIy16nQorwBw/8izev5RnuIwhYmHpeIVhXzOcKAc
j7VFy/JipbnAs78ku694cU9RVnfhws7CBe0F8+HqRKpzJdWlM9qWTG/JmdqY
M6Uue/LV7MmNdKiD0ygXRXXzx1yc9+7ZIA06pxXPXhk42xCtbcbdEELt2KeI
2BI/3Rw/RTOTmhLippN0XqqmkeYp0RSe4/XOWUY8ysjM6pLC1v2BwHOMFpAT
GU6cNE5M0UluEXYUZ5xAzdDHT50KVJ46FRH/ETjvCbgUhxadM6Yh8yAHnaHK
1Ed+9Xmc1c5JKnuVOqoo5y9RBZuoLof7VlUWEw9VlUYrS+Di86OItjx/oCy3
v2xpb+mS7tKczhK8uvEcXHZ/8eK+oqweOlPVnj+3JW9OY95suOCLdrl/eWYH
daBN2ZPrFk+6mJ5izYXoycuxk1fjdJ4NZyJhJLSx8m8yzrQdr5fDlCAm8vQz
HAxLnQBeF41z4CF5XrFWnToVIfOcG0XK253zw8dVuaLO2fPBUyk+lfj0ieGh
+nx34MFTS89a+EQitNR57rA+Js8hVc8SEKEN6oCwOh2coU8H6yPb7rOn1YmV
VfEVVXFrRWXMWr4sJh6srogD0KryRFVpHGEW9y8r6l1W2F1RAFdvRUF/eUEU
425etGxpH1Atye4oXtxSvKileDF80Q1UafMy9J8Mtilv9tW05I6eiR49Fz96
MYGHRy2o73FGEqkoJLs0wmPhIf1MfR7YOUzq8Mn0HEXcd1LWkmougoiwvHYb
mHC0irAZE1yCJ0noCQiKV4bmxSe8GRmfOs1gZnJwRopT3h/Li0ap0Dwe9zQI
YbMO8SCqTTMOtBY5ut6soyuxTKyGa2V89crYqhWxVcvjK5fj9CB17j6+fFl0
eQVUFtXlvTjxqb+6LFpVRjqF/14JOi3uW1bULayKgg5hE9u+igKoN6BCEiFS
bU/pkvaSbI9jivIlpH2IEc3w4InYwVPxg2cTKBrMTxaONrPluRc6eK9O3xt1
hi3VQ2e34SXiSl/ECA/hi4gZB1lNYZqd4J5TYVFOo9kJxjl8eIls13MTlMT0
5ARbh0nNC5Vm04QbQBXxqA1whT20MHKGcNBcZN36xLp1iXVr42vhWpNYszoR
wromsnoVcIquWtFP44miK5fHQ3gsP7KyKraism95RTdd8EUsBNUO8hqoKu2p
LG4POl/h2g8acteTew7H9xxLiIg6TW07Mw3C+BIyA1SG8cnHaUMZnnuaQbM/
nDkUkYA5FHQ/hS3vqC0npHinftCUJJz6ETKPzmd4VBDh6WEfJjZuSmyAa2Mi
IidRxNeti9IVj9DEq7VrYmtW961ZBVcssoYnHgysWt6jb4u8X/gpxZtzW/B9
c35l5/4ETpER9g5VKMHdcE9CwWFxwtZZlwICVlBD9MQdnoKSoWb+8FgdgRMg
cBYSTs/BgI7zhSJqMI6cIpUBL0NoVseHWxMffpRQk2Pw7sQ3bY5jlM/geSgf
xjZuggu+38gRf0C/J37P5skMvBOWp2+8JfBe0L5/3DAuJzRlwstQwHw3vJvb
4B3cDe8AJx7hKISh8A7uhncwlOb2yL9G//22+xMp/yFWagrGv20o3Af8U+lP
lzOWboO/eSj8C4bALb0JJxfBvyxT3fPtrPJM36wkW5K/YzDy69cPZFDIxfFX
G6MbNsVEJul742a681TybqGQnUA4MiSY07Ay5SS1TM8cMFQCUsfxH2oiFM5i
Cm3bpf/1qKtMPd+OLtDdXv6kyU9ehD55nymLCqnTHfsTOw4kaNAavoR2HvBO
CnTFaofIyuruVcsHaEgIvkASia5e2bcaxLQ6KqS+MIKR4tbHpQY3JGg+GGoz
g+6PHvEH98M1jxEu1DrNfQrruU96ruanSTUfjWajGNOxrIBZadYnu7lPsfXE
ORHGGU58T9QMQBFR49J2HpQ2gZg0RIiKsMSuQ4ndR5KY/EVo99HE7sOJPXAd
T0QwC4X3Hk/sPRL3xo6vujPcsqL2ypLuqrIBHJ8oMnAeaXm0uryvurxreXn3
8mV9KyqjNJAUXyATx1ZWR3GOXz/O8YtiooYwZdMsCUgLa9ZAfsAssW4tZgzK
HiE5TZHmO2M9h6PoICga0xR5Eh1+9K5jgp/9sfvOhrRetst7OlR/5uQsv/2u
maYhz1RFNYIuAhnE2n2UswuPnKNULjL2wjdwM48l4HVfTWL/KWx1qAwQEfwG
ful4/MCJ+IFTiYNnkyGetlSb+OJ0/IsTsfT1ffHippKc9tKl3WV5A8IqL0iI
O6FbLM/vK8/vKs9vr4CrsHtZUR+UrDhRuxTK1xjQqiqDyqcXiqDqin4oiaAw
ogrplpU4axFqpviq5Vg/USFFFRWP/1UDFrnysvWERZ6NlKEnXm40Bi3SPGee
LmJqgSeayfmkxrRLCxlleKYsMiKeiOGasUif90z/sFKesWjhZz1zlzEH2hw9
i9WACO1TM6EPnOHqLBMnWp1JAIsDJxMHgciZxBfncAQtzZ/NPHwhefhc4tDZ
+KHTscOnY0fOxY9QiW4do9kg0PBeih87F4PqPYDbPZpb3qy6vDlN+fPaChZ0
01R76A16ixZ1FS1qL8qitiG7nWaY9pXlAk5sGAlqL1Sm3SK8rLB3WVF/ZTE0
lfGqsgTWs3GRWV0Rg14FLuhaACn0Lzw4E/sai+PaKtegTMGzkvSYTOGaLPuh
a7KsraeV0iQ6Gu2mRztTzRg2h8vybEypqEwNzDMc2PJNcTzKJZk5nJSqYloP
sOXsbhw2hi9DDrL/kHargQv4nE8cxpmYh2vj4q4jF3CEEgCSs7zrEscvx49f
QEbHz8dOXIrXXI3XNCZ49j6OfrkaO3k5evLCQJDuHtb8Fk+8kP1BXfaUJjLy
kYa9ubPbc2e15M5qgI49f05L/rz2gvldhQt7AC32f9k9xdnQF2K3j20/zqbt
L88bgP5iGc5Pj1UW46SpqMggjcIVr1aDnfUU2gw9hVaPn9V6HGpOPNUeFTpQ
EsWbAuc6O+OBd8qoGPHPdXa05hmyTvrCqW4iY7ee62wMdRY8l8ozcV2EDsFL
GM1NLyaPXJJTnYWefYU6uhg/fil+/ApOVKJZPENPNiKjU/XxU3WxU5ejp65E
T9fHzjThshSe9+B53c2x2oaB2rr+IIKOAue9c3b+6As8Zz1rQv0i7VvwQQOS
nVyXM6UxZ1rLkumtS2e25c7uyJvTmT+vq2BehwX9u3igcEEntPJFi4BpL85Y
x4H40XK4cNIwMuVhwzSp2+VkoMcK6ynduI6E/dBQHq/u8afQTiO0NnW739jA
w88zk5u69Jv0cHWPmYyOijQljNZttA3UfoPXwfNJl90BzZnDqHf0MoBEddVJ
gVk4Kj9SU5/AwVj18ZN1oKj4qYY4eh/QWq99thnXfmuboA6obYiKIedaouel
vQUt77MFTevApaZAgg9pgjNG1igPUbLAk3YU6IK3YOzFBeMuLRxfl/Xe1UXv
Nyye1Jg9uSlnSssSdKRoWzoDF75zZ7Xnze7In9vJs72LskCk8DeW5AyIISVL
yOIgN+Z3peC1gn9N5TGiMyV6rSlzLr8YTXuDAH+KIHsDJ8VpC5mj0rTbMR4x
XCq0lwzPxA+zv4F2qsA1JSCO5gYNSTkQv1EO2j6FFz5DOd3Mz1No8Jn0OGiN
iYzzrVF2rLgIV8vAxVZ+eo0PQ21t+y2k10Fbn6cC9+znRO+0YdpYVNqnMVkL
0IpMcoq5qDzxtHlFowVyFXey0QhZInTweH1pFrOwvwgy6+IBNo4tzVW2auQX
YwFQkantKz3eB7QSmJnKMobWpb77V7iM7BjUOMawp5CyMzXnuIzg1v3j5OzE
c3NuQRuDloThH4MWMoQsXtsWkyYj+BQGVCYioDNpMsIeMh3ymba2keEdJqHG
Lu0OFOQ1slAznCB9DQ9MfOoL9hmVVr8vGEhfP+s4xr6teCrLSrd1kzLfUuaj
7JJA/iPopObA1O5NgSS184/hquY1i/E5/0gfxEAZajuuQ24/A+XItS8tPeXk
lGQH6BPK9kdbJPqsuQLcudhQhM8he20wlT+XhaMGbDbDDHb+8TgES19D5VE5
4Xf72TOWPLfJxekFkGeNdHFiEyDDvNmxUHuvkV1llFFJh0ORPbjItVJaOC0l
459U/k1uhKv9CA1v4A9Nrxg3v092+2x+gtTngWd6whi6I/d1tiRQ2E7RDgHa
HWdrmzyfVwjtEQl7XLh4d0KG3xNRO9GGyYarS9twBWXECZoiWo6iU+W2dx77
VLqqMdHHpSOeR5pMVDviGY5cV9jQybRTlyyln5oS5WIQZbR0CVpgsBw9jnh+
kGv8xpUeJ7Vthhup4S9rhlGXI15ahJ64qcWnHfEsRS/scQ2Wp1F1oOSz/5E6
n+Boz0nY4z7Lu/hsxobbMmmXX6iXTPF82fA9zVC6cf9ws7IdVYbc7Of8m90T
tIUs2xsyT7bpGum4qqukedlx5p7kkOSGJW+O4VK5GP1MSnPjZfkBLpWBGF3G
hqZRt8dR1vQI1obrKUxlXQAvOAANEzzp8nJSApRBk59Rh2q9/ncZ2oPdtGHn
/HZXejdD02LWY0UapMMPNMOXH1k98h/Rmfu1724ga3WA6fN2/vUuhiktRxHm
YWWwjoZrMmO+Waus1pTfqEuTpsMz7tcpQg/ZmHQ3dHvIVgV6yK4OkKITUAMZ
ukXoeBl6vO98AJ2ypVnLL6GMgROB6vuKpudPdYMajJrmwH20y93wBm4LIDhF
E3Q8ur+5euS3175GdsBvfJ98nX8EQVbZjiqTdfatdDgOUxxfkRx1eEW/PEqV
i0yb7hkoR2WQR6VOCogBvs46nqb3dU7v1O33dXa7xLIFsIPP8FxPb9bNUfPB
uutg53Nd7zQl5zfsDiA4WRMc9qWK4ey1/jXpz605cnDV/tyjQY+/cvSIDpZP
qyIW0uSLJ6ZzjnwNxahzJBeuLnPuGej8K429KDX+zbzW0xM0s6Dp82vaiLps
uZ3kp9XH9s0Kn2PLTfS+HKg8HTPb3d7NWnZMb8AtuzRe60TQ8Wt+9p6S5+8v
A44jHqp68WvLX/r6SuT4TYyrKEaycoa4CkmSgypXPCDGCb/dZ1avUwjitJfQ
whIgKiWyK3ed6RoL4dRsOqTjIfeO2DimkKEyF/UG0ush+IWLoGnraxqrmwI0
axfcEE61S6Ynekp+sk8YUkdJr8HDz6gzIx293W7tdVhoyXyTct6W9Fh7TO+/
YniOPX0mfOauwmfvKX7uvtJhXyofAXL8Kshx+cvfWMkYIT2+/r2NlB6lxboq
XGUfIgudZwwTZ12vSnN1aiK1neUHmBWXzuCuQ0ZT6DdIiPFAIer1G13TsNOa
w/CjFAxVR6jTIC/GSIb+HOjy2Xb6B7Pn8/LrcFyYb7nq89Z2x85u1SFgsXmb
qlfcWU9FThPgH+NN6c/6PXVH/tMGxuFfXvbCwyRIxMjZETBukhh/jBjfZYy/
NjBy8/G8VKOub6SfOq4FcHGDZuoynnJlI6UYZSmy87aTEQODqYfhZoPhJz6G
7lJGJkK1CCoX0TiMukR4zRdD4+4YyinQY4/uDaD+3OeOnoH4cHyLie9PgxF8
8ra8p+4oeObuomfvpZD6YAVr8aV/wNQ48lsUUqFU/f6Hb3J9Y9ap/75r/G/2
6OKGHbmlK7BMioYQx101y1MWIpY1lBF1MOVVOIdguSJY7RCEYHqdBF3F6FGD
oDsRyjCqytATzddqjJUXk6Bfgt7iUztmawWmKDs94TNQfYDvz8EEpzkEb83V
Mnz+ASQoixskCM3G2le/Tc3G9zdhhUrLAFShfqac1fdIb+6nD+nlViDIoRTL
GugxNMEJFEqB4DQVSqkwLcqKmkupDsHSlATX/e0IOokwkGDbDRCkE3TYsz/g
CqJehB0OwqD6hUToQph2beYJIHg7Eyx5/gGMoqjBh6tAgxhFgSDkw0cNgj/d
hoEUa1OKokDwt3vfB4LPBBIkQ24iqL2dsyXBTklwgZtgYF/hJvg3iKKKYHAp
M5gGVQcfoEEmeJsmmKb30wR5Hu8QGURVHDUQNqZfX4M4+vSdMo4OY4YPURz9
+grOhK9+R/WJnAkhjj72icPwcRlHORNOHsbL474O0ctQPl7mOEqZMF6yJFHq
z4Tl/8uZ0IyjZjk6OMN7FUN3JjSWX7wi7A2IozynbGjMq0KKpXFJ0b83NKT2
t6WpaSqdjh/S4be5NDWX4Vzt/oTUNY1cfTMXbN531TR5rpom/n9e0xypU+va
3Fi0evvCgLb+emsab0/h9PODlaT+mgb37Zk7OEOeTgNUqRpGJzdqnGaJ6u80
HpedhtP1G53GLEOYrvQ4tW2Ju9MoMjuNfKPTKMeH//xMSi7arFadxoagTiOI
qO4WHaKeTuO8p9Ogle4b7zS+Mlin4apUb4jq4JO2jf7/uXtLMVE+uEz2/9/A
/p/WVdfr/v+tH31k9v9KnVjqaJxTRlD/bzaO1P/jVoFxunFsznH6/x5P05Eu
1Ab2/5uug2jgCk4Nns6QRujmCo4TcJM30v93OP1/Kqly/39XOq36+n/VguAY
LY9KH/Qwxf9Ku6jzeE2Oih6VMGXRsx7XyLHxwJw5inImd49Uue6mnMlPOw5j
sB1xzNglINMm7fzgh8lyHcCJt8YzZHrIobYCqKUAWf1UuB8am2tygauqaYjq
Qva4O/D6HkvJBQEfVK3Uc0FM04ffgILWtybnqYjCplj/Ivelp+YpxunvX/yq
Wpf7ltSlCrNbVJh195FqTQefXD0vHyyrVtJ5ckWPreq8wXa6a0mAcMaCH3aY
GbTa9cDKSaKb3A8d/UT1k46DvlRqLNN5ZOostDYGJFQ+R+kRKj8bvvOy+wlV
veehcHfwMw5a7cnsMZ9xGHLF6XbXdVbGIfrKN3Gh/FX1wEPHWGYp18q5o1RF
ELUkh3VLond7uFZaVSnkeQrpLLZCb4I4cZyAtyBSAr3OZ1f4/DHFM2TXsysO
vOazq1QyreNHx9e8CVU+Ob7dE33N5x8BVW9XH/Uud3kSq1+vvigsyQZURvpE
w1jXk+Qf8BMrVcJizaMAOgus5sNHmSqJ4ZlZRrZ0GOqV1imtSpJyhUA+usr2
BVnPk2R/5lTC9D9Jdu3p2KH2dNCT5M/2+5bQ1Qqsa/HgnLMPh2Eaj0LkMp6w
AKe4WcfdNEApo9p17p1SN2uh+p5pOVB5mqSGStOb0vab3hBKj6gcak8d1Aty
cvecflAFgZSXBPQ+K96ew62IK5wCu27ez6F2WMVKaSOA3Cvn3l7lqNCNz3l6
ZSbLj9SuHPfOOLmraq/3QaQD0R9jjceRh9374E64Iy1NyQmfaXVto+L9OBHN
UTcxVPFmpnqybEHYFUNbu7t9MJ1tAWn3VckHi/oBMT9bxNx3eMrwI1NfODr1
RddjYlpMRWrORhyX6GiDHD5qdPbiFMzvLVzYV7SoX4VP6Cfjnn1VVaVG0Wrs
PvY+PnbvOPYmR88OVXeK3PFFWohGWHXtCkAxXuP+UwZXmo8j9zLK+BoyF9eJ
ZIZBckCXRNy/hEyUdmNnr4g0d/V4dnjQ7pwQoNR50OA3VfPTzxGNzhBy3Inp
r9TMePXkzNdPzXrjzKw3U2+eonzH1Shjc7ZrzO+TOzbwKeMA7r2hxKeCZmKZ
X3iBu42NvVSufcZGAE21w9gVRs2NqWn2VdUaFP274xpxptEJGpIj61miyHGV
qh+71rtHjp42G3vkOpzNOnUdOAWmvU8MvdreV9/R19DZG7hlJ0CD0zVDGR7l
TlQW2pnZb56d81bt3Ldr5717ft7oC/PHXJo/Vm1Gpc3FHCeJm9owpVtDuZMx
6uxkxHwXd/YXF6HfsXc/o096q1e59hev1xtTjfiZbn+xYujd3pgCo3d/sZEZ
/STl6oHRmXh3O0qaapcq07zdTJbo6tqGfr2XWvsvt6Lna107VLd93r1zAfSc
/XDUFoDA8BEFbRyG5uDi/DEXF467lDXh8qL3ryyaeHXxpIbFHzRmQ3Sc3Jwz
FXf5L5nR5toOjsT6lNjkDilNjCOlTnTB0FTducrHTZ+5+Vvt8fcCTL1H/ECt
a6OxiVHgvAhha5Q8syqMLPGiYTst0uUxrLeL8yZ/Qbv8cVYPbvRviZ5vjlrn
m6HqudCCOC+3466ejgERAn3KZfnOvgCKzjnR+WMuLxh3ZeH4OivrvasiM+v9
q4veB2z12ZMblkxrXDK9aemMlqUzW63cWe3i7tzZ7Xmz2/PnduTP68TzcQt7
MbshNrSeLsWzGbRxWO7lR9vcSpAbnm9M0umMjEDF8XyPDL/w1qkTjKENRgDl
uT5+iHxe1zjv9rnrfGLGp0FqlE7fnj3j3HXwrJtMPizl1yZO+CCfcfuIcXYD
XjLxPBvPSGpQAbcZj29YpxpBmacb8QTHmSac3NkcFxlnyLgerrONaIF+rjlK
7tnoih6SJzna0Ig57WQuPPE2tUVYS6ajJ3uriOBBmpmteXPa8Czj/I7CBZ1W
4cJuqyirW9xZtKi7GK7snpKc3tKl/WV5MRIbVCYxPh1FegNwiaqyBB4dpjNS
6CBvATcR0lUmaA795umUVAYfXfSETIEng+lcxk2bzNBponPTu1XT85yYcvEj
hNZOOvGrjpXKc1PHeZbEEIRIHP3a5JlUYef01AWefYQnSW/GM2+Xk0fpHNUx
bkiAJ81NOgHXVTyZaNXUx3EelnWyHp3p62OnG5AgEG2i6VnCPttCp6laAs8J
O9zwIOKCboFsRGZhVjfwAToIaHF3SU5P6RIEZJXlwo+8fqs8v19Eygv6KwoH
8Fwih0TSVlxEqp3DbIkVlQmARCcTh+iTieZ+feO8MJ01DTvBkvKcnPGiY+b1
njXN8Jw1NRVof6KObQvzzKLrfDDFVkudWwyb54K1IkNakfvPyEk6shHhC9oR
1ZGQPkNI9FICrqOXEtbRywl5lrEOkR6/QmCvJmrwLGM9TjmDH41Q255qcg7Z
B8bOstwYSicvBlxiyCVWQQIiDcUqi+NWZUlchCpL41VwleFF54FD1RVxfeDQ
UpxszUngmeAAXZlZjeNiRJ/sNqKjjJA2Kw2HP5in7+lcd9g8fY8Hu3G2AZ4v
xXkpNIPG1pqjWTUipA/b41QomujAxNRBYY6hfHjxqHOkm84vWjjfRZ4VtvDg
aZgPC+uTp6RHC9iJiKSnNHn4Ip3vpslyIT6Kiq1JXZIibZjPNmpMwdNDIfPg
RD6rmmOYCOmjnub9z/DoBOsJnD0FHGzkYGsOjmpCzrHeDUlbzkFwKWczj4zx
n7PfvI01pJhYGABtDUU4MxF26pkIio7lmcCBhGyc/KTYRLSgODjCK+W5kMkI
FWYDJdsgZAfqy6bpSPLEKUDC+XA4c4xmj6WrLlatSPBt1J/mCN9FOeGLvlZ3
MwI3MwT3Ec+6h7z3ET7QYXkfLbiNEbiDtrx7/qkdtmdqh7VNfrq37aJ7GJL3
EEcWwCdbnYGXczrC+hMu7yIkmTDcQZ68pe+gCKsoZesoJcLGvRRhmnOYCPx0
Ovdow4bEBj1DI8wzNNQ5f121ZsJ7D8v3Tp+liGdmA3ycQhiWI3yCHGf18E3Z
zvfI1vdIhOSnDe9SRM57Ccm7FJZ3KUMNNPmEZ75keGaa8KylT9XIMRpAxnP+
nJkPB+UYObiXCYsHwXg/lYmdX8TT58ctWxNbPk5wtrF1sSCsj7Y7E4m288QK
8z3e4ZlegZOMbI/C7tSTR+QZbfhyqFKd/H4IzXzROU3YcH9wBIx3FswQed/o
N/C4KfpShHQOpM/drgT9rogx2ySxfVd82+dBUymcaSLbdya2fw6XnjOTqb7Q
s2eAGfzJt6p/H/17dibx33+bMztsh3rvQ+ElgkN/Qnr+j5z1ZMtPx830M87B
2o6/azt/pBJwhbZsSxCPMN3/xJZt8c0fRzdvDZzM4HzOd+5P7DyQ2HkwEaL5
EgeTmayxAzKpiLD6DOHnihUpwvCCKo3A5y8MbzcM7zNsMAgzP/2+bDm1Ct9B
mD8D8l/OxYqw5WhJ+Odn4uQfjCWgpxDqC4N1mCe+4lQvHOwVx8FpcfgBvdiG
jYn1G2LrN0TXrx9Ytz7wDLzzud17LLHvOHxu951IWHtpshnNisOMGMYXW0+N
ExkYTGw9gVHNR1KTveDSdybE87z4wtlxIbgvdto5ZzS3JaTvkJp4FtYTzzhI
kJiQalhNkrP1JDmBdyckZxpjZA7J+Zs4oCRMk0pobiMOkBPhNavjInPNqvga
mvdHw/6iq5YPrKzuX1kdtKLg5OlDZxPWodqE9UVtApMNZJyzVCLImTyWnsl3
KslpCl/k9G0aaiknJhkz43Cgkk33c4cxUjakpiTaciTpXq5QrYA7qaaiwV0M
O3fRmZhofsL0JD4ZpUPG1FIeXBrmcYlqFC3NeQlh/sNi3NbjoakCFPaqlbIc
4Q45ghMwaQjmiqoEzUyM4wxM+AFd5PKKWHV5FEcIlfZXlvRXFvcuK+5J/xnF
gStQCNtYDdtHrySO0vQIKLOwpz2shozylAKbZ1jS1AIaEqJHWUoyNhQNcjas
QUQB4fkxn+v5vofk7EqaYXfQnBTrnV5pDBz1Tq/cen3TK/X8WFuT4O4mQ891
1qOd163lDzPO7DOmdQONEBII60HPXDwK6olxBmIGjwnmScFVpQkeFixC0AiI
zIrCKE4LzsPZsqU4hbQXWruSnKDVUfOJPk7mONWcsHHloKYpietE1onGpIWL
RiFoS9FbgCfD6umjV/T0UYeZnsEc1jOYeQwzdVNcqfA8Xz1Em+f9BMyxpDwe
dqYy7+P6k0oEnY3MwbDc0w81J8Oaw32NSc2RjYZOEIuc8Zuhp+DrGb9rVnFd
TkPh5OBmY3Yz1vd6djPN4g7LWdxqHLewlhVBAqgwvEjK2MViKRpZWCU5UTGk
OHuAp60XZfUVLuwtWKCGdM8NPO1tksNlV5uHn+spzTb7DdCJWFypxSdi+IAz
UkOOEdrz43hDkiaAZDiT0Osc/w9W41BzoqwzpNk16/fv/fO1vVN+fSO2zfHM
rLab089nNvjd5EzaNodtr3emMwvqAG7WU9PNwek4blvOwccVJwuHZ91cKXWE
C4kVRbiiiItUOMwXH6Wxewywiok7irOVX0XWAFlWaAOSntzZPJy5c+kMms+M
U/LR9mAwhpc6tAsB+kfoSek2O19prnecMSxcTrfg+i2v9tU04fDtEw24CqjR
HiOiwgKgvhiLM+4Pao8sNRtYrnmYLhOkzrt2+WgGonQmNSuMnLcy/O4hajqz
yAxECPRIdZke1WkPA9LanToAVhYrdgWx8vyYQS1aktNPI7X7ycygr2BBr5U/
r0fckceeMWhpoJBJb66WxZNwVPqi9xvZQgbdncisQlzH3kWnktaGE3WdfALW
wrN4+HzL1u5KxJk0fAuDPsvD1fGSs/ARMj15Qa+XBpzWDYr9ubQvqHOJ1vSd
0BlTjn3Wc/CNEcKfp3Cf+NTtXuA3oAhwL/gwWItrtG8hKZAnmH03wIoCgyUB
LIxX4PJwXDoYsHdBdpQ0N6CCYw8gzJvTlTu7U45CV1JDGyfypMjS/mroOYre
BejNNeoC2VaSB/Dr3un3gTwDfEX6GgxfEVtj5lPONptUaCefB6UFKA3gqYWL
n7G00Bh97QmjVHzCCM3HDFuYw9pUi6Ix5dg3vCYHJ1zzof8KXxGtUc10o8eO
whh9v0q74FXpeOq3+kmQpyGrEYe9kK8Ip7k+6RKD1nid6Csih9orhhPJjQsY
jr9KFhSO3aEESJ5c00eeMrwrj/t9RVy7/02auOc1pBzttKN5BvuieUyxme1Q
x5tQWVqYBnc8fYIdCk/T5gXKuo+xSZPyaaJCyqNYMxgrz1Cv04gbp9foZ6fb
6MetT3Yx9PiK+F23tCR5vtmjhp+I9obBswqQBsnph9Lf/F6Z+2Z1Ob540m2C
4ud4Q4Rop3bBMVF/1TBtGnGMPfKk04+yyQvYuWjs/8fdbrSz+D74QvsVGl6T
3SZfr+Ok4XiuzWVIs2EGe16B1d4XLvdQnro1xnQwdExELxnmW7UBMvW6N6Ux
3zKImtJk8631bvMtlyi94dVt87OUDfFi2kdNOm/N7jL9DTEVsvOW8lHzShAh
Or4+Hzx/1CH4BBkdPr6HXSvH/HLn6J9/JomlncPM9qF8ivn2IKwBfnhuL8OZ
XiNRt5eoacXscaM80XTNdDP0WuHVGvnUdDM8QtWRoU72104J0rBQM63w1mpR
uimaBj/aKLaMnJqkp6FEKE2buZoxfZu1Dh1+ZM00XXpt1Uhnw+e0cxpZjkp4
yjpWOht+/NaPt6bZfzqYO+Ut2ha23WsL6zKndJy7Apx9QatYQGV63WEpoSqX
k7elw30qc0rTo1kHW0OXyHJ/WpZ+i1EdYHXdU+2E1qryAAM1dvxFcxDl+EtJ
kYxGpxnGzdpDXavwTWUZO5JS4AtkNKrs0ti+efzje9n8TrrGKoTkxP0hm1Pe
YB2E249v9jmlI98ut20s5dghaSx/ebfeFI9rbArLdKVT9M27xra/x3QuTeMa
63bqkqHW71T5qbRWczn/bvRFWI99s8uC28VTucYqB2f2wfNI0nCNVTDRJ00X
M8r/17AxJP/f0b/47N3HPnV8nP95C5AkT3Vyjf3WmqCe8z7NUHk3t2rvZofl
4N7NPVQpzbgh622Xd3OrC6L2bnYgerybU5jG3pB3sze0pvJuzjXwLRwwvJs7
cliLkwIMuB12r5yCWMrsVCIkf9jHlXfzL1CFb/+Moqj2bv6nja89un7kt9e+
8k30bkYP7ocDvZud06t/MP3To9fF0RVsg2yAnXLI5wHsSpraPJYhutOl459e
G2Te7PdP3y0t1lwEAw1/tQDdmdFJiy71xTAnMr5ZjA8KGsTnMWxGQzssZc5M
Nx1+KQ+i4STqLrXv9vcVO7JqfukbK1/82nJgN/wrlcO+FOif7kyf/q9Y8x9i
zdeII0N0vNTdgbXbHVgDoqpbidytvJ9Kip46luoeolh/7WidU71CS+LKjzU+
hAduBKHHeVvnRF2fFsmypjRXeokaZamRCnFtxpAftRRYyrxGSZAtfZGf4bZN
/Mb8SmrvnZ/5rLbZNP2RVS99HfmNAHgPVjx/f9lz95YEEMzUBP8Yb/pvOgAJ
YkxGW/CklQg5Yuxvp+ong0sfE6J2VB8SLEWj53wPati0WdG0klVCTBFKUyLc
60Poq1JNhNBl4HJclRNEuaYxJVgMEiRPX4+hry5lsBodfYUXZWb/nsIn6M/t
4KvyHlYwwO/dn38m+VH5Qqb3m9gqHfghPDS9Xz7ioSoQ33P3lT7798VP31WY
Po7+Kd6kMV4zY6qRG68noDqlq9Siq7n0R1OzruF8yP2Hkw8vB1Q0DsEjRoV6
PQR1k0FpkAmmDKKowDi7+aIC5/Y6xShHUCpesB98V5lqv1GLZShXLsOPTaY2
kMPneMS3B3oImfq4gSBrdMD32qNQs6wb+S3Kexg7q1h+iO8exPfUHfnXQ/CP
8WatRQOiL6AGQTRLG09KTF3XBOVDduNmK26qaGQkNZPh34qgmQaNKsaJodhR
uHKgEiCVnxOUAKF+kRb3MoBOecEoXvzm9jL7cfTcRCWnip6ovuoRlPogej57
T8kzdxc9dUfBk7flBRH8sib4Z5r1YEbTwNLGnxIDCfI67eQAHd4YQtlZeJPh
X4dwc2qElS6EFRqhLmO4CuUYOl3HUFcO5BpmBiCkBTWsP3khRhva/8YpYJz+
jxUICCEBftNR4PAvLxv2pXJHgbfnP3FrbgDBRwIJ/sEbSNuuJ5AaBFOWpZAK
aX1u7CAAGyXAI2Y18z/UoA+gtxQ16piKArOrVxpUCzNag/L5BCVBVYSelRo0
mj9u48exBn+109s9KIBQgb78yGpuHYZ/WVYwOoQCwCANfsdP0BAgEtQCjKre
Qjf73U5NmraxUA/BzDzIBPXa6tsmQixlcKU8GdBTnP1fQOhPhNTLl+VzKUqJ
MCtqdIKd2AlObjGXZFQYlW3gtJdOOt71VMfoldAxIEMMo9uheec61OncUYar
oY4BhFDESBneW/IMIXwyUIMPpqpkkv+DSoYi6JQbrWROq0pGPeoYBOAeWgb/
awCuHwygq5KBXiIuK5l5vkpGt/KpKplhTiUDcZRToVPJUCPoxFFcfXE6+BEP
OZXMMykrma8F9hODZkC3ALvSd/aAj7uJgJ7Q002YBM0nGmYtevpvRtBVi1Yq
gqXq4aG5HrMIM2G+kwnbjUDagE8IcTHmolShLGacbp67wQm4pA3dIK9nf8aL
obSEtuVN7Cb0Moxu5V3J8JngbsJYGy1N+19v8Xx////w+1t9f9sy/Z34u/8P
LvHJ/g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->346564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->807165036],

Cell["Use graphics as a frame label:", "ExampleText",
 CellID->72875948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", 
         RowBox[{"1", "/", "4"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "40"}]}], "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671767863],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347984744]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26232],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " image as a label:"
}], "ExampleText",
 CellID->121617956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ColorData", "[", 
     RowBox[{"\"\<SunsetColors\>\"", ",", "\"\<Image\>\""}], "]"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "120"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"None", ",", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "\"\<Low\>\""}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "\"\<High\>\""}], "}"}]}], "}"}], ",", "None"}],
         "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38755651],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwVACxrAQDkP0fyALj
iv//gTSEzAOSzEBBdjAvF0SygtTAAJDNwAamQcJMQBYTkGYGibDA1QEZwVBz
IFIQwI3GZ4QwIVYhtEIVMGGYCRZhRogEYXUdsioQnwW7OXCXgJWDCHZMR4BI
JgZUtYRthenC4QNMm9kwbUb3BSg8WbGIMyHph4QqLptYoHEFCRCYUpCZQahu
gGuB+YEVLQQwzU7EGiacaGEC0QASSIClDjZEaoC5nBVqM+t/RKrEJEFmpwJV
ccF5DCAuKxM7Nwu/IJu4GIe8DJeaEo+eBp+ZroCdsZCbpYivnVioi2Ssl3Rq
gGxOqHxJtGJNonJDumpNnnpliWZptXZho05eu15Wn0H6FKPkWSbxC81illtE
rLMK3WITuMvO96C913FHt9Muzufc7S962VzxtbgeYHor2OhumN6DSO3HMRrP
4lReJiq+SZF9ly71MUv8S67w9wKBX8W8v8v5flfx/64T+N0o+KdV+E+HyJ8e
0b/9Yn8ni/+dLvlvltS/edL/Fsr8Xyr7f4X8/zUK/9cr/9+k8X+r3v8dxv/3
WP7fb/f/kMv/o57/T/j/Px36/1zU/4sJ/6+k/r+e/f9Wwf+7Zf8fVP9/3PT/
Sdf/Z5P+v5j1/9Wi/29W/X+78f/7nf8/Hvz/+eT/rxf/f7vx/8eD/38+/P/3
Axroo2E3GnajYTcadqNhNxp2o2E3GnajYTcadqNhNxp2o2E3GMIO0btlYAQA
sjn9OQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{120, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414091504]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SunsetColors\>\""}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", "l"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39974837],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22999491]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21265],

Cell[TextData[{
 "The overall output format can be specified using ",
 Cell[BoxData[
  ButtonBox["FormatType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FormatType"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->41388345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Sin", "[", "x", "]"}]}], "}"}]}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36255446],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357212403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32532956],

Cell["Vertical frame labels are rotated in graphics, by default:", \
"ExampleText",
 CellID->46196138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"left", ",", "right"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108538682],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameLabel->{{
     FormBox["left", TraditionalForm], 
     FormBox["right", TraditionalForm]}, {None, None}}]], "Output",
 ImageSize->{184, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204231063]
}, Open  ]],

Cell[TextData[{
 "Vertical frame labels are not rotated in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", by default:"
}], "ExampleText",
 CellID->203145377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"left", ",", "right"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->394440968],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$1054$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$1054$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, 
      "Options" :> {
       FrameLabel -> {{$CellContext`left, $CellContext`right}, {None, None}}},
       "DefaultOptions" :> {}],
     ImageSizeCache->{299., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{303, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->350831204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186028236],

Cell[TextData[{
 "The vertical label rotation can be specified using ",
 Cell[BoxData[
  ButtonBox["RotateLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotateLabel"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->224182388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "\"\<y-axis\>\""}], "}"}]}], ",", 
   RowBox[{"RotateLabel", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->523728034],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameLabel->{None, 
    FormBox["\"y-axis\"", TraditionalForm]},
  RotateLabel->False]], "Output",
 ImageSize->{184, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19508357]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15849],

Cell["\<\
When different format types are combined the result is likely unpredictable: \
\
\>", "ExampleText",
 CellID->226240286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"TraditionalForm", "@", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}]}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41856964],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32494159]
}, Open  ]],

Cell["This is equivalent to: ", "ExampleText",
 CellID->106728617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"TraditionalForm", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23353568],

Cell[BoxData[
 TagBox[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}],
   TraditionalForm],
  TraditionalForm,
  Editable->True]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//StandardForm=",
 CellID->166372388]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30448],

Cell["Control the ellipse with the sliders:", "ExampleText",
 CellID->185334376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
     RowBox[{"Dynamic", "@", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "s"}], "}"}]}], "]"}]}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "10"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "300"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "r", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "10"}], "}"}]}], "]"}], ",", 
      RowBox[{"VerticalSlider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "s", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "10"}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"RotateLabel", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349497871],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], EdgeForm[GrayLevel[0]], 
   DynamicBox[Typeset`ToBoxes[
     Disk[{0, 0}, {$CellContext`r, $CellContext`s}], StandardForm, Graphics],
    ImageSizeCache->{{158.25, 184.75}, {-35.75, -9.25}}]},
  Frame->True,
  FrameLabel->{
    FormBox[
     SliderBox[
      Dynamic[$CellContext`r], {1, 10}], TraditionalForm], 
    FormBox[
     SliderBox[
      Dynamic[$CellContext`s], {1, 10}, Appearance -> "Vertical"], 
     TraditionalForm]},
  ImageSize->300,
  PlotRange->10,
  RotateLabel->False]], "Output",
 ImageSize->{304, 298},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153892013]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2848],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Labeled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Labeled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotLabel"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12221],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Labeling Two\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingTwoDimensionalGraphics"]], "Tutorials",
 CellID->32243],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->222040977],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->332736057],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->442174489],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->466426650]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrameLabel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 12.8609334}", "context" -> "System`", 
    "keywords" -> {
     "frame label", "graphics frame", "plot frame", "labeling of frames", 
      "graphics frame label", "plot frame label"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FrameLabel is an option for Graphics, Manipulate and related functions \
that specifies labels to be placed on the edges of a frame. ", 
    "synonyms" -> {"frame label"}, "title" -> "FrameLabel", "type" -> 
    "Symbol", "uri" -> "ref/FrameLabel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11252, 308, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->90816981]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 439066, 7967}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2808, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3431, 91, 4194, 83, 70, "ObjectNameGrid"],
Cell[7628, 176, 783, 24, 70, "Usage",
 CellID->28574]
}, Open  ]],
Cell[CellGroupData[{
Cell[8448, 205, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8926, 222, 237, 8, 70, "Notes",
 CellID->2235],
Cell[9166, 232, 326, 9, 70, "Notes",
 CellID->17255],
Cell[9495, 243, 296, 10, 70, "Notes",
 CellID->5713],
Cell[9794, 255, 567, 18, 70, "Notes",
 CellID->5621],
Cell[10364, 275, 442, 13, 70, "Notes",
 CellID->27212],
Cell[10809, 290, 406, 13, 70, "Notes",
 CellID->32304]
}, Closed]],
Cell[CellGroupData[{
Cell[11252, 308, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->90816981],
Cell[CellGroupData[{
Cell[11636, 322, 147, 5, 70, "ExampleSection",
 CellID->42267439],
Cell[11786, 329, 88, 1, 70, "ExampleText",
 CellID->406721236],
Cell[CellGroupData[{
Cell[11899, 334, 309, 9, 28, "Input",
 CellID->25225454],
Cell[12211, 345, 2700, 48, 136, "Output",
 Evaluatable->False,
 CellID->452382959]
}, Open  ]],
Cell[14926, 396, 125, 3, 70, "ExampleDelimiter",
 CellID->355586309],
Cell[15054, 401, 91, 1, 70, "ExampleText",
 CellID->513450776],
Cell[CellGroupData[{
Cell[15170, 406, 361, 11, 28, "Input",
 CellID->130102686],
Cell[15534, 419, 2542, 46, 125, "Output",
 Evaluatable->False,
 CellID->206713533]
}, Open  ]],
Cell[18091, 468, 124, 3, 70, "ExampleDelimiter",
 CellID->78564993],
Cell[18218, 473, 72, 1, 70, "ExampleText",
 CellID->799486137],
Cell[CellGroupData[{
Cell[18315, 478, 519, 17, 28, "Input",
 CellID->63028012],
Cell[18837, 497, 2827, 50, 147, "Output",
 Evaluatable->False,
 CellID->413406351]
}, Open  ]],
Cell[21679, 550, 124, 3, 70, "ExampleDelimiter",
 CellID->63018244],
Cell[21806, 555, 252, 8, 70, "ExampleText",
 CellID->194566514],
Cell[CellGroupData[{
Cell[22083, 567, 479, 14, 47, "Input",
 CellID->558268740],
Cell[22565, 583, 2905, 52, 142, "Output",
 Evaluatable->False,
 CellID->120969143]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25519, 641, 216, 7, 70, "ExampleSection",
 CellID->23213],
Cell[25738, 650, 303, 11, 70, "ExampleText",
 CellID->175125548],
Cell[CellGroupData[{
Cell[26066, 665, 293, 9, 70, "Input",
 CellID->194121374],
Cell[26362, 676, 344, 11, 162, "Output",
 CellID->122984769]
}, Open  ]],
Cell[26721, 690, 125, 3, 70, "ExampleDelimiter",
 CellID->141434770],
Cell[26849, 695, 203, 8, 70, "ExampleText",
 CellID->82479360],
Cell[CellGroupData[{
Cell[27077, 707, 377, 11, 70, "Input",
 CellID->2477946],
Cell[27457, 720, 508, 17, 162, "Output",
 CellID->331112918]
}, Open  ]],
Cell[27980, 740, 125, 3, 70, "ExampleDelimiter",
 CellID->183673086],
Cell[28108, 745, 266, 8, 70, "ExampleText",
 CellID->636303218],
Cell[CellGroupData[{
Cell[28399, 757, 642, 18, 70, "Input",
 CellID->86999437],
Cell[29044, 777, 2997, 53, 70, "Output",
 Evaluatable->False,
 CellID->23434315]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32090, 836, 239, 7, 70, "ExampleSection",
 CellID->16487],
Cell[32332, 845, 212, 8, 70, "ExampleText",
 CellID->107384665],
Cell[CellGroupData[{
Cell[32569, 857, 396, 13, 70, "Input",
 CellID->4100350],
Cell[32968, 872, 1644, 37, 70, "Output",
 CellID->94805580]
}, Open  ]],
Cell[34627, 912, 125, 3, 70, "ExampleDelimiter",
 CellID->224904698],
Cell[34755, 917, 367, 13, 70, "ExampleText",
 CellID->9992112],
Cell[CellGroupData[{
Cell[35147, 934, 437, 13, 70, "Input",
 CellID->187420325],
Cell[35587, 949, 290607, 4807, 70, "Output",
 CellID->438611511]
}, Open  ]],
Cell[CellGroupData[{
Cell[326231, 5761, 437, 13, 70, "Input",
 CellID->208618586],
Cell[326671, 5776, 28400, 470, 70, "Output",
 Evaluatable->False,
 CellID->346564]
}, Open  ]],
Cell[355086, 6249, 125, 3, 70, "ExampleDelimiter",
 CellID->807165036],
Cell[355214, 6254, 72, 1, 70, "ExampleText",
 CellID->72875948],
Cell[CellGroupData[{
Cell[355311, 6259, 966, 28, 70, "Input",
 CellID->671767863],
Cell[356280, 6289, 2860, 51, 70, "Output",
 Evaluatable->False,
 CellID->347984744]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[359189, 6346, 223, 7, 70, "ExampleSection",
 CellID->26232],
Cell[359415, 6355, 206, 8, 70, "ExampleText",
 CellID->121617956],
Cell[CellGroupData[{
Cell[359646, 6367, 777, 23, 70, "Input",
 CellID->38755651],
Cell[360426, 6392, 1013, 21, 70, "Output",
 Evaluatable->False,
 CellID->414091504]
}, Open  ]],
Cell[CellGroupData[{
Cell[361476, 6418, 480, 14, 70, "Input",
 CellID->39974837],
Cell[361959, 6434, 58052, 956, 70, "Output",
 Evaluatable->False,
 CellID->22999491]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[420060, 7396, 233, 7, 70, "ExampleSection",
 CellID->21265],
Cell[420296, 7405, 235, 8, 70, "ExampleText",
 CellID->41388345],
Cell[CellGroupData[{
Cell[420556, 7417, 454, 13, 70, "Input",
 CellID->36255446],
Cell[421013, 7432, 2848, 51, 70, "Output",
 Evaluatable->False,
 CellID->357212403]
}, Open  ]],
Cell[423876, 7486, 124, 3, 70, "ExampleDelimiter",
 CellID->32532956],
Cell[424003, 7491, 102, 2, 70, "ExampleText",
 CellID->46196138],
Cell[CellGroupData[{
Cell[424130, 7497, 416, 13, 70, "Input",
 CellID->108538682],
Cell[424549, 7512, 317, 10, 161, "Output",
 CellID->204231063]
}, Open  ]],
Cell[424881, 7525, 240, 8, 70, "ExampleText",
 CellID->203145377],
Cell[CellGroupData[{
Cell[425146, 7537, 411, 13, 70, "Input",
 CellID->394440968],
Cell[425560, 7552, 1639, 37, 70, "Output",
 CellID->350831204]
}, Open  ]],
Cell[427214, 7592, 125, 3, 70, "ExampleDelimiter",
 CellID->186028236],
Cell[427342, 7597, 240, 8, 70, "ExampleText",
 CellID->224182388],
Cell[CellGroupData[{
Cell[427607, 7609, 363, 10, 70, "Input",
 CellID->523728034],
Cell[427973, 7621, 292, 10, 158, "Output",
 CellID->19508357]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[428314, 7637, 226, 7, 70, "ExampleSection",
 CellID->15849],
Cell[428543, 7646, 130, 4, 70, "ExampleText",
 CellID->226240286],
Cell[CellGroupData[{
Cell[428698, 7654, 496, 14, 70, "Input",
 CellID->41856964],
Cell[429197, 7670, 2859, 51, 70, "Output",
 Evaluatable->False,
 CellID->32494159]
}, Open  ]],
Cell[432071, 7724, 66, 1, 70, "ExampleText",
 CellID->106728617],
Cell[CellGroupData[{
Cell[432162, 7729, 180, 5, 70, "Input",
 CellID->23353568],
Cell[432345, 7736, 282, 11, 50, "Output",
 CellID->166372388]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[432676, 7753, 224, 7, 70, "ExampleSection",
 CellID->30448],
Cell[432903, 7762, 80, 1, 70, "ExampleText",
 CellID->185334376],
Cell[CellGroupData[{
Cell[433008, 7767, 1072, 31, 70, "Input",
 CellID->349497871],
Cell[434083, 7800, 688, 22, 70, "Output",
 CellID->153892013]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[434832, 7829, 310, 9, 70, "SeeAlsoSection",
 CellID->2848],
Cell[435145, 7840, 937, 35, 70, "SeeAlso",
 CellID->18868]
}, Open  ]],
Cell[CellGroupData[{
Cell[436119, 7880, 314, 9, 70, "TutorialsSection",
 CellID->12221],
Cell[436436, 7891, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[436577, 7896, 182, 3, 70, "Tutorials",
 CellID->32243],
Cell[436762, 7901, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[436956, 7909, 319, 9, 70, "MoreAboutSection",
 CellID->222040977],
Cell[437278, 7920, 173, 3, 70, "MoreAbout",
 CellID->332736057],
Cell[437454, 7925, 175, 3, 70, "MoreAbout",
 CellID->442174489],
Cell[437632, 7930, 163, 3, 70, "MoreAbout",
 CellID->466426650]
}, Open  ]],
Cell[437810, 7936, 50, 0, 70, "History"],
Cell[437863, 7938, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

