(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22224,        762]
NotebookOptionsPosition[     17800,        617]
NotebookOutlinePosition[     19279,        656]
CellTagsIndexPosition[     19194,        651]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrameStyle" :> 
          Documentation`HelpLookup["paclet:ref/FrameStyle"], "ImageMargins" :> 
          Documentation`HelpLookup["paclet:ref/ImageMargins"], "Framed" :> 
          Documentation`HelpLookup["paclet:ref/Framed"], "Spacings" :> 
          Documentation`HelpLookup["paclet:ref/Spacings"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FrameStyle\"\>", 
       2->"\<\"ImageMargins\"\>", 3->"\<\"Framed\"\>", 
       4->"\<\"Spacings\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup["paclet:guide/PlottingAndImageRegions"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       2->"\<\"Plotting and Image Regions\"\>", 
       3->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FrameMargins", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FrameMargins",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FrameMargins"]], "InlineFormula"],
     "\[LineSeparator]is an option for objects that can be displayed with \
frames which specifies the absolute margins in printer\[CloseCurlyQuote]s \
points to leave inside the frame. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17759]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible settings are: ", "Notes",
 CellID->10740],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["dist", "TI"], Cell[
    "the same margins on all sides ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["left", "TI"], ",", 
        StyleBox["right", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["bottom", "TI"], ",", 
        StyleBox["top", "TI"]}], "}"}]}], "}"}], Cell[
    "different margins on different sides ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->24008]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->135502724],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->142919673],

Cell["Use predefined margins: ", "ExampleText",
 CellID->253646638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"xyz", ",", 
     RowBox[{"FrameMargins", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
      "None", ",", "Tiny", ",", "Small", ",", "Medium", ",", "Large"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->309605901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox["xyz",
    FrameMargins->None,
    StripOnInput->False], ",", 
   FrameBox["xyz",
    FrameMargins->Tiny,
    StripOnInput->False], ",", 
   FrameBox["xyz",
    FrameMargins->Small,
    StripOnInput->False], ",", 
   FrameBox["xyz",
    FrameMargins->Medium,
    StripOnInput->False], ",", 
   FrameBox["xyz",
    FrameMargins->Large,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{214, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->811350252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58512524],

Cell["Specify frame margins in printer's points:", "ExampleText",
 CellID->333461012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"xyz", ",", 
   RowBox[{"FrameMargins", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48884382],

Cell[BoxData[
 FrameBox["xyz",
  FrameMargins->10,
  StripOnInput->False]], "Output",
 ImageSize->{47, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150275548]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{"xyz", ",", 
   RowBox[{"FrameMargins", "\[Rule]", "15"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->685944990],

Cell[BoxData[
 PanelBox["xyz",
  FrameMargins->15]], "Output",
 ImageSize->{57, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->182256669]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33683484],

Cell["Specify a different margin on each side:", "ExampleText",
 CellID->1004445825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"xyz", ",", 
   RowBox[{"FrameMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"30", ",", "30"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->407302540],

Cell[BoxData[
 ButtonBox["xyz",
  Appearance->Automatic,
  ButtonData->"paclet:ref/xyz",
  ButtonFrame->"DialogBox",
  ButtonFunction:>{},
  Evaluator->None,
  FrameMargins->{{30, 30}, {5, 5}},
  Method->"Preemptive"]], "Output",
 ImageSize->{87, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423597889]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16111],

Cell[TextData[{
 "Frame margins in ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->48289056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupMenu", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42131896],

Cell[BoxData[
 PopupMenuBox[$CellContext`x, {$CellContext`x->"x", $CellContext`y->
  "y", $CellContext`z->"z"},
  FrameMargins->10]], "Output",
 ImageSize->{62, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430273459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110798458],

Cell[TextData[{
 "Frame margins in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->798151944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316991609],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {24., {5., 13.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$261$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$261$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Framed[$CellContext`x$$], 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, 
      "Options" :> {FrameMargins -> Medium}, "DefaultOptions" :> {}],
     ImageSizeCache->{249., {46., 51.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133970078]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->712547876],

Cell[TextData[{
 "Frame margins in ",
 Cell[BoxData[
  ButtonBox["MenuView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MenuView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->234788631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MenuView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "x"}], ",", 
     RowBox[{"2", "\[Rule]", "y"}], ",", 
     RowBox[{"3", "\[Rule]", "z"}]}], "}"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"20", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245821772],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = 3}, 
   InterpretationBox[
    StyleBox[
     PanelBox[
      TagBox[GridBox[{
         {
          ItemBox[
           PopupMenuBox[Dynamic[BoxForm`var$$], {1->"1", 2->"2", 3->"3"},
            DefaultBaseStyle->"MenuViewLabel",
            Enabled->Automatic],
           Alignment->Left,
           StripOnInput->False]},
         {
          ItemBox[
           StyleBox[
            PaneBox[Cell[BoxData[
              
              PaneSelectorBox[{1->"x", 2->"y", 3->"z"}, Dynamic[
               BoxForm`var$$],
               Alignment->{Left, Top},
               ImageSize->All]]],
             ImageMargins->{{20, 20}, {5, 5}}],
            Deployed->False,
            StripOnInput->False],
           Background->GrayLevel[1],
           Frame->True,
           FrameStyle->GrayLevel[0.8235294117647058],
           StripOnInput->False]}
        },
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        RowsEqual->False],
       "Grid"],
      BaselinePosition->Automatic,
      DefaultBaseStyle->"MenuView",
      FrameMargins->6,
      ImageMargins->Automatic],
     Deployed->True,
     StripOnInput->False],
    MenuView[{1 -> $CellContext`x, 2 -> $CellContext`y, 3 -> $CellContext`z}, 
     FrameMargins -> {{20, 20}, {5, 5}}]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{79, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185133604]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12726],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Framed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Framed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Spacings"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->411092869],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->290866592],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->26136987],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->138575565]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrameMargins - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 16.8141596}", "context" -> "System`", 
    "keywords" -> {
     "frame margins", "margins inside frames", "frame margins around text", 
      "frame margins around formulas", "frame margins around expressions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FrameMargins is an option for objects that can be displayed with frames \
which specifies the absolute margins in printer\\[CloseCurlyQuote]s points to \
leave inside the frame. ", "synonyms" -> {"frame margins"}, "title" -> 
    "FrameMargins", "type" -> "Symbol", "uri" -> "ref/FrameMargins"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6200, 180, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->135502724]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19051, 644}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1938, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2561, 71, 1577, 37, 70, "ObjectNameGrid"],
Cell[4141, 110, 555, 15, 70, "Usage",
 CellID->17759]
}, Open  ]],
Cell[CellGroupData[{
Cell[4733, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5211, 147, 56, 1, 70, "Notes",
 CellID->10740],
Cell[5270, 150, 893, 25, 70, "2ColumnTableMod",
 CellID->24008]
}, Closed]],
Cell[CellGroupData[{
Cell[6200, 180, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->135502724],
Cell[CellGroupData[{
Cell[6585, 194, 148, 5, 70, "ExampleSection",
 CellID->142919673],
Cell[6736, 201, 67, 1, 70, "ExampleText",
 CellID->253646638],
Cell[CellGroupData[{
Cell[6828, 206, 393, 13, 28, "Input",
 CellID->309605901],
Cell[7224, 221, 563, 22, 53, "Output",
 CellID->811350252]
}, Open  ]],
Cell[7802, 246, 124, 3, 70, "ExampleDelimiter",
 CellID->58512524],
Cell[7929, 251, 85, 1, 70, "ExampleText",
 CellID->333461012],
Cell[CellGroupData[{
Cell[8039, 256, 168, 5, 70, "Input",
 CellID->48884382],
Cell[8210, 263, 215, 8, 53, "Output",
 CellID->150275548]
}, Open  ]],
Cell[CellGroupData[{
Cell[8462, 276, 168, 5, 70, "Input",
 CellID->685944990],
Cell[8633, 283, 192, 7, 70, "Output",
 CellID->182256669]
}, Open  ]],
Cell[8840, 293, 124, 3, 70, "ExampleDelimiter",
 CellID->33683484],
Cell[8967, 298, 84, 1, 70, "ExampleText",
 CellID->1004445825],
Cell[CellGroupData[{
Cell[9076, 303, 331, 11, 70, "Input",
 CellID->407302540],
Cell[9410, 316, 359, 13, 70, "Output",
 CellID->423597889]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9818, 335, 216, 7, 70, "ExampleSection",
 CellID->16111],
Cell[10037, 344, 201, 8, 70, "ExampleText",
 CellID->48289056],
Cell[CellGroupData[{
Cell[10263, 356, 238, 7, 70, "Input",
 CellID->42131896],
Cell[10504, 365, 273, 8, 70, "Output",
 CellID->430273459]
}, Open  ]],
Cell[10792, 376, 125, 3, 70, "ExampleDelimiter",
 CellID->110798458],
Cell[10920, 381, 204, 8, 70, "ExampleText",
 CellID->798151944],
Cell[CellGroupData[{
Cell[11149, 393, 278, 8, 70, "Input",
 CellID->316991609],
Cell[11430, 403, 1585, 35, 70, "Output",
 CellID->133970078]
}, Open  ]],
Cell[13030, 441, 125, 3, 70, "ExampleDelimiter",
 CellID->712547876],
Cell[13158, 446, 200, 8, 70, "ExampleText",
 CellID->234788631],
Cell[CellGroupData[{
Cell[13383, 458, 486, 16, 70, "Input",
 CellID->245821772],
Cell[13872, 476, 1623, 51, 70, "Output",
 CellID->185133604]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15556, 534, 311, 9, 70, "SeeAlsoSection",
 CellID->12726],
Cell[15870, 545, 949, 35, 70, "SeeAlso",
 CellID->23600]
}, Open  ]],
Cell[CellGroupData[{
Cell[16856, 585, 319, 9, 70, "MoreAboutSection",
 CellID->411092869],
Cell[17178, 596, 204, 4, 70, "MoreAbout",
 CellID->290866592],
Cell[17385, 602, 160, 3, 70, "MoreAbout",
 CellID->26136987],
Cell[17548, 607, 180, 3, 70, "MoreAbout",
 CellID->138575565]
}, Open  ]],
Cell[17743, 613, 27, 0, 70, "History"],
Cell[17773, 615, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

