(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    125301,       3168]
NotebookOptionsPosition[    114522,       2795]
NotebookOutlinePosition[    116012,       2835]
CellTagsIndexPosition[    115925,       2830]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Frame" :> Documentation`HelpLookup["paclet:ref/Frame"], 
          "FrameLabel" :> Documentation`HelpLookup["paclet:ref/FrameLabel"], 
          "FrameTicksStyle" :> 
          Documentation`HelpLookup["paclet:ref/FrameTicksStyle"], 
          "FrameStyle" :> Documentation`HelpLookup["paclet:ref/FrameStyle"], 
          "Ticks" :> Documentation`HelpLookup["paclet:ref/Ticks"], 
          "GridLines" :> Documentation`HelpLookup["paclet:ref/GridLines"], 
          "FaceGrids" :> Documentation`HelpLookup["paclet:ref/FaceGrids"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Frame\"\>", 
       2->"\<\"FrameLabel\"\>", 3->"\<\"FrameTicksStyle\"\>", 
       4->"\<\"FrameStyle\"\>", 5->"\<\"Ticks\"\>", 6->"\<\"GridLines\"\>", 
       7->"\<\"FaceGrids\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graphics Annotation & Appearance\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FrameTicks", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["FrameTicks",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FrameTicks"]], "InlineFormula"],
     "\[LineSeparator]is an option for 2D graphics functions that specifies \
tick marks for the edges of a frame. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData[
  ButtonBox["FrameTicks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicks"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->19294],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no tick marks drawn ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "tick marks placed automatically", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "tick marks placed automatically on bottom and left edges", 
     "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "All", Cell[
    "tick marks placed automatically on all edges", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["left", "TI"], ",", 
        StyleBox["right", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["bottom", "TI"], ",", 
        StyleBox["top", "TI"]}], "}"}]}], "}"}], Cell[
    "tick mark options specified separately for each edge ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->26846],

Cell["\<\
Automatic tick marks are usually placed at points whose coordinates have the \
minimum number of digits in their decimal representation. \
\>", "Notes",
 CellID->3542],

Cell[TextData[{
 "For each edge, tick marks can be specified as described in the notes for ",
 Cell[BoxData[
  ButtonBox["Ticks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6133],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " gives default styles to use for frame tick marks and tick mark labels."
}], "Notes",
 CellID->643683418],

Cell[TextData[{
 "Frame ticks are only shown if the frame itself is drawn, as specified by ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->752782723],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FrameTicks", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " does not draw ticks in data plots where only ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " values are given, without explicit specification of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " values."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24436384]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->567260944],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->542690413],

Cell["Put a frame, but no ticks:", "ExampleText",
 CellID->439930527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "->", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24643],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->22730198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384317580],

Cell["Place frame tick marks and labels automatically:", "ExampleText",
 CellID->25360382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12988],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->795860890]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Omega]", " ", "I"}], "-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Omega]", " ", "I"}], "+", "1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Omega]", " ", "I"}], "+", "10"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Omega]", " ", "I"}], "-", "10"}], ")"}]}], ")"}]}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "1", ",", 
     RowBox[{"10", "^", "3"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149164357],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWWmIHEUUrp1rNxvvdU2M0RnjfV+oiASFxeuHShANEhOZrNFdNbtxszGa
9ch6JB6JJwEDokii4PEjYogIEcSAGBADYkBUkAgSfxgEgz8WhPJ7r7qnuqur
u1/Pzv7LsFtVb6q+d9er6p5bm+NDK1Y2x4cHm42bxpqrhoYHVzduHB3DV+Uu
pdRO/E/MVRhrjPh/p9bok20f2jIW1IO+N+hL6Evo5wV0OaBrznz4fb+zLuxV
hcUEHxcV7ZU6kVpiovmjTnfoHmoqljb8oivmRWjlma9kcvAh+jPmU+laVEK6
HApVF/VHrD9ifUxyXZt9MTvX6rnBylJiZa2wvX1RXkI7OmdvlO4V2a2qLbpj
Me/L5dvZyIc+XxD0s3S8Ms6PxCSsv74KOsdZ16q/5UC0BxOvvmknhMsh6q1Q
Irl4m1kW83a+/2nFFmXOnXy0K79FT03958ujoxy6kTOfh+8RaVlxvaTN2fiq
tmdse1yY3vvt72vGd6nXpbrl5GWLd4D8+KMf3nzjm9f83CO54GZiVcd2zuZN
ez7dsZ9tTvLpj+uF6MGifd//8Ur66u7onjx8eGpw+ScHD/6jNqcjEr47cODv
4aEdwKpNIpTJrj1f/zax7gsavixCmbgZ82n4UgEUHAG7oKcQVQ3tAgpY9aII
xSdDGepBSRq+IEJ1Mz068hniRMONBVCI1NIlH5KGMlSPo+EGEWqWo+HzBVBW
QxmK93DZ7BUaPudFSWpnOdw7kTk+98tI1v0//knDZ/3c260gMSk2ezonhUiq
naV33/luUnek6gW0qcjQFtGi/f9MWzqHp6Tr96OZNgWWhpNtc0/ubUsfw/Tk
+t1f7v6Vhuv9Ujy1thLpkxwPHfp38Z0fUCT9HN0cPlbHc/jpAihIQXr+8vNf
QtRxjmefEqGOZxrlF0WYhk8WQNkdLUOdoE2+ylezF+Bx+F09IULx7TJyokzk
Rj5x48nIXnOrtvVvnZ97gacE7dmBRgoij/iTd2dGivEcEhPpScPHOyaFSMMd
NwFkCEVvrU6vUcV1P4lpe3o9NiMemsM0SjdCQcO1fil5N7YERxw5iGw6Rzen
+UksUs0eLYCyFUuGOplpW7HWFEDZiiVDmfcJ2ErYUDQcF6FOcbyxugAK3kA+
0v1UhprveGNMhDpVx/PmES8qrQYxnVGDDHewhoAM7rFMjz45WCl5+X8a0/ae
vUogSV4hDHdbIUZ0eoXodvyTp3mdaSQI0oSGowLNi8poMI3DFkcuDUcEMgo9
LSZk2b2cIqtAJTJv/2wFXenl6Gb2AqbtrfnhAih7C5ahzmD6/e37tr61l4YP
iVBnOho+WABlNZShzmL6810/bdzwFQ2HRaizmbY3rqECKPtULkOdwzRcgQpL
dj0gQp3r2HW/CHUe0/Y+saIACrpBQ+gpRJ3veOM+LyqrwmbtjQuYBl9wp7Ni
0M99WtXjQqZx9qGAUGSWz4CMi5i2VbDZIRlEXuzkyDKdXr2rOu0NuvuUdUnI
FRqTV+4VaOy8FRP65tLQN/A/xXiZX1Ikg7p1/P2vmzWXhRFFJlNOLvVydDP5
cqbNXR9YdY8IdQXTOA8gC+VRLRGhrmQaFRWy6A3Y3SLUVRw17E3sBsiCsxaL
cFczDlGEQBzxCOpdItw1HE/YhszCcQc0ZcIdIuy1jIX3oeii27fhbKOaskiE
XUhNDebhUISDoDKYAH6bCH09T8Grxr03DLyNCo9nXcQU6t/iz67EL7exjM2o
UAPUzAZjnCEQgiyAQBhs0sGIJcsHvHJdSZzkbdxKbmYcIgVpMNsoAuNL1y3c
qiqIHUj8wREVzPG+xkrK8ho1ZfOTgm5Vqk7qSWTd+d77W0SF9qpSUAi+NHoi
8YzmqkoNIeBeMqpODdHoadiLxla9Tvk1T++GxK6M+el7d8u0bX7PfJ1xY93O
U2m/mbXXqq7/AVC670Q=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->160901242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->610285637],

Cell["Place frame tick marks at the specific positions:", "ExampleText",
 CellID->28686972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", "None"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi", ",", 
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"3", "Pi"}]}], "}"}], ",", "None"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259399820],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->16420839]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->254457233],

Cell[TextData[{
 "Specify overall frame ticks style, including frame tick labels, using ",
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->108500934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3077879],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101247976]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13110],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameTicks Positions and Labeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23626714],

Cell["Place frame ticks and labels on the all edges:", "ExampleText",
 CellID->89028187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199535740],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725462071]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->805736338],

Cell["Place frame ticks on the left edge of the frame:", "ExampleText",
 CellID->333949031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"All", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1917372],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280821878]
}, Open  ]],

Cell["Place frame ticks on the right and top edges:", "ExampleText",
 CellID->490055490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "All"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"None", ",", "All"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->420657077],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39153386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->323192075],

Cell["\<\
Draw frame ticks at the specific positions on the right and bottom edges:\
\>", "ExampleText",
 CellID->138014992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], ",", 
          RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi", ",", 
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"3", "Pi"}]}], "}"}], ",", "None"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21168231],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26506796]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355108754],

Cell["\<\
Draw frame ticks at the specific positions with the specific labels:\
\>", "ExampleText",
 CellID->58219888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"0", "\[Degree]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"180", "\[Degree]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"360", "\[Degree]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", 
          RowBox[{"540", "\[Degree]"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->716482942],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->624891500]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameTicks Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->452036478],

Cell["Specify frame ticks with scaled lengths:", "ExampleText",
 CellID->101010188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"0", "\[Degree]"}], ",", ".2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"180", "\[Degree]"}], ",", ".2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"360", "\[Degree]"}], ",", ".2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", 
          RowBox[{"540", "\[Degree]"}], ",", ".2"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166334252],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298427818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->486785948],

Cell["\<\
Specify frame ticks with scaled lengths in positive and negative directions:\
\>", "ExampleText",
 CellID->343485730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"0", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", ".05"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"180", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", ".05"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"360", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", ".05"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", 
          RowBox[{"540", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", "0.05"}], "}"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198058241],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70988772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114741329],

Cell["Specify the style of each frame ticks:", "ExampleText",
 CellID->4603537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"180", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", ".05"}], "}"}], ",", "Red"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"360", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", ".05"}], "}"}], ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", 
          RowBox[{"540", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", ".05"}], "}"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Dashed"}], "]"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278680862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180050977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25285280],

Cell[TextData[{
 "Specify overall frame ticks style, using ",
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->658564593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->955546046],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12349229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73404585],

Cell["Specify frame ticks style for each edge:", "ExampleText",
 CellID->5392742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Black", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Green"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->747103243],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->677507713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->537694265],

Cell[TextData[{
 "Individually styled frame ticks can be used with ",
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 ", and have higher priority:"
}], "ExampleText",
 CellID->232700368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Pi", ",", "Pi", ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", "0"}], "}"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Blue", ",", "Dashed"}], "]"}]}], "}"}], ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", "None"}], "}"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80169133],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->304061931]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19211],

Cell[TextData[{
 "Specify a frame ticks function applied to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " values of each direction:"
}], "ExampleText",
 CellID->814353806],

Cell[BoxData[
 RowBox[{
  RowBox[{"fticks", "[", 
   RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "i", ",", 
        RowBox[{"{", 
         RowBox[{".1", ",", "0"}], "}"}], ",", "Red"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "i", ",", 
        RowBox[{"{", 
         RowBox[{".05", ",", "0"}], "}"}], ",", "Blue"}], "}"}]}], "]"}], ",",
     
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Ceiling", "[", "min", "]"}], ",", 
      RowBox[{"Floor", "[", "max", "]"}], ",", "1"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22894193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "fticks"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->545912847],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, 2],
  Frame->True,
  FrameTicks->FrontEndValueCache[$CellContext`fticks, {{{-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}, {-1., 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm], {0.05, 0.}, 
       RGBColor[0., 0., 1.]}, {0., 
       FormBox["0", TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}, {1., 
       FormBox["1", TraditionalForm], {0.05, 0.}, 
       RGBColor[0., 0., 1.]}, {2., 
       FormBox["2", TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}}, {{-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}, {-1., 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm], {0.05, 0.}, 
       RGBColor[0., 0., 1.]}, {0., 
       FormBox["0", TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}, {1., 
       FormBox["1", TraditionalForm], {0.05, 0.}, 
       RGBColor[0., 0., 1.]}, {2., 
       FormBox["2", TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}}, {{-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}, {-1., 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm], {0.05, 0.}, 
       RGBColor[0., 0., 1.]}, {0., 
       FormBox["0", TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}, {1., 
       FormBox["1", TraditionalForm], {0.05, 0.}, 
       RGBColor[0., 0., 1.]}, {2., 
       FormBox["2", TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}}, {{-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}, {-1., 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm], {0.05, 0.}, 
       RGBColor[0., 0., 1.]}, {0., 
       FormBox["0", TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}, {1., 
       FormBox["1", TraditionalForm], {0.05, 0.}, 
       RGBColor[0., 0., 1.]}, {2., 
       FormBox["2", TraditionalForm], {0.1, 0.}, 
       RGBColor[1., 0., 0.]}}}]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->728302907]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5163],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " affects frame ticks and frame tick labels:"
}], "ExampleText",
 CellID->242285675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404749038],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WkuMFUUUbd5vmP+bGQYGBpgPMODAMIDIIN8R+YiEGBcGlLgYiTosFIK4
0Q1sdKMm6kLYyMJP4meBkWBMhsRIYiQxkhhJjJIYTAwuJCYSFyQm7b11q/v2
O1X9+s3PCbxXt7rr3ntO3XuruvodHDs1/vRzY6eOHR3r3Xdy7MT4saMv9O49
fpK68nOCILhI/9/oCqgdUsv8vxiG9O1+PsOfBb7D/FHjYfP1LH/mpT+Ie8cT
vdzcH/fmMkam2Z/aZ7+xGAYL6btgv8lmGPnVlbjO3yzz5ZyV80ZLn2CPR1Xq
Yd5Q7wJnhNvT5fSwVZ6KOfydYnkRWJpvkbnaZspiN1js9GF37ESsTt/e/IS2
vBfF1HD59eQ8HE+Nyf6ENp/WZMwlv/NhMvbcmO6yM37WSBiJRcMS/eVNPpu/
wiTltmmOn648I/YLKgdmdoKgwzKXh5kohJW1LQxKvjuqyF6N05WLIt+69fe1
73+nT0Exg1ZmxetEVkS8Y0bn7Tz4MsLRV3f9xz+OPvXpocc+PP785/RJ7avf
/ha0wL1dHl0Fm5d+D5Lr03Yjf/D+tWPjF375+U97nVovnrpEvcG+kLM7SGS3
WwGKoHObkc+/+925s1e5KTFFAnVxc4+jM6oIJdC01ciffPzD2299w825RiaB
uri529HUZzXJSGKQuLt799+gwcgEiijk5i57Xy4elbR7v5Hv3LlLnHP8NRr5
9u1/njzyEfUGD3rtuhoIM5HIzSYjf3bh+uuvXYnsV9ewOZoJ8oGbMu8kUBc3
H0jFLrZffunLK1//qiOJC5pjbo5GMSHGAr/9EbBfBq2jmQhGYEQZNGZr2ASe
t4PGnTVq0BHtoNGvgVncBN7OA/63V42g+4xMk01TrqPJCXKFmzsyPd8YxRyl
Pkew7D6oRTL11qxBs8fsJygH/SMZi3hNBijooxHGh0cfeS+0mZ2O+V4jU4JR
moVxZdKc2+bYjXY2WEFE05nTE5cnbqgmZc9EeEFgGUXWI6yrBdC7AThdCJya
nCvG0SGqa1hDWdwAbIsvWqtGEhHBuac81uY1uUSOqWaN4U2AIufwnGVhvZFp
0kkDNxcbmYrdzZt/aTQr/1OzwLG3xPRTUbRrg2jW/HQ1J9eGXMyz+rYYYhTz
Jt47VK1268LKbF9qZFo8aAeiEan1O+/46deoK4Bo/OLST6++8pVq1FmtVaNm
p2ik9YiQM9INMIuFTI3DEEm9YWXGrofZ8mvkWUG0vYB2vQdteiUZBqS9gHQd
IC1mIl0LSPsB6TAgrVWjIu4HxMOA2K+ROUC0/YB2rQdtOndDgHQ5IB0CpKVM
pEOAdDkgHQKktWpUxMsB8RpAXJfKHaIdALSrPWjTuVsDSAcA6WpA6voVPfPi
irYGEA8A4kFAPNfR7J4pYI1dDVysAi7uCStrmGujIZRzqma/LX1SpGo9CFyt
Au1iTSuoaw05yoHc5PXizXhF5vFFklr93hZjTeKk9VD5GQQPVwKCesfjueBh
S5ZlMWYtK1eDYGkleOJajk432pPxVYrt0J/E1kqIM7Gkq+MAyA2OpSizZDZ0
B7vCyLTo0tIbxhGtPq/wsAeZVuEvDaPB7A/vC4Zg9ArQ7vfTjZ4D+89TUoVx
TdF9AtaUuObQEG421miBSgEVBG4uA0akTmt1kOtaPfwW4hOvxM55mWUFVyXR
qBnd4HLs+EvVheaan1qXASO4ruC605TJSB4Y6QNG1gEjfcBIrRYkViINzAzu
TPqAGb9mrcwEkZKAm73ACu4tcO8hT/JZ+0mpzZo9PcAM7ul7gJnmTGYKwEyP
ZUb2lfocIpo1k7I1I0NLgaH4KcrWkKUgt9RoQdmRpwKtzBvBZ7mu1cFvQU+Q
VJOM1Mq7ETQt8bDjzi6v6nnPilsCZuRZRKsvPovgs0qrgyPrvK4Ecd8NUYDn
Hd1w/1Qtqs/dMHdiUZ8Nu4GT2iyyWBdW5nD8dE4VmtkbiWT7nIvPwS2hvsPK
xiXWLk/cOHN6Qq1pZGyGyJHrWuvKk2ayDvCIRj1REotaI7rg/jbHYtpuE89J
zXucxNPtlrCy+sh1rT6upSi/6kHTAoiGLcCiXNf8KofVVqx68Cs+87IMbAV5
PnjT7vXbtaDR2gn+bgPmOkGu1YJGaSfMsljQ9UVOBnV96UjlXk6hNZc7jKy7
hh1hZe7LdV0J2qP4rLpyyUm51qwO0LoDrLYD3nmZDDUCp20wi6PAWBvgqNWC
YmgDDKMQBWXPnFW30AQYWgHDLsDQChj8FniWm8H3VsiJXWCpxeN7eoY1gx/N
wMRuI+vJK1/nXcWCTEaaIz/IL6phliH1aw/gkut0J93PcraFlgg5kcEjMI72
hpVVrBGY81tgrsqQWZLDuqo+BPFTb1mJ3lz7uS4Dl3URYnKJ9+PmtyGc+SQz
Y1K1K1ck9wyg4NmHxPFLLtJ4u2ZLjPD7qwOhrTn2LV8pskT3M5OLHEvJ81yu
GGjRZFSBxpKv9I+UGg4KZIMmRAAeND004+QFkUUNuYdullE0vNuxnPbO1NSZ
evKZtO3cfo5WAAokmnlSYn3EkfhW1VTaEnlClZaGkxK6RgoXhck3pothlPis
yCfxjtw+ic7K2+ZZlNFfeY60YIihyf5GIO3tuI/p6f6CY7rj/295Vvz1/ALE
PT18J4zynCuY/KbG/c3NibAy73FPa3ZkwXHoxf2o2RUGh0I5r8vbeWbP+EhI
bjd/toE5Fzh2zRvA4LD/vooeV1d17UGqtcc9KHM1WsD6iWedYuEJz125aPSM
WDhiHI97U/mOLEdzo/cW7BU/R0c8XuSjYfEc52KShXKwn2p7q9dGGeQ6r2eH
vMg7PHPqRu5hi6IBruJ5sD873KwK5vwHNBW87A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217641201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172046868],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " offers overall style of all the label-like elements, including frame tick \
labels:"
}], "ExampleText",
 CellID->287688071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->852841955],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49379387]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " can be used to together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->16302533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"FrameTicksStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610817034],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->86410236]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->468017888],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " affects the style of the frame, frame labels, frame ticks and frame tick \
labels:"
}], "ExampleText",
 CellID->2867181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", 
      RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82910697],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->397629634]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " can be used together with ",
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " and has higher priority:"
}], "ExampleText",
 CellID->271652939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", 
      RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "Green"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131785817],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235521623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11991344],

Cell["\<\
Individually styled frame ticks can be used with other styles and have higher \
priority:\
\>", "ExampleText",
 CellID->145936691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Pi", ",", "Pi", ",", 
          RowBox[{"{", 
           RowBox[{".4", ",", "0"}], "}"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", "None"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69778533],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->82318519]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79769809],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Ticks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
 " controls the ticks and tick labels on the axes:"
}], "ExampleText",
 CellID->19748360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155246595],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  Ticks->Automatic]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->156314720]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173024789],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 " to get frame ticks that correspond to date and time: "
}], "ExampleText",
 CellID->182480779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"FinancialData", "[", 
   RowBox[{"\"\<IBM\>\"", ",", "\"\<Jan. 1, 2004\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180372752],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9XOuvXFUVP51zzsx9FFpAnpa2KqCIoP/AnZn77Asol0oBKWJFhUYoCG3w
izExUZHoNx69c/u4LZdSxIAEBGKCITEhmmD86mf/kePa+7f32uuss+ecmdsr
zXRmzszZe6/Hbz33nnvP0RNP/vjpoyeOPX50957njj775LHHn9+99Mxz9FG6
JUmSD+j/r25I6H1B7+z/D4qCXuXzND1n9FWLXlv0mrrXzHybmjH2X7JjyH3m
2ty2c8j3/rXue7lO21K11Tzn+JSf7Vh/L1/nPNZ9umv0sWJdfb1j7Flis44x
SxZGJcmEfbmi8nnT+qnnf+RRMd5vHnvdDc5Q0V3Hvl45ymoVqX5lTBr19c4x
xsfmG2n85XAsad8Iv2OOsdejjhnCl/EuSVvioBlPntad44wtYW3XFzOyhn7r
Pa0Xi/lC7VtvrrnPS2Ij35tXswx8atX3t7XU3bg3w7cVvWpO1+3nnYokY9Z2
ni63jHG/uWFafT65kWvHxRvr/+7NrPzh93/H+pc7a831lLruOE2Mw335jm+r
OyCXBx+4SBwtzp8GcsX3d0Uo3MIU5EUzziN0fP7556CD3kg62v/8x3+fOf7+
Rx/+h0W8Q913l7ou09N28vEIzN2rhTAGVWa4UkmgacUJNydWvLqRM8z/kx+9
Q/MfWl5vnL/MUfP8iO4QGB7jr9AkI2gHa+zbc9Ys0x289OKnyLqCPVy3ybKz
6+Z371+j+We7A2ADuV7geLa32rTuuDIFv3uXDKf93uDkiQ/pzWOPvg0cAyv0
mJ+trHxdmTYSypc2R/rZffdewJJz/dUWvUsykGU+nMMnKS3nxlwTpYspJ6Br
ujakG2OxDz/4JiZdmDtNmGhbSmiBWkpe/O2nGPTs8febJTQKJdIC+t0Vuswt
JXsWzxBozC16nWaZbIiSnGe0j1NJaujI+zMD/tTYyrVRakie99/3+ihyaZep
KeD5RvF4oJJWmu+vwpRJc47KhdnVH/7gbUKZ84aayuuLsresR5HODHTG0hwX
bATMgfR+dwByE4v2Tn9m5Z4Da5DoCyc/ct4hLldGB43QtrKtVs46xutKc0Qe
0jkI2wjZWq/jxvivwfUxmlPGEXSTkqPbNIpTi5Eww51Rmi+c/9eB/WuECUg8
W5g/7QxsZgVSnJ8duBFRuaeEMuJP8ND192seyshRuU0R4nm9rG3Fb6xo0ZJK
RgcvACcVszsgmH0ptCP4qpe1omhYDt8cwaeR+7zy8mcACgmKWXC2BpnI2DKl
ZrIeysVjwpfjBUgjh5JcVcuLz550XVDnS7Zb1XHexkzgEhRLD6spvkpQzChp
Ly2eccHXM68pHzda7bJ3IAuDMOKUINcwRMDHAK+IVuyYG+Q4KjXsEYbKBTE/
yIVUDmEOlcv42cV1QgPGPhBXTjz3F7pG7IzTRqoGFY42QpnS/uXq7Noy3olb
xJMQfaaj+AftnjKdoY2rq2sFhikXJL5U/vnoI2/piDIRo6vNdkAekdwq5UrN
tDVpD9RxFkYkpIJeIAWel9JXN8ZaZYfnKGRFa32Ri7ck4UePvGViaq4wsv0y
NSvjm9GjpdlkJJR7HLz3PJBntTdZoXVp4YzzbpZWE1GctttlvZCUNZ3j6p5j
mKw8Us5Gkgz+dWZFSjaX1BIRLnYe+d4l0EWK6Agpg37KWBOJbvZAAlVbLxst
qAwRkH2ssxJuS5op6lMCaL4DnSzhnq0/HJ3B/lsq49d0VnNC2V1qjulfFujj
9SZmeysPHb5IkYLsSEIY8/Hog/ectxVJm7hWYEfHccnnNPQwOgbP7ENIzebT
K2tlv/E+yA7BW8yyLAJz/p6uCDWI6zlFImbn2BPvVvSQqrk6Vg6HltdxzeYH
qvbZgAvTs/6rVMcY2jZPBjr7vKko+4O4FFwfwGbBFDshhQnwK8Niz6osF3MY
mU3QN6AF0dzEcXDOUZYe4JzzR6xX4TyO6Gq3rZr7Qd/Bo8Q5RfKD3OORhy9B
s1P06QOH1uGSC5+UwJjpVljlS7/7IJL7UYgCdZOc35BCfT/nHIzI9Ti5MpcR
4f+A/Kivzfc5zo1HZd8pMO1s1sYApx/ynJaKqeD5ZwYkK0iGBEASu/fu89Kb
cr1bySV45or31VnQZsnB1n4dZeEIE5U8EzLynSCDjqX5M45Stmsno37Jaw+A
xe2lLon1iIxFvAfu0Rkgc0KEu3953fVQIIUQQVoCZQYt9VKK+X4ds6StY1Jj
63adNmuDxaUzQBmxf/mLv1orQNfhwL41sATNZzwXLQUsUGxzs2RiFpOJgMuQ
abRURmUtJ6O4SbCjKoFk6Ct2X0XqjLApY7KomJaeiWb3KnXCJuxWUKrXgT5C
fEGvTNjPAMYPjtn2nXXA7mi0kxlXLMQ6RgCrrCHD8d7FM36GK8Q9QW6httbU
NuVnVirGO7NU7AeWNgr07LA1CnEdbF1KxdMVzb6yXncFyCeRdRhLfYWEij3M
nHIrQ978PWQVqamacznLe/s3v/4bJiNl0nsipC0s0PiMOAJCxJkq21dP5J6m
m3v3/nMECgRSUpT2JV3jGhyX3z/yllujFZUKh1CBheH+dUMWkpe7vj7qUWJI
Lt6v3GQTkMhcb7XkL20euBV3vXDyI66v6OMD+85BbK+9+jGtE41Rpncm8+M2
eQ80EHp+98RKpA0bn+sPOF41Y6Msie2KH2A0dDKQ9xF9Mkma6w+RS9lK4Ac4
5wBOtvI9XIwVIpDQjMQLpIJhdmLLivRoJBFZViPLCrUszWrmGN9Stik+IA+/
svP/KcRg4gFiHJWezkJGsqCUrG9udvX4U+8578/fO96R+9EsaKKanRELa/jY
BdthJ5zxMKtF1yOY7w8gWVLn5Jh2ATSEHFfGsqOP/dFxT+vTNaVFjnuAb7j/
COi60aMbTLn5kXfynrirHbCKkdk13r/gmnGjuRsN674SGACPHY5LS36zh/h3
MYuMjt1vE+JvjFrS8sG1nujACiTcUJSzoWZuNFaB+ZC5dhGHMo72Bk32E+Gx
T6XK/7ajfAUM3Bi1iPXXP3F8fNVeo+Y1tUI95mS94/ecylraJrTEHnASzlNm
uj7bHzifGfqdmfKpcQ6V5iZkLsvr0KBb1N31eqr29Jv3rbYp+q2GJmh1hird
wFu4qMXQ7yLf+srLn7ncsuurrk6U34A8nIxjjpjHcMdm8KjrdOyuIJ8j2/a9
RVODy6KEicDZH5n9BCsKs95mdSdxIUPJd9Td5TMwHot5o4aspU2zp6CQPue3
P2mhcD4D2QBsAYHeWJCmGdINnsJ2MCY4ezz2xLvMDOsm3D2ubuR5lghXwVvQ
M1c3zCo4ksHf9DTiHAUbucnjCbVgqRKnUcnl2lRsn0x7R10/WK+Q0WpQDzlA
8Aa87N97DuY1hLfgD21HsSO3mNBLY75KHfX6zNQjMBOvER2J/V/kg31ytTat
YhHCurgGo5W119M6knywfTk+bi1kpFwdpdbqSKpVzTjN1S3v7xS+VbFn8azx
OKCfvT7v1zTpAa5jtlvWA+hnlzk2/UFKVyv548QU+2oyek0nqiGWAE8FeoG2
hblVTn0DvcH/NtNr0Z5jeJCJRXRplxc1GFsBPahIc1zIWjjOBfskNEBoiWg/
XVid7sxFMs4hkgbtXOP53rKqj2EP/fK+jaZb9CJ0fWVjfUd2p5EJGS3oaFGL
EiStaG65c6oyCoW9G6CyMJXfms69sNsRcqdaLXQHRx6+JLTQkfoLttvMBbAj
q1/OV10vEdU3uuXcQ85ZirTw8sELQ/ZugkbH1Y2NGrZL0R9Q9ISXiETxCKZc
LDBdrVTN2qpoHL3L0HcKdSYQF+xQVZV+h6jCk953CzPuUvePcLrQYcxkeEcv
ssMMtdiciKkZkgWcntPnq6K0lnr0/e4pl7+PSqHvuvqIFevCIoLynlCi+5l6
Z9TS6XY+Q+SwNX+bPVffbyFqer9WhDgfq0FrzwYN67K3lZ1zPFVZuuhH6rMQ
UvrcbaUIdx73+5OYoncQ5yzEnvqo4E/gYGHBoM4q5vq2xyD35Tk/StlbVfbZ
JT9cITu5mz0Rbc1RbjLeGyURxTKtje8Jpp4n2Z8cxPaBovjrsKbga48/9Z4Z
myl7jnMlTylprso1x1h7PeG+Ez97Gw0jcMgoJPhRYuU4pFRqBCxSteLuP/zd
NwSWb41yxnWmP5G1ObtYQ7JFi9RcrkmcWurQLQnnNyRHxpPbPmWK7XymXnNT
OudLvoIuYZXcSaYBbSW7VjHSLpTLxYK9oJfFK/YtpND1yTinoQW411fY0xN0
H/rQZKaO9ltivFR2G6qZUxiRCZTCDupysmAZGMe+lSbQtmRjTqgh6QvmB6xT
WgMbOrB/zfWBo0izZ0K6oecdzrjSqCg/woLLOqp2/nBqiT2pBBiyjlyeRfda
tyvCmZT6vka7X1cUQUcqOuQc80BGUo8tndfrXmLom+4sY6uHfmbLS563BVLv
F5zkb4tR3QmnuW2YLZ1XCvem5TUBgWS03N5qvLRvZHZJUJtwAdMLO6zfUGvb
8fKsxSmd21jqXJbHO8oF4l8zzltKL7stZdgGYhDirgnGRA+99vnTyL6iNBtc
7Vk8wx7HaVLTLXMyJ9jazm8mPICRL+iVvTKzFuSLBKbnm1XJHYoCYCJkGcAM
t59cdhbyZ8xSt4uAEfosiMWsOF8p9/CWD65V9ne/GaWTbKBEZ6h70CUyWHbb
I6sRrzAl6SzKDWVyoLp22CHk3GerJtmefP5P9BYuLfmWohS+Af2/wGnoToBS
tqRDy+sRStuKUsIcS0z6SZGb7PASwEHafXvOcubdw06tPqkPSjHC2J7u0+XC
qliTJXT6+Od/58nxMGPKKUHh+tEJpbtiYiFyqXAyInVPfv9bI/V2KxeWKws0
95b20OGLHIYSlfM3/QpDy9tTbep3brDYSNVhCnq28+R8spYtqJWnwbCf0PHU
ciMsSNPn8NE9A00huUNQyLuz9AaxlM+ql6w5JlNrZTnfT1Axep8uNtjvn8TM
5pdIB81+NWKq65LoekZbW5w2vp8eP3/hHdsnatXQNrzfDX8o0WxwghiIDiXV
rH7nzBy0qOjUUjRB97KrJX/FPmSiQWrNv+5olbUB0FkrNbLSlfkd7vMke+3V
jxkBZSpiHWaZY2Aqk0Hr3wkhS3N9bsq4Y6snHd7JLsXTTlHJMDV6SWruBHR3
pbQi+h5mFr2i9bMuGz38wAWfvQt050WjHyU5ZcrP6KxIax3rsp8ykcX6M/Rv
yx2LSDY3yWsj70R8wjGORGcN0bVFLMEuRqFO4NZF49RL1enm9lFWnIY3XZhf
JSKxOuqR0Guuclt/RlOvY6+nWHrSITJvQyRac0o9voraW8Mz/+yvSYIjcSLq
F8b1UFyMNz94DD3v3EfTwv+rzxabZITv9y6dlvPLrijP7v6ohPvn5Tb6afzo
ytn66594Jz/wv/TzPqGcGVVPSY/0F1Y2IG3OmisdoM2gqOkXlFGaOjhL0u8N
nv7pn41Bzq76MzStL15CbdIaojt+1O927DZRV0n1L07cqa5BCV2rI0ObT8mm
/A2QL/B6ynPAfrUck5EE45/+my3GjsPfSan+zZbNek62/A/ISMWS\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235445876]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11783],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameTicksStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameTicksStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ticks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ticks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridLines",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridLines"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FaceGrids",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceGrids"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5832],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FrameTicks",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=FrameTicks"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->326074885],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->24063051]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrameTicks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 19.8298618}", "context" -> "System`", 
    "keywords" -> {
     "frame tick marks", "frame tick labels", "plot frame ticks", 
      "graphics frame ticks", "graphics frame tick marks", 
      "graphics frame tick labels", "frame ruler", "frame ruler mark", 
      "frame ruler labels", "frame scale"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FrameTicks is an option for 2D graphics functions that specifies tick \
marks for the edges of a frame. ", "synonyms" -> {"frame ticks"}, "title" -> 
    "FrameTicks", "type" -> "Symbol", "uri" -> "ref/FrameTicks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12208, 329, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->567260944]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 115781, 2823}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2551, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3174, 85, 4194, 83, 70, "ObjectNameGrid"],
Cell[7371, 170, 480, 14, 70, "Usage",
 CellID->11540]
}, Open  ]],
Cell[CellGroupData[{
Cell[7888, 189, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8366, 206, 218, 8, 70, "Notes",
 CellID->19294],
Cell[8587, 216, 1995, 51, 70, "2ColumnTableMod",
 CellID->26846],
Cell[10585, 269, 177, 4, 70, "Notes",
 CellID->3542],
Cell[10765, 275, 240, 8, 70, "Notes",
 CellID->6133],
Cell[11008, 285, 256, 7, 70, "Notes",
 CellID->643683418],
Cell[11267, 294, 244, 8, 70, "Notes",
 CellID->752782723],
Cell[11514, 304, 657, 20, 70, "Notes",
 CellID->24436384]
}, Closed]],
Cell[CellGroupData[{
Cell[12208, 329, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->567260944],
Cell[CellGroupData[{
Cell[12593, 343, 148, 5, 70, "ExampleSection",
 CellID->542690413],
Cell[12744, 350, 69, 1, 70, "ExampleText",
 CellID->439930527],
Cell[CellGroupData[{
Cell[12838, 355, 304, 9, 28, "Input",
 CellID->24643],
Cell[13145, 366, 2312, 42, 114, "Output",
 Evaluatable->False,
 CellID->22730198]
}, Open  ]],
Cell[15472, 411, 125, 3, 70, "ExampleDelimiter",
 CellID->384317580],
Cell[15600, 416, 90, 1, 70, "ExampleText",
 CellID->25360382],
Cell[CellGroupData[{
Cell[15715, 421, 314, 9, 28, "Input",
 CellID->12988],
Cell[16032, 432, 2667, 48, 118, "Output",
 Evaluatable->False,
 CellID->795860890]
}, Open  ]],
Cell[CellGroupData[{
Cell[18736, 485, 833, 27, 47, "Input",
 CellID->149164357],
Cell[19572, 514, 2185, 40, 144, "Output",
 Evaluatable->False,
 CellID->160901242]
}, Open  ]],
Cell[21772, 557, 125, 3, 70, "ExampleDelimiter",
 CellID->610285637],
Cell[21900, 562, 91, 1, 70, "ExampleText",
 CellID->28686972],
Cell[CellGroupData[{
Cell[22016, 567, 717, 24, 47, "Input",
 CellID->259399820],
Cell[22736, 593, 2451, 44, 124, "Output",
 Evaluatable->False,
 CellID->16420839]
}, Open  ]],
Cell[25202, 640, 125, 3, 70, "ExampleDelimiter",
 CellID->254457233],
Cell[25330, 645, 267, 8, 70, "ExampleText",
 CellID->108500934],
Cell[CellGroupData[{
Cell[25622, 657, 383, 11, 28, "Input",
 CellID->3077879],
Cell[26008, 670, 3157, 56, 138, "Output",
 Evaluatable->False,
 CellID->101247976]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29214, 732, 216, 7, 70, "ExampleSection",
 CellID->13110],
Cell[CellGroupData[{
Cell[29455, 743, 253, 7, 70, "ExampleSubsection",
 CellID->23626714],
Cell[29711, 752, 88, 1, 70, "ExampleText",
 CellID->89028187],
Cell[CellGroupData[{
Cell[29824, 757, 312, 9, 70, "Input",
 CellID->199535740],
Cell[30139, 768, 2958, 53, 70, "Output",
 Evaluatable->False,
 CellID->725462071]
}, Open  ]],
Cell[33112, 824, 125, 3, 70, "ExampleDelimiter",
 CellID->805736338],
Cell[33240, 829, 91, 1, 70, "ExampleText",
 CellID->333949031],
Cell[CellGroupData[{
Cell[33356, 834, 480, 15, 70, "Input",
 CellID->1917372],
Cell[33839, 851, 2689, 48, 70, "Output",
 Evaluatable->False,
 CellID->280821878]
}, Open  ]],
Cell[36543, 902, 88, 1, 70, "ExampleText",
 CellID->490055490],
Cell[CellGroupData[{
Cell[36656, 907, 481, 15, 70, "Input",
 CellID->420657077],
Cell[37140, 924, 2957, 53, 70, "Output",
 Evaluatable->False,
 CellID->39153386]
}, Open  ]],
Cell[40112, 980, 125, 3, 70, "ExampleDelimiter",
 CellID->323192075],
Cell[40240, 985, 124, 3, 70, "ExampleText",
 CellID->138014992],
Cell[CellGroupData[{
Cell[40389, 992, 761, 25, 70, "Input",
 CellID->21168231],
Cell[41153, 1019, 2887, 51, 70, "Output",
 Evaluatable->False,
 CellID->26506796]
}, Open  ]],
Cell[44055, 1073, 125, 3, 70, "ExampleDelimiter",
 CellID->355108754],
Cell[44183, 1078, 118, 3, 70, "ExampleText",
 CellID->58219888],
Cell[CellGroupData[{
Cell[44326, 1085, 1007, 32, 70, "Input",
 CellID->716482942],
Cell[45336, 1119, 2990, 53, 70, "Output",
 Evaluatable->False,
 CellID->624891500]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48375, 1178, 239, 7, 70, "ExampleSubsection",
 CellID->452036478],
Cell[48617, 1187, 83, 1, 70, "ExampleText",
 CellID->101010188],
Cell[CellGroupData[{
Cell[48725, 1192, 1051, 32, 70, "Input",
 CellID->166334252],
Cell[49779, 1226, 2945, 52, 70, "Output",
 Evaluatable->False,
 CellID->298427818]
}, Open  ]],
Cell[52739, 1281, 125, 3, 70, "ExampleDelimiter",
 CellID->486785948],
Cell[52867, 1286, 127, 3, 70, "ExampleText",
 CellID->343485730],
Cell[CellGroupData[{
Cell[53019, 1293, 1312, 40, 70, "Input",
 CellID->198058241],
Cell[54334, 1335, 3221, 57, 70, "Output",
 Evaluatable->False,
 CellID->70988772]
}, Open  ]],
Cell[57570, 1395, 125, 3, 70, "ExampleDelimiter",
 CellID->114741329],
Cell[57698, 1400, 79, 1, 70, "ExampleText",
 CellID->4603537],
Cell[CellGroupData[{
Cell[57802, 1405, 1192, 35, 70, "Input",
 CellID->278680862],
Cell[58997, 1442, 3092, 55, 70, "Output",
 Evaluatable->False,
 CellID->180050977]
}, Open  ]],
Cell[62104, 1500, 124, 3, 70, "ExampleDelimiter",
 CellID->25285280],
Cell[62231, 1505, 238, 8, 70, "ExampleText",
 CellID->658564593],
Cell[CellGroupData[{
Cell[62494, 1517, 436, 12, 70, "Input",
 CellID->955546046],
Cell[62933, 1531, 2997, 53, 70, "Output",
 Evaluatable->False,
 CellID->12349229]
}, Open  ]],
Cell[65945, 1587, 124, 3, 70, "ExampleDelimiter",
 CellID->73404585],
Cell[66072, 1592, 81, 1, 70, "ExampleText",
 CellID->5392742],
Cell[CellGroupData[{
Cell[66178, 1597, 540, 16, 70, "Input",
 CellID->747103243],
Cell[66721, 1615, 3181, 56, 70, "Output",
 Evaluatable->False,
 CellID->677507713]
}, Open  ]],
Cell[69917, 1674, 125, 3, 70, "ExampleDelimiter",
 CellID->537694265],
Cell[70045, 1679, 272, 8, 70, "ExampleText",
 CellID->232700368],
Cell[CellGroupData[{
Cell[70342, 1691, 841, 24, 70, "Input",
 CellID->80169133],
Cell[71186, 1717, 2692, 48, 70, "Output",
 Evaluatable->False,
 CellID->304061931]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[73939, 1772, 239, 7, 70, "ExampleSection",
 CellID->19211],
Cell[74181, 1781, 345, 13, 70, "ExampleText",
 CellID->814353806],
Cell[74529, 1796, 748, 24, 70, "Input",
 CellID->22894193],
Cell[CellGroupData[{
Cell[75302, 1824, 330, 10, 70, "Input",
 CellID->545912847],
Cell[75635, 1836, 2200, 56, 201, "Output",
 CellID->728302907]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[77884, 1898, 232, 7, 70, "ExampleSection",
 CellID->5163],
Cell[78119, 1907, 234, 7, 70, "ExampleText",
 CellID->242285675],
Cell[CellGroupData[{
Cell[78378, 1918, 540, 16, 70, "Input",
 CellID->404749038],
Cell[78921, 1936, 3120, 55, 70, "Output",
 Evaluatable->False,
 CellID->217641201]
}, Open  ]],
Cell[82056, 1994, 125, 3, 70, "ExampleDelimiter",
 CellID->172046868],
Cell[82184, 1999, 265, 8, 70, "ExampleText",
 CellID->287688071],
Cell[CellGroupData[{
Cell[82474, 2011, 658, 20, 70, "Input",
 CellID->852841955],
Cell[83135, 2033, 3115, 55, 70, "Output",
 Evaluatable->False,
 CellID->49379387]
}, Open  ]],
Cell[86265, 2091, 374, 12, 70, "ExampleText",
 CellID->16302533],
Cell[CellGroupData[{
Cell[86664, 2107, 717, 21, 70, "Input",
 CellID->610817034],
Cell[87384, 2130, 3184, 56, 70, "Output",
 Evaluatable->False,
 CellID->86410236]
}, Open  ]],
Cell[90583, 2189, 125, 3, 70, "ExampleDelimiter",
 CellID->468017888],
Cell[90711, 2194, 262, 8, 70, "ExampleText",
 CellID->2867181],
Cell[CellGroupData[{
Cell[90998, 2206, 638, 19, 70, "Input",
 CellID->82910697],
Cell[91639, 2227, 3104, 55, 70, "Output",
 Evaluatable->False,
 CellID->397629634]
}, Open  ]],
Cell[94758, 2285, 371, 12, 70, "ExampleText",
 CellID->271652939],
Cell[CellGroupData[{
Cell[95154, 2301, 697, 20, 70, "Input",
 CellID->131785817],
Cell[95854, 2323, 3189, 56, 70, "Output",
 Evaluatable->False,
 CellID->235521623]
}, Open  ]],
Cell[99058, 2382, 124, 3, 70, "ExampleDelimiter",
 CellID->11991344],
Cell[99185, 2387, 140, 4, 70, "ExampleText",
 CellID->145936691],
Cell[CellGroupData[{
Cell[99350, 2395, 961, 27, 70, "Input",
 CellID->69778533],
Cell[100314, 2424, 2748, 49, 70, "Output",
 Evaluatable->False,
 CellID->82318519]
}, Open  ]],
Cell[103077, 2476, 124, 3, 70, "ExampleDelimiter",
 CellID->79769809],
Cell[103204, 2481, 218, 7, 70, "ExampleText",
 CellID->19748360],
Cell[CellGroupData[{
Cell[103447, 2492, 244, 7, 70, "Input",
 CellID->155246595],
Cell[103694, 2501, 275, 9, 167, "Output",
 CellID->156314720]
}, Open  ]],
Cell[103984, 2513, 125, 3, 70, "ExampleDelimiter",
 CellID->173024789],
Cell[104112, 2518, 248, 8, 70, "ExampleText",
 CellID->182480779],
Cell[CellGroupData[{
Cell[104385, 2530, 204, 6, 70, "Input",
 CellID->180372752],
Cell[104592, 2538, 5877, 100, 70, "Output",
 Evaluatable->False,
 CellID->235445876]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[110530, 2645, 311, 9, 70, "SeeAlsoSection",
 CellID->11783],
Cell[110844, 2656, 1689, 62, 70, "SeeAlso",
 CellID->4886]
}, Open  ]],
Cell[CellGroupData[{
Cell[112570, 2723, 313, 9, 70, "TutorialsSection",
 CellID->5832],
Cell[112886, 2734, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[113027, 2739, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[113221, 2747, 305, 8, 70, "RelatedLinksSection"],
Cell[113529, 2757, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113931, 2774, 319, 9, 70, "MoreAboutSection",
 CellID->326074885],
Cell[114253, 2785, 174, 3, 70, "MoreAbout",
 CellID->24063051]
}, Open  ]],
Cell[114442, 2791, 50, 0, 70, "History"],
Cell[114495, 2793, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

