(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23136,        859]
NotebookOptionsPosition[     18243,        694]
NotebookOutlinePosition[     19667,        733]
CellTagsIndexPosition[     19582,        728]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing and Searching List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TestingAndSearchingListElements"], 
          "Manipulating Expressions like Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsLikeLists"], 
          "Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Testing and Searching List Elements\"\>", 
       2->"\<\"Manipulating Expressions like Lists\"\>", 
       3->"\<\"Putting Constraints on Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MemberQ" :> Documentation`HelpLookup["paclet:ref/MemberQ"], 
          "Count" :> Documentation`HelpLookup["paclet:ref/Count"], 
          "StringFreeQ" :> 
          Documentation`HelpLookup["paclet:ref/StringFreeQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MemberQ\"\>", 2->"\<\"Count\"\>", 
       3->"\<\"StringFreeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Pattern Matching Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/PatternMatchingFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Elements of Lists\"\>", 2->"\<\"Expressions\"\>",
        3->"\<\"Pattern Matching Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FreeQ", "ObjectName",
 CellID->29014],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FreeQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if no subexpression in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " matches ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ", and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FreeQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]tests only those parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on levels specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16931]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " can be a pattern. "
}], "Notes",
 CellID->7668],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->27397],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->16563],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", " ", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11700],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->28286],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24299],

Cell[TextData[{
 "Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " consists of numbers, symbols and other objects that do not have subparts."
}], "Notes",
 CellID->22199],

Cell[TextData[{
 "Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to the whole expression."
}], "Notes",
 CellID->12233],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 " looks at heads of expressions, and their parts."
}], "Notes",
 CellID->20513]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->920943666],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->602468840],

Cell[TextData[{
 "Test whether a list is free of ",
 Cell[BoxData["0"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->351390115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "1", ",", "0"}], "}"}], ",", "0"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22393053],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226291910]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64581134],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 " normally tests all levels in an expression:"
}], "ExampleText",
 CellID->821807285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", "0"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286662446],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->569789336]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7804],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 " works with patterns:"
}], "ExampleText",
 CellID->57779118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b", ",", "a", ",", "a", ",", "a"}], "}"}], 
   ",", "_Integer"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205371076],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85850325]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"y", "^", "3"}], ",", 
     RowBox[{"x", "^", "5"}], ",", 
     RowBox[{"x", "^", "6"}]}], "}"}], ",", 
   RowBox[{"y", "^", "_"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->196490588],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->422864959]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->352454362]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26034],

Cell["\<\
Define a function that factors out \[OpenCurlyDoubleQuote]constants\
\[CloseCurlyDoubleQuote]:\
\>", "ExampleText",
 CellID->477623650],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"c_", " ", "x_"}], ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"c", " ", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "x"}], "]"}]}], "/;", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"c", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196411464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"3", "x"}], ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"a", " ", "x"}], ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], "x"}], ",", "x"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72687458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", " ", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "x"}], "]"}]}], ",", 
   RowBox[{"a", " ", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "x"}], "]"}]}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}], ",", "x"}], "]"}]}], "}"}]], "Output",\

 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208621856]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243609972],

Cell["Test which integrals are free of logarithms:", "ExampleText",
 CellID->299885352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"x", "^", "n"}], ",", "x"}], "]"}], ",", "Log"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8699620],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "False", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{445, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192456593]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15173],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Count",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Count"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringFreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringFreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15758]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26019],

Cell[TextData[ButtonBox["Testing and Searching List Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TestingAndSearchingListElements"]], "Tutorials",\

 CellID->5613],

Cell[TextData[ButtonBox["Manipulating Expressions like Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingExpressionsLikeLists"]], "Tutorials",\

 CellID->30028],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->32360]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->33889318],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->134446772],

Cell[TextData[ButtonBox["Pattern Matching Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PatternMatchingFunctions"]], "MoreAbout",
 CellID->75452013]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FreeQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 25.3612534}", "context" -> "System`", 
    "keywords" -> {
     "absent from expression", "absent from list", "independence", 
      "independent from", "free of"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FreeQ[expr, form] yields True if no subexpression in expr matches form, \
and yields False otherwise. FreeQ[expr, form, levelspec] tests only those \
parts of expr on levels specified by levelspec. ", "synonyms" -> {"free q"}, 
    "title" -> "FreeQ", "type" -> "Symbol", "uri" -> "ref/FreeQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9316, 324, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->920943666]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19439, 721}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2672, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3295, 89, 43, 1, 70, "ObjectName",
 CellID->29014],
Cell[3341, 92, 1555, 51, 70, "Usage",
 CellID->16931]
}, Open  ]],
Cell[CellGroupData[{
Cell[4933, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5411, 165, 126, 5, 70, "Notes",
 CellID->7668],
Cell[5540, 172, 197, 7, 70, "Notes",
 CellID->27397],
Cell[5740, 181, 1664, 55, 70, "2ColumnTableMod",
 CellID->16563],
Cell[7407, 238, 450, 18, 70, "Notes",
 CellID->11700],
Cell[7860, 258, 303, 12, 70, "Notes",
 CellID->28286],
Cell[8166, 272, 312, 13, 70, "Notes",
 CellID->24299],
Cell[8481, 287, 189, 6, 70, "Notes",
 CellID->22199],
Cell[8673, 295, 134, 5, 70, "Notes",
 CellID->12233],
Cell[8810, 302, 469, 17, 70, "Notes",
 CellID->20513]
}, Closed]],
Cell[CellGroupData[{
Cell[9316, 324, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->920943666],
Cell[CellGroupData[{
Cell[9701, 338, 148, 5, 70, "ExampleSection",
 CellID->602468840],
Cell[9852, 345, 133, 5, 70, "ExampleText",
 CellID->351390115],
Cell[CellGroupData[{
Cell[10010, 354, 205, 7, 28, "Input",
 CellID->22393053],
Cell[10218, 363, 162, 5, 36, "Output",
 CellID->226291910]
}, Open  ]],
Cell[10395, 371, 124, 3, 70, "ExampleDelimiter",
 CellID->64581134],
Cell[10522, 376, 215, 7, 70, "ExampleText",
 CellID->821807285],
Cell[CellGroupData[{
Cell[10762, 387, 322, 11, 70, "Input",
 CellID->286662446],
Cell[11087, 400, 162, 5, 36, "Output",
 CellID->569789336]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11298, 411, 215, 7, 70, "ExampleSection",
 CellID->7804],
Cell[11516, 420, 191, 7, 70, "ExampleText",
 CellID->57779118],
Cell[CellGroupData[{
Cell[11732, 431, 224, 7, 70, "Input",
 CellID->205371076],
Cell[11959, 440, 160, 5, 36, "Output",
 CellID->85850325]
}, Open  ]],
Cell[CellGroupData[{
Cell[12156, 450, 321, 11, 70, "Input",
 CellID->196490588],
Cell[12480, 463, 162, 5, 36, "Output",
 CellID->422864959]
}, Open  ]],
Cell[12657, 471, 125, 3, 70, "ExampleDelimiter",
 CellID->352454362]
}, Closed]],
Cell[CellGroupData[{
Cell[12819, 479, 223, 7, 70, "ExampleSection",
 CellID->26034],
Cell[13045, 488, 145, 4, 70, "ExampleText",
 CellID->477623650],
Cell[13193, 494, 335, 12, 70, "Input",
 CellID->196411464],
Cell[CellGroupData[{
Cell[13553, 510, 412, 16, 70, "Input",
 CellID->72687458],
Cell[13968, 528, 511, 19, 36, "Output",
 CellID->208621856]
}, Open  ]],
Cell[14494, 550, 125, 3, 70, "ExampleDelimiter",
 CellID->243609972],
Cell[14622, 555, 87, 1, 70, "ExampleText",
 CellID->299885352],
Cell[CellGroupData[{
Cell[14734, 560, 356, 12, 70, "Input",
 CellID->8699620],
Cell[15093, 574, 338, 10, 36, "Output",
 CellID->192456593]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15492, 591, 311, 9, 70, "SeeAlsoSection",
 CellID->15173],
Cell[15806, 602, 694, 26, 70, "SeeAlso",
 CellID->15758]
}, Open  ]],
Cell[CellGroupData[{
Cell[16537, 633, 314, 9, 70, "TutorialsSection",
 CellID->26019],
Cell[16854, 644, 178, 4, 70, "Tutorials",
 CellID->5613],
Cell[17035, 650, 180, 4, 70, "Tutorials",
 CellID->30028],
Cell[17218, 656, 170, 3, 70, "Tutorials",
 CellID->32360]
}, Open  ]],
Cell[CellGroupData[{
Cell[17425, 664, 299, 8, 70, "MoreAboutSection"],
Cell[17727, 674, 143, 3, 70, "MoreAbout",
 CellID->33889318],
Cell[17873, 679, 134, 3, 70, "MoreAbout",
 CellID->134446772],
Cell[18010, 684, 161, 3, 70, "MoreAbout",
 CellID->75452013]
}, Open  ]],
Cell[18186, 690, 27, 0, 70, "History"],
Cell[18216, 692, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

